/*
 * ORY Keto
 *
 * Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.
 *
 * The version of the OpenAPI document: v0.0.0-alpha.58
 * Contact: hi@ory.sh
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};


/// struct for typed errors of method `add_ory_access_control_policy_role_members`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddOryAccessControlPolicyRoleMembersError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `delete_ory_access_control_policy`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteOryAccessControlPolicyError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `delete_ory_access_control_policy_role`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteOryAccessControlPolicyRoleError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `do_ory_access_control_policies_allow`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DoOryAccessControlPoliciesAllowError {
    Status403(crate::models::AuthorizationResult),
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_ory_access_control_policy`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetOryAccessControlPolicyError {
    Status404(crate::models::InlineResponse500),
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_ory_access_control_policy_role`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetOryAccessControlPolicyRoleError {
    Status404(crate::models::InlineResponse500),
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `list_ory_access_control_policies`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListOryAccessControlPoliciesError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `list_ory_access_control_policy_roles`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListOryAccessControlPolicyRolesError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `remove_ory_access_control_policy_role_members`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveOryAccessControlPolicyRoleMembersError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `upsert_ory_access_control_policy`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpsertOryAccessControlPolicyError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `upsert_ory_access_control_policy_role`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpsertOryAccessControlPolicyRoleError {
    Status500(crate::models::InlineResponse500),
    UnknownValue(serde_json::Value),
}


/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn add_ory_access_control_policy_role_members(configuration: &configuration::Configuration, flavor: &str, id: &str, body: Option<crate::models::AddOryAccessControlPolicyRoleMembersBody>) -> Result<crate::models::OryAccessControlPolicyRole, Error<AddOryAccessControlPolicyRoleMembersError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles/{id}/members", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.put(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddOryAccessControlPolicyRoleMembersError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete an ORY Access Control Policy
pub async fn delete_ory_access_control_policy(configuration: &configuration::Configuration, flavor: &str, id: &str) -> Result<(), Error<DeleteOryAccessControlPolicyError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/policies/{id}", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.delete(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        Ok(())
    } else {
        let local_var_entity: Option<DeleteOryAccessControlPolicyError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn delete_ory_access_control_policy_role(configuration: &configuration::Configuration, flavor: &str, id: &str) -> Result<(), Error<DeleteOryAccessControlPolicyRoleError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles/{id}", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.delete(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        Ok(())
    } else {
        let local_var_entity: Option<DeleteOryAccessControlPolicyRoleError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Use this endpoint to check if a request is allowed or not. If the request is allowed, a 200 response with `{\"allowed\":\"true\"}` will be sent. If the request is denied, a 403 response with `{\"allowed\":\"false\"}` will be sent instead.
pub async fn do_ory_access_control_policies_allow(configuration: &configuration::Configuration, flavor: &str, body: Option<crate::models::OryAccessControlPolicyAllowedInput>) -> Result<crate::models::AuthorizationResult, Error<DoOryAccessControlPoliciesAllowError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/allowed", configuration.base_path, flavor=crate::apis::urlencode(flavor));
    let mut local_var_req_builder = local_var_client.post(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<DoOryAccessControlPoliciesAllowError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Get an ORY Access Control Policy
pub async fn get_ory_access_control_policy(configuration: &configuration::Configuration, flavor: &str, id: &str) -> Result<crate::models::OryAccessControlPolicy, Error<GetOryAccessControlPolicyError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/policies/{id}", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetOryAccessControlPolicyError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn get_ory_access_control_policy_role(configuration: &configuration::Configuration, flavor: &str, id: &str) -> Result<crate::models::OryAccessControlPolicyRole, Error<GetOryAccessControlPolicyRoleError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles/{id}", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetOryAccessControlPolicyRoleError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// List ORY Access Control Policies
pub async fn list_ory_access_control_policies(configuration: &configuration::Configuration, flavor: &str, limit: Option<i64>, offset: Option<i64>, subject: Option<&str>, resource: Option<&str>, action: Option<&str>) -> Result<Vec<crate::models::OryAccessControlPolicy>, Error<ListOryAccessControlPoliciesError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/policies", configuration.base_path, flavor=crate::apis::urlencode(flavor));
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = limit {
        local_var_req_builder = local_var_req_builder.query(&[("limit", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = offset {
        local_var_req_builder = local_var_req_builder.query(&[("offset", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = subject {
        local_var_req_builder = local_var_req_builder.query(&[("subject", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = resource {
        local_var_req_builder = local_var_req_builder.query(&[("resource", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = action {
        local_var_req_builder = local_var_req_builder.query(&[("action", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ListOryAccessControlPoliciesError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn list_ory_access_control_policy_roles(configuration: &configuration::Configuration, flavor: &str, limit: Option<i64>, offset: Option<i64>, member: Option<&str>) -> Result<Vec<crate::models::OryAccessControlPolicyRole>, Error<ListOryAccessControlPolicyRolesError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles", configuration.base_path, flavor=crate::apis::urlencode(flavor));
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = limit {
        local_var_req_builder = local_var_req_builder.query(&[("limit", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = offset {
        local_var_req_builder = local_var_req_builder.query(&[("offset", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = member {
        local_var_req_builder = local_var_req_builder.query(&[("member", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ListOryAccessControlPolicyRolesError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn remove_ory_access_control_policy_role_members(configuration: &configuration::Configuration, flavor: &str, id: &str, member: &str) -> Result<(), Error<RemoveOryAccessControlPolicyRoleMembersError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles/{id}/members/{member}", configuration.base_path, flavor=crate::apis::urlencode(flavor), id=crate::apis::urlencode(id), member=crate::apis::urlencode(member));
    let mut local_var_req_builder = local_var_client.delete(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        Ok(())
    } else {
        let local_var_entity: Option<RemoveOryAccessControlPolicyRoleMembersError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Upsert an ORY Access Control Policy
pub async fn upsert_ory_access_control_policy(configuration: &configuration::Configuration, flavor: &str, body: Option<crate::models::OryAccessControlPolicy>) -> Result<crate::models::OryAccessControlPolicy, Error<UpsertOryAccessControlPolicyError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/policies", configuration.base_path, flavor=crate::apis::urlencode(flavor));
    let mut local_var_req_builder = local_var_client.put(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<UpsertOryAccessControlPolicyError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.
pub async fn upsert_ory_access_control_policy_role(configuration: &configuration::Configuration, flavor: &str, body: Option<crate::models::OryAccessControlPolicyRole>) -> Result<crate::models::OryAccessControlPolicyRole, Error<UpsertOryAccessControlPolicyRoleError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/engines/acp/ory/{flavor}/roles", configuration.base_path, flavor=crate::apis::urlencode(flavor));
    let mut local_var_req_builder = local_var_client.put(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if local_var_status.is_success() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<UpsertOryAccessControlPolicyRoleError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

