/*
 * Ory Hydra API
 *
 * Documentation for all of Ory Hydra's APIs. 
 *
 * The version of the OpenAPI document: v1.11.8
 * Contact: hi@ory.sh
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrustJwtGrantIssuerBody {
    /// The \"allow_any_subject\" indicates that the issuer is allowed to have any principal as the subject of the JWT.
    #[serde(rename = "allow_any_subject", skip_serializing_if = "Option::is_none")]
    pub allow_any_subject: Option<bool>,
    /// The \"expires_at\" indicates, when grant will expire, so we will reject assertion from \"issuer\" targeting \"subject\".
    #[serde(rename = "expires_at")]
    pub expires_at: String,
    /// The \"issuer\" identifies the principal that issued the JWT assertion (same as \"iss\" claim in JWT).
    #[serde(rename = "issuer")]
    pub issuer: String,
    #[serde(rename = "jwk")]
    pub jwk: Box<crate::models::JsonWebKey>,
    /// The \"scope\" contains list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749])
    #[serde(rename = "scope")]
    pub scope: Vec<String>,
    /// The \"subject\" identifies the principal that is the subject of the JWT.
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
}

impl TrustJwtGrantIssuerBody {
    pub fn new(expires_at: String, issuer: String, jwk: crate::models::JsonWebKey, scope: Vec<String>) -> TrustJwtGrantIssuerBody {
        TrustJwtGrantIssuerBody {
            allow_any_subject: None,
            expires_at,
            issuer,
            jwk: Box::new(jwk),
            scope,
            subject: None,
        }
    }
}


