/*
 * Ory Oathkeeper API
 *
 * Documentation for all of Ory Oathkeeper's APIs. 
 *
 * The version of the OpenAPI document: v1.11.6
 * Contact: hi@ory.sh
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrustJwtGrantIssuerBody {
    /// The \"expires_at\" indicates, when grant will expire, so we will reject assertion from \"issuer\" targeting \"subject\".
    #[serde(rename = "expires_at")]
    pub expires_at: String,
    /// The \"issuer\" identifies the principal that issued the JWT assertion (same as \"iss\" claim in JWT).
    #[serde(rename = "issuer")]
    pub issuer: String,
    #[serde(rename = "jwk")]
    pub jwk: Box<crate::models::JsonWebKey>,
    /// The \"scope\" contains list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749])
    #[serde(rename = "scope")]
    pub scope: Vec<String>,
    /// The \"subject\" identifies the principal that is the subject of the JWT.
    #[serde(rename = "subject")]
    pub subject: String,
}

impl TrustJwtGrantIssuerBody {
    pub fn new(expires_at: String, issuer: String, jwk: crate::models::JsonWebKey, scope: Vec<String>, subject: String) -> TrustJwtGrantIssuerBody {
        TrustJwtGrantIssuerBody {
            expires_at,
            issuer,
            jwk: Box::new(jwk),
            scope,
            subject,
        }
    }
}


