/*
 * Ory Oathkeeper API
 *
 * Documentation for all of Ory Oathkeeper's APIs. 
 *
 * The version of the OpenAPI document: v1.11.5
 * Contact: hi@ory.sh
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsentRequestSession {
    /// AccessToken sets session data for the access and refresh token, as well as any future tokens issued by the refresh grant. Keep in mind that this data will be available to anyone performing OAuth 2.0 Challenge Introspection. If only your services can perform OAuth 2.0 Challenge Introspection, this is usually fine. But if third parties can access that endpoint as well, sensitive data from the session might be exposed to them. Use with care!
    #[serde(rename = "access_token", skip_serializing_if = "Option::is_none")]
    pub access_token: Option<::std::collections::HashMap<String, serde_json::Value>>,
    /// IDToken sets session data for the OpenID Connect ID token. Keep in mind that the session'id payloads are readable by anyone that has access to the ID Challenge. Use with care!
    #[serde(rename = "id_token", skip_serializing_if = "Option::is_none")]
    pub id_token: Option<::std::collections::HashMap<String, serde_json::Value>>,
}

impl ConsentRequestSession {
    pub fn new() -> ConsentRequestSession {
        ConsentRequestSession {
            access_token: None,
            id_token: None,
        }
    }
}


