# Rust API client for ory-client

Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed
with a valid Personal Access Token. Public APIs are mostly used in browsers.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v0.0.1-alpha.14
- Package version: v0.0.1-alpha.14
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://playground.projects.oryapis.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_identity_admin**](docs/DefaultApi.md#create_identity_admin) | **post** /api/kratos/admin/identities | Create an Identity
*DefaultApi* | [**create_recovery_link_admin**](docs/DefaultApi.md#create_recovery_link_admin) | **post** /api/kratos/admin/recovery/link | Create a Recovery Link
*DefaultApi* | [**delete_identity_admin**](docs/DefaultApi.md#delete_identity_admin) | **delete** /api/kratos/admin/identities/{id} | Delete an Identity
*DefaultApi* | [**get_identity_admin**](docs/DefaultApi.md#get_identity_admin) | **get** /api/kratos/admin/identities/{id} | Get an Identity
*DefaultApi* | [**get_schema**](docs/DefaultApi.md#get_schema) | **get** /api/kratos/public/schemas/{id} | 
*DefaultApi* | [**get_schema_admin**](docs/DefaultApi.md#get_schema_admin) | **get** /api/kratos/admin/schemas/{id} | 
*DefaultApi* | [**get_self_service_error**](docs/DefaultApi.md#get_self_service_error) | **get** /api/kratos/public/self-service/errors | Get User-Facing Self-Service Errors
*DefaultApi* | [**get_self_service_error_admin**](docs/DefaultApi.md#get_self_service_error_admin) | **get** /api/kratos/admin/self-service/errors | Get User-Facing Self-Service Errors
*DefaultApi* | [**get_self_service_login_flow**](docs/DefaultApi.md#get_self_service_login_flow) | **get** /api/kratos/public/self-service/login/flows | Get Login Flow
*DefaultApi* | [**get_self_service_login_flow_admin**](docs/DefaultApi.md#get_self_service_login_flow_admin) | **get** /api/kratos/admin/self-service/login/flows | Get Login Flow
*DefaultApi* | [**get_self_service_recovery_flow**](docs/DefaultApi.md#get_self_service_recovery_flow) | **get** /api/kratos/public/self-service/recovery/flows | Get information about a recovery flow
*DefaultApi* | [**get_self_service_recovery_flow_admin**](docs/DefaultApi.md#get_self_service_recovery_flow_admin) | **get** /api/kratos/admin/self-service/recovery/flows | Get information about a recovery flow
*DefaultApi* | [**get_self_service_registration_flow**](docs/DefaultApi.md#get_self_service_registration_flow) | **get** /api/kratos/public/self-service/registration/flows | Get Registration Flow
*DefaultApi* | [**get_self_service_registration_flow_admin**](docs/DefaultApi.md#get_self_service_registration_flow_admin) | **get** /api/kratos/admin/self-service/registration/flows | Get Registration Flow
*DefaultApi* | [**get_self_service_settings_flow**](docs/DefaultApi.md#get_self_service_settings_flow) | **get** /api/kratos/public/self-service/settings/flows | Get Settings Flow
*DefaultApi* | [**get_self_service_settings_flow_admin**](docs/DefaultApi.md#get_self_service_settings_flow_admin) | **get** /api/kratos/admin/self-service/settings/flows | Get Settings Flow
*DefaultApi* | [**get_self_service_verification_flow**](docs/DefaultApi.md#get_self_service_verification_flow) | **get** /api/kratos/public/self-service/verification/flows | Get Verification Flow
*DefaultApi* | [**get_self_service_verification_flow_admin**](docs/DefaultApi.md#get_self_service_verification_flow_admin) | **get** /api/kratos/admin/self-service/verification/flows | Get Verification Flow
*DefaultApi* | [**get_version_admin**](docs/DefaultApi.md#get_version_admin) | **get** /api/kratos/admin/version | Return Running Software Version.
*DefaultApi* | [**initialize_self_service_browser_logout_flow**](docs/DefaultApi.md#initialize_self_service_browser_logout_flow) | **get** /api/kratos/public/self-service/browser/flows/logout | Initialize Browser-Based Logout User Flow
*DefaultApi* | [**initialize_self_service_login_for_browsers**](docs/DefaultApi.md#initialize_self_service_login_for_browsers) | **get** /api/kratos/public/self-service/login/browser | Initialize Login Flow for Browsers
*DefaultApi* | [**initialize_self_service_login_without_browser**](docs/DefaultApi.md#initialize_self_service_login_without_browser) | **get** /api/kratos/public/self-service/login/api | Initialize Login Flow for APIs, Services, Apps, ...
*DefaultApi* | [**initialize_self_service_recovery_for_browsers**](docs/DefaultApi.md#initialize_self_service_recovery_for_browsers) | **get** /api/kratos/public/self-service/recovery/browser | Initialize Recovery Flow for Browser Clients
*DefaultApi* | [**initialize_self_service_recovery_for_native_apps**](docs/DefaultApi.md#initialize_self_service_recovery_for_native_apps) | **get** /api/kratos/public/self-service/recovery/api | Initialize Recovery Flow for Native Apps and API clients
*DefaultApi* | [**initialize_self_service_registration_for_browsers**](docs/DefaultApi.md#initialize_self_service_registration_for_browsers) | **get** /api/kratos/public/self-service/registration/browser | Initialize Registration Flow for Browsers
*DefaultApi* | [**initialize_self_service_registration_without_browser**](docs/DefaultApi.md#initialize_self_service_registration_without_browser) | **get** /api/kratos/public/self-service/registration/api | Initialize Registration Flow for APIs, Services, Apps, ...
*DefaultApi* | [**initialize_self_service_settings_for_browsers**](docs/DefaultApi.md#initialize_self_service_settings_for_browsers) | **get** /api/kratos/public/self-service/settings/browser | Initialize Settings Flow for Browsers
*DefaultApi* | [**initialize_self_service_settings_for_native_apps**](docs/DefaultApi.md#initialize_self_service_settings_for_native_apps) | **get** /api/kratos/public/self-service/settings/api | Initialize Settings Flow for Native Apps and API clients
*DefaultApi* | [**initialize_self_service_verification_for_browsers**](docs/DefaultApi.md#initialize_self_service_verification_for_browsers) | **get** /api/kratos/public/self-service/verification/browser | Initialize Verification Flow for Browser Clients
*DefaultApi* | [**initialize_self_service_verification_for_native_apps**](docs/DefaultApi.md#initialize_self_service_verification_for_native_apps) | **get** /api/kratos/public/self-service/verification/api | Initialize Verification Flow for Native Apps and API clients
*DefaultApi* | [**is_alive_admin**](docs/DefaultApi.md#is_alive_admin) | **get** /api/kratos/admin/health/alive | Check HTTP Server Status
*DefaultApi* | [**is_ready_admin**](docs/DefaultApi.md#is_ready_admin) | **get** /api/kratos/admin/health/ready | Check HTTP Server and Database Status
*DefaultApi* | [**list_identities_admin**](docs/DefaultApi.md#list_identities_admin) | **get** /api/kratos/admin/identities | List Identities
*DefaultApi* | [**prometheus_admin**](docs/DefaultApi.md#prometheus_admin) | **get** /api/kratos/admin/metrics/prometheus | Get snapshot metrics from the Hydra service. If you're using k8s, you can then add annotations to your deployment like so:
*DefaultApi* | [**revoke_session**](docs/DefaultApi.md#revoke_session) | **delete** /api/kratos/public/sessions | Initialize Logout Flow for API Clients - Revoke a Session
*DefaultApi* | [**submit_self_service_login_flow**](docs/DefaultApi.md#submit_self_service_login_flow) | **post** /api/kratos/public/self-service/login | Submit a Login Flow
*DefaultApi* | [**submit_self_service_recovery_flow**](docs/DefaultApi.md#submit_self_service_recovery_flow) | **post** /api/kratos/public/self-service/recovery | Complete Recovery Flow
*DefaultApi* | [**submit_self_service_recovery_flow_with_link_method**](docs/DefaultApi.md#submit_self_service_recovery_flow_with_link_method) | **post** /api/kratos/public/self-service/recovery/methods/link | Complete Recovery Flow with Link Method
*DefaultApi* | [**submit_self_service_registration_flow**](docs/DefaultApi.md#submit_self_service_registration_flow) | **post** /api/kratos/public/self-service/registration | Submit a Registration Flow
*DefaultApi* | [**submit_self_service_settings_flow**](docs/DefaultApi.md#submit_self_service_settings_flow) | **post** /api/kratos/public/self-service/settings | Complete Settings Flow
*DefaultApi* | [**submit_self_service_verification_flow**](docs/DefaultApi.md#submit_self_service_verification_flow) | **post** /api/kratos/public/self-service/verification/flows | Complete Verification Flow
*DefaultApi* | [**to_session**](docs/DefaultApi.md#to_session) | **get** /api/kratos/public/sessions/whoami | Check Who the Current HTTP Session Belongs To
*DefaultApi* | [**update_identity_admin**](docs/DefaultApi.md#update_identity_admin) | **put** /api/kratos/admin/identities/{id} | Update an Identity


## Documentation For Models

 - [AuthenticateOkBody](docs/AuthenticateOkBody.md)
 - [ContainerChangeResponseItem](docs/ContainerChangeResponseItem.md)
 - [ContainerCreateCreatedBody](docs/ContainerCreateCreatedBody.md)
 - [ContainerTopOkBody](docs/ContainerTopOkBody.md)
 - [ContainerUpdateOkBody](docs/ContainerUpdateOkBody.md)
 - [ContainerWaitOkBody](docs/ContainerWaitOkBody.md)
 - [ContainerWaitOkBodyError](docs/ContainerWaitOkBodyError.md)
 - [CreateIdentity](docs/CreateIdentity.md)
 - [CreateRecoveryLink](docs/CreateRecoveryLink.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [GenericError](docs/GenericError.md)
 - [GraphDriverData](docs/GraphDriverData.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [IdResponse](docs/IdResponse.md)
 - [Identity](docs/Identity.md)
 - [IdentityCredentials](docs/IdentityCredentials.md)
 - [ImageDeleteResponseItem](docs/ImageDeleteResponseItem.md)
 - [ImageSummary](docs/ImageSummary.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [JsonError](docs/JsonError.md)
 - [LoginFlow](docs/LoginFlow.md)
 - [LoginViaApiResponse](docs/LoginViaApiResponse.md)
 - [Meta](docs/Meta.md)
 - [Plugin](docs/Plugin.md)
 - [PluginConfig](docs/PluginConfig.md)
 - [PluginConfigArgs](docs/PluginConfigArgs.md)
 - [PluginConfigInterface](docs/PluginConfigInterface.md)
 - [PluginConfigLinux](docs/PluginConfigLinux.md)
 - [PluginConfigNetwork](docs/PluginConfigNetwork.md)
 - [PluginConfigRootfs](docs/PluginConfigRootfs.md)
 - [PluginConfigUser](docs/PluginConfigUser.md)
 - [PluginDevice](docs/PluginDevice.md)
 - [PluginEnv](docs/PluginEnv.md)
 - [PluginInterfaceType](docs/PluginInterfaceType.md)
 - [PluginMount](docs/PluginMount.md)
 - [PluginSettings](docs/PluginSettings.md)
 - [Port](docs/Port.md)
 - [RecoveryAddress](docs/RecoveryAddress.md)
 - [RecoveryFlow](docs/RecoveryFlow.md)
 - [RecoveryLink](docs/RecoveryLink.md)
 - [RegistrationFlow](docs/RegistrationFlow.md)
 - [RegistrationViaApiResponse](docs/RegistrationViaApiResponse.md)
 - [RevokeSession](docs/RevokeSession.md)
 - [SelfServiceErrorContainer](docs/SelfServiceErrorContainer.md)
 - [ServiceUpdateResponse](docs/ServiceUpdateResponse.md)
 - [Session](docs/Session.md)
 - [SettingsFlow](docs/SettingsFlow.md)
 - [SettingsProfileFormConfig](docs/SettingsProfileFormConfig.md)
 - [SettingsViaApiResponse](docs/SettingsViaApiResponse.md)
 - [SubmitSelfServiceBrowserSettingsOidcFlowPayload](docs/SubmitSelfServiceBrowserSettingsOidcFlowPayload.md)
 - [SubmitSelfServiceLoginFlow](docs/SubmitSelfServiceLoginFlow.md)
 - [SubmitSelfServiceLoginFlowWithPasswordMethod](docs/SubmitSelfServiceLoginFlowWithPasswordMethod.md)
 - [SubmitSelfServiceRecoveryFlowWithLinkMethod](docs/SubmitSelfServiceRecoveryFlowWithLinkMethod.md)
 - [SubmitSelfServiceRegistrationFlow](docs/SubmitSelfServiceRegistrationFlow.md)
 - [SubmitSelfServiceRegistrationFlowWithPasswordMethod](docs/SubmitSelfServiceRegistrationFlowWithPasswordMethod.md)
 - [SubmitSelfServiceSettingsFlow](docs/SubmitSelfServiceSettingsFlow.md)
 - [SubmitSelfServiceSettingsFlowWithPasswordMethod](docs/SubmitSelfServiceSettingsFlowWithPasswordMethod.md)
 - [SubmitSelfServiceSettingsFlowWithProfileMethod](docs/SubmitSelfServiceSettingsFlowWithProfileMethod.md)
 - [SubmitSelfServiceVerificationFlowWithLinkMethod](docs/SubmitSelfServiceVerificationFlowWithLinkMethod.md)
 - [UiContainer](docs/UiContainer.md)
 - [UiNode](docs/UiNode.md)
 - [UiNodeAnchorAttributes](docs/UiNodeAnchorAttributes.md)
 - [UiNodeAttributes](docs/UiNodeAttributes.md)
 - [UiNodeImageAttributes](docs/UiNodeImageAttributes.md)
 - [UiNodeInputAttributes](docs/UiNodeInputAttributes.md)
 - [UiNodeTextAttributes](docs/UiNodeTextAttributes.md)
 - [UiText](docs/UiText.md)
 - [UpdateIdentity](docs/UpdateIdentity.md)
 - [VerifiableIdentityAddress](docs/VerifiableIdentityAddress.md)
 - [VerificationFlow](docs/VerificationFlow.md)
 - [Version](docs/Version.md)
 - [Volume](docs/Volume.md)
 - [VolumeUsageData](docs/VolumeUsageData.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

support@ory.sh

