/*
 * Ory APIs
 *
 * Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers. 
 *
 * The version of the OpenAPI document: v0.0.1-alpha.10
 * Contact: support@ory.sh
 * Generated by: https://openapi-generator.tech
 */

/// Port : Port An open port on a container



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Port {
    /// IP
    #[serde(rename = "IP", skip_serializing_if = "Option::is_none")]
    pub IP: Option<String>,
    /// Port on the container
    #[serde(rename = "PrivatePort")]
    pub private_port: i32,
    /// Port exposed on the host
    #[serde(rename = "PublicPort", skip_serializing_if = "Option::is_none")]
    pub public_port: Option<i32>,
    /// type
    #[serde(rename = "Type")]
    pub _type: String,
}

impl Port {
    /// Port An open port on a container
    pub fn new(private_port: i32, _type: String) -> Port {
        Port {
            IP: None,
            private_port,
            public_port: None,
            _type,
        }
    }
}


