/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __MAC_11_4: u32 = 110400;
pub const __MAC_11_5: u32 = 110500;
pub const __MAC_11_6: u32 = 110600;
pub const __MAC_12_0: u32 = 120000;
pub const __MAC_12_1: u32 = 120100;
pub const __MAC_12_2: u32 = 120200;
pub const __MAC_12_3: u32 = 120300;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __IPHONE_14_6: u32 = 140600;
pub const __IPHONE_14_7: u32 = 140700;
pub const __IPHONE_14_8: u32 = 140800;
pub const __IPHONE_15_0: u32 = 150000;
pub const __IPHONE_15_1: u32 = 150100;
pub const __IPHONE_15_2: u32 = 150200;
pub const __IPHONE_15_3: u32 = 150300;
pub const __IPHONE_15_4: u32 = 150400;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __TVOS_14_6: u32 = 140600;
pub const __TVOS_14_7: u32 = 140700;
pub const __TVOS_15_0: u32 = 150000;
pub const __TVOS_15_1: u32 = 150100;
pub const __TVOS_15_2: u32 = 150200;
pub const __TVOS_15_3: u32 = 150300;
pub const __TVOS_15_4: u32 = 150400;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const __WATCHOS_7_5: u32 = 70500;
pub const __WATCHOS_7_6: u32 = 70600;
pub const __WATCHOS_8_0: u32 = 80000;
pub const __WATCHOS_8_1: u32 = 80100;
pub const __WATCHOS_8_3: u32 = 80300;
pub const __WATCHOS_8_4: u32 = 80400;
pub const __WATCHOS_8_5: u32 = 80500;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const MAC_OS_VERSION_12_0: u32 = 120000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __DRIVERKIT_21_0: u32 = 210000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 120300;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 1;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_EXTSN: &[u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_VERS_1050: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __has_ptrcheck: u32 = 0;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _ARM_SIGNAL_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const __DARWIN_OPAQUE_ARM_THREAD_STATE64: u32 = 0;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_V5: u32 = 5;
pub const RUSAGE_INFO_CURRENT: u32 = 5;
pub const RU_PROC_RUNS_RESLIDE: u32 = 1;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_TYPE_VFS_TRIGGER_RESOLVE: u32 = 5;
pub const IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION: u32 = 6;
pub const IOPOL_TYPE_VFS_IGNORE_PERMISSIONS: u32 = 7;
pub const IOPOL_TYPE_VFS_SKIP_MTIME_UPDATE: u32 = 8;
pub const IOPOL_TYPE_VFS_ALLOW_LOW_SPACE_WRITES: u32 = 9;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT: u32 = 0;
pub const IOPOL_VFS_TRIGGER_RESOLVE_OFF: u32 = 1;
pub const IOPOL_VFS_CONTENT_PROTECTION_DEFAULT: u32 = 0;
pub const IOPOL_VFS_CONTENT_PROTECTION_IGNORE: u32 = 1;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_OFF: u32 = 0;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_ON: u32 = 1;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_OFF: u32 = 0;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_ON: u32 = 1;
pub const IOPOL_VFS_ALLOW_LOW_SPACE_WRITES_OFF: u32 = 0;
pub const IOPOL_VFS_ALLOW_LOW_SPACE_WRITES_ON: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const ORT_API_VERSION: u32 = 11;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_exception_state {
    pub __exception: __uint32_t,
    pub __fsr: __uint32_t,
    pub __far: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_arm_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_arm_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state>())).__exception as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state),
            "::",
            stringify!(__exception)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state>())).__fsr as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state),
            "::",
            stringify!(__fsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state>())).__far as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state),
            "::",
            stringify!(__far)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_exception_state64 {
    pub __far: __uint64_t,
    pub __esr: __uint32_t,
    pub __exception: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_arm_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_arm_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state64>())).__far as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state64),
            "::",
            stringify!(__far)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state64>())).__esr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state64),
            "::",
            stringify!(__esr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_exception_state64>())).__exception as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_exception_state64),
            "::",
            stringify!(__exception)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_thread_state {
    pub __r: [__uint32_t; 13usize],
    pub __sp: __uint32_t,
    pub __lr: __uint32_t,
    pub __pc: __uint32_t,
    pub __cpsr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_thread_state>(),
        68usize,
        concat!("Size of: ", stringify!(__darwin_arm_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_arm_thread_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_thread_state>())).__r as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state),
            "::",
            stringify!(__r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_thread_state>())).__sp as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state),
            "::",
            stringify!(__sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_thread_state>())).__lr as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state),
            "::",
            stringify!(__lr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_thread_state>())).__pc as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state),
            "::",
            stringify!(__pc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state>())).__cpsr as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state),
            "::",
            stringify!(__cpsr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_thread_state64 {
    pub __x: [__uint64_t; 29usize],
    pub __fp: __uint64_t,
    pub __lr: __uint64_t,
    pub __sp: __uint64_t,
    pub __pc: __uint64_t,
    pub __cpsr: __uint32_t,
    pub __pad: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_thread_state64>(),
        272usize,
        concat!("Size of: ", stringify!(__darwin_arm_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_arm_thread_state64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__fp as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__fp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__lr as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__lr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__sp as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__sp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__pc as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__pc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__cpsr as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__cpsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_thread_state64>())).__pad as *const _ as usize
        },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_thread_state64),
            "::",
            stringify!(__pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_vfp_state {
    pub __r: [__uint32_t; 64usize],
    pub __fpscr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_vfp_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_vfp_state>(),
        260usize,
        concat!("Size of: ", stringify!(__darwin_arm_vfp_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_vfp_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_arm_vfp_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_vfp_state>())).__r as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_vfp_state),
            "::",
            stringify!(__r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_vfp_state>())).__fpscr as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_vfp_state),
            "::",
            stringify!(__fpscr)
        )
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_neon_state64 {
    pub __v: [__uint128_t; 32usize],
    pub __fpsr: __uint32_t,
    pub __fpcr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_neon_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_neon_state64>(),
        528usize,
        concat!("Size of: ", stringify!(__darwin_arm_neon_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_neon_state64>(),
        16usize,
        concat!("Alignment of ", stringify!(__darwin_arm_neon_state64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_neon_state64>())).__v as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state64),
            "::",
            stringify!(__v)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_neon_state64>())).__fpsr as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state64),
            "::",
            stringify!(__fpsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_neon_state64>())).__fpcr as *const _ as usize
        },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state64),
            "::",
            stringify!(__fpcr)
        )
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_neon_state {
    pub __v: [__uint128_t; 16usize],
    pub __fpsr: __uint32_t,
    pub __fpcr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_neon_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_neon_state>(),
        272usize,
        concat!("Size of: ", stringify!(__darwin_arm_neon_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_neon_state>(),
        16usize,
        concat!("Alignment of ", stringify!(__darwin_arm_neon_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_neon_state>())).__v as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state),
            "::",
            stringify!(__v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_neon_state>())).__fpsr as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state),
            "::",
            stringify!(__fpsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_arm_neon_state>())).__fpcr as *const _ as usize },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_neon_state),
            "::",
            stringify!(__fpcr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __arm_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___arm_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__arm_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__arm_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__arm_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__arm_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__arm_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__arm_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __arm_legacy_debug_state {
    pub __bvr: [__uint32_t; 16usize],
    pub __bcr: [__uint32_t; 16usize],
    pub __wvr: [__uint32_t; 16usize],
    pub __wcr: [__uint32_t; 16usize],
}
#[test]
fn bindgen_test_layout___arm_legacy_debug_state() {
    assert_eq!(
        ::std::mem::size_of::<__arm_legacy_debug_state>(),
        256usize,
        concat!("Size of: ", stringify!(__arm_legacy_debug_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__arm_legacy_debug_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__arm_legacy_debug_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__arm_legacy_debug_state>())).__bvr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__arm_legacy_debug_state),
            "::",
            stringify!(__bvr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__arm_legacy_debug_state>())).__bcr as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__arm_legacy_debug_state),
            "::",
            stringify!(__bcr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__arm_legacy_debug_state>())).__wvr as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__arm_legacy_debug_state),
            "::",
            stringify!(__wvr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__arm_legacy_debug_state>())).__wcr as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__arm_legacy_debug_state),
            "::",
            stringify!(__wcr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_debug_state32 {
    pub __bvr: [__uint32_t; 16usize],
    pub __bcr: [__uint32_t; 16usize],
    pub __wvr: [__uint32_t; 16usize],
    pub __wcr: [__uint32_t; 16usize],
    pub __mdscr_el1: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_debug_state32>(),
        264usize,
        concat!("Size of: ", stringify!(__darwin_arm_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_debug_state32>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_arm_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state32>())).__bvr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state32),
            "::",
            stringify!(__bvr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state32>())).__bcr as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state32),
            "::",
            stringify!(__bcr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state32>())).__wvr as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state32),
            "::",
            stringify!(__wvr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state32>())).__wcr as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state32),
            "::",
            stringify!(__wcr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state32>())).__mdscr_el1 as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state32),
            "::",
            stringify!(__mdscr_el1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_debug_state64 {
    pub __bvr: [__uint64_t; 16usize],
    pub __bcr: [__uint64_t; 16usize],
    pub __wvr: [__uint64_t; 16usize],
    pub __wcr: [__uint64_t; 16usize],
    pub __mdscr_el1: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_arm_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_debug_state64>(),
        520usize,
        concat!("Size of: ", stringify!(__darwin_arm_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_arm_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state64>())).__bvr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state64),
            "::",
            stringify!(__bvr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state64>())).__bcr as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state64),
            "::",
            stringify!(__bcr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state64>())).__wvr as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state64),
            "::",
            stringify!(__wvr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state64>())).__wcr as *const _ as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state64),
            "::",
            stringify!(__wcr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_debug_state64>())).__mdscr_el1 as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_debug_state64),
            "::",
            stringify!(__mdscr_el1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_arm_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_arm_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_arm_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_arm_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_arm_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_arm_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_arm_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_arm_exception_state,
    pub __ss: __darwin_arm_thread_state,
    pub __fs: __darwin_arm_vfp_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        340usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_arm_exception_state64,
    pub __ss: __darwin_arm_thread_state64,
    pub __ns: __darwin_arm_neon_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        816usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        16usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ns as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ns)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v5 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
    pub ri_flags: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v5() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v5>(),
        304usize,
        concat!("Size of: ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v5>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_runnable_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_flags as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_flags)
        )
    );
}
pub type rusage_info_current = rusage_info_v5;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct _OSUnalignedU16 {
    pub __val: u16,
}
#[test]
fn bindgen_test_layout__OSUnalignedU16() {
    assert_eq!(
        ::std::mem::size_of::<_OSUnalignedU16>(),
        2usize,
        concat!("Size of: ", stringify!(_OSUnalignedU16))
    );
    assert_eq!(
        ::std::mem::align_of::<_OSUnalignedU16>(),
        1usize,
        concat!("Alignment of ", stringify!(_OSUnalignedU16))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OSUnalignedU16>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OSUnalignedU16),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct _OSUnalignedU32 {
    pub __val: u32,
}
#[test]
fn bindgen_test_layout__OSUnalignedU32() {
    assert_eq!(
        ::std::mem::size_of::<_OSUnalignedU32>(),
        4usize,
        concat!("Size of: ", stringify!(_OSUnalignedU32))
    );
    assert_eq!(
        ::std::mem::align_of::<_OSUnalignedU32>(),
        1usize,
        concat!("Alignment of ", stringify!(_OSUnalignedU32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OSUnalignedU32>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OSUnalignedU32),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct _OSUnalignedU64 {
    pub __val: u64,
}
#[test]
fn bindgen_test_layout__OSUnalignedU64() {
    assert_eq!(
        ::std::mem::size_of::<_OSUnalignedU64>(),
        8usize,
        concat!("Size of: ", stringify!(_OSUnalignedU64))
    );
    assert_eq!(
        ::std::mem::align_of::<_OSUnalignedU64>(),
        1usize,
        concat!("Alignment of ", stringify!(_OSUnalignedU64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OSUnalignedU64>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OSUnalignedU64),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
pub type wchar_t = __darwin_wchar_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UNDEFINED:
    ONNXTensorElementDataType = 0;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT: ONNXTensorElementDataType =
    1;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT8: ONNXTensorElementDataType =
    2;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT8: ONNXTensorElementDataType =
    3;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT16:
    ONNXTensorElementDataType = 4;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT16: ONNXTensorElementDataType =
    5;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT32: ONNXTensorElementDataType =
    6;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT64: ONNXTensorElementDataType =
    7;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_STRING:
    ONNXTensorElementDataType = 8;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_BOOL: ONNXTensorElementDataType =
    9;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT16:
    ONNXTensorElementDataType = 10;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_DOUBLE:
    ONNXTensorElementDataType = 11;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT32:
    ONNXTensorElementDataType = 12;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT64:
    ONNXTensorElementDataType = 13;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_COMPLEX64:
    ONNXTensorElementDataType = 14;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_COMPLEX128:
    ONNXTensorElementDataType = 15;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_BFLOAT16:
    ONNXTensorElementDataType = 16;
#[doc = " Copied from TensorProto::DataType"]
#[doc = " Currently, Ort doesn't support complex64, complex128"]
pub type ONNXTensorElementDataType = ::std::os::raw::c_uint;
pub const ONNXType_ONNX_TYPE_UNKNOWN: ONNXType = 0;
pub const ONNXType_ONNX_TYPE_TENSOR: ONNXType = 1;
pub const ONNXType_ONNX_TYPE_SEQUENCE: ONNXType = 2;
pub const ONNXType_ONNX_TYPE_MAP: ONNXType = 3;
pub const ONNXType_ONNX_TYPE_OPAQUE: ONNXType = 4;
pub const ONNXType_ONNX_TYPE_SPARSETENSOR: ONNXType = 5;
pub const ONNXType_ONNX_TYPE_OPTIONAL: ONNXType = 6;
pub type ONNXType = ::std::os::raw::c_uint;
pub const OrtSparseFormat_ORT_SPARSE_UNDEFINED: OrtSparseFormat = 0;
pub const OrtSparseFormat_ORT_SPARSE_COO: OrtSparseFormat = 1;
pub const OrtSparseFormat_ORT_SPARSE_CSRC: OrtSparseFormat = 2;
pub const OrtSparseFormat_ORT_SPARSE_BLOCK_SPARSE: OrtSparseFormat = 4;
pub type OrtSparseFormat = ::std::os::raw::c_uint;
pub const OrtSparseIndicesFormat_ORT_SPARSE_COO_INDICES: OrtSparseIndicesFormat = 0;
pub const OrtSparseIndicesFormat_ORT_SPARSE_CSR_INNER_INDICES: OrtSparseIndicesFormat = 1;
pub const OrtSparseIndicesFormat_ORT_SPARSE_CSR_OUTER_INDICES: OrtSparseIndicesFormat = 2;
pub const OrtSparseIndicesFormat_ORT_SPARSE_BLOCK_SPARSE_INDICES: OrtSparseIndicesFormat = 3;
pub type OrtSparseIndicesFormat = ::std::os::raw::c_uint;
#[doc = "< Verbose informational messages (least severe)."]
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_VERBOSE: OrtLoggingLevel = 0;
#[doc = "< Informational messages."]
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_INFO: OrtLoggingLevel = 1;
#[doc = "< Warning messages."]
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_WARNING: OrtLoggingLevel = 2;
#[doc = "< Error messages."]
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_ERROR: OrtLoggingLevel = 3;
#[doc = "< Fatal error messages (most severe)."]
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_FATAL: OrtLoggingLevel = 4;
#[doc = " \\brief Logging severity levels"]
#[doc = ""]
#[doc = " In typical API usage, specifying a logging severity level specifies the minimum severity of log messages to show."]
pub type OrtLoggingLevel = ::std::os::raw::c_uint;
pub const OrtErrorCode_ORT_OK: OrtErrorCode = 0;
pub const OrtErrorCode_ORT_FAIL: OrtErrorCode = 1;
pub const OrtErrorCode_ORT_INVALID_ARGUMENT: OrtErrorCode = 2;
pub const OrtErrorCode_ORT_NO_SUCHFILE: OrtErrorCode = 3;
pub const OrtErrorCode_ORT_NO_MODEL: OrtErrorCode = 4;
pub const OrtErrorCode_ORT_ENGINE_ERROR: OrtErrorCode = 5;
pub const OrtErrorCode_ORT_RUNTIME_EXCEPTION: OrtErrorCode = 6;
pub const OrtErrorCode_ORT_INVALID_PROTOBUF: OrtErrorCode = 7;
pub const OrtErrorCode_ORT_MODEL_LOADED: OrtErrorCode = 8;
pub const OrtErrorCode_ORT_NOT_IMPLEMENTED: OrtErrorCode = 9;
pub const OrtErrorCode_ORT_INVALID_GRAPH: OrtErrorCode = 10;
pub const OrtErrorCode_ORT_EP_FAIL: OrtErrorCode = 11;
pub type OrtErrorCode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtEnv {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtStatus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtMemoryInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtIoBinding {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSession {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtValue {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtRunOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTensorTypeAndShapeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSessionOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCustomOpDomain {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtMapTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSequenceTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtModelMetadata {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtThreadPoolParams {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtThreadingOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtArenaCfg {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtPrepackedWeightsContainer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTensorRTProviderOptionsV2 {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCUDAProviderOptionsV2 {
    _unused: [u8; 0],
}
pub type OrtStatusPtr = *mut OrtStatus;
#[doc = " \\brief Memory allocation interface"]
#[doc = ""]
#[doc = " Structure of function pointers that defines a memory allocator. This can be created and filled in by the user for custom allocators."]
#[doc = ""]
#[doc = " When an allocator is passed to any function, be sure that the allocator object is not destroyed until the last allocated object using it is freed."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtAllocator {
    #[doc = "< Must be initialized to ORT_API_VERSION"]
    pub version: u32,
    #[doc = "< Returns a pointer to an allocated block of `size` bytes"]
    pub Alloc: ::std::option::Option<
        unsafe extern "C" fn(this_: *mut OrtAllocator, size: usize) -> *mut ::std::os::raw::c_void,
    >,
    #[doc = "< Free a block of memory previously allocated with OrtAllocator::Alloc"]
    pub Free: ::std::option::Option<
        unsafe extern "C" fn(this_: *mut OrtAllocator, p: *mut ::std::os::raw::c_void),
    >,
    #[doc = "< Return a pointer to an ::OrtMemoryInfo that describes this allocator"]
    pub Info: ::std::option::Option<
        unsafe extern "C" fn(this_: *const OrtAllocator) -> *const OrtMemoryInfo,
    >,
}
#[test]
fn bindgen_test_layout_OrtAllocator() {
    assert_eq!(
        ::std::mem::size_of::<OrtAllocator>(),
        32usize,
        concat!("Size of: ", stringify!(OrtAllocator))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtAllocator>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtAllocator))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Alloc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Alloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Info as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Info)
        )
    );
}
pub type OrtLoggingFunction = ::std::option::Option<
    unsafe extern "C" fn(
        param: *mut ::std::os::raw::c_void,
        severity: OrtLoggingLevel,
        category: *const ::std::os::raw::c_char,
        logid: *const ::std::os::raw::c_char,
        code_location: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
    ),
>;
pub const GraphOptimizationLevel_ORT_DISABLE_ALL: GraphOptimizationLevel = 0;
pub const GraphOptimizationLevel_ORT_ENABLE_BASIC: GraphOptimizationLevel = 1;
pub const GraphOptimizationLevel_ORT_ENABLE_EXTENDED: GraphOptimizationLevel = 2;
pub const GraphOptimizationLevel_ORT_ENABLE_ALL: GraphOptimizationLevel = 99;
#[doc = " \\brief Graph optimization level"]
#[doc = ""]
#[doc = " Refer to https://www.onnxruntime.ai/docs/resources/graph-optimizations.html"]
#[doc = " for an in-depth understanding of Graph Optimizations"]
pub type GraphOptimizationLevel = ::std::os::raw::c_uint;
pub const ExecutionMode_ORT_SEQUENTIAL: ExecutionMode = 0;
pub const ExecutionMode_ORT_PARALLEL: ExecutionMode = 1;
pub type ExecutionMode = ::std::os::raw::c_uint;
pub const OrtLanguageProjection_ORT_PROJECTION_C: OrtLanguageProjection = 0;
pub const OrtLanguageProjection_ORT_PROJECTION_CPLUSPLUS: OrtLanguageProjection = 1;
pub const OrtLanguageProjection_ORT_PROJECTION_CSHARP: OrtLanguageProjection = 2;
pub const OrtLanguageProjection_ORT_PROJECTION_PYTHON: OrtLanguageProjection = 3;
pub const OrtLanguageProjection_ORT_PROJECTION_JAVA: OrtLanguageProjection = 4;
pub const OrtLanguageProjection_ORT_PROJECTION_WINML: OrtLanguageProjection = 5;
pub const OrtLanguageProjection_ORT_PROJECTION_NODEJS: OrtLanguageProjection = 6;
#[doc = " \\brief Language projection identifiers"]
#[doc = " /see OrtApi::SetLanguageProjection"]
pub type OrtLanguageProjection = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtKernelInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtKernelContext {
    _unused: [u8; 0],
}
pub const OrtAllocatorType_OrtInvalidAllocator: OrtAllocatorType = -1;
pub const OrtAllocatorType_OrtDeviceAllocator: OrtAllocatorType = 0;
pub const OrtAllocatorType_OrtArenaAllocator: OrtAllocatorType = 1;
pub type OrtAllocatorType = ::std::os::raw::c_int;
#[doc = "< Any CPU memory used by non-CPU execution provider"]
pub const OrtMemType_OrtMemTypeCPUInput: OrtMemType = -2;
#[doc = "< CPU accessible memory outputted by non-CPU execution provider, i.e. CUDA_PINNED"]
pub const OrtMemType_OrtMemTypeCPUOutput: OrtMemType = -1;
#[doc = "< Temporary CPU accessible memory allocated by non-CPU execution provider, i.e. CUDA_PINNED"]
pub const OrtMemType_OrtMemTypeCPU: OrtMemType = -1;
#[doc = "< The default allocator for execution provider"]
pub const OrtMemType_OrtMemTypeDefault: OrtMemType = 0;
#[doc = " \\brief Memory types for allocated memory, execution provider specific types should be extended in each provider."]
pub type OrtMemType = ::std::os::raw::c_int;
pub const OrtCudnnConvAlgoSearch_OrtCudnnConvAlgoSearchExhaustive: OrtCudnnConvAlgoSearch = 0;
pub const OrtCudnnConvAlgoSearch_OrtCudnnConvAlgoSearchHeuristic: OrtCudnnConvAlgoSearch = 1;
pub const OrtCudnnConvAlgoSearch_OrtCudnnConvAlgoSearchDefault: OrtCudnnConvAlgoSearch = 2;
#[doc = " \\brief Algorithm to use for cuDNN Convolution Op"]
pub type OrtCudnnConvAlgoSearch = ::std::os::raw::c_uint;
#[doc = " \\brief CUDA Provider Options"]
#[doc = ""]
#[doc = " \\see OrtApi::SessionOptionsAppendExecutionProvider_CUDA"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCUDAProviderOptions {
    #[doc = " \\brief CUDA device Id"]
    #[doc = "   Defaults to 0."]
    pub device_id: ::std::os::raw::c_int,
    #[doc = " \\brief CUDA Convolution algorithm search configuration."]
    #[doc = "   See enum OrtCudnnConvAlgoSearch for more details."]
    #[doc = "   Defaults to OrtCudnnConvAlgoSearchExhaustive."]
    pub cudnn_conv_algo_search: OrtCudnnConvAlgoSearch,
    #[doc = " \\brief CUDA memory limit (To use all possible memory pass in maximum size_t)"]
    #[doc = "   Defaults to SIZE_MAX."]
    #[doc = "   \\note If a ::OrtArenaCfg has been applied, it will override this field"]
    pub gpu_mem_limit: usize,
    #[doc = " \\brief Strategy used to grow the memory arena"]
    #[doc = "   0 = kNextPowerOfTwo<br>"]
    #[doc = "   1 = kSameAsRequested<br>"]
    #[doc = "   Defaults to 0."]
    #[doc = "   \\note If a ::OrtArenaCfg has been applied, it will override this field"]
    pub arena_extend_strategy: ::std::os::raw::c_int,
    #[doc = " \\brief Flag indicating if copying needs to take place on the same stream as the compute stream in the CUDA EP"]
    #[doc = "   0 = Use separate streams for copying and compute."]
    #[doc = "   1 = Use the same stream for copying and compute."]
    #[doc = "   Defaults to 1."]
    #[doc = "   WARNING: Setting this to 0 may result in data races for some models."]
    #[doc = "   Please see issue #4829 for more details."]
    pub do_copy_in_default_stream: ::std::os::raw::c_int,
    #[doc = " \\brief Flag indicating if there is a user provided compute stream"]
    #[doc = "   Defaults to 0."]
    pub has_user_compute_stream: ::std::os::raw::c_int,
    #[doc = " \\brief User provided compute stream."]
    #[doc = "   If provided, please set `has_user_compute_stream` to 1."]
    pub user_compute_stream: *mut ::std::os::raw::c_void,
    #[doc = " \\brief CUDA memory arena configuration parameters"]
    pub default_memory_arena_cfg: *mut OrtArenaCfg,
}
#[test]
fn bindgen_test_layout_OrtCUDAProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtCUDAProviderOptions>(),
        48usize,
        concat!("Size of: ", stringify!(OrtCUDAProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtCUDAProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtCUDAProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).cudnn_conv_algo_search as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(cudnn_conv_algo_search)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).gpu_mem_limit as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(gpu_mem_limit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).arena_extend_strategy as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(arena_extend_strategy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).do_copy_in_default_stream as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(do_copy_in_default_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).has_user_compute_stream as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(has_user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).user_compute_stream as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).default_memory_arena_cfg as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(default_memory_arena_cfg)
        )
    );
}
#[doc = " \\brief ROCM Provider Options"]
#[doc = ""]
#[doc = " \\see OrtApi::SessionOptionsAppendExecutionProvider_ROCM"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtROCMProviderOptions {
    #[doc = " \\brief ROCM device Id"]
    #[doc = "   Defaults to 0."]
    pub device_id: ::std::os::raw::c_int,
    #[doc = " \\brief ROCM MIOpen Convolution algorithm exaustive search option."]
    #[doc = "   Defaults to 0 (false)."]
    pub miopen_conv_exhaustive_search: ::std::os::raw::c_int,
    #[doc = " \\brief ROCM memory limit (To use all possible memory pass in maximum size_t)"]
    #[doc = "   Defaults to SIZE_MAX."]
    #[doc = "   \\note If a ::OrtArenaCfg has been applied, it will override this field"]
    pub gpu_mem_limit: usize,
    #[doc = " \\brief Strategy used to grow the memory arena"]
    #[doc = "   0 = kNextPowerOfTwo<br>"]
    #[doc = "   1 = kSameAsRequested<br>"]
    #[doc = "   Defaults to 0."]
    #[doc = "   \\note If a ::OrtArenaCfg has been applied, it will override this field"]
    pub arena_extend_strategy: ::std::os::raw::c_int,
    #[doc = " \\brief Flag indicating if copying needs to take place on the same stream as the compute stream in the ROCM EP"]
    #[doc = "   0 = Use separate streams for copying and compute."]
    #[doc = "   1 = Use the same stream for copying and compute."]
    #[doc = "   Defaults to 1."]
    #[doc = "   WARNING: Setting this to 0 may result in data races for some models."]
    #[doc = "   Please see issue #4829 for more details."]
    pub do_copy_in_default_stream: ::std::os::raw::c_int,
    #[doc = " \\brief Flag indicating if there is a user provided compute stream"]
    #[doc = "   Defaults to 0."]
    pub has_user_compute_stream: ::std::os::raw::c_int,
    #[doc = " \\brief User provided compute stream."]
    #[doc = "   If provided, please set `has_user_compute_stream` to 1."]
    pub user_compute_stream: *mut ::std::os::raw::c_void,
    #[doc = " \\brief ROCM memory arena configuration parameters"]
    pub default_memory_arena_cfg: *mut OrtArenaCfg,
}
#[test]
fn bindgen_test_layout_OrtROCMProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtROCMProviderOptions>(),
        48usize,
        concat!("Size of: ", stringify!(OrtROCMProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtROCMProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtROCMProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).miopen_conv_exhaustive_search
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(miopen_conv_exhaustive_search)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).gpu_mem_limit as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(gpu_mem_limit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).arena_extend_strategy as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(arena_extend_strategy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).do_copy_in_default_stream as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(do_copy_in_default_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).has_user_compute_stream as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(has_user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).user_compute_stream as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).default_memory_arena_cfg as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(default_memory_arena_cfg)
        )
    );
}
#[doc = " \\brief TensorRT Provider Options"]
#[doc = ""]
#[doc = " \\see OrtApi::SessionOptionsAppendExecutionProvider_TensorRT"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTensorRTProviderOptions {
    #[doc = "< CUDA device id (0 = default device)"]
    pub device_id: ::std::os::raw::c_int,
    pub has_user_compute_stream: ::std::os::raw::c_int,
    pub user_compute_stream: *mut ::std::os::raw::c_void,
    pub trt_max_partition_iterations: ::std::os::raw::c_int,
    pub trt_min_subgraph_size: ::std::os::raw::c_int,
    pub trt_max_workspace_size: usize,
    pub trt_fp16_enable: ::std::os::raw::c_int,
    pub trt_int8_enable: ::std::os::raw::c_int,
    pub trt_int8_calibration_table_name: *const ::std::os::raw::c_char,
    pub trt_int8_use_native_calibration_table: ::std::os::raw::c_int,
    pub trt_dla_enable: ::std::os::raw::c_int,
    pub trt_dla_core: ::std::os::raw::c_int,
    pub trt_dump_subgraphs: ::std::os::raw::c_int,
    pub trt_engine_cache_enable: ::std::os::raw::c_int,
    pub trt_engine_cache_path: *const ::std::os::raw::c_char,
    pub trt_engine_decryption_enable: ::std::os::raw::c_int,
    pub trt_engine_decryption_lib_path: *const ::std::os::raw::c_char,
    pub trt_force_sequential_engine_build: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_OrtTensorRTProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtTensorRTProviderOptions>(),
        104usize,
        concat!("Size of: ", stringify!(OrtTensorRTProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtTensorRTProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtTensorRTProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).has_user_compute_stream
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(has_user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).user_compute_stream as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_max_partition_iterations
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_max_partition_iterations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_min_subgraph_size as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_min_subgraph_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_max_workspace_size
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_max_workspace_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_fp16_enable as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_fp16_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_int8_enable as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_int8_calibration_table_name
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_calibration_table_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>()))
                .trt_int8_use_native_calibration_table as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_use_native_calibration_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dla_enable as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dla_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dla_core as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dla_core)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dump_subgraphs as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dump_subgraphs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_cache_enable
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_cache_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_cache_path as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_cache_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_decryption_enable
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_decryption_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_decryption_lib_path
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_decryption_lib_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_force_sequential_engine_build
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_force_sequential_engine_build)
        )
    );
}
#[doc = " \\brief MIGraphX Provider Options"]
#[doc = ""]
#[doc = " \\see OrtApi::SessionOptionsAppendExecutionProvider_MIGraphX"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtMIGraphXProviderOptions {
    pub device_id: ::std::os::raw::c_int,
    pub migraphx_fp16_enable: ::std::os::raw::c_int,
    pub migraphx_int8_enable: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_OrtMIGraphXProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtMIGraphXProviderOptions>(),
        12usize,
        concat!("Size of: ", stringify!(OrtMIGraphXProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtMIGraphXProviderOptions>(),
        4usize,
        concat!("Alignment of ", stringify!(OrtMIGraphXProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtMIGraphXProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtMIGraphXProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtMIGraphXProviderOptions>())).migraphx_fp16_enable as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtMIGraphXProviderOptions),
            "::",
            stringify!(migraphx_fp16_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtMIGraphXProviderOptions>())).migraphx_int8_enable as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtMIGraphXProviderOptions),
            "::",
            stringify!(migraphx_int8_enable)
        )
    );
}
#[doc = " \\brief OpenVINO Provider Options"]
#[doc = ""]
#[doc = " \\see OrtApi::SessionOptionsAppendExecutionProvider_OpenVINO"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtOpenVINOProviderOptions {
    #[doc = " \\brief Device type string"]
    #[doc = ""]
    #[doc = " Valid settings are one of: \"CPU_FP32\", \"GPU_FP32\", \"GPU_FP16\", \"MYRIAD_FP16\", \"VAD-M_FP16\" or \"VAD-F_FP32\""]
    pub device_type: *const ::std::os::raw::c_char,
    #[doc = "< 0 = disabled, nonzero = enabled"]
    pub enable_vpu_fast_compile: ::std::os::raw::c_uchar,
    pub device_id: *const ::std::os::raw::c_char,
    #[doc = "< 0 = Use default number of threads"]
    pub num_of_threads: usize,
    #[doc = "< 0 = disabled, nonzero = enabled"]
    pub use_compiled_network: ::std::os::raw::c_uchar,
    pub blob_dump_path: *const ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_OrtOpenVINOProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtOpenVINOProviderOptions>(),
        56usize,
        concat!("Size of: ", stringify!(OrtOpenVINOProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtOpenVINOProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtOpenVINOProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).device_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(device_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).enable_vpu_fast_compile
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(enable_vpu_fast_compile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).device_id as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).num_of_threads as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(num_of_threads)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).use_compiled_network as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(use_compiled_network)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).blob_dump_path as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(blob_dump_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).context as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(context)
        )
    );
}
#[doc = " \\brief The helper interface to get the right version of OrtApi"]
#[doc = ""]
#[doc = " Get a pointer to this structure through ::OrtGetApiBase"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtApiBase {
    #[doc = " \\brief Get a pointer to the requested version of the ::OrtApi"]
    #[doc = ""]
    #[doc = " \\param[in] version Must be ::ORT_API_VERSION"]
    #[doc = " \\return The ::OrtApi for the version requested, nullptr will be returned if this version is unsupported, for example when using a runtime"]
    #[doc = "   older than the version created with this header file."]
    pub GetApi: ::std::option::Option<unsafe extern "C" fn(version: u32) -> *const OrtApi>,
    #[doc = "< Returns a null terminated string of the version of the Onnxruntime library (eg: \"1.8.1\")"]
    pub GetVersionString:
        ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_OrtApiBase() {
    assert_eq!(
        ::std::mem::size_of::<OrtApiBase>(),
        16usize,
        concat!("Size of: ", stringify!(OrtApiBase))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtApiBase>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtApiBase))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApiBase>())).GetApi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApiBase),
            "::",
            stringify!(GetApi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApiBase>())).GetVersionString as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApiBase),
            "::",
            stringify!(GetVersionString)
        )
    );
}
#[doc = " \\brief Thread work loop function"]
#[doc = ""]
#[doc = " Onnxruntime will provide the working loop on custom thread creation"]
#[doc = " Argument is an onnxruntime built-in type which will be provided when thread pool calls OrtCustomCreateThreadFn"]
pub type OrtThreadWorkerFn =
    ::std::option::Option<unsafe extern "C" fn(ort_worker_fn_param: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCustomHandleType {
    pub __place_holder: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_OrtCustomHandleType() {
    assert_eq!(
        ::std::mem::size_of::<OrtCustomHandleType>(),
        1usize,
        concat!("Size of: ", stringify!(OrtCustomHandleType))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtCustomHandleType>(),
        1usize,
        concat!("Alignment of ", stringify!(OrtCustomHandleType))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomHandleType>())).__place_holder as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomHandleType),
            "::",
            stringify!(__place_holder)
        )
    );
}
pub type OrtCustomThreadHandle = *const OrtCustomHandleType;
#[doc = " \\brief Ort custom thread creation function"]
#[doc = ""]
#[doc = " The function should return a thread handle to be used in onnxruntime thread pools"]
#[doc = " Onnxruntime will throw exception on return value of nullptr or 0, indicating that the function failed to create a thread"]
pub type OrtCustomCreateThreadFn = ::std::option::Option<
    unsafe extern "C" fn(
        ort_custom_thread_creation_options: *mut ::std::os::raw::c_void,
        ort_thread_worker_fn: OrtThreadWorkerFn,
        ort_worker_fn_param: *mut ::std::os::raw::c_void,
    ) -> OrtCustomThreadHandle,
>;
#[doc = " \\brief Custom thread join function"]
#[doc = ""]
#[doc = " Onnxruntime thread pool destructor will call the function to join a custom thread."]
#[doc = " Argument ort_custom_thread_handle is the value returned by OrtCustomCreateThreadFn"]
pub type OrtCustomJoinThreadFn =
    ::std::option::Option<unsafe extern "C" fn(ort_custom_thread_handle: OrtCustomThreadHandle)>;
#[doc = " \\brief The C API"]
#[doc = ""]
#[doc = " All C API functions are defined inside this structure as pointers to functions."]
#[doc = " Call OrtApiBase::GetApi to get a pointer to it"]
#[doc = ""]
#[doc = " \\nosubgrouping"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtApi {
    #[doc = " \\brief Create an OrtStatus from a null terminated string"]
    #[doc = ""]
    #[doc = " \\param[in] code"]
    #[doc = " \\param[in] msg A null-terminated string. Its contents will be copied."]
    #[doc = " \\return A new OrtStatus object, must be destroyed with OrtApi::ReleaseStatus"]
    pub CreateStatus: ::std::option::Option<
        unsafe extern "C" fn(
            code: OrtErrorCode,
            msg: *const ::std::os::raw::c_char,
        ) -> *mut OrtStatus,
    >,
    #[doc = " \\brief Get OrtErrorCode from OrtStatus"]
    #[doc = ""]
    #[doc = " \\param[in] status"]
    #[doc = " \\return OrtErrorCode that \\p status was created with"]
    pub GetErrorCode:
        ::std::option::Option<unsafe extern "C" fn(status: *const OrtStatus) -> OrtErrorCode>,
    #[doc = " \\brief Get error string from OrtStatus"]
    #[doc = ""]
    #[doc = " \\param[in] status"]
    #[doc = " \\return The error message inside the `status`. Do not free the returned value."]
    pub GetErrorMessage: ::std::option::Option<
        unsafe extern "C" fn(status: *const OrtStatus) -> *const ::std::os::raw::c_char,
    >,
    pub CreateEnv: ::std::option::Option<
        unsafe extern "C" fn(
            log_severity_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub CreateEnvWithCustomLogger: ::std::option::Option<
        unsafe extern "C" fn(
            logging_function: OrtLoggingFunction,
            logger_param: *mut ::std::os::raw::c_void,
            log_severity_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub EnableTelemetryEvents:
        ::std::option::Option<unsafe extern "C" fn(env: *const OrtEnv) -> OrtStatusPtr>,
    pub DisableTelemetryEvents:
        ::std::option::Option<unsafe extern "C" fn(env: *const OrtEnv) -> OrtStatusPtr>,
    pub CreateSession: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_path: *const ::std::os::raw::c_char,
            options: *const OrtSessionOptions,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionFromArray: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_data: *const ::std::os::raw::c_void,
            model_data_length: usize,
            options: *const OrtSessionOptions,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub Run: ::std::option::Option<
        unsafe extern "C" fn(
            session: *mut OrtSession,
            run_options: *const OrtRunOptions,
            input_names: *const *const ::std::os::raw::c_char,
            inputs: *const *const OrtValue,
            input_len: usize,
            output_names: *const *const ::std::os::raw::c_char,
            output_names_len: usize,
            outputs: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionOptions: ::std::option::Option<
        unsafe extern "C" fn(options: *mut *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub SetOptimizedModelFilePath: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            optimized_model_filepath: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CloneSessionOptions: ::std::option::Option<
        unsafe extern "C" fn(
            in_options: *const OrtSessionOptions,
            out_options: *mut *mut OrtSessionOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionExecutionMode: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            execution_mode: ExecutionMode,
        ) -> OrtStatusPtr,
    >,
    pub EnableProfiling: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            profile_file_prefix: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub DisableProfiling: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub EnableMemPattern: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub DisableMemPattern: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub EnableCpuMemArena: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub DisableCpuMemArena: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub SetSessionLogId: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            logid: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            session_log_verbosity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            session_log_severity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionGraphOptimizationLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            graph_optimization_level: GraphOptimizationLevel,
        ) -> OrtStatusPtr,
    >,
    pub SetIntraOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            intra_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetInterOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            inter_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub CreateCustomOpDomain: ::std::option::Option<
        unsafe extern "C" fn(
            domain: *const ::std::os::raw::c_char,
            out: *mut *mut OrtCustomOpDomain,
        ) -> OrtStatusPtr,
    >,
    pub CustomOpDomain_Add: ::std::option::Option<
        unsafe extern "C" fn(
            custom_op_domain: *mut OrtCustomOpDomain,
            op: *const OrtCustomOp,
        ) -> OrtStatusPtr,
    >,
    pub AddCustomOpDomain: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            custom_op_domain: *mut OrtCustomOpDomain,
        ) -> OrtStatusPtr,
    >,
    pub RegisterCustomOpsLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            library_path: *const ::std::os::raw::c_char,
            library_handle: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetInputCount: ::std::option::Option<
        unsafe extern "C" fn(session: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetOutputCount: ::std::option::Option<
        unsafe extern "C" fn(session: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerCount: ::std::option::Option<
        unsafe extern "C" fn(session: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetInputTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOutputTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetInputName: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOutputName: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerName: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreateRunOptions:
        ::std::option::Option<unsafe extern "C" fn(out: *mut *mut OrtRunOptions) -> OrtStatusPtr>,
    pub RunOptionsSetRunLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            log_verbosity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetRunLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            log_severity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetRunTag: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            run_tag: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *const OrtRunOptions,
            log_verbosity_level: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *const OrtRunOptions,
            log_severity_level: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunTag: ::std::option::Option<
        unsafe extern "C" fn(
            options: *const OrtRunOptions,
            run_tag: *mut *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetTerminate:
        ::std::option::Option<unsafe extern "C" fn(options: *mut OrtRunOptions) -> OrtStatusPtr>,
    pub RunOptionsUnsetTerminate:
        ::std::option::Option<unsafe extern "C" fn(options: *mut OrtRunOptions) -> OrtStatusPtr>,
    pub CreateTensorAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            allocator: *mut OrtAllocator,
            shape: *const i64,
            shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateTensorWithDataAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtMemoryInfo,
            p_data: *mut ::std::os::raw::c_void,
            p_data_len: usize,
            shape: *const i64,
            shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub IsTensor: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorMutableData: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub FillStringTensor: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            s: *const *const ::std::os::raw::c_char,
            s_len: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetStringTensorDataLength: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, len: *mut usize) -> OrtStatusPtr,
    >,
    pub GetStringTensorContent: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            s: *mut ::std::os::raw::c_void,
            s_len: usize,
            offsets: *mut usize,
            offsets_len: usize,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToTensorInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            out: *mut *const OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetOnnxTypeFromTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(type_info: *const OrtTypeInfo, out: *mut ONNXType) -> OrtStatusPtr,
    >,
    pub CreateTensorTypeAndShapeInfo: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtTensorTypeAndShapeInfo) -> OrtStatusPtr,
    >,
    pub SetTensorElementType: ::std::option::Option<
        unsafe extern "C" fn(
            info: *mut OrtTensorTypeAndShapeInfo,
            type_: ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub SetDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *mut OrtTensorTypeAndShapeInfo,
            dim_values: *const i64,
            dim_count: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorElementType: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            out: *mut ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub GetDimensionsCount: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            out: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            dim_values: *mut i64,
            dim_values_length: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetSymbolicDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            dim_params: *mut *const ::std::os::raw::c_char,
            dim_params_length: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorShapeElementCount: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            out: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorTypeAndShape: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut *mut OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut *mut OrtTypeInfo) -> OrtStatusPtr,
    >,
    pub GetValueType: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut ONNXType) -> OrtStatusPtr,
    >,
    pub CreateMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            name: *const ::std::os::raw::c_char,
            type_: OrtAllocatorType,
            id: ::std::os::raw::c_int,
            mem_type: OrtMemType,
            out: *mut *mut OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub CreateCpuMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_: OrtAllocatorType,
            mem_type: OrtMemType,
            out: *mut *mut OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub CompareMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            info1: *const OrtMemoryInfo,
            info2: *const OrtMemoryInfo,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetName: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *const OrtMemoryInfo,
            out: *mut *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetId: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *const OrtMemoryInfo,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetMemType: ::std::option::Option<
        unsafe extern "C" fn(ptr: *const OrtMemoryInfo, out: *mut OrtMemType) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetType: ::std::option::Option<
        unsafe extern "C" fn(ptr: *const OrtMemoryInfo, out: *mut OrtAllocatorType) -> OrtStatusPtr,
    >,
    pub AllocatorAlloc: ::std::option::Option<
        unsafe extern "C" fn(
            ort_allocator: *mut OrtAllocator,
            size: usize,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub AllocatorFree: ::std::option::Option<
        unsafe extern "C" fn(
            ort_allocator: *mut OrtAllocator,
            p: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub AllocatorGetInfo: ::std::option::Option<
        unsafe extern "C" fn(
            ort_allocator: *const OrtAllocator,
            out: *mut *const OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetAllocatorWithDefaultOptions:
        ::std::option::Option<unsafe extern "C" fn(out: *mut *mut OrtAllocator) -> OrtStatusPtr>,
    pub AddFreeDimensionOverride: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            dim_denotation: *const ::std::os::raw::c_char,
            dim_value: i64,
        ) -> OrtStatusPtr,
    >,
    pub GetValue: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            index: ::std::os::raw::c_int,
            allocator: *mut OrtAllocator,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub GetValueCount: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut usize) -> OrtStatusPtr,
    >,
    pub CreateValue: ::std::option::Option<
        unsafe extern "C" fn(
            in_: *const *const OrtValue,
            num_values: usize,
            value_type: ONNXType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateOpaqueValue: ::std::option::Option<
        unsafe extern "C" fn(
            domain_name: *const ::std::os::raw::c_char,
            type_name: *const ::std::os::raw::c_char,
            data_container: *const ::std::os::raw::c_void,
            data_container_size: usize,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub GetOpaqueValue: ::std::option::Option<
        unsafe extern "C" fn(
            domain_name: *const ::std::os::raw::c_char,
            type_name: *const ::std::os::raw::c_char,
            in_: *const OrtValue,
            data_container: *mut ::std::os::raw::c_void,
            data_container_size: usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_float: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut f32,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_int64: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_string: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut ::std::os::raw::c_char,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelContext_GetInputCount: ::std::option::Option<
        unsafe extern "C" fn(context: *const OrtKernelContext, out: *mut usize) -> OrtStatusPtr,
    >,
    pub KernelContext_GetOutputCount: ::std::option::Option<
        unsafe extern "C" fn(context: *const OrtKernelContext, out: *mut usize) -> OrtStatusPtr,
    >,
    pub KernelContext_GetInput: ::std::option::Option<
        unsafe extern "C" fn(
            context: *const OrtKernelContext,
            index: usize,
            out: *mut *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub KernelContext_GetOutput: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut OrtKernelContext,
            index: usize,
            dim_values: *const i64,
            dim_count: usize,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseEnv: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtEnv)>,
    pub ReleaseStatus: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtStatus)>,
    pub ReleaseMemoryInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtMemoryInfo)>,
    pub ReleaseSession: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSession)>,
    pub ReleaseValue: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtValue)>,
    pub ReleaseRunOptions: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtRunOptions)>,
    pub ReleaseTypeInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtTypeInfo)>,
    pub ReleaseTensorTypeAndShapeInfo:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtTensorTypeAndShapeInfo)>,
    pub ReleaseSessionOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSessionOptions)>,
    pub ReleaseCustomOpDomain:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtCustomOpDomain)>,
    pub GetDenotationFromTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            denotation: *mut *const ::std::os::raw::c_char,
            len: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToMapTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            out: *mut *const OrtMapTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToSequenceTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            out: *mut *const OrtSequenceTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetMapKeyType: ::std::option::Option<
        unsafe extern "C" fn(
            map_type_info: *const OrtMapTypeInfo,
            out: *mut ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub GetMapValueType: ::std::option::Option<
        unsafe extern "C" fn(
            map_type_info: *const OrtMapTypeInfo,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetSequenceElementType: ::std::option::Option<
        unsafe extern "C" fn(
            sequence_type_info: *const OrtSequenceTypeInfo,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseMapTypeInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtMapTypeInfo)>,
    pub ReleaseSequenceTypeInfo:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSequenceTypeInfo)>,
    pub SessionEndProfiling: ::std::option::Option<
        unsafe extern "C" fn(
            session: *mut OrtSession,
            allocator: *mut OrtAllocator,
            out: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetModelMetadata: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            out: *mut *mut OrtModelMetadata,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetProducerName: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetGraphName: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetDomain: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetDescription: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataLookupCustomMetadataMap: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            key: *const ::std::os::raw::c_char,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetVersion: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            value: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseModelMetadata:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtModelMetadata)>,
    pub CreateEnvWithGlobalThreadPools: ::std::option::Option<
        unsafe extern "C" fn(
            log_severity_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            tp_options: *const OrtThreadingOptions,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub DisablePerSessionThreads: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub CreateThreadingOptions: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtThreadingOptions) -> OrtStatusPtr,
    >,
    pub ReleaseThreadingOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtThreadingOptions)>,
    pub ModelMetadataGetCustomMetadataMapKeys: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            keys: *mut *mut *mut ::std::os::raw::c_char,
            num_keys: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub AddFreeDimensionOverrideByName: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            dim_name: *const ::std::os::raw::c_char,
            dim_value: i64,
        ) -> OrtStatusPtr,
    >,
    pub GetAvailableProviders: ::std::option::Option<
        unsafe extern "C" fn(
            out_ptr: *mut *mut *mut ::std::os::raw::c_char,
            provider_length: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseAvailableProviders: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *mut *mut ::std::os::raw::c_char,
            providers_length: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub GetStringTensorElementLength: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, index: usize, out: *mut usize) -> OrtStatusPtr,
    >,
    pub GetStringTensorElement: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            s_len: usize,
            index: usize,
            s: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub FillStringTensorElement: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            s: *const ::std::os::raw::c_char,
            index: usize,
        ) -> OrtStatusPtr,
    >,
    pub AddSessionConfigEntry: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            config_key: *const ::std::os::raw::c_char,
            config_value: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreateAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            session: *const OrtSession,
            mem_info: *const OrtMemoryInfo,
            out: *mut *mut OrtAllocator,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseAllocator: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtAllocator)>,
    pub RunWithBinding: ::std::option::Option<
        unsafe extern "C" fn(
            session: *mut OrtSession,
            run_options: *const OrtRunOptions,
            binding_ptr: *const OrtIoBinding,
        ) -> OrtStatusPtr,
    >,
    pub CreateIoBinding: ::std::option::Option<
        unsafe extern "C" fn(session: *mut OrtSession, out: *mut *mut OrtIoBinding) -> OrtStatusPtr,
    >,
    pub ReleaseIoBinding: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtIoBinding)>,
    pub BindInput: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            val_ptr: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub BindOutput: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            val_ptr: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub BindOutputToDevice: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            mem_info_ptr: *const OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetBoundOutputNames: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *const OrtIoBinding,
            allocator: *mut OrtAllocator,
            buffer: *mut *mut ::std::os::raw::c_char,
            lengths: *mut *mut usize,
            count: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetBoundOutputValues: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *const OrtIoBinding,
            allocator: *mut OrtAllocator,
            output: *mut *mut *mut OrtValue,
            output_count: *mut usize,
        ) -> OrtStatusPtr,
    >,
    #[doc = " \\brief Clears any previously set Inputs for an ::OrtIoBinding"]
    pub ClearBoundInputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding)>,
    #[doc = " \\brief Clears any previously set Outputs for an ::OrtIoBinding"]
    pub ClearBoundOutputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding)>,
    pub TensorAt: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            location_values: *const i64,
            location_values_count: usize,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub CreateAndRegisterAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            env: *mut OrtEnv,
            mem_info: *const OrtMemoryInfo,
            arena_cfg: *const OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub SetLanguageProjection: ::std::option::Option<
        unsafe extern "C" fn(
            ort_env: *const OrtEnv,
            projection: OrtLanguageProjection,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetProfilingStartTimeNs: ::std::option::Option<
        unsafe extern "C" fn(session: *const OrtSession, out: *mut u64) -> OrtStatusPtr,
    >,
    pub SetGlobalIntraOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            intra_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalInterOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            inter_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalSpinControl: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            allow_spinning: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub AddInitializer: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            name: *const ::std::os::raw::c_char,
            val: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateEnvWithCustomLoggerAndGlobalThreadPools: ::std::option::Option<
        unsafe extern "C" fn(
            logging_function: OrtLoggingFunction,
            logger_param: *mut ::std::os::raw::c_void,
            log_severity_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            tp_options: *const OrtThreadingOptions,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_CUDA: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            cuda_options: *const OrtCUDAProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_ROCM: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            rocm_options: *const OrtROCMProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_OpenVINO: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            provider_options: *const OrtOpenVINOProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalDenormalAsZero: ::std::option::Option<
        unsafe extern "C" fn(tp_options: *mut OrtThreadingOptions) -> OrtStatusPtr,
    >,
    pub CreateArenaCfg: ::std::option::Option<
        unsafe extern "C" fn(
            max_mem: usize,
            arena_extend_strategy: ::std::os::raw::c_int,
            initial_chunk_size_bytes: ::std::os::raw::c_int,
            max_dead_bytes_per_chunk: ::std::os::raw::c_int,
            out: *mut *mut OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseArenaCfg: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtArenaCfg)>,
    pub ModelMetadataGetGraphDescription: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_TensorRT: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            tensorrt_options: *const OrtTensorRTProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetCurrentGpuDeviceId: ::std::option::Option<
        unsafe extern "C" fn(device_id: ::std::os::raw::c_int) -> OrtStatusPtr,
    >,
    pub GetCurrentGpuDeviceId: ::std::option::Option<
        unsafe extern "C" fn(device_id: *mut ::std::os::raw::c_int) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttributeArray_float: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut f32,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttributeArray_int64: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut i64,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub CreateArenaCfgV2: ::std::option::Option<
        unsafe extern "C" fn(
            arena_config_keys: *const *const ::std::os::raw::c_char,
            arena_config_values: *const usize,
            num_keys: usize,
            out: *mut *mut OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub AddRunConfigEntry: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            config_key: *const ::std::os::raw::c_char,
            config_value: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreatePrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtPrepackedWeightsContainer) -> OrtStatusPtr,
    >,
    pub ReleasePrepackedWeightsContainer:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtPrepackedWeightsContainer)>,
    pub CreateSessionWithPrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_path: *const ::std::os::raw::c_char,
            options: *const OrtSessionOptions,
            prepacked_weights_container: *mut OrtPrepackedWeightsContainer,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionFromArrayWithPrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_data: *const ::std::os::raw::c_void,
            model_data_length: usize,
            options: *const OrtSessionOptions,
            prepacked_weights_container: *mut OrtPrepackedWeightsContainer,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_TensorRT_V2: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            tensorrt_options: *const OrtTensorRTProviderOptionsV2,
        ) -> OrtStatusPtr,
    >,
    pub CreateTensorRTProviderOptions: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtTensorRTProviderOptionsV2) -> OrtStatusPtr,
    >,
    pub UpdateTensorRTProviderOptions: ::std::option::Option<
        unsafe extern "C" fn(
            tensorrt_options: *mut OrtTensorRTProviderOptionsV2,
            provider_options_keys: *const *const ::std::os::raw::c_char,
            provider_options_values: *const *const ::std::os::raw::c_char,
            num_keys: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorRTProviderOptionsAsString: ::std::option::Option<
        unsafe extern "C" fn(
            tensorrt_options: *const OrtTensorRTProviderOptionsV2,
            allocator: *mut OrtAllocator,
            ptr: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    #[doc = " \\brief Release an ::OrtTensorRTProviderOptionsV2"]
    #[doc = ""]
    #[doc = " \\note This is an exception in the naming convention of other Release* functions, as the name of the method does not have the V2 suffix, but the type does"]
    pub ReleaseTensorRTProviderOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtTensorRTProviderOptionsV2)>,
    pub EnableOrtCustomOps: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub RegisterAllocator: ::std::option::Option<
        unsafe extern "C" fn(env: *mut OrtEnv, allocator: *mut OrtAllocator) -> OrtStatusPtr,
    >,
    pub UnregisterAllocator: ::std::option::Option<
        unsafe extern "C" fn(env: *mut OrtEnv, mem_info: *const OrtMemoryInfo) -> OrtStatusPtr,
    >,
    pub IsSparseTensor: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub CreateSparseTensorAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            allocator: *mut OrtAllocator,
            dense_shape: *const i64,
            dense_shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub FillSparseTensorCoo: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            data_mem_info: *const OrtMemoryInfo,
            values_shape: *const i64,
            values_shape_len: usize,
            values: *const ::std::os::raw::c_void,
            indices_data: *const i64,
            indices_num: usize,
        ) -> OrtStatusPtr,
    >,
    pub FillSparseTensorCsr: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            data_mem_info: *const OrtMemoryInfo,
            values_shape: *const i64,
            values_shape_len: usize,
            values: *const ::std::os::raw::c_void,
            inner_indices_data: *const i64,
            inner_indices_num: usize,
            outer_indices_data: *const i64,
            outer_indices_num: usize,
        ) -> OrtStatusPtr,
    >,
    pub FillSparseTensorBlockSparse: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            data_mem_info: *const OrtMemoryInfo,
            values_shape: *const i64,
            values_shape_len: usize,
            values: *const ::std::os::raw::c_void,
            indices_shape_data: *const i64,
            indices_shape_len: usize,
            indices_data: *const i32,
        ) -> OrtStatusPtr,
    >,
    pub CreateSparseTensorWithValuesAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtMemoryInfo,
            p_data: *mut ::std::os::raw::c_void,
            dense_shape: *const i64,
            dense_shape_len: usize,
            values_shape: *const i64,
            values_shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub UseCooIndices: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            indices_data: *mut i64,
            indices_num: usize,
        ) -> OrtStatusPtr,
    >,
    pub UseCsrIndices: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            inner_data: *mut i64,
            inner_num: usize,
            outer_data: *mut i64,
            outer_num: usize,
        ) -> OrtStatusPtr,
    >,
    pub UseBlockSparseIndices: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *mut OrtValue,
            indices_shape: *const i64,
            indices_shape_len: usize,
            indices_data: *mut i32,
        ) -> OrtStatusPtr,
    >,
    pub GetSparseTensorFormat: ::std::option::Option<
        unsafe extern "C" fn(ort_value: *const OrtValue, out: *mut OrtSparseFormat) -> OrtStatusPtr,
    >,
    pub GetSparseTensorValuesTypeAndShape: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *const OrtValue,
            out: *mut *mut OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetSparseTensorValues: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *const OrtValue,
            out: *mut *const ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub GetSparseTensorIndicesTypeShape: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *const OrtValue,
            indices_format: OrtSparseIndicesFormat,
            out: *mut *mut OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetSparseTensorIndices: ::std::option::Option<
        unsafe extern "C" fn(
            ort_value: *const OrtValue,
            indices_format: OrtSparseIndicesFormat,
            num_indices: *mut usize,
            indices: *mut *const ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub HasValue: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub KernelContext_GetGPUComputeStream: ::std::option::Option<
        unsafe extern "C" fn(
            context: *const OrtKernelContext,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            mem_info: *mut *const OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetExecutionProviderApi: ::std::option::Option<
        unsafe extern "C" fn(
            provider_name: *const ::std::os::raw::c_char,
            version: u32,
            provider_api: *mut *const ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsSetCustomCreateThreadFn: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            ort_custom_create_thread_fn: OrtCustomCreateThreadFn,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsSetCustomThreadCreationOptions: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            ort_custom_thread_creation_options: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsSetCustomJoinThreadFn: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            ort_custom_join_thread_fn: OrtCustomJoinThreadFn,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalCustomCreateThreadFn: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            ort_custom_create_thread_fn: OrtCustomCreateThreadFn,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalCustomThreadCreationOptions: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            ort_custom_thread_creation_options: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalCustomJoinThreadFn: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            ort_custom_join_thread_fn: OrtCustomJoinThreadFn,
        ) -> OrtStatusPtr,
    >,
    pub SynchronizeBoundInputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding) -> OrtStatusPtr>,
    pub SynchronizeBoundOutputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding) -> OrtStatusPtr>,
    pub SessionOptionsAppendExecutionProvider_CUDA_V2: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            cuda_options: *const OrtCUDAProviderOptionsV2,
        ) -> OrtStatusPtr,
    >,
    pub CreateCUDAProviderOptions: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtCUDAProviderOptionsV2) -> OrtStatusPtr,
    >,
    pub UpdateCUDAProviderOptions: ::std::option::Option<
        unsafe extern "C" fn(
            cuda_options: *mut OrtCUDAProviderOptionsV2,
            provider_options_keys: *const *const ::std::os::raw::c_char,
            provider_options_values: *const *const ::std::os::raw::c_char,
            num_keys: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetCUDAProviderOptionsAsString: ::std::option::Option<
        unsafe extern "C" fn(
            cuda_options: *const OrtCUDAProviderOptionsV2,
            allocator: *mut OrtAllocator,
            ptr: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    #[doc = " \\brief Release an ::OrtCUDAProviderOptionsV2"]
    #[doc = ""]
    #[doc = " \\note This is an exception in the naming convention of other Release* functions, as the name of the method does not have the V2 suffix, but the type does"]
    #[doc = ""]
    #[doc = " \\since Version 1.11."]
    pub ReleaseCUDAProviderOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtCUDAProviderOptionsV2)>,
    pub SessionOptionsAppendExecutionProvider_MIGraphX: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            migraphx_options: *const OrtMIGraphXProviderOptions,
        ) -> OrtStatusPtr,
    >,
}
#[test]
fn bindgen_test_layout_OrtApi() {
    assert_eq!(
        ::std::mem::size_of::<OrtApi>(),
        1680usize,
        concat!("Size of: ", stringify!(OrtApi))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtApi>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtApi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateStatus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetErrorCode as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetErrorCode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetErrorMessage as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetErrorMessage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateEnv as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithCustomLogger as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithCustomLogger)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableTelemetryEvents as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableTelemetryEvents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableTelemetryEvents as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableTelemetryEvents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSession as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSession)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSessionFromArray as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionFromArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).Run as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(Run)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSessionOptions as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetOptimizedModelFilePath as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetOptimizedModelFilePath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CloneSessionOptions as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CloneSessionOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetSessionExecutionMode as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionExecutionMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableProfiling as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableProfiling as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableMemPattern as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableMemPattern)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableMemPattern as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableMemPattern)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableCpuMemArena as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableCpuMemArena)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableCpuMemArena as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableCpuMemArena)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetSessionLogId as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionLogVerbosityLevel as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionLogSeverityLevel as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionGraphOptimizationLevel as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionGraphOptimizationLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetIntraOpNumThreads as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetIntraOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetInterOpNumThreads as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetInterOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateCustomOpDomain as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CustomOpDomain_Add as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CustomOpDomain_Add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddCustomOpDomain as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RegisterCustomOpsLibrary as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RegisterCustomOpsLibrary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputCount as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputCount as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerCount as *const _
                as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputTypeInfo as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputTypeInfo as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerTypeInfo as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputName as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputName as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerName as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateRunOptions as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateRunOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunLogVerbosityLevel as *const _
                as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunLogSeverityLevel as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunTag as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunTag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunLogVerbosityLevel as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunLogSeverityLevel as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunTag as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunTag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetTerminate as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetTerminate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsUnsetTerminate as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsUnsetTerminate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateTensorAsOrtValue as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorAsOrtValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateTensorWithDataAsOrtValue as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorWithDataAsOrtValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).IsTensor as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(IsTensor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorMutableData as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorMutableData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillStringTensor as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillStringTensor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetStringTensorDataLength as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorDataLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetStringTensorContent as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorContent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToTensorInfo as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToTensorInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetOnnxTypeFromTypeInfo as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetOnnxTypeFromTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateTensorTypeAndShapeInfo as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorTypeAndShapeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetTensorElementType as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetTensorElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetDimensions as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetDimensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorElementType as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetDimensionsCount as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDimensionsCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetDimensions as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDimensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSymbolicDimensions as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSymbolicDimensions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetTensorShapeElementCount as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorShapeElementCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorTypeAndShape as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorTypeAndShape)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTypeInfo as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValueType as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValueType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateMemoryInfo as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateCpuMemoryInfo as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateCpuMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CompareMemoryInfo as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CompareMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetName as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetId as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetMemType as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetMemType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetType as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorAlloc as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorAlloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorFree as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorFree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorGetInfo as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorGetInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetAllocatorWithDefaultOptions as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetAllocatorWithDefaultOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddFreeDimensionOverride as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddFreeDimensionOverride)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValue as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValueCount as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValueCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateValue as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateOpaqueValue as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateOpaqueValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetOpaqueValue as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetOpaqueValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_float as *const _ as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_float)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_int64 as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_int64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_string as *const _ as usize
        },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetInputCount as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetInputCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetOutputCount as *const _ as usize
        },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetOutputCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetInput as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetOutput as *const _ as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseEnv as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseEnv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseStatus as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseMemoryInfo as *const _ as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSession as *const _ as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSession)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseValue as *const _ as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseRunOptions as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseRunOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseTypeInfo as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseTensorTypeAndShapeInfo as *const _ as usize
        },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseTensorTypeAndShapeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSessionOptions as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSessionOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseCustomOpDomain as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetDenotationFromTypeInfo as *const _ as usize
        },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDenotationFromTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToMapTypeInfo as *const _ as usize
        },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToMapTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToSequenceTypeInfo as *const _ as usize
        },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToSequenceTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetMapKeyType as *const _ as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetMapKeyType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetMapValueType as *const _ as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetMapValueType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSequenceElementType as *const _ as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSequenceElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseMapTypeInfo as *const _ as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseMapTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSequenceTypeInfo as *const _ as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSequenceTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionEndProfiling as *const _ as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionEndProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetModelMetadata as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetModelMetadata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetProducerName as *const _ as usize
        },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetProducerName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetGraphName as *const _ as usize
        },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetGraphName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetDomain as *const _ as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetDomain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetDescription as *const _ as usize
        },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataLookupCustomMetadataMap as *const _
                as usize
        },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataLookupCustomMetadataMap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetVersion as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseModelMetadata as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseModelMetadata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithGlobalThreadPools as *const _ as usize
        },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithGlobalThreadPools)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisablePerSessionThreads as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisablePerSessionThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateThreadingOptions as *const _ as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateThreadingOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseThreadingOptions as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseThreadingOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetCustomMetadataMapKeys as *const _
                as usize
        },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetCustomMetadataMapKeys)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).AddFreeDimensionOverrideByName as *const _ as usize
        },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddFreeDimensionOverrideByName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetAvailableProviders as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetAvailableProviders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseAvailableProviders as *const _ as usize
        },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseAvailableProviders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetStringTensorElementLength as *const _ as usize
        },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorElementLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetStringTensorElement as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorElement)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillStringTensorElement as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillStringTensorElement)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddSessionConfigEntry as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddSessionConfigEntry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateAllocator as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseAllocator as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunWithBinding as *const _ as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunWithBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateIoBinding as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateIoBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseIoBinding as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseIoBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindInput as *const _ as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindOutput as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindOutputToDevice as *const _ as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindOutputToDevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetBoundOutputNames as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetBoundOutputNames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetBoundOutputValues as *const _ as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetBoundOutputValues)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ClearBoundInputs as *const _ as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ClearBoundInputs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ClearBoundOutputs as *const _ as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ClearBoundOutputs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).TensorAt as *const _ as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(TensorAt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateAndRegisterAllocator as *const _ as usize
        },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateAndRegisterAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetLanguageProjection as *const _ as usize },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetLanguageProjection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetProfilingStartTimeNs as *const _ as usize
        },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetProfilingStartTimeNs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalIntraOpNumThreads as *const _ as usize
        },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalIntraOpNumThreads)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalInterOpNumThreads as *const _ as usize
        },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalInterOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetGlobalSpinControl as *const _ as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalSpinControl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddInitializer as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddInitializer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithCustomLoggerAndGlobalThreadPools
                as *const _ as usize
        },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithCustomLoggerAndGlobalThreadPools)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_CUDA
                as *const _ as usize
        },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_CUDA)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_ROCM
                as *const _ as usize
        },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_ROCM)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_OpenVINO
                as *const _ as usize
        },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_OpenVINO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetGlobalDenormalAsZero as *const _ as usize },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalDenormalAsZero)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateArenaCfg as *const _ as usize },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateArenaCfg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseArenaCfg as *const _ as usize },
        1256usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseArenaCfg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetGraphDescription as *const _ as usize
        },
        1264usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetGraphDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_TensorRT
                as *const _ as usize
        },
        1272usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_TensorRT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetCurrentGpuDeviceId as *const _ as usize },
        1280usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetCurrentGpuDeviceId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetCurrentGpuDeviceId as *const _ as usize },
        1288usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetCurrentGpuDeviceId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttributeArray_float as *const _
                as usize
        },
        1296usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttributeArray_float)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttributeArray_int64 as *const _
                as usize
        },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttributeArray_int64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateArenaCfgV2 as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateArenaCfgV2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddRunConfigEntry as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddRunConfigEntry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreatePrepackedWeightsContainer as *const _ as usize
        },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreatePrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleasePrepackedWeightsContainer as *const _ as usize
        },
        1336usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleasePrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSessionWithPrepackedWeightsContainer
                as *const _ as usize
        },
        1344usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionWithPrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSessionFromArrayWithPrepackedWeightsContainer
                as *const _ as usize
        },
        1352usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionFromArrayWithPrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_TensorRT_V2
                as *const _ as usize
        },
        1360usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_TensorRT_V2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateTensorRTProviderOptions as *const _ as usize
        },
        1368usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorRTProviderOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).UpdateTensorRTProviderOptions as *const _ as usize
        },
        1376usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UpdateTensorRTProviderOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetTensorRTProviderOptionsAsString as *const _
                as usize
        },
        1384usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorRTProviderOptionsAsString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseTensorRTProviderOptions as *const _ as usize
        },
        1392usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseTensorRTProviderOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableOrtCustomOps as *const _ as usize },
        1400usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableOrtCustomOps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RegisterAllocator as *const _ as usize },
        1408usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RegisterAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).UnregisterAllocator as *const _ as usize },
        1416usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UnregisterAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).IsSparseTensor as *const _ as usize },
        1424usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(IsSparseTensor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSparseTensorAsOrtValue as *const _ as usize
        },
        1432usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSparseTensorAsOrtValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillSparseTensorCoo as *const _ as usize },
        1440usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillSparseTensorCoo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillSparseTensorCsr as *const _ as usize },
        1448usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillSparseTensorCsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).FillSparseTensorBlockSparse as *const _ as usize
        },
        1456usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillSparseTensorBlockSparse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSparseTensorWithValuesAsOrtValue as *const _
                as usize
        },
        1464usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSparseTensorWithValuesAsOrtValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).UseCooIndices as *const _ as usize },
        1472usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UseCooIndices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).UseCsrIndices as *const _ as usize },
        1480usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UseCsrIndices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).UseBlockSparseIndices as *const _ as usize },
        1488usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UseBlockSparseIndices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSparseTensorFormat as *const _ as usize },
        1496usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSparseTensorFormat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetSparseTensorValuesTypeAndShape as *const _
                as usize
        },
        1504usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSparseTensorValuesTypeAndShape)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSparseTensorValues as *const _ as usize },
        1512usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSparseTensorValues)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetSparseTensorIndicesTypeShape as *const _ as usize
        },
        1520usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSparseTensorIndicesTypeShape)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSparseTensorIndices as *const _ as usize },
        1528usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSparseTensorIndices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).HasValue as *const _ as usize },
        1536usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(HasValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetGPUComputeStream as *const _
                as usize
        },
        1544usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetGPUComputeStream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorMemoryInfo as *const _ as usize },
        1552usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetExecutionProviderApi as *const _ as usize },
        1560usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetExecutionProviderApi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsSetCustomCreateThreadFn as *const _
                as usize
        },
        1568usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsSetCustomCreateThreadFn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsSetCustomThreadCreationOptions
                as *const _ as usize
        },
        1576usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsSetCustomThreadCreationOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsSetCustomJoinThreadFn as *const _
                as usize
        },
        1584usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsSetCustomJoinThreadFn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalCustomCreateThreadFn as *const _ as usize
        },
        1592usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalCustomCreateThreadFn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalCustomThreadCreationOptions as *const _
                as usize
        },
        1600usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalCustomThreadCreationOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalCustomJoinThreadFn as *const _ as usize
        },
        1608usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalCustomJoinThreadFn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SynchronizeBoundInputs as *const _ as usize },
        1616usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SynchronizeBoundInputs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SynchronizeBoundOutputs as *const _ as usize },
        1624usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SynchronizeBoundOutputs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_CUDA_V2
                as *const _ as usize
        },
        1632usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_CUDA_V2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateCUDAProviderOptions as *const _ as usize
        },
        1640usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateCUDAProviderOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).UpdateCUDAProviderOptions as *const _ as usize
        },
        1648usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(UpdateCUDAProviderOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetCUDAProviderOptionsAsString as *const _ as usize
        },
        1656usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetCUDAProviderOptionsAsString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseCUDAProviderOptions as *const _ as usize
        },
        1664usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseCUDAProviderOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_MIGraphX
                as *const _ as usize
        },
        1672usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_MIGraphX)
        )
    );
}
pub const OrtCustomOpInputOutputCharacteristic_INPUT_OUTPUT_REQUIRED:
    OrtCustomOpInputOutputCharacteristic = 0;
pub const OrtCustomOpInputOutputCharacteristic_INPUT_OUTPUT_OPTIONAL:
    OrtCustomOpInputOutputCharacteristic = 1;
pub type OrtCustomOpInputOutputCharacteristic = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCustomOp {
    pub version: u32,
    pub CreateKernel: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            api: *const OrtApi,
            info: *const OrtKernelInfo,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub GetName: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp) -> *const ::std::os::raw::c_char,
    >,
    pub GetExecutionProviderType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp) -> *const ::std::os::raw::c_char,
    >,
    pub GetInputType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp, index: usize) -> ONNXTensorElementDataType,
    >,
    pub GetInputTypeCount:
        ::std::option::Option<unsafe extern "C" fn(op: *const OrtCustomOp) -> usize>,
    pub GetOutputType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp, index: usize) -> ONNXTensorElementDataType,
    >,
    pub GetOutputTypeCount:
        ::std::option::Option<unsafe extern "C" fn(op: *const OrtCustomOp) -> usize>,
    pub KernelCompute: ::std::option::Option<
        unsafe extern "C" fn(
            op_kernel: *mut ::std::os::raw::c_void,
            context: *mut OrtKernelContext,
        ),
    >,
    pub KernelDestroy:
        ::std::option::Option<unsafe extern "C" fn(op_kernel: *mut ::std::os::raw::c_void)>,
    pub GetInputCharacteristic: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            index: usize,
        ) -> OrtCustomOpInputOutputCharacteristic,
    >,
    pub GetOutputCharacteristic: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            index: usize,
        ) -> OrtCustomOpInputOutputCharacteristic,
    >,
}
#[test]
fn bindgen_test_layout_OrtCustomOp() {
    assert_eq!(
        ::std::mem::size_of::<OrtCustomOp>(),
        96usize,
        concat!("Size of: ", stringify!(OrtCustomOp))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtCustomOp>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtCustomOp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).CreateKernel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(CreateKernel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetName as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetExecutionProviderType as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetExecutionProviderType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetInputType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetInputTypeCount as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputTypeCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputType as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputTypeCount as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputTypeCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).KernelCompute as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(KernelCompute)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).KernelDestroy as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(KernelDestroy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetInputCharacteristic as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputCharacteristic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputCharacteristic as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputCharacteristic)
        )
    );
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
pub type __uint128_t = u128;
extern crate libloading;
pub struct onnxruntime {
    __library: ::libloading::Library,
    pub signal: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ) -> ::std::option::Option<
            unsafe extern "C" fn(
                arg1: ::std::os::raw::c_int,
                arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
            ),
        >,
        ::libloading::Error,
    >,
    pub getpriority: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub getiopolicy_np: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub getrlimit: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut rlimit,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub getrusage: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut rusage,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub setpriority: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: id_t,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub setiopolicy_np: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub setrlimit: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *const rlimit,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub wait: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_int) -> pid_t,
        ::libloading::Error,
    >,
    pub waitpid: Result<
        unsafe extern "C" fn(
            arg1: pid_t,
            arg2: *mut ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
        ) -> pid_t,
        ::libloading::Error,
    >,
    pub waitid: Result<
        unsafe extern "C" fn(
            arg1: idtype_t,
            arg2: id_t,
            arg3: *mut siginfo_t,
            arg4: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub wait3: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
            arg3: *mut rusage,
        ) -> pid_t,
        ::libloading::Error,
    >,
    pub wait4: Result<
        unsafe extern "C" fn(
            arg1: pid_t,
            arg2: *mut ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut rusage,
        ) -> pid_t,
        ::libloading::Error,
    >,
    pub alloca: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub malloc: Result<
        unsafe extern "C" fn(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub calloc: Result<
        unsafe extern "C" fn(
            __count: ::std::os::raw::c_ulong,
            __size: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub free: Result<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void), ::libloading::Error>,
    pub realloc: Result<
        unsafe extern "C" fn(
            __ptr: *mut ::std::os::raw::c_void,
            __size: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub valloc: Result<
        unsafe extern "C" fn(arg1: usize) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub aligned_alloc: Result<
        unsafe extern "C" fn(
            __alignment: ::std::os::raw::c_ulong,
            __size: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub posix_memalign: Result<
        unsafe extern "C" fn(
            __memptr: *mut *mut ::std::os::raw::c_void,
            __alignment: usize,
            __size: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub abort: Result<unsafe extern "C" fn(), ::libloading::Error>,
    pub abs: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub atexit: Result<
        unsafe extern "C" fn(
            arg1: ::std::option::Option<unsafe extern "C" fn()>,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub atof: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> f64,
        ::libloading::Error,
    >,
    pub atoi: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub atol: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub atoll: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong,
        ::libloading::Error,
    >,
    pub bsearch: Result<
        unsafe extern "C" fn(
            __key: *const ::std::os::raw::c_void,
            __base: *const ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub div: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t,
        ::libloading::Error,
    >,
    pub exit: Result<unsafe extern "C" fn(arg1: ::std::os::raw::c_int), ::libloading::Error>,
    pub getenv: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub labs: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub ldiv: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t,
        ::libloading::Error,
    >,
    pub llabs: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong,
        ::libloading::Error,
    >,
    pub lldiv: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_longlong,
            arg2: ::std::os::raw::c_longlong,
        ) -> lldiv_t,
        ::libloading::Error,
    >,
    pub mblen: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __n: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub mbstowcs: Result<
        unsafe extern "C" fn(
            arg1: *mut wchar_t,
            arg2: *const ::std::os::raw::c_char,
            arg3: usize,
        ) -> usize,
        ::libloading::Error,
    >,
    pub mbtowc: Result<
        unsafe extern "C" fn(
            arg1: *mut wchar_t,
            arg2: *const ::std::os::raw::c_char,
            arg3: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub qsort: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ),
        ::libloading::Error,
    >,
    pub rand: Result<unsafe extern "C" fn() -> ::std::os::raw::c_int, ::libloading::Error>,
    pub srand: Result<unsafe extern "C" fn(arg1: ::std::os::raw::c_uint), ::libloading::Error>,
    pub strtod: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
        ) -> f64,
        ::libloading::Error,
    >,
    pub strtof: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
        ) -> f32,
        ::libloading::Error,
    >,
    pub strtol: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub strtold: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
        ) -> f64,
        ::libloading::Error,
    >,
    pub strtoll: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_longlong,
        ::libloading::Error,
    >,
    pub strtoul: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strtoull: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_ulonglong,
        ::libloading::Error,
    >,
    pub system: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub wcstombs: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: *const wchar_t,
            arg3: usize,
        ) -> usize,
        ::libloading::Error,
    >,
    pub wctomb: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: wchar_t,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub _Exit: Result<unsafe extern "C" fn(arg1: ::std::os::raw::c_int), ::libloading::Error>,
    pub a64l: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub drand48: Result<unsafe extern "C" fn() -> f64, ::libloading::Error>,
    pub ecvt: Result<
        unsafe extern "C" fn(
            arg1: f64,
            arg2: ::std::os::raw::c_int,
            arg3: *mut ::std::os::raw::c_int,
            arg4: *mut ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub erand48: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_ushort) -> f64,
        ::libloading::Error,
    >,
    pub fcvt: Result<
        unsafe extern "C" fn(
            arg1: f64,
            arg2: ::std::os::raw::c_int,
            arg3: *mut ::std::os::raw::c_int,
            arg4: *mut ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub gcvt: Result<
        unsafe extern "C" fn(
            arg1: f64,
            arg2: ::std::os::raw::c_int,
            arg3: *mut ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub getsubopt: Result<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_char,
            arg2: *const *mut ::std::os::raw::c_char,
            arg3: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub grantpt: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub initstate: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_uint,
            arg2: *mut ::std::os::raw::c_char,
            arg3: usize,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub jrand48: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub l64a: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub lcong48:
        Result<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_ushort), ::libloading::Error>,
    pub lrand48: Result<unsafe extern "C" fn() -> ::std::os::raw::c_long, ::libloading::Error>,
    pub mktemp: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub mkstemp: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub mrand48: Result<unsafe extern "C" fn() -> ::std::os::raw::c_long, ::libloading::Error>,
    pub nrand48: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long,
        ::libloading::Error,
    >,
    pub posix_openpt: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub ptsname: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub ptsname_r: Result<
        unsafe extern "C" fn(
            fildes: ::std::os::raw::c_int,
            buffer: *mut ::std::os::raw::c_char,
            buflen: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub putenv: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub random: Result<unsafe extern "C" fn() -> ::std::os::raw::c_long, ::libloading::Error>,
    pub rand_r: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub realpath: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *mut ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub seed48: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort,
        ::libloading::Error,
    >,
    pub setenv: Result<
        unsafe extern "C" fn(
            __name: *const ::std::os::raw::c_char,
            __value: *const ::std::os::raw::c_char,
            __overwrite: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub setkey:
        Result<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char), ::libloading::Error>,
    pub setstate: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub srand48: Result<unsafe extern "C" fn(arg1: ::std::os::raw::c_long), ::libloading::Error>,
    pub srandom: Result<unsafe extern "C" fn(arg1: ::std::os::raw::c_uint), ::libloading::Error>,
    pub unlockpt: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub unsetenv: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub arc4random: Result<unsafe extern "C" fn() -> u32, ::libloading::Error>,
    pub arc4random_addrandom: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int),
        ::libloading::Error,
    >,
    pub arc4random_buf: Result<
        unsafe extern "C" fn(__buf: *mut ::std::os::raw::c_void, __nbytes: usize),
        ::libloading::Error,
    >,
    pub arc4random_stir: Result<unsafe extern "C" fn(), ::libloading::Error>,
    pub arc4random_uniform:
        Result<unsafe extern "C" fn(__upper_bound: u32) -> u32, ::libloading::Error>,
    pub atexit_b: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub bsearch_b: Result<
        unsafe extern "C" fn(
            __key: *const ::std::os::raw::c_void,
            __base: *const ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: *mut ::std::os::raw::c_void,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub cgetcap: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub cgetclose: Result<unsafe extern "C" fn() -> ::std::os::raw::c_int, ::libloading::Error>,
    pub cgetent: Result<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
            arg3: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetfirst: Result<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetmatch: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetnext: Result<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_char,
            arg2: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetnum: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut ::std::os::raw::c_long,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetset: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetstr: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub cgetustr: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub daemon: Result<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub devname: Result<
        unsafe extern "C" fn(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub devname_r: Result<
        unsafe extern "C" fn(
            arg1: dev_t,
            arg2: mode_t,
            buf: *mut ::std::os::raw::c_char,
            len: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub getbsize: Result<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_int,
            arg2: *mut ::std::os::raw::c_long,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub getloadavg: Result<
        unsafe extern "C" fn(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub getprogname:
        Result<unsafe extern "C" fn() -> *const ::std::os::raw::c_char, ::libloading::Error>,
    pub setprogname:
        Result<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char), ::libloading::Error>,
    pub heapsort: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub heapsort_b: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub mergesort: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub mergesort_b: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub psort: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ),
        ::libloading::Error,
    >,
    pub psort_b: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: *mut ::std::os::raw::c_void,
        ),
        ::libloading::Error,
    >,
    pub psort_r: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            arg1: *mut ::std::os::raw::c_void,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *mut ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                    arg3: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ),
        ::libloading::Error,
    >,
    pub qsort_b: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            __compar: *mut ::std::os::raw::c_void,
        ),
        ::libloading::Error,
    >,
    pub qsort_r: Result<
        unsafe extern "C" fn(
            __base: *mut ::std::os::raw::c_void,
            __nel: usize,
            __width: usize,
            arg1: *mut ::std::os::raw::c_void,
            __compar: ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *mut ::std::os::raw::c_void,
                    arg2: *const ::std::os::raw::c_void,
                    arg3: *const ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
        ),
        ::libloading::Error,
    >,
    pub radixsort: Result<
        unsafe extern "C" fn(
            __base: *mut *const ::std::os::raw::c_uchar,
            __nel: ::std::os::raw::c_int,
            __table: *const ::std::os::raw::c_uchar,
            __endbyte: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub rpmatch: Result<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub sradixsort: Result<
        unsafe extern "C" fn(
            __base: *mut *const ::std::os::raw::c_uchar,
            __nel: ::std::os::raw::c_int,
            __table: *const ::std::os::raw::c_uchar,
            __endbyte: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub sranddev: Result<unsafe extern "C" fn(), ::libloading::Error>,
    pub srandomdev: Result<unsafe extern "C" fn(), ::libloading::Error>,
    pub reallocf: Result<
        unsafe extern "C" fn(
            __ptr: *mut ::std::os::raw::c_void,
            __size: usize,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub strtonum: Result<
        unsafe extern "C" fn(
            __numstr: *const ::std::os::raw::c_char,
            __minval: ::std::os::raw::c_longlong,
            __maxval: ::std::os::raw::c_longlong,
            __errstrp: *mut *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_longlong,
        ::libloading::Error,
    >,
    pub strtoq: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_longlong,
        ::libloading::Error,
    >,
    pub strtouq: Result<
        unsafe extern "C" fn(
            __str: *const ::std::os::raw::c_char,
            __endptr: *mut *mut ::std::os::raw::c_char,
            __base: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_ulonglong,
        ::libloading::Error,
    >,
    pub memchr: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_void,
            __c: ::std::os::raw::c_int,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub memcmp: Result<
        unsafe extern "C" fn(
            __s1: *const ::std::os::raw::c_void,
            __s2: *const ::std::os::raw::c_void,
            __n: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub memcpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_void,
            __src: *const ::std::os::raw::c_void,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub memmove: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_void,
            __src: *const ::std::os::raw::c_void,
            __len: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub memset: Result<
        unsafe extern "C" fn(
            __b: *mut ::std::os::raw::c_void,
            __c: ::std::os::raw::c_int,
            __len: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub strcat: Result<
        unsafe extern "C" fn(
            __s1: *mut ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strchr: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __c: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strcmp: Result<
        unsafe extern "C" fn(
            __s1: *const ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strcoll: Result<
        unsafe extern "C" fn(
            __s1: *const ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strcpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __src: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strcspn: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __charset: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strerror: Result<
        unsafe extern "C" fn(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strlen: Result<
        unsafe extern "C" fn(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strncat: Result<
        unsafe extern "C" fn(
            __s1: *mut ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strncmp: Result<
        unsafe extern "C" fn(
            __s1: *const ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strncpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __src: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strpbrk: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __charset: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strrchr: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __c: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strspn: Result<
        unsafe extern "C" fn(
            __s: *const ::std::os::raw::c_char,
            __charset: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strstr: Result<
        unsafe extern "C" fn(
            __big: *const ::std::os::raw::c_char,
            __little: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strtok: Result<
        unsafe extern "C" fn(
            __str: *mut ::std::os::raw::c_char,
            __sep: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strxfrm: Result<
        unsafe extern "C" fn(
            __s1: *mut ::std::os::raw::c_char,
            __s2: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strtok_r: Result<
        unsafe extern "C" fn(
            __str: *mut ::std::os::raw::c_char,
            __sep: *const ::std::os::raw::c_char,
            __lasts: *mut *mut ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strerror_r: Result<
        unsafe extern "C" fn(
            __errnum: ::std::os::raw::c_int,
            __strerrbuf: *mut ::std::os::raw::c_char,
            __buflen: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strdup: Result<
        unsafe extern "C" fn(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub memccpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_void,
            __src: *const ::std::os::raw::c_void,
            __c: ::std::os::raw::c_int,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub stpcpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __src: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub stpncpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __src: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strndup: Result<
        unsafe extern "C" fn(
            __s1: *const ::std::os::raw::c_char,
            __n: ::std::os::raw::c_ulong,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strnlen: Result<
        unsafe extern "C" fn(__s1: *const ::std::os::raw::c_char, __n: usize) -> usize,
        ::libloading::Error,
    >,
    pub strsignal: Result<
        unsafe extern "C" fn(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub memset_s: Result<
        unsafe extern "C" fn(
            __s: *mut ::std::os::raw::c_void,
            __smax: rsize_t,
            __c: ::std::os::raw::c_int,
            __n: rsize_t,
        ) -> errno_t,
        ::libloading::Error,
    >,
    pub memmem: Result<
        unsafe extern "C" fn(
            __big: *const ::std::os::raw::c_void,
            __big_len: usize,
            __little: *const ::std::os::raw::c_void,
            __little_len: usize,
        ) -> *mut ::std::os::raw::c_void,
        ::libloading::Error,
    >,
    pub memset_pattern4: Result<
        unsafe extern "C" fn(
            __b: *mut ::std::os::raw::c_void,
            __pattern4: *const ::std::os::raw::c_void,
            __len: usize,
        ),
        ::libloading::Error,
    >,
    pub memset_pattern8: Result<
        unsafe extern "C" fn(
            __b: *mut ::std::os::raw::c_void,
            __pattern8: *const ::std::os::raw::c_void,
            __len: usize,
        ),
        ::libloading::Error,
    >,
    pub memset_pattern16: Result<
        unsafe extern "C" fn(
            __b: *mut ::std::os::raw::c_void,
            __pattern16: *const ::std::os::raw::c_void,
            __len: usize,
        ),
        ::libloading::Error,
    >,
    pub strcasestr: Result<
        unsafe extern "C" fn(
            __big: *const ::std::os::raw::c_char,
            __little: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strnstr: Result<
        unsafe extern "C" fn(
            __big: *const ::std::os::raw::c_char,
            __little: *const ::std::os::raw::c_char,
            __len: usize,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub strlcat: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __source: *const ::std::os::raw::c_char,
            __size: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strlcpy: Result<
        unsafe extern "C" fn(
            __dst: *mut ::std::os::raw::c_char,
            __source: *const ::std::os::raw::c_char,
            __size: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_ulong,
        ::libloading::Error,
    >,
    pub strmode: Result<
        unsafe extern "C" fn(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char),
        ::libloading::Error,
    >,
    pub strsep: Result<
        unsafe extern "C" fn(
            __stringp: *mut *mut ::std::os::raw::c_char,
            __delim: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub swab: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_void,
            arg3: isize,
        ),
        ::libloading::Error,
    >,
    pub timingsafe_bcmp: Result<
        unsafe extern "C" fn(
            __b1: *const ::std::os::raw::c_void,
            __b2: *const ::std::os::raw::c_void,
            __len: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strsignal_r: Result<
        unsafe extern "C" fn(
            __sig: ::std::os::raw::c_int,
            __strsignalbuf: *mut ::std::os::raw::c_char,
            __buflen: usize,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub bcmp: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub bcopy: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_void,
            arg3: usize,
        ),
        ::libloading::Error,
    >,
    pub bzero: Result<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong),
        ::libloading::Error,
    >,
    pub index: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub rindex: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_char,
        ::libloading::Error,
    >,
    pub ffs: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strcasecmp: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub strncasecmp: Result<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_ulong,
        ) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub ffsl: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub ffsll: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub fls: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub flsl: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub flsll: Result<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int,
        ::libloading::Error,
    >,
    pub OrtGetApiBase: Result<unsafe extern "C" fn() -> *const OrtApiBase, ::libloading::Error>,
    pub OrtSessionOptionsAppendExecutionProvider_CUDA: Result<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            device_id: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
        ::libloading::Error,
    >,
    pub OrtSessionOptionsAppendExecutionProvider_MIGraphX: Result<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            device_id: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
        ::libloading::Error,
    >,
}
impl onnxruntime {
    pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
    where
        P: AsRef<::std::ffi::OsStr>,
    {
        let library = ::libloading::Library::new(path)?;
        Self::from_library(library)
    }
    pub unsafe fn from_library<L>(library: L) -> Result<Self, ::libloading::Error>
    where
        L: Into<::libloading::Library>,
    {
        let __library = library.into();
        let signal = __library.get(b"signal\0").map(|sym| *sym);
        let getpriority = __library.get(b"getpriority\0").map(|sym| *sym);
        let getiopolicy_np = __library.get(b"getiopolicy_np\0").map(|sym| *sym);
        let getrlimit = __library.get(b"getrlimit\0").map(|sym| *sym);
        let getrusage = __library.get(b"getrusage\0").map(|sym| *sym);
        let setpriority = __library.get(b"setpriority\0").map(|sym| *sym);
        let setiopolicy_np = __library.get(b"setiopolicy_np\0").map(|sym| *sym);
        let setrlimit = __library.get(b"setrlimit\0").map(|sym| *sym);
        let wait = __library.get(b"wait\0").map(|sym| *sym);
        let waitpid = __library.get(b"waitpid\0").map(|sym| *sym);
        let waitid = __library.get(b"waitid\0").map(|sym| *sym);
        let wait3 = __library.get(b"wait3\0").map(|sym| *sym);
        let wait4 = __library.get(b"wait4\0").map(|sym| *sym);
        let alloca = __library.get(b"alloca\0").map(|sym| *sym);
        let malloc = __library.get(b"malloc\0").map(|sym| *sym);
        let calloc = __library.get(b"calloc\0").map(|sym| *sym);
        let free = __library.get(b"free\0").map(|sym| *sym);
        let realloc = __library.get(b"realloc\0").map(|sym| *sym);
        let valloc = __library.get(b"valloc\0").map(|sym| *sym);
        let aligned_alloc = __library.get(b"aligned_alloc\0").map(|sym| *sym);
        let posix_memalign = __library.get(b"posix_memalign\0").map(|sym| *sym);
        let abort = __library.get(b"abort\0").map(|sym| *sym);
        let abs = __library.get(b"abs\0").map(|sym| *sym);
        let atexit = __library.get(b"atexit\0").map(|sym| *sym);
        let atof = __library.get(b"atof\0").map(|sym| *sym);
        let atoi = __library.get(b"atoi\0").map(|sym| *sym);
        let atol = __library.get(b"atol\0").map(|sym| *sym);
        let atoll = __library.get(b"atoll\0").map(|sym| *sym);
        let bsearch = __library.get(b"bsearch\0").map(|sym| *sym);
        let div = __library.get(b"div\0").map(|sym| *sym);
        let exit = __library.get(b"exit\0").map(|sym| *sym);
        let getenv = __library.get(b"getenv\0").map(|sym| *sym);
        let labs = __library.get(b"labs\0").map(|sym| *sym);
        let ldiv = __library.get(b"ldiv\0").map(|sym| *sym);
        let llabs = __library.get(b"llabs\0").map(|sym| *sym);
        let lldiv = __library.get(b"lldiv\0").map(|sym| *sym);
        let mblen = __library.get(b"mblen\0").map(|sym| *sym);
        let mbstowcs = __library.get(b"mbstowcs\0").map(|sym| *sym);
        let mbtowc = __library.get(b"mbtowc\0").map(|sym| *sym);
        let qsort = __library.get(b"qsort\0").map(|sym| *sym);
        let rand = __library.get(b"rand\0").map(|sym| *sym);
        let srand = __library.get(b"srand\0").map(|sym| *sym);
        let strtod = __library.get(b"strtod\0").map(|sym| *sym);
        let strtof = __library.get(b"strtof\0").map(|sym| *sym);
        let strtol = __library.get(b"strtol\0").map(|sym| *sym);
        let strtold = __library.get(b"strtold\0").map(|sym| *sym);
        let strtoll = __library.get(b"strtoll\0").map(|sym| *sym);
        let strtoul = __library.get(b"strtoul\0").map(|sym| *sym);
        let strtoull = __library.get(b"strtoull\0").map(|sym| *sym);
        let system = __library.get(b"system\0").map(|sym| *sym);
        let wcstombs = __library.get(b"wcstombs\0").map(|sym| *sym);
        let wctomb = __library.get(b"wctomb\0").map(|sym| *sym);
        let _Exit = __library.get(b"_Exit\0").map(|sym| *sym);
        let a64l = __library.get(b"a64l\0").map(|sym| *sym);
        let drand48 = __library.get(b"drand48\0").map(|sym| *sym);
        let ecvt = __library.get(b"ecvt\0").map(|sym| *sym);
        let erand48 = __library.get(b"erand48\0").map(|sym| *sym);
        let fcvt = __library.get(b"fcvt\0").map(|sym| *sym);
        let gcvt = __library.get(b"gcvt\0").map(|sym| *sym);
        let getsubopt = __library.get(b"getsubopt\0").map(|sym| *sym);
        let grantpt = __library.get(b"grantpt\0").map(|sym| *sym);
        let initstate = __library.get(b"initstate\0").map(|sym| *sym);
        let jrand48 = __library.get(b"jrand48\0").map(|sym| *sym);
        let l64a = __library.get(b"l64a\0").map(|sym| *sym);
        let lcong48 = __library.get(b"lcong48\0").map(|sym| *sym);
        let lrand48 = __library.get(b"lrand48\0").map(|sym| *sym);
        let mktemp = __library.get(b"mktemp\0").map(|sym| *sym);
        let mkstemp = __library.get(b"mkstemp\0").map(|sym| *sym);
        let mrand48 = __library.get(b"mrand48\0").map(|sym| *sym);
        let nrand48 = __library.get(b"nrand48\0").map(|sym| *sym);
        let posix_openpt = __library.get(b"posix_openpt\0").map(|sym| *sym);
        let ptsname = __library.get(b"ptsname\0").map(|sym| *sym);
        let ptsname_r = __library.get(b"ptsname_r\0").map(|sym| *sym);
        let putenv = __library.get(b"putenv\0").map(|sym| *sym);
        let random = __library.get(b"random\0").map(|sym| *sym);
        let rand_r = __library.get(b"rand_r\0").map(|sym| *sym);
        let realpath = __library.get(b"realpath\0").map(|sym| *sym);
        let seed48 = __library.get(b"seed48\0").map(|sym| *sym);
        let setenv = __library.get(b"setenv\0").map(|sym| *sym);
        let setkey = __library.get(b"setkey\0").map(|sym| *sym);
        let setstate = __library.get(b"setstate\0").map(|sym| *sym);
        let srand48 = __library.get(b"srand48\0").map(|sym| *sym);
        let srandom = __library.get(b"srandom\0").map(|sym| *sym);
        let unlockpt = __library.get(b"unlockpt\0").map(|sym| *sym);
        let unsetenv = __library.get(b"unsetenv\0").map(|sym| *sym);
        let arc4random = __library.get(b"arc4random\0").map(|sym| *sym);
        let arc4random_addrandom = __library.get(b"arc4random_addrandom\0").map(|sym| *sym);
        let arc4random_buf = __library.get(b"arc4random_buf\0").map(|sym| *sym);
        let arc4random_stir = __library.get(b"arc4random_stir\0").map(|sym| *sym);
        let arc4random_uniform = __library.get(b"arc4random_uniform\0").map(|sym| *sym);
        let atexit_b = __library.get(b"atexit_b\0").map(|sym| *sym);
        let bsearch_b = __library.get(b"bsearch_b\0").map(|sym| *sym);
        let cgetcap = __library.get(b"cgetcap\0").map(|sym| *sym);
        let cgetclose = __library.get(b"cgetclose\0").map(|sym| *sym);
        let cgetent = __library.get(b"cgetent\0").map(|sym| *sym);
        let cgetfirst = __library.get(b"cgetfirst\0").map(|sym| *sym);
        let cgetmatch = __library.get(b"cgetmatch\0").map(|sym| *sym);
        let cgetnext = __library.get(b"cgetnext\0").map(|sym| *sym);
        let cgetnum = __library.get(b"cgetnum\0").map(|sym| *sym);
        let cgetset = __library.get(b"cgetset\0").map(|sym| *sym);
        let cgetstr = __library.get(b"cgetstr\0").map(|sym| *sym);
        let cgetustr = __library.get(b"cgetustr\0").map(|sym| *sym);
        let daemon = __library.get(b"daemon\0").map(|sym| *sym);
        let devname = __library.get(b"devname\0").map(|sym| *sym);
        let devname_r = __library.get(b"devname_r\0").map(|sym| *sym);
        let getbsize = __library.get(b"getbsize\0").map(|sym| *sym);
        let getloadavg = __library.get(b"getloadavg\0").map(|sym| *sym);
        let getprogname = __library.get(b"getprogname\0").map(|sym| *sym);
        let setprogname = __library.get(b"setprogname\0").map(|sym| *sym);
        let heapsort = __library.get(b"heapsort\0").map(|sym| *sym);
        let heapsort_b = __library.get(b"heapsort_b\0").map(|sym| *sym);
        let mergesort = __library.get(b"mergesort\0").map(|sym| *sym);
        let mergesort_b = __library.get(b"mergesort_b\0").map(|sym| *sym);
        let psort = __library.get(b"psort\0").map(|sym| *sym);
        let psort_b = __library.get(b"psort_b\0").map(|sym| *sym);
        let psort_r = __library.get(b"psort_r\0").map(|sym| *sym);
        let qsort_b = __library.get(b"qsort_b\0").map(|sym| *sym);
        let qsort_r = __library.get(b"qsort_r\0").map(|sym| *sym);
        let radixsort = __library.get(b"radixsort\0").map(|sym| *sym);
        let rpmatch = __library.get(b"rpmatch\0").map(|sym| *sym);
        let sradixsort = __library.get(b"sradixsort\0").map(|sym| *sym);
        let sranddev = __library.get(b"sranddev\0").map(|sym| *sym);
        let srandomdev = __library.get(b"srandomdev\0").map(|sym| *sym);
        let reallocf = __library.get(b"reallocf\0").map(|sym| *sym);
        let strtonum = __library.get(b"strtonum\0").map(|sym| *sym);
        let strtoq = __library.get(b"strtoq\0").map(|sym| *sym);
        let strtouq = __library.get(b"strtouq\0").map(|sym| *sym);
        let memchr = __library.get(b"memchr\0").map(|sym| *sym);
        let memcmp = __library.get(b"memcmp\0").map(|sym| *sym);
        let memcpy = __library.get(b"memcpy\0").map(|sym| *sym);
        let memmove = __library.get(b"memmove\0").map(|sym| *sym);
        let memset = __library.get(b"memset\0").map(|sym| *sym);
        let strcat = __library.get(b"strcat\0").map(|sym| *sym);
        let strchr = __library.get(b"strchr\0").map(|sym| *sym);
        let strcmp = __library.get(b"strcmp\0").map(|sym| *sym);
        let strcoll = __library.get(b"strcoll\0").map(|sym| *sym);
        let strcpy = __library.get(b"strcpy\0").map(|sym| *sym);
        let strcspn = __library.get(b"strcspn\0").map(|sym| *sym);
        let strerror = __library.get(b"strerror\0").map(|sym| *sym);
        let strlen = __library.get(b"strlen\0").map(|sym| *sym);
        let strncat = __library.get(b"strncat\0").map(|sym| *sym);
        let strncmp = __library.get(b"strncmp\0").map(|sym| *sym);
        let strncpy = __library.get(b"strncpy\0").map(|sym| *sym);
        let strpbrk = __library.get(b"strpbrk\0").map(|sym| *sym);
        let strrchr = __library.get(b"strrchr\0").map(|sym| *sym);
        let strspn = __library.get(b"strspn\0").map(|sym| *sym);
        let strstr = __library.get(b"strstr\0").map(|sym| *sym);
        let strtok = __library.get(b"strtok\0").map(|sym| *sym);
        let strxfrm = __library.get(b"strxfrm\0").map(|sym| *sym);
        let strtok_r = __library.get(b"strtok_r\0").map(|sym| *sym);
        let strerror_r = __library.get(b"strerror_r\0").map(|sym| *sym);
        let strdup = __library.get(b"strdup\0").map(|sym| *sym);
        let memccpy = __library.get(b"memccpy\0").map(|sym| *sym);
        let stpcpy = __library.get(b"stpcpy\0").map(|sym| *sym);
        let stpncpy = __library.get(b"stpncpy\0").map(|sym| *sym);
        let strndup = __library.get(b"strndup\0").map(|sym| *sym);
        let strnlen = __library.get(b"strnlen\0").map(|sym| *sym);
        let strsignal = __library.get(b"strsignal\0").map(|sym| *sym);
        let memset_s = __library.get(b"memset_s\0").map(|sym| *sym);
        let memmem = __library.get(b"memmem\0").map(|sym| *sym);
        let memset_pattern4 = __library.get(b"memset_pattern4\0").map(|sym| *sym);
        let memset_pattern8 = __library.get(b"memset_pattern8\0").map(|sym| *sym);
        let memset_pattern16 = __library.get(b"memset_pattern16\0").map(|sym| *sym);
        let strcasestr = __library.get(b"strcasestr\0").map(|sym| *sym);
        let strnstr = __library.get(b"strnstr\0").map(|sym| *sym);
        let strlcat = __library.get(b"strlcat\0").map(|sym| *sym);
        let strlcpy = __library.get(b"strlcpy\0").map(|sym| *sym);
        let strmode = __library.get(b"strmode\0").map(|sym| *sym);
        let strsep = __library.get(b"strsep\0").map(|sym| *sym);
        let swab = __library.get(b"swab\0").map(|sym| *sym);
        let timingsafe_bcmp = __library.get(b"timingsafe_bcmp\0").map(|sym| *sym);
        let strsignal_r = __library.get(b"strsignal_r\0").map(|sym| *sym);
        let bcmp = __library.get(b"bcmp\0").map(|sym| *sym);
        let bcopy = __library.get(b"bcopy\0").map(|sym| *sym);
        let bzero = __library.get(b"bzero\0").map(|sym| *sym);
        let index = __library.get(b"index\0").map(|sym| *sym);
        let rindex = __library.get(b"rindex\0").map(|sym| *sym);
        let ffs = __library.get(b"ffs\0").map(|sym| *sym);
        let strcasecmp = __library.get(b"strcasecmp\0").map(|sym| *sym);
        let strncasecmp = __library.get(b"strncasecmp\0").map(|sym| *sym);
        let ffsl = __library.get(b"ffsl\0").map(|sym| *sym);
        let ffsll = __library.get(b"ffsll\0").map(|sym| *sym);
        let fls = __library.get(b"fls\0").map(|sym| *sym);
        let flsl = __library.get(b"flsl\0").map(|sym| *sym);
        let flsll = __library.get(b"flsll\0").map(|sym| *sym);
        let OrtGetApiBase = __library.get(b"OrtGetApiBase\0").map(|sym| *sym);
        let OrtSessionOptionsAppendExecutionProvider_CUDA = __library
            .get(b"OrtSessionOptionsAppendExecutionProvider_CUDA\0")
            .map(|sym| *sym);
        let OrtSessionOptionsAppendExecutionProvider_MIGraphX = __library
            .get(b"OrtSessionOptionsAppendExecutionProvider_MIGraphX\0")
            .map(|sym| *sym);
        Ok(onnxruntime {
            __library,
            signal,
            getpriority,
            getiopolicy_np,
            getrlimit,
            getrusage,
            setpriority,
            setiopolicy_np,
            setrlimit,
            wait,
            waitpid,
            waitid,
            wait3,
            wait4,
            alloca,
            malloc,
            calloc,
            free,
            realloc,
            valloc,
            aligned_alloc,
            posix_memalign,
            abort,
            abs,
            atexit,
            atof,
            atoi,
            atol,
            atoll,
            bsearch,
            div,
            exit,
            getenv,
            labs,
            ldiv,
            llabs,
            lldiv,
            mblen,
            mbstowcs,
            mbtowc,
            qsort,
            rand,
            srand,
            strtod,
            strtof,
            strtol,
            strtold,
            strtoll,
            strtoul,
            strtoull,
            system,
            wcstombs,
            wctomb,
            _Exit,
            a64l,
            drand48,
            ecvt,
            erand48,
            fcvt,
            gcvt,
            getsubopt,
            grantpt,
            initstate,
            jrand48,
            l64a,
            lcong48,
            lrand48,
            mktemp,
            mkstemp,
            mrand48,
            nrand48,
            posix_openpt,
            ptsname,
            ptsname_r,
            putenv,
            random,
            rand_r,
            realpath,
            seed48,
            setenv,
            setkey,
            setstate,
            srand48,
            srandom,
            unlockpt,
            unsetenv,
            arc4random,
            arc4random_addrandom,
            arc4random_buf,
            arc4random_stir,
            arc4random_uniform,
            atexit_b,
            bsearch_b,
            cgetcap,
            cgetclose,
            cgetent,
            cgetfirst,
            cgetmatch,
            cgetnext,
            cgetnum,
            cgetset,
            cgetstr,
            cgetustr,
            daemon,
            devname,
            devname_r,
            getbsize,
            getloadavg,
            getprogname,
            setprogname,
            heapsort,
            heapsort_b,
            mergesort,
            mergesort_b,
            psort,
            psort_b,
            psort_r,
            qsort_b,
            qsort_r,
            radixsort,
            rpmatch,
            sradixsort,
            sranddev,
            srandomdev,
            reallocf,
            strtonum,
            strtoq,
            strtouq,
            memchr,
            memcmp,
            memcpy,
            memmove,
            memset,
            strcat,
            strchr,
            strcmp,
            strcoll,
            strcpy,
            strcspn,
            strerror,
            strlen,
            strncat,
            strncmp,
            strncpy,
            strpbrk,
            strrchr,
            strspn,
            strstr,
            strtok,
            strxfrm,
            strtok_r,
            strerror_r,
            strdup,
            memccpy,
            stpcpy,
            stpncpy,
            strndup,
            strnlen,
            strsignal,
            memset_s,
            memmem,
            memset_pattern4,
            memset_pattern8,
            memset_pattern16,
            strcasestr,
            strnstr,
            strlcat,
            strlcpy,
            strmode,
            strsep,
            swab,
            timingsafe_bcmp,
            strsignal_r,
            bcmp,
            bcopy,
            bzero,
            index,
            rindex,
            ffs,
            strcasecmp,
            strncasecmp,
            ffsl,
            ffsll,
            fls,
            flsl,
            flsll,
            OrtGetApiBase,
            OrtSessionOptionsAppendExecutionProvider_CUDA,
            OrtSessionOptionsAppendExecutionProvider_MIGraphX,
        })
    }
    pub unsafe fn signal(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    > {
        (self.signal.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getpriority(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
    ) -> ::std::os::raw::c_int {
        (self
            .getpriority
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getiopolicy_np(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self
            .getiopolicy_np
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getrlimit(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: *mut rlimit,
    ) -> ::std::os::raw::c_int {
        (self
            .getrlimit
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getrusage(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: *mut rusage,
    ) -> ::std::os::raw::c_int {
        (self
            .getrusage
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn setpriority(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self
            .setpriority
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn setiopolicy_np(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self
            .setiopolicy_np
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn setrlimit(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: *const rlimit,
    ) -> ::std::os::raw::c_int {
        (self
            .setrlimit
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn wait(&self, arg1: *mut ::std::os::raw::c_int) -> pid_t {
        (self.wait.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn waitpid(
        &self,
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t {
        (self
            .waitpid
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn waitid(
        &self,
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self.waitid.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3, arg4)
    }
    pub unsafe fn wait3(
        &self,
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t {
        (self.wait3.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn wait4(
        &self,
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t {
        (self.wait4.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3, arg4)
    }
    pub unsafe fn alloca(&self, arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
        (self.alloca.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn malloc(&self, __size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
        (self.malloc.as_ref().expect("Expected function, got error."))(__size)
    }
    pub unsafe fn calloc(
        &self,
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self.calloc.as_ref().expect("Expected function, got error."))(__count, __size)
    }
    pub unsafe fn free(&self, arg1: *mut ::std::os::raw::c_void) -> () {
        (self.free.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn realloc(
        &self,
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .realloc
            .as_ref()
            .expect("Expected function, got error."))(__ptr, __size)
    }
    pub unsafe fn valloc(&self, arg1: usize) -> *mut ::std::os::raw::c_void {
        (self.valloc.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn aligned_alloc(
        &self,
        __alignment: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .aligned_alloc
            .as_ref()
            .expect("Expected function, got error."))(__alignment, __size)
    }
    pub unsafe fn posix_memalign(
        &self,
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: usize,
        __size: usize,
    ) -> ::std::os::raw::c_int {
        (self
            .posix_memalign
            .as_ref()
            .expect("Expected function, got error."))(__memptr, __alignment, __size)
    }
    pub unsafe fn abort(&self) -> () {
        (self.abort.as_ref().expect("Expected function, got error."))()
    }
    pub unsafe fn abs(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self.abs.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn atexit(
        &self,
        arg1: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int {
        (self.atexit.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn atof(&self, arg1: *const ::std::os::raw::c_char) -> f64 {
        (self.atof.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn atoi(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self.atoi.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn atol(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
        (self.atol.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn atoll(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong {
        (self.atoll.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn bsearch(
        &self,
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .bsearch
            .as_ref()
            .expect("Expected function, got error."))(
            __key, __base, __nel, __width, __compar
        )
    }
    pub unsafe fn div(&self, arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t {
        (self.div.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn exit(&self, arg1: ::std::os::raw::c_int) -> () {
        (self.exit.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn getenv(
        &self,
        arg1: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.getenv.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn labs(&self, arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long {
        (self.labs.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn ldiv(
        &self,
        arg1: ::std::os::raw::c_long,
        arg2: ::std::os::raw::c_long,
    ) -> ldiv_t {
        (self.ldiv.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn llabs(&self, arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong {
        (self.llabs.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn lldiv(
        &self,
        arg1: ::std::os::raw::c_longlong,
        arg2: ::std::os::raw::c_longlong,
    ) -> lldiv_t {
        (self.lldiv.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn mblen(
        &self,
        __s: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> ::std::os::raw::c_int {
        (self.mblen.as_ref().expect("Expected function, got error."))(__s, __n)
    }
    pub unsafe fn mbstowcs(
        &self,
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: usize,
    ) -> usize {
        (self
            .mbstowcs
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn mbtowc(
        &self,
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: usize,
    ) -> ::std::os::raw::c_int {
        (self.mbtowc.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn qsort(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> () {
        (self.qsort.as_ref().expect("Expected function, got error."))(
            __base, __nel, __width, __compar,
        )
    }
    pub unsafe fn rand(&self) -> ::std::os::raw::c_int {
        (self.rand.as_ref().expect("Expected function, got error."))()
    }
    pub unsafe fn srand(&self, arg1: ::std::os::raw::c_uint) -> () {
        (self.srand.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn strtod(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64 {
        (self.strtod.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn strtof(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32 {
        (self.strtof.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn strtol(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long {
        (self.strtol.as_ref().expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn strtold(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64 {
        (self
            .strtold
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn strtoll(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong {
        (self
            .strtoll
            .as_ref()
            .expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn strtoul(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong {
        (self
            .strtoul
            .as_ref()
            .expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn strtoull(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong {
        (self
            .strtoull
            .as_ref()
            .expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn system(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self.system.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn wcstombs(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: usize,
    ) -> usize {
        (self
            .wcstombs
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn wctomb(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: wchar_t,
    ) -> ::std::os::raw::c_int {
        (self.wctomb.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn _Exit(&self, arg1: ::std::os::raw::c_int) -> () {
        (self._Exit.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn a64l(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
        (self.a64l.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn drand48(&self) -> f64 {
        (self
            .drand48
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn ecvt(
        &self,
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self.ecvt.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3, arg4)
    }
    pub unsafe fn erand48(&self, arg1: *mut ::std::os::raw::c_ushort) -> f64 {
        (self
            .erand48
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn fcvt(
        &self,
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self.fcvt.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3, arg4)
    }
    pub unsafe fn gcvt(
        &self,
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.gcvt.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn getsubopt(
        &self,
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .getsubopt
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn grantpt(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self
            .grantpt
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn initstate(
        &self,
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: usize,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .initstate
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn jrand48(&self, arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
        (self
            .jrand48
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn l64a(&self, arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char {
        (self.l64a.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn lcong48(&self, arg1: *mut ::std::os::raw::c_ushort) -> () {
        (self
            .lcong48
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn lrand48(&self) -> ::std::os::raw::c_long {
        (self
            .lrand48
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn mktemp(&self, arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
        (self.mktemp.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn mkstemp(&self, arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self
            .mkstemp
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn mrand48(&self) -> ::std::os::raw::c_long {
        (self
            .mrand48
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn nrand48(&self, arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
        (self
            .nrand48
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn posix_openpt(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self
            .posix_openpt
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn ptsname(&self, arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
        (self
            .ptsname
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn ptsname_r(
        &self,
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: usize,
    ) -> ::std::os::raw::c_int {
        (self
            .ptsname_r
            .as_ref()
            .expect("Expected function, got error."))(fildes, buffer, buflen)
    }
    pub unsafe fn putenv(&self, arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self.putenv.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn random(&self) -> ::std::os::raw::c_long {
        (self.random.as_ref().expect("Expected function, got error."))()
    }
    pub unsafe fn rand_r(&self, arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int {
        (self.rand_r.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn realpath(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .realpath
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn seed48(
        &self,
        arg1: *mut ::std::os::raw::c_ushort,
    ) -> *mut ::std::os::raw::c_ushort {
        (self.seed48.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn setenv(
        &self,
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self.setenv.as_ref().expect("Expected function, got error."))(__name, __value, __overwrite)
    }
    pub unsafe fn setkey(&self, arg1: *const ::std::os::raw::c_char) -> () {
        (self.setkey.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn setstate(
        &self,
        arg1: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .setstate
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn srand48(&self, arg1: ::std::os::raw::c_long) -> () {
        (self
            .srand48
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn srandom(&self, arg1: ::std::os::raw::c_uint) -> () {
        (self
            .srandom
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn unlockpt(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self
            .unlockpt
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn unsetenv(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self
            .unsetenv
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn arc4random(&self) -> u32 {
        (self
            .arc4random
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn arc4random_addrandom(
        &self,
        arg1: *mut ::std::os::raw::c_uchar,
        arg2: ::std::os::raw::c_int,
    ) -> () {
        (self
            .arc4random_addrandom
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn arc4random_buf(&self, __buf: *mut ::std::os::raw::c_void, __nbytes: usize) -> () {
        (self
            .arc4random_buf
            .as_ref()
            .expect("Expected function, got error."))(__buf, __nbytes)
    }
    pub unsafe fn arc4random_stir(&self) -> () {
        (self
            .arc4random_stir
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn arc4random_uniform(&self, __upper_bound: u32) -> u32 {
        (self
            .arc4random_uniform
            .as_ref()
            .expect("Expected function, got error."))(__upper_bound)
    }
    pub unsafe fn atexit_b(&self, arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int {
        (self
            .atexit_b
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn bsearch_b(
        &self,
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .bsearch_b
            .as_ref()
            .expect("Expected function, got error."))(
            __key, __base, __nel, __width, __compar
        )
    }
    pub unsafe fn cgetcap(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .cgetcap
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn cgetclose(&self) -> ::std::os::raw::c_int {
        (self
            .cgetclose
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn cgetent(
        &self,
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetent
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn cgetfirst(
        &self,
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetfirst
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn cgetmatch(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetmatch
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn cgetnext(
        &self,
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetnext
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn cgetnum(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetnum
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn cgetset(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self
            .cgetset
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn cgetstr(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetstr
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn cgetustr(
        &self,
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .cgetustr
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn daemon(
        &self,
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self.daemon.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn devname(&self, arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char {
        (self
            .devname
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn devname_r(
        &self,
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .devname_r
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, buf, len)
    }
    pub unsafe fn getbsize(
        &self,
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .getbsize
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getloadavg(
        &self,
        arg1: *mut f64,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int {
        (self
            .getloadavg
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn getprogname(&self) -> *const ::std::os::raw::c_char {
        (self
            .getprogname
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn setprogname(&self, arg1: *const ::std::os::raw::c_char) -> () {
        (self
            .setprogname
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn heapsort(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int {
        (self
            .heapsort
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn heapsort_b(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int {
        (self
            .heapsort_b
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn mergesort(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int {
        (self
            .mergesort
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn mergesort_b(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int {
        (self
            .mergesort_b
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn psort(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> () {
        (self.psort.as_ref().expect("Expected function, got error."))(
            __base, __nel, __width, __compar,
        )
    }
    pub unsafe fn psort_b(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> () {
        (self
            .psort_b
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn psort_r(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> () {
        (self
            .psort_r
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, arg1, __compar)
    }
    pub unsafe fn qsort_b(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> () {
        (self
            .qsort_b
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, __compar)
    }
    pub unsafe fn qsort_r(
        &self,
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> () {
        (self
            .qsort_r
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __width, arg1, __compar)
    }
    pub unsafe fn radixsort(
        &self,
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int {
        (self
            .radixsort
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __table, __endbyte)
    }
    pub unsafe fn rpmatch(&self, arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
        (self
            .rpmatch
            .as_ref()
            .expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn sradixsort(
        &self,
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int {
        (self
            .sradixsort
            .as_ref()
            .expect("Expected function, got error."))(__base, __nel, __table, __endbyte)
    }
    pub unsafe fn sranddev(&self) -> () {
        (self
            .sranddev
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn srandomdev(&self) -> () {
        (self
            .srandomdev
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn reallocf(
        &self,
        __ptr: *mut ::std::os::raw::c_void,
        __size: usize,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .reallocf
            .as_ref()
            .expect("Expected function, got error."))(__ptr, __size)
    }
    pub unsafe fn strtonum(
        &self,
        __numstr: *const ::std::os::raw::c_char,
        __minval: ::std::os::raw::c_longlong,
        __maxval: ::std::os::raw::c_longlong,
        __errstrp: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_longlong {
        (self
            .strtonum
            .as_ref()
            .expect("Expected function, got error."))(
            __numstr, __minval, __maxval, __errstrp
        )
    }
    pub unsafe fn strtoq(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong {
        (self.strtoq.as_ref().expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn strtouq(
        &self,
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong {
        (self
            .strtouq
            .as_ref()
            .expect("Expected function, got error."))(__str, __endptr, __base)
    }
    pub unsafe fn memchr(
        &self,
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self.memchr.as_ref().expect("Expected function, got error."))(__s, __c, __n)
    }
    pub unsafe fn memcmp(
        &self,
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int {
        (self.memcmp.as_ref().expect("Expected function, got error."))(__s1, __s2, __n)
    }
    pub unsafe fn memcpy(
        &self,
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self.memcpy.as_ref().expect("Expected function, got error."))(__dst, __src, __n)
    }
    pub unsafe fn memmove(
        &self,
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .memmove
            .as_ref()
            .expect("Expected function, got error."))(__dst, __src, __len)
    }
    pub unsafe fn memset(
        &self,
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self.memset.as_ref().expect("Expected function, got error."))(__b, __c, __len)
    }
    pub unsafe fn strcat(
        &self,
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strcat.as_ref().expect("Expected function, got error."))(__s1, __s2)
    }
    pub unsafe fn strchr(
        &self,
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self.strchr.as_ref().expect("Expected function, got error."))(__s, __c)
    }
    pub unsafe fn strcmp(
        &self,
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self.strcmp.as_ref().expect("Expected function, got error."))(__s1, __s2)
    }
    pub unsafe fn strcoll(
        &self,
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .strcoll
            .as_ref()
            .expect("Expected function, got error."))(__s1, __s2)
    }
    pub unsafe fn strcpy(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strcpy.as_ref().expect("Expected function, got error."))(__dst, __src)
    }
    pub unsafe fn strcspn(
        &self,
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong {
        (self
            .strcspn
            .as_ref()
            .expect("Expected function, got error."))(__s, __charset)
    }
    pub unsafe fn strerror(&self, __errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
        (self
            .strerror
            .as_ref()
            .expect("Expected function, got error."))(__errnum)
    }
    pub unsafe fn strlen(&self, __s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong {
        (self.strlen.as_ref().expect("Expected function, got error."))(__s)
    }
    pub unsafe fn strncat(
        &self,
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strncat
            .as_ref()
            .expect("Expected function, got error."))(__s1, __s2, __n)
    }
    pub unsafe fn strncmp(
        &self,
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int {
        (self
            .strncmp
            .as_ref()
            .expect("Expected function, got error."))(__s1, __s2, __n)
    }
    pub unsafe fn strncpy(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strncpy
            .as_ref()
            .expect("Expected function, got error."))(__dst, __src, __n)
    }
    pub unsafe fn strpbrk(
        &self,
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strpbrk
            .as_ref()
            .expect("Expected function, got error."))(__s, __charset)
    }
    pub unsafe fn strrchr(
        &self,
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strrchr
            .as_ref()
            .expect("Expected function, got error."))(__s, __c)
    }
    pub unsafe fn strspn(
        &self,
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong {
        (self.strspn.as_ref().expect("Expected function, got error."))(__s, __charset)
    }
    pub unsafe fn strstr(
        &self,
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strstr.as_ref().expect("Expected function, got error."))(__big, __little)
    }
    pub unsafe fn strtok(
        &self,
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strtok.as_ref().expect("Expected function, got error."))(__str, __sep)
    }
    pub unsafe fn strxfrm(
        &self,
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong {
        (self
            .strxfrm
            .as_ref()
            .expect("Expected function, got error."))(__s1, __s2, __n)
    }
    pub unsafe fn strtok_r(
        &self,
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strtok_r
            .as_ref()
            .expect("Expected function, got error."))(__str, __sep, __lasts)
    }
    pub unsafe fn strerror_r(
        &self,
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int {
        (self
            .strerror_r
            .as_ref()
            .expect("Expected function, got error."))(__errnum, __strerrbuf, __buflen)
    }
    pub unsafe fn strdup(
        &self,
        __s1: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strdup.as_ref().expect("Expected function, got error."))(__s1)
    }
    pub unsafe fn memccpy(
        &self,
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void {
        (self
            .memccpy
            .as_ref()
            .expect("Expected function, got error."))(__dst, __src, __c, __n)
    }
    pub unsafe fn stpcpy(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.stpcpy.as_ref().expect("Expected function, got error."))(__dst, __src)
    }
    pub unsafe fn stpncpy(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .stpncpy
            .as_ref()
            .expect("Expected function, got error."))(__dst, __src, __n)
    }
    pub unsafe fn strndup(
        &self,
        __s1: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strndup
            .as_ref()
            .expect("Expected function, got error."))(__s1, __n)
    }
    pub unsafe fn strnlen(&self, __s1: *const ::std::os::raw::c_char, __n: usize) -> usize {
        (self
            .strnlen
            .as_ref()
            .expect("Expected function, got error."))(__s1, __n)
    }
    pub unsafe fn strsignal(&self, __sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
        (self
            .strsignal
            .as_ref()
            .expect("Expected function, got error."))(__sig)
    }
    pub unsafe fn memset_s(
        &self,
        __s: *mut ::std::os::raw::c_void,
        __smax: rsize_t,
        __c: ::std::os::raw::c_int,
        __n: rsize_t,
    ) -> errno_t {
        (self
            .memset_s
            .as_ref()
            .expect("Expected function, got error."))(__s, __smax, __c, __n)
    }
    pub unsafe fn memmem(
        &self,
        __big: *const ::std::os::raw::c_void,
        __big_len: usize,
        __little: *const ::std::os::raw::c_void,
        __little_len: usize,
    ) -> *mut ::std::os::raw::c_void {
        (self.memmem.as_ref().expect("Expected function, got error."))(
            __big,
            __big_len,
            __little,
            __little_len,
        )
    }
    pub unsafe fn memset_pattern4(
        &self,
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: usize,
    ) -> () {
        (self
            .memset_pattern4
            .as_ref()
            .expect("Expected function, got error."))(__b, __pattern4, __len)
    }
    pub unsafe fn memset_pattern8(
        &self,
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: usize,
    ) -> () {
        (self
            .memset_pattern8
            .as_ref()
            .expect("Expected function, got error."))(__b, __pattern8, __len)
    }
    pub unsafe fn memset_pattern16(
        &self,
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: usize,
    ) -> () {
        (self
            .memset_pattern16
            .as_ref()
            .expect("Expected function, got error."))(__b, __pattern16, __len)
    }
    pub unsafe fn strcasestr(
        &self,
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strcasestr
            .as_ref()
            .expect("Expected function, got error."))(__big, __little)
    }
    pub unsafe fn strnstr(
        &self,
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: usize,
    ) -> *mut ::std::os::raw::c_char {
        (self
            .strnstr
            .as_ref()
            .expect("Expected function, got error."))(__big, __little, __len)
    }
    pub unsafe fn strlcat(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong {
        (self
            .strlcat
            .as_ref()
            .expect("Expected function, got error."))(__dst, __source, __size)
    }
    pub unsafe fn strlcpy(
        &self,
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong {
        (self
            .strlcpy
            .as_ref()
            .expect("Expected function, got error."))(__dst, __source, __size)
    }
    pub unsafe fn strmode(
        &self,
        __mode: ::std::os::raw::c_int,
        __bp: *mut ::std::os::raw::c_char,
    ) -> () {
        (self
            .strmode
            .as_ref()
            .expect("Expected function, got error."))(__mode, __bp)
    }
    pub unsafe fn strsep(
        &self,
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char {
        (self.strsep.as_ref().expect("Expected function, got error."))(__stringp, __delim)
    }
    pub unsafe fn swab(
        &self,
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: isize,
    ) -> () {
        (self.swab.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn timingsafe_bcmp(
        &self,
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: usize,
    ) -> ::std::os::raw::c_int {
        (self
            .timingsafe_bcmp
            .as_ref()
            .expect("Expected function, got error."))(__b1, __b2, __len)
    }
    pub unsafe fn strsignal_r(
        &self,
        __sig: ::std::os::raw::c_int,
        __strsignalbuf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int {
        (self
            .strsignal_r
            .as_ref()
            .expect("Expected function, got error."))(__sig, __strsignalbuf, __buflen)
    }
    pub unsafe fn bcmp(
        &self,
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int {
        (self.bcmp.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn bcopy(
        &self,
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
    ) -> () {
        (self.bcopy.as_ref().expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn bzero(
        &self,
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_ulong,
    ) -> () {
        (self.bzero.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn index(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self.index.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn rindex(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char {
        (self.rindex.as_ref().expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn ffs(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self.ffs.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn strcasecmp(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int {
        (self
            .strcasecmp
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2)
    }
    pub unsafe fn strncasecmp(
        &self,
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int {
        (self
            .strncasecmp
            .as_ref()
            .expect("Expected function, got error."))(arg1, arg2, arg3)
    }
    pub unsafe fn ffsl(&self, arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int {
        (self.ffsl.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn ffsll(&self, arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int {
        (self.ffsll.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn fls(&self, arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
        (self.fls.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn flsl(&self, arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int {
        (self.flsl.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn flsll(&self, arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int {
        (self.flsll.as_ref().expect("Expected function, got error."))(arg1)
    }
    pub unsafe fn OrtGetApiBase(&self) -> *const OrtApiBase {
        (self
            .OrtGetApiBase
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn OrtSessionOptionsAppendExecutionProvider_CUDA(
        &self,
        options: *mut OrtSessionOptions,
        device_id: ::std::os::raw::c_int,
    ) -> OrtStatusPtr {
        (self
            .OrtSessionOptionsAppendExecutionProvider_CUDA
            .as_ref()
            .expect("Expected function, got error."))(options, device_id)
    }
    pub unsafe fn OrtSessionOptionsAppendExecutionProvider_MIGraphX(
        &self,
        options: *mut OrtSessionOptions,
        device_id: ::std::os::raw::c_int,
    ) -> OrtStatusPtr {
        (self
            .OrtSessionOptionsAppendExecutionProvider_MIGraphX
            .as_ref()
            .expect("Expected function, got error."))(options, device_id)
    }
}
