/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201505;
pub const __STDC_NO_THREADS__: u32 = 1;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 23;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __ENUM_IDTYPE_T: u32 = 1;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const _ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const _SIGSET_H_types: u32 = 1;
pub const __timespec_defined: u32 = 1;
pub const _STRUCT_TIMEVAL: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _SYS_SYSMACROS_H: u32 = 1;
pub const _BITS_PTHREADTYPES_H: u32 = 1;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __have_pthread_attr_t: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __PTHREAD_RWLOCK_INT_FLAGS_SHARED: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _STRING_H: u32 = 1;
pub const _XLOCALE_H: u32 = 1;
pub const ORT_API_VERSION: u32 = 8;
pub type wchar_t = ::std::os::raw::c_int;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __qaddr_t = *mut __quad_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub __wait_terminated: wait__bindgen_ty_1,
    pub __wait_stopped: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn __w_termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set___w_termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___w_coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_termsig: ::std::os::raw::c_uint,
        __w_coredump: ::std::os::raw::c_uint,
        __w_retcode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let __w_termsig: u32 = unsafe { ::std::mem::transmute(__w_termsig) };
            __w_termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __w_coredump: u32 = unsafe { ::std::mem::transmute(__w_coredump) };
            __w_coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_retcode: u32 = unsafe { ::std::mem::transmute(__w_retcode) };
            __w_retcode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn __w_stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_stopval: ::std::os::raw::c_uint,
        __w_stopsig: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let __w_stopval: u32 = unsafe { ::std::mem::transmute(__w_stopval) };
            __w_stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_stopsig: u32 = unsafe { ::std::mem::transmute(__w_stopsig) };
            __w_stopsig as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_terminated as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_terminated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_stopped as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_stopped)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __WAIT_STATUS {
    pub __uptr: *mut wait,
    pub __iptr: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___WAIT_STATUS() {
    assert_eq!(
        ::std::mem::size_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Size of: ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        ::std::mem::align_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Alignment of ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__uptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__uptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__iptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__iptr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> usize;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type time_t = __time_t;
pub type clockid_t = __clockid_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gnu_dev_major(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: pthread_mutex_t___pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__elision as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: pthread_cond_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__futex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__total_seq as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__wakeup_seq as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__woken_seq as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__mutex as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__nwaiters as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__broadcast_seq as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: pthread_rwlock_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_rwlock_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __nr_readers: ::std::os::raw::c_uint,
    pub __readers_wakeup: ::std::os::raw::c_uint,
    pub __writer_wakeup: ::std::os::raw::c_uint,
    pub __nr_readers_queued: ::std::os::raw::c_uint,
    pub __nr_writers_queued: ::std::os::raw::c_uint,
    pub __writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__readers_wakeup as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__readers_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer_wakeup as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers_queued
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_writers_queued
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_writers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__rwelision as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad1 as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad2 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__flags)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cfree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: usize,
        __size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: usize, __size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(__pwcs: *mut wchar_t, __s: *const ::std::os::raw::c_char, __n: usize) -> usize;
}
extern "C" {
    pub fn wcstombs(__s: *mut ::std::os::raw::c_char, __pwcs: *const wchar_t, __n: usize) -> usize;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
pub type int_least8_t = ::std::os::raw::c_schar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type int_least32_t = ::std::os::raw::c_int;
pub type int_least64_t = ::std::os::raw::c_long;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type uint_least64_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__names as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: __locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: usize,
        __l: __locale_t,
    ) -> usize;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: usize) -> usize;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: __locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __bzero(__s: *mut ::std::os::raw::c_void, __n: usize);
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: usize,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UNDEFINED:
    ONNXTensorElementDataType = 0;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT: ONNXTensorElementDataType =
    1;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT8: ONNXTensorElementDataType =
    2;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT8: ONNXTensorElementDataType =
    3;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT16:
    ONNXTensorElementDataType = 4;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT16: ONNXTensorElementDataType =
    5;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT32: ONNXTensorElementDataType =
    6;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_INT64: ONNXTensorElementDataType =
    7;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_STRING:
    ONNXTensorElementDataType = 8;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_BOOL: ONNXTensorElementDataType =
    9;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT16:
    ONNXTensorElementDataType = 10;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_DOUBLE:
    ONNXTensorElementDataType = 11;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT32:
    ONNXTensorElementDataType = 12;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT64:
    ONNXTensorElementDataType = 13;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_COMPLEX64:
    ONNXTensorElementDataType = 14;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_COMPLEX128:
    ONNXTensorElementDataType = 15;
pub const ONNXTensorElementDataType_ONNX_TENSOR_ELEMENT_DATA_TYPE_BFLOAT16:
    ONNXTensorElementDataType = 16;
pub type ONNXTensorElementDataType = ::std::os::raw::c_uint;
pub const ONNXType_ONNX_TYPE_UNKNOWN: ONNXType = 0;
pub const ONNXType_ONNX_TYPE_TENSOR: ONNXType = 1;
pub const ONNXType_ONNX_TYPE_SEQUENCE: ONNXType = 2;
pub const ONNXType_ONNX_TYPE_MAP: ONNXType = 3;
pub const ONNXType_ONNX_TYPE_OPAQUE: ONNXType = 4;
pub const ONNXType_ONNX_TYPE_SPARSETENSOR: ONNXType = 5;
pub type ONNXType = ::std::os::raw::c_uint;
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_VERBOSE: OrtLoggingLevel = 0;
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_INFO: OrtLoggingLevel = 1;
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_WARNING: OrtLoggingLevel = 2;
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_ERROR: OrtLoggingLevel = 3;
pub const OrtLoggingLevel_ORT_LOGGING_LEVEL_FATAL: OrtLoggingLevel = 4;
pub type OrtLoggingLevel = ::std::os::raw::c_uint;
pub const OrtErrorCode_ORT_OK: OrtErrorCode = 0;
pub const OrtErrorCode_ORT_FAIL: OrtErrorCode = 1;
pub const OrtErrorCode_ORT_INVALID_ARGUMENT: OrtErrorCode = 2;
pub const OrtErrorCode_ORT_NO_SUCHFILE: OrtErrorCode = 3;
pub const OrtErrorCode_ORT_NO_MODEL: OrtErrorCode = 4;
pub const OrtErrorCode_ORT_ENGINE_ERROR: OrtErrorCode = 5;
pub const OrtErrorCode_ORT_RUNTIME_EXCEPTION: OrtErrorCode = 6;
pub const OrtErrorCode_ORT_INVALID_PROTOBUF: OrtErrorCode = 7;
pub const OrtErrorCode_ORT_MODEL_LOADED: OrtErrorCode = 8;
pub const OrtErrorCode_ORT_NOT_IMPLEMENTED: OrtErrorCode = 9;
pub const OrtErrorCode_ORT_INVALID_GRAPH: OrtErrorCode = 10;
pub const OrtErrorCode_ORT_EP_FAIL: OrtErrorCode = 11;
pub type OrtErrorCode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtEnv {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtStatus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtMemoryInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtIoBinding {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSession {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtValue {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtRunOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTensorTypeAndShapeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSessionOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCustomOpDomain {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtMapTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtSequenceTypeInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtModelMetadata {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtThreadPoolParams {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtThreadingOptions {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtArenaCfg {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtPrepackedWeightsContainer {
    _unused: [u8; 0],
}
pub type OrtStatusPtr = *mut OrtStatus;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtAllocator {
    pub version: u32,
    pub Alloc: ::std::option::Option<
        unsafe extern "C" fn(this_: *mut OrtAllocator, size: usize) -> *mut ::std::os::raw::c_void,
    >,
    pub Free: ::std::option::Option<
        unsafe extern "C" fn(this_: *mut OrtAllocator, p: *mut ::std::os::raw::c_void),
    >,
    pub Info: ::std::option::Option<
        unsafe extern "C" fn(this_: *const OrtAllocator) -> *const OrtMemoryInfo,
    >,
}
#[test]
fn bindgen_test_layout_OrtAllocator() {
    assert_eq!(
        ::std::mem::size_of::<OrtAllocator>(),
        32usize,
        concat!("Size of: ", stringify!(OrtAllocator))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtAllocator>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtAllocator))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Alloc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Alloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtAllocator>())).Info as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtAllocator),
            "::",
            stringify!(Info)
        )
    );
}
pub type OrtLoggingFunction = ::std::option::Option<
    unsafe extern "C" fn(
        param: *mut ::std::os::raw::c_void,
        severity: OrtLoggingLevel,
        category: *const ::std::os::raw::c_char,
        logid: *const ::std::os::raw::c_char,
        code_location: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
    ),
>;
pub const GraphOptimizationLevel_ORT_DISABLE_ALL: GraphOptimizationLevel = 0;
pub const GraphOptimizationLevel_ORT_ENABLE_BASIC: GraphOptimizationLevel = 1;
pub const GraphOptimizationLevel_ORT_ENABLE_EXTENDED: GraphOptimizationLevel = 2;
pub const GraphOptimizationLevel_ORT_ENABLE_ALL: GraphOptimizationLevel = 99;
pub type GraphOptimizationLevel = ::std::os::raw::c_uint;
pub const ExecutionMode_ORT_SEQUENTIAL: ExecutionMode = 0;
pub const ExecutionMode_ORT_PARALLEL: ExecutionMode = 1;
pub type ExecutionMode = ::std::os::raw::c_uint;
pub const OrtLanguageProjection_ORT_PROJECTION_C: OrtLanguageProjection = 0;
pub const OrtLanguageProjection_ORT_PROJECTION_CPLUSPLUS: OrtLanguageProjection = 1;
pub const OrtLanguageProjection_ORT_PROJECTION_CSHARP: OrtLanguageProjection = 2;
pub const OrtLanguageProjection_ORT_PROJECTION_PYTHON: OrtLanguageProjection = 3;
pub const OrtLanguageProjection_ORT_PROJECTION_JAVA: OrtLanguageProjection = 4;
pub const OrtLanguageProjection_ORT_PROJECTION_WINML: OrtLanguageProjection = 5;
pub const OrtLanguageProjection_ORT_PROJECTION_NODEJS: OrtLanguageProjection = 6;
pub type OrtLanguageProjection = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtKernelInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtKernelContext {
    _unused: [u8; 0],
}
pub const OrtAllocatorType_Invalid: OrtAllocatorType = -1;
pub const OrtAllocatorType_OrtDeviceAllocator: OrtAllocatorType = 0;
pub const OrtAllocatorType_OrtArenaAllocator: OrtAllocatorType = 1;
pub type OrtAllocatorType = ::std::os::raw::c_int;
pub const OrtMemType_OrtMemTypeCPUInput: OrtMemType = -2;
pub const OrtMemType_OrtMemTypeCPUOutput: OrtMemType = -1;
pub const OrtMemType_OrtMemTypeCPU: OrtMemType = -1;
pub const OrtMemType_OrtMemTypeDefault: OrtMemType = 0;
#[doc = " memory types for allocator, exec provider specific types should be extended in each provider"]
#[doc = " Whenever this struct is updated, please also update the MakeKey function in onnxruntime/core/framework/execution_provider.cc"]
pub type OrtMemType = ::std::os::raw::c_int;
pub const OrtCudnnConvAlgoSearch_EXHAUSTIVE: OrtCudnnConvAlgoSearch = 0;
pub const OrtCudnnConvAlgoSearch_HEURISTIC: OrtCudnnConvAlgoSearch = 1;
pub const OrtCudnnConvAlgoSearch_DEFAULT: OrtCudnnConvAlgoSearch = 2;
pub type OrtCudnnConvAlgoSearch = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Options for the CUDA provider that are passed to SessionOptionsAppendExecutionProvider_CUDA"]
#[doc = " </summary>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCUDAProviderOptions {
    pub device_id: ::std::os::raw::c_int,
    pub cudnn_conv_algo_search: OrtCudnnConvAlgoSearch,
    pub gpu_mem_limit: usize,
    pub arena_extend_strategy: ::std::os::raw::c_int,
    pub do_copy_in_default_stream: ::std::os::raw::c_int,
    pub has_user_compute_stream: ::std::os::raw::c_int,
    pub user_compute_stream: *mut ::std::os::raw::c_void,
    pub default_memory_arena_cfg: *mut OrtArenaCfg,
}
#[test]
fn bindgen_test_layout_OrtCUDAProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtCUDAProviderOptions>(),
        48usize,
        concat!("Size of: ", stringify!(OrtCUDAProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtCUDAProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtCUDAProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).cudnn_conv_algo_search as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(cudnn_conv_algo_search)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).gpu_mem_limit as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(gpu_mem_limit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).arena_extend_strategy as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(arena_extend_strategy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).do_copy_in_default_stream as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(do_copy_in_default_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).has_user_compute_stream as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(has_user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).user_compute_stream as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCUDAProviderOptions>())).default_memory_arena_cfg as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCUDAProviderOptions),
            "::",
            stringify!(default_memory_arena_cfg)
        )
    );
}
#[doc = " <summary>"]
#[doc = " Options for the ROCM provider that are passed to SessionOptionsAppendExecutionProvider_ROCM"]
#[doc = " </summary>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtROCMProviderOptions {
    pub device_id: ::std::os::raw::c_int,
    pub miopen_conv_exhaustive_search: ::std::os::raw::c_int,
    pub gpu_mem_limit: usize,
    pub arena_extend_strategy: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_OrtROCMProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtROCMProviderOptions>(),
        24usize,
        concat!("Size of: ", stringify!(OrtROCMProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtROCMProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtROCMProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).miopen_conv_exhaustive_search
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(miopen_conv_exhaustive_search)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).gpu_mem_limit as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(gpu_mem_limit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtROCMProviderOptions>())).arena_extend_strategy as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtROCMProviderOptions),
            "::",
            stringify!(arena_extend_strategy)
        )
    );
}
#[doc = " <summary>"]
#[doc = " Options for the TensorRT provider that are passed to SessionOptionsAppendExecutionProvider_TensorRT"]
#[doc = " </summary>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtTensorRTProviderOptions {
    pub device_id: ::std::os::raw::c_int,
    pub has_user_compute_stream: ::std::os::raw::c_int,
    pub user_compute_stream: *mut ::std::os::raw::c_void,
    pub trt_max_partition_iterations: ::std::os::raw::c_int,
    pub trt_min_subgraph_size: ::std::os::raw::c_int,
    pub trt_max_workspace_size: usize,
    pub trt_fp16_enable: ::std::os::raw::c_int,
    pub trt_int8_enable: ::std::os::raw::c_int,
    pub trt_int8_calibration_table_name: *const ::std::os::raw::c_char,
    pub trt_int8_use_native_calibration_table: ::std::os::raw::c_int,
    pub trt_dla_enable: ::std::os::raw::c_int,
    pub trt_dla_core: ::std::os::raw::c_int,
    pub trt_dump_subgraphs: ::std::os::raw::c_int,
    pub trt_engine_cache_enable: ::std::os::raw::c_int,
    pub trt_engine_cache_path: *const ::std::os::raw::c_char,
    pub trt_engine_decryption_enable: ::std::os::raw::c_int,
    pub trt_engine_decryption_lib_path: *const ::std::os::raw::c_char,
    pub trt_force_sequential_engine_build: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_OrtTensorRTProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtTensorRTProviderOptions>(),
        104usize,
        concat!("Size of: ", stringify!(OrtTensorRTProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtTensorRTProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtTensorRTProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).device_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).has_user_compute_stream
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(has_user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).user_compute_stream as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(user_compute_stream)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_max_partition_iterations
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_max_partition_iterations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_min_subgraph_size as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_min_subgraph_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_max_workspace_size
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_max_workspace_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_fp16_enable as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_fp16_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_int8_enable as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_int8_calibration_table_name
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_calibration_table_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>()))
                .trt_int8_use_native_calibration_table as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_int8_use_native_calibration_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dla_enable as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dla_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dla_core as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dla_core)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_dump_subgraphs as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_dump_subgraphs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_cache_enable
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_cache_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_cache_path as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_cache_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_decryption_enable
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_decryption_enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_engine_decryption_lib_path
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_engine_decryption_lib_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtTensorRTProviderOptions>())).trt_force_sequential_engine_build
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtTensorRTProviderOptions),
            "::",
            stringify!(trt_force_sequential_engine_build)
        )
    );
}
#[doc = " <summary>"]
#[doc = " Options for the OpenVINO provider that are passed to SessionOptionsAppendExecutionProvider_OpenVINO"]
#[doc = " </summary>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtOpenVINOProviderOptions {
    pub device_type: *const ::std::os::raw::c_char,
    pub enable_vpu_fast_compile: ::std::os::raw::c_uchar,
    pub device_id: *const ::std::os::raw::c_char,
    pub num_of_threads: usize,
    pub use_compiled_network: ::std::os::raw::c_uchar,
    pub blob_dump_path: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_OrtOpenVINOProviderOptions() {
    assert_eq!(
        ::std::mem::size_of::<OrtOpenVINOProviderOptions>(),
        48usize,
        concat!("Size of: ", stringify!(OrtOpenVINOProviderOptions))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtOpenVINOProviderOptions>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtOpenVINOProviderOptions))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).device_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(device_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).enable_vpu_fast_compile
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(enable_vpu_fast_compile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).device_id as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(device_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).num_of_threads as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(num_of_threads)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).use_compiled_network as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(use_compiled_network)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtOpenVINOProviderOptions>())).blob_dump_path as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtOpenVINOProviderOptions),
            "::",
            stringify!(blob_dump_path)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtApiBase {
    pub GetApi: ::std::option::Option<unsafe extern "C" fn(version: u32) -> *const OrtApi>,
    pub GetVersionString:
        ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_OrtApiBase() {
    assert_eq!(
        ::std::mem::size_of::<OrtApiBase>(),
        16usize,
        concat!("Size of: ", stringify!(OrtApiBase))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtApiBase>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtApiBase))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApiBase>())).GetApi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApiBase),
            "::",
            stringify!(GetApi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApiBase>())).GetVersionString as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApiBase),
            "::",
            stringify!(GetVersionString)
        )
    );
}
extern "C" {
    pub fn OrtGetApiBase() -> *const OrtApiBase;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtApi {
    #[doc = " \\param msg A null-terminated string. Its content will be copied into the newly created OrtStatus"]
    pub CreateStatus: ::std::option::Option<
        unsafe extern "C" fn(
            code: OrtErrorCode,
            msg: *const ::std::os::raw::c_char,
        ) -> *mut OrtStatus,
    >,
    pub GetErrorCode:
        ::std::option::Option<unsafe extern "C" fn(status: *const OrtStatus) -> OrtErrorCode>,
    #[doc = " \\param status must not be NULL"]
    #[doc = " \\return The error message inside the `status`. Do not free the returned value."]
    pub GetErrorMessage: ::std::option::Option<
        unsafe extern "C" fn(status: *const OrtStatus) -> *const ::std::os::raw::c_char,
    >,
    pub CreateEnv: ::std::option::Option<
        unsafe extern "C" fn(
            logging_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub CreateEnvWithCustomLogger: ::std::option::Option<
        unsafe extern "C" fn(
            logging_function: OrtLoggingFunction,
            logger_param: *mut ::std::os::raw::c_void,
            logging_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub EnableTelemetryEvents:
        ::std::option::Option<unsafe extern "C" fn(env: *const OrtEnv) -> OrtStatusPtr>,
    pub DisableTelemetryEvents:
        ::std::option::Option<unsafe extern "C" fn(env: *const OrtEnv) -> OrtStatusPtr>,
    pub CreateSession: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_path: *const ::std::os::raw::c_char,
            options: *const OrtSessionOptions,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionFromArray: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_data: *const ::std::os::raw::c_void,
            model_data_length: usize,
            options: *const OrtSessionOptions,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub Run: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *mut OrtSession,
            run_options: *const OrtRunOptions,
            input_names: *const *const ::std::os::raw::c_char,
            input: *const *const OrtValue,
            input_len: usize,
            output_names1: *const *const ::std::os::raw::c_char,
            output_names_len: usize,
            output: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionOptions: ::std::option::Option<
        unsafe extern "C" fn(options: *mut *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub SetOptimizedModelFilePath: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            optimized_model_filepath: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CloneSessionOptions: ::std::option::Option<
        unsafe extern "C" fn(
            in_options: *const OrtSessionOptions,
            out_options: *mut *mut OrtSessionOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionExecutionMode: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            execution_mode: ExecutionMode,
        ) -> OrtStatusPtr,
    >,
    pub EnableProfiling: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            profile_file_prefix: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub DisableProfiling: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub EnableMemPattern: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub DisableMemPattern: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub EnableCpuMemArena: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub DisableCpuMemArena: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub SetSessionLogId: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            logid: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            session_log_verbosity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            session_log_severity_level: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetSessionGraphOptimizationLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            graph_optimization_level: GraphOptimizationLevel,
        ) -> OrtStatusPtr,
    >,
    pub SetIntraOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            intra_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetInterOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            inter_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub CreateCustomOpDomain: ::std::option::Option<
        unsafe extern "C" fn(
            domain: *const ::std::os::raw::c_char,
            out: *mut *mut OrtCustomOpDomain,
        ) -> OrtStatusPtr,
    >,
    pub CustomOpDomain_Add: ::std::option::Option<
        unsafe extern "C" fn(
            custom_op_domain: *mut OrtCustomOpDomain,
            op: *const OrtCustomOp,
        ) -> OrtStatusPtr,
    >,
    pub AddCustomOpDomain: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            custom_op_domain: *mut OrtCustomOpDomain,
        ) -> OrtStatusPtr,
    >,
    pub RegisterCustomOpsLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            library_path: *const ::std::os::raw::c_char,
            library_handle: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetInputCount: ::std::option::Option<
        unsafe extern "C" fn(sess: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetOutputCount: ::std::option::Option<
        unsafe extern "C" fn(sess: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerCount: ::std::option::Option<
        unsafe extern "C" fn(sess: *const OrtSession, out: *mut usize) -> OrtStatusPtr,
    >,
    pub SessionGetInputTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOutputTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetInputName: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOutputName: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetOverridableInitializerName: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            index: usize,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreateRunOptions:
        ::std::option::Option<unsafe extern "C" fn(out: *mut *mut OrtRunOptions) -> OrtStatusPtr>,
    pub RunOptionsSetRunLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            value: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetRunLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            value: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetRunTag: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut OrtRunOptions,
            run_tag: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunLogVerbosityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *const OrtRunOptions,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunLogSeverityLevel: ::std::option::Option<
        unsafe extern "C" fn(
            options: *const OrtRunOptions,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsGetRunTag: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const OrtRunOptions,
            out: *mut *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub RunOptionsSetTerminate:
        ::std::option::Option<unsafe extern "C" fn(options: *mut OrtRunOptions) -> OrtStatusPtr>,
    pub RunOptionsUnsetTerminate:
        ::std::option::Option<unsafe extern "C" fn(options: *mut OrtRunOptions) -> OrtStatusPtr>,
    pub CreateTensorAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            allocator: *mut OrtAllocator,
            shape: *const i64,
            shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateTensorWithDataAsOrtValue: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtMemoryInfo,
            p_data: *mut ::std::os::raw::c_void,
            p_data_len: usize,
            shape: *const i64,
            shape_len: usize,
            type_: ONNXTensorElementDataType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub IsTensor: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorMutableData: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub FillStringTensor: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            s: *const *const ::std::os::raw::c_char,
            s_len: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetStringTensorDataLength: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, len: *mut usize) -> OrtStatusPtr,
    >,
    pub GetStringTensorContent: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            s: *mut ::std::os::raw::c_void,
            s_len: usize,
            offsets: *mut usize,
            offsets_len: usize,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToTensorInfo: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const OrtTypeInfo,
            out: *mut *const OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetOnnxTypeFromTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const OrtTypeInfo, out: *mut ONNXType) -> OrtStatusPtr,
    >,
    pub CreateTensorTypeAndShapeInfo: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtTensorTypeAndShapeInfo) -> OrtStatusPtr,
    >,
    pub SetTensorElementType: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut OrtTensorTypeAndShapeInfo,
            type_: ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub SetDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *mut OrtTensorTypeAndShapeInfo,
            dim_values: *const i64,
            dim_count: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorElementType: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const OrtTensorTypeAndShapeInfo,
            out: *mut ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub GetDimensionsCount: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            out: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            dim_values: *mut i64,
            dim_values_length: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetSymbolicDimensions: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            dim_params: *mut *const ::std::os::raw::c_char,
            dim_params_length: usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorShapeElementCount: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtTensorTypeAndShapeInfo,
            out: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetTensorTypeAndShape: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            out: *mut *mut OrtTensorTypeAndShapeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut *mut OrtTypeInfo) -> OrtStatusPtr,
    >,
    pub GetValueType: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut ONNXType) -> OrtStatusPtr,
    >,
    pub CreateMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            name1: *const ::std::os::raw::c_char,
            type_: OrtAllocatorType,
            id1: ::std::os::raw::c_int,
            mem_type1: OrtMemType,
            out: *mut *mut OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub CreateCpuMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_: OrtAllocatorType,
            mem_type1: OrtMemType,
            out: *mut *mut OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub CompareMemoryInfo: ::std::option::Option<
        unsafe extern "C" fn(
            info1: *const OrtMemoryInfo,
            info2: *const OrtMemoryInfo,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetName: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *const OrtMemoryInfo,
            out: *mut *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetId: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *const OrtMemoryInfo,
            out: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetMemType: ::std::option::Option<
        unsafe extern "C" fn(ptr: *const OrtMemoryInfo, out: *mut OrtMemType) -> OrtStatusPtr,
    >,
    pub MemoryInfoGetType: ::std::option::Option<
        unsafe extern "C" fn(ptr: *const OrtMemoryInfo, out: *mut OrtAllocatorType) -> OrtStatusPtr,
    >,
    pub AllocatorAlloc: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *mut OrtAllocator,
            size: usize,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub AllocatorFree: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *mut OrtAllocator,
            p: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub AllocatorGetInfo: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *const OrtAllocator,
            out: *mut *const OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetAllocatorWithDefaultOptions:
        ::std::option::Option<unsafe extern "C" fn(out: *mut *mut OrtAllocator) -> OrtStatusPtr>,
    pub AddFreeDimensionOverride: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            dim_denotation: *const ::std::os::raw::c_char,
            dim_value: i64,
        ) -> OrtStatusPtr,
    >,
    pub GetValue: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            index: ::std::os::raw::c_int,
            allocator: *mut OrtAllocator,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub GetValueCount: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, out: *mut usize) -> OrtStatusPtr,
    >,
    pub CreateValue: ::std::option::Option<
        unsafe extern "C" fn(
            in_: *const *const OrtValue,
            num_values: usize,
            value_type: ONNXType,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateOpaqueValue: ::std::option::Option<
        unsafe extern "C" fn(
            domain_name: *const ::std::os::raw::c_char,
            type_name: *const ::std::os::raw::c_char,
            data_container: *const ::std::os::raw::c_void,
            data_container_size: usize,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub GetOpaqueValue: ::std::option::Option<
        unsafe extern "C" fn(
            domain_name: *const ::std::os::raw::c_char,
            type_name: *const ::std::os::raw::c_char,
            in_: *const OrtValue,
            data_container: *mut ::std::os::raw::c_void,
            data_container_size: usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_float: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut f32,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_int64: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttribute_string: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut ::std::os::raw::c_char,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelContext_GetInputCount: ::std::option::Option<
        unsafe extern "C" fn(context: *const OrtKernelContext, out: *mut usize) -> OrtStatusPtr,
    >,
    pub KernelContext_GetOutputCount: ::std::option::Option<
        unsafe extern "C" fn(context: *const OrtKernelContext, out: *mut usize) -> OrtStatusPtr,
    >,
    pub KernelContext_GetInput: ::std::option::Option<
        unsafe extern "C" fn(
            context: *const OrtKernelContext,
            index: usize,
            out: *mut *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub KernelContext_GetOutput: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut OrtKernelContext,
            index: usize,
            dim_values: *const i64,
            dim_count: usize,
            out: *mut *mut OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseEnv: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtEnv)>,
    pub ReleaseStatus: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtStatus)>,
    pub ReleaseMemoryInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtMemoryInfo)>,
    pub ReleaseSession: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSession)>,
    pub ReleaseValue: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtValue)>,
    pub ReleaseRunOptions: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtRunOptions)>,
    pub ReleaseTypeInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtTypeInfo)>,
    pub ReleaseTensorTypeAndShapeInfo:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtTensorTypeAndShapeInfo)>,
    pub ReleaseSessionOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSessionOptions)>,
    pub ReleaseCustomOpDomain:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtCustomOpDomain)>,
    pub GetDenotationFromTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const OrtTypeInfo,
            denotation: *mut *const ::std::os::raw::c_char,
            len: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToMapTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            out: *mut *const OrtMapTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub CastTypeInfoToSequenceTypeInfo: ::std::option::Option<
        unsafe extern "C" fn(
            type_info: *const OrtTypeInfo,
            out: *mut *const OrtSequenceTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetMapKeyType: ::std::option::Option<
        unsafe extern "C" fn(
            map_type_info: *const OrtMapTypeInfo,
            out: *mut ONNXTensorElementDataType,
        ) -> OrtStatusPtr,
    >,
    pub GetMapValueType: ::std::option::Option<
        unsafe extern "C" fn(
            map_type_info: *const OrtMapTypeInfo,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetSequenceElementType: ::std::option::Option<
        unsafe extern "C" fn(
            sequence_type_info: *const OrtSequenceTypeInfo,
            type_info: *mut *mut OrtTypeInfo,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseMapTypeInfo: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtMapTypeInfo)>,
    pub ReleaseSequenceTypeInfo:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtSequenceTypeInfo)>,
    pub SessionEndProfiling: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *mut OrtSession,
            allocator: *mut OrtAllocator,
            out: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetModelMetadata: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            out: *mut *mut OrtModelMetadata,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetProducerName: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetGraphName: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetDomain: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetDescription: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataLookupCustomMetadataMap: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            key: *const ::std::os::raw::c_char,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub ModelMetadataGetVersion: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            value: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseModelMetadata:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtModelMetadata)>,
    pub CreateEnvWithGlobalThreadPools: ::std::option::Option<
        unsafe extern "C" fn(
            logging_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            t_options: *const OrtThreadingOptions,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub DisablePerSessionThreads: ::std::option::Option<
        unsafe extern "C" fn(options: *mut OrtSessionOptions) -> OrtStatusPtr,
    >,
    pub CreateThreadingOptions: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtThreadingOptions) -> OrtStatusPtr,
    >,
    pub ReleaseThreadingOptions:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtThreadingOptions)>,
    pub ModelMetadataGetCustomMetadataMapKeys: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            keys: *mut *mut *mut ::std::os::raw::c_char,
            num_keys: *mut i64,
        ) -> OrtStatusPtr,
    >,
    pub AddFreeDimensionOverrideByName: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            dim_name: *const ::std::os::raw::c_char,
            dim_value: i64,
        ) -> OrtStatusPtr,
    >,
    pub GetAvailableProviders: ::std::option::Option<
        unsafe extern "C" fn(
            out_ptr: *mut *mut *mut ::std::os::raw::c_char,
            provider_length: *mut ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseAvailableProviders: ::std::option::Option<
        unsafe extern "C" fn(
            ptr: *mut *mut ::std::os::raw::c_char,
            providers_length: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub GetStringTensorElementLength: ::std::option::Option<
        unsafe extern "C" fn(value: *const OrtValue, index: usize, out: *mut usize) -> OrtStatusPtr,
    >,
    pub GetStringTensorElement: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const OrtValue,
            s_len: usize,
            index: usize,
            s: *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub FillStringTensorElement: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            s: *const ::std::os::raw::c_char,
            index: usize,
        ) -> OrtStatusPtr,
    >,
    pub AddSessionConfigEntry: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            config_key: *const ::std::os::raw::c_char,
            config_value: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreateAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *const OrtSession,
            mem_info: *const OrtMemoryInfo,
            out: *mut *mut OrtAllocator,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseAllocator: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtAllocator)>,
    pub RunWithBinding: ::std::option::Option<
        unsafe extern "C" fn(
            sess: *mut OrtSession,
            run_options: *const OrtRunOptions,
            binding_ptr: *const OrtIoBinding,
        ) -> OrtStatusPtr,
    >,
    pub CreateIoBinding: ::std::option::Option<
        unsafe extern "C" fn(sess: *mut OrtSession, out: *mut *mut OrtIoBinding) -> OrtStatusPtr,
    >,
    pub ReleaseIoBinding: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtIoBinding)>,
    pub BindInput: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            val_ptr: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub BindOutput: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            val_ptr: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub BindOutputToDevice: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *mut OrtIoBinding,
            name: *const ::std::os::raw::c_char,
            val_ptr: *const OrtMemoryInfo,
        ) -> OrtStatusPtr,
    >,
    pub GetBoundOutputNames: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *const OrtIoBinding,
            allocator: *mut OrtAllocator,
            buffer: *mut *mut ::std::os::raw::c_char,
            lengths: *mut *mut usize,
            count: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub GetBoundOutputValues: ::std::option::Option<
        unsafe extern "C" fn(
            binding_ptr: *const OrtIoBinding,
            allocator: *mut OrtAllocator,
            output: *mut *mut *mut OrtValue,
            output_count: *mut usize,
        ) -> OrtStatusPtr,
    >,
    #[doc = " Clears any previously specified bindings for inputs/outputs"]
    pub ClearBoundInputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding)>,
    pub ClearBoundOutputs:
        ::std::option::Option<unsafe extern "C" fn(binding_ptr: *mut OrtIoBinding)>,
    pub TensorAt: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut OrtValue,
            location_values: *const i64,
            location_values_count: usize,
            out: *mut *mut ::std::os::raw::c_void,
        ) -> OrtStatusPtr,
    >,
    pub CreateAndRegisterAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            env: *mut OrtEnv,
            mem_info: *const OrtMemoryInfo,
            arena_cfg: *const OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub SetLanguageProjection: ::std::option::Option<
        unsafe extern "C" fn(
            ort_env: *const OrtEnv,
            projection: OrtLanguageProjection,
        ) -> OrtStatusPtr,
    >,
    pub SessionGetProfilingStartTimeNs: ::std::option::Option<
        unsafe extern "C" fn(sess: *const OrtSession, out: *mut u64) -> OrtStatusPtr,
    >,
    pub SetGlobalIntraOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            intra_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalInterOpNumThreads: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            inter_op_num_threads: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalSpinControl: ::std::option::Option<
        unsafe extern "C" fn(
            tp_options: *mut OrtThreadingOptions,
            allow_spinning: ::std::os::raw::c_int,
        ) -> OrtStatusPtr,
    >,
    pub AddInitializer: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            name: *const ::std::os::raw::c_char,
            val: *const OrtValue,
        ) -> OrtStatusPtr,
    >,
    pub CreateEnvWithCustomLoggerAndGlobalThreadPools: ::std::option::Option<
        unsafe extern "C" fn(
            logging_function: OrtLoggingFunction,
            logger_param: *mut ::std::os::raw::c_void,
            logging_level: OrtLoggingLevel,
            logid: *const ::std::os::raw::c_char,
            tp_options: *const OrtThreadingOptions,
            out: *mut *mut OrtEnv,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_CUDA: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            cuda_options: *const OrtCUDAProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_ROCM: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            rocm_options: *const OrtROCMProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_OpenVINO: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            provider_options: *const OrtOpenVINOProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetGlobalDenormalAsZero: ::std::option::Option<
        unsafe extern "C" fn(tp_options: *mut OrtThreadingOptions) -> OrtStatusPtr,
    >,
    pub CreateArenaCfg: ::std::option::Option<
        unsafe extern "C" fn(
            max_mem: usize,
            arena_extend_strategy: ::std::os::raw::c_int,
            initial_chunk_size_bytes: ::std::os::raw::c_int,
            max_dead_bytes_per_chunk: ::std::os::raw::c_int,
            out: *mut *mut OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub ReleaseArenaCfg: ::std::option::Option<unsafe extern "C" fn(input: *mut OrtArenaCfg)>,
    pub ModelMetadataGetGraphDescription: ::std::option::Option<
        unsafe extern "C" fn(
            model_metadata: *const OrtModelMetadata,
            allocator: *mut OrtAllocator,
            value: *mut *mut ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub SessionOptionsAppendExecutionProvider_TensorRT: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtSessionOptions,
            tensorrt_options: *const OrtTensorRTProviderOptions,
        ) -> OrtStatusPtr,
    >,
    pub SetCurrentGpuDeviceId: ::std::option::Option<
        unsafe extern "C" fn(device_id: ::std::os::raw::c_int) -> OrtStatusPtr,
    >,
    pub GetCurrentGpuDeviceId: ::std::option::Option<
        unsafe extern "C" fn(device_id: *mut ::std::os::raw::c_int) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttributeArray_float: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut f32,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub KernelInfoGetAttributeArray_int64: ::std::option::Option<
        unsafe extern "C" fn(
            info: *const OrtKernelInfo,
            name: *const ::std::os::raw::c_char,
            out: *mut i64,
            size: *mut usize,
        ) -> OrtStatusPtr,
    >,
    pub CreateArenaCfgV2: ::std::option::Option<
        unsafe extern "C" fn(
            arena_config_keys: *const *const ::std::os::raw::c_char,
            arena_config_values: *const usize,
            num_keys: usize,
            out: *mut *mut OrtArenaCfg,
        ) -> OrtStatusPtr,
    >,
    pub AddRunConfigEntry: ::std::option::Option<
        unsafe extern "C" fn(
            options: *mut OrtRunOptions,
            config_key: *const ::std::os::raw::c_char,
            config_value: *const ::std::os::raw::c_char,
        ) -> OrtStatusPtr,
    >,
    pub CreatePrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(out: *mut *mut OrtPrepackedWeightsContainer) -> OrtStatusPtr,
    >,
    pub ReleasePrepackedWeightsContainer:
        ::std::option::Option<unsafe extern "C" fn(input: *mut OrtPrepackedWeightsContainer)>,
    pub CreateSessionWithPrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_path: *const ::std::os::raw::c_char,
            options: *const OrtSessionOptions,
            prepacked_weights_container: *mut OrtPrepackedWeightsContainer,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
    pub CreateSessionFromArrayWithPrepackedWeightsContainer: ::std::option::Option<
        unsafe extern "C" fn(
            env: *const OrtEnv,
            model_data: *const ::std::os::raw::c_void,
            model_data_length: usize,
            options: *const OrtSessionOptions,
            prepacked_weights_container: *mut OrtPrepackedWeightsContainer,
            out: *mut *mut OrtSession,
        ) -> OrtStatusPtr,
    >,
}
#[test]
fn bindgen_test_layout_OrtApi() {
    assert_eq!(
        ::std::mem::size_of::<OrtApi>(),
        1360usize,
        concat!("Size of: ", stringify!(OrtApi))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtApi>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtApi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateStatus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetErrorCode as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetErrorCode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetErrorMessage as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetErrorMessage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateEnv as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithCustomLogger as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithCustomLogger)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableTelemetryEvents as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableTelemetryEvents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableTelemetryEvents as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableTelemetryEvents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSession as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSession)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSessionFromArray as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionFromArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).Run as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(Run)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateSessionOptions as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetOptimizedModelFilePath as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetOptimizedModelFilePath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CloneSessionOptions as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CloneSessionOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetSessionExecutionMode as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionExecutionMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableProfiling as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableProfiling as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableMemPattern as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableMemPattern)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableMemPattern as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableMemPattern)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).EnableCpuMemArena as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(EnableCpuMemArena)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisableCpuMemArena as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisableCpuMemArena)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetSessionLogId as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionLogVerbosityLevel as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionLogSeverityLevel as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetSessionGraphOptimizationLevel as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetSessionGraphOptimizationLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetIntraOpNumThreads as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetIntraOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetInterOpNumThreads as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetInterOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateCustomOpDomain as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CustomOpDomain_Add as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CustomOpDomain_Add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddCustomOpDomain as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RegisterCustomOpsLibrary as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RegisterCustomOpsLibrary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputCount as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputCount as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerCount as *const _
                as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputTypeInfo as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputTypeInfo as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerTypeInfo as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetInputName as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetInputName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetOutputName as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOutputName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetOverridableInitializerName as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetOverridableInitializerName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateRunOptions as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateRunOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunLogVerbosityLevel as *const _
                as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunLogSeverityLevel as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetRunTag as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetRunTag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunLogVerbosityLevel as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunLogVerbosityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunLogSeverityLevel as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunLogSeverityLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsGetRunTag as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsGetRunTag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsSetTerminate as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsSetTerminate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunOptionsUnsetTerminate as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunOptionsUnsetTerminate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateTensorAsOrtValue as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorAsOrtValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateTensorWithDataAsOrtValue as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorWithDataAsOrtValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).IsTensor as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(IsTensor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorMutableData as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorMutableData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillStringTensor as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillStringTensor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetStringTensorDataLength as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorDataLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetStringTensorContent as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorContent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToTensorInfo as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToTensorInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetOnnxTypeFromTypeInfo as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetOnnxTypeFromTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateTensorTypeAndShapeInfo as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateTensorTypeAndShapeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetTensorElementType as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetTensorElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetDimensions as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetDimensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorElementType as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetDimensionsCount as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDimensionsCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetDimensions as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDimensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSymbolicDimensions as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSymbolicDimensions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetTensorShapeElementCount as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorShapeElementCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTensorTypeAndShape as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTensorTypeAndShape)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetTypeInfo as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValueType as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValueType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateMemoryInfo as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateCpuMemoryInfo as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateCpuMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CompareMemoryInfo as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CompareMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetName as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetId as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetMemType as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetMemType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).MemoryInfoGetType as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(MemoryInfoGetType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorAlloc as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorAlloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorFree as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorFree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AllocatorGetInfo as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AllocatorGetInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetAllocatorWithDefaultOptions as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetAllocatorWithDefaultOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddFreeDimensionOverride as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddFreeDimensionOverride)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValue as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetValueCount as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetValueCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateValue as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateOpaqueValue as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateOpaqueValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetOpaqueValue as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetOpaqueValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_float as *const _ as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_float)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_int64 as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_int64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttribute_string as *const _ as usize
        },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttribute_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetInputCount as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetInputCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetOutputCount as *const _ as usize
        },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetOutputCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetInput as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).KernelContext_GetOutput as *const _ as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelContext_GetOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseEnv as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseEnv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseStatus as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseMemoryInfo as *const _ as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseMemoryInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSession as *const _ as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSession)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseValue as *const _ as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseRunOptions as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseRunOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseTypeInfo as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseTensorTypeAndShapeInfo as *const _ as usize
        },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseTensorTypeAndShapeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSessionOptions as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSessionOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseCustomOpDomain as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseCustomOpDomain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetDenotationFromTypeInfo as *const _ as usize
        },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetDenotationFromTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToMapTypeInfo as *const _ as usize
        },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToMapTypeInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CastTypeInfoToSequenceTypeInfo as *const _ as usize
        },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CastTypeInfoToSequenceTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetMapKeyType as *const _ as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetMapKeyType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetMapValueType as *const _ as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetMapValueType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetSequenceElementType as *const _ as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetSequenceElementType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseMapTypeInfo as *const _ as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseMapTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseSequenceTypeInfo as *const _ as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseSequenceTypeInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionEndProfiling as *const _ as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionEndProfiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SessionGetModelMetadata as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetModelMetadata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetProducerName as *const _ as usize
        },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetProducerName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetGraphName as *const _ as usize
        },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetGraphName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetDomain as *const _ as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetDomain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetDescription as *const _ as usize
        },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataLookupCustomMetadataMap as *const _
                as usize
        },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataLookupCustomMetadataMap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetVersion as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseModelMetadata as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseModelMetadata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithGlobalThreadPools as *const _ as usize
        },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithGlobalThreadPools)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).DisablePerSessionThreads as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(DisablePerSessionThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateThreadingOptions as *const _ as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateThreadingOptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseThreadingOptions as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseThreadingOptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetCustomMetadataMapKeys as *const _
                as usize
        },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetCustomMetadataMapKeys)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).AddFreeDimensionOverrideByName as *const _ as usize
        },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddFreeDimensionOverrideByName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetAvailableProviders as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetAvailableProviders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleaseAvailableProviders as *const _ as usize
        },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseAvailableProviders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).GetStringTensorElementLength as *const _ as usize
        },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorElementLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetStringTensorElement as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetStringTensorElement)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).FillStringTensorElement as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(FillStringTensorElement)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddSessionConfigEntry as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddSessionConfigEntry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateAllocator as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseAllocator as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).RunWithBinding as *const _ as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(RunWithBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateIoBinding as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateIoBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseIoBinding as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseIoBinding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindInput as *const _ as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindOutput as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).BindOutputToDevice as *const _ as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(BindOutputToDevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetBoundOutputNames as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetBoundOutputNames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetBoundOutputValues as *const _ as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetBoundOutputValues)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ClearBoundInputs as *const _ as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ClearBoundInputs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ClearBoundOutputs as *const _ as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ClearBoundOutputs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).TensorAt as *const _ as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(TensorAt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateAndRegisterAllocator as *const _ as usize
        },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateAndRegisterAllocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetLanguageProjection as *const _ as usize },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetLanguageProjection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionGetProfilingStartTimeNs as *const _ as usize
        },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionGetProfilingStartTimeNs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalIntraOpNumThreads as *const _ as usize
        },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalIntraOpNumThreads)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SetGlobalInterOpNumThreads as *const _ as usize
        },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalInterOpNumThreads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetGlobalSpinControl as *const _ as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalSpinControl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddInitializer as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddInitializer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateEnvWithCustomLoggerAndGlobalThreadPools
                as *const _ as usize
        },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateEnvWithCustomLoggerAndGlobalThreadPools)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_CUDA
                as *const _ as usize
        },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_CUDA)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_ROCM
                as *const _ as usize
        },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_ROCM)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_OpenVINO
                as *const _ as usize
        },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_OpenVINO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetGlobalDenormalAsZero as *const _ as usize },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetGlobalDenormalAsZero)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateArenaCfg as *const _ as usize },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateArenaCfg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).ReleaseArenaCfg as *const _ as usize },
        1256usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleaseArenaCfg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ModelMetadataGetGraphDescription as *const _ as usize
        },
        1264usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ModelMetadataGetGraphDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).SessionOptionsAppendExecutionProvider_TensorRT
                as *const _ as usize
        },
        1272usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SessionOptionsAppendExecutionProvider_TensorRT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).SetCurrentGpuDeviceId as *const _ as usize },
        1280usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(SetCurrentGpuDeviceId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).GetCurrentGpuDeviceId as *const _ as usize },
        1288usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(GetCurrentGpuDeviceId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttributeArray_float as *const _
                as usize
        },
        1296usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttributeArray_float)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).KernelInfoGetAttributeArray_int64 as *const _
                as usize
        },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(KernelInfoGetAttributeArray_int64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).CreateArenaCfgV2 as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateArenaCfgV2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtApi>())).AddRunConfigEntry as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(AddRunConfigEntry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreatePrepackedWeightsContainer as *const _ as usize
        },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreatePrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).ReleasePrepackedWeightsContainer as *const _ as usize
        },
        1336usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(ReleasePrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSessionWithPrepackedWeightsContainer
                as *const _ as usize
        },
        1344usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionWithPrepackedWeightsContainer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtApi>())).CreateSessionFromArrayWithPrepackedWeightsContainer
                as *const _ as usize
        },
        1352usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtApi),
            "::",
            stringify!(CreateSessionFromArrayWithPrepackedWeightsContainer)
        )
    );
}
pub const OrtCustomOpInputOutputCharacteristic_INPUT_OUTPUT_REQUIRED:
    OrtCustomOpInputOutputCharacteristic = 0;
pub const OrtCustomOpInputOutputCharacteristic_INPUT_OUTPUT_OPTIONAL:
    OrtCustomOpInputOutputCharacteristic = 1;
pub type OrtCustomOpInputOutputCharacteristic = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OrtCustomOp {
    pub version: u32,
    pub CreateKernel: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            api: *const OrtApi,
            info: *const OrtKernelInfo,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub GetName: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp) -> *const ::std::os::raw::c_char,
    >,
    pub GetExecutionProviderType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp) -> *const ::std::os::raw::c_char,
    >,
    pub GetInputType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp, index: usize) -> ONNXTensorElementDataType,
    >,
    pub GetInputTypeCount:
        ::std::option::Option<unsafe extern "C" fn(op: *const OrtCustomOp) -> usize>,
    pub GetOutputType: ::std::option::Option<
        unsafe extern "C" fn(op: *const OrtCustomOp, index: usize) -> ONNXTensorElementDataType,
    >,
    pub GetOutputTypeCount:
        ::std::option::Option<unsafe extern "C" fn(op: *const OrtCustomOp) -> usize>,
    pub KernelCompute: ::std::option::Option<
        unsafe extern "C" fn(
            op_kernel: *mut ::std::os::raw::c_void,
            context: *mut OrtKernelContext,
        ),
    >,
    pub KernelDestroy:
        ::std::option::Option<unsafe extern "C" fn(op_kernel: *mut ::std::os::raw::c_void)>,
    pub GetInputCharacteristic: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            index: usize,
        ) -> OrtCustomOpInputOutputCharacteristic,
    >,
    pub GetOutputCharacteristic: ::std::option::Option<
        unsafe extern "C" fn(
            op: *const OrtCustomOp,
            index: usize,
        ) -> OrtCustomOpInputOutputCharacteristic,
    >,
}
#[test]
fn bindgen_test_layout_OrtCustomOp() {
    assert_eq!(
        ::std::mem::size_of::<OrtCustomOp>(),
        96usize,
        concat!("Size of: ", stringify!(OrtCustomOp))
    );
    assert_eq!(
        ::std::mem::align_of::<OrtCustomOp>(),
        8usize,
        concat!("Alignment of ", stringify!(OrtCustomOp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).CreateKernel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(CreateKernel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetName as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetExecutionProviderType as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetExecutionProviderType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetInputType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetInputTypeCount as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputTypeCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputType as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputTypeCount as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputTypeCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).KernelCompute as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(KernelCompute)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<OrtCustomOp>())).KernelDestroy as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(KernelDestroy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetInputCharacteristic as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetInputCharacteristic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OrtCustomOp>())).GetOutputCharacteristic as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(OrtCustomOp),
            "::",
            stringify!(GetOutputCharacteristic)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_data {
    pub _address: u8,
}
