#!/bin/bash

# Updates the DNS type specs in dns-specs/* and generated code in src/specs/*.
# This is done as an offline process (separate from the main build) to avoid problems with tooling, such as:
# - Cargo: Requires that generated artifacts go into OUT_DIR
# - rust-analyzer and RLS: Neither follows OUT_DIR at all
# - rust-analyzer: Gets confused by code mtimes getting updated during rebuild/analysis, leading to infinite rebuilds etc
# So we just keep the generated artifacts in source control, and update them when needed with this script.

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd $SCRIPT_DIR

cargo run --example update_specs -- --fetch
