// This file is autogenerated by update_specs.rs. Don't touch.
use rkyv::{Archive, Deserialize, Serialize};
use bytecheck::CheckBytes;
#[repr(u16)]
#[derive(Archive, Deserialize, Serialize, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[archive_attr(derive(CheckBytes))]
pub enum ResourceClass {

  /// Reserved [RFC6895]
  RESERVED_0 = 0,

  /// Internet (IN) [RFC1035]
  INTERNET = 1,

  // Unassigned
  // 2

  /// Chaos (CH) [D. Moon, "Chaosnet", A.I. Memo 628, Massachusetts Institute of Technology Artificial Intelligence Laboratory, June 1981.]
  CHAOS = 3,

  /// Hesiod (HS) [Dyer, S., and F. Hsu, "Hesiod", Project Athena Technical Plan - Name Service, April 1987.]
  HESIOD = 4,

  // Unassigned
  // 5-253

  /// QCLASS NONE [RFC2136]
  NONE = 254,

  /// QCLASS * (ANY) [RFC1035]
  ANY = 255,

  // Unassigned
  // 256-65279

  // Reserved for Private Use [RFC6895]
  // 65280-65534

  /// Reserved [RFC6895]
  RESERVED_65535 = 65535,
}

pub fn resourceclass_int(i: usize) -> Option<ResourceClass> {
    match i {
        0 => Some(ResourceClass::RESERVED_0),
        1 => Some(ResourceClass::INTERNET),
        3 => Some(ResourceClass::CHAOS),
        4 => Some(ResourceClass::HESIOD),
        254 => Some(ResourceClass::NONE),
        255 => Some(ResourceClass::ANY),
        65535 => Some(ResourceClass::RESERVED_65535),
        _ => None,
    }
}
#[repr(u16)]
#[derive(Archive, Deserialize, Serialize, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[archive_attr(derive(CheckBytes))]
pub enum ResourceType {

  /// [RFC6895]
  RESERVED_0 = 0,

  /// a host address [RFC1035]
  A = 1,

  /// an authoritative name server [RFC1035]
  NS = 2,

  /// a mail destination (OBSOLETE - use MX) [RFC1035]
  MD_OBSOLETE = 3,

  /// a mail forwarder (OBSOLETE - use MX) [RFC1035]
  MF_OBSOLETE = 4,

  /// the canonical name for an alias [RFC1035]
  CNAME = 5,

  /// marks the start of a zone of authority [RFC1035]
  SOA = 6,

  /// a mailbox domain name (EXPERIMENTAL) [RFC1035]
  MB = 7,

  /// a mail group member (EXPERIMENTAL) [RFC1035]
  MG = 8,

  /// a mail rename domain name (EXPERIMENTAL) [RFC1035]
  MR = 9,

  /// a null RR (EXPERIMENTAL) [RFC1035]
  NULL = 10,

  /// a well known service description [RFC1035]
  WKS = 11,

  /// a domain name pointer [RFC1035]
  PTR = 12,

  /// host information [RFC1035]
  HINFO = 13,

  /// mailbox or mail list information [RFC1035]
  MINFO = 14,

  /// mail exchange [RFC1035]
  MX = 15,

  /// text strings [RFC1035]
  TXT = 16,

  /// for Responsible Person [RFC1183]
  RP = 17,

  /// for AFS Data Base location [RFC1183][RFC5864]
  AFSDB = 18,

  /// for X.25 PSDN address [RFC1183]
  X25 = 19,

  /// for ISDN address [RFC1183]
  ISDN = 20,

  /// for Route Through [RFC1183]
  RT = 21,

  /// for NSAP address, NSAP style A record [RFC1706]
  NSAP = 22,

  /// for domain name pointer, NSAP style [RFC1348][RFC1637][RFC1706]
  NSAP_PTR = 23,

  /// for security signature [RFC4034][RFC3755][RFC2535][RFC2536][RFC2537][RFC2931][RFC3110][RFC3008]
  SIG = 24,

  /// for security key [RFC4034][RFC3755][RFC2535][RFC2536][RFC2537][RFC2539][RFC3008][RFC3110]
  KEY = 25,

  /// X.400 mail mapping information [RFC2163]
  PX = 26,

  /// Geographical Position [RFC1712]
  GPOS = 27,

  /// IP6 Address [RFC3596]
  AAAA = 28,

  /// Location Information [RFC1876]
  LOC = 29,

  /// Next Domain (OBSOLETE) [RFC3755][RFC2535]
  NXT_OBSOLETE = 30,

  /// Endpoint Identifier [Michael_Patton][http://ana-3.lcs.mit.edu/~jnc/nimrod/dns.txt]
  EID = 31,

  /// Nimrod Locator [1][Michael_Patton][http://ana-3.lcs.mit.edu/~jnc/nimrod/dns.txt]
  NIMLOC = 32,

  /// Server Selection [1][RFC2782]
  SRV = 33,

  /// ATM Address [         ATM Forum Technical Committee, "ATM Name System, V2.0", Doc ID: AF-DANS-0152.000, July 2000. Available from and held in escrow by IANA.]
  ATMA = 34,

  /// Naming Authority Pointer [RFC2915][RFC2168][RFC3403]
  NAPTR = 35,

  /// Key Exchanger [RFC2230]
  KX = 36,

  /// CERT [RFC4398]
  CERT = 37,

  /// A6 (OBSOLETE - use AAAA) [RFC3226][RFC2874][RFC6563]
  A6_OBSOLETE = 38,

  /// DNAME [RFC6672]
  DNAME = 39,

  /// SINK [Donald_E_Eastlake][http://tools.ietf.org/html/draft-eastlake-kitchen-sink]
  SINK = 40,

  /// OPT [RFC6891][RFC3225]
  OPT = 41,

  /// APL [RFC3123]
  APL = 42,

  /// Delegation Signer [RFC4034][RFC3658]
  DS = 43,

  /// SSH Key Fingerprint [RFC4255]
  SSHFP = 44,

  /// IPSECKEY [RFC4025]
  IPSECKEY = 45,

  /// RRSIG [RFC4034][RFC3755]
  RRSIG = 46,

  /// NSEC [RFC4034][RFC3755]
  NSEC = 47,

  /// DNSKEY [RFC4034][RFC3755]
  DNSKEY = 48,

  /// DHCID [RFC4701]
  DHCID = 49,

  /// NSEC3 [RFC5155]
  NSEC3 = 50,

  /// NSEC3PARAM [RFC5155]
  NSEC3PARAM = 51,

  /// TLSA [RFC6698]
  TLSA = 52,

  /// S/MIME cert association [RFC8162]
  SMIMEA = 53,

  // Unassigned
  // 54

  /// Host Identity Protocol [RFC8005]
  HIP = 55,

  /// NINFO [Jim_Reid]
  NINFO = 56,

  /// RKEY [Jim_Reid]
  RKEY = 57,

  /// Trust Anchor LINK [Wouter_Wijngaards]
  TALINK = 58,

  /// Child DS [RFC7344]
  CDS = 59,

  /// DNSKEY(s) the Child wants reflected in DS [RFC7344]
  CDNSKEY = 60,

  /// OpenPGP Key [RFC7929]
  OPENPGPKEY = 61,

  /// Child-To-Parent Synchronization [RFC7477]
  CSYNC = 62,

  /// Message Digest Over Zone Data [RFC8976]
  ZONEMD = 63,

  /// Service Binding [draft-ietf-dnsop-svcb-https-00]
  SVCB = 64,

  /// HTTPS Binding [draft-ietf-dnsop-svcb-https-00]
  HTTPS = 65,

  // Unassigned
  // 66-98

  /// [RFC7208]
  SPF = 99,

  /// [IANA-Reserved]
  UINFO = 100,

  /// [IANA-Reserved]
  UID = 101,

  /// [IANA-Reserved]
  GID = 102,

  /// [IANA-Reserved]
  UNSPEC = 103,

  /// [RFC6742]
  NID = 104,

  /// [RFC6742]
  L32 = 105,

  /// [RFC6742]
  L64 = 106,

  /// [RFC6742]
  LP = 107,

  /// an EUI-48 address [RFC7043]
  EUI48 = 108,

  /// an EUI-64 address [RFC7043]
  EUI64 = 109,

  // Unassigned
  // 110-248

  /// Transaction Key [RFC2930]
  TKEY = 249,

  /// Transaction Signature [RFC8945]
  TSIG = 250,

  /// incremental transfer [RFC1995]
  IXFR = 251,

  /// transfer of an entire zone [RFC1035][RFC5936]
  AXFR = 252,

  /// mailbox-related RRs (MB, MG or MR) [RFC1035]
  MAILB = 253,

  /// mail agent RRs (OBSOLETE - see MX) [RFC1035]
  MAILA_OBSOLETE = 254,

  /// A request for some or all records the server has available [RFC1035][RFC6895][RFC8482]
  ANY = 255,

  /// URI [RFC7553]
  URI = 256,

  /// Certification Authority Restriction [RFC8659]
  CAA = 257,

  /// Application Visibility and Control [Wolfgang_Riedel]
  AVC = 258,

  /// Digital Object Architecture [draft-durand-doa-over-dns]
  DOA = 259,

  /// Automatic Multicast Tunneling Relay [RFC8777]
  AMTRELAY = 260,

  // Unassigned
  // 261-32767

  /// DNSSEC Trust Authorities [Sam_Weiler][http://cameo.library.cmu.edu/][         Deploying DNSSEC Without a Signed Root.  Technical Report 1999-19, Information Networking Institute, Carnegie Mellon University, April 2004.]
  TA = 32768,

  /// DNSSEC Lookaside Validation (OBSOLETE) [RFC8749][RFC4431]
  DLV_OBSOLETE = 32769,

  // Unassigned
  // 32770-65279

  // Private use
  // 65280-65534

  /// Reserved
  RESERVED_65535 = 65535,
}

pub fn resourcetype_int(i: usize) -> Option<ResourceType> {
    match i {
        0 => Some(ResourceType::RESERVED_0),
        1 => Some(ResourceType::A),
        2 => Some(ResourceType::NS),
        3 => Some(ResourceType::MD_OBSOLETE),
        4 => Some(ResourceType::MF_OBSOLETE),
        5 => Some(ResourceType::CNAME),
        6 => Some(ResourceType::SOA),
        7 => Some(ResourceType::MB),
        8 => Some(ResourceType::MG),
        9 => Some(ResourceType::MR),
        10 => Some(ResourceType::NULL),
        11 => Some(ResourceType::WKS),
        12 => Some(ResourceType::PTR),
        13 => Some(ResourceType::HINFO),
        14 => Some(ResourceType::MINFO),
        15 => Some(ResourceType::MX),
        16 => Some(ResourceType::TXT),
        17 => Some(ResourceType::RP),
        18 => Some(ResourceType::AFSDB),
        19 => Some(ResourceType::X25),
        20 => Some(ResourceType::ISDN),
        21 => Some(ResourceType::RT),
        22 => Some(ResourceType::NSAP),
        23 => Some(ResourceType::NSAP_PTR),
        24 => Some(ResourceType::SIG),
        25 => Some(ResourceType::KEY),
        26 => Some(ResourceType::PX),
        27 => Some(ResourceType::GPOS),
        28 => Some(ResourceType::AAAA),
        29 => Some(ResourceType::LOC),
        30 => Some(ResourceType::NXT_OBSOLETE),
        31 => Some(ResourceType::EID),
        32 => Some(ResourceType::NIMLOC),
        33 => Some(ResourceType::SRV),
        34 => Some(ResourceType::ATMA),
        35 => Some(ResourceType::NAPTR),
        36 => Some(ResourceType::KX),
        37 => Some(ResourceType::CERT),
        38 => Some(ResourceType::A6_OBSOLETE),
        39 => Some(ResourceType::DNAME),
        40 => Some(ResourceType::SINK),
        41 => Some(ResourceType::OPT),
        42 => Some(ResourceType::APL),
        43 => Some(ResourceType::DS),
        44 => Some(ResourceType::SSHFP),
        45 => Some(ResourceType::IPSECKEY),
        46 => Some(ResourceType::RRSIG),
        47 => Some(ResourceType::NSEC),
        48 => Some(ResourceType::DNSKEY),
        49 => Some(ResourceType::DHCID),
        50 => Some(ResourceType::NSEC3),
        51 => Some(ResourceType::NSEC3PARAM),
        52 => Some(ResourceType::TLSA),
        53 => Some(ResourceType::SMIMEA),
        55 => Some(ResourceType::HIP),
        56 => Some(ResourceType::NINFO),
        57 => Some(ResourceType::RKEY),
        58 => Some(ResourceType::TALINK),
        59 => Some(ResourceType::CDS),
        60 => Some(ResourceType::CDNSKEY),
        61 => Some(ResourceType::OPENPGPKEY),
        62 => Some(ResourceType::CSYNC),
        63 => Some(ResourceType::ZONEMD),
        64 => Some(ResourceType::SVCB),
        65 => Some(ResourceType::HTTPS),
        99 => Some(ResourceType::SPF),
        100 => Some(ResourceType::UINFO),
        101 => Some(ResourceType::UID),
        102 => Some(ResourceType::GID),
        103 => Some(ResourceType::UNSPEC),
        104 => Some(ResourceType::NID),
        105 => Some(ResourceType::L32),
        106 => Some(ResourceType::L64),
        107 => Some(ResourceType::LP),
        108 => Some(ResourceType::EUI48),
        109 => Some(ResourceType::EUI64),
        249 => Some(ResourceType::TKEY),
        250 => Some(ResourceType::TSIG),
        251 => Some(ResourceType::IXFR),
        252 => Some(ResourceType::AXFR),
        253 => Some(ResourceType::MAILB),
        254 => Some(ResourceType::MAILA_OBSOLETE),
        255 => Some(ResourceType::ANY),
        256 => Some(ResourceType::URI),
        257 => Some(ResourceType::CAA),
        258 => Some(ResourceType::AVC),
        259 => Some(ResourceType::DOA),
        260 => Some(ResourceType::AMTRELAY),
        32768 => Some(ResourceType::TA),
        32769 => Some(ResourceType::DLV_OBSOLETE),
        65535 => Some(ResourceType::RESERVED_65535),
        _ => None,
    }
}
#[repr(u8)]
#[derive(Archive, Deserialize, Serialize, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[archive_attr(derive(CheckBytes))]
pub enum OpCode {

  /// Query [RFC1035]
  QUERY = 0,

  /// IQuery  (Inverse Query, OBSOLETE) [RFC3425]
  IQUERY_OBSOLETE = 1,

  /// Status [RFC1035]
  STATUS = 2,

  // Unassigned
  // 3

  /// Notify [RFC1996]
  NOTIFY = 4,

  /// Update [RFC2136]
  UPDATE = 5,

  /// DNS Stateful Operations (DSO) [RFC8490]
  DSO = 6,

  // Unassigned
  // 7-15
}

pub fn opcode_int(i: usize) -> Option<OpCode> {
    match i {
        0 => Some(OpCode::QUERY),
        1 => Some(OpCode::IQUERY_OBSOLETE),
        2 => Some(OpCode::STATUS),
        4 => Some(OpCode::NOTIFY),
        5 => Some(OpCode::UPDATE),
        6 => Some(OpCode::DSO),
        _ => None,
    }
}
#[repr(u16)]
#[derive(Archive, Deserialize, Serialize, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[archive_attr(derive(CheckBytes))]
pub enum ResponseCode {

  /// NoError: No Error [RFC1035]
  NOERROR = 0,

  /// FormErr: Format Error [RFC1035]
  FORMERR = 1,

  /// ServFail: Server Failure [RFC1035]
  SERVFAIL = 2,

  /// NXDomain: Non-Existent Domain [RFC1035]
  NXDOMAIN = 3,

  /// NotImp: Not Implemented [RFC1035]
  NOTIMP = 4,

  /// Refused: Query Refused [RFC1035]
  REFUSED = 5,

  /// YXDomain: Name Exists when it should not [RFC2136][RFC6672]
  YXDOMAIN = 6,

  /// YXRRSet: RR Set Exists when it should not [RFC2136]
  YXRRSET = 7,

  /// NXRRSet: RR Set that should exist does not [RFC2136]
  NXRRSET = 8,

  /// NotAuth: Server Not Authoritative for zone [RFC2136]
  /// NotAuth: Not Authorized [RFC2845]
  NOTAUTH = 9,

  /// NotZone: Name not contained in zone [RFC2136]
  NOTZONE = 10,

  /// DSOTYPENI: DSO-TYPE Not Implemented [RFC8490]
  DSOTYPENI = 11,

  // Unassigned
  // 12-15

  /// BADVERS: Bad OPT Version [RFC6891]
  /// BADSIG: TSIG Signature Failure [RFC2845]
  BADVERS_BADSIG = 16,

  /// BADKEY: Key not recognized [RFC8945]
  BADKEY = 17,

  /// BADTIME: Signature out of time window [RFC8945]
  BADTIME = 18,

  /// BADMODE: Bad TKEY Mode [RFC2930]
  BADMODE = 19,

  /// BADNAME: Duplicate key name [RFC2930]
  BADNAME = 20,

  /// BADALG: Algorithm not supported [RFC2930]
  BADALG = 21,

  /// BADTRUNC: Bad Truncation [RFC8945]
  BADTRUNC = 22,

  /// BADCOOKIE: Bad/missing Server Cookie [RFC7873]
  BADCOOKIE = 23,

  // Unassigned
  // 24-3840

  // Reserved for Private Use [RFC6895]
  // 3841-4095

  // Unassigned
  // 4096-65534

  /// Reserved, can be allocated by Standards Action [RFC6895]
  RESERVED_65535 = 65535,
}

pub fn responsecode_int(i: usize) -> Option<ResponseCode> {
    match i {
        0 => Some(ResponseCode::NOERROR),
        1 => Some(ResponseCode::FORMERR),
        2 => Some(ResponseCode::SERVFAIL),
        3 => Some(ResponseCode::NXDOMAIN),
        4 => Some(ResponseCode::NOTIMP),
        5 => Some(ResponseCode::REFUSED),
        6 => Some(ResponseCode::YXDOMAIN),
        7 => Some(ResponseCode::YXRRSET),
        8 => Some(ResponseCode::NXRRSET),
        9 => Some(ResponseCode::NOTAUTH),
        10 => Some(ResponseCode::NOTZONE),
        11 => Some(ResponseCode::DSOTYPENI),
        16 => Some(ResponseCode::BADVERS_BADSIG),
        17 => Some(ResponseCode::BADKEY),
        18 => Some(ResponseCode::BADTIME),
        19 => Some(ResponseCode::BADMODE),
        20 => Some(ResponseCode::BADNAME),
        21 => Some(ResponseCode::BADALG),
        22 => Some(ResponseCode::BADTRUNC),
        23 => Some(ResponseCode::BADCOOKIE),
        65535 => Some(ResponseCode::RESERVED_65535),
        _ => None,
    }
}
#[repr(u16)]
#[derive(Archive, Deserialize, Serialize, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[archive_attr(derive(CheckBytes))]
pub enum OPTOptionCode {

  /// Reserved [RFC6891]
  NONE = 0,

  /// LLQ: Optional [RFC8764]
  LLQ = 1,

  /// UL: On-hold [http://files.dns-sd.org/draft-sekar-dns-ul.txt]
  UL = 2,

  /// NSID: Standard [RFC5001]
  NSID = 3,

  /// Reserved [draft-cheshire-edns0-owner-option]
  RESERVED_4 = 4,

  /// DAU: Standard [RFC6975]
  DAU = 5,

  /// DHU: Standard [RFC6975]
  DHU = 6,

  /// N3U: Standard [RFC6975]
  N3U = 7,

  /// edns-client-subnet: Optional [RFC7871]
  EDNS_CLIENT_SUBNET = 8,

  /// EDNS EXPIRE: Optional [RFC7314]
  EDNS_EXPIRE = 9,

  /// COOKIE: Standard [RFC7873]
  COOKIE = 10,

  /// edns-tcp-keepalive: Standard [RFC7828]
  EDNS_TCP_KEEPALIVE = 11,

  /// Padding: Standard [RFC7830]
  PADDING = 12,

  /// CHAIN: Standard [RFC7901]
  CHAIN = 13,

  /// edns-key-tag: Optional [RFC8145]
  EDNS_KEY_TAG = 14,

  /// Extended DNS Error: Standard [RFC8914]
  EXTENDED_DNS_ERROR = 15,

  /// EDNS-Client-Tag: Optional [draft-bellis-dnsop-edns-tags]
  EDNS_CLIENT_TAG = 16,

  /// EDNS-Server-Tag: Optional [draft-bellis-dnsop-edns-tags]
  EDNS_SERVER_TAG = 17,

  // Unassigned
  // 18-26945

  /// DeviceID: Optional [https://docs.umbrella.com/developer/networkdevices-api/identifying-dns-traffic2][Brian_Hartvigsen]
  DEVICEID = 26946,

  // Unassigned
  // 26947-65000

  // Reserved for Local/Experimental Use [RFC6891]
  // 65001-65534

  /// Reserved for future expansion [RFC6891]
  RESERVED_FOR_FUTURE_EXPANSION = 65535,
}

pub fn optoptioncode_int(i: usize) -> Option<OPTOptionCode> {
    match i {
        0 => Some(OPTOptionCode::NONE),
        1 => Some(OPTOptionCode::LLQ),
        2 => Some(OPTOptionCode::UL),
        3 => Some(OPTOptionCode::NSID),
        4 => Some(OPTOptionCode::RESERVED_4),
        5 => Some(OPTOptionCode::DAU),
        6 => Some(OPTOptionCode::DHU),
        7 => Some(OPTOptionCode::N3U),
        8 => Some(OPTOptionCode::EDNS_CLIENT_SUBNET),
        9 => Some(OPTOptionCode::EDNS_EXPIRE),
        10 => Some(OPTOptionCode::COOKIE),
        11 => Some(OPTOptionCode::EDNS_TCP_KEEPALIVE),
        12 => Some(OPTOptionCode::PADDING),
        13 => Some(OPTOptionCode::CHAIN),
        14 => Some(OPTOptionCode::EDNS_KEY_TAG),
        15 => Some(OPTOptionCode::EXTENDED_DNS_ERROR),
        16 => Some(OPTOptionCode::EDNS_CLIENT_TAG),
        17 => Some(OPTOptionCode::EDNS_SERVER_TAG),
        26946 => Some(OPTOptionCode::DEVICEID),
        65535 => Some(OPTOptionCode::RESERVED_FOR_FUTURE_EXPANSION),
        _ => None,
    }
}
