/// Local and Redis cache clients.
pub mod cache;

/// Clients for querying upstream DNS servers over various protocols/methods
pub mod client;

/// Parsers/generators for converting raw DNS messages into equivalent framebuffer representations
pub mod codec;

/// Utilities relating to Originz toml configuration.
pub mod config;

/// Client for downloading data over HTTP to local disk.
pub mod fetcher;

/// Filters/overrides to be applied before querying upstream DNS servers
pub mod filter;

/// Implements support for running the hyper HTTP library against smol, not tokio.
/// This allows me to stop spending hours every 4-6 months to keep Originz on the Tokio upgrade treadmill.
/// The hyper integration meanwhile is set up to resolve hosts against ourselves, instead of the system resolver.
pub mod hyper_smol;

/// Listens to a TCP socket for incoming requests, adding them to a channel.
pub mod listen_tcp;

/// Listens to a UDP socket for incoming requests, adding them to a channel.
pub mod listen_udp;

/// Utilities relating to setting up log output.
pub mod logging;

/// Runs a DNS query, checking for matching filters or going to the upstream resolver
pub mod lookup;

/// Wraps one or more DNS clients and performs queries through them
pub mod resolver;

/// Runs the UDP/TCP listeners and worker threads.
pub mod runner;

/// Definitions of serializable framebuffer representations for DNS messages
pub mod specs;

extern crate packed_struct_codegen;
