use std::ffi::OsString;
use std::path::Path;

/// File extension used on zstd-compressed files.
/// This is in addition to any existing extension, e.g. "mycrimes.txt.zst"
pub const ZSTD_EXTENSION: &'static str = "zst";

pub fn is_zstd_extension(path: &Path) -> bool {
    return match path.extension() {
        Some(ext) => ext == OsString::from(ZSTD_EXTENSION).as_os_str(),
        None => false,
    };
}
