/// Deserializes DNS messages, returning parsed `Message` objects.
pub mod decoder;

/// Serializes `Message` objects as DNS wire messages.
pub mod encoder;

/// Encodes and decodes length-delimited character strings.
/// Public to allow access for property tests.
pub mod character_string;

/// Encodes and decodes length-delimited character strings.
/// Public to allow access for property tests.
pub mod domain_name;

pub mod message;

mod rdata;
