use anyhow::Result;
use async_trait::async_trait;
use bytes::BytesMut;
use std::io::ErrorKind;

use crate::specs::message::Message;

#[async_trait]
pub trait DnsClient {
    /// Runs a query for the provided request, then returns the response.
    /// query_buffer may also be used as a scratch pad for handling the request.
    async fn query(&mut self, request: &Message, query_buffer: &mut BytesMut) -> Result<Option<Message>>;
}

fn is_timeout(kind: ErrorKind) -> bool {
    return match kind {
        ErrorKind::WouldBlock | ErrorKind::TimedOut => true,
        _ => false,
    };
}

/// Parses configured upstream strings into DNS clients
pub mod upstream;

/// Client: DNS over HTTPS
pub mod https;
/// Client: Host OS lookup
pub mod system;
/// Client: TCP (fallback for UDP)
pub mod tcp;
/// Client: UDP
pub mod udp;
