use anyhow::Result;
use async_trait::async_trait;

use crate::codec::message::RequestInfo;
use crate::specs::message::Message;

#[async_trait]
pub trait DnsCache {
    /// Queries the cache for a response.
    async fn fetch(&mut self, request_info: RequestInfo) -> Result<Option<Message>>;

    /// Stores an upstream server response Message to the cache.
    async fn store(&mut self, request_info: RequestInfo, response: Message) -> Result<()>;
}

/// Cache: Redis (client)
pub mod redis;

/// Cache: Retainer (local)
pub mod retainer;

/// Cache background task that handles fetch/store requests
pub mod task;
