# ODPI-C version 4.2

Oracle Database Programming Interface for C (ODPI-C) is an open source library
of C code that simplifies access to Oracle Database for applications written in
C or C++.  It is a wrapper over [Oracle Call Interface
(OCI)](http://www.oracle.com/technetwork/database/features/oci/index.html) that
makes applications and language interfaces easier to develop.

ODPI-C supports basic and advanced features of Oracle Database and
Oracle Client.  See the [homepage](https://oracle.github.io/odpi/) for
a list.

## Installation

See [ODPI-C Installation](https://oracle.github.io/odpi/doc/installation.html).

## Documentation

See the [ODPI-C Documentation](https://oracle.github.io/odpi/doc/index.html) and
[Release Notes](https://oracle.github.io/odpi/doc/releasenotes.html).

## Samples

See [/samples](https://github.com/oracle/odpi/tree/main/samples).

## Help

Please report bugs and ask questions using [GitHub issues](https://github.com/oracle/odpi/issues).

## Tests

See [/test](https://github.com/oracle/odpi/tree/main/test).

## Contributing

See [CONTRIBUTING](https://github.com/oracle/odpi/blob/main/CONTRIBUTING.md).

## Drivers Using ODPI-C

Oracle Drivers:
* [cx_Oracle](https://oracle.github.io/python-cx_Oracle) Python interface.
* [node-oracledb](https://oracle.github.io/node-oracledb) Node.js module.

Third-party Drivers:
* [godror](https://github.com/godror/godror) Go Driver.
* [odpic-raw](https://github.com/leptonyu/odpic-raw)  Haskell Raw Bindings.
* [ruby-ODPI ](https://github.com/kubo/ruby-odpi) Ruby Interface.
* [rust-oracle ](https://github.com/kubo/rust-oracle) Driver for Rust.
* [Oracle.jl](https://github.com/felipenoris/Oracle.jl) Driver for Julia.
* [oranif](https://github.com/KonnexionsGmbH/oranif) Driver for Erlang.
* [nimodpi](https://github.com/mikra01/nimodpi) Driver for Nim.

## License

Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.

This program is free software: you can modify it and/or redistribute it under
the terms of:

(i)  the Universal Permissive License v 1.0 or at your option, any
     later version (<http://oss.oracle.com/licenses/upl>); and/or

(ii) the Apache License v 2.0. (<http://www.apache.org/licenses/LICENSE-2.0>)
