use std::collections::HashMap;

pub struct Model {
  variables: HashMap<String, Option<f64>>,
  constraints: Vec<Constraint>,
}

impl Model {
  pub fn new() -> Self {
    Model {
      variables: HashMap::new(),
      constraints: vec![],
    }
  }

  pub fn solve() -> Result<Solution, SolverError> {
    Ok(Solution)
  }

  pub fn add_variable(&mut self, variable: Variable) {
    self.variables.insert(variable.name, variable.value);
  }

  pub fn add_constraint(&mut self, constraint: Constraint) {}
  pub fn maximise(&mut self, variable: Variable) {}
  pub fn minimise(&mut self, variable: Variable) {}
}

pub struct Variable {
  name: String,
  value: Option<f64>,
}

impl Variable {
  pub fn new(name: String) -> Self {
    Variable { name, value: None }
  }
}

pub struct Constraint;
pub struct Solution;
pub struct SolverError;
