#[derive(Debug)]
pub struct OperatorMachineData {
    pub machine_status: MachineStatus,
    pub time: i64,
}

#[derive(Debug)]
pub struct MachineStatus {
    pub turret: Turret,
    pub head: Head,
}

#[derive(Debug)]
pub struct Turret {
    pub pos_x: f32,
    pub pos_y: f32,
    pub pos_z: f32,
    pub angle: f32,
}

#[derive(Debug)]
pub struct Head {
    pub pos_x: f32,
    pub pos_y: f32,
    pub pos_z: f32,
    pub angle_phi: f32,
    pub angle_rho: f32,
    pub angle_theta: f32,
    pub action: HeadAction,
    pub tree_grabed: Option<i32>,
}

#[derive(Debug)]
pub enum HeadAction {
    Idle,
    RollActivated,
    KnifeActivated,
    RollAndKnifeActivated,
}
