use super::types::*;
use crate::link;
link! {

/* automatically generated by rust-bindgen 0.58.1 */

extern "C" {
    #[doc = " @brief Returns number of version that is exported. Use the ie_version_free() to free memory."]
    #[doc = " @return Version number of the API."]
    pub fn ie_c_api_version() -> ie_version_t;
}
extern "C" {
    #[doc = " @brief Release the memory allocated by ie_c_api_version."]
    #[doc = " @param version A pointer to the ie_version_t to free memory."]
    pub fn ie_version_free(version: *mut ie_version_t);
}
extern "C" {
    #[doc = " @brief Release the memory allocated by ie_param_t."]
    #[doc = " @param param A pointer to the ie_param_t to free memory."]
    pub fn ie_param_free(param: *mut ie_param_t);
}
extern "C" {
    #[doc = " @brief Constructs Inference Engine Core instance using XML configuration file with devices description."]
    #[doc = " See RegisterPlugins for more details. Use the ie_core_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param xml_config_file A path to .xml file with devices to load from. If XML configuration file is not specified,"]
    #[doc = " then default Inference Engine devices are loaded from the default plugin.xml file."]
    #[doc = " @param core A pointer to the newly created ie_core_t."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_create(
        xml_config_file: *const ::std::os::raw::c_char,
        core: *mut *mut ie_core_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases memory occupied by core."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the core to free memory."]
    pub fn ie_core_free(core: *mut *mut ie_core_t);
}
extern "C" {
    #[doc = " @brief Gets version information of the device specified. Use the ie_core_versions_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param device_name Name to identify device."]
    #[doc = " @param versions A pointer to versions corresponding to device_name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_get_versions(
        core: *const ie_core_t,
        device_name: *const ::std::os::raw::c_char,
        versions: *mut ie_core_versions_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases memory occupied by ie_core_versions."]
    #[doc = " @ingroup Core"]
    #[doc = " @param vers A pointer to the ie_core_versions to free memory."]
    pub fn ie_core_versions_free(vers: *mut ie_core_versions_t);
}
extern "C" {
    #[doc = " @brief Reads the model from the .xml and .bin files of the IR. Use the ie_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param xml .xml file's path of the IR."]
    #[doc = " @param weights_file .bin file's path of the IR, if path is empty, will try to read bin file with the same name as xml and"]
    #[doc = " if bin file with the same name was not found, will load IR without weights."]
    #[doc = " @param network A pointer to the newly created network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_read_network(
        core: *mut ie_core_t,
        xml: *const ::std::os::raw::c_char,
        weights_file: *const ::std::os::raw::c_char,
        network: *mut *mut ie_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Reads the model from an xml string and a blob of the bin part of the IR. Use the ie_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param xml_content Xml content of the IR."]
    #[doc = " @param xml_content_size Number of bytes in the xml content of the IR."]
    #[doc = " @param weight_blob Blob containing the bin part of the IR."]
    #[doc = " @param network A pointer to the newly created network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_read_network_from_memory(
        core: *mut ie_core_t,
        xml_content: *const u8,
        xml_content_size: usize,
        weight_blob: *const ie_blob_t,
        network: *mut *mut ie_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates an executable network from a network previously exported to a file. Users can create as many networks as they need and use"]
    #[doc = " them simultaneously (up to the limitation of the hardware resources). Use the ie_exec_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param file_name A path to the location of the exported file."]
    #[doc = " @param device_name A name of the device to load the network to."]
    #[doc = " @param config Device configuration."]
    #[doc = " @param exe_network A pointer to the newly created executable network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_import_network(
        core: *mut ie_core_t,
        file_name: *const ::std::os::raw::c_char,
        device_name: *const ::std::os::raw::c_char,
        config: *const ie_config_t,
        exe_network: *mut *mut ie_executable_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates an executable network from a network previously exported to memory. Users can create as many networks as they need and use"]
    #[doc = " them simultaneously (up to the limitation of the hardware resources). Use the ie_exec_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param content A pointer to content of the exported network."]
    #[doc = " @param content_size Number of bytes in the exported network."]
    #[doc = " @param device_name A name of the device to load the network to."]
    #[doc = " @param config Device configuration."]
    #[doc = " @param exe_network A pointer to the newly created executable network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_import_network_from_memory(
        core: *mut ie_core_t,
        content: *const u8,
        content_size: usize,
        device_name: *const ::std::os::raw::c_char,
        config: *const ie_config_t,
        exe_network: *mut *mut ie_executable_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Exports an executable network to a .bin file."]
    #[doc = " @ingroup Core"]
    #[doc = " @param exe_network A pointer to the newly created executable network."]
    #[doc = " @param file_name Path to the file to export the network to."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_export_network(
        exe_network: *mut ie_executable_network_t,
        file_name: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates an executable network from a given network object. Users can create as many networks as they need and use"]
    #[doc = " them simultaneously (up to the limitation of the hardware resources). Use the ie_exec_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param network A pointer to the input ie_network instance to create the executable network from."]
    #[doc = " @param device_name Name of the device to load the network to."]
    #[doc = " @param config Device configuration."]
    #[doc = " @param exe_network A pointer to the newly created executable network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_load_network(
        core: *mut ie_core_t,
        network: *const ie_network_t,
        device_name: *const ::std::os::raw::c_char,
        config: *const ie_config_t,
        exe_network: *mut *mut ie_executable_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Reads model and creates an executable network from IR or ONNX file. Users can create as many networks as they need and use"]
    #[doc = " them simultaneously (up to the limitation of the hardware resources). Use the ie_exec_network_free() method to free memory."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to the ie_core_t instance."]
    #[doc = " @param xml .xml file's path of the IR. Weights file name will be calculated automatically"]
    #[doc = " @param device_name Name of device to load network to."]
    #[doc = " @param config Device configuration."]
    #[doc = " @param exe_network A pointer to the newly created executable network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_load_network_from_file(
        core: *mut ie_core_t,
        xml: *const ::std::os::raw::c_char,
        device_name: *const ::std::os::raw::c_char,
        config: *const ie_config_t,
        exe_network: *mut *mut ie_executable_network_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Sets configuration for device."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param ie_core_config Device configuration."]
    #[doc = " @param device_name An optional name of a device. If device name is not specified,"]
    #[doc = " the config is set for all the registered devices."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_set_config(
        core: *mut ie_core_t,
        ie_core_config: *const ie_config_t,
        device_name: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Registers a new device and a plugin which implement this device inside Inference Engine."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param plugin_name A name of a plugin. Depending on a platform, plugin_name is wrapped with"]
    #[doc = " a shared library suffix and a prefix to identify a full name of the library."]
    #[doc = " @param device_name A device name to register plugin for. If not specified, the method registers"]
    #[doc = " a plugin with the default name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_register_plugin(
        core: *mut ie_core_t,
        plugin_name: *const ::std::os::raw::c_char,
        device_name: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Registers plugins specified in an \".xml\" configuration file."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param xml_config_file A full path to \".xml\" file containing plugins configuration."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_register_plugins(
        core: *mut ie_core_t,
        xml_config_file: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Unregisters a plugin with a specified device name."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param device_name A device name of the device to unregister."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_unregister_plugin(
        core: *mut ie_core_t,
        device_name: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Loads extension library to the device with a specified device name."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param extension_path Path to the extensions library file to load to a device."]
    #[doc = " @param device_name A device name of a device to load the extensions to."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_add_extension(
        core: *mut ie_core_t,
        extension_path: *const ::std::os::raw::c_char,
        device_name: *const ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets general runtime metric for dedicated hardware. The method is needed to request common device properties"]
    #[doc = " which are executable network agnostic. It can be device name, temperature, other devices-specific values."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param device_name A name of a device to get a metric value."]
    #[doc = " @param metric_name A metric name to request."]
    #[doc = " @param param_result A metric value corresponding to the metric_name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_get_metric(
        core: *const ie_core_t,
        device_name: *const ::std::os::raw::c_char,
        metric_name: *const ::std::os::raw::c_char,
        param_result: *mut ie_param_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets configuration dedicated to device behaviour. The method is targeted to extract information"]
    #[doc = " which can be set via SetConfig method."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param device_name A name of a device to get a configuration value."]
    #[doc = " @param config_name Name of a configuration."]
    #[doc = " @param param_result A configuration value corresponding to the config_name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_get_config(
        core: *const ie_core_t,
        device_name: *const ::std::os::raw::c_char,
        config_name: *const ::std::os::raw::c_char,
        param_result: *mut ie_param_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets available devices for neural network inference."]
    #[doc = " @ingroup Core"]
    #[doc = " @param core A pointer to ie_core_t instance."]
    #[doc = " @param avai_devices The devices are returned as { CPU, GPU.0, GPU.1, MYRIAD }"]
    #[doc = " If there more than one device of specific type, they are enumerated with .# suffix"]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_core_get_available_devices(
        core: *const ie_core_t,
        avai_devices: *mut ie_available_devices_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases memory occpuied by ie_available_devices_t"]
    #[doc = " @ingroup Core"]
    #[doc = " @param avai_devices A pointer to the ie_available_devices_t to free memory."]
    pub fn ie_core_available_devices_free(avai_devices: *mut ie_available_devices_t);
}
extern "C" {
    #[doc = " @brief Releases memory occupied by ExecutableNetwork."]
    #[doc = " @ingroup ExecutableNetwork"]
    #[doc = " @param ie_exec_network A pointer to the ExecutableNetwork to free memory."]
    pub fn ie_exec_network_free(ie_exec_network: *mut *mut ie_executable_network_t);
}
extern "C" {
    #[doc = " @brief Creates an inference request instance used to infer the network. The created request has allocated input"]
    #[doc = " and output blobs (that can be changed later). Use the ie_infer_request_free() method to free memory."]
    #[doc = " @ingroup ExecutableNetwork"]
    #[doc = " @param ie_exec_network A pointer to ie_executable_network_t instance."]
    #[doc = " @param request A pointer to the newly created ie_infer_request_t instance"]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_exec_network_create_infer_request(
        ie_exec_network: *mut ie_executable_network_t,
        request: *mut *mut ie_infer_request_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets general runtime metric for an executable network. It can be network name, actual device ID on which executable network is running"]
    #[doc = " or all other properties which cannot be changed dynamically."]
    #[doc = " @ingroup ExecutableNetwork"]
    #[doc = " @param ie_exec_network A pointer to ie_executable_network_t instance."]
    #[doc = " @param metric_name A metric name to request."]
    #[doc = " @param param_result A metric value corresponding to the metric_name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_exec_network_get_metric(
        ie_exec_network: *const ie_executable_network_t,
        metric_name: *const ::std::os::raw::c_char,
        param_result: *mut ie_param_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Sets configuration for current executable network. Currently, the method can be used"]
    #[doc = " when the network run on the Multi device and the configuration parameter is only can be \"MULTI_DEVICE_PRIORITIES\""]
    #[doc = " @ingroup ExecutableNetwork"]
    #[doc = " @param ie_exec_network A pointer to ie_executable_network_t instance."]
    #[doc = " @param param_config A pointer to device configuration.."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_exec_network_set_config(
        ie_exec_network: *mut ie_executable_network_t,
        param_config: *const ie_config_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets configuration for current executable network. The method is responsible to"]
    #[doc = " extract information which affects executable network execution."]
    #[doc = " @ingroup ExecutableNetwork"]
    #[doc = " @param ie_exec_network A pointer to ie_executable_network_t instance."]
    #[doc = " @param metric_config A configuration parameter name to request."]
    #[doc = " @param param_result A configuration value corresponding to a configuration parameter name."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_exec_network_get_config(
        ie_exec_network: *const ie_executable_network_t,
        metric_config: *const ::std::os::raw::c_char,
        param_result: *mut ie_param_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases memory occupied by ie_infer_request_t instance."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to the ie_infer_request_t to free memory."]
    pub fn ie_infer_request_free(infer_request: *mut *mut ie_infer_request_t);
}
extern "C" {
    #[doc = " @brief Gets input/output data for inference"]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @param name Name of input or output blob."]
    #[doc = " @param blob A pointer to input or output blob. The type of Blob must match the network input precision and size."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_get_blob(
        infer_request: *mut ie_infer_request_t,
        name: *const ::std::os::raw::c_char,
        blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Sets input/output data to inference."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @param name Name of input or output blob."]
    #[doc = " @param blob Reference to input or output blob. The type of a blob must match the network input precision and size."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_set_blob(
        infer_request: *mut ie_infer_request_t,
        name: *const ::std::os::raw::c_char,
        blob: *const ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Starts synchronous inference of the infer request and fill outputs."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_infer(infer_request: *mut ie_infer_request_t) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Starts asynchronous inference of the infer request and fill outputs."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_infer_async(infer_request: *mut ie_infer_request_t) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Sets a callback function that will be called on success or failure of asynchronous request"]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @param callback  A function to be called."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_set_completion_callback(
        infer_request: *mut ie_infer_request_t,
        callback: *mut ie_complete_call_back_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Waits for the result to become available. Blocks until specified timeout elapses or the result becomes available, whichever comes first."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @param timeout Maximum duration in milliseconds to block for"]
    #[doc = " @note There are special cases when timeout is equal some value of the WaitMode enum:"]
    #[doc = " * 0 - Immediately returns the inference status. It does not block or interrupt execution."]
    #[doc = " * -1 - waits until inference result becomes available"]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_wait(
        infer_request: *mut ie_infer_request_t,
        timeout: i64,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief  Sets new batch size for certain infer request when dynamic batching is enabled in executable network that created this request."]
    #[doc = " @ingroup InferRequest"]
    #[doc = " @param infer_request A pointer to ie_infer_request_t instance."]
    #[doc = " @param size New batch size to be used by all the following inference calls for this request."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_infer_request_set_batch(
        infer_request: *mut ie_infer_request_t,
        size: usize,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief When network is loaded into the Infernece Engine, it is not required anymore and should be released"]
    #[doc = " @ingroup Network"]
    #[doc = " @param network The pointer to the instance of the ie_network_t to free."]
    pub fn ie_network_free(network: *mut *mut ie_network_t);
}
extern "C" {
    #[doc = " @brief Get name of network."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to the instance of the ie_network_t to get a name from."]
    #[doc = " @param name Name of the network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_name(
        network: *const ie_network_t,
        name: *mut *mut ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets number of inputs for the network."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to the instance of the ie_network_t to get number of input information."]
    #[doc = " @param size_result A number of the instance's input information."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_inputs_number(
        network: *const ie_network_t,
        size_result: *mut usize,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets name corresponding to the \"number\". Use the ie_network_name_free() method to free memory."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to theinstance of the ie_network_t to get input information."]
    #[doc = " @param number An id of input information ."]
    #[doc = " @param name Input name corresponding to the number."]
    #[doc = " @return status Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_name(
        network: *const ie_network_t,
        number: usize,
        name: *mut *mut ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets a precision of the input data provided by user."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param prec_result A pointer to the precision used for input blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_precision(
        network: *const ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        prec_result: *mut precision_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Changes the precision of the input data provided by the user."]
    #[doc = " This function should be called before loading the network to the device."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param p A new precision of the input data to set (eg. precision_e.FP16)."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_input_precision(
        network: *mut ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        p: precision_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets a layout of the input data."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param layout_result A pointer to the layout used for input blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_layout(
        network: *const ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        layout_result: *mut layout_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Changes the layout of the input data named \"input_name\"."]
    #[doc = " This function should be called before loading the network to the device."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param l A new layout of the input data to set."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_input_layout(
        network: *mut ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        l: layout_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets dimensions/shape of the input data with reversed order."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param dims_result A pointer to the dimensions used for input blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_dims(
        network: *const ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        dims_result: *mut dimensions_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets pre-configured resize algorithm."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param resize_alg_result The pointer to the resize algorithm used for input blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_resize_algorithm(
        network: *const ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        resize_alg_result: *mut resize_alg_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Sets resize algorithm to be used during pre-processing"]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param resize_algo Resize algorithm."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_input_resize_algorithm(
        network: *mut ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        resize_algo: resize_alg_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets color format of the input data."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param colformat_result The pointer to the color format used for input blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_color_format(
        network: *const ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        colformat_result: *mut colorformat_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Changes the color format of the input data."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param input_name Name of input data."]
    #[doc = " @param color_format Color format of the input data."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_color_format(
        network: *mut ie_network_t,
        input_name: *const ::std::os::raw::c_char,
        color_format: colorformat_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Helper method collect all input shapes with input names of corresponding input data."]
    #[doc = " Use the ie_network_input_shapes_free() method to free memory."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to the instance of the ie_network_t to get input shapes."]
    #[doc = " @param shapes A pointer to the input_shapes."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_input_shapes(
        network: *mut ie_network_t,
        shapes: *mut input_shapes_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Run shape inference with new input shapes for the network."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to the instance of the ie_network_t to reshape."]
    #[doc = " @param shapes A new input shapes to set for the network."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_reshape(network: *mut ie_network_t, shapes: input_shapes_t) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets number of output for the network."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to the instance of the ie_network_t to get number of output information."]
    #[doc = " @param size_result A number of the network's output information."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_outputs_number(
        network: *const ie_network_t,
        size_result: *mut usize,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets name corresponding to the \"number\". Use the ie_network_name_free() method to free memory."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to theinstance of the ie_network_t to get output information."]
    #[doc = " @param number An id of output information ."]
    #[doc = " @param name Output name corresponding to the number."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_output_name(
        network: *const ie_network_t,
        number: usize,
        name: *mut *mut ::std::os::raw::c_char,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets a precision of the output data named \"output_name\"."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param output_name Name of output data."]
    #[doc = " @param prec_result A pointer to the precision used for output blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_output_precision(
        network: *const ie_network_t,
        output_name: *const ::std::os::raw::c_char,
        prec_result: *mut precision_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Changes the precision of the output data named \"output_name\"."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param output_name Name of output data."]
    #[doc = " @param p A new precision of the output data to set (eg. precision_e.FP16)."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_output_precision(
        network: *mut ie_network_t,
        output_name: *const ::std::os::raw::c_char,
        p: precision_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets a layout of the output data."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param output_name Name of output data."]
    #[doc = " @param layout_result A pointer to the layout used for output blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_output_layout(
        network: *const ie_network_t,
        output_name: *const ::std::os::raw::c_char,
        layout_result: *mut layout_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Changes the layout of the output data named \"output_name\"."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param output_name Name of output data."]
    #[doc = " @param l A new layout of the output data to set."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_set_output_layout(
        network: *mut ie_network_t,
        output_name: *const ::std::os::raw::c_char,
        l: layout_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets dimensions/shape of the output data with reversed order."]
    #[doc = " @ingroup Network"]
    #[doc = " @param network A pointer to ie_network_t instance."]
    #[doc = " @param output_name Name of output data."]
    #[doc = " @param dims_result A pointer to the dimensions used for output blob creation."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_network_get_output_dims(
        network: *const ie_network_t,
        output_name: *const ::std::os::raw::c_char,
        dims_result: *mut dimensions_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases memory occupied by input_shapes."]
    #[doc = " @ingroup Network"]
    #[doc = " @param inputShapes A pointer to the input_shapes to free memory."]
    pub fn ie_network_input_shapes_free(inputShapes: *mut input_shapes_t);
}
extern "C" {
    #[doc = " @brief Releases momory occupied by input_name or output_name."]
    #[doc = " @ingroup Network"]
    #[doc = " @param name A pointer to the input_name or output_name to free memory."]
    pub fn ie_network_name_free(name: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " @brief Creates a blob with the specified dimensions, layout and to allocate memory."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param tensorDesc Tensor descriptor for Blob creation."]
    #[doc = " @param blob A pointer to the newly created blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_make_memory(
        tensorDesc: *const tensor_desc_t,
        blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates a blob with the given tensor descriptor from the pointer to the pre-allocated memory."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param tensorDesc Tensor descriptor for Blob creation."]
    #[doc = " @param ptr Pointer to the pre-allocated memory."]
    #[doc = " @param size Length of the pre-allocated array."]
    #[doc = " @param blob A pointer to the newly created blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_make_memory_from_preallocated(
        tensorDesc: *const tensor_desc_t,
        ptr: *mut ::std::os::raw::c_void,
        size: usize,
        blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates a blob describing given roi_t instance based on the given blob with pre-allocated memory."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param inputBlob original blob with pre-allocated memory."]
    #[doc = " @param roi A roi_tinstance inside of the original blob."]
    #[doc = " @param blob A pointer to the newly created blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_make_memory_with_roi(
        inputBlob: *const ie_blob_t,
        roi: *const roi_t,
        blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates a NV12 blob from two planes Y and UV."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param y A pointer to the ie_blob_t instance that represents Y plane in NV12 color format."]
    #[doc = " @param uv A pointer to the ie_blob_t instance that represents UV plane in NV12 color format."]
    #[doc = " @param nv12Blob A pointer to the newly created blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_make_memory_nv12(
        y: *const ie_blob_t,
        uv: *const ie_blob_t,
        nv12Blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Creates I420 blob from three planes Y, U and V."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param y A pointer to the ie_blob_t instance that represents Y plane in I420 color format."]
    #[doc = " @param u A pointer to the ie_blob_t instance that represents U plane in I420 color format."]
    #[doc = " @param v A pointer to the ie_blob_t instance that represents V plane in I420 color format."]
    #[doc = " @param i420Blob A pointer to the newly created blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_make_memory_i420(
        y: *const ie_blob_t,
        u: *const ie_blob_t,
        v: *const ie_blob_t,
        i420Blob: *mut *mut ie_blob_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets the total number of elements, which is a product of all the dimensions."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param size_result The total number of elements."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_size(
        blob: *mut ie_blob_t,
        size_result: *mut ::std::os::raw::c_int,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets the size of the current Blob in bytes."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param bsize_result The size of the current blob in bytes."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_byte_size(
        blob: *mut ie_blob_t,
        bsize_result: *mut ::std::os::raw::c_int,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases previously allocated data"]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob to free memory."]
    pub fn ie_blob_deallocate(blob: *mut *mut ie_blob_t);
}
extern "C" {
    #[doc = " @brief Gets access to the allocated memory ."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param blob_buffer A pointer to the copied data from the given blob."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_get_buffer(
        blob: *const ie_blob_t,
        blob_buffer: *mut ie_blob_buffer_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets read-only access to the allocated memory."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param blob_cbuffer A pointer to the coped data from the given pointer to the blob and the data is read-only."]
    #[doc = " @return Status code of the operation: OK(0) for success"]
    pub fn ie_blob_get_cbuffer(
        blob: *const ie_blob_t,
        blob_cbuffer: *mut ie_blob_buffer_t,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets dimensions of blob's tensor."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param dims_result A pointer to the dimensions of blob's tensor."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_get_dims(blob: *const ie_blob_t, dims_result: *mut dimensions_t)
        -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets layout of blob's tensor."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param layout_result A pointer to the layout of blob's tensor."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_get_layout(blob: *const ie_blob_t, layout_result: *mut layout_e)
        -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Gets precision of blob's tensor."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob."]
    #[doc = " @param prec_result A pointer to the precision of blob's tensor."]
    #[doc = " @return Status code of the operation: OK(0) for success."]
    pub fn ie_blob_get_precision(
        blob: *const ie_blob_t,
        prec_result: *mut precision_e,
    ) -> IEStatusCode;
}
extern "C" {
    #[doc = " @brief Releases the memory occupied by the ie_blob_t pointer."]
    #[doc = " @ingroup Blob"]
    #[doc = " @param blob A pointer to the blob pointer to release memory."]
    pub fn ie_blob_free(blob: *mut *mut ie_blob_t);
}

}
