use std::os::raw::c_char;
use std::os::raw::c_int;
use std::ffi::CString;
use std::ffi::CStr;

extern "C" {
  fn open_connect(nom:*const c_char) -> i32;
}
pub fn rust_connect(nom:&str)-> i32{
  let nom1=CString::new(nom).unwrap();
  let c_ptr: *const c_char = nom1.as_ptr();
  let res = unsafe{open_connect(c_ptr)};
  res
}

extern "C" {
  fn open_close(db:c_int) -> i32;
}
pub fn rust_close(db:i32)-> i32{
  let db1: c_int = db;
  let res = unsafe{open_close(db1)};
  res
}

extern "C" {
  fn open_prepare(db:c_int, sql:*const c_char) -> i32;
}
pub fn rust_prepare(db:i32, sql:&str)-> i32{
  let db1: c_int = db;
  let sql1=CString::new(sql).unwrap();
  let c_ptr: *const c_char = sql1.as_ptr();
  let res = unsafe{open_prepare(db1, c_ptr)};
  res
}

extern "C" {
  fn open_step(st:c_int) -> i32;
}
pub fn rust_step(st:i32)-> i32{
  let st1: c_int = st;
  let res = unsafe{open_step(st1)};
  res
}

extern "C" {
  fn open_free_result(st:c_int) -> i32;
}
pub fn rust_free_result(st:i32)-> i32{
  let st1: c_int = st;
  let res = unsafe{open_free_result(st1)};
  res
}

extern "C" {
  fn open_column_text(st:c_int, co:c_int) -> *const c_char;
}
pub fn rust_column_text(st:i32, co:i32)-> String {
  let st1: c_int = st;
  let co1: c_int = co;
  let c_buf: *const c_char = unsafe { open_column_text(st1, co1) };
  let c_str: &CStr = unsafe { CStr::from_ptr(c_buf) };
  let str_slice: &str = c_str.to_str().unwrap();
  let str_buf: String = str_slice.to_owned();  
  str_buf
}

extern "C" {
  fn open_column_name(st:c_int, co:c_int) -> *const c_char;
}
pub fn rust_column_name(st:i32, co:i32)-> String {
  let st1: c_int = st;
  let co1: c_int = co;
  let c_buf: *const c_char = unsafe { open_column_name(st1, co1) };
  let c_str: &CStr = unsafe { CStr::from_ptr(c_buf) };
  let str_slice: &str = c_str.to_str().unwrap();
  let str_buf: String = str_slice.to_owned();  
  str_buf
}

extern "C" {
  fn open_num_rows(st:c_int) -> i32;
}
pub fn rust_num_rows(st:i32)-> i32{
  let st1: c_int = st;
  let res = unsafe{open_num_rows(st1)};
  res
}

extern "C" {
  fn open_num_columns(st:c_int) -> i32;
}
pub fn rust_num_columns(st:i32)-> i32{
  let st1: c_int = st;
  let res = unsafe{open_num_columns(st1)};
  res
}

extern "C" {
  fn open_last_error() -> *const c_char;
}
pub fn rust_last_error()-> String{
  let c_buf: *const c_char = unsafe { open_last_error() };
  let c_str: &CStr = unsafe { CStr::from_ptr(c_buf) };
  let str_slice: &str = c_str.to_str().unwrap();
  let str_buf: String = str_slice.to_owned();  
  str_buf
}
