/* automatically generated by rust-bindgen */
use std::os::raw::*;
pub type OPJ_BOOL = c_int;
pub type OPJ_CHAR = c_char;
pub type OPJ_FLOAT32 = f32;
pub type OPJ_BYTE = u8;
pub type OPJ_UINT16 = u16;
pub type OPJ_INT32 = i32;
pub type OPJ_UINT32 = u32;
pub type OPJ_UINT64 = u64;
pub type OPJ_OFF_T = i64;
use libc::FILE;
pub type OPJ_SIZE_T = usize;
#[repr(u32)]
/// DEPRECATED: use RSIZ, OPJ_PROFILE_* and OPJ_EXTENSION_* instead
/// Rsiz Capabilities
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RSIZ_CAPABILITIES {
    OPJ_STD_RSIZ = 0,
    /// Standard JPEG2000 profile
    OPJ_CINEMA2K = 3,
    /// Profile name for a 2K image
    OPJ_CINEMA4K = 4,
    /// Profile name for a 4K image
    OPJ_MCT = 33024,
}
/// DEPRECATED: use RSIZ, OPJ_PROFILE_* and OPJ_EXTENSION_* instead
/// Rsiz Capabilities
pub use self::RSIZ_CAPABILITIES as OPJ_RSIZ_CAPABILITIES;
#[repr(u32)]
/// DEPRECATED: use RSIZ, OPJ_PROFILE_* and OPJ_EXTENSION_* instead
/// Digital cinema operation mode
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CINEMA_MODE {
    OPJ_OFF = 0,
    /// Not Digital Cinema
    OPJ_CINEMA2K_24 = 1,
    /// 2K Digital Cinema at 24 fps
    OPJ_CINEMA2K_48 = 2,
    /// 2K Digital Cinema at 48 fps
    OPJ_CINEMA4K_24 = 3,
}
/// DEPRECATED: use RSIZ, OPJ_PROFILE_* and OPJ_EXTENSION_* instead
/// Digital cinema operation mode
pub use self::CINEMA_MODE as OPJ_CINEMA_MODE;
#[repr(i32)]
/// Progression order
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PROG_ORDER {
    ///< place-holder
    OPJ_PROG_UNKNOWN = -1,
    ///< layer-resolution-component-precinct order
    OPJ_LRCP = 0,
    ///< resolution-layer-component-precinct order
    OPJ_RLCP = 1,
    ///< resolution-precinct-component-layer order
    OPJ_RPCL = 2,
    ///< precinct-component-resolution-layer order
    OPJ_PCRL = 3,
    ///< component-precinct-resolution-layer order
    OPJ_CPRL = 4,
}
/// Progression order
pub use self::PROG_ORDER as OPJ_PROG_ORDER;
#[repr(i32)]
/// Supported image color spaces
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum COLOR_SPACE {
    ///< not supported by the library
    OPJ_CLRSPC_UNKNOWN = -1,
    ///< not specified in the codestream
    OPJ_CLRSPC_UNSPECIFIED = 0,
    ///< sRGB
    OPJ_CLRSPC_SRGB = 1,
    ///< grayscale
    OPJ_CLRSPC_GRAY = 2,
    ///< YUV
    OPJ_CLRSPC_SYCC = 3,
    ///< e-YCC
    OPJ_CLRSPC_EYCC = 4,
    ///< CMYK
    OPJ_CLRSPC_CMYK = 5,
}
/// Supported image color spaces
pub use self::COLOR_SPACE as OPJ_COLOR_SPACE;
#[repr(i32)]
/// Supported codec
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum CODEC_FORMAT {
    ///< place-holder
    OPJ_CODEC_UNKNOWN = -1,
    ///< JPEG-2000 codestream : read/write
    OPJ_CODEC_J2K = 0,
    ///< JPT-stream (JPEG 2000, JPIP) : read only
    OPJ_CODEC_JPT = 1,
    ///< JP2 file format : read/write
    OPJ_CODEC_JP2 = 2,
    ///< JPP-stream (JPEG 2000, JPIP) : to be coded
    OPJ_CODEC_JPP = 3,
    ///< JPX file format (JPEG 2000 Part-2) : to be coded
    OPJ_CODEC_JPX = 4,
}
/// Supported codec
pub use self::CODEC_FORMAT as OPJ_CODEC_FORMAT;
/// Callback function prototype for events
/// * `msg` —                Event message
/// * `client_data` —        Client object where will be return the event message
pub type opj_msg_callback = ::std::option::Option<
    unsafe extern "C" fn(
        msg: *const c_char,
        client_data: *mut c_void,
    ),
>;
/// Progression order changes
///
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_poc {
    /// Resolution num start, Component num start, given by POC
    pub resno0: OPJ_UINT32,
    /// Resolution num start, Component num start, given by POC
    pub compno0: OPJ_UINT32,
    /// Layer num end,Resolution num end, Component num end, given by POC
    pub layno1: OPJ_UINT32,
    /// Layer num end,Resolution num end, Component num end, given by POC
    pub resno1: OPJ_UINT32,
    /// Layer num end,Resolution num end, Component num end, given by POC
    pub compno1: OPJ_UINT32,
    /// Layer num start,Precinct num start, Precinct num end
    pub layno0: OPJ_UINT32,
    /// Layer num start,Precinct num start, Precinct num end
    pub precno0: OPJ_UINT32,
    /// Layer num start,Precinct num start, Precinct num end
    pub precno1: OPJ_UINT32,
    /// Progression order enum
    pub prg1: OPJ_PROG_ORDER,
    /// Progression order enum
    pub prg: OPJ_PROG_ORDER,
    /// Progression order string
    pub progorder: [OPJ_CHAR; 5usize],
    /// Tile number (starting at 1)
    pub tile: OPJ_UINT32,
    /// Start and end values for Tile width and height
    pub tx0: OPJ_INT32,
    /// Start and end values for Tile width and height
    pub tx1: OPJ_INT32,
    /// Start and end values for Tile width and height
    pub ty0: OPJ_INT32,
    /// Start and end values for Tile width and height
    pub ty1: OPJ_INT32,
    /// Start value, initialised in pi_initialise_encode
    pub layS: OPJ_UINT32,
    /// Start value, initialised in pi_initialise_encode
    pub resS: OPJ_UINT32,
    /// Start value, initialised in pi_initialise_encode
    pub compS: OPJ_UINT32,
    /// Start value, initialised in pi_initialise_encode
    pub prcS: OPJ_UINT32,
    /// End value, initialised in pi_initialise_encode
    pub layE: OPJ_UINT32,
    /// End value, initialised in pi_initialise_encode
    pub resE: OPJ_UINT32,
    /// End value, initialised in pi_initialise_encode
    pub compE: OPJ_UINT32,
    /// End value, initialised in pi_initialise_encode
    pub prcE: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub txS: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub txE: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub tyS: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub tyE: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub dx: OPJ_UINT32,
    /// Start and end values of Tile width and height, initialised in pi_initialise_encode
    pub dy: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub lay_t: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub res_t: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub comp_t: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub prc_t: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub tx0_t: OPJ_UINT32,
    /// Temporary values for Tile parts, initialised in pi_create_encode
    pub ty0_t: OPJ_UINT32,
}
/// Progression order changes
///
pub type opj_poc_t = opj_poc;
/// Compression parameters
#[repr(C)]
#[derive(Copy, Clone)]
pub struct opj_cparameters {
    /// size of tile: tile_size_on = false (not in argument) or = true (in argument)
    pub tile_size_on: OPJ_BOOL,
    /// XTOsiz
    pub cp_tx0: c_int,
    /// YTOsiz
    pub cp_ty0: c_int,
    /// XTsiz
    pub cp_tdx: c_int,
    /// YTsiz
    pub cp_tdy: c_int,
    /// allocation by rate/distortion
    pub cp_disto_alloc: c_int,
    /// allocation by fixed layer
    pub cp_fixed_alloc: c_int,
    /// add fixed_quality
    pub cp_fixed_quality: c_int,
    /// fixed layer
    pub cp_matrice: *mut c_int,
    /// comment for coding
    pub cp_comment: *mut c_char,
    /// csty : coding style
    pub csty: c_int,
    /// progression order (default OPJ_LRCP)
    pub prog_order: OPJ_PROG_ORDER,
    /// progression order changes
    pub POC: [opj_poc_t; 32usize],
    /// number of progression order changes (POC), default to 0
    pub numpocs: OPJ_UINT32,
    /// number of layers
    pub tcp_numlayers: c_int,
    /// rates of layers - might be subsequently limited by the max_cs_size field.
    /// Should be decreasing. 1 can be
    /// used as last value to indicate the last layer is lossless.
    pub tcp_rates: [f32; 100usize],
    /// different psnr for successive layers. Should be increasing. 0 can be
    /// used as last value to indicate the last layer is lossless.
    pub tcp_distoratio: [f32; 100usize],
    /// number of resolutions
    pub numresolution: c_int,
    /// initial code block width, default to 64
    pub cblockw_init: c_int,
    /// initial code block height, default to 64
    pub cblockh_init: c_int,
    /// mode switch (cblk_style)
    pub mode: c_int,
    /// 1 : use the irreversible DWT 9-7, 0 : use lossless compression (default)
    pub irreversible: c_int,
    /// region of interest: affected component in [0..3], -1 means no ROI
    pub roi_compno: c_int,
    /// region of interest: upshift value
    pub roi_shift: c_int,
    pub res_spec: c_int,
    /// initial precinct width
    pub prcw_init: [c_int; 33usize],
    /// initial precinct height
    pub prch_init: [c_int; 33usize],
    /// input file name
    pub infile: [c_char; 4096usize],
    /// output file name
    pub outfile: [c_char; 4096usize],
    /// DEPRECATED. Index generation is now handeld with the opj_encode_with_info() function. Set to NULL
    pub index_on: c_int,
    /// DEPRECATED. Index generation is now handeld with the opj_encode_with_info() function. Set to NULL
    pub index: [c_char; 4096usize],
    /// subimage encoding: origin image offset in x direction
    pub image_offset_x0: c_int,
    /// subimage encoding: origin image offset in y direction
    pub image_offset_y0: c_int,
    /// subsampling value for dx
    pub subsampling_dx: c_int,
    /// subsampling value for dy
    pub subsampling_dy: c_int,
    /// input file format 0: PGX, 1: PxM, 2: BMP 3:TIF
    pub decod_format: c_int,
    /// output file format 0: J2K, 1: JP2, 2: JPT
    pub cod_format: c_int,
    /// enables writing of EPC in MH, thus activating JPWL
    pub jpwl_epc_on: OPJ_BOOL,
    /// error protection method for MH (0,1,16,32,37-128)
    pub jpwl_hprot_MH: c_int,
    /// tile number of header protection specification (>=0)
    pub jpwl_hprot_TPH_tileno: [c_int; 16usize],
    /// error protection methods for TPHs (0,1,16,32,37-128)
    pub jpwl_hprot_TPH: [c_int; 16usize],
    /// tile number of packet protection specification (>=0)
    pub jpwl_pprot_tileno: [c_int; 16usize],
    /// packet number of packet protection specification (>=0)
    pub jpwl_pprot_packno: [c_int; 16usize],
    /// error protection methods for packets (0,1,16,32,37-128)
    pub jpwl_pprot: [c_int; 16usize],
    /// enables writing of ESD, (0=no/1/2 bytes)
    pub jpwl_sens_size: c_int,
    /// sensitivity addressing size (0=auto/2/4 bytes)
    pub jpwl_sens_addr: c_int,
    /// sensitivity range (0-3)
    pub jpwl_sens_range: c_int,
    /// sensitivity method for MH (-1=no,0-7)
    pub jpwl_sens_MH: c_int,
    /// tile number of sensitivity specification (>=0)
    pub jpwl_sens_TPH_tileno: [c_int; 16usize],
    /// sensitivity methods for TPHs (-1=no,0-7)
    pub jpwl_sens_TPH: [c_int; 16usize],
    /// DEPRECATED: use RSIZ, OPJ_PROFILE_* and MAX_COMP_SIZE instead
    /// Digital Cinema compliance 0-not compliant, 1-compliant
    pub cp_cinema: OPJ_CINEMA_MODE,
    /// Maximum size (in bytes) for each component.
    /// If == 0, component size limitation is not considered
    pub max_comp_size: c_int,
    /// DEPRECATED: use RSIZ, OPJ_PROFILE_* and OPJ_EXTENSION_* instead
    /// Profile name
    pub cp_rsiz: OPJ_RSIZ_CAPABILITIES,
    /// Tile part generation
    pub tp_on: c_char,
    /// Flag for Tile part generation
    pub tp_flag: c_char,
    /// MCT (multiple component transform)
    pub tcp_mct: c_char,
    /// Enable JPIP indexing
    pub jpip_on: OPJ_BOOL,
    /// Naive implementation of MCT restricted to a single reversible array based
    ///encoding without offset concerning all the components.
    pub mct_data: *mut c_void,
    /// Maximum size (in bytes) for the whole codestream.
    /// If == 0, codestream size limitation is not considered
    /// If it does not comply with tcp_rates, max_cs_size prevails
    /// and a warning is issued.
    pub max_cs_size: c_int,
    /// RSIZ value
    ///To be used to combine OPJ_PROFILE_*, OPJ_EXTENSION_* and (sub)levels values.
    pub rsiz: OPJ_UINT16,
}
/// Compression parameters
pub type opj_cparameters_t = opj_cparameters;
/// Decompression parameters
#[repr(C)]
#[derive(Copy, Clone)]
pub struct opj_dparameters {
    ///Set the number of highest resolution levels to be discarded.
    ///The image resolution is effectively divided by 2 to the power of the number of discarded levels.
    ///The reduce factor is limited by the smallest total number of decomposition levels among tiles.
    ///if != 0, then original dimension divided by 2^(reduce);
    ///if == 0 or not used, image is decoded to the full resolution
    pub cp_reduce: OPJ_UINT32,
    ///Set the maximum number of quality layers to decode.
    ///If there are less quality layers than the specified number, all the quality layers are decoded.
    ///if != 0, then only the first "layer" layers are decoded;
    ///if == 0 or not used, all the quality layers are decoded
    pub cp_layer: OPJ_UINT32,
    /// input file name
    pub infile: [c_char; 4096usize],
    /// output file name
    pub outfile: [c_char; 4096usize],
    /// input file format 0: J2K, 1: JP2, 2: JPT
    pub decod_format: c_int,
    /// output file format 0: PGX, 1: PxM, 2: BMP
    pub cod_format: c_int,
    /// Decoding area left boundary
    pub DA_x0: OPJ_UINT32,
    /// Decoding area right boundary
    pub DA_x1: OPJ_UINT32,
    /// Decoding area up boundary
    pub DA_y0: OPJ_UINT32,
    /// Decoding area bottom boundary
    pub DA_y1: OPJ_UINT32,
    /// Verbose mode
    pub m_verbose: OPJ_BOOL,
    /// tile number of the decoded tile
    pub tile_index: OPJ_UINT32,
    /// Nb of tile to decode
    pub nb_tile_to_decode: OPJ_UINT32,
    /// activates the JPWL correction capabilities
    pub jpwl_correct: OPJ_BOOL,
    /// expected number of components
    pub jpwl_exp_comps: c_int,
    /// maximum number of tiles
    pub jpwl_max_tiles: c_int,
    pub flags: c_uint,
}
/// Decompression parameters
pub type opj_dparameters_t = opj_dparameters;
/// JPEG2000 codec V2.
pub type opj_codec_t = *mut c_void;
pub type opj_stream_read_fn = ::std::option::Option<
    unsafe extern "C" fn(
        p_buffer: *mut c_void,
        p_nb_bytes: OPJ_SIZE_T,
        p_user_data: *mut c_void,
    ) -> OPJ_SIZE_T,
>;
pub type opj_stream_write_fn = ::std::option::Option<
    unsafe extern "C" fn(
        p_buffer: *mut c_void,
        p_nb_bytes: OPJ_SIZE_T,
        p_user_data: *mut c_void,
    ) -> OPJ_SIZE_T,
>;
pub type opj_stream_skip_fn = ::std::option::Option<
    unsafe extern "C" fn(
        p_nb_bytes: OPJ_OFF_T,
        p_user_data: *mut c_void,
    ) -> OPJ_OFF_T,
>;
pub type opj_stream_seek_fn = ::std::option::Option<
    unsafe extern "C" fn(
        p_nb_bytes: OPJ_OFF_T,
        p_user_data: *mut c_void,
    ) -> OPJ_BOOL,
>;
pub type opj_stream_free_user_data_fn =
    ::std::option::Option<unsafe extern "C" fn(p_user_data: *mut c_void)>;
pub type opj_stream_t = *mut c_void;
/// Defines a single image component
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_image_comp {
    /// XRsiz: horizontal separation of a sample of ith component with respect to the reference grid
    pub dx: OPJ_UINT32,
    /// YRsiz: vertical separation of a sample of ith component with respect to the reference grid
    pub dy: OPJ_UINT32,
    /// data width
    pub w: OPJ_UINT32,
    /// data height
    pub h: OPJ_UINT32,
    /// x component offset compared to the whole image
    pub x0: OPJ_UINT32,
    /// y component offset compared to the whole image
    pub y0: OPJ_UINT32,
    /// precision
    pub prec: OPJ_UINT32,
    /// image depth in bits
    pub bpp: OPJ_UINT32,
    /// signed (1) / unsigned (0)
    pub sgnd: OPJ_UINT32,
    /// number of decoded resolution
    pub resno_decoded: OPJ_UINT32,
    /// number of division by 2 of the out image compared to the original size of image
    pub factor: OPJ_UINT32,
    /// image component data
    pub data: *mut OPJ_INT32,
    /// alpha channel
    pub alpha: OPJ_UINT16,
}
/// Defines a single image component
pub type opj_image_comp_t = opj_image_comp;
/// Defines image data and characteristics
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_image {
    /// XOsiz: horizontal offset from the origin of the reference grid to the left side of the image area
    pub x0: OPJ_UINT32,
    /// YOsiz: vertical offset from the origin of the reference grid to the top side of the image area
    pub y0: OPJ_UINT32,
    /// Xsiz: width of the reference grid
    pub x1: OPJ_UINT32,
    /// Ysiz: height of the reference grid
    pub y1: OPJ_UINT32,
    /// number of components in the image
    pub numcomps: OPJ_UINT32,
    /// color space: sRGB, Greyscale or YUV
    pub color_space: OPJ_COLOR_SPACE,
    /// image components
    pub comps: *mut opj_image_comp_t,
    /// 'restricted' ICC profile
    pub icc_profile_buf: *mut OPJ_BYTE,
    /// size of ICC profile
    pub icc_profile_len: OPJ_UINT32,
}
/// Defines image data and characteristics
pub type opj_image_t = opj_image;
/// Component parameters structure used by the opj_image_create function
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_image_comptparm {
    /// XRsiz: horizontal separation of a sample of ith component with respect to the reference grid
    pub dx: OPJ_UINT32,
    /// YRsiz: vertical separation of a sample of ith component with respect to the reference grid
    pub dy: OPJ_UINT32,
    /// data width
    pub w: OPJ_UINT32,
    /// data height
    pub h: OPJ_UINT32,
    /// x component offset compared to the whole image
    pub x0: OPJ_UINT32,
    /// y component offset compared to the whole image
    pub y0: OPJ_UINT32,
    /// precision
    pub prec: OPJ_UINT32,
    /// image depth in bits
    pub bpp: OPJ_UINT32,
    /// signed (1) / unsigned (0)
    pub sgnd: OPJ_UINT32,
}
/// Component parameters structure used by the opj_image_create function
pub type opj_image_cmptparm_t = opj_image_comptparm;
/// Index structure : Information concerning a packet inside tile
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_packet_info {
    /// packet start position (including SOP marker if it exists)
    pub start_pos: OPJ_OFF_T,
    /// end of packet header position (including EPH marker if it exists)
    pub end_ph_pos: OPJ_OFF_T,
    /// packet end position
    pub end_pos: OPJ_OFF_T,
    /// packet distorsion
    pub disto: f64,
}
/// Index structure : Information concerning a packet inside tile
pub type opj_packet_info_t = opj_packet_info;
/// Marker structure
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_marker_info {
    /// marker type
    pub type_: c_ushort,
    /// position in codestream
    pub pos: OPJ_OFF_T,
    /// length, marker val included
    pub len: c_int,
}
/// Marker structure
pub type opj_marker_info_t = opj_marker_info;
/// Index structure : Information concerning tile-parts
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_tp_info {
    /// start position of tile part
    pub tp_start_pos: c_int,
    /// end position of tile part header
    pub tp_end_header: c_int,
    /// end position of tile part
    pub tp_end_pos: c_int,
    /// start packet of tile part
    pub tp_start_pack: c_int,
    /// number of packets of tile part
    pub tp_numpacks: c_int,
}
/// Index structure : Information concerning tile-parts
pub type opj_tp_info_t = opj_tp_info;
/// Index structure : information regarding tiles
#[repr(C)]
#[derive(Copy, Clone)]
pub struct opj_tile_info {
    /// value of thresh for each layer by tile cfr. Marcela
    pub thresh: *mut f64,
    /// number of tile
    pub tileno: c_int,
    /// start position
    pub start_pos: c_int,
    /// end position of the header
    pub end_header: c_int,
    /// end position
    pub end_pos: c_int,
    /// precinct number for each resolution level (width)
    pub pw: [c_int; 33usize],
    /// precinct number for each resolution level (height)
    pub ph: [c_int; 33usize],
    /// precinct size (in power of 2), in X for each resolution level
    pub pdx: [c_int; 33usize],
    /// precinct size (in power of 2), in Y for each resolution level
    pub pdy: [c_int; 33usize],
    /// information concerning packets inside tile
    pub packet: *mut opj_packet_info_t,
    /// add fixed_quality
    pub numpix: c_int,
    /// add fixed_quality
    pub distotile: f64,
    /// number of markers
    pub marknum: c_int,
    /// list of markers
    pub marker: *mut opj_marker_info_t,
    /// actual size of markers array
    pub maxmarknum: c_int,
    /// number of tile parts
    pub num_tps: c_int,
    /// information concerning tile parts
    pub tp: *mut opj_tp_info_t,
}
/// Index structure : information regarding tiles
pub type opj_tile_info_t = opj_tile_info;
/// Index structure of the codestream
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_codestream_info {
    /// maximum distortion reduction on the whole image (add for Marcela)
    pub D_max: f64,
    /// packet number
    pub packno: c_int,
    /// writing the packet in the index with t2_encode_packets
    pub index_write: c_int,
    /// image width
    pub image_w: c_int,
    /// image height
    pub image_h: c_int,
    /// progression order
    pub prog: OPJ_PROG_ORDER,
    /// tile size in x
    pub tile_x: c_int,
    /// tile size in y
    pub tile_y: c_int,
    pub tile_Ox: c_int,
    pub tile_Oy: c_int,
    /// number of tiles in X
    pub tw: c_int,
    /// number of tiles in Y
    pub th: c_int,
    /// component numbers
    pub numcomps: c_int,
    /// number of layer
    pub numlayers: c_int,
    /// number of decomposition for each component
    pub numdecompos: *mut c_int,
    /// number of markers
    pub marknum: c_int,
    /// list of markers
    pub marker: *mut opj_marker_info_t,
    /// actual size of markers array
    pub maxmarknum: c_int,
    /// main header position
    pub main_head_start: c_int,
    /// main header position
    pub main_head_end: c_int,
    /// codestream's size
    pub codestream_size: c_int,
    /// information regarding tiles inside image
    pub tile: *mut opj_tile_info_t,
}
/// Index structure of the codestream
pub type opj_codestream_info_t = opj_codestream_info;
/// Tile-component coding parameters information
#[repr(C)]
#[derive(Copy, Clone)]
pub struct opj_tccp_info {
    /// component index
    pub compno: OPJ_UINT32,
    /// coding style
    pub csty: OPJ_UINT32,
    /// number of resolutions
    pub numresolutions: OPJ_UINT32,
    /// log2 of code-blocks width
    pub cblkw: OPJ_UINT32,
    /// log2 of code-blocks height
    pub cblkh: OPJ_UINT32,
    /// code-block coding style
    pub cblksty: OPJ_UINT32,
    /// discrete wavelet transform identifier: 0 = 9-7 irreversible, 1 = 5-3 reversible
    pub qmfbid: OPJ_UINT32,
    /// quantisation style
    pub qntsty: OPJ_UINT32,
    /// stepsizes used for quantization
    pub stepsizes_mant: [OPJ_UINT32; 97usize],
    /// stepsizes used for quantization
    pub stepsizes_expn: [OPJ_UINT32; 97usize],
    /// number of guard bits
    pub numgbits: OPJ_UINT32,
    /// Region Of Interest shift
    pub roishift: OPJ_INT32,
    /// precinct width
    pub prcw: [OPJ_UINT32; 33usize],
    /// precinct height
    pub prch: [OPJ_UINT32; 33usize],
}
/// Tile-component coding parameters information
pub type opj_tccp_info_t = opj_tccp_info;
/// Tile coding parameters information
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_tile_v2_info {
    /// number (index) of tile
    pub tileno: c_int,
    /// coding style
    pub csty: OPJ_UINT32,
    /// progression order
    pub prg: OPJ_PROG_ORDER,
    /// number of layers
    pub numlayers: OPJ_UINT32,
    /// multi-component transform identifier
    pub mct: OPJ_UINT32,
    /// information concerning tile component parameters
    pub tccp_info: *mut opj_tccp_info_t,
}
/// Tile coding parameters information
pub type opj_tile_info_v2_t = opj_tile_v2_info;
/// Information structure about the codestream (FIXME should be expand and enhance)
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_codestream_info_v2 {
    /// tile origin in x = XTOsiz
    pub tx0: OPJ_UINT32,
    /// tile origin in y = YTOsiz
    pub ty0: OPJ_UINT32,
    /// tile size in x = XTsiz
    pub tdx: OPJ_UINT32,
    /// tile size in y = YTsiz
    pub tdy: OPJ_UINT32,
    /// number of tiles in X
    pub tw: OPJ_UINT32,
    /// number of tiles in Y
    pub th: OPJ_UINT32,
    /// number of components
    pub nbcomps: OPJ_UINT32,
    /// Default information regarding tiles inside image
    pub m_default_tile_info: opj_tile_info_v2_t,
    /// information regarding tiles inside image
    pub tile_info: *mut opj_tile_info_v2_t,
}
/// Information structure about the codestream (FIXME should be expand and enhance)
pub type opj_codestream_info_v2_t = opj_codestream_info_v2;
/// Index structure about a tile part
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_tp_index {
    /// start position
    pub start_pos: OPJ_OFF_T,
    /// end position of the header
    pub end_header: OPJ_OFF_T,
    /// end position
    pub end_pos: OPJ_OFF_T,
}
/// Index structure about a tile part
pub type opj_tp_index_t = opj_tp_index;
/// Index structure about a tile
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_tile_index {
    /// tile index
    pub tileno: OPJ_UINT32,
    /// number of tile parts
    pub nb_tps: OPJ_UINT32,
    /// current nb of tile part (allocated)
    pub current_nb_tps: OPJ_UINT32,
    /// current tile-part index
    pub current_tpsno: OPJ_UINT32,
    /// information concerning tile parts
    pub tp_index: *mut opj_tp_index_t,
    /// number of markers
    pub marknum: OPJ_UINT32,
    /// list of markers
    pub marker: *mut opj_marker_info_t,
    /// actual size of markers array
    pub maxmarknum: OPJ_UINT32,
    /// packet number
    pub nb_packet: OPJ_UINT32,
    /// information concerning packets inside tile
    pub packet_index: *mut opj_packet_info_t,
}
/// Index structure about a tile
pub type opj_tile_index_t = opj_tile_index;
/// Index structure of the codestream (FIXME should be expand and enhance)
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_codestream_index {
    /// main header start position (SOC position)
    pub main_head_start: OPJ_OFF_T,
    /// main header end position (first SOT position)
    pub main_head_end: OPJ_OFF_T,
    /// codestream's size
    pub codestream_size: OPJ_UINT64,
    /// number of markers
    pub marknum: OPJ_UINT32,
    /// list of markers
    pub marker: *mut opj_marker_info_t,
    /// actual size of markers array
    pub maxmarknum: OPJ_UINT32,
    pub nb_of_tiles: OPJ_UINT32,
    pub tile_index: *mut opj_tile_index_t,
}
/// Index structure of the codestream (FIXME should be expand and enhance)
pub type opj_codestream_index_t = opj_codestream_index;
/// Info structure of the JP2 file
/// EXPERIMENTAL FOR THE MOMENT
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_jp2_metadata {
    pub not_used: OPJ_INT32,
}
/// Info structure of the JP2 file
/// EXPERIMENTAL FOR THE MOMENT
pub type opj_jp2_metadata_t = opj_jp2_metadata;
/// Index structure of the JP2 file
/// EXPERIMENTAL FOR THE MOMENT
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct opj_jp2_index {
    pub not_used: OPJ_INT32,
}
/// Index structure of the JP2 file
/// EXPERIMENTAL FOR THE MOMENT
pub type opj_jp2_index_t = opj_jp2_index;
extern "C" {
    pub fn opj_version() -> *const c_char;
}
extern "C" {
    /// Create an image
    ///
    /// * `numcmpts` —       number of components
    /// * `cmptparms` —      components parameters
    /// * `clrspc` —         image color space
    /// @return returns      a new image structure if successful, returns NULL otherwise
    pub fn opj_image_create(
        numcmpts: OPJ_UINT32,
        cmptparms: *mut opj_image_cmptparm_t,
        clrspc: OPJ_COLOR_SPACE,
    ) -> *mut opj_image_t;
}
extern "C" {
    /// Deallocate any resources associated with an image
    ///
    /// * `image` —          image to be destroyed
    pub fn opj_image_destroy(image: *mut opj_image_t);
}
extern "C" {
    /// Creates an image without allocating memory for the image (used in the new version of the library).
    ///
    /// * `numcmpts` —     the number of components
    /// * `cmptparms` —    the components parameters
    /// * `clrspc` —       the image color space
    ///
    /// @return  a new image structure if successful, NULL otherwise.
    pub fn opj_image_tile_create(
        numcmpts: OPJ_UINT32,
        cmptparms: *mut opj_image_cmptparm_t,
        clrspc: OPJ_COLOR_SPACE,
    ) -> *mut opj_image_t;
}
extern "C" {
    /// Allocator for opj_image_t->comps[].data
    /// To be paired with opj_image_data_free.
    ///
    /// * `size` —     number of bytes to allocate
    ///
    /// @return  a new pointer if successful, NULL otherwise.
    /// @since 2.2.0
    pub fn opj_image_data_alloc(size: OPJ_SIZE_T) -> *mut c_void;
}
extern "C" {
    /// Destructor for opj_image_t->comps[].data
    /// To be paired with opj_image_data_alloc.
    ///
    /// * `ptr` —     Pointer to free
    ///
    /// @since 2.2.0
    pub fn opj_image_data_free(ptr: *mut c_void);
}
extern "C" {
    /// Creates an abstract stream. This function does nothing except allocating memory and initializing the abstract stream.
    ///
    /// * `p_is_input` —       if set to true then the stream will be an input stream, an output stream else.
    ///
    /// @return  a stream object.
    pub fn opj_stream_default_create(p_is_input: OPJ_BOOL) -> *mut opj_stream_t;
}
extern "C" {
    /// Creates an abstract stream. This function does nothing except allocating memory and initializing the abstract stream.
    ///
    /// * `p_buffer_size` —   FIXME DOC
    /// * `p_is_input` —       if set to true then the stream will be an input stream, an output stream else.
    ///
    /// @return  a stream object.
    pub fn opj_stream_create(p_buffer_size: OPJ_SIZE_T, p_is_input: OPJ_BOOL) -> *mut opj_stream_t;
}
extern "C" {
    /// Destroys a stream created by opj_create_stream. This function does NOT close the abstract stream. If needed the user must
    /// close its own implementation of the stream.
    ///
    /// * `p_stream` —     the stream to destroy.
    pub fn opj_stream_destroy(p_stream: *mut opj_stream_t);
}
extern "C" {
    /// Sets the given function to be used as a read function.
    /// * `p_stream` —     the stream to modify
    /// * `p_function` —   the function to use a read function.
    pub fn opj_stream_set_read_function(
        p_stream: *mut opj_stream_t,
        p_function: opj_stream_read_fn,
    );
}
extern "C" {
    /// Sets the given function to be used as a write function.
    /// * `p_stream` —     the stream to modify
    /// * `p_function` —   the function to use a write function.
    pub fn opj_stream_set_write_function(
        p_stream: *mut opj_stream_t,
        p_function: opj_stream_write_fn,
    );
}
extern "C" {
    /// Sets the given function to be used as a skip function.
    /// * `p_stream` —     the stream to modify
    /// * `p_function` —   the function to use a skip function.
    pub fn opj_stream_set_skip_function(
        p_stream: *mut opj_stream_t,
        p_function: opj_stream_skip_fn,
    );
}
extern "C" {
    /// Sets the given function to be used as a seek function, the stream is then seekable,
    /// using SEEK_SET behavior.
    /// * `p_stream` —     the stream to modify
    /// * `p_function` —   the function to use a skip function.
    pub fn opj_stream_set_seek_function(
        p_stream: *mut opj_stream_t,
        p_function: opj_stream_seek_fn,
    );
}
extern "C" {
    /// Sets the given data to be used as a user data for the stream.
    /// * `p_stream` —     the stream to modify
    /// * `p_data` —       the data to set.
    /// * `p_function` —   the function to free p_data when opj_stream_destroy() is called.
    pub fn opj_stream_set_user_data(
        p_stream: *mut opj_stream_t,
        p_data: *mut c_void,
        p_function: opj_stream_free_user_data_fn,
    );
}
extern "C" {
    /// Sets the length of the user data for the stream.
    ///
    /// * `p_stream` —     the stream to modify
    /// * `data_length` —  length of the user_data.
    pub fn opj_stream_set_user_data_length(p_stream: *mut opj_stream_t, data_length: OPJ_UINT64);
}
extern "C" {
    /// Create a stream from a file identified with its filename with default parameters (helper function)
    /// * `fname` —              the filename of the file to stream
    /// * `p_is_read_stream` —   whether the stream is a read stream (true) or not (false)
    pub fn opj_stream_create_default_file_stream(
        fname: *const c_char,
        p_is_read_stream: OPJ_BOOL,
    ) -> *mut opj_stream_t;
}
extern "C" {
    /// Create a stream from a file identified with its filename with a specific buffer size
    /// * `fname` —              the filename of the file to stream
    /// * `p_buffer_size` —      size of the chunk used to stream
    /// * `p_is_read_stream` —   whether the stream is a read stream (true) or not (false)
    pub fn opj_stream_create_file_stream(
        fname: *const c_char,
        p_buffer_size: OPJ_SIZE_T,
        p_is_read_stream: OPJ_BOOL,
    ) -> *mut opj_stream_t;
}
extern "C" {
    /// Set the info handler use by openjpeg.
    /// * `p_codec` —        the codec previously initialise
    /// * `p_callback` —     the callback function which will be used
    /// * `p_user_data` —    client object where will be returned the message
    pub fn opj_set_info_handler(
        p_codec: *mut opj_codec_t,
        p_callback: opj_msg_callback,
        p_user_data: *mut c_void,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Set the warning handler use by openjpeg.
    /// * `p_codec` —        the codec previously initialise
    /// * `p_callback` —     the callback function which will be used
    /// * `p_user_data` —    client object where will be returned the message
    pub fn opj_set_warning_handler(
        p_codec: *mut opj_codec_t,
        p_callback: opj_msg_callback,
        p_user_data: *mut c_void,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Set the error handler use by openjpeg.
    /// * `p_codec` —        the codec previously initialise
    /// * `p_callback` —     the callback function which will be used
    /// * `p_user_data` —    client object where will be returned the message
    pub fn opj_set_error_handler(
        p_codec: *mut opj_codec_t,
        p_callback: opj_msg_callback,
        p_user_data: *mut c_void,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Creates a J2K/JP2 decompression structure
    /// * `format` —         Decoder to select
    ///
    /// @return Returns a handle to a decompressor if successful, returns NULL otherwise
    pub fn opj_create_decompress(format: OPJ_CODEC_FORMAT) -> *mut opj_codec_t;
}
extern "C" {
    /// Destroy a decompressor handle
    ///
    /// * `p_codec` —          decompressor handle to destroy
    pub fn opj_destroy_codec(p_codec: *mut opj_codec_t);
}
extern "C" {
    /// Read after the codestream if necessary
    /// * `p_codec` —          the JPEG2000 codec to read.
    /// * `p_stream` —         the JPEG2000 stream.
    pub fn opj_end_decompress(p_codec: *mut opj_codec_t, p_stream: *mut opj_stream_t) -> OPJ_BOOL;
}
extern "C" {
    /// Set decoding parameters to default values
    /// * `parameters` —  Decompression parameters
    pub fn opj_set_default_decoder_parameters(parameters: *mut opj_dparameters_t);
}
extern "C" {
    /// Setup the decoder with decompression parameters provided by the user and with the message handler
    /// provided by the user.
    ///
    /// * `p_codec` —        decompressor handler
    /// * `parameters` —     decompression parameters
    ///
    /// @return true         if the decoder is correctly set
    pub fn opj_setup_decoder(
        p_codec: *mut opj_codec_t,
        parameters: *mut opj_dparameters_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Allocates worker threads for the compressor/decompressor.
    ///
    /// By default, only the main thread is used. If this function is not used,
    /// but the OPJ_NUM_THREADS environment variable is set, its value will be
    /// used to initialize the number of threads. The value can be either an integer
    /// number, or "ALL_CPUS". If OPJ_NUM_THREADS is set and this function is called,
    /// this function will override the behaviour of the environment variable.
    ///
    /// This function must be called after opj_setup_decoder() and
    /// before opj_read_header() for the decoding side, or after opj_setup_encoder()
    /// and before opj_start_compress() for the encoding side.
    ///
    /// * 'p_codec' —        decompressor or compressor handler
    /// * 'num_threads' —    number of threads.
    ///
    /// @return OPJ_TRUE     if the function is successful.
    pub fn opj_codec_set_threads(
        p_codec: *mut opj_codec_t,
        num_threads: c_int,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Decodes an image header.
    ///
    /// * `p_stream` —         the jpeg2000 stream.
    /// * `p_codec` —          the jpeg2000 codec to read.
    /// * `p_image` —          the image structure initialized with the characteristics of encoded image.
    ///
    /// @return true             if the main header of the codestream and the JP2 header is correctly read.
    pub fn opj_read_header(
        p_stream: *mut opj_stream_t,
        p_codec: *mut opj_codec_t,
        p_image: *mut *mut opj_image_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Restrict the number of components to decode.
    ///
    /// This function should be called after opj_read_header().
    ///
    /// This function enables to restrict the set of decoded components to the
    /// specified indices.
    /// Note that the current implementation (apply_color_transforms == OPJ_FALSE)
    /// is such that neither the multi-component transform at codestream level,
    /// nor JP2 channel transformations will be applied.
    /// Consequently the indices are relative to the codestream.
    ///
    /// Note: opj_decode_tile_data() should not be used together with opj_set_decoded_components().
    ///
    /// * `p_codec` —          the jpeg2000 codec to read.
    /// * `numcomps` —         Size of the comps_indices array.
    /// * `comps_indices` —    Array of numcomps values representing the indices
    ///                          of the components to decode (relative to the
    ///                          codestream, starting at 0)
    /// * `apply_color_transforms` —  Whether multi-component transform at codestream level
    ///                                 or JP2 channel transformations should be applied.
    ///                                 Currently this parameter should be set to OPJ_FALSE.
    ///                                 Setting it to OPJ_TRUE will result in an error.
    ///
    /// @return OPJ_TRUE         in case of success.
    pub fn opj_set_decoded_components(
        p_codec: *mut opj_codec_t,
        numcomps: OPJ_UINT32,
        comps_indices: *const OPJ_UINT32,
        apply_color_transforms: OPJ_BOOL,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Sets the given area to be decoded. This function should be called right after opj_read_header and before any tile header reading.
    ///
    /// The coordinates passed to this function should be expressed in the reference grid,
    /// that is to say at the highest resolution level, even if requesting the image at lower
    /// resolution levels.
    ///
    /// Generally opj_set_decode_area() should be followed by opj_decode(), and the
    /// codec cannot be re-used.
    /// In the particular case of an image made of a single tile, several sequences of
    /// calls to opoj_set_decode_area() and opj_decode() are allowed, and will bring
    /// performance improvements when reading an image by chunks.
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `p_image` —          the decoded image previously set by opj_read_header
    /// * `p_start_x` —        the left position of the rectangle to decode (in image coordinates).
    /// * `p_end_x` —          the right position of the rectangle to decode (in image coordinates).
    /// * `p_start_y` —        the up position of the rectangle to decode (in image coordinates).
    /// * `p_end_y` —          the bottom position of the rectangle to decode (in image coordinates).
    ///
    /// @return  true            if the area could be set.
    pub fn opj_set_decode_area(
        p_codec: *mut opj_codec_t,
        p_image: *mut opj_image_t,
        p_start_x: OPJ_INT32,
        p_start_y: OPJ_INT32,
        p_end_x: OPJ_INT32,
        p_end_y: OPJ_INT32,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Decode an image from a JPEG-2000 codestream
    ///
    /// * `p_decompressor` —     decompressor handle
    /// * `p_stream` —           Input buffer stream
    /// * `p_image` —            the decoded image
    /// @return                  true if success, otherwise false
    pub fn opj_decode(
        p_decompressor: *mut opj_codec_t,
        p_stream: *mut opj_stream_t,
        p_image: *mut opj_image_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Get the decoded tile from the codec
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `p_stream` —         input streamm
    /// * `p_image` —          output image
    /// * `tile_index` —       index of the tile which will be decode
    ///
    /// @return                  true if success, otherwise false
    pub fn opj_get_decoded_tile(
        p_codec: *mut opj_codec_t,
        p_stream: *mut opj_stream_t,
        p_image: *mut opj_image_t,
        tile_index: OPJ_UINT32,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Set the resolution factor of the decoded image
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `res_factor` —       resolution factor to set
    ///
    /// @return                  true if success, otherwise false
    pub fn opj_set_decoded_resolution_factor(
        p_codec: *mut opj_codec_t,
        res_factor: OPJ_UINT32,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Writes a tile with the given data.
    ///
    /// * `p_codec` —              the jpeg2000 codec.
    /// * `p_tile_index` —         the index of the tile to write. At the moment, the tiles must be written from 0 to n-1 in sequence.
    /// * `p_data` —               pointer to the data to write. Data is arranged in sequence, data_comp0, then data_comp1, then ... NO INTERLEAVING should be set.
    /// * `p_data_size` —          this value os used to make sure the data being written is correct. The size must be equal to the sum for each component of
    ///                              tile_width * tile_height * component_size. component_size can be 1,2 or 4 bytes, depending on the precision of the given component.
    /// * `p_stream` —             the stream to write data to.
    ///
    /// @return  true if the data could be written.
    pub fn opj_write_tile(
        p_codec: *mut opj_codec_t,
        p_tile_index: OPJ_UINT32,
        p_data: *mut OPJ_BYTE,
        p_data_size: OPJ_UINT32,
        p_stream: *mut opj_stream_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Reads a tile header. This function is compulsory and allows one to know the size of the tile that will be decoded.
    /// The user may need to refer to the image got by opj_read_header to understand the size being taken by the tile.
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `p_tile_index` —     pointer to a value that will hold the index of the tile being decoded, in case of success.
    /// * `p_data_size` —      pointer to a value that will hold the maximum size of the decoded data, in case of success. In case
    ///                          of truncated codestreams, the actual number of bytes decoded may be lower. The computation of the size is the same
    ///                          as depicted in opj_write_tile.
    /// * `p_tile_x0` —        pointer to a value that will hold the x0 pos of the tile (in the image).
    /// * `p_tile_y0` —        pointer to a value that will hold the y0 pos of the tile (in the image).
    /// * `p_tile_x1` —        pointer to a value that will hold the x1 pos of the tile (in the image).
    /// * `p_tile_y1` —        pointer to a value that will hold the y1 pos of the tile (in the image).
    /// * `p_nb_comps` —       pointer to a value that will hold the number of components in the tile.
    /// * `p_should_go_on` —   pointer to a boolean that will hold the fact that the decoding should go on. In case the
    ///                          codestream is over at the time of the call, the value will be set to false. The user should then stop
    ///                          the decoding.
    /// * `p_stream` —         the stream to decode.
    /// @return  true            if the tile header could be decoded. In case the decoding should end, the returned value is still true.
    ///                          returning false may be the result of a shortage of memory or an internal error.
    pub fn opj_read_tile_header(
        p_codec: *mut opj_codec_t,
        p_stream: *mut opj_stream_t,
        p_tile_index: *mut OPJ_UINT32,
        p_data_size: *mut OPJ_UINT32,
        p_tile_x0: *mut OPJ_INT32,
        p_tile_y0: *mut OPJ_INT32,
        p_tile_x1: *mut OPJ_INT32,
        p_tile_y1: *mut OPJ_INT32,
        p_nb_comps: *mut OPJ_UINT32,
        p_should_go_on: *mut OPJ_BOOL,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Reads a tile data. This function is compulsory and allows one to decode tile data. opj_read_tile_header should be called before.
    /// The user may need to refer to the image got by opj_read_header to understand the size being taken by the tile.
    ///
    /// Note: opj_decode_tile_data() should not be used together with opj_set_decoded_components().
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `p_tile_index` —     the index of the tile being decoded, this should be the value set by opj_read_tile_header.
    /// * `p_data` —           pointer to a memory block that will hold the decoded data.
    /// * `p_data_size` —      size of p_data. p_data_size should be bigger or equal to the value set by opj_read_tile_header.
    /// * `p_stream` —         the stream to decode.
    ///
    /// @return  true            if the data could be decoded.
    pub fn opj_decode_tile_data(
        p_codec: *mut opj_codec_t,
        p_tile_index: OPJ_UINT32,
        p_data: *mut OPJ_BYTE,
        p_data_size: OPJ_UINT32,
        p_stream: *mut opj_stream_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Creates a J2K/JP2 compression structure
    /// * `format` —       Coder to select
    /// @return              Returns a handle to a compressor if successful, returns NULL otherwise
    pub fn opj_create_compress(format: OPJ_CODEC_FORMAT) -> *mut opj_codec_t;
}
extern "C" {
    ///Set encoding parameters to default values, that means :
    ///<ul>
    ///<li>Lossless
    ///<li>1 tile
    ///<li>Size of precinct : 2^15 x 2^15 (means 1 precinct)
    ///<li>Size of code-block : 64 x 64
    ///<li>Number of resolutions: 6
    ///<li>No SOP marker in the codestream
    ///<li>No EPH marker in the codestream
    ///<li>No sub-sampling in x or y direction
    ///<li>No mode switch activated
    ///<li>Progression order: LRCP
    ///<li>No index file
    ///<li>No ROI upshifted
    ///<li>No offset of the origin of the image
    ///<li>No offset of the origin of the tiles
    ///<li>Reversible DWT 5-3
    ///</ul>
    ///@param parameters Compression parameters
    pub fn opj_set_default_encoder_parameters(parameters: *mut opj_cparameters_t);
}
extern "C" {
    /// Setup the encoder parameters using the current image and using user parameters.
    /// * `p_codec` —        Compressor handle
    /// * `parameters` —     Compression parameters
    /// * `image` —          Input filled image
    pub fn opj_setup_encoder(
        p_codec: *mut opj_codec_t,
        parameters: *mut opj_cparameters_t,
        image: *mut opj_image_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Specify extra options for the encoder.
    ///
    /// This may be called after opj_setup_encoder() and before opj_start_compress()
    ///
    /// This is the way to add new options in a fully ABI compatible way, without
    /// extending the opj_cparameters_t structure.
    ///
    /// Currently supported options are:
    /// <ul>
    /// <li>PLT=YES/NO. Defaults to NO. If set to YES, PLT marker segments,
    ///     indicating the length of each packet in the tile-part header, will be
    ///     written. Since 2.3.2</li>
    /// </ul>
    ///
    /// * 'p_codec' —        Compressor handle
    /// * 'p_options' —      Compression options. This should be a NULL terminated
    ///                      array of strings. Each string is of the form KEY=VALUE.
    ///
    /// @return OPJ_TRUE in case of success.
    /// @since 2.3.2
    pub fn opj_encoder_set_extra_options(
        p_codec: *mut opj_codec_t,
        p_options: *const *const c_char,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Start to compress the current image.
    /// * `p_codec` —        Compressor handle
    /// * `p_image` —        Input filled image
    /// * `p_stream` —       Input stgream
    pub fn opj_start_compress(
        p_codec: *mut opj_codec_t,
        p_image: *mut opj_image_t,
        p_stream: *mut opj_stream_t,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// End to compress the current image.
    /// * `p_codec` —        Compressor handle
    /// * `p_stream` —       Input stgream
    pub fn opj_end_compress(p_codec: *mut opj_codec_t, p_stream: *mut opj_stream_t) -> OPJ_BOOL;
}
extern "C" {
    /// Encode an image into a JPEG-2000 codestream
    /// * `p_codec` —        compressor handle
    /// * `p_stream` —       Output buffer stream
    ///
    /// @return              Returns true if successful, returns false otherwise
    pub fn opj_encode(p_codec: *mut opj_codec_t, p_stream: *mut opj_stream_t) -> OPJ_BOOL;
}
extern "C" {
    ///Destroy Codestream information after compression or decompression
    ///@param cstr_info Codestream information structure
    pub fn opj_destroy_cstr_info(cstr_info: *mut *mut opj_codestream_info_v2_t);
}
extern "C" {
    /// Dump the codec information into the output stream
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    /// * `info_flag` —        type of information dump.
    /// * `output_stream` —    output stream where dump the information gotten from the codec.
    ///
    pub fn opj_dump_codec(
        p_codec: *mut opj_codec_t,
        info_flag: OPJ_INT32,
        output_stream: *mut FILE,
    );
}
extern "C" {
    /// Get the codestream information from the codec
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    ///
    /// @return                  a pointer to a codestream information structure.
    ///
    pub fn opj_get_cstr_info(p_codec: *mut opj_codec_t) -> *mut opj_codestream_info_v2_t;
}
extern "C" {
    /// Get the codestream index from the codec
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    ///
    /// @return                  a pointer to a codestream index structure.
    ///
    pub fn opj_get_cstr_index(p_codec: *mut opj_codec_t) -> *mut opj_codestream_index_t;
}
extern "C" {
    pub fn opj_destroy_cstr_index(p_cstr_index: *mut *mut opj_codestream_index_t);
}
extern "C" {
    /// Get the JP2 file information from the codec FIXME
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    ///
    /// @return                  a pointer to a JP2 metadata structure.
    ///
    pub fn opj_get_jp2_metadata(p_codec: *mut opj_codec_t) -> *mut opj_jp2_metadata_t;
}
extern "C" {
    /// Get the JP2 file index from the codec FIXME
    ///
    /// * `p_codec` —          the jpeg2000 codec.
    ///
    /// @return                  a pointer to a JP2 index structure.
    ///
    pub fn opj_get_jp2_index(p_codec: *mut opj_codec_t) -> *mut opj_jp2_index_t;
}
extern "C" {
    /// Sets the MCT matrix to use.
    ///
    /// * `parameters` —       the parameters to change.
    /// * `pEncodingMatrix` —  the encoding matrix.
    /// * `p_dc_shift` —       the dc shift coefficients to use.
    /// * `pNbComp` —          the number of components of the image.
    ///
    /// @return  true if the parameters could be set.
    pub fn opj_set_MCT(
        parameters: *mut opj_cparameters_t,
        pEncodingMatrix: *mut OPJ_FLOAT32,
        p_dc_shift: *mut OPJ_INT32,
        pNbComp: OPJ_UINT32,
    ) -> OPJ_BOOL;
}
extern "C" {
    /// Returns if the library is built with thread support.
    /// OPJ_TRUE if mutex, condition, thread, thread pool are available.
    pub fn opj_has_thread_support() -> OPJ_BOOL;
}
extern "C" {
    /// Return the number of virtual CPUs
    pub fn opj_get_num_cpus() -> c_int;
}
