/* automatically generated by rust-bindgen 0.58.1 */

pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const FRAME_NUM_PARAM_SET: i32 = -1;
pub const FRAME_NUM_IDR: u32 = 0;
pub const DEBLOCKING_OFFSET: u32 = 6;
pub const DEBLOCKING_OFFSET_MINUS: i32 = -6;
pub const MAX_TEMPORAL_LAYER_NUM: u32 = 4;
pub const MAX_SPATIAL_LAYER_NUM: u32 = 4;
pub const MAX_QUALITY_LAYER_NUM: u32 = 4;
pub const MAX_LAYER_NUM_OF_FRAME: u32 = 128;
pub const MAX_NAL_UNITS_IN_LAYER: u32 = 128;
pub const MAX_RTP_PAYLOAD_LEN: u32 = 1000;
pub const AVERAGE_RTP_PAYLOAD_LEN: u32 = 800;
pub const SAVED_NALUNIT_NUM_TMP: u32 = 21;
pub const MAX_SLICES_NUM_TMP: u32 = 35;
pub const AUTO_REF_PIC_COUNT: i32 = -1;
pub const UNSPECIFIED_BIT_RATE: u32 = 0;
#[repr(i32)]
#[doc = " @brief Enumerate the type of video format"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EVideoFormatType {
    #[doc = "< rgb color formats"]
    videoFormatRGB = 1,
    videoFormatRGBA = 2,
    videoFormatRGB555 = 3,
    videoFormatRGB565 = 4,
    videoFormatBGR = 5,
    videoFormatBGRA = 6,
    videoFormatABGR = 7,
    videoFormatARGB = 8,
    #[doc = "< yuv color formats"]
    videoFormatYUY2 = 20,
    videoFormatYVYU = 21,
    videoFormatUYVY = 22,
    #[doc = "< the same as IYUV"]
    videoFormatI420 = 23,
    videoFormatYV12 = 24,
    #[doc = "< only used in SVC decoder testbed"]
    videoFormatInternal = 25,
    #[doc = "< new format for output by DXVA decoding"]
    videoFormatNV12 = 26,
    videoFormatVFlip = -2147483648,
}
#[repr(i32)]
#[doc = " @brief Enumerate  video frame type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EVideoFrameType {
    #[doc = "< encoder not ready or parameters are invalidate"]
    videoFrameTypeInvalid = 0,
    #[doc = "< IDR frame in H.264"]
    videoFrameTypeIDR = 1,
    #[doc = "< I frame type"]
    videoFrameTypeI = 2,
    #[doc = "< P frame type"]
    videoFrameTypeP = 3,
    #[doc = "< skip the frame based encoder kernel"]
    videoFrameTypeSkip = 4,
    #[doc = "< a frame where I and P slices are mixing, not supported yet"]
    videoFrameTypeIPMixed = 5,
}
#[repr(i32)]
#[doc = " @brief Enumerate  return type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum CM_RETURN {
    #[doc = "< successful"]
    cmResultSuccess = 0,
    #[doc = "< parameters are invalid"]
    cmInitParaError = 1,
    cmUnknownReason = 2,
    #[doc = "< malloc a memory error"]
    cmMallocMemeError = 3,
    #[doc = "< initial action is expected"]
    cmInitExpected = 4,
    cmUnsupportedData = 5,
}
#[repr(i32)]
#[doc = " @brief Enumulate the nal unit type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ENalUnitType {
    NAL_UNKNOWN = 0,
    NAL_SLICE = 1,
    NAL_SLICE_DPA = 2,
    NAL_SLICE_DPB = 3,
    NAL_SLICE_DPC = 4,
    #[doc = "< ref_idc != 0"]
    NAL_SLICE_IDR = 5,
    #[doc = "< ref_idc == 0"]
    NAL_SEI = 6,
    NAL_SPS = 7,
    NAL_PPS = 8,
}
#[repr(i32)]
#[doc = " @brief NRI: eNalRefIdc"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ENalPriority {
    NAL_PRIORITY_DISPOSABLE = 0,
    NAL_PRIORITY_LOW = 1,
    NAL_PRIORITY_HIGH = 2,
    NAL_PRIORITY_HIGHEST = 3,
}
pub const DEBLOCKING_IDC_0: _bindgen_ty_1 = _bindgen_ty_1::DEBLOCKING_IDC_0;
pub const DEBLOCKING_IDC_1: _bindgen_ty_1 = _bindgen_ty_1::DEBLOCKING_IDC_1;
pub const DEBLOCKING_IDC_2: _bindgen_ty_1 = _bindgen_ty_1::DEBLOCKING_IDC_2;
#[repr(i32)]
#[doc = " @brief eDeblockingIdc"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum _bindgen_ty_1 {
    DEBLOCKING_IDC_0 = 0,
    DEBLOCKING_IDC_1 = 1,
    DEBLOCKING_IDC_2 = 2,
}
pub type ERR_TOOL = ::std::os::raw::c_ushort;
pub const ET_NONE: _bindgen_ty_2 = _bindgen_ty_2::ET_NONE;
pub const ET_IP_SCALE: _bindgen_ty_2 = _bindgen_ty_2::ET_IP_SCALE;
pub const ET_FMO: _bindgen_ty_2 = _bindgen_ty_2::ET_FMO;
pub const ET_IR_R1: _bindgen_ty_2 = _bindgen_ty_2::ET_IR_R1;
pub const ET_IR_R2: _bindgen_ty_2 = _bindgen_ty_2::ET_IR_R2;
pub const ET_IR_R3: _bindgen_ty_2 = _bindgen_ty_2::ET_IR_R3;
pub const ET_FEC_HALF: _bindgen_ty_2 = _bindgen_ty_2::ET_FEC_HALF;
pub const ET_FEC_FULL: _bindgen_ty_2 = _bindgen_ty_2::ET_FEC_FULL;
pub const ET_RFS: _bindgen_ty_2 = _bindgen_ty_2::ET_RFS;
#[repr(i32)]
#[doc = "@brief to do"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum _bindgen_ty_2 {
    #[doc = "< NONE Error Tools"]
    ET_NONE = 0,
    #[doc = "< IP Scalable"]
    ET_IP_SCALE = 1,
    #[doc = "< Flexible Macroblock Ordering"]
    ET_FMO = 2,
    #[doc = "< Intra Refresh in predifined 2% MB"]
    ET_IR_R1 = 4,
    #[doc = "< Intra Refresh in predifined 5% MB"]
    ET_IR_R2 = 8,
    #[doc = "< Intra Refresh in predifined 10% MB"]
    ET_IR_R3 = 16,
    #[doc = "< Forward Error Correction in 50% redundency mode"]
    ET_FEC_HALF = 32,
    #[doc = "< Forward Error Correction in 100% redundency mode"]
    ET_FEC_FULL = 64,
    #[doc = "< Reference Frame Selection"]
    ET_RFS = 128,
}
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SliceInformation {
    #[doc = "< base buffer of coded slice(s)"]
    pub pBufferOfSlices: *mut ::std::os::raw::c_uchar,
    #[doc = "< number of coded slices"]
    pub iCodedSliceCount: ::std::os::raw::c_int,
    #[doc = "< array of slices length accordingly by number of slice"]
    pub pLengthOfSlices: *mut ::std::os::raw::c_uint,
    #[doc = "< FEC type[0, 50%FEC, 100%FEC]"]
    pub iFecType: ::std::os::raw::c_int,
    #[doc = "< index of slice in frame [FMO: 0,..,uiSliceCount-1; No FMO: 0]"]
    pub uiSliceIdx: ::std::os::raw::c_uchar,
    #[doc = "< count number of slice in frame [FMO: 2-8; No FMO: 1]"]
    pub uiSliceCount: ::std::os::raw::c_uchar,
    #[doc = "< index of frame[-1, .., idr_interval-1]"]
    pub iFrameIndex: ::std::os::raw::c_char,
    #[doc = "< NRI, priority level of slice(NAL)"]
    pub uiNalRefIdc: ::std::os::raw::c_uchar,
    #[doc = "< NAL type"]
    pub uiNalType: ::std::os::raw::c_uchar,
    #[doc = "< whether final NAL is involved in buffer of coded slices, flag used in Pause feature in T27"]
    pub uiContainingFinalNal: ::std::os::raw::c_uchar,
}
impl Default for SliceInformation {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
pub type SliceInfo = SliceInformation;
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
pub type PSliceInfo = *mut SliceInformation;
#[doc = " @brief thresholds of the initial, maximal and minimal rate"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SRateThresholds {
    #[doc = "< frame width"]
    pub iWidth: ::std::os::raw::c_int,
    #[doc = "< frame height"]
    pub iHeight: ::std::os::raw::c_int,
    #[doc = "< threshold of initial rate"]
    pub iThresholdOfInitRate: ::std::os::raw::c_int,
    #[doc = "< threshold of maximal rate"]
    pub iThresholdOfMaxRate: ::std::os::raw::c_int,
    #[doc = "< threshold of minimal rate"]
    pub iThresholdOfMinRate: ::std::os::raw::c_int,
    #[doc = "< min frame rate min"]
    pub iMinThresholdFrameRate: ::std::os::raw::c_int,
    #[doc = "< skip to frame rate min"]
    pub iSkipFrameRate: ::std::os::raw::c_int,
    #[doc = "< how many frames to skip"]
    pub iSkipFrameStep: ::std::os::raw::c_int,
}
#[doc = " @brief thresholds of the initial, maximal and minimal rate"]
pub type PRateThresholds = *mut SRateThresholds;
#[doc = " @brief  Structure for decoder memery"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagSysMemBuffer {
    #[doc = "< width of decoded pic for display"]
    pub iWidth: ::std::os::raw::c_int,
    #[doc = "< height of decoded pic for display"]
    pub iHeight: ::std::os::raw::c_int,
    #[doc = "< type is \"EVideoFormatType\""]
    pub iFormat: ::std::os::raw::c_int,
    #[doc = "< stride of 2 component"]
    pub iStride: [::std::os::raw::c_int; 2usize],
}
#[doc = " @brief  Structure for decoder memery"]
pub type SSysMEMBuffer = TagSysMemBuffer;
#[doc = " @brief  Buffer info"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TagBufferInfo {
    #[doc = "< 0: one frame data is not ready; 1: one frame data is ready"]
    pub iBufferStatus: ::std::os::raw::c_int,
    #[doc = "< input BS timestamp"]
    pub uiInBsTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "< output YUV timestamp, when bufferstatus is 1"]
    pub uiOutYuvTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "<  output buffer info"]
    pub UsrData: TagBufferInfo__bindgen_ty_1,
    pub pDst: [*mut ::std::os::raw::c_uchar; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TagBufferInfo__bindgen_ty_1 {
    #[doc = "<  memory info for one picture"]
    pub sSystemBuffer: SSysMEMBuffer,
}
impl Default for TagBufferInfo__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for TagBufferInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief  Buffer info"]
pub type SBufferInfo = TagBufferInfo;
extern "C" {
    pub static kiKeyNumMultiple: [::std::os::raw::c_char; 6usize];
}
#[doc = " @brief Struct of OpenH264 version"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _tagVersion {
    #[doc = "< The major version number"]
    pub uMajor: ::std::os::raw::c_uint,
    #[doc = "< The minor version number"]
    pub uMinor: ::std::os::raw::c_uint,
    #[doc = "< The revision number"]
    pub uRevision: ::std::os::raw::c_uint,
    #[doc = "< The reserved number, it should be 0."]
    pub uReserved: ::std::os::raw::c_uint,
}
#[doc = " @brief Struct of OpenH264 version"]
pub type OpenH264Version = _tagVersion;
#[repr(i32)]
#[doc = " @brief Decoding status"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum DECODING_STATE {
    #[doc = "< bit stream error-free"]
    dsErrorFree = 0,
    #[doc = "< need more throughput to generate a frame output,"]
    dsFramePending = 1,
    #[doc = "< layer lost at reference frame with temporal id 0"]
    dsRefLost = 2,
    #[doc = "< error bitstreams(maybe broken internal frame) the decoder cared"]
    dsBitstreamError = 4,
    #[doc = "< dependented layer is ever lost"]
    dsDepLayerLost = 8,
    #[doc = "< no parameter set NALs involved"]
    dsNoParamSets = 16,
    #[doc = "< current data error concealed specified"]
    dsDataErrorConcealed = 32,
    #[doc = "<ref picure list contains null ptrs within uiRefCount range"]
    dsRefListNullPtrs = 64,
    #[doc = "< invalid argument specified"]
    dsInvalidArgument = 4096,
    #[doc = "< initializing operation is expected"]
    dsInitialOptExpected = 8192,
    #[doc = "< out of memory due to new request"]
    dsOutOfMemory = 16384,
    #[doc = "< actual picture size exceeds size of dst pBuffer feed in decoder, so need expand its size"]
    dsDstBufNeedExpan = 32768,
}
#[repr(i32)]
#[doc = " @brief Option types introduced in SVC encoder application"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ENCODER_OPTION {
    ENCODER_OPTION_DATAFORMAT = 0,
    #[doc = "< IDR period,0/-1 means no Intra period (only the first frame); lager than 0 means the desired IDR period, must be multiple of (2^temporal_layer)"]
    ENCODER_OPTION_IDR_INTERVAL = 1,
    #[doc = "< structure of Base Param"]
    ENCODER_OPTION_SVC_ENCODE_PARAM_BASE = 2,
    #[doc = "< structure of Extension Param"]
    ENCODER_OPTION_SVC_ENCODE_PARAM_EXT = 3,
    #[doc = "< maximal input frame rate, current supported range: MAX_FRAME_RATE = 30,MIN_FRAME_RATE = 1"]
    ENCODER_OPTION_FRAME_RATE = 4,
    ENCODER_OPTION_BITRATE = 5,
    ENCODER_OPTION_MAX_BITRATE = 6,
    ENCODER_OPTION_INTER_SPATIAL_PRED = 7,
    ENCODER_OPTION_RC_MODE = 8,
    ENCODER_OPTION_RC_FRAME_SKIP = 9,
    #[doc = "< 0:disable padding;1:padding"]
    ENCODER_PADDING_PADDING = 10,
    #[doc = "< assgin the profile for each layer"]
    ENCODER_OPTION_PROFILE = 11,
    #[doc = "< assgin the level for each layer"]
    ENCODER_OPTION_LEVEL = 12,
    #[doc = "< the number of refererence frame"]
    ENCODER_OPTION_NUMBER_REF = 13,
    #[doc = "< the delivery info which is a feedback from app level"]
    ENCODER_OPTION_DELIVERY_STATUS = 14,
    ENCODER_LTR_RECOVERY_REQUEST = 15,
    ENCODER_LTR_MARKING_FEEDBACK = 16,
    ENCODER_LTR_MARKING_PERIOD = 17,
    #[doc = "< 0:disable LTR;larger than 0 enable LTR; LTR number is fixed to be 2 in current encoder"]
    ENCODER_OPTION_LTR = 18,
    ENCODER_OPTION_COMPLEXITY = 19,
    #[doc = "< enable SSEI: true--enable ssei; false--disable ssei"]
    ENCODER_OPTION_ENABLE_SSEI = 20,
    #[doc = "< enable prefix: true--enable prefix; false--disable prefix"]
    ENCODER_OPTION_ENABLE_PREFIX_NAL_ADDING = 21,
    #[doc = "< different stategy in adjust ID in SPS/PPS: 0- constant ID, 1-additional ID, 6-mapping and additional"]
    ENCODER_OPTION_SPS_PPS_ID_STRATEGY = 22,
    ENCODER_OPTION_CURRENT_PATH = 23,
    #[doc = "< dump layer reconstruct frame to a specified file"]
    ENCODER_OPTION_DUMP_FILE = 24,
    #[doc = "< trace info based on the trace level"]
    ENCODER_OPTION_TRACE_LEVEL = 25,
    #[doc = "< a void (*)(void* context, int level, const char* message) function which receives log messages"]
    ENCODER_OPTION_TRACE_CALLBACK = 26,
    #[doc = "< context info of trace callback"]
    ENCODER_OPTION_TRACE_CALLBACK_CONTEXT = 27,
    #[doc = "< read only"]
    ENCODER_OPTION_GET_STATISTICS = 28,
    #[doc = "< log interval in millisecond"]
    ENCODER_OPTION_STATISTICS_LOG_INTERVAL = 29,
    #[doc = "< advanced algorithmetic settings"]
    ENCODER_OPTION_IS_LOSSLESS_LINK = 30,
    #[doc = "< bit vary percentage"]
    ENCODER_OPTION_BITS_VARY_PERCENTAGE = 31,
}
#[repr(i32)]
#[doc = " @brief Option types introduced in decoder application"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum DECODER_OPTION {
    #[doc = "< end of stream flag"]
    DECODER_OPTION_END_OF_STREAM = 1,
    #[doc = "< feedback whether or not have VCL NAL in current AU for application layer"]
    DECODER_OPTION_VCL_NAL = 2,
    #[doc = "< feedback temporal id for application layer"]
    DECODER_OPTION_TEMPORAL_ID = 3,
    #[doc = "< feedback current decoded frame number"]
    DECODER_OPTION_FRAME_NUM = 4,
    #[doc = "< feedback current frame belong to which IDR period"]
    DECODER_OPTION_IDR_PIC_ID = 5,
    #[doc = "< feedback wether current frame mark a LTR"]
    DECODER_OPTION_LTR_MARKING_FLAG = 6,
    #[doc = "< feedback frame num marked by current Frame"]
    DECODER_OPTION_LTR_MARKED_FRAME_NUM = 7,
    #[doc = "< indicate decoder error concealment method"]
    DECODER_OPTION_ERROR_CON_IDC = 8,
    DECODER_OPTION_TRACE_LEVEL = 9,
    #[doc = "< a void (*)(void* context, int level, const char* message) function which receives log messages"]
    DECODER_OPTION_TRACE_CALLBACK = 10,
    #[doc = "< context info of trace callbac"]
    DECODER_OPTION_TRACE_CALLBACK_CONTEXT = 11,
    #[doc = "< feedback decoder statistics"]
    DECODER_OPTION_GET_STATISTICS = 12,
    #[doc = "< feedback decoder Sample Aspect Ratio info in Vui"]
    DECODER_OPTION_GET_SAR_INFO = 13,
    #[doc = "< get current AU profile info, only is used in GetOption"]
    DECODER_OPTION_PROFILE = 14,
    #[doc = "< get current AU level info,only is used in GetOption"]
    DECODER_OPTION_LEVEL = 15,
    #[doc = "< set log output interval"]
    DECODER_OPTION_STATISTICS_LOG_INTERVAL = 16,
    #[doc = "< feedback current frame is ref pic or not"]
    DECODER_OPTION_IS_REF_PIC = 17,
    #[doc = "< number of frames remaining in decoder buffer when pictures are required to re-ordered into display-order."]
    DECODER_OPTION_NUM_OF_FRAMES_REMAINING_IN_BUFFER = 18,
    #[doc = "< number of decoding threads. The maximum thread count is equal or less than lesser of (cpu core counts and 16)."]
    DECODER_OPTION_NUM_OF_THREADS = 19,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of error concealment methods"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ERROR_CON_IDC {
    ERROR_CON_DISABLE = 0,
    ERROR_CON_FRAME_COPY = 1,
    ERROR_CON_SLICE_COPY = 2,
    ERROR_CON_FRAME_COPY_CROSS_IDR = 3,
    ERROR_CON_SLICE_COPY_CROSS_IDR = 4,
    ERROR_CON_SLICE_COPY_CROSS_IDR_FREEZE_RES_CHANGE = 5,
    ERROR_CON_SLICE_MV_COPY_CROSS_IDR = 6,
    ERROR_CON_SLICE_MV_COPY_CROSS_IDR_FREEZE_RES_CHANGE = 7,
}
#[repr(i32)]
#[doc = " @brief Feedback that whether or not have VCL NAL in current AU"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum FEEDBACK_VCL_NAL_IN_AU {
    FEEDBACK_NON_VCL_NAL = 0,
    FEEDBACK_VCL_NAL = 1,
    FEEDBACK_UNKNOWN_NAL = 2,
}
#[repr(i32)]
#[doc = " @brief Type of layer being encoded"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum LAYER_TYPE {
    NON_VIDEO_CODING_LAYER = 0,
    VIDEO_CODING_LAYER = 1,
}
#[repr(i32)]
#[doc = " @brief Spatial layer num"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum LAYER_NUM {
    SPATIAL_LAYER_0 = 0,
    SPATIAL_LAYER_1 = 1,
    SPATIAL_LAYER_2 = 2,
    SPATIAL_LAYER_3 = 3,
    SPATIAL_LAYER_ALL = 4,
}
impl VIDEO_BITSTREAM_TYPE {
    pub const VIDEO_BITSTREAM_DEFAULT: VIDEO_BITSTREAM_TYPE = VIDEO_BITSTREAM_TYPE::VIDEO_BITSTREAM_SVC;
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of video bitstream which is provided to decoder"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum VIDEO_BITSTREAM_TYPE {
    VIDEO_BITSTREAM_AVC = 0,
    VIDEO_BITSTREAM_SVC = 1,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of key frame request"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum KEY_FRAME_REQUEST_TYPE {
    NO_RECOVERY_REQUSET = 0,
    LTR_RECOVERY_REQUEST = 1,
    IDR_RECOVERY_REQUEST = 2,
    NO_LTR_MARKING_FEEDBACK = 3,
    LTR_MARKING_SUCCESS = 4,
    LTR_MARKING_FAILED = 5,
}
#[doc = " @brief Structure for LTR recover request"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRRecoverRequest {
    #[doc = "< IDR request or LTR recovery request"]
    pub uiFeedbackType: ::std::os::raw::c_uint,
    #[doc = "< distinguish request from different IDR"]
    pub uiIDRPicId: ::std::os::raw::c_uint,
    pub iLastCorrectFrameNum: ::std::os::raw::c_int,
    #[doc = "< specify current decoder frame_num."]
    pub iCurrentFrameNum: ::std::os::raw::c_int,
    pub iLayerId: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for LTR marking feedback"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRMarkingFeedback {
    #[doc = "< mark failed or successful"]
    pub uiFeedbackType: ::std::os::raw::c_uint,
    #[doc = "< distinguish request from different IDR"]
    pub uiIDRPicId: ::std::os::raw::c_uint,
    #[doc = "< specify current decoder frame_num"]
    pub iLTRFrameNum: ::std::os::raw::c_int,
    pub iLayerId: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for LTR configuration"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRConfig {
    #[doc = "< 1: on, 0: off"]
    pub bEnableLongTermReference: bool,
    #[doc = "< TODO: not supported to set it arbitrary yet"]
    pub iLTRRefNum: ::std::os::raw::c_int,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of rate control mode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum RC_MODES {
    #[doc = "< quality mode"]
    RC_QUALITY_MODE = 0,
    #[doc = "< bitrate mode"]
    RC_BITRATE_MODE = 1,
    #[doc = "< no bitrate control,only using buffer status,adjust the video quality"]
    RC_BUFFERBASED_MODE = 2,
    RC_TIMESTAMP_MODE = 3,
    #[doc = "< this is in-building RC MODE, WILL BE DELETED after algorithm tuning!"]
    RC_BITRATE_MODE_POST_SKIP = 4,
    #[doc = "< rate control off mode"]
    RC_OFF_MODE = -1,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of profile id"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EProfileIdc {
    PRO_UNKNOWN = 0,
    PRO_BASELINE = 66,
    PRO_MAIN = 77,
    PRO_EXTENDED = 88,
    PRO_HIGH = 100,
    PRO_HIGH10 = 110,
    PRO_HIGH422 = 122,
    PRO_HIGH444 = 144,
    PRO_CAVLC444 = 244,
    PRO_SCALABLE_BASELINE = 83,
    PRO_SCALABLE_HIGH = 86,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of level id"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ELevelIdc {
    LEVEL_UNKNOWN = 0,
    LEVEL_1_0 = 10,
    LEVEL_1_B = 9,
    LEVEL_1_1 = 11,
    LEVEL_1_2 = 12,
    LEVEL_1_3 = 13,
    LEVEL_2_0 = 20,
    LEVEL_2_1 = 21,
    LEVEL_2_2 = 22,
    LEVEL_3_0 = 30,
    LEVEL_3_1 = 31,
    LEVEL_3_2 = 32,
    LEVEL_4_0 = 40,
    LEVEL_4_1 = 41,
    LEVEL_4_2 = 42,
    LEVEL_5_0 = 50,
    LEVEL_5_1 = 51,
    LEVEL_5_2 = 52,
}
pub const WELS_LOG_QUIET: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_QUIET;
pub const WELS_LOG_ERROR: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_ERROR;
pub const WELS_LOG_WARNING: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_WARNING;
pub const WELS_LOG_INFO: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_INFO;
pub const WELS_LOG_DEBUG: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_DEBUG;
pub const WELS_LOG_DETAIL: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_DETAIL;
pub const WELS_LOG_RESV: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_RESV;
pub const WELS_LOG_LEVEL_COUNT: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_LEVEL_COUNT;
pub const WELS_LOG_DEFAULT: _bindgen_ty_3 = _bindgen_ty_3::WELS_LOG_WARNING;
#[repr(i32)]
#[doc = " @brief Enumerate the type of wels log"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum _bindgen_ty_3 {
    #[doc = "< quiet mode"]
    WELS_LOG_QUIET = 0,
    #[doc = "< error log iLevel"]
    WELS_LOG_ERROR = 1,
    #[doc = "< Warning log iLevel"]
    WELS_LOG_WARNING = 2,
    #[doc = "< information log iLevel"]
    WELS_LOG_INFO = 4,
    #[doc = "< debug log, critical algo log"]
    WELS_LOG_DEBUG = 8,
    #[doc = "< per packet/frame log"]
    WELS_LOG_DETAIL = 16,
    #[doc = "< resversed log iLevel"]
    WELS_LOG_RESV = 32,
    WELS_LOG_LEVEL_COUNT = 6,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of slice mode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum SliceModeEnum {
    #[doc = "< | SliceNum==1"]
    SM_SINGLE_SLICE = 0,
    #[doc = "< | according to SliceNum        | enabled dynamic slicing for multi-thread"]
    SM_FIXEDSLCNUM_SLICE = 1,
    #[doc = "< | according to SlicesAssign    | need input of MB numbers each slice. In addition, if other constraint in SSliceArgument is presented, need to follow the constraints. Typically if MB num and slice size are both constrained, re-encoding may be involved."]
    SM_RASTER_SLICE = 2,
    #[doc = "< | according to SliceSize       | slicing according to size, the slicing will be dynamic(have no idea about slice_nums until encoding current frame)"]
    SM_SIZELIMITED_SLICE = 3,
    SM_RESERVED = 4,
}
#[doc = " @brief Structure for slice argument"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SSliceArgument {
    #[doc = "< by default, uiSliceMode will be SM_SINGLE_SLICE"]
    pub uiSliceMode: SliceModeEnum,
    #[doc = "< only used when uiSliceMode=1, when uiSliceNum=0 means auto design it with cpu core number"]
    pub uiSliceNum: ::std::os::raw::c_uint,
    #[doc = "< only used when uiSliceMode=2; when =0 means setting one MB row a slice"]
    pub uiSliceMbNum: [::std::os::raw::c_uint; 35usize],
    #[doc = "< now only used when uiSliceMode=4"]
    pub uiSliceSizeConstraint: ::std::os::raw::c_uint,
}
impl Default for SSliceArgument {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of video format"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EVideoFormatSPS {
    VF_COMPONENT = 0,
    VF_PAL = 1,
    VF_NTSC = 2,
    VF_SECAM = 3,
    VF_MAC = 4,
    VF_UNDEF = 5,
    VF_NUM_ENUM = 6,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of color primaries"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EColorPrimaries {
    CP_RESERVED0 = 0,
    CP_BT709 = 1,
    CP_UNDEF = 2,
    CP_RESERVED3 = 3,
    CP_BT470M = 4,
    CP_BT470BG = 5,
    CP_SMPTE170M = 6,
    CP_SMPTE240M = 7,
    CP_FILM = 8,
    CP_BT2020 = 9,
    CP_NUM_ENUM = 10,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of transfer characteristics"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ETransferCharacteristics {
    TRC_RESERVED0 = 0,
    TRC_BT709 = 1,
    TRC_UNDEF = 2,
    TRC_RESERVED3 = 3,
    TRC_BT470M = 4,
    TRC_BT470BG = 5,
    TRC_SMPTE170M = 6,
    TRC_SMPTE240M = 7,
    TRC_LINEAR = 8,
    TRC_LOG100 = 9,
    TRC_LOG316 = 10,
    TRC_IEC61966_2_4 = 11,
    TRC_BT1361E = 12,
    TRC_IEC61966_2_1 = 13,
    TRC_BT2020_10 = 14,
    TRC_BT2020_12 = 15,
    TRC_NUM_ENUM = 16,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of color matrix"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EColorMatrix {
    CM_GBR = 0,
    CM_BT709 = 1,
    CM_UNDEF = 2,
    CM_RESERVED3 = 3,
    CM_FCC = 4,
    CM_BT470BG = 5,
    CM_SMPTE170M = 6,
    CM_SMPTE240M = 7,
    CM_YCGCO = 8,
    CM_BT2020NC = 9,
    CM_BT2020C = 10,
    CM_NUM_ENUM = 11,
}
#[repr(i32)]
#[doc = " @brief Enumerate the type of sample aspect ratio"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ESampleAspectRatio {
    ASP_UNSPECIFIED = 0,
    ASP_1x1 = 1,
    ASP_12x11 = 2,
    ASP_10x11 = 3,
    ASP_16x11 = 4,
    ASP_40x33 = 5,
    ASP_24x11 = 6,
    ASP_20x11 = 7,
    ASP_32x11 = 8,
    ASP_80x33 = 9,
    ASP_18x11 = 10,
    ASP_15x11 = 11,
    ASP_64x33 = 12,
    ASP_160x99 = 13,
    ASP_EXT_SAR = 255,
}
#[doc = " @brief  Structure for spatial layer configuration"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SSpatialLayerConfig {
    #[doc = "< width of picture in luminance samples of a layer"]
    pub iVideoWidth: ::std::os::raw::c_int,
    #[doc = "< height of picture in luminance samples of a layer"]
    pub iVideoHeight: ::std::os::raw::c_int,
    #[doc = "< frame rate specified for a layer"]
    pub fFrameRate: f32,
    #[doc = "< target bitrate for a spatial layer, in unit of bps"]
    pub iSpatialBitrate: ::std::os::raw::c_int,
    #[doc = "< maximum  bitrate for a spatial layer, in unit of bps"]
    pub iMaxSpatialBitrate: ::std::os::raw::c_int,
    #[doc = "< value of profile IDC (PRO_UNKNOWN for auto-detection)"]
    pub uiProfileIdc: EProfileIdc,
    #[doc = "< value of profile IDC (0 for auto-detection)"]
    pub uiLevelIdc: ELevelIdc,
    #[doc = "< value of level IDC (0 for auto-detection)"]
    pub iDLayerQp: ::std::os::raw::c_int,
    pub sSliceArgument: SSliceArgument,
    pub bVideoSignalTypePresent: bool,
    pub uiVideoFormat: ::std::os::raw::c_uchar,
    pub bFullRange: bool,
    pub bColorDescriptionPresent: bool,
    pub uiColorPrimaries: ::std::os::raw::c_uchar,
    pub uiTransferCharacteristics: ::std::os::raw::c_uchar,
    pub uiColorMatrix: ::std::os::raw::c_uchar,
    #[doc = "< aspect ratio present in VUI"]
    pub bAspectRatioPresent: bool,
    #[doc = "< aspect ratio idc"]
    pub eAspectRatio: ESampleAspectRatio,
    #[doc = "< use if aspect ratio idc == 255"]
    pub sAspectRatioExtWidth: ::std::os::raw::c_ushort,
    #[doc = "< use if aspect ratio idc == 255"]
    pub sAspectRatioExtHeight: ::std::os::raw::c_ushort,
}
impl Default for SSpatialLayerConfig {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(i32)]
#[doc = " @brief Encoder usage type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EUsageType {
    #[doc = "< camera video for real-time communication"]
    CAMERA_VIDEO_REAL_TIME = 0,
    #[doc = "< screen content signal"]
    SCREEN_CONTENT_REAL_TIME = 1,
    CAMERA_VIDEO_NON_REAL_TIME = 2,
    SCREEN_CONTENT_NON_REAL_TIME = 3,
    INPUT_CONTENT_TYPE_ALL = 4,
}
#[repr(i32)]
#[doc = " @brief Enumulate the complexity mode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum ECOMPLEXITY_MODE {
    #[doc = "< the lowest compleixty,the fastest speed,"]
    LOW_COMPLEXITY = 0,
    #[doc = "< medium complexity, medium speed,medium quality"]
    MEDIUM_COMPLEXITY = 1,
    #[doc = "< high complexity, lowest speed, high quality"]
    HIGH_COMPLEXITY = 2,
}
#[repr(i32)]
#[doc = " @brief Enumulate for the stategy of SPS/PPS strategy"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum EParameterSetStrategy {
    #[doc = "< constant id in SPS/PPS"]
    CONSTANT_ID = 0,
    #[doc = "< SPS/PPS id increases at each IDR"]
    INCREASING_ID = 1,
    #[doc = "< using SPS in the existing list if possible"]
    SPS_LISTING = 2,
    SPS_LISTING_AND_PPS_INCREASING = 3,
    SPS_PPS_LISTING = 6,
}
#[doc = " @brief SVC Encoding Parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagEncParamBase {
    #[doc = "< application type; please refer to the definition of EUsageType"]
    pub iUsageType: EUsageType,
    #[doc = "< width of picture in luminance samples (the maximum of all layers if multiple spatial layers presents)"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< height of picture in luminance samples((the maximum of all layers if multiple spatial layers presents)"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< target bitrate desired, in unit of bps"]
    pub iTargetBitrate: ::std::os::raw::c_int,
    #[doc = "< rate control mode"]
    pub iRCMode: RC_MODES,
    #[doc = "< maximal input frame rate"]
    pub fMaxFrameRate: f32,
}
impl Default for TagEncParamBase {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief SVC Encoding Parameters"]
pub type SEncParamBase = TagEncParamBase;
#[doc = " @brief SVC Encoding Parameters"]
pub type PEncParamBase = *mut TagEncParamBase;
#[doc = " @brief SVC Encoding Parameters extention"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TagEncParamExt {
    #[doc = "< same as in TagEncParamBase"]
    pub iUsageType: EUsageType,
    #[doc = "< same as in TagEncParamBase"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iTargetBitrate: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iRCMode: RC_MODES,
    #[doc = "< same as in TagEncParamBase"]
    pub fMaxFrameRate: f32,
    #[doc = "< temporal layer number, max temporal layer = 4"]
    pub iTemporalLayerNum: ::std::os::raw::c_int,
    #[doc = "< spatial layer number,1<= iSpatialLayerNum <= MAX_SPATIAL_LAYER_NUM, MAX_SPATIAL_LAYER_NUM = 4"]
    pub iSpatialLayerNum: ::std::os::raw::c_int,
    pub sSpatialLayers: [SSpatialLayerConfig; 4usize],
    pub iComplexityMode: ECOMPLEXITY_MODE,
    #[doc = "< period of Intra frame"]
    pub uiIntraPeriod: ::std::os::raw::c_uint,
    #[doc = "< number of reference frame used"]
    pub iNumRefFrame: ::std::os::raw::c_int,
    #[doc = "< different stategy in adjust ID in SPS/PPS: 0- constant ID, 1-additional ID, 6-mapping and additional"]
    pub eSpsPpsIdStrategy: EParameterSetStrategy,
    #[doc = "< false:not use Prefix NAL; true: use Prefix NAL"]
    pub bPrefixNalAddingCtrl: bool,
    #[doc = "< false:not use SSEI; true: use SSEI -- TODO: planning to remove the interface of SSEI"]
    pub bEnableSSEI: bool,
    #[doc = "< (when encoding more than 1 spatial layer) false: use SVC syntax for higher layers; true: use Simulcast AVC"]
    pub bSimulcastAVC: bool,
    #[doc = "< 0:disable padding;1:padding"]
    pub iPaddingFlag: ::std::os::raw::c_int,
    #[doc = "< 0:CAVLC  1:CABAC."]
    pub iEntropyCodingModeFlag: ::std::os::raw::c_int,
    #[doc = "< False: don't skip frame even if VBV buffer overflow.True: allow skipping frames to keep the bitrate within limits"]
    pub bEnableFrameSkip: bool,
    #[doc = "< the maximum bitrate, in unit of bps, set it to UNSPECIFIED_BIT_RATE if not needed"]
    pub iMaxBitrate: ::std::os::raw::c_int,
    #[doc = "< the maximum QP encoder supports"]
    pub iMaxQp: ::std::os::raw::c_int,
    #[doc = "< the minmum QP encoder supports"]
    pub iMinQp: ::std::os::raw::c_int,
    #[doc = "< the maximum NAL size.  This value should be not 0 for dynamic slice mode"]
    pub uiMaxNalSize: ::std::os::raw::c_uint,
    #[doc = "< 1: on, 0: off"]
    pub bEnableLongTermReference: bool,
    #[doc = "< the number of LTR(long term reference),TODO: not supported to set it arbitrary yet"]
    pub iLTRRefNum: ::std::os::raw::c_int,
    #[doc = "< the LTR marked period that is used in feedback."]
    pub iLtrMarkPeriod: ::std::os::raw::c_uint,
    #[doc = "< 1 # 0: auto(dynamic imp. internal encoder); 1: multiple threads imp. disabled; lager than 1: count number of threads;"]
    pub iMultipleThreadIdc: ::std::os::raw::c_ushort,
    #[doc = "< only used when uiSliceMode=1 or 3, will change slicing of a picture during the run-time of multi-thread encoding, so the result of each run may be different"]
    pub bUseLoadBalancing: bool,
    #[doc = "< 0: on, 1: off, 2: on except for slice boundaries"]
    pub iLoopFilterDisableIdc: ::std::os::raw::c_int,
    #[doc = "< AlphaOffset: valid range [-6, 6], default 0"]
    pub iLoopFilterAlphaC0Offset: ::std::os::raw::c_int,
    #[doc = "< BetaOffset: valid range [-6, 6], default 0"]
    pub iLoopFilterBetaOffset: ::std::os::raw::c_int,
    #[doc = "< denoise control"]
    pub bEnableDenoise: bool,
    #[doc = "< background detection control //VAA_BACKGROUND_DETECTION //BGD cmd"]
    pub bEnableBackgroundDetection: bool,
    #[doc = "< adaptive quantization control"]
    pub bEnableAdaptiveQuant: bool,
    #[doc = "< enable frame cropping flag: TRUE always in application"]
    pub bEnableFrameCroppingFlag: bool,
    pub bEnableSceneChangeDetect: bool,
    #[doc = "<  LTR advanced setting"]
    pub bIsLosslessLink: bool,
}
impl Default for TagEncParamExt {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief SVC Encoding Parameters extention"]
pub type SEncParamExt = TagEncParamExt;
#[doc = " @brief Define a new struct to show the property of video bitstream."]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SVideoProperty {
    #[doc = "< size of the struct"]
    pub size: ::std::os::raw::c_uint,
    #[doc = "< video stream type (AVC/SVC)"]
    pub eVideoBsType: VIDEO_BITSTREAM_TYPE,
}
impl Default for SVideoProperty {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagSVCDecodingParam {
    #[doc = "< file name of reconstructed frame used for PSNR calculation based debug"]
    pub pFileNameRestructed: *mut ::std::os::raw::c_char,
    #[doc = "< CPU load"]
    pub uiCpuLoad: ::std::os::raw::c_uint,
    #[doc = "< setting target dq layer id"]
    pub uiTargetDqLayer: ::std::os::raw::c_uchar,
    #[doc = "< whether active error concealment feature in decoder"]
    pub eEcActiveIdc: ERROR_CON_IDC,
    #[doc = "< decoder for parse only, no reconstruction. When it is true, SPS/PPS size should not exceed SPS_PPS_BS_SIZE (128). Otherwise, it will return error info"]
    pub bParseOnly: bool,
    #[doc = "< video stream property"]
    pub sVideoProperty: SVideoProperty,
}
impl Default for TagSVCDecodingParam {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
pub type SDecodingParam = TagSVCDecodingParam;
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
pub type PDecodingParam = *mut TagSVCDecodingParam;
#[doc = " @brief Bitstream inforamtion of a layer being encoded"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLayerBSInfo {
    pub uiTemporalId: ::std::os::raw::c_uchar,
    pub uiSpatialId: ::std::os::raw::c_uchar,
    pub uiQualityId: ::std::os::raw::c_uchar,
    pub eFrameType: EVideoFrameType,
    pub uiLayerType: ::std::os::raw::c_uchar,
    #[doc = "< refer to D.2.11 Sub-sequence information SEI message semantics"]
    pub iSubSeqId: ::std::os::raw::c_int,
    #[doc = "< count number of NAL coded already"]
    pub iNalCount: ::std::os::raw::c_int,
    #[doc = "< length of NAL size in byte from 0 to iNalCount-1"]
    pub pNalLengthInByte: *mut ::std::os::raw::c_int,
    #[doc = "< buffer of bitstream contained"]
    pub pBsBuf: *mut ::std::os::raw::c_uchar,
}
impl Default for SLayerBSInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Bitstream inforamtion of a layer being encoded"]
pub type PLayerBSInfo = *mut SLayerBSInfo;
#[doc = " @brief Frame bit stream info"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SFrameBSInfo {
    pub iLayerNum: ::std::os::raw::c_int,
    pub sLayerInfo: [SLayerBSInfo; 128usize],
    pub eFrameType: EVideoFrameType,
    pub iFrameSizeInBytes: ::std::os::raw::c_int,
    pub uiTimeStamp: ::std::os::raw::c_longlong,
}
impl Default for SFrameBSInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Frame bit stream info"]
pub type PFrameBSInfo = *mut SFrameBSInfo;
#[doc = "  @brief Structure for source picture"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct Source_Picture_s {
    #[doc = "< color space type"]
    pub iColorFormat: ::std::os::raw::c_int,
    #[doc = "< stride for each plane pData"]
    pub iStride: [::std::os::raw::c_int; 4usize],
    #[doc = "< plane pData"]
    pub pData: [*mut ::std::os::raw::c_uchar; 4usize],
    #[doc = "< luma picture width in x coordinate"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< luma picture height in y coordinate"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< timestamp of the source picture, unit: millisecond"]
    pub uiTimeStamp: ::std::os::raw::c_longlong,
}
impl Default for Source_Picture_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = "  @brief Structure for source picture"]
pub type SSourcePicture = Source_Picture_s;
#[doc = " @brief Structure for bit rate info"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagBitrateInfo {
    pub iLayer: LAYER_NUM,
    #[doc = "< the maximum bitrate"]
    pub iBitrate: ::std::os::raw::c_int,
}
impl Default for TagBitrateInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Structure for bit rate info"]
pub type SBitrateInfo = TagBitrateInfo;
#[doc = " @brief Structure for dump layer info"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDumpLayer {
    pub iLayer: ::std::os::raw::c_int,
    pub pFileName: *mut ::std::os::raw::c_char,
}
impl Default for TagDumpLayer {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Structure for dump layer info"]
pub type SDumpLayer = TagDumpLayer;
#[doc = " @brief Structure for profile info in layer"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagProfileInfo {
    pub iLayer: ::std::os::raw::c_int,
    #[doc = "< the profile info"]
    pub uiProfileIdc: EProfileIdc,
}
impl Default for TagProfileInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Structure for profile info in layer"]
pub type SProfileInfo = TagProfileInfo;
#[doc = " @brief  Structure for level info in layer"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagLevelInfo {
    pub iLayer: ::std::os::raw::c_int,
    #[doc = "< the level info"]
    pub uiLevelIdc: ELevelIdc,
}
impl Default for TagLevelInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief  Structure for level info in layer"]
pub type SLevelInfo = TagLevelInfo;
#[doc = " @brief Structure for dilivery status"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDeliveryStatus {
    #[doc = "< 0: the previous frame isn't delivered,1: the previous frame is delivered"]
    pub bDeliveryFlag: bool,
    #[doc = "< the frame type that is dropped; reserved"]
    pub iDropFrameType: ::std::os::raw::c_int,
    #[doc = "< the frame size that is dropped; reserved"]
    pub iDropFrameSize: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for dilivery status"]
pub type SDeliveryStatus = TagDeliveryStatus;
#[doc = " @brief The capability of decoder, for SDP negotiation"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDecoderCapability {
    #[doc = "< profile_idc"]
    pub iProfileIdc: ::std::os::raw::c_int,
    #[doc = "< profile-iop"]
    pub iProfileIop: ::std::os::raw::c_int,
    #[doc = "< level_idc"]
    pub iLevelIdc: ::std::os::raw::c_int,
    #[doc = "< max-mbps"]
    pub iMaxMbps: ::std::os::raw::c_int,
    #[doc = "< max-fs"]
    pub iMaxFs: ::std::os::raw::c_int,
    #[doc = "< max-cpb"]
    pub iMaxCpb: ::std::os::raw::c_int,
    #[doc = "< max-dpb"]
    pub iMaxDpb: ::std::os::raw::c_int,
    #[doc = "< max-br"]
    pub iMaxBr: ::std::os::raw::c_int,
    #[doc = "< redundant-pic-cap"]
    pub bRedPicCap: bool,
}
#[doc = " @brief The capability of decoder, for SDP negotiation"]
pub type SDecoderCapability = TagDecoderCapability;
#[doc = " @brief Structure for parse only output"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagParserBsInfo {
    #[doc = "< total NAL number in current AU"]
    pub iNalNum: ::std::os::raw::c_int,
    #[doc = "< each nal length"]
    pub pNalLenInByte: *mut ::std::os::raw::c_int,
    #[doc = "< outputted dst buffer for parsed bitstream"]
    pub pDstBuff: *mut ::std::os::raw::c_uchar,
    #[doc = "< required SPS width info"]
    pub iSpsWidthInPixel: ::std::os::raw::c_int,
    #[doc = "< required SPS height info"]
    pub iSpsHeightInPixel: ::std::os::raw::c_int,
    #[doc = "< input BS timestamp"]
    pub uiInBsTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "< output BS timestamp"]
    pub uiOutBsTimeStamp: ::std::os::raw::c_ulonglong,
}
impl Default for TagParserBsInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " @brief Structure for parse only output"]
pub type SParserBsInfo = TagParserBsInfo;
#[doc = " @brief Structure for parse only output"]
pub type PParserBsInfo = *mut TagParserBsInfo;
#[doc = " @brief Structure for encoder statistics"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagVideoEncoderStatistics {
    #[doc = "< the width of encoded frame"]
    pub uiWidth: ::std::os::raw::c_uint,
    #[doc = "< the height of encoded frame"]
    pub uiHeight: ::std::os::raw::c_uint,
    #[doc = "< average_Encoding_Time"]
    pub fAverageFrameSpeedInMs: f32,
    #[doc = "< the average frame rate in, calculate since encoding starts, supposed that the input timestamp is in unit of ms"]
    pub fAverageFrameRate: f32,
    #[doc = "< the frame rate in, in the last second, supposed that the input timestamp is in unit of ms (? useful for checking BR, but is it easy to calculate?"]
    pub fLatestFrameRate: f32,
    #[doc = "< sendrate in Bits per second, calculated within the set time-window"]
    pub uiBitRate: ::std::os::raw::c_uint,
    #[doc = "< the average QP of last encoded frame"]
    pub uiAverageFrameQP: ::std::os::raw::c_uint,
    #[doc = "< number of frames"]
    pub uiInputFrameCount: ::std::os::raw::c_uint,
    #[doc = "< number of frames"]
    pub uiSkippedFrameCount: ::std::os::raw::c_uint,
    #[doc = "< uiResolutionChangeTimes"]
    pub uiResolutionChangeTimes: ::std::os::raw::c_uint,
    #[doc = "< number of IDR requests"]
    pub uiIDRReqNum: ::std::os::raw::c_uint,
    #[doc = "< number of actual IDRs sent"]
    pub uiIDRSentNum: ::std::os::raw::c_uint,
    #[doc = "< number of LTR sent/marked"]
    pub uiLTRSentNum: ::std::os::raw::c_uint,
    #[doc = "< Timestamp of updating the statistics"]
    pub iStatisticsTs: ::std::os::raw::c_longlong,
    pub iTotalEncodedBytes: ::std::os::raw::c_ulong,
    pub iLastStatisticsBytes: ::std::os::raw::c_ulong,
    pub iLastStatisticsFrameCount: ::std::os::raw::c_ulong,
}
#[doc = " @brief Structure for encoder statistics"]
pub type SEncoderStatistics = TagVideoEncoderStatistics;
#[doc = " @brief  Structure for decoder statistics"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagVideoDecoderStatistics {
    #[doc = "< the width of encode/decode frame"]
    pub uiWidth: ::std::os::raw::c_uint,
    #[doc = "< the height of encode/decode frame"]
    pub uiHeight: ::std::os::raw::c_uint,
    #[doc = "< average_Decoding_Time"]
    pub fAverageFrameSpeedInMs: f32,
    #[doc = "< actual average_Decoding_Time, including freezing pictures"]
    pub fActualAverageFrameSpeedInMs: f32,
    #[doc = "< number of frames"]
    pub uiDecodedFrameCount: ::std::os::raw::c_uint,
    #[doc = "< uiResolutionChangeTimes"]
    pub uiResolutionChangeTimes: ::std::os::raw::c_uint,
    #[doc = "< number of correct IDR received"]
    pub uiIDRCorrectNum: ::std::os::raw::c_uint,
    #[doc = "< when EC is on, the average ratio of total EC areas, can be an indicator of reconstruction quality"]
    pub uiAvgEcRatio: ::std::os::raw::c_uint,
    #[doc = "< when EC is on, the rough average ratio of propogate EC areas, can be an indicator of reconstruction quality"]
    pub uiAvgEcPropRatio: ::std::os::raw::c_uint,
    #[doc = "< number of actual unintegrity IDR or not received but eced"]
    pub uiEcIDRNum: ::std::os::raw::c_uint,
    #[doc = "<"]
    pub uiEcFrameNum: ::std::os::raw::c_uint,
    #[doc = "< number of whole lost IDR"]
    pub uiIDRLostNum: ::std::os::raw::c_uint,
    #[doc = "< number of freezing IDR with error (partly received), under resolution change"]
    pub uiFreezingIDRNum: ::std::os::raw::c_uint,
    #[doc = "< number of freezing non-IDR with error"]
    pub uiFreezingNonIDRNum: ::std::os::raw::c_uint,
    #[doc = "< average luma QP. default: -1, no correct frame outputted"]
    pub iAvgLumaQp: ::std::os::raw::c_int,
    #[doc = "< number of Sps Invalid report"]
    pub iSpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of SubSps Invalid report"]
    pub iSubSpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of Pps Invalid report"]
    pub iPpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of Sps NoExist Nal"]
    pub iSpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< number of SubSps NoExist Nal"]
    pub iSubSpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< number of Pps NoExist Nal"]
    pub iPpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< Profile idc in syntax"]
    pub uiProfile: ::std::os::raw::c_uint,
    #[doc = "< level idc according to Annex A-1"]
    pub uiLevel: ::std::os::raw::c_uint,
    #[doc = "< current active SPS id"]
    pub iCurrentActiveSpsId: ::std::os::raw::c_int,
    #[doc = "< current active PPS id"]
    pub iCurrentActivePpsId: ::std::os::raw::c_int,
    #[doc = "< frame interval of statistics log"]
    pub iStatisticsLogInterval: ::std::os::raw::c_uint,
}
#[doc = " @brief  Structure for decoder statistics"]
pub type SDecoderStatistics = TagVideoDecoderStatistics;
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagVuiSarInfo {
    #[doc = "< SAR width"]
    pub uiSarWidth: ::std::os::raw::c_uint,
    #[doc = "< SAR height"]
    pub uiSarHeight: ::std::os::raw::c_uint,
    #[doc = "< SAR overscan flag"]
    pub bOverscanAppropriateFlag: bool,
}
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
pub type SVuiSarInfo = TagVuiSarInfo;
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
pub type PVuiSarInfo = *mut TagVuiSarInfo;
pub type ISVCEncoder = *const ISVCEncoderVtbl;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ISVCEncoderVtbl {
    pub Initialize: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *const SEncParamBase) -> ::std::os::raw::c_int,
    >,
    pub InitializeExt:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *const SEncParamExt) -> ::std::os::raw::c_int>,
    pub GetDefaultParams:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *mut SEncParamExt) -> ::std::os::raw::c_int>,
    pub Uninitialize: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder) -> ::std::os::raw::c_int>,
    pub EncodeFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            kpSrcPic: *const SSourcePicture,
            pBsInfo: *mut SFrameBSInfo,
        ) -> ::std::os::raw::c_int,
    >,
    pub EncodeParameterSets:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pBsInfo: *mut SFrameBSInfo) -> ::std::os::raw::c_int>,
    pub ForceIntraFrame: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, bIDR: bool) -> ::std::os::raw::c_int>,
    pub SetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            eOptionId: ENCODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub GetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            eOptionId: ENCODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
pub type ISVCDecoder = *const ISVCDecoderVtbl;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ISVCDecoderVtbl {
    pub Initialize: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ISVCDecoder, pParam: *const SDecodingParam) -> ::std::os::raw::c_long,
    >,
    pub Uninitialize: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCDecoder) -> ::std::os::raw::c_long>,
    pub DecodeFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pStride: *mut ::std::os::raw::c_int,
            iWidth: *mut ::std::os::raw::c_int,
            iHeight: *mut ::std::os::raw::c_int,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrameNoDelay: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrame2: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub FlushFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeParser: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            pDstInfo: *mut SParserBsInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrameEx: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            pDst: *mut ::std::os::raw::c_uchar,
            iDstStride: ::std::os::raw::c_int,
            iDstLen: *mut ::std::os::raw::c_int,
            iWidth: *mut ::std::os::raw::c_int,
            iHeight: *mut ::std::os::raw::c_int,
            iColorFormat: *mut ::std::os::raw::c_int,
        ) -> DECODING_STATE,
    >,
    pub SetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            eOptionId: DECODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_long,
    >,
    pub GetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            eOptionId: DECODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_long,
    >,
}
pub type WelsTraceCallback = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, level: ::std::os::raw::c_int, string: *const ::std::os::raw::c_char),
>;
extern "C" {
    #[doc = " @brief   Create encoder"]
    #[doc = "  @param   ppEncoder encoder"]
    #[doc = "  @return  0 - success; otherwise - failed;"]
    pub fn WelsCreateSVCEncoder(ppEncoder: *mut *mut ISVCEncoder) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief   Destroy encoder"]
    #[doc = "   @param   pEncoder encoder"]
    #[doc = "  @return  void"]
    pub fn WelsDestroySVCEncoder(pEncoder: *mut ISVCEncoder);
}
extern "C" {
    #[doc = " @brief   Get the capability of decoder"]
    #[doc = "  @param   pDecCapability  decoder capability"]
    #[doc = "  @return  0 - success; otherwise - failed;"]
    pub fn WelsGetDecoderCapability(pDecCapability: *mut SDecoderCapability) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief   Create decoder"]
    #[doc = "  @param   ppDecoder decoder"]
    #[doc = "  @return  0 - success; otherwise - failed;"]
    pub fn WelsCreateDecoder(ppDecoder: *mut *mut ISVCDecoder) -> ::std::os::raw::c_long;
}
extern "C" {
    #[doc = " @brief   Destroy decoder"]
    #[doc = "  @param   pDecoder  decoder"]
    #[doc = "  @return  void"]
    pub fn WelsDestroyDecoder(pDecoder: *mut ISVCDecoder);
}
extern "C" {
    #[doc = " @brief   Get codec version"]
    #[doc = "           Note, old versions of Mingw (GCC < 4.7) are buggy and use an"]
    #[doc = "           incorrect/different ABI for calling this function, making it"]
    #[doc = "           incompatible with MSVC builds."]
    #[doc = "  @return  The linked codec version"]
    pub fn WelsGetCodecVersion() -> OpenH264Version;
}
extern "C" {
    #[doc = " @brief   Get codec version"]
    #[doc = "  @param   pVersion  struct to fill in with the version"]
    pub fn WelsGetCodecVersionEx(pVersion: *mut OpenH264Version);
}
