use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize)]
pub struct ModelSimulationNodeResult {
    min: f32,
    max: f32,
    mean: f32,
    std_deviation: f32,
}

impl ModelSimulationNodeResult {
    pub fn new(params: (f32, f32, f32, f32)) -> ModelSimulationNodeResult {
        ModelSimulationNodeResult {
            min: params.0,
            max: params.1,
            mean: params.2,
            std_deviation: params.3,
        }
    }
}

#[derive(Serialize, Deserialize)]
pub struct ModelSimulationResult {
    pub(crate) control: String,
    pub(crate) risk: ModelSimulationNodeResult,
    pub(crate) lef: ModelSimulationNodeResult,
    pub(crate) v: ModelSimulationNodeResult,
}

#[derive(Serialize, Deserialize)]
pub struct SimulationResult {
    pub(crate) threat: String,
    pub(crate) simulation_result: Vec<ModelSimulationResult>,
}

#[derive(Serialize, Deserialize)]
pub struct SimulationResults {
    pub(crate) simulation_result: Vec<SimulationResult>,
}
