use crate::{
    simulations::model::nodes::{Node, NodeNames},
    Result,
};
use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct Tree {
    root: Node,
}

impl Tree {
    pub fn new() -> Tree {
        Tree {
            root: Node::new(
                NodeNames::Risk,
                vec![
                    Node::new(
                        NodeNames::LossEventFrequency,
                        vec![
                            Node::new(
                                NodeNames::ThreatEventFrequency,
                                vec![
                                    Node::new(NodeNames::ContactFrequency, vec![]),
                                    Node::new(NodeNames::ProbabilityOfAction, vec![]),
                                ],
                            ),
                            Node::new(
                                NodeNames::Vulnerability,
                                vec![
                                    Node::new(NodeNames::ThreatCapability, vec![]),
                                    Node::new(NodeNames::ControlStrength, vec![]),
                                ],
                            ),
                        ],
                    ),
                    Node::new(
                        NodeNames::LossMagnitude,
                        vec![
                            Node::new(NodeNames::PrimaryLoss, vec![]),
                            Node::new(
                                NodeNames::SecondaryLoss,
                                vec![
                                    Node::new(NodeNames::SecondaryLossEventFrequency, vec![]),
                                    Node::new(NodeNames::SecondaryLossEventMagnitude, vec![]),
                                ],
                            ),
                        ],
                    ),
                ],
            ),
        }
    }

    pub fn get(&mut self, name: &NodeNames) -> Result<(f32, f32, f32, f32)> {
        let n = self.root.search(name)?;
        Ok((
            n.min.unwrap(),
            n.max.unwrap(),
            n.mean.unwrap(),
            n.dev.unwrap(),
        ))
    }

    pub fn calc(&mut self, n: u32) -> Result<(f32, f32, f32, f32)> {
        self.root.calc(n)?;
        self.get(&NodeNames::Risk)
    }

    pub fn search(&mut self, name: &NodeNames) -> Result<&mut Node> {
        self.root.search(name)
    }
}
