use crate::{error::Error, Result};
use serde::{Deserialize, Serialize};
use serde_json::Value;

#[derive(Serialize, Deserialize, Debug, Clone)]
pub enum GenParams {
    PertParams { min: f32, mean: f32, max: f32 },
    ConstParams { val: f32 },
    NormalParams { mean: f32, dev: f32 },
}

impl GenParams {
    pub fn from_json(v: &Value) -> Result<GenParams> {
        let min = v["min"].as_f64();
        let max = v["max"].as_f64();
        let mean = v["mean"].as_f64();
        let dev = v["dev"].as_f64();
        let val = v["val"].as_f64();
        if let (Some(mmin), Some(mmax), Some(mmean)) = (min, max, mean) {
            return Ok(GenParams::PertParams {
                min: mmin as f32,
                mean: mmean as f32,
                max: mmax as f32,
            });
        }
        if let (Some(mmean), Some(mdev)) = (mean, dev) {
            return Ok(GenParams::NormalParams {
                mean: mmean as f32,
                dev: mdev as f32,
            });
        }
        if let Some(mval) = val {
            return Ok(GenParams::ConstParams { val: mval as f32 });
        }

        Err(Error::UnsupportedDistributionSetting { e: v.clone() })
    }
}
