OpenFAIR-RS
===========

Factor Analysis of Information Risk (OpenFAIR) is a model/method 
to help organizations understand the level of risk present in 
their IT environments.

The FAIR methodology is conceived as a way to provide meaningful 
measurements so that it could satisfy management's desire to 
make effective comparisons and well-informed decisions. 
FAIR has become the only international standard Value at 
Risk (VaR) model for cyber-security and operational risk.

FAIR is a methodology for analyzing cybersecurity risk. Here, we 
will refer to risk as the total dollar amount of expected loss 
for a given timeframe. In a general sense, FAIR methodology works 
by breaking risk into its individual components. These components can 
then be measured or estimated numerically, allowing for a 
quantitative calculation of risk as a whole.

The actual calculation for risk often takes the form of a [Monte Carlo method](https://en.wikipedia.org/wiki/Monte_Carlo_method).

This is based on the terms found in:

1. [Open FAIR™ RISK TAXONOMY (O-RT)](https://publications.opengroup.org/c13k>)
2. [Open FAIR™ RISK ANALYSIS (O-RA)](https://publications.opengroup.org/c13g>)

*"Open FAIR" is a trademark of the Open Group.*

### Requirements
- Rust 1.50+

### Usage
- Cargo.toml
```toml
[dependencies]
openfair = "0.1.1"
```

and then

```rust
use openfair::{simulate, Result};
use std::fs::read_to_string;

fn main() -> Result<()> {
    let input = read_to_string("data/input.json")?;
    let result = simulate(&serde_json::from_str(&input)?)?;
    println!("{:#?}", result);
    
    Ok(())
}
```

### Example
- Running the example to return the output
```bash
cargo run --example eg1 -- -i data/input.json
```

- Running the example to return the chart data output
```bash
cargo run --example eg1 -- -i data/input.json --generate-chart
```

### Reference
- [Open Group](https://www.opengroup.org/certifications/openfair)

---
License: MIT/Apache 2.0