# Use s3 as backend

[s3.rs](s3.rs) provides a detailed examples for using s3 as backend.

`access_key_id` and `secret_access_key` could be loaded from `~/.aws/config` automatically:

```shell
OPENDAL_S3_BUCKET=opendal OPENDAL_S3_REGION=test cargo run --example s3
```

Or specify manually:

```shell
OPENDAL_S3_BUCKET=opendal OPENDAL_S3_ACCESS_KEY_ID=minioadmin OPENDAL_S3_SECRET_ACCESS_KEY=minioadminx OPENDAL_S3_ENDPOINT=http://127.0.0.1:9900 OPENDAL_S3_REGION=test cargo run --example s3
```

All config could be passed via environment:

- `OPENDAL_S3_ROOT`: root path, default: /
- `OPENDAL_S3_BUCKET`: bukcet name, required.
- `OPENDAL_S3_ENDPOINT`: endpoint of s3 service, default: https://s3.amazonaws.com
- `OPENDAL_S3_REGION`: region of s3 service, could be auto detected.
- `OPENDAL_S3_ACCESS_KEY_ID`: access key id of s3 service, could be auto detected.
- `OPENDAL_S3_SECRET_ACCESS_KEY`: secret access key of s3 service, could be auto detected.
