use crate::{mod_prelude_sys::*, core};

#[cfg(ocvrs_has_module_alphamat)]
mod alphamat_sys {
	use super::*;

	extern "C" {
		pub fn cv_alphamat_infoFlow_const__InputArrayR_const__InputArrayR_const__OutputArrayR(image: *const c_void, tmap: *const c_void, result: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_alphamat)]
pub use alphamat_sys::*;

#[cfg(ocvrs_has_module_aruco)]
mod aruco_sys {
	use super::*;

	extern "C" {
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_aruco_detectCharucoDiamond_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(image: *const c_void, marker_corners: *const c_void, marker_ids: *const c_void, square_marker_length_rate: f32, diamond_corners: *const c_void, diamond_ids: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void) -> Result_void;
		pub fn cv_aruco_detectMarkers_const__InputArrayR_const_Ptr_Dictionary_R_const__OutputArrayR_const__OutputArrayR_const_Ptr_DetectorParameters_R_const__OutputArrayR_const__InputArrayR_const__InputArrayR(image: *const c_void, dictionary: *const c_void, corners: *const c_void, ids: *const c_void, parameters: *const c_void, rejected_img_points: *const c_void, camera_matrix: *const c_void, dist_coeff: *const c_void) -> Result_void;
		pub fn cv_aruco_drawAxis_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_float(image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, length: f32) -> Result_void;
		pub fn cv_aruco_drawCharucoDiamond_const_Ptr_Dictionary_R_Vec4i_int_int_const__OutputArrayR_int_int(dictionary: *const c_void, ids: *const core::Vec4i, square_length: i32, marker_length: i32, img: *const c_void, margin_size: i32, border_bits: i32) -> Result_void;
		pub fn cv_aruco_drawDetectedCornersCharuco_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(image: *const c_void, charuco_corners: *const c_void, charuco_ids: *const c_void, corner_color: *const core::Scalar) -> Result_void;
		pub fn cv_aruco_drawDetectedDiamonds_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(image: *const c_void, diamond_corners: *const c_void, diamond_ids: *const c_void, border_color: *const core::Scalar) -> Result_void;
		pub fn cv_aruco_drawDetectedMarkers_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(image: *const c_void, corners: *const c_void, ids: *const c_void, border_color: *const core::Scalar) -> Result_void;
		pub fn cv_aruco_drawMarker_const_Ptr_Dictionary_R_int_int_const__OutputArrayR_int(dictionary: *const c_void, id: i32, side_pixels: i32, img: *const c_void, border_bits: i32) -> Result_void;
		pub fn cv_aruco_drawPlanarBoard_const_Ptr_Board_R_Size_const__OutputArrayR_int_int(board: *const c_void, out_size: *const core::Size, img: *const c_void, margin_size: i32, border_bits: i32) -> Result_void;
		pub fn cv_aruco_estimatePoseBoard_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(corners: *const c_void, ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool) -> Result<i32>;
		pub fn cv_aruco_estimatePoseCharucoBoard_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool) -> Result<bool>;
		pub fn cv_aruco_estimatePoseSingleMarkers_const__InputArrayR_float_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(corners: *const c_void, marker_length: f32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, _obj_points: *const c_void) -> Result_void;
		pub fn cv_aruco_generateCustomDictionary_int_int_const_Ptr_Dictionary_R_int(n_markers: i32, marker_size: i32, base_dictionary: *const c_void, random_seed: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_generateCustomDictionary_int_int_int(n_markers: i32, marker_size: i32, random_seed: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_getBoardObjectAndImagePoints_const_Ptr_Board_R_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(board: *const c_void, detected_corners: *const c_void, detected_ids: *const c_void, obj_points: *const c_void, img_points: *const c_void) -> Result_void;
		pub fn cv_aruco_getPredefinedDictionary_PREDEFINED_DICTIONARY_NAME(name: crate::aruco::PREDEFINED_DICTIONARY_NAME) -> Result<*mut c_void>;
		pub fn cv_aruco_getPredefinedDictionary_int(dict: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_interpolateCornersCharuco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(marker_corners: *const c_void, marker_ids: *const c_void, image: *const c_void, board: *const c_void, charuco_corners: *const c_void, charuco_ids: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, min_markers: i32) -> Result<i32>;
		pub fn cv_aruco_refineDetectedMarkers_const__InputArrayR_const_Ptr_Board_R_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_float_float_bool_const__OutputArrayR_const_Ptr_DetectorParameters_R(image: *const c_void, board: *const c_void, detected_corners: *const c_void, detected_ids: *const c_void, rejected_corners: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, min_rep_distance: f32, error_correction_rate: f32, check_all_orders: bool, recovered_idxs: *const c_void, parameters: *const c_void) -> Result_void;
		pub fn cv_aruco_testCharucoCornersCollinear_const_Ptr_CharucoBoard_R_const__InputArrayR(_board: *const c_void, _charuco_ids: *const c_void) -> Result<bool>;
		pub fn cv_aruco_Board_getPropObjPoints_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_Board_setPropObjPoints_vector_vector_Point3f__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_Board_getPropDictionary(instance: *mut c_void) -> *mut c_void;
		pub fn cv_aruco_Board_setPropDictionary_Ptr_Dictionary_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_Board_getPropIds_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_Board_setPropIds_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_Board_create_const__InputArrayR_const_Ptr_Dictionary_R_const__InputArrayR(obj_points: *const c_void, dictionary: *const c_void, ids: *const c_void) -> Result<*mut c_void>;
		pub fn cv_aruco_Board_setIds_const__InputArrayR(instance: *mut c_void, ids: *const c_void) -> Result_void;
		pub fn cv_aruco_CharucoBoard_getPropChessboardCorners_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_CharucoBoard_setPropChessboardCorners_vector_Point3f_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_CharucoBoard_getPropNearestMarkerIdx_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_CharucoBoard_setPropNearestMarkerIdx_vector_vector_int__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_CharucoBoard_getPropNearestMarkerCorners_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_CharucoBoard_setPropNearestMarkerCorners_vector_vector_int__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_CharucoBoard_draw_Size_const__OutputArrayR_int_int(instance: *mut c_void, out_size: *const core::Size, img: *const c_void, margin_size: i32, border_bits: i32) -> Result_void;
		pub fn cv_aruco_CharucoBoard_create_int_int_float_float_const_Ptr_Dictionary_R(squares_x: i32, squares_y: i32, square_length: f32, marker_length: f32, dictionary: *const c_void) -> Result<*mut c_void>;
		pub fn cv_aruco_CharucoBoard_getChessboardSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_aruco_CharucoBoard_getSquareLength_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_aruco_CharucoBoard_getMarkerLength_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeMin_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeMin_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeMax_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeMax_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeStep_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeStep_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAdaptiveThreshConstant_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropAdaptiveThreshConstant_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMinMarkerPerimeterRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMinMarkerPerimeterRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMaxMarkerPerimeterRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMaxMarkerPerimeterRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropPolygonalApproxAccuracyRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropPolygonalApproxAccuracyRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMinCornerDistanceRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMinCornerDistanceRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMinDistanceToBorder_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropMinDistanceToBorder_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropMinMarkerDistanceRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMinMarkerDistanceRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropCornerRefinementMethod_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropCornerRefinementMethod_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropCornerRefinementWinSize_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropCornerRefinementWinSize_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropCornerRefinementMaxIterations_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropCornerRefinementMaxIterations_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropCornerRefinementMinAccuracy_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropCornerRefinementMinAccuracy_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMarkerBorderBits_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropMarkerBorderBits_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropPerspectiveRemovePixelPerCell_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropPerspectiveRemovePixelPerCell_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropPerspectiveRemoveIgnoredMarginPerCell_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropPerspectiveRemoveIgnoredMarginPerCell_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMaxErroneousBitsInBorderRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMaxErroneousBitsInBorderRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropMinOtsuStdDev_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropMinOtsuStdDev_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropErrorCorrectionRate_const(instance: *const c_void) -> f64;
		pub fn cv_aruco_DetectorParameters_setPropErrorCorrectionRate_double(instance: *mut c_void, val: f64);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagQuadDecimate_const(instance: *const c_void) -> f32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagQuadDecimate_float(instance: *mut c_void, val: f32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagQuadSigma_const(instance: *const c_void) -> f32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagQuadSigma_float(instance: *mut c_void, val: f32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagMinClusterPixels_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagMinClusterPixels_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagMaxNmaxima_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagMaxNmaxima_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagCriticalRad_const(instance: *const c_void) -> f32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagCriticalRad_float(instance: *mut c_void, val: f32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagMaxLineFitMse_const(instance: *const c_void) -> f32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagMaxLineFitMse_float(instance: *mut c_void, val: f32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagMinWhiteBlackDiff_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagMinWhiteBlackDiff_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropAprilTagDeglitch_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_DetectorParameters_setPropAprilTagDeglitch_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_DetectorParameters_getPropDetectInvertedMarker_const(instance: *const c_void) -> bool;
		pub fn cv_aruco_DetectorParameters_setPropDetectInvertedMarker_bool(instance: *mut c_void, val: bool);
		pub fn cv_aruco_DetectorParameters_DetectorParameters() -> Result<*mut c_void>;
		pub fn cv_aruco_DetectorParameters_create() -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_getPropBytesList_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_Dictionary_setPropBytesList_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_aruco_Dictionary_getPropMarkerSize_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_Dictionary_setPropMarkerSize_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_Dictionary_getPropMaxCorrectionBits_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_Dictionary_setPropMaxCorrectionBits_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_Dictionary_Dictionary_const_MatR_int_int(_bytes_list: *const c_void, _marker_size: i32, _maxcorr: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_Dictionary_const_Ptr_Dictionary_R(_dictionary: *const c_void) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_create_int_int_int(n_markers: i32, marker_size: i32, random_seed: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_create_int_int_const_Ptr_Dictionary_R_int(n_markers: i32, marker_size: i32, base_dictionary: *const c_void, random_seed: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_get_int(dict: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_identify_const_const_MatR_intR_intR_double(instance: *const c_void, only_bits: *const c_void, idx: *mut i32, rotation: *mut i32, max_correction_rate: f64) -> Result<bool>;
		pub fn cv_aruco_Dictionary_getDistanceToId_const_const__InputArrayR_int_bool(instance: *const c_void, bits: *const c_void, id: i32, all_rotations: bool) -> Result<i32>;
		pub fn cv_aruco_Dictionary_drawMarker_const_int_int_const__OutputArrayR_int(instance: *const c_void, id: i32, side_pixels: i32, _img: *const c_void, border_bits: i32) -> Result_void;
		pub fn cv_aruco_Dictionary_getByteListFromBits_const_MatR(bits: *const c_void) -> Result<*mut c_void>;
		pub fn cv_aruco_Dictionary_getBitsFromByteList_const_MatR_int(byte_list: *const c_void, marker_size: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_GridBoard_draw_Size_const__OutputArrayR_int_int(instance: *mut c_void, out_size: *const core::Size, img: *const c_void, margin_size: i32, border_bits: i32) -> Result_void;
		pub fn cv_aruco_GridBoard_create_int_int_float_float_const_Ptr_Dictionary_R_int(markers_x: i32, markers_y: i32, marker_length: f32, marker_separation: f32, dictionary: *const c_void, first_marker: i32) -> Result<*mut c_void>;
		pub fn cv_aruco_GridBoard_getGridSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_aruco_GridBoard_getMarkerLength_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_aruco_GridBoard_getMarkerSeparation_const(instance: *const c_void) -> Result<f32>;
	}
}
#[cfg(ocvrs_has_module_aruco)]
pub use aruco_sys::*;

#[cfg(ocvrs_has_module_barcode)]
mod barcode_sys {
	use super::*;

	extern "C" {
		pub fn cv_barcode_BarcodeDetector_BarcodeDetector_const_stringR_const_stringR(prototxt_path: *const c_char, model_path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_barcode_BarcodeDetector_detect_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, img: *const c_void, points: *const c_void) -> Result<bool>;
		pub fn cv_barcode_BarcodeDetector_decode_const_const__InputArrayR_const__InputArrayR_vector_string_R_vector_BarcodeType_R(instance: *const c_void, img: *const c_void, points: *const c_void, decoded_info: *mut c_void, decoded_type: *mut c_void) -> Result<bool>;
		pub fn cv_barcode_BarcodeDetector_detectAndDecode_const_const__InputArrayR_vector_string_R_vector_BarcodeType_R_const__OutputArrayR(instance: *const c_void, img: *const c_void, decoded_info: *mut c_void, decoded_type: *mut c_void, points: *const c_void) -> Result<bool>;
	}
}
#[cfg(ocvrs_has_module_barcode)]
pub use barcode_sys::*;

#[cfg(ocvrs_has_module_bgsegm)]
mod bgsegm_sys {
	use super::*;

	extern "C" {
		pub fn cv_bgsegm_createBackgroundSubtractorCNT_int_bool_int_bool(min_pixel_stability: i32, use_history: bool, max_pixel_stability: i32, is_parallel: bool) -> Result<*mut c_void>;
		pub fn cv_bgsegm_createBackgroundSubtractorGMG_int_double(initialization_frames: i32, decision_threshold: f64) -> Result<*mut c_void>;
		pub fn cv_bgsegm_createBackgroundSubtractorGSOC_int_int_float_float_int_float_float_float_float_float_float(mc: i32, n_samples: i32, replace_rate: f32, propagation_rate: f32, hits_threshold: i32, alpha: f32, beta: f32, blinking_supression_decay: f32, blinking_supression_multiplier: f32, noise_removal_threshold_fac_bg: f32, noise_removal_threshold_fac_fg: f32) -> Result<*mut c_void>;
		pub fn cv_bgsegm_createBackgroundSubtractorLSBP_int_int_int_float_float_float_float_float_float_float_float_int_int(mc: i32, n_samples: i32, lsbp_radius: i32, tlower: f32, tupper: f32, tinc: f32, tdec: f32, rscale: f32, rincdec: f32, noise_removal_threshold_fac_bg: f32, noise_removal_threshold_fac_fg: f32, lsb_pthreshold: i32, min_count: i32) -> Result<*mut c_void>;
		pub fn cv_bgsegm_createBackgroundSubtractorMOG_int_int_double_double(history: i32, nmixtures: i32, background_ratio: f64, noise_sigma: f64) -> Result<*mut c_void>;
		pub fn cv_bgsegm_createSyntheticSequenceGenerator_const__InputArrayR_const__InputArrayR_double_double_double_double(background: *const c_void, object: *const c_void, amplitude: f64, wavelength: f64, wavespeed: f64, objspeed: f64) -> Result<*mut c_void>;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getMinPixelStability_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setMinPixelStability_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getMaxPixelStability_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setMaxPixelStability_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getUseHistory_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setUseHistory_bool(instance: *mut c_void, value: bool) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getIsParallel_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setIsParallel_bool(instance: *mut c_void, value: bool) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMaxFeatures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMaxFeatures_int(instance: *mut c_void, max_features: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getDefaultLearningRate_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setDefaultLearningRate_double(instance: *mut c_void, lr: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getNumFrames_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setNumFrames_int(instance: *mut c_void, nframes: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getQuantizationLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setQuantizationLevels_int(instance: *mut c_void, nlevels: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getBackgroundPrior_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setBackgroundPrior_double(instance: *mut c_void, bgprior: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getSmoothingRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setSmoothingRadius_int(instance: *mut c_void, radius: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getDecisionThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setDecisionThreshold_double(instance: *mut c_void, thresh: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getUpdateBackgroundModel_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setUpdateBackgroundModel_bool(instance: *mut c_void, update: bool) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMinVal_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMinVal_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMaxVal_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMaxVal_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_calcLocalSVDValues_const__OutputArrayR_const_MatR(local_svd_values: *const c_void, frame: *const c_void) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_computeFromLocalSVDValues_const__OutputArrayR_const_MatR_const_Point2iX(desc: *const c_void, local_svd_values: *const c_void, lsbp_sample_points: *const core::Point2i) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_compute_const__OutputArrayR_const_MatR_const_Point2iX(desc: *const c_void, frame: *const c_void, lsbp_sample_points: *const core::Point2i) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getHistory_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setHistory_int(instance: *mut c_void, nframes: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getNMixtures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setNMixtures_int(instance: *mut c_void, nmix: i32) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getBackgroundRatio_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setBackgroundRatio_double(instance: *mut c_void, background_ratio: f64) -> Result_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getNoiseSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setNoiseSigma_double(instance: *mut c_void, noise_sigma: f64) -> Result_void;
		pub fn cv_bgsegm_SyntheticSequenceGenerator_SyntheticSequenceGenerator_const__InputArrayR_const__InputArrayR_double_double_double_double(background: *const c_void, object: *const c_void, amplitude: f64, wavelength: f64, wavespeed: f64, objspeed: f64) -> Result<*mut c_void>;
		pub fn cv_bgsegm_SyntheticSequenceGenerator_getNextFrame_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame: *const c_void, gt_mask: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_bgsegm)]
pub use bgsegm_sys::*;

#[cfg(ocvrs_has_module_bioinspired)]
mod bioinspired_sys {
	use super::*;

	extern "C" {
		pub fn cv_bioinspired_Retina_getInputSize(instance: *mut c_void) -> Result<core::Size>;
		pub fn cv_bioinspired_Retina_getOutputSize(instance: *mut c_void) -> Result<core::Size>;
		pub fn cv_bioinspired_Retina_setup_String_const_bool(instance: *mut c_void, retina_parameter_file: *mut c_char, apply_default_setup_on_failure: bool) -> Result_void;
		pub fn cv_bioinspired_Retina_setup_FileStorageR_const_bool(instance: *mut c_void, fs: *mut c_void, apply_default_setup_on_failure: bool) -> Result_void;
		pub fn cv_bioinspired_Retina_setup_RetinaParameters(instance: *mut c_void, new_parameters: *mut c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getParameters(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_bioinspired_Retina_printSetup(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_bioinspired_Retina_write_const_String(instance: *const c_void, fs: *mut c_char) -> Result_void;
		pub fn cv_bioinspired_Retina_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_setupOPLandIPLParvoChannel_const_bool_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(instance: *mut c_void, color_mode: bool, normalise_output: bool, photoreceptors_local_adaptation_sensitivity: f32, photoreceptors_temporal_constant: f32, photoreceptors_spatial_constant: f32, horizontal_cells_gain: f32, hcells_temporal_constant: f32, hcells_spatial_constant: f32, ganglion_cells_sensitivity: f32) -> Result_void;
		pub fn cv_bioinspired_Retina_setupIPLMagnoChannel_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(instance: *mut c_void, normalise_output: bool, parasol_cells_beta: f32, parasol_cells_tau: f32, parasol_cells_k: f32, amacrin_cells_temporal_cut_frequency: f32, v0_compression_parameter: f32, local_adaptintegration_tau: f32, local_adaptintegration_k: f32) -> Result_void;
		pub fn cv_bioinspired_Retina_run_const__InputArrayR(instance: *mut c_void, input_image: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, output_tone_mapped_image: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getParvo_const__OutputArrayR(instance: *mut c_void, retina_output_parvo: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getParvoRAW_const__OutputArrayR(instance: *mut c_void, retina_output_parvo: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getMagno_const__OutputArrayR(instance: *mut c_void, retina_output_magno: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getMagnoRAW_const__OutputArrayR(instance: *mut c_void, retina_output_magno: *const c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_getMagnoRAW_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_bioinspired_Retina_getParvoRAW_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_bioinspired_Retina_setColorSaturation_const_bool_const_float(instance: *mut c_void, saturate_colors: bool, color_saturation_value: f32) -> Result_void;
		pub fn cv_bioinspired_Retina_clearBuffers(instance: *mut c_void) -> Result_void;
		pub fn cv_bioinspired_Retina_activateMovingContoursProcessing_const_bool(instance: *mut c_void, activate: bool) -> Result_void;
		pub fn cv_bioinspired_Retina_activateContoursProcessing_const_bool(instance: *mut c_void, activate: bool) -> Result_void;
		pub fn cv_bioinspired_Retina_create_Size(input_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_bioinspired_Retina_create_Size_const_bool_int_const_bool_const_float_const_float(input_size: *const core::Size, color_mode: bool, color_sampling_method: i32, use_retina_log_sampling: bool, reduction_factor: f32, sampling_strength: f32) -> Result<*mut c_void>;
		pub fn cv_bioinspired_RetinaFastToneMapping_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, output_tone_mapped_image: *const c_void) -> Result_void;
		pub fn cv_bioinspired_RetinaFastToneMapping_setup_const_float_const_float_const_float(instance: *mut c_void, photoreceptors_neighborhood_radius: f32, ganglioncells_neighborhood_radius: f32, mean_luminance_modulator_k: f32) -> Result_void;
		pub fn cv_bioinspired_RetinaFastToneMapping_create_Size(input_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_bioinspired_RetinaParameters_getPropOPLandIplParvo_const(instance: *const c_void) -> crate::bioinspired::RetinaParameters_OPLandIplParvoParameters;
		pub fn cv_bioinspired_RetinaParameters_setPropOPLandIplParvo_OPLandIplParvoParameters(instance: *mut c_void, val: *const crate::bioinspired::RetinaParameters_OPLandIplParvoParameters);
		pub fn cv_bioinspired_RetinaParameters_getPropIplMagno_const(instance: *const c_void) -> crate::bioinspired::RetinaParameters_IplMagnoParameters;
		pub fn cv_bioinspired_RetinaParameters_setPropIplMagno_IplMagnoParameters(instance: *mut c_void, val: *const crate::bioinspired::RetinaParameters_IplMagnoParameters);
		pub fn cv_bioinspired_RetinaParameters_IplMagnoParameters_IplMagnoParameters() -> Result<crate::bioinspired::RetinaParameters_IplMagnoParameters>;
		pub fn cv_bioinspired_RetinaParameters_OPLandIplParvoParameters_OPLandIplParvoParameters() -> Result<crate::bioinspired::RetinaParameters_OPLandIplParvoParameters>;
		pub fn cv_bioinspired_SegmentationParameters_SegmentationParameters() -> Result<crate::bioinspired::SegmentationParameters>;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getSize(instance: *mut c_void) -> Result<core::Size>;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_String_const_bool(instance: *mut c_void, segmentation_parameter_file: *mut c_char, apply_default_setup_on_failure: bool) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_FileStorageR_const_bool(instance: *mut c_void, fs: *mut c_void, apply_default_setup_on_failure: bool) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_SegmentationParameters(instance: *mut c_void, new_parameters: *const crate::bioinspired::SegmentationParameters) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getParameters(instance: *mut c_void) -> Result<crate::bioinspired::SegmentationParameters>;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_printSetup(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_write_const_String(instance: *const c_void, fs: *mut c_char) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_run_const__InputArrayR_const_int(instance: *mut c_void, input_to_segment: *const c_void, channel_index: i32) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getSegmentationPicture_const__OutputArrayR(instance: *mut c_void, transient_areas: *const c_void) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_clearAllBuffers(instance: *mut c_void) -> Result_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_create_Size(input_size: *const core::Size) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_bioinspired)]
pub use bioinspired_sys::*;

#[cfg(ocvrs_has_module_calib3d)]
mod calib3d_sys {
	use super::*;

	extern "C" {
		pub fn cv_RQDecomp3x3_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, mtx_r: *const c_void, mtx_q: *const c_void, qx: *const c_void, qy: *const c_void, qz: *const c_void) -> Result<core::Vec3d>;
		pub fn cv_Rodrigues_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, jacobian: *const c_void) -> Result_void;
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, std_deviations_obj_points: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_calibrateHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_HandEyeCalibrationMethod(r_gripper2base: *const c_void, t_gripper2base: *const c_void, r_target2cam: *const c_void, t_target2cam: *const c_void, r_cam2gripper: *const c_void, t_cam2gripper: *const c_void, method: crate::calib3d::HandEyeCalibrationMethod) -> Result_void;
		pub fn cv_calibrateRobotWorldHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_RobotWorldHandEyeCalibrationMethod(r_world2cam: *const c_void, t_world2cam: *const c_void, r_base2gripper: *const c_void, t_base2gripper: *const c_void, r_base2world: *const c_void, t_base2world: *const c_void, r_gripper2cam: *const c_void, t_gripper2cam: *const c_void, method: crate::calib3d::RobotWorldHandEyeCalibrationMethod) -> Result_void;
		pub fn cv_calibrationMatrixValues_const__InputArrayR_Size_double_double_doubleR_doubleR_doubleR_Point2dR_doubleR(camera_matrix: *const c_void, image_size: *const core::Size, aperture_width: f64, aperture_height: f64, fovx: *mut f64, fovy: *mut f64, focal_length: *mut f64, principal_point: *mut core::Point2d, aspect_ratio: *mut f64) -> Result_void;
		pub fn cv_checkChessboard_const__InputArrayR_Size(img: *const c_void, size: *const core::Size) -> Result<bool>;
		pub fn cv_composeRT_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(rvec1: *const c_void, tvec1: *const c_void, rvec2: *const c_void, tvec2: *const c_void, rvec3: *const c_void, tvec3: *const c_void, dr3dr1: *const c_void, dr3dt1: *const c_void, dr3dr2: *const c_void, dr3dt2: *const c_void, dt3dr1: *const c_void, dt3dt1: *const c_void, dt3dr2: *const c_void, dt3dt2: *const c_void) -> Result_void;
		pub fn cv_computeCorrespondEpilines_const__InputArrayR_int_const__InputArrayR_const__OutputArrayR(points: *const c_void, which_image: i32, f: *const c_void, lines: *const c_void) -> Result_void;
		pub fn cv_convertPointsFromHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_convertPointsHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_convertPointsToHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_correctMatches_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(f: *const c_void, points1: *const c_void, points2: *const c_void, new_points1: *const c_void, new_points2: *const c_void) -> Result_void;
		pub fn cv_decomposeEssentialMat_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(e: *const c_void, r1: *const c_void, r2: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_decomposeHomographyMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(h: *const c_void, k: *const c_void, rotations: *const c_void, translations: *const c_void, normals: *const c_void) -> Result<i32>;
		pub fn cv_decomposeProjectionMatrix_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(proj_matrix: *const c_void, camera_matrix: *const c_void, rot_matrix: *const c_void, trans_vect: *const c_void, rot_matrix_x: *const c_void, rot_matrix_y: *const c_void, rot_matrix_z: *const c_void, euler_angles: *const c_void) -> Result_void;
		pub fn cv_drawChessboardCorners_const__InputOutputArrayR_Size_const__InputArrayR_bool(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, pattern_was_found: bool) -> Result_void;
		pub fn cv_drawFrameAxes_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_int(image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, length: f32, thickness: i32) -> Result_void;
		pub fn cv_estimateAffine2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(pts1: *const c_void, pts2: *const c_void, inliers: *const c_void, params: *const crate::calib3d::UsacParams) -> Result<*mut c_void>;
		pub fn cv_estimateAffine2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_size_t_double_size_t(from: *const c_void, to: *const c_void, inliers: *const c_void, method: i32, ransac_reproj_threshold: f64, max_iters: size_t, confidence: f64, refine_iters: size_t) -> Result<*mut c_void>;
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ransac_threshold: f64, confidence: f64) -> Result<i32>;
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR_doubleX_bool(src: *const c_void, dst: *const c_void, scale: *mut f64, force_rotation: bool) -> Result<*mut c_void>;
		pub fn cv_estimateAffinePartial2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_size_t_double_size_t(from: *const c_void, to: *const c_void, inliers: *const c_void, method: i32, ransac_reproj_threshold: f64, max_iters: size_t, confidence: f64, refine_iters: size_t) -> Result<*mut c_void>;
		pub fn cv_estimateChessboardSharpness_const__InputArrayR_Size_const__InputArrayR_float_bool_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, rise_distance: f32, vertical: bool, sharpness: *const c_void) -> Result<core::Scalar>;
		pub fn cv_estimateTranslation3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ransac_threshold: f64, confidence: f64) -> Result<i32>;
		pub fn cv_filterHomographyDecompByVisibleRefpoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(rotations: *const c_void, normals: *const c_void, before_points: *const c_void, after_points: *const c_void, possible_solutions: *const c_void, points_mask: *const c_void) -> Result_void;
		pub fn cv_filterSpeckles_const__InputOutputArrayR_double_int_double_const__InputOutputArrayR(img: *const c_void, new_val: f64, max_speckle_size: i32, max_diff: f64, buf: *const c_void) -> Result_void;
		pub fn cv_find4QuadCornerSubpix_const__InputArrayR_const__InputOutputArrayR_Size(img: *const c_void, corners: *const c_void, region_size: *const core::Size) -> Result<bool>;
		pub fn cv_findChessboardCornersSB_const__InputArrayR_Size_const__OutputArrayR_int(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_findChessboardCornersSB_const__InputArrayR_Size_const__OutputArrayR_int_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32, meta: *const c_void) -> Result<bool>;
		pub fn cv_findChessboardCorners_const__InputArrayR_Size_const__OutputArrayR_int(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_findCirclesGrid_const__InputArrayR_Size_const__OutputArrayR_int_const_Ptr_Feature2D_R(image: *const c_void, pattern_size: *const core::Size, centers: *const c_void, flags: i32, blob_detector: *const c_void) -> Result<bool>;
		pub fn cv_findCirclesGrid_const__InputArrayR_Size_const__OutputArrayR_int_const_Ptr_Feature2D_R_const_CirclesGridFinderParametersR(image: *const c_void, pattern_size: *const core::Size, centers: *const c_void, flags: i32, blob_detector: *const c_void, parameters: *const crate::calib3d::CirclesGridFinderParameters) -> Result<bool>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, camera_matrix2: *const c_void, dist_coeff1: *const c_void, dist_coeff2: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams) -> Result<*mut c_void>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, method: i32, prob: f64, threshold: f64, max_iters: i32, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_double_Point2d_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, focal: f64, pp: *const core::Point2d, method: i32, prob: f64, threshold: f64, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_double_Point2d_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, focal: f64, pp: *const core::Point2d, method: i32, prob: f64, threshold: f64, max_iters: i32, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(points1: *const c_void, points2: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams) -> Result<*mut c_void>;
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_double(points1: *const c_void, points2: *const c_void, mask: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64) -> Result<*mut c_void>;
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, max_iters: i32, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(src_points: *const c_void, dst_points: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams) -> Result<*mut c_void>;
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double(src_points: *const c_void, dst_points: *const c_void, mask: *const c_void, method: i32, ransac_reproj_threshold: f64) -> Result<*mut c_void>;
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_int_double_const__OutputArrayR_const_int_const_double(src_points: *const c_void, dst_points: *const c_void, method: i32, ransac_reproj_threshold: f64, mask: *const c_void, max_iters: i32, confidence: f64) -> Result<*mut c_void>;
		pub fn cv_fisheye_calibrate_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, k: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_fisheye_distortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_double(undistorted: *const c_void, distorted: *const c_void, k: *const c_void, d: *const c_void, alpha: f64) -> Result_void;
		pub fn cv_fisheye_estimateNewCameraMatrixForUndistortRectify_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR_double_const_SizeR_double(k: *const c_void, d: *const c_void, image_size: *const core::Size, r: *const c_void, p: *const c_void, balance: f64, new_size: *const core::Size, fov_scale: f64) -> Result_void;
		pub fn cv_fisheye_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR(k: *const c_void, d: *const c_void, r: *const c_void, p: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void) -> Result_void;
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, d: *const c_void, alpha: f64, jacobian: *const c_void) -> Result_void;
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, d: *const c_void, alpha: f64, jacobian: *const c_void) -> Result_void;
		pub fn cv_fisheye_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_fisheye_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_SizeR_double_double(k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, tvec: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, flags: i32, new_image_size: *const core::Size, balance: f64, fov_scale: f64) -> Result_void;
		pub fn cv_fisheye_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, knew: *const c_void, new_size: *const core::Size) -> Result_void;
		pub fn cv_fisheye_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, r: *const c_void, p: *const c_void) -> Result_void;
		pub fn cv_getDefaultNewCameraMatrix_const__InputArrayR_Size_bool(camera_matrix: *const c_void, imgsize: *const core::Size, center_principal_point: bool) -> Result<*mut c_void>;
		pub fn cv_getOptimalNewCameraMatrix_const__InputArrayR_const__InputArrayR_Size_double_Size_RectX_bool(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, alpha: f64, new_img_size: *const core::Size, valid_pix_roi: *mut core::Rect, center_principal_point: bool) -> Result<*mut c_void>;
		pub fn cv_getValidDisparityROI_Rect_Rect_int_int_int(roi1: *const core::Rect, roi2: *const core::Rect, min_disparity: i32, number_of_disparities: i32, block_size: i32) -> Result<core::Rect>;
		pub fn cv_initCameraMatrix2D_const__InputArrayR_const__InputArrayR_Size_double(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, aspect_ratio: f64) -> Result<*mut c_void>;
		pub fn cv_initInverseRectificationMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR(camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, new_camera_matrix: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void) -> Result_void;
		pub fn cv_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_int_const__OutputArrayR_const__OutputArrayR(camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, new_camera_matrix: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void) -> Result_void;
		pub fn cv_initWideAngleProjMap_const__InputArrayR_const__InputArrayR_Size_int_int_const__OutputArrayR_const__OutputArrayR_UndistortTypes_double(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, dest_image_width: i32, m1type: i32, map1: *const c_void, map2: *const c_void, proj_type: crate::calib3d::UndistortTypes, alpha: f64) -> Result<f32>;
		pub fn cv_matMulDeriv_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(a: *const c_void, b: *const c_void, d_a_bd_a: *const c_void, d_a_bd_b: *const c_void) -> Result_void;
		pub fn cv_projectPoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double(object_points: *const c_void, rvec: *const c_void, tvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, image_points: *const c_void, jacobian: *const c_void, aspect_ratio: f64) -> Result_void;
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_double_double_const__InputOutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, e: *const c_void, r: *const c_void, t: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void) -> Result<i32>;
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, mask: *const c_void) -> Result<i32>;
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_const__InputOutputArrayR_const__OutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, distance_thresh: f64, mask: *const c_void, triangulated_points: *const c_void) -> Result<i32>;
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_Point2d_const__InputOutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, r: *const c_void, t: *const c_void, focal: f64, pp: *const core::Point2d, mask: *const c_void) -> Result<i32>;
		pub fn cv_rectify3Collinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_double_Size_RectX_RectX_int(camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, camera_matrix3: *const c_void, dist_coeffs3: *const c_void, imgpt1: *const c_void, imgpt3: *const c_void, image_size: *const core::Size, r12: *const c_void, t12: *const c_void, r13: *const c_void, t13: *const c_void, r1: *const c_void, r2: *const c_void, r3: *const c_void, p1: *const c_void, p2: *const c_void, p3: *const c_void, q: *const c_void, alpha: f64, new_img_size: *const core::Size, roi1: *mut core::Rect, roi2: *mut core::Rect, flags: i32) -> Result<f32>;
		pub fn cv_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR_bool_int(disparity: *const c_void, _3d_image: *const c_void, q: *const c_void, handle_missing_values: bool, ddepth: i32) -> Result_void;
		pub fn cv_sampsonDistance_const__InputArrayR_const__InputArrayR_const__InputArrayR(pt1: *const c_void, pt2: *const c_void, f: *const c_void) -> Result<f64>;
		pub fn cv_solveP3P_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32) -> Result<i32>;
		pub fn cv_solvePnPGeneric_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_SolvePnPMethod_const__InputArrayR_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, use_extrinsic_guess: bool, flags: crate::calib3d::SolvePnPMethod, rvec: *const c_void, tvec: *const c_void, reprojection_error: *const c_void) -> Result<i32>;
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int_float_double_const__OutputArrayR_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, confidence: f64, inliers: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const_UsacParamsR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, inliers: *const c_void, params: *const crate::calib3d::UsacParams) -> Result<bool>;
		pub fn cv_solvePnPRefineLM_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_TermCriteria(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, criteria: *const core::TermCriteria) -> Result_void;
		pub fn cv_solvePnPRefineVVS_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_TermCriteria_double(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, criteria: *const core::TermCriteria, vv_slambda: f64) -> Result_void;
		pub fn cv_solvePnP_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32) -> Result<bool>;
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_stereoRectifyUncalibrated_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__OutputArrayR_const__OutputArrayR_double(points1: *const c_void, points2: *const c_void, f: *const c_void, img_size: *const core::Size, h1: *const c_void, h2: *const c_void, threshold: f64) -> Result<bool>;
		pub fn cv_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_double_Size_RectX_RectX(camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, flags: i32, alpha: f64, new_image_size: *const core::Size, valid_pix_roi1: *mut core::Rect, valid_pix_roi2: *mut core::Rect) -> Result_void;
		pub fn cv_triangulatePoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(proj_matr1: *const c_void, proj_matr2: *const c_void, proj_points1: *const c_void, proj_points2: *const c_void, points4_d: *const c_void) -> Result_void;
		pub fn cv_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, p: *const c_void) -> Result_void;
		pub fn cv_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_TermCriteria(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, p: *const c_void, criteria: *const core::TermCriteria) -> Result_void;
		pub fn cv_undistort_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, new_camera_matrix: *const c_void) -> Result_void;
		pub fn cv_validateDisparity_const__InputOutputArrayR_const__InputArrayR_int_int_int(disparity: *const c_void, cost: *const c_void, min_disparity: i32, number_of_disparities: i32, disp12_max_disp: i32) -> Result_void;
		pub fn cv_CirclesGridFinderParameters_CirclesGridFinderParameters() -> Result<crate::calib3d::CirclesGridFinderParameters>;
		pub fn cv_LMSolver_run_const_const__InputOutputArrayR(instance: *const c_void, param: *const c_void) -> Result<i32>;
		pub fn cv_LMSolver_setMaxIters_int(instance: *mut c_void, max_iters: i32) -> Result_void;
		pub fn cv_LMSolver_getMaxIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_LMSolver_create_const_Ptr_Callback_R_int(cb: *const c_void, max_iters: i32) -> Result<*mut c_void>;
		pub fn cv_LMSolver_create_const_Ptr_Callback_R_int_double(cb: *const c_void, max_iters: i32, eps: f64) -> Result<*mut c_void>;
		pub fn cv_LMSolver_Callback_compute_const_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, param: *const c_void, err: *const c_void, j: *const c_void) -> Result<bool>;
		pub fn cv_StereoBM_getPreFilterType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setPreFilterType_int(instance: *mut c_void, pre_filter_type: i32) -> Result_void;
		pub fn cv_StereoBM_getPreFilterSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setPreFilterSize_int(instance: *mut c_void, pre_filter_size: i32) -> Result_void;
		pub fn cv_StereoBM_getPreFilterCap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setPreFilterCap_int(instance: *mut c_void, pre_filter_cap: i32) -> Result_void;
		pub fn cv_StereoBM_getTextureThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setTextureThreshold_int(instance: *mut c_void, texture_threshold: i32) -> Result_void;
		pub fn cv_StereoBM_getUniquenessRatio_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setUniquenessRatio_int(instance: *mut c_void, uniqueness_ratio: i32) -> Result_void;
		pub fn cv_StereoBM_getSmallerBlockSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoBM_setSmallerBlockSize_int(instance: *mut c_void, block_size: i32) -> Result_void;
		pub fn cv_StereoBM_getROI1_const(instance: *const c_void) -> Result<core::Rect>;
		pub fn cv_StereoBM_setROI1_Rect(instance: *mut c_void, roi1: *const core::Rect) -> Result_void;
		pub fn cv_StereoBM_getROI2_const(instance: *const c_void) -> Result<core::Rect>;
		pub fn cv_StereoBM_setROI2_Rect(instance: *mut c_void, roi2: *const core::Rect) -> Result_void;
		pub fn cv_StereoBM_create_int_int(num_disparities: i32, block_size: i32) -> Result<*mut c_void>;
		pub fn cv_StereoMatcher_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void) -> Result_void;
		pub fn cv_StereoMatcher_getMinDisparity_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setMinDisparity_int(instance: *mut c_void, min_disparity: i32) -> Result_void;
		pub fn cv_StereoMatcher_getNumDisparities_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setNumDisparities_int(instance: *mut c_void, num_disparities: i32) -> Result_void;
		pub fn cv_StereoMatcher_getBlockSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setBlockSize_int(instance: *mut c_void, block_size: i32) -> Result_void;
		pub fn cv_StereoMatcher_getSpeckleWindowSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setSpeckleWindowSize_int(instance: *mut c_void, speckle_window_size: i32) -> Result_void;
		pub fn cv_StereoMatcher_getSpeckleRange_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setSpeckleRange_int(instance: *mut c_void, speckle_range: i32) -> Result_void;
		pub fn cv_StereoMatcher_getDisp12MaxDiff_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoMatcher_setDisp12MaxDiff_int(instance: *mut c_void, disp12_max_diff: i32) -> Result_void;
		pub fn cv_StereoSGBM_getPreFilterCap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoSGBM_setPreFilterCap_int(instance: *mut c_void, pre_filter_cap: i32) -> Result_void;
		pub fn cv_StereoSGBM_getUniquenessRatio_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoSGBM_setUniquenessRatio_int(instance: *mut c_void, uniqueness_ratio: i32) -> Result_void;
		pub fn cv_StereoSGBM_getP1_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoSGBM_setP1_int(instance: *mut c_void, p1: i32) -> Result_void;
		pub fn cv_StereoSGBM_getP2_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoSGBM_setP2_int(instance: *mut c_void, p2: i32) -> Result_void;
		pub fn cv_StereoSGBM_getMode_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_StereoSGBM_setMode_int(instance: *mut c_void, mode: i32) -> Result_void;
		pub fn cv_StereoSGBM_create_int_int_int_int_int_int_int_int_int_int_int(min_disparity: i32, num_disparities: i32, block_size: i32, p1: i32, p2: i32, disp12_max_diff: i32, pre_filter_cap: i32, uniqueness_ratio: i32, speckle_window_size: i32, speckle_range: i32, mode: i32) -> Result<*mut c_void>;
		pub fn cv_UsacParams_UsacParams() -> Result<crate::calib3d::UsacParams>;
	}
}
#[cfg(ocvrs_has_module_calib3d)]
pub use calib3d_sys::*;

#[cfg(ocvrs_has_module_ccalib)]
mod ccalib_sys {
	use super::*;

	extern "C" {
		pub fn cv_omnidir_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, size: *const core::Size, k: *const c_void, xi: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, idx: *const c_void) -> Result<f64>;
		pub fn cv_omnidir_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR_int(k: *const c_void, d: *const c_void, xi: *const c_void, r: *const c_void, p: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void, flags: i32) -> Result_void;
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, xi: f64, d: *const c_void, jacobian: *const c_void) -> Result_void;
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, xi: f64, d: *const c_void, jacobian: *const c_void) -> Result_void;
		pub fn cv_omnidir_stereoCalibrate_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const_SizeR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, image_size1: *const core::Size, image_size2: *const core::Size, k1: *const c_void, xi1: *const c_void, d1: *const c_void, k2: *const c_void, xi2: *const c_void, d2: *const c_void, rvec: *const c_void, tvec: *const c_void, rvecs_l: *const c_void, tvecs_l: *const c_void, flags: i32, criteria: *const core::TermCriteria, idx: *const c_void) -> Result<f64>;
		pub fn cv_omnidir_stereoReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_int_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR_int(image1: *const c_void, image2: *const c_void, k1: *const c_void, d1: *const c_void, xi1: *const c_void, k2: *const c_void, d2: *const c_void, xi2: *const c_void, r: *const c_void, t: *const c_void, flag: i32, num_disparities: i32, sad_window_size: i32, disparity: *const c_void, image1_rec: *const c_void, image2_rec: *const c_void, new_size: *const core::Size, knew: *const c_void, point_cloud: *const c_void, point_type: i32) -> Result_void;
		pub fn cv_omnidir_stereoRectify_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(r: *const c_void, t: *const c_void, r1: *const c_void, r2: *const c_void) -> Result_void;
		pub fn cv_omnidir_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_const_SizeR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, xi: *const c_void, flags: i32, knew: *const c_void, new_size: *const core::Size, r: *const c_void) -> Result_void;
		pub fn cv_omnidir_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, xi: *const c_void, r: *const c_void) -> Result_void;
		pub fn cv_ccalib_CustomPattern_CustomPattern() -> Result<*mut c_void>;
		pub fn cv_ccalib_CustomPattern_create_const__InputArrayR_const_Size2f_const__OutputArrayR(instance: *mut c_void, pattern: *const c_void, board_size: *const core::Size2f, output: *const c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_findPattern_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const_double_const_double_const_bool_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, matched_features: *const c_void, pattern_points: *const c_void, ratio: f64, proj_error: f64, refine_position: bool, out: *const c_void, h: *const c_void, pattern_corners: *const c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_isInitialized(instance: *mut c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_getPatternPoints_vector_KeyPoint_R(instance: *mut c_void, original_points: *mut c_void) -> Result_void;
		pub fn cv_ccalib_CustomPattern_getPixelSize(instance: *mut c_void) -> Result<f64>;
		pub fn cv_ccalib_CustomPattern_setFeatureDetector_Ptr_Feature2D_(instance: *mut c_void, feature_detector: *mut c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_setDescriptorExtractor_Ptr_Feature2D_(instance: *mut c_void, extractor: *mut c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_setDescriptorMatcher_Ptr_DescriptorMatcher_(instance: *mut c_void, matcher: *mut c_void) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_getFeatureDetector(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ccalib_CustomPattern_getDescriptorExtractor(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ccalib_CustomPattern_getDescriptorMatcher(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ccalib_CustomPattern_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria) -> Result<f64>;
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int_float_int_const__OutputArrayR_int(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, min_inliers_count: i32, inliers: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int_float_int_const__OutputArrayR_int(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, min_inliers_count: i32, inliers: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_ccalib_CustomPattern_drawOrientation_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_int(instance: *mut c_void, image: *const c_void, tvec: *const c_void, rvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, axis_length: f64, axis_width: i32) -> Result_void;
		pub fn cv_multicalib_MultiCameraCalibration_MultiCameraCalibration_int_int_const_stringR_float_float_int_int_int_int_TermCriteria_Ptr_Feature2D__Ptr_Feature2D__Ptr_DescriptorMatcher_(camera_type: i32, n_cameras: i32, file_name: *const c_char, pattern_width: f32, pattern_height: f32, verbose: i32, show_extration: i32, n_mini_matches: i32, flags: i32, criteria: *const core::TermCriteria, detector: *mut c_void, descriptor: *mut c_void, matcher: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_multicalib_MultiCameraCalibration_loadImages(instance: *mut c_void) -> Result_void;
		pub fn cv_multicalib_MultiCameraCalibration_initialize(instance: *mut c_void) -> Result_void;
		pub fn cv_multicalib_MultiCameraCalibration_optimizeExtrinsics(instance: *mut c_void) -> Result<f64>;
		pub fn cv_multicalib_MultiCameraCalibration_run(instance: *mut c_void) -> Result<f64>;
		pub fn cv_multicalib_MultiCameraCalibration_writeParameters_const_stringR(instance: *mut c_void, filename: *const c_char) -> Result_void;
		pub fn cv_multicalib_MultiCameraCalibration_edge_getPropCameraVertex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_setPropCameraVertex_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_getPropPhotoVertex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_setPropPhotoVertex_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_getPropPhotoIndex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_setPropPhotoIndex_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_getPropTransform_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_multicalib_MultiCameraCalibration_edge_setPropTransform_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_multicalib_MultiCameraCalibration_edge_edge_int_int_int_Mat(cv: i32, pv: i32, pi: i32, trans: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_getPropPose_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_setPropPose_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_getPropTimestamp_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_setPropTimestamp_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_vertex_Mat_int(po: *mut c_void, ts: i32) -> Result<*mut c_void>;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_vertex() -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternCornerFinder_RandomPatternCornerFinder_float_float_int_int_int_int_Ptr_Feature2D__Ptr_Feature2D__Ptr_DescriptorMatcher_(pattern_width: f32, pattern_height: f32, nmini_match: i32, depth: i32, verbose: i32, show_extraction: i32, detector: *mut c_void, descriptor: *mut c_void, matcher: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternCornerFinder_loadPattern_const_MatR(instance: *mut c_void, pattern_image: *const c_void) -> Result_void;
		pub fn cv_randpattern_RandomPatternCornerFinder_loadPattern_const_MatR_const_vector_KeyPoint_R_const_MatR(instance: *mut c_void, pattern_image: *const c_void, pattern_key_points: *const c_void, pattern_descriptors: *const c_void) -> Result_void;
		pub fn cv_randpattern_RandomPatternCornerFinder_computeObjectImagePoints_vector_Mat_(instance: *mut c_void, input_images: *mut c_void) -> Result_void;
		pub fn cv_randpattern_RandomPatternCornerFinder_computeObjectImagePointsForSingle_Mat(instance: *mut c_void, input_image: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternCornerFinder_getObjectPoints(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternCornerFinder_getImagePoints(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternGenerator_RandomPatternGenerator_int_int(image_width: i32, image_height: i32) -> Result<*mut c_void>;
		pub fn cv_randpattern_RandomPatternGenerator_generatePattern(instance: *mut c_void) -> Result_void;
		pub fn cv_randpattern_RandomPatternGenerator_getPattern(instance: *mut c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_ccalib)]
pub use ccalib_sys::*;

#[cfg(ocvrs_has_module_core)]
mod core_sys {
	use super::*;

	extern "C" {
		pub fn cv_Cholesky_doubleX_size_t_int_doubleX_size_t_int(a: *mut f64, astep: size_t, m: i32, b: *mut f64, bstep: size_t, n: i32) -> Result<bool>;
		pub fn cv_Cholesky_floatX_size_t_int_floatX_size_t_int(a: *mut f32, astep: size_t, m: i32, b: *mut f32, bstep: size_t, n: i32) -> Result<bool>;
		pub fn cv_LUT_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, lut: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_LU_doubleX_size_t_int_doubleX_size_t_int(a: *mut f64, astep: size_t, m: i32, b: *mut f64, bstep: size_t, n: i32) -> Result<i32>;
		pub fn cv_LU_floatX_size_t_int_floatX_size_t_int(a: *mut f32, astep: size_t, m: i32, b: *mut f32, bstep: size_t, n: i32) -> Result<i32>;
		pub fn cv_Mahalanobis_const__InputArrayR_const__InputArrayR_const__InputArrayR(v1: *const c_void, v2: *const c_void, icovar: *const c_void) -> Result<f64>;
		pub fn cv_PCABackProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_double(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, eigenvalues: *const c_void, retained_variance: f64) -> Result_void;
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, eigenvalues: *const c_void, max_components: i32) -> Result_void;
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_double(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, retained_variance: f64) -> Result_void;
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_int(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, max_components: i32) -> Result_void;
		pub fn cv_PCAProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_PSNR_const__InputArrayR_const__InputArrayR_double(src1: *const c_void, src2: *const c_void, r: f64) -> Result<f64>;
		pub fn cv_SVBackSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(w: *const c_void, u: *const c_void, vt: *const c_void, rhs: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_SVDecomp_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, flags: i32) -> Result_void;
		pub fn cv_abs_const_MatExprR(e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_abs_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, dtype: i32) -> Result_void;
		pub fn cv_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32) -> Result_void;
		pub fn cv_batchDistance_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__OutputArrayR_int_int_const__InputArrayR_int_bool(src1: *const c_void, src2: *const c_void, dist: *const c_void, dtype: i32, nidx: *const c_void, norm_type: i32, k: i32, mask: *const c_void, update: i32, crosscheck: bool) -> Result_void;
		pub fn cv_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_borderInterpolate_int_int_int(p: i32, len: i32, border_type: i32) -> Result<i32>;
		pub fn cv_calcCovarMatrix_const__InputArrayR_const__OutputArrayR_const__InputOutputArrayR_int_int(samples: *const c_void, covar: *const c_void, mean: *const c_void, flags: i32, ctype: i32) -> Result_void;
		pub fn cv_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, angle_in_degrees: bool) -> Result_void;
		pub fn cv_checkHardwareSupport_int(feature: i32) -> Result<bool>;
		pub fn cv_checkRange_const__InputArrayR_bool_PointX_double_double(a: *const c_void, quiet: bool, pos: *mut core::Point, min_val: f64, max_val: f64) -> Result<bool>;
		pub fn cv_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, cmpop: i32) -> Result_void;
		pub fn cv_completeSymm_const__InputOutputArrayR_bool(m: *const c_void, lower_to_upper: bool) -> Result_void;
		pub fn cv_convertFp16_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_convertScaleAbs_const__InputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64) -> Result_void;
		pub fn cv_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, value: *const core::Scalar) -> Result_void;
		pub fn cv_copyTo_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_countNonZero_const__InputArrayR(src: *const c_void) -> Result<i32>;
		pub fn cv_cubeRoot_float(val: f32) -> Result<f32>;
		pub fn cv_cuda_createContinuous_int_int_int_const__OutputArrayR(rows: i32, cols: i32, typ: i32, arr: *const c_void) -> Result_void;
		pub fn cv_cuda_deviceSupports_FeatureSet(feature_set: core::FeatureSet) -> Result<bool>;
		pub fn cv_cuda_ensureSizeIsEnough_int_int_int_const__OutputArrayR(rows: i32, cols: i32, typ: i32, arr: *const c_void) -> Result_void;
		pub fn cv_cuda_getCudaEnabledDeviceCount() -> Result<i32>;
		pub fn cv_cuda_getDevice() -> Result<i32>;
		pub fn cv_cuda_printCudaDeviceInfo_int(device: i32) -> Result_void;
		pub fn cv_cuda_printShortCudaDeviceInfo_int(device: i32) -> Result_void;
		pub fn cv_cuda_registerPageLocked_MatR(m: *mut c_void) -> Result_void;
		pub fn cv_cuda_resetDevice() -> Result_void;
		pub fn cv_cuda_setBufferPoolConfig_int_size_t_int(device_id: i32, stack_size: size_t, stack_count: i32) -> Result_void;
		pub fn cv_cuda_setBufferPoolUsage_bool(on: bool) -> Result_void;
		pub fn cv_cuda_setDevice_int(device: i32) -> Result_void;
		pub fn cv_cuda_setGlDevice_int(device: i32) -> Result_void;
		pub fn cv_cuda_unregisterPageLocked_MatR(m: *mut c_void) -> Result_void;
		pub fn cv_dct_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32) -> Result_void;
		pub fn cv_depthToString_int(depth: i32) -> Result<*mut c_void>;
		pub fn cv_detail_check_failed_MatChannels_const_int_const_CheckContextR(v: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_MatChannels_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_MatDepth_const_int_const_CheckContextR(v: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_MatDepth_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_MatType_const_int_const_CheckContextR(v: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_MatType_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_Size__int__const_CheckContextR(v: *const core::Size_<i32>, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_Size__int__const_Size__int__const_CheckContextR(v1: *const core::Size_<i32>, v2: *const core::Size_<i32>, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_double_const_CheckContextR(v: f64, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_double_const_double_const_CheckContextR(v1: f64, v2: f64, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_float_const_CheckContextR(v: f32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_float_const_float_const_CheckContextR(v1: f32, v2: f32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_int_const_CheckContextR(v: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_size_t_const_CheckContextR(v: size_t, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_size_t_const_size_t_const_CheckContextR(v1: size_t, v2: size_t, ctx: *const c_void) -> Result_void;
		pub fn cv_detail_check_failed_auto_const_stringR_const_CheckContextR(v1: *const c_char, ctx: *const c_void) -> Result_void;
		pub fn cv_determinant_const__InputArrayR(mtx: *const c_void) -> Result<f64>;
		pub fn cv_dft_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, flags: i32, nonzero_rows: i32) -> Result_void;
		pub fn cv_directx_getTypeFromD3DFORMAT_const_int(i_d3_dformat: i32) -> Result<i32>;
		pub fn cv_directx_getTypeFromDXGI_FORMAT_const_int(i_dxgi_format: i32) -> Result<i32>;
		pub fn cv_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32) -> Result_void;
		pub fn cv_divide_double_const__InputArrayR_const__OutputArrayR_int(scale: f64, src2: *const c_void, dst: *const c_void, dtype: i32) -> Result_void;
		pub fn cv_eigenNonSymmetric_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, eigenvalues: *const c_void, eigenvectors: *const c_void) -> Result_void;
		pub fn cv_eigen_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, eigenvalues: *const c_void, eigenvectors: *const c_void) -> Result<bool>;
		pub fn cv_error_const_ExceptionR(exc: *const c_void) -> Result_void;
		pub fn cv_error_int_const_StringR_const_charX_const_charX_int(_code: i32, _err: *const c_char, _func: *const c_char, _file: *const c_char, _line: i32) -> Result_void;
		pub fn cv_exp_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_extractChannel_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, coi: i32) -> Result_void;
		pub fn cv_fastAtan2_float_float(y: f32, x: f32) -> Result<f32>;
		pub fn cv_findNonZero_const__InputArrayR_const__OutputArrayR(src: *const c_void, idx: *const c_void) -> Result_void;
		pub fn cv_flip_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flip_code: i32) -> Result_void;
		pub fn cv_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, flags: i32) -> Result_void;
		pub fn cv_getBuildInformation() -> Result<*mut c_void>;
		pub fn cv_getCPUFeaturesLine() -> Result<*mut c_void>;
		pub fn cv_getCPUTickCount() -> Result<i64>;
		pub fn cv_getElemSize_int(typ: i32) -> Result<size_t>;
		pub fn cv_getHardwareFeatureName_int(feature: i32) -> Result<*mut c_void>;
		pub fn cv_getLogLevel() -> Result<i32>;
		pub fn cv_getNumThreads() -> Result<i32>;
		pub fn cv_getNumberOfCPUs() -> Result<i32>;
		pub fn cv_getOptimalDFTSize_int(vecsize: i32) -> Result<i32>;
		pub fn cv_getThreadNum() -> Result<i32>;
		pub fn cv_getTickCount() -> Result<i64>;
		pub fn cv_getTickFrequency() -> Result<f64>;
		pub fn cv_getVersionMajor() -> i32;
		pub fn cv_getVersionMinor() -> i32;
		pub fn cv_getVersionRevision() -> i32;
		pub fn cv_getVersionString() -> Result<*mut c_void>;
		pub fn cv_glob_String_vector_String_R_bool(pattern: *mut c_char, result: *mut c_void, recursive: bool) -> Result_void;
		pub fn cv_haveOpenVX() -> Result<bool>;
		pub fn cv_hconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_hconcat_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_idct_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32) -> Result_void;
		pub fn cv_idft_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, flags: i32, nonzero_rows: i32) -> Result_void;
		pub fn cv_inRange_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, lowerb: *const c_void, upperb: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_insertChannel_const__InputArrayR_const__InputOutputArrayR_int(src: *const c_void, dst: *const c_void, coi: i32) -> Result_void;
		pub fn cv_instr_getFlags() -> Result<core::FLAGS>;
		pub fn cv_instr_resetTrace() -> Result_void;
		pub fn cv_instr_setFlags_FLAGS(mode_flags: core::FLAGS) -> Result_void;
		pub fn cv_instr_setUseInstrumentation_bool(flag: bool) -> Result_void;
		pub fn cv_instr_useInstrumentation() -> Result<bool>;
		pub fn cv_invert_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32) -> Result<f64>;
		pub fn cv_ipp_getIppErrorLocation() -> Result<*mut c_void>;
		pub fn cv_ipp_getIppFeatures() -> Result<u64>;
		pub fn cv_ipp_getIppStatus() -> Result<i32>;
		pub fn cv_ipp_getIppVersion() -> Result<*mut c_void>;
		pub fn cv_ipp_setIppStatus_int_const_charX_const_charX_int(status: i32, funcname: *const c_char, filename: *const c_char, line: i32) -> Result_void;
		pub fn cv_ipp_setUseIPP_NotExact_bool(flag: bool) -> Result_void;
		pub fn cv_ipp_setUseIPP_bool(flag: bool) -> Result_void;
		pub fn cv_ipp_useIPP() -> Result<bool>;
		pub fn cv_ipp_useIPP_NotExact() -> Result<bool>;
		pub fn cv_kmeans_const__InputArrayR_int_const__InputOutputArrayR_TermCriteria_int_int_const__OutputArrayR(data: *const c_void, k: i32, best_labels: *const c_void, criteria: *const core::TermCriteria, attempts: i32, flags: i32, centers: *const c_void) -> Result<f64>;
		pub fn cv_log_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void) -> Result_void;
		pub fn cv_max_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_max_const_MatR_const_MatR_MatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_max_const_MatR_double(a: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_max_const_UMatR_const_UMatR_UMatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_max_double_const_MatR(s: f64, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_meanStdDev_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, mean: *const c_void, stddev: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_mean_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void) -> Result<core::Scalar>;
		pub fn cv_merge_const_MatX_size_t_const__OutputArrayR(mv: *const c_void, count: size_t, dst: *const c_void) -> Result_void;
		pub fn cv_merge_const__InputArrayR_const__OutputArrayR(mv: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_minMaxIdx_const__InputArrayR_doubleX_doubleX_intX_intX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_idx: *mut i32, max_idx: *mut i32, mask: *const c_void) -> Result_void;
		pub fn cv_minMaxLoc_const_SparseMatR_doubleX_doubleX_intX_intX(a: *const c_void, min_val: *mut f64, max_val: *mut f64, min_idx: *mut i32, max_idx: *mut i32) -> Result_void;
		pub fn cv_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_loc: *mut core::Point, max_loc: *mut core::Point, mask: *const c_void) -> Result_void;
		pub fn cv_min_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_min_const_MatR_const_MatR_MatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_min_const_MatR_double(a: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_min_const_UMatR_const_UMatR_UMatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_min_double_const_MatR(s: f64, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_intX_size_t(src: *const c_void, dst: *const c_void, from_to: *const i32, npairs: size_t) -> Result_void;
		pub fn cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_vector_int_R(src: *const c_void, dst: *const c_void, from_to: *const c_void) -> Result_void;
		pub fn cv_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool(a: *const c_void, b: *const c_void, c: *const c_void, flags: i32, conj_b: bool) -> Result_void;
		pub fn cv_mulTransposed_const__InputArrayR_const__OutputArrayR_bool_const__InputArrayR_double_int(src: *const c_void, dst: *const c_void, a_ta: bool, delta: *const c_void, scale: f64, dtype: i32) -> Result_void;
		pub fn cv_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32) -> Result_void;
		pub fn cv_noArray() -> *mut c_void;
		pub fn cv_norm_const_SparseMatR_int(src: *const c_void, norm_type: i32) -> Result<f64>;
		pub fn cv_norm_const__InputArrayR_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, src2: *const c_void, norm_type: i32, mask: *const c_void) -> Result<f64>;
		pub fn cv_norm_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, norm_type: i32, mask: *const c_void) -> Result<f64>;
		pub fn cv_normalize_const_SparseMatR_SparseMatR_double_int(src: *const c_void, dst: *mut c_void, alpha: f64, norm_type: i32) -> Result_void;
		pub fn cv_normalize_const__InputArrayR_const__InputOutputArrayR_double_double_int_int_const__InputArrayR(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, norm_type: i32, dtype: i32, mask: *const c_void) -> Result_void;
		pub fn cv_ocl_attachContext_const_StringR_voidX_voidX_voidX(platform_name: *const c_char, platform_id: *mut c_void, context: *mut c_void, device_id: *mut c_void) -> Result_void;
		pub fn cv_ocl_buildOptionsAddMatrixDescription_StringR_const_StringR_const__InputArrayR(build_options: *mut *mut c_void, name: *const c_char, _m: *const c_void) -> Result_void;
		pub fn cv_ocl_checkOptimalVectorWidth_const_intX_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(vector_widths: *const i32, src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void, strat: core::OclVectorStrategy) -> Result<i32>;
		pub fn cv_ocl_convertFromBuffer_voidX_size_t_int_int_int_UMatR(cl_mem_buffer: *mut c_void, step: size_t, rows: i32, cols: i32, typ: i32, dst: *mut c_void) -> Result_void;
		pub fn cv_ocl_convertFromImage_voidX_UMatR(cl_mem_image: *mut c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_ocl_convertTypeStr_int_int_int_charX(sdepth: i32, ddepth: i32, cn: i32, buf: *mut *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_finish() -> Result_void;
		pub fn cv_ocl_getOpenCLErrorString_int(error_code: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_getPlatfomsInfo_vector_PlatformInfo_R(platform_info: *mut c_void) -> Result_void;
		pub fn cv_ocl_haveAmdBlas() -> Result<bool>;
		pub fn cv_ocl_haveAmdFft() -> Result<bool>;
		pub fn cv_ocl_haveOpenCL() -> Result<bool>;
		pub fn cv_ocl_haveSVM() -> Result<bool>;
		pub fn cv_ocl_kernelToStr_const__InputArrayR_int_const_charX(_kernel: *const c_void, ddepth: i32, name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_memopTypeToStr_int(t: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_predictOptimalVectorWidthMax_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void) -> Result<i32>;
		pub fn cv_ocl_predictOptimalVectorWidth_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void, strat: core::OclVectorStrategy) -> Result<i32>;
		pub fn cv_ocl_setUseOpenCL_bool(flag: bool) -> Result_void;
		pub fn cv_ocl_typeToStr_int(t: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_useOpenCL() -> Result<bool>;
		pub fn cv_ocl_vecopTypeToStr_int(t: i32) -> Result<*mut c_void>;
		pub fn cv_ogl_convertFromGLTexture2D_const_Texture2DR_const__OutputArrayR(texture: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ogl_convertToGLTexture2D_const__InputArrayR_Texture2DR(src: *const c_void, texture: *mut c_void) -> Result_void;
		pub fn cv_ogl_mapGLBuffer_const_BufferR_AccessFlag(buffer: *const c_void, access_flags: core::AccessFlag) -> Result<*mut c_void>;
		pub fn cv_ogl_ocl_initializeContextFromGL() -> Result<*mut c_void>;
		pub fn cv_ogl_render_const_ArraysR_const__InputArrayR_int_Scalar(arr: *const c_void, indices: *const c_void, mode: i32, color: *const core::Scalar) -> Result_void;
		pub fn cv_ogl_render_const_ArraysR_int_Scalar(arr: *const c_void, mode: i32, color: *const core::Scalar) -> Result_void;
		pub fn cv_ogl_render_const_Texture2DR_Rect__double__Rect__double_(tex: *const c_void, wnd_rect: *const core::Rect_<f64>, tex_rect: *const core::Rect_<f64>) -> Result_void;
		pub fn cv_ogl_unmapGLBuffer_UMatR(u: *mut c_void) -> Result_void;
		pub fn cv_operatorA_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_MatExprR_const_ScalarR(e: *const c_void, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_ScalarR_const_MatExprR(s: *const core::Scalar, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorA_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatExprR_double(e: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_const_MatR_double(a: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_operatorD_double_const_MatExprR(s: f64, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorD_double_const_MatR(s: f64, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorEQ_const_FileNodeIteratorR_const_FileNodeIteratorR(it1: *const c_void, it2: *const c_void) -> Result<bool>;
		pub fn cv_operatorEQ_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorEQ_const_MatR_double(a: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_operatorEQ_double_const_MatR(s: f64, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatExprR(e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatExprR_const_ScalarR(e: *const c_void, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_ScalarR_const_MatExprR(s: *const core::Scalar, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorS_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatExprR_double(e: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatR_const_MatR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_const_MatR_double(a: *const c_void, s: f64) -> Result<*mut c_void>;
		pub fn cv_operatorX_double_const_MatExprR(s: f64, e: *const c_void) -> Result<*mut c_void>;
		pub fn cv_operatorX_double_const_MatR(s: f64, a: *const c_void) -> Result<*mut c_void>;
		pub fn cv_parallel_for__const_RangeR_const_ParallelLoopBodyR_double(range: *const c_void, body: *const c_void, nstripes: f64) -> Result_void;
		pub fn cv_patchNaNs_const__InputOutputArrayR_double(a: *const c_void, val: f64) -> Result_void;
		pub fn cv_perspectiveTransform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, m: *const c_void) -> Result_void;
		pub fn cv_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(x: *const c_void, y: *const c_void, angle: *const c_void, angle_in_degrees: bool) -> Result_void;
		pub fn cv_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, angle_in_degrees: bool) -> Result_void;
		pub fn cv_pow_const__InputArrayR_double_const__OutputArrayR(src: *const c_void, power: f64, dst: *const c_void) -> Result_void;
		pub fn cv_randShuffle_const__InputOutputArrayR_double_RNGX(dst: *const c_void, iter_factor: f64, rng: *mut c_void) -> Result_void;
		pub fn cv_randn_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(dst: *const c_void, mean: *const c_void, stddev: *const c_void) -> Result_void;
		pub fn cv_randu_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(dst: *const c_void, low: *const c_void, high: *const c_void) -> Result_void;
		pub fn cv_read_const_FileNodeR_DMatchR_const_DMatchR(node: *const c_void, value: *mut core::DMatch, default_value: *const core::DMatch) -> Result_void;
		pub fn cv_read_const_FileNodeR_KeyPointR_const_KeyPointR(node: *const c_void, value: *mut core::KeyPoint, default_value: *const core::KeyPoint) -> Result_void;
		pub fn cv_read_const_FileNodeR_MatR_const_MatR(node: *const c_void, mat: *mut c_void, default_mat: *const c_void) -> Result_void;
		pub fn cv_read_const_FileNodeR_SparseMatR_const_SparseMatR(node: *const c_void, mat: *mut c_void, default_mat: *const c_void) -> Result_void;
		pub fn cv_read_const_FileNodeR_doubleR_double(node: *const c_void, value: *mut f64, default_value: f64) -> Result_void;
		pub fn cv_read_const_FileNodeR_floatR_float(node: *const c_void, value: *mut f32, default_value: f32) -> Result_void;
		pub fn cv_read_const_FileNodeR_intR_int(node: *const c_void, value: *mut i32, default_value: i32) -> Result_void;
		pub fn cv_read_const_FileNodeR_stringR_const_stringR(node: *const c_void, value: *mut *mut c_void, default_value: *const c_char) -> Result_void;
		pub fn cv_read_const_FileNodeR_vector_DMatch_R(node: *const c_void, matches: *mut c_void) -> Result_void;
		pub fn cv_read_const_FileNodeR_vector_KeyPoint_R(node: *const c_void, keypoints: *mut c_void) -> Result_void;
		pub fn cv_reduce_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, dim: i32, rtype: i32, dtype: i32) -> Result_void;
		pub fn cv_repeat_const_MatR_int_int(src: *const c_void, ny: i32, nx: i32) -> Result<*mut c_void>;
		pub fn cv_repeat_const__InputArrayR_int_int_const__OutputArrayR(src: *const c_void, ny: i32, nx: i32, dst: *const c_void) -> Result_void;
		pub fn cv_rotate_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, rotate_code: i32) -> Result_void;
		pub fn cv_samples_addSamplesDataSearchPath_const_StringR(path: *const c_char) -> Result_void;
		pub fn cv_samples_addSamplesDataSearchSubDirectory_const_StringR(subdir: *const c_char) -> Result_void;
		pub fn cv_samples_findFileOrKeep_const_StringR_bool(relative_path: *const c_char, silent_mode: bool) -> Result<*mut c_void>;
		pub fn cv_samples_findFile_const_StringR_bool_bool(relative_path: *const c_char, required: bool, silent_mode: bool) -> Result<*mut c_void>;
		pub fn cv_scaleAdd_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(src1: *const c_void, alpha: f64, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_setBreakOnError_bool(flag: bool) -> Result<bool>;
		pub fn cv_setIdentity_const__InputOutputArrayR_const_ScalarR(mtx: *const c_void, s: *const core::Scalar) -> Result_void;
		pub fn cv_setLogLevel_int(level: i32) -> Result<i32>;
		pub fn cv_setNumThreads_int(nthreads: i32) -> Result_void;
		pub fn cv_setRNGSeed_int(seed: i32) -> Result_void;
		pub fn cv_setUseOpenVX_bool(flag: bool) -> Result_void;
		pub fn cv_setUseOptimized_bool(onoff: bool) -> Result_void;
		pub fn cv_solveCubic_const__InputArrayR_const__OutputArrayR(coeffs: *const c_void, roots: *const c_void) -> Result<i32>;
		pub fn cv_solveLP_const__InputArrayR_const__InputArrayR_const__OutputArrayR(func: *const c_void, constr: *const c_void, z: *const c_void) -> Result<i32>;
		pub fn cv_solvePoly_const__InputArrayR_const__OutputArrayR_int(coeffs: *const c_void, roots: *const c_void, max_iters: i32) -> Result<f64>;
		pub fn cv_solve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_sortIdx_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32) -> Result_void;
		pub fn cv_sort_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32) -> Result_void;
		pub fn cv_split_const_MatR_MatX(src: *const c_void, mvbegin: *mut c_void) -> Result_void;
		pub fn cv_split_const__InputArrayR_const__OutputArrayR(m: *const c_void, mv: *const c_void) -> Result_void;
		pub fn cv_sqrt_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32) -> Result_void;
		pub fn cv_sum_const__InputArrayR(src: *const c_void) -> Result<core::Scalar>;
		pub fn cv_swap_MatR_MatR(a: *mut c_void, b: *mut c_void) -> Result_void;
		pub fn cv_swap_UMatR_UMatR(a: *mut c_void, b: *mut c_void) -> Result_void;
		pub fn cv_tempfile_const_charX(suffix: *const c_char) -> Result<*mut c_void>;
		pub fn cv_theRNG() -> Result<*mut c_void>;
		pub fn cv_trace_const__InputArrayR(mtx: *const c_void) -> Result<core::Scalar>;
		pub fn cv_transform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, m: *const c_void) -> Result_void;
		pub fn cv_transpose_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_typeToString_int(typ: i32) -> Result<*mut c_void>;
		pub fn cv_useOpenVX() -> Result<bool>;
		pub fn cv_useOptimized() -> Result<bool>;
		pub fn cv_utils_dumpBool_bool(argument: bool) -> Result<*mut c_void>;
		pub fn cv_utils_dumpCString_const_charX(argument: *const c_char) -> Result<*mut c_void>;
		pub fn cv_utils_dumpDouble_double(argument: f64) -> Result<*mut c_void>;
		pub fn cv_utils_dumpFloat_float(argument: f32) -> Result<*mut c_void>;
		pub fn cv_utils_dumpInputArrayOfArrays_const__InputArrayR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpInputArray_const__InputArrayR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpInputOutputArrayOfArrays_const__InputOutputArrayR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpInputOutputArray_const__InputOutputArrayR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpInt_int(argument: i32) -> Result<*mut c_void>;
		pub fn cv_utils_dumpRange_const_RangeR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpRect_const_RectR(argument: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_utils_dumpRotatedRect_const_RotatedRectR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpSizeT_size_t(argument: size_t) -> Result<*mut c_void>;
		pub fn cv_utils_dumpString_const_StringR(argument: *const c_char) -> Result<*mut c_void>;
		pub fn cv_utils_dumpTermCriteria_const_TermCriteriaR(argument: *const core::TermCriteria) -> Result<*mut c_void>;
		pub fn cv_utils_dumpVectorOfDouble_const_vector_double_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpVectorOfInt_const_vector_int_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_dumpVectorOfRect_const_vector_Rect_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_fs_getCacheDirectoryForDownloads() -> Result<*mut c_void>;
		pub fn cv_utils_generateVectorOfInt_size_t_vector_int_R(len: size_t, vec: *mut c_void) -> Result_void;
		pub fn cv_utils_generateVectorOfMat_size_t_int_int_int_vector_Mat_R(len: size_t, rows: i32, cols: i32, dtype: i32, vec: *mut c_void) -> Result_void;
		pub fn cv_utils_generateVectorOfRect_size_t_vector_Rect_R(len: size_t, vec: *mut c_void) -> Result_void;
		pub fn cv_utils_getThreadID() -> Result<i32>;
		pub fn cv_utils_logging_getLogLevel() -> Result<core::LogLevel>;
		pub fn cv_utils_logging_getLogTagLevel_const_charX(tag: *const c_char) -> Result<core::LogLevel>;
		pub fn cv_utils_logging_internal_getGlobalLogTag() -> Result<*mut c_void>;
		pub fn cv_utils_logging_internal_writeLogMessageEx_LogLevel_const_charX_const_charX_int_const_charX_const_charX(log_level: core::LogLevel, tag: *const c_char, file: *const c_char, line: i32, func: *const c_char, message: *const c_char) -> Result_void;
		pub fn cv_utils_logging_internal_writeLogMessage_LogLevel_const_charX(log_level: core::LogLevel, message: *const c_char) -> Result_void;
		pub fn cv_utils_logging_registerLogTag_LogTagX(plogtag: *mut c_void) -> Result_void;
		pub fn cv_utils_logging_setLogLevel_LogLevel(log_level: core::LogLevel) -> Result<core::LogLevel>;
		pub fn cv_utils_logging_setLogTagLevel_const_charX_LogLevel(tag: *const c_char, level: core::LogLevel) -> Result_void;
		pub fn cv_utils_testAsyncArray_const__InputArrayR(argument: *const c_void) -> Result<*mut c_void>;
		pub fn cv_utils_testAsyncException() -> Result<*mut c_void>;
		pub fn cv_utils_testOverloadResolution_const_RectR(rect: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_utils_testOverloadResolution_int_const_PointR(value: i32, point: *const core::Point) -> Result<*mut c_void>;
		pub fn cv_utils_testOverwriteNativeMethod_int(argument: i32) -> Result<i32>;
		pub fn cv_utils_testRaiseGeneralException() -> Result_void;
		pub fn cv_utils_testReservedKeywordConversion_int_int_int(positional_argument: i32, lambda: i32, from: i32) -> Result<*mut c_void>;
		pub fn cv_va_intel_convertFromVASurface_VADisplay_VASurfaceID_Size_const__OutputArrayR(display: *mut c_void, surface: core::va_surface_id, size: *const core::Size, dst: *const c_void) -> Result_void;
		pub fn cv_va_intel_convertToVASurface_VADisplay_const__InputArrayR_VASurfaceID_Size(display: *mut c_void, src: *const c_void, surface: core::va_surface_id, size: *const core::Size) -> Result_void;
		pub fn cv_va_intel_ocl_initializeContextFromVA_VADisplay_bool(display: *mut c_void, try_interop: bool) -> Result<*mut c_void>;
		pub fn cv_vconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_vconcat_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_writeScalar_FileStorageR_const_StringR(fs: *mut c_void, value: *const c_char) -> Result_void;
		pub fn cv_writeScalar_FileStorageR_double(fs: *mut c_void, value: f64) -> Result_void;
		pub fn cv_writeScalar_FileStorageR_float(fs: *mut c_void, value: f32) -> Result_void;
		pub fn cv_writeScalar_FileStorageR_int(fs: *mut c_void, value: i32) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_MatR(fs: *mut c_void, name: *const c_char, value: *const c_void) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_SparseMatR(fs: *mut c_void, name: *const c_char, value: *const c_void) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_StringR(fs: *mut c_void, name: *const c_char, value: *const c_char) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_vector_DMatch_R(fs: *mut c_void, name: *const c_char, value: *const c_void) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_vector_KeyPoint_R(fs: *mut c_void, name: *const c_char, value: *const c_void) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_double(fs: *mut c_void, name: *const c_char, value: f64) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_float(fs: *mut c_void, name: *const c_char, value: f32) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_int(fs: *mut c_void, name: *const c_char, value: i32) -> Result_void;
		pub fn cv_Algorithm_Algorithm() -> Result<*mut c_void>;
		pub fn cv_Algorithm_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_Algorithm_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_Algorithm_write_const_const_Ptr_FileStorage_R_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char) -> Result_void;
		pub fn cv_Algorithm_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_Algorithm_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_Algorithm_save_const_const_StringR(instance: *const c_void, filename: *const c_char) -> Result_void;
		pub fn cv_Algorithm_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_AsyncArray_AsyncArray() -> *mut c_void;
		pub fn cv_AsyncArray_AsyncArray_const_AsyncArrayR(o: *const c_void) -> *mut c_void;
		pub fn cv_AsyncArray_release(instance: *mut c_void);
		pub fn cv_AsyncArray_get_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_AsyncArray_get_const_const__OutputArrayR_int64_t(instance: *const c_void, dst: *const c_void, timeout_ns: i64) -> Result<bool>;
		pub fn cv_AsyncArray_get_const_const__OutputArrayR_double(instance: *const c_void, dst: *const c_void, timeout_ns: f64) -> Result<bool>;
		pub fn cv_AsyncArray_wait_for_const_int64_t(instance: *const c_void, timeout_ns: i64) -> Result<bool>;
		pub fn cv_AsyncArray_wait_for_const_double(instance: *const c_void, timeout_ns: f64) -> Result<bool>;
		pub fn cv_AsyncArray_valid_const(instance: *const c_void) -> bool;
		pub fn cv_AsyncArray_AsyncArray_AsyncArrayR(o: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_AsyncPromise_AsyncPromise() -> *mut c_void;
		pub fn cv_AsyncPromise_AsyncPromise_const_AsyncPromiseR(o: *const c_void) -> *mut c_void;
		pub fn cv_AsyncPromise_release(instance: *mut c_void);
		pub fn cv_AsyncPromise_getArrayResult(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_AsyncPromise_setValue_const__InputArrayR(instance: *mut c_void, value: *const c_void) -> Result_void;
		pub fn cv_AsyncPromise_setException_const_ExceptionR(instance: *mut c_void, exception: *const c_void) -> Result_void;
		pub fn cv_AsyncPromise_AsyncPromise_AsyncPromiseR(o: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_AsyncPromise__getImpl_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_CommandLineParser_CommandLineParser_int_const_charXX_const_StringR(argc: i32, argv: *const *const c_char, keys: *const c_char) -> Result<*mut c_void>;
		pub fn cv_CommandLineParser_CommandLineParser_const_CommandLineParserR(parser: *const c_void) -> Result<*mut c_void>;
		pub fn cv_CommandLineParser_getPathToApplication_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_CommandLineParser_has_const_const_StringR(instance: *const c_void, name: *const c_char) -> Result<bool>;
		pub fn cv_CommandLineParser_check_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_CommandLineParser_about_const_StringR(instance: *mut c_void, message: *const c_char) -> Result_void;
		pub fn cv_CommandLineParser_printMessage_const(instance: *const c_void) -> Result_void;
		pub fn cv_CommandLineParser_printErrors_const(instance: *const c_void) -> Result_void;
		pub fn cv_ConjGradSolver_create_const_Ptr_Function_R_TermCriteria(f: *const c_void, termcrit: *const core::TermCriteria) -> Result<*mut c_void>;
		pub fn cv_DMatch_DMatch() -> Result<core::DMatch>;
		pub fn cv_DMatch_DMatch_int_int_float(_query_idx: i32, _train_idx: i32, _distance: f32) -> Result<core::DMatch>;
		pub fn cv_DMatch_DMatch_int_int_int_float(_query_idx: i32, _train_idx: i32, _img_idx: i32, _distance: f32) -> Result<core::DMatch>;
		pub fn cv_DownhillSolver_getInitStep_const_const__OutputArrayR(instance: *const c_void, step: *const c_void) -> Result_void;
		pub fn cv_DownhillSolver_setInitStep_const__InputArrayR(instance: *mut c_void, step: *const c_void) -> Result_void;
		pub fn cv_DownhillSolver_create_const_Ptr_Function_R_const__InputArrayR_TermCriteria(f: *const c_void, init_step: *const c_void, termcrit: *const core::TermCriteria) -> Result<*mut c_void>;
		pub fn cv_Exception_getPropMsg_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_setPropMsg_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_Exception_getPropCode_const(instance: *const c_void) -> i32;
		pub fn cv_Exception_setPropCode_int(instance: *mut c_void, val: i32);
		pub fn cv_Exception_getPropErr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_setPropErr_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_Exception_getPropFunc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_setPropFunc_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_Exception_getPropFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_setPropFile_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_Exception_getPropLine_const(instance: *const c_void) -> i32;
		pub fn cv_Exception_setPropLine_int(instance: *mut c_void, val: i32);
		pub fn cv_Exception_Exception() -> Result<*mut c_void>;
		pub fn cv_Exception_Exception_int_const_StringR_const_StringR_const_StringR_int(_code: i32, _err: *const c_char, _func: *const c_char, _file: *const c_char, _line: i32) -> Result<*mut c_void>;
		pub fn cv_Exception_what_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Exception_formatMessage(instance: *mut c_void) -> Result_void;
		pub fn cv_FileNode_getPropBlockIdx_const(instance: *const c_void) -> size_t;
		pub fn cv_FileNode_setPropBlockIdx_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_FileNode_getPropOfs_const(instance: *const c_void) -> size_t;
		pub fn cv_FileNode_setPropOfs_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_FileNode_FileNode() -> Result<*mut c_void>;
		pub fn cv_FileNode_FileNode_const_FileStorageX_size_t_size_t(fs: *const c_void, block_idx: size_t, ofs: size_t) -> Result<*mut c_void>;
		pub fn cv_FileNode_FileNode_const_FileNodeR(node: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_operator___const_const_StringR(instance: *const c_void, nodename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileNode_operator___const_const_charX(instance: *const c_void, nodename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileNode_operator___const_int(instance: *const c_void, i: i32) -> Result<*mut c_void>;
		pub fn cv_FileNode_keys_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FileNode_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isNone_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isSeq_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isMap_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isInt_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isReal_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isString_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_isNamed_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileNode_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_size_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_FileNode_rawSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_FileNode_operator_int_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FileNode_operator_float_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_FileNode_operator_double_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_FileNode_operator_std_string_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_isMap_int(flags: i32) -> Result<bool>;
		pub fn cv_FileNode_isSeq_int(flags: i32) -> Result<bool>;
		pub fn cv_FileNode_isCollection_int(flags: i32) -> Result<bool>;
		pub fn cv_FileNode_isEmptyCollection_int(flags: i32) -> Result<bool>;
		pub fn cv_FileNode_isFlow_int(flags: i32) -> Result<bool>;
		pub fn cv_FileNode_ptr(instance: *mut c_void) -> Result<*mut u8>;
		pub fn cv_FileNode_ptr_const(instance: *const c_void) -> Result<*const u8>;
		pub fn cv_FileNode_begin_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_end_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_readRaw_const_const_StringR_voidX_size_t(instance: *const c_void, fmt: *const c_char, vec: *mut c_void, len: size_t) -> Result_void;
		pub fn cv_FileNode_setValue_int_const_voidX_int(instance: *mut c_void, typ: i32, value: *const c_void, len: i32) -> Result_void;
		pub fn cv_FileNode_real_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_FileNode_string_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNode_mat_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_FileNodeIterator() -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_FileNodeIterator_const_FileNodeR_bool(node: *const c_void, seek_end: bool) -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_FileNodeIterator_const_FileNodeIteratorR(it: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_operatorX_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_readRaw_const_StringR_voidX_size_t(instance: *mut c_void, fmt: *const c_char, vec: *mut c_void, len: size_t) -> Result<*mut c_void>;
		pub fn cv_FileNodeIterator_remaining_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_FileNodeIterator_equalTo_const_const_FileNodeIteratorR(instance: *const c_void, it: *const c_void) -> Result<bool>;
		pub fn cv_FileStorage_getPropState_const(instance: *const c_void) -> i32;
		pub fn cv_FileStorage_setPropState_int(instance: *mut c_void, val: i32);
		pub fn cv_FileStorage_getPropElname_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_FileStorage_setPropElname_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_FileStorage_FileStorage() -> Result<*mut c_void>;
		pub fn cv_FileStorage_FileStorage_const_StringR_int_const_StringR(filename: *const c_char, flags: i32, encoding: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileStorage_open_const_StringR_int_const_StringR(instance: *mut c_void, filename: *const c_char, flags: i32, encoding: *const c_char) -> Result<bool>;
		pub fn cv_FileStorage_isOpened_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FileStorage_release(instance: *mut c_void) -> Result_void;
		pub fn cv_FileStorage_releaseAndGetString(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_FileStorage_getFirstTopLevelNode_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FileStorage_root_const_int(instance: *const c_void, streamidx: i32) -> Result<*mut c_void>;
		pub fn cv_FileStorage_operator___const_const_StringR(instance: *const c_void, nodename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileStorage_operator___const_const_charX(instance: *const c_void, nodename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileStorage_write_const_StringR_int(instance: *mut c_void, name: *const c_char, val: i32) -> Result_void;
		pub fn cv_FileStorage_write_const_StringR_double(instance: *mut c_void, name: *const c_char, val: f64) -> Result_void;
		pub fn cv_FileStorage_write_const_StringR_const_StringR(instance: *mut c_void, name: *const c_char, val: *const c_char) -> Result_void;
		pub fn cv_FileStorage_write_const_StringR_const_MatR(instance: *mut c_void, name: *const c_char, val: *const c_void) -> Result_void;
		pub fn cv_FileStorage_write_const_StringR_const_vector_String_R(instance: *mut c_void, name: *const c_char, val: *const c_void) -> Result_void;
		pub fn cv_FileStorage_writeRaw_const_StringR_const_voidX_size_t(instance: *mut c_void, fmt: *const c_char, vec: *const c_void, len: size_t) -> Result_void;
		pub fn cv_FileStorage_writeComment_const_StringR_bool(instance: *mut c_void, comment: *const c_char, append: bool) -> Result_void;
		pub fn cv_FileStorage_startWriteStruct_const_StringR_int_const_StringR(instance: *mut c_void, name: *const c_char, flags: i32, type_name: *const c_char) -> Result_void;
		pub fn cv_FileStorage_endWriteStruct(instance: *mut c_void) -> Result_void;
		pub fn cv_FileStorage_getDefaultObjectName_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_FileStorage_getFormat_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_Formatted_next(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Formatted_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_Formatter_format_const_const_MatR(instance: *const c_void, mtx: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Formatter_set16fPrecision_int(instance: *mut c_void, p: i32) -> Result_void;
		pub fn cv_Formatter_set32fPrecision_int(instance: *mut c_void, p: i32) -> Result_void;
		pub fn cv_Formatter_set64fPrecision_int(instance: *mut c_void, p: i32) -> Result_void;
		pub fn cv_Formatter_setMultiline_bool(instance: *mut c_void, ml: bool) -> Result_void;
		pub fn cv_Formatter_get_FormatType(fmt: core::Formatter_FormatType) -> Result<*mut c_void>;
		pub fn cv_KeyPoint_KeyPoint() -> Result<core::KeyPoint>;
		pub fn cv_KeyPoint_KeyPoint_Point2f_float_float_float_int_int(pt: *const core::Point2f, size: f32, angle: f32, response: f32, octave: i32, class_id: i32) -> Result<core::KeyPoint>;
		pub fn cv_KeyPoint_KeyPoint_float_float_float_float_float_int_int(x: f32, y: f32, size: f32, angle: f32, response: f32, octave: i32, class_id: i32) -> Result<core::KeyPoint>;
		pub fn cv_KeyPoint_hash_const(instance: *const core::KeyPoint) -> Result<size_t>;
		pub fn cv_KeyPoint_convert_const_vector_KeyPoint_R_vector_Point2f_R_const_vector_int_R(keypoints: *const c_void, points2f: *mut c_void, keypoint_indexes: *const c_void) -> Result_void;
		pub fn cv_KeyPoint_convert_const_vector_Point2f_R_vector_KeyPoint_R_float_float_int_int(points2f: *const c_void, keypoints: *mut c_void, size: f32, response: f32, octave: i32, class_id: i32) -> Result_void;
		pub fn cv_KeyPoint_overlap_const_KeyPointR_const_KeyPointR(kp1: *const core::KeyPoint, kp2: *const core::KeyPoint) -> Result<f32>;
		pub fn cv_LDA_LDA_int(num_components: i32) -> Result<*mut c_void>;
		pub fn cv_LDA_LDA_const__InputArrayR_const__InputArrayR_int(src: *const c_void, labels: *const c_void, num_components: i32) -> Result<*mut c_void>;
		pub fn cv_LDA_save_const_const_StringR(instance: *const c_void, filename: *const c_char) -> Result_void;
		pub fn cv_LDA_load_const_StringR(instance: *mut c_void, filename: *const c_char) -> Result_void;
		pub fn cv_LDA_save_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_LDA_load_const_FileStorageR(instance: *mut c_void, node: *const c_void) -> Result_void;
		pub fn cv_LDA_compute_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void) -> Result_void;
		pub fn cv_LDA_project_const__InputArrayR(instance: *mut c_void, src: *const c_void) -> Result<*mut c_void>;
		pub fn cv_LDA_reconstruct_const__InputArrayR(instance: *mut c_void, src: *const c_void) -> Result<*mut c_void>;
		pub fn cv_LDA_eigenvectors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_LDA_eigenvalues_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_LDA_subspaceProject_const__InputArrayR_const__InputArrayR_const__InputArrayR(w: *const c_void, mean: *const c_void, src: *const c_void) -> Result<*mut c_void>;
		pub fn cv_LDA_subspaceReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR(w: *const c_void, mean: *const c_void, src: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_getPropDims_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_setPropDims_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_getPropRows_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_setPropRows_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_getPropCols_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_setPropCols_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_getPropData(instance: *mut c_void) -> *mut u8;
		pub fn cv_Mat_setPropData_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_Mat_getPropDatastart_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_getPropDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_getPropDatalimit_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_getPropU(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Mat_setPropU_UMatDataX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_Mat_getPropSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Mat_getPropStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Mat_Mat() -> *mut c_void;
		pub fn cv_Mat_Mat_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_int_int_int_const_ScalarR(rows: i32, cols: i32, typ: i32, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_Size_int_const_ScalarR(size: *const core::Size, typ: i32, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_int_const_intX_int(ndims: i32, sizes: *const i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_vector_int_R_int(sizes: *const c_void, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_int_const_intX_int_const_ScalarR(ndims: i32, sizes: *const i32, typ: i32, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_vector_int_R_int_const_ScalarR(sizes: *const c_void, typ: i32, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_int_int_int_voidX_size_t(rows: i32, cols: i32, typ: i32, data: *mut c_void, step: size_t) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_Size_int_voidX_size_t(size: *const core::Size, typ: i32, data: *mut c_void, step: size_t) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_int_const_intX_int_voidX_const_size_tX(ndims: i32, sizes: *const i32, typ: i32, data: *mut c_void, steps: *const size_t) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_vector_int_R_int_voidX_const_size_tX(sizes: *const c_void, typ: i32, data: *mut c_void, steps: *const size_t) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_MatR_const_RangeR_const_RangeR(m: *const c_void, row_range: *const c_void, col_range: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_MatR_const_RectR(m: *const c_void, roi: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_MatR_const_vector_Range_R(m: *const c_void, ranges: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_Mat_const_GpuMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_getUMat_const_AccessFlag_UMatUsageFlags(instance: *const c_void, access_flags: core::AccessFlag, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_Mat_row_const_int(instance: *const c_void, y: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_col_const_int(instance: *const c_void, x: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_rowRange_const_const_RangeR(instance: *const c_void, r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_colRange_const_const_RangeR(instance: *const c_void, r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_diag_const_int(instance: *const c_void, d: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_diag_const_MatR(d: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_copyTo_const_const__OutputArrayR(instance: *const c_void, m: *const c_void) -> Result_void;
		pub fn cv_Mat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, m: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_Mat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, m: *const c_void, rtype: i32, alpha: f64, beta: f64) -> Result_void;
		pub fn cv_Mat_assignTo_const_MatR_int(instance: *const c_void, m: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_Mat_setTo_const__InputArrayR_const__InputArrayR(instance: *mut c_void, value: *const c_void, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_reshape_const_int_int_const_intX(instance: *const c_void, cn: i32, newndims: i32, newsz: *const i32) -> Result<*mut c_void>;
		pub fn cv_Mat_reshape_const_int_const_vector_int_R(instance: *const c_void, cn: i32, newshape: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_t_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_inv_const_int(instance: *const c_void, method: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_mul_const_const__InputArrayR_double(instance: *const c_void, m: *const c_void, scale: f64) -> Result<*mut c_void>;
		pub fn cv_Mat_cross_const_const__InputArrayR(instance: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_dot_const_const__InputArrayR(instance: *const c_void, m: *const c_void) -> Result<f64>;
		pub fn cv_Mat_zeros_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_zeros_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_zeros_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_ones_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_ones_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_ones_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_eye_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_eye_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32) -> Result_void;
		pub fn cv_Mat_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32) -> Result_void;
		pub fn cv_Mat_create_int_const_intX_int(instance: *mut c_void, ndims: i32, sizes: *const i32, typ: i32) -> Result_void;
		pub fn cv_Mat_create_const_vector_int_R_int(instance: *mut c_void, sizes: *const c_void, typ: i32) -> Result_void;
		pub fn cv_Mat_addref(instance: *mut c_void) -> Result_void;
		pub fn cv_Mat_release(instance: *mut c_void) -> Result_void;
		pub fn cv_Mat_deallocate(instance: *mut c_void) -> Result_void;
		pub fn cv_Mat_reserve_size_t(instance: *mut c_void, sz: size_t) -> Result_void;
		pub fn cv_Mat_reserveBuffer_size_t(instance: *mut c_void, sz: size_t) -> Result_void;
		pub fn cv_Mat_resize_size_t(instance: *mut c_void, sz: size_t) -> Result_void;
		pub fn cv_Mat_resize_size_t_const_ScalarR(instance: *mut c_void, sz: size_t, s: *const core::Scalar) -> Result_void;
		pub fn cv_Mat_push_back_const_MatR(instance: *mut c_void, m: *const c_void) -> Result_void;
		pub fn cv_Mat_pop_back_size_t(instance: *mut c_void, nelems: size_t) -> Result_void;
		pub fn cv_Mat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point) -> Result_void;
		pub fn cv_Mat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32) -> Result<*mut c_void>;
		pub fn cv_Mat_isContinuous_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_isSubmatrix_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_elemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_Mat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_Mat_type_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_step1_const_int(instance: *const c_void, i: i32) -> Result<size_t>;
		pub fn cv_Mat_empty_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_total_const(instance: *const c_void) -> size_t;
		pub fn cv_Mat_total_const_int_int(instance: *const c_void, start_dim: i32, end_dim: i32) -> Result<size_t>;
		pub fn cv_Mat_checkVector_const_int_int_bool(instance: *const c_void, elem_channels: i32, depth: i32, require_continuous: bool) -> Result<i32>;
		pub fn cv_Mat_ptr_int(instance: *mut c_void, i0: i32) -> Result<*mut u8>;
		pub fn cv_Mat_ptr_const_int(instance: *const c_void, i0: i32) -> Result<*const u8>;
		pub fn cv_Mat_ptr_int_int(instance: *mut c_void, row: i32, col: i32) -> Result<*mut u8>;
		pub fn cv_Mat_ptr_const_int_int(instance: *const c_void, row: i32, col: i32) -> Result<*const u8>;
		pub fn cv_Mat_ptr_int_int_int(instance: *mut c_void, i0: i32, i1: i32, i2: i32) -> Result<*mut u8>;
		pub fn cv_Mat_ptr_const_int_int_int(instance: *const c_void, i0: i32, i1: i32, i2: i32) -> Result<*const u8>;
		pub fn cv_Mat_ptr_const_intX(instance: *mut c_void, idx: *const i32) -> Result<*mut u8>;
		pub fn cv_Mat_ptr_const_const_intX(instance: *const c_void, idx: *const i32) -> Result<*const u8>;
		pub fn cv_Mat_Mat_MatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Mat_updateContinuityFlag(instance: *mut c_void) -> Result_void;
		pub fn cv_MatConstIterator_getPropM_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatConstIterator_getPropElemSize_const(instance: *const c_void) -> size_t;
		pub fn cv_MatConstIterator_setPropElemSize_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_MatConstIterator_getPropPtr_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_getPropSliceStart_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_getPropSliceEnd_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_MatConstIterator() -> Result<*mut c_void>;
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX(_m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX_int_int(_m: *const c_void, _row: i32, _col: i32) -> Result<*mut c_void>;
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX_Point(_m: *const c_void, _pt: *const core::Point) -> Result<*mut c_void>;
		pub fn cv_MatConstIterator_MatConstIterator_const_MatConstIteratorR(it: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatConstIterator_operatorX_const(instance: *const c_void) -> Result<*const u8>;
		pub fn cv_MatConstIterator_operator___const_ptrdiff_t(instance: *const c_void, i: ptrdiff_t) -> Result<*const u8>;
		pub fn cv_MatConstIterator_pos_const(instance: *const c_void) -> Result<core::Point>;
		pub fn cv_MatConstIterator_pos_const_intX(instance: *const c_void, _idx: *mut i32) -> Result_void;
		pub fn cv_MatConstIterator_lpos_const(instance: *const c_void) -> Result<ptrdiff_t>;
		pub fn cv_MatConstIterator_seek_ptrdiff_t_bool(instance: *mut c_void, ofs: ptrdiff_t, relative: bool) -> Result_void;
		pub fn cv_MatConstIterator_seek_const_intX_bool(instance: *mut c_void, _idx: *const i32, relative: bool) -> Result_void;
		pub fn cv_MatExpr_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_MatExpr_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_MatExpr_getPropA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_setPropA_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_MatExpr_getPropB_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_setPropB_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_MatExpr_getPropC_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_setPropC_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_MatExpr_getPropAlpha_const(instance: *const c_void) -> f64;
		pub fn cv_MatExpr_setPropAlpha_double(instance: *mut c_void, val: f64);
		pub fn cv_MatExpr_getPropBeta_const(instance: *const c_void) -> f64;
		pub fn cv_MatExpr_setPropBeta_double(instance: *mut c_void, val: f64);
		pub fn cv_MatExpr_getPropS_const(instance: *const c_void) -> core::Scalar;
		pub fn cv_MatExpr_setPropS_Scalar(instance: *mut c_void, val: *const core::Scalar);
		pub fn cv_MatExpr_MatExpr() -> Result<*mut c_void>;
		pub fn cv_MatExpr_MatExpr_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatExpr_MatExpr_const_MatOpX_int_const_MatR_const_MatR_const_MatR_double_double_const_ScalarR(_op: *const c_void, _flags: i32, _a: *const c_void, _b: *const c_void, _c: *const c_void, _alpha: f64, _beta: f64, _s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_MatExpr_operator_cv_Mat_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatExpr_size_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_MatExpr_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_MatExpr_row_const_int(instance: *const c_void, y: i32) -> Result<*mut c_void>;
		pub fn cv_MatExpr_col_const_int(instance: *const c_void, x: i32) -> Result<*mut c_void>;
		pub fn cv_MatExpr_diag_const_int(instance: *const c_void, d: i32) -> Result<*mut c_void>;
		pub fn cv_MatExpr_t_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatExpr_inv_const_int(instance: *const c_void, method: i32) -> Result<*mut c_void>;
		pub fn cv_MatExpr_mul_const_const_MatExprR_double(instance: *const c_void, e: *const c_void, scale: f64) -> Result<*mut c_void>;
		pub fn cv_MatExpr_mul_const_const_MatR_double(instance: *const c_void, m: *const c_void, scale: f64) -> Result<*mut c_void>;
		pub fn cv_MatExpr_cross_const_const_MatR(instance: *const c_void, m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MatExpr_dot_const_const_MatR(instance: *const c_void, m: *const c_void) -> Result<f64>;
		pub fn cv_MatExpr_swap_MatExprR(instance: *mut c_void, b: *mut c_void) -> Result_void;
		pub fn cv_MatOp_elementWise_const_const_MatExprR(instance: *const c_void, expr: *const c_void) -> Result<bool>;
		pub fn cv_MatOp_assign_const_const_MatExprR_MatR_int(instance: *const c_void, expr: *const c_void, m: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_MatOp_roi_const_const_MatExprR_const_RangeR_const_RangeR_MatExprR(instance: *const c_void, expr: *const c_void, row_range: *const c_void, col_range: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_diag_const_const_MatExprR_int_MatExprR(instance: *const c_void, expr: *const c_void, d: i32, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignAdd_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignSubtract_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignMultiply_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignDivide_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignAnd_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignOr_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_augAssignXor_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_MatOp_add_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_add_const_const_MatExprR_const_ScalarR_MatExprR(instance: *const c_void, expr1: *const c_void, s: *const core::Scalar, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_subtract_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_subtract_const_const_ScalarR_const_MatExprR_MatExprR(instance: *const c_void, s: *const core::Scalar, expr: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_multiply_const_const_MatExprR_const_MatExprR_MatExprR_double(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, scale: f64) -> Result_void;
		pub fn cv_MatOp_multiply_const_const_MatExprR_double_MatExprR(instance: *const c_void, expr1: *const c_void, s: f64, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_divide_const_const_MatExprR_const_MatExprR_MatExprR_double(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, scale: f64) -> Result_void;
		pub fn cv_MatOp_divide_const_double_const_MatExprR_MatExprR(instance: *const c_void, s: f64, expr: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_abs_const_const_MatExprR_MatExprR(instance: *const c_void, expr: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_transpose_const_const_MatExprR_MatExprR(instance: *const c_void, expr: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_matmul_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_invert_const_const_MatExprR_int_MatExprR(instance: *const c_void, expr: *const c_void, method: i32, res: *mut c_void) -> Result_void;
		pub fn cv_MatOp_size_const_const_MatExprR(instance: *const c_void, expr: *const c_void) -> Result<core::Size>;
		pub fn cv_MatOp_type_const_const_MatExprR(instance: *const c_void, expr: *const c_void) -> Result<i32>;
		pub fn cv_MatSize_getPropP(instance: *mut c_void) -> *mut i32;
		pub fn cv_MatSize_setPropP_intX(instance: *mut c_void, val: *mut i32);
		pub fn cv_MatSize_MatSize_intX(_p: *mut i32) -> *mut c_void;
		pub fn cv_MatSize_dims_const(instance: *const c_void) -> i32;
		pub fn cv_MatSize_operator___const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv_MatSize_operator___int(instance: *mut c_void, i: i32) -> Result<i32>;
		pub fn cv_MatSize_operator_const_intX_const(instance: *const c_void) -> *const i32;
		pub fn cv_MatSize_operatorEQ_const_const_MatSizeR(instance: *const c_void, sz: *const c_void) -> bool;
		pub fn cv_MatStep_getPropP(instance: *mut c_void) -> *mut size_t;
		pub fn cv_MatStep_setPropP_size_tX(instance: *mut c_void, val: *mut size_t);
		pub fn cv_MatStep_getPropBuf(instance: *mut c_void) -> *mut [size_t; 2];
		pub fn cv_MatStep_MatStep() -> *mut c_void;
		pub fn cv_MatStep_MatStep_size_t(s: size_t) -> *mut c_void;
		pub fn cv_MatStep_operator___const_int(instance: *const c_void, i: i32) -> size_t;
		pub fn cv_MatStep_operator___int(instance: *mut c_void, i: i32) -> size_t;
		pub fn cv_MatStep_operator_size_t_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_Matx_AddOp_Matx_AddOp() -> Result<*mut c_void>;
		pub fn cv_Matx_AddOp_Matx_AddOp_const_Matx_AddOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_DivOp_Matx_DivOp() -> Result<*mut c_void>;
		pub fn cv_Matx_DivOp_Matx_DivOp_const_Matx_DivOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_MatMulOp_Matx_MatMulOp() -> Result<*mut c_void>;
		pub fn cv_Matx_MatMulOp_Matx_MatMulOp_const_Matx_MatMulOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_MulOp_Matx_MulOp() -> Result<*mut c_void>;
		pub fn cv_Matx_MulOp_Matx_MulOp_const_Matx_MulOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_ScaleOp_Matx_ScaleOp() -> Result<*mut c_void>;
		pub fn cv_Matx_ScaleOp_Matx_ScaleOp_const_Matx_ScaleOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_SubOp_Matx_SubOp() -> Result<*mut c_void>;
		pub fn cv_Matx_SubOp_Matx_SubOp_const_Matx_SubOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Matx_TOp_Matx_TOp() -> Result<*mut c_void>;
		pub fn cv_Matx_TOp_Matx_TOp_const_Matx_TOpR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MinProblemSolver_getFunction_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MinProblemSolver_setFunction_const_Ptr_Function_R(instance: *mut c_void, f: *const c_void) -> Result_void;
		pub fn cv_MinProblemSolver_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_MinProblemSolver_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, termcrit: *const core::TermCriteria) -> Result_void;
		pub fn cv_MinProblemSolver_minimize_const__InputOutputArrayR(instance: *mut c_void, x: *const c_void) -> Result<f64>;
		pub fn cv_MinProblemSolver_Function_getDims_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_MinProblemSolver_Function_getGradientEps_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_MinProblemSolver_Function_calc_const_const_doubleX(instance: *const c_void, x: *const f64) -> Result<f64>;
		pub fn cv_MinProblemSolver_Function_getGradient_const_doubleX_doubleX(instance: *mut c_void, x: *const f64, grad: *mut f64) -> Result_void;
		pub fn cv_Moments_Moments() -> Result<core::Moments>;
		pub fn cv_Moments_Moments_double_double_double_double_double_double_double_double_double_double(m00: f64, m10: f64, m01: f64, m20: f64, m11: f64, m02: f64, m30: f64, m21: f64, m12: f64, m03: f64) -> Result<core::Moments>;
		pub fn cv_PCA_getPropEigenvectors_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_setPropEigenvectors_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_PCA_getPropEigenvalues_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_setPropEigenvalues_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_PCA_getPropMean_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_setPropMean_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_PCA_PCA() -> Result<*mut c_void>;
		pub fn cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_int(data: *const c_void, mean: *const c_void, flags: i32, max_components: i32) -> Result<*mut c_void>;
		pub fn cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_double(data: *const c_void, mean: *const c_void, flags: i32, retained_variance: f64) -> Result<*mut c_void>;
		pub fn cv_PCA_project_const_const__InputArrayR(instance: *const c_void, vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv_PCA_project_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, vec: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_PCA_backProject_const_const__InputArrayR(instance: *const c_void, vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv_PCA_backProject_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, vec: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_PCA_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_PCA_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_RNG_getPropState_const(instance: *const c_void) -> u64;
		pub fn cv_RNG_setPropState_uint64_t(instance: *mut c_void, val: u64);
		pub fn cv_RNG_RNG() -> Result<*mut c_void>;
		pub fn cv_RNG_RNG_uint64_t(state: u64) -> Result<*mut c_void>;
		pub fn cv_RNG_next(instance: *mut c_void) -> Result<u32>;
		pub fn cv_RNG_operator_unsigned_char(instance: *mut c_void) -> Result<u8>;
		pub fn cv_RNG_operator_signed_char(instance: *mut c_void) -> Result<i8>;
		pub fn cv_RNG_operator_unsigned_short(instance: *mut c_void) -> Result<u16>;
		pub fn cv_RNG_operator_short(instance: *mut c_void) -> Result<i16>;
		pub fn cv_RNG_operator_unsigned_int(instance: *mut c_void) -> Result<u32>;
		pub fn cv_RNG_operator_int(instance: *mut c_void) -> Result<i32>;
		pub fn cv_RNG_operator_float(instance: *mut c_void) -> Result<f32>;
		pub fn cv_RNG_operator_double(instance: *mut c_void) -> Result<f64>;
		pub fn cv_RNG_uniform_int_int(instance: *mut c_void, a: i32, b: i32) -> Result<i32>;
		pub fn cv_RNG_uniform_float_float(instance: *mut c_void, a: f32, b: f32) -> Result<f32>;
		pub fn cv_RNG_uniform_double_double(instance: *mut c_void, a: f64, b: f64) -> Result<f64>;
		pub fn cv_RNG_fill_const__InputOutputArrayR_int_const__InputArrayR_const__InputArrayR_bool(instance: *mut c_void, mat: *const c_void, dist_type: i32, a: *const c_void, b: *const c_void, saturate_range: bool) -> Result_void;
		pub fn cv_RNG_gaussian_double(instance: *mut c_void, sigma: f64) -> Result<f64>;
		pub fn cv_RNG_operatorEQ_const_const_RNGR(instance: *const c_void, other: *const c_void) -> Result<bool>;
		pub fn cv_RNG_MT19937_RNG_MT19937() -> Result<*mut c_void>;
		pub fn cv_RNG_MT19937_RNG_MT19937_unsigned_int(s: u32) -> Result<*mut c_void>;
		pub fn cv_RNG_MT19937_seed_unsigned_int(instance: *mut c_void, s: u32) -> Result_void;
		pub fn cv_RNG_MT19937_next(instance: *mut c_void) -> Result<u32>;
		pub fn cv_RNG_MT19937_operator_int(instance: *mut c_void) -> Result<i32>;
		pub fn cv_RNG_MT19937_operator_unsigned_int(instance: *mut c_void) -> Result<u32>;
		pub fn cv_RNG_MT19937_operator_float(instance: *mut c_void) -> Result<f32>;
		pub fn cv_RNG_MT19937_operator_double(instance: *mut c_void) -> Result<f64>;
		pub fn cv_RNG_MT19937_uniform_int_int(instance: *mut c_void, a: i32, b: i32) -> Result<i32>;
		pub fn cv_RNG_MT19937_uniform_float_float(instance: *mut c_void, a: f32, b: f32) -> Result<f32>;
		pub fn cv_RNG_MT19937_uniform_double_double(instance: *mut c_void, a: f64, b: f64) -> Result<f64>;
		pub fn cv_Range_getPropStart_const(instance: *const c_void) -> i32;
		pub fn cv_Range_setPropStart_int(instance: *mut c_void, val: i32);
		pub fn cv_Range_getPropEnd_const(instance: *const c_void) -> i32;
		pub fn cv_Range_setPropEnd_int(instance: *mut c_void, val: i32);
		pub fn cv_Range_Range() -> Result<*mut c_void>;
		pub fn cv_Range_Range_int_int(_start: i32, _end: i32) -> Result<*mut c_void>;
		pub fn cv_Range_size_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_Range_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_Range_all() -> Result<*mut c_void>;
		pub fn cv_RotatedRect_getPropCenter_const(instance: *const c_void) -> core::Point2f;
		pub fn cv_RotatedRect_setPropCenter_Point2f(instance: *mut c_void, val: *const core::Point2f);
		pub fn cv_RotatedRect_getPropSize_const(instance: *const c_void) -> core::Size2f;
		pub fn cv_RotatedRect_setPropSize_Size2f(instance: *mut c_void, val: *const core::Size2f);
		pub fn cv_RotatedRect_getPropAngle_const(instance: *const c_void) -> f32;
		pub fn cv_RotatedRect_setPropAngle_float(instance: *mut c_void, val: f32);
		pub fn cv_RotatedRect_RotatedRect() -> Result<*mut c_void>;
		pub fn cv_RotatedRect_RotatedRect_const_Point2fR_const_Size2fR_float(center: *const core::Point2f, size: *const core::Size2f, angle: f32) -> Result<*mut c_void>;
		pub fn cv_RotatedRect_RotatedRect_const_Point2fR_const_Point2fR_const_Point2fR(point1: *const core::Point2f, point2: *const core::Point2f, point3: *const core::Point2f) -> Result<*mut c_void>;
		pub fn cv_RotatedRect_points_const_Point2fX(instance: *const c_void, pts: *mut core::Point2f) -> Result_void;
		pub fn cv_RotatedRect_boundingRect_const(instance: *const c_void) -> Result<core::Rect>;
		pub fn cv_RotatedRect_boundingRect2f_const(instance: *const c_void) -> Result<core::Rect_<f32>>;
		pub fn cv_SVD_getPropU_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_setPropU_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SVD_getPropW_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_setPropW_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SVD_getPropVt_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_setPropVt_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SVD_SVD() -> Result<*mut c_void>;
		pub fn cv_SVD_SVD_const__InputArrayR_int(src: *const c_void, flags: i32) -> Result<*mut c_void>;
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, flags: i32) -> Result_void;
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, flags: i32) -> Result_void;
		pub fn cv_SVD_backSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(w: *const c_void, u: *const c_void, vt: *const c_void, rhs: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_SVD_solveZ_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_SVD_backSubst_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, rhs: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_SparseMat_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_getPropHdr(instance: *mut c_void) -> *mut c_void;
		pub fn cv_SparseMat_setPropHdr_HdrX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SparseMat_SparseMat() -> Result<*mut c_void>;
		pub fn cv_SparseMat_SparseMat_int_const_intX_int(dims: i32, _sizes: *const i32, _type: i32) -> Result<*mut c_void>;
		pub fn cv_SparseMat_SparseMat_const_SparseMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_SparseMat_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_copyTo_const_SparseMatR(instance: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_copyTo_const_MatR(instance: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_convertTo_const_SparseMatR_int_double(instance: *const c_void, m: *mut c_void, rtype: i32, alpha: f64) -> Result_void;
		pub fn cv_SparseMat_convertTo_const_MatR_int_double_double(instance: *const c_void, m: *mut c_void, rtype: i32, alpha: f64, beta: f64) -> Result_void;
		pub fn cv_SparseMat_assignTo_const_SparseMatR_int(instance: *const c_void, m: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_SparseMat_create_int_const_intX_int(instance: *mut c_void, dims: i32, _sizes: *const i32, _type: i32) -> Result_void;
		pub fn cv_SparseMat_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_addref(instance: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_release(instance: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_elemSize_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_type_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_size_const(instance: *const c_void) -> Result<*const i32>;
		pub fn cv_SparseMat_size_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv_SparseMat_dims_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_SparseMat_nzcount_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_SparseMat_hash_const_int(instance: *const c_void, i0: i32) -> Result<size_t>;
		pub fn cv_SparseMat_hash_const_int_int(instance: *const c_void, i0: i32, i1: i32) -> Result<size_t>;
		pub fn cv_SparseMat_hash_const_int_int_int(instance: *const c_void, i0: i32, i1: i32, i2: i32) -> Result<size_t>;
		pub fn cv_SparseMat_hash_const_const_intX(instance: *const c_void, idx: *const i32) -> Result<size_t>;
		pub fn cv_SparseMat_ptr_int_bool_size_tX(instance: *mut c_void, i0: i32, create_missing: bool, hashval: *mut size_t) -> Result<*mut u8>;
		pub fn cv_SparseMat_ptr_int_int_bool_size_tX(instance: *mut c_void, i0: i32, i1: i32, create_missing: bool, hashval: *mut size_t) -> Result<*mut u8>;
		pub fn cv_SparseMat_ptr_int_int_int_bool_size_tX(instance: *mut c_void, i0: i32, i1: i32, i2: i32, create_missing: bool, hashval: *mut size_t) -> Result<*mut u8>;
		pub fn cv_SparseMat_ptr_const_intX_bool_size_tX(instance: *mut c_void, idx: *const i32, create_missing: bool, hashval: *mut size_t) -> Result<*mut u8>;
		pub fn cv_SparseMat_erase_int_int_size_tX(instance: *mut c_void, i0: i32, i1: i32, hashval: *mut size_t) -> Result_void;
		pub fn cv_SparseMat_erase_int_int_int_size_tX(instance: *mut c_void, i0: i32, i1: i32, i2: i32, hashval: *mut size_t) -> Result_void;
		pub fn cv_SparseMat_erase_const_intX_size_tX(instance: *mut c_void, idx: *const i32, hashval: *mut size_t) -> Result_void;
		pub fn cv_SparseMat_begin(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_begin_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_end(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_end_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMat_node_size_t(instance: *mut c_void, nidx: size_t) -> Result<*mut c_void>;
		pub fn cv_SparseMat_node_const_size_t(instance: *const c_void, nidx: size_t) -> Result<*mut c_void>;
		pub fn cv_SparseMat_newNode_const_intX_size_t(instance: *mut c_void, idx: *const i32, hashval: size_t) -> Result<*mut u8>;
		pub fn cv_SparseMat_removeNode_size_t_size_t_size_t(instance: *mut c_void, hidx: size_t, nidx: size_t, previdx: size_t) -> Result_void;
		pub fn cv_SparseMat_resizeHashTab_size_t(instance: *mut c_void, newsize: size_t) -> Result_void;
		pub fn cv_SparseMat_Hdr_getPropRefcount_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_setPropRefcount_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_getPropDims_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_setPropDims_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_getPropValueOffset_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_setPropValueOffset_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_getPropNodeSize_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_setPropNodeSize_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_getPropNodeCount_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_setPropNodeCount_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_getPropFreeList_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_setPropFreeList_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_getPropPool_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMat_Hdr_setPropPool_vector_unsigned_char_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SparseMat_Hdr_getPropHashtab_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMat_Hdr_setPropHashtab_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_SparseMat_Hdr_getPropSize(instance: *mut c_void) -> *mut [i32; 32];
		pub fn cv_SparseMat_Hdr_Hdr_int_const_intX_int(_dims: i32, _sizes: *const i32, _type: i32) -> Result<*mut c_void>;
		pub fn cv_SparseMat_Hdr_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_SparseMat_Node_getPropHashval_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Node_setPropHashval_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Node_getPropNext_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Node_setPropNext_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Node_getPropIdx(instance: *mut c_void) -> *mut [i32; 32];
		pub fn cv_SparseMatConstIterator_getPropM_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMatConstIterator_getPropHashidx_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMatConstIterator_setPropHashidx_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMatConstIterator_getPropPtr(instance: *mut c_void) -> *mut u8;
		pub fn cv_SparseMatConstIterator_setPropPtr_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator() -> Result<*mut c_void>;
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatX(_m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatConstIteratorR(it: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMatConstIterator_node_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMatConstIterator_seekEnd(instance: *mut c_void) -> Result_void;
		pub fn cv_SparseMatIterator_SparseMatIterator() -> Result<*mut c_void>;
		pub fn cv_SparseMatIterator_SparseMatIterator_SparseMatX(_m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMatIterator_SparseMatIterator_const_SparseMatIteratorR(it: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseMatIterator_node_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_TLSDataContainer_cleanup(instance: *mut c_void) -> Result_void;
		pub fn cv_TermCriteria_TermCriteria() -> Result<core::TermCriteria>;
		pub fn cv_TermCriteria_TermCriteria_int_int_double(typ: i32, max_count: i32, epsilon: f64) -> Result<core::TermCriteria>;
		pub fn cv_TermCriteria_isValid_const(instance: *const core::TermCriteria) -> Result<bool>;
		pub fn cv_TickMeter_TickMeter() -> Result<*mut c_void>;
		pub fn cv_TickMeter_start(instance: *mut c_void) -> Result_void;
		pub fn cv_TickMeter_stop(instance: *mut c_void) -> Result_void;
		pub fn cv_TickMeter_getTimeTicks_const(instance: *const c_void) -> Result<i64>;
		pub fn cv_TickMeter_getTimeMicro_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_getTimeMilli_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_getTimeSec_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_getCounter_const(instance: *const c_void) -> Result<i64>;
		pub fn cv_TickMeter_getFPS_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_getAvgTimeSec_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_getAvgTimeMilli_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_TickMeter_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_UMat_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_getPropDims_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_setPropDims_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_getPropRows_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_setPropRows_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_getPropCols_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_setPropCols_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_getPropUsageFlags_const(instance: *const c_void) -> core::UMatUsageFlags;
		pub fn cv_UMat_setPropUsageFlags_UMatUsageFlags(instance: *mut c_void, val: core::UMatUsageFlags);
		pub fn cv_UMat_getPropU(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMat_setPropU_UMatDataX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_UMat_getPropOffset_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_setPropOffset_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_UMat_getPropSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_UMat_getPropStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_UMat_UMat_UMatUsageFlags(usage_flags: core::UMatUsageFlags) -> *mut c_void;
		pub fn cv_UMat_UMat_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_int_int_int_const_ScalarR_UMatUsageFlags(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_Size_int_const_ScalarR_UMatUsageFlags(size: *const core::Size, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_int_const_intX_int_UMatUsageFlags(ndims: i32, sizes: *const i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_int_const_intX_int_const_ScalarR_UMatUsageFlags(ndims: i32, sizes: *const i32, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_const_UMatR_const_RangeR_const_RangeR(m: *const c_void, row_range: *const c_void, col_range: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_const_UMatR_const_RectR(m: *const c_void, roi: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_UMat_UMat_const_UMatR_const_vector_Range_R(m: *const c_void, ranges: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_getMat_const_AccessFlag(instance: *const c_void, flags: core::AccessFlag) -> Result<*mut c_void>;
		pub fn cv_UMat_row_const_int(instance: *const c_void, y: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_col_const_int(instance: *const c_void, x: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_rowRange_const_const_RangeR(instance: *const c_void, r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_colRange_const_const_RangeR(instance: *const c_void, r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_diag_const_int(instance: *const c_void, d: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_diag_const_UMatR_UMatUsageFlags(d: *const c_void, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_diag_const_UMatR(d: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_copyTo_const_const__OutputArrayR(instance: *const c_void, m: *const c_void) -> Result_void;
		pub fn cv_UMat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, m: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_UMat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, m: *const c_void, rtype: i32, alpha: f64, beta: f64) -> Result_void;
		pub fn cv_UMat_assignTo_const_UMatR_int(instance: *const c_void, m: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_UMat_setTo_const__InputArrayR_const__InputArrayR(instance: *mut c_void, value: *const c_void, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_reshape_const_int_int_const_intX(instance: *const c_void, cn: i32, newndims: i32, newsz: *const i32) -> Result<*mut c_void>;
		pub fn cv_UMat_t_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_inv_const_int(instance: *const c_void, method: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_mul_const_const__InputArrayR_double(instance: *const c_void, m: *const c_void, scale: f64) -> Result<*mut c_void>;
		pub fn cv_UMat_dot_const_const__InputArrayR(instance: *const c_void, m: *const c_void) -> Result<f64>;
		pub fn cv_UMat_zeros_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_zeros_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_zeros_int_const_intX_int_UMatUsageFlags(ndims: i32, sz: *const i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_zeros_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_zeros_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_zeros_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_int_const_intX_int_UMatUsageFlags(ndims: i32, sz: *const i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_ones_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_eye_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_eye_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags) -> Result<*mut c_void>;
		pub fn cv_UMat_eye_int_int_int(rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_eye_Size_int(size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_create_int_int_int_UMatUsageFlags(instance: *mut c_void, rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result_void;
		pub fn cv_UMat_create_Size_int_UMatUsageFlags(instance: *mut c_void, size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags) -> Result_void;
		pub fn cv_UMat_create_int_const_intX_int_UMatUsageFlags(instance: *mut c_void, ndims: i32, sizes: *const i32, typ: i32, usage_flags: core::UMatUsageFlags) -> Result_void;
		pub fn cv_UMat_create_const_vector_int_R_int_UMatUsageFlags(instance: *mut c_void, sizes: *const c_void, typ: i32, usage_flags: core::UMatUsageFlags) -> Result_void;
		pub fn cv_UMat_addref(instance: *mut c_void) -> Result_void;
		pub fn cv_UMat_release(instance: *mut c_void) -> Result_void;
		pub fn cv_UMat_deallocate(instance: *mut c_void) -> Result_void;
		pub fn cv_UMat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point) -> Result_void;
		pub fn cv_UMat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32) -> Result<*mut c_void>;
		pub fn cv_UMat_isContinuous_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_isSubmatrix_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_elemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_UMat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_type_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_step1_const_int(instance: *const c_void, i: i32) -> Result<size_t>;
		pub fn cv_UMat_empty_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_total_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_checkVector_const_int_int_bool(instance: *const c_void, elem_channels: i32, depth: i32, require_continuous: bool) -> Result<i32>;
		pub fn cv_UMat_UMat_UMatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_UMat_handle_const_AccessFlag(instance: *const c_void, access_flags: core::AccessFlag) -> Result<*mut c_void>;
		pub fn cv_UMat_ndoffset_const_size_tX(instance: *const c_void, ofs: *mut size_t) -> Result_void;
		pub fn cv_UMat_updateContinuityFlag(instance: *mut c_void) -> Result_void;
		pub fn cv_UMatData_getPropUrefcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_setPropUrefcount_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_getPropRefcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_setPropRefcount_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_getPropData(instance: *mut c_void) -> *mut u8;
		pub fn cv_UMatData_setPropData_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_UMatData_getPropOrigdata(instance: *mut c_void) -> *mut u8;
		pub fn cv_UMatData_setPropOrigdata_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_UMatData_getPropSize_const(instance: *const c_void) -> size_t;
		pub fn cv_UMatData_setPropSize_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_UMatData_getPropFlags_const(instance: *const c_void) -> core::UMatData_MemoryFlag;
		pub fn cv_UMatData_setPropFlags_MemoryFlag(instance: *mut c_void, val: core::UMatData_MemoryFlag);
		pub fn cv_UMatData_getPropHandle(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_setPropHandle_voidX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_UMatData_getPropUserdata(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_setPropUserdata_voidX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_UMatData_getPropAllocatorFlags__const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_setPropAllocatorFlags__int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_getPropMapcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_setPropMapcount_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_getPropOriginalUMatData(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_setPropOriginalUMatData_UMatDataX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_UMatData_lock(instance: *mut c_void) -> Result_void;
		pub fn cv_UMatData_unlock(instance: *mut c_void) -> Result_void;
		pub fn cv_UMatData_hostCopyObsolete_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_deviceCopyObsolete_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_deviceMemMapped_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_copyOnMap_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_tempUMat_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_tempCopiedUMat_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_UMatData_markHostCopyObsolete_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_UMatData_markDeviceCopyObsolete_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_UMatData_markDeviceMemMapped_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv__InputArray__InputArray() -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_int_voidX(_flags: i32, _obj: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_MatExprR(expr: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_vector_Mat_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_vector_bool_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_doubleR(val: *const f64) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_GpuMatR(d_mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_vector_GpuMat_R(d_mat_array: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_BufferR(buf: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_HostMemR(cuda_mem: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_UMatR(um: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray__InputArray_const_vector_UMat_R(umv: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray_getMat_const_int(instance: *const c_void, idx: i32) -> Result<*mut c_void>;
		pub fn cv__InputArray_getMat__const_int(instance: *const c_void, idx: i32) -> Result<*mut c_void>;
		pub fn cv__InputArray_getUMat_const_int(instance: *const c_void, idx: i32) -> Result<*mut c_void>;
		pub fn cv__InputArray_getMatVector_const_vector_Mat_R(instance: *const c_void, mv: *mut c_void) -> Result_void;
		pub fn cv__InputArray_getUMatVector_const_vector_UMat_R(instance: *const c_void, umv: *mut c_void) -> Result_void;
		pub fn cv__InputArray_getGpuMatVector_const_vector_GpuMat_R(instance: *const c_void, gpumv: *mut c_void) -> Result_void;
		pub fn cv__InputArray_getGpuMat_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray_getOGlBuffer_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray_getFlags_const(instance: *const c_void) -> Result<i32>;
		pub fn cv__InputArray_getObj_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputArray_getSz_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv__InputArray_kind_const(instance: *const c_void) -> Result<core::_InputArray_KindFlag>;
		pub fn cv__InputArray_dims_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_cols_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_rows_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_size_const_int(instance: *const c_void, i: i32) -> Result<core::Size>;
		pub fn cv__InputArray_sizend_const_intX_int(instance: *const c_void, sz: *mut i32, i: i32) -> Result<i32>;
		pub fn cv__InputArray_sameSize_const_const__InputArrayR(instance: *const c_void, arr: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_total_const_int(instance: *const c_void, i: i32) -> Result<size_t>;
		pub fn cv__InputArray_type_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_depth_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_channels_const_int(instance: *const c_void, i: i32) -> Result<i32>;
		pub fn cv__InputArray_isContinuous_const_int(instance: *const c_void, i: i32) -> Result<bool>;
		pub fn cv__InputArray_isSubmatrix_const_int(instance: *const c_void, i: i32) -> Result<bool>;
		pub fn cv__InputArray_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_copyTo_const_const__OutputArrayR(instance: *const c_void, arr: *const c_void) -> Result_void;
		pub fn cv__InputArray_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, arr: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv__InputArray_offset_const_int(instance: *const c_void, i: i32) -> Result<size_t>;
		pub fn cv__InputArray_step_const_int(instance: *const c_void, i: i32) -> Result<size_t>;
		pub fn cv__InputArray_isMat_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isUMat_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isMatVector_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isUMatVector_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isMatx_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isVector_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isGpuMat_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputArray_isGpuMatVector_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__InputOutputArray__InputOutputArray() -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_int_voidX(_flags: i32, _obj: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_MatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_vector_Mat_R(vec: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_GpuMatR(d_mat: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_BufferR(buf: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_HostMemR(cuda_mem: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_UMatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_vector_UMat_R(vec: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_vector_Mat_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_GpuMatR(d_mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_vector_GpuMat_R(d_mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_BufferR(buf: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_HostMemR(cuda_mem: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv__InputOutputArray__InputOutputArray_const_vector_UMat_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray() -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_int_voidX(_flags: i32, _obj: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_MatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_vector_Mat_R(vec: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_GpuMatR(d_mat: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_vector_GpuMat_R(d_mat: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_BufferR(buf: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_HostMemR(cuda_mem: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_UMatR(m: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_vector_UMat_R(vec: *mut c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_vector_Mat_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_GpuMatR(d_mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_BufferR(buf: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_HostMemR(cuda_mem: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray__OutputArray_const_vector_UMat_R(vec: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray_fixedSize_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__OutputArray_fixedType_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__OutputArray_needed_const(instance: *const c_void) -> Result<bool>;
		pub fn cv__OutputArray_getMatRef_const_int(instance: *const c_void, i: i32) -> Result<*mut c_void>;
		pub fn cv__OutputArray_getUMatRef_const_int(instance: *const c_void, i: i32) -> Result<*mut c_void>;
		pub fn cv__OutputArray_getGpuMatRef_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray_getGpuMatVecRef_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray_getOGlBufferRef_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray_getHostMemRef_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv__OutputArray_create_const_Size_int_int_bool_DepthMask(instance: *const c_void, sz: *const core::Size, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask) -> Result_void;
		pub fn cv__OutputArray_create_const_int_int_int_int_bool_DepthMask(instance: *const c_void, rows: i32, cols: i32, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask) -> Result_void;
		pub fn cv__OutputArray_create_const_int_const_intX_int_int_bool_DepthMask(instance: *const c_void, dims: i32, size: *const i32, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask) -> Result_void;
		pub fn cv__OutputArray_createSameSize_const_const__InputArrayR_int(instance: *const c_void, arr: *const c_void, mtype: i32) -> Result_void;
		pub fn cv__OutputArray_release_const(instance: *const c_void) -> Result_void;
		pub fn cv__OutputArray_clear_const(instance: *const c_void) -> Result_void;
		pub fn cv__OutputArray_setTo_const_const__InputArrayR_const__InputArrayR(instance: *const c_void, value: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv__OutputArray_assign_const_const_UMatR(instance: *const c_void, u: *const c_void) -> Result_void;
		pub fn cv__OutputArray_assign_const_const_MatR(instance: *const c_void, m: *const c_void) -> Result_void;
		pub fn cv__OutputArray_assign_const_const_vector_UMat_R(instance: *const c_void, v: *const c_void) -> Result_void;
		pub fn cv__OutputArray_assign_const_const_vector_Mat_R(instance: *const c_void, v: *const c_void) -> Result_void;
		pub fn cv__OutputArray_move_const_UMatR(instance: *const c_void, u: *mut c_void) -> Result_void;
		pub fn cv__OutputArray_move_const_MatR(instance: *const c_void, m: *mut c_void) -> Result_void;
		pub fn cv_cuda_BufferPool_BufferPool_StreamR(stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_BufferPool_getBuffer_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_BufferPool_getBuffer_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_BufferPool_getAllocator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_DeviceInfo_DeviceInfo() -> Result<*mut c_void>;
		pub fn cv_cuda_DeviceInfo_DeviceInfo_int(device_id: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_DeviceInfo_deviceID_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_DeviceInfo_totalGlobalMem_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_sharedMemPerBlock_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_regsPerBlock_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_warpSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_memPitch_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_maxThreadsPerBlock_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxThreadsDim_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxGridSize_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_clockRate_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_totalConstMem_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_majorVersion_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_minorVersion_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_textureAlignment_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_texturePitchAlignment_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_multiProcessorCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_kernelExecTimeoutEnabled_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_integrated_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_canMapHostMemory_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_computeMode_const(instance: *const c_void) -> Result<core::DeviceInfo_ComputeMode>;
		pub fn cv_cuda_DeviceInfo_maxTexture1D_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxTexture1DMipmap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxTexture1DLinear_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxTexture2D_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxTexture2DMipmap_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxTexture2DLinear_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxTexture2DGather_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxTexture3D_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxTextureCubemap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxTexture1DLayered_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxTexture2DLayered_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxTextureCubemapLayered_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxSurface1D_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxSurface2D_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxSurface3D_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxSurface1DLayered_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_maxSurface2DLayered_const(instance: *const c_void) -> Result<core::Vec3i>;
		pub fn cv_cuda_DeviceInfo_maxSurfaceCubemap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxSurfaceCubemapLayered_const(instance: *const c_void) -> Result<core::Vec2i>;
		pub fn cv_cuda_DeviceInfo_surfaceAlignment_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_concurrentKernels_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_ECCEnabled_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_pciBusID_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_pciDeviceID_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_pciDomainID_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_tccDriver_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_asyncEngineCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_unifiedAddressing_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_memoryClockRate_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_memoryBusWidth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_l2CacheSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_maxThreadsPerMultiProcessor_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DeviceInfo_queryMemory_const_size_tR_size_tR(instance: *const c_void, total_memory: *mut size_t, free_memory: *mut size_t) -> Result_void;
		pub fn cv_cuda_DeviceInfo_freeMemory_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_totalMemory_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_DeviceInfo_supports_const_FeatureSet(instance: *const c_void, feature_set: core::FeatureSet) -> Result<bool>;
		pub fn cv_cuda_DeviceInfo_isCompatible_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_Event_Event_CreateFlags(flags: core::Event_CreateFlags) -> Result<*mut c_void>;
		pub fn cv_cuda_Event_record_StreamR(instance: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_Event_queryIfComplete_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_Event_waitForCompletion(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_Event_elapsedTime_const_EventR_const_EventR(start: *const c_void, end: *const c_void) -> Result<f32>;
		pub fn cv_cuda_GpuData_getPropData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuData_setPropData_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_cuda_GpuData_getPropSize_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_GpuData_setPropSize_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_GpuData_GpuData_size_t(_size: size_t) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_getPropRows_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_setPropRows_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_getPropCols_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_setPropCols_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_getPropStep_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_GpuMat_setPropStep_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_GpuMat_getPropData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuMat_setPropData_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_cuda_GpuMat_getPropRefcount(instance: *mut c_void) -> *mut i32;
		pub fn cv_cuda_GpuMat_setPropRefcount_intX(instance: *mut c_void, val: *mut i32);
		pub fn cv_cuda_GpuMat_getPropDatastart(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuMat_setPropDatastart_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_cuda_GpuMat_getPropDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_GpuMat_getPropAllocator(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMat_setPropAllocator_AllocatorX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_GpuMat_defaultAllocator() -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_setDefaultAllocator_AllocatorX(allocator: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_GpuMat_AllocatorX(allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_AllocatorX(rows: i32, cols: i32, typ: i32, allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_AllocatorX(size: *const core::Size, typ: i32, allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_Scalar_AllocatorX(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_Scalar_AllocatorX(size: *const core::Size, typ: i32, s: *const core::Scalar, allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_voidX_size_t(rows: i32, cols: i32, typ: i32, data: *mut c_void, step: size_t) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_voidX_size_t(size: *const core::Size, typ: i32, data: *mut c_void, step: size_t) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR_Range_Range(m: *const c_void, row_range: *mut c_void, col_range: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR_Rect(m: *const c_void, roi: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_GpuMat_const__InputArrayR_AllocatorX(arr: *const c_void, allocator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32) -> Result_void;
		pub fn cv_cuda_GpuMat_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32) -> Result_void;
		pub fn cv_cuda_GpuMat_release(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_swap_GpuMatR(instance: *mut c_void, mat: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_upload_const__InputArrayR(instance: *mut c_void, arr: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_upload_const__InputArrayR_StreamR(instance: *mut c_void, arr: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_download_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_download_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR_StreamR(instance: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_setTo_Scalar(instance: *mut c_void, s: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_setTo_Scalar_StreamR(instance: *mut c_void, s: *const core::Scalar, stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR(instance: *mut c_void, s: *const core::Scalar, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR_StreamR(instance: *mut c_void, s: *const core::Scalar, mask: *const c_void, stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int(instance: *const c_void, dst: *const c_void, rtype: i32) -> Result_void;
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, beta: f64) -> Result_void;
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, beta: f64, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_assignTo_const_GpuMatR_int(instance: *const c_void, m: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_cuda_GpuMat_ptr_int(instance: *mut c_void, y: i32) -> Result<*mut u8>;
		pub fn cv_cuda_GpuMat_ptr_const_int(instance: *const c_void, y: i32) -> Result<*const u8>;
		pub fn cv_cuda_GpuMat_row_const_int(instance: *const c_void, y: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_col_const_int(instance: *const c_void, x: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_rowRange_const_Range(instance: *const c_void, r: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_colRange_const_Range(instance: *const c_void, r: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point) -> Result_void;
		pub fn cv_cuda_GpuMat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_isContinuous_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMat_elemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMat_elemSize1_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMat_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_GpuMat_depth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_GpuMat_channels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_GpuMat_step1_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMat_size_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_GpuMat_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMat_cudaPtr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMat_updateContinuityFlag(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMat_Allocator_allocate_GpuMatX_int_int_size_t(instance: *mut c_void, mat: *mut c_void, rows: i32, cols: i32, elem_size: size_t) -> Result<bool>;
		pub fn cv_cuda_GpuMat_Allocator_free_GpuMatX(instance: *mut c_void, mat: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMatND_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMatND_getPropDims_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMatND_setPropDims_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMatND_getPropSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_setPropSize_SizeArray(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_GpuMatND_getPropStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_setPropStep_StepArray(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_GpuMatND_GpuMatND() -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_GpuMatND_SizeArray_int(size: *mut c_void, typ: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_GpuMatND_SizeArray_int_voidX_StepArray(size: *mut c_void, typ: i32, data: *mut c_void, step: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_create_SizeArray_int(instance: *mut c_void, size: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_cuda_GpuMatND_release(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_swap_GpuMatNDR(instance: *mut c_void, m: *mut c_void);
		pub fn cv_cuda_GpuMatND_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_clone_const_StreamR(instance: *const c_void, stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_createGpuMatHeader_const_IndexArray_Range_Range(instance: *const c_void, idx: *mut c_void, row_range: *mut c_void, col_range: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_createGpuMatHeader_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_operator_cv_cuda_GpuMat_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_GpuMatND_GpuMatND_const_GpuMatNDR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_GpuMatND_GpuMatNDR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_upload_const__InputArrayR(instance: *mut c_void, src: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_upload_const__InputArrayR_StreamR(instance: *mut c_void, src: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_download_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_download_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_GpuMatND_isContinuous_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMatND_isSubmatrix_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMatND_elemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMatND_elemSize1_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMatND_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMatND_external_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_GpuMatND_getDevicePtr_const(instance: *const c_void) -> Result<*mut u8>;
		pub fn cv_cuda_GpuMatND_total_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMatND_totalMemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_GpuMatND_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HostMem_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_getPropRows_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_setPropRows_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_getPropCols_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_setPropCols_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_getPropStep_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_HostMem_setPropStep_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_HostMem_getPropData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_HostMem_setPropData_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_cuda_HostMem_getPropRefcount(instance: *mut c_void) -> *mut i32;
		pub fn cv_cuda_HostMem_setPropRefcount_intX(instance: *mut c_void, val: *mut i32);
		pub fn cv_cuda_HostMem_getPropDatastart(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_HostMem_setPropDatastart_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_cuda_HostMem_getPropDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_HostMem_getPropAlloc_type_const(instance: *const c_void) -> core::HostMem_AllocType;
		pub fn cv_cuda_HostMem_setPropAlloc_type_AllocType(instance: *mut c_void, val: core::HostMem_AllocType);
		pub fn cv_cuda_HostMem_HostMem_AllocType(alloc_type: core::HostMem_AllocType) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_HostMem_const_HostMemR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_HostMem_int_int_int_AllocType(rows: i32, cols: i32, typ: i32, alloc_type: core::HostMem_AllocType) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_HostMem_Size_int_AllocType(size: *const core::Size, typ: i32, alloc_type: core::HostMem_AllocType) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_HostMem_const__InputArrayR_AllocType(arr: *const c_void, alloc_type: core::HostMem_AllocType) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_swap_HostMemR(instance: *mut c_void, b: *mut c_void) -> Result_void;
		pub fn cv_cuda_HostMem_clone_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32) -> Result_void;
		pub fn cv_cuda_HostMem_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32) -> Result_void;
		pub fn cv_cuda_HostMem_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_release(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_HostMem_createMatHeader_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_createGpuMatHeader_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_HostMem_isContinuous_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_HostMem_elemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_HostMem_elemSize1_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_HostMem_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HostMem_depth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HostMem_channels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HostMem_step1_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_HostMem_size_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_HostMem_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_Stream_Stream() -> Result<*mut c_void>;
		pub fn cv_cuda_Stream_Stream_const_Ptr_Allocator_R(allocator: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_Stream_Stream_const_size_t(cuda_flags: size_t) -> Result<*mut c_void>;
		pub fn cv_cuda_Stream_queryIfComplete_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_Stream_waitForCompletion(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_Stream_waitEvent_const_EventR(instance: *mut c_void, event: *const c_void) -> Result_void;
		pub fn cv_cuda_Stream_enqueueHostCallback_StreamCallback_voidX(instance: *mut c_void, callback: Option<unsafe extern "C" fn(i32, *mut c_void) -> ()>, user_data: *mut c_void) -> Result_void;
		pub fn cv_cuda_Stream_Null() -> Result<*mut c_void>;
		pub fn cv_cuda_Stream_cudaPtr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_TargetArchs_builtWith_FeatureSet(feature_set: core::FeatureSet) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_has_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasPtx_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasBin_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasEqualOrLessPtx_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasEqualOrGreater_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasEqualOrGreaterPtx_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_cuda_TargetArchs_hasEqualOrGreaterBin_int_int(major: i32, minor: i32) -> Result<bool>;
		pub fn cv_detail_CheckContext_getPropFunc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_getPropFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_getPropLine_const(instance: *const c_void) -> i32;
		pub fn cv_detail_CheckContext_setPropLine_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_CheckContext_getPropTestOp_const(instance: *const c_void) -> core::Detail_TestOp;
		pub fn cv_detail_CheckContext_setPropTestOp_TestOp(instance: *mut c_void, val: core::Detail_TestOp);
		pub fn cv_detail_CheckContext_getPropMessage_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_getPropP1_str_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_getPropP2_str_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_getPropM_funName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_setPropM_funName_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_instr_NodeData_getPropM_instrType_const(instance: *const c_void) -> core::TYPE;
		pub fn cv_instr_NodeData_setPropM_instrType_TYPE(instance: *mut c_void, val: core::TYPE);
		pub fn cv_instr_NodeData_getPropM_implType_const(instance: *const c_void) -> core::IMPL;
		pub fn cv_instr_NodeData_setPropM_implType_IMPL(instance: *mut c_void, val: core::IMPL);
		pub fn cv_instr_NodeData_getPropM_fileName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_getPropM_lineNum_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_setPropM_lineNum_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_getPropM_retAddress(instance: *mut c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_setPropM_retAddress_voidX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_instr_NodeData_getPropM_alwaysExpand_const(instance: *const c_void) -> bool;
		pub fn cv_instr_NodeData_setPropM_alwaysExpand_bool(instance: *mut c_void, val: bool);
		pub fn cv_instr_NodeData_getPropM_funError_const(instance: *const c_void) -> bool;
		pub fn cv_instr_NodeData_setPropM_funError_bool(instance: *mut c_void, val: bool);
		pub fn cv_instr_NodeData_getPropM_counter_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_setPropM_counter_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_getPropM_ticksTotal_const(instance: *const c_void) -> u64;
		pub fn cv_instr_NodeData_setPropM_ticksTotal_uint64_t(instance: *mut c_void, val: u64);
		pub fn cv_instr_NodeData_getPropM_threads_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_setPropM_threads_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_NodeData_const_charX_const_charX_int_voidX_bool_TYPE_IMPL(fun_name: *const c_char, file_name: *const c_char, line_num: i32, ret_address: *mut c_void, always_expand: bool, instr_type: core::TYPE, impl_type: core::IMPL) -> Result<*mut c_void>;
		pub fn cv_instr_NodeData_NodeData_NodeDataR(ref_: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_instr_NodeData_getTotalMs_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_instr_NodeData_getMeanMs_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_internal_WriteStructContext_WriteStructContext_FileStorageR_const_StringR_int_const_StringR(_fs: *mut c_void, name: *const c_char, flags: i32, type_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_Context() -> *mut c_void;
		pub fn cv_ocl_Context_Context_int(dtype: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_Context_const_ContextR(c: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_Context_ContextR(c: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Context_create(instance: *mut c_void) -> Result<bool>;
		pub fn cv_ocl_Context_create_int(instance: *mut c_void, dtype: i32) -> Result<bool>;
		pub fn cv_ocl_Context_ndevices_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Context_device_const_size_t(instance: *const c_void, idx: size_t) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_getProg_const_ProgramSourceR_const_StringR_StringR(instance: *mut c_void, prog: *const c_void, buildopt: *const c_char, errmsg: *mut *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_unloadProg_ProgramR(instance: *mut c_void, prog: *mut c_void) -> Result_void;
		pub fn cv_ocl_Context_getDefault_bool(initialize: bool) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_getOpenCLContextProperty_const_int(instance: *const c_void, property_id: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_useSVM_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Context_setUseSVM_bool(instance: *mut c_void, enabled: bool) -> Result_void;
		pub fn cv_ocl_Context_fromHandle_voidX(context: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_fromDevice_const_DeviceR(device: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_create_const_stringR(configuration: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_Context_release(instance: *mut c_void) -> Result_void;
		pub fn cv_ocl_Context_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_Device() -> *mut c_void;
		pub fn cv_ocl_Device_Device_voidX(d: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_Device_const_DeviceR(d: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_Device_DeviceR(d: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Device_set_voidX(instance: *mut c_void, d: *mut c_void) -> Result_void;
		pub fn cv_ocl_Device_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_extensions_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_isExtensionSupported_const_const_StringR(instance: *const c_void, extension_name: *const c_char) -> Result<bool>;
		pub fn cv_ocl_Device_version_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_vendorName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_OpenCL_C_Version_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_OpenCLVersion_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_deviceVersionMajor_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_deviceVersionMinor_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_driverVersion_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_addressBits_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_available_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_compilerAvailable_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_linkerAvailable_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_doubleFPConfig_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_singleFPConfig_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_halfFPConfig_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_endianLittle_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_errorCorrectionSupport_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_executionCapabilities_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_globalMemCacheSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_globalMemCacheType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_globalMemCacheLineSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_globalMemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_localMemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_localMemType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_hostUnifiedMemory_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_imageSupport_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_imageFromBufferSupport_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_imagePitchAlignment_const(instance: *const c_void) -> Result<u32>;
		pub fn cv_ocl_Device_imageBaseAddressAlignment_const(instance: *const c_void) -> Result<u32>;
		pub fn cv_ocl_Device_intelSubgroupsSupport_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_image2DMaxWidth_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_image2DMaxHeight_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_image3DMaxWidth_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_image3DMaxHeight_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_image3DMaxDepth_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_imageMaxBufferSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_imageMaxArraySize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_vendorID_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_isAMD_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_isIntel_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_isNVidia_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Device_maxClockFrequency_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxComputeUnits_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxConstantArgs_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxConstantBufferSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_maxMemAllocSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_maxParameterSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_maxReadImageArgs_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxWriteImageArgs_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxSamplers_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxWorkGroupSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_maxWorkItemDims_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_maxWorkItemSizes_const_size_tX(instance: *const c_void, unnamed: *mut size_t) -> Result_void;
		pub fn cv_ocl_Device_memBaseAddrAlign_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthChar_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthShort_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthInt_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthLong_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthFloat_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthDouble_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_nativeVectorWidthHalf_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthChar_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthShort_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthInt_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthLong_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthFloat_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthDouble_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_preferredVectorWidthHalf_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Device_printfBufferSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_profilingTimerResolution_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Device_getDefault() -> Result<*mut c_void>;
		pub fn cv_ocl_Device_fromHandle_voidX(d: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Device_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Image2D_Image2D() -> *mut c_void;
		pub fn cv_ocl_Image2D_Image2D_const_UMatR_bool_bool(src: *const c_void, norm: bool, alias: bool) -> Result<*mut c_void>;
		pub fn cv_ocl_Image2D_Image2D_const_Image2DR(i: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Image2D_Image2D_Image2DR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Image2D_canCreateAlias_const_UMatR(u: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Image2D_isFormatSupported_int_int_bool(depth: i32, cn: i32, norm: bool) -> Result<bool>;
		pub fn cv_ocl_Image2D_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Kernel_Kernel() -> *mut c_void;
		pub fn cv_ocl_Kernel_Kernel_const_charX_const_ProgramR(kname: *const c_char, prog: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Kernel_Kernel_const_charX_const_ProgramSourceR_const_StringR_StringX(kname: *const c_char, prog: *const c_void, buildopts: *const c_char, errmsg: *mut *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Kernel_Kernel_const_KernelR(k: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Kernel_Kernel_KernelR(k: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Kernel_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_create_const_charX_const_ProgramR(instance: *mut c_void, kname: *const c_char, prog: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_create_const_charX_const_ProgramSourceR_const_StringR_StringX(instance: *mut c_void, kname: *const c_char, prog: *const c_void, buildopts: *const c_char, errmsg: *mut *mut c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_set_int_const_voidX_size_t(instance: *mut c_void, i: i32, value: *const c_void, sz: size_t) -> Result<i32>;
		pub fn cv_ocl_Kernel_set_int_const_Image2DR(instance: *mut c_void, i: i32, image_2d: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Kernel_set_int_const_UMatR(instance: *mut c_void, i: i32, m: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Kernel_set_int_const_KernelArgR(instance: *mut c_void, i: i32, arg: *const c_void) -> Result<i32>;
		pub fn cv_ocl_Kernel_run_int_size_tX_size_tX_bool_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, q: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_run__int_size_tX_size_tX_bool_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, q: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_runTask_bool_const_QueueR(instance: *mut c_void, sync: bool, q: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Kernel_runProfiling_int_size_tX_size_tX_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, q: *const c_void) -> Result<i64>;
		pub fn cv_ocl_Kernel_workGroupSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Kernel_preferedWorkGroupSizeMultiple_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Kernel_compileWorkGroupSize_const_size_tX(instance: *const c_void, wsz: *mut size_t) -> Result<bool>;
		pub fn cv_ocl_Kernel_localMemSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_ocl_Kernel_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_getPropFlags_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_setPropFlags_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_getPropM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_KernelArg_setPropM_UMatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_ocl_KernelArg_getPropObj_const(instance: *const c_void) -> *const c_void;
		pub fn cv_ocl_KernelArg_getPropSz_const(instance: *const c_void) -> size_t;
		pub fn cv_ocl_KernelArg_setPropSz_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_ocl_KernelArg_getPropWscale_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_setPropWscale_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_getPropIwscale_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_setPropIwscale_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_KernelArg_int_UMatX_int_int_const_voidX_size_t(_flags: i32, _m: *mut c_void, wscale: i32, iwscale: i32, _obj: *const c_void, _sz: size_t) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_KernelArg() -> *mut c_void;
		pub fn cv_ocl_KernelArg_Local_size_t(local_mem_size: size_t) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_PtrWriteOnly_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_PtrReadOnly_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_PtrReadWrite_const_UMatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_ReadWrite_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_ReadWriteNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_ReadOnly_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_WriteOnly_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_ReadOnlyNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_WriteOnlyNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32) -> Result<*mut c_void>;
		pub fn cv_ocl_KernelArg_Constant_const_MatR(m: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext() -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_const_OpenCLExecutionContextR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_OpenCLExecutionContextR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_getContext_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_getDevice_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_getQueue_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_useOpenCL_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_OpenCLExecutionContext_setUseOpenCL_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_ocl_OpenCLExecutionContext_getCurrent() -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_getCurrentRef() -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_bind_const(instance: *const c_void) -> Result_void;
		pub fn cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const_const_QueueR(instance: *const c_void, q: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_create_const_stringR_voidX_voidX_voidX(platform_name: *const c_char, platform_id: *mut c_void, context: *mut c_void, device_id: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR_const_QueueR(context: *const c_void, device: *const c_void, queue: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR(context: *const c_void, device: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_OpenCLExecutionContext_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_OpenCLExecutionContext_release(instance: *mut c_void) -> Result_void;
		pub fn cv_ocl_Platform_Platform() -> *mut c_void;
		pub fn cv_ocl_Platform_Platform_const_PlatformR(p: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Platform_Platform_PlatformR(p: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Platform_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Platform_getDefault() -> Result<*mut c_void>;
		pub fn cv_ocl_Platform_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_PlatformInfo_PlatformInfo() -> *mut c_void;
		pub fn cv_ocl_PlatformInfo_PlatformInfo_voidX(id: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_PlatformInfo_PlatformInfo_const_PlatformInfoR(i: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_PlatformInfo_PlatformInfo_PlatformInfoR(i: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_PlatformInfo_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_PlatformInfo_vendor_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_PlatformInfo_version_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_PlatformInfo_versionMajor_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_PlatformInfo_versionMinor_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_PlatformInfo_deviceNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ocl_PlatformInfo_getDevice_const_DeviceR_int(instance: *const c_void, device: *mut c_void, d: i32) -> Result_void;
		pub fn cv_ocl_PlatformInfo_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Program_Program() -> *mut c_void;
		pub fn cv_ocl_Program_Program_const_ProgramSourceR_const_StringR_StringR(src: *const c_void, buildflags: *const c_char, errmsg: *mut *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Program_Program_const_ProgramR(prog: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Program_Program_ProgramR(prog: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Program_create_const_ProgramSourceR_const_StringR_StringR(instance: *mut c_void, src: *const c_void, buildflags: *const c_char, errmsg: *mut *mut c_void) -> Result<bool>;
		pub fn cv_ocl_Program_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Program_getBinary_const_vector_char_R(instance: *const c_void, binary: *mut c_void) -> Result_void;
		pub fn cv_ocl_Program_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Program_read_const_StringR_const_StringR(instance: *mut c_void, buf: *const c_char, buildflags: *const c_char) -> Result<bool>;
		pub fn cv_ocl_Program_write_const_StringR(instance: *const c_void, buf: *mut *mut c_void) -> Result<bool>;
		pub fn cv_ocl_Program_source_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Program_getPrefix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Program_getPrefix_const_StringR(buildflags: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_ProgramSource() -> *mut c_void;
		pub fn cv_ocl_ProgramSource_ProgramSource_const_StringR_const_StringR_const_StringR_const_StringR(module: *const c_char, name: *const c_char, code_str: *const c_char, code_hash: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_ProgramSource_const_StringR(prog: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_ProgramSource_const_ProgramSourceR(prog: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_ProgramSource_ProgramSourceR(prog: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_ProgramSource_source_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_hash_const(instance: *const c_void) -> Result<core::ProgramSource_hash_t>;
		pub fn cv_ocl_ProgramSource_fromBinary_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, build_options: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_fromSPIR_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, build_options: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ocl_ProgramSource_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Queue_Queue() -> *mut c_void;
		pub fn cv_ocl_Queue_Queue_const_ContextR_const_DeviceR(c: *const c_void, d: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Queue_Queue_const_QueueR(q: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Queue_Queue_QueueR(q: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Queue_create_const_ContextR_const_DeviceR(instance: *mut c_void, c: *const c_void, d: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Queue_finish(instance: *mut c_void) -> Result_void;
		pub fn cv_ocl_Queue_ptr_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Queue_getDefault() -> Result<*mut c_void>;
		pub fn cv_ocl_Queue_getProfilingQueue_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Queue_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ocl_Timer_Timer_const_QueueR(q: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ocl_Timer_start(instance: *mut c_void) -> Result_void;
		pub fn cv_ocl_Timer_stop(instance: *mut c_void) -> Result_void;
		pub fn cv_ocl_Timer_durationNS_const(instance: *const c_void) -> Result<u64>;
		pub fn cv_ogl_Arrays_Arrays() -> Result<*mut c_void>;
		pub fn cv_ogl_Arrays_setVertexArray_const__InputArrayR(instance: *mut c_void, vertex: *const c_void) -> Result_void;
		pub fn cv_ogl_Arrays_resetVertexArray(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Arrays_setColorArray_const__InputArrayR(instance: *mut c_void, color: *const c_void) -> Result_void;
		pub fn cv_ogl_Arrays_resetColorArray(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Arrays_setNormalArray_const__InputArrayR(instance: *mut c_void, normal: *const c_void) -> Result_void;
		pub fn cv_ogl_Arrays_resetNormalArray(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Arrays_setTexCoordArray_const__InputArrayR(instance: *mut c_void, tex_coord: *const c_void) -> Result_void;
		pub fn cv_ogl_Arrays_resetTexCoordArray(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Arrays_release(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Arrays_setAutoRelease_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_ogl_Arrays_bind_const(instance: *const c_void) -> Result_void;
		pub fn cv_ogl_Arrays_size_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Arrays_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ogl_Buffer_Buffer() -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_Buffer_int_int_int_unsigned_int_bool(arows: i32, acols: i32, atype: i32, abuf_id: u32, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_Buffer_Size_int_unsigned_int_bool(asize: *const core::Size, atype: i32, abuf_id: u32, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_Buffer_int_int_int_Target_bool(arows: i32, acols: i32, atype: i32, target: core::Buffer_Target, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_Buffer_Size_int_Target_bool(asize: *const core::Size, atype: i32, target: core::Buffer_Target, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_Buffer_const__InputArrayR_Target_bool(arr: *const c_void, target: core::Buffer_Target, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_create_int_int_int_Target_bool(instance: *mut c_void, arows: i32, acols: i32, atype: i32, target: core::Buffer_Target, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Buffer_create_Size_int_Target_bool(instance: *mut c_void, asize: *const core::Size, atype: i32, target: core::Buffer_Target, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Buffer_release(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Buffer_setAutoRelease_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR_Target_bool(instance: *mut c_void, arr: *const c_void, target: core::Buffer_Target, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR_StreamR_Target_bool(instance: *mut c_void, arr: *const c_void, stream: *mut c_void, target: core::Buffer_Target, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Buffer_copyTo_const_const__OutputArrayR(instance: *const c_void, arr: *const c_void) -> Result_void;
		pub fn cv_ogl_Buffer_copyTo_const_const__OutputArrayR_StreamR(instance: *const c_void, arr: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_ogl_Buffer_clone_const_Target_bool(instance: *const c_void, target: core::Buffer_Target, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_bind_const_Target(instance: *const c_void, target: core::Buffer_Target) -> Result_void;
		pub fn cv_ogl_Buffer_unbind_Target(target: core::Buffer_Target) -> Result_void;
		pub fn cv_ogl_Buffer_mapHost_Access(instance: *mut c_void, access: core::Buffer_Access) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_unmapHost(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Buffer_mapDevice(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_unmapDevice(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Buffer_mapDevice_StreamR(instance: *mut c_void, stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ogl_Buffer_unmapDevice_StreamR(instance: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_ogl_Buffer_rows_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_cols_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_size_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_ogl_Buffer_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ogl_Buffer_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_depth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_channels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_elemSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_elemSize1_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Buffer_bufId_const(instance: *const c_void) -> Result<u32>;
		pub fn cv_ogl_Texture2D_Texture2D() -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format_unsigned_int_bool(arows: i32, acols: i32, aformat: core::Texture2D_Format, atex_id: u32, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format_unsigned_int_bool(asize: *const core::Size, aformat: core::Texture2D_Format, atex_id: u32, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format_bool(arows: i32, acols: i32, aformat: core::Texture2D_Format, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format_bool(asize: *const core::Size, aformat: core::Texture2D_Format, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_Texture2D_const__InputArrayR_bool(arr: *const c_void, auto_release: bool) -> Result<*mut c_void>;
		pub fn cv_ogl_Texture2D_create_int_int_Format_bool(instance: *mut c_void, arows: i32, acols: i32, aformat: core::Texture2D_Format, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Texture2D_create_Size_Format_bool(instance: *mut c_void, asize: *const core::Size, aformat: core::Texture2D_Format, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Texture2D_release(instance: *mut c_void) -> Result_void;
		pub fn cv_ogl_Texture2D_setAutoRelease_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_ogl_Texture2D_copyFrom_const__InputArrayR_bool(instance: *mut c_void, arr: *const c_void, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Texture2D_copyTo_const_const__OutputArrayR_int_bool(instance: *const c_void, arr: *const c_void, ddepth: i32, auto_release: bool) -> Result_void;
		pub fn cv_ogl_Texture2D_bind_const(instance: *const c_void) -> Result_void;
		pub fn cv_ogl_Texture2D_rows_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Texture2D_cols_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ogl_Texture2D_size_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_ogl_Texture2D_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ogl_Texture2D_format_const(instance: *const c_void) -> Result<core::Texture2D_Format>;
		pub fn cv_ogl_Texture2D_texId_const(instance: *const c_void) -> Result<u32>;
		pub fn cv_utils_logging_LogTag_getPropName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_utils_logging_LogTag_getPropLevel_const(instance: *const c_void) -> core::LogLevel;
		pub fn cv_utils_logging_LogTag_setPropLevel_LogLevel(instance: *mut c_void, val: core::LogLevel);
		pub fn cv_utils_logging_LogTag_LogTag_const_charX_LogLevel(_name: *const c_char, _level: core::LogLevel) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_core)]
pub use core_sys::*;

#[cfg(ocvrs_has_module_cudaarithm)]
mod cudaarithm_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_absSum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void) -> Result<core::Scalar>;
		pub fn cv_cuda_abs_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int_StreamR(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcAbsSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcNormDiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, norm_type: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcNorm_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, norm_type: i32, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcSqrSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, cmpop: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_countNonZero_const__InputArrayR(src: *const c_void) -> Result<i32>;
		pub fn cv_cuda_countNonZero_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_createConvolution_Size(user_block_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_cuda_createDFT_Size_int(dft_size: *const core::Size, flags: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createLookUpTable_const__InputArrayR(lut: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_dft_const__InputArrayR_const__OutputArrayR_Size_int_StreamR(src: *const c_void, dst: *const c_void, dft_size: *const core::Size, flags: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_exp_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_findMinMaxLoc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, min_max_vals: *const c_void, loc: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_findMinMax_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_flip_const__InputArrayR_const__OutputArrayR_int_StreamR(src: *const c_void, dst: *const c_void, flip_code: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, flags: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_inRange_const__InputArrayR_const_ScalarR_const_ScalarR_const__OutputArrayR_StreamR(src: *const c_void, lowerb: *const core::Scalar, upperb: *const core::Scalar, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_integral_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, sum: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_log_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar__int__const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__OutputArrayR_StreamR(xy: *const c_void, magnitude: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_magnitude_const__InputArrayR_const__OutputArrayR_StreamR(xy: *const c_void, magnitude: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_meanStdDev_const__InputArrayR_ScalarR_ScalarR(mtx: *const c_void, mean: *mut core::Scalar, stddev: *mut core::Scalar) -> Result_void;
		pub fn cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR_StreamR(mtx: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_merge_const_GpuMatX_size_t_const__OutputArrayR_StreamR(src: *const c_void, n: size_t, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_merge_const_vector_GpuMat_R_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_loc: *mut core::Point, max_loc: *mut core::Point, mask: *const c_void) -> Result_void;
		pub fn cv_cuda_minMax_const__InputArrayR_doubleX_doubleX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, mask: *const c_void) -> Result_void;
		pub fn cv_cuda_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_mulAndScaleSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_float_bool_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, scale: f32, conj_b: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, conj_b: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_norm_const__InputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, norm_type: i32) -> Result<f64>;
		pub fn cv_cuda_norm_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, norm_type: i32, mask: *const c_void) -> Result<f64>;
		pub fn cv_cuda_normalize_const__InputArrayR_const__OutputArrayR_double_double_int_int_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, norm_type: i32, dtype: i32, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(x: *const c_void, y: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, angle_in_degrees: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_pow_const__InputArrayR_double_const__OutputArrayR_StreamR(src: *const c_void, power: f64, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_rectStdDev_const__InputArrayR_const__InputArrayR_const__OutputArrayR_Rect_StreamR(src: *const c_void, sqr: *const c_void, dst: *const c_void, rect: *const core::Rect, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_reduce_const__InputArrayR_const__OutputArrayR_int_int_int_StreamR(mtx: *const c_void, vec: *const c_void, dim: i32, reduce_op: i32, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar__int__const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_split_const__InputArrayR_GpuMatX_StreamR(src: *const c_void, dst: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_split_const__InputArrayR_vector_GpuMat_R_StreamR(src: *const c_void, dst: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_sqrIntegral_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, sqsum: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_sqrSum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void) -> Result<core::Scalar>;
		pub fn cv_cuda_sqr_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_sqrt_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_sum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void) -> Result<core::Scalar>;
		pub fn cv_cuda_threshold_const__InputArrayR_const__OutputArrayR_double_double_int_StreamR(src: *const c_void, dst: *const c_void, thresh: f64, maxval: f64, typ: i32, stream: *mut c_void) -> Result<f64>;
		pub fn cv_cuda_transpose_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_Convolution_convolve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, ccorr: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DFT_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, result: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_LookUpTable_transform_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudaarithm)]
pub use cudaarithm_sys::*;

#[cfg(ocvrs_has_module_cudabgsegm)]
mod cudabgsegm_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_createBackgroundSubtractorMOG2_int_double_bool(history: i32, var_threshold: f64, detect_shadows: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_createBackgroundSubtractorMOG_int_int_double_double(history: i32, nmixtures: i32, background_ratio: f64, noise_sigma: f64) -> Result<*mut c_void>;
		pub fn cv_cuda_BackgroundSubtractorMOG_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_const_const__OutputArrayR_StreamR(instance: *const c_void, background_image: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_GpuMatR_StreamR(instance: *mut c_void, background_image: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getHistory_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_BackgroundSubtractorMOG_setHistory_int(instance: *mut c_void, nframes: i32) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getNMixtures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_BackgroundSubtractorMOG_setNMixtures_int(instance: *mut c_void, nmix: i32) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundRatio_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_BackgroundSubtractorMOG_setBackgroundRatio_double(instance: *mut c_void, background_ratio: f64) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_getNoiseSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_BackgroundSubtractorMOG_setNoiseSigma_double(instance: *mut c_void, noise_sigma: f64) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_const_const__OutputArrayR_StreamR(instance: *const c_void, background_image: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_GpuMatR_StreamR(instance: *mut c_void, background_image: *mut c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudabgsegm)]
pub use cudabgsegm_sys::*;

#[cfg(ocvrs_has_module_cudacodec)]
mod cudacodec_sys {
	use super::*;

	extern "C" {
		pub fn cv_cudacodec_createVideoReader_const_Ptr_RawVideoSource_R(source: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cudacodec_createVideoReader_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_SurfaceFormat(encoder_callback: *const c_void, frame_size: *const core::Size, fps: f64, format: crate::cudacodec::SurfaceFormat) -> Result<*mut c_void>;
		pub fn cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_const_EncoderParamsR_SurfaceFormat(encoder_callback: *const c_void, frame_size: *const core::Size, fps: f64, params: *const c_void, format: crate::cudacodec::SurfaceFormat) -> Result<*mut c_void>;
		pub fn cv_cudacodec_createVideoWriter_const_StringR_Size_double_SurfaceFormat(file_name: *const c_char, frame_size: *const core::Size, fps: f64, format: crate::cudacodec::SurfaceFormat) -> Result<*mut c_void>;
		pub fn cv_cudacodec_createVideoWriter_const_StringR_Size_double_const_EncoderParamsR_SurfaceFormat(file_name: *const c_char, frame_size: *const core::Size, fps: f64, params: *const c_void, format: crate::cudacodec::SurfaceFormat) -> Result<*mut c_void>;
		pub fn cv_cudacodec_EncoderCallBack_acquireBitStream_intX(instance: *mut c_void, buffer_size: *mut i32) -> Result<*mut u8>;
		pub fn cv_cudacodec_EncoderCallBack_releaseBitStream_unsigned_charX_int(instance: *mut c_void, data: *mut u8, size: i32) -> Result_void;
		pub fn cv_cudacodec_EncoderCallBack_onBeginFrame_int_PicType(instance: *mut c_void, frame_number: i32, pic_type: crate::cudacodec::EncoderCallBack_PicType) -> Result_void;
		pub fn cv_cudacodec_EncoderCallBack_onEndFrame_int_PicType(instance: *mut c_void, frame_number: i32, pic_type: crate::cudacodec::EncoderCallBack_PicType) -> Result_void;
		pub fn cv_cudacodec_EncoderParams_getPropP_Interval_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropP_Interval_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropIDR_Period_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropIDR_Period_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropDynamicGOP_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropDynamicGOP_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropRCType_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropRCType_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropAvgBitrate_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropAvgBitrate_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropPeakBitrate_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropPeakBitrate_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropQP_Level_Intra_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropQP_Level_Intra_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropQP_Level_InterP_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropQP_Level_InterP_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropQP_Level_InterB_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropQP_Level_InterB_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropDeblockMode_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropDeblockMode_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropProfileLevel_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropProfileLevel_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropForceIntra_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropForceIntra_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropForceIDR_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropForceIDR_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropClearStat_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropClearStat_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropDIMode_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropDIMode_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropPresets_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropPresets_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropDisableCabac_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropDisableCabac_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropNaluFramingType_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropNaluFramingType_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_getPropDisableSPSPPS_const(instance: *const c_void) -> i32;
		pub fn cv_cudacodec_EncoderParams_setPropDisableSPSPPS_int(instance: *mut c_void, val: i32);
		pub fn cv_cudacodec_EncoderParams_EncoderParams() -> Result<*mut c_void>;
		pub fn cv_cudacodec_EncoderParams_EncoderParams_const_StringR(config_file: *const c_char) -> Result<*mut c_void>;
		pub fn cv_cudacodec_EncoderParams_load_const_StringR(instance: *mut c_void, config_file: *const c_char) -> Result_void;
		pub fn cv_cudacodec_EncoderParams_save_const_const_StringR(instance: *const c_void, config_file: *const c_char) -> Result_void;
		pub fn cv_cudacodec_RawVideoSource_getNextPacket_unsigned_charXX_size_tX(instance: *mut c_void, data: *mut *mut u8, size: *mut size_t) -> Result<bool>;
		pub fn cv_cudacodec_RawVideoSource_format_const(instance: *const c_void) -> Result<crate::cudacodec::FormatInfo>;
		pub fn cv_cudacodec_RawVideoSource_updateFormat_const_int_const_int(instance: *mut c_void, coded_width: i32, coded_height: i32) -> Result_void;
		pub fn cv_cudacodec_VideoReader_nextFrame_GpuMatR_StreamR(instance: *mut c_void, frame: *mut c_void, stream: *mut c_void) -> Result<bool>;
		pub fn cv_cudacodec_VideoReader_format_const(instance: *const c_void) -> Result<crate::cudacodec::FormatInfo>;
		pub fn cv_cudacodec_VideoWriter_write_const__InputArrayR_bool(instance: *mut c_void, frame: *const c_void, last_frame: bool) -> Result_void;
		pub fn cv_cudacodec_VideoWriter_getEncoderParams_const(instance: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_cudacodec)]
pub use cudacodec_sys::*;

#[cfg(ocvrs_has_module_cudafeatures2d)]
mod cudafeatures2d_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_DescriptorMatcher_createBFMatcher_int(norm_type: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_DescriptorMatcher_isMaskSupported_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DescriptorMatcher_add_const_vector_GpuMat_R(instance: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_getTrainDescriptors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_DescriptorMatcher_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DescriptorMatcher_train(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_const__InputArrayR_vector_DMatch_R_const__InputArrayR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_vector_DMatch_R_const_vector_GpuMat_R(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__OutputArrayR_const_vector_GpuMat_R_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, masks: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_matchConvert_const__InputArrayR_vector_DMatch_R(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_vector_vector_DMatch__R_int_const_vector_GpuMat_R_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, k: i32, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__OutputArrayR_int_const_vector_GpuMat_R_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, k: i32, masks: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_knnMatchConvert_const__InputArrayR_vector_vector_DMatch__R_bool(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_vector_vector_DMatch__R_float_const_vector_GpuMat_R_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, max_distance: f32, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__OutputArrayR_float_const_vector_GpuMat_R_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, max_distance: f32, masks: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DescriptorMatcher_radiusMatchConvert_const__InputArrayR_vector_vector_DMatch__R_bool(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, compact_result: bool) -> Result_void;
		pub fn cv_cuda_FastFeatureDetector_create_int_bool_int_int(threshold: i32, nonmax_suppression: bool, typ: i32, max_npoints: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_FastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32) -> Result_void;
		pub fn cv_cuda_FastFeatureDetector_setMaxNumPoints_int(instance: *mut c_void, max_npoints: i32) -> Result_void;
		pub fn cv_cuda_FastFeatureDetector_getMaxNumPoints_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_Feature2DAsync_detectAsync_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_Feature2DAsync_computeAsync_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, descriptors: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_Feature2DAsync_detectAndComputeAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *const c_void, descriptors: *const c_void, use_provided_keypoints: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_Feature2DAsync_convert_const__InputArrayR_vector_KeyPoint_R(instance: *mut c_void, gpu_keypoints: *const c_void, keypoints: *mut c_void) -> Result_void;
		pub fn cv_cuda_ORB_create_int_float_int_int_int_int_int_int_int_bool(nfeatures: i32, scale_factor: f32, nlevels: i32, edge_threshold: i32, first_level: i32, wta_k: i32, score_type: i32, patch_size: i32, fast_threshold: i32, blur_for_descriptor: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_ORB_setBlurForDescriptor_bool(instance: *mut c_void, blur_for_descriptor: bool) -> Result_void;
		pub fn cv_cuda_ORB_getBlurForDescriptor_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_ORB_setFastThreshold_int(instance: *mut c_void, fast_threshold: i32) -> Result_void;
		pub fn cv_cuda_ORB_getFastThreshold_const(instance: *const c_void) -> Result<i32>;
	}
}
#[cfg(ocvrs_has_module_cudafeatures2d)]
pub use cudafeatures2d_sys::*;

#[cfg(ocvrs_has_module_cudafilters)]
mod cudafilters_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_createBoxFilter_int_int_Size_Point_int_Scalar(src_type: i32, dst_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createBoxMaxFilter_int_Size_Point_int_Scalar(src_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createBoxMinFilter_int_Size_Point_int_Scalar(src_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createColumnSumFilter_int_int_int_int_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, anchor: i32, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createDerivFilter_int_int_int_int_int_bool_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ksize: i32, normalize: bool, scale: f64, row_border_mode: i32, column_border_mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createGaussianFilter_int_int_Size_double_double_int_int(src_type: i32, dst_type: i32, ksize: *const core::Size, sigma1: f64, sigma2: f64, row_border_mode: i32, column_border_mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createLaplacianFilter_int_int_int_double_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, scale: f64, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createLinearFilter_int_int_const__InputArrayR_Point_int_Scalar(src_type: i32, dst_type: i32, kernel: *const c_void, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createMedianFilter_int_int_int(src_type: i32, window_size: i32, partition: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createMorphologyFilter_int_int_const__InputArrayR_Point_int(op: i32, src_type: i32, kernel: *const c_void, anchor: *const core::Point, iterations: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createRowSumFilter_int_int_int_int_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, anchor: i32, border_mode: i32, border_val: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_cuda_createScharrFilter_int_int_int_int_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, scale: f64, row_border_mode: i32, column_border_mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createSeparableLinearFilter_int_int_const__InputArrayR_const__InputArrayR_Point_int_int(src_type: i32, dst_type: i32, row_kernel: *const c_void, column_kernel: *const c_void, anchor: *const core::Point, row_border_mode: i32, column_border_mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createSobelFilter_int_int_int_int_int_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ksize: i32, scale: f64, row_border_mode: i32, column_border_mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_Filter_apply_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudafilters)]
pub use cudafilters_sys::*;

#[cfg(ocvrs_has_module_cudaimgproc)]
mod cudaimgproc_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_alphaComp_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(img1: *const c_void, img2: *const c_void, dst: *const c_void, alpha_op: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_bilateralFilter_const__InputArrayR_const__OutputArrayR_int_float_float_int_StreamR(src: *const c_void, dst: *const c_void, kernel_size: i32, sigma_color: f32, sigma_spatial: f32, border_mode: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_blendLinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(img1: *const c_void, img2: *const c_void, weights1: *const c_void, weights2: *const c_void, result: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcHist_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, mask: *const c_void, hist: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_calcHist_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, hist: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_createCLAHE_double_Size(clip_limit: f64, tile_grid_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_cuda_createCannyEdgeDetector_double_double_int_bool(low_thresh: f64, high_thresh: f64, apperture_size: i32, l2gradient: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_createGeneralizedHoughBallard() -> Result<*mut c_void>;
		pub fn cv_cuda_createGeneralizedHoughGuil() -> Result<*mut c_void>;
		pub fn cv_cuda_createGoodFeaturesToTrackDetector_int_int_double_double_int_bool_double(src_type: i32, max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, use_harris_detector: bool, harris_k: f64) -> Result<*mut c_void>;
		pub fn cv_cuda_createHarrisCorner_int_int_int_double_int(src_type: i32, block_size: i32, ksize: i32, k: f64, border_type: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createHoughCirclesDetector_float_float_int_int_int_int_int(dp: f32, min_dist: f32, canny_threshold: i32, votes_threshold: i32, min_radius: i32, max_radius: i32, max_circles: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createHoughLinesDetector_float_float_int_bool_int(rho: f32, theta: f32, threshold: i32, do_sort: bool, max_lines: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createHoughSegmentDetector_float_float_int_int_int(rho: f32, theta: f32, min_line_length: i32, max_line_gap: i32, max_lines: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createMinEigenValCorner_int_int_int_int(src_type: i32, block_size: i32, ksize: i32, border_type: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createTemplateMatching_int_int_Size(src_type: i32, method: i32, user_block_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_cuda_cvtColor_const__InputArrayR_const__OutputArrayR_int_int_StreamR(src: *const c_void, dst: *const c_void, code: i32, dcn: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_demosaicing_const__InputArrayR_const__OutputArrayR_int_int_StreamR(src: *const c_void, dst: *const c_void, code: i32, dcn: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_equalizeHist_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_evenLevels_const__OutputArrayR_int_int_int_StreamR(levels: *const c_void, n_levels: i32, lower_level: i32, upper_level: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_gammaCorrection_const__InputArrayR_const__OutputArrayR_bool_StreamR(src: *const c_void, dst: *const c_void, forward: bool, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_histEven_const__InputArrayR_const__OutputArrayR_int_int_int_StreamR(src: *const c_void, hist: *const c_void, hist_size: i32, lower_level: i32, upper_level: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_histRange_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, hist: *const c_void, levels: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_meanShiftFiltering_const__InputArrayR_const__OutputArrayR_int_int_TermCriteria_StreamR(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, criteria: *const core::TermCriteria, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_meanShiftProc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_TermCriteria_StreamR(src: *const c_void, dstr: *const c_void, dstsp: *const c_void, sp: i32, sr: i32, criteria: *const core::TermCriteria, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_meanShiftSegmentation_const__InputArrayR_const__OutputArrayR_int_int_int_TermCriteria_StreamR(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, minsize: i32, criteria: *const core::TermCriteria, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_swapChannels_const__InputOutputArrayR_const_intXX_StreamR(image: *const c_void, dst_order: *const [i32; 4], stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CLAHE_apply_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, edges: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, dx: *const c_void, dy: *const c_void, edges: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_setLowThreshold_double(instance: *mut c_void, low_thresh: f64) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_getLowThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_CannyEdgeDetector_setHighThreshold_double(instance: *mut c_void, high_thresh: f64) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_getHighThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_CannyEdgeDetector_setAppertureSize_int(instance: *mut c_void, apperture_size: i32) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_getAppertureSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_CannyEdgeDetector_setL2Gradient_bool(instance: *mut c_void, l2gradient: bool) -> Result_void;
		pub fn cv_cuda_CannyEdgeDetector_getL2Gradient_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_CornernessCriteria_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CornersDetector_detect_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, image: *const c_void, corners: *const c_void, mask: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, circles: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_setDp_float(instance: *mut c_void, dp: f32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getDp_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughCirclesDetector_setMinDist_float(instance: *mut c_void, min_dist: f32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getMinDist_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughCirclesDetector_setCannyThreshold_int(instance: *mut c_void, canny_threshold: i32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getCannyThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughCirclesDetector_setVotesThreshold_int(instance: *mut c_void, votes_threshold: i32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getVotesThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughCirclesDetector_setMinRadius_int(instance: *mut c_void, min_radius: i32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getMinRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughCirclesDetector_setMaxRadius_int(instance: *mut c_void, max_radius: i32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getMaxRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughCirclesDetector_setMaxCircles_int(instance: *mut c_void, max_circles: i32) -> Result_void;
		pub fn cv_cuda_HoughCirclesDetector_getMaxCircles_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughLinesDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, lines: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_downloadResults_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, d_lines: *const c_void, h_lines: *const c_void, h_votes: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_setRho_float(instance: *mut c_void, rho: f32) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_getRho_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughLinesDetector_setTheta_float(instance: *mut c_void, theta: f32) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_getTheta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughLinesDetector_setThreshold_int(instance: *mut c_void, threshold: i32) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_getThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughLinesDetector_setDoSort_bool(instance: *mut c_void, do_sort: bool) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_getDoSort_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_HoughLinesDetector_setMaxLines_int(instance: *mut c_void, max_lines: i32) -> Result_void;
		pub fn cv_cuda_HoughLinesDetector_getMaxLines_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughSegmentDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, lines: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_setRho_float(instance: *mut c_void, rho: f32) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_getRho_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughSegmentDetector_setTheta_float(instance: *mut c_void, theta: f32) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_getTheta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_cuda_HoughSegmentDetector_setMinLineLength_int(instance: *mut c_void, min_line_length: i32) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_getMinLineLength_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughSegmentDetector_setMaxLineGap_int(instance: *mut c_void, max_line_gap: i32) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_getMaxLineGap_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HoughSegmentDetector_setMaxLines_int(instance: *mut c_void, max_lines: i32) -> Result_void;
		pub fn cv_cuda_HoughSegmentDetector_getMaxLines_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_TemplateMatching_match_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudaimgproc)]
pub use cudaimgproc_sys::*;

#[cfg(ocvrs_has_module_cudaobjdetect)]
mod cudaobjdetect_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_CascadeClassifier_create_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_cuda_CascadeClassifier_create_const_FileStorageR(file: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_CascadeClassifier_setMaxObjectSize_Size(instance: *mut c_void, max_object_size: *const core::Size) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getMaxObjectSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_CascadeClassifier_setMinObjectSize_Size(instance: *mut c_void, min_size: *const core::Size) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getMinObjectSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_CascadeClassifier_setScaleFactor_double(instance: *mut c_void, scale_factor: f64) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getScaleFactor_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_CascadeClassifier_setMinNeighbors_int(instance: *mut c_void, min_neighbors: i32) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getMinNeighbors_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_CascadeClassifier_setFindLargestObject_bool(instance: *mut c_void, find_largest_object: bool) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getFindLargestObject(instance: *mut c_void) -> Result<bool>;
		pub fn cv_cuda_CascadeClassifier_setMaxNumObjects_int(instance: *mut c_void, max_num_objects: i32) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_getMaxNumObjects_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_CascadeClassifier_getClassifierSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_CascadeClassifier_detectMultiScale_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, objects: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_CascadeClassifier_convert_const__OutputArrayR_vector_Rect_R(instance: *mut c_void, gpu_objects: *const c_void, objects: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_create_Size_Size_Size_Size_int(win_size: *const core::Size, block_size: *const core::Size, block_stride: *const core::Size, cell_size: *const core::Size, nbins: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_HOG_setWinSigma_double(instance: *mut c_void, win_sigma: f64) -> Result_void;
		pub fn cv_cuda_HOG_getWinSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_HOG_setL2HysThreshold_double(instance: *mut c_void, threshold_l2hys: f64) -> Result_void;
		pub fn cv_cuda_HOG_getL2HysThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_HOG_setGammaCorrection_bool(instance: *mut c_void, gamma_correction: bool) -> Result_void;
		pub fn cv_cuda_HOG_getGammaCorrection_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_HOG_setNumLevels_int(instance: *mut c_void, nlevels: i32) -> Result_void;
		pub fn cv_cuda_HOG_getNumLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HOG_setHitThreshold_double(instance: *mut c_void, hit_threshold: f64) -> Result_void;
		pub fn cv_cuda_HOG_getHitThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_HOG_setWinStride_Size(instance: *mut c_void, win_stride: *const core::Size) -> Result_void;
		pub fn cv_cuda_HOG_getWinStride_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_HOG_setScaleFactor_double(instance: *mut c_void, scale0: f64) -> Result_void;
		pub fn cv_cuda_HOG_getScaleFactor_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_HOG_setGroupThreshold_int(instance: *mut c_void, group_threshold: i32) -> Result_void;
		pub fn cv_cuda_HOG_getGroupThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_HOG_setDescriptorFormat_DescriptorStorageFormat(instance: *mut c_void, descr_format: crate::objdetect::HOGDescriptor_DescriptorStorageFormat) -> Result_void;
		pub fn cv_cuda_HOG_getDescriptorFormat_const(instance: *const c_void) -> Result<crate::objdetect::HOGDescriptor_DescriptorStorageFormat>;
		pub fn cv_cuda_HOG_getDescriptorSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_HOG_getBlockHistogramSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_cuda_HOG_setSVMDetector_const__InputArrayR(instance: *mut c_void, detector: *const c_void) -> Result_void;
		pub fn cv_cuda_HOG_getDefaultPeopleDetector_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_HOG_detect_const__InputArrayR_vector_Point_R_vector_double_X(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_detect_const__InputArrayR_vector_Point_R_vector_double_R(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_detectWithoutConf_const__InputArrayR_vector_Point_R(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_double_X(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_double_R(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_detectMultiScaleWithoutConf_const__InputArrayR_vector_Rect_R(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void) -> Result_void;
		pub fn cv_cuda_HOG_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, img: *const c_void, descriptors: *const c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudaobjdetect)]
pub use cudaobjdetect_sys::*;

#[cfg(ocvrs_has_module_cudaoptflow)]
mod cudaoptflow_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_BroxOpticalFlow_getFlowSmoothness_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_BroxOpticalFlow_setFlowSmoothness_double(instance: *mut c_void, alpha: f64) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_getGradientConstancyImportance_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_BroxOpticalFlow_setGradientConstancyImportance_double(instance: *mut c_void, gamma: f64) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_getPyramidScaleFactor_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_BroxOpticalFlow_setPyramidScaleFactor_double(instance: *mut c_void, scale_factor: f64) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_getInnerIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_BroxOpticalFlow_setInnerIterations_int(instance: *mut c_void, inner_iterations: i32) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_getOuterIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_BroxOpticalFlow_setOuterIterations_int(instance: *mut c_void, outer_iterations: i32) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_getSolverIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_BroxOpticalFlow_setSolverIterations_int(instance: *mut c_void, solver_iterations: i32) -> Result_void;
		pub fn cv_cuda_BroxOpticalFlow_create_double_double_double_int_int_int(alpha: f64, gamma: f64, scale_factor: f64, inner_iterations: i32, outer_iterations: i32, solver_iterations: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_DenseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_StreamR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_getWinSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_DensePyrLKOpticalFlow_setWinSize_Size(instance: *mut c_void, win_size: *const core::Size) -> Result_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DensePyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, max_level: i32) -> Result_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DensePyrLKOpticalFlow_setNumIters_int(instance: *mut c_void, iters: i32) -> Result_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_DensePyrLKOpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool) -> Result_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_create_Size_int_int_bool(win_size: *const core::Size, max_level: i32, iters: i32, use_initial_flow: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_FarnebackOpticalFlow_getNumLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_FarnebackOpticalFlow_setNumLevels_int(instance: *mut c_void, num_levels: i32) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getPyrScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_FarnebackOpticalFlow_setPyrScale_double(instance: *mut c_void, pyr_scale: f64) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getFastPyramids_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_FarnebackOpticalFlow_setFastPyramids_bool(instance: *mut c_void, fast_pyramids: bool) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getWinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_FarnebackOpticalFlow_setWinSize_int(instance: *mut c_void, win_size: i32) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_FarnebackOpticalFlow_setNumIters_int(instance: *mut c_void, num_iters: i32) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getPolyN_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_FarnebackOpticalFlow_setPolyN_int(instance: *mut c_void, poly_n: i32) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getPolySigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_FarnebackOpticalFlow_setPolySigma_double(instance: *mut c_void, poly_sigma: f64) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_getFlags_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_FarnebackOpticalFlow_setFlags_int(instance: *mut c_void, flags: i32) -> Result_void;
		pub fn cv_cuda_FarnebackOpticalFlow_create_int_double_bool_int_int_int_double_int(num_levels: i32, pyr_scale: f64, fast_pyramids: bool, win_size: i32, num_iters: i32, poly_n: i32, poly_sigma: f64, flags: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_NvidiaHWOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_StreamR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, reference_image: *const c_void, flow: *const c_void, stream: *mut c_void, hint: *const c_void, cost: *const c_void) -> Result_void;
		pub fn cv_cuda_NvidiaHWOpticalFlow_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_cuda_NvidiaHWOpticalFlow_getGridSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_upSampler_const__InputArrayR_Size_int_const__InputOutputArrayR(instance: *mut c_void, flow: *const c_void, image_size: *const core::Size, grid_size: i32, upsampled_flow: *const c_void) -> Result_void;
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_create_Size_NVIDIA_OF_PERF_LEVEL_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0_NVIDIA_OF_PERF_LEVEL, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_convertToFloat_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, flow: *const c_void, float_flow: *const c_void) -> Result_void;
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size_NVIDIA_OF_PERF_LEVEL_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE_NVIDIA_OF_HINT_VECTOR_GRID_SIZE_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_PERF_LEVEL, output_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE, hint_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_HINT_VECTOR_GRID_SIZE, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size_vector_Rect__NVIDIA_OF_PERF_LEVEL_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE_NVIDIA_OF_HINT_VECTOR_GRID_SIZE_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, roi_data: *mut c_void, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_PERF_LEVEL, output_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE, hint_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_HINT_VECTOR_GRID_SIZE, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getTau_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setTau_double(instance: *mut c_void, tau: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getLambda_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setLambda_double(instance: *mut c_void, lambda: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getGamma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setGamma_double(instance: *mut c_void, gamma: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getTheta_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setTheta_double(instance: *mut c_void, theta: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumScales_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumScales_int(instance: *mut c_void, nscales: i32) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumWarps_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumWarps_int(instance: *mut c_void, warps: i32) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getEpsilon_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setEpsilon_double(instance: *mut c_void, epsilon: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumIterations_int(instance: *mut c_void, iterations: i32) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getScaleStep_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setScaleStep_double(instance: *mut c_void, scale_step: f64) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_OpticalFlowDual_TVL1_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool) -> Result_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_create_double_double_double_int_int_double_int_double_double_bool(tau: f64, lambda: f64, theta: f64, nscales: i32, warps: i32, epsilon: f64, iterations: i32, scale_step: f64, gamma: f64, use_initial_flow: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_SparseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, err: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getWinSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setWinSize_Size(instance: *mut c_void, win_size: *const core::Size) -> Result_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, max_level: i32) -> Result_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setNumIters_int(instance: *mut c_void, iters: i32) -> Result_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool) -> Result_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_create_Size_int_int_bool(win_size: *const core::Size, max_level: i32, iters: i32, use_initial_flow: bool) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_cudaoptflow)]
pub use cudaoptflow_sys::*;

#[cfg(ocvrs_has_module_cudastereo)]
mod cudastereo_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_createDisparityBilateralFilter_int_int_int(ndisp: i32, radius: i32, iters: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createStereoBM_int_int(num_disparities: i32, block_size: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createStereoBeliefPropagation_int_int_int_int(ndisp: i32, iters: i32, levels: i32, msg_type: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createStereoConstantSpaceBP_int_int_int_int_int(ndisp: i32, iters: i32, levels: i32, nr_plane: i32, msg_type: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_createStereoSGM_int_int_int_int_int_int(min_disparity: i32, num_disparities: i32, p1: i32, p2: i32, uniqueness_ratio: i32, mode: i32) -> Result<*mut c_void>;
		pub fn cv_cuda_drawColorDisp_const__InputArrayR_const__OutputArrayR_int_StreamR(src_disp: *const c_void, dst_disp: *const c_void, ndisp: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(disp: *const c_void, xyzw: *const c_void, q: *const c_void, dst_cn: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, disparity: *const c_void, image: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getNumDisparities_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DisparityBilateralFilter_setNumDisparities_int(instance: *mut c_void, num_disparities: i32) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DisparityBilateralFilter_setRadius_int(instance: *mut c_void, radius: i32) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_DisparityBilateralFilter_setNumIters_int(instance: *mut c_void, iters: i32) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getEdgeThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_DisparityBilateralFilter_setEdgeThreshold_double(instance: *mut c_void, edge_threshold: f64) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getMaxDiscThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_DisparityBilateralFilter_setMaxDiscThreshold_double(instance: *mut c_void, max_disc_threshold: f64) -> Result_void;
		pub fn cv_cuda_DisparityBilateralFilter_getSigmaRange_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_DisparityBilateralFilter_setSigmaRange_double(instance: *mut c_void, sigma_range: f64) -> Result_void;
		pub fn cv_cuda_StereoBM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, data: *const c_void, disparity: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_StereoBeliefPropagation_setNumIters_int(instance: *mut c_void, iters: i32) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getNumLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_StereoBeliefPropagation_setNumLevels_int(instance: *mut c_void, levels: i32) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getMaxDataTerm_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_StereoBeliefPropagation_setMaxDataTerm_double(instance: *mut c_void, max_data_term: f64) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getDataWeight_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_StereoBeliefPropagation_setDataWeight_double(instance: *mut c_void, data_weight: f64) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getMaxDiscTerm_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_StereoBeliefPropagation_setMaxDiscTerm_double(instance: *mut c_void, max_disc_term: f64) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getDiscSingleJump_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_cuda_StereoBeliefPropagation_setDiscSingleJump_double(instance: *mut c_void, disc_single_jump: f64) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_getMsgType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_StereoBeliefPropagation_setMsgType_int(instance: *mut c_void, msg_type: i32) -> Result_void;
		pub fn cv_cuda_StereoBeliefPropagation_estimateRecommendedParams_int_int_intR_intR_intR(width: i32, height: i32, ndisp: *mut i32, iters: *mut i32, levels: *mut i32) -> Result_void;
		pub fn cv_cuda_StereoConstantSpaceBP_getNrPlane_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_StereoConstantSpaceBP_setNrPlane_int(instance: *mut c_void, nr_plane: i32) -> Result_void;
		pub fn cv_cuda_StereoConstantSpaceBP_getUseLocalInitDataCost_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_cuda_StereoConstantSpaceBP_setUseLocalInitDataCost_bool(instance: *mut c_void, use_local_init_data_cost: bool) -> Result_void;
		pub fn cv_cuda_StereoConstantSpaceBP_estimateRecommendedParams_int_int_intR_intR_intR_intR(width: i32, height: i32, ndisp: *mut i32, iters: *mut i32, levels: *mut i32, nr_plane: *mut i32) -> Result_void;
		pub fn cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void) -> Result_void;
		pub fn cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudastereo)]
pub use cudastereo_sys::*;

#[cfg(ocvrs_has_module_cudawarping)]
mod cudawarping_sys {
	use super::*;

	extern "C" {
		pub fn cv_cuda_buildWarpAffineMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_buildWarpAffineMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_buildWarpAffineMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_buildWarpPerspectiveMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_buildWarpPerspectiveMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_buildWarpPerspectiveMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_pyrDown_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_pyrUp_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, xmap: *const c_void, ymap: *const c_void, interpolation: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_resize_const__InputArrayR_const__OutputArrayR_Size_double_double_int_StreamR(src: *const c_void, dst: *const c_void, dsize: *const core::Size, fx: f64, fy: f64, interpolation: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_rotate_const__InputArrayR_const__OutputArrayR_Size_double_double_double_int_StreamR(src: *const c_void, dst: *const c_void, dsize: *const core::Size, angle: f64, x_shift: f64, y_shift: f64, interpolation: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_cudawarping)]
pub use cudawarping_sys::*;

#[cfg(ocvrs_has_module_cvv)]
mod cvv_sys {
	use super::*;

	extern "C" {
		pub fn cvv_impl_debugDMatch_const__InputArrayR_vector_KeyPoint__const__InputArrayR_vector_KeyPoint__vector_DMatch__const_CallMetaDataR_const_charX_const_charX_bool(img1: *const c_void, keypoints1: *mut c_void, img2: *const c_void, keypoints2: *mut c_void, matches: *mut c_void, data: *const c_void, description: *const c_char, view: *const c_char, use_train_descriptor: bool) -> Result_void;
		pub fn cvv_impl_debugFilter_const__InputArrayR_const__InputArrayR_const_CallMetaDataR_const_charX_const_charX(original: *const c_void, result: *const c_void, data: *const c_void, description: *const c_char, view: *const c_char) -> Result_void;
		pub fn cvv_impl_finalShow() -> Result_void;
		pub fn cvv_impl_showImage_const__InputArrayR_const_CallMetaDataR_const_charX_const_charX(img: *const c_void, data: *const c_void, description: *const c_char, view: *const c_char) -> Result_void;
		pub fn cvv_impl_CallMetaData_getPropFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cvv_impl_CallMetaData_getPropLine_const(instance: *const c_void) -> size_t;
		pub fn cvv_impl_CallMetaData_getPropFunction_const(instance: *const c_void) -> *mut c_void;
		pub fn cvv_impl_CallMetaData_getPropIsKnown_const(instance: *const c_void) -> bool;
		pub fn cvv_impl_CallMetaData_CallMetaData() -> Result<*mut c_void>;
		pub fn cvv_impl_CallMetaData_CallMetaData_const_charX_size_t_const_charX(file: *const c_char, line: size_t, function: *const c_char) -> Result<*mut c_void>;
		pub fn cvv_impl_CallMetaData_operator_bool(instance: *mut c_void) -> Result<bool>;
	}
}
#[cfg(ocvrs_has_module_cvv)]
pub use cvv_sys::*;

#[cfg(ocvrs_has_module_dnn)]
mod dnn_sys {
	use super::*;

	extern "C" {
		pub fn cv_dnn_NMSBoxes_const_vector_Rect2d_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32) -> Result_void;
		pub fn cv_dnn_NMSBoxes_const_vector_Rect_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32) -> Result_void;
		pub fn cv_dnn_NMSBoxes_const_vector_RotatedRect_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32) -> Result_void;
		pub fn cv_dnn_blobFromImage_const__InputArrayR_const__OutputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(image: *const c_void, blob: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32) -> Result_void;
		pub fn cv_dnn_blobFromImage_const__InputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(image: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_blobFromImages_const__InputArrayR_const__OutputArrayR_double_Size_const_ScalarR_bool_bool_int(images: *const c_void, blob: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32) -> Result_void;
		pub fn cv_dnn_blobFromImages_const__InputArrayR_double_Size_const_ScalarR_bool_bool_int(images: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_concat_const_MatShapeR_const_MatShapeR(a: *const c_void, b: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_enableModelDiagnostics_bool(is_diagnostics_mode: bool) -> Result_void;
		pub fn cv_dnn_getAvailableTargets_Backend(be: crate::dnn::Backend) -> Result<*mut c_void>;
		pub fn cv_dnn_getInferenceEngineBackendType() -> Result<*mut c_void>;
		pub fn cv_dnn_getInferenceEngineCPUType() -> Result<*mut c_void>;
		pub fn cv_dnn_getInferenceEngineVPUType() -> Result<*mut c_void>;
		pub fn cv_dnn_getPlane_const_MatR_int_int(m: *const c_void, n: i32, cn: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_imagesFromBlob_const_MatR_const__OutputArrayR(blob_: *const c_void, images_: *const c_void) -> Result_void;
		pub fn cv_dnn_print_const_MatShapeR_const_StringR(shape: *const c_void, name: *const c_char) -> Result_void;
		pub fn cv_dnn_readNetFromCaffe_const_StringR_const_StringR(prototxt: *const c_char, caffe_model: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromCaffe_const_charX_size_t_const_charX_size_t(buffer_proto: *const c_char, len_proto: size_t, buffer_model: *const c_char, len_model: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromCaffe_const_vector_unsigned_char_R_const_vector_unsigned_char_R(buffer_proto: *const c_void, buffer_model: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromDarknet_const_StringR_const_StringR(cfg_file: *const c_char, darknet_model: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromDarknet_const_charX_size_t_const_charX_size_t(buffer_cfg: *const c_char, len_cfg: size_t, buffer_model: *const c_char, len_model: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromDarknet_const_vector_unsigned_char_R_const_vector_unsigned_char_R(buffer_cfg: *const c_void, buffer_model: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromModelOptimizer_const_StringR_const_StringR(xml: *const c_char, bin: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(buffer_model_config_ptr: *const u8, buffer_model_config_size: size_t, buffer_weights_ptr: *const u8, buffer_weights_size: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromModelOptimizer_const_vector_unsigned_char_R_const_vector_unsigned_char_R(buffer_model_config: *const c_void, buffer_weights: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromONNX_const_StringR(onnx_file: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromONNX_const_charX_size_t(buffer: *const c_char, size_buffer: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromONNX_const_vector_unsigned_char_R(buffer: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromTensorflow_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromTensorflow_const_charX_size_t_const_charX_size_t(buffer_model: *const c_char, len_model: size_t, buffer_config: *const c_char, len_config: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromTensorflow_const_vector_unsigned_char_R_const_vector_unsigned_char_R(buffer_model: *const c_void, buffer_config: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readNetFromTorch_const_StringR_bool_bool(model: *const c_char, is_binary: bool, evaluate: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_readNet_const_StringR_const_StringR_const_StringR(model: *const c_char, config: *const c_char, framework: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readNet_const_StringR_const_vector_unsigned_char_R_const_vector_unsigned_char_R(framework: *const c_char, buffer_model: *const c_void, buffer_config: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_readTensorFromONNX_const_StringR(path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_readTorchBlob_const_StringR_bool(filename: *const c_char, is_binary: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_releaseHDDLPlugin() -> Result_void;
		pub fn cv_dnn_resetMyriadDevice() -> Result_void;
		pub fn cv_dnn_setInferenceEngineBackendType_const_StringR(new_backend_type: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_shape_const_MatR(mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_shape_const_MatSizeR(sz: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_shape_const_UMatR(mat: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_shape_const_intX_const_int(dims: *const i32, n: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_shape_int_int_int_int(a0: i32, a1: i32, a2: i32, a3: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_shrinkCaffeModel_const_StringR_const_StringR_const_vector_String_R(src: *const c_char, dst: *const c_char, layers_types: *const c_void) -> Result_void;
		pub fn cv_dnn_slice_const_MatR_const__RangeR(m: *const c_void, r0: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void, r2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void, r2: *const c_void, r3: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_softNMSBoxes_const_vector_Rect_R_const_vector_float_R_vector_float_R_const_float_const_float_vector_int_R_size_t_const_float_SoftNMSMethod(bboxes: *const c_void, scores: *const c_void, updated_scores: *mut c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, top_k: size_t, sigma: f32, method: crate::dnn::SoftNMSMethod) -> Result_void;
		pub fn cv_dnn_toString_const_MatShapeR_const_StringR(shape: *const c_void, name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_total_const_MatShapeR_int_int(shape: *const c_void, start: i32, end: i32) -> Result<i32>;
		pub fn cv_dnn_writeTextGraph_const_StringR_const_StringR(model: *const c_char, output: *const c_char) -> Result_void;
		pub fn cv_dnn_AbsLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_AccumLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ActivationLayer_forwardSlice_const_const_floatX_floatX_int_size_t_int_int(instance: *const c_void, src: *const f32, dst: *mut f32, len: i32, out_plane_size: size_t, cn0: i32, cn1: i32) -> Result_void;
		pub fn cv_dnn_ActivationLayer_forwardSlice_const_const_intX_const_intX_intX_int_size_t_int_int(instance: *const c_void, src: *const i32, lut: *const i32, dst: *mut i32, len: i32, out_plane_size: size_t, cn0: i32, cn1: i32) -> Result_void;
		pub fn cv_dnn_ActivationLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_BNLLLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_BackendNode_getPropBackendId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendNode_setPropBackendId_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendWrapper_getPropBackendId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendWrapper_setPropBackendId_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendWrapper_getPropTargetId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendWrapper_setPropTargetId_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendWrapper_copyToHost(instance: *mut c_void) -> Result_void;
		pub fn cv_dnn_BackendWrapper_setHostDirty(instance: *mut c_void) -> Result_void;
		pub fn cv_dnn_BaseConvolutionLayer_getPropKernel_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_BaseConvolutionLayer_setPropKernel_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_getPropStride_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_BaseConvolutionLayer_setPropStride_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_getPropPad_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_BaseConvolutionLayer_setPropPad_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_getPropDilation_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_BaseConvolutionLayer_setPropDilation_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_getPropAdjustPad_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_BaseConvolutionLayer_setPropAdjustPad_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_getPropAdjust_pads_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropAdjust_pads_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropKernel_size_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropKernel_size_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropStrides_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropStrides_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropDilations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropDilations_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropPads_begin_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropPads_begin_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropPads_end_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropPads_end_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_getPropPadMode_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_setPropPadMode_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_BaseConvolutionLayer_getPropNumOutput_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BaseConvolutionLayer_setPropNumOutput_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BatchNormLayer_getPropHasWeights_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_BatchNormLayer_setPropHasWeights_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_BatchNormLayer_getPropHasBias_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_BatchNormLayer_setPropHasBias_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_BatchNormLayer_getPropEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayer_setPropEpsilon_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_BatchNormLayerInt8_getPropInput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayerInt8_setPropInput_sc_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayerInt8_getPropOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayerInt8_setPropOutput_sc_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayerInt8_getPropInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BatchNormLayerInt8_setPropInput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BatchNormLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BatchNormLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BatchNormLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_BlankLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ChannelsPReLULayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ClassificationModel_ClassificationModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_ClassificationModel_ClassificationModel_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ClassificationModel_classify_const__InputArrayR_intR_floatR(instance: *mut c_void, frame: *const c_void, class_id: *mut i32, conf: *mut f32) -> Result_void;
		pub fn cv_dnn_ConcatLayer_getPropAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConcatLayer_setPropAxis_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConcatLayer_getPropPadding_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConcatLayer_setPropPadding_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConcatLayer_getPropPaddingValue_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConcatLayer_setPropPaddingValue_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConcatLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ConstLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ConvolutionLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ConvolutionLayerInt8_getPropInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConvolutionLayerInt8_setPropInput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConvolutionLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConvolutionLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConvolutionLayerInt8_getPropOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ConvolutionLayerInt8_setPropOutput_sc_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ConvolutionLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_CorrelationLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_CropAndResizeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_CropLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_CumSumLayer_getPropExclusive_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_CumSumLayer_setPropExclusive_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_CumSumLayer_getPropReverse_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_CumSumLayer_setPropReverse_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_CumSumLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DataAugmentationLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DeconvolutionLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DequantizeLayer_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_DequantizeLayer_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_DequantizeLayer_getPropZeropoint_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_DequantizeLayer_setPropZeropoint_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_DequantizeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DetectionModel_DetectionModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_DetectionModel_DetectionModel_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DetectionModel_DetectionModel() -> Result<*mut c_void>;
		pub fn cv_dnn_DetectionModel_setNmsAcrossClasses_bool(instance: *mut c_void, value: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_DetectionModel_getNmsAcrossClasses(instance: *mut c_void) -> Result<bool>;
		pub fn cv_dnn_DetectionModel_detect_const__InputArrayR_vector_int_R_vector_float_R_vector_Rect_R_float_float(instance: *mut c_void, frame: *const c_void, class_ids: *mut c_void, confidences: *mut c_void, boxes: *mut c_void, conf_threshold: f32, nms_threshold: f32) -> Result_void;
		pub fn cv_dnn_DetectionOutputLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_has_const_const_StringR(instance: *const c_void, key: *const c_char) -> Result<bool>;
		pub fn cv_dnn_Dict_ptr_const_StringR(instance: *mut c_void, key: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_ptr_const_const_StringR(instance: *const c_void, key: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_get_const_const_StringR(instance: *const c_void, key: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_set_cv_String_const_StringR_const_StringR(instance: *mut c_void, key: *const c_char, value: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_set_cv_dnn_DictValue_const_StringR_const_DictValueR(instance: *mut c_void, key: *const c_char, value: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Dict_set_double_const_StringR_const_doubleR(instance: *mut c_void, key: *const c_char, value: *const f64) -> Result<f64>;
		pub fn cv_dnn_Dict_set_int64_t_const_StringR_const_int64_tR(instance: *mut c_void, key: *const c_char, value: *const i64) -> Result<i64>;
		pub fn cv_dnn_Dict_erase_const_StringR(instance: *mut c_void, key: *const c_char) -> Result_void;
		pub fn cv_dnn_DictValue_DictValue_const_DictValueR(r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_bool(i: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_int64_t(i: i64) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_int(i: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_unsigned_int(p: u32) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_double(p: f64) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_DictValue_const_charX(s: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_get_cv_String_const_int(instance: *const c_void, idx: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_DictValue_get_double_const_int(instance: *const c_void, idx: i32) -> Result<f64>;
		pub fn cv_dnn_DictValue_get_int_const_int(instance: *const c_void, idx: i32) -> Result<i32>;
		pub fn cv_dnn_DictValue_get_int64_t_const_int(instance: *const c_void, idx: i32) -> Result<i64>;
		pub fn cv_dnn_DictValue_size_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_dnn_DictValue_isInt_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_dnn_DictValue_isString_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_dnn_DictValue_isReal_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_dnn_DictValue_getIntValue_const_int(instance: *const c_void, idx: i32) -> Result<i32>;
		pub fn cv_dnn_DictValue_getRealValue_const_int(instance: *const c_void, idx: i32) -> Result<f64>;
		pub fn cv_dnn_DictValue_getStringValue_const_int(instance: *const c_void, idx: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_ELULayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_EltwiseLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_EltwiseLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ExpLayer_getPropBase_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_setPropBase_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_getPropShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_setPropShift_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_FlattenLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_FlowWarpLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_GRULayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_InnerProductLayer_getPropAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_InnerProductLayer_setPropAxis_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_InnerProductLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_InnerProductLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_InnerProductLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_InnerProductLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_InterpLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_KeypointsModel_KeypointsModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_KeypointsModel_KeypointsModel_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_KeypointsModel_estimate_const__InputArrayR_float(instance: *mut c_void, frame: *const c_void, thresh: f32) -> Result<*mut c_void>;
		pub fn cv_dnn_LRNLayer_getPropType_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_LRNLayer_setPropType_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_LRNLayer_getPropSize_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_LRNLayer_setPropSize_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_LRNLayer_getPropAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_setPropAlpha_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_getPropBeta_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_setPropBeta_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_getPropBias_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_setPropBias_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_getPropNormBySize_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_LRNLayer_setPropNormBySize_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_LRNLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_LSTMLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_LSTMLayer_setWeights_const_MatR_const_MatR_const_MatR(instance: *mut c_void, wh: *const c_void, wx: *const c_void, b: *const c_void) -> Result_void;
		pub fn cv_dnn_LSTMLayer_setOutShape_const_MatShapeR(instance: *mut c_void, out_tail_shape: *const c_void) -> Result_void;
		pub fn cv_dnn_LSTMLayer_setUseTimstampsDim_bool(instance: *mut c_void, use_: bool) -> Result_void;
		pub fn cv_dnn_LSTMLayer_setProduceCellOutput_bool(instance: *mut c_void, produce: bool) -> Result_void;
		pub fn cv_dnn_LSTMLayer_inputNameToIndex_String(instance: *mut c_void, input_name: *mut c_char) -> Result<i32>;
		pub fn cv_dnn_LSTMLayer_outputNameToIndex_const_StringR(instance: *mut c_void, output_name: *const c_char) -> Result<i32>;
		pub fn cv_dnn_Layer_getPropBlobs_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_setPropBlobs_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_Layer_getPropName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_setPropName_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_Layer_getPropType_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_setPropType_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_Layer_getPropPreferableTarget_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_Layer_setPropPreferableTarget_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_Layer_finalize_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void) -> Result_void;
		pub fn cv_dnn_Layer_forward_vector_MatX_R_vector_Mat_R_vector_Mat_R(instance: *mut c_void, input: *mut c_void, output: *mut c_void, internals: *mut c_void) -> Result_void;
		pub fn cv_dnn_Layer_forward_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, internals: *const c_void) -> Result_void;
		pub fn cv_dnn_Layer_tryQuantize_const_vector_vector_float__R_const_vector_vector_int__R_LayerParamsR(instance: *mut c_void, scales: *const c_void, zeropoints: *const c_void, params: *mut c_void) -> Result<bool>;
		pub fn cv_dnn_Layer_forward_fallback_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, internals: *const c_void) -> Result_void;
		pub fn cv_dnn_Layer_finalize_const_vector_Mat_R_vector_Mat_R(instance: *mut c_void, inputs: *const c_void, outputs: *mut c_void) -> Result_void;
		pub fn cv_dnn_Layer_finalize_const_vector_Mat_R(instance: *mut c_void, inputs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_run_const_vector_Mat_R_vector_Mat_R_vector_Mat_R(instance: *mut c_void, inputs: *const c_void, outputs: *mut c_void, internals: *mut c_void) -> Result_void;
		pub fn cv_dnn_Layer_inputNameToIndex_String(instance: *mut c_void, input_name: *mut c_char) -> Result<i32>;
		pub fn cv_dnn_Layer_outputNameToIndex_const_StringR(instance: *mut c_void, output_name: *const c_char) -> Result<i32>;
		pub fn cv_dnn_Layer_supportBackend_int(instance: *mut c_void, backend_id: i32) -> Result<bool>;
		pub fn cv_dnn_Layer_initHalide_const_vector_Ptr_BackendWrapper__R(instance: *mut c_void, inputs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_initInfEngine_const_vector_Ptr_BackendWrapper__R(instance: *mut c_void, inputs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_initNgraph_const_vector_Ptr_BackendWrapper__R_const_vector_Ptr_BackendNode__R(instance: *mut c_void, inputs: *const c_void, nodes: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_initVkCom_const_vector_Ptr_BackendWrapper__R(instance: *mut c_void, inputs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_initCUDA_voidX_const_vector_Ptr_BackendWrapper__R_const_vector_Ptr_BackendWrapper__R(instance: *mut c_void, context: *mut c_void, inputs: *const c_void, outputs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_applyHalideScheduler_const_Ptr_BackendNode_R_const_vector_MatX_R_const_vector_Mat_R_int(instance: *const c_void, node: *mut c_void, inputs: *const c_void, outputs: *const c_void, target_id: i32) -> Result_void;
		pub fn cv_dnn_Layer_tryAttach_const_Ptr_BackendNode_R(instance: *mut c_void, node: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_setActivation_const_Ptr_ActivationLayer_R(instance: *mut c_void, layer: *const c_void) -> Result<bool>;
		pub fn cv_dnn_Layer_tryFuse_Ptr_Layer_R(instance: *mut c_void, top: *mut c_void) -> Result<bool>;
		pub fn cv_dnn_Layer_getScaleShift_const_MatR_MatR(instance: *const c_void, scale: *mut c_void, shift: *mut c_void) -> Result_void;
		pub fn cv_dnn_Layer_getScaleZeropoint_const_floatR_intR(instance: *const c_void, scale: *mut f32, zeropoint: *mut i32) -> Result_void;
		pub fn cv_dnn_Layer_unsetAttached(instance: *mut c_void) -> Result_void;
		pub fn cv_dnn_Layer_getMemoryShapes_const_const_vector_MatShape_R_const_int_vector_MatShape_R_vector_MatShape_R(instance: *const c_void, inputs: *const c_void, required_outputs: i32, outputs: *mut c_void, internals: *mut c_void) -> Result<bool>;
		pub fn cv_dnn_Layer_getFLOPS_const_const_vector_MatShape_R_const_vector_MatShape_R(instance: *const c_void, inputs: *const c_void, outputs: *const c_void) -> Result<i64>;
		pub fn cv_dnn_Layer_updateMemoryShapes_const_vector_MatShape_R(instance: *mut c_void, inputs: *const c_void) -> Result<bool>;
		pub fn cv_dnn_Layer_Layer() -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_Layer_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Layer_setParamsFrom_const_LayerParamsR(instance: *mut c_void, params: *const c_void) -> Result_void;
		pub fn cv_dnn_LayerFactory_registerLayer_const_StringR_Constructor(typ: *const c_char, constructor: Option<unsafe extern "C" fn(*mut c_void) -> *mut c_void>) -> Result_void;
		pub fn cv_dnn_LayerFactory_unregisterLayer_const_StringR(typ: *const c_char) -> Result_void;
		pub fn cv_dnn_LayerFactory_createLayerInstance_const_StringR_LayerParamsR(typ: *const c_char, params: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_LayerParams_getPropBlobs_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_setPropBlobs_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_LayerParams_getPropName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_setPropName_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_LayerParams_getPropType_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_setPropType_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_MVNLayer_getPropEps_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_MVNLayer_setPropEps_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_MVNLayer_getPropNormVariance_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_MVNLayer_setPropNormVariance_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_MVNLayer_getPropAcrossChannels_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_MVNLayer_setPropAcrossChannels_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_MVNLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_MaxUnpoolLayer_getPropPoolKernel_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_MaxUnpoolLayer_setPropPoolKernel_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_getPropPoolPad_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_MaxUnpoolLayer_setPropPoolPad_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_getPropPoolStride_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_MaxUnpoolLayer_setPropPoolStride_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_MishLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_Model() -> Result<*mut c_void>;
		pub fn cv_dnn_Model_Model_const_ModelR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Model_Model_ModelR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Model_Model_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_Model_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputSize_const_SizeR(instance: *mut c_void, size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputSize_int_int(instance: *mut c_void, width: i32, height: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputMean_const_ScalarR(instance: *mut c_void, mean: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputScale_double(instance: *mut c_void, scale: f64) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputCrop_bool(instance: *mut c_void, crop: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputSwapRB_bool(instance: *mut c_void, swap_rb: bool) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setInputParams_double_const_SizeR_const_ScalarR_bool_bool(instance: *mut c_void, scale: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool) -> Result_void;
		pub fn cv_dnn_Model_predict_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, frame: *const c_void, outs: *const c_void) -> Result_void;
		pub fn cv_dnn_Model_setPreferableBackend_Backend(instance: *mut c_void, backend_id: crate::dnn::Backend) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_setPreferableTarget_Target(instance: *mut c_void, target_id: crate::dnn::Target) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_getNetwork__const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Model_getNetwork_(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_Net() -> Result<*mut c_void>;
		pub fn cv_dnn_Net_readFromModelOptimizer_const_StringR_const_StringR(xml: *const c_char, bin: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_readFromModelOptimizer_const_vector_unsigned_char_R_const_vector_unsigned_char_R(buffer_model_config: *const c_void, buffer_weights: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_readFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(buffer_model_config_ptr: *const u8, buffer_model_config_size: size_t, buffer_weights_ptr: *const u8, buffer_weights_size: size_t) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_dnn_Net_dump(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_dumpToFile_const_StringR(instance: *mut c_void, path: *const c_char) -> Result_void;
		pub fn cv_dnn_Net_addLayer_const_StringR_const_StringR_const_intR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, dtype: *const i32, params: *mut c_void) -> Result<i32>;
		pub fn cv_dnn_Net_addLayer_const_StringR_const_StringR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, params: *mut c_void) -> Result<i32>;
		pub fn cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_const_intR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, dtype: *const i32, params: *mut c_void) -> Result<i32>;
		pub fn cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, params: *mut c_void) -> Result<i32>;
		pub fn cv_dnn_Net_getLayerId_const_StringR(instance: *mut c_void, layer: *const c_char) -> Result<i32>;
		pub fn cv_dnn_Net_getLayerNames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getLayer_LayerId(instance: *mut c_void, layer_id: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getLayerInputs_LayerId(instance: *mut c_void, layer_id: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_connect_String_String(instance: *mut c_void, out_pin: *mut c_char, inp_pin: *mut c_char) -> Result_void;
		pub fn cv_dnn_Net_connect_int_int_int_int(instance: *mut c_void, out_layer_id: i32, out_num: i32, inp_layer_id: i32, inp_num: i32) -> Result_void;
		pub fn cv_dnn_Net_setInputsNames_const_vector_String_R(instance: *mut c_void, input_blob_names: *const c_void) -> Result_void;
		pub fn cv_dnn_Net_setInputShape_const_StringR_const_MatShapeR(instance: *mut c_void, input_name: *const c_char, shape: *const c_void) -> Result_void;
		pub fn cv_dnn_Net_forward_const_StringR(instance: *mut c_void, output_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_forwardAsync_const_StringR(instance: *mut c_void, output_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_forward_const__OutputArrayR_const_StringR(instance: *mut c_void, output_blobs: *const c_void, output_name: *const c_char) -> Result_void;
		pub fn cv_dnn_Net_forward_const__OutputArrayR_const_vector_String_R(instance: *mut c_void, output_blobs: *const c_void, out_blob_names: *const c_void) -> Result_void;
		pub fn cv_dnn_Net_forward_vector_vector_Mat__R_const_vector_String_R(instance: *mut c_void, output_blobs: *mut c_void, out_blob_names: *const c_void) -> Result_void;
		pub fn cv_dnn_Net_quantize_const__InputArrayR_int_int(instance: *mut c_void, calib_data: *const c_void, inputs_dtype: i32, outputs_dtype: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getInputDetails_const_vector_float_R_vector_int_R(instance: *const c_void, scales: *mut c_void, zeropoints: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getOutputDetails_const_vector_float_R_vector_int_R(instance: *const c_void, scales: *mut c_void, zeropoints: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_setHalideScheduler_const_StringR(instance: *mut c_void, scheduler: *const c_char) -> Result_void;
		pub fn cv_dnn_Net_setPreferableBackend_int(instance: *mut c_void, backend_id: i32) -> Result_void;
		pub fn cv_dnn_Net_setPreferableTarget_int(instance: *mut c_void, target_id: i32) -> Result_void;
		pub fn cv_dnn_Net_setInput_const__InputArrayR_const_StringR_double_const_ScalarR(instance: *mut c_void, blob: *const c_void, name: *const c_char, scalefactor: f64, mean: *const core::Scalar) -> Result_void;
		pub fn cv_dnn_Net_setParam_LayerId_int_const_MatR(instance: *mut c_void, layer: *mut c_void, num_param: i32, blob: *const c_void) -> Result_void;
		pub fn cv_dnn_Net_getParam_LayerId_int(instance: *mut c_void, layer: *mut c_void, num_param: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getUnconnectedOutLayers_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getUnconnectedOutLayersNames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_Net_getLayersShapes_const_const_vector_MatShape_R_vector_int_R_vector_vector_MatShape__R_vector_vector_MatShape__R(instance: *const c_void, net_input_shapes: *const c_void, layers_ids: *mut c_void, in_layers_shapes: *mut c_void, out_layers_shapes: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getLayersShapes_const_const_MatShapeR_vector_int_R_vector_vector_MatShape__R_vector_vector_MatShape__R(instance: *const c_void, net_input_shape: *const c_void, layers_ids: *mut c_void, in_layers_shapes: *mut c_void, out_layers_shapes: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getLayerShapes_const_const_MatShapeR_const_int_vector_MatShape_R_vector_MatShape_R(instance: *const c_void, net_input_shape: *const c_void, layer_id: i32, in_layer_shapes: *mut c_void, out_layer_shapes: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getLayerShapes_const_const_vector_MatShape_R_const_int_vector_MatShape_R_vector_MatShape_R(instance: *const c_void, net_input_shapes: *const c_void, layer_id: i32, in_layer_shapes: *mut c_void, out_layer_shapes: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getFLOPS_const_const_vector_MatShape_R(instance: *const c_void, net_input_shapes: *const c_void) -> Result<i64>;
		pub fn cv_dnn_Net_getFLOPS_const_const_MatShapeR(instance: *const c_void, net_input_shape: *const c_void) -> Result<i64>;
		pub fn cv_dnn_Net_getFLOPS_const_const_int_const_vector_MatShape_R(instance: *const c_void, layer_id: i32, net_input_shapes: *const c_void) -> Result<i64>;
		pub fn cv_dnn_Net_getFLOPS_const_const_int_const_MatShapeR(instance: *const c_void, layer_id: i32, net_input_shape: *const c_void) -> Result<i64>;
		pub fn cv_dnn_Net_getLayerTypes_const_vector_String_R(instance: *const c_void, layers_types: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getLayersCount_const_const_StringR(instance: *const c_void, layer_type: *const c_char) -> Result<i32>;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_vector_MatShape_R_size_tR_size_tR(instance: *const c_void, net_input_shapes: *const c_void, weights: *mut size_t, blobs: *mut size_t) -> Result_void;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_size_tR_size_tR(instance: *const c_void, net_input_shape: *const c_void, weights: *mut size_t, blobs: *mut size_t) -> Result_void;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_int_const_vector_MatShape_R_size_tR_size_tR(instance: *const c_void, layer_id: i32, net_input_shapes: *const c_void, weights: *mut size_t, blobs: *mut size_t) -> Result_void;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_int_const_MatShapeR_size_tR_size_tR(instance: *const c_void, layer_id: i32, net_input_shape: *const c_void, weights: *mut size_t, blobs: *mut size_t) -> Result_void;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_vector_MatShape_R_vector_int_R_vector_size_t_R_vector_size_t_R(instance: *const c_void, net_input_shapes: *const c_void, layer_ids: *mut c_void, weights: *mut c_void, blobs: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_vector_int_R_vector_size_t_R_vector_size_t_R(instance: *const c_void, net_input_shape: *const c_void, layer_ids: *mut c_void, weights: *mut c_void, blobs: *mut c_void) -> Result_void;
		pub fn cv_dnn_Net_enableFusion_bool(instance: *mut c_void, fusion: bool) -> Result_void;
		pub fn cv_dnn_Net_getPerfProfile_vector_double_R(instance: *mut c_void, timings: *mut c_void) -> Result<i64>;
		pub fn cv_dnn_NormalizeBBoxLayer_getPropPnorm_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_NormalizeBBoxLayer_setPropPnorm_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_NormalizeBBoxLayer_getPropEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_NormalizeBBoxLayer_setPropEpsilon_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_NormalizeBBoxLayer_getPropAcrossSpatial_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_NormalizeBBoxLayer_setPropAcrossSpatial_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_NormalizeBBoxLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PaddingLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PermuteLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PoolingLayer_getPropType_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayer_setPropType_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayer_getPropKernel_size_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropKernel_size_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_PoolingLayer_getPropStrides_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropStrides_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_PoolingLayer_getPropPads_begin_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropPads_begin_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_PoolingLayer_getPropPads_end_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropPads_end_vector_size_t_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_PoolingLayer_getPropGlobalPooling_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_setPropGlobalPooling_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_getPropIsGlobalPooling_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropIsGlobalPooling_vector_bool_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_PoolingLayer_getPropComputeMaxIdx_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_setPropComputeMaxIdx_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_getPropPadMode_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_setPropPadMode_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_dnn_PoolingLayer_getPropCeilMode_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_setPropCeilMode_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_getPropAvePoolPaddedArea_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_setPropAvePoolPaddedArea_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_getPropPooledSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_dnn_PoolingLayer_setPropPooledSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_PoolingLayer_getPropSpatialScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PoolingLayer_setPropSpatialScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PoolingLayer_getPropPsRoiOutChannels_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayer_setPropPsRoiOutChannels_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PoolingLayerInt8_getPropInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayerInt8_setPropInput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PowerLayer_getPropPower_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_setPropPower_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_getPropShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_setPropShift_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_PriorBoxLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ProposalLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_QuantizeLayer_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_QuantizeLayer_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_QuantizeLayer_getPropZeropoint_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_QuantizeLayer_setPropZeropoint_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_QuantizeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_RNNLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_RNNLayer_setWeights_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR(instance: *mut c_void, wxh: *const c_void, bh: *const c_void, whh: *const c_void, who: *const c_void, bo: *const c_void) -> Result_void;
		pub fn cv_dnn_RNNLayer_setProduceHiddenOutput_bool(instance: *mut c_void, produce: bool) -> Result_void;
		pub fn cv_dnn_ReLU6Layer_getPropMinValue_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLU6Layer_setPropMinValue_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLU6Layer_getPropMaxValue_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLU6Layer_setPropMaxValue_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLU6Layer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ReLULayer_getPropNegativeSlope_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLULayer_setPropNegativeSlope_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLULayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_RegionLayer_getPropNmsThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RegionLayer_setPropNmsThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RegionLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ReorgLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_RequantizeLayer_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RequantizeLayer_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RequantizeLayer_getPropShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RequantizeLayer_setPropShift_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RequantizeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ReshapeLayer_getPropNewShapeDesc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_setPropNewShapeDesc_MatShape(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_ReshapeLayer_getPropNewShapeRange_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_setPropNewShapeRange_Range(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_ReshapeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ResizeLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ScaleLayer_getPropHasBias_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ScaleLayer_setPropHasBias_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ScaleLayer_getPropAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ScaleLayer_setPropAxis_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ScaleLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ScaleLayerInt8_getPropOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ScaleLayerInt8_setPropOutput_sc_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ScaleLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ScaleLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ScaleLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SegmentationModel_SegmentationModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_SegmentationModel_SegmentationModel_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SegmentationModel_segment_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, frame: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_dnn_ShiftLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ShiftLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_ShuffleChannelLayer_getPropGroup_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ShuffleChannelLayer_setPropGroup_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ShuffleChannelLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SigmoidLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SliceLayer_getPropSliceRanges_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_setPropSliceRanges_vector_vector_Range__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_SliceLayer_getPropSliceSteps_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_setPropSliceSteps_vector_vector_int__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_dnn_SliceLayer_getPropAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SliceLayer_setPropAxis_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SliceLayer_getPropNum_split_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SliceLayer_setPropNum_split_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SliceLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SoftmaxLayer_getPropLogSoftMax_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_SoftmaxLayer_setPropLogSoftMax_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_SoftmaxLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SoftmaxLayerInt8_getPropOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_SoftmaxLayerInt8_setPropOutput_sc_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_SoftmaxLayerInt8_getPropOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SoftmaxLayerInt8_setPropOutput_zp_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SoftmaxLayerInt8_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SplitLayer_getPropOutputsCount_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SplitLayer_setPropOutputsCount_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SplitLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_SwishLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TanHLayer_create_const_LayerParamsR(params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vector_vector_Point__R_vector_float_R(instance: *const c_void, frame: *const c_void, detections: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vector_vector_Point__R(instance: *const c_void, frame: *const c_void, detections: *mut c_void) -> Result_void;
		pub fn cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vector_RotatedRect_R_vector_float_R(instance: *const c_void, frame: *const c_void, detections: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vector_RotatedRect_R(instance: *const c_void, frame: *const c_void, detections: *mut c_void) -> Result_void;
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB() -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_stringR_const_stringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_setBinaryThreshold_float(instance: *mut c_void, binary_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_getBinaryThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_dnn_TextDetectionModel_DB_setPolygonThreshold_float(instance: *mut c_void, polygon_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_getPolygonThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_dnn_TextDetectionModel_DB_setUnclipRatio_double(instance: *mut c_void, unclip_ratio: f64) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_getUnclipRatio_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_dnn_TextDetectionModel_DB_setMaxCandidates_int(instance: *mut c_void, max_candidates: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_DB_getMaxCandidates_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST() -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_stringR_const_stringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_EAST_setConfidenceThreshold_float(instance: *mut c_void, conf_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_EAST_getConfidenceThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_dnn_TextDetectionModel_EAST_setNMSThreshold_float(instance: *mut c_void, nms_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextDetectionModel_EAST_getNMSThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel() -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel_const_NetR(network: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel_const_stringR_const_stringR(model: *const c_char, config: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_setDecodeType_const_stringR(instance: *mut c_void, decode_type: *const c_char) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_getDecodeType_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_setDecodeOptsCTCPrefixBeamSearch_int_int(instance: *mut c_void, beam_size: i32, voc_prune_size: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_setVocabulary_const_vector_string_R(instance: *mut c_void, vocabulary: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_getVocabulary_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR(instance: *const c_void, frame: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR_const__InputArrayR_vector_string_R(instance: *const c_void, frame: *const c_void, roi_rects: *const c_void, results: *mut c_void) -> Result_void;
		pub fn cv_dnn__Range__Range_const_RangeR(r: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dnn__Range__Range_int_int(start_: i32, size_: i32) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_dnn)]
pub use dnn_sys::*;

#[cfg(ocvrs_has_module_dnn_superres)]
mod dnn_superres_sys {
	use super::*;

	extern "C" {
		pub fn cv_dnn_superres_DnnSuperResImpl_create() -> Result<*mut c_void>;
		pub fn cv_dnn_superres_DnnSuperResImpl_DnnSuperResImpl() -> Result<*mut c_void>;
		pub fn cv_dnn_superres_DnnSuperResImpl_DnnSuperResImpl_const_StringR_int(algo: *const c_char, scale: i32) -> Result<*mut c_void>;
		pub fn cv_dnn_superres_DnnSuperResImpl_readModel_const_StringR(instance: *mut c_void, path: *const c_char) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_readModel_const_StringR_const_StringR(instance: *mut c_void, weights: *const c_char, definition: *const c_char) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_setModel_const_StringR_int(instance: *mut c_void, algo: *const c_char, scale: i32) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_setPreferableBackend_int(instance: *mut c_void, backend_id: i32) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_setPreferableTarget_int(instance: *mut c_void, target_id: i32) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_upsample_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_upsampleMultioutput_const__InputArrayR_vector_Mat_R_const_vector_int_R_const_vector_String_R(instance: *mut c_void, img: *const c_void, imgs_new: *mut c_void, scale_factors: *const c_void, node_names: *const c_void) -> Result_void;
		pub fn cv_dnn_superres_DnnSuperResImpl_getScale(instance: *mut c_void) -> Result<i32>;
		pub fn cv_dnn_superres_DnnSuperResImpl_getAlgorithm(instance: *mut c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_dnn_superres)]
pub use dnn_superres_sys::*;

#[cfg(ocvrs_has_module_dpm)]
mod dpm_sys {
	use super::*;

	extern "C" {
		pub fn cv_dpm_DPMDetector_isEmpty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_dpm_DPMDetector_detect_MatR_vector_ObjectDetection_R(instance: *mut c_void, image: *mut c_void, objects: *mut c_void) -> Result_void;
		pub fn cv_dpm_DPMDetector_getClassNames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dpm_DPMDetector_getClassCount_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_dpm_DPMDetector_create_const_vector_string_R_const_vector_string_R(filenames: *const c_void, class_names: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dpm_DPMDetector_ObjectDetection_getPropRect_const(instance: *const c_void) -> core::Rect;
		pub fn cv_dpm_DPMDetector_ObjectDetection_setPropRect_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_dpm_DPMDetector_ObjectDetection_getPropScore_const(instance: *const c_void) -> f32;
		pub fn cv_dpm_DPMDetector_ObjectDetection_setPropScore_float(instance: *mut c_void, val: f32);
		pub fn cv_dpm_DPMDetector_ObjectDetection_getPropClassID_const(instance: *const c_void) -> i32;
		pub fn cv_dpm_DPMDetector_ObjectDetection_setPropClassID_int(instance: *mut c_void, val: i32);
		pub fn cv_dpm_DPMDetector_ObjectDetection_ObjectDetection() -> Result<*mut c_void>;
		pub fn cv_dpm_DPMDetector_ObjectDetection_ObjectDetection_const_RectR_float_int(rect: *const core::Rect, score: f32, class_id: i32) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_dpm)]
pub use dpm_sys::*;

#[cfg(ocvrs_has_module_face)]
mod face_sys {
	use super::*;

	extern "C" {
		pub fn cv_face_createFacemarkAAM() -> Result<*mut c_void>;
		pub fn cv_face_createFacemarkKazemi() -> Result<*mut c_void>;
		pub fn cv_face_createFacemarkLBF() -> Result<*mut c_void>;
		pub fn cv_face_drawFacemarks_const__InputOutputArrayR_const__InputArrayR_Scalar(image: *const c_void, points: *const c_void, color: *const core::Scalar) -> Result_void;
		pub fn cv_face_getFacesHAAR_const__InputArrayR_const__OutputArrayR_const_StringR(image: *const c_void, faces: *const c_void, face_cascade_name: *const c_char) -> Result<bool>;
		pub fn cv_face_getFaces_const__InputArrayR_const__OutputArrayR_CParamsX(image: *const c_void, faces: *const c_void, params: *mut c_void) -> Result<bool>;
		pub fn cv_face_loadDatasetList_String_String_vector_String_R_vector_String_R(image_list: *mut c_char, annotation_list: *mut c_char, images: *mut c_void, annotations: *mut c_void) -> Result<bool>;
		pub fn cv_face_loadFacePoints_String_const__OutputArrayR_float(filename: *mut c_char, points: *const c_void, offset: f32) -> Result<bool>;
		pub fn cv_face_loadTrainingData_String_String_vector_String_R_const__OutputArrayR_float(image_list: *mut c_char, ground_truth: *mut c_char, images: *mut c_void, face_points: *const c_void, offset: f32) -> Result<bool>;
		pub fn cv_face_loadTrainingData_String_vector_String_R_const__OutputArrayR_char_float(filename: *mut c_char, images: *mut c_void, face_points: *const c_void, delim: i8, offset: f32) -> Result<bool>;
		pub fn cv_face_loadTrainingData_vector_String__vector_vector_Point2f__R_vector_String_R(filename: *mut c_void, trainlandmarks: *mut c_void, trainimages: *mut c_void) -> Result<bool>;
		pub fn cv_face_BIF_getNumBands_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_BIF_getNumRotations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_BIF_compute_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, image: *const c_void, features: *const c_void) -> Result_void;
		pub fn cv_face_BIF_create_int_int(num_bands: i32, num_rotations: i32) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_getNumComponents_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_BasicFaceRecognizer_setNumComponents_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_face_BasicFaceRecognizer_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_face_BasicFaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_face_BasicFaceRecognizer_getProjections_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_getLabels_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_getEigenValues_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_getEigenVectors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_getMean_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_BasicFaceRecognizer_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_face_BasicFaceRecognizer_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_face_BasicFaceRecognizer_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_face_CParams_getPropCascade_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_CParams_setPropCascade_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_face_CParams_getPropScaleFactor_const(instance: *const c_void) -> f64;
		pub fn cv_face_CParams_setPropScaleFactor_double(instance: *mut c_void, val: f64);
		pub fn cv_face_CParams_getPropMinNeighbors_const(instance: *const c_void) -> i32;
		pub fn cv_face_CParams_setPropMinNeighbors_int(instance: *mut c_void, val: i32);
		pub fn cv_face_CParams_getPropMinSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_face_CParams_setPropMinSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_face_CParams_getPropMaxSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_face_CParams_setPropMaxSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_face_CParams_getPropFace_cascade_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_CParams_setPropFace_cascade_CascadeClassifier(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_CParams_CParams_String_double_int_Size_Size(cascade_model: *mut c_char, sf: f64, min_n: i32, min_sz: *const core::Size, max_sz: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_face_EigenFaceRecognizer_create_int_double(num_components: i32, threshold: f64) -> Result<*mut c_void>;
		pub fn cv_face_FaceRecognizer_train_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void) -> Result_void;
		pub fn cv_face_FaceRecognizer_update_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void) -> Result_void;
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR(instance: *const c_void, src: *const c_void) -> Result<i32>;
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR_intR_doubleR(instance: *const c_void, src: *const c_void, label: *mut i32, confidence: *mut f64) -> Result_void;
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR_Ptr_PredictCollector_(instance: *const c_void, src: *const c_void, collector: *mut c_void) -> Result_void;
		pub fn cv_face_FaceRecognizer_write_const_const_StringR(instance: *const c_void, filename: *const c_char) -> Result_void;
		pub fn cv_face_FaceRecognizer_read_const_StringR(instance: *mut c_void, filename: *const c_char) -> Result_void;
		pub fn cv_face_FaceRecognizer_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_face_FaceRecognizer_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_face_FaceRecognizer_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_face_FaceRecognizer_setLabelInfo_int_const_StringR(instance: *mut c_void, label: i32, str_info: *const c_char) -> Result_void;
		pub fn cv_face_FaceRecognizer_getLabelInfo_const_int(instance: *const c_void, label: i32) -> Result<*mut c_void>;
		pub fn cv_face_FaceRecognizer_getLabelsByString_const_const_StringR(instance: *const c_void, str: *const c_char) -> Result<*mut c_void>;
		pub fn cv_face_FaceRecognizer_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_face_FaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_face_Facemark_loadModel_String(instance: *mut c_void, model: *mut c_char) -> Result_void;
		pub fn cv_face_Facemark_fit_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void, landmarks: *const c_void) -> Result<bool>;
		pub fn cv_face_FacemarkAAM_fitConfig_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_vector_Config_R(instance: *mut c_void, image: *const c_void, roi: *const c_void, _landmarks: *const c_void, runtime_params: *const c_void) -> Result<bool>;
		pub fn cv_face_FacemarkAAM_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_FacemarkAAM_Config_getPropR_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Config_setPropR_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Config_getPropT_const(instance: *const c_void) -> core::Point2f;
		pub fn cv_face_FacemarkAAM_Config_setPropT_Point2f(instance: *mut c_void, val: *const core::Point2f);
		pub fn cv_face_FacemarkAAM_Config_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkAAM_Config_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkAAM_Config_getPropModel_scale_idx_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Config_setPropModel_scale_idx_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Config_Config_Mat_Point2f_float_int(rot: *mut c_void, trans: *const core::Point2f, scaling: f32, scale_id: i32) -> Result<*mut c_void>;
		pub fn cv_face_FacemarkAAM_Data_getPropS0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Data_setPropS0_vector_Point2f_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropScales_vector_float_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropTriangles_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropTriangles_vector_Vec3i_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropTextures_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropTextures_vector_Texture_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropS0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropS0_vector_Point2f_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropS_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropS_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_getPropQ_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_setPropQ_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropMax_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropMax_m_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropResolution_const(instance: *const c_void) -> core::Rect;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropResolution_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropA_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropA0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropA0_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropAA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropAA_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropAA0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropAA0_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropTextureIdx_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropTextureIdx_vector_vector_Point__(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropBase_shape_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropBase_shape_vector_Point2f_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropInd1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropInd1_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_getPropInd2_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_setPropInd2_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Params_getPropModel_filename_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Params_setPropModel_filename_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_face_FacemarkAAM_Params_getPropM_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropM_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropN_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropN_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropN_iter_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropN_iter_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropVerbose_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkAAM_Params_setPropVerbose_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkAAM_Params_getPropSave_model_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkAAM_Params_setPropSave_model_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkAAM_Params_getPropMax_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropMax_m_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropMax_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropMax_n_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropTexture_max_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_setPropTexture_max_m_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_getPropScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Params_setPropScales_vector_float_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkAAM_Params_Params() -> Result<*mut c_void>;
		pub fn cv_face_FacemarkAAM_Params_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_face_FacemarkAAM_Params_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_face_FacemarkKazemi_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_FacemarkKazemi_training_vector_Mat_R_vector_vector_Point2f__R_string_Size_string(instance: *mut c_void, images: *mut c_void, landmarks: *mut c_void, configfile: *mut c_char, scale: *const core::Size, model_filename: *mut c_char) -> Result<bool>;
		pub fn cv_face_FacemarkKazemi_setFaceDetector_bool__X__const_cv__InputArrayR__const_cv__OutputArrayR__voidX__voidX(instance: *mut c_void, f: Option<unsafe extern "C" fn(*const c_void, *const c_void, *mut c_void) -> bool>, user_data: *mut c_void) -> Result<bool>;
		pub fn cv_face_FacemarkKazemi_getFaces_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void) -> Result<bool>;
		pub fn cv_face_FacemarkKazemi_Params_getPropCascade_depth_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropCascade_depth_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropTree_depth_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropTree_depth_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropNum_trees_per_cascade_level_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropNum_trees_per_cascade_level_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropLearning_rate_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkKazemi_Params_setPropLearning_rate_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkKazemi_Params_getPropOversampling_amount_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropOversampling_amount_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropNum_test_coordinates_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropNum_test_coordinates_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropLambda_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkKazemi_Params_setPropLambda_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkKazemi_Params_getPropNum_test_splits_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_setPropNum_test_splits_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_getPropConfigfile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkKazemi_Params_setPropConfigfile_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_face_FacemarkKazemi_Params_Params() -> Result<*mut c_void>;
		pub fn cv_face_FacemarkLBF_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_FacemarkLBF_Params_getPropShape_offset_const(instance: *const c_void) -> f64;
		pub fn cv_face_FacemarkLBF_Params_setPropShape_offset_double(instance: *mut c_void, val: f64);
		pub fn cv_face_FacemarkLBF_Params_getPropCascade_face_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_setPropCascade_face_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_face_FacemarkLBF_Params_getPropVerbose_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkLBF_Params_setPropVerbose_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkLBF_Params_getPropN_landmarks_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_setPropN_landmarks_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_getPropInitShape_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_setPropInitShape_n_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_getPropStages_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_setPropStages_n_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_getPropTree_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_setPropTree_n_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_getPropTree_depth_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_setPropTree_depth_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_getPropBagging_overlap_const(instance: *const c_void) -> f64;
		pub fn cv_face_FacemarkLBF_Params_setPropBagging_overlap_double(instance: *mut c_void, val: f64);
		pub fn cv_face_FacemarkLBF_Params_getPropModel_filename_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_setPropModel_filename_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_face_FacemarkLBF_Params_getPropSave_model_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkLBF_Params_setPropSave_model_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkLBF_Params_getPropSeed_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkLBF_Params_setPropSeed_unsigned_int(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkLBF_Params_getPropFeats_m_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_setPropFeats_m_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkLBF_Params_getPropRadius_m_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_setPropRadius_m_vector_double_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_face_FacemarkLBF_Params_getPropDetectROI_const(instance: *const c_void) -> core::Rect;
		pub fn cv_face_FacemarkLBF_Params_setPropDetectROI_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_face_FacemarkLBF_Params_Params() -> Result<*mut c_void>;
		pub fn cv_face_FacemarkLBF_Params_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_face_FacemarkLBF_Params_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_face_FacemarkTrain_addTrainingSample_const__InputArrayR_const__InputArrayR(instance: *mut c_void, image: *const c_void, landmarks: *const c_void) -> Result<bool>;
		pub fn cv_face_FacemarkTrain_training_voidX(instance: *mut c_void, parameters: *mut c_void) -> Result_void;
		pub fn cv_face_FacemarkTrain_setFaceDetector_FN_FaceDetector_voidX(instance: *mut c_void, detector: Option<unsafe extern "C" fn(*const c_void, *const c_void, *mut c_void) -> bool>, user_data: *mut c_void) -> Result<bool>;
		pub fn cv_face_FacemarkTrain_getFaces_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void) -> Result<bool>;
		pub fn cv_face_FacemarkTrain_getData_voidX(instance: *mut c_void, items: *mut c_void) -> Result<bool>;
		pub fn cv_face_FisherFaceRecognizer_create_int_double(num_components: i32, threshold: f64) -> Result<*mut c_void>;
		pub fn cv_face_LBPHFaceRecognizer_getGridX_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_LBPHFaceRecognizer_setGridX_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_face_LBPHFaceRecognizer_getGridY_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_LBPHFaceRecognizer_setGridY_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_face_LBPHFaceRecognizer_getRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_LBPHFaceRecognizer_setRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_face_LBPHFaceRecognizer_getNeighbors_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_LBPHFaceRecognizer_setNeighbors_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_face_LBPHFaceRecognizer_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_face_LBPHFaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_face_LBPHFaceRecognizer_getHistograms_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_LBPHFaceRecognizer_getLabels_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_face_LBPHFaceRecognizer_create_int_int_int_int_double(radius: i32, neighbors: i32, grid_x: i32, grid_y: i32, threshold: f64) -> Result<*mut c_void>;
		pub fn cv_face_MACE_salt_const_StringR(instance: *mut c_void, passphrase: *const c_char) -> Result_void;
		pub fn cv_face_MACE_train_const__InputArrayR(instance: *mut c_void, images: *const c_void) -> Result_void;
		pub fn cv_face_MACE_same_const_const__InputArrayR(instance: *const c_void, query: *const c_void) -> Result<bool>;
		pub fn cv_face_MACE_load_const_StringR_const_StringR(filename: *const c_char, objname: *const c_char) -> Result<*mut c_void>;
		pub fn cv_face_MACE_create_int(imgsize: i32) -> Result<*mut c_void>;
		pub fn cv_face_PredictCollector_init_size_t(instance: *mut c_void, size: size_t) -> Result_void;
		pub fn cv_face_PredictCollector_collect_int_double(instance: *mut c_void, label: i32, dist: f64) -> Result<bool>;
		pub fn cv_face_StandardCollector_StandardCollector_double(threshold_: f64) -> Result<*mut c_void>;
		pub fn cv_face_StandardCollector_init_size_t(instance: *mut c_void, size: size_t) -> Result_void;
		pub fn cv_face_StandardCollector_collect_int_double(instance: *mut c_void, label: i32, dist: f64) -> Result<bool>;
		pub fn cv_face_StandardCollector_getMinLabel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_face_StandardCollector_getMinDist_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_face_StandardCollector_create_double(threshold: f64) -> Result<*mut c_void>;
		pub fn cv_face_StandardCollector_PredictResult_PredictResult_int_double(label_: i32, distance_: f64) -> Result<crate::face::StandardCollector_PredictResult>;
	}
}
#[cfg(ocvrs_has_module_face)]
pub use face_sys::*;

#[cfg(ocvrs_has_module_features2d)]
mod features2d_sys {
	use super::*;

	extern "C" {
		pub fn cv_AGAST_const__InputArrayR_vector_KeyPoint_R_int_bool(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool) -> Result_void;
		pub fn cv_AGAST_const__InputArrayR_vector_KeyPoint_R_int_bool_DetectorType(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, typ: crate::features2d::AgastFeatureDetector_DetectorType) -> Result_void;
		pub fn cv_FAST_const__InputArrayR_vector_KeyPoint_R_int_bool(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool) -> Result_void;
		pub fn cv_FAST_const__InputArrayR_vector_KeyPoint_R_int_bool_DetectorType(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, typ: crate::features2d::FastFeatureDetector_DetectorType) -> Result_void;
		pub fn cv_computeRecallPrecisionCurve_const_vector_vector_DMatch__R_const_vector_vector_unsigned_char__R_vector_Point2f_R(matches1to2: *const c_void, correct_matches1to2_mask: *const c_void, recall_precision_curve: *mut c_void) -> Result_void;
		pub fn cv_drawKeypoints_const__InputArrayR_const_vector_KeyPoint_R_const__InputOutputArrayR_const_ScalarR_DrawMatchesFlags(image: *const c_void, keypoints: *const c_void, out_image: *const c_void, color: *const core::Scalar, flags: crate::features2d::DrawMatchesFlags) -> Result_void;
		pub fn cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_DMatch_R_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vector_char_R_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags) -> Result_void;
		pub fn cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_DMatch_R_const__InputOutputArrayR_const_int_const_ScalarR_const_ScalarR_const_vector_char_R_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, matches_thickness: i32, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags) -> Result_void;
		pub fn cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_vector_DMatch__R_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vector_vector_char__R_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags) -> Result_void;
		pub fn cv_evaluateFeatureDetector_const_MatR_const_MatR_const_MatR_vector_KeyPoint_X_vector_KeyPoint_X_floatR_intR_const_Ptr_Feature2D_R(img1: *const c_void, img2: *const c_void, h1to2: *const c_void, keypoints1: *mut c_void, keypoints2: *mut c_void, repeatability: *mut f32, corresp_count: *mut i32, fdetector: *const c_void) -> Result_void;
		pub fn cv_getNearestPoint_const_vector_Point2f_R_float(recall_precision_curve: *const c_void, l_precision: f32) -> Result<i32>;
		pub fn cv_getRecall_const_vector_Point2f_R_float(recall_precision_curve: *const c_void, l_precision: f32) -> Result<f32>;
		pub fn cv_AKAZE_create_DescriptorType_int_int_float_int_int_DiffusivityType(descriptor_type: crate::features2d::AKAZE_DescriptorType, descriptor_size: i32, descriptor_channels: i32, threshold: f32, n_octaves: i32, n_octave_layers: i32, diffusivity: crate::features2d::KAZE_DiffusivityType) -> Result<*mut c_void>;
		pub fn cv_AKAZE_setDescriptorType_DescriptorType(instance: *mut c_void, dtype: crate::features2d::AKAZE_DescriptorType) -> Result_void;
		pub fn cv_AKAZE_getDescriptorType_const(instance: *const c_void) -> Result<crate::features2d::AKAZE_DescriptorType>;
		pub fn cv_AKAZE_setDescriptorSize_int(instance: *mut c_void, dsize: i32) -> Result_void;
		pub fn cv_AKAZE_getDescriptorSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AKAZE_setDescriptorChannels_int(instance: *mut c_void, dch: i32) -> Result_void;
		pub fn cv_AKAZE_getDescriptorChannels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AKAZE_setThreshold_double(instance: *mut c_void, threshold: f64) -> Result_void;
		pub fn cv_AKAZE_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_AKAZE_setNOctaves_int(instance: *mut c_void, octaves: i32) -> Result_void;
		pub fn cv_AKAZE_getNOctaves_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AKAZE_setNOctaveLayers_int(instance: *mut c_void, octave_layers: i32) -> Result_void;
		pub fn cv_AKAZE_getNOctaveLayers_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AKAZE_setDiffusivity_DiffusivityType(instance: *mut c_void, diff: crate::features2d::KAZE_DiffusivityType) -> Result_void;
		pub fn cv_AKAZE_getDiffusivity_const(instance: *const c_void) -> Result<crate::features2d::KAZE_DiffusivityType>;
		pub fn cv_AKAZE_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_AffineFeature_create_const_Ptr_Feature2D_R_int_int_float_float(backend: *const c_void, max_tilt: i32, min_tilt: i32, tilt_step: f32, rotate_step_base: f32) -> Result<*mut c_void>;
		pub fn cv_AffineFeature_setViewParams_const_vector_float_R_const_vector_float_R(instance: *mut c_void, tilts: *const c_void, rolls: *const c_void) -> Result_void;
		pub fn cv_AffineFeature_getViewParams_const_vector_float_R_vector_float_R(instance: *const c_void, tilts: *mut c_void, rolls: *mut c_void) -> Result_void;
		pub fn cv_AffineFeature_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_AgastFeatureDetector_create_int_bool_DetectorType(threshold: i32, nonmax_suppression: bool, typ: crate::features2d::AgastFeatureDetector_DetectorType) -> Result<*mut c_void>;
		pub fn cv_AgastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32) -> Result_void;
		pub fn cv_AgastFeatureDetector_getThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AgastFeatureDetector_setNonmaxSuppression_bool(instance: *mut c_void, f: bool) -> Result_void;
		pub fn cv_AgastFeatureDetector_getNonmaxSuppression_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_AgastFeatureDetector_setType_DetectorType(instance: *mut c_void, typ: crate::features2d::AgastFeatureDetector_DetectorType) -> Result_void;
		pub fn cv_AgastFeatureDetector_getType_const(instance: *const c_void) -> Result<crate::features2d::AgastFeatureDetector_DetectorType>;
		pub fn cv_AgastFeatureDetector_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BFMatcher_BFMatcher_int_bool(norm_type: i32, cross_check: bool) -> Result<*mut c_void>;
		pub fn cv_BFMatcher_isMaskSupported_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_BFMatcher_create_int_bool(norm_type: i32, cross_check: bool) -> Result<*mut c_void>;
		pub fn cv_BFMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool) -> Result<*mut c_void>;
		pub fn cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_Ptr_Feature2D_R_const_Ptr_DescriptorMatcher_R(dextractor: *const c_void, dmatcher: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_Ptr_DescriptorMatcher_R(dmatcher: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWImgDescriptorExtractor_setVocabulary_const_MatR(instance: *mut c_void, vocabulary: *const c_void) -> Result_void;
		pub fn cv_BOWImgDescriptorExtractor_getVocabulary_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR_vector_vector_int__X_MatX(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, img_descriptor: *const c_void, point_idxs_of_clusters: *mut c_void, descriptors: *mut c_void) -> Result_void;
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_const__OutputArrayR_vector_vector_int__X(instance: *mut c_void, keypoint_descriptors: *const c_void, img_descriptor: *const c_void, point_idxs_of_clusters: *mut c_void) -> Result_void;
		pub fn cv_BOWImgDescriptorExtractor_compute2_const_MatR_vector_KeyPoint_R_MatR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, img_descriptor: *mut c_void) -> Result_void;
		pub fn cv_BOWImgDescriptorExtractor_descriptorSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BOWImgDescriptorExtractor_descriptorType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BOWKMeansTrainer_BOWKMeansTrainer_int_const_TermCriteriaR_int_int(cluster_count: i32, termcrit: *const core::TermCriteria, attempts: i32, flags: i32) -> Result<*mut c_void>;
		pub fn cv_BOWKMeansTrainer_cluster_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWKMeansTrainer_cluster_const_const_MatR(instance: *const c_void, descriptors: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWTrainer_add_const_MatR(instance: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_BOWTrainer_getDescriptors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWTrainer_descriptorsCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BOWTrainer_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_BOWTrainer_cluster_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BOWTrainer_cluster_const_const_MatR(instance: *const c_void, descriptors: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BRISK_create_int_int_float(thresh: i32, octaves: i32, pattern_scale: f32) -> Result<*mut c_void>;
		pub fn cv_BRISK_create_const_vector_float_R_const_vector_int_R_float_float_const_vector_int_R(radius_list: *const c_void, number_list: *const c_void, d_max: f32, d_min: f32, index_change: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BRISK_create_int_int_const_vector_float_R_const_vector_int_R_float_float_const_vector_int_R(thresh: i32, octaves: i32, radius_list: *const c_void, number_list: *const c_void, d_max: f32, d_min: f32, index_change: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BRISK_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BRISK_setThreshold_int(instance: *mut c_void, threshold: i32) -> Result_void;
		pub fn cv_BRISK_getThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BRISK_setOctaves_int(instance: *mut c_void, octaves: i32) -> Result_void;
		pub fn cv_BRISK_getOctaves_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DescriptorMatcher_add_const__InputArrayR(instance: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_getTrainDescriptors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_DescriptorMatcher_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_DescriptorMatcher_isMaskSupported_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_DescriptorMatcher_train(instance: *mut c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_match_const_const__InputArrayR_const__InputArrayR_vector_DMatch_R_const__InputArrayR(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_knnMatch_const_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_DescriptorMatcher_radiusMatch_const_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_DescriptorMatcher_match_const__InputArrayR_vector_DMatch_R_const__InputArrayR(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_knnMatch_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_DescriptorMatcher_radiusMatch_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_DescriptorMatcher_write_const_const_StringR(instance: *const c_void, file_name: *const c_char) -> Result_void;
		pub fn cv_DescriptorMatcher_read_const_StringR(instance: *mut c_void, file_name: *const c_char) -> Result_void;
		pub fn cv_DescriptorMatcher_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_DescriptorMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool) -> Result<*mut c_void>;
		pub fn cv_DescriptorMatcher_create_const_StringR(descriptor_matcher_type: *const c_char) -> Result<*mut c_void>;
		pub fn cv_DescriptorMatcher_create_const_MatcherTypeR(matcher_type: *const crate::features2d::DescriptorMatcher_MatcherType) -> Result<*mut c_void>;
		pub fn cv_DescriptorMatcher_write_const_const_Ptr_FileStorage_R_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char) -> Result_void;
		pub fn cv_FastFeatureDetector_create_int_bool_DetectorType(threshold: i32, nonmax_suppression: bool, typ: crate::features2d::FastFeatureDetector_DetectorType) -> Result<*mut c_void>;
		pub fn cv_FastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32) -> Result_void;
		pub fn cv_FastFeatureDetector_getThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FastFeatureDetector_setNonmaxSuppression_bool(instance: *mut c_void, f: bool) -> Result_void;
		pub fn cv_FastFeatureDetector_getNonmaxSuppression_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FastFeatureDetector_setType_DetectorType(instance: *mut c_void, typ: crate::features2d::FastFeatureDetector_DetectorType) -> Result_void;
		pub fn cv_FastFeatureDetector_getType_const(instance: *const c_void) -> Result<crate::features2d::FastFeatureDetector_DetectorType>;
		pub fn cv_FastFeatureDetector_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Feature2D_detect_const__InputArrayR_vector_KeyPoint_R_const__InputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_Feature2D_detect_const__InputArrayR_vector_vector_KeyPoint__R_const__InputArrayR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_Feature2D_compute_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_Feature2D_compute_const__InputArrayR_vector_vector_KeyPoint__R_const__OutputArrayR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_Feature2D_detectAndCompute_const__InputArrayR_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR_bool(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, use_provided_keypoints: bool) -> Result_void;
		pub fn cv_Feature2D_descriptorSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_Feature2D_descriptorType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_Feature2D_defaultNorm_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_Feature2D_write_const_const_StringR(instance: *const c_void, file_name: *const c_char) -> Result_void;
		pub fn cv_Feature2D_read_const_StringR(instance: *mut c_void, file_name: *const c_char) -> Result_void;
		pub fn cv_Feature2D_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_Feature2D_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_Feature2D_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_Feature2D_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Feature2D_write_const_const_Ptr_FileStorage_R_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char) -> Result_void;
		pub fn cv_FlannBasedMatcher_FlannBasedMatcher_const_Ptr_IndexParams_R_const_Ptr_SearchParams_R(index_params: *const c_void, search_params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_FlannBasedMatcher_add_const__InputArrayR(instance: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_FlannBasedMatcher_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_FlannBasedMatcher_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_FlannBasedMatcher_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_FlannBasedMatcher_train(instance: *mut c_void) -> Result_void;
		pub fn cv_FlannBasedMatcher_isMaskSupported_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FlannBasedMatcher_create() -> Result<*mut c_void>;
		pub fn cv_FlannBasedMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool) -> Result<*mut c_void>;
		pub fn cv_GFTTDetector_create_int_double_double_int_bool_double(max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, use_harris_detector: bool, k: f64) -> Result<*mut c_void>;
		pub fn cv_GFTTDetector_create_int_double_double_int_int_bool_double(max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, gradiant_size: i32, use_harris_detector: bool, k: f64) -> Result<*mut c_void>;
		pub fn cv_GFTTDetector_setMaxFeatures_int(instance: *mut c_void, max_features: i32) -> Result_void;
		pub fn cv_GFTTDetector_getMaxFeatures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GFTTDetector_setQualityLevel_double(instance: *mut c_void, qlevel: f64) -> Result_void;
		pub fn cv_GFTTDetector_getQualityLevel_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GFTTDetector_setMinDistance_double(instance: *mut c_void, min_distance: f64) -> Result_void;
		pub fn cv_GFTTDetector_getMinDistance_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GFTTDetector_setBlockSize_int(instance: *mut c_void, block_size: i32) -> Result_void;
		pub fn cv_GFTTDetector_getBlockSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GFTTDetector_setHarrisDetector_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_GFTTDetector_getHarrisDetector_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_GFTTDetector_setK_double(instance: *mut c_void, k: f64) -> Result_void;
		pub fn cv_GFTTDetector_getK_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GFTTDetector_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_KAZE_create_bool_bool_float_int_int_DiffusivityType(extended: bool, upright: bool, threshold: f32, n_octaves: i32, n_octave_layers: i32, diffusivity: crate::features2d::KAZE_DiffusivityType) -> Result<*mut c_void>;
		pub fn cv_KAZE_setExtended_bool(instance: *mut c_void, extended: bool) -> Result_void;
		pub fn cv_KAZE_getExtended_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_KAZE_setUpright_bool(instance: *mut c_void, upright: bool) -> Result_void;
		pub fn cv_KAZE_getUpright_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_KAZE_setThreshold_double(instance: *mut c_void, threshold: f64) -> Result_void;
		pub fn cv_KAZE_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_KAZE_setNOctaves_int(instance: *mut c_void, octaves: i32) -> Result_void;
		pub fn cv_KAZE_getNOctaves_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_KAZE_setNOctaveLayers_int(instance: *mut c_void, octave_layers: i32) -> Result_void;
		pub fn cv_KAZE_getNOctaveLayers_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_KAZE_setDiffusivity_DiffusivityType(instance: *mut c_void, diff: crate::features2d::KAZE_DiffusivityType) -> Result_void;
		pub fn cv_KAZE_getDiffusivity_const(instance: *const c_void) -> Result<crate::features2d::KAZE_DiffusivityType>;
		pub fn cv_KAZE_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_KeyPointsFilter_KeyPointsFilter() -> Result<*mut c_void>;
		pub fn cv_KeyPointsFilter_runByImageBorder_vector_KeyPoint_R_Size_int(keypoints: *mut c_void, image_size: *const core::Size, border_size: i32) -> Result_void;
		pub fn cv_KeyPointsFilter_runByKeypointSize_vector_KeyPoint_R_float_float(keypoints: *mut c_void, min_size: f32, max_size: f32) -> Result_void;
		pub fn cv_KeyPointsFilter_runByPixelsMask_vector_KeyPoint_R_const_MatR(keypoints: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_KeyPointsFilter_removeDuplicated_vector_KeyPoint_R(keypoints: *mut c_void) -> Result_void;
		pub fn cv_KeyPointsFilter_removeDuplicatedSorted_vector_KeyPoint_R(keypoints: *mut c_void) -> Result_void;
		pub fn cv_KeyPointsFilter_retainBest_vector_KeyPoint_R_int(keypoints: *mut c_void, npoints: i32) -> Result_void;
		pub fn cv_MSER_create_int_int_int_double_double_int_double_double_int(delta: i32, min_area: i32, max_area: i32, max_variation: f64, min_diversity: f64, max_evolution: i32, area_threshold: f64, min_margin: f64, edge_blur_size: i32) -> Result<*mut c_void>;
		pub fn cv_MSER_detectRegions_const__InputArrayR_vector_vector_Point__R_vector_Rect_R(instance: *mut c_void, image: *const c_void, msers: *mut c_void, bboxes: *mut c_void) -> Result_void;
		pub fn cv_MSER_setDelta_int(instance: *mut c_void, delta: i32) -> Result_void;
		pub fn cv_MSER_getDelta_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_MSER_setMinArea_int(instance: *mut c_void, min_area: i32) -> Result_void;
		pub fn cv_MSER_getMinArea_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_MSER_setMaxArea_int(instance: *mut c_void, max_area: i32) -> Result_void;
		pub fn cv_MSER_getMaxArea_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_MSER_setPass2Only_bool(instance: *mut c_void, f: bool) -> Result_void;
		pub fn cv_MSER_getPass2Only_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_MSER_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ORB_create_int_float_int_int_int_int_ScoreType_int_int(nfeatures: i32, scale_factor: f32, nlevels: i32, edge_threshold: i32, first_level: i32, wta_k: i32, score_type: crate::features2d::ORB_ScoreType, patch_size: i32, fast_threshold: i32) -> Result<*mut c_void>;
		pub fn cv_ORB_setMaxFeatures_int(instance: *mut c_void, max_features: i32) -> Result_void;
		pub fn cv_ORB_getMaxFeatures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setScaleFactor_double(instance: *mut c_void, scale_factor: f64) -> Result_void;
		pub fn cv_ORB_getScaleFactor_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ORB_setNLevels_int(instance: *mut c_void, nlevels: i32) -> Result_void;
		pub fn cv_ORB_getNLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setEdgeThreshold_int(instance: *mut c_void, edge_threshold: i32) -> Result_void;
		pub fn cv_ORB_getEdgeThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setFirstLevel_int(instance: *mut c_void, first_level: i32) -> Result_void;
		pub fn cv_ORB_getFirstLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setWTA_K_int(instance: *mut c_void, wta_k: i32) -> Result_void;
		pub fn cv_ORB_getWTA_K_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setScoreType_ScoreType(instance: *mut c_void, score_type: crate::features2d::ORB_ScoreType) -> Result_void;
		pub fn cv_ORB_getScoreType_const(instance: *const c_void) -> Result<crate::features2d::ORB_ScoreType>;
		pub fn cv_ORB_setPatchSize_int(instance: *mut c_void, patch_size: i32) -> Result_void;
		pub fn cv_ORB_getPatchSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_setFastThreshold_int(instance: *mut c_void, fast_threshold: i32) -> Result_void;
		pub fn cv_ORB_getFastThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ORB_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SIFT_create_int_int_double_double_double(nfeatures: i32, n_octave_layers: i32, contrast_threshold: f64, edge_threshold: f64, sigma: f64) -> Result<*mut c_void>;
		pub fn cv_SIFT_create_int_int_double_double_double_int(nfeatures: i32, n_octave_layers: i32, contrast_threshold: f64, edge_threshold: f64, sigma: f64, descriptor_type: i32) -> Result<*mut c_void>;
		pub fn cv_SIFT_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SimpleBlobDetector_create_const_ParamsR(parameters: *const crate::features2d::SimpleBlobDetector_Params) -> Result<*mut c_void>;
		pub fn cv_SimpleBlobDetector_getDefaultName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SimpleBlobDetector_Params_Params() -> Result<crate::features2d::SimpleBlobDetector_Params>;
		pub fn cv_SimpleBlobDetector_Params_read_const_FileNodeR(instance: *const crate::features2d::SimpleBlobDetector_Params, fn_: *const c_void) -> Result_void;
		pub fn cv_SimpleBlobDetector_Params_write_const_FileStorageR(instance: *const crate::features2d::SimpleBlobDetector_Params, fs: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_features2d)]
pub use features2d_sys::*;

#[cfg(ocvrs_has_module_flann)]
mod flann_sys {
	use super::*;

	extern "C" {
		pub fn cvflann_flann_distance_type() -> Result<crate::flann::flann_distance_t>;
		pub fn cvflann_set_distance_type_flann_distance_t_int(distance_type: crate::flann::flann_distance_t, order: i32) -> Result_void;
		pub fn cv_flann_AutotunedIndexParams_AutotunedIndexParams_float_float_float_float(target_precision: f32, build_weight: f32, memory_weight: f32, sample_fraction: f32) -> Result<*mut c_void>;
		pub fn cv_flann_CompositeIndexParams_CompositeIndexParams_int_int_int_flann_centers_init_t_float(trees: i32, branching: i32, iterations: i32, centers_init: crate::flann::flann_centers_init_t, cb_index: f32) -> Result<*mut c_void>;
		pub fn cv_flann_HierarchicalClusteringIndexParams_HierarchicalClusteringIndexParams_int_flann_centers_init_t_int_int(branching: i32, centers_init: crate::flann::flann_centers_init_t, trees: i32, leaf_size: i32) -> Result<*mut c_void>;
		pub fn cv_flann_Index_Index() -> Result<*mut c_void>;
		pub fn cv_flann_Index_Index_const__InputArrayR_const_IndexParamsR_flann_distance_t(features: *const c_void, params: *const c_void, dist_type: crate::flann::flann_distance_t) -> Result<*mut c_void>;
		pub fn cv_flann_Index_build_const__InputArrayR_const_IndexParamsR_flann_distance_t(instance: *mut c_void, features: *const c_void, params: *const c_void, dist_type: crate::flann::flann_distance_t) -> Result_void;
		pub fn cv_flann_Index_knnSearch_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_SearchParamsR(instance: *mut c_void, query: *const c_void, indices: *const c_void, dists: *const c_void, knn: i32, params: *const c_void) -> Result_void;
		pub fn cv_flann_Index_radiusSearch_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_int_const_SearchParamsR(instance: *mut c_void, query: *const c_void, indices: *const c_void, dists: *const c_void, radius: f64, max_results: i32, params: *const c_void) -> Result<i32>;
		pub fn cv_flann_Index_save_const_const_StringR(instance: *const c_void, filename: *const c_char) -> Result_void;
		pub fn cv_flann_Index_load_const__InputArrayR_const_StringR(instance: *mut c_void, features: *const c_void, filename: *const c_char) -> Result<bool>;
		pub fn cv_flann_Index_release(instance: *mut c_void) -> Result_void;
		pub fn cv_flann_Index_getDistance_const(instance: *const c_void) -> Result<crate::flann::flann_distance_t>;
		pub fn cv_flann_Index_getAlgorithm_const(instance: *const c_void) -> Result<crate::flann::flann_algorithm_t>;
		pub fn cv_flann_IndexParams_getPropParams(instance: *mut c_void) -> *mut c_void;
		pub fn cv_flann_IndexParams_setPropParams_voidX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_flann_IndexParams_IndexParams() -> Result<*mut c_void>;
		pub fn cv_flann_IndexParams_getString_const_const_StringR_const_StringR(instance: *const c_void, key: *const c_char, default_val: *const c_char) -> Result<*mut c_void>;
		pub fn cv_flann_IndexParams_getInt_const_const_StringR_int(instance: *const c_void, key: *const c_char, default_val: i32) -> Result<i32>;
		pub fn cv_flann_IndexParams_getDouble_const_const_StringR_double(instance: *const c_void, key: *const c_char, default_val: f64) -> Result<f64>;
		pub fn cv_flann_IndexParams_setString_const_StringR_const_StringR(instance: *mut c_void, key: *const c_char, value: *const c_char) -> Result_void;
		pub fn cv_flann_IndexParams_setInt_const_StringR_int(instance: *mut c_void, key: *const c_char, value: i32) -> Result_void;
		pub fn cv_flann_IndexParams_setDouble_const_StringR_double(instance: *mut c_void, key: *const c_char, value: f64) -> Result_void;
		pub fn cv_flann_IndexParams_setFloat_const_StringR_float(instance: *mut c_void, key: *const c_char, value: f32) -> Result_void;
		pub fn cv_flann_IndexParams_setBool_const_StringR_bool(instance: *mut c_void, key: *const c_char, value: bool) -> Result_void;
		pub fn cv_flann_IndexParams_setAlgorithm_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_flann_IndexParams_getAll_const_vector_String_R_vector_FlannIndexType_R_vector_String_R_vector_double_R(instance: *const c_void, names: *mut c_void, types: *mut c_void, str_values: *mut c_void, num_values: *mut c_void) -> Result_void;
		pub fn cv_flann_KDTreeIndexParams_KDTreeIndexParams_int(trees: i32) -> Result<*mut c_void>;
		pub fn cv_flann_KMeansIndexParams_KMeansIndexParams_int_int_flann_centers_init_t_float(branching: i32, iterations: i32, centers_init: crate::flann::flann_centers_init_t, cb_index: f32) -> Result<*mut c_void>;
		pub fn cv_flann_LinearIndexParams_LinearIndexParams() -> Result<*mut c_void>;
		pub fn cv_flann_LshIndexParams_LshIndexParams_int_int_int(table_number: i32, key_size: i32, multi_probe_level: i32) -> Result<*mut c_void>;
		pub fn cv_flann_SavedIndexParams_SavedIndexParams_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_flann_SearchParams_SearchParams_int_float_bool_bool(checks: i32, eps: f32, sorted: bool, explore_all_trees: bool) -> Result<*mut c_void>;
		pub fn cv_flann_SearchParams_SearchParams_int_float_bool(checks: i32, eps: f32, sorted: bool) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_flann)]
pub use flann_sys::*;

#[cfg(ocvrs_has_module_freetype)]
mod freetype_sys {
	use super::*;

	extern "C" {
		pub fn cv_freetype_createFreeType2() -> Result<*mut c_void>;
		pub fn cv_freetype_FreeType2_loadFontData_String_int(instance: *mut c_void, font_file_name: *mut c_char, id: i32) -> Result_void;
		pub fn cv_freetype_FreeType2_setSplitNumber_int(instance: *mut c_void, num: i32) -> Result_void;
		pub fn cv_freetype_FreeType2_putText_const__InputOutputArrayR_const_StringR_Point_int_Scalar_int_int_bool(instance: *mut c_void, img: *const c_void, text: *const c_char, org: *const core::Point, font_height: i32, color: *const core::Scalar, thickness: i32, line_type: i32, bottom_left_origin: bool) -> Result_void;
		pub fn cv_freetype_FreeType2_getTextSize_const_StringR_int_int_intX(instance: *mut c_void, text: *const c_char, font_height: i32, thickness: i32, base_line: *mut i32) -> Result<core::Size>;
	}
}
#[cfg(ocvrs_has_module_freetype)]
pub use freetype_sys::*;

#[cfg(ocvrs_has_module_fuzzy)]
mod fuzzy_sys {
	use super::*;

	extern "C" {
		pub fn cv_ft_FT02D_FL_process_const__InputArrayR_const_int_const__OutputArrayR(matrix: *const c_void, radius: i32, output: *const c_void) -> Result_void;
		pub fn cv_ft_FT02D_FL_process_float_const__InputArrayR_const_int_const__OutputArrayR(matrix: *const c_void, radius: i32, output: *const c_void) -> Result_void;
		pub fn cv_ft_FT02D_components_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(matrix: *const c_void, kernel: *const c_void, components: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_ft_FT02D_inverseFT_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int(components: *const c_void, kernel: *const c_void, output: *const c_void, width: i32, height: i32) -> Result_void;
		pub fn cv_ft_FT02D_iteration_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__OutputArrayR_bool(matrix: *const c_void, kernel: *const c_void, output: *const c_void, mask: *const c_void, mask_output: *const c_void, first_stop: bool) -> Result<i32>;
		pub fn cv_ft_FT02D_process_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(matrix: *const c_void, kernel: *const c_void, output: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_ft_FT12D_components_const__InputArrayR_const__InputArrayR_const__OutputArrayR(matrix: *const c_void, kernel: *const c_void, components: *const c_void) -> Result_void;
		pub fn cv_ft_FT12D_createPolynomMatrixHorizontal_int_const__OutputArrayR_const_int(radius: i32, matrix: *const c_void, chn: i32) -> Result_void;
		pub fn cv_ft_FT12D_createPolynomMatrixVertical_int_const__OutputArrayR_const_int(radius: i32, matrix: *const c_void, chn: i32) -> Result_void;
		pub fn cv_ft_FT12D_inverseFT_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int(components: *const c_void, kernel: *const c_void, output: *const c_void, width: i32, height: i32) -> Result_void;
		pub fn cv_ft_FT12D_polynomial_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(matrix: *const c_void, kernel: *const c_void, c00: *const c_void, c10: *const c_void, c01: *const c_void, components: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_ft_FT12D_process_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(matrix: *const c_void, kernel: *const c_void, output: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_ft_createKernel_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_int(a: *const c_void, b: *const c_void, kernel: *const c_void, chn: i32) -> Result_void;
		pub fn cv_ft_createKernel_int_int_const__OutputArrayR_const_int(function: i32, radius: i32, kernel: *const c_void, chn: i32) -> Result_void;
		pub fn cv_ft_filter_const__InputArrayR_const__InputArrayR_const__OutputArrayR(image: *const c_void, kernel: *const c_void, output: *const c_void) -> Result_void;
		pub fn cv_ft_inpaint_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_int(image: *const c_void, mask: *const c_void, output: *const c_void, radius: i32, function: i32, algorithm: i32) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_fuzzy)]
pub use fuzzy_sys::*;

#[cfg(ocvrs_has_module_hdf)]
mod hdf_sys {
	use super::*;

	extern "C" {
		pub fn cv_hdf_open_const_StringR(hdf5_filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_hdf_HDF5_close(instance: *mut c_void) -> Result_void;
		pub fn cv_hdf_HDF5_grcreate_const_StringR(instance: *mut c_void, grlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_hlexists_const_const_StringR(instance: *const c_void, label: *const c_char) -> Result<bool>;
		pub fn cv_hdf_HDF5_atexists_const_const_StringR(instance: *const c_void, atlabel: *const c_char) -> Result<bool>;
		pub fn cv_hdf_HDF5_atdelete_const_StringR(instance: *mut c_void, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atwrite_const_int_const_StringR(instance: *mut c_void, value: i32, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atread_intX_const_StringR(instance: *mut c_void, value: *mut i32, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atwrite_const_double_const_StringR(instance: *mut c_void, value: f64, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atread_doubleX_const_StringR(instance: *mut c_void, value: *mut f64, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atwrite_const_StringR_const_StringR(instance: *mut c_void, value: *const c_char, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atread_StringX_const_StringR(instance: *mut c_void, value: *mut *mut c_void, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atwrite_const__InputArrayR_const_StringR(instance: *mut c_void, value: *const c_void, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_atread_const__OutputArrayR_const_StringR(instance: *mut c_void, value: *const c_void, atlabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_int_const_int_const_StringR(instance: *const c_void, rows: i32, cols: i32, typ: i32, dslabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_int_const_int_const_StringR_const_int(instance: *const c_void, rows: i32, cols: i32, typ: i32, dslabel: *const c_char, compresslevel: i32) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_int_const_int_const_StringR_const_int_const_vector_int_R(instance: *const c_void, rows: i32, cols: i32, typ: i32, dslabel: *const c_char, compresslevel: i32, dims_chunks: *const c_void) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_int_const_int_const_StringR_const_int_const_intX(instance: *const c_void, rows: i32, cols: i32, typ: i32, dslabel: *const c_char, compresslevel: i32, dims_chunks: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_intX_const_int_const_StringR(instance: *const c_void, n_dims: i32, sizes: *const i32, typ: i32, dslabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_intX_const_int_const_StringR_const_int(instance: *const c_void, n_dims: i32, sizes: *const i32, typ: i32, dslabel: *const c_char, compresslevel: i32) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_vector_int_R_const_int_const_StringR_const_int_const_vector_int_R(instance: *const c_void, sizes: *const c_void, typ: i32, dslabel: *const c_char, compresslevel: i32, dims_chunks: *const c_void) -> Result_void;
		pub fn cv_hdf_HDF5_dscreate_const_const_int_const_intX_const_int_const_StringR_const_int_const_intX(instance: *const c_void, n_dims: i32, sizes: *const i32, typ: i32, dslabel: *const c_char, compresslevel: i32, dims_chunks: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dsgetsize_const_const_StringR_int(instance: *const c_void, dslabel: *const c_char, dims_flag: i32) -> Result<*mut c_void>;
		pub fn cv_hdf_HDF5_dsgettype_const_const_StringR(instance: *const c_void, dslabel: *const c_char) -> Result<i32>;
		pub fn cv_hdf_HDF5_dswrite_const_const__InputArrayR_const_StringR(instance: *const c_void, array: *const c_void, dslabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dswrite_const_const__InputArrayR_const_StringR_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dswrite_const_const__InputArrayR_const_StringR_const_vector_int_R_const_vector_int_R(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const c_void, dims_counts: *const c_void) -> Result_void;
		pub fn cv_hdf_HDF5_dswrite_const_const__InputArrayR_const_StringR_const_intX_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32, dims_counts: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dsinsert_const_const__InputArrayR_const_StringR(instance: *const c_void, array: *const c_void, dslabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dsinsert_const_const__InputArrayR_const_StringR_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dsinsert_const_const__InputArrayR_const_StringR_const_vector_int_R_const_vector_int_R(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const c_void, dims_counts: *const c_void) -> Result_void;
		pub fn cv_hdf_HDF5_dsinsert_const_const__InputArrayR_const_StringR_const_intX_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32, dims_counts: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dsread_const_const__OutputArrayR_const_StringR(instance: *const c_void, array: *const c_void, dslabel: *const c_char) -> Result_void;
		pub fn cv_hdf_HDF5_dsread_const_const__OutputArrayR_const_StringR_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_dsread_const_const__OutputArrayR_const_StringR_const_vector_int_R_const_vector_int_R(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const c_void, dims_counts: *const c_void) -> Result_void;
		pub fn cv_hdf_HDF5_dsread_const_const__OutputArrayR_const_StringR_const_intX_const_intX(instance: *const c_void, array: *const c_void, dslabel: *const c_char, dims_offset: *const i32, dims_counts: *const i32) -> Result_void;
		pub fn cv_hdf_HDF5_kpgetsize_const_const_StringR_int(instance: *const c_void, kplabel: *const c_char, dims_flag: i32) -> Result<i32>;
		pub fn cv_hdf_HDF5_kpcreate_const_const_int_const_StringR_const_int_const_int(instance: *const c_void, size: i32, kplabel: *const c_char, compresslevel: i32, chunks: i32) -> Result_void;
		pub fn cv_hdf_HDF5_kpwrite_const_const_vector_KeyPoint__const_StringR_const_int_const_int(instance: *const c_void, keypoints: *const c_void, kplabel: *const c_char, offset: i32, counts: i32) -> Result_void;
		pub fn cv_hdf_HDF5_kpinsert_const_const_vector_KeyPoint__const_StringR_const_int_const_int(instance: *const c_void, keypoints: *const c_void, kplabel: *const c_char, offset: i32, counts: i32) -> Result_void;
		pub fn cv_hdf_HDF5_kpread_const_vector_KeyPoint_R_const_StringR_const_int_const_int(instance: *const c_void, keypoints: *mut c_void, kplabel: *const c_char, offset: i32, counts: i32) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_hdf)]
pub use hdf_sys::*;

#[cfg(ocvrs_has_module_hfs)]
mod hfs_sys {
	use super::*;

	extern "C" {
		pub fn cv_hfs_HfsSegment_setSegEgbThresholdI_float(instance: *mut c_void, c: f32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getSegEgbThresholdI(instance: *mut c_void) -> Result<f32>;
		pub fn cv_hfs_HfsSegment_setMinRegionSizeI_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getMinRegionSizeI(instance: *mut c_void) -> Result<i32>;
		pub fn cv_hfs_HfsSegment_setSegEgbThresholdII_float(instance: *mut c_void, c: f32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getSegEgbThresholdII(instance: *mut c_void) -> Result<f32>;
		pub fn cv_hfs_HfsSegment_setMinRegionSizeII_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getMinRegionSizeII(instance: *mut c_void) -> Result<i32>;
		pub fn cv_hfs_HfsSegment_setSpatialWeight_float(instance: *mut c_void, w: f32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getSpatialWeight(instance: *mut c_void) -> Result<f32>;
		pub fn cv_hfs_HfsSegment_setSlicSpixelSize_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getSlicSpixelSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_hfs_HfsSegment_setNumSlicIter_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_hfs_HfsSegment_getNumSlicIter(instance: *mut c_void) -> Result<i32>;
		pub fn cv_hfs_HfsSegment_performSegmentGpu_const__InputArrayR_bool(instance: *mut c_void, src: *const c_void, if_draw: bool) -> Result<*mut c_void>;
		pub fn cv_hfs_HfsSegment_performSegmentCpu_const__InputArrayR_bool(instance: *mut c_void, src: *const c_void, if_draw: bool) -> Result<*mut c_void>;
		pub fn cv_hfs_HfsSegment_create_int_int_float_int_float_int_float_int_int(height: i32, width: i32, seg_egb_threshold_i: f32, min_region_size_i: i32, seg_egb_threshold_ii: f32, min_region_size_ii: i32, spatial_weight: f32, slic_spixel_size: i32, num_slic_iter: i32) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_hfs)]
pub use hfs_sys::*;

#[cfg(ocvrs_has_module_highgui)]
mod highgui_sys {
	use super::*;

	extern "C" {
		pub fn cv_addText_const_MatR_const_StringR_Point_const_QtFontR(img: *const c_void, text: *const c_char, org: *const core::Point, font: *const c_void) -> Result_void;
		pub fn cv_addText_const_MatR_const_StringR_Point_const_StringR_int_Scalar_int_int_int(img: *const c_void, text: *const c_char, org: *const core::Point, name_font: *const c_char, point_size: i32, color: *const core::Scalar, weight: i32, style: i32, spacing: i32) -> Result_void;
		pub fn cv_createButton_const_StringR_ButtonCallback_voidX_int_bool(bar_name: *const c_char, on_change: Option<unsafe extern "C" fn(i32, *mut c_void) -> ()>, userdata: *mut c_void, typ: i32, initial_button_state: bool) -> Result<i32>;
		pub fn cv_createTrackbar_const_StringR_const_StringR_intX_int_TrackbarCallback_voidX(trackbarname: *const c_char, winname: *const c_char, value: *mut i32, count: i32, on_change: Option<unsafe extern "C" fn(i32, *mut c_void) -> ()>, userdata: *mut c_void) -> Result<i32>;
		pub fn cv_destroyAllWindows() -> Result_void;
		pub fn cv_destroyWindow_const_StringR(winname: *const c_char) -> Result_void;
		pub fn cv_displayOverlay_const_StringR_const_StringR_int(winname: *const c_char, text: *const c_char, delayms: i32) -> Result_void;
		pub fn cv_displayStatusBar_const_StringR_const_StringR_int(winname: *const c_char, text: *const c_char, delayms: i32) -> Result_void;
		pub fn cv_fontQt_const_StringR_int_Scalar_int_int_int(name_font: *const c_char, point_size: i32, color: *const core::Scalar, weight: i32, style: i32, spacing: i32) -> Result<*mut c_void>;
		pub fn cv_getMouseWheelDelta_int(flags: i32) -> Result<i32>;
		pub fn cv_getTrackbarPos_const_StringR_const_StringR(trackbarname: *const c_char, winname: *const c_char) -> Result<i32>;
		pub fn cv_getWindowImageRect_const_StringR(winname: *const c_char) -> Result<core::Rect>;
		pub fn cv_getWindowProperty_const_StringR_int(winname: *const c_char, prop_id: i32) -> Result<f64>;
		pub fn cv_imshow_const_StringR_const__InputArrayR(winname: *const c_char, mat: *const c_void) -> Result_void;
		pub fn cv_loadWindowParameters_const_StringR(window_name: *const c_char) -> Result_void;
		pub fn cv_moveWindow_const_StringR_int_int(winname: *const c_char, x: i32, y: i32) -> Result_void;
		pub fn cv_namedWindow_const_StringR_int(winname: *const c_char, flags: i32) -> Result_void;
		pub fn cv_pollKey() -> Result<i32>;
		pub fn cv_resizeWindow_const_StringR_const_SizeR(winname: *const c_char, size: *const core::Size) -> Result_void;
		pub fn cv_resizeWindow_const_StringR_int_int(winname: *const c_char, width: i32, height: i32) -> Result_void;
		pub fn cv_saveWindowParameters_const_StringR(window_name: *const c_char) -> Result_void;
		pub fn cv_selectROI_const_StringR_const__InputArrayR_bool_bool(window_name: *const c_char, img: *const c_void, show_crosshair: bool, from_center: bool) -> Result<core::Rect>;
		pub fn cv_selectROI_const__InputArrayR_bool_bool(img: *const c_void, show_crosshair: bool, from_center: bool) -> Result<core::Rect>;
		pub fn cv_selectROIs_const_StringR_const__InputArrayR_vector_Rect_R_bool_bool(window_name: *const c_char, img: *const c_void, bounding_boxes: *mut c_void, show_crosshair: bool, from_center: bool) -> Result_void;
		pub fn cv_setMouseCallback_const_StringR_MouseCallback_voidX(winname: *const c_char, on_mouse: Option<unsafe extern "C" fn(i32, i32, i32, i32, *mut c_void) -> ()>, userdata: *mut c_void) -> Result_void;
		pub fn cv_setOpenGlContext_const_StringR(winname: *const c_char) -> Result_void;
		pub fn cv_setOpenGlDrawCallback_const_StringR_OpenGlDrawCallback_voidX(winname: *const c_char, on_opengl_draw: Option<unsafe extern "C" fn(*mut c_void) -> ()>, userdata: *mut c_void) -> Result_void;
		pub fn cv_setTrackbarMax_const_StringR_const_StringR_int(trackbarname: *const c_char, winname: *const c_char, maxval: i32) -> Result_void;
		pub fn cv_setTrackbarMin_const_StringR_const_StringR_int(trackbarname: *const c_char, winname: *const c_char, minval: i32) -> Result_void;
		pub fn cv_setTrackbarPos_const_StringR_const_StringR_int(trackbarname: *const c_char, winname: *const c_char, pos: i32) -> Result_void;
		pub fn cv_setWindowProperty_const_StringR_int_double(winname: *const c_char, prop_id: i32, prop_value: f64) -> Result_void;
		pub fn cv_setWindowTitle_const_StringR_const_StringR(winname: *const c_char, title: *const c_char) -> Result_void;
		pub fn cv_startLoop_int__X__int__charXX__int_charXX(pt2_func: Option<unsafe extern "C" fn(i32, *mut *mut c_char) -> i32>, argc: i32, argv: *mut *mut c_char) -> Result<i32>;
		pub fn cv_startWindowThread() -> Result<i32>;
		pub fn cv_stopLoop() -> Result_void;
		pub fn cv_updateWindow_const_StringR(winname: *const c_char) -> Result_void;
		pub fn cv_waitKeyEx_int(delay: i32) -> Result<i32>;
		pub fn cv_waitKey_int(delay: i32) -> Result<i32>;
		pub fn cv_QtFont_getPropNameFont_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_QtFont_getPropColor_const(instance: *const c_void) -> core::Scalar;
		pub fn cv_QtFont_setPropColor_Scalar(instance: *mut c_void, val: *const core::Scalar);
		pub fn cv_QtFont_getPropFont_face_const(instance: *const c_void) -> i32;
		pub fn cv_QtFont_setPropFont_face_int(instance: *mut c_void, val: i32);
		pub fn cv_QtFont_getPropAscii_const(instance: *const c_void) -> *const i32;
		pub fn cv_QtFont_getPropGreek_const(instance: *const c_void) -> *const i32;
		pub fn cv_QtFont_getPropCyrillic_const(instance: *const c_void) -> *const i32;
		pub fn cv_QtFont_getPropHscale_const(instance: *const c_void) -> f32;
		pub fn cv_QtFont_setPropHscale_float(instance: *mut c_void, val: f32);
		pub fn cv_QtFont_getPropVscale_const(instance: *const c_void) -> f32;
		pub fn cv_QtFont_setPropVscale_float(instance: *mut c_void, val: f32);
		pub fn cv_QtFont_getPropShear_const(instance: *const c_void) -> f32;
		pub fn cv_QtFont_setPropShear_float(instance: *mut c_void, val: f32);
		pub fn cv_QtFont_getPropThickness_const(instance: *const c_void) -> i32;
		pub fn cv_QtFont_setPropThickness_int(instance: *mut c_void, val: i32);
		pub fn cv_QtFont_getPropDx_const(instance: *const c_void) -> f32;
		pub fn cv_QtFont_setPropDx_float(instance: *mut c_void, val: f32);
		pub fn cv_QtFont_getPropLine_type_const(instance: *const c_void) -> i32;
		pub fn cv_QtFont_setPropLine_type_int(instance: *mut c_void, val: i32);
	}
}
#[cfg(ocvrs_has_module_highgui)]
pub use highgui_sys::*;

#[cfg(ocvrs_has_module_img_hash)]
mod img_hash_sys {
	use super::*;

	extern "C" {
		pub fn cv_img_hash_averageHash_const__InputArrayR_const__OutputArrayR(input_arr: *const c_void, output_arr: *const c_void) -> Result_void;
		pub fn cv_img_hash_blockMeanHash_const__InputArrayR_const__OutputArrayR_int(input_arr: *const c_void, output_arr: *const c_void, mode: i32) -> Result_void;
		pub fn cv_img_hash_colorMomentHash_const__InputArrayR_const__OutputArrayR(input_arr: *const c_void, output_arr: *const c_void) -> Result_void;
		pub fn cv_img_hash_marrHildrethHash_const__InputArrayR_const__OutputArrayR_float_float(input_arr: *const c_void, output_arr: *const c_void, alpha: f32, scale: f32) -> Result_void;
		pub fn cv_img_hash_pHash_const__InputArrayR_const__OutputArrayR(input_arr: *const c_void, output_arr: *const c_void) -> Result_void;
		pub fn cv_img_hash_radialVarianceHash_const__InputArrayR_const__OutputArrayR_double_int(input_arr: *const c_void, output_arr: *const c_void, sigma: f64, num_of_angle_line: i32) -> Result_void;
		pub fn cv_img_hash_AverageHash_create() -> Result<*mut c_void>;
		pub fn cv_img_hash_BlockMeanHash_setMode_int(instance: *mut c_void, mode: i32) -> Result_void;
		pub fn cv_img_hash_BlockMeanHash_getMean_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_img_hash_BlockMeanHash_create_int(mode: i32) -> Result<*mut c_void>;
		pub fn cv_img_hash_ColorMomentHash_create() -> Result<*mut c_void>;
		pub fn cv_img_hash_ImgHashBase_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_arr: *const c_void, output_arr: *const c_void) -> Result_void;
		pub fn cv_img_hash_ImgHashBase_compare_const_const__InputArrayR_const__InputArrayR(instance: *const c_void, hash_one: *const c_void, hash_two: *const c_void) -> Result<f64>;
		pub fn cv_img_hash_MarrHildrethHash_getAlpha_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_img_hash_MarrHildrethHash_getScale_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_img_hash_MarrHildrethHash_setKernelParam_float_float(instance: *mut c_void, alpha: f32, scale: f32) -> Result_void;
		pub fn cv_img_hash_MarrHildrethHash_create_float_float(alpha: f32, scale: f32) -> Result<*mut c_void>;
		pub fn cv_img_hash_PHash_create() -> Result<*mut c_void>;
		pub fn cv_img_hash_RadialVarianceHash_create_double_int(sigma: f64, num_of_angle_line: i32) -> Result<*mut c_void>;
		pub fn cv_img_hash_RadialVarianceHash_getNumOfAngleLine_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_img_hash_RadialVarianceHash_getSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_img_hash_RadialVarianceHash_setNumOfAngleLine_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_img_hash_RadialVarianceHash_setSigma_double(instance: *mut c_void, value: f64) -> Result_void;
		pub fn cv_img_hash_RadialVarianceHash_getFeatures(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_img_hash_RadialVarianceHash_getHash(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_img_hash_RadialVarianceHash_getPixPerLine_const_MatR(instance: *mut c_void, input: *const c_void) -> Result<*mut c_void>;
		pub fn cv_img_hash_RadialVarianceHash_getProjection(instance: *mut c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_img_hash)]
pub use img_hash_sys::*;

#[cfg(ocvrs_has_module_imgcodecs)]
mod imgcodecs_sys {
	use super::*;

	extern "C" {
		pub fn cv_haveImageReader_const_StringR(filename: *const c_char) -> Result<bool>;
		pub fn cv_haveImageWriter_const_StringR(filename: *const c_char) -> Result<bool>;
		pub fn cv_imcount_const_StringR_int(filename: *const c_char, flags: i32) -> Result<size_t>;
		pub fn cv_imdecode_const__InputArrayR_int(buf: *const c_void, flags: i32) -> Result<*mut c_void>;
		pub fn cv_imdecode_const__InputArrayR_int_MatX(buf: *const c_void, flags: i32, dst: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_imencode_const_StringR_const__InputArrayR_vector_unsigned_char_R_const_vector_int_R(ext: *const c_char, img: *const c_void, buf: *mut c_void, params: *const c_void) -> Result<bool>;
		pub fn cv_imread_const_StringR_int(filename: *const c_char, flags: i32) -> Result<*mut c_void>;
		pub fn cv_imreadmulti_const_StringR_vector_Mat_R_int(filename: *const c_char, mats: *mut c_void, flags: i32) -> Result<bool>;
		pub fn cv_imreadmulti_const_StringR_vector_Mat_R_int_int_int(filename: *const c_char, mats: *mut c_void, start: i32, count: i32, flags: i32) -> Result<bool>;
		pub fn cv_imwrite_const_StringR_const__InputArrayR_const_vector_int_R(filename: *const c_char, img: *const c_void, params: *const c_void) -> Result<bool>;
		pub fn cv_imwritemulti_const_StringR_const__InputArrayR_const_vector_int_R(filename: *const c_char, img: *const c_void, params: *const c_void) -> Result<bool>;
	}
}
#[cfg(ocvrs_has_module_imgcodecs)]
pub use imgcodecs_sys::*;

#[cfg(ocvrs_has_module_imgproc)]
mod imgproc_sys {
	use super::*;

	extern "C" {
		pub fn cv_Canny_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_bool(dx: *const c_void, dy: *const c_void, edges: *const c_void, threshold1: f64, threshold2: f64, l2gradient: bool) -> Result_void;
		pub fn cv_Canny_const__InputArrayR_const__OutputArrayR_double_double_int_bool(image: *const c_void, edges: *const c_void, threshold1: f64, threshold2: f64, aperture_size: i32, l2gradient: bool) -> Result_void;
		pub fn cv_EMD_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_floatX_const__OutputArrayR(signature1: *const c_void, signature2: *const c_void, dist_type: i32, cost: *const c_void, lower_bound: *mut f32, flow: *const c_void) -> Result<f32>;
		pub fn cv_GaussianBlur_const__InputArrayR_const__OutputArrayR_Size_double_double_int(src: *const c_void, dst: *const c_void, ksize: *const core::Size, sigma_x: f64, sigma_y: f64, border_type: i32) -> Result_void;
		pub fn cv_HoughCircles_const__InputArrayR_const__OutputArrayR_int_double_double_double_double_int_int(image: *const c_void, circles: *const c_void, method: i32, dp: f64, min_dist: f64, param1: f64, param2: f64, min_radius: i32, max_radius: i32) -> Result_void;
		pub fn cv_HoughLinesP_const__InputArrayR_const__OutputArrayR_double_double_int_double_double(image: *const c_void, lines: *const c_void, rho: f64, theta: f64, threshold: i32, min_line_length: f64, max_line_gap: f64) -> Result_void;
		pub fn cv_HoughLinesPointSet_const__InputArrayR_const__OutputArrayR_int_int_double_double_double_double_double_double(point: *const c_void, lines: *const c_void, lines_max: i32, threshold: i32, min_rho: f64, max_rho: f64, rho_step: f64, min_theta: f64, max_theta: f64, theta_step: f64) -> Result_void;
		pub fn cv_HoughLines_const__InputArrayR_const__OutputArrayR_double_double_int_double_double_double_double(image: *const c_void, lines: *const c_void, rho: f64, theta: f64, threshold: i32, srn: f64, stn: f64, min_theta: f64, max_theta: f64) -> Result_void;
		pub fn cv_HuMoments_const_MomentsR_const__OutputArrayR(m: *const core::Moments, hu: *const c_void) -> Result_void;
		pub fn cv_HuMoments_const_MomentsR_doubleXX(moments: *const core::Moments, hu: *mut [f64; 7]) -> Result_void;
		pub fn cv_Laplacian_const__InputArrayR_const__OutputArrayR_int_int_double_double_int(src: *const c_void, dst: *const c_void, ddepth: i32, ksize: i32, scale: f64, delta: f64, border_type: i32) -> Result_void;
		pub fn cv_Scharr_const__InputArrayR_const__OutputArrayR_int_int_int_double_double_int(src: *const c_void, dst: *const c_void, ddepth: i32, dx: i32, dy: i32, scale: f64, delta: f64, border_type: i32) -> Result_void;
		pub fn cv_Sobel_const__InputArrayR_const__OutputArrayR_int_int_int_int_double_double_int(src: *const c_void, dst: *const c_void, ddepth: i32, dx: i32, dy: i32, ksize: i32, scale: f64, delta: f64, border_type: i32) -> Result_void;
		pub fn cv_accumulateProduct_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_accumulateSquare_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_accumulateWeighted_const__InputArrayR_const__InputOutputArrayR_double_const__InputArrayR(src: *const c_void, dst: *const c_void, alpha: f64, mask: *const c_void) -> Result_void;
		pub fn cv_accumulate_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_adaptiveThreshold_const__InputArrayR_const__OutputArrayR_double_int_int_int_double(src: *const c_void, dst: *const c_void, max_value: f64, adaptive_method: i32, threshold_type: i32, block_size: i32, c: f64) -> Result_void;
		pub fn cv_applyColorMap_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, user_color: *const c_void) -> Result_void;
		pub fn cv_applyColorMap_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, colormap: i32) -> Result_void;
		pub fn cv_approxPolyDP_const__InputArrayR_const__OutputArrayR_double_bool(curve: *const c_void, approx_curve: *const c_void, epsilon: f64, closed: bool) -> Result_void;
		pub fn cv_arcLength_const__InputArrayR_bool(curve: *const c_void, closed: bool) -> Result<f64>;
		pub fn cv_arrowedLine_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int_double(img: *const c_void, pt1: *const core::Point, pt2: *const core::Point, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32, tip_length: f64) -> Result_void;
		pub fn cv_bilateralFilter_const__InputArrayR_const__OutputArrayR_int_double_double_int(src: *const c_void, dst: *const c_void, d: i32, sigma_color: f64, sigma_space: f64, border_type: i32) -> Result_void;
		pub fn cv_blendLinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, weights1: *const c_void, weights2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_blur_const__InputArrayR_const__OutputArrayR_Size_Point_int(src: *const c_void, dst: *const c_void, ksize: *const core::Size, anchor: *const core::Point, border_type: i32) -> Result_void;
		pub fn cv_boundingRect_const__InputArrayR(array: *const c_void) -> Result<core::Rect>;
		pub fn cv_boxFilter_const__InputArrayR_const__OutputArrayR_int_Size_Point_bool_int(src: *const c_void, dst: *const c_void, ddepth: i32, ksize: *const core::Size, anchor: *const core::Point, normalize: bool, border_type: i32) -> Result_void;
		pub fn cv_boxPoints_RotatedRect_const__OutputArrayR(box_: *mut c_void, points: *const c_void) -> Result_void;
		pub fn cv_buildPyramid_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, maxlevel: i32, border_type: i32) -> Result_void;
		pub fn cv_calcBackProject_const__InputArrayR_const_vector_int_R_const__InputArrayR_const__OutputArrayR_const_vector_float_R_double(images: *const c_void, channels: *const c_void, hist: *const c_void, dst: *const c_void, ranges: *const c_void, scale: f64) -> Result_void;
		pub fn cv_calcHist_const__InputArrayR_const_vector_int_R_const__InputArrayR_const__OutputArrayR_const_vector_int_R_const_vector_float_R_bool(images: *const c_void, channels: *const c_void, mask: *const c_void, hist: *const c_void, hist_size: *const c_void, ranges: *const c_void, accumulate: bool) -> Result_void;
		pub fn cv_circle_const__InputOutputArrayR_Point_int_const_ScalarR_int_int_int(img: *const c_void, center: *const core::Point, radius: i32, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_clipLine_Rect_PointR_PointR(img_rect: *const core::Rect, pt1: *mut core::Point, pt2: *mut core::Point) -> Result<bool>;
		pub fn cv_clipLine_Size2l_Point2lR_Point2lR(img_size: *const core::Size2l, pt1: *mut core::Point2l, pt2: *mut core::Point2l) -> Result<bool>;
		pub fn cv_clipLine_Size_PointR_PointR(img_size: *const core::Size, pt1: *mut core::Point, pt2: *mut core::Point) -> Result<bool>;
		pub fn cv_compareHist_const_SparseMatR_const_SparseMatR_int(h1: *const c_void, h2: *const c_void, method: i32) -> Result<f64>;
		pub fn cv_compareHist_const__InputArrayR_const__InputArrayR_int(h1: *const c_void, h2: *const c_void, method: i32) -> Result<f64>;
		pub fn cv_connectedComponentsWithStats_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(image: *const c_void, labels: *const c_void, stats: *const c_void, centroids: *const c_void, connectivity: i32, ltype: i32) -> Result<i32>;
		pub fn cv_connectedComponentsWithStats_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_int(image: *const c_void, labels: *const c_void, stats: *const c_void, centroids: *const c_void, connectivity: i32, ltype: i32, ccltype: i32) -> Result<i32>;
		pub fn cv_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int(image: *const c_void, labels: *const c_void, connectivity: i32, ltype: i32) -> Result<i32>;
		pub fn cv_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int_int(image: *const c_void, labels: *const c_void, connectivity: i32, ltype: i32, ccltype: i32) -> Result<i32>;
		pub fn cv_contourArea_const__InputArrayR_bool(contour: *const c_void, oriented: bool) -> Result<f64>;
		pub fn cv_convertMaps_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_bool(map1: *const c_void, map2: *const c_void, dstmap1: *const c_void, dstmap2: *const c_void, dstmap1type: i32, nninterpolation: bool) -> Result_void;
		pub fn cv_convexHull_const__InputArrayR_const__OutputArrayR_bool_bool(points: *const c_void, hull: *const c_void, clockwise: bool, return_points: bool) -> Result_void;
		pub fn cv_convexityDefects_const__InputArrayR_const__InputArrayR_const__OutputArrayR(contour: *const c_void, convexhull: *const c_void, convexity_defects: *const c_void) -> Result_void;
		pub fn cv_cornerEigenValsAndVecs_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, block_size: i32, ksize: i32, border_type: i32) -> Result_void;
		pub fn cv_cornerHarris_const__InputArrayR_const__OutputArrayR_int_int_double_int(src: *const c_void, dst: *const c_void, block_size: i32, ksize: i32, k: f64, border_type: i32) -> Result_void;
		pub fn cv_cornerMinEigenVal_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, block_size: i32, ksize: i32, border_type: i32) -> Result_void;
		pub fn cv_cornerSubPix_const__InputArrayR_const__InputOutputArrayR_Size_Size_TermCriteria(image: *const c_void, corners: *const c_void, win_size: *const core::Size, zero_zone: *const core::Size, criteria: *const core::TermCriteria) -> Result_void;
		pub fn cv_createCLAHE_double_Size(clip_limit: f64, tile_grid_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_createGeneralizedHoughBallard() -> Result<*mut c_void>;
		pub fn cv_createGeneralizedHoughGuil() -> Result<*mut c_void>;
		pub fn cv_createHanningWindow_const__OutputArrayR_Size_int(dst: *const c_void, win_size: *const core::Size, typ: i32) -> Result_void;
		pub fn cv_createLineSegmentDetector_int_double_double_double_double_double_double_int(refine: i32, scale: f64, sigma_scale: f64, quant: f64, ang_th: f64, log_eps: f64, density_th: f64, n_bins: i32) -> Result<*mut c_void>;
		pub fn cv_cvtColorTwoPlane_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, code: i32) -> Result_void;
		pub fn cv_cvtColor_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, code: i32, dst_cn: i32) -> Result_void;
		pub fn cv_demosaicing_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, code: i32, dst_cn: i32) -> Result_void;
		pub fn cv_dilate_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, kernel: *const c_void, anchor: *const core::Point, iterations: i32, border_type: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_distanceTransform_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, labels: *const c_void, distance_type: i32, mask_size: i32, label_type: i32) -> Result_void;
		pub fn cv_distanceTransform_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, distance_type: i32, mask_size: i32, dst_type: i32) -> Result_void;
		pub fn cv_divSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool(a: *const c_void, b: *const c_void, c: *const c_void, flags: i32, conj_b: bool) -> Result_void;
		pub fn cv_drawContours_const__InputOutputArrayR_const__InputArrayR_int_const_ScalarR_int_int_const__InputArrayR_int_Point(image: *const c_void, contours: *const c_void, contour_idx: i32, color: *const core::Scalar, thickness: i32, line_type: i32, hierarchy: *const c_void, max_level: i32, offset: *const core::Point) -> Result_void;
		pub fn cv_drawMarker_const__InputOutputArrayR_Point_const_ScalarR_int_int_int_int(img: *const c_void, position: *const core::Point, color: *const core::Scalar, marker_type: i32, marker_size: i32, thickness: i32, line_type: i32) -> Result_void;
		pub fn cv_ellipse2Poly_Point2d_Size2d_int_int_int_int_vector_Point2d_R(center: *const core::Point2d, axes: *const core::Size2d, angle: i32, arc_start: i32, arc_end: i32, delta: i32, pts: *mut c_void) -> Result_void;
		pub fn cv_ellipse2Poly_Point_Size_int_int_int_int_vector_Point_R(center: *const core::Point, axes: *const core::Size, angle: i32, arc_start: i32, arc_end: i32, delta: i32, pts: *mut c_void) -> Result_void;
		pub fn cv_ellipse_const__InputOutputArrayR_Point_Size_double_double_double_const_ScalarR_int_int_int(img: *const c_void, center: *const core::Point, axes: *const core::Size, angle: f64, start_angle: f64, end_angle: f64, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_ellipse_const__InputOutputArrayR_const_RotatedRectR_const_ScalarR_int_int(img: *const c_void, box_: *const c_void, color: *const core::Scalar, thickness: i32, line_type: i32) -> Result_void;
		pub fn cv_equalizeHist_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_erode_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, kernel: *const c_void, anchor: *const core::Point, iterations: i32, border_type: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_fillConvexPoly_const__InputOutputArrayR_const__InputArrayR_const_ScalarR_int_int(img: *const c_void, points: *const c_void, color: *const core::Scalar, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_fillPoly_const__InputOutputArrayR_const__InputArrayR_const_ScalarR_int_int_Point(img: *const c_void, pts: *const c_void, color: *const core::Scalar, line_type: i32, shift: i32, offset: *const core::Point) -> Result_void;
		pub fn cv_filter2D_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_Point_double_int(src: *const c_void, dst: *const c_void, ddepth: i32, kernel: *const c_void, anchor: *const core::Point, delta: f64, border_type: i32) -> Result_void;
		pub fn cv_findContours_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_Point(image: *const c_void, contours: *const c_void, hierarchy: *const c_void, mode: i32, method: i32, offset: *const core::Point) -> Result_void;
		pub fn cv_findContours_const__InputArrayR_const__OutputArrayR_int_int_Point(image: *const c_void, contours: *const c_void, mode: i32, method: i32, offset: *const core::Point) -> Result_void;
		pub fn cv_fitEllipseAMS_const__InputArrayR(points: *const c_void) -> Result<*mut c_void>;
		pub fn cv_fitEllipseDirect_const__InputArrayR(points: *const c_void) -> Result<*mut c_void>;
		pub fn cv_fitEllipse_const__InputArrayR(points: *const c_void) -> Result<*mut c_void>;
		pub fn cv_fitLine_const__InputArrayR_const__OutputArrayR_int_double_double_double(points: *const c_void, line: *const c_void, dist_type: i32, param: f64, reps: f64, aeps: f64) -> Result_void;
		pub fn cv_floodFill_const__InputOutputArrayR_Point_Scalar_RectX_Scalar_Scalar_int(image: *const c_void, seed_point: *const core::Point, new_val: *const core::Scalar, rect: *mut core::Rect, lo_diff: *const core::Scalar, up_diff: *const core::Scalar, flags: i32) -> Result<i32>;
		pub fn cv_floodFill_const__InputOutputArrayR_const__InputOutputArrayR_Point_Scalar_RectX_Scalar_Scalar_int(image: *const c_void, mask: *const c_void, seed_point: *const core::Point, new_val: *const core::Scalar, rect: *mut core::Rect, lo_diff: *const core::Scalar, up_diff: *const core::Scalar, flags: i32) -> Result<i32>;
		pub fn cv_getAffineTransform_const_Point2fX_const_Point2fX(src: *const core::Point2f, dst: *const core::Point2f) -> Result<*mut c_void>;
		pub fn cv_getAffineTransform_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void) -> Result<*mut c_void>;
		pub fn cv_getDerivKernels_const__OutputArrayR_const__OutputArrayR_int_int_int_bool_int(kx: *const c_void, ky: *const c_void, dx: i32, dy: i32, ksize: i32, normalize: bool, ktype: i32) -> Result_void;
		pub fn cv_getFontScaleFromHeight_const_int_const_int_const_int(font_face: i32, pixel_height: i32, thickness: i32) -> Result<f64>;
		pub fn cv_getGaborKernel_Size_double_double_double_double_double_int(ksize: *const core::Size, sigma: f64, theta: f64, lambd: f64, gamma: f64, psi: f64, ktype: i32) -> Result<*mut c_void>;
		pub fn cv_getGaussianKernel_int_double_int(ksize: i32, sigma: f64, ktype: i32) -> Result<*mut c_void>;
		pub fn cv_getPerspectiveTransform_const_Point2fX_const_Point2fX_int(src: *const core::Point2f, dst: *const core::Point2f, solve_method: i32) -> Result<*mut c_void>;
		pub fn cv_getPerspectiveTransform_const__InputArrayR_const__InputArrayR_int(src: *const c_void, dst: *const c_void, solve_method: i32) -> Result<*mut c_void>;
		pub fn cv_getRectSubPix_const__InputArrayR_Size_Point2f_const__OutputArrayR_int(image: *const c_void, patch_size: *const core::Size, center: *const core::Point2f, patch: *const c_void, patch_type: i32) -> Result_void;
		pub fn cv_getRotationMatrix2D_Point2f_double_double(center: *const core::Point2f, angle: f64, scale: f64) -> Result<*mut c_void>;
		#[cfg(not(target_os = "windows"))]
		pub fn cv_getRotationMatrix2D__Point2f_double_double(center: *const core::Point2f, angle: f64, scale: f64) -> Result<core::Matx23d>;
		pub fn cv_getStructuringElement_int_Size_Point(shape: i32, ksize: *const core::Size, anchor: *const core::Point) -> Result<*mut c_void>;
		pub fn cv_getTextSize_const_StringR_int_double_int_intX(text: *const c_char, font_face: i32, font_scale: f64, thickness: i32, base_line: *mut i32) -> Result<core::Size>;
		pub fn cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_const__OutputArrayR_int_int_bool_double(image: *const c_void, corners: *const c_void, max_corners: i32, quality_level: f64, min_distance: f64, mask: *const c_void, corners_quality: *const c_void, block_size: i32, gradient_size: i32, use_harris_detector: bool, k: f64) -> Result_void;
		pub fn cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_int_bool_double(image: *const c_void, corners: *const c_void, max_corners: i32, quality_level: f64, min_distance: f64, mask: *const c_void, block_size: i32, use_harris_detector: bool, k: f64) -> Result_void;
		pub fn cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_int_int_bool_double(image: *const c_void, corners: *const c_void, max_corners: i32, quality_level: f64, min_distance: f64, mask: *const c_void, block_size: i32, gradient_size: i32, use_harris_detector: bool, k: f64) -> Result_void;
		pub fn cv_grabCut_const__InputArrayR_const__InputOutputArrayR_Rect_const__InputOutputArrayR_const__InputOutputArrayR_int_int(img: *const c_void, mask: *const c_void, rect: *const core::Rect, bgd_model: *const c_void, fgd_model: *const c_void, iter_count: i32, mode: i32) -> Result_void;
		pub fn cv_integral_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(src: *const c_void, sum: *const c_void, sqsum: *const c_void, tilted: *const c_void, sdepth: i32, sqdepth: i32) -> Result_void;
		pub fn cv_integral_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(src: *const c_void, sum: *const c_void, sqsum: *const c_void, sdepth: i32, sqdepth: i32) -> Result_void;
		pub fn cv_integral_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, sum: *const c_void, sdepth: i32) -> Result_void;
		pub fn cv_intersectConvexConvex_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(p1: *const c_void, p2: *const c_void, p12: *const c_void, handle_nested: bool) -> Result<f32>;
		pub fn cv_invertAffineTransform_const__InputArrayR_const__OutputArrayR(m: *const c_void, i_m: *const c_void) -> Result_void;
		pub fn cv_isContourConvex_const__InputArrayR(contour: *const c_void) -> Result<bool>;
		pub fn cv_line_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int(img: *const c_void, pt1: *const core::Point, pt2: *const core::Point, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_linearPolar_const__InputArrayR_const__OutputArrayR_Point2f_double_int(src: *const c_void, dst: *const c_void, center: *const core::Point2f, max_radius: f64, flags: i32) -> Result_void;
		pub fn cv_logPolar_const__InputArrayR_const__OutputArrayR_Point2f_double_int(src: *const c_void, dst: *const c_void, center: *const core::Point2f, m: f64, flags: i32) -> Result_void;
		pub fn cv_matchShapes_const__InputArrayR_const__InputArrayR_int_double(contour1: *const c_void, contour2: *const c_void, method: i32, parameter: f64) -> Result<f64>;
		pub fn cv_matchTemplate_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR(image: *const c_void, templ: *const c_void, result: *const c_void, method: i32, mask: *const c_void) -> Result_void;
		pub fn cv_medianBlur_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, ksize: i32) -> Result_void;
		pub fn cv_minAreaRect_const__InputArrayR(points: *const c_void) -> Result<*mut c_void>;
		pub fn cv_minEnclosingCircle_const__InputArrayR_Point2fR_floatR(points: *const c_void, center: *mut core::Point2f, radius: *mut f32) -> Result_void;
		pub fn cv_minEnclosingTriangle_const__InputArrayR_const__OutputArrayR(points: *const c_void, triangle: *const c_void) -> Result<f64>;
		pub fn cv_moments_const__InputArrayR_bool(array: *const c_void, binary_image: bool) -> Result<core::Moments>;
		pub fn cv_morphologyDefaultBorderValue() -> Result<core::Scalar>;
		pub fn cv_morphologyEx_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_Point_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, op: i32, kernel: *const c_void, anchor: *const core::Point, iterations: i32, border_type: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_phaseCorrelate_const__InputArrayR_const__InputArrayR_const__InputArrayR_doubleX(src1: *const c_void, src2: *const c_void, window: *const c_void, response: *mut f64) -> Result<core::Point2d>;
		pub fn cv_pointPolygonTest_const__InputArrayR_Point2f_bool(contour: *const c_void, pt: *const core::Point2f, measure_dist: bool) -> Result<f64>;
		pub fn cv_polylines_const__InputOutputArrayR_const__InputArrayR_bool_const_ScalarR_int_int_int(img: *const c_void, pts: *const c_void, is_closed: bool, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_preCornerDetect_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, ksize: i32, border_type: i32) -> Result_void;
		pub fn cv_putText_const__InputOutputArrayR_const_StringR_Point_int_double_Scalar_int_int_bool(img: *const c_void, text: *const c_char, org: *const core::Point, font_face: i32, font_scale: f64, color: *const core::Scalar, thickness: i32, line_type: i32, bottom_left_origin: bool) -> Result_void;
		pub fn cv_pyrDown_const__InputArrayR_const__OutputArrayR_const_SizeR_int(src: *const c_void, dst: *const c_void, dstsize: *const core::Size, border_type: i32) -> Result_void;
		pub fn cv_pyrMeanShiftFiltering_const__InputArrayR_const__OutputArrayR_double_double_int_TermCriteria(src: *const c_void, dst: *const c_void, sp: f64, sr: f64, max_level: i32, termcrit: *const core::TermCriteria) -> Result_void;
		pub fn cv_pyrUp_const__InputArrayR_const__OutputArrayR_const_SizeR_int(src: *const c_void, dst: *const c_void, dstsize: *const core::Size, border_type: i32) -> Result_void;
		pub fn cv_rectangle_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int(img: *const c_void, pt1: *const core::Point, pt2: *const core::Point, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_rectangle_const__InputOutputArrayR_Rect_const_ScalarR_int_int_int(img: *const c_void, rec: *const core::Rect, color: *const core::Scalar, thickness: i32, line_type: i32, shift: i32) -> Result_void;
		pub fn cv_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, map1: *const c_void, map2: *const c_void, interpolation: i32, border_mode: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_resize_const__InputArrayR_const__OutputArrayR_Size_double_double_int(src: *const c_void, dst: *const c_void, dsize: *const core::Size, fx: f64, fy: f64, interpolation: i32) -> Result_void;
		pub fn cv_rotatedRectangleIntersection_const_RotatedRectR_const_RotatedRectR_const__OutputArrayR(rect1: *const c_void, rect2: *const c_void, intersecting_region: *const c_void) -> Result<i32>;
		pub fn cv_sepFilter2D_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_const__InputArrayR_Point_double_int(src: *const c_void, dst: *const c_void, ddepth: i32, kernel_x: *const c_void, kernel_y: *const c_void, anchor: *const core::Point, delta: f64, border_type: i32) -> Result_void;
		pub fn cv_spatialGradient_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(src: *const c_void, dx: *const c_void, dy: *const c_void, ksize: i32, border_type: i32) -> Result_void;
		pub fn cv_sqrBoxFilter_const__InputArrayR_const__OutputArrayR_int_Size_Point_bool_int(src: *const c_void, dst: *const c_void, ddepth: i32, ksize: *const core::Size, anchor: *const core::Point, normalize: bool, border_type: i32) -> Result_void;
		pub fn cv_threshold_const__InputArrayR_const__OutputArrayR_double_double_int(src: *const c_void, dst: *const c_void, thresh: f64, maxval: f64, typ: i32) -> Result<f64>;
		pub fn cv_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_warpPolar_const__InputArrayR_const__OutputArrayR_Size_Point2f_double_int(src: *const c_void, dst: *const c_void, dsize: *const core::Size, center: *const core::Point2f, max_radius: f64, flags: i32) -> Result_void;
		pub fn cv_watershed_const__InputArrayR_const__InputOutputArrayR(image: *const c_void, markers: *const c_void) -> Result_void;
		pub fn cv_wrapperEMD_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_Ptr_float__const__OutputArrayR(signature1: *const c_void, signature2: *const c_void, dist_type: i32, cost: *const c_void, lower_bound: *mut c_void, flow: *const c_void) -> Result<f32>;
		pub fn cv_CLAHE_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_CLAHE_setClipLimit_double(instance: *mut c_void, clip_limit: f64) -> Result_void;
		pub fn cv_CLAHE_getClipLimit_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_CLAHE_setTilesGridSize_Size(instance: *mut c_void, tile_grid_size: *const core::Size) -> Result_void;
		pub fn cv_CLAHE_getTilesGridSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_CLAHE_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_GeneralizedHough_setTemplate_const__InputArrayR_Point(instance: *mut c_void, templ: *const c_void, templ_center: *const core::Point) -> Result_void;
		pub fn cv_GeneralizedHough_setTemplate_const__InputArrayR_const__InputArrayR_const__InputArrayR_Point(instance: *mut c_void, edges: *const c_void, dx: *const c_void, dy: *const c_void, templ_center: *const core::Point) -> Result_void;
		pub fn cv_GeneralizedHough_detect_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, positions: *const c_void, votes: *const c_void) -> Result_void;
		pub fn cv_GeneralizedHough_detect_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, edges: *const c_void, dx: *const c_void, dy: *const c_void, positions: *const c_void, votes: *const c_void) -> Result_void;
		pub fn cv_GeneralizedHough_setCannyLowThresh_int(instance: *mut c_void, canny_low_thresh: i32) -> Result_void;
		pub fn cv_GeneralizedHough_getCannyLowThresh_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHough_setCannyHighThresh_int(instance: *mut c_void, canny_high_thresh: i32) -> Result_void;
		pub fn cv_GeneralizedHough_getCannyHighThresh_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHough_setMinDist_double(instance: *mut c_void, min_dist: f64) -> Result_void;
		pub fn cv_GeneralizedHough_getMinDist_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHough_setDp_double(instance: *mut c_void, dp: f64) -> Result_void;
		pub fn cv_GeneralizedHough_getDp_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHough_setMaxBufferSize_int(instance: *mut c_void, max_buffer_size: i32) -> Result_void;
		pub fn cv_GeneralizedHough_getMaxBufferSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughBallard_setLevels_int(instance: *mut c_void, levels: i32) -> Result_void;
		pub fn cv_GeneralizedHoughBallard_getLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughBallard_setVotesThreshold_int(instance: *mut c_void, votes_threshold: i32) -> Result_void;
		pub fn cv_GeneralizedHoughBallard_getVotesThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughGuil_setXi_double(instance: *mut c_void, xi: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getXi_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setLevels_int(instance: *mut c_void, levels: i32) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughGuil_setAngleEpsilon_double(instance: *mut c_void, angle_epsilon: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getAngleEpsilon_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setMinAngle_double(instance: *mut c_void, min_angle: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getMinAngle_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setMaxAngle_double(instance: *mut c_void, max_angle: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getMaxAngle_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setAngleStep_double(instance: *mut c_void, angle_step: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getAngleStep_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setAngleThresh_int(instance: *mut c_void, angle_thresh: i32) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getAngleThresh_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughGuil_setMinScale_double(instance: *mut c_void, min_scale: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getMinScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setMaxScale_double(instance: *mut c_void, max_scale: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getMaxScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setScaleStep_double(instance: *mut c_void, scale_step: f64) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getScaleStep_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_GeneralizedHoughGuil_setScaleThresh_int(instance: *mut c_void, scale_thresh: i32) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getScaleThresh_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_GeneralizedHoughGuil_setPosThresh_int(instance: *mut c_void, pos_thresh: i32) -> Result_void;
		pub fn cv_GeneralizedHoughGuil_getPosThresh_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_LineIterator_getPropPtr(instance: *mut c_void) -> *mut u8;
		pub fn cv_LineIterator_setPropPtr_unsigned_charX(instance: *mut c_void, val: *mut u8);
		pub fn cv_LineIterator_getPropPtr0_const(instance: *const c_void) -> *const u8;
		pub fn cv_LineIterator_getPropStep_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropStep_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropElemSize_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropElemSize_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropErr_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropErr_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropCount_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropCount_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropMinusDelta_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropMinusDelta_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropPlusDelta_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropPlusDelta_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropMinusStep_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropMinusStep_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropPlusStep_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropPlusStep_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropMinusShift_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropMinusShift_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropPlusShift_const(instance: *const c_void) -> i32;
		pub fn cv_LineIterator_setPropPlusShift_int(instance: *mut c_void, val: i32);
		pub fn cv_LineIterator_getPropP_const(instance: *const c_void) -> core::Point;
		pub fn cv_LineIterator_setPropP_Point(instance: *mut c_void, val: *const core::Point);
		pub fn cv_LineIterator_getPropPtmode_const(instance: *const c_void) -> bool;
		pub fn cv_LineIterator_setPropPtmode_bool(instance: *mut c_void, val: bool);
		pub fn cv_LineIterator_LineIterator_const_MatR_Point_Point_int_bool(img: *const c_void, pt1: *const core::Point, pt2: *const core::Point, connectivity: i32, left_to_right: bool) -> Result<*mut c_void>;
		pub fn cv_LineIterator_LineIterator_Point_Point_int_bool(pt1: *const core::Point, pt2: *const core::Point, connectivity: i32, left_to_right: bool) -> Result<*mut c_void>;
		pub fn cv_LineIterator_LineIterator_Size_Point_Point_int_bool(bounding_area_size: *const core::Size, pt1: *const core::Point, pt2: *const core::Point, connectivity: i32, left_to_right: bool) -> Result<*mut c_void>;
		pub fn cv_LineIterator_LineIterator_Rect_Point_Point_int_bool(bounding_area_rect: *const core::Rect, pt1: *const core::Point, pt2: *const core::Point, connectivity: i32, left_to_right: bool) -> Result<*mut c_void>;
		pub fn cv_LineIterator_init_const_MatX_Rect_Point_Point_int_bool(instance: *mut c_void, img: *const c_void, bounding_area_rect: *const core::Rect, pt1: *const core::Point, pt2: *const core::Point, connectivity: i32, left_to_right: bool) -> Result_void;
		pub fn cv_LineIterator_operatorX(instance: *mut c_void) -> Result<*mut u8>;
		pub fn cv_LineIterator_pos_const(instance: *const c_void) -> Result<core::Point>;
		pub fn cv_LineSegmentDetector_detect_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, lines: *const c_void, width: *const c_void, prec: *const c_void, nfa: *const c_void) -> Result_void;
		pub fn cv_LineSegmentDetector_drawSegments_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, image: *const c_void, lines: *const c_void) -> Result_void;
		pub fn cv_LineSegmentDetector_compareSegments_const_SizeR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, size: *const core::Size, lines1: *const c_void, lines2: *const c_void, image: *const c_void) -> Result<i32>;
		pub fn cv_Subdiv2D_Subdiv2D() -> Result<*mut c_void>;
		pub fn cv_Subdiv2D_Subdiv2D_Rect(rect: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_Subdiv2D_initDelaunay_Rect(instance: *mut c_void, rect: *const core::Rect) -> Result_void;
		pub fn cv_Subdiv2D_insert_Point2f(instance: *mut c_void, pt: *const core::Point2f) -> Result<i32>;
		pub fn cv_Subdiv2D_insert_const_vector_Point2f_R(instance: *mut c_void, ptvec: *const c_void) -> Result_void;
		pub fn cv_Subdiv2D_locate_Point2f_intR_intR(instance: *mut c_void, pt: *const core::Point2f, edge: *mut i32, vertex: *mut i32) -> Result<i32>;
		pub fn cv_Subdiv2D_findNearest_Point2f_Point2fX(instance: *mut c_void, pt: *const core::Point2f, nearest_pt: *mut core::Point2f) -> Result<i32>;
		pub fn cv_Subdiv2D_getEdgeList_const_vector_Vec4f_R(instance: *const c_void, edge_list: *mut c_void) -> Result_void;
		pub fn cv_Subdiv2D_getLeadingEdgeList_const_vector_int_R(instance: *const c_void, leading_edge_list: *mut c_void) -> Result_void;
		pub fn cv_Subdiv2D_getTriangleList_const_vector_Vec6f_R(instance: *const c_void, triangle_list: *mut c_void) -> Result_void;
		pub fn cv_Subdiv2D_getVoronoiFacetList_const_vector_int_R_vector_vector_Point2f__R_vector_Point2f_R(instance: *mut c_void, idx: *const c_void, facet_list: *mut c_void, facet_centers: *mut c_void) -> Result_void;
		pub fn cv_Subdiv2D_getVertex_const_int_intX(instance: *const c_void, vertex: i32, first_edge: *mut i32) -> Result<core::Point2f>;
		pub fn cv_Subdiv2D_getEdge_const_int_int(instance: *const c_void, edge: i32, next_edge_type: i32) -> Result<i32>;
		pub fn cv_Subdiv2D_nextEdge_const_int(instance: *const c_void, edge: i32) -> Result<i32>;
		pub fn cv_Subdiv2D_rotateEdge_const_int_int(instance: *const c_void, edge: i32, rotate: i32) -> Result<i32>;
		pub fn cv_Subdiv2D_symEdge_const_int(instance: *const c_void, edge: i32) -> Result<i32>;
		pub fn cv_Subdiv2D_edgeOrg_const_int_Point2fX(instance: *const c_void, edge: i32, orgpt: *mut core::Point2f) -> Result<i32>;
		pub fn cv_Subdiv2D_edgeDst_const_int_Point2fX(instance: *const c_void, edge: i32, dstpt: *mut core::Point2f) -> Result<i32>;
		pub fn cv_segmentation_IntelligentScissorsMB_IntelligentScissorsMB() -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_setWeights_float_float_float(instance: *mut c_void, weight_non_edge: f32, weight_gradient_direction: f32, weight_gradient_magnitude: f32) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_setGradientMagnitudeMaxLimit_float(instance: *mut c_void, gradient_magnitude_threshold_max: f32) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_setEdgeFeatureZeroCrossingParameters_float(instance: *mut c_void, gradient_magnitude_min_value: f32) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_setEdgeFeatureCannyParameters_double_double_int_bool(instance: *mut c_void, threshold1: f64, threshold2: f64, aperture_size: i32, l2gradient: bool) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_applyImage_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_applyImageFeatures_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, non_edge: *const c_void, gradient_direction: *const c_void, gradient_magnitude: *const c_void, image: *const c_void) -> Result<*mut c_void>;
		pub fn cv_segmentation_IntelligentScissorsMB_buildMap_const_PointR(instance: *mut c_void, source_pt: *const core::Point) -> Result_void;
		pub fn cv_segmentation_IntelligentScissorsMB_getContour_const_const_PointR_const__OutputArrayR_bool(instance: *const c_void, target_pt: *const core::Point, contour: *const c_void, backward: bool) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_imgproc)]
pub use imgproc_sys::*;

#[cfg(ocvrs_has_module_intensity_transform)]
mod intensity_transform_sys {
	use super::*;

	extern "C" {
		pub fn cv_intensity_transform_BIMEF_const__InputArrayR_const__OutputArrayR_float_float_float(input: *const c_void, output: *const c_void, mu: f32, a: f32, b: f32) -> Result_void;
		pub fn cv_intensity_transform_BIMEF_const__InputArrayR_const__OutputArrayR_float_float_float_float(input: *const c_void, output: *const c_void, k: f32, mu: f32, a: f32, b: f32) -> Result_void;
		pub fn cv_intensity_transform_autoscaling_const_Mat_MatR(input: *const c_void, output: *mut c_void) -> Result_void;
		pub fn cv_intensity_transform_contrastStretching_const_Mat_MatR_const_int_const_int_const_int_const_int(input: *const c_void, output: *mut c_void, r1: i32, s1: i32, r2: i32, s2: i32) -> Result_void;
		pub fn cv_intensity_transform_gammaCorrection_const_Mat_MatR_const_float(input: *const c_void, output: *mut c_void, gamma: f32) -> Result_void;
		pub fn cv_intensity_transform_logTransform_const_Mat_MatR(input: *const c_void, output: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_intensity_transform)]
pub use intensity_transform_sys::*;

#[cfg(ocvrs_has_module_line_descriptor)]
mod line_descriptor_sys {
	use super::*;

	extern "C" {
		pub fn cv_line_descriptor_drawKeylines_const_MatR_const_vector_KeyLine_R_MatR_const_ScalarR_int(image: *const c_void, keylines: *const c_void, out_image: *mut c_void, color: *const core::Scalar, flags: i32) -> Result_void;
		pub fn cv_line_descriptor_drawLineMatches_const_MatR_const_vector_KeyLine_R_const_MatR_const_vector_KeyLine_R_const_vector_DMatch_R_MatR_const_ScalarR_const_ScalarR_const_vector_char_R_int(img1: *const c_void, keylines1: *const c_void, img2: *const c_void, keylines2: *const c_void, matches1to2: *const c_void, out_img: *mut c_void, match_color: *const core::Scalar, single_line_color: *const core::Scalar, matches_mask: *const c_void, flags: i32) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_BinaryDescriptor_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_line_descriptor_BinaryDescriptor_createBinaryDescriptor() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_BinaryDescriptor_createBinaryDescriptor_Params(parameters: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_line_descriptor_BinaryDescriptor_getNumOfOctaves(instance: *mut c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_setNumOfOctaves_int(instance: *mut c_void, octaves: i32) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_getWidthOfBand(instance: *mut c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_setWidthOfBand_int(instance: *mut c_void, width: i32) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_getReductionRatio(instance: *mut c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_setReductionRatio_int(instance: *mut c_void, r_ratio: i32) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_detect_const_MatR_vector_KeyLine_R_const_MatR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_detect_const_const_vector_Mat_R_vector_vector_KeyLine__R_const_vector_Mat_R(instance: *const c_void, images: *const c_void, keylines: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_compute_const_const_MatR_vector_KeyLine_R_MatR_bool(instance: *const c_void, image: *const c_void, keylines: *mut c_void, descriptors: *mut c_void, return_float_descr: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_compute_const_const_vector_Mat_R_vector_vector_KeyLine__R_vector_Mat_R_bool(instance: *const c_void, images: *const c_void, keylines: *mut c_void, descriptors: *mut c_void, return_float_descr: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_descriptorSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_descriptorType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_defaultNorm_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_getPropNumOfOctave__const(instance: *const c_void) -> i32;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_setPropNumOfOctave__int(instance: *mut c_void, val: i32);
		pub fn cv_line_descriptor_BinaryDescriptor_Params_getPropWidthOfBand__const(instance: *const c_void) -> i32;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_setPropWidthOfBand__int(instance: *mut c_void, val: i32);
		pub fn cv_line_descriptor_BinaryDescriptor_Params_getPropReductionRatio_const(instance: *const c_void) -> i32;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_setPropReductionRatio_int(instance: *mut c_void, val: i32);
		pub fn cv_line_descriptor_BinaryDescriptor_Params_getPropKsize__const(instance: *const c_void) -> i32;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_setPropKsize__int(instance: *mut c_void, val: i32);
		pub fn cv_line_descriptor_BinaryDescriptor_Params_Params() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptor_Params_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_match_const_const_MatR_const_MatR_vector_DMatch_R_const_MatR(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_match_const_MatR_vector_DMatch_R_const_vector_Mat_R(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_knnMatch_const_const_MatR_const_MatR_vector_vector_DMatch__R_int_const_MatR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_knnMatch_const_MatR_vector_vector_DMatch__R_int_const_vector_Mat_R_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_radiusMatch_const_const_MatR_const_MatR_vector_vector_DMatch__R_float_const_MatR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, mask: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_radiusMatch_const_MatR_vector_vector_DMatch__R_float_const_vector_Mat_R_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, masks: *const c_void, compact_result: bool) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_add_const_vector_Mat_R(instance: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_train(instance: *mut c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_createBinaryDescriptorMatcher() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_line_descriptor_BinaryDescriptorMatcher_BinaryDescriptorMatcher() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_KeyLine_getStartPoint_const(instance: *const crate::line_descriptor::KeyLine) -> Result<core::Point2f>;
		pub fn cv_line_descriptor_KeyLine_getEndPoint_const(instance: *const crate::line_descriptor::KeyLine) -> Result<core::Point2f>;
		pub fn cv_line_descriptor_KeyLine_getStartPointInOctave_const(instance: *const crate::line_descriptor::KeyLine) -> Result<core::Point2f>;
		pub fn cv_line_descriptor_KeyLine_getEndPointInOctave_const(instance: *const crate::line_descriptor::KeyLine) -> Result<core::Point2f>;
		pub fn cv_line_descriptor_KeyLine_KeyLine() -> Result<crate::line_descriptor::KeyLine>;
		pub fn cv_line_descriptor_LSDDetector_LSDDetector() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_LSDDetector_LSDDetector_LSDParam(_params: *const crate::line_descriptor::LSDParam) -> Result<*mut c_void>;
		pub fn cv_line_descriptor_LSDDetector_createLSDDetector() -> Result<*mut c_void>;
		pub fn cv_line_descriptor_LSDDetector_createLSDDetector_LSDParam(params: *const crate::line_descriptor::LSDParam) -> Result<*mut c_void>;
		pub fn cv_line_descriptor_LSDDetector_detect_const_MatR_vector_KeyLine_R_int_int_const_MatR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, scale: i32, num_octaves: i32, mask: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_LSDDetector_detect_const_const_vector_Mat_R_vector_vector_KeyLine__R_int_int_const_vector_Mat_R(instance: *const c_void, images: *const c_void, keylines: *mut c_void, scale: i32, num_octaves: i32, masks: *const c_void) -> Result_void;
		pub fn cv_line_descriptor_LSDParam_LSDParam() -> Result<crate::line_descriptor::LSDParam>;
	}
}
#[cfg(ocvrs_has_module_line_descriptor)]
pub use line_descriptor_sys::*;

#[cfg(ocvrs_has_module_mcc)]
mod mcc_sys {
	use super::*;

	extern "C" {
		pub fn cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_CONST_COLOR(src: *const c_void, constcolor: crate::mcc::CONST_COLOR) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_Mat_COLOR_SPACE(src: *const c_void, colors: *mut c_void, ref_cs: crate::mcc::COLOR_SPACE) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_Mat_COLOR_SPACE_Mat(src: *const c_void, colors: *mut c_void, ref_cs: crate::mcc::COLOR_SPACE, colored: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_setColorSpace_COLOR_SPACE(instance: *mut c_void, cs: crate::mcc::COLOR_SPACE) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setCCM_TYPE_CCM_TYPE(instance: *mut c_void, ccm_type: crate::mcc::CCM_TYPE) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setDistance_DISTANCE_TYPE(instance: *mut c_void, distance: crate::mcc::DISTANCE_TYPE) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setLinear_LINEAR_TYPE(instance: *mut c_void, linear_type: crate::mcc::LINEAR_TYPE) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setLinearGamma_const_doubleR(instance: *mut c_void, gamma: *const f64) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setLinearDegree_const_intR(instance: *mut c_void, deg: *const i32) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setSaturatedThreshold_const_doubleR_const_doubleR(instance: *mut c_void, lower: *const f64, upper: *const f64) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setWeightsList_const_MatR(instance: *mut c_void, weights_list: *const c_void) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setWeightCoeff_const_doubleR(instance: *mut c_void, weights_coeff: *const f64) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setInitialMethod_INITIAL_METHOD_TYPE(instance: *mut c_void, initial_method_type: crate::mcc::INITIAL_METHOD_TYPE) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setMaxCount_const_intR(instance: *mut c_void, max_count: *const i32) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_setEpsilon_const_doubleR(instance: *mut c_void, epsilon: *const f64) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_run(instance: *mut c_void) -> Result_void;
		pub fn cv_ccm_ColorCorrectionModel_getCCM_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_getLoss_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ccm_ColorCorrectionModel_get_src_rgbl_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_get_dst_rgbl_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_getMask_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_getWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ccm_ColorCorrectionModel_infer_const_MatR_bool(instance: *mut c_void, img: *const c_void, islinear: bool) -> Result<*mut c_void>;
		pub fn cv_mcc_CChecker_create() -> Result<*mut c_void>;
		pub fn cv_mcc_CChecker_setTarget_TYPECHART(instance: *mut c_void, _target: crate::mcc::MCC_TYPECHART) -> Result_void;
		pub fn cv_mcc_CChecker_setBox_vector_Point2f_(instance: *mut c_void, _box: *mut c_void) -> Result_void;
		pub fn cv_mcc_CChecker_setChartsRGB_Mat(instance: *mut c_void, _charts_rgb: *mut c_void) -> Result_void;
		pub fn cv_mcc_CChecker_setChartsYCbCr_Mat(instance: *mut c_void, _charts_y_cb_cr: *mut c_void) -> Result_void;
		pub fn cv_mcc_CChecker_setCost_float(instance: *mut c_void, _cost: f32) -> Result_void;
		pub fn cv_mcc_CChecker_setCenter_Point2f(instance: *mut c_void, _center: *const core::Point2f) -> Result_void;
		pub fn cv_mcc_CChecker_getTarget(instance: *mut c_void) -> Result<crate::mcc::MCC_TYPECHART>;
		pub fn cv_mcc_CChecker_getBox(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_mcc_CChecker_getChartsRGB(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_mcc_CChecker_getChartsYCbCr(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_mcc_CChecker_getCost(instance: *mut c_void) -> Result<f32>;
		pub fn cv_mcc_CChecker_getCenter(instance: *mut c_void) -> Result<core::Point2f>;
		pub fn cv_mcc_CCheckerDetector_setNet_Net(instance: *mut c_void, net: *mut c_void) -> Result<bool>;
		pub fn cv_mcc_CCheckerDetector_process_const__InputArrayR_const_TYPECHART_const_vector_Rect_R_const_int_bool_const_Ptr_DetectorParameters_R(instance: *mut c_void, image: *const c_void, chart_type: crate::mcc::MCC_TYPECHART, regions_of_interest: *const c_void, nc: i32, use_net: bool, params: *const c_void) -> Result<bool>;
		pub fn cv_mcc_CCheckerDetector_process_const__InputArrayR_const_TYPECHART_const_int_bool_const_Ptr_DetectorParameters_R(instance: *mut c_void, image: *const c_void, chart_type: crate::mcc::MCC_TYPECHART, nc: i32, use_net: bool, params: *const c_void) -> Result<bool>;
		pub fn cv_mcc_CCheckerDetector_getBestColorChecker(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_mcc_CCheckerDetector_getListColorChecker(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_mcc_CCheckerDetector_create() -> Result<*mut c_void>;
		pub fn cv_mcc_CCheckerDraw_draw_const__InputOutputArrayR(instance: *mut c_void, img: *const c_void) -> Result_void;
		pub fn cv_mcc_CCheckerDraw_create_Ptr_CChecker__Scalar_int(p_checker: *mut c_void, color: *const core::Scalar, thickness: i32) -> Result<*mut c_void>;
		pub fn cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeMin_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeMin_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeMax_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeMax_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeStep_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeStep_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropAdaptiveThreshConstant_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropAdaptiveThreshConstant_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropMinContoursAreaRate_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropMinContoursAreaRate_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropMinContoursArea_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropMinContoursArea_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropConfidenceThreshold_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropConfidenceThreshold_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropMinContourSolidity_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropMinContourSolidity_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropFindCandidatesApproxPolyDPEpsMultiplier_const(instance: *const c_void) -> f64;
		pub fn cv_mcc_DetectorParameters_setPropFindCandidatesApproxPolyDPEpsMultiplier_double(instance: *mut c_void, val: f64);
		pub fn cv_mcc_DetectorParameters_getPropBorderWidth_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropBorderWidth_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropB0factor_const(instance: *const c_void) -> f32;
		pub fn cv_mcc_DetectorParameters_setPropB0factor_float(instance: *mut c_void, val: f32);
		pub fn cv_mcc_DetectorParameters_getPropMaxError_const(instance: *const c_void) -> f32;
		pub fn cv_mcc_DetectorParameters_setPropMaxError_float(instance: *mut c_void, val: f32);
		pub fn cv_mcc_DetectorParameters_getPropMinContourPointsAllowed_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropMinContourPointsAllowed_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropMinContourLengthAllowed_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropMinContourLengthAllowed_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropMinInterContourDistance_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropMinInterContourDistance_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropMinInterCheckerDistance_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropMinInterCheckerDistance_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropMinImageSize_const(instance: *const c_void) -> i32;
		pub fn cv_mcc_DetectorParameters_setPropMinImageSize_int(instance: *mut c_void, val: i32);
		pub fn cv_mcc_DetectorParameters_getPropMinGroupSize_const(instance: *const c_void) -> u32;
		pub fn cv_mcc_DetectorParameters_setPropMinGroupSize_unsigned_int(instance: *mut c_void, val: u32);
		pub fn cv_mcc_DetectorParameters_DetectorParameters() -> Result<*mut c_void>;
		pub fn cv_mcc_DetectorParameters_create() -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_mcc)]
pub use mcc_sys::*;

#[cfg(ocvrs_has_module_ml)]
mod ml_sys {
	use super::*;

	extern "C" {
		pub fn cv_ml_createConcentricSpheresTestSet_int_int_int_const__OutputArrayR_const__OutputArrayR(nsamples: i32, nfeatures: i32, nclasses: i32, samples: *const c_void, responses: *const c_void) -> Result_void;
		pub fn cv_ml_randMVNormal_const__InputArrayR_const__InputArrayR_int_const__OutputArrayR(mean: *const c_void, cov: *const c_void, nsamples: i32, samples: *const c_void) -> Result_void;
		pub fn cv_ml_ANN_MLP_setTrainMethod_int_double_double(instance: *mut c_void, method: i32, param1: f64, param2: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getTrainMethod_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_ANN_MLP_setActivationFunction_int_double_double(instance: *mut c_void, typ: i32, param1: f64, param2: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_setLayerSizes_const__InputArrayR(instance: *mut c_void, _layer_sizes: *const c_void) -> Result_void;
		pub fn cv_ml_ANN_MLP_getLayerSizes_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_ANN_MLP_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_ANN_MLP_setTermCriteria_TermCriteria(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_ANN_MLP_getBackpropWeightScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setBackpropWeightScale_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getBackpropMomentumScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setBackpropMomentumScale_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getRpropDW0_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setRpropDW0_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getRpropDWPlus_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setRpropDWPlus_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getRpropDWMinus_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setRpropDWMinus_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getRpropDWMin_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setRpropDWMin_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getRpropDWMax_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setRpropDWMax_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getAnnealInitialT_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setAnnealInitialT_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getAnnealFinalT_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setAnnealFinalT_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getAnnealCoolingRatio_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_ANN_MLP_setAnnealCoolingRatio_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_ANN_MLP_getAnnealItePerStep_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_ANN_MLP_setAnnealItePerStep_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_ANN_MLP_setAnnealEnergyRNG_const_RNGR(instance: *mut c_void, rng: *const c_void) -> Result_void;
		pub fn cv_ml_ANN_MLP_getWeights_const_int(instance: *const c_void, layer_idx: i32) -> Result<*mut c_void>;
		pub fn cv_ml_ANN_MLP_create() -> Result<*mut c_void>;
		pub fn cv_ml_ANN_MLP_load_const_StringR(filepath: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_Boost_getBoostType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_Boost_setBoostType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_Boost_getWeakCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_Boost_setWeakCount_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_Boost_getWeightTrimRate_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_Boost_setWeightTrimRate_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_Boost_create() -> Result<*mut c_void>;
		pub fn cv_ml_Boost_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_getMaxCategories_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_DTrees_setMaxCategories_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_DTrees_getMaxDepth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_DTrees_setMaxDepth_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_DTrees_getMinSampleCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_DTrees_setMinSampleCount_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_DTrees_getCVFolds_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_DTrees_setCVFolds_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_DTrees_getUseSurrogates_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_DTrees_setUseSurrogates_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ml_DTrees_getUse1SERule_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_DTrees_setUse1SERule_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ml_DTrees_getTruncatePrunedTree_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_DTrees_setTruncatePrunedTree_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ml_DTrees_getRegressionAccuracy_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ml_DTrees_setRegressionAccuracy_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_ml_DTrees_getPriors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_setPriors_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_ml_DTrees_getRoots_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_getNodes_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_getSplits_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_getSubsets_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_create() -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_Node_getPropValue_const(instance: *const c_void) -> f64;
		pub fn cv_ml_DTrees_Node_setPropValue_double(instance: *mut c_void, val: f64);
		pub fn cv_ml_DTrees_Node_getPropClassIdx_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropClassIdx_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_getPropParent_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropParent_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_getPropLeft_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropLeft_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_getPropRight_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropRight_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_getPropDefaultDir_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropDefaultDir_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_getPropSplit_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Node_setPropSplit_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Node_Node() -> Result<*mut c_void>;
		pub fn cv_ml_DTrees_Split_getPropVarIdx_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Split_setPropVarIdx_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Split_getPropInversed_const(instance: *const c_void) -> bool;
		pub fn cv_ml_DTrees_Split_setPropInversed_bool(instance: *mut c_void, val: bool);
		pub fn cv_ml_DTrees_Split_getPropQuality_const(instance: *const c_void) -> f32;
		pub fn cv_ml_DTrees_Split_setPropQuality_float(instance: *mut c_void, val: f32);
		pub fn cv_ml_DTrees_Split_getPropNext_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Split_setPropNext_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Split_getPropC_const(instance: *const c_void) -> f32;
		pub fn cv_ml_DTrees_Split_setPropC_float(instance: *mut c_void, val: f32);
		pub fn cv_ml_DTrees_Split_getPropSubsetOfs_const(instance: *const c_void) -> i32;
		pub fn cv_ml_DTrees_Split_setPropSubsetOfs_int(instance: *mut c_void, val: i32);
		pub fn cv_ml_DTrees_Split_Split() -> Result<*mut c_void>;
		pub fn cv_ml_EM_getClustersNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_EM_setClustersNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_EM_getCovarianceMatrixType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_EM_setCovarianceMatrixType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_EM_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_EM_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_EM_getWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_EM_getMeans_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_EM_getCovs_const_vector_Mat_R(instance: *const c_void, covs: *mut c_void) -> Result_void;
		pub fn cv_ml_EM_predict_const_const__InputArrayR_const__OutputArrayR_int(instance: *const c_void, samples: *const c_void, results: *const c_void, flags: i32) -> Result<f32>;
		pub fn cv_ml_EM_predict2_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, sample: *const c_void, probs: *const c_void) -> Result<core::Vec2d>;
		pub fn cv_ml_EM_trainEM_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, samples: *const c_void, log_likelihoods: *const c_void, labels: *const c_void, probs: *const c_void) -> Result<bool>;
		pub fn cv_ml_EM_trainE_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, samples: *const c_void, means0: *const c_void, covs0: *const c_void, weights0: *const c_void, log_likelihoods: *const c_void, labels: *const c_void, probs: *const c_void) -> Result<bool>;
		pub fn cv_ml_EM_trainM_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, samples: *const c_void, probs0: *const c_void, log_likelihoods: *const c_void, labels: *const c_void, probs: *const c_void) -> Result<bool>;
		pub fn cv_ml_EM_create() -> Result<*mut c_void>;
		pub fn cv_ml_EM_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_KNearest_getDefaultK_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_KNearest_setDefaultK_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_KNearest_getIsClassifier_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_KNearest_setIsClassifier_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ml_KNearest_getEmax_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_KNearest_setEmax_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_KNearest_getAlgorithmType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_KNearest_setAlgorithmType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_KNearest_findNearest_const_const__InputArrayR_int_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, samples: *const c_void, k: i32, results: *const c_void, neighbor_responses: *const c_void, dist: *const c_void) -> Result<f32>;
		pub fn cv_ml_KNearest_create() -> Result<*mut c_void>;
		pub fn cv_ml_KNearest_load_const_StringR(filepath: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_LogisticRegression_getLearningRate_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_LogisticRegression_setLearningRate_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_LogisticRegression_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_LogisticRegression_setIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_LogisticRegression_getRegularization_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_LogisticRegression_setRegularization_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_LogisticRegression_getTrainMethod_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_LogisticRegression_setTrainMethod_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_LogisticRegression_getMiniBatchSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_LogisticRegression_setMiniBatchSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_LogisticRegression_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_LogisticRegression_setTermCriteria_TermCriteria(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_LogisticRegression_predict_const_const__InputArrayR_const__OutputArrayR_int(instance: *const c_void, samples: *const c_void, results: *const c_void, flags: i32) -> Result<f32>;
		pub fn cv_ml_LogisticRegression_get_learnt_thetas_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_LogisticRegression_create() -> Result<*mut c_void>;
		pub fn cv_ml_LogisticRegression_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_NormalBayesClassifier_predictProb_const_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int(instance: *const c_void, inputs: *const c_void, outputs: *const c_void, output_probs: *const c_void, flags: i32) -> Result<f32>;
		pub fn cv_ml_NormalBayesClassifier_create() -> Result<*mut c_void>;
		pub fn cv_ml_NormalBayesClassifier_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_ParamGrid_getPropMinVal_const(instance: *const c_void) -> f64;
		pub fn cv_ml_ParamGrid_setPropMinVal_double(instance: *mut c_void, val: f64);
		pub fn cv_ml_ParamGrid_getPropMaxVal_const(instance: *const c_void) -> f64;
		pub fn cv_ml_ParamGrid_setPropMaxVal_double(instance: *mut c_void, val: f64);
		pub fn cv_ml_ParamGrid_getPropLogStep_const(instance: *const c_void) -> f64;
		pub fn cv_ml_ParamGrid_setPropLogStep_double(instance: *mut c_void, val: f64);
		pub fn cv_ml_ParamGrid_ParamGrid() -> Result<*mut c_void>;
		pub fn cv_ml_ParamGrid_ParamGrid_double_double_double(_min_val: f64, _max_val: f64, _log_step: f64) -> Result<*mut c_void>;
		pub fn cv_ml_ParamGrid_create_double_double_double(min_val: f64, max_val: f64, logstep: f64) -> Result<*mut c_void>;
		pub fn cv_ml_RTrees_getCalculateVarImportance_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_RTrees_setCalculateVarImportance_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ml_RTrees_getActiveVarCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_RTrees_setActiveVarCount_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_RTrees_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_RTrees_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_RTrees_getVarImportance_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_RTrees_getVotes_const_const__InputArrayR_const__OutputArrayR_int(instance: *const c_void, samples: *const c_void, results: *const c_void, flags: i32) -> Result_void;
		pub fn cv_ml_RTrees_getOOBError_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_RTrees_create() -> Result<*mut c_void>;
		pub fn cv_ml_RTrees_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_getType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_SVM_setType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ml_SVM_getGamma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setGamma_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getCoef0_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setCoef0_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getDegree_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setDegree_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getC_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setC_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getNu_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setNu_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getP_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_setP_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ml_SVM_getClassWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_setClassWeights_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_ml_SVM_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_SVM_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_SVM_getKernelType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_SVM_setKernel_int(instance: *mut c_void, kernel_type: i32) -> Result_void;
		pub fn cv_ml_SVM_setCustomKernel_const_Ptr_Kernel_R(instance: *mut c_void, _kernel: *const c_void) -> Result_void;
		pub fn cv_ml_SVM_trainAuto_const_Ptr_TrainData_R_int_ParamGrid_ParamGrid_ParamGrid_ParamGrid_ParamGrid_ParamGrid_bool(instance: *mut c_void, data: *const c_void, k_fold: i32, cgrid: *mut c_void, gamma_grid: *mut c_void, p_grid: *mut c_void, nu_grid: *mut c_void, coeff_grid: *mut c_void, degree_grid: *mut c_void, balanced: bool) -> Result<bool>;
		pub fn cv_ml_SVM_trainAuto_const__InputArrayR_int_const__InputArrayR_int_Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__bool(instance: *mut c_void, samples: *const c_void, layout: i32, responses: *const c_void, k_fold: i32, cgrid: *mut c_void, gamma_grid: *mut c_void, p_grid: *mut c_void, nu_grid: *mut c_void, coeff_grid: *mut c_void, degree_grid: *mut c_void, balanced: bool) -> Result<bool>;
		pub fn cv_ml_SVM_getSupportVectors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_getUncompressedSupportVectors_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_getDecisionFunction_const_int_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, i: i32, alpha: *const c_void, svidx: *const c_void) -> Result<f64>;
		pub fn cv_ml_SVM_getDefaultGrid_int(param_id: i32) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_getDefaultGridPtr_int(param_id: i32) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_create() -> Result<*mut c_void>;
		pub fn cv_ml_SVM_load_const_StringR(filepath: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_SVM_Kernel_getType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_SVM_Kernel_calc_int_int_const_floatX_const_floatX_floatX(instance: *mut c_void, vcount: i32, n: i32, vecs: *const f32, another: *const f32, results: *mut f32) -> Result_void;
		pub fn cv_ml_SVMSGD_getWeights(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ml_SVMSGD_getShift(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ml_SVMSGD_create() -> Result<*mut c_void>;
		pub fn cv_ml_SVMSGD_load_const_StringR_const_StringR(filepath: *const c_char, node_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_ml_SVMSGD_setOptimalParameters_int_int(instance: *mut c_void, svmsgd_type: i32, margin_type: i32) -> Result_void;
		pub fn cv_ml_SVMSGD_getSvmsgdType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_SVMSGD_setSvmsgdType_int(instance: *mut c_void, svmsgd_type: i32) -> Result_void;
		pub fn cv_ml_SVMSGD_getMarginType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_SVMSGD_setMarginType_int(instance: *mut c_void, margin_type: i32) -> Result_void;
		pub fn cv_ml_SVMSGD_getMarginRegularization_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ml_SVMSGD_setMarginRegularization_float(instance: *mut c_void, margin_regularization: f32) -> Result_void;
		pub fn cv_ml_SVMSGD_getInitialStepSize_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ml_SVMSGD_setInitialStepSize_float(instance: *mut c_void, initial_step_size: f32) -> Result_void;
		pub fn cv_ml_SVMSGD_getStepDecreasingPower_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ml_SVMSGD_setStepDecreasingPower_float(instance: *mut c_void, step_decreasing_power: f32) -> Result_void;
		pub fn cv_ml_SVMSGD_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_ml_SVMSGD_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, val: *const core::TermCriteria) -> Result_void;
		pub fn cv_ml_StatModel_getVarCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_StatModel_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_StatModel_isTrained_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_StatModel_isClassifier_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ml_StatModel_train_const_Ptr_TrainData_R_int(instance: *mut c_void, train_data: *const c_void, flags: i32) -> Result<bool>;
		pub fn cv_ml_StatModel_train_const__InputArrayR_int_const__InputArrayR(instance: *mut c_void, samples: *const c_void, layout: i32, responses: *const c_void) -> Result<bool>;
		pub fn cv_ml_StatModel_calcError_const_const_Ptr_TrainData_R_bool_const__OutputArrayR(instance: *const c_void, data: *const c_void, test: bool, resp: *const c_void) -> Result<f32>;
		pub fn cv_ml_StatModel_predict_const_const__InputArrayR_const__OutputArrayR_int(instance: *const c_void, samples: *const c_void, results: *const c_void, flags: i32) -> Result<f32>;
		pub fn cv_ml_TrainData_missingValue() -> Result<f32>;
		pub fn cv_ml_TrainData_getLayout_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getNTrainSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getNTestSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getNSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getNVars_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getNAllVars_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getSample_const_const__InputArrayR_int_floatX(instance: *const c_void, var_idx: *const c_void, sidx: i32, buf: *mut f32) -> Result_void;
		pub fn cv_ml_TrainData_getSamples_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getMissing_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTrainSamples_const_int_bool_bool(instance: *const c_void, layout: i32, compress_samples: bool, compress_vars: bool) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTrainResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTrainNormCatResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTestResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTestNormCatResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getNormCatResponses_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getSampleWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTrainSampleWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTestSampleWeights_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getVarIdx_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getVarType_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getVarSymbolFlags_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getResponseType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ml_TrainData_getTrainSampleIdx_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getTestSampleIdx_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getValues_const_int_const__InputArrayR_floatX(instance: *const c_void, vi: i32, sidx: *const c_void, values: *mut f32) -> Result_void;
		pub fn cv_ml_TrainData_getNormCatValues_const_int_const__InputArrayR_intX(instance: *const c_void, vi: i32, sidx: *const c_void, values: *mut i32) -> Result_void;
		pub fn cv_ml_TrainData_getDefaultSubstValues_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getCatCount_const_int(instance: *const c_void, vi: i32) -> Result<i32>;
		pub fn cv_ml_TrainData_getClassLabels_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getCatOfs_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getCatMap_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_setTrainTestSplit_int_bool(instance: *mut c_void, count: i32, shuffle: bool) -> Result_void;
		pub fn cv_ml_TrainData_setTrainTestSplitRatio_double_bool(instance: *mut c_void, ratio: f64, shuffle: bool) -> Result_void;
		pub fn cv_ml_TrainData_shuffleTrainTest(instance: *mut c_void) -> Result_void;
		pub fn cv_ml_TrainData_getTestSamples_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getNames_const_vector_String_R(instance: *const c_void, names: *mut c_void) -> Result_void;
		pub fn cv_ml_TrainData_getSubVector_const_MatR_const_MatR(vec: *const c_void, idx: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_getSubMatrix_const_MatR_const_MatR_int(matrix: *const c_void, idx: *const c_void, layout: i32) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_loadFromCSV_const_StringR_int_int_int_const_StringR_char_char(filename: *const c_char, header_line_count: i32, response_start_idx: i32, response_end_idx: i32, var_type_spec: *const c_char, delimiter: i8, missch: i8) -> Result<*mut c_void>;
		pub fn cv_ml_TrainData_create_const__InputArrayR_int_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(samples: *const c_void, layout: i32, responses: *const c_void, var_idx: *const c_void, sample_idx: *const c_void, sample_weights: *const c_void, var_type: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_ml)]
pub use ml_sys::*;

#[cfg(ocvrs_has_module_objdetect)]
mod objdetect_sys {
	use super::*;

	extern "C" {
		pub fn cv_createFaceDetectionMaskGenerator() -> Result<*mut c_void>;
		pub fn cv_groupRectangles_meanshift_vector_Rect_R_vector_double_R_vector_double_R_double_Size(rect_list: *mut c_void, found_weights: *mut c_void, found_scales: *mut c_void, detect_threshold: f64, win_det_size: *const core::Size) -> Result_void;
		pub fn cv_groupRectangles_vector_Rect_R_int_double(rect_list: *mut c_void, group_threshold: i32, eps: f64) -> Result_void;
		pub fn cv_groupRectangles_vector_Rect_R_int_double_vector_int_X_vector_double_X(rect_list: *mut c_void, group_threshold: i32, eps: f64, weights: *mut c_void, level_weights: *mut c_void) -> Result_void;
		pub fn cv_groupRectangles_vector_Rect_R_vector_int_R_int_double(rect_list: *mut c_void, weights: *mut c_void, group_threshold: i32, eps: f64) -> Result_void;
		pub fn cv_groupRectangles_vector_Rect_R_vector_int_R_vector_double_R_int_double(rect_list: *mut c_void, reject_levels: *mut c_void, level_weights: *mut c_void, group_threshold: i32, eps: f64) -> Result_void;
		pub fn cv_BaseCascadeClassifier_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_BaseCascadeClassifier_load_const_StringR(instance: *mut c_void, filename: *const c_char) -> Result<bool>;
		pub fn cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_double_int_int_Size_Size(instance: *mut c_void, image: *const c_void, objects: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size) -> Result_void;
		pub fn cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_double_int_int_Size_Size(instance: *mut c_void, image: *const c_void, objects: *mut c_void, num_detections: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size) -> Result_void;
		pub fn cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_vector_double_R_double_int_int_Size_Size_bool(instance: *mut c_void, image: *const c_void, objects: *mut c_void, reject_levels: *mut c_void, level_weights: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size, output_reject_levels: bool) -> Result_void;
		pub fn cv_BaseCascadeClassifier_isOldFormatCascade_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_BaseCascadeClassifier_getOriginalWindowSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_BaseCascadeClassifier_getFeatureType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BaseCascadeClassifier_getOldCascade(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_BaseCascadeClassifier_setMaskGenerator_const_Ptr_MaskGenerator_R(instance: *mut c_void, mask_generator: *const c_void) -> Result_void;
		pub fn cv_BaseCascadeClassifier_getMaskGenerator(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_BaseCascadeClassifier_MaskGenerator_generateMask_const_MatR(instance: *mut c_void, src: *const c_void) -> Result<*mut c_void>;
		pub fn cv_BaseCascadeClassifier_MaskGenerator_initializeMask_const_MatR(instance: *mut c_void, unnamed: *const c_void) -> Result_void;
		pub fn cv_CascadeClassifier_getPropCc(instance: *mut c_void) -> *mut c_void;
		pub fn cv_CascadeClassifier_setPropCc_Ptr_BaseCascadeClassifier_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_CascadeClassifier_CascadeClassifier() -> Result<*mut c_void>;
		pub fn cv_CascadeClassifier_CascadeClassifier_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_CascadeClassifier_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_CascadeClassifier_load_const_StringR(instance: *mut c_void, filename: *const c_char) -> Result<bool>;
		pub fn cv_CascadeClassifier_read_const_FileNodeR(instance: *mut c_void, node: *const c_void) -> Result<bool>;
		pub fn cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_double_int_int_Size_Size(instance: *mut c_void, image: *const c_void, objects: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size) -> Result_void;
		pub fn cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_double_int_int_Size_Size(instance: *mut c_void, image: *const c_void, objects: *mut c_void, num_detections: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size) -> Result_void;
		pub fn cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_vector_double_R_double_int_int_Size_Size_bool(instance: *mut c_void, image: *const c_void, objects: *mut c_void, reject_levels: *mut c_void, level_weights: *mut c_void, scale_factor: f64, min_neighbors: i32, flags: i32, min_size: *const core::Size, max_size: *const core::Size, output_reject_levels: bool) -> Result_void;
		pub fn cv_CascadeClassifier_isOldFormatCascade_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_CascadeClassifier_getOriginalWindowSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_CascadeClassifier_getFeatureType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_CascadeClassifier_getOldCascade(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_CascadeClassifier_convert_const_StringR_const_StringR(oldcascade: *const c_char, newcascade: *const c_char) -> Result<bool>;
		pub fn cv_CascadeClassifier_setMaskGenerator_const_Ptr_MaskGenerator_R(instance: *mut c_void, mask_generator: *const c_void) -> Result_void;
		pub fn cv_CascadeClassifier_getMaskGenerator(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_DetectionBasedTracker_DetectionBasedTracker_Ptr_IDetector__Ptr_IDetector__const_ParametersR(main_detector: *mut c_void, tracking_detector: *mut c_void, params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_DetectionBasedTracker_run(instance: *mut c_void) -> Result<bool>;
		pub fn cv_DetectionBasedTracker_stop(instance: *mut c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_resetTracking(instance: *mut c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_process_const_MatR(instance: *mut c_void, image_gray: *const c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_setParameters_const_ParametersR(instance: *mut c_void, params: *const c_void) -> Result<bool>;
		pub fn cv_DetectionBasedTracker_getParameters_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_DetectionBasedTracker_getObjects_const_vector_Rect_R(instance: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_getObjects_const_vector_ExtObject_R(instance: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_addObject_const_RectR(instance: *mut c_void, location: *const core::Rect) -> Result<i32>;
		pub fn cv_DetectionBasedTracker_ExtObject_getPropId_const(instance: *const c_void) -> i32;
		pub fn cv_DetectionBasedTracker_ExtObject_setPropId_int(instance: *mut c_void, val: i32);
		pub fn cv_DetectionBasedTracker_ExtObject_getPropLocation_const(instance: *const c_void) -> core::Rect;
		pub fn cv_DetectionBasedTracker_ExtObject_setPropLocation_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_DetectionBasedTracker_ExtObject_getPropStatus_const(instance: *const c_void) -> crate::objdetect::DetectionBasedTracker_ObjectStatus;
		pub fn cv_DetectionBasedTracker_ExtObject_setPropStatus_ObjectStatus(instance: *mut c_void, val: crate::objdetect::DetectionBasedTracker_ObjectStatus);
		pub fn cv_DetectionBasedTracker_ExtObject_ExtObject_int_Rect_ObjectStatus(_id: i32, _location: *const core::Rect, _status: crate::objdetect::DetectionBasedTracker_ObjectStatus) -> Result<*mut c_void>;
		pub fn cv_DetectionBasedTracker_IDetector_detect_const_MatR_vector_Rect_R(instance: *mut c_void, image: *const c_void, objects: *mut c_void) -> Result_void;
		pub fn cv_DetectionBasedTracker_IDetector_setMinObjectSize_const_SizeR(instance: *mut c_void, min: *const core::Size) -> Result_void;
		pub fn cv_DetectionBasedTracker_IDetector_setMaxObjectSize_const_SizeR(instance: *mut c_void, max: *const core::Size) -> Result_void;
		pub fn cv_DetectionBasedTracker_IDetector_getMinObjectSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_DetectionBasedTracker_IDetector_getMaxObjectSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_DetectionBasedTracker_IDetector_getScaleFactor(instance: *mut c_void) -> Result<f32>;
		pub fn cv_DetectionBasedTracker_IDetector_setScaleFactor_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_DetectionBasedTracker_IDetector_getMinNeighbours(instance: *mut c_void) -> Result<i32>;
		pub fn cv_DetectionBasedTracker_IDetector_setMinNeighbours_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_DetectionBasedTracker_Parameters_getPropMaxTrackLifetime_const(instance: *const c_void) -> i32;
		pub fn cv_DetectionBasedTracker_Parameters_setPropMaxTrackLifetime_int(instance: *mut c_void, val: i32);
		pub fn cv_DetectionBasedTracker_Parameters_getPropMinDetectionPeriod_const(instance: *const c_void) -> i32;
		pub fn cv_DetectionBasedTracker_Parameters_setPropMinDetectionPeriod_int(instance: *mut c_void, val: i32);
		pub fn cv_DetectionBasedTracker_Parameters_Parameters() -> Result<*mut c_void>;
		pub fn cv_DetectionROI_getPropScale_const(instance: *const c_void) -> f64;
		pub fn cv_DetectionROI_setPropScale_double(instance: *mut c_void, val: f64);
		pub fn cv_DetectionROI_getPropLocations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_DetectionROI_setPropLocations_vector_Point_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_DetectionROI_getPropConfidences_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_DetectionROI_setPropConfidences_vector_double_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_FaceDetectorYN_setInputSize_const_SizeR(instance: *mut c_void, input_size: *const core::Size) -> Result_void;
		pub fn cv_FaceDetectorYN_getInputSize(instance: *mut c_void) -> Result<core::Size>;
		pub fn cv_FaceDetectorYN_setScoreThreshold_float(instance: *mut c_void, score_threshold: f32) -> Result_void;
		pub fn cv_FaceDetectorYN_getScoreThreshold(instance: *mut c_void) -> Result<f32>;
		pub fn cv_FaceDetectorYN_setNMSThreshold_float(instance: *mut c_void, nms_threshold: f32) -> Result_void;
		pub fn cv_FaceDetectorYN_getNMSThreshold(instance: *mut c_void) -> Result<f32>;
		pub fn cv_FaceDetectorYN_setTopK_int(instance: *mut c_void, top_k: i32) -> Result_void;
		pub fn cv_FaceDetectorYN_getTopK(instance: *mut c_void) -> Result<i32>;
		pub fn cv_FaceDetectorYN_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void) -> Result<i32>;
		pub fn cv_FaceDetectorYN_create_const_StringR_const_StringR_const_SizeR_float_float_int_int_int(model: *const c_char, config: *const c_char, input_size: *const core::Size, score_threshold: f32, nms_threshold: f32, top_k: i32, backend_id: i32, target_id: i32) -> Result<*mut c_void>;
		pub fn cv_FaceRecognizerSF_alignCrop_const_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *const c_void, src_img: *const c_void, face_box: *const c_void, aligned_img: *const c_void) -> Result_void;
		pub fn cv_FaceRecognizerSF_feature_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, aligned_img: *const c_void, face_feature: *const c_void) -> Result_void;
		pub fn cv_FaceRecognizerSF_match_const_const__InputArrayR_const__InputArrayR_int(instance: *const c_void, _face_feature1: *const c_void, _face_feature2: *const c_void, dis_type: i32) -> Result<f64>;
		pub fn cv_FaceRecognizerSF_create_const_StringR_const_StringR_int_int(model: *const c_char, config: *const c_char, backend_id: i32, target_id: i32) -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_getPropWinSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_HOGDescriptor_setPropWinSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_HOGDescriptor_getPropBlockSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_HOGDescriptor_setPropBlockSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_HOGDescriptor_getPropBlockStride_const(instance: *const c_void) -> core::Size;
		pub fn cv_HOGDescriptor_setPropBlockStride_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_HOGDescriptor_getPropCellSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_HOGDescriptor_setPropCellSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_HOGDescriptor_getPropNbins_const(instance: *const c_void) -> i32;
		pub fn cv_HOGDescriptor_setPropNbins_int(instance: *mut c_void, val: i32);
		pub fn cv_HOGDescriptor_getPropDerivAperture_const(instance: *const c_void) -> i32;
		pub fn cv_HOGDescriptor_setPropDerivAperture_int(instance: *mut c_void, val: i32);
		pub fn cv_HOGDescriptor_getPropWinSigma_const(instance: *const c_void) -> f64;
		pub fn cv_HOGDescriptor_setPropWinSigma_double(instance: *mut c_void, val: f64);
		pub fn cv_HOGDescriptor_getPropHistogramNormType_const(instance: *const c_void) -> crate::objdetect::HOGDescriptor_HistogramNormType;
		pub fn cv_HOGDescriptor_setPropHistogramNormType_HistogramNormType(instance: *mut c_void, val: crate::objdetect::HOGDescriptor_HistogramNormType);
		pub fn cv_HOGDescriptor_getPropL2HysThreshold_const(instance: *const c_void) -> f64;
		pub fn cv_HOGDescriptor_setPropL2HysThreshold_double(instance: *mut c_void, val: f64);
		pub fn cv_HOGDescriptor_getPropGammaCorrection_const(instance: *const c_void) -> bool;
		pub fn cv_HOGDescriptor_setPropGammaCorrection_bool(instance: *mut c_void, val: bool);
		pub fn cv_HOGDescriptor_getPropSvmDetector_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_HOGDescriptor_setPropSvmDetector_vector_float_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_HOGDescriptor_getPropOclSvmDetector_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_HOGDescriptor_setPropOclSvmDetector_UMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_HOGDescriptor_getPropFree_coef_const(instance: *const c_void) -> f32;
		pub fn cv_HOGDescriptor_setPropFree_coef_float(instance: *mut c_void, val: f32);
		pub fn cv_HOGDescriptor_getPropNlevels_const(instance: *const c_void) -> i32;
		pub fn cv_HOGDescriptor_setPropNlevels_int(instance: *mut c_void, val: i32);
		pub fn cv_HOGDescriptor_getPropSignedGradient_const(instance: *const c_void) -> bool;
		pub fn cv_HOGDescriptor_setPropSignedGradient_bool(instance: *mut c_void, val: bool);
		pub fn cv_HOGDescriptor_HOGDescriptor() -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_HOGDescriptor_Size_Size_Size_Size_int_int_double_HistogramNormType_double_bool_int_bool(_win_size: *const core::Size, _block_size: *const core::Size, _block_stride: *const core::Size, _cell_size: *const core::Size, _nbins: i32, _deriv_aperture: i32, _win_sigma: f64, _histogram_norm_type: crate::objdetect::HOGDescriptor_HistogramNormType, _l2_hys_threshold: f64, _gamma_correction: bool, _nlevels: i32, _signed_gradient: bool) -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_HOGDescriptor_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_HOGDescriptor_const_HOGDescriptorR(d: *const c_void) -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_getDescriptorSize_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_HOGDescriptor_checkDetectorSize_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_HOGDescriptor_getWinSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_HOGDescriptor_setSVMDetector_const__InputArrayR(instance: *mut c_void, svmdetector: *const c_void) -> Result_void;
		pub fn cv_HOGDescriptor_read_FileNodeR(instance: *mut c_void, fn_: *mut c_void) -> Result<bool>;
		pub fn cv_HOGDescriptor_write_const_FileStorageR_const_StringR(instance: *const c_void, fs: *mut c_void, objname: *const c_char) -> Result_void;
		pub fn cv_HOGDescriptor_load_const_StringR_const_StringR(instance: *mut c_void, filename: *const c_char, objname: *const c_char) -> Result<bool>;
		pub fn cv_HOGDescriptor_save_const_const_StringR_const_StringR(instance: *const c_void, filename: *const c_char, objname: *const c_char) -> Result_void;
		pub fn cv_HOGDescriptor_copyTo_const_HOGDescriptorR(instance: *const c_void, c: *mut c_void) -> Result_void;
		pub fn cv_HOGDescriptor_compute_const_const__InputArrayR_vector_float_R_Size_Size_const_vector_Point_R(instance: *const c_void, img: *const c_void, descriptors: *mut c_void, win_stride: *const core::Size, padding: *const core::Size, locations: *const c_void) -> Result_void;
		pub fn cv_HOGDescriptor_detect_const_const__InputArrayR_vector_Point_R_vector_double_R_double_Size_Size_const_vector_Point_R(instance: *const c_void, img: *const c_void, found_locations: *mut c_void, weights: *mut c_void, hit_threshold: f64, win_stride: *const core::Size, padding: *const core::Size, search_locations: *const c_void) -> Result_void;
		pub fn cv_HOGDescriptor_detect_const_const__InputArrayR_vector_Point_R_double_Size_Size_const_vector_Point_R(instance: *const c_void, img: *const c_void, found_locations: *mut c_void, hit_threshold: f64, win_stride: *const core::Size, padding: *const core::Size, search_locations: *const c_void) -> Result_void;
		pub fn cv_HOGDescriptor_detectMultiScale_const_const__InputArrayR_vector_Rect_R_vector_double_R_double_Size_Size_double_double_bool(instance: *const c_void, img: *const c_void, found_locations: *mut c_void, found_weights: *mut c_void, hit_threshold: f64, win_stride: *const core::Size, padding: *const core::Size, scale: f64, final_threshold: f64, use_meanshift_grouping: bool) -> Result_void;
		pub fn cv_HOGDescriptor_detectMultiScale_const_const__InputArrayR_vector_Rect_R_double_Size_Size_double_double_bool(instance: *const c_void, img: *const c_void, found_locations: *mut c_void, hit_threshold: f64, win_stride: *const core::Size, padding: *const core::Size, scale: f64, final_threshold: f64, use_meanshift_grouping: bool) -> Result_void;
		pub fn cv_HOGDescriptor_computeGradient_const_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_Size(instance: *const c_void, img: *const c_void, grad: *const c_void, angle_ofs: *const c_void, padding_tl: *const core::Size, padding_br: *const core::Size) -> Result_void;
		pub fn cv_HOGDescriptor_getDefaultPeopleDetector() -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_getDaimlerPeopleDetector() -> Result<*mut c_void>;
		pub fn cv_HOGDescriptor_detectROI_const_const__InputArrayR_const_vector_Point_R_vector_Point_R_vector_double_R_double_Size_Size(instance: *const c_void, img: *const c_void, locations: *const c_void, found_locations: *mut c_void, confidences: *mut c_void, hit_threshold: f64, win_stride: *const core::Size, padding: *const core::Size) -> Result_void;
		pub fn cv_HOGDescriptor_detectMultiScaleROI_const_const__InputArrayR_vector_Rect_R_vector_DetectionROI_R_double_int(instance: *const c_void, img: *const c_void, found_locations: *mut c_void, locations: *mut c_void, hit_threshold: f64, group_threshold: i32) -> Result_void;
		pub fn cv_HOGDescriptor_groupRectangles_const_vector_Rect_R_vector_double_R_int_double(instance: *const c_void, rect_list: *mut c_void, weights: *mut c_void, group_threshold: i32, eps: f64) -> Result_void;
		pub fn cv_QRCodeDetector_QRCodeDetector() -> Result<*mut c_void>;
		pub fn cv_QRCodeDetector_setEpsX_double(instance: *mut c_void, eps_x: f64) -> Result_void;
		pub fn cv_QRCodeDetector_setEpsY_double(instance: *mut c_void, eps_y: f64) -> Result_void;
		pub fn cv_QRCodeDetector_detect_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, img: *const c_void, points: *const c_void) -> Result<bool>;
		pub fn cv_QRCodeDetector_decode_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, points: *const c_void, straight_qrcode: *const c_void) -> Result<*mut c_void>;
		pub fn cv_QRCodeDetector_decodeCurved_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, points: *const c_void, straight_qrcode: *const c_void) -> Result<*mut c_void>;
		pub fn cv_QRCodeDetector_detectAndDecode_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, points: *const c_void, straight_qrcode: *const c_void) -> Result<*mut c_void>;
		pub fn cv_QRCodeDetector_detectAndDecodeCurved_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, points: *const c_void, straight_qrcode: *const c_void) -> Result<*mut c_void>;
		pub fn cv_QRCodeDetector_detectMulti_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, img: *const c_void, points: *const c_void) -> Result<bool>;
		pub fn cv_QRCodeDetector_decodeMulti_const_const__InputArrayR_const__InputArrayR_vector_string_R_const__OutputArrayR(instance: *const c_void, img: *const c_void, points: *const c_void, decoded_info: *mut c_void, straight_qrcode: *const c_void) -> Result<bool>;
		pub fn cv_SimilarRects_getPropEps_const(instance: *const c_void) -> f64;
		pub fn cv_SimilarRects_setPropEps_double(instance: *mut c_void, val: f64);
		pub fn cv_SimilarRects_SimilarRects_double(_eps: f64) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_objdetect)]
pub use objdetect_sys::*;

#[cfg(ocvrs_has_module_optflow)]
mod optflow_sys {
	use super::*;

	extern "C" {
		pub fn cv_motempl_calcGlobalOrientation_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_double(orientation: *const c_void, mask: *const c_void, mhi: *const c_void, timestamp: f64, duration: f64) -> Result<f64>;
		pub fn cv_motempl_calcMotionGradient_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double_int(mhi: *const c_void, mask: *const c_void, orientation: *const c_void, delta1: f64, delta2: f64, aperture_size: i32) -> Result_void;
		pub fn cv_motempl_segmentMotion_const__InputArrayR_const__OutputArrayR_vector_Rect_R_double_double(mhi: *const c_void, segmask: *const c_void, bounding_rects: *mut c_void, timestamp: f64, seg_thresh: f64) -> Result_void;
		pub fn cv_motempl_updateMotionHistory_const__InputArrayR_const__InputOutputArrayR_double_double(silhouette: *const c_void, mhi: *const c_void, timestamp: f64, duration: f64) -> Result_void;
		pub fn cv_optflow_calcOpticalFlowDenseRLOF_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_Ptr_RLOFOpticalFlowParameter__float_Size_InterpolationType_int_float_float_int_int_bool_float_float_bool(i0: *const c_void, i1: *const c_void, flow: *const c_void, rlof_param: *mut c_void, forward_backward_threshold: f32, grid_step: *const core::Size, interp_type: crate::optflow::InterpolationType, epic_k: i32, epic_sigma: f32, epic_lambda: f32, ric_sp_size: i32, ric_slic_type: i32, use_post_proc: bool, fgs_lambda: f32, fgs_sigma: f32, use_variational_refinement: bool) -> Result_void;
		pub fn cv_optflow_calcOpticalFlowSF_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_int(from: *const c_void, to: *const c_void, flow: *const c_void, layers: i32, averaging_block_size: i32, max_flow: i32) -> Result_void;
		pub fn cv_optflow_calcOpticalFlowSF_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_int_double_double_int_double_double_double_int_double_double_double(from: *const c_void, to: *const c_void, flow: *const c_void, layers: i32, averaging_block_size: i32, max_flow: i32, sigma_dist: f64, sigma_color: f64, postprocess_window: i32, sigma_dist_fix: f64, sigma_color_fix: f64, occ_thr: f64, upscale_averaging_radius: i32, upscale_sigma_dist: f64, upscale_sigma_color: f64, speed_up_thr: f64) -> Result_void;
		pub fn cv_optflow_calcOpticalFlowSparseRLOF_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_Ptr_RLOFOpticalFlowParameter__float(prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, err: *const c_void, rlof_param: *mut c_void, forward_backward_threshold: f32) -> Result_void;
		pub fn cv_optflow_calcOpticalFlowSparseToDense_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_float_bool_float_float(from: *const c_void, to: *const c_void, flow: *const c_void, grid_step: i32, k: i32, sigma: f32, use_post_proc: bool, fgs_lambda: f32, fgs_sigma: f32) -> Result_void;
		pub fn cv_optflow_createOptFlow_DeepFlow() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_DenseRLOF() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_DualTVL1() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_Farneback() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_PCAFlow() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_SimpleFlow() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_SparseRLOF() -> Result<*mut c_void>;
		pub fn cv_optflow_createOptFlow_SparseToDense() -> Result<*mut c_void>;
		pub fn cv_read_const_FileNodeR_NodeR_Node(fn_: *const c_void, node: *mut crate::optflow::GPCTree_Node, unnamed: *const crate::optflow::GPCTree_Node) -> Result_void;
		pub fn cv_write_FileStorageR_const_StringR_const_NodeR(fs: *mut c_void, name: *const c_char, node: *const crate::optflow::GPCTree_Node) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setRLOFOpticalFlowParameter_Ptr_RLOFOpticalFlowParameter_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getRLOFOpticalFlowParameter_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setForwardBackward_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getForwardBackward_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getGridStep_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setGridStep_Size(instance: *mut c_void, val: *const core::Size) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setInterpolation_InterpolationType(instance: *mut c_void, val: crate::optflow::InterpolationType) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getInterpolation_const(instance: *const c_void) -> Result<crate::optflow::InterpolationType>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getEPICK_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setEPICK_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getEPICSigma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setEPICSigma_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getEPICLambda_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setEPICLambda_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getFgsLambda_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setFgsLambda_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getFgsSigma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setFgsSigma_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setUsePostProc_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getUsePostProc_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setUseVariationalRefinement_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getUseVariationalRefinement_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setRICSPSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getRICSPSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_setRICSLICType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DenseRLOFOpticalFlow_getRICSLICType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DenseRLOFOpticalFlow_create_Ptr_RLOFOpticalFlowParameter__float_Size_InterpolationType_int_float_float_int_int_bool_float_float_bool(rlof_param: *mut c_void, forward_backward_threshold: f32, grid_step: *const core::Size, interp_type: crate::optflow::InterpolationType, epic_k: i32, epic_sigma: f32, epic_lambda: f32, ric_sp_size: i32, ric_slic_type: i32, use_post_proc: bool, fgs_lambda: f32, fgs_sigma: f32, use_variational_refinement: bool) -> Result<*mut c_void>;
		pub fn cv_optflow_DualTVL1OpticalFlow_getTau_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setTau_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getLambda_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setLambda_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getTheta_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setTheta_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getGamma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setGamma_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getScalesNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setScalesNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getWarpingsNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setWarpingsNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getEpsilon_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setEpsilon_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getInnerIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setInnerIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getOuterIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setOuterIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getScaleStep_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setScaleStep_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_getMedianFiltering_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_DualTVL1OpticalFlow_setMedianFiltering_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_DualTVL1OpticalFlow_create_double_double_double_int_int_double_int_int_double_double_int_bool(tau: f64, lambda: f64, theta: f64, nscales: i32, warps: i32, epsilon: f64, innner_iterations: i32, outer_iterations: i32, scale_step: f64, gamma: f64, median_filtering: i32, use_initial_flow: bool) -> Result<*mut c_void>;
		pub fn cv_optflow_GPCDetails_getAllDescriptorsForImage_const_MatX_vector_GPCPatchDescriptor_R_const_GPCMatchingParamsR_int(img_ch: *const c_void, descr: *mut c_void, mp: *const crate::optflow::GPCMatchingParams, typ: i32) -> Result_void;
		pub fn cv_optflow_GPCDetails_getCoordinatesFromIndex_size_t_Size_intR_intR(index: size_t, sz: *const core::Size, x: *mut i32, y: *mut i32) -> Result_void;
		pub fn cv_optflow_GPCMatchingParams_GPCMatchingParams_bool(_use_opencl: bool) -> Result<crate::optflow::GPCMatchingParams>;
		pub fn cv_optflow_GPCMatchingParams_GPCMatchingParams_const_GPCMatchingParamsR(params: *const crate::optflow::GPCMatchingParams) -> Result<crate::optflow::GPCMatchingParams>;
		pub fn cv_optflow_GPCPatchDescriptor_getPropFeature_const(instance: *const c_void) -> core::VecN<f64, 18>;
		pub fn cv_optflow_GPCPatchDescriptor_setPropFeature_Vec_double__18_(instance: *mut c_void, val: *const core::VecN<f64, 18>);
		pub fn cv_optflow_GPCPatchDescriptor_dot_const_const_Vec_double__18_R(instance: *const c_void, coef: *const core::VecN<f64, 18>) -> Result<f64>;
		pub fn cv_optflow_GPCPatchDescriptor_markAsSeparated(instance: *mut c_void) -> Result_void;
		pub fn cv_optflow_GPCPatchDescriptor_isSeparated_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_GPCPatchSample_getPropRef_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_optflow_GPCPatchSample_setPropRef_GPCPatchDescriptor(instance: *mut c_void, val: *mut c_void);
		pub fn cv_optflow_GPCPatchSample_getPropPos_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_optflow_GPCPatchSample_setPropPos_GPCPatchDescriptor(instance: *mut c_void, val: *mut c_void);
		pub fn cv_optflow_GPCPatchSample_getPropNeg_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_optflow_GPCPatchSample_setPropNeg_GPCPatchDescriptor(instance: *mut c_void, val: *mut c_void);
		pub fn cv_optflow_GPCPatchSample_getDirections_const_boolR_boolR_boolR_const_Vec_double__18_R_double(instance: *const c_void, refdir: *mut bool, posdir: *mut bool, negdir: *mut bool, coef: *const core::VecN<f64, 18>, rhs: f64) -> Result_void;
		pub fn cv_optflow_GPCTrainingParams_GPCTrainingParams_unsigned_int_int_GPCDescType_bool(_max_tree_depth: u32, _min_number_of_samples: i32, _descriptor_type: crate::optflow::GPCDescType, _print_progress: bool) -> Result<crate::optflow::GPCTrainingParams>;
		pub fn cv_optflow_GPCTrainingParams_check_const(instance: *const crate::optflow::GPCTrainingParams) -> Result<bool>;
		pub fn cv_optflow_GPCTrainingSamples_create_const_vector_String_R_const_vector_String_R_const_vector_String_R_int(images_from: *const c_void, images_to: *const c_void, gt: *const c_void, descriptor_type: i32) -> Result<*mut c_void>;
		pub fn cv_optflow_GPCTrainingSamples_create_const__InputArrayR_const__InputArrayR_const__InputArrayR_int(images_from: *const c_void, images_to: *const c_void, gt: *const c_void, descriptor_type: i32) -> Result<*mut c_void>;
		pub fn cv_optflow_GPCTrainingSamples_size_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_optflow_GPCTrainingSamples_type_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_GPCTree_train_GPCTrainingSamplesR_const_GPCTrainingParams(instance: *mut c_void, samples: *mut c_void, params: *const crate::optflow::GPCTrainingParams) -> Result_void;
		pub fn cv_optflow_GPCTree_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_optflow_GPCTree_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_optflow_GPCTree_findLeafForPatch_const_const_GPCPatchDescriptorR(instance: *const c_void, descr: *const c_void) -> Result<u32>;
		pub fn cv_optflow_GPCTree_create() -> Result<*mut c_void>;
		pub fn cv_optflow_GPCTree_operatorEQ_const_const_GPCTreeR(instance: *const c_void, t: *const c_void) -> Result<bool>;
		pub fn cv_optflow_GPCTree_getDescriptorType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_GPCTree_Node_operatorEQ_const_const_NodeR(instance: *const crate::optflow::GPCTree_Node, n: *const crate::optflow::GPCTree_Node) -> Result<bool>;
		pub fn cv_optflow_OpticalFlowPCAFlow_OpticalFlowPCAFlow_Ptr_const_PCAPrior__const_Size_float_float_float_float_float(_prior: *const c_void, _basis_size: *const core::Size, _sparse_rate: f32, _retained_corners_fraction: f32, _occlusions_threshold: f32, _damping_factor: f32, _clahe_clip: f32) -> Result<*mut c_void>;
		pub fn cv_optflow_OpticalFlowPCAFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow: *const c_void) -> Result_void;
		pub fn cv_optflow_OpticalFlowPCAFlow_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_optflow_PCAPrior_PCAPrior_const_charX(path_to_prior: *const c_char) -> Result<*mut c_void>;
		pub fn cv_optflow_PCAPrior_getPadding_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_PCAPrior_getBasisSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_PCAPrior_fillConstraints_const_floatX_floatX_floatX_floatX(instance: *const c_void, a1: *mut f32, a2: *mut f32, b1: *mut f32, b2: *mut f32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropSolverType_const(instance: *const c_void) -> crate::optflow::SolverType;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropSolverType_SolverType(instance: *mut c_void, val: crate::optflow::SolverType);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropSupportRegionType_const(instance: *const c_void) -> crate::optflow::SupportRegionType;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropSupportRegionType_SupportRegionType(instance: *mut c_void, val: crate::optflow::SupportRegionType);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropNormSigma0_const(instance: *const c_void) -> f32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropNormSigma0_float(instance: *mut c_void, val: f32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropNormSigma1_const(instance: *const c_void) -> f32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropNormSigma1_float(instance: *mut c_void, val: f32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropSmallWinSize_const(instance: *const c_void) -> i32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropSmallWinSize_int(instance: *mut c_void, val: i32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropLargeWinSize_const(instance: *const c_void) -> i32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropLargeWinSize_int(instance: *mut c_void, val: i32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropCrossSegmentationThreshold_const(instance: *const c_void) -> i32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropCrossSegmentationThreshold_int(instance: *mut c_void, val: i32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropMaxLevel_const(instance: *const c_void) -> i32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropMaxLevel_int(instance: *mut c_void, val: i32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropUseInitialFlow_const(instance: *const c_void) -> bool;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropUseInitialFlow_bool(instance: *mut c_void, val: bool);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropUseIlluminationModel_const(instance: *const c_void) -> bool;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropUseIlluminationModel_bool(instance: *mut c_void, val: bool);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropUseGlobalMotionPrior_const(instance: *const c_void) -> bool;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropUseGlobalMotionPrior_bool(instance: *mut c_void, val: bool);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropMaxIteration_const(instance: *const c_void) -> i32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropMaxIteration_int(instance: *mut c_void, val: i32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropMinEigenValue_const(instance: *const c_void) -> f32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropMinEigenValue_float(instance: *mut c_void, val: f32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_getPropGlobalMotionRansacThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setPropGlobalMotionRansacThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_optflow_RLOFOpticalFlowParameter_RLOFOpticalFlowParameter() -> Result<*mut c_void>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setUseMEstimator_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setSolverType_SolverType(instance: *mut c_void, val: crate::optflow::SolverType) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getSolverType_const(instance: *const c_void) -> Result<crate::optflow::SolverType>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setSupportRegionType_SupportRegionType(instance: *mut c_void, val: crate::optflow::SupportRegionType) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getSupportRegionType_const(instance: *const c_void) -> Result<crate::optflow::SupportRegionType>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setNormSigma0_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getNormSigma0_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setNormSigma1_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getNormSigma1_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setSmallWinSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getSmallWinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setLargeWinSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getLargeWinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setCrossSegmentationThreshold_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getCrossSegmentationThreshold_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setMaxLevel_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getMaxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setUseInitialFlow_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setUseIlluminationModel_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getUseIlluminationModel_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setUseGlobalMotionPrior_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getUseGlobalMotionPrior_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setMaxIteration_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getMaxIteration_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setMinEigenValue_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getMinEigenValue_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_setGlobalMotionRansacThreshold_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_RLOFOpticalFlowParameter_getGlobalMotionRansacThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_RLOFOpticalFlowParameter_create() -> Result<*mut c_void>;
		pub fn cv_optflow_SparseRLOFOpticalFlow_setRLOFOpticalFlowParameter_Ptr_RLOFOpticalFlowParameter_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_optflow_SparseRLOFOpticalFlow_getRLOFOpticalFlowParameter_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_optflow_SparseRLOFOpticalFlow_setForwardBackward_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_optflow_SparseRLOFOpticalFlow_getForwardBackward_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_optflow_SparseRLOFOpticalFlow_create_Ptr_RLOFOpticalFlowParameter__float(rlof_param: *mut c_void, forward_backward_threshold: f32) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_optflow)]
pub use optflow_sys::*;

#[cfg(ocvrs_has_module_ovis)]
mod ovis_sys {
	use super::*;

	extern "C" {
		pub fn cv_ovis_addResourceLocation_const_StringR(path: *const c_char) -> Result_void;
		pub fn cv_ovis_createGridMesh_const_StringR_const_Size2fR_const_SizeR(name: *const c_char, size: *const core::Size2f, segments: *const core::Size) -> Result_void;
		pub fn cv_ovis_createPlaneMesh_const_StringR_const_Size2fR_const__InputArrayR(name: *const c_char, size: *const core::Size2f, image: *const c_void) -> Result_void;
		pub fn cv_ovis_createPointCloudMesh_const_StringR_const__InputArrayR_const__InputArrayR(name: *const c_char, vertices: *const c_void, colors: *const c_void) -> Result_void;
		pub fn cv_ovis_createTriangleMesh_const_StringR_const__InputArrayR_const__InputArrayR_const__InputArrayR(name: *const c_char, vertices: *const c_void, normals: *const c_void, indices: *const c_void) -> Result_void;
		pub fn cv_ovis_createWindow_const_StringR_const_SizeR_int(title: *const c_char, size: *const core::Size, flags: i32) -> Result<*mut c_void>;
		pub fn cv_ovis_setMaterialProperty_const_StringR_const_StringR_const_ScalarR(name: *const c_char, prop: *const c_char, value: *const core::Scalar) -> Result_void;
		pub fn cv_ovis_setMaterialProperty_const_StringR_int_const_ScalarR(name: *const c_char, prop: i32, value: *const core::Scalar) -> Result_void;
		pub fn cv_ovis_setMaterialProperty_const_StringR_int_const_StringR(name: *const c_char, prop: i32, value: *const c_char) -> Result_void;
		pub fn cv_ovis_setMaterialProperty_const_StringR_int_const__InputArrayR(name: *const c_char, prop: i32, value: *const c_void) -> Result_void;
		pub fn cv_ovis_updateTexture_const_StringR_const__InputArrayR(name: *const c_char, image: *const c_void) -> Result_void;
		pub fn cv_ovis_waitKey_int(delay: i32) -> Result<i32>;
		pub fn cv_ovis_WindowScene_setBackground_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_setBackground_const_ScalarR(instance: *mut c_void, color: *const core::Scalar) -> Result_void;
		pub fn cv_ovis_WindowScene_setCompositors_const_vector_String_R(instance: *mut c_void, names: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_createEntity_const_StringR_const_StringR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, name: *const c_char, meshname: *const c_char, tvec: *const c_void, rot: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_removeEntity_const_StringR(instance: *mut c_void, name: *const c_char) -> Result_void;
		pub fn cv_ovis_WindowScene_setEntityProperty_const_StringR_int_const_ScalarR(instance: *mut c_void, name: *const c_char, prop: i32, value: *const core::Scalar) -> Result_void;
		pub fn cv_ovis_WindowScene_setEntityProperty_const_StringR_int_const_StringR_int(instance: *mut c_void, name: *const c_char, prop: i32, value: *const c_char, sub_entity_idx: i32) -> Result_void;
		pub fn cv_ovis_WindowScene_getEntityProperty_const_StringR_int_const__OutputArrayR(instance: *mut c_void, name: *const c_char, prop: i32, value: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_createCameraEntity_const_StringR_const__InputArrayR_const_SizeR_float_const__InputArrayR_const__InputArrayR_const_ScalarR(instance: *mut c_void, name: *const c_char, k: *const c_void, imsize: *const core::Size, z_far: f32, tvec: *const c_void, rot: *const c_void, color: *const core::Scalar) -> Result<core::Rect2d>;
		pub fn cv_ovis_WindowScene_createLightEntity_const_StringR_const__InputArrayR_const__InputArrayR_const_ScalarR_const_ScalarR(instance: *mut c_void, name: *const c_char, tvec: *const c_void, rot: *const c_void, diffuse_color: *const core::Scalar, specular_color: *const core::Scalar) -> Result_void;
		pub fn cv_ovis_WindowScene_updateEntityPose_const_StringR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, name: *const c_char, tvec: *const c_void, rot: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_setEntityPose_const_StringR_const__InputArrayR_const__InputArrayR_bool(instance: *mut c_void, name: *const c_char, tvec: *const c_void, rot: *const c_void, invert: bool) -> Result_void;
		pub fn cv_ovis_WindowScene_getEntityPose_const_StringR_const__OutputArrayR_const__OutputArrayR_bool(instance: *mut c_void, name: *const c_char, r: *const c_void, tvec: *const c_void, invert: bool) -> Result_void;
		pub fn cv_ovis_WindowScene_getEntityAnimations_const_StringR_vector_String_R(instance: *mut c_void, name: *const c_char, out: *mut c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_playEntityAnimation_const_StringR_const_StringR_bool(instance: *mut c_void, name: *const c_char, animname: *const c_char, loop_: bool) -> Result_void;
		pub fn cv_ovis_WindowScene_stopEntityAnimation_const_StringR_const_StringR(instance: *mut c_void, name: *const c_char, animname: *const c_char) -> Result_void;
		pub fn cv_ovis_WindowScene_getScreenshot_const__OutputArrayR(instance: *mut c_void, frame: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_getCompositorTexture_const_StringR_const_StringR_const__OutputArrayR_int(instance: *mut c_void, compname: *const c_char, texname: *const c_char, out: *const c_void, mrt_index: i32) -> Result_void;
		pub fn cv_ovis_WindowScene_getDepth_const__OutputArrayR(instance: *mut c_void, depth: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_fixCameraYawAxis_bool_const__InputArrayR(instance: *mut c_void, use_fixed: bool, up: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_setCameraPose_const__InputArrayR_const__InputArrayR_bool(instance: *mut c_void, tvec: *const c_void, rot: *const c_void, invert: bool) -> Result_void;
		pub fn cv_ovis_WindowScene_setCameraLookAt_const_StringR_const__InputArrayR(instance: *mut c_void, target: *const c_char, offset: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_setEntityLookAt_const_StringR_const_StringR_const__InputArrayR(instance: *mut c_void, origin: *const c_char, target: *const c_char, offset: *const c_void) -> Result_void;
		pub fn cv_ovis_WindowScene_getCameraPose_const__OutputArrayR_const__OutputArrayR_bool(instance: *mut c_void, r: *const c_void, tvec: *const c_void, invert: bool) -> Result_void;
		pub fn cv_ovis_WindowScene_setCameraIntrinsics_const__InputArrayR_const_SizeR_float_float(instance: *mut c_void, k: *const c_void, imsize: *const core::Size, z_near: f32, z_far: f32) -> Result_void;
		pub fn cv_ovis_WindowScene_update(instance: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_ovis)]
pub use ovis_sys::*;

#[cfg(ocvrs_has_module_phase_unwrapping)]
mod phase_unwrapping_sys {
	use super::*;

	extern "C" {
		pub fn cv_phase_unwrapping_HistogramPhaseUnwrapping_create_const_ParamsR(parameters: *const crate::phase_unwrapping::HistogramPhaseUnwrapping_Params) -> Result<*mut c_void>;
		pub fn cv_phase_unwrapping_HistogramPhaseUnwrapping_getInverseReliabilityMap_const__OutputArrayR(instance: *mut c_void, reliability_map: *const c_void) -> Result_void;
		pub fn cv_phase_unwrapping_HistogramPhaseUnwrapping_Params_Params() -> Result<crate::phase_unwrapping::HistogramPhaseUnwrapping_Params>;
		pub fn cv_phase_unwrapping_PhaseUnwrapping_unwrapPhaseMap_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, wrapped_phase_map: *const c_void, unwrapped_phase_map: *const c_void, shadow_mask: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_phase_unwrapping)]
pub use phase_unwrapping_sys::*;

#[cfg(ocvrs_has_module_photo)]
mod photo_sys {
	use super::*;

	extern "C" {
		pub fn cv_colorChange_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_float_float(src: *const c_void, mask: *const c_void, dst: *const c_void, red_mul: f32, green_mul: f32, blue_mul: f32) -> Result_void;
		pub fn cv_createAlignMTB_int_int_bool(max_bits: i32, exclude_range: i32, cut: bool) -> Result<*mut c_void>;
		pub fn cv_createCalibrateDebevec_int_float_bool(samples: i32, lambda: f32, random: bool) -> Result<*mut c_void>;
		pub fn cv_createCalibrateRobertson_int_float(max_iter: i32, threshold: f32) -> Result<*mut c_void>;
		pub fn cv_createMergeDebevec() -> Result<*mut c_void>;
		pub fn cv_createMergeMertens_float_float_float(contrast_weight: f32, saturation_weight: f32, exposure_weight: f32) -> Result<*mut c_void>;
		pub fn cv_createMergeRobertson() -> Result<*mut c_void>;
		pub fn cv_createTonemapDrago_float_float_float(gamma: f32, saturation: f32, bias: f32) -> Result<*mut c_void>;
		pub fn cv_createTonemapMantiuk_float_float_float(gamma: f32, scale: f32, saturation: f32) -> Result<*mut c_void>;
		pub fn cv_createTonemapReinhard_float_float_float_float(gamma: f32, intensity: f32, light_adapt: f32, color_adapt: f32) -> Result<*mut c_void>;
		pub fn cv_createTonemap_float(gamma: f32) -> Result<*mut c_void>;
		pub fn cv_cuda_fastNlMeansDenoisingColored_const__InputArrayR_const__OutputArrayR_float_float_int_int_StreamR(src: *const c_void, dst: *const c_void, h_luminance: f32, photo_render: f32, search_window: i32, block_size: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_fastNlMeansDenoising_const__InputArrayR_const__OutputArrayR_float_int_int_StreamR(src: *const c_void, dst: *const c_void, h: f32, search_window: i32, block_size: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_cuda_nonLocalMeans_const__InputArrayR_const__OutputArrayR_float_int_int_int_StreamR(src: *const c_void, dst: *const c_void, h: f32, search_window: i32, block_size: i32, border_mode: i32, stream: *mut c_void) -> Result_void;
		pub fn cv_decolor_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, grayscale: *const c_void, color_boost: *const c_void) -> Result_void;
		pub fn cv_denoise_TVL1_const_vector_Mat_R_MatR_double_int(observations: *const c_void, result: *mut c_void, lambda: f64, niters: i32) -> Result_void;
		pub fn cv_detailEnhance_const__InputArrayR_const__OutputArrayR_float_float(src: *const c_void, dst: *const c_void, sigma_s: f32, sigma_r: f32) -> Result_void;
		pub fn cv_edgePreservingFilter_const__InputArrayR_const__OutputArrayR_int_float_float(src: *const c_void, dst: *const c_void, flags: i32, sigma_s: f32, sigma_r: f32) -> Result_void;
		pub fn cv_fastNlMeansDenoisingColoredMulti_const__InputArrayR_const__OutputArrayR_int_int_float_float_int_int(src_imgs: *const c_void, dst: *const c_void, img_to_denoise_index: i32, temporal_window_size: i32, h: f32, h_color: f32, template_window_size: i32, search_window_size: i32) -> Result_void;
		pub fn cv_fastNlMeansDenoisingColored_const__InputArrayR_const__OutputArrayR_float_float_int_int(src: *const c_void, dst: *const c_void, h: f32, h_color: f32, template_window_size: i32, search_window_size: i32) -> Result_void;
		pub fn cv_fastNlMeansDenoisingMulti_const__InputArrayR_const__OutputArrayR_int_int_const_vector_float_R_int_int_int(src_imgs: *const c_void, dst: *const c_void, img_to_denoise_index: i32, temporal_window_size: i32, h: *const c_void, template_window_size: i32, search_window_size: i32, norm_type: i32) -> Result_void;
		pub fn cv_fastNlMeansDenoisingMulti_const__InputArrayR_const__OutputArrayR_int_int_float_int_int(src_imgs: *const c_void, dst: *const c_void, img_to_denoise_index: i32, temporal_window_size: i32, h: f32, template_window_size: i32, search_window_size: i32) -> Result_void;
		pub fn cv_fastNlMeansDenoising_const__InputArrayR_const__OutputArrayR_const_vector_float_R_int_int_int(src: *const c_void, dst: *const c_void, h: *const c_void, template_window_size: i32, search_window_size: i32, norm_type: i32) -> Result_void;
		pub fn cv_fastNlMeansDenoising_const__InputArrayR_const__OutputArrayR_float_int_int(src: *const c_void, dst: *const c_void, h: f32, template_window_size: i32, search_window_size: i32) -> Result_void;
		pub fn cv_illuminationChange_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_float(src: *const c_void, mask: *const c_void, dst: *const c_void, alpha: f32, beta: f32) -> Result_void;
		pub fn cv_inpaint_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(src: *const c_void, inpaint_mask: *const c_void, dst: *const c_void, inpaint_radius: f64, flags: i32) -> Result_void;
		pub fn cv_pencilSketch_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_float_float_float(src: *const c_void, dst1: *const c_void, dst2: *const c_void, sigma_s: f32, sigma_r: f32, shade_factor: f32) -> Result_void;
		pub fn cv_seamlessClone_const__InputArrayR_const__InputArrayR_const__InputArrayR_Point_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, mask: *const c_void, p: *const core::Point, blend: *const c_void, flags: i32) -> Result_void;
		pub fn cv_stylization_const__InputArrayR_const__OutputArrayR_float_float(src: *const c_void, dst: *const c_void, sigma_s: f32, sigma_r: f32) -> Result_void;
		pub fn cv_textureFlattening_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_float_int(src: *const c_void, mask: *const c_void, dst: *const c_void, low_threshold: f32, high_threshold: f32, kernel_size: i32) -> Result_void;
		pub fn cv_AlignExposures_process_const__InputArrayR_vector_Mat_R_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *mut c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_AlignMTB_process_const__InputArrayR_vector_Mat_R_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *mut c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_AlignMTB_process_const__InputArrayR_vector_Mat_R(instance: *mut c_void, src: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_AlignMTB_calculateShift_const__InputArrayR_const__InputArrayR(instance: *mut c_void, img0: *const c_void, img1: *const c_void) -> Result<core::Point>;
		pub fn cv_AlignMTB_shiftMat_const__InputArrayR_const__OutputArrayR_const_Point(instance: *mut c_void, src: *const c_void, dst: *const c_void, shift: *const core::Point) -> Result_void;
		pub fn cv_AlignMTB_computeBitmaps_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, tb: *const c_void, eb: *const c_void) -> Result_void;
		pub fn cv_AlignMTB_getMaxBits_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AlignMTB_setMaxBits_int(instance: *mut c_void, max_bits: i32) -> Result_void;
		pub fn cv_AlignMTB_getExcludeRange_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_AlignMTB_setExcludeRange_int(instance: *mut c_void, exclude_range: i32) -> Result_void;
		pub fn cv_AlignMTB_getCut_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_AlignMTB_setCut_bool(instance: *mut c_void, value: bool) -> Result_void;
		pub fn cv_CalibrateCRF_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void) -> Result_void;
		pub fn cv_CalibrateDebevec_getLambda_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_CalibrateDebevec_setLambda_float(instance: *mut c_void, lambda: f32) -> Result_void;
		pub fn cv_CalibrateDebevec_getSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_CalibrateDebevec_setSamples_int(instance: *mut c_void, samples: i32) -> Result_void;
		pub fn cv_CalibrateDebevec_getRandom_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_CalibrateDebevec_setRandom_bool(instance: *mut c_void, random: bool) -> Result_void;
		pub fn cv_CalibrateRobertson_getMaxIter_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_CalibrateRobertson_setMaxIter_int(instance: *mut c_void, max_iter: i32) -> Result_void;
		pub fn cv_CalibrateRobertson_getThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_CalibrateRobertson_setThreshold_float(instance: *mut c_void, threshold: f32) -> Result_void;
		pub fn cv_CalibrateRobertson_getRadiance_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_MergeDebevec_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_MergeDebevec_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void) -> Result_void;
		pub fn cv_MergeExposures_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_MergeMertens_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_MergeMertens_process_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_MergeMertens_getContrastWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_MergeMertens_setContrastWeight_float(instance: *mut c_void, contrast_weiht: f32) -> Result_void;
		pub fn cv_MergeMertens_getSaturationWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_MergeMertens_setSaturationWeight_float(instance: *mut c_void, saturation_weight: f32) -> Result_void;
		pub fn cv_MergeMertens_getExposureWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_MergeMertens_setExposureWeight_float(instance: *mut c_void, exposure_weight: f32) -> Result_void;
		pub fn cv_MergeRobertson_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_MergeRobertson_process_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, times: *const c_void) -> Result_void;
		pub fn cv_Tonemap_process_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_Tonemap_getGamma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_Tonemap_setGamma_float(instance: *mut c_void, gamma: f32) -> Result_void;
		pub fn cv_TonemapDrago_getSaturation_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapDrago_setSaturation_float(instance: *mut c_void, saturation: f32) -> Result_void;
		pub fn cv_TonemapDrago_getBias_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapDrago_setBias_float(instance: *mut c_void, bias: f32) -> Result_void;
		pub fn cv_TonemapMantiuk_getScale_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapMantiuk_setScale_float(instance: *mut c_void, scale: f32) -> Result_void;
		pub fn cv_TonemapMantiuk_getSaturation_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapMantiuk_setSaturation_float(instance: *mut c_void, saturation: f32) -> Result_void;
		pub fn cv_TonemapReinhard_getIntensity_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapReinhard_setIntensity_float(instance: *mut c_void, intensity: f32) -> Result_void;
		pub fn cv_TonemapReinhard_getLightAdaptation_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapReinhard_setLightAdaptation_float(instance: *mut c_void, light_adapt: f32) -> Result_void;
		pub fn cv_TonemapReinhard_getColorAdaptation_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_TonemapReinhard_setColorAdaptation_float(instance: *mut c_void, color_adapt: f32) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_photo)]
pub use photo_sys::*;

#[cfg(ocvrs_has_module_plot)]
mod plot_sys {
	use super::*;

	extern "C" {
		pub fn cv_plot_Plot2d_setMinX_double(instance: *mut c_void, _plot_min_x: f64) -> Result_void;
		pub fn cv_plot_Plot2d_setMinY_double(instance: *mut c_void, _plot_min_y: f64) -> Result_void;
		pub fn cv_plot_Plot2d_setMaxX_double(instance: *mut c_void, _plot_max_x: f64) -> Result_void;
		pub fn cv_plot_Plot2d_setMaxY_double(instance: *mut c_void, _plot_max_y: f64) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotLineWidth_int(instance: *mut c_void, _plot_line_width: i32) -> Result_void;
		pub fn cv_plot_Plot2d_setNeedPlotLine_bool(instance: *mut c_void, _need_plot_line: bool) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotLineColor_Scalar(instance: *mut c_void, _plot_line_color: *const core::Scalar) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotBackgroundColor_Scalar(instance: *mut c_void, _plot_background_color: *const core::Scalar) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotAxisColor_Scalar(instance: *mut c_void, _plot_axis_color: *const core::Scalar) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotGridColor_Scalar(instance: *mut c_void, _plot_grid_color: *const core::Scalar) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotTextColor_Scalar(instance: *mut c_void, _plot_text_color: *const core::Scalar) -> Result_void;
		pub fn cv_plot_Plot2d_setPlotSize_int_int(instance: *mut c_void, _plot_size_width: i32, _plot_size_height: i32) -> Result_void;
		pub fn cv_plot_Plot2d_setShowGrid_bool(instance: *mut c_void, need_show_grid: bool) -> Result_void;
		pub fn cv_plot_Plot2d_setShowText_bool(instance: *mut c_void, need_show_text: bool) -> Result_void;
		pub fn cv_plot_Plot2d_setGridLinesNumber_int(instance: *mut c_void, grid_lines_number: i32) -> Result_void;
		pub fn cv_plot_Plot2d_setInvertOrientation_bool(instance: *mut c_void, _invert_orientation: bool) -> Result_void;
		pub fn cv_plot_Plot2d_setPointIdxToPrint_int(instance: *mut c_void, point_idx: i32) -> Result_void;
		pub fn cv_plot_Plot2d_render_const__OutputArrayR(instance: *mut c_void, _plot_result: *const c_void) -> Result_void;
		pub fn cv_plot_Plot2d_create_const__InputArrayR(data: *const c_void) -> Result<*mut c_void>;
		pub fn cv_plot_Plot2d_create_const__InputArrayR_const__InputArrayR(data_x: *const c_void, data_y: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_plot)]
pub use plot_sys::*;

#[cfg(ocvrs_has_module_quality)]
mod quality_sys {
	use super::*;

	extern "C" {
		pub fn cv_quality_QualityBRISQUE_compute_const__InputArrayR(instance: *mut c_void, img: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityBRISQUE_create_const_StringR_const_StringR(model_file_path: *const c_char, range_file_path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_quality_QualityBRISQUE_create_const_Ptr_SVM_R_const_MatR(model: *const c_void, range: *const c_void) -> Result<*mut c_void>;
		pub fn cv_quality_QualityBRISQUE_compute_const__InputArrayR_const_StringR_const_StringR(img: *const c_void, model_file_path: *const c_char, range_file_path: *const c_char) -> Result<core::Scalar>;
		pub fn cv_quality_QualityBRISQUE_computeFeatures_const__InputArrayR_const__OutputArrayR(img: *const c_void, features: *const c_void) -> Result_void;
		pub fn cv_quality_QualityBase_compute_const__InputArrayR(instance: *mut c_void, img: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityBase_getQualityMap_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_quality_QualityBase_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_quality_QualityBase_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_quality_QualityGMSD_compute_const__InputArrayR(instance: *mut c_void, cmp: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityGMSD_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_quality_QualityGMSD_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_quality_QualityGMSD_create_const__InputArrayR(ref_: *const c_void) -> Result<*mut c_void>;
		pub fn cv_quality_QualityGMSD_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(ref_: *const c_void, cmp: *const c_void, quality_map: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityMSE_compute_const__InputArrayR(instance: *mut c_void, cmp_imgs: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityMSE_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_quality_QualityMSE_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_quality_QualityMSE_create_const__InputArrayR(ref_: *const c_void) -> Result<*mut c_void>;
		pub fn cv_quality_QualityMSE_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(ref_: *const c_void, cmp: *const c_void, quality_map: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityPSNR_create_const__InputArrayR_double(ref_: *const c_void, max_pixel_value: f64) -> Result<*mut c_void>;
		pub fn cv_quality_QualityPSNR_compute_const__InputArrayR(instance: *mut c_void, cmp: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualityPSNR_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_quality_QualityPSNR_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_quality_QualityPSNR_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(ref_: *const c_void, cmp: *const c_void, quality_map: *const c_void, max_pixel_value: f64) -> Result<core::Scalar>;
		pub fn cv_quality_QualityPSNR_getMaxPixelValue_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_quality_QualityPSNR_setMaxPixelValue_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_quality_QualitySSIM_compute_const__InputArrayR(instance: *mut c_void, cmp: *const c_void) -> Result<core::Scalar>;
		pub fn cv_quality_QualitySSIM_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_quality_QualitySSIM_clear(instance: *mut c_void) -> Result_void;
		pub fn cv_quality_QualitySSIM_create_const__InputArrayR(ref_: *const c_void) -> Result<*mut c_void>;
		pub fn cv_quality_QualitySSIM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(ref_: *const c_void, cmp: *const c_void, quality_map: *const c_void) -> Result<core::Scalar>;
	}
}
#[cfg(ocvrs_has_module_quality)]
pub use quality_sys::*;

#[cfg(ocvrs_has_module_rapid)]
mod rapid_sys {
	use super::*;

	extern "C" {
		pub fn cv_rapid_convertCorrespondencies_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputOutputArrayR_const__InputArrayR(cols: *const c_void, src_locations: *const c_void, pts2d: *const c_void, pts3d: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_rapid_drawCorrespondencies_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(bundle: *const c_void, cols: *const c_void, colors: *const c_void) -> Result_void;
		pub fn cv_rapid_drawSearchLines_const__InputOutputArrayR_const__InputArrayR_const_ScalarR(img: *const c_void, locations: *const c_void, color: *const core::Scalar) -> Result_void;
		pub fn cv_rapid_drawWireframe_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const_ScalarR_int_bool(img: *const c_void, pts2d: *const c_void, tris: *const c_void, color: *const core::Scalar, typ: i32, cull_backface: bool) -> Result_void;
		pub fn cv_rapid_extractControlPoints_int_int_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(num: i32, len: i32, pts3d: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, imsize: *const core::Size, tris: *const c_void, ctl2d: *const c_void, ctl3d: *const c_void) -> Result_void;
		pub fn cv_rapid_extractLineBundle_int_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(len: i32, ctl2d: *const c_void, img: *const c_void, bundle: *const c_void, src_locations: *const c_void) -> Result_void;
		pub fn cv_rapid_findCorrespondencies_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(bundle: *const c_void, cols: *const c_void, response: *const c_void) -> Result_void;
		pub fn cv_rapid_rapid_const__InputArrayR_int_int_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_doubleX(img: *const c_void, num: i32, len: i32, pts3d: *const c_void, tris: *const c_void, k: *const c_void, rvec: *const c_void, tvec: *const c_void, rmsd: *mut f64) -> Result<f32>;
		pub fn cv_rapid_GOSTracker_create_const__InputArrayR_const__InputArrayR_int_unsigned_char(pts3d: *const c_void, tris: *const c_void, hist_bins: i32, sobel_thesh: u8) -> Result<*mut c_void>;
		pub fn cv_rapid_OLSTracker_create_const__InputArrayR_const__InputArrayR_int_unsigned_char(pts3d: *const c_void, tris: *const c_void, hist_bins: i32, sobel_thesh: u8) -> Result<*mut c_void>;
		pub fn cv_rapid_Rapid_create_const__InputArrayR_const__InputArrayR(pts3d: *const c_void, tris: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rapid_Tracker_compute_const__InputArrayR_int_int_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const_TermCriteriaR(instance: *mut c_void, img: *const c_void, num: i32, len: i32, k: *const c_void, rvec: *const c_void, tvec: *const c_void, termcrit: *const core::TermCriteria) -> Result<f32>;
		pub fn cv_rapid_Tracker_clearState(instance: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_rapid)]
pub use rapid_sys::*;

#[cfg(ocvrs_has_module_rgbd)]
mod rgbd_sys {
	use super::*;

	extern "C" {
		pub fn cv_kinfu_makeVolume_VolumeType_float_Matx44f_float_float_int_float_Vec3i(_volume_type: crate::rgbd::Kinfu_VolumeType, _voxel_size: f32, _pose: *const core::Matx44f, _raycast_step_factor: f32, _trunc_dist: f32, _max_weight: i32, _truncate_threshold: f32, _resolution: *const core::Vec3i) -> Result<*mut c_void>;
		pub fn cv_linemod_colormap_const_MatR_MatR(quantized: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_linemod_drawFeatures_const__InputOutputArrayR_const_vector_Template_R_const_Point2iR_int(img: *const c_void, templates: *const c_void, tl: *const core::Point2i, size: i32) -> Result_void;
		pub fn cv_linemod_getDefaultLINE() -> Result<*mut c_void>;
		pub fn cv_linemod_getDefaultLINEMOD() -> Result<*mut c_void>;
		pub fn cv_rgbd_depthTo3dSparse_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(depth: *const c_void, in_k: *const c_void, in_points: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_rgbd_depthTo3d_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(depth: *const c_void, k: *const c_void, points3d: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_rgbd_isValidDepth_const_doubleR(depth: *const f64) -> Result<bool>;
		pub fn cv_rgbd_isValidDepth_const_floatR(depth: *const f32) -> Result<bool>;
		pub fn cv_rgbd_isValidDepth_const_intR(depth: *const i32) -> Result<bool>;
		pub fn cv_rgbd_isValidDepth_const_shortR(depth: *const i16) -> Result<bool>;
		pub fn cv_rgbd_isValidDepth_const_unsigned_intR(depth: *const u32) -> Result<bool>;
		pub fn cv_rgbd_isValidDepth_const_unsigned_shortR(depth: *const u16) -> Result<bool>;
		pub fn cv_rgbd_registerDepth_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__OutputArrayR_bool(unregistered_camera_matrix: *const c_void, registered_camera_matrix: *const c_void, registered_dist_coeffs: *const c_void, rt: *const c_void, unregistered_depth: *const c_void, output_image_plane_size: *const core::Size, registered_depth: *const c_void, depth_dilation: bool) -> Result_void;
		pub fn cv_rgbd_rescaleDepth_const__InputArrayR_int_const__OutputArrayR_double(in_: *const c_void, depth: i32, out: *const c_void, depth_factor: f64) -> Result_void;
		pub fn cv_rgbd_warpFrame_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(image: *const c_void, depth: *const c_void, mask: *const c_void, rt: *const c_void, camera_matrix: *const c_void, dist_coeff: *const c_void, warped_image: *const c_void, warped_depth: *const c_void, warped_mask: *const c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_create_const_Ptr_Params_R(_params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_ColoredKinFu_getParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_ColoredKinFu_render_const_const__OutputArrayR(instance: *const c_void, image: *const c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_render_const_const__OutputArrayR_const_Matx44fR(instance: *const c_void, image: *const c_void, camera_pose: *const core::Matx44f) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_getPoints_const_const__OutputArrayR(instance: *const c_void, points: *const c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_getNormals_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_colored_kinfu_ColoredKinFu_getPose_const(instance: *const c_void) -> Result<core::Affine3f>;
		pub fn cv_colored_kinfu_ColoredKinFu_update_const__InputArrayR_const__InputArrayR(instance: *mut c_void, depth: *const c_void, rgb: *const c_void) -> Result<bool>;
		pub fn cv_colored_kinfu_Params_getPropFrameSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_colored_kinfu_Params_setPropFrameSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_colored_kinfu_Params_getPropRgb_frameSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_colored_kinfu_Params_setPropRgb_frameSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_colored_kinfu_Params_getPropVolumeType_const(instance: *const c_void) -> crate::rgbd::Kinfu_VolumeType;
		pub fn cv_colored_kinfu_Params_setPropVolumeType_VolumeType(instance: *mut c_void, val: crate::rgbd::Kinfu_VolumeType);
		pub fn cv_colored_kinfu_Params_getPropIntr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_colored_kinfu_Params_setPropIntr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_colored_kinfu_Params_getPropRgb_intr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_colored_kinfu_Params_setPropRgb_intr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_colored_kinfu_Params_getPropDepthFactor_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropDepthFactor_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropBilateral_sigma_depth_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropBilateral_sigma_depth_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropBilateral_sigma_spatial_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropBilateral_sigma_spatial_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropBilateral_kernel_size_const(instance: *const c_void) -> i32;
		pub fn cv_colored_kinfu_Params_setPropBilateral_kernel_size_int(instance: *mut c_void, val: i32);
		pub fn cv_colored_kinfu_Params_getPropPyramidLevels_const(instance: *const c_void) -> i32;
		pub fn cv_colored_kinfu_Params_setPropPyramidLevels_int(instance: *mut c_void, val: i32);
		pub fn cv_colored_kinfu_Params_getPropVolumeDims_const(instance: *const c_void) -> core::Vec3i;
		pub fn cv_colored_kinfu_Params_setPropVolumeDims_Vec3i(instance: *mut c_void, val: *const core::Vec3i);
		pub fn cv_colored_kinfu_Params_getPropVoxelSize_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropVoxelSize_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropTsdf_min_camera_movement_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropTsdf_min_camera_movement_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropVolumePose_const(instance: *const c_void) -> core::Affine3f;
		pub fn cv_colored_kinfu_Params_setPropVolumePose_Affine3f(instance: *mut c_void, val: *const core::Affine3f);
		pub fn cv_colored_kinfu_Params_getPropTsdf_trunc_dist_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropTsdf_trunc_dist_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropTsdf_max_weight_const(instance: *const c_void) -> i32;
		pub fn cv_colored_kinfu_Params_setPropTsdf_max_weight_int(instance: *mut c_void, val: i32);
		pub fn cv_colored_kinfu_Params_getPropRaycast_step_factor_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropRaycast_step_factor_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropLightPose_const(instance: *const c_void) -> core::Vec3f;
		pub fn cv_colored_kinfu_Params_setPropLightPose_Vec3f(instance: *mut c_void, val: *const core::Vec3f);
		pub fn cv_colored_kinfu_Params_getPropIcpDistThresh_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropIcpDistThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropIcpAngleThresh_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropIcpAngleThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_getPropIcpIterations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_colored_kinfu_Params_setPropIcpIterations_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_colored_kinfu_Params_getPropTruncateThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_colored_kinfu_Params_setPropTruncateThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_colored_kinfu_Params_Params() -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_Params_Matx33f_Vec3f(volume_initial_pose_rot: *const core::Matx33f, volume_initial_pose_transl: *const core::Vec3f) -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_Params_Matx44f(volume_initial_pose: *const core::Matx44f) -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_setInitialVolumePose_Matx33f_Vec3f(instance: *mut c_void, r: *const core::Matx33f, t: *const core::Vec3f) -> Result_void;
		pub fn cv_colored_kinfu_Params_setInitialVolumePose_Matx44f(instance: *mut c_void, homogen_tf: *const core::Matx44f) -> Result_void;
		pub fn cv_colored_kinfu_Params_defaultParams() -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_coarseParams() -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_hashTSDFParams_bool(is_coarse: bool) -> Result<*mut c_void>;
		pub fn cv_colored_kinfu_Params_coloredTSDFParams_bool(is_coarse: bool) -> Result<*mut c_void>;
		pub fn cv_dynafu_DynaFu_create_const_Ptr_Params_R(_params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dynafu_DynaFu_getParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dynafu_DynaFu_render_const_const__OutputArrayR_const_Matx44fR(instance: *const c_void, image: *const c_void, camera_pose: *const core::Matx44f) -> Result_void;
		pub fn cv_dynafu_DynaFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_dynafu_DynaFu_getPoints_const_const__OutputArrayR(instance: *const c_void, points: *const c_void) -> Result_void;
		pub fn cv_dynafu_DynaFu_getNormals_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_dynafu_DynaFu_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_dynafu_DynaFu_getPose_const(instance: *const c_void) -> Result<core::Affine3f>;
		pub fn cv_dynafu_DynaFu_update_const__InputArrayR(instance: *mut c_void, depth: *const c_void) -> Result<bool>;
		pub fn cv_dynafu_DynaFu_getNodesPos_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_dynafu_DynaFu_marchCubes_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, vertices: *const c_void, edges: *const c_void) -> Result_void;
		pub fn cv_dynafu_DynaFu_renderSurface_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_bool(instance: *mut c_void, depth_image: *const c_void, vert_image: *const c_void, norm_image: *const c_void, warp: bool) -> Result_void;
		pub fn cv_kinfu_Intr_Intr() -> Result<crate::rgbd::Kinfu_Intr>;
		pub fn cv_kinfu_Intr_Intr_float_float_float_float(_fx: f32, _fy: f32, _cx: f32, _cy: f32) -> Result<crate::rgbd::Kinfu_Intr>;
		pub fn cv_kinfu_Intr_Intr_Matx33f(m: *const core::Matx33f) -> Result<crate::rgbd::Kinfu_Intr>;
		pub fn cv_kinfu_Intr_scale_const_int(instance: *const crate::rgbd::Kinfu_Intr, pyr: i32) -> Result<crate::rgbd::Kinfu_Intr>;
		pub fn cv_kinfu_Intr_makeReprojector_const(instance: *const crate::rgbd::Kinfu_Intr) -> Result<crate::rgbd::Kinfu_Intr_Reprojector>;
		pub fn cv_kinfu_Intr_makeProjector_const(instance: *const crate::rgbd::Kinfu_Intr) -> Result<crate::rgbd::Kinfu_Intr_Projector>;
		pub fn cv_kinfu_Intr_getMat_const(instance: *const crate::rgbd::Kinfu_Intr) -> Result<core::Matx33f>;
		pub fn cv_kinfu_Intr_Projector_Projector_Intr(intr: *const crate::rgbd::Kinfu_Intr) -> Result<crate::rgbd::Kinfu_Intr_Projector>;
		pub fn cv_kinfu_Intr_Reprojector_Reprojector() -> Result<crate::rgbd::Kinfu_Intr_Reprojector>;
		pub fn cv_kinfu_Intr_Reprojector_Reprojector_Intr(intr: *const crate::rgbd::Kinfu_Intr) -> Result<crate::rgbd::Kinfu_Intr_Reprojector>;
		pub fn cv_kinfu_KinFu_create_const_Ptr_Params_R(_params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_kinfu_KinFu_getParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_kinfu_KinFu_render_const_const__OutputArrayR(instance: *const c_void, image: *const c_void) -> Result_void;
		pub fn cv_kinfu_KinFu_render_const_const__OutputArrayR_const_Matx44fR(instance: *const c_void, image: *const c_void, camera_pose: *const core::Matx44f) -> Result_void;
		pub fn cv_kinfu_KinFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_kinfu_KinFu_getPoints_const_const__OutputArrayR(instance: *const c_void, points: *const c_void) -> Result_void;
		pub fn cv_kinfu_KinFu_getNormals_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_kinfu_KinFu_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_kinfu_KinFu_getPose_const(instance: *const c_void) -> Result<core::Affine3f>;
		pub fn cv_kinfu_KinFu_update_const__InputArrayR(instance: *mut c_void, depth: *const c_void) -> Result<bool>;
		pub fn cv_kinfu_Params_getPropFrameSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_kinfu_Params_setPropFrameSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_kinfu_Params_getPropVolumeType_const(instance: *const c_void) -> crate::rgbd::Kinfu_VolumeType;
		pub fn cv_kinfu_Params_setPropVolumeType_VolumeType(instance: *mut c_void, val: crate::rgbd::Kinfu_VolumeType);
		pub fn cv_kinfu_Params_getPropIntr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_kinfu_Params_setPropIntr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_kinfu_Params_getPropRgb_intr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_kinfu_Params_setPropRgb_intr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_kinfu_Params_getPropDepthFactor_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropDepthFactor_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropBilateral_sigma_depth_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropBilateral_sigma_depth_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropBilateral_sigma_spatial_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropBilateral_sigma_spatial_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropBilateral_kernel_size_const(instance: *const c_void) -> i32;
		pub fn cv_kinfu_Params_setPropBilateral_kernel_size_int(instance: *mut c_void, val: i32);
		pub fn cv_kinfu_Params_getPropPyramidLevels_const(instance: *const c_void) -> i32;
		pub fn cv_kinfu_Params_setPropPyramidLevels_int(instance: *mut c_void, val: i32);
		pub fn cv_kinfu_Params_getPropVolumeDims_const(instance: *const c_void) -> core::Vec3i;
		pub fn cv_kinfu_Params_setPropVolumeDims_Vec3i(instance: *mut c_void, val: *const core::Vec3i);
		pub fn cv_kinfu_Params_getPropVoxelSize_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropVoxelSize_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropTsdf_min_camera_movement_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropTsdf_min_camera_movement_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropVolumePose_const(instance: *const c_void) -> core::Affine3f;
		pub fn cv_kinfu_Params_setPropVolumePose_Affine3f(instance: *mut c_void, val: *const core::Affine3f);
		pub fn cv_kinfu_Params_getPropTsdf_trunc_dist_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropTsdf_trunc_dist_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropTsdf_max_weight_const(instance: *const c_void) -> i32;
		pub fn cv_kinfu_Params_setPropTsdf_max_weight_int(instance: *mut c_void, val: i32);
		pub fn cv_kinfu_Params_getPropRaycast_step_factor_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropRaycast_step_factor_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropLightPose_const(instance: *const c_void) -> core::Vec3f;
		pub fn cv_kinfu_Params_setPropLightPose_Vec3f(instance: *mut c_void, val: *const core::Vec3f);
		pub fn cv_kinfu_Params_getPropIcpDistThresh_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropIcpDistThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropIcpAngleThresh_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropIcpAngleThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_getPropIcpIterations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_kinfu_Params_setPropIcpIterations_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_kinfu_Params_getPropTruncateThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Params_setPropTruncateThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_Params_Params() -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_Params_Matx33f_Vec3f(volume_initial_pose_rot: *const core::Matx33f, volume_initial_pose_transl: *const core::Vec3f) -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_Params_Matx44f(volume_initial_pose: *const core::Matx44f) -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_setInitialVolumePose_Matx33f_Vec3f(instance: *mut c_void, r: *const core::Matx33f, t: *const core::Vec3f) -> Result_void;
		pub fn cv_kinfu_Params_setInitialVolumePose_Matx44f(instance: *mut c_void, homogen_tf: *const core::Matx44f) -> Result_void;
		pub fn cv_kinfu_Params_defaultParams() -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_coarseParams() -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_hashTSDFParams_bool(is_coarse: bool) -> Result<*mut c_void>;
		pub fn cv_kinfu_Params_coloredTSDFParams_bool(is_coarse: bool) -> Result<*mut c_void>;
		pub fn cv_kinfu_Volume_getPropVoxelSize_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Volume_getPropVoxelSizeInv_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Volume_getPropPose_const(instance: *const c_void) -> core::Affine3f;
		pub fn cv_kinfu_Volume_getPropRaycastStepFactor_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_Volume_integrate_const__InputArrayR_float_const_Matx44fR_const_IntrR_const_int(instance: *mut c_void, _depth: *const c_void, depth_factor: f32, camera_pose: *const core::Matx44f, intrinsics: *const crate::rgbd::Kinfu_Intr, frame_id: i32) -> Result_void;
		pub fn cv_kinfu_Volume_integrate_const__InputArrayR_const__InputArrayR_float_const_Matx44fR_const_IntrR_const_IntrR_const_int(instance: *mut c_void, _depth: *const c_void, _rgb: *const c_void, depth_factor: f32, camera_pose: *const core::Matx44f, intrinsics: *const crate::rgbd::Kinfu_Intr, rgb_intrinsics: *const crate::rgbd::Kinfu_Intr, frame_id: i32) -> Result_void;
		pub fn cv_kinfu_Volume_raycast_const_const_Matx44fR_const_IntrR_const_SizeR_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, camera_pose: *const core::Matx44f, intrinsics: *const crate::rgbd::Kinfu_Intr, frame_size: *const core::Size, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_kinfu_Volume_raycast_const_const_Matx44fR_const_IntrR_const_SizeR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, camera_pose: *const core::Matx44f, intrinsics: *const crate::rgbd::Kinfu_Intr, frame_size: *const core::Size, points: *const c_void, normals: *const c_void, colors: *const c_void) -> Result_void;
		pub fn cv_kinfu_Volume_fetchNormals_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, _normals: *const c_void) -> Result_void;
		pub fn cv_kinfu_Volume_fetchPointsNormals_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_kinfu_Volume_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_kinfu_VolumeParams_getPropType_const(instance: *const c_void) -> crate::rgbd::Kinfu_VolumeType;
		pub fn cv_kinfu_VolumeParams_setPropType_VolumeType(instance: *mut c_void, val: crate::rgbd::Kinfu_VolumeType);
		pub fn cv_kinfu_VolumeParams_getPropResolution_const(instance: *const c_void) -> core::Vec3i;
		pub fn cv_kinfu_VolumeParams_setPropResolution_Vec3i(instance: *mut c_void, val: *const core::Vec3i);
		pub fn cv_kinfu_VolumeParams_getPropUnitResolution_const(instance: *const c_void) -> i32;
		pub fn cv_kinfu_VolumeParams_setPropUnitResolution_int(instance: *mut c_void, val: i32);
		pub fn cv_kinfu_VolumeParams_getPropPose_const(instance: *const c_void) -> core::Affine3f;
		pub fn cv_kinfu_VolumeParams_setPropPose_Affine3f(instance: *mut c_void, val: *const core::Affine3f);
		pub fn cv_kinfu_VolumeParams_getPropVoxelSize_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_VolumeParams_setPropVoxelSize_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_VolumeParams_getPropTsdfTruncDist_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_VolumeParams_setPropTsdfTruncDist_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_VolumeParams_getPropMaxWeight_const(instance: *const c_void) -> i32;
		pub fn cv_kinfu_VolumeParams_setPropMaxWeight_int(instance: *mut c_void, val: i32);
		pub fn cv_kinfu_VolumeParams_getPropDepthTruncThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_VolumeParams_setPropDepthTruncThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_VolumeParams_getPropRaycastStepFactor_const(instance: *const c_void) -> f32;
		pub fn cv_kinfu_VolumeParams_setPropRaycastStepFactor_float(instance: *mut c_void, val: f32);
		pub fn cv_kinfu_VolumeParams_defaultParams_VolumeType(_volume_type: crate::rgbd::Kinfu_VolumeType) -> Result<*mut c_void>;
		pub fn cv_kinfu_VolumeParams_coarseParams_VolumeType(_volume_type: crate::rgbd::Kinfu_VolumeType) -> Result<*mut c_void>;
		pub fn cv_kinfu_detail_PoseGraph_create() -> Result<*mut c_void>;
		pub fn cv_kinfu_detail_PoseGraph_addNode_size_t_const_Affine3dR_bool(instance: *mut c_void, _node_id: size_t, _pose: *const core::Affine3d, fixed: bool) -> Result_void;
		pub fn cv_kinfu_detail_PoseGraph_isNodeExist_const_size_t(instance: *const c_void, node_id: size_t) -> Result<bool>;
		pub fn cv_kinfu_detail_PoseGraph_setNodeFixed_size_t_bool(instance: *mut c_void, node_id: size_t, fixed: bool) -> Result<bool>;
		pub fn cv_kinfu_detail_PoseGraph_isNodeFixed_const_size_t(instance: *const c_void, node_id: size_t) -> Result<bool>;
		pub fn cv_kinfu_detail_PoseGraph_getNodePose_const_size_t(instance: *const c_void, node_id: size_t) -> Result<core::Affine3d>;
		pub fn cv_kinfu_detail_PoseGraph_getNodesIds_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_kinfu_detail_PoseGraph_getNumNodes_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_kinfu_detail_PoseGraph_addEdge_size_t_size_t_const_Affine3fR_const_Matx66fR(instance: *mut c_void, _source_node_id: size_t, _target_node_id: size_t, _transformation: *const core::Affine3f, _information: *const core::Matx66f) -> Result_void;
		pub fn cv_kinfu_detail_PoseGraph_getEdgeStart_const_size_t(instance: *const c_void, i: size_t) -> Result<size_t>;
		pub fn cv_kinfu_detail_PoseGraph_getEdgeEnd_const_size_t(instance: *const c_void, i: size_t) -> Result<size_t>;
		pub fn cv_kinfu_detail_PoseGraph_getNumEdges_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_kinfu_detail_PoseGraph_isValid_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_kinfu_detail_PoseGraph_optimize_const_TermCriteriaR(instance: *mut c_void, tc: *const core::TermCriteria) -> Result<i32>;
		pub fn cv_kinfu_detail_PoseGraph_calcEnergy_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_large_kinfu_LargeKinfu_create_const_Ptr_Params_R(_params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_large_kinfu_LargeKinfu_getParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_large_kinfu_LargeKinfu_render_const_const__OutputArrayR(instance: *const c_void, image: *const c_void) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_render_const_const__OutputArrayR_const_Matx44fR(instance: *const c_void, image: *const c_void, camera_pose: *const core::Matx44f) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_getCloud_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_getPoints_const_const__OutputArrayR(instance: *const c_void, points: *const c_void) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_getNormals_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, points: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_large_kinfu_LargeKinfu_getPose_const(instance: *const c_void) -> Result<core::Affine3f>;
		pub fn cv_large_kinfu_LargeKinfu_update_const__InputArrayR(instance: *mut c_void, depth: *const c_void) -> Result<bool>;
		pub fn cv_large_kinfu_Params_getPropFrameSize_const(instance: *const c_void) -> core::Size;
		pub fn cv_large_kinfu_Params_setPropFrameSize_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_large_kinfu_Params_getPropIntr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_large_kinfu_Params_setPropIntr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_large_kinfu_Params_getPropRgb_intr_const(instance: *const c_void) -> core::Matx33f;
		pub fn cv_large_kinfu_Params_setPropRgb_intr_Matx33f(instance: *mut c_void, val: *const core::Matx33f);
		pub fn cv_large_kinfu_Params_getPropDepthFactor_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropDepthFactor_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropBilateral_sigma_depth_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropBilateral_sigma_depth_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropBilateral_sigma_spatial_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropBilateral_sigma_spatial_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropBilateral_kernel_size_const(instance: *const c_void) -> i32;
		pub fn cv_large_kinfu_Params_setPropBilateral_kernel_size_int(instance: *mut c_void, val: i32);
		pub fn cv_large_kinfu_Params_getPropPyramidLevels_const(instance: *const c_void) -> i32;
		pub fn cv_large_kinfu_Params_setPropPyramidLevels_int(instance: *mut c_void, val: i32);
		pub fn cv_large_kinfu_Params_getPropTsdf_min_camera_movement_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropTsdf_min_camera_movement_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropLightPose_const(instance: *const c_void) -> core::Vec3f;
		pub fn cv_large_kinfu_Params_setPropLightPose_Vec3f(instance: *mut c_void, val: *const core::Vec3f);
		pub fn cv_large_kinfu_Params_getPropIcpDistThresh_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropIcpDistThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropIcpAngleThresh_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropIcpAngleThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropIcpIterations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_large_kinfu_Params_setPropIcpIterations_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_large_kinfu_Params_getPropTruncateThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_large_kinfu_Params_setPropTruncateThreshold_float(instance: *mut c_void, val: f32);
		pub fn cv_large_kinfu_Params_getPropVolumeParams_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_large_kinfu_Params_setPropVolumeParams_VolumeParams(instance: *mut c_void, val: *mut c_void);
		pub fn cv_large_kinfu_Params_defaultParams() -> Result<*mut c_void>;
		pub fn cv_large_kinfu_Params_coarseParams() -> Result<*mut c_void>;
		pub fn cv_large_kinfu_Params_hashTSDFParams_bool(is_coarse: bool) -> Result<*mut c_void>;
		pub fn cv_linemod_ColorGradient_getPropWeak_threshold_const(instance: *const c_void) -> f32;
		pub fn cv_linemod_ColorGradient_setPropWeak_threshold_float(instance: *mut c_void, val: f32);
		pub fn cv_linemod_ColorGradient_getPropNum_features_const(instance: *const c_void) -> size_t;
		pub fn cv_linemod_ColorGradient_setPropNum_features_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_linemod_ColorGradient_getPropStrong_threshold_const(instance: *const c_void) -> f32;
		pub fn cv_linemod_ColorGradient_setPropStrong_threshold_float(instance: *mut c_void, val: f32);
		pub fn cv_linemod_ColorGradient_ColorGradient() -> Result<*mut c_void>;
		pub fn cv_linemod_ColorGradient_ColorGradient_float_size_t_float(weak_threshold: f32, num_features: size_t, strong_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_linemod_ColorGradient_create_float_size_t_float(weak_threshold: f32, num_features: size_t, strong_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_linemod_ColorGradient_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_ColorGradient_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_ColorGradient_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_DepthNormal_getPropDistance_threshold_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_DepthNormal_setPropDistance_threshold_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_DepthNormal_getPropDifference_threshold_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_DepthNormal_setPropDifference_threshold_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_DepthNormal_getPropNum_features_const(instance: *const c_void) -> size_t;
		pub fn cv_linemod_DepthNormal_setPropNum_features_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_linemod_DepthNormal_getPropExtract_threshold_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_DepthNormal_setPropExtract_threshold_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_DepthNormal_DepthNormal() -> Result<*mut c_void>;
		pub fn cv_linemod_DepthNormal_DepthNormal_int_int_size_t_int(distance_threshold: i32, difference_threshold: i32, num_features: size_t, extract_threshold: i32) -> Result<*mut c_void>;
		pub fn cv_linemod_DepthNormal_create_int_int_size_t_int(distance_threshold: i32, difference_threshold: i32, num_features: size_t, extract_threshold: i32) -> Result<*mut c_void>;
		pub fn cv_linemod_DepthNormal_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_DepthNormal_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_DepthNormal_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_Detector_Detector() -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_Detector_const_vector_Ptr_Modality__R_const_vector_int_R(modalities: *const c_void, t_pyramid: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_match_const_const_vector_Mat_R_float_vector_Match_R_const_vector_String_R_const__OutputArrayR_const_vector_Mat_R(instance: *const c_void, sources: *const c_void, threshold: f32, matches: *mut c_void, class_ids: *const c_void, quantized_images: *const c_void, masks: *const c_void) -> Result_void;
		pub fn cv_linemod_Detector_addTemplate_const_vector_Mat_R_const_StringR_const_MatR_RectX(instance: *mut c_void, sources: *const c_void, class_id: *const c_char, object_mask: *const c_void, bounding_box: *mut core::Rect) -> Result<i32>;
		pub fn cv_linemod_Detector_addSyntheticTemplate_const_vector_Template_R_const_StringR(instance: *mut c_void, templates: *const c_void, class_id: *const c_char) -> Result<i32>;
		pub fn cv_linemod_Detector_getModalities_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_getT_const_int(instance: *const c_void, pyramid_level: i32) -> Result<i32>;
		pub fn cv_linemod_Detector_pyramidLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_linemod_Detector_getTemplates_const_const_StringR_int(instance: *const c_void, class_id: *const c_char, template_id: i32) -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_numTemplates_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_linemod_Detector_numTemplates_const_const_StringR(instance: *const c_void, class_id: *const c_char) -> Result<i32>;
		pub fn cv_linemod_Detector_numClasses_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_linemod_Detector_classIds_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_Detector_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_Detector_readClass_const_FileNodeR_const_StringR(instance: *mut c_void, fn_: *const c_void, class_id_override: *const c_char) -> Result<*mut c_void>;
		pub fn cv_linemod_Detector_writeClass_const_const_StringR_FileStorageR(instance: *const c_void, class_id: *const c_char, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_Detector_readClasses_const_vector_String_R_const_StringR(instance: *mut c_void, class_ids: *const c_void, format: *const c_char) -> Result_void;
		pub fn cv_linemod_Detector_writeClasses_const_const_StringR(instance: *const c_void, format: *const c_char) -> Result_void;
		pub fn cv_linemod_Feature_Feature() -> Result<crate::rgbd::Linemod_Feature>;
		pub fn cv_linemod_Feature_Feature_int_int_int(x: i32, y: i32, label: i32) -> Result<crate::rgbd::Linemod_Feature>;
		pub fn cv_linemod_Feature_read_const_FileNodeR(instance: *const crate::rgbd::Linemod_Feature, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_Feature_write_const_FileStorageR(instance: *const crate::rgbd::Linemod_Feature, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_Match_getPropX_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Match_setPropX_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Match_getPropY_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Match_setPropY_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Match_getPropSimilarity_const(instance: *const c_void) -> f32;
		pub fn cv_linemod_Match_setPropSimilarity_float(instance: *mut c_void, val: f32);
		pub fn cv_linemod_Match_getPropClass_id_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_linemod_Match_setPropClass_id_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_linemod_Match_getPropTemplate_id_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Match_setPropTemplate_id_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Match_Match() -> Result<*mut c_void>;
		pub fn cv_linemod_Match_Match_int_int_float_const_StringR_int(x: i32, y: i32, similarity: f32, class_id: *const c_char, template_id: i32) -> Result<*mut c_void>;
		pub fn cv_linemod_Match_operatorEQ_const_const_MatchR(instance: *const c_void, rhs: *const c_void) -> Result<bool>;
		pub fn cv_linemod_Modality_process_const_const_MatR_const_MatR(instance: *const c_void, src: *const c_void, mask: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_Modality_name_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_Modality_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_Modality_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_linemod_Modality_create_const_StringR(modality_type: *const c_char) -> Result<*mut c_void>;
		pub fn cv_linemod_Modality_create_const_FileNodeR(fn_: *const c_void) -> Result<*mut c_void>;
		pub fn cv_linemod_QuantizedPyramid_quantize_const_MatR(instance: *const c_void, dst: *mut c_void) -> Result_void;
		pub fn cv_linemod_QuantizedPyramid_extractTemplate_const_TemplateR(instance: *const c_void, templ: *mut c_void) -> Result<bool>;
		pub fn cv_linemod_QuantizedPyramid_pyrDown(instance: *mut c_void) -> Result_void;
		pub fn cv_linemod_Template_getPropWidth_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Template_setPropWidth_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Template_getPropHeight_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Template_setPropHeight_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Template_getPropPyramid_level_const(instance: *const c_void) -> i32;
		pub fn cv_linemod_Template_setPropPyramid_level_int(instance: *mut c_void, val: i32);
		pub fn cv_linemod_Template_getPropFeatures_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_linemod_Template_setPropFeatures_vector_Feature_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_linemod_Template_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_linemod_Template_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_rgbd_DepthCleaner_DepthCleaner() -> Result<*mut c_void>;
		pub fn cv_rgbd_DepthCleaner_DepthCleaner_int_int_int(depth: i32, window_size: i32, method: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_DepthCleaner_create_int_int_int(depth: i32, window_size: i32, method: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_DepthCleaner_initialize_const(instance: *const c_void) -> Result_void;
		pub fn cv_rgbd_DepthCleaner_getWindowSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_DepthCleaner_setWindowSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_DepthCleaner_getDepth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_DepthCleaner_setDepth_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_DepthCleaner_getMethod_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_DepthCleaner_setMethod_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_FastICPOdometry() -> Result<*mut c_void>;
		pub fn cv_rgbd_FastICPOdometry_FastICPOdometry_const_MatR_float_float_float_float_int_const_vector_int_R(camera_matrix: *const c_void, max_dist_diff: f32, angle_threshold: f32, sigma_depth: f32, sigma_spatial: f32, kernel_size: i32, iter_counts: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_FastICPOdometry_create_const_MatR_float_float_float_float_int_const_vector_int_R(camera_matrix: *const c_void, max_dist_diff: f32, angle_threshold: f32, sigma_depth: f32, sigma_spatial: f32, kernel_size: i32, iter_counts: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_FastICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(instance: *const c_void, frame: *mut c_void, cache_type: i32) -> Result<core::Size>;
		pub fn cv_rgbd_FastICPOdometry_getCameraMatrix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_FastICPOdometry_setCameraMatrix_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getMaxDistDiff_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_FastICPOdometry_setMaxDistDiff_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getAngleThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_rgbd_FastICPOdometry_setAngleThreshold_float(instance: *mut c_void, f: f32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getSigmaDepth_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_rgbd_FastICPOdometry_setSigmaDepth_float(instance: *mut c_void, f: f32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getSigmaSpatial_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_rgbd_FastICPOdometry_setSigmaSpatial_float(instance: *mut c_void, f: f32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getKernelSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_FastICPOdometry_setKernelSize_int(instance: *mut c_void, f: i32) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getIterationCounts_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_FastICPOdometry_setIterationCounts_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_FastICPOdometry_getTransformType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_FastICPOdometry_setTransformType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_ICPOdometry() -> Result<*mut c_void>;
		pub fn cv_rgbd_ICPOdometry_ICPOdometry_const_MatR_float_float_float_float_const_vector_int_R_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, max_points_part: f32, iter_counts: *const c_void, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_ICPOdometry_create_const_MatR_float_float_float_float_const_vector_int_R_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, max_points_part: f32, iter_counts: *const c_void, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_ICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(instance: *const c_void, frame: *mut c_void, cache_type: i32) -> Result<core::Size>;
		pub fn cv_rgbd_ICPOdometry_getCameraMatrix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_ICPOdometry_setCameraMatrix_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMinDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMinDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMaxDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMaxDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMaxDepthDiff_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMaxDepthDiff_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getIterationCounts_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_ICPOdometry_setIterationCounts_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMaxPointsPart_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMaxPointsPart_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getTransformType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_ICPOdometry_setTransformType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMaxTranslation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMaxTranslation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getMaxRotation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_ICPOdometry_setMaxRotation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_ICPOdometry_getNormalsComputer_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_Odometry_DEFAULT_MIN_DEPTH() -> Result<f32>;
		pub fn cv_rgbd_Odometry_DEFAULT_MAX_DEPTH() -> Result<f32>;
		pub fn cv_rgbd_Odometry_DEFAULT_MAX_DEPTH_DIFF() -> Result<f32>;
		pub fn cv_rgbd_Odometry_DEFAULT_MAX_POINTS_PART() -> Result<f32>;
		pub fn cv_rgbd_Odometry_DEFAULT_MAX_TRANSLATION() -> Result<f32>;
		pub fn cv_rgbd_Odometry_DEFAULT_MAX_ROTATION() -> Result<f32>;
		pub fn cv_rgbd_Odometry_compute_const_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const__OutputArrayR_const_MatR(instance: *const c_void, src_image: *const c_void, src_depth: *const c_void, src_mask: *const c_void, dst_image: *const c_void, dst_depth: *const c_void, dst_mask: *const c_void, rt: *const c_void, init_rt: *const c_void) -> Result<bool>;
		pub fn cv_rgbd_Odometry_compute_const_Ptr_OdometryFrame_R_Ptr_OdometryFrame_R_const__OutputArrayR_const_MatR(instance: *const c_void, src_frame: *mut c_void, dst_frame: *mut c_void, rt: *const c_void, init_rt: *const c_void) -> Result<bool>;
		pub fn cv_rgbd_Odometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(instance: *const c_void, frame: *mut c_void, cache_type: i32) -> Result<core::Size>;
		pub fn cv_rgbd_Odometry_create_const_StringR(odometry_type: *const c_char) -> Result<*mut c_void>;
		pub fn cv_rgbd_Odometry_getCameraMatrix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_Odometry_setCameraMatrix_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_Odometry_getTransformType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_Odometry_setTransformType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_OdometryFrame_getPropPyramidImage_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidImage_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidDepth_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidDepth_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidMask_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidMask_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidCloud_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidCloud_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramid_dI_dx_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramid_dI_dx_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramid_dI_dy_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramid_dI_dy_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidTexturedMask_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidTexturedMask_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidNormals_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidNormals_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_getPropPyramidNormalsMask_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_OdometryFrame_setPropPyramidNormalsMask_vector_Mat_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_OdometryFrame_OdometryFrame() -> Result<*mut c_void>;
		pub fn cv_rgbd_OdometryFrame_OdometryFrame_const_MatR_const_MatR_const_MatR_const_MatR_int(image: *const c_void, depth: *const c_void, mask: *const c_void, normals: *const c_void, id: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_OdometryFrame_create_const_MatR_const_MatR_const_MatR_const_MatR_int(image: *const c_void, depth: *const c_void, mask: *const c_void, normals: *const c_void, id: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_OdometryFrame_release(instance: *mut c_void) -> Result_void;
		pub fn cv_rgbd_OdometryFrame_releasePyramids(instance: *mut c_void) -> Result_void;
		pub fn cv_rgbd_RgbdFrame_getPropID_const(instance: *const c_void) -> i32;
		pub fn cv_rgbd_RgbdFrame_setPropID_int(instance: *mut c_void, val: i32);
		pub fn cv_rgbd_RgbdFrame_getPropImage_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_RgbdFrame_setPropImage_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_RgbdFrame_getPropDepth_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_RgbdFrame_setPropDepth_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_RgbdFrame_getPropMask_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_RgbdFrame_setPropMask_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_RgbdFrame_getPropNormals_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_rgbd_RgbdFrame_setPropNormals_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_rgbd_RgbdFrame_RgbdFrame() -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdFrame_RgbdFrame_const_MatR_const_MatR_const_MatR_const_MatR_int(image: *const c_void, depth: *const c_void, mask: *const c_void, normals: *const c_void, id: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdFrame_create_const_MatR_const_MatR_const_MatR_const_MatR_int(image: *const c_void, depth: *const c_void, mask: *const c_void, normals: *const c_void, id: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdFrame_release(instance: *mut c_void) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_RgbdICPOdometry() -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_RgbdICPOdometry_const_MatR_float_float_float_float_const_vector_int_R_const_vector_float_R_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, max_points_part: f32, iter_counts: *const c_void, min_gradient_magnitudes: *const c_void, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_create_const_MatR_float_float_float_float_const_vector_int_R_const_vector_float_R_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, max_points_part: f32, iter_counts: *const c_void, min_gradient_magnitudes: *const c_void, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(instance: *const c_void, frame: *mut c_void, cache_type: i32) -> Result<core::Size>;
		pub fn cv_rgbd_RgbdICPOdometry_getCameraMatrix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_setCameraMatrix_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMinDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMinDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMaxDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMaxDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMaxDepthDiff_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMaxDepthDiff_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMaxPointsPart_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMaxPointsPart_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getIterationCounts_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_setIterationCounts_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMinGradientMagnitudes_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdICPOdometry_setMinGradientMagnitudes_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getTransformType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdICPOdometry_setTransformType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMaxTranslation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMaxTranslation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getMaxRotation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdICPOdometry_setMaxRotation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdICPOdometry_getNormalsComputer_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdNormals_RgbdNormals() -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdNormals_RgbdNormals_int_int_int_const__InputArrayR_int_int(rows: i32, cols: i32, depth: i32, k: *const c_void, window_size: i32, method: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdNormals_create_int_int_int_const__InputArrayR_int_int(rows: i32, cols: i32, depth: i32, k: *const c_void, window_size: i32, method: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdNormals_initialize_const(instance: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getRows_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdNormals_setRows_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getCols_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdNormals_setCols_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getWindowSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdNormals_setWindowSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getDepth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdNormals_setDepth_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getK_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdNormals_setK_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdNormals_getMethod_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdNormals_setMethod_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_RgbdOdometry() -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_RgbdOdometry_const_MatR_float_float_float_const_vector_int_R_const_vector_float_R_float_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, iter_counts: *const c_void, min_gradient_magnitudes: *const c_void, max_points_part: f32, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_create_const_MatR_float_float_float_const_vector_int_R_const_vector_float_R_float_int(camera_matrix: *const c_void, min_depth: f32, max_depth: f32, max_depth_diff: f32, iter_counts: *const c_void, min_gradient_magnitudes: *const c_void, max_points_part: f32, transform_type: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(instance: *const c_void, frame: *mut c_void, cache_type: i32) -> Result<core::Size>;
		pub fn cv_rgbd_RgbdOdometry_getCameraMatrix_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_setCameraMatrix_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMinDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMinDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMaxDepth_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMaxDepth_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMaxDepthDiff_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMaxDepthDiff_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getIterationCounts_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_setIterationCounts_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMinGradientMagnitudes_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdOdometry_setMinGradientMagnitudes_const_MatR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMaxPointsPart_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMaxPointsPart_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getTransformType_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdOdometry_setTransformType_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMaxTranslation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMaxTranslation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdOdometry_getMaxRotation_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdOdometry_setMaxRotation_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_RgbdPlane_int(method: i32) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdPlane_RgbdPlane_int_int_int_double_double_double_double(method: i32, block_size: i32, min_size: i32, threshold: f64, sensor_error_a: f64, sensor_error_b: f64, sensor_error_c: f64) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdPlane_create_int_int_int_double_double_double_double(method: i32, block_size: i32, min_size: i32, threshold: f64, sensor_error_a: f64, sensor_error_b: f64, sensor_error_c: f64) -> Result<*mut c_void>;
		pub fn cv_rgbd_RgbdPlane_getBlockSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdPlane_setBlockSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getMinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdPlane_setMinSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getMethod_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_rgbd_RgbdPlane_setMethod_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdPlane_setThreshold_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getSensorErrorA_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdPlane_setSensorErrorA_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getSensorErrorB_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdPlane_setSensorErrorB_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_rgbd_RgbdPlane_getSensorErrorC_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_rgbd_RgbdPlane_setSensorErrorC_double(instance: *mut c_void, val: f64) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_rgbd)]
pub use rgbd_sys::*;

#[cfg(ocvrs_has_module_saliency)]
mod saliency_sys {
	use super::*;

	extern "C" {
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_MotionSaliencyBinWangApr2014() -> Result<*mut c_void>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_create() -> Result<*mut c_void>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_computeSaliency_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, saliency_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_setImagesize_int_int(instance: *mut c_void, w: i32, h: i32) -> Result_void;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_init(instance: *mut c_void) -> Result<bool>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_getImageWidth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_setImageWidth_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_getImageHeight_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_MotionSaliencyBinWangApr2014_setImageHeight_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_ObjectnessBING() -> Result<*mut c_void>;
		pub fn cv_saliency_ObjectnessBING_create() -> Result<*mut c_void>;
		pub fn cv_saliency_ObjectnessBING_computeSaliency_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, saliency_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_ObjectnessBING_read(instance: *mut c_void) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_write_const(instance: *const c_void) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_getobjectnessValues(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_saliency_ObjectnessBING_setTrainingPath_const_StringR(instance: *mut c_void, training_path: *const c_char) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_setBBResDir_const_StringR(instance: *mut c_void, results_dir: *const c_char) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_getBase_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_saliency_ObjectnessBING_setBase_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_getNSS_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_ObjectnessBING_setNSS_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_saliency_ObjectnessBING_getW_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_ObjectnessBING_setW_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_saliency_Saliency_computeSaliency_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, saliency_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_StaticSaliency_computeBinaryMap_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, _saliency_map: *const c_void, _binary_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_StaticSaliencyFineGrained_StaticSaliencyFineGrained() -> Result<*mut c_void>;
		pub fn cv_saliency_StaticSaliencyFineGrained_create() -> Result<*mut c_void>;
		pub fn cv_saliency_StaticSaliencyFineGrained_computeSaliency_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, saliency_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_StaticSaliencySpectralResidual() -> Result<*mut c_void>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_create() -> Result<*mut c_void>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_computeSaliency_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, saliency_map: *const c_void) -> Result<bool>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void) -> Result_void;
		pub fn cv_saliency_StaticSaliencySpectralResidual_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_saliency_StaticSaliencySpectralResidual_getImageWidth_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_setImageWidth_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_saliency_StaticSaliencySpectralResidual_getImageHeight_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_saliency_StaticSaliencySpectralResidual_setImageHeight_int(instance: *mut c_void, val: i32) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_saliency)]
pub use saliency_sys::*;

#[cfg(ocvrs_has_module_sfm)]
mod sfm_sys {
	use super::*;

	extern "C" {
		pub fn cv_sfm_KRtFromProjection_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(p: *const c_void, k: *const c_void, r: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_applyTransformationToPoints_const__InputArrayR_const__InputArrayR_const__OutputArrayR(points: *const c_void, t: *const c_void, transformed_points: *const c_void) -> Result_void;
		pub fn cv_sfm_computeOrientation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double(x1: *const c_void, x2: *const c_void, r: *const c_void, t: *const c_void, s: f64) -> Result_void;
		pub fn cv_sfm_depth_const__InputArrayR_const__InputArrayR_const__InputArrayR(r: *const c_void, t: *const c_void, x: *const c_void) -> Result<f64>;
		pub fn cv_sfm_essentialFromFundamental_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(f: *const c_void, k1: *const c_void, k2: *const c_void, e: *const c_void) -> Result_void;
		pub fn cv_sfm_essentialFromRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(r1: *const c_void, t1: *const c_void, r2: *const c_void, t2: *const c_void, e: *const c_void) -> Result_void;
		pub fn cv_sfm_euclideanToHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_sfm_fundamentalFromCorrespondences7PointRobust_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR_const__OutputArrayR_double(x1: *const c_void, x2: *const c_void, max_error: f64, f: *const c_void, inliers: *const c_void, outliers_probability: f64) -> Result<f64>;
		pub fn cv_sfm_fundamentalFromCorrespondences8PointRobust_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR_const__OutputArrayR_double(x1: *const c_void, x2: *const c_void, max_error: f64, f: *const c_void, inliers: *const c_void, outliers_probability: f64) -> Result<f64>;
		pub fn cv_sfm_fundamentalFromEssential_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(e: *const c_void, k1: *const c_void, k2: *const c_void, f: *const c_void) -> Result_void;
		pub fn cv_sfm_fundamentalFromProjections_const__InputArrayR_const__InputArrayR_const__OutputArrayR(p1: *const c_void, p2: *const c_void, f: *const c_void) -> Result_void;
		pub fn cv_sfm_homogeneousToEuclidean_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_sfm_importReconstruction_const_StringR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(file: *const c_char, rs: *const c_void, ts: *const c_void, ks: *const c_void, points3d: *const c_void, file_format: i32) -> Result_void;
		pub fn cv_sfm_isotropicPreconditionerFromPoints_const__InputArrayR_const__OutputArrayR(points: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_meanAndVarianceAlongRows_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(a: *const c_void, mean: *const c_void, variance: *const c_void) -> Result_void;
		pub fn cv_sfm_motionFromEssentialChooseSolution_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(rs: *const c_void, ts: *const c_void, k1: *const c_void, x1: *const c_void, k2: *const c_void, x2: *const c_void) -> Result<i32>;
		pub fn cv_sfm_motionFromEssential_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(e: *const c_void, rs: *const c_void, ts: *const c_void) -> Result_void;
		pub fn cv_sfm_normalizeFundamental_const__InputArrayR_const__OutputArrayR(f: *const c_void, f_normalized: *const c_void) -> Result_void;
		pub fn cv_sfm_normalizeIsotropicPoints_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(points: *const c_void, normalized_points: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_normalizePoints_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(points: *const c_void, normalized_points: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_normalizedEightPointSolver_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x1: *const c_void, x2: *const c_void, f: *const c_void) -> Result_void;
		pub fn cv_sfm_preconditionerFromPoints_const__InputArrayR_const__OutputArrayR(points: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_projectionFromKRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(k: *const c_void, r: *const c_void, t: *const c_void, p: *const c_void) -> Result_void;
		pub fn cv_sfm_projectionsFromFundamental_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(f: *const c_void, p1: *const c_void, p2: *const c_void) -> Result_void;
		pub fn cv_sfm_reconstruct_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_bool(points2d: *const c_void, ps: *const c_void, points3d: *const c_void, k: *const c_void, is_projective: bool) -> Result_void;
		pub fn cv_sfm_reconstruct_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_const__OutputArrayR_bool(points2d: *const c_void, rs: *const c_void, ts: *const c_void, k: *const c_void, points3d: *const c_void, is_projective: bool) -> Result_void;
		pub fn cv_sfm_reconstruct_const_vector_String__const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_bool(images: *const c_void, ps: *const c_void, points3d: *const c_void, k: *const c_void, is_projective: bool) -> Result_void;
		pub fn cv_sfm_reconstruct_const_vector_String__const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_const__OutputArrayR_bool(images: *const c_void, rs: *const c_void, ts: *const c_void, k: *const c_void, points3d: *const c_void, is_projective: bool) -> Result_void;
		pub fn cv_sfm_relativeCameraMotion_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(r1: *const c_void, t1: *const c_void, r2: *const c_void, t2: *const c_void, r: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_sfm_skew_const__InputArrayR(x: *const c_void) -> Result<*mut c_void>;
		pub fn cv_sfm_triangulatePoints_const__InputArrayR_const__InputArrayR_const__OutputArrayR(points2d: *const c_void, projection_matrices: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_run_const__InputArrayR(instance: *mut c_void, points2d: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_run_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, points2d: *const c_void, k: *const c_void, rs: *const c_void, ts: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_run_const_vector_String_R(instance: *mut c_void, images: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_run_const_vector_String_R_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, k: *const c_void, rs: *const c_void, ts: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_getError_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_sfm_BaseSFM_getPoints_const__OutputArrayR(instance: *mut c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_getIntrinsics_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_sfm_BaseSFM_getCameras_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, rs: *const c_void, ts: *const c_void) -> Result_void;
		pub fn cv_sfm_BaseSFM_setReconstructionOptions_const_libmv_ReconstructionOptionsR(instance: *mut c_void, libmv_reconstruction_options: *const crate::sfm::libmv_ReconstructionOptions) -> Result_void;
		pub fn cv_sfm_BaseSFM_setCameraIntrinsicOptions_const_libmv_CameraIntrinsicsOptionsR(instance: *mut c_void, libmv_camera_intrinsics_options: *const crate::sfm::libmv_CameraIntrinsicsOptions) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_run_const__InputArrayR(instance: *mut c_void, points2d: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_run_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, points2d: *const c_void, k: *const c_void, rs: *const c_void, ts: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_run_const_vector_String_R(instance: *mut c_void, images: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_run_const_vector_String_R_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, k: *const c_void, rs: *const c_void, ts: *const c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_getError_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_getPoints_const__OutputArrayR(instance: *mut c_void, points3d: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_getIntrinsics_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_getCameras_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, rs: *const c_void, ts: *const c_void) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_setReconstructionOptions_const_libmv_ReconstructionOptionsR(instance: *mut c_void, libmv_reconstruction_options: *const crate::sfm::libmv_ReconstructionOptions) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_setCameraIntrinsicOptions_const_libmv_CameraIntrinsicsOptionsR(instance: *mut c_void, libmv_camera_intrinsics_options: *const crate::sfm::libmv_CameraIntrinsicsOptions) -> Result_void;
		pub fn cv_sfm_SFMLibmvEuclideanReconstruction_create_const_libmv_CameraIntrinsicsOptionsR_const_libmv_ReconstructionOptionsR(camera_instrinsic_options: *const crate::sfm::libmv_CameraIntrinsicsOptions, reconstruction_options: *const crate::sfm::libmv_ReconstructionOptions) -> Result<*mut c_void>;
		pub fn cv_sfm_libmv_CameraIntrinsicsOptions_libmv_CameraIntrinsicsOptions_const_int_const_double_const_double_const_double_const_double_const_double_const_double_const_double_const_double_const_double(_distortion_model: i32, _focal_length_x: f64, _focal_length_y: f64, _principal_point_x: f64, _principal_point_y: f64, _polynomial_k1: f64, _polynomial_k2: f64, _polynomial_k3: f64, _polynomial_p1: f64, _polynomial_p2: f64) -> Result<crate::sfm::libmv_CameraIntrinsicsOptions>;
		pub fn cv_sfm_libmv_ReconstructionOptions_libmv_ReconstructionOptions_const_int_const_int_const_int_const_int_const_int(_keyframe1: i32, _keyframe2: i32, _refine_intrinsics: i32, _select_keyframes: i32, _verbosity_level: i32) -> Result<crate::sfm::libmv_ReconstructionOptions>;
	}
}
#[cfg(ocvrs_has_module_sfm)]
pub use sfm_sys::*;

#[cfg(ocvrs_has_module_shape)]
mod shape_sys {
	use super::*;

	extern "C" {
		pub fn cv_EMDL1_const__InputArrayR_const__InputArrayR(signature1: *const c_void, signature2: *const c_void) -> Result<f32>;
		pub fn cv_createAffineTransformer_bool(full_affine: bool) -> Result<*mut c_void>;
		pub fn cv_createChiHistogramCostExtractor_int_float(n_dummies: i32, default_cost: f32) -> Result<*mut c_void>;
		pub fn cv_createEMDHistogramCostExtractor_int_int_float(flag: i32, n_dummies: i32, default_cost: f32) -> Result<*mut c_void>;
		pub fn cv_createEMDL1HistogramCostExtractor_int_float(n_dummies: i32, default_cost: f32) -> Result<*mut c_void>;
		pub fn cv_createHausdorffDistanceExtractor_int_float(distance_flag: i32, rank_prop: f32) -> Result<*mut c_void>;
		pub fn cv_createNormHistogramCostExtractor_int_int_float(flag: i32, n_dummies: i32, default_cost: f32) -> Result<*mut c_void>;
		pub fn cv_createShapeContextDistanceExtractor_int_int_float_float_int_const_Ptr_HistogramCostExtractor_R_const_Ptr_ShapeTransformer_R(n_angular_bins: i32, n_radial_bins: i32, inner_radius: f32, outer_radius: f32, iterations: i32, comparer: *const c_void, transformer: *const c_void) -> Result<*mut c_void>;
		pub fn cv_createThinPlateSplineShapeTransformer_double(regularization_parameter: f64) -> Result<*mut c_void>;
		pub fn cv_AffineTransformer_setFullAffine_bool(instance: *mut c_void, full_affine: bool) -> Result_void;
		pub fn cv_AffineTransformer_getFullAffine_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_EMDHistogramCostExtractor_setNormFlag_int(instance: *mut c_void, flag: i32) -> Result_void;
		pub fn cv_EMDHistogramCostExtractor_getNormFlag_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_HausdorffDistanceExtractor_setDistanceFlag_int(instance: *mut c_void, distance_flag: i32) -> Result_void;
		pub fn cv_HausdorffDistanceExtractor_getDistanceFlag_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_HausdorffDistanceExtractor_setRankProportion_float(instance: *mut c_void, rank_proportion: f32) -> Result_void;
		pub fn cv_HausdorffDistanceExtractor_getRankProportion_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_HistogramCostExtractor_buildCostMatrix_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, descriptors1: *const c_void, descriptors2: *const c_void, cost_matrix: *const c_void) -> Result_void;
		pub fn cv_HistogramCostExtractor_setNDummies_int(instance: *mut c_void, n_dummies: i32) -> Result_void;
		pub fn cv_HistogramCostExtractor_getNDummies_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_HistogramCostExtractor_setDefaultCost_float(instance: *mut c_void, default_cost: f32) -> Result_void;
		pub fn cv_HistogramCostExtractor_getDefaultCost_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_NormHistogramCostExtractor_setNormFlag_int(instance: *mut c_void, flag: i32) -> Result_void;
		pub fn cv_NormHistogramCostExtractor_getNormFlag_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ShapeContextDistanceExtractor_setAngularBins_int(instance: *mut c_void, n_angular_bins: i32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getAngularBins_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ShapeContextDistanceExtractor_setRadialBins_int(instance: *mut c_void, n_radial_bins: i32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getRadialBins_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ShapeContextDistanceExtractor_setInnerRadius_float(instance: *mut c_void, inner_radius: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getInnerRadius_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setOuterRadius_float(instance: *mut c_void, outer_radius: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getOuterRadius_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setRotationInvariant_bool(instance: *mut c_void, rotation_invariant: bool) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getRotationInvariant_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ShapeContextDistanceExtractor_setShapeContextWeight_float(instance: *mut c_void, shape_context_weight: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getShapeContextWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setImageAppearanceWeight_float(instance: *mut c_void, image_appearance_weight: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getImageAppearanceWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setBendingEnergyWeight_float(instance: *mut c_void, bending_energy_weight: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getBendingEnergyWeight_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setImages_const__InputArrayR_const__InputArrayR(instance: *mut c_void, image1: *const c_void, image2: *const c_void) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getImages_const_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, image1: *const c_void, image2: *const c_void) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_setIterations_int(instance: *mut c_void, iterations: i32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ShapeContextDistanceExtractor_setCostExtractor_Ptr_HistogramCostExtractor_(instance: *mut c_void, comparer: *mut c_void) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getCostExtractor_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ShapeContextDistanceExtractor_setStdDev_float(instance: *mut c_void, sigma: f32) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getStdDev_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ShapeContextDistanceExtractor_setTransformAlgorithm_Ptr_ShapeTransformer_(instance: *mut c_void, transformer: *mut c_void) -> Result_void;
		pub fn cv_ShapeContextDistanceExtractor_getTransformAlgorithm_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ShapeDistanceExtractor_computeDistance_const__InputArrayR_const__InputArrayR(instance: *mut c_void, contour1: *const c_void, contour2: *const c_void) -> Result<f32>;
		pub fn cv_ShapeTransformer_estimateTransformation_const__InputArrayR_const__InputArrayR_vector_DMatch_R(instance: *mut c_void, transforming_shape: *const c_void, target_shape: *const c_void, matches: *mut c_void) -> Result_void;
		pub fn cv_ShapeTransformer_applyTransformation_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input: *const c_void, output: *const c_void) -> Result<f32>;
		pub fn cv_ShapeTransformer_warpImage_const_const__InputArrayR_const__OutputArrayR_int_int_const_ScalarR(instance: *const c_void, transforming_image: *const c_void, output: *const c_void, flags: i32, border_mode: i32, border_value: *const core::Scalar) -> Result_void;
		pub fn cv_ThinPlateSplineShapeTransformer_setRegularizationParameter_double(instance: *mut c_void, beta: f64) -> Result_void;
		pub fn cv_ThinPlateSplineShapeTransformer_getRegularizationParameter_const(instance: *const c_void) -> Result<f64>;
	}
}
#[cfg(ocvrs_has_module_shape)]
pub use shape_sys::*;

#[cfg(ocvrs_has_module_stereo)]
mod stereo_sys {
	use super::*;

	extern "C" {
		pub fn cv_stereo_censusTransform_const_MatR_const_MatR_int_MatR_MatR_const_int(image1: *const c_void, image2: *const c_void, kernel_size: i32, dist1: *mut c_void, dist2: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_stereo_censusTransform_const_MatR_int_MatR_const_int(image1: *const c_void, kernel_size: i32, dist1: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_stereo_modifiedCensusTransform_const_MatR_const_MatR_int_MatR_MatR_const_int_int_const_MatR_const_MatR(img1: *const c_void, img2: *const c_void, kernel_size: i32, dist1: *mut c_void, dist2: *mut c_void, typ: i32, t: i32, integral_image1: *const c_void, integral_image2: *const c_void) -> Result_void;
		pub fn cv_stereo_modifiedCensusTransform_const_MatR_int_MatR_const_int_int_const_MatR(img1: *const c_void, kernel_size: i32, dist: *mut c_void, typ: i32, t: i32, integral_image: *const c_void) -> Result_void;
		pub fn cv_stereo_starCensusTransform_const_MatR_const_MatR_int_MatR_MatR(img1: *const c_void, img2: *const c_void, kernel_size: i32, dist1: *mut c_void, dist2: *mut c_void) -> Result_void;
		pub fn cv_stereo_starCensusTransform_const_MatR_int_MatR(img1: *const c_void, kernel_size: i32, dist: *mut c_void) -> Result_void;
		pub fn cv_stereo_symetricCensusTransform_const_MatR_const_MatR_int_MatR_MatR_const_int(img1: *const c_void, img2: *const c_void, kernel_size: i32, dist1: *mut c_void, dist2: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_stereo_symetricCensusTransform_const_MatR_int_MatR_const_int(img1: *const c_void, kernel_size: i32, dist1: *mut c_void, typ: i32) -> Result_void;
		pub fn cv_stereo_MatchQuasiDense_MatchQuasiDense() -> Result<crate::stereo::MatchQuasiDense>;
		pub fn cv_stereo_QuasiDenseStereo_getPropParam_const(instance: *const c_void) -> crate::stereo::PropagationParameters;
		pub fn cv_stereo_QuasiDenseStereo_setPropParam_PropagationParameters(instance: *mut c_void, val: *const crate::stereo::PropagationParameters);
		pub fn cv_stereo_QuasiDenseStereo_loadParameters_String(instance: *mut c_void, filepath: *mut c_char) -> Result<i32>;
		pub fn cv_stereo_QuasiDenseStereo_saveParameters_String(instance: *mut c_void, filepath: *mut c_char) -> Result<i32>;
		pub fn cv_stereo_QuasiDenseStereo_getSparseMatches_vector_MatchQuasiDense_R(instance: *mut c_void, s_matches: *mut c_void) -> Result_void;
		pub fn cv_stereo_QuasiDenseStereo_getDenseMatches_vector_MatchQuasiDense_R(instance: *mut c_void, dense_matches: *mut c_void) -> Result_void;
		pub fn cv_stereo_QuasiDenseStereo_process_const_MatR_const_MatR(instance: *mut c_void, img_left: *const c_void, img_right: *const c_void) -> Result_void;
		pub fn cv_stereo_QuasiDenseStereo_getMatch_const_int_const_int(instance: *mut c_void, x: i32, y: i32) -> Result<core::Point2f>;
		pub fn cv_stereo_QuasiDenseStereo_getDisparity(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_stereo_QuasiDenseStereo_create_Size_String(mono_img_size: *const core::Size, param_filepath: *mut c_char) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_stereo)]
pub use stereo_sys::*;

#[cfg(ocvrs_has_module_stitching)]
mod stitching_sys {
	use super::*;

	extern "C" {
		pub fn cv_detail_autoDetectWaveCorrectKind_const_vector_Mat_R(rmats: *const c_void) -> Result<crate::stitching::Detail_WaveCorrectKind>;
		pub fn cv_detail_computeImageFeatures_const_Ptr_Feature2D_R_const__InputArrayR_ImageFeaturesR_const__InputArrayR(features_finder: *const c_void, image: *const c_void, features: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_computeImageFeatures_const_Ptr_Feature2D_R_const__InputArrayR_vector_ImageFeatures_R_const__InputArrayR(features_finder: *const c_void, images: *const c_void, features: *mut c_void, masks: *const c_void) -> Result_void;
		pub fn cv_detail_createLaplacePyrGpu_const__InputArrayR_int_vector_UMat_R(img: *const c_void, num_levels: i32, pyr: *mut c_void) -> Result_void;
		pub fn cv_detail_createLaplacePyr_const__InputArrayR_int_vector_UMat_R(img: *const c_void, num_levels: i32, pyr: *mut c_void) -> Result_void;
		pub fn cv_detail_createWeightMap_const__InputArrayR_float_const__InputOutputArrayR(mask: *const c_void, sharpness: f32, weight: *const c_void) -> Result_void;
		pub fn cv_detail_findMaxSpanningTree_int_const_vector_MatchesInfo_R_GraphR_vector_int_R(num_images: i32, pairwise_matches: *const c_void, span_tree: *mut c_void, centers: *mut c_void) -> Result_void;
		pub fn cv_detail_leaveBiggestComponent_vector_ImageFeatures_R_vector_MatchesInfo_R_float(features: *mut c_void, pairwise_matches: *mut c_void, conf_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_detail_matchesGraphAsString_vector_String_R_vector_MatchesInfo_R_float(pathes: *mut c_void, pairwise_matches: *mut c_void, conf_threshold: f32) -> Result<*mut c_void>;
		pub fn cv_detail_normalizeUsingWeightMap_const__InputArrayR_const__InputOutputArrayR(weight: *const c_void, src: *const c_void) -> Result_void;
		pub fn cv_detail_overlapRoi_Point_Point_Size_Size_RectR(tl1: *const core::Point, tl2: *const core::Point, sz1: *const core::Size, sz2: *const core::Size, roi: *mut core::Rect) -> Result<bool>;
		pub fn cv_detail_restoreImageFromLaplacePyrGpu_vector_UMat_R(pyr: *mut c_void) -> Result_void;
		pub fn cv_detail_restoreImageFromLaplacePyr_vector_UMat_R(pyr: *mut c_void) -> Result_void;
		pub fn cv_detail_resultRoiIntersection_const_vector_Point_R_const_vector_Size_R(corners: *const c_void, sizes: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_resultRoi_const_vector_Point_R_const_vector_Size_R(corners: *const c_void, sizes: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_resultRoi_const_vector_Point_R_const_vector_UMat_R(corners: *const c_void, images: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_resultTl_const_vector_Point_R(corners: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_selectRandomSubset_int_int_vector_int_R(count: i32, size: i32, subset: *mut c_void) -> Result_void;
		pub fn cv_detail_stitchingLogLevel() -> Result<i32>;
		pub fn cv_detail_waveCorrect_vector_Mat_R_WaveCorrectKind(rmats: *mut c_void, kind: crate::stitching::Detail_WaveCorrectKind) -> Result_void;
		pub fn cv_AffineWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_CompressedRectilinearPortraitWarper_CompressedRectilinearPortraitWarper_float_float(a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_CompressedRectilinearPortraitWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_CompressedRectilinearWarper_CompressedRectilinearWarper_float_float(a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_CompressedRectilinearWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_CylindricalWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_CylindricalWarperGpu_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_FisheyeWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_MercatorWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PaniniPortraitWarper_PaniniPortraitWarper_float_float(a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_PaniniPortraitWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PaniniWarper_PaniniWarper_float_float(a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_PaniniWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PlaneWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PlaneWarperGpu_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PyRotationWarper_PyRotationWarper_String_float(typ: *mut c_char, scale: f32) -> Result<*mut c_void>;
		pub fn cv_PyRotationWarper_PyRotationWarper() -> Result<*mut c_void>;
		pub fn cv_PyRotationWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_PyRotationWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_PyRotationWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_PyRotationWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_PyRotationWarper_warpBackward_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_Size_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst_size: *const core::Size, dst: *const c_void) -> Result_void;
		pub fn cv_PyRotationWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void) -> Result<core::Rect>;
		pub fn cv_PyRotationWarper_getScale_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_PyRotationWarper_setScale_float(instance: *mut c_void, unnamed: f32) -> Result_void;
		pub fn cv_SphericalWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_SphericalWarperGpu_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_StereographicWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_Stitcher_create_Mode(mode: crate::stitching::Stitcher_Mode) -> Result<*mut c_void>;
		pub fn cv_Stitcher_registrationResol_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_Stitcher_setRegistrationResol_double(instance: *mut c_void, resol_mpx: f64) -> Result_void;
		pub fn cv_Stitcher_seamEstimationResol_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_Stitcher_setSeamEstimationResol_double(instance: *mut c_void, resol_mpx: f64) -> Result_void;
		pub fn cv_Stitcher_compositingResol_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_Stitcher_setCompositingResol_double(instance: *mut c_void, resol_mpx: f64) -> Result_void;
		pub fn cv_Stitcher_panoConfidenceThresh_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_Stitcher_setPanoConfidenceThresh_double(instance: *mut c_void, conf_thresh: f64) -> Result_void;
		pub fn cv_Stitcher_waveCorrection_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_Stitcher_setWaveCorrection_bool(instance: *mut c_void, flag: bool) -> Result_void;
		pub fn cv_Stitcher_interpolationFlags_const(instance: *const c_void) -> Result<crate::imgproc::InterpolationFlags>;
		pub fn cv_Stitcher_setInterpolationFlags_InterpolationFlags(instance: *mut c_void, interp_flags: crate::imgproc::InterpolationFlags) -> Result_void;
		pub fn cv_Stitcher_waveCorrectKind_const(instance: *const c_void) -> Result<crate::stitching::Detail_WaveCorrectKind>;
		pub fn cv_Stitcher_setWaveCorrectKind_WaveCorrectKind(instance: *mut c_void, kind: crate::stitching::Detail_WaveCorrectKind) -> Result_void;
		pub fn cv_Stitcher_featuresFinder(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_featuresFinder_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setFeaturesFinder_Ptr_Feature2D_(instance: *mut c_void, features_finder: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_featuresMatcher(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_featuresMatcher_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setFeaturesMatcher_Ptr_FeaturesMatcher_(instance: *mut c_void, features_matcher: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_matchingMask_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setMatchingMask_const_UMatR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_Stitcher_bundleAdjuster(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_bundleAdjuster_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setBundleAdjuster_Ptr_BundleAdjusterBase_(instance: *mut c_void, bundle_adjuster: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_estimator(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_estimator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setEstimator_Ptr_Estimator_(instance: *mut c_void, estimator: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_warper(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_warper_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setWarper_Ptr_WarperCreator_(instance: *mut c_void, creator: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_exposureCompensator(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_exposureCompensator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setExposureCompensator_Ptr_ExposureCompensator_(instance: *mut c_void, exposure_comp: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_seamFinder(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_seamFinder_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setSeamFinder_Ptr_SeamFinder_(instance: *mut c_void, seam_finder: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_blender(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_blender_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_setBlender_Ptr_Blender_(instance: *mut c_void, b: *mut c_void) -> Result_void;
		pub fn cv_Stitcher_estimateTransform_const__InputArrayR_const__InputArrayR(instance: *mut c_void, images: *const c_void, masks: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_setTransform_const__InputArrayR_const_vector_CameraParams_R_const_vector_int_R(instance: *mut c_void, images: *const c_void, cameras: *const c_void, component: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_setTransform_const__InputArrayR_const_vector_CameraParams_R(instance: *mut c_void, images: *const c_void, cameras: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_composePanorama_const__OutputArrayR(instance: *mut c_void, pano: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_composePanorama_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, pano: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_stitch_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, pano: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_stitch_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, masks: *const c_void, pano: *const c_void) -> Result<crate::stitching::Stitcher_Status>;
		pub fn cv_Stitcher_component_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_cameras_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_Stitcher_workScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_Stitcher_resultMask_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_TransverseMercatorWarper_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_WarperCreator_create_const_float(instance: *const c_void, scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_AffineBasedEstimator_AffineBasedEstimator() -> Result<*mut c_void>;
		pub fn cv_detail_AffineBestOf2NearestMatcher_AffineBestOf2NearestMatcher_bool_bool_float_int(full_affine: bool, try_use_gpu: bool, match_conf: f32, num_matches_thresh1: i32) -> Result<*mut c_void>;
		pub fn cv_detail_AffineWarper_AffineWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_AffineWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, h: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_AffineWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, h: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_AffineWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, h: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_AffineWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, h: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_AffineWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, h: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_BestOf2NearestMatcher_BestOf2NearestMatcher_bool_float_int_int(try_use_gpu: bool, match_conf: f32, num_matches_thresh1: i32, num_matches_thresh2: i32) -> Result<*mut c_void>;
		pub fn cv_detail_BestOf2NearestMatcher_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_detail_BestOf2NearestMatcher_create_bool_float_int_int(try_use_gpu: bool, match_conf: f32, num_matches_thresh1: i32, num_matches_thresh2: i32) -> Result<*mut c_void>;
		pub fn cv_detail_BestOf2NearestRangeMatcher_BestOf2NearestRangeMatcher_int_bool_float_int_int(range_width: i32, try_use_gpu: bool, match_conf: f32, num_matches_thresh1: i32, num_matches_thresh2: i32) -> Result<*mut c_void>;
		pub fn cv_detail_Blender_createDefault_int_bool(typ: i32, try_gpu: bool) -> Result<*mut c_void>;
		pub fn cv_detail_Blender_prepare_const_vector_Point_R_const_vector_Size_R(instance: *mut c_void, corners: *const c_void, sizes: *const c_void) -> Result_void;
		pub fn cv_detail_Blender_prepare_Rect(instance: *mut c_void, dst_roi: *const core::Rect) -> Result_void;
		pub fn cv_detail_Blender_feed_const__InputArrayR_const__InputArrayR_Point(instance: *mut c_void, img: *const c_void, mask: *const c_void, tl: *const core::Point) -> Result_void;
		pub fn cv_detail_Blender_blend_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, dst: *const c_void, dst_mask: *const c_void) -> Result_void;
		pub fn cv_detail_BlocksChannelsCompensator_BlocksChannelsCompensator_int_int_int(bl_width: i32, bl_height: i32, nr_feeds: i32) -> Result<*mut c_void>;
		pub fn cv_detail_BlocksCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, index: i32, corner: *const core::Point, image: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_BlocksCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_BlocksCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_BlocksCompensator_setNrFeeds_int(instance: *mut c_void, nr_feeds: i32) -> Result_void;
		pub fn cv_detail_BlocksCompensator_getNrFeeds(instance: *mut c_void) -> Result<i32>;
		pub fn cv_detail_BlocksCompensator_setSimilarityThreshold_double(instance: *mut c_void, similarity_threshold: f64) -> Result_void;
		pub fn cv_detail_BlocksCompensator_getSimilarityThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_detail_BlocksCompensator_setBlockSize_int_int(instance: *mut c_void, width: i32, height: i32) -> Result_void;
		pub fn cv_detail_BlocksCompensator_setBlockSize_Size(instance: *mut c_void, size: *const core::Size) -> Result_void;
		pub fn cv_detail_BlocksCompensator_getBlockSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_detail_BlocksCompensator_setNrGainsFilteringIterations_int(instance: *mut c_void, nr_iterations: i32) -> Result_void;
		pub fn cv_detail_BlocksCompensator_getNrGainsFilteringIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_detail_BlocksGainCompensator_BlocksGainCompensator_int_int(bl_width: i32, bl_height: i32) -> Result<*mut c_void>;
		pub fn cv_detail_BlocksGainCompensator_BlocksGainCompensator_int_int_int(bl_width: i32, bl_height: i32, nr_feeds: i32) -> Result<*mut c_void>;
		pub fn cv_detail_BlocksGainCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, index: i32, corner: *const core::Point, image: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_BlocksGainCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_BlocksGainCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_BundleAdjusterAffine_BundleAdjusterAffine() -> Result<*mut c_void>;
		pub fn cv_detail_BundleAdjusterAffinePartial_BundleAdjusterAffinePartial() -> Result<*mut c_void>;
		pub fn cv_detail_BundleAdjusterBase_refinementMask_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_BundleAdjusterBase_setRefinementMask_const_MatR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_BundleAdjusterBase_confThresh_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_detail_BundleAdjusterBase_setConfThresh_double(instance: *mut c_void, conf_thresh: f64) -> Result_void;
		pub fn cv_detail_BundleAdjusterBase_termCriteria(instance: *mut c_void) -> Result<core::TermCriteria>;
		pub fn cv_detail_BundleAdjusterBase_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, term_criteria: *const core::TermCriteria) -> Result_void;
		pub fn cv_detail_BundleAdjusterRay_BundleAdjusterRay() -> Result<*mut c_void>;
		pub fn cv_detail_BundleAdjusterReproj_BundleAdjusterReproj() -> Result<*mut c_void>;
		pub fn cv_detail_CameraParams_getPropFocal_const(instance: *const c_void) -> f64;
		pub fn cv_detail_CameraParams_setPropFocal_double(instance: *mut c_void, val: f64);
		pub fn cv_detail_CameraParams_getPropAspect_const(instance: *const c_void) -> f64;
		pub fn cv_detail_CameraParams_setPropAspect_double(instance: *mut c_void, val: f64);
		pub fn cv_detail_CameraParams_getPropPpx_const(instance: *const c_void) -> f64;
		pub fn cv_detail_CameraParams_setPropPpx_double(instance: *mut c_void, val: f64);
		pub fn cv_detail_CameraParams_getPropPpy_const(instance: *const c_void) -> f64;
		pub fn cv_detail_CameraParams_setPropPpy_double(instance: *mut c_void, val: f64);
		pub fn cv_detail_CameraParams_getPropR_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CameraParams_setPropR_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_CameraParams_getPropT_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CameraParams_setPropT_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_CameraParams_CameraParams() -> Result<*mut c_void>;
		pub fn cv_detail_CameraParams_CameraParams_const_CameraParamsR(other: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_CameraParams_K_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_ChannelsCompensator_ChannelsCompensator_int(nr_feeds: i32) -> Result<*mut c_void>;
		pub fn cv_detail_ChannelsCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, index: i32, corner: *const core::Point, image: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_ChannelsCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_ChannelsCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_ChannelsCompensator_setNrFeeds_int(instance: *mut c_void, nr_feeds: i32) -> Result_void;
		pub fn cv_detail_ChannelsCompensator_getNrFeeds(instance: *mut c_void) -> Result<i32>;
		pub fn cv_detail_ChannelsCompensator_setSimilarityThreshold_double(instance: *mut c_void, similarity_threshold: f64) -> Result_void;
		pub fn cv_detail_ChannelsCompensator_getSimilarityThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_detail_ChannelsCompensator_gains_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_CompressedRectilinearPortraitProjector_getPropA_const(instance: *const c_void) -> f32;
		pub fn cv_detail_CompressedRectilinearPortraitProjector_setPropA_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_CompressedRectilinearPortraitProjector_getPropB_const(instance: *const c_void) -> f32;
		pub fn cv_detail_CompressedRectilinearPortraitProjector_setPropB_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_CompressedRectilinearPortraitProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_CompressedRectilinearPortraitProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_CompressedRectilinearPortraitWarper_CompressedRectilinearPortraitWarper_float_float_float(scale: f32, a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_detail_CompressedRectilinearProjector_getPropA_const(instance: *const c_void) -> f32;
		pub fn cv_detail_CompressedRectilinearProjector_setPropA_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_CompressedRectilinearProjector_getPropB_const(instance: *const c_void) -> f32;
		pub fn cv_detail_CompressedRectilinearProjector_setPropB_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_CompressedRectilinearProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_CompressedRectilinearProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_CompressedRectilinearWarper_CompressedRectilinearWarper_float_float_float(scale: f32, a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_detail_CylindricalPortraitProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_CylindricalPortraitProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_CylindricalPortraitWarper_CylindricalPortraitWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_CylindricalProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_CylindricalProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_CylindricalWarper_CylindricalWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_CylindricalWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_CylindricalWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_CylindricalWarperGpu_CylindricalWarperGpu_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_CylindricalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_CylindricalWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_CylindricalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *mut c_void, ymap: *mut c_void) -> Result<core::Rect>;
		pub fn cv_detail_CylindricalWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *mut c_void) -> Result<core::Point>;
		pub fn cv_detail_DisjointSets_getPropParent_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_DisjointSets_setPropParent_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_DisjointSets_getPropSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_DisjointSets_setPropSize_vector_int_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_DisjointSets_DisjointSets_int(elem_count: i32) -> Result<*mut c_void>;
		pub fn cv_detail_DisjointSets_createOneElemSets_int(instance: *mut c_void, elem_count: i32) -> Result_void;
		pub fn cv_detail_DisjointSets_findSetByElem_int(instance: *mut c_void, elem: i32) -> Result<i32>;
		pub fn cv_detail_DisjointSets_mergeSets_int_int(instance: *mut c_void, set1: i32, set2: i32) -> Result<i32>;
		pub fn cv_detail_DpSeamFinder_DpSeamFinder_CostFunction(cost_func: crate::stitching::Detail_DpSeamFinder_CostFunction) -> Result<*mut c_void>;
		pub fn cv_detail_DpSeamFinder_DpSeamFinder_String(cost_func: *mut c_char) -> Result<*mut c_void>;
		pub fn cv_detail_DpSeamFinder_costFunction_const(instance: *const c_void) -> Result<crate::stitching::Detail_DpSeamFinder_CostFunction>;
		pub fn cv_detail_DpSeamFinder_setCostFunction_CostFunction(instance: *mut c_void, val: crate::stitching::Detail_DpSeamFinder_CostFunction) -> Result_void;
		pub fn cv_detail_DpSeamFinder_setCostFunction_String(instance: *mut c_void, val: *mut c_char) -> Result_void;
		pub fn cv_detail_DpSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_ExposureCompensator_createDefault_int(typ: i32) -> Result<*mut c_void>;
		pub fn cv_detail_ExposureCompensator_feed_const_vector_Point_R_const_vector_UMat_R_const_vector_UMat_R(instance: *mut c_void, corners: *const c_void, images: *const c_void, masks: *const c_void) -> Result_void;
		pub fn cv_detail_ExposureCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, index: i32, corner: *const core::Point, image: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_ExposureCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_detail_ExposureCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, unnamed: *mut c_void) -> Result_void;
		pub fn cv_detail_ExposureCompensator_setUpdateGain_bool(instance: *mut c_void, b: bool) -> Result_void;
		pub fn cv_detail_ExposureCompensator_getUpdateGain(instance: *mut c_void) -> Result<bool>;
		pub fn cv_detail_FeatherBlender_FeatherBlender_float(sharpness: f32) -> Result<*mut c_void>;
		pub fn cv_detail_FeatherBlender_sharpness_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_detail_FeatherBlender_setSharpness_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_detail_FeatherBlender_prepare_Rect(instance: *mut c_void, dst_roi: *const core::Rect) -> Result_void;
		pub fn cv_detail_FeatherBlender_feed_const__InputArrayR_const__InputArrayR_Point(instance: *mut c_void, img: *const c_void, mask: *const c_void, tl: *const core::Point) -> Result_void;
		pub fn cv_detail_FeatherBlender_blend_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, dst: *const c_void, dst_mask: *const c_void) -> Result_void;
		pub fn cv_detail_FeatherBlender_createWeightMaps_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, masks: *const c_void, corners: *const c_void, weight_maps: *mut c_void) -> Result<core::Rect>;
		pub fn cv_detail_FeaturesMatcher_isThreadSafe_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_detail_FeaturesMatcher_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_detail_FisheyeProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_FisheyeProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_FisheyeWarper_FisheyeWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_GainCompensator_GainCompensator() -> Result<*mut c_void>;
		pub fn cv_detail_GainCompensator_GainCompensator_int(nr_feeds: i32) -> Result<*mut c_void>;
		pub fn cv_detail_GainCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, index: i32, corner: *const core::Point, image: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_detail_GainCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_GainCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_GainCompensator_setNrFeeds_int(instance: *mut c_void, nr_feeds: i32) -> Result_void;
		pub fn cv_detail_GainCompensator_getNrFeeds(instance: *mut c_void) -> Result<i32>;
		pub fn cv_detail_GainCompensator_setSimilarityThreshold_double(instance: *mut c_void, similarity_threshold: f64) -> Result_void;
		pub fn cv_detail_GainCompensator_getSimilarityThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_detail_GainCompensator_prepareSimilarityMask_const_vector_Point_R_const_vector_UMat_R(instance: *mut c_void, corners: *const c_void, images: *const c_void) -> Result_void;
		pub fn cv_detail_GainCompensator_gains_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_Graph_Graph_int(num_vertices: i32) -> Result<*mut c_void>;
		pub fn cv_detail_Graph_create_int(instance: *mut c_void, num_vertices: i32) -> Result_void;
		pub fn cv_detail_Graph_numVertices_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_detail_Graph_addEdge_int_int_float(instance: *mut c_void, from: i32, to: i32, weight: f32) -> Result_void;
		pub fn cv_detail_GraphCutSeamFinder_GraphCutSeamFinder_int_float_float(cost_type: i32, terminal_cost: f32, bad_region_penalty: f32) -> Result<*mut c_void>;
		pub fn cv_detail_GraphCutSeamFinder_GraphCutSeamFinder_String_float_float(cost_type: *mut c_char, terminal_cost: f32, bad_region_penalty: f32) -> Result<*mut c_void>;
		pub fn cv_detail_GraphCutSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_GraphCutSeamFinderGpu_GraphCutSeamFinderGpu_int_float_float(cost_type: i32, terminal_cost: f32, bad_region_penalty: f32) -> Result<*mut c_void>;
		pub fn cv_detail_GraphCutSeamFinderGpu_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_GraphCutSeamFinderGpu_findInPair_size_t_size_t_Rect(instance: *mut c_void, first: size_t, second: size_t, roi: *const core::Rect) -> Result_void;
		pub fn cv_detail_GraphEdge_getPropFrom_const(instance: *const c_void) -> i32;
		pub fn cv_detail_GraphEdge_setPropFrom_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_GraphEdge_getPropTo_const(instance: *const c_void) -> i32;
		pub fn cv_detail_GraphEdge_setPropTo_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_GraphEdge_getPropWeight_const(instance: *const c_void) -> f32;
		pub fn cv_detail_GraphEdge_setPropWeight_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_GraphEdge_GraphEdge_int_int_float(from: i32, to: i32, weight: f32) -> Result<*mut c_void>;
		pub fn cv_detail_HomographyBasedEstimator_HomographyBasedEstimator_bool(is_focals_estimated: bool) -> Result<*mut c_void>;
		pub fn cv_detail_ImageFeatures_getPropImg_idx_const(instance: *const c_void) -> i32;
		pub fn cv_detail_ImageFeatures_setPropImg_idx_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_ImageFeatures_getPropImg_size_const(instance: *const c_void) -> core::Size;
		pub fn cv_detail_ImageFeatures_setPropImg_size_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_detail_ImageFeatures_getPropKeypoints_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_ImageFeatures_setPropKeypoints_vector_KeyPoint_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_ImageFeatures_getPropDescriptors_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_ImageFeatures_setPropDescriptors_UMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_ImageFeatures_getKeypoints(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_detail_MatchesInfo_getPropSrc_img_idx_const(instance: *const c_void) -> i32;
		pub fn cv_detail_MatchesInfo_setPropSrc_img_idx_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_MatchesInfo_getPropDst_img_idx_const(instance: *const c_void) -> i32;
		pub fn cv_detail_MatchesInfo_setPropDst_img_idx_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_MatchesInfo_getPropMatches_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_MatchesInfo_setPropMatches_vector_DMatch_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_MatchesInfo_getPropInliers_mask_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_MatchesInfo_setPropInliers_mask_vector_unsigned_char_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_MatchesInfo_getPropNum_inliers_const(instance: *const c_void) -> i32;
		pub fn cv_detail_MatchesInfo_setPropNum_inliers_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_MatchesInfo_getPropH_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_MatchesInfo_setPropH_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_detail_MatchesInfo_getPropConfidence_const(instance: *const c_void) -> f64;
		pub fn cv_detail_MatchesInfo_setPropConfidence_double(instance: *mut c_void, val: f64);
		pub fn cv_detail_MatchesInfo_MatchesInfo() -> Result<*mut c_void>;
		pub fn cv_detail_MatchesInfo_MatchesInfo_const_MatchesInfoR(other: *const c_void) -> Result<*mut c_void>;
		pub fn cv_detail_MatchesInfo_getMatches(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_detail_MatchesInfo_getInliers(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_detail_MercatorProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_MercatorProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_MercatorWarper_MercatorWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_MultiBandBlender_MultiBandBlender_int_int_int(try_gpu: i32, num_bands: i32, weight_type: i32) -> Result<*mut c_void>;
		pub fn cv_detail_MultiBandBlender_numBands_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_detail_MultiBandBlender_setNumBands_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_detail_MultiBandBlender_prepare_Rect(instance: *mut c_void, dst_roi: *const core::Rect) -> Result_void;
		pub fn cv_detail_MultiBandBlender_feed_const__InputArrayR_const__InputArrayR_Point(instance: *mut c_void, img: *const c_void, mask: *const c_void, tl: *const core::Point) -> Result_void;
		pub fn cv_detail_MultiBandBlender_blend_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, dst: *const c_void, dst_mask: *const c_void) -> Result_void;
		pub fn cv_detail_NoBundleAdjuster_NoBundleAdjuster() -> Result<*mut c_void>;
		pub fn cv_detail_NoExposureCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(instance: *mut c_void, unnamed: i32, unnamed_1: *const core::Point, unnamed_2: *const c_void, unnamed_3: *const c_void) -> Result_void;
		pub fn cv_detail_NoExposureCompensator_getMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_NoExposureCompensator_setMatGains_vector_Mat_R(instance: *mut c_void, umv: *mut c_void) -> Result_void;
		pub fn cv_detail_NoSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, unnamed: *const c_void, unnamed_1: *const c_void, unnamed_2: *mut c_void) -> Result_void;
		pub fn cv_detail_PairwiseSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_PaniniPortraitProjector_getPropA_const(instance: *const c_void) -> f32;
		pub fn cv_detail_PaniniPortraitProjector_setPropA_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_PaniniPortraitProjector_getPropB_const(instance: *const c_void) -> f32;
		pub fn cv_detail_PaniniPortraitProjector_setPropB_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_PaniniPortraitProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_PaniniPortraitProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_PaniniPortraitWarper_PaniniPortraitWarper_float_float_float(scale: f32, a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_detail_PaniniProjector_getPropA_const(instance: *const c_void) -> f32;
		pub fn cv_detail_PaniniProjector_setPropA_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_PaniniProjector_getPropB_const(instance: *const c_void) -> f32;
		pub fn cv_detail_PaniniProjector_setPropB_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_PaniniProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_PaniniProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_PaniniWarper_PaniniWarper_float_float_float(scale: f32, a: f32, b: f32) -> Result<*mut c_void>;
		pub fn cv_detail_PlanePortraitProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_PlanePortraitProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_PlanePortraitWarper_PlanePortraitWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_PlaneProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_PlaneProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_PlaneWarper_PlaneWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_PlaneWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_PlaneWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void, t: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_PlaneWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_PlaneWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void, t: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_PlaneWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, t: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_PlaneWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, t: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_PlaneWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, t: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarperGpu_PlaneWarperGpu_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, t: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_PlaneWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, t: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *mut c_void, ymap: *mut c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, t: *const c_void, xmap: *mut c_void, ymap: *mut c_void) -> Result<core::Rect>;
		pub fn cv_detail_PlaneWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *mut c_void) -> Result<core::Point>;
		pub fn cv_detail_PlaneWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, t: *const c_void, interp_mode: i32, border_mode: i32, dst: *mut c_void) -> Result<core::Point>;
		pub fn cv_detail_ProjectorBase_getPropScale_const(instance: *const c_void) -> f32;
		pub fn cv_detail_ProjectorBase_setPropScale_float(instance: *mut c_void, val: f32);
		pub fn cv_detail_ProjectorBase_getPropK(instance: *mut c_void) -> *mut [f32; 9];
		pub fn cv_detail_ProjectorBase_getPropRinv(instance: *mut c_void) -> *mut [f32; 9];
		pub fn cv_detail_ProjectorBase_getPropR_kinv(instance: *mut c_void) -> *mut [f32; 9];
		pub fn cv_detail_ProjectorBase_getPropK_rinv(instance: *mut c_void) -> *mut [f32; 9];
		pub fn cv_detail_ProjectorBase_getPropT(instance: *mut c_void) -> *mut [f32; 3];
		pub fn cv_detail_ProjectorBase_setCameraParams_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, k: *const c_void, r: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_detail_RotationWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_RotationWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, pt: *const core::Point2f, k: *const c_void, r: *const c_void) -> Result<core::Point2f>;
		pub fn cv_detail_RotationWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_RotationWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_RotationWarper_warpBackward_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_Size_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst_size: *const core::Size, dst: *const c_void) -> Result_void;
		pub fn cv_detail_RotationWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_RotationWarper_getScale_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_detail_RotationWarper_setScale_float(instance: *mut c_void, unnamed: f32) -> Result_void;
		pub fn cv_detail_SeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_SeamFinder_createDefault_int(typ: i32) -> Result<*mut c_void>;
		pub fn cv_detail_SphericalPortraitProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_SphericalPortraitProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_SphericalPortraitWarper_SphericalPortraitWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_SphericalProjector_mapForward_float_float_floatR_floatR(instance: *const crate::stitching::Detail_SphericalProjector, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_SphericalProjector_mapBackward_float_float_floatR_floatR(instance: *const crate::stitching::Detail_SphericalProjector, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_SphericalWarper_SphericalWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_SphericalWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_SphericalWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_SphericalWarperGpu_SphericalWarperGpu_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_SphericalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *const c_void, ymap: *const c_void) -> Result<core::Rect>;
		pub fn cv_detail_SphericalWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *const c_void) -> Result<core::Point>;
		pub fn cv_detail_SphericalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(instance: *mut c_void, src_size: *const core::Size, k: *const c_void, r: *const c_void, xmap: *mut c_void, ymap: *mut c_void) -> Result<core::Rect>;
		pub fn cv_detail_SphericalWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(instance: *mut c_void, src: *const c_void, k: *const c_void, r: *const c_void, interp_mode: i32, border_mode: i32, dst: *mut c_void) -> Result<core::Point>;
		pub fn cv_detail_StereographicProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_StereographicProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_StereographicWarper_StereographicWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_TransverseMercatorProjector_mapForward_float_float_floatR_floatR(instance: *mut c_void, x: f32, y: f32, u: *mut f32, v: *mut f32) -> Result_void;
		pub fn cv_detail_TransverseMercatorProjector_mapBackward_float_float_floatR_floatR(instance: *mut c_void, u: f32, v: f32, x: *mut f32, y: *mut f32) -> Result_void;
		pub fn cv_detail_TransverseMercatorWarper_TransverseMercatorWarper_float(scale: f32) -> Result<*mut c_void>;
		pub fn cv_detail_VoronoiSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, src: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
		pub fn cv_detail_VoronoiSeamFinder_find_const_vector_Size_R_const_vector_Point_R_vector_UMat_R(instance: *mut c_void, size: *const c_void, corners: *const c_void, masks: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_stitching)]
pub use stitching_sys::*;

#[cfg(ocvrs_has_module_structured_light)]
mod structured_light_sys {
	use super::*;

	extern "C" {
		pub fn cv_structured_light_GrayCodePattern_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_structured_light_GrayCodePattern_create_int_int(width: i32, height: i32) -> Result<*mut c_void>;
		pub fn cv_structured_light_GrayCodePattern_getNumberOfPatternImages_const(instance: *const c_void) -> Result<size_t>;
		pub fn cv_structured_light_GrayCodePattern_setWhiteThreshold_size_t(instance: *mut c_void, value: size_t) -> Result_void;
		pub fn cv_structured_light_GrayCodePattern_setBlackThreshold_size_t(instance: *mut c_void, value: size_t) -> Result_void;
		pub fn cv_structured_light_GrayCodePattern_getImagesForShadowMasks_const_const__InputOutputArrayR_const__InputOutputArrayR(instance: *const c_void, black_image: *const c_void, white_image: *const c_void) -> Result_void;
		pub fn cv_structured_light_GrayCodePattern_getProjPixel_const_const__InputArrayR_int_int_PointR(instance: *const c_void, pattern_images: *const c_void, x: i32, y: i32, proj_pix: *mut core::Point) -> Result<bool>;
		pub fn cv_structured_light_GrayCodePattern_Params_getPropWidth_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_GrayCodePattern_Params_setPropWidth_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_GrayCodePattern_Params_getPropHeight_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_GrayCodePattern_Params_setPropHeight_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_GrayCodePattern_Params_Params() -> Result<*mut c_void>;
		pub fn cv_structured_light_SinusoidalPattern_create_Ptr_Params_(parameters: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_structured_light_SinusoidalPattern_computePhaseMap_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, pattern_images: *const c_void, wrapped_phase_map: *const c_void, shadow_mask: *const c_void, fundamental: *const c_void) -> Result_void;
		pub fn cv_structured_light_SinusoidalPattern_unwrapPhaseMap_const__InputArrayR_const__OutputArrayR_Size_const__InputArrayR(instance: *mut c_void, wrapped_phase_map: *const c_void, unwrapped_phase_map: *const c_void, cam_size: *const core::Size, shadow_mask: *const c_void) -> Result_void;
		pub fn cv_structured_light_SinusoidalPattern_findProCamMatches_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, proj_unwrapped_phase_map: *const c_void, cam_unwrapped_phase_map: *const c_void, matches: *const c_void) -> Result_void;
		pub fn cv_structured_light_SinusoidalPattern_computeDataModulationTerm_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, pattern_images: *const c_void, data_modulation_term: *const c_void, shadow_mask: *const c_void) -> Result_void;
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropWidth_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropWidth_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropHeight_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropHeight_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropNbrOfPeriods_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropNbrOfPeriods_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropShiftValue_const(instance: *const c_void) -> f32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropShiftValue_float(instance: *mut c_void, val: f32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropMethodId_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropMethodId_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropNbrOfPixelsBetweenMarkers_const(instance: *const c_void) -> i32;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropNbrOfPixelsBetweenMarkers_int(instance: *mut c_void, val: i32);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropHorizontal_const(instance: *const c_void) -> bool;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropHorizontal_bool(instance: *mut c_void, val: bool);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropSetMarkers_const(instance: *const c_void) -> bool;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropSetMarkers_bool(instance: *mut c_void, val: bool);
		pub fn cv_structured_light_SinusoidalPattern_Params_getPropMarkersLocation_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_structured_light_SinusoidalPattern_Params_setPropMarkersLocation_vector_Point2f_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_structured_light_SinusoidalPattern_Params_Params() -> Result<*mut c_void>;
		pub fn cv_structured_light_StructuredLightPattern_generate_const__OutputArrayR(instance: *mut c_void, pattern_images: *const c_void) -> Result<bool>;
		pub fn cv_structured_light_StructuredLightPattern_decode_const_const_vector_vector_Mat__R_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(instance: *const c_void, pattern_images: *const c_void, disparity_map: *const c_void, black_images: *const c_void, white_images: *const c_void, flags: i32) -> Result<bool>;
	}
}
#[cfg(ocvrs_has_module_structured_light)]
pub use structured_light_sys::*;

#[cfg(ocvrs_has_module_superres)]
mod superres_sys {
	use super::*;

	extern "C" {
		pub fn cv_superres_createFrameSource_Camera_int(device_id: i32) -> Result<*mut c_void>;
		pub fn cv_superres_createFrameSource_Empty() -> Result<*mut c_void>;
		pub fn cv_superres_createFrameSource_Video_CUDA_const_StringR(file_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_superres_createFrameSource_Video_const_StringR(file_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_Brox_CUDA() -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_DualTVL1() -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_DualTVL1_CUDA() -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_Farneback() -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_Farneback_CUDA() -> Result<*mut c_void>;
		pub fn cv_superres_createOptFlow_PyrLK_CUDA() -> Result<*mut c_void>;
		pub fn cv_superres_createSuperResolution_BTVL1() -> Result<*mut c_void>;
		pub fn cv_superres_createSuperResolution_BTVL1_CUDA() -> Result<*mut c_void>;
		pub fn cv_superres_BroxOpticalFlow_getAlpha_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_BroxOpticalFlow_setAlpha_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_BroxOpticalFlow_getGamma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_BroxOpticalFlow_setGamma_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_BroxOpticalFlow_getScaleFactor_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_BroxOpticalFlow_setScaleFactor_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_BroxOpticalFlow_getInnerIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_BroxOpticalFlow_setInnerIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_BroxOpticalFlow_getOuterIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_BroxOpticalFlow_setOuterIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_BroxOpticalFlow_getSolverIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_BroxOpticalFlow_setSolverIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_DenseOpticalFlowExt_calc_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, flow1: *const c_void, flow2: *const c_void) -> Result_void;
		pub fn cv_superres_DenseOpticalFlowExt_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getTau_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_DualTVL1OpticalFlow_setTau_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getLambda_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_DualTVL1OpticalFlow_setLambda_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getTheta_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_DualTVL1OpticalFlow_setTheta_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getScalesNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_DualTVL1OpticalFlow_setScalesNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getWarpingsNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_DualTVL1OpticalFlow_setWarpingsNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getEpsilon_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_DualTVL1OpticalFlow_setEpsilon_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_DualTVL1OpticalFlow_setIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_DualTVL1OpticalFlow_getUseInitialFlow_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_superres_DualTVL1OpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getPyrScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_FarnebackOpticalFlow_setPyrScale_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getLevelsNumber_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_FarnebackOpticalFlow_setLevelsNumber_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getWindowSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_FarnebackOpticalFlow_setWindowSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_FarnebackOpticalFlow_setIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getPolyN_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_FarnebackOpticalFlow_setPolyN_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getPolySigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_FarnebackOpticalFlow_setPolySigma_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_FarnebackOpticalFlow_getFlags_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_FarnebackOpticalFlow_setFlags_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_FrameSource_nextFrame_const__OutputArrayR(instance: *mut c_void, frame: *const c_void) -> Result_void;
		pub fn cv_superres_FrameSource_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_superres_PyrLKOpticalFlow_getWindowSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_PyrLKOpticalFlow_setWindowSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_PyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_PyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_PyrLKOpticalFlow_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_PyrLKOpticalFlow_setIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_setInput_const_Ptr_FrameSource_R(instance: *mut c_void, frame_source: *const c_void) -> Result_void;
		pub fn cv_superres_SuperResolution_nextFrame_const__OutputArrayR(instance: *mut c_void, frame: *const c_void) -> Result_void;
		pub fn cv_superres_SuperResolution_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_superres_SuperResolution_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_superres_SuperResolution_getScale_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_SuperResolution_setScale_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_getIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_SuperResolution_setIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_getTau_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_SuperResolution_setTau_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_SuperResolution_getLambda_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_SuperResolution_setLambda_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_SuperResolution_getAlpha_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_SuperResolution_setAlpha_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_SuperResolution_getKernelSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_SuperResolution_setKernelSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_getBlurKernelSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_SuperResolution_setBlurKernelSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_getBlurSigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_superres_SuperResolution_setBlurSigma_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_superres_SuperResolution_getTemporalAreaRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_superres_SuperResolution_setTemporalAreaRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_superres_SuperResolution_getOpticalFlow_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_superres_SuperResolution_setOpticalFlow_const_Ptr_DenseOpticalFlowExt_R(instance: *mut c_void, val: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_superres)]
pub use superres_sys::*;

#[cfg(ocvrs_has_module_surface_matching)]
mod surface_matching_sys {
	use super::*;

	extern "C" {
		pub fn cv_ppf_match_3d_ICP_ICP() -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_ICP_ICP_const_int_const_float_const_float_const_int_const_int_const_int(iterations: i32, tolerence: f32, rejection_scale: f32, num_levels: i32, sample_type: i32, num_max_corr: i32) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_ICP_registerModelToScene_const_MatR_const_MatR_doubleR_Matx44dR(instance: *mut c_void, src_pc: *const c_void, dst_pc: *const c_void, residual: *mut f64, pose: *mut core::Matx44d) -> Result<i32>;
		pub fn cv_ppf_match_3d_ICP_registerModelToScene_const_MatR_const_MatR_vector_Pose3DPtr_R(instance: *mut c_void, src_pc: *const c_void, dst_pc: *const c_void, poses: *mut c_void) -> Result<i32>;
		pub fn cv_ppf_match_3d_PPF3DDetector_PPF3DDetector() -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_PPF3DDetector_PPF3DDetector_const_double_const_double_const_double(relative_sampling_step: f64, relative_distance_step: f64, num_angles: f64) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_PPF3DDetector_setSearchParams_const_double_const_double_const_bool(instance: *mut c_void, position_threshold: f64, rotation_threshold: f64, use_weighted_clustering: bool) -> Result_void;
		pub fn cv_ppf_match_3d_PPF3DDetector_trainModel_const_MatR(instance: *mut c_void, model: *const c_void) -> Result_void;
		pub fn cv_ppf_match_3d_PPF3DDetector_match_const_MatR_vector_Pose3DPtr_R_const_double_const_double(instance: *mut c_void, scene: *const c_void, results: *mut c_void, relative_scene_sample_step: f64, relative_scene_distance: f64) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_getPropAlpha_const(instance: *const c_void) -> f64;
		pub fn cv_ppf_match_3d_Pose3D_setPropAlpha_double(instance: *mut c_void, val: f64);
		pub fn cv_ppf_match_3d_Pose3D_getPropResidual_const(instance: *const c_void) -> f64;
		pub fn cv_ppf_match_3d_Pose3D_setPropResidual_double(instance: *mut c_void, val: f64);
		pub fn cv_ppf_match_3d_Pose3D_getPropModelIndex_const(instance: *const c_void) -> size_t;
		pub fn cv_ppf_match_3d_Pose3D_setPropModelIndex_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_ppf_match_3d_Pose3D_getPropNumVotes_const(instance: *const c_void) -> size_t;
		pub fn cv_ppf_match_3d_Pose3D_setPropNumVotes_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_ppf_match_3d_Pose3D_getPropPose_const(instance: *const c_void) -> core::Matx44d;
		pub fn cv_ppf_match_3d_Pose3D_setPropPose_Matx44d(instance: *mut c_void, val: *const core::Matx44d);
		pub fn cv_ppf_match_3d_Pose3D_getPropAngle_const(instance: *const c_void) -> f64;
		pub fn cv_ppf_match_3d_Pose3D_setPropAngle_double(instance: *mut c_void, val: f64);
		pub fn cv_ppf_match_3d_Pose3D_getPropT_const(instance: *const c_void) -> core::Vec3d;
		pub fn cv_ppf_match_3d_Pose3D_setPropT_Vec3d(instance: *mut c_void, val: *const core::Vec3d);
		pub fn cv_ppf_match_3d_Pose3D_getPropQ_const(instance: *const c_void) -> core::Vec4d;
		pub fn cv_ppf_match_3d_Pose3D_setPropQ_Vec4d(instance: *mut c_void, val: *const core::Vec4d);
		pub fn cv_ppf_match_3d_Pose3D_Pose3D() -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_Pose3D_Pose3D_double_size_t_size_t(alpha: f64, model_index: size_t, num_votes: size_t) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_Pose3D_updatePose_Matx44dR(instance: *mut c_void, new_pose: *mut core::Matx44d) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_updatePose_Matx33dR_Vec3dR(instance: *mut c_void, new_r: *mut core::Matx33d, new_t: *mut core::Vec3d) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_updatePoseQuat_Vec4dR_Vec3dR(instance: *mut c_void, q: *mut core::Vec4d, new_t: *mut core::Vec3d) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_appendPose_Matx44dR(instance: *mut c_void, incremental_pose: *mut core::Matx44d) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_printPose(instance: *mut c_void) -> Result_void;
		pub fn cv_ppf_match_3d_Pose3D_clone(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_Pose3D_writePose_const_stringR(instance: *mut c_void, file_name: *const c_char) -> Result<i32>;
		pub fn cv_ppf_match_3d_Pose3D_readPose_const_stringR(instance: *mut c_void, file_name: *const c_char) -> Result<i32>;
		pub fn cv_ppf_match_3d_PoseCluster3D_getPropPoseList_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_ppf_match_3d_PoseCluster3D_setPropPoseList_vector_Pose3DPtr_(instance: *mut c_void, val: *mut c_void);
		pub fn cv_ppf_match_3d_PoseCluster3D_getPropNumVotes_const(instance: *const c_void) -> size_t;
		pub fn cv_ppf_match_3d_PoseCluster3D_setPropNumVotes_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_ppf_match_3d_PoseCluster3D_getPropId_const(instance: *const c_void) -> i32;
		pub fn cv_ppf_match_3d_PoseCluster3D_setPropId_int(instance: *mut c_void, val: i32);
		pub fn cv_ppf_match_3d_PoseCluster3D_PoseCluster3D() -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_PoseCluster3D_PoseCluster3D_Pose3DPtr(new_pose: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_PoseCluster3D_PoseCluster3D_Pose3DPtr_int(new_pose: *mut c_void, new_id: i32) -> Result<*mut c_void>;
		pub fn cv_ppf_match_3d_PoseCluster3D_addPose_Pose3DPtr(instance: *mut c_void, new_pose: *mut c_void) -> Result_void;
		pub fn cv_ppf_match_3d_PoseCluster3D_writePoseCluster_const_stringR(instance: *mut c_void, file_name: *const c_char) -> Result<i32>;
		pub fn cv_ppf_match_3d_PoseCluster3D_readPoseCluster_const_stringR(instance: *mut c_void, file_name: *const c_char) -> Result<i32>;
	}
}
#[cfg(ocvrs_has_module_surface_matching)]
pub use surface_matching_sys::*;

#[cfg(ocvrs_has_module_text)]
mod text_sys {
	use super::*;

	extern "C" {
		pub fn cv_text_MSERsToERStats_const__InputArrayR_vector_vector_Point__R_vector_vector_ERStat__R(image: *const c_void, contours: *mut c_void, regions: *mut c_void) -> Result_void;
		pub fn cv_text_computeNMChannels_const__InputArrayR_const__OutputArrayR_int(_src: *const c_void, _channels: *const c_void, _mode: i32) -> Result_void;
		pub fn cv_text_createERFilterNM1_const_Ptr_Callback_R_int_float_float_float_bool_float(cb: *const c_void, threshold_delta: i32, min_area: f32, max_area: f32, min_probability: f32, non_max_suppression: bool, min_probability_diff: f32) -> Result<*mut c_void>;
		pub fn cv_text_createERFilterNM1_const_StringR_int_float_float_float_bool_float(filename: *const c_char, threshold_delta: i32, min_area: f32, max_area: f32, min_probability: f32, non_max_suppression: bool, min_probability_diff: f32) -> Result<*mut c_void>;
		pub fn cv_text_createERFilterNM2_const_Ptr_Callback_R_float(cb: *const c_void, min_probability: f32) -> Result<*mut c_void>;
		pub fn cv_text_createERFilterNM2_const_StringR_float(filename: *const c_char, min_probability: f32) -> Result<*mut c_void>;
		pub fn cv_text_createOCRHMMTransitionsTable_const_StringR_vector_String_R(vocabulary: *const c_char, lexicon: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_text_createOCRHMMTransitionsTable_stringR_vector_string_R_const__OutputArrayR(vocabulary: *mut *mut c_void, lexicon: *mut c_void, transition_probabilities_table: *const c_void) -> Result_void;
		pub fn cv_text_detectRegions_const__InputArrayR_const_Ptr_ERFilter_R_const_Ptr_ERFilter_R_vector_Rect_R_int_const_StringR_float(image: *const c_void, er_filter1: *const c_void, er_filter2: *const c_void, groups_rects: *mut c_void, method: i32, filename: *const c_char, min_probability: f32) -> Result_void;
		pub fn cv_text_detectRegions_const__InputArrayR_const_Ptr_ERFilter_R_const_Ptr_ERFilter_R_vector_vector_Point__R(image: *const c_void, er_filter1: *const c_void, er_filter2: *const c_void, regions: *mut c_void) -> Result_void;
		pub fn cv_text_detectTextSWT_const__InputArrayR_vector_Rect_R_bool_const__OutputArrayR_const__OutputArrayR(input: *const c_void, result: *mut c_void, dark_on_light: bool, draw: *const c_void, chain_b_bs: *const c_void) -> Result_void;
		pub fn cv_text_erGrouping_const__InputArrayR_const__InputArrayR_vector_vector_ERStat__R_vector_vector_Vec2i__R_vector_Rect_R_int_const_stringR_float(img: *const c_void, channels: *const c_void, regions: *mut c_void, groups: *mut c_void, groups_rects: *mut c_void, method: i32, filename: *const c_char, min_probablity: f32) -> Result_void;
		pub fn cv_text_erGrouping_const__InputArrayR_const__InputArrayR_vector_vector_Point___vector_Rect_R_int_const_StringR_float(image: *const c_void, channel: *const c_void, regions: *mut c_void, groups_rects: *mut c_void, method: i32, filename: *const c_char, min_probablity: f32) -> Result_void;
		pub fn cv_text_loadClassifierNM1_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_loadClassifierNM2_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_loadOCRBeamSearchClassifierCNN_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_loadOCRHMMClassifierCNN_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_loadOCRHMMClassifierNM_const_StringR(filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_loadOCRHMMClassifier_const_StringR_int(filename: *const c_char, classifier: i32) -> Result<*mut c_void>;
		pub fn cv_text_BaseOCR_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_BaseOCR_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, mask: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_ERFilter_run_const__InputArrayR_vector_ERStat_R(instance: *mut c_void, image: *const c_void, regions: *mut c_void) -> Result_void;
		pub fn cv_text_ERFilter_setCallback_const_Ptr_Callback_R(instance: *mut c_void, cb: *const c_void) -> Result_void;
		pub fn cv_text_ERFilter_setThresholdDelta_int(instance: *mut c_void, threshold_delta: i32) -> Result_void;
		pub fn cv_text_ERFilter_setMinArea_float(instance: *mut c_void, min_area: f32) -> Result_void;
		pub fn cv_text_ERFilter_setMaxArea_float(instance: *mut c_void, max_area: f32) -> Result_void;
		pub fn cv_text_ERFilter_setMinProbability_float(instance: *mut c_void, min_probability: f32) -> Result_void;
		pub fn cv_text_ERFilter_setMinProbabilityDiff_float(instance: *mut c_void, min_probability_diff: f32) -> Result_void;
		pub fn cv_text_ERFilter_setNonMaxSuppression_bool(instance: *mut c_void, non_max_suppression: bool) -> Result_void;
		pub fn cv_text_ERFilter_getNumRejected_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_text_ERFilter_Callback_eval_const_ERStatR(instance: *mut c_void, stat: *const c_void) -> Result<f64>;
		pub fn cv_text_ERStat_getPropPixel_const(instance: *const c_void) -> i32;
		pub fn cv_text_ERStat_setPropPixel_int(instance: *mut c_void, val: i32);
		pub fn cv_text_ERStat_getPropLevel_const(instance: *const c_void) -> i32;
		pub fn cv_text_ERStat_setPropLevel_int(instance: *mut c_void, val: i32);
		pub fn cv_text_ERStat_getPropArea_const(instance: *const c_void) -> i32;
		pub fn cv_text_ERStat_setPropArea_int(instance: *mut c_void, val: i32);
		pub fn cv_text_ERStat_getPropPerimeter_const(instance: *const c_void) -> i32;
		pub fn cv_text_ERStat_setPropPerimeter_int(instance: *mut c_void, val: i32);
		pub fn cv_text_ERStat_getPropEuler_const(instance: *const c_void) -> i32;
		pub fn cv_text_ERStat_setPropEuler_int(instance: *mut c_void, val: i32);
		pub fn cv_text_ERStat_getPropRect_const(instance: *const c_void) -> core::Rect;
		pub fn cv_text_ERStat_setPropRect_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_text_ERStat_getPropRaw_moments(instance: *mut c_void) -> *mut [f64; 2];
		pub fn cv_text_ERStat_getPropCentral_moments(instance: *mut c_void) -> *mut [f64; 3];
		pub fn cv_text_ERStat_getPropMed_crossings_const(instance: *const c_void) -> f32;
		pub fn cv_text_ERStat_setPropMed_crossings_float(instance: *mut c_void, val: f32);
		pub fn cv_text_ERStat_getPropHole_area_ratio_const(instance: *const c_void) -> f32;
		pub fn cv_text_ERStat_setPropHole_area_ratio_float(instance: *mut c_void, val: f32);
		pub fn cv_text_ERStat_getPropConvex_hull_ratio_const(instance: *const c_void) -> f32;
		pub fn cv_text_ERStat_setPropConvex_hull_ratio_float(instance: *mut c_void, val: f32);
		pub fn cv_text_ERStat_getPropNum_inflexion_points_const(instance: *const c_void) -> f32;
		pub fn cv_text_ERStat_setPropNum_inflexion_points_float(instance: *mut c_void, val: f32);
		pub fn cv_text_ERStat_getPropProbability_const(instance: *const c_void) -> f64;
		pub fn cv_text_ERStat_setPropProbability_double(instance: *mut c_void, val: f64);
		pub fn cv_text_ERStat_getPropParent(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropParent_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_getPropChild(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropChild_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_getPropNext(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropNext_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_getPropPrev(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropPrev_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_getPropLocal_maxima_const(instance: *const c_void) -> bool;
		pub fn cv_text_ERStat_setPropLocal_maxima_bool(instance: *mut c_void, val: bool);
		pub fn cv_text_ERStat_getPropMax_probability_ancestor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropMax_probability_ancestor_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_getPropMin_probability_ancestor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_text_ERStat_setPropMin_probability_ancestor_ERStatX(instance: *mut c_void, val: *mut c_void);
		pub fn cv_text_ERStat_ERStat_int_int_int_int(level: i32, pixel: i32, x: i32, y: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRBeamSearchDecoder_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRBeamSearchDecoder_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, mask: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRBeamSearchDecoder_run_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRBeamSearchDecoder_run_const__InputArrayR_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, mask: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRBeamSearchDecoder_create_const_Ptr_ClassifierCallback__const_stringR_const__InputArrayR_const__InputArrayR_decoder_mode_int(classifier: *const c_void, vocabulary: *const c_char, transition_probabilities_table: *const c_void, emission_probabilities_table: *const c_void, mode: crate::text::decoder_mode, beam_size: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRBeamSearchDecoder_create_const_StringR_const_StringR_const__InputArrayR_const__InputArrayR_decoder_mode_int(filename: *const c_char, vocabulary: *const c_char, transition_probabilities_table: *const c_void, emission_probabilities_table: *const c_void, mode: crate::text::decoder_mode, beam_size: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRBeamSearchDecoder_ClassifierCallback_eval_const__InputArrayR_vector_vector_double__R_vector_int_R(instance: *mut c_void, image: *const c_void, recognition_probabilities: *mut c_void, oversegmentation: *mut c_void) -> Result_void;
		pub fn cv_text_OCRBeamSearchDecoder_ClassifierCallback_getWindowSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_text_OCRBeamSearchDecoder_ClassifierCallback_getStepSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_text_OCRHMMDecoder_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRHMMDecoder_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, mask: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRHMMDecoder_run_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRHMMDecoder_run_const__InputArrayR_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, mask: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRHMMDecoder_create_const_Ptr_ClassifierCallback__const_StringR_const__InputArrayR_const__InputArrayR_int(classifier: *const c_void, vocabulary: *const c_char, transition_probabilities_table: *const c_void, emission_probabilities_table: *const c_void, mode: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRHMMDecoder_create_const_StringR_const_StringR_const__InputArrayR_const__InputArrayR_int_int(filename: *const c_char, vocabulary: *const c_char, transition_probabilities_table: *const c_void, emission_probabilities_table: *const c_void, mode: i32, classifier: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRHMMDecoder_ClassifierCallback_eval_const__InputArrayR_vector_int_R_vector_double_R(instance: *mut c_void, image: *const c_void, out_class: *mut c_void, out_confidence: *mut c_void) -> Result_void;
		pub fn cv_text_OCRHolisticWordRecognizer_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRHolisticWordRecognizer_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, mask: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRHolisticWordRecognizer_create_const_stringR_const_stringR_const_stringR(arch_filename: *const c_char, weights_filename: *const c_char, words_filename: *const c_char) -> Result<*mut c_void>;
		pub fn cv_text_OCRTesseract_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRTesseract_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(instance: *mut c_void, image: *mut c_void, mask: *mut c_void, output_text: *mut *mut c_void, component_rects: *mut c_void, component_texts: *mut c_void, component_confidences: *mut c_void, component_level: i32) -> Result_void;
		pub fn cv_text_OCRTesseract_run_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRTesseract_run_const__InputArrayR_const__InputArrayR_int_int(instance: *mut c_void, image: *const c_void, mask: *const c_void, min_confidence: i32, component_level: i32) -> Result<*mut c_void>;
		pub fn cv_text_OCRTesseract_setWhiteList_const_StringR(instance: *mut c_void, char_whitelist: *const c_char) -> Result_void;
		pub fn cv_text_OCRTesseract_create_const_charX_const_charX_const_charX_int_int(datapath: *const c_char, language: *const c_char, char_whitelist: *const c_char, oem: i32, psmode: i32) -> Result<*mut c_void>;
		pub fn cv_text_TextDetector_detect_const__InputArrayR_vector_Rect_R_vector_float_R(instance: *mut c_void, input_image: *const c_void, bbox: *mut c_void, confidence: *mut c_void) -> Result_void;
		pub fn cv_text_TextDetectorCNN_detect_const__InputArrayR_vector_Rect_R_vector_float_R(instance: *mut c_void, input_image: *const c_void, bbox: *mut c_void, confidence: *mut c_void) -> Result_void;
		pub fn cv_text_TextDetectorCNN_create_const_StringR_const_StringR_vector_Size_(model_arch_filename: *const c_char, model_weights_filename: *const c_char, detection_sizes: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_text_TextDetectorCNN_create_const_StringR_const_StringR(model_arch_filename: *const c_char, model_weights_filename: *const c_char) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_text)]
pub use text_sys::*;

#[cfg(ocvrs_has_module_tracking)]
mod tracking_sys {
	use super::*;

	extern "C" {
		pub fn cv_tracking_TrackerCSRT_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_tracking_TrackerCSRT_setInitialMask_const__InputArrayR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_hog_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_hog_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_color_names_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_color_names_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_gray_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_gray_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_rgb_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_rgb_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_channel_weights_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_channel_weights_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropUse_segmentation_const(instance: *const c_void) -> bool;
		pub fn cv_tracking_TrackerCSRT_Params_setPropUse_segmentation_bool(instance: *mut c_void, val: bool);
		pub fn cv_tracking_TrackerCSRT_Params_getPropWindow_function_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_tracking_TrackerCSRT_Params_setPropWindow_function_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_tracking_TrackerCSRT_Params_getPropKaiser_alpha_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropKaiser_alpha_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropCheb_attenuation_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropCheb_attenuation_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropTemplate_size_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropTemplate_size_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropGsl_sigma_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropGsl_sigma_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropHog_orientations_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropHog_orientations_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropHog_clip_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropHog_clip_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropPadding_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropPadding_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropFilter_lr_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropFilter_lr_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropWeights_lr_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropWeights_lr_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropNum_hog_channels_used_const(instance: *const c_void) -> i32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropNum_hog_channels_used_int(instance: *mut c_void, val: i32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropAdmm_iterations_const(instance: *const c_void) -> i32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropAdmm_iterations_int(instance: *mut c_void, val: i32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropHistogram_bins_const(instance: *const c_void) -> i32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropHistogram_bins_int(instance: *mut c_void, val: i32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropHistogram_lr_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropHistogram_lr_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropBackground_ratio_const(instance: *const c_void) -> i32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropBackground_ratio_int(instance: *mut c_void, val: i32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropNumber_of_scales_const(instance: *const c_void) -> i32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropNumber_of_scales_int(instance: *mut c_void, val: i32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropScale_sigma_factor_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropScale_sigma_factor_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropScale_model_max_area_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropScale_model_max_area_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropScale_lr_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropScale_lr_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropScale_step_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropScale_step_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_getPropPsr_threshold_const(instance: *const c_void) -> f32;
		pub fn cv_tracking_TrackerCSRT_Params_setPropPsr_threshold_float(instance: *mut c_void, val: f32);
		pub fn cv_tracking_TrackerCSRT_Params_Params() -> Result<*mut c_void>;
		pub fn cv_tracking_TrackerKCF_create_const_ParamsR(parameters: *const crate::tracking::TrackerKCF_Params) -> Result<*mut c_void>;
		pub fn cv_tracking_TrackerKCF_setFeatureExtractor_FeatureExtractorCallbackFN_bool(instance: *mut c_void, callback: Option<unsafe extern "C" fn(*const c_void, core::Rect, *mut c_void) -> ()>, pca_func: bool) -> Result_void;
		pub fn cv_tracking_TrackerKCF_Params_Params() -> Result<crate::tracking::TrackerKCF_Params>;
	}
}
#[cfg(ocvrs_has_module_tracking)]
pub use tracking_sys::*;

#[cfg(ocvrs_has_module_video)]
mod video_sys {
	use super::*;

	extern "C" {
		pub fn cv_CamShift_const__InputArrayR_RectR_TermCriteria(prob_image: *const c_void, window: *mut core::Rect, criteria: *const core::TermCriteria) -> Result<*mut c_void>;
		pub fn cv_buildOpticalFlowPyramid_const__InputArrayR_const__OutputArrayR_Size_int_bool_int_int_bool(img: *const c_void, pyramid: *const c_void, win_size: *const core::Size, max_level: i32, with_derivatives: bool, pyr_border: i32, deriv_border: i32, try_reuse_input_image: bool) -> Result<i32>;
		pub fn cv_calcOpticalFlowFarneback_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_double_int_int_int_int_double_int(prev: *const c_void, next: *const c_void, flow: *const c_void, pyr_scale: f64, levels: i32, winsize: i32, iterations: i32, poly_n: i32, poly_sigma: f64, flags: i32) -> Result_void;
		pub fn cv_calcOpticalFlowPyrLK_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_Size_int_TermCriteria_int_double(prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, err: *const c_void, win_size: *const core::Size, max_level: i32, criteria: *const core::TermCriteria, flags: i32, min_eig_threshold: f64) -> Result_void;
		pub fn cv_computeECC_const__InputArrayR_const__InputArrayR_const__InputArrayR(template_image: *const c_void, input_image: *const c_void, input_mask: *const c_void) -> Result<f64>;
		pub fn cv_createBackgroundSubtractorKNN_int_double_bool(history: i32, dist2_threshold: f64, detect_shadows: bool) -> Result<*mut c_void>;
		pub fn cv_createBackgroundSubtractorMOG2_int_double_bool(history: i32, var_threshold: f64, detect_shadows: bool) -> Result<*mut c_void>;
		pub fn cv_estimateRigidTransform_const__InputArrayR_const__InputArrayR_bool(src: *const c_void, dst: *const c_void, full_affine: bool) -> Result<*mut c_void>;
		pub fn cv_findTransformECC_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_int_TermCriteria_const__InputArrayR(template_image: *const c_void, input_image: *const c_void, warp_matrix: *const c_void, motion_type: i32, criteria: *const core::TermCriteria, input_mask: *const c_void) -> Result<f64>;
		pub fn cv_findTransformECC_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_int_TermCriteria_const__InputArrayR_int(template_image: *const c_void, input_image: *const c_void, warp_matrix: *const c_void, motion_type: i32, criteria: *const core::TermCriteria, input_mask: *const c_void, gauss_filt_size: i32) -> Result<f64>;
		pub fn cv_meanShift_const__InputArrayR_RectR_TermCriteria(prob_image: *const c_void, window: *mut core::Rect, criteria: *const core::TermCriteria) -> Result<i32>;
		pub fn cv_readOpticalFlow_const_StringR(path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_writeOpticalFlow_const_StringR_const__InputArrayR(path: *const c_char, flow: *const c_void) -> Result<bool>;
		pub fn cv_BackgroundSubtractor_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64) -> Result_void;
		pub fn cv_BackgroundSubtractor_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getHistory_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorKNN_setHistory_int(instance: *mut c_void, history: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getNSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorKNN_setNSamples_int(instance: *mut c_void, _n_n: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getDist2Threshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorKNN_setDist2Threshold_double(instance: *mut c_void, _dist2_threshold: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getkNNSamples_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorKNN_setkNNSamples_int(instance: *mut c_void, _nk_nn: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getDetectShadows_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_BackgroundSubtractorKNN_setDetectShadows_bool(instance: *mut c_void, detect_shadows: bool) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getShadowValue_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorKNN_setShadowValue_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorKNN_getShadowThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorKNN_setShadowThreshold_double(instance: *mut c_void, threshold: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getHistory_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorMOG2_setHistory_int(instance: *mut c_void, history: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getNMixtures_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorMOG2_setNMixtures_int(instance: *mut c_void, nmixtures: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getBackgroundRatio_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setBackgroundRatio_double(instance: *mut c_void, ratio: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getVarThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setVarThreshold_double(instance: *mut c_void, var_threshold: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getVarThresholdGen_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setVarThresholdGen_double(instance: *mut c_void, var_threshold_gen: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getVarInit_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setVarInit_double(instance: *mut c_void, var_init: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getVarMin_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setVarMin_double(instance: *mut c_void, var_min: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getVarMax_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setVarMax_double(instance: *mut c_void, var_max: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold_double(instance: *mut c_void, ct: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getDetectShadows_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_BackgroundSubtractorMOG2_setDetectShadows_bool(instance: *mut c_void, detect_shadows: bool) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getShadowValue_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_BackgroundSubtractorMOG2_setShadowValue_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_getShadowThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_BackgroundSubtractorMOG2_setShadowThreshold_double(instance: *mut c_void, threshold: f64) -> Result_void;
		pub fn cv_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64) -> Result_void;
		pub fn cv_DISOpticalFlow_getFinestScale_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DISOpticalFlow_setFinestScale_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_DISOpticalFlow_getPatchSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DISOpticalFlow_setPatchSize_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_DISOpticalFlow_getPatchStride_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DISOpticalFlow_setPatchStride_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_DISOpticalFlow_getGradientDescentIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DISOpticalFlow_setGradientDescentIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_DISOpticalFlow_getVariationalRefinementIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_DISOpticalFlow_setVariationalRefinementIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_DISOpticalFlow_getVariationalRefinementAlpha_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_DISOpticalFlow_setVariationalRefinementAlpha_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_DISOpticalFlow_getVariationalRefinementDelta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_DISOpticalFlow_setVariationalRefinementDelta_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_DISOpticalFlow_getVariationalRefinementGamma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_DISOpticalFlow_setVariationalRefinementGamma_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_DISOpticalFlow_getUseMeanNormalization_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_DISOpticalFlow_setUseMeanNormalization_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_DISOpticalFlow_getUseSpatialPropagation_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_DISOpticalFlow_setUseSpatialPropagation_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_DISOpticalFlow_create_int(preset: i32) -> Result<*mut c_void>;
		pub fn cv_DenseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow: *const c_void) -> Result_void;
		pub fn cv_DenseOpticalFlow_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getNumLevels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FarnebackOpticalFlow_setNumLevels_int(instance: *mut c_void, num_levels: i32) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getPyrScale_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_FarnebackOpticalFlow_setPyrScale_double(instance: *mut c_void, pyr_scale: f64) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getFastPyramids_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_FarnebackOpticalFlow_setFastPyramids_bool(instance: *mut c_void, fast_pyramids: bool) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getWinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FarnebackOpticalFlow_setWinSize_int(instance: *mut c_void, win_size: i32) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getNumIters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FarnebackOpticalFlow_setNumIters_int(instance: *mut c_void, num_iters: i32) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getPolyN_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FarnebackOpticalFlow_setPolyN_int(instance: *mut c_void, poly_n: i32) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getPolySigma_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_FarnebackOpticalFlow_setPolySigma_double(instance: *mut c_void, poly_sigma: f64) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_getFlags_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_FarnebackOpticalFlow_setFlags_int(instance: *mut c_void, flags: i32) -> Result_void;
		pub fn cv_FarnebackOpticalFlow_create_int_double_bool_int_int_int_double_int(num_levels: i32, pyr_scale: f64, fast_pyramids: bool, win_size: i32, num_iters: i32, poly_n: i32, poly_sigma: f64, flags: i32) -> Result<*mut c_void>;
		pub fn cv_KalmanFilter_getPropStatePre_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropStatePre_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropStatePost_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropStatePost_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTransitionMatrix_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTransitionMatrix_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropControlMatrix_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropControlMatrix_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropMeasurementMatrix_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropMeasurementMatrix_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropProcessNoiseCov_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropProcessNoiseCov_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropMeasurementNoiseCov_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropMeasurementNoiseCov_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropErrorCovPre_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropErrorCovPre_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropGain_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropGain_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropErrorCovPost_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropErrorCovPost_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTemp1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTemp1_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTemp2_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTemp2_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTemp3_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTemp3_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTemp4_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTemp4_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_getPropTemp5_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KalmanFilter_setPropTemp5_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_KalmanFilter_KalmanFilter() -> Result<*mut c_void>;
		pub fn cv_KalmanFilter_KalmanFilter_int_int_int_int(dynam_params: i32, measure_params: i32, control_params: i32, typ: i32) -> Result<*mut c_void>;
		pub fn cv_KalmanFilter_init_int_int_int_int(instance: *mut c_void, dynam_params: i32, measure_params: i32, control_params: i32, typ: i32) -> Result_void;
		pub fn cv_KalmanFilter_predict_const_MatR(instance: *mut c_void, control: *const c_void) -> Result<*mut c_void>;
		pub fn cv_KalmanFilter_correct_const_MatR(instance: *mut c_void, measurement: *const c_void) -> Result<*mut c_void>;
		pub fn cv_SparseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, err: *const c_void) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_getWinSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_SparsePyrLKOpticalFlow_setWinSize_Size(instance: *mut c_void, win_size: *const core::Size) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_SparsePyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, max_level: i32) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_getTermCriteria_const(instance: *const c_void) -> Result<core::TermCriteria>;
		pub fn cv_SparsePyrLKOpticalFlow_setTermCriteria_TermCriteriaR(instance: *mut c_void, crit: *mut core::TermCriteria) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_getFlags_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_SparsePyrLKOpticalFlow_setFlags_int(instance: *mut c_void, flags: i32) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_getMinEigThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_SparsePyrLKOpticalFlow_setMinEigThreshold_double(instance: *mut c_void, min_eig_threshold: f64) -> Result_void;
		pub fn cv_SparsePyrLKOpticalFlow_create_Size_int_TermCriteria_int_double(win_size: *const core::Size, max_level: i32, crit: *const core::TermCriteria, flags: i32, min_eig_threshold: f64) -> Result<*mut c_void>;
		pub fn cv_Tracker_init_const__InputArrayR_const_RectR(instance: *mut c_void, image: *const c_void, bounding_box: *const core::Rect) -> Result_void;
		pub fn cv_Tracker_update_const__InputArrayR_RectR(instance: *mut c_void, image: *const c_void, bounding_box: *mut core::Rect) -> Result<bool>;
		pub fn cv_TrackerDaSiamRPN_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_TrackerDaSiamRPN_getTrackingScore(instance: *mut c_void) -> Result<f32>;
		pub fn cv_TrackerDaSiamRPN_Params_getPropModel_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_TrackerDaSiamRPN_Params_setPropModel_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_TrackerDaSiamRPN_Params_getPropKernel_cls1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_TrackerDaSiamRPN_Params_setPropKernel_cls1_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_TrackerDaSiamRPN_Params_getPropKernel_r1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_TrackerDaSiamRPN_Params_setPropKernel_r1_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_TrackerDaSiamRPN_Params_getPropBackend_const(instance: *const c_void) -> i32;
		pub fn cv_TrackerDaSiamRPN_Params_setPropBackend_int(instance: *mut c_void, val: i32);
		pub fn cv_TrackerDaSiamRPN_Params_getPropTarget_const(instance: *const c_void) -> i32;
		pub fn cv_TrackerDaSiamRPN_Params_setPropTarget_int(instance: *mut c_void, val: i32);
		pub fn cv_TrackerDaSiamRPN_Params_Params() -> Result<*mut c_void>;
		pub fn cv_TrackerGOTURN_create_const_ParamsR(parameters: *const c_void) -> Result<*mut c_void>;
		pub fn cv_TrackerGOTURN_Params_getPropModelTxt_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_TrackerGOTURN_Params_setPropModelTxt_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_TrackerGOTURN_Params_getPropModelBin_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_TrackerGOTURN_Params_setPropModelBin_string(instance: *mut c_void, val: *mut c_char);
		pub fn cv_TrackerGOTURN_Params_Params() -> Result<*mut c_void>;
		pub fn cv_TrackerMIL_create_const_ParamsR(parameters: *const crate::video::TrackerMIL_Params) -> Result<*mut c_void>;
		pub fn cv_TrackerMIL_Params_Params() -> Result<crate::video::TrackerMIL_Params>;
		pub fn cv_VariationalRefinement_calcUV_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow_u: *const c_void, flow_v: *const c_void) -> Result_void;
		pub fn cv_VariationalRefinement_getFixedPointIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_VariationalRefinement_setFixedPointIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_VariationalRefinement_getSorIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_VariationalRefinement_setSorIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_VariationalRefinement_getOmega_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_VariationalRefinement_setOmega_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_VariationalRefinement_getAlpha_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_VariationalRefinement_setAlpha_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_VariationalRefinement_getDelta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_VariationalRefinement_setDelta_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_VariationalRefinement_getGamma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_VariationalRefinement_setGamma_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_VariationalRefinement_create() -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_video)]
pub use video_sys::*;

#[cfg(ocvrs_has_module_videoio)]
mod videoio_sys {
	use super::*;

	extern "C" {
		pub fn cv_videoio_registry_getBackendName_VideoCaptureAPIs(api: crate::videoio::VideoCaptureAPIs) -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getBackends() -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getCameraBackendPluginVersion_VideoCaptureAPIs_intR_intR(api: crate::videoio::VideoCaptureAPIs, version_abi: *mut i32, version_api: *mut i32) -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getCameraBackends() -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getStreamBackendPluginVersion_VideoCaptureAPIs_intR_intR(api: crate::videoio::VideoCaptureAPIs, version_abi: *mut i32, version_api: *mut i32) -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getStreamBackends() -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getWriterBackendPluginVersion_VideoCaptureAPIs_intR_intR(api: crate::videoio::VideoCaptureAPIs, version_abi: *mut i32, version_api: *mut i32) -> Result<*mut c_void>;
		pub fn cv_videoio_registry_getWriterBackends() -> Result<*mut c_void>;
		pub fn cv_videoio_registry_hasBackend_VideoCaptureAPIs(api: crate::videoio::VideoCaptureAPIs) -> Result<bool>;
		pub fn cv_videoio_registry_isBackendBuiltIn_VideoCaptureAPIs(api: crate::videoio::VideoCaptureAPIs) -> Result<bool>;
		pub fn cv_VideoCapture_VideoCapture() -> Result<*mut c_void>;
		pub fn cv_VideoCapture_VideoCapture_const_StringR_int(filename: *const c_char, api_preference: i32) -> Result<*mut c_void>;
		pub fn cv_VideoCapture_VideoCapture_const_StringR_int_const_vector_int_R(filename: *const c_char, api_preference: i32, params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_VideoCapture_VideoCapture_int_int(index: i32, api_preference: i32) -> Result<*mut c_void>;
		pub fn cv_VideoCapture_VideoCapture_int_int_const_vector_int_R(index: i32, api_preference: i32, params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_VideoCapture_open_const_StringR_int(instance: *mut c_void, filename: *const c_char, api_preference: i32) -> Result<bool>;
		pub fn cv_VideoCapture_open_const_StringR_int_const_vector_int_R(instance: *mut c_void, filename: *const c_char, api_preference: i32, params: *const c_void) -> Result<bool>;
		pub fn cv_VideoCapture_open_int_int(instance: *mut c_void, index: i32, api_preference: i32) -> Result<bool>;
		pub fn cv_VideoCapture_open_int_int_const_vector_int_R(instance: *mut c_void, index: i32, api_preference: i32, params: *const c_void) -> Result<bool>;
		pub fn cv_VideoCapture_isOpened_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_VideoCapture_release(instance: *mut c_void) -> Result_void;
		pub fn cv_VideoCapture_grab(instance: *mut c_void) -> Result<bool>;
		pub fn cv_VideoCapture_retrieve_const__OutputArrayR_int(instance: *mut c_void, image: *const c_void, flag: i32) -> Result<bool>;
		pub fn cv_VideoCapture_read_const__OutputArrayR(instance: *mut c_void, image: *const c_void) -> Result<bool>;
		pub fn cv_VideoCapture_set_int_double(instance: *mut c_void, prop_id: i32, value: f64) -> Result<bool>;
		pub fn cv_VideoCapture_get_const_int(instance: *const c_void, prop_id: i32) -> Result<f64>;
		pub fn cv_VideoCapture_getBackendName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_VideoCapture_setExceptionMode_bool(instance: *mut c_void, enable: bool) -> Result_void;
		pub fn cv_VideoCapture_getExceptionMode(instance: *mut c_void) -> Result<bool>;
		pub fn cv_VideoCapture_waitAny_const_vector_VideoCapture_R_vector_int_R_int64_t(streams: *const c_void, ready_index: *mut c_void, timeout_ns: i64) -> Result<bool>;
		pub fn cv_VideoWriter_VideoWriter() -> Result<*mut c_void>;
		pub fn cv_VideoWriter_VideoWriter_const_StringR_int_double_Size_bool(filename: *const c_char, fourcc: i32, fps: f64, frame_size: *const core::Size, is_color: bool) -> Result<*mut c_void>;
		pub fn cv_VideoWriter_VideoWriter_const_StringR_int_int_double_Size_bool(filename: *const c_char, api_preference: i32, fourcc: i32, fps: f64, frame_size: *const core::Size, is_color: bool) -> Result<*mut c_void>;
		pub fn cv_VideoWriter_VideoWriter_const_StringR_int_double_const_SizeR_const_vector_int_R(filename: *const c_char, fourcc: i32, fps: f64, frame_size: *const core::Size, params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_VideoWriter_VideoWriter_const_StringR_int_int_double_const_SizeR_const_vector_int_R(filename: *const c_char, api_preference: i32, fourcc: i32, fps: f64, frame_size: *const core::Size, params: *const c_void) -> Result<*mut c_void>;
		pub fn cv_VideoWriter_open_const_StringR_int_double_Size_bool(instance: *mut c_void, filename: *const c_char, fourcc: i32, fps: f64, frame_size: *const core::Size, is_color: bool) -> Result<bool>;
		pub fn cv_VideoWriter_open_const_StringR_int_int_double_Size_bool(instance: *mut c_void, filename: *const c_char, api_preference: i32, fourcc: i32, fps: f64, frame_size: *const core::Size, is_color: bool) -> Result<bool>;
		pub fn cv_VideoWriter_open_const_StringR_int_double_const_SizeR_const_vector_int_R(instance: *mut c_void, filename: *const c_char, fourcc: i32, fps: f64, frame_size: *const core::Size, params: *const c_void) -> Result<bool>;
		pub fn cv_VideoWriter_open_const_StringR_int_int_double_const_SizeR_const_vector_int_R(instance: *mut c_void, filename: *const c_char, api_preference: i32, fourcc: i32, fps: f64, frame_size: *const core::Size, params: *const c_void) -> Result<bool>;
		pub fn cv_VideoWriter_isOpened_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_VideoWriter_release(instance: *mut c_void) -> Result_void;
		pub fn cv_VideoWriter_write_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result_void;
		pub fn cv_VideoWriter_set_int_double(instance: *mut c_void, prop_id: i32, value: f64) -> Result<bool>;
		pub fn cv_VideoWriter_get_const_int(instance: *const c_void, prop_id: i32) -> Result<f64>;
		pub fn cv_VideoWriter_fourcc_char_char_char_char(c1: i8, c2: i8, c3: i8, c4: i8) -> Result<i32>;
		pub fn cv_VideoWriter_getBackendName_const(instance: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_videoio)]
pub use videoio_sys::*;

#[cfg(ocvrs_has_module_videostab)]
mod videostab_sys {
	use super::*;

	extern "C" {
		pub fn cv_videostab_calcBlurriness_const_MatR(frame: *const c_void) -> Result<f32>;
		pub fn cv_videostab_calcFlowMask_const_MatR_const_MatR_const_MatR_float_const_MatR_const_MatR_MatR(flow_x: *const c_void, flow_y: *const c_void, errors: *const c_void, max_error: f32, mask0: *const c_void, mask1: *const c_void, flow_mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_completeFrameAccordingToFlow_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_float_MatR_MatR(flow_mask: *const c_void, flow_x: *const c_void, flow_y: *const c_void, frame1: *const c_void, mask1: *const c_void, dist_thresh: f32, frame0: *mut c_void, mask0: *mut c_void) -> Result_void;
		pub fn cv_videostab_ensureInclusionConstraint_const_MatR_Size_float(m: *const c_void, size: *const core::Size, trim_ratio: f32) -> Result<*mut c_void>;
		pub fn cv_videostab_estimateGlobalMotionLeastSquares_const__InputOutputArrayR_const__InputOutputArrayR_int_floatX(points0: *const c_void, points1: *const c_void, model: i32, rmse: *mut f32) -> Result<*mut c_void>;
		pub fn cv_videostab_estimateGlobalMotionRansac_const__InputArrayR_const__InputArrayR_int_const_RansacParamsR_floatX_intX(points0: *const c_void, points1: *const c_void, model: i32, params: *const c_void, rmse: *mut f32, ninliers: *mut i32) -> Result<*mut c_void>;
		pub fn cv_videostab_estimateOptimalTrimRatio_const_MatR_Size(m: *const c_void, size: *const core::Size) -> Result<f32>;
		pub fn cv_videostab_getMotion_int_int_const_vector_Mat_R(from: i32, to: i32, motions: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_ColorAverageInpainter_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_ColorInpainter_ColorInpainter_int_double(method: i32, radius: f64) -> Result<*mut c_void>;
		pub fn cv_videostab_ColorInpainter_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_ConsistentMosaicInpainter_ConsistentMosaicInpainter() -> Result<*mut c_void>;
		pub fn cv_videostab_ConsistentMosaicInpainter_setStdevThresh_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_ConsistentMosaicInpainter_stdevThresh_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_ConsistentMosaicInpainter_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_DeblurerBase_setRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_DeblurerBase_radius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_DeblurerBase_deblur_int_MatR_const_RangeR(instance: *mut c_void, idx: i32, frame: *mut c_void, range: *const c_void) -> Result_void;
		pub fn cv_videostab_DeblurerBase_setFrames_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_DeblurerBase_frames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_DeblurerBase_setMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_DeblurerBase_motions_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_DeblurerBase_setBlurrinessRates_const_vector_float_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_DeblurerBase_blurrinessRates_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_DensePyrLkOptFlowEstimatorGpu_DensePyrLkOptFlowEstimatorGpu() -> Result<*mut c_void>;
		pub fn cv_videostab_DensePyrLkOptFlowEstimatorGpu_run_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, flow_x: *const c_void, flow_y: *const c_void, errors: *const c_void) -> Result_void;
		pub fn cv_videostab_FastMarchingMethod_FastMarchingMethod() -> Result<*mut c_void>;
		pub fn cv_videostab_FastMarchingMethod_distanceMap_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_FromFileMotionReader_FromFileMotionReader_const_StringR(path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_videostab_FromFileMotionReader_estimate_const_MatR_const_MatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_GaussianMotionFilter_GaussianMotionFilter_int_float(radius: i32, stdev: f32) -> Result<*mut c_void>;
		pub fn cv_videostab_GaussianMotionFilter_setParams_int_float(instance: *mut c_void, radius: i32, stdev: f32) -> Result_void;
		pub fn cv_videostab_GaussianMotionFilter_radius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_GaussianMotionFilter_stdev_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_GaussianMotionFilter_stabilize_int_const_vector_Mat_R_const_RangeR(instance: *mut c_void, idx: i32, motions: *const c_void, range: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_IDenseOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, flow_x: *const c_void, flow_y: *const c_void, errors: *const c_void) -> Result_void;
		pub fn cv_videostab_IFrameSource_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_IFrameSource_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_ILog_print_const_charX(instance: *mut c_void, format: *const c_char) -> Result_void;
		pub fn cv_videostab_IMotionStabilizer_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(instance: *mut c_void, size: i32, motions: *const c_void, range: *const c_void, stabilization_motions: *mut c_void) -> Result_void;
		pub fn cv_videostab_IOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, frame_size: *const core::Size, points0: *const c_void, points1: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_ISparseOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, points0: *const c_void, points1: *const c_void, status: *const c_void, errors: *const c_void) -> Result_void;
		pub fn cv_videostab_ImageMotionEstimatorBase_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_ImageMotionEstimatorBase_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_ImageMotionEstimatorBase_setFrameMask_const__InputArrayR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_ImageMotionEstimatorBase_estimate_const_MatR_const_MatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_InpainterBase_setRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_InpainterBase_radius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_InpainterBase_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_InpainterBase_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_InpainterBase_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_InpainterBase_setFrames_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpainterBase_frames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_InpainterBase_setMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpainterBase_motions_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_InpainterBase_setStabilizedFrames_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpainterBase_stabilizedFrames_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_InpainterBase_setStabilizationMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpainterBase_stabilizationMotions_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_InpaintingPipeline_pushBack_Ptr_InpainterBase_(instance: *mut c_void, inpainter: *mut c_void) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_videostab_InpaintingPipeline_setRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_setFrames_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_setMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_setStabilizedFrames_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_setStabilizationMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_InpaintingPipeline_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_KeypointBasedMotionEstimator_Ptr_MotionEstimatorBase_(estimator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_setDetector_Ptr_Feature2D_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_detector_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_setOpticalFlowEstimator_Ptr_ISparseOptFlowEstimator_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_opticalFlowEstimator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_setOutlierRejector_Ptr_IOutlierRejector_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_outlierRejector_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_setFrameMask_const__InputArrayR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimator_estimate_const_MatR_const_MatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimator_estimate_const__InputArrayR_const__InputArrayR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_KeypointBasedMotionEstimatorGpu_Ptr_MotionEstimatorBase_(estimator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_setOutlierRejector_Ptr_IOutlierRejector_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_outlierRejector_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_estimate_const_MatR_const_MatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_KeypointBasedMotionEstimatorGpu_estimate_const_GpuMatR_const_GpuMatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_LogToStdout_print_const_charX(instance: *mut c_void, format: *const c_char) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_LpMotionStabilizer_MotionModel(model: crate::videostab::MotionModel) -> Result<*mut c_void>;
		pub fn cv_videostab_LpMotionStabilizer_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_LpMotionStabilizer_setFrameSize_Size(instance: *mut c_void, val: *const core::Size) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_frameSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_videostab_LpMotionStabilizer_setTrimRatio_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_trimRatio_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_LpMotionStabilizer_setWeight1_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_weight1_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_LpMotionStabilizer_setWeight2_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_weight2_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_LpMotionStabilizer_setWeight3_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_weight3_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_LpMotionStabilizer_setWeight4_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_LpMotionStabilizer_weight4_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_LpMotionStabilizer_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(instance: *mut c_void, size: i32, motions: *const c_void, range: *const c_void, stabilization_motions: *mut c_void) -> Result_void;
		pub fn cv_videostab_MaskFrameSource_MaskFrameSource_const_Ptr_IFrameSource_R(source: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_MaskFrameSource_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_MaskFrameSource_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_MoreAccurateMotionWobbleSuppressor_suppress_int_const_MatR_MatR(instance: *mut c_void, idx: i32, frame: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_videostab_MoreAccurateMotionWobbleSuppressorBase_setPeriod_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_MoreAccurateMotionWobbleSuppressorBase_period_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_MoreAccurateMotionWobbleSuppressorGpu_suppress_int_const_GpuMatR_GpuMatR(instance: *mut c_void, idx: i32, frame: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_videostab_MoreAccurateMotionWobbleSuppressorGpu_suppress_int_const_MatR_MatR(instance: *mut c_void, idx: i32, frame: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_videostab_MotionEstimatorBase_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_MotionEstimatorBase_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_MotionEstimatorBase_estimate_const__InputArrayR_const__InputArrayR_boolX(instance: *mut c_void, points0: *const c_void, points1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionEstimatorL1_MotionEstimatorL1_MotionModel(model: crate::videostab::MotionModel) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionEstimatorL1_estimate_const__InputArrayR_const__InputArrayR_boolX(instance: *mut c_void, points0: *const c_void, points1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionEstimatorRansacL2_MotionEstimatorRansacL2_MotionModel(model: crate::videostab::MotionModel) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionEstimatorRansacL2_setRansacParams_const_RansacParamsR(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_MotionEstimatorRansacL2_ransacParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionEstimatorRansacL2_setMinInlierRatio_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_MotionEstimatorRansacL2_minInlierRatio_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_MotionEstimatorRansacL2_estimate_const__InputArrayR_const__InputArrayR_boolX(instance: *mut c_void, points0: *const c_void, points1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionFilterBase_stabilize_int_const_vector_Mat_R_const_RangeR(instance: *mut c_void, idx: i32, motions: *const c_void, range: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionFilterBase_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(instance: *mut c_void, size: i32, motions: *const c_void, range: *const c_void, stabilization_motions: *mut c_void) -> Result_void;
		pub fn cv_videostab_MotionInpainter_MotionInpainter() -> Result<*mut c_void>;
		pub fn cv_videostab_MotionInpainter_setOptFlowEstimator_Ptr_IDenseOptFlowEstimator_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_MotionInpainter_optFlowEstimator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_MotionInpainter_setFlowErrorThreshold_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_MotionInpainter_flowErrorThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_MotionInpainter_setDistThreshold_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_MotionInpainter_distThresh_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_MotionInpainter_setBorderMode_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_MotionInpainter_borderMode_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_MotionInpainter_inpaint_int_MatR_MatR(instance: *mut c_void, idx: i32, frame: *mut c_void, mask: *mut c_void) -> Result_void;
		pub fn cv_videostab_MotionStabilizationPipeline_pushBack_Ptr_IMotionStabilizer_(instance: *mut c_void, stabilizer: *mut c_void) -> Result_void;
		pub fn cv_videostab_MotionStabilizationPipeline_empty_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_videostab_MotionStabilizationPipeline_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(instance: *mut c_void, size: i32, motions: *const c_void, range: *const c_void, stabilization_motions: *mut c_void) -> Result_void;
		pub fn cv_videostab_NullDeblurer_deblur_int_MatR_const_RangeR(instance: *mut c_void, unnamed: i32, unnamed_1: *mut c_void, unnamed_2: *const c_void) -> Result_void;
		pub fn cv_videostab_NullFrameSource_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_NullFrameSource_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_NullInpainter_inpaint_int_MatR_MatR(instance: *mut c_void, unnamed: i32, unnamed_1: *mut c_void, unnamed_2: *mut c_void) -> Result_void;
		pub fn cv_videostab_NullLog_print_const_charX(instance: *mut c_void, unnamed: *const c_char) -> Result_void;
		pub fn cv_videostab_NullOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, frame_size: *const core::Size, points0: *const c_void, points1: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_NullWobbleSuppressor_suppress_int_const_MatR_MatR(instance: *mut c_void, idx: i32, frame: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_videostab_OnePassStabilizer_OnePassStabilizer() -> Result<*mut c_void>;
		pub fn cv_videostab_OnePassStabilizer_setMotionFilter_Ptr_MotionFilterBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_OnePassStabilizer_motionFilter_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_OnePassStabilizer_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_OnePassStabilizer_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_PyrLkOptFlowEstimatorBase_PyrLkOptFlowEstimatorBase() -> Result<*mut c_void>;
		pub fn cv_videostab_PyrLkOptFlowEstimatorBase_setWinSize_Size(instance: *mut c_void, val: *const core::Size) -> Result_void;
		pub fn cv_videostab_PyrLkOptFlowEstimatorBase_winSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_videostab_PyrLkOptFlowEstimatorBase_setMaxLevel_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_PyrLkOptFlowEstimatorBase_maxLevel_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_RansacParams_getPropSize_const(instance: *const c_void) -> i32;
		pub fn cv_videostab_RansacParams_setPropSize_int(instance: *mut c_void, val: i32);
		pub fn cv_videostab_RansacParams_getPropThresh_const(instance: *const c_void) -> f32;
		pub fn cv_videostab_RansacParams_setPropThresh_float(instance: *mut c_void, val: f32);
		pub fn cv_videostab_RansacParams_getPropEps_const(instance: *const c_void) -> f32;
		pub fn cv_videostab_RansacParams_setPropEps_float(instance: *mut c_void, val: f32);
		pub fn cv_videostab_RansacParams_getPropProb_const(instance: *const c_void) -> f32;
		pub fn cv_videostab_RansacParams_setPropProb_float(instance: *mut c_void, val: f32);
		pub fn cv_videostab_RansacParams_RansacParams() -> Result<*mut c_void>;
		pub fn cv_videostab_RansacParams_RansacParams_int_float_float_float(size: i32, thresh: f32, eps: f32, prob: f32) -> Result<*mut c_void>;
		pub fn cv_videostab_RansacParams_niters_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_RansacParams_default2dMotion_MotionModel(model: crate::videostab::MotionModel) -> Result<*mut c_void>;
		pub fn cv_videostab_SparsePyrLkOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, points0: *const c_void, points1: *const c_void, status: *const c_void, errors: *const c_void) -> Result_void;
		pub fn cv_videostab_SparsePyrLkOptFlowEstimatorGpu_SparsePyrLkOptFlowEstimatorGpu() -> Result<*mut c_void>;
		pub fn cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, points0: *const c_void, points1: *const c_void, status: *const c_void, errors: *const c_void) -> Result_void;
		pub fn cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const_GpuMatR_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR_GpuMatR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, points0: *const c_void, points1: *mut c_void, status: *mut c_void, errors: *mut c_void) -> Result_void;
		pub fn cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const_GpuMatR_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, points0: *const c_void, points1: *mut c_void, status: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_setLog_Ptr_ILog_(instance: *mut c_void, ilog: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_log_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_StabilizerBase_setRadius_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_StabilizerBase_radius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_StabilizerBase_setFrameSource_Ptr_IFrameSource_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_frameSource_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_StabilizerBase_setMaskSource_const_Ptr_IFrameSource_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_maskSource_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_StabilizerBase_setMotionEstimator_Ptr_ImageMotionEstimatorBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_motionEstimator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_StabilizerBase_setDeblurer_Ptr_DeblurerBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_deblurrer_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_StabilizerBase_setTrimRatio_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_StabilizerBase_trimRatio_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_StabilizerBase_setCorrectionForInclusion_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_videostab_StabilizerBase_doCorrectionForInclusion_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_videostab_StabilizerBase_setBorderMode_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_StabilizerBase_borderMode_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_StabilizerBase_setInpainter_Ptr_InpainterBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_StabilizerBase_inpainter_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_ToFileMotionWriter_ToFileMotionWriter_const_StringR_Ptr_ImageMotionEstimatorBase_(path: *const c_char, estimator: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_ToFileMotionWriter_setMotionModel_MotionModel(instance: *mut c_void, val: crate::videostab::MotionModel) -> Result_void;
		pub fn cv_videostab_ToFileMotionWriter_motionModel_const(instance: *const c_void) -> Result<crate::videostab::MotionModel>;
		pub fn cv_videostab_ToFileMotionWriter_setFrameMask_const__InputArrayR(instance: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_ToFileMotionWriter_estimate_const_MatR_const_MatR_boolX(instance: *mut c_void, frame0: *const c_void, frame1: *const c_void, ok: *mut bool) -> Result<*mut c_void>;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_TranslationBasedLocalOutlierRejector() -> Result<*mut c_void>;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_setCellSize_Size(instance: *mut c_void, val: *const core::Size) -> Result_void;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_cellSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_setRansacParams_RansacParams(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_ransacParams_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_TranslationBasedLocalOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, frame_size: *const core::Size, points0: *const c_void, points1: *const c_void, mask: *const c_void) -> Result_void;
		pub fn cv_videostab_TwoPassStabilizer_TwoPassStabilizer() -> Result<*mut c_void>;
		pub fn cv_videostab_TwoPassStabilizer_setMotionStabilizer_Ptr_IMotionStabilizer_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_TwoPassStabilizer_motionStabilizer_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_TwoPassStabilizer_setWobbleSuppressor_Ptr_WobbleSuppressorBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_TwoPassStabilizer_wobbleSuppressor_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_TwoPassStabilizer_setEstimateTrimRatio_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_videostab_TwoPassStabilizer_mustEstimateTrimaRatio_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_videostab_TwoPassStabilizer_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_TwoPassStabilizer_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_VideoFileSource_VideoFileSource_const_StringR_bool(path: *const c_char, volatile_frame: bool) -> Result<*mut c_void>;
		pub fn cv_videostab_VideoFileSource_reset(instance: *mut c_void) -> Result_void;
		pub fn cv_videostab_VideoFileSource_nextFrame(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_VideoFileSource_width(instance: *mut c_void) -> Result<i32>;
		pub fn cv_videostab_VideoFileSource_height(instance: *mut c_void) -> Result<i32>;
		pub fn cv_videostab_VideoFileSource_count(instance: *mut c_void) -> Result<i32>;
		pub fn cv_videostab_VideoFileSource_fps(instance: *mut c_void) -> Result<f64>;
		pub fn cv_videostab_WeightingDeblurer_WeightingDeblurer() -> Result<*mut c_void>;
		pub fn cv_videostab_WeightingDeblurer_setSensitivity_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_videostab_WeightingDeblurer_sensitivity_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_videostab_WeightingDeblurer_deblur_int_MatR_const_RangeR(instance: *mut c_void, idx: i32, frame: *mut c_void, range: *const c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_setMotionEstimator_Ptr_ImageMotionEstimatorBase_(instance: *mut c_void, val: *mut c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_motionEstimator_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_WobbleSuppressorBase_suppress_int_const_MatR_MatR(instance: *mut c_void, idx: i32, frame: *const c_void, result: *mut c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_setFrameCount_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_frameCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_videostab_WobbleSuppressorBase_setMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_motions_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_WobbleSuppressorBase_setMotions2_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_motions2_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_videostab_WobbleSuppressorBase_setStabilizationMotions_const_vector_Mat_R(instance: *mut c_void, val: *const c_void) -> Result_void;
		pub fn cv_videostab_WobbleSuppressorBase_stabilizationMotions_const(instance: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_videostab)]
pub use videostab_sys::*;

#[cfg(ocvrs_has_module_viz)]
mod viz_sys {
	use super::*;

	extern "C" {
		pub fn cv_viz_computeNormals_const_MeshR_const__OutputArrayR(mesh: *const c_void, normals: *const c_void) -> Result_void;
		pub fn cv_viz_getWindowByName_const_StringR(window_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_viz_imshow_const_StringR_const__InputArrayR_const_SizeR(window_name: *const c_char, image: *const c_void, window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_makeCameraPose_const_Vec3dR_const_Vec3dR_const_Vec3dR(position: *const core::Vec3d, focal_point: *const core::Vec3d, y_dir: *const core::Vec3d) -> Result<core::Affine3d>;
		pub fn cv_viz_makeTransformToGlobal_const_Vec3dR_const_Vec3dR_const_Vec3dR_const_Vec3dR(axis_x: *const core::Vec3d, axis_y: *const core::Vec3d, axis_z: *const core::Vec3d, origin: *const core::Vec3d) -> Result<core::Affine3d>;
		pub fn cv_viz_readCloud_const_StringR_const__OutputArrayR_const__OutputArrayR(file: *const c_char, colors: *const c_void, normals: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_readMesh_const_StringR(file: *const c_char) -> Result<*mut c_void>;
		pub fn cv_viz_readPose_const_StringR_Affine3dR_const_StringR(file: *const c_char, pose: *mut core::Affine3d, tag: *const c_char) -> Result<bool>;
		pub fn cv_viz_readTrajectory_const__OutputArrayR_const_StringR_int_int_const_StringR(traj: *const c_void, files_format: *const c_char, start: i32, end: i32, tag: *const c_char) -> Result_void;
		pub fn cv_viz_unregisterAllWindows() -> Result_void;
		pub fn cv_viz_writeCloud_const_StringR_const__InputArrayR_const__InputArrayR_const__InputArrayR_bool(file: *const c_char, cloud: *const c_void, colors: *const c_void, normals: *const c_void, binary: bool) -> Result_void;
		pub fn cv_viz_writePose_const_StringR_const_Affine3dR_const_StringR(file: *const c_char, pose: *const core::Affine3d, tag: *const c_char) -> Result_void;
		pub fn cv_viz_writeTrajectory_const__InputArrayR_const_StringR_int_const_StringR(traj: *const c_void, files_format: *const c_char, start: i32, tag: *const c_char) -> Result_void;
		pub fn cv_viz_Camera_Camera_double_double_double_double_const_SizeR(fx: f64, fy: f64, cx: f64, cy: f64, window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_Camera_Camera_const_Vec2dR_const_SizeR(fov: *const core::Vec2d, window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_Camera_Camera_const_Matx33dR_const_SizeR(k: *const core::Matx33d, window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_Camera_Camera_const_Matx44dR_const_SizeR(proj: *const core::Matx44d, window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_Camera_getClip_const(instance: *const c_void) -> Result<core::Vec2d>;
		pub fn cv_viz_Camera_setClip_const_Vec2dR(instance: *mut c_void, clip: *const core::Vec2d) -> Result_void;
		pub fn cv_viz_Camera_getWindowSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_viz_Camera_setWindowSize_const_SizeR(instance: *mut c_void, window_size: *const core::Size) -> Result_void;
		pub fn cv_viz_Camera_getFov_const(instance: *const c_void) -> Result<core::Vec2d>;
		pub fn cv_viz_Camera_setFov_const_Vec2dR(instance: *mut c_void, fov: *const core::Vec2d) -> Result_void;
		pub fn cv_viz_Camera_getPrincipalPoint_const(instance: *const c_void) -> Result<core::Vec2d>;
		pub fn cv_viz_Camera_getFocalLength_const(instance: *const c_void) -> Result<core::Vec2d>;
		pub fn cv_viz_Camera_computeProjectionMatrix_const_Matx44dR(instance: *const c_void, proj: *mut core::Matx44d) -> Result_void;
		pub fn cv_viz_Camera_KinectCamera_const_SizeR(window_size: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_viz_Color_Color() -> Result<*mut c_void>;
		pub fn cv_viz_Color_Color_double(gray: f64) -> Result<*mut c_void>;
		pub fn cv_viz_Color_Color_double_double_double(blue: f64, green: f64, red: f64) -> Result<*mut c_void>;
		pub fn cv_viz_Color_Color_const_ScalarR(color: *const core::Scalar) -> Result<*mut c_void>;
		pub fn cv_viz_Color_operator_cv_Vec3b_const(instance: *const c_void) -> Result<core::Vec3b>;
		pub fn cv_viz_Color_black() -> Result<*mut c_void>;
		pub fn cv_viz_Color_blue() -> Result<*mut c_void>;
		pub fn cv_viz_Color_green() -> Result<*mut c_void>;
		pub fn cv_viz_Color_red() -> Result<*mut c_void>;
		pub fn cv_viz_Color_cyan() -> Result<*mut c_void>;
		pub fn cv_viz_Color_yellow() -> Result<*mut c_void>;
		pub fn cv_viz_Color_magenta() -> Result<*mut c_void>;
		pub fn cv_viz_Color_white() -> Result<*mut c_void>;
		pub fn cv_viz_Color_gray() -> Result<*mut c_void>;
		pub fn cv_viz_Color_silver() -> Result<*mut c_void>;
		pub fn cv_viz_Color_mlab() -> Result<*mut c_void>;
		pub fn cv_viz_Color_navy() -> Result<*mut c_void>;
		pub fn cv_viz_Color_maroon() -> Result<*mut c_void>;
		pub fn cv_viz_Color_teal() -> Result<*mut c_void>;
		pub fn cv_viz_Color_olive() -> Result<*mut c_void>;
		pub fn cv_viz_Color_purple() -> Result<*mut c_void>;
		pub fn cv_viz_Color_azure() -> Result<*mut c_void>;
		pub fn cv_viz_Color_chartreuse() -> Result<*mut c_void>;
		pub fn cv_viz_Color_rose() -> Result<*mut c_void>;
		pub fn cv_viz_Color_lime() -> Result<*mut c_void>;
		pub fn cv_viz_Color_gold() -> Result<*mut c_void>;
		pub fn cv_viz_Color_orange() -> Result<*mut c_void>;
		pub fn cv_viz_Color_orange_red() -> Result<*mut c_void>;
		pub fn cv_viz_Color_indigo() -> Result<*mut c_void>;
		pub fn cv_viz_Color_brown() -> Result<*mut c_void>;
		pub fn cv_viz_Color_apricot() -> Result<*mut c_void>;
		pub fn cv_viz_Color_pink() -> Result<*mut c_void>;
		pub fn cv_viz_Color_raspberry() -> Result<*mut c_void>;
		pub fn cv_viz_Color_cherry() -> Result<*mut c_void>;
		pub fn cv_viz_Color_violet() -> Result<*mut c_void>;
		pub fn cv_viz_Color_amethyst() -> Result<*mut c_void>;
		pub fn cv_viz_Color_bluberry() -> Result<*mut c_void>;
		pub fn cv_viz_Color_celestial_blue() -> Result<*mut c_void>;
		pub fn cv_viz_Color_turquoise() -> Result<*mut c_void>;
		pub fn cv_viz_Color_not_set() -> Result<*mut c_void>;
		pub fn cv_viz_KeyboardEvent_getPropAction_const(instance: *const c_void) -> crate::viz::KeyboardEvent_Action;
		pub fn cv_viz_KeyboardEvent_setPropAction_Action(instance: *mut c_void, val: crate::viz::KeyboardEvent_Action);
		pub fn cv_viz_KeyboardEvent_getPropSymbol_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_KeyboardEvent_setPropSymbol_String(instance: *mut c_void, val: *mut c_char);
		pub fn cv_viz_KeyboardEvent_getPropCode_const(instance: *const c_void) -> u8;
		pub fn cv_viz_KeyboardEvent_setPropCode_unsigned_char(instance: *mut c_void, val: u8);
		pub fn cv_viz_KeyboardEvent_getPropModifiers_const(instance: *const c_void) -> i32;
		pub fn cv_viz_KeyboardEvent_setPropModifiers_int(instance: *mut c_void, val: i32);
		pub fn cv_viz_KeyboardEvent_KeyboardEvent_Action_const_StringR_unsigned_char_int(action: crate::viz::KeyboardEvent_Action, symbol: *const c_char, code: u8, modifiers: i32) -> Result<*mut c_void>;
		pub fn cv_viz_Mesh_getPropCloud_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropCloud_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_getPropColors_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropColors_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_getPropNormals_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropNormals_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_getPropPolygons_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropPolygons_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_getPropTexture_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropTexture_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_getPropTcoords_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_viz_Mesh_setPropTcoords_Mat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_viz_Mesh_Mesh() -> Result<*mut c_void>;
		pub fn cv_viz_Mesh_load_const_StringR_int(file: *const c_char, typ: i32) -> Result<*mut c_void>;
		pub fn cv_viz_MouseEvent_getPropType_const(instance: *const c_void) -> crate::viz::MouseEvent_Type;
		pub fn cv_viz_MouseEvent_setPropType_Type(instance: *mut c_void, val: crate::viz::MouseEvent_Type);
		pub fn cv_viz_MouseEvent_getPropButton_const(instance: *const c_void) -> crate::viz::MouseEvent_MouseButton;
		pub fn cv_viz_MouseEvent_setPropButton_MouseButton(instance: *mut c_void, val: crate::viz::MouseEvent_MouseButton);
		pub fn cv_viz_MouseEvent_getPropPointer_const(instance: *const c_void) -> core::Point;
		pub fn cv_viz_MouseEvent_setPropPointer_Point(instance: *mut c_void, val: *const core::Point);
		pub fn cv_viz_MouseEvent_getPropModifiers_const(instance: *const c_void) -> i32;
		pub fn cv_viz_MouseEvent_setPropModifiers_int(instance: *mut c_void, val: i32);
		pub fn cv_viz_MouseEvent_MouseEvent_const_TypeR_const_MouseButtonR_const_PointR_int(typ: *const crate::viz::MouseEvent_Type, button: *const crate::viz::MouseEvent_MouseButton, pointer: *const core::Point, modifiers: i32) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_Viz3d_const_StringR(window_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_Viz3d_const_Viz3dR(unnamed: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_showWidget_const_StringR_const_WidgetR_const_Affine3dR(instance: *mut c_void, id: *const c_char, widget: *const c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Viz3d_removeWidget_const_StringR(instance: *mut c_void, id: *const c_char) -> Result_void;
		pub fn cv_viz_Viz3d_getWidget_const_const_StringR(instance: *const c_void, id: *const c_char) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_removeAllWidgets(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_showImage_const__InputArrayR_const_SizeR(instance: *mut c_void, image: *const c_void, window_size: *const core::Size) -> Result_void;
		pub fn cv_viz_Viz3d_setWidgetPose_const_StringR_const_Affine3dR(instance: *mut c_void, id: *const c_char, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Viz3d_updateWidgetPose_const_StringR_const_Affine3dR(instance: *mut c_void, id: *const c_char, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Viz3d_getWidgetPose_const_const_StringR(instance: *const c_void, id: *const c_char) -> Result<core::Affine3d>;
		pub fn cv_viz_Viz3d_setCamera_const_CameraR(instance: *mut c_void, camera: *const c_void) -> Result_void;
		pub fn cv_viz_Viz3d_getCamera_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_getViewerPose_const(instance: *const c_void) -> Result<core::Affine3d>;
		pub fn cv_viz_Viz3d_setViewerPose_const_Affine3dR(instance: *mut c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Viz3d_resetCameraViewpoint_const_StringR(instance: *mut c_void, id: *const c_char) -> Result_void;
		pub fn cv_viz_Viz3d_resetCamera(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_convertToWindowCoordinates_const_Point3dR_Point3dR(instance: *mut c_void, pt: *const core::Point3d, window_coord: *mut core::Point3d) -> Result_void;
		pub fn cv_viz_Viz3d_converTo3DRay_const_Point3dR_Point3dR_Vec3dR(instance: *mut c_void, window_coord: *const core::Point3d, origin: *mut core::Point3d, direction: *mut core::Vec3d) -> Result_void;
		pub fn cv_viz_Viz3d_getWindowSize_const(instance: *const c_void) -> Result<core::Size>;
		pub fn cv_viz_Viz3d_setWindowSize_const_SizeR(instance: *mut c_void, window_size: *const core::Size) -> Result_void;
		pub fn cv_viz_Viz3d_getWindowName_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_getScreenshot_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_Viz3d_saveScreenshot_const_StringR(instance: *mut c_void, file: *const c_char) -> Result_void;
		pub fn cv_viz_Viz3d_setWindowPosition_const_PointR(instance: *mut c_void, window_position: *const core::Point) -> Result_void;
		pub fn cv_viz_Viz3d_setFullScreen_bool(instance: *mut c_void, mode: bool) -> Result_void;
		pub fn cv_viz_Viz3d_setBackgroundColor_const_ColorR_const_ColorR(instance: *mut c_void, color: *const c_void, color2: *const c_void) -> Result_void;
		pub fn cv_viz_Viz3d_setBackgroundTexture_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result_void;
		pub fn cv_viz_Viz3d_setBackgroundMeshLab(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_spin(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_spinOnce_int_bool(instance: *mut c_void, time: i32, force_redraw: bool) -> Result_void;
		pub fn cv_viz_Viz3d_setOffScreenRendering(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_removeAllLights(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_addLight_const_Vec3dR_const_Vec3dR_const_ColorR_const_ColorR_const_ColorR_const_ColorR(instance: *mut c_void, position: *const core::Vec3d, focal_point: *const core::Vec3d, color: *const c_void, diffuse_color: *const c_void, ambient_color: *const c_void, specular_color: *const c_void) -> Result_void;
		pub fn cv_viz_Viz3d_wasStopped_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_viz_Viz3d_close(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_registerKeyboardCallback_KeyboardCallback_voidX(instance: *mut c_void, callback: Option<unsafe extern "C" fn(*const c_void, *mut c_void) -> ()>, cookie: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_registerMouseCallback_MouseCallback_voidX(instance: *mut c_void, callback: Option<unsafe extern "C" fn(*const c_void, *mut c_void) -> ()>, cookie: *mut c_void) -> Result_void;
		pub fn cv_viz_Viz3d_setRenderingProperty_const_StringR_int_double(instance: *mut c_void, id: *const c_char, property: i32, value: f64) -> Result_void;
		pub fn cv_viz_Viz3d_getRenderingProperty_const_StringR_int(instance: *mut c_void, id: *const c_char, property: i32) -> Result<f64>;
		pub fn cv_viz_Viz3d_setRepresentation_int(instance: *mut c_void, representation: i32) -> Result_void;
		pub fn cv_viz_Viz3d_setGlobalWarnings_bool(instance: *mut c_void, enabled: bool) -> Result_void;
		pub fn cv_viz_WArrow_WArrow_const_Point3dR_const_Point3dR_double_const_ColorR(pt1: *const core::Point3d, pt2: *const core::Point3d, thickness: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCameraPosition_WCameraPosition_double(scale: f64) -> Result<*mut c_void>;
		pub fn cv_viz_WCameraPosition_WCameraPosition_const_Matx33dR_double_const_ColorR(k: *const core::Matx33d, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCameraPosition_WCameraPosition_const_Vec2dR_double_const_ColorR(fov: *const core::Vec2d, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCameraPosition_WCameraPosition_const_Matx33dR_const__InputArrayR_double_const_ColorR(k: *const core::Matx33d, image: *const c_void, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCameraPosition_WCameraPosition_const_Vec2dR_const__InputArrayR_double_const_ColorR(fov: *const core::Vec2d, image: *const c_void, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCircle_WCircle_double_double_const_ColorR(radius: f64, thickness: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCircle_WCircle_double_const_Point3dR_const_Vec3dR_double_const_ColorR(radius: f64, center: *const core::Point3d, normal: *const core::Vec3d, thickness: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCloud_WCloud_const__InputArrayR_const__InputArrayR(cloud: *const c_void, colors: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCloud_WCloud_const__InputArrayR_const_ColorR(cloud: *const c_void, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCloud_WCloud_const__InputArrayR_const__InputArrayR_const__InputArrayR(cloud: *const c_void, colors: *const c_void, normals: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCloud_WCloud_const__InputArrayR_const_ColorR_const__InputArrayR(cloud: *const c_void, color: *const c_void, normals: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCloudCollection_WCloudCollection() -> Result<*mut c_void>;
		pub fn cv_viz_WCloudCollection_addCloud_const__InputArrayR_const__InputArrayR_const_Affine3dR(instance: *mut c_void, cloud: *const c_void, colors: *const c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_WCloudCollection_addCloud_const__InputArrayR_const_ColorR_const_Affine3dR(instance: *mut c_void, cloud: *const c_void, color: *const c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_WCloudCollection_finalize(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_WCloudNormals_WCloudNormals_const__InputArrayR_const__InputArrayR_int_double_const_ColorR(cloud: *const c_void, normals: *const c_void, level: i32, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCone_WCone_double_double_int_const_ColorR(length: f64, radius: f64, resolution: i32, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCone_WCone_double_const_Point3dR_const_Point3dR_int_const_ColorR(radius: f64, center: *const core::Point3d, tip: *const core::Point3d, resolution: i32, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCoordinateSystem_WCoordinateSystem_double(scale: f64) -> Result<*mut c_void>;
		pub fn cv_viz_WCube_WCube_const_Point3dR_const_Point3dR_bool_const_ColorR(min_point: *const core::Point3d, max_point: *const core::Point3d, wire_frame: bool, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WCylinder_WCylinder_const_Point3dR_const_Point3dR_double_int_const_ColorR(axis_point1: *const core::Point3d, axis_point2: *const core::Point3d, radius: f64, numsides: i32, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WGrid_WGrid_const_Vec2iR_const_Vec2dR_const_ColorR(cells: *const core::Vec2i, cells_spacing: *const core::Vec2d, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WGrid_WGrid_const_Point3dR_const_Vec3dR_const_Vec3dR_const_Vec2iR_const_Vec2dR_const_ColorR(center: *const core::Point3d, normal: *const core::Vec3d, new_yaxis: *const core::Vec3d, cells: *const core::Vec2i, cells_spacing: *const core::Vec2d, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WImage3D_WImage3D_const__InputArrayR_const_Size2dR(image: *const c_void, size: *const core::Size2d) -> Result<*mut c_void>;
		pub fn cv_viz_WImage3D_WImage3D_const__InputArrayR_const_Size2dR_const_Vec3dR_const_Vec3dR_const_Vec3dR(image: *const c_void, size: *const core::Size2d, center: *const core::Vec3d, normal: *const core::Vec3d, up_vector: *const core::Vec3d) -> Result<*mut c_void>;
		pub fn cv_viz_WImage3D_setImage_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result_void;
		pub fn cv_viz_WImage3D_setSize_const_SizeR(instance: *mut c_void, size: *const core::Size) -> Result_void;
		pub fn cv_viz_WImageOverlay_WImageOverlay_const__InputArrayR_const_RectR(image: *const c_void, rect: *const core::Rect) -> Result<*mut c_void>;
		pub fn cv_viz_WImageOverlay_setImage_const__InputArrayR(instance: *mut c_void, image: *const c_void) -> Result_void;
		pub fn cv_viz_WLine_WLine_const_Point3dR_const_Point3dR_const_ColorR(pt1: *const core::Point3d, pt2: *const core::Point3d, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WMesh_WMesh_const_MeshR(mesh: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WMesh_WMesh_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(cloud: *const c_void, polygons: *const c_void, colors: *const c_void, normals: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR(cloud: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR_const_Point3dR_const_Point3dR(cloud: *const c_void, p1: *const core::Point3d, p2: *const core::Point3d) -> Result<*mut c_void>;
		pub fn cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR_const_Point3dR_const_Point3dR_const_ColorR_const_Color(cloud: *const c_void, p1: *const core::Point3d, p2: *const core::Point3d, c1: *const c_void, c2: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPlane_WPlane_const_Size2dR_const_ColorR(size: *const core::Size2d, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPlane_WPlane_const_Point3dR_const_Vec3dR_const_Vec3dR_const_Size2dR_const_ColorR(center: *const core::Point3d, normal: *const core::Vec3d, new_yaxis: *const core::Vec3d, size: *const core::Size2d, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPolyLine_WPolyLine_const__InputArrayR_const__InputArrayR(points: *const c_void, colors: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WPolyLine_WPolyLine_const__InputArrayR_const_ColorR(points: *const c_void, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WSphere_WSphere_const_Point3dR_double_int_const_ColorR(center: *const core::Point3d, radius: f64, sphere_resolution: i32, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WText_WText_const_StringR_const_PointR_int_const_ColorR(text: *const c_char, pos: *const core::Point, font_size: i32, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WText_setText_const_StringR(instance: *mut c_void, text: *const c_char) -> Result_void;
		pub fn cv_viz_WText_getText_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WText3D_WText3D_const_StringR_const_Point3dR_double_bool_const_ColorR(text: *const c_char, position: *const core::Point3d, text_scale: f64, face_camera: bool, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WText3D_setText_const_StringR(instance: *mut c_void, text: *const c_char) -> Result_void;
		pub fn cv_viz_WText3D_getText_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WTrajectory_WTrajectory_const__InputArrayR_int_double_const_ColorR(path: *const c_void, display_mode: i32, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WTrajectoryFrustums_WTrajectoryFrustums_const__InputArrayR_const_Matx33dR_double_const_ColorR(path: *const c_void, k: *const core::Matx33d, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WTrajectoryFrustums_WTrajectoryFrustums_const__InputArrayR_const_Vec2dR_double_const_ColorR(path: *const c_void, fov: *const core::Vec2d, scale: f64, color: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WTrajectorySpheres_WTrajectorySpheres_const__InputArrayR_double_double_const_ColorR_const_ColorR(path: *const c_void, line_length: f64, radius: f64, from: *const c_void, to: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_WWidgetMerger_WWidgetMerger() -> Result<*mut c_void>;
		pub fn cv_viz_WWidgetMerger_addWidget_const_Widget3DR_const_Affine3dR(instance: *mut c_void, widget: *const c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_WWidgetMerger_finalize(instance: *mut c_void) -> Result_void;
		pub fn cv_viz_Widget_Widget() -> Result<*mut c_void>;
		pub fn cv_viz_Widget_Widget_const_WidgetR(other: *const c_void) -> Result<*mut c_void>;
		pub fn cv_viz_Widget_fromPlyFile_const_StringR(file_name: *const c_char) -> Result<*mut c_void>;
		pub fn cv_viz_Widget_setRenderingProperty_int_double(instance: *mut c_void, property: i32, value: f64) -> Result_void;
		pub fn cv_viz_Widget_getRenderingProperty_const_int(instance: *const c_void, property: i32) -> Result<f64>;
		pub fn cv_viz_Widget2D_Widget2D() -> Result<*mut c_void>;
		pub fn cv_viz_Widget2D_setColor_const_ColorR(instance: *mut c_void, color: *const c_void) -> Result_void;
		pub fn cv_viz_Widget3D_Widget3D() -> Result<*mut c_void>;
		pub fn cv_viz_Widget3D_setPose_const_Affine3dR(instance: *mut c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Widget3D_updatePose_const_Affine3dR(instance: *mut c_void, pose: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Widget3D_getPose_const(instance: *const c_void) -> Result<core::Affine3d>;
		pub fn cv_viz_Widget3D_applyTransform_const_Affine3dR(instance: *mut c_void, transform: *const core::Affine3d) -> Result_void;
		pub fn cv_viz_Widget3D_setColor_const_ColorR(instance: *mut c_void, color: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_viz)]
pub use viz_sys::*;

#[cfg(ocvrs_has_module_wechat_qrcode)]
mod wechat_qrcode_sys {
	use super::*;

	extern "C" {
		pub fn cv_wechat_qrcode_WeChatQRCode_WeChatQRCode_const_stringR_const_stringR_const_stringR_const_stringR(detector_prototxt_path: *const c_char, detector_caffe_model_path: *const c_char, super_resolution_prototxt_path: *const c_char, super_resolution_caffe_model_path: *const c_char) -> Result<*mut c_void>;
		pub fn cv_wechat_qrcode_WeChatQRCode_detectAndDecode_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, points: *const c_void) -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_wechat_qrcode)]
pub use wechat_qrcode_sys::*;

#[cfg(ocvrs_has_module_xfeatures2d)]
mod xfeatures2d_sys {
	use super::*;

	extern "C" {
		pub fn cv_xfeatures2d_FASTForPointSet_const__InputArrayR_vector_KeyPoint_R_int_bool_DetectorType(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, typ: crate::features2d::FastFeatureDetector_DetectorType) -> Result_void;
		pub fn cv_xfeatures2d_matchGMS_const_SizeR_const_SizeR_const_vector_KeyPoint_R_const_vector_KeyPoint_R_const_vector_DMatch_R_vector_DMatch_R_const_bool_const_bool_const_double(size1: *const core::Size, size2: *const core::Size, keypoints1: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, matches_gms: *mut c_void, with_rotation: bool, with_scale: bool, threshold_factor: f64) -> Result_void;
		pub fn cv_xfeatures2d_matchLOGOS_const_vector_KeyPoint_R_const_vector_KeyPoint_R_const_vector_int_R_const_vector_int_R_vector_DMatch_R(keypoints1: *const c_void, keypoints2: *const c_void, nn1: *const c_void, nn2: *const c_void, matches1to2: *mut c_void) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_getPropHessianThreshold_const(instance: *const c_void) -> f64;
		pub fn cv_cuda_SURF_CUDA_setPropHessianThreshold_double(instance: *mut c_void, val: f64);
		pub fn cv_cuda_SURF_CUDA_getPropNOctaves_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_SURF_CUDA_setPropNOctaves_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_SURF_CUDA_getPropNOctaveLayers_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_SURF_CUDA_setPropNOctaveLayers_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_SURF_CUDA_getPropExtended_const(instance: *const c_void) -> bool;
		pub fn cv_cuda_SURF_CUDA_setPropExtended_bool(instance: *mut c_void, val: bool);
		pub fn cv_cuda_SURF_CUDA_getPropUpright_const(instance: *const c_void) -> bool;
		pub fn cv_cuda_SURF_CUDA_setPropUpright_bool(instance: *mut c_void, val: bool);
		pub fn cv_cuda_SURF_CUDA_getPropKeypointsRatio_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_SURF_CUDA_setPropKeypointsRatio_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_SURF_CUDA_getPropSum_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropSum_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_getPropMask1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropMask1_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_getPropMaskSum_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropMaskSum_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_getPropDet_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropDet_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_getPropTrace_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropTrace_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_getPropMaxPosBuffer_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_SURF_CUDA_setPropMaxPosBuffer_GpuMat(instance: *mut c_void, val: *mut c_void);
		pub fn cv_cuda_SURF_CUDA_SURF_CUDA() -> Result<*mut c_void>;
		pub fn cv_cuda_SURF_CUDA_SURF_CUDA_double_int_int_bool_float_bool(_hessian_threshold: f64, _n_octaves: i32, _n_octave_layers: i32, _extended: bool, _keypoints_ratio: f32, _upright: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_SURF_CUDA_create_double_int_int_bool_float_bool(_hessian_threshold: f64, _n_octaves: i32, _n_octave_layers: i32, _extended: bool, _keypoints_ratio: f32, _upright: bool) -> Result<*mut c_void>;
		pub fn cv_cuda_SURF_CUDA_descriptorSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_SURF_CUDA_defaultNorm_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_cuda_SURF_CUDA_uploadKeypoints_const_vector_KeyPoint_R_GpuMatR(instance: *mut c_void, keypoints: *const c_void, keypoints_gpu: *mut c_void) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_downloadKeypoints_const_GpuMatR_vector_KeyPoint_R(instance: *mut c_void, keypoints_gpu: *const c_void, keypoints: *mut c_void) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_downloadDescriptors_const_GpuMatR_vector_float_R(instance: *mut c_void, descriptors_gpu: *const c_void, descriptors: *mut c_void) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_detect_const_GpuMatR_const_GpuMatR_GpuMatR(instance: *mut c_void, img: *const c_void, mask: *const c_void, keypoints: *mut c_void) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_detectWithDescriptors_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR_bool(instance: *mut c_void, img: *const c_void, mask: *const c_void, keypoints: *mut c_void, descriptors: *mut c_void, use_provided_keypoints: bool) -> Result_void;
		pub fn cv_cuda_SURF_CUDA_releaseMemory(instance: *mut c_void) -> Result_void;
		pub fn cv_xfeatures2d_AffineFeature2D_create_Ptr_Feature2D__Ptr_Feature2D_(keypoint_detector: *mut c_void, descriptor_extractor: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_AffineFeature2D_create_Ptr_Feature2D_(keypoint_detector: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_AffineFeature2D_detect_const__InputArrayR_vector_Elliptic_KeyPoint_R_const__InputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, mask: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_AffineFeature2D_detectAndCompute_const__InputArrayR_const__InputArrayR_vector_Elliptic_KeyPoint_R_const__OutputArrayR_bool(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, use_provided_keypoints: bool) -> Result_void;
		pub fn cv_xfeatures2d_BEBLID_create_float_int(scale_factor: f32, n_bits: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_BoostDesc_create_int_bool_float(desc: i32, use_scale_orientation: bool, scale_factor: f32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_BoostDesc_setUseScaleOrientation_const_bool(instance: *mut c_void, use_scale_orientation: bool) -> Result_void;
		pub fn cv_xfeatures2d_BoostDesc_getUseScaleOrientation_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_xfeatures2d_BoostDesc_setScaleFactor_const_float(instance: *mut c_void, scale_factor: f32) -> Result_void;
		pub fn cv_xfeatures2d_BoostDesc_getScaleFactor_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_BriefDescriptorExtractor_create_int_bool(bytes: i32, use_orientation: bool) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_DAISY_create_float_int_int_int_NormalizationType_const__InputArrayR_bool_bool(radius: f32, q_radius: i32, q_theta: i32, q_hist: i32, norm: crate::xfeatures2d::DAISY_NormalizationType, h: *const c_void, interpolation: bool, use_orientation: bool) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_DAISY_compute_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_compute_const__InputArrayR_vector_vector_KeyPoint__R_const__OutputArrayR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_compute_const__InputArrayR_Rect_const__OutputArrayR(instance: *mut c_void, image: *const c_void, roi: *const core::Rect, descriptors: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, descriptors: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_GetDescriptor_const_double_double_int_floatX(instance: *const c_void, y: f64, x: f64, orientation: i32, descriptor: *mut f32) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_GetDescriptor_const_double_double_int_floatX_doubleX(instance: *const c_void, y: f64, x: f64, orientation: i32, descriptor: *mut f32, h: *mut f64) -> Result<bool>;
		pub fn cv_xfeatures2d_DAISY_GetUnnormalizedDescriptor_const_double_double_int_floatX(instance: *const c_void, y: f64, x: f64, orientation: i32, descriptor: *mut f32) -> Result_void;
		pub fn cv_xfeatures2d_DAISY_GetUnnormalizedDescriptor_const_double_double_int_floatX_doubleX(instance: *const c_void, y: f64, x: f64, orientation: i32, descriptor: *mut f32, h: *mut f64) -> Result<bool>;
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_getPropAxes_const(instance: *const c_void) -> core::Size_<f32>;
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_setPropAxes_Size__float_(instance: *mut c_void, val: *const core::Size_<f32>);
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_getPropSi_const(instance: *const c_void) -> f32;
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_setPropSi_float(instance: *mut c_void, val: f32);
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_getPropTransf_const(instance: *const c_void) -> core::Matx23f;
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_setPropTransf_Matx23f(instance: *mut c_void, val: *const core::Matx23f);
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_Elliptic_KeyPoint() -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_Elliptic_KeyPoint_Elliptic_KeyPoint_Point2f_float_Size_float_float(pt: *const core::Point2f, angle: f32, axes: *const core::Size, size: f32, si: f32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_FREAK_create_bool_bool_float_int_const_vector_int_R(orientation_normalized: bool, scale_normalized: bool, pattern_scale: f32, n_octaves: i32, selected_pairs: *const c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_HarrisLaplaceFeatureDetector_create_int_float_float_int_int(num_octaves: i32, corn_thresh: f32, dog_thresh: f32, max_corners: i32, num_layers: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_LATCH_create_int_bool_int_double(bytes: i32, rotation_invariance: bool, half_ssd_size: i32, sigma: f64) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_LUCID_create_const_int_const_int(lucid_kernel: i32, blur_kernel: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_MSDDetector_create_int_int_int_int_float_int_float_int_bool(m_patch_radius: i32, m_search_area_radius: i32, m_nms_radius: i32, m_nms_scale_radius: i32, m_th_saliency: f32, m_k_nn: i32, m_scale_factor: f32, m_n_scales: i32, m_compute_orientation: bool) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_create_const_int_const_int_const_int(init_sample_count: i32, init_seed_count: i32, point_distribution: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_create_const_vector_Point2f_R_const_int(init_sampling_points: *const c_void, init_seed_count: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_create_const_vector_Point2f_R_const_vector_int_R(init_sampling_points: *const c_void, init_cluster_seed_indexes: *const c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_computeSignature_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, image: *const c_void, signature: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_computeSignatures_const_const_vector_Mat_R_vector_Mat_R(instance: *const c_void, images: *const c_void, signatures: *mut c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_drawSignature_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_int(source: *const c_void, signature: *const c_void, result: *const c_void, radius_to_shorter_side_ratio: f32, border_thickness: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_generateInitPoints_vector_Point2f_R_const_int_int(init_points: *mut c_void, count: i32, point_distribution: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getSampleCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_getGrayscaleBits_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setGrayscaleBits_int(instance: *mut c_void, grayscale_bits: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWindowRadius_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWindowRadius_int(instance: *mut c_void, radius: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightX_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightX_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightY_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightY_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightL_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightL_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightA_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightA_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightB_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightB_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightContrast_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightContrast_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getWeightEntropy_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeightEntropy_float(instance: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getSamplingPoints_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_setWeight_int_float(instance: *mut c_void, idx: i32, value: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_setWeights_const_vector_float_R(instance: *mut c_void, weights: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_setTranslation_int_float(instance: *mut c_void, idx: i32, value: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_setTranslations_const_vector_float_R(instance: *mut c_void, translations: *const c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_setSamplingPoints_vector_Point2f_(instance: *mut c_void, sampling_points: *mut c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getInitSeedIndexes_const(instance: *const c_void) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignatures_setInitSeedIndexes_vector_int_(instance: *mut c_void, init_seed_indexes: *mut c_void) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getInitSeedCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_getIterationCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setIterationCount_int(instance: *mut c_void, iteration_count: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getMaxClustersCount_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setMaxClustersCount_int(instance: *mut c_void, max_clusters_count: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getClusterMinSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setClusterMinSize_int(instance: *mut c_void, cluster_min_size: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getJoiningDistance_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setJoiningDistance_float(instance: *mut c_void, joining_distance: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getDropThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignatures_setDropThreshold_float(instance: *mut c_void, drop_threshold: f32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignatures_getDistanceFunction_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_PCTSignatures_setDistanceFunction_int(instance: *mut c_void, distance_function: i32) -> Result_void;
		pub fn cv_xfeatures2d_PCTSignaturesSQFD_create_const_int_const_int_const_float(distance_function: i32, similarity_function: i32, similarity_parameter: f32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_PCTSignaturesSQFD_computeQuadraticFormDistance_const_const__InputArrayR_const__InputArrayR(instance: *const c_void, _signature0: *const c_void, _signature1: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_PCTSignaturesSQFD_computeQuadraticFormDistances_const_const_MatR_const_vector_Mat_R_vector_float_R(instance: *const c_void, source_signature: *const c_void, image_signatures: *const c_void, distances: *mut c_void) -> Result_void;
		pub fn cv_xfeatures2d_SURF_create_double_int_int_bool_bool(hessian_threshold: f64, n_octaves: i32, n_octave_layers: i32, extended: bool, upright: bool) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_SURF_setHessianThreshold_double(instance: *mut c_void, hessian_threshold: f64) -> Result_void;
		pub fn cv_xfeatures2d_SURF_getHessianThreshold_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_xfeatures2d_SURF_setNOctaves_int(instance: *mut c_void, n_octaves: i32) -> Result_void;
		pub fn cv_xfeatures2d_SURF_getNOctaves_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_SURF_setNOctaveLayers_int(instance: *mut c_void, n_octave_layers: i32) -> Result_void;
		pub fn cv_xfeatures2d_SURF_getNOctaveLayers_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_SURF_setExtended_bool(instance: *mut c_void, extended: bool) -> Result_void;
		pub fn cv_xfeatures2d_SURF_getExtended_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_xfeatures2d_SURF_setUpright_bool(instance: *mut c_void, upright: bool) -> Result_void;
		pub fn cv_xfeatures2d_SURF_getUpright_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_xfeatures2d_StarDetector_create_int_int_int_int_int(max_size: i32, response_threshold: i32, line_threshold_projected: i32, line_threshold_binarized: i32, suppress_nonmax_size: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_TBMR_create_int_float_float_int(min_area: i32, max_area_relative: f32, scale_factor: f32, n_scales: i32) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_TBMR_setMinArea_int(instance: *mut c_void, min_area: i32) -> Result_void;
		pub fn cv_xfeatures2d_TBMR_getMinArea_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_TBMR_setMaxAreaRelative_float(instance: *mut c_void, max_area: f32) -> Result_void;
		pub fn cv_xfeatures2d_TBMR_getMaxAreaRelative_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_TBMR_setScaleFactor_float(instance: *mut c_void, scale_factor: f32) -> Result_void;
		pub fn cv_xfeatures2d_TBMR_getScaleFactor_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_TBMR_setNScales_int(instance: *mut c_void, n_scales: i32) -> Result_void;
		pub fn cv_xfeatures2d_TBMR_getNScales_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xfeatures2d_VGG_create_int_float_bool_bool_float_bool(desc: i32, isigma: f32, img_normalize: bool, use_scale_orientation: bool, scale_factor: f32, dsc_normalize: bool) -> Result<*mut c_void>;
		pub fn cv_xfeatures2d_VGG_setSigma_const_float(instance: *mut c_void, isigma: f32) -> Result_void;
		pub fn cv_xfeatures2d_VGG_getSigma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_VGG_setUseNormalizeImage_const_bool(instance: *mut c_void, img_normalize: bool) -> Result_void;
		pub fn cv_xfeatures2d_VGG_getUseNormalizeImage_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_xfeatures2d_VGG_setUseScaleOrientation_const_bool(instance: *mut c_void, use_scale_orientation: bool) -> Result_void;
		pub fn cv_xfeatures2d_VGG_getUseScaleOrientation_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_xfeatures2d_VGG_setScaleFactor_const_float(instance: *mut c_void, scale_factor: f32) -> Result_void;
		pub fn cv_xfeatures2d_VGG_getScaleFactor_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xfeatures2d_VGG_setUseNormalizeDescriptor_const_bool(instance: *mut c_void, dsc_normalize: bool) -> Result_void;
		pub fn cv_xfeatures2d_VGG_getUseNormalizeDescriptor_const(instance: *const c_void) -> Result<bool>;
	}
}
#[cfg(ocvrs_has_module_xfeatures2d)]
pub use xfeatures2d_sys::*;

#[cfg(ocvrs_has_module_ximgproc)]
mod ximgproc_sys {
	use super::*;

	extern "C" {
		pub fn cv_ximgproc_BrightEdges_MatR_MatR_int_int_int(_original: *mut c_void, _edgeview: *mut c_void, contrast: i32, shortrange: i32, longrange: i32) -> Result_void;
		pub fn cv_ximgproc_FastHoughTransform_const__InputArrayR_const__OutputArrayR_int_int_int_int(src: *const c_void, dst: *const c_void, dst_mat_depth: i32, angle_range: i32, op: i32, make_skew: i32) -> Result_void;
		pub fn cv_ximgproc_GradientDericheX_const__InputArrayR_const__OutputArrayR_double_double(op: *const c_void, dst: *const c_void, alpha: f64, omega: f64) -> Result_void;
		pub fn cv_ximgproc_GradientDericheY_const__InputArrayR_const__OutputArrayR_double_double(op: *const c_void, dst: *const c_void, alpha: f64, omega: f64) -> Result_void;
		pub fn cv_ximgproc_GradientPaillouX_const__InputArrayR_const__OutputArrayR_double_double(op: *const c_void, _dst: *const c_void, alpha: f64, omega: f64) -> Result_void;
		pub fn cv_ximgproc_GradientPaillouY_const__InputArrayR_const__OutputArrayR_double_double(op: *const c_void, _dst: *const c_void, alpha: f64, omega: f64) -> Result_void;
		pub fn cv_ximgproc_HoughPoint2Line_const_PointR_const__InputArrayR_int_int_int(hough_point: *const core::Point, src_img_info: *const c_void, angle_range: i32, make_skew: i32, rules: i32) -> Result<core::Vec4i>;
		pub fn cv_ximgproc_PeiLinNormalization_const__InputArrayR(i: *const c_void) -> Result<core::Matx23d>;
		pub fn cv_ximgproc_PeiLinNormalization_const__InputArrayR_const__OutputArrayR(i: *const c_void, t: *const c_void) -> Result_void;
		pub fn cv_ximgproc_amFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_bool(joint: *const c_void, src: *const c_void, dst: *const c_void, sigma_s: f64, sigma_r: f64, adjust_outliers: bool) -> Result_void;
		pub fn cv_ximgproc_anisotropicDiffusion_const__InputArrayR_const__OutputArrayR_float_float_int(src: *const c_void, dst: *const c_void, alpha: f32, k: f32, niters: i32) -> Result_void;
		pub fn cv_ximgproc_bilateralTextureFilter_const__InputArrayR_const__OutputArrayR_int_int_double_double(src: *const c_void, dst: *const c_void, fr: i32, num_iter: i32, sigma_alpha: f64, sigma_avg: f64) -> Result_void;
		pub fn cv_ximgproc_colorMatchTemplate_const__InputArrayR_const__InputArrayR_const__OutputArrayR(img: *const c_void, templ: *const c_void, result: *const c_void) -> Result_void;
		pub fn cv_ximgproc_computeBadPixelPercent_const__InputArrayR_const__InputArrayR_Rect_int(gt: *const c_void, src: *const c_void, roi: *const core::Rect, thresh: i32) -> Result<f64>;
		pub fn cv_ximgproc_computeMSE_const__InputArrayR_const__InputArrayR_Rect(gt: *const c_void, src: *const c_void, roi: *const core::Rect) -> Result<f64>;
		pub fn cv_ximgproc_contourSampling_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, out: *const c_void, nb_elt: i32) -> Result_void;
		pub fn cv_ximgproc_covarianceEstimation_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, window_rows: i32, window_cols: i32) -> Result_void;
		pub fn cv_ximgproc_createAMFilter_double_double_bool(sigma_s: f64, sigma_r: f64, adjust_outliers: bool) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createContourFitting_int_int(ctr: i32, fd: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createDTFilter_const__InputArrayR_double_double_int_int(guide: *const c_void, sigma_spatial: f64, sigma_color: f64, mode: i32, num_iters: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createDisparityWLSFilterGeneric_bool(use_confidence: bool) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createDisparityWLSFilter_Ptr_StereoMatcher_(matcher_left: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createEdgeAwareInterpolator() -> Result<*mut c_void>;
		pub fn cv_ximgproc_createEdgeBoxes_float_float_float_float_int_float_float_float_float_float_float_float(alpha: f32, beta: f32, eta: f32, min_score: f32, max_boxes: i32, edge_min_mag: f32, edge_merge_thr: f32, cluster_min_mag: f32, max_aspect_ratio: f32, min_box_area: f32, gamma: f32, kappa: f32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createEdgeDrawing() -> Result<*mut c_void>;
		pub fn cv_ximgproc_createFastBilateralSolverFilter_const__InputArrayR_double_double_double_double_int_double(guide: *const c_void, sigma_spatial: f64, sigma_luma: f64, sigma_chroma: f64, lambda: f64, num_iter: i32, max_tol: f64) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createFastGlobalSmootherFilter_const__InputArrayR_double_double_double_int(guide: *const c_void, lambda: f64, sigma_color: f64, lambda_attenuation: f64, num_iter: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createFastLineDetector_int_float_double_double_int_bool(length_threshold: i32, distance_threshold: f32, canny_th1: f64, canny_th2: f64, canny_aperture_size: i32, do_merge: bool) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createGuidedFilter_const__InputArrayR_int_double(guide: *const c_void, radius: i32, eps: f64) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createQuaternionImage_const__InputArrayR_const__OutputArrayR(img: *const c_void, qimg: *const c_void) -> Result_void;
		pub fn cv_ximgproc_createRFFeatureGetter() -> Result<*mut c_void>;
		pub fn cv_ximgproc_createRICInterpolator() -> Result<*mut c_void>;
		pub fn cv_ximgproc_createRightMatcher_Ptr_StereoMatcher_(matcher_left: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createStructuredEdgeDetection_const_StringR_Ptr_const_RFFeatureGetter_(model: *const c_char, how_to_get_features: *const c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createSuperpixelLSC_const__InputArrayR_int_float(image: *const c_void, region_size: i32, ratio: f32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createSuperpixelSEEDS_int_int_int_int_int_int_int_bool(image_width: i32, image_height: i32, image_channels: i32, num_superpixels: i32, num_levels: i32, prior: i32, histogram_bins: i32, double_step: bool) -> Result<*mut c_void>;
		pub fn cv_ximgproc_createSuperpixelSLIC_const__InputArrayR_int_int_float(image: *const c_void, algorithm: i32, region_size: i32, ruler: f32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_dtFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_int_int(guide: *const c_void, src: *const c_void, dst: *const c_void, sigma_spatial: f64, sigma_color: f64, mode: i32, num_iters: i32) -> Result_void;
		pub fn cv_ximgproc_edgePreservingFilter_const__InputArrayR_const__OutputArrayR_int_double(src: *const c_void, dst: *const c_void, d: i32, threshold: f64) -> Result_void;
		pub fn cv_ximgproc_fastBilateralSolverFilter_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_double_double_int_double(guide: *const c_void, src: *const c_void, confidence: *const c_void, dst: *const c_void, sigma_spatial: f64, sigma_luma: f64, sigma_chroma: f64, lambda: f64, num_iter: i32, max_tol: f64) -> Result_void;
		pub fn cv_ximgproc_fastGlobalSmootherFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_double_int(guide: *const c_void, src: *const c_void, dst: *const c_void, lambda: f64, sigma_color: f64, lambda_attenuation: f64, num_iter: i32) -> Result_void;
		pub fn cv_ximgproc_fourierDescriptor_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, nb_elt: i32, nb_fd: i32) -> Result_void;
		pub fn cv_ximgproc_getDisparityVis_const__InputArrayR_const__OutputArrayR_double(src: *const c_void, dst: *const c_void, scale: f64) -> Result_void;
		pub fn cv_ximgproc_guidedFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_int(guide: *const c_void, src: *const c_void, dst: *const c_void, radius: i32, eps: f64, d_depth: i32) -> Result_void;
		pub fn cv_ximgproc_jointBilateralFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_double_int(joint: *const c_void, src: *const c_void, dst: *const c_void, d: i32, sigma_color: f64, sigma_space: f64, border_type: i32) -> Result_void;
		pub fn cv_ximgproc_l0Smooth_const__InputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, lambda: f64, kappa: f64) -> Result_void;
		pub fn cv_ximgproc_niBlackThreshold_const__InputArrayR_const__OutputArrayR_double_int_int_double_int_double(_src: *const c_void, _dst: *const c_void, max_value: f64, typ: i32, block_size: i32, k: f64, binarization_method: i32, r: f64) -> Result_void;
		pub fn cv_ximgproc_qconj_const__InputArrayR_const__OutputArrayR(qimg: *const c_void, qcimg: *const c_void) -> Result_void;
		pub fn cv_ximgproc_qdft_const__InputArrayR_const__OutputArrayR_int_bool(img: *const c_void, qimg: *const c_void, flags: i32, side_left: bool) -> Result_void;
		pub fn cv_ximgproc_qmultiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_qunitary_const__InputArrayR_const__OutputArrayR(qimg: *const c_void, qnimg: *const c_void) -> Result_void;
		pub fn cv_ximgproc_readGT_String_const__OutputArrayR(src_path: *mut c_char, dst: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_rl_createRLEImage_const_vector_Point3i_R_const__OutputArrayR_Size(runs: *const c_void, res: *const c_void, size: *const core::Size) -> Result_void;
		pub fn cv_ximgproc_rl_dilate_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point(rl_src: *const c_void, rl_dest: *const c_void, rl_kernel: *const c_void, anchor: *const core::Point) -> Result_void;
		pub fn cv_ximgproc_rl_erode_const__InputArrayR_const__OutputArrayR_const__InputArrayR_bool_Point(rl_src: *const c_void, rl_dest: *const c_void, rl_kernel: *const c_void, b_boundary_on: bool, anchor: *const core::Point) -> Result_void;
		pub fn cv_ximgproc_rl_getStructuringElement_int_Size(shape: i32, ksize: *const core::Size) -> Result<*mut c_void>;
		pub fn cv_ximgproc_rl_isRLMorphologyPossible_const__InputArrayR(rl_structuring_element: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_rl_morphologyEx_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_bool_Point(rl_src: *const c_void, rl_dest: *const c_void, op: i32, rl_kernel: *const c_void, b_boundary_on_for_erosion: bool, anchor: *const core::Point) -> Result_void;
		pub fn cv_ximgproc_rl_paint_const__InputOutputArrayR_const__InputArrayR_const_ScalarR(image: *const c_void, rl_src: *const c_void, value: *const core::Scalar) -> Result_void;
		pub fn cv_ximgproc_rl_threshold_const__InputArrayR_const__OutputArrayR_double_int(src: *const c_void, rl_dest: *const c_void, thresh: f64, typ: i32) -> Result_void;
		pub fn cv_ximgproc_rollingGuidanceFilter_const__InputArrayR_const__OutputArrayR_int_double_double_int_int(src: *const c_void, dst: *const c_void, d: i32, sigma_color: f64, sigma_space: f64, num_of_iter: i32, border_type: i32) -> Result_void;
		pub fn cv_ximgproc_segmentation_createGraphSegmentation_double_float_int(sigma: f64, k: f32, min_size: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentation() -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyColor() -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyFill() -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple() -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy_(s1: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(s1: *mut c_void, s2: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(s1: *mut c_void, s2: *mut c_void, s3: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(s1: *mut c_void, s2: *mut c_void, s3: *mut c_void, s4: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategySize() -> Result<*mut c_void>;
		pub fn cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyTexture() -> Result<*mut c_void>;
		pub fn cv_ximgproc_thinning_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, thinning_type: i32) -> Result_void;
		pub fn cv_ximgproc_transformFD_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(src: *const c_void, t: *const c_void, dst: *const c_void, fd_contour: bool) -> Result_void;
		pub fn cv_ximgproc_weightedMedianFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_int_const__InputArrayR(joint: *const c_void, src: *const c_void, dst: *const c_void, r: i32, sigma: f64, weight_type: i32, mask: *const c_void) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_filter_const__InputArrayR_const__OutputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, joint: *const c_void) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_collectGarbage(instance: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_create() -> Result<*mut c_void>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getSigmaS_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setSigmaS_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getSigmaR_const(instance: *const c_void) -> Result<f64>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setSigmaR_double(instance: *mut c_void, val: f64) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getTreeHeight_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setTreeHeight_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getPCAIterations_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setPCAIterations_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getAdjustOutliers_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setAdjustOutliers_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_getUseRNG_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_AdaptiveManifoldFilter_setUseRNG_bool(instance: *mut c_void, val: bool) -> Result_void;
		pub fn cv_ximgproc_ContourFitting_ContourFitting_int_int(ctr: i32, fd: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_ContourFitting_estimateTransformation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_doubleX_bool(instance: *mut c_void, src: *const c_void, dst: *const c_void, alpha_phi_st: *const c_void, dist: *mut f64, fd_contour: bool) -> Result_void;
		pub fn cv_ximgproc_ContourFitting_estimateTransformation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_doubleR_bool(instance: *mut c_void, src: *const c_void, dst: *const c_void, alpha_phi_st: *const c_void, dist: *mut f64, fd_contour: bool) -> Result_void;
		pub fn cv_ximgproc_ContourFitting_setCtrSize_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_ximgproc_ContourFitting_setFDSize_int(instance: *mut c_void, n: i32) -> Result_void;
		pub fn cv_ximgproc_ContourFitting_getCtrSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_ContourFitting_getFDSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_DTFilter_filter_const__InputArrayR_const__OutputArrayR_int(instance: *mut c_void, src: *const c_void, dst: *const c_void, d_depth: i32) -> Result_void;
		pub fn cv_ximgproc_DisparityFilter_filter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Rect_const__InputArrayR(instance: *mut c_void, disparity_map_left: *const c_void, left_view: *const c_void, filtered_disparity_map: *const c_void, disparity_map_right: *const c_void, roi: *const core::Rect, right_view: *const c_void) -> Result_void;
		pub fn cv_ximgproc_DisparityWLSFilter_getLambda(instance: *mut c_void) -> Result<f64>;
		pub fn cv_ximgproc_DisparityWLSFilter_setLambda_double(instance: *mut c_void, _lambda: f64) -> Result_void;
		pub fn cv_ximgproc_DisparityWLSFilter_getSigmaColor(instance: *mut c_void) -> Result<f64>;
		pub fn cv_ximgproc_DisparityWLSFilter_setSigmaColor_double(instance: *mut c_void, _sigma_color: f64) -> Result_void;
		pub fn cv_ximgproc_DisparityWLSFilter_getLRCthresh(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_DisparityWLSFilter_setLRCthresh_int(instance: *mut c_void, _lrc_thresh: i32) -> Result_void;
		pub fn cv_ximgproc_DisparityWLSFilter_getDepthDiscontinuityRadius(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_DisparityWLSFilter_setDepthDiscontinuityRadius_int(instance: *mut c_void, _disc_radius: i32) -> Result_void;
		pub fn cv_ximgproc_DisparityWLSFilter_getConfidenceMap(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_DisparityWLSFilter_getROI(instance: *mut c_void) -> Result<core::Rect>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setCostMap_const_MatR(instance: *mut c_void, _cost_map: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setK_int(instance: *mut c_void, _k: i32) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getK(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setSigma_float(instance: *mut c_void, _sigma: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getSigma(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setLambda_float(instance: *mut c_void, _lambda: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getLambda(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setUsePostProcessing_bool(instance: *mut c_void, _use_post_proc: bool) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getUsePostProcessing(instance: *mut c_void) -> Result<bool>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setFGSLambda_float(instance: *mut c_void, _lambda: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getFGSLambda(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeAwareInterpolator_setFGSSigma_float(instance: *mut c_void, _sigma: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeAwareInterpolator_getFGSSigma(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_getBoundingBoxes_const__InputArrayR_const__InputArrayR_vector_Rect_R_const__OutputArrayR(instance: *mut c_void, edge_map: *const c_void, orientation_map: *const c_void, boxes: *mut c_void, scores: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getAlpha_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setAlpha_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getBeta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setBeta_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getEta_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setEta_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getMinScore_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setMinScore_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getMaxBoxes_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_EdgeBoxes_setMaxBoxes_int(instance: *mut c_void, value: i32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getEdgeMinMag_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setEdgeMinMag_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getEdgeMergeThr_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setEdgeMergeThr_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getClusterMinMag_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setClusterMinMag_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getMaxAspectRatio_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setMaxAspectRatio_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getMinBoxArea_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setMinBoxArea_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getGamma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setGamma_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeBoxes_getKappa_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_EdgeBoxes_setKappa_float(instance: *mut c_void, value: f32) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_getPropParams_const(instance: *const c_void) -> crate::ximgproc::EdgeDrawing_Params;
		pub fn cv_ximgproc_EdgeDrawing_setPropParams_Params(instance: *mut c_void, val: *const crate::ximgproc::EdgeDrawing_Params);
		pub fn cv_ximgproc_EdgeDrawing_detectEdges_const__InputArrayR(instance: *mut c_void, src: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_getEdgeImage_const__OutputArrayR(instance: *mut c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_getGradientImage_const__OutputArrayR(instance: *mut c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_getSegments(instance: *mut c_void) -> Result<*mut c_void>;
		pub fn cv_ximgproc_EdgeDrawing_detectLines_const__OutputArrayR(instance: *mut c_void, lines: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_detectEllipses_const__OutputArrayR(instance: *mut c_void, ellipses: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_setParams_const_ParamsR(instance: *mut c_void, parameters: *const crate::ximgproc::EdgeDrawing_Params) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_Params_Params() -> Result<crate::ximgproc::EdgeDrawing_Params>;
		pub fn cv_ximgproc_EdgeDrawing_Params_read_const_FileNodeR(instance: *const crate::ximgproc::EdgeDrawing_Params, fn_: *const c_void) -> Result_void;
		pub fn cv_ximgproc_EdgeDrawing_Params_write_const_FileStorageR(instance: *const crate::ximgproc::EdgeDrawing_Params, fs: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_FastBilateralSolverFilter_filter_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, confidence: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_FastGlobalSmootherFilter_filter_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_FastLineDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, lines: *const c_void) -> Result_void;
		pub fn cv_ximgproc_FastLineDetector_drawSegments_const__InputOutputArrayR_const__InputArrayR_bool_Scalar_int(instance: *mut c_void, image: *const c_void, lines: *const c_void, draw_arrow: bool, linecolor: *const core::Scalar, linethickness: i32) -> Result_void;
		pub fn cv_ximgproc_GuidedFilter_filter_const__InputArrayR_const__OutputArrayR_int(instance: *mut c_void, src: *const c_void, dst: *const c_void, d_depth: i32) -> Result_void;
		pub fn cv_ximgproc_RFFeatureGetter_getFeatures_const_const_MatR_MatR_const_int_const_int_const_int_const_int_const_int(instance: *const c_void, src: *const c_void, features: *mut c_void, gnrm_rad: i32, gsmth_rad: i32, shrink: i32, out_num: i32, grad_num: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_setK_int(instance: *mut c_void, k: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getK_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_RICInterpolator_setCostMap_const_MatR(instance: *mut c_void, cost_map: *const c_void) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_setSuperpixelSize_int(instance: *mut c_void, sp_size: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getSuperpixelSize_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_RICInterpolator_setSuperpixelNNCnt_int(instance: *mut c_void, sp_nn: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getSuperpixelNNCnt_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_RICInterpolator_setSuperpixelRuler_float(instance: *mut c_void, ruler: f32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getSuperpixelRuler_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_RICInterpolator_setSuperpixelMode_int(instance: *mut c_void, mode: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getSuperpixelMode_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_RICInterpolator_setAlpha_float(instance: *mut c_void, alpha: f32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getAlpha_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_RICInterpolator_setModelIter_int(instance: *mut c_void, model_iter: i32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getModelIter_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_RICInterpolator_setRefineModels_bool(instance: *mut c_void, refine_modles: bool) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getRefineModels_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_RICInterpolator_setMaxFlow_float(instance: *mut c_void, max_flow: f32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getMaxFlow_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_RICInterpolator_setUseVariationalRefinement_bool(instance: *mut c_void, use_variational_refinement: bool) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getUseVariationalRefinement_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_RICInterpolator_setUseGlobalSmootherFilter_bool(instance: *mut c_void, use_fgs: bool) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getUseGlobalSmootherFilter_const(instance: *const c_void) -> Result<bool>;
		pub fn cv_ximgproc_RICInterpolator_setFGSLambda_float(instance: *mut c_void, lambda: f32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getFGSLambda_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_RICInterpolator_setFGSSigma_float(instance: *mut c_void, sigma: f32) -> Result_void;
		pub fn cv_ximgproc_RICInterpolator_getFGSSigma_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_ximgproc_RidgeDetectionFilter_create_int_int_int_int_int_double_double_int(ddepth: i32, dx: i32, dy: i32, ksize: i32, out_dtype: i32, scale: f64, delta: f64, border_type: i32) -> Result<*mut c_void>;
		pub fn cv_ximgproc_RidgeDetectionFilter_getRidgeFilteredImage_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, _img: *const c_void, out: *const c_void) -> Result_void;
		pub fn cv_ximgproc_SparseMatchInterpolator_interpolate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, from_image: *const c_void, from_points: *const c_void, to_image: *const c_void, to_points: *const c_void, dense_flow: *const c_void) -> Result_void;
		pub fn cv_ximgproc_StructuredEdgeDetection_detectEdges_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, _src: *const c_void, _dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_StructuredEdgeDetection_computeOrientation_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, _src: *const c_void, _dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_StructuredEdgeDetection_edgesNms_const_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_float_bool(instance: *const c_void, edge_image: *const c_void, orientation_image: *const c_void, _dst: *const c_void, r: i32, s: i32, m: f32, is_parallel: bool) -> Result_void;
		pub fn cv_ximgproc_SuperpixelLSC_getNumberOfSuperpixels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_SuperpixelLSC_iterate_int(instance: *mut c_void, num_iterations: i32) -> Result_void;
		pub fn cv_ximgproc_SuperpixelLSC_getLabels_const_const__OutputArrayR(instance: *const c_void, labels_out: *const c_void) -> Result_void;
		pub fn cv_ximgproc_SuperpixelLSC_getLabelContourMask_const_const__OutputArrayR_bool(instance: *const c_void, image: *const c_void, thick_line: bool) -> Result_void;
		pub fn cv_ximgproc_SuperpixelLSC_enforceLabelConnectivity_int(instance: *mut c_void, min_element_size: i32) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSEEDS_getNumberOfSuperpixels(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_SuperpixelSEEDS_iterate_const__InputArrayR_int(instance: *mut c_void, img: *const c_void, num_iterations: i32) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSEEDS_getLabels_const__OutputArrayR(instance: *mut c_void, labels_out: *const c_void) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSEEDS_getLabelContourMask_const__OutputArrayR_bool(instance: *mut c_void, image: *const c_void, thick_line: bool) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSLIC_getNumberOfSuperpixels_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_ximgproc_SuperpixelSLIC_iterate_int(instance: *mut c_void, num_iterations: i32) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSLIC_getLabels_const_const__OutputArrayR(instance: *const c_void, labels_out: *const c_void) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSLIC_getLabelContourMask_const_const__OutputArrayR_bool(instance: *const c_void, image: *const c_void, thick_line: bool) -> Result_void;
		pub fn cv_ximgproc_SuperpixelSLIC_enforceLabelConnectivity_int(instance: *mut c_void, min_element_size: i32) -> Result_void;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_processImage_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_setSigma_double(instance: *mut c_void, sigma: f64) -> Result_void;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_getSigma(instance: *mut c_void) -> Result<f64>;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_setK_float(instance: *mut c_void, k: f32) -> Result_void;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_getK(instance: *mut c_void) -> Result<f32>;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_setMinSize_int(instance: *mut c_void, min_size: i32) -> Result_void;
		pub fn cv_ximgproc_segmentation_GraphSegmentation_getMinSize(instance: *mut c_void) -> Result<i32>;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_setBaseImage_const__InputArrayR(instance: *mut c_void, img: *const c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSingleStrategy_int_float(instance: *mut c_void, k: i32, sigma: f32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSelectiveSearchFast_int_int_float(instance: *mut c_void, base_k: i32, inc_k: i32, sigma: f32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSelectiveSearchQuality_int_int_float(instance: *mut c_void, base_k: i32, inc_k: i32, sigma: f32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_addImage_const__InputArrayR(instance: *mut c_void, img: *const c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearImages(instance: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_addGraphSegmentation_Ptr_GraphSegmentation_(instance: *mut c_void, g: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearGraphSegmentations(instance: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_addStrategy_Ptr_SelectiveSearchSegmentationStrategy_(instance: *mut c_void, s: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearStrategies(instance: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentation_process_vector_Rect_R(instance: *mut c_void, rects: *mut c_void) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_setImage_const__InputArrayR_const__InputArrayR_const__InputArrayR_int(instance: *mut c_void, img: *const c_void, regions: *const c_void, sizes: *const c_void, image_id: i32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_get_int_int(instance: *mut c_void, r1: i32, r2: i32) -> Result<f32>;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_merge_int_int(instance: *mut c_void, r1: i32, r2: i32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_addStrategy_Ptr_SelectiveSearchSegmentationStrategy__float(instance: *mut c_void, g: *mut c_void, weight: f32) -> Result_void;
		pub fn cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_clearStrategies(instance: *mut c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_ximgproc)]
pub use ximgproc_sys::*;

#[cfg(ocvrs_has_module_xobjdetect)]
mod xobjdetect_sys {
	use super::*;

	extern "C" {
		pub fn cv_xobjdetect_WBDetector_read_const_FileNodeR(instance: *mut c_void, node: *const c_void) -> Result_void;
		pub fn cv_xobjdetect_WBDetector_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void) -> Result_void;
		pub fn cv_xobjdetect_WBDetector_train_const_stringR_const_stringR(instance: *mut c_void, pos_samples: *const c_char, neg_imgs: *const c_char) -> Result_void;
		pub fn cv_xobjdetect_WBDetector_detect_const_MatR_vector_Rect_R_vector_double_R(instance: *mut c_void, img: *const c_void, bboxes: *mut c_void, confidences: *mut c_void) -> Result_void;
		pub fn cv_xobjdetect_WBDetector_create() -> Result<*mut c_void>;
	}
}
#[cfg(ocvrs_has_module_xobjdetect)]
pub use xobjdetect_sys::*;

#[cfg(ocvrs_has_module_xphoto)]
mod xphoto_sys {
	use super::*;

	extern "C" {
		pub fn cv_xphoto_applyChannelGains_const__InputArrayR_const__OutputArrayR_float_float_float(src: *const c_void, dst: *const c_void, gain_b: f32, gain_g: f32, gain_r: f32) -> Result_void;
		pub fn cv_xphoto_bm3dDenoising_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_float_int_int_int_int_int_int_float_int_int_int(src: *const c_void, dst_step1: *const c_void, dst_step2: *const c_void, h: f32, template_window_size: i32, search_window_size: i32, block_matching_step1: i32, block_matching_step2: i32, group_size: i32, sliding_step: i32, beta: f32, norm_type: i32, step: i32, transform_type: i32) -> Result_void;
		pub fn cv_xphoto_bm3dDenoising_const__InputArrayR_const__OutputArrayR_float_int_int_int_int_int_int_float_int_int_int(src: *const c_void, dst: *const c_void, h: f32, template_window_size: i32, search_window_size: i32, block_matching_step1: i32, block_matching_step2: i32, group_size: i32, sliding_step: i32, beta: f32, norm_type: i32, step: i32, transform_type: i32) -> Result_void;
		pub fn cv_xphoto_createGrayworldWB() -> Result<*mut c_void>;
		pub fn cv_xphoto_createLearningBasedWB_const_StringR(path_to_model: *const c_char) -> Result<*mut c_void>;
		pub fn cv_xphoto_createSimpleWB() -> Result<*mut c_void>;
		pub fn cv_xphoto_createTonemapDurand_float_float_float_float_float(gamma: f32, contrast: f32, saturation: f32, sigma_color: f32, sigma_space: f32) -> Result<*mut c_void>;
		pub fn cv_xphoto_dctDenoising_const_MatR_MatR_const_double_const_int(src: *const c_void, dst: *mut c_void, sigma: f64, psize: i32) -> Result_void;
		pub fn cv_xphoto_inpaint_const_MatR_const_MatR_MatR_const_int(src: *const c_void, mask: *const c_void, dst: *mut c_void, algorithm_type: i32) -> Result_void;
		pub fn cv_xphoto_oilPainting_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, size: i32, dyn_ratio: i32) -> Result_void;
		pub fn cv_xphoto_oilPainting_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, size: i32, dyn_ratio: i32, code: i32) -> Result_void;
		pub fn cv_xphoto_GrayworldWB_getSaturationThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_GrayworldWB_setSaturationThreshold_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_LearningBasedWB_extractSimpleFeatures_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
		pub fn cv_xphoto_LearningBasedWB_getRangeMaxVal_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xphoto_LearningBasedWB_setRangeMaxVal_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_xphoto_LearningBasedWB_getSaturationThreshold_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_LearningBasedWB_setSaturationThreshold_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_LearningBasedWB_getHistBinNum_const(instance: *const c_void) -> Result<i32>;
		pub fn cv_xphoto_LearningBasedWB_setHistBinNum_int(instance: *mut c_void, val: i32) -> Result_void;
		pub fn cv_xphoto_SimpleWB_getInputMin_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_SimpleWB_setInputMin_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_SimpleWB_getInputMax_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_SimpleWB_setInputMax_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_SimpleWB_getOutputMin_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_SimpleWB_setOutputMin_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_SimpleWB_getOutputMax_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_SimpleWB_setOutputMax_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_SimpleWB_getP_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_SimpleWB_setP_float(instance: *mut c_void, val: f32) -> Result_void;
		pub fn cv_xphoto_TonemapDurand_getSaturation_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_TonemapDurand_setSaturation_float(instance: *mut c_void, saturation: f32) -> Result_void;
		pub fn cv_xphoto_TonemapDurand_getContrast_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_TonemapDurand_setContrast_float(instance: *mut c_void, contrast: f32) -> Result_void;
		pub fn cv_xphoto_TonemapDurand_getSigmaSpace_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_TonemapDurand_setSigmaSpace_float(instance: *mut c_void, sigma_space: f32) -> Result_void;
		pub fn cv_xphoto_TonemapDurand_getSigmaColor_const(instance: *const c_void) -> Result<f32>;
		pub fn cv_xphoto_TonemapDurand_setSigmaColor_float(instance: *mut c_void, sigma_color: f32) -> Result_void;
		pub fn cv_xphoto_WhiteBalancer_balanceWhite_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void) -> Result_void;
	}
}
#[cfg(ocvrs_has_module_xphoto)]
pub use xphoto_sys::*;

pub use crate::manual::sys::*;
