#include "ocvrs_common.hpp"
#include <opencv2/ximgproc.hpp>
#include "ximgproc_types.hpp"

extern "C" {
	// BrightEdges(cv::Mat &, cv::Mat &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/brightedges.hpp:48
	Result_void cv_ximgproc_BrightEdges_MatR_MatR_int_int_int(cv::Mat* _original, cv::Mat* _edgeview, int contrast, int shortrange, int longrange) {
		try {
			cv::ximgproc::BrightEdges(*_original, *_edgeview, contrast, shortrange, longrange);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// FastHoughTransform(cv::InputArray, cv::OutputArray, int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fast_hough_transform.hpp:133
	Result_void cv_ximgproc_FastHoughTransform_const__InputArrayR_const__OutputArrayR_int_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int dstMatDepth, int angleRange, int op, int makeSkew) {
		try {
			cv::ximgproc::FastHoughTransform(*src, *dst, dstMatDepth, angleRange, op, makeSkew);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GradientDericheX(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/deriche_filter.hpp:72
	Result_void cv_ximgproc_GradientDericheX_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* op, const cv::_OutputArray* dst, double alpha, double omega) {
		try {
			cv::ximgproc::GradientDericheX(*op, *dst, alpha, omega);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GradientDericheY(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/deriche_filter.hpp:60
	Result_void cv_ximgproc_GradientDericheY_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* op, const cv::_OutputArray* dst, double alpha, double omega) {
		try {
			cv::ximgproc::GradientDericheY(*op, *dst, alpha, omega);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GradientPaillouX(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/paillou_filter.hpp:62
	Result_void cv_ximgproc_GradientPaillouX_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* op, const cv::_OutputArray* _dst, double alpha, double omega) {
		try {
			cv::ximgproc::GradientPaillouX(*op, *_dst, alpha, omega);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GradientPaillouY(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/paillou_filter.hpp:61
	Result_void cv_ximgproc_GradientPaillouY_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* op, const cv::_OutputArray* _dst, double alpha, double omega) {
		try {
			cv::ximgproc::GradientPaillouY(*op, *_dst, alpha, omega);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HoughPoint2Line(const cv::Point &, cv::InputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fast_hough_transform.hpp:155
	Result<cv::Vec4i> cv_ximgproc_HoughPoint2Line_const_PointR_const__InputArrayR_int_int_int(const cv::Point* houghPoint, const cv::_InputArray* srcImgInfo, int angleRange, int makeSkew, int rules) {
		try {
			cv::Vec4i ret = cv::ximgproc::HoughPoint2Line(*houghPoint, *srcImgInfo, angleRange, makeSkew, rules);
			return Ok<cv::Vec4i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec4i>))
	}
	
	// PeiLinNormalization(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/peilin.hpp:26
	Result<cv::Matx23d> cv_ximgproc_PeiLinNormalization_const__InputArrayR(const cv::_InputArray* I) {
		try {
			cv::Matx23d ret = cv::ximgproc::PeiLinNormalization(*I);
			return Ok<cv::Matx23d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx23d>))
	}
	
	// PeiLinNormalization(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/peilin.hpp:28
	Result_void cv_ximgproc_PeiLinNormalization_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* I, const cv::_OutputArray* T) {
		try {
			cv::ximgproc::PeiLinNormalization(*I, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// amFilter(cv::InputArray, cv::InputArray, cv::OutputArray, double, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:284
	Result_void cv_ximgproc_amFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_bool(const cv::_InputArray* joint, const cv::_InputArray* src, const cv::_OutputArray* dst, double sigma_s, double sigma_r, bool adjust_outliers) {
		try {
			cv::ximgproc::amFilter(*joint, *src, *dst, sigma_s, sigma_r, adjust_outliers);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// anisotropicDiffusion(cv::InputArray, cv::OutputArray, float, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc.hpp:209
	Result_void cv_ximgproc_anisotropicDiffusion_const__InputArrayR_const__OutputArrayR_float_float_int(const cv::_InputArray* src, const cv::_OutputArray* dst, float alpha, float K, int niters) {
		try {
			cv::ximgproc::anisotropicDiffusion(*src, *dst, alpha, K, niters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bilateralTextureFilter(cv::InputArray, cv::OutputArray, int, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:339
	Result_void cv_ximgproc_bilateralTextureFilter_const__InputArrayR_const__OutputArrayR_int_int_double_double(const cv::_InputArray* src, const cv::_OutputArray* dst, int fr, int numIter, double sigmaAlpha, double sigmaAvg) {
		try {
			cv::ximgproc::bilateralTextureFilter(*src, *dst, fr, numIter, sigmaAlpha, sigmaAvg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// colorMatchTemplate(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:62
	Result_void cv_ximgproc_colorMatchTemplate_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* img, const cv::_InputArray* templ, const cv::_OutputArray* result) {
		try {
			cv::ximgproc::colorMatchTemplate(*img, *templ, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeBadPixelPercent(cv::InputArray, cv::InputArray, cv::Rect, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:193
	Result<double> cv_ximgproc_computeBadPixelPercent_const__InputArrayR_const__InputArrayR_Rect_int(const cv::_InputArray* GT, const cv::_InputArray* src, cv::Rect* ROI, int thresh) {
		try {
			double ret = cv::ximgproc::computeBadPixelPercent(*GT, *src, *ROI, thresh);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// computeMSE(cv::InputArray, cv::InputArray, cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:177
	Result<double> cv_ximgproc_computeMSE_const__InputArrayR_const__InputArrayR_Rect(const cv::_InputArray* GT, const cv::_InputArray* src, cv::Rect* ROI) {
		try {
			double ret = cv::ximgproc::computeMSE(*GT, *src, *ROI);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// contourSampling(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:106
	Result_void cv_ximgproc_contourSampling_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* out, int nbElt) {
		try {
			cv::ximgproc::contourSampling(*src, *out, nbElt);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// covarianceEstimation(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/estimated_covariance.hpp:77
	Result_void cv_ximgproc_covarianceEstimation_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int windowRows, int windowCols) {
		try {
			cv::ximgproc::covarianceEstimation(*src, *dst, windowRows, windowCols);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createAMFilter(double, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:262
	Result<cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>*> cv_ximgproc_createAMFilter_double_double_bool(double sigma_s, double sigma_r, bool adjust_outliers) {
		try {
			cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter> ret = cv::ximgproc::createAMFilter(sigma_s, sigma_r, adjust_outliers);
			return Ok(new cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>*>))
	}
	
	// createContourFitting(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:114
	Result<cv::Ptr<cv::ximgproc::ContourFitting>*> cv_ximgproc_createContourFitting_int_int(int ctr, int fd) {
		try {
			cv::Ptr<cv::ximgproc::ContourFitting> ret = cv::ximgproc::createContourFitting(ctr, fd);
			return Ok(new cv::Ptr<cv::ximgproc::ContourFitting>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::ContourFitting>*>))
	}
	
	// createDTFilter(cv::InputArray, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:102
	Result<cv::Ptr<cv::ximgproc::DTFilter>*> cv_ximgproc_createDTFilter_const__InputArrayR_double_double_int_int(const cv::_InputArray* guide, double sigmaSpatial, double sigmaColor, int mode, int numIters) {
		try {
			cv::Ptr<cv::ximgproc::DTFilter> ret = cv::ximgproc::createDTFilter(*guide, sigmaSpatial, sigmaColor, mode, numIters);
			return Ok(new cv::Ptr<cv::ximgproc::DTFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::DTFilter>*>))
	}
	
	// createDisparityWLSFilterGeneric(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:149
	Result<cv::Ptr<cv::ximgproc::DisparityWLSFilter>*> cv_ximgproc_createDisparityWLSFilterGeneric_bool(bool use_confidence) {
		try {
			cv::Ptr<cv::ximgproc::DisparityWLSFilter> ret = cv::ximgproc::createDisparityWLSFilterGeneric(use_confidence);
			return Ok(new cv::Ptr<cv::ximgproc::DisparityWLSFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::DisparityWLSFilter>*>))
	}
	
	// createDisparityWLSFilter(Ptr<cv::StereoMatcher>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:131
	Result<cv::Ptr<cv::ximgproc::DisparityWLSFilter>*> cv_ximgproc_createDisparityWLSFilter_Ptr_StereoMatcher_(cv::Ptr<cv::StereoMatcher>* matcher_left) {
		try {
			cv::Ptr<cv::ximgproc::DisparityWLSFilter> ret = cv::ximgproc::createDisparityWLSFilter(*matcher_left);
			return Ok(new cv::Ptr<cv::ximgproc::DisparityWLSFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::DisparityWLSFilter>*>))
	}
	
	// createEdgeAwareInterpolator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:138
	Result<cv::Ptr<cv::ximgproc::EdgeAwareInterpolator>*> cv_ximgproc_createEdgeAwareInterpolator() {
		try {
			cv::Ptr<cv::ximgproc::EdgeAwareInterpolator> ret = cv::ximgproc::createEdgeAwareInterpolator();
			return Ok(new cv::Ptr<cv::ximgproc::EdgeAwareInterpolator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::EdgeAwareInterpolator>*>))
	}
	
	// createEdgeBoxes(float, float, float, float, int, float, float, float, float, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:183
	Result<cv::Ptr<cv::ximgproc::EdgeBoxes>*> cv_ximgproc_createEdgeBoxes_float_float_float_float_int_float_float_float_float_float_float_float(float alpha, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag, float maxAspectRatio, float minBoxArea, float gamma, float kappa) {
		try {
			cv::Ptr<cv::ximgproc::EdgeBoxes> ret = cv::ximgproc::createEdgeBoxes(alpha, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag, maxAspectRatio, minBoxArea, gamma, kappa);
			return Ok(new cv::Ptr<cv::ximgproc::EdgeBoxes>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::EdgeBoxes>*>))
	}
	
	// createEdgeDrawing() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:98
	Result<cv::Ptr<cv::ximgproc::EdgeDrawing>*> cv_ximgproc_createEdgeDrawing() {
		try {
			cv::Ptr<cv::ximgproc::EdgeDrawing> ret = cv::ximgproc::createEdgeDrawing();
			return Ok(new cv::Ptr<cv::ximgproc::EdgeDrawing>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::EdgeDrawing>*>))
	}
	
	// createFastBilateralSolverFilter(cv::InputArray, double, double, double, double, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:417
	Result<cv::Ptr<cv::ximgproc::FastBilateralSolverFilter>*> cv_ximgproc_createFastBilateralSolverFilter_const__InputArrayR_double_double_double_double_int_double(const cv::_InputArray* guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter, double max_tol) {
		try {
			cv::Ptr<cv::ximgproc::FastBilateralSolverFilter> ret = cv::ximgproc::createFastBilateralSolverFilter(*guide, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter, max_tol);
			return Ok(new cv::Ptr<cv::ximgproc::FastBilateralSolverFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::FastBilateralSolverFilter>*>))
	}
	
	// createFastGlobalSmootherFilter(cv::InputArray, double, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:489
	Result<cv::Ptr<cv::ximgproc::FastGlobalSmootherFilter>*> cv_ximgproc_createFastGlobalSmootherFilter_const__InputArrayR_double_double_double_int(const cv::_InputArray* guide, double lambda, double sigma_color, double lambda_attenuation, int num_iter) {
		try {
			cv::Ptr<cv::ximgproc::FastGlobalSmootherFilter> ret = cv::ximgproc::createFastGlobalSmootherFilter(*guide, lambda, sigma_color, lambda_attenuation, num_iter);
			return Ok(new cv::Ptr<cv::ximgproc::FastGlobalSmootherFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::FastGlobalSmootherFilter>*>))
	}
	
	// createFastLineDetector(int, float, double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fast_line_detector.hpp:71
	Result<cv::Ptr<cv::ximgproc::FastLineDetector>*> cv_ximgproc_createFastLineDetector_int_float_double_double_int_bool(int length_threshold, float distance_threshold, double canny_th1, double canny_th2, int canny_aperture_size, bool do_merge) {
		try {
			cv::Ptr<cv::ximgproc::FastLineDetector> ret = cv::ximgproc::createFastLineDetector(length_threshold, distance_threshold, canny_th1, canny_th2, canny_aperture_size, do_merge);
			return Ok(new cv::Ptr<cv::ximgproc::FastLineDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::FastLineDetector>*>))
	}
	
	// createGuidedFilter(cv::InputArray, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:158
	Result<cv::Ptr<cv::ximgproc::GuidedFilter>*> cv_ximgproc_createGuidedFilter_const__InputArrayR_int_double(const cv::_InputArray* guide, int radius, double eps) {
		try {
			cv::Ptr<cv::ximgproc::GuidedFilter> ret = cv::ximgproc::createGuidedFilter(*guide, radius, eps);
			return Ok(new cv::Ptr<cv::ximgproc::GuidedFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::GuidedFilter>*>))
	}
	
	// createQuaternionImage(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:22
	Result_void cv_ximgproc_createQuaternionImage_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* img, const cv::_OutputArray* qimg) {
		try {
			cv::ximgproc::createQuaternionImage(*img, *qimg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createRFFeatureGetter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:91
	Result<cv::Ptr<cv::ximgproc::RFFeatureGetter>*> cv_ximgproc_createRFFeatureGetter() {
		try {
			cv::Ptr<cv::ximgproc::RFFeatureGetter> ret = cv::ximgproc::createRFFeatureGetter();
			return Ok(new cv::Ptr<cv::ximgproc::RFFeatureGetter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::RFFeatureGetter>*>))
	}
	
	// createRICInterpolator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:265
	Result<cv::Ptr<cv::ximgproc::RICInterpolator>*> cv_ximgproc_createRICInterpolator() {
		try {
			cv::Ptr<cv::ximgproc::RICInterpolator> ret = cv::ximgproc::createRICInterpolator();
			return Ok(new cv::Ptr<cv::ximgproc::RICInterpolator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::RICInterpolator>*>))
	}
	
	// createRightMatcher(Ptr<cv::StereoMatcher>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:139
	Result<cv::Ptr<cv::StereoMatcher>*> cv_ximgproc_createRightMatcher_Ptr_StereoMatcher_(cv::Ptr<cv::StereoMatcher>* matcher_left) {
		try {
			cv::Ptr<cv::StereoMatcher> ret = cv::ximgproc::createRightMatcher(*matcher_left);
			return Ok(new cv::Ptr<cv::StereoMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::StereoMatcher>*>))
	}
	
	// createStructuredEdgeDetection(const cv::String &, Ptr<const cv::ximgproc::RFFeatureGetter>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:140
	Result<cv::Ptr<cv::ximgproc::StructuredEdgeDetection>*> cv_ximgproc_createStructuredEdgeDetection_const_StringR_Ptr_const_RFFeatureGetter_(const char* model, cv::Ptr<const cv::ximgproc::RFFeatureGetter>* howToGetFeatures) {
		try {
			cv::Ptr<cv::ximgproc::StructuredEdgeDetection> ret = cv::ximgproc::createStructuredEdgeDetection(std::string(model), *howToGetFeatures);
			return Ok(new cv::Ptr<cv::ximgproc::StructuredEdgeDetection>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::StructuredEdgeDetection>*>))
	}
	
	// createSuperpixelLSC(cv::InputArray, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:150
	Result<cv::Ptr<cv::ximgproc::SuperpixelLSC>*> cv_ximgproc_createSuperpixelLSC_const__InputArrayR_int_float(const cv::_InputArray* image, int region_size, float ratio) {
		try {
			cv::Ptr<cv::ximgproc::SuperpixelLSC> ret = cv::ximgproc::createSuperpixelLSC(*image, region_size, ratio);
			return Ok(new cv::Ptr<cv::ximgproc::SuperpixelLSC>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::SuperpixelLSC>*>))
	}
	
	// createSuperpixelSEEDS(int, int, int, int, int, int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/seeds.hpp:173
	Result<cv::Ptr<cv::ximgproc::SuperpixelSEEDS>*> cv_ximgproc_createSuperpixelSEEDS_int_int_int_int_int_int_int_bool(int image_width, int image_height, int image_channels, int num_superpixels, int num_levels, int prior, int histogram_bins, bool double_step) {
		try {
			cv::Ptr<cv::ximgproc::SuperpixelSEEDS> ret = cv::ximgproc::createSuperpixelSEEDS(image_width, image_height, image_channels, num_superpixels, num_levels, prior, histogram_bins, double_step);
			return Ok(new cv::Ptr<cv::ximgproc::SuperpixelSEEDS>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::SuperpixelSEEDS>*>))
	}
	
	// createSuperpixelSLIC(cv::InputArray, int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:160
	Result<cv::Ptr<cv::ximgproc::SuperpixelSLIC>*> cv_ximgproc_createSuperpixelSLIC_const__InputArrayR_int_int_float(const cv::_InputArray* image, int algorithm, int region_size, float ruler) {
		try {
			cv::Ptr<cv::ximgproc::SuperpixelSLIC> ret = cv::ximgproc::createSuperpixelSLIC(*image, algorithm, region_size, ruler);
			return Ok(new cv::Ptr<cv::ximgproc::SuperpixelSLIC>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::SuperpixelSLIC>*>))
	}
	
	// dtFilter(cv::InputArray, cv::InputArray, cv::OutputArray, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:121
	Result_void cv_ximgproc_dtFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_int_int(const cv::_InputArray* guide, const cv::_InputArray* src, const cv::_OutputArray* dst, double sigmaSpatial, double sigmaColor, int mode, int numIters) {
		try {
			cv::ximgproc::dtFilter(*guide, *src, *dst, sigmaSpatial, sigmaColor, mode, numIters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// edgePreservingFilter(cv::InputArray, cv::OutputArray, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgepreserving_filter.hpp:27
	Result_void cv_ximgproc_edgePreservingFilter_const__InputArrayR_const__OutputArrayR_int_double(const cv::_InputArray* src, const cv::_OutputArray* dst, int d, double threshold) {
		try {
			cv::ximgproc::edgePreservingFilter(*src, *dst, d, threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fastBilateralSolverFilter(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, double, double, double, double, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:448
	Result_void cv_ximgproc_fastBilateralSolverFilter_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_double_double_int_double(const cv::_InputArray* guide, const cv::_InputArray* src, const cv::_InputArray* confidence, const cv::_OutputArray* dst, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter, double max_tol) {
		try {
			cv::ximgproc::fastBilateralSolverFilter(*guide, *src, *confidence, *dst, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter, max_tol);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fastGlobalSmootherFilter(cv::InputArray, cv::InputArray, cv::OutputArray, double, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:509
	Result_void cv_ximgproc_fastGlobalSmootherFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_double_int(const cv::_InputArray* guide, const cv::_InputArray* src, const cv::_OutputArray* dst, double lambda, double sigma_color, double lambda_attenuation, int num_iter) {
		try {
			cv::ximgproc::fastGlobalSmootherFilter(*guide, *src, *dst, lambda, sigma_color, lambda_attenuation, num_iter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fourierDescriptor(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:87
	Result_void cv_ximgproc_fourierDescriptor_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int nbElt, int nbFD) {
		try {
			cv::ximgproc::fourierDescriptor(*src, *dst, nbElt, nbFD);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDisparityVis(cv::InputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:204
	Result_void cv_ximgproc_getDisparityVis_const__InputArrayR_const__OutputArrayR_double(const cv::_InputArray* src, const cv::_OutputArray* dst, double scale) {
		try {
			cv::ximgproc::getDisparityVis(*src, *dst, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// guidedFilter(cv::InputArray, cv::InputArray, cv::OutputArray, int, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:180
	Result_void cv_ximgproc_guidedFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_int(const cv::_InputArray* guide, const cv::_InputArray* src, const cv::_OutputArray* dst, int radius, double eps, int dDepth) {
		try {
			cv::ximgproc::guidedFilter(*guide, *src, *dst, radius, eps, dDepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// jointBilateralFilter(cv::InputArray, cv::InputArray, cv::OutputArray, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:317
	Result_void cv_ximgproc_jointBilateralFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_double_int(const cv::_InputArray* joint, const cv::_InputArray* src, const cv::_OutputArray* dst, int d, double sigmaColor, double sigmaSpace, int borderType) {
		try {
			cv::ximgproc::jointBilateralFilter(*joint, *src, *dst, d, sigmaColor, sigmaSpace, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// l0Smooth(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:523
	Result_void cv_ximgproc_l0Smooth_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* src, const cv::_OutputArray* dst, double lambda, double kappa) {
		try {
			cv::ximgproc::l0Smooth(*src, *dst, lambda, kappa);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// niBlackThreshold(cv::InputArray, cv::OutputArray, double, int, int, double, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc.hpp:174
	Result_void cv_ximgproc_niBlackThreshold_const__InputArrayR_const__OutputArrayR_double_int_int_double_int_double(const cv::_InputArray* _src, const cv::_OutputArray* _dst, double maxValue, int type, int blockSize, double k, int binarizationMethod, double r) {
		try {
			cv::ximgproc::niBlackThreshold(*_src, *_dst, maxValue, type, blockSize, k, binarizationMethod, r);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// qconj(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:30
	Result_void cv_ximgproc_qconj_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* qimg, const cv::_OutputArray* qcimg) {
		try {
			cv::ximgproc::qconj(*qimg, *qcimg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// qdft(cv::InputArray, cv::OutputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:54
	Result_void cv_ximgproc_qdft_const__InputArrayR_const__OutputArrayR_int_bool(const cv::_InputArray* img, const cv::_OutputArray* qimg, int flags, bool sideLeft) {
		try {
			cv::ximgproc::qdft(*img, *qimg, flags, sideLeft);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// qmultiply(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:45
	Result_void cv_ximgproc_qmultiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::ximgproc::qmultiply(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// qunitary(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/color_match.hpp:37
	Result_void cv_ximgproc_qunitary_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* qimg, const cv::_OutputArray* qnimg) {
		try {
			cv::ximgproc::qunitary(*qimg, *qnimg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// readGT(cv::String, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:164
	Result<int> cv_ximgproc_readGT_String_const__OutputArrayR(char* src_path, const cv::_OutputArray* dst) {
		try {
			int ret = cv::ximgproc::readGT(std::string(src_path), *dst);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// createRLEImage(const std::vector<cv::Point3i> &, cv::OutputArray, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:97
	Result_void cv_ximgproc_rl_createRLEImage_const_vector_Point3i_R_const__OutputArrayR_Size(const std::vector<cv::Point3i>* runs, const cv::_OutputArray* res, cv::Size* size) {
		try {
			cv::ximgproc::rl::createRLEImage(*runs, *res, *size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// dilate(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:42
	Result_void cv_ximgproc_rl_dilate_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point(const cv::_InputArray* rlSrc, const cv::_OutputArray* rlDest, const cv::_InputArray* rlKernel, cv::Point* anchor) {
		try {
			cv::ximgproc::rl::dilate(*rlSrc, *rlDest, *rlKernel, *anchor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erode(cv::InputArray, cv::OutputArray, cv::InputArray, bool, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:57
	Result_void cv_ximgproc_rl_erode_const__InputArrayR_const__OutputArrayR_const__InputArrayR_bool_Point(const cv::_InputArray* rlSrc, const cv::_OutputArray* rlDest, const cv::_InputArray* rlKernel, bool bBoundaryOn, cv::Point* anchor) {
		try {
			cv::ximgproc::rl::erode(*rlSrc, *rlDest, *rlKernel, bBoundaryOn, *anchor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getStructuringElement(int, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:68
	Result<cv::Mat*> cv_ximgproc_rl_getStructuringElement_int_Size(int shape, cv::Size* ksize) {
		try {
			cv::Mat ret = cv::ximgproc::rl::getStructuringElement(shape, *ksize);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// isRLMorphologyPossible(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:87
	Result<bool> cv_ximgproc_rl_isRLMorphologyPossible_const__InputArrayR(const cv::_InputArray* rlStructuringElement) {
		try {
			bool ret = cv::ximgproc::rl::isRLMorphologyPossible(*rlStructuringElement);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// morphologyEx(cv::InputArray, cv::OutputArray, int, cv::InputArray, bool, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:113
	Result_void cv_ximgproc_rl_morphologyEx_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_bool_Point(const cv::_InputArray* rlSrc, const cv::_OutputArray* rlDest, int op, const cv::_InputArray* rlKernel, bool bBoundaryOnForErosion, cv::Point* anchor) {
		try {
			cv::ximgproc::rl::morphologyEx(*rlSrc, *rlDest, op, *rlKernel, bBoundaryOnForErosion, *anchor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// paint(cv::InputOutputArray, cv::InputArray, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:79
	Result_void cv_ximgproc_rl_paint_const__InputOutputArrayR_const__InputArrayR_const_ScalarR(const cv::_InputOutputArray* image, const cv::_InputArray* rlSrc, const cv::Scalar* value) {
		try {
			cv::ximgproc::rl::paint(*image, *rlSrc, *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// threshold(cv::InputArray, cv::OutputArray, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/run_length_morphology.hpp:28
	Result_void cv_ximgproc_rl_threshold_const__InputArrayR_const__OutputArrayR_double_int(const cv::_InputArray* src, const cv::_OutputArray* rlDest, double thresh, int type) {
		try {
			cv::ximgproc::rl::threshold(*src, *rlDest, thresh, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rollingGuidanceFilter(cv::InputArray, cv::OutputArray, int, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:373
	Result_void cv_ximgproc_rollingGuidanceFilter_const__InputArrayR_const__OutputArrayR_int_double_double_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int d, double sigmaColor, double sigmaSpace, int numOfIter, int borderType) {
		try {
			cv::ximgproc::rollingGuidanceFilter(*src, *dst, d, sigmaColor, sigmaSpace, numOfIter, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createGraphSegmentation(double, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:69
	Result<cv::Ptr<cv::ximgproc::segmentation::GraphSegmentation>*> cv_ximgproc_segmentation_createGraphSegmentation_double_float_int(double sigma, float k, int min_size) {
		try {
			cv::Ptr<cv::ximgproc::segmentation::GraphSegmentation> ret = cv::ximgproc::segmentation::createGraphSegmentation(sigma, k, min_size);
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::GraphSegmentation>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::GraphSegmentation>*>))
	}
	
	// createSelectiveSearchSegmentation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:244
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentation() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentation();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyColor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:104
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyColor() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyColor();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyFill() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:131
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyFill() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyFill();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyMultiple() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:149
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyMultiple();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyMultiple(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:154
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy_(cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s1) {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyMultiple(*s1);
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyMultiple(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:160
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s1, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s2) {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyMultiple(*s1, *s2);
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyMultiple(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:168
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s1, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s2, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s3) {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyMultiple(*s1, *s2, *s3);
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyMultiple(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:176
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple_Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy__Ptr_SelectiveSearchSegmentationStrategy_(cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s1, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s2, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s3, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s4) {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyMultiple(*s1, *s2, *s3, *s4);
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>*>))
	}
	
	// createSelectiveSearchSegmentationStrategySize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:113
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategySize() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategySize();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>*>))
	}
	
	// createSelectiveSearchSegmentationStrategyTexture() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:122
	Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>*> cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyTexture() {
		try {
			cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture> ret = cv::ximgproc::segmentation::createSelectiveSearchSegmentationStrategyTexture();
			return Ok(new cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>*>))
	}
	
	// thinning(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc.hpp:187
	Result_void cv_ximgproc_thinning_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int thinningType) {
		try {
			cv::ximgproc::thinning(*src, *dst, thinningType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// transformFD(cv::InputArray, cv::InputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:97
	Result_void cv_ximgproc_transformFD_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(const cv::_InputArray* src, const cv::_InputArray* t, const cv::_OutputArray* dst, bool fdContour) {
		try {
			cv::ximgproc::transformFD(*src, *t, *dst, fdContour);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// weightedMedianFilter(cv::InputArray, cv::InputArray, cv::OutputArray, int, double, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/weighted_median_filter.hpp:90
	Result_void cv_ximgproc_weightedMedianFilter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_int_const__InputArrayR(const cv::_InputArray* joint, const cv::_InputArray* src, const cv::_OutputArray* dst, int r, double sigma, int weightType, const cv::_InputArray* mask) {
		try {
			cv::ximgproc::weightedMedianFilter(*joint, *src, *dst, r, sigma, weightType, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:214
	Result_void cv_ximgproc_AdaptiveManifoldFilter_filter_const__InputArrayR_const__OutputArrayR_const__InputArrayR(cv::ximgproc::AdaptiveManifoldFilter* instance, const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* joint) {
		try {
			instance->filter(*src, *dst, *joint);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:216
	Result_void cv_ximgproc_AdaptiveManifoldFilter_collectGarbage(cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:218
	Result<cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>*> cv_ximgproc_AdaptiveManifoldFilter_create() {
		try {
			cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter> ret = cv::ximgproc::AdaptiveManifoldFilter::create();
			return Ok(new cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::AdaptiveManifoldFilter>*>))
	}
	
	// getSigmaS() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:221
	Result<double> cv_ximgproc_AdaptiveManifoldFilter_getSigmaS_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			double ret = instance->getSigmaS();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSigmaS(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:223
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setSigmaS_double(cv::ximgproc::AdaptiveManifoldFilter* instance, double val) {
		try {
			instance->setSigmaS(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigmaR() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:225
	Result<double> cv_ximgproc_AdaptiveManifoldFilter_getSigmaR_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			double ret = instance->getSigmaR();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSigmaR(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:227
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setSigmaR_double(cv::ximgproc::AdaptiveManifoldFilter* instance, double val) {
		try {
			instance->setSigmaR(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTreeHeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:229
	Result<int> cv_ximgproc_AdaptiveManifoldFilter_getTreeHeight_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			int ret = instance->getTreeHeight();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTreeHeight(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:231
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setTreeHeight_int(cv::ximgproc::AdaptiveManifoldFilter* instance, int val) {
		try {
			instance->setTreeHeight(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPCAIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:233
	Result<int> cv_ximgproc_AdaptiveManifoldFilter_getPCAIterations_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			int ret = instance->getPCAIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPCAIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:235
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setPCAIterations_int(cv::ximgproc::AdaptiveManifoldFilter* instance, int val) {
		try {
			instance->setPCAIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAdjustOutliers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:237
	Result<bool> cv_ximgproc_AdaptiveManifoldFilter_getAdjustOutliers_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			bool ret = instance->getAdjustOutliers();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setAdjustOutliers(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:239
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setAdjustOutliers_bool(cv::ximgproc::AdaptiveManifoldFilter* instance, bool val) {
		try {
			instance->setAdjustOutliers(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseRNG() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:241
	Result<bool> cv_ximgproc_AdaptiveManifoldFilter_getUseRNG_const(const cv::ximgproc::AdaptiveManifoldFilter* instance) {
		try {
			bool ret = instance->getUseRNG();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseRNG(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:243
	Result_void cv_ximgproc_AdaptiveManifoldFilter_setUseRNG_bool(cv::ximgproc::AdaptiveManifoldFilter* instance, bool val) {
		try {
			instance->setUseRNG(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_ContourFitting_to_Algorithm(cv::ximgproc::ContourFitting* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_ContourFitting_delete(cv::ximgproc::ContourFitting* instance) {
		delete instance;
	}
	// ContourFitting(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:38
	Result<cv::ximgproc::ContourFitting*> cv_ximgproc_ContourFitting_ContourFitting_int_int(int ctr, int fd) {
		try {
			cv::ximgproc::ContourFitting* ret = new cv::ximgproc::ContourFitting(ctr, fd);
			return Ok<cv::ximgproc::ContourFitting*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ximgproc::ContourFitting*>))
	}
	
	// estimateTransformation(cv::InputArray, cv::InputArray, cv::OutputArray, double *, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:47
	Result_void cv_ximgproc_ContourFitting_estimateTransformation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_doubleX_bool(cv::ximgproc::ContourFitting* instance, const cv::_InputArray* src, const cv::_InputArray* dst, const cv::_OutputArray* alphaPhiST, double* dist, bool fdContour) {
		try {
			instance->estimateTransformation(*src, *dst, *alphaPhiST, dist, fdContour);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimateTransformation(cv::InputArray, cv::InputArray, cv::OutputArray, double &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:56
	Result_void cv_ximgproc_ContourFitting_estimateTransformation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_doubleR_bool(cv::ximgproc::ContourFitting* instance, const cv::_InputArray* src, const cv::_InputArray* dst, const cv::_OutputArray* alphaPhiST, double* dist, bool fdContour) {
		try {
			instance->estimateTransformation(*src, *dst, *alphaPhiST, *dist, fdContour);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCtrSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:61
	Result_void cv_ximgproc_ContourFitting_setCtrSize_int(cv::ximgproc::ContourFitting* instance, int n) {
		try {
			instance->setCtrSize(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFDSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:66
	Result_void cv_ximgproc_ContourFitting_setFDSize_int(cv::ximgproc::ContourFitting* instance, int n) {
		try {
			instance->setFDSize(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCtrSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:70
	Result<int> cv_ximgproc_ContourFitting_getCtrSize(cv::ximgproc::ContourFitting* instance) {
		try {
			int ret = instance->getCtrSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getFDSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fourier_descriptors.hpp:74
	Result<int> cv_ximgproc_ContourFitting_getFDSize(cv::ximgproc::ContourFitting* instance) {
		try {
			int ret = instance->getFDSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// filter(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:79
	Result_void cv_ximgproc_DTFilter_filter_const__InputArrayR_const__OutputArrayR_int(cv::ximgproc::DTFilter* instance, const cv::_InputArray* src, const cv::_OutputArray* dst, int dDepth) {
		try {
			instance->filter(*src, *dst, dDepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, cv::Rect, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:75
	Result_void cv_ximgproc_DisparityFilter_filter_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Rect_const__InputArrayR(cv::ximgproc::DisparityFilter* instance, const cv::_InputArray* disparity_map_left, const cv::_InputArray* left_view, const cv::_OutputArray* filtered_disparity_map, const cv::_InputArray* disparity_map_right, cv::Rect* ROI, const cv::_InputArray* right_view) {
		try {
			instance->filter(*disparity_map_left, *left_view, *filtered_disparity_map, *disparity_map_right, *ROI, *right_view);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:90
	Result<double> cv_ximgproc_DisparityWLSFilter_getLambda(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			double ret = instance->getLambda();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLambda(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:92
	Result_void cv_ximgproc_DisparityWLSFilter_setLambda_double(cv::ximgproc::DisparityWLSFilter* instance, double _lambda) {
		try {
			instance->setLambda(_lambda);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigmaColor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:97
	Result<double> cv_ximgproc_DisparityWLSFilter_getSigmaColor(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			double ret = instance->getSigmaColor();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSigmaColor(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:99
	Result_void cv_ximgproc_DisparityWLSFilter_setSigmaColor_double(cv::ximgproc::DisparityWLSFilter* instance, double _sigma_color) {
		try {
			instance->setSigmaColor(_sigma_color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLRCthresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:106
	Result<int> cv_ximgproc_DisparityWLSFilter_getLRCthresh(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			int ret = instance->getLRCthresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setLRCthresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:108
	Result_void cv_ximgproc_DisparityWLSFilter_setLRCthresh_int(cv::ximgproc::DisparityWLSFilter* instance, int _LRC_thresh) {
		try {
			instance->setLRCthresh(_LRC_thresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDepthDiscontinuityRadius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:112
	Result<int> cv_ximgproc_DisparityWLSFilter_getDepthDiscontinuityRadius(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			int ret = instance->getDepthDiscontinuityRadius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDepthDiscontinuityRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:114
	Result_void cv_ximgproc_DisparityWLSFilter_setDepthDiscontinuityRadius_int(cv::ximgproc::DisparityWLSFilter* instance, int _disc_radius) {
		try {
			instance->setDepthDiscontinuityRadius(_disc_radius);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getConfidenceMap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:119
	Result<cv::Mat*> cv_ximgproc_DisparityWLSFilter_getConfidenceMap(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			cv::Mat ret = instance->getConfidenceMap();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getROI() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/disparity_filter.hpp:122
	Result<cv::Rect> cv_ximgproc_DisparityWLSFilter_getROI(cv::ximgproc::DisparityWLSFilter* instance) {
		try {
			cv::Rect ret = instance->getROI();
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// setCostMap(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:88
	Result_void cv_ximgproc_EdgeAwareInterpolator_setCostMap_const_MatR(cv::ximgproc::EdgeAwareInterpolator* instance, const cv::Mat* _costMap) {
		try {
			instance->setCostMap(*_costMap);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setK(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:96
	Result_void cv_ximgproc_EdgeAwareInterpolator_setK_int(cv::ximgproc::EdgeAwareInterpolator* instance, int _k) {
		try {
			instance->setK(_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:98
	Result<int> cv_ximgproc_EdgeAwareInterpolator_getK(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			int ret = instance->getK();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSigma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:104
	Result_void cv_ximgproc_EdgeAwareInterpolator_setSigma_float(cv::ximgproc::EdgeAwareInterpolator* instance, float _sigma) {
		try {
			instance->setSigma(_sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:106
	Result<float> cv_ximgproc_EdgeAwareInterpolator_getSigma(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			float ret = instance->getSigma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setLambda(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:111
	Result_void cv_ximgproc_EdgeAwareInterpolator_setLambda_float(cv::ximgproc::EdgeAwareInterpolator* instance, float _lambda) {
		try {
			instance->setLambda(_lambda);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:113
	Result<float> cv_ximgproc_EdgeAwareInterpolator_getLambda(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			float ret = instance->getLambda();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setUsePostProcessing(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:118
	Result_void cv_ximgproc_EdgeAwareInterpolator_setUsePostProcessing_bool(cv::ximgproc::EdgeAwareInterpolator* instance, bool _use_post_proc) {
		try {
			instance->setUsePostProcessing(_use_post_proc);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUsePostProcessing() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:120
	Result<bool> cv_ximgproc_EdgeAwareInterpolator_getUsePostProcessing(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			bool ret = instance->getUsePostProcessing();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setFGSLambda(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:124
	Result_void cv_ximgproc_EdgeAwareInterpolator_setFGSLambda_float(cv::ximgproc::EdgeAwareInterpolator* instance, float _lambda) {
		try {
			instance->setFGSLambda(_lambda);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFGSLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:126
	Result<float> cv_ximgproc_EdgeAwareInterpolator_getFGSLambda(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			float ret = instance->getFGSLambda();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setFGSSigma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:129
	Result_void cv_ximgproc_EdgeAwareInterpolator_setFGSSigma_float(cv::ximgproc::EdgeAwareInterpolator* instance, float _sigma) {
		try {
			instance->setFGSSigma(_sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFGSSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:131
	Result<float> cv_ximgproc_EdgeAwareInterpolator_getFGSSigma(cv::ximgproc::EdgeAwareInterpolator* instance) {
		try {
			float ret = instance->getFGSSigma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getBoundingBoxes(cv::InputArray, cv::InputArray, std::vector<Rect> &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:79
	Result_void cv_ximgproc_EdgeBoxes_getBoundingBoxes_const__InputArrayR_const__InputArrayR_vector_Rect_R_const__OutputArrayR(cv::ximgproc::EdgeBoxes* instance, const cv::_InputArray* edge_map, const cv::_InputArray* orientation_map, std::vector<cv::Rect>* boxes, const cv::_OutputArray* scores) {
		try {
			instance->getBoundingBoxes(*edge_map, *orientation_map, *boxes, *scores);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:83
	Result<float> cv_ximgproc_EdgeBoxes_getAlpha_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getAlpha();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setAlpha(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:86
	Result_void cv_ximgproc_EdgeBoxes_setAlpha_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setAlpha(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBeta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:90
	Result<float> cv_ximgproc_EdgeBoxes_getBeta_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getBeta();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setBeta(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:93
	Result_void cv_ximgproc_EdgeBoxes_setBeta_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setBeta(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:97
	Result<float> cv_ximgproc_EdgeBoxes_getEta_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getEta();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setEta(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:100
	Result_void cv_ximgproc_EdgeBoxes_setEta_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setEta(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinScore() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:104
	Result<float> cv_ximgproc_EdgeBoxes_getMinScore_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getMinScore();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMinScore(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:107
	Result_void cv_ximgproc_EdgeBoxes_setMinScore_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setMinScore(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxBoxes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:111
	Result<int> cv_ximgproc_EdgeBoxes_getMaxBoxes_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			int ret = instance->getMaxBoxes();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxBoxes(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:114
	Result_void cv_ximgproc_EdgeBoxes_setMaxBoxes_int(cv::ximgproc::EdgeBoxes* instance, int value) {
		try {
			instance->setMaxBoxes(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeMinMag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:118
	Result<float> cv_ximgproc_EdgeBoxes_getEdgeMinMag_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getEdgeMinMag();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setEdgeMinMag(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:121
	Result_void cv_ximgproc_EdgeBoxes_setEdgeMinMag_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setEdgeMinMag(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeMergeThr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:125
	Result<float> cv_ximgproc_EdgeBoxes_getEdgeMergeThr_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getEdgeMergeThr();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setEdgeMergeThr(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:128
	Result_void cv_ximgproc_EdgeBoxes_setEdgeMergeThr_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setEdgeMergeThr(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getClusterMinMag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:132
	Result<float> cv_ximgproc_EdgeBoxes_getClusterMinMag_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getClusterMinMag();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setClusterMinMag(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:135
	Result_void cv_ximgproc_EdgeBoxes_setClusterMinMag_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setClusterMinMag(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxAspectRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:139
	Result<float> cv_ximgproc_EdgeBoxes_getMaxAspectRatio_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getMaxAspectRatio();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMaxAspectRatio(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:142
	Result_void cv_ximgproc_EdgeBoxes_setMaxAspectRatio_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setMaxAspectRatio(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinBoxArea() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:146
	Result<float> cv_ximgproc_EdgeBoxes_getMinBoxArea_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getMinBoxArea();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMinBoxArea(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:149
	Result_void cv_ximgproc_EdgeBoxes_setMinBoxArea_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setMinBoxArea(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:153
	Result<float> cv_ximgproc_EdgeBoxes_getGamma_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getGamma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setGamma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:156
	Result_void cv_ximgproc_EdgeBoxes_setGamma_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setGamma(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getKappa() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:160
	Result<float> cv_ximgproc_EdgeBoxes_getKappa_const(const cv::ximgproc::EdgeBoxes* instance) {
		try {
			float ret = instance->getKappa();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setKappa(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edgeboxes.hpp:163
	Result_void cv_ximgproc_EdgeBoxes_setKappa_float(cv::ximgproc::EdgeBoxes* instance, float value) {
		try {
			instance->setKappa(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// params /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:86
	cv::ximgproc::EdgeDrawing::Params cv_ximgproc_EdgeDrawing_getPropParams_const(const cv::ximgproc::EdgeDrawing* instance) {
		cv::ximgproc::EdgeDrawing::Params ret = instance->params;
		return (cv::ximgproc::EdgeDrawing::Params)ret;
	}
	
	// params /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:86
	void cv_ximgproc_EdgeDrawing_setPropParams_Params(cv::ximgproc::EdgeDrawing* instance, cv::ximgproc::EdgeDrawing::Params* val) {
		instance->params = *val;
	}
	
	// detectEdges(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:66
	Result_void cv_ximgproc_EdgeDrawing_detectEdges_const__InputArrayR(cv::ximgproc::EdgeDrawing* instance, const cv::_InputArray* src) {
		try {
			instance->detectEdges(*src);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeImage(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:67
	Result_void cv_ximgproc_EdgeDrawing_getEdgeImage_const__OutputArrayR(cv::ximgproc::EdgeDrawing* instance, const cv::_OutputArray* dst) {
		try {
			instance->getEdgeImage(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGradientImage(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:68
	Result_void cv_ximgproc_EdgeDrawing_getGradientImage_const__OutputArrayR(cv::ximgproc::EdgeDrawing* instance, const cv::_OutputArray* dst) {
		try {
			instance->getGradientImage(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSegments() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:70
	Result<std::vector<std::vector<cv::Point>>*> cv_ximgproc_EdgeDrawing_getSegments(cv::ximgproc::EdgeDrawing* instance) {
		try {
			std::vector<std::vector<cv::Point>> ret = instance->getSegments();
			return Ok(new std::vector<std::vector<cv::Point>>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<std::vector<cv::Point>>*>))
	}
	
	// detectLines(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:77
	Result_void cv_ximgproc_EdgeDrawing_detectLines_const__OutputArrayR(cv::ximgproc::EdgeDrawing* instance, const cv::_OutputArray* lines) {
		try {
			instance->detectLines(*lines);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectEllipses(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:84
	Result_void cv_ximgproc_EdgeDrawing_detectEllipses_const__OutputArrayR(cv::ximgproc::EdgeDrawing* instance, const cv::_OutputArray* ellipses) {
		try {
			instance->detectEllipses(*ellipses);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setParams(const EdgeDrawing::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:92
	Result_void cv_ximgproc_EdgeDrawing_setParams_const_ParamsR(cv::ximgproc::EdgeDrawing* instance, const cv::ximgproc::EdgeDrawing::Params* parameters) {
		try {
			instance->setParams(*parameters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:35
	Result<cv::ximgproc::EdgeDrawing::Params> cv_ximgproc_EdgeDrawing_Params_Params() {
		try {
			cv::ximgproc::EdgeDrawing::Params ret;
			return Ok<cv::ximgproc::EdgeDrawing::Params>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ximgproc::EdgeDrawing::Params>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:58
	Result_void cv_ximgproc_EdgeDrawing_Params_read_const_FileNodeR(cv::ximgproc::EdgeDrawing::Params instance, const cv::FileNode* fn) {
		try {
			instance.read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_drawing.hpp:59
	Result_void cv_ximgproc_EdgeDrawing_Params_write_const_FileStorageR(const cv::ximgproc::EdgeDrawing::Params instance, cv::FileStorage* fs) {
		try {
			instance.write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:395
	Result_void cv_ximgproc_FastBilateralSolverFilter_filter_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::ximgproc::FastBilateralSolverFilter* instance, const cv::_InputArray* src, const cv::_InputArray* confidence, const cv::_OutputArray* dst) {
		try {
			instance->filter(*src, *confidence, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:466
	Result_void cv_ximgproc_FastGlobalSmootherFilter_filter_const__InputArrayR_const__OutputArrayR(cv::ximgproc::FastGlobalSmootherFilter* instance, const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			instance->filter(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fast_line_detector.hpp:44
	Result_void cv_ximgproc_FastLineDetector_detect_const__InputArrayR_const__OutputArrayR(cv::ximgproc::FastLineDetector* instance, const cv::_InputArray* image, const cv::_OutputArray* lines) {
		try {
			instance->detect(*image, *lines);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawSegments(cv::InputOutputArray, cv::InputArray, bool, cv::Scalar, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/fast_line_detector.hpp:54
	Result_void cv_ximgproc_FastLineDetector_drawSegments_const__InputOutputArrayR_const__InputArrayR_bool_Scalar_int(cv::ximgproc::FastLineDetector* instance, const cv::_InputOutputArray* image, const cv::_InputArray* lines, bool draw_arrow, cv::Scalar* linecolor, int linethickness) {
		try {
			instance->drawSegments(*image, *lines, draw_arrow, *linecolor, linethickness);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/edge_filter.hpp:143
	Result_void cv_ximgproc_GuidedFilter_filter_const__InputArrayR_const__OutputArrayR_int(cv::ximgproc::GuidedFilter* instance, const cv::_InputArray* src, const cv::_OutputArray* dst, int dDepth) {
		try {
			instance->filter(*src, *dst, dDepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFeatures(const cv::Mat &, cv::Mat &, const int, const int, const int, const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:83
	Result_void cv_ximgproc_RFFeatureGetter_getFeatures_const_const_MatR_MatR_const_int_const_int_const_int_const_int_const_int(const cv::ximgproc::RFFeatureGetter* instance, const cv::Mat* src, cv::Mat* features, const int gnrmRad, const int gsmthRad, const int shrink, const int outNum, const int gradNum) {
		try {
			instance->getFeatures(*src, *features, gnrmRad, gsmthRad, shrink, outNum, gradNum);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setK(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:153
	Result_void cv_ximgproc_RICInterpolator_setK_int(cv::ximgproc::RICInterpolator* instance, int k) {
		try {
			instance->setK(k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:157
	Result<int> cv_ximgproc_RICInterpolator_getK_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			int ret = instance->getK();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCostMap(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:166
	Result_void cv_ximgproc_RICInterpolator_setCostMap_const_MatR(cv::ximgproc::RICInterpolator* instance, const cv::Mat* costMap) {
		try {
			instance->setCostMap(*costMap);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSuperpixelSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:170
	Result_void cv_ximgproc_RICInterpolator_setSuperpixelSize_int(cv::ximgproc::RICInterpolator* instance, int spSize) {
		try {
			instance->setSuperpixelSize(spSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSuperpixelSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:174
	Result<int> cv_ximgproc_RICInterpolator_getSuperpixelSize_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			int ret = instance->getSuperpixelSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSuperpixelNNCnt(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:178
	Result_void cv_ximgproc_RICInterpolator_setSuperpixelNNCnt_int(cv::ximgproc::RICInterpolator* instance, int spNN) {
		try {
			instance->setSuperpixelNNCnt(spNN);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSuperpixelNNCnt() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:182
	Result<int> cv_ximgproc_RICInterpolator_getSuperpixelNNCnt_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			int ret = instance->getSuperpixelNNCnt();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSuperpixelRuler(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:186
	Result_void cv_ximgproc_RICInterpolator_setSuperpixelRuler_float(cv::ximgproc::RICInterpolator* instance, float ruler) {
		try {
			instance->setSuperpixelRuler(ruler);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSuperpixelRuler() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:190
	Result<float> cv_ximgproc_RICInterpolator_getSuperpixelRuler_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			float ret = instance->getSuperpixelRuler();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSuperpixelMode(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:197
	Result_void cv_ximgproc_RICInterpolator_setSuperpixelMode_int(cv::ximgproc::RICInterpolator* instance, int mode) {
		try {
			instance->setSuperpixelMode(mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSuperpixelMode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:201
	Result<int> cv_ximgproc_RICInterpolator_getSuperpixelMode_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			int ret = instance->getSuperpixelMode();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setAlpha(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:204
	Result_void cv_ximgproc_RICInterpolator_setAlpha_float(cv::ximgproc::RICInterpolator* instance, float alpha) {
		try {
			instance->setAlpha(alpha);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:208
	Result<float> cv_ximgproc_RICInterpolator_getAlpha_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			float ret = instance->getAlpha();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setModelIter(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:211
	Result_void cv_ximgproc_RICInterpolator_setModelIter_int(cv::ximgproc::RICInterpolator* instance, int modelIter) {
		try {
			instance->setModelIter(modelIter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getModelIter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:215
	Result<int> cv_ximgproc_RICInterpolator_getModelIter_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			int ret = instance->getModelIter();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRefineModels(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:218
	Result_void cv_ximgproc_RICInterpolator_setRefineModels_bool(cv::ximgproc::RICInterpolator* instance, bool refineModles) {
		try {
			instance->setRefineModels(refineModles);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRefineModels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:222
	Result<bool> cv_ximgproc_RICInterpolator_getRefineModels_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			bool ret = instance->getRefineModels();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setMaxFlow(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:226
	Result_void cv_ximgproc_RICInterpolator_setMaxFlow_float(cv::ximgproc::RICInterpolator* instance, float maxFlow) {
		try {
			instance->setMaxFlow(maxFlow);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:230
	Result<float> cv_ximgproc_RICInterpolator_getMaxFlow_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			float ret = instance->getMaxFlow();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setUseVariationalRefinement(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:233
	Result_void cv_ximgproc_RICInterpolator_setUseVariationalRefinement_bool(cv::ximgproc::RICInterpolator* instance, bool use_variational_refinement) {
		try {
			instance->setUseVariationalRefinement(use_variational_refinement);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseVariationalRefinement() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:237
	Result<bool> cv_ximgproc_RICInterpolator_getUseVariationalRefinement_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			bool ret = instance->getUseVariationalRefinement();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseGlobalSmootherFilter(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:240
	Result_void cv_ximgproc_RICInterpolator_setUseGlobalSmootherFilter_bool(cv::ximgproc::RICInterpolator* instance, bool use_FGS) {
		try {
			instance->setUseGlobalSmootherFilter(use_FGS);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseGlobalSmootherFilter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:244
	Result<bool> cv_ximgproc_RICInterpolator_getUseGlobalSmootherFilter_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			bool ret = instance->getUseGlobalSmootherFilter();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setFGSLambda(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:247
	Result_void cv_ximgproc_RICInterpolator_setFGSLambda_float(cv::ximgproc::RICInterpolator* instance, float lambda) {
		try {
			instance->setFGSLambda(lambda);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFGSLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:251
	Result<float> cv_ximgproc_RICInterpolator_getFGSLambda_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			float ret = instance->getFGSLambda();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setFGSSigma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:254
	Result_void cv_ximgproc_RICInterpolator_setFGSSigma_float(cv::ximgproc::RICInterpolator* instance, float sigma) {
		try {
			instance->setFGSSigma(sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFGSSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:258
	Result<float> cv_ximgproc_RICInterpolator_getFGSSigma_const(const cv::ximgproc::RICInterpolator* instance) {
		try {
			float ret = instance->getFGSSigma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create(int, int, int, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/ridgefilter.hpp:42
	Result<cv::Ptr<cv::ximgproc::RidgeDetectionFilter>*> cv_ximgproc_RidgeDetectionFilter_create_int_int_int_int_int_double_double_int(int ddepth, int dx, int dy, int ksize, int out_dtype, double scale, double delta, int borderType) {
		try {
			cv::Ptr<cv::ximgproc::RidgeDetectionFilter> ret = cv::ximgproc::RidgeDetectionFilter::create(ddepth, dx, dy, ksize, out_dtype, scale, delta, borderType);
			return Ok(new cv::Ptr<cv::ximgproc::RidgeDetectionFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ximgproc::RidgeDetectionFilter>*>))
	}
	
	// getRidgeFilteredImage(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/ridgefilter.hpp:48
	Result_void cv_ximgproc_RidgeDetectionFilter_getRidgeFilteredImage_const__InputArrayR_const__OutputArrayR(cv::ximgproc::RidgeDetectionFilter* instance, const cv::_InputArray* _img, const cv::_OutputArray* out) {
		try {
			instance->getRidgeFilteredImage(*_img, *out);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// interpolate(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/sparse_match_interpolator.hpp:69
	Result_void cv_ximgproc_SparseMatchInterpolator_interpolate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::ximgproc::SparseMatchInterpolator* instance, const cv::_InputArray* from_image, const cv::_InputArray* from_points, const cv::_InputArray* to_image, const cv::_InputArray* to_points, const cv::_OutputArray* dense_flow) {
		try {
			instance->interpolate(*from_image, *from_points, *to_image, *to_points, *dense_flow);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectEdges(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:109
	Result_void cv_ximgproc_StructuredEdgeDetection_detectEdges_const_const__InputArrayR_const__OutputArrayR(const cv::ximgproc::StructuredEdgeDetection* instance, const cv::_InputArray* _src, const cv::_OutputArray* _dst) {
		try {
			instance->detectEdges(*_src, *_dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeOrientation(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:116
	Result_void cv_ximgproc_StructuredEdgeDetection_computeOrientation_const_const__InputArrayR_const__OutputArrayR(const cv::ximgproc::StructuredEdgeDetection* instance, const cv::_InputArray* _src, const cv::_OutputArray* _dst) {
		try {
			instance->computeOrientation(*_src, *_dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// edgesNms(cv::InputArray, cv::InputArray, cv::OutputArray, int, int, float, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/structured_edge_detection.hpp:129
	Result_void cv_ximgproc_StructuredEdgeDetection_edgesNms_const_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_float_bool(const cv::ximgproc::StructuredEdgeDetection* instance, const cv::_InputArray* edge_image, const cv::_InputArray* orientation_image, const cv::_OutputArray* _dst, int r, int s, float m, bool isParallel) {
		try {
			instance->edgesNms(*edge_image, *orientation_image, *_dst, r, s, m, isParallel);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumberOfSuperpixels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:78
	Result<int> cv_ximgproc_SuperpixelLSC_getNumberOfSuperpixels_const(const cv::ximgproc::SuperpixelLSC* instance) {
		try {
			int ret = instance->getNumberOfSuperpixels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// iterate(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:94
	Result_void cv_ximgproc_SuperpixelLSC_iterate_int(cv::ximgproc::SuperpixelLSC* instance, int num_iterations) {
		try {
			instance->iterate(num_iterations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabels(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:106
	Result_void cv_ximgproc_SuperpixelLSC_getLabels_const_const__OutputArrayR(const cv::ximgproc::SuperpixelLSC* instance, const cv::_OutputArray* labels_out) {
		try {
			instance->getLabels(*labels_out);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabelContourMask(cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:118
	Result_void cv_ximgproc_SuperpixelLSC_getLabelContourMask_const_const__OutputArrayR_bool(const cv::ximgproc::SuperpixelLSC* instance, const cv::_OutputArray* image, bool thick_line) {
		try {
			instance->getLabelContourMask(*image, thick_line);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// enforceLabelConnectivity(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/lsc.hpp:129
	Result_void cv_ximgproc_SuperpixelLSC_enforceLabelConnectivity_int(cv::ximgproc::SuperpixelLSC* instance, int min_element_size) {
		try {
			instance->enforceLabelConnectivity(min_element_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumberOfSuperpixels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/seeds.hpp:75
	Result<int> cv_ximgproc_SuperpixelSEEDS_getNumberOfSuperpixels(cv::ximgproc::SuperpixelSEEDS* instance) {
		try {
			int ret = instance->getNumberOfSuperpixels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// iterate(cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/seeds.hpp:99
	Result_void cv_ximgproc_SuperpixelSEEDS_iterate_const__InputArrayR_int(cv::ximgproc::SuperpixelSEEDS* instance, const cv::_InputArray* img, int num_iterations) {
		try {
			instance->iterate(*img, num_iterations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabels(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/seeds.hpp:111
	Result_void cv_ximgproc_SuperpixelSEEDS_getLabels_const__OutputArrayR(cv::ximgproc::SuperpixelSEEDS* instance, const cv::_OutputArray* labels_out) {
		try {
			instance->getLabels(*labels_out);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabelContourMask(cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/seeds.hpp:139
	Result_void cv_ximgproc_SuperpixelSEEDS_getLabelContourMask_const__OutputArrayR_bool(cv::ximgproc::SuperpixelSEEDS* instance, const cv::_OutputArray* image, bool thick_line) {
		try {
			instance->getLabelContourMask(*image, thick_line);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumberOfSuperpixels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:85
	Result<int> cv_ximgproc_SuperpixelSLIC_getNumberOfSuperpixels_const(const cv::ximgproc::SuperpixelSLIC* instance) {
		try {
			int ret = instance->getNumberOfSuperpixels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// iterate(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:101
	Result_void cv_ximgproc_SuperpixelSLIC_iterate_int(cv::ximgproc::SuperpixelSLIC* instance, int num_iterations) {
		try {
			instance->iterate(num_iterations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabels(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:113
	Result_void cv_ximgproc_SuperpixelSLIC_getLabels_const_const__OutputArrayR(const cv::ximgproc::SuperpixelSLIC* instance, const cv::_OutputArray* labels_out) {
		try {
			instance->getLabels(*labels_out);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabelContourMask(cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:125
	Result_void cv_ximgproc_SuperpixelSLIC_getLabelContourMask_const_const__OutputArrayR_bool(const cv::ximgproc::SuperpixelSLIC* instance, const cv::_OutputArray* image, bool thick_line) {
		try {
			instance->getLabelContourMask(*image, thick_line);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// enforceLabelConnectivity(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/slic.hpp:136
	Result_void cv_ximgproc_SuperpixelSLIC_enforceLabelConnectivity_int(cv::ximgproc::SuperpixelSLIC* instance, int min_element_size) {
		try {
			instance->enforceLabelConnectivity(min_element_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// processImage(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:52
	Result_void cv_ximgproc_segmentation_GraphSegmentation_processImage_const__InputArrayR_const__OutputArrayR(cv::ximgproc::segmentation::GraphSegmentation* instance, const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			instance->processImage(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:54
	Result_void cv_ximgproc_segmentation_GraphSegmentation_setSigma_double(cv::ximgproc::segmentation::GraphSegmentation* instance, double sigma) {
		try {
			instance->setSigma(sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:55
	Result<double> cv_ximgproc_segmentation_GraphSegmentation_getSigma(cv::ximgproc::segmentation::GraphSegmentation* instance) {
		try {
			double ret = instance->getSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setK(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:57
	Result_void cv_ximgproc_segmentation_GraphSegmentation_setK_float(cv::ximgproc::segmentation::GraphSegmentation* instance, float k) {
		try {
			instance->setK(k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:58
	Result<float> cv_ximgproc_segmentation_GraphSegmentation_getK(cv::ximgproc::segmentation::GraphSegmentation* instance) {
		try {
			float ret = instance->getK();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMinSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:60
	Result_void cv_ximgproc_segmentation_GraphSegmentation_setMinSize_int(cv::ximgproc::segmentation::GraphSegmentation* instance, int min_size) {
		try {
			instance->setMinSize(min_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:61
	Result<int> cv_ximgproc_segmentation_GraphSegmentation_getMinSize(cv::ximgproc::segmentation::GraphSegmentation* instance) {
		try {
			int ret = instance->getMinSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setBaseImage(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:187
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_setBaseImage_const__InputArrayR(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, const cv::_InputArray* img) {
		try {
			instance->setBaseImage(*img);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// switchToSingleStrategy(int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:193
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSingleStrategy_int_float(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, int k, float sigma) {
		try {
			instance->switchToSingleStrategy(k, sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// switchToSelectiveSearchFast(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:200
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSelectiveSearchFast_int_int_float(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, int base_k, int inc_k, float sigma) {
		try {
			instance->switchToSelectiveSearchFast(base_k, inc_k, sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// switchToSelectiveSearchQuality(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:207
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_switchToSelectiveSearchQuality_int_int_float(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, int base_k, int inc_k, float sigma) {
		try {
			instance->switchToSelectiveSearchQuality(base_k, inc_k, sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addImage(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:212
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_addImage_const__InputArrayR(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, const cv::_InputArray* img) {
		try {
			instance->addImage(*img);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearImages() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:216
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearImages(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance) {
		try {
			instance->clearImages();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addGraphSegmentation(Ptr<cv::ximgproc::segmentation::GraphSegmentation>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:221
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_addGraphSegmentation_Ptr_GraphSegmentation_(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, cv::Ptr<cv::ximgproc::segmentation::GraphSegmentation>* g) {
		try {
			instance->addGraphSegmentation(*g);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearGraphSegmentations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:225
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearGraphSegmentations(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance) {
		try {
			instance->clearGraphSegmentations();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addStrategy(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:230
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_addStrategy_Ptr_SelectiveSearchSegmentationStrategy_(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* s) {
		try {
			instance->addStrategy(*s);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearStrategies() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:234
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_clearStrategies(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance) {
		try {
			instance->clearStrategies();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// process(std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:239
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentation_process_vector_Rect_R(cv::ximgproc::segmentation::SelectiveSearchSegmentation* instance, std::vector<cv::Rect>* rects) {
		try {
			instance->process(*rects);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setImage(cv::InputArray, cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:82
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_setImage_const__InputArrayR_const__InputArrayR_const__InputArrayR_int(cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy* instance, const cv::_InputArray* img, const cv::_InputArray* regions, const cv::_InputArray* sizes, int image_id) {
		try {
			instance->setImage(*img, *regions, *sizes, image_id);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// get(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:88
	Result<float> cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_get_int_int(cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy* instance, int r1, int r2) {
		try {
			float ret = instance->get(r1, r2);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// merge(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:94
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_merge_int_int(cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy* instance, int r1, int r2) {
		try {
			instance->merge(r1, r2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addStrategy(Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:142
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_addStrategy_Ptr_SelectiveSearchSegmentationStrategy__float(cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple* instance, cv::Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>* g, float weight) {
		try {
			instance->addStrategy(*g, weight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearStrategies() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ximgproc/segmentation.hpp:145
	Result_void cv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_clearStrategies(cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple* instance) {
		try {
			instance->clearStrategies();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
