#include "ocvrs_common.hpp"
#include <opencv2/viz.hpp>
#include "viz_types.hpp"

extern "C" {
	// computeNormals(const cv::viz::Mesh &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:214
	Result_void cv_viz_computeNormals_const_MeshR_const__OutputArrayR(const cv::viz::Mesh* mesh, const cv::_OutputArray* normals) {
		try {
			cv::viz::computeNormals(*mesh, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowByName(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:97
	Result<cv::viz::Viz3d*> cv_viz_getWindowByName_const_StringR(const char* window_name) {
		try {
			cv::viz::Viz3d ret = cv::viz::getWindowByName(std::string(window_name));
			return Ok(new cv::viz::Viz3d(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Viz3d*>))
	}
	
	// imshow(const cv::String &, cv::InputArray, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:103
	Result<cv::viz::Viz3d*> cv_viz_imshow_const_StringR_const__InputArrayR_const_SizeR(const char* window_name, const cv::_InputArray* image, const cv::Size* window_size) {
		try {
			cv::viz::Viz3d ret = cv::viz::imshow(std::string(window_name), *image, *window_size);
			return Ok(new cv::viz::Viz3d(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Viz3d*>))
	}
	
	// makeCameraPose(const cv::Vec3d &, const cv::Vec3d &, const cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:84
	Result<cv::Affine3d> cv_viz_makeCameraPose_const_Vec3dR_const_Vec3dR_const_Vec3dR(const cv::Vec3d* position, const cv::Vec3d* focal_point, const cv::Vec3d* y_dir) {
		try {
			cv::Affine3d ret = cv::viz::makeCameraPose(*position, *focal_point, *y_dir);
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// makeTransformToGlobal(const cv::Vec3d &, const cv::Vec3d &, const cv::Vec3d &, const cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:73
	Result<cv::Affine3d> cv_viz_makeTransformToGlobal_const_Vec3dR_const_Vec3dR_const_Vec3dR_const_Vec3dR(const cv::Vec3d* axis_x, const cv::Vec3d* axis_y, const cv::Vec3d* axis_z, const cv::Vec3d* origin) {
		try {
			cv::Affine3d ret = cv::viz::makeTransformToGlobal(*axis_x, *axis_y, *axis_z, *origin);
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// readCloud(const cv::String &, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:160
	Result<cv::Mat*> cv_viz_readCloud_const_StringR_const__OutputArrayR_const__OutputArrayR(const char* file, const cv::_OutputArray* colors, const cv::_OutputArray* normals) {
		try {
			cv::Mat ret = cv::viz::readCloud(std::string(file), *colors, *normals);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// readMesh(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:165
	Result<cv::viz::Mesh*> cv_viz_readMesh_const_StringR(const char* file) {
		try {
			cv::viz::Mesh ret = cv::viz::readMesh(std::string(file));
			return Ok(new cv::viz::Mesh(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Mesh*>))
	}
	
	// readPose(const cv::String &, cv::Affine3d &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:175
	Result<bool> cv_viz_readPose_const_StringR_Affine3dR_const_StringR(const char* file, cv::Affine3d* pose, const char* tag) {
		try {
			bool ret = cv::viz::readPose(std::string(file), *pose, std::string(tag));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// readTrajectory(cv::OutputArray, const cv::String &, int, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:206
	Result_void cv_viz_readTrajectory_const__OutputArrayR_const_StringR_int_int_const_StringR(const cv::_OutputArray* traj, const char* files_format, int start, int end, const char* tag) {
		try {
			cv::viz::readTrajectory(*traj, std::string(files_format), start, end, std::string(tag));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unregisterAllWindows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:100
	Result_void cv_viz_unregisterAllWindows() {
		try {
			cv::viz::unregisterAllWindows();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeCloud(const cv::String &, cv::InputArray, cv::InputArray, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:151
	Result_void cv_viz_writeCloud_const_StringR_const__InputArrayR_const__InputArrayR_const__InputArrayR_bool(const char* file, const cv::_InputArray* cloud, const cv::_InputArray* colors, const cv::_InputArray* normals, bool binary) {
		try {
			cv::viz::writeCloud(std::string(file), *cloud, *colors, *normals, binary);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writePose(const cv::String &, const cv::Affine3d &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:181
	Result_void cv_viz_writePose_const_StringR_const_Affine3dR_const_StringR(const char* file, const cv::Affine3d* pose, const char* tag) {
		try {
			cv::viz::writePose(std::string(file), *pose, std::string(tag));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeTrajectory(cv::InputArray, const cv::String &, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/vizcore.hpp:193
	Result_void cv_viz_writeTrajectory_const__InputArrayR_const_StringR_int_const_StringR(const cv::_InputArray* traj, const char* files_format, int start, const char* tag) {
		try {
			cv::viz::writeTrajectory(*traj, std::string(files_format), start, std::string(tag));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Camera_delete(cv::viz::Camera* instance) {
		delete instance;
	}
	// Camera(double, double, double, double, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:176
	Result<cv::viz::Camera*> cv_viz_Camera_Camera_double_double_double_double_const_SizeR(double fx, double fy, double cx, double cy, const cv::Size* window_size) {
		try {
			cv::viz::Camera* ret = new cv::viz::Camera(fx, fy, cx, cy, *window_size);
			return Ok<cv::viz::Camera*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	// Camera(const cv::Vec2d &, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:183
	Result<cv::viz::Camera*> cv_viz_Camera_Camera_const_Vec2dR_const_SizeR(const cv::Vec2d* fov, const cv::Size* window_size) {
		try {
			cv::viz::Camera* ret = new cv::viz::Camera(*fov, *window_size);
			return Ok<cv::viz::Camera*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	// Camera(const cv::Matx33d &, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:197
	Result<cv::viz::Camera*> cv_viz_Camera_Camera_const_Matx33dR_const_SizeR(const cv::Matx33d* K, const cv::Size* window_size) {
		try {
			cv::viz::Camera* ret = new cv::viz::Camera(*K, *window_size);
			return Ok<cv::viz::Camera*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	// Camera(const cv::Matx44d &, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:213
	Result<cv::viz::Camera*> cv_viz_Camera_Camera_const_Matx44dR_const_SizeR(const cv::Matx44d* proj, const cv::Size* window_size) {
		try {
			cv::viz::Camera* ret = new cv::viz::Camera(*proj, *window_size);
			return Ok<cv::viz::Camera*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	// getClip() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:215
	Result<const cv::Vec2d> cv_viz_Camera_getClip_const(const cv::viz::Camera* instance) {
		try {
			const cv::Vec2d ret = instance->getClip();
			return Ok<const cv::Vec2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Vec2d>))
	}
	
	// setClip(const cv::Vec2d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:216
	Result_void cv_viz_Camera_setClip_const_Vec2dR(cv::viz::Camera* instance, const cv::Vec2d* clip) {
		try {
			instance->setClip(*clip);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:218
	Result<const cv::Size> cv_viz_Camera_getWindowSize_const(const cv::viz::Camera* instance) {
		try {
			const cv::Size ret = instance->getWindowSize();
			return Ok<const cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Size>))
	}
	
	// setWindowSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:219
	Result_void cv_viz_Camera_setWindowSize_const_SizeR(cv::viz::Camera* instance, const cv::Size* window_size) {
		try {
			instance->setWindowSize(*window_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFov() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:221
	Result<const cv::Vec2d> cv_viz_Camera_getFov_const(const cv::viz::Camera* instance) {
		try {
			const cv::Vec2d ret = instance->getFov();
			return Ok<const cv::Vec2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Vec2d>))
	}
	
	// setFov(const cv::Vec2d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:222
	Result_void cv_viz_Camera_setFov_const_Vec2dR(cv::viz::Camera* instance, const cv::Vec2d* fov) {
		try {
			instance->setFov(*fov);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPrincipalPoint() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:224
	Result<const cv::Vec2d> cv_viz_Camera_getPrincipalPoint_const(const cv::viz::Camera* instance) {
		try {
			const cv::Vec2d ret = instance->getPrincipalPoint();
			return Ok<const cv::Vec2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Vec2d>))
	}
	
	// getFocalLength() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:225
	Result<const cv::Vec2d> cv_viz_Camera_getFocalLength_const(const cv::viz::Camera* instance) {
		try {
			const cv::Vec2d ret = instance->getFocalLength();
			return Ok<const cv::Vec2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Vec2d>))
	}
	
	// computeProjectionMatrix(cv::Matx44d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:240
	Result_void cv_viz_Camera_computeProjectionMatrix_const_Matx44dR(const cv::viz::Camera* instance, cv::Matx44d* proj) {
		try {
			instance->computeProjectionMatrix(*proj);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// KinectCamera(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:250
	Result<cv::viz::Camera*> cv_viz_Camera_KinectCamera_const_SizeR(const cv::Size* window_size) {
		try {
			cv::viz::Camera ret = cv::viz::Camera::KinectCamera(*window_size);
			return Ok(new cv::viz::Camera(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	void cv_Color_delete(cv::viz::Color* instance) {
		delete instance;
	}
	// Color() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:66
	Result<cv::viz::Color*> cv_viz_Color_Color() {
		try {
			cv::viz::Color* ret = new cv::viz::Color();
			return Ok<cv::viz::Color*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// Color(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:68
	Result<cv::viz::Color*> cv_viz_Color_Color_double(double gray) {
		try {
			cv::viz::Color* ret = new cv::viz::Color(gray);
			return Ok<cv::viz::Color*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// Color(double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:69
	Result<cv::viz::Color*> cv_viz_Color_Color_double_double_double(double blue, double green, double red) {
		try {
			cv::viz::Color* ret = new cv::viz::Color(blue, green, red);
			return Ok<cv::viz::Color*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// Color(const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:71
	Result<cv::viz::Color*> cv_viz_Color_Color_const_ScalarR(const cv::Scalar* color) {
		try {
			cv::viz::Color* ret = new cv::viz::Color(*color);
			return Ok<cv::viz::Color*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// operator Vec() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:73
	Result<cv::Vec3b> cv_viz_Color_operator_cv_Vec3b_const(const cv::viz::Color* instance) {
		try {
			cv::Vec3b ret = instance->operator cv::Vec3b();
			return Ok<cv::Vec3b>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3b>))
	}
	
	// black() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:75
	Result<cv::viz::Color*> cv_viz_Color_black() {
		try {
			cv::viz::Color ret = cv::viz::Color::black();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// blue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:76
	Result<cv::viz::Color*> cv_viz_Color_blue() {
		try {
			cv::viz::Color ret = cv::viz::Color::blue();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// green() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:77
	Result<cv::viz::Color*> cv_viz_Color_green() {
		try {
			cv::viz::Color ret = cv::viz::Color::green();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// red() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:78
	Result<cv::viz::Color*> cv_viz_Color_red() {
		try {
			cv::viz::Color ret = cv::viz::Color::red();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// cyan() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:79
	Result<cv::viz::Color*> cv_viz_Color_cyan() {
		try {
			cv::viz::Color ret = cv::viz::Color::cyan();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// yellow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:80
	Result<cv::viz::Color*> cv_viz_Color_yellow() {
		try {
			cv::viz::Color ret = cv::viz::Color::yellow();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// magenta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:81
	Result<cv::viz::Color*> cv_viz_Color_magenta() {
		try {
			cv::viz::Color ret = cv::viz::Color::magenta();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// white() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:82
	Result<cv::viz::Color*> cv_viz_Color_white() {
		try {
			cv::viz::Color ret = cv::viz::Color::white();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// gray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:84
	Result<cv::viz::Color*> cv_viz_Color_gray() {
		try {
			cv::viz::Color ret = cv::viz::Color::gray();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// silver() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:85
	Result<cv::viz::Color*> cv_viz_Color_silver() {
		try {
			cv::viz::Color ret = cv::viz::Color::silver();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// mlab() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:87
	Result<cv::viz::Color*> cv_viz_Color_mlab() {
		try {
			cv::viz::Color ret = cv::viz::Color::mlab();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// navy() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:89
	Result<cv::viz::Color*> cv_viz_Color_navy() {
		try {
			cv::viz::Color ret = cv::viz::Color::navy();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// maroon() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:90
	Result<cv::viz::Color*> cv_viz_Color_maroon() {
		try {
			cv::viz::Color ret = cv::viz::Color::maroon();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// teal() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:91
	Result<cv::viz::Color*> cv_viz_Color_teal() {
		try {
			cv::viz::Color ret = cv::viz::Color::teal();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// olive() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:92
	Result<cv::viz::Color*> cv_viz_Color_olive() {
		try {
			cv::viz::Color ret = cv::viz::Color::olive();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// purple() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:93
	Result<cv::viz::Color*> cv_viz_Color_purple() {
		try {
			cv::viz::Color ret = cv::viz::Color::purple();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// azure() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:94
	Result<cv::viz::Color*> cv_viz_Color_azure() {
		try {
			cv::viz::Color ret = cv::viz::Color::azure();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// chartreuse() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:95
	Result<cv::viz::Color*> cv_viz_Color_chartreuse() {
		try {
			cv::viz::Color ret = cv::viz::Color::chartreuse();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// rose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:96
	Result<cv::viz::Color*> cv_viz_Color_rose() {
		try {
			cv::viz::Color ret = cv::viz::Color::rose();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// lime() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:98
	Result<cv::viz::Color*> cv_viz_Color_lime() {
		try {
			cv::viz::Color ret = cv::viz::Color::lime();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// gold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:99
	Result<cv::viz::Color*> cv_viz_Color_gold() {
		try {
			cv::viz::Color ret = cv::viz::Color::gold();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// orange() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:100
	Result<cv::viz::Color*> cv_viz_Color_orange() {
		try {
			cv::viz::Color ret = cv::viz::Color::orange();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// orange_red() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:101
	Result<cv::viz::Color*> cv_viz_Color_orange_red() {
		try {
			cv::viz::Color ret = cv::viz::Color::orange_red();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// indigo() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:102
	Result<cv::viz::Color*> cv_viz_Color_indigo() {
		try {
			cv::viz::Color ret = cv::viz::Color::indigo();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// brown() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:104
	Result<cv::viz::Color*> cv_viz_Color_brown() {
		try {
			cv::viz::Color ret = cv::viz::Color::brown();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// apricot() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:105
	Result<cv::viz::Color*> cv_viz_Color_apricot() {
		try {
			cv::viz::Color ret = cv::viz::Color::apricot();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// pink() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:106
	Result<cv::viz::Color*> cv_viz_Color_pink() {
		try {
			cv::viz::Color ret = cv::viz::Color::pink();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// raspberry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:107
	Result<cv::viz::Color*> cv_viz_Color_raspberry() {
		try {
			cv::viz::Color ret = cv::viz::Color::raspberry();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// cherry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:108
	Result<cv::viz::Color*> cv_viz_Color_cherry() {
		try {
			cv::viz::Color ret = cv::viz::Color::cherry();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// violet() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:109
	Result<cv::viz::Color*> cv_viz_Color_violet() {
		try {
			cv::viz::Color ret = cv::viz::Color::violet();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// amethyst() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:110
	Result<cv::viz::Color*> cv_viz_Color_amethyst() {
		try {
			cv::viz::Color ret = cv::viz::Color::amethyst();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// bluberry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:111
	Result<cv::viz::Color*> cv_viz_Color_bluberry() {
		try {
			cv::viz::Color ret = cv::viz::Color::bluberry();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// celestial_blue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:112
	Result<cv::viz::Color*> cv_viz_Color_celestial_blue() {
		try {
			cv::viz::Color ret = cv::viz::Color::celestial_blue();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// turquoise() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:113
	Result<cv::viz::Color*> cv_viz_Color_turquoise() {
		try {
			cv::viz::Color ret = cv::viz::Color::turquoise();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// not_set() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:115
	Result<cv::viz::Color*> cv_viz_Color_not_set() {
		try {
			cv::viz::Color ret = cv::viz::Color::not_set();
			return Ok(new cv::viz::Color(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Color*>))
	}
	
	// action /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:302
	cv::viz::KeyboardEvent::Action cv_viz_KeyboardEvent_getPropAction_const(const cv::viz::KeyboardEvent* instance) {
		cv::viz::KeyboardEvent::Action ret = instance->action;
		return (cv::viz::KeyboardEvent::Action)ret;
	}
	
	// action /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:302
	void cv_viz_KeyboardEvent_setPropAction_Action(cv::viz::KeyboardEvent* instance, cv::viz::KeyboardEvent::Action val) {
		instance->action = val;
	}
	
	// symbol /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:303
	void* cv_viz_KeyboardEvent_getPropSymbol_const(const cv::viz::KeyboardEvent* instance) {
		cv::String ret = instance->symbol;
		return ocvrs_create_string(ret.c_str());
	}
	
	// symbol /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:303
	void cv_viz_KeyboardEvent_setPropSymbol_String(cv::viz::KeyboardEvent* instance, char* val) {
		instance->symbol = std::string(val);
	}
	
	// code /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:304
	unsigned char cv_viz_KeyboardEvent_getPropCode_const(const cv::viz::KeyboardEvent* instance) {
		unsigned char ret = instance->code;
		return (unsigned char)ret;
	}
	
	// code /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:304
	void cv_viz_KeyboardEvent_setPropCode_unsigned_char(cv::viz::KeyboardEvent* instance, unsigned char val) {
		instance->code = val;
	}
	
	// modifiers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:305
	int cv_viz_KeyboardEvent_getPropModifiers_const(const cv::viz::KeyboardEvent* instance) {
		int ret = instance->modifiers;
		return (int)ret;
	}
	
	// modifiers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:305
	void cv_viz_KeyboardEvent_setPropModifiers_int(cv::viz::KeyboardEvent* instance, int val) {
		instance->modifiers = val;
	}
	
	void cv_KeyboardEvent_delete(cv::viz::KeyboardEvent* instance) {
		delete instance;
	}
	// KeyboardEvent(cv::viz::KeyboardEvent::Action, const cv::String &, unsigned char, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:300
	Result<cv::viz::KeyboardEvent*> cv_viz_KeyboardEvent_KeyboardEvent_Action_const_StringR_unsigned_char_int(cv::viz::KeyboardEvent::Action action, const char* symbol, unsigned char code, int modifiers) {
		try {
			cv::viz::KeyboardEvent* ret = new cv::viz::KeyboardEvent(action, std::string(symbol), code, modifiers);
			return Ok<cv::viz::KeyboardEvent*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::KeyboardEvent*>))
	}
	
	// cloud /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:129
	cv::Mat* cv_viz_Mesh_getPropCloud_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->cloud;
		return new cv::Mat(ret);
	}
	
	// cloud /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:129
	void cv_viz_Mesh_setPropCloud_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->cloud = *val;
	}
	
	// colors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:130
	cv::Mat* cv_viz_Mesh_getPropColors_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->colors;
		return new cv::Mat(ret);
	}
	
	// colors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:130
	void cv_viz_Mesh_setPropColors_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->colors = *val;
	}
	
	// normals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:131
	cv::Mat* cv_viz_Mesh_getPropNormals_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->normals;
		return new cv::Mat(ret);
	}
	
	// normals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:131
	void cv_viz_Mesh_setPropNormals_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->normals = *val;
	}
	
	// polygons /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:135
	cv::Mat* cv_viz_Mesh_getPropPolygons_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->polygons;
		return new cv::Mat(ret);
	}
	
	// polygons /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:135
	void cv_viz_Mesh_setPropPolygons_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->polygons = *val;
	}
	
	// texture /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:137
	cv::Mat* cv_viz_Mesh_getPropTexture_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->texture;
		return new cv::Mat(ret);
	}
	
	// texture /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:137
	void cv_viz_Mesh_setPropTexture_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->texture = *val;
	}
	
	// tcoords /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:138
	cv::Mat* cv_viz_Mesh_getPropTcoords_const(const cv::viz::Mesh* instance) {
		cv::Mat ret = instance->tcoords;
		return new cv::Mat(ret);
	}
	
	// tcoords /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:138
	void cv_viz_Mesh_setPropTcoords_Mat(cv::viz::Mesh* instance, cv::Mat* val) {
		instance->tcoords = *val;
	}
	
	void cv_Mesh_delete(cv::viz::Mesh* instance) {
		delete instance;
	}
	// Mesh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:140
	Result<cv::viz::Mesh*> cv_viz_Mesh_Mesh() {
		try {
			cv::viz::Mesh* ret = new cv::viz::Mesh();
			return Ok<cv::viz::Mesh*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Mesh*>))
	}
	
	// load(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:154
	Result<cv::viz::Mesh*> cv_viz_Mesh_load_const_StringR_int(const char* file, int type) {
		try {
			cv::viz::Mesh ret = cv::viz::Mesh::load(std::string(file), type);
			return Ok(new cv::viz::Mesh(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Mesh*>))
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:327
	cv::viz::MouseEvent::Type cv_viz_MouseEvent_getPropType_const(const cv::viz::MouseEvent* instance) {
		cv::viz::MouseEvent::Type ret = instance->type;
		return (cv::viz::MouseEvent::Type)ret;
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:327
	void cv_viz_MouseEvent_setPropType_Type(cv::viz::MouseEvent* instance, cv::viz::MouseEvent::Type val) {
		instance->type = val;
	}
	
	// button /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:328
	cv::viz::MouseEvent::MouseButton cv_viz_MouseEvent_getPropButton_const(const cv::viz::MouseEvent* instance) {
		cv::viz::MouseEvent::MouseButton ret = instance->button;
		return (cv::viz::MouseEvent::MouseButton)ret;
	}
	
	// button /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:328
	void cv_viz_MouseEvent_setPropButton_MouseButton(cv::viz::MouseEvent* instance, cv::viz::MouseEvent::MouseButton val) {
		instance->button = val;
	}
	
	// pointer /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:329
	cv::Point cv_viz_MouseEvent_getPropPointer_const(const cv::viz::MouseEvent* instance) {
		cv::Point ret = instance->pointer;
		return (cv::Point)ret;
	}
	
	// pointer /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:329
	void cv_viz_MouseEvent_setPropPointer_Point(cv::viz::MouseEvent* instance, cv::Point* val) {
		instance->pointer = *val;
	}
	
	// modifiers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:330
	int cv_viz_MouseEvent_getPropModifiers_const(const cv::viz::MouseEvent* instance) {
		int ret = instance->modifiers;
		return (int)ret;
	}
	
	// modifiers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:330
	void cv_viz_MouseEvent_setPropModifiers_int(cv::viz::MouseEvent* instance, int val) {
		instance->modifiers = val;
	}
	
	void cv_MouseEvent_delete(cv::viz::MouseEvent* instance) {
		delete instance;
	}
	// MouseEvent(const cv::viz::MouseEvent::Type &, const cv::viz::MouseEvent::MouseButton &, const cv::Point &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/types.hpp:325
	Result<cv::viz::MouseEvent*> cv_viz_MouseEvent_MouseEvent_const_TypeR_const_MouseButtonR_const_PointR_int(const cv::viz::MouseEvent::Type* type, const cv::viz::MouseEvent::MouseButton* button, const cv::Point* pointer, int modifiers) {
		try {
			cv::viz::MouseEvent* ret = new cv::viz::MouseEvent(*type, *button, *pointer, modifiers);
			return Ok<cv::viz::MouseEvent*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::MouseEvent*>))
	}
	
	void cv_Viz3d_delete(cv::viz::Viz3d* instance) {
		delete instance;
	}
	// Viz3d(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:78
	Result<cv::viz::Viz3d*> cv_viz_Viz3d_Viz3d_const_StringR(const char* window_name) {
		try {
			cv::viz::Viz3d* ret = new cv::viz::Viz3d(std::string(window_name));
			return Ok<cv::viz::Viz3d*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Viz3d*>))
	}
	
	// Viz3d(const cv::viz::Viz3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:79
	Result<cv::viz::Viz3d*> cv_viz_Viz3d_Viz3d_const_Viz3dR(const cv::viz::Viz3d* unnamed) {
		try {
			cv::viz::Viz3d* ret = new cv::viz::Viz3d(*unnamed);
			return Ok<cv::viz::Viz3d*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Viz3d*>))
	}
	
	// showWidget(const cv::String &, const cv::viz::Widget &, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:88
	Result_void cv_viz_Viz3d_showWidget_const_StringR_const_WidgetR_const_Affine3dR(cv::viz::Viz3d* instance, const char* id, const cv::viz::Widget* widget, const cv::Affine3d* pose) {
		try {
			instance->showWidget(std::string(id), *widget, *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// removeWidget(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:94
	Result_void cv_viz_Viz3d_removeWidget_const_StringR(cv::viz::Viz3d* instance, const char* id) {
		try {
			instance->removeWidget(std::string(id));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWidget(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:103
	Result<cv::viz::Widget*> cv_viz_Viz3d_getWidget_const_const_StringR(const cv::viz::Viz3d* instance, const char* id) {
		try {
			cv::viz::Widget ret = instance->getWidget(std::string(id));
			return Ok(new cv::viz::Widget(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget*>))
	}
	
	// removeAllWidgets() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:107
	Result_void cv_viz_Viz3d_removeAllWidgets(cv::viz::Viz3d* instance) {
		try {
			instance->removeAllWidgets();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// showImage(cv::InputArray, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:114
	Result_void cv_viz_Viz3d_showImage_const__InputArrayR_const_SizeR(cv::viz::Viz3d* instance, const cv::_InputArray* image, const cv::Size* window_size) {
		try {
			instance->showImage(*image, *window_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWidgetPose(const cv::String &, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:120
	Result_void cv_viz_Viz3d_setWidgetPose_const_StringR_const_Affine3dR(cv::viz::Viz3d* instance, const char* id, const cv::Affine3d* pose) {
		try {
			instance->setWidgetPose(std::string(id), *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updateWidgetPose(const cv::String &, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:127
	Result_void cv_viz_Viz3d_updateWidgetPose_const_StringR_const_Affine3dR(cv::viz::Viz3d* instance, const char* id, const cv::Affine3d* pose) {
		try {
			instance->updateWidgetPose(std::string(id), *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWidgetPose(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:133
	Result<cv::Affine3d> cv_viz_Viz3d_getWidgetPose_const_const_StringR(const cv::viz::Viz3d* instance, const char* id) {
		try {
			cv::Affine3d ret = instance->getWidgetPose(std::string(id));
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// setCamera(const cv::viz::Camera &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:139
	Result_void cv_viz_Viz3d_setCamera_const_CameraR(cv::viz::Viz3d* instance, const cv::viz::Camera* camera) {
		try {
			instance->setCamera(*camera);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCamera() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:143
	Result<cv::viz::Camera*> cv_viz_Viz3d_getCamera_const(const cv::viz::Viz3d* instance) {
		try {
			cv::viz::Camera ret = instance->getCamera();
			return Ok(new cv::viz::Camera(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Camera*>))
	}
	
	// getViewerPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:147
	Result<cv::Affine3d> cv_viz_Viz3d_getViewerPose_const(const cv::viz::Viz3d* instance) {
		try {
			cv::Affine3d ret = instance->getViewerPose();
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// setViewerPose(const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:153
	Result_void cv_viz_Viz3d_setViewerPose_const_Affine3dR(cv::viz::Viz3d* instance, const cv::Affine3d* pose) {
		try {
			instance->setViewerPose(*pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetCameraViewpoint(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:159
	Result_void cv_viz_Viz3d_resetCameraViewpoint_const_StringR(cv::viz::Viz3d* instance, const char* id) {
		try {
			instance->resetCameraViewpoint(std::string(id));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetCamera() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:163
	Result_void cv_viz_Viz3d_resetCamera(cv::viz::Viz3d* instance) {
		try {
			instance->resetCamera();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertToWindowCoordinates(const cv::Point3d &, cv::Point3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:170
	Result_void cv_viz_Viz3d_convertToWindowCoordinates_const_Point3dR_Point3dR(cv::viz::Viz3d* instance, const cv::Point3d* pt, cv::Point3d* window_coord) {
		try {
			instance->convertToWindowCoordinates(*pt, *window_coord);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// converTo3DRay(const cv::Point3d &, cv::Point3d &, cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:177
	Result_void cv_viz_Viz3d_converTo3DRay_const_Point3dR_Point3dR_Vec3dR(cv::viz::Viz3d* instance, const cv::Point3d* window_coord, cv::Point3d* origin, cv::Vec3d* direction) {
		try {
			instance->converTo3DRay(*window_coord, *origin, *direction);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:181
	Result<cv::Size> cv_viz_Viz3d_getWindowSize_const(const cv::viz::Viz3d* instance) {
		try {
			cv::Size ret = instance->getWindowSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setWindowSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:186
	Result_void cv_viz_Viz3d_setWindowSize_const_SizeR(cv::viz::Viz3d* instance, const cv::Size* window_size) {
		try {
			instance->setWindowSize(*window_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:191
	Result<void*> cv_viz_Viz3d_getWindowName_const(const cv::viz::Viz3d* instance) {
		try {
			cv::String ret = instance->getWindowName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getScreenshot() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:195
	Result<cv::Mat*> cv_viz_Viz3d_getScreenshot_const(const cv::viz::Viz3d* instance) {
		try {
			cv::Mat ret = instance->getScreenshot();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// saveScreenshot(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:201
	Result_void cv_viz_Viz3d_saveScreenshot_const_StringR(cv::viz::Viz3d* instance, const char* file) {
		try {
			instance->saveScreenshot(std::string(file));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWindowPosition(const cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:207
	Result_void cv_viz_Viz3d_setWindowPosition_const_PointR(cv::viz::Viz3d* instance, const cv::Point* window_position) {
		try {
			instance->setWindowPosition(*window_position);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFullScreen(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:213
	Result_void cv_viz_Viz3d_setFullScreen_bool(cv::viz::Viz3d* instance, bool mode) {
		try {
			instance->setFullScreen(mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBackgroundColor(const cv::viz::Viz3d::Color &, const cv::viz::Viz3d::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:217
	Result_void cv_viz_Viz3d_setBackgroundColor_const_ColorR_const_ColorR(cv::viz::Viz3d* instance, const cv::viz::Viz3d::Color* color, const cv::viz::Viz3d::Color* color2) {
		try {
			instance->setBackgroundColor(*color, *color2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBackgroundTexture(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:218
	Result_void cv_viz_Viz3d_setBackgroundTexture_const__InputArrayR(cv::viz::Viz3d* instance, const cv::_InputArray* image) {
		try {
			instance->setBackgroundTexture(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBackgroundMeshLab() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:219
	Result_void cv_viz_Viz3d_setBackgroundMeshLab(cv::viz::Viz3d* instance) {
		try {
			instance->setBackgroundMeshLab();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// spin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:223
	Result_void cv_viz_Viz3d_spin(cv::viz::Viz3d* instance) {
		try {
			instance->spin();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// spinOnce(int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:230
	Result_void cv_viz_Viz3d_spinOnce_int_bool(cv::viz::Viz3d* instance, int time, bool force_redraw) {
		try {
			instance->spinOnce(time, force_redraw);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setOffScreenRendering() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:234
	Result_void cv_viz_Viz3d_setOffScreenRendering(cv::viz::Viz3d* instance) {
		try {
			instance->setOffScreenRendering();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// removeAllLights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:238
	Result_void cv_viz_Viz3d_removeAllLights(cv::viz::Viz3d* instance) {
		try {
			instance->removeAllLights();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addLight(const cv::Vec3d &, const cv::Vec3d &, const cv::viz::Viz3d::Color &, const cv::viz::Viz3d::Color &, const cv::viz::Viz3d::Color &, const cv::viz::Viz3d::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:249
	Result_void cv_viz_Viz3d_addLight_const_Vec3dR_const_Vec3dR_const_ColorR_const_ColorR_const_ColorR_const_ColorR(cv::viz::Viz3d* instance, const cv::Vec3d* position, const cv::Vec3d* focalPoint, const cv::viz::Viz3d::Color* color, const cv::viz::Viz3d::Color* diffuseColor, const cv::viz::Viz3d::Color* ambientColor, const cv::viz::Viz3d::Color* specularColor) {
		try {
			instance->addLight(*position, *focalPoint, *color, *diffuseColor, *ambientColor, *specularColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// wasStopped() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:255
	Result<bool> cv_viz_Viz3d_wasStopped_const(const cv::viz::Viz3d* instance) {
		try {
			bool ret = instance->wasStopped();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// close() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:256
	Result_void cv_viz_Viz3d_close(cv::viz::Viz3d* instance) {
		try {
			instance->close();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// registerKeyboardCallback(cv::viz::Viz3d::KeyboardCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:264
	Result_void cv_viz_Viz3d_registerKeyboardCallback_KeyboardCallback_voidX(cv::viz::Viz3d* instance, cv::viz::Viz3d::KeyboardCallback callback, void* cookie) {
		try {
			instance->registerKeyboardCallback(callback, cookie);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// registerMouseCallback(cv::viz::Viz3d::MouseCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:271
	Result_void cv_viz_Viz3d_registerMouseCallback_MouseCallback_voidX(cv::viz::Viz3d* instance, cv::viz::Viz3d::MouseCallback callback, void* cookie) {
		try {
			instance->registerMouseCallback(callback, cookie);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setRenderingProperty(const cv::String &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:299
	Result_void cv_viz_Viz3d_setRenderingProperty_const_StringR_int_double(cv::viz::Viz3d* instance, const char* id, int property, double value) {
		try {
			instance->setRenderingProperty(std::string(id), property, value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRenderingProperty(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:325
	Result<double> cv_viz_Viz3d_getRenderingProperty_const_StringR_int(cv::viz::Viz3d* instance, const char* id, int property) {
		try {
			double ret = instance->getRenderingProperty(std::string(id), property);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRepresentation(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:334
	Result_void cv_viz_Viz3d_setRepresentation_int(cv::viz::Viz3d* instance, int representation) {
		try {
			instance->setRepresentation(representation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setGlobalWarnings(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/viz3d.hpp:336
	Result_void cv_viz_Viz3d_setGlobalWarnings_bool(cv::viz::Viz3d* instance, bool enabled) {
		try {
			instance->setGlobalWarnings(enabled);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::viz::Widget* cv_WArrow_to_Widget(cv::viz::WArrow* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WArrow_to_Widget3D(cv::viz::WArrow* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WArrow_delete(cv::viz::WArrow* instance) {
		delete instance;
	}
	// WArrow(const cv::Point3d &, const cv::Point3d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:301
	Result<cv::viz::WArrow*> cv_viz_WArrow_WArrow_const_Point3dR_const_Point3dR_double_const_ColorR(const cv::Point3d* pt1, const cv::Point3d* pt2, double thickness, const cv::viz::Color* color) {
		try {
			cv::viz::WArrow* ret = new cv::viz::WArrow(*pt1, *pt2, thickness, *color);
			return Ok<cv::viz::WArrow*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WArrow*>))
	}
	
	cv::viz::Widget* cv_WCameraPosition_to_Widget(cv::viz::WCameraPosition* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCameraPosition_to_Widget3D(cv::viz::WCameraPosition* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCameraPosition_delete(cv::viz::WCameraPosition* instance) {
		delete instance;
	}
	// WCameraPosition(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:550
	Result<cv::viz::WCameraPosition*> cv_viz_WCameraPosition_WCameraPosition_double(double scale) {
		try {
			cv::viz::WCameraPosition* ret = new cv::viz::WCameraPosition(scale);
			return Ok<cv::viz::WCameraPosition*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCameraPosition*>))
	}
	
	// WCameraPosition(const cv::Matx33d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:560
	Result<cv::viz::WCameraPosition*> cv_viz_WCameraPosition_WCameraPosition_const_Matx33dR_double_const_ColorR(const cv::Matx33d* K, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WCameraPosition* ret = new cv::viz::WCameraPosition(*K, scale, *color);
			return Ok<cv::viz::WCameraPosition*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCameraPosition*>))
	}
	
	// WCameraPosition(const cv::Vec2d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:570
	Result<cv::viz::WCameraPosition*> cv_viz_WCameraPosition_WCameraPosition_const_Vec2dR_double_const_ColorR(const cv::Vec2d* fov, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WCameraPosition* ret = new cv::viz::WCameraPosition(*fov, scale, *color);
			return Ok<cv::viz::WCameraPosition*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCameraPosition*>))
	}
	
	// WCameraPosition(const cv::Matx33d &, cv::InputArray, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:583
	Result<cv::viz::WCameraPosition*> cv_viz_WCameraPosition_WCameraPosition_const_Matx33dR_const__InputArrayR_double_const_ColorR(const cv::Matx33d* K, const cv::_InputArray* image, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WCameraPosition* ret = new cv::viz::WCameraPosition(*K, *image, scale, *color);
			return Ok<cv::viz::WCameraPosition*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCameraPosition*>))
	}
	
	// WCameraPosition(const cv::Vec2d &, cv::InputArray, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:596
	Result<cv::viz::WCameraPosition*> cv_viz_WCameraPosition_WCameraPosition_const_Vec2dR_const__InputArrayR_double_const_ColorR(const cv::Vec2d* fov, const cv::_InputArray* image, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WCameraPosition* ret = new cv::viz::WCameraPosition(*fov, *image, scale, *color);
			return Ok<cv::viz::WCameraPosition*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCameraPosition*>))
	}
	
	cv::viz::Widget* cv_WCircle_to_Widget(cv::viz::WCircle* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCircle_to_Widget3D(cv::viz::WCircle* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCircle_delete(cv::viz::WCircle* instance) {
		delete instance;
	}
	// WCircle(double, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:315
	Result<cv::viz::WCircle*> cv_viz_WCircle_WCircle_double_double_const_ColorR(double radius, double thickness, const cv::viz::Color* color) {
		try {
			cv::viz::WCircle* ret = new cv::viz::WCircle(radius, thickness, *color);
			return Ok<cv::viz::WCircle*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCircle*>))
	}
	
	// WCircle(double, const cv::Point3d &, const cv::Vec3d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:325
	Result<cv::viz::WCircle*> cv_viz_WCircle_WCircle_double_const_Point3dR_const_Vec3dR_double_const_ColorR(double radius, const cv::Point3d* center, const cv::Vec3d* normal, double thickness, const cv::viz::Color* color) {
		try {
			cv::viz::WCircle* ret = new cv::viz::WCircle(radius, *center, *normal, thickness, *color);
			return Ok<cv::viz::WCircle*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCircle*>))
	}
	
	cv::viz::Widget* cv_WCloud_to_Widget(cv::viz::WCloud* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCloud_to_Widget3D(cv::viz::WCloud* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCloud_delete(cv::viz::WCloud* instance) {
		delete instance;
	}
	// WCloud(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:690
	Result<cv::viz::WCloud*> cv_viz_WCloud_WCloud_const__InputArrayR_const__InputArrayR(const cv::_InputArray* cloud, const cv::_InputArray* colors) {
		try {
			cv::viz::WCloud* ret = new cv::viz::WCloud(*cloud, *colors);
			return Ok<cv::viz::WCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloud*>))
	}
	
	// WCloud(cv::InputArray, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:698
	Result<cv::viz::WCloud*> cv_viz_WCloud_WCloud_const__InputArrayR_const_ColorR(const cv::_InputArray* cloud, const cv::viz::Color* color) {
		try {
			cv::viz::WCloud* ret = new cv::viz::WCloud(*cloud, *color);
			return Ok<cv::viz::WCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloud*>))
	}
	
	// WCloud(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:707
	Result<cv::viz::WCloud*> cv_viz_WCloud_WCloud_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* cloud, const cv::_InputArray* colors, const cv::_InputArray* normals) {
		try {
			cv::viz::WCloud* ret = new cv::viz::WCloud(*cloud, *colors, *normals);
			return Ok<cv::viz::WCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloud*>))
	}
	
	// WCloud(cv::InputArray, const cv::viz::Color &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:717
	Result<cv::viz::WCloud*> cv_viz_WCloud_WCloud_const__InputArrayR_const_ColorR_const__InputArrayR(const cv::_InputArray* cloud, const cv::viz::Color* color, const cv::_InputArray* normals) {
		try {
			cv::viz::WCloud* ret = new cv::viz::WCloud(*cloud, *color, *normals);
			return Ok<cv::viz::WCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloud*>))
	}
	
	cv::viz::Widget* cv_WCloudCollection_to_Widget(cv::viz::WCloudCollection* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCloudCollection_to_Widget3D(cv::viz::WCloudCollection* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCloudCollection_delete(cv::viz::WCloudCollection* instance) {
		delete instance;
	}
	// WCloudCollection() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:739
	Result<cv::viz::WCloudCollection*> cv_viz_WCloudCollection_WCloudCollection() {
		try {
			cv::viz::WCloudCollection* ret = new cv::viz::WCloudCollection();
			return Ok<cv::viz::WCloudCollection*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloudCollection*>))
	}
	
	// addCloud(cv::InputArray, cv::InputArray, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:747
	Result_void cv_viz_WCloudCollection_addCloud_const__InputArrayR_const__InputArrayR_const_Affine3dR(cv::viz::WCloudCollection* instance, const cv::_InputArray* cloud, const cv::_InputArray* colors, const cv::Affine3d* pose) {
		try {
			instance->addCloud(*cloud, *colors, *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addCloud(cv::InputArray, const cv::viz::Color &, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:754
	Result_void cv_viz_WCloudCollection_addCloud_const__InputArrayR_const_ColorR_const_Affine3dR(cv::viz::WCloudCollection* instance, const cv::_InputArray* cloud, const cv::viz::Color* color, const cv::Affine3d* pose) {
		try {
			instance->addCloud(*cloud, *color, *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// finalize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:759
	Result_void cv_viz_WCloudCollection_finalize(cv::viz::WCloudCollection* instance) {
		try {
			instance->finalize();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::viz::Widget* cv_WCloudNormals_to_Widget(cv::viz::WCloudNormals* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCloudNormals_to_Widget3D(cv::viz::WCloudNormals* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCloudNormals_delete(cv::viz::WCloudNormals* instance) {
		delete instance;
	}
	// WCloudNormals(cv::InputArray, cv::InputArray, int, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:777
	Result<cv::viz::WCloudNormals*> cv_viz_WCloudNormals_WCloudNormals_const__InputArrayR_const__InputArrayR_int_double_const_ColorR(const cv::_InputArray* cloud, const cv::_InputArray* normals, int level, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WCloudNormals* ret = new cv::viz::WCloudNormals(*cloud, *normals, level, scale, *color);
			return Ok<cv::viz::WCloudNormals*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCloudNormals*>))
	}
	
	cv::viz::Widget* cv_WCone_to_Widget(cv::viz::WCone* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCone_to_Widget3D(cv::viz::WCone* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCone_delete(cv::viz::WCone* instance) {
		delete instance;
	}
	// WCone(double, double, int, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:340
	Result<cv::viz::WCone*> cv_viz_WCone_WCone_double_double_int_const_ColorR(double length, double radius, int resolution, const cv::viz::Color* color) {
		try {
			cv::viz::WCone* ret = new cv::viz::WCone(length, radius, resolution, *color);
			return Ok<cv::viz::WCone*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCone*>))
	}
	
	// WCone(double, const cv::Point3d &, const cv::Point3d &, int, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:351
	Result<cv::viz::WCone*> cv_viz_WCone_WCone_double_const_Point3dR_const_Point3dR_int_const_ColorR(double radius, const cv::Point3d* center, const cv::Point3d* tip, int resolution, const cv::viz::Color* color) {
		try {
			cv::viz::WCone* ret = new cv::viz::WCone(radius, *center, *tip, resolution, *color);
			return Ok<cv::viz::WCone*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCone*>))
	}
	
	cv::viz::Widget* cv_WCoordinateSystem_to_Widget(cv::viz::WCoordinateSystem* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCoordinateSystem_to_Widget3D(cv::viz::WCoordinateSystem* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCoordinateSystem_delete(cv::viz::WCoordinateSystem* instance) {
		delete instance;
	}
	// WCoordinateSystem(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:520
	Result<cv::viz::WCoordinateSystem*> cv_viz_WCoordinateSystem_WCoordinateSystem_double(double scale) {
		try {
			cv::viz::WCoordinateSystem* ret = new cv::viz::WCoordinateSystem(scale);
			return Ok<cv::viz::WCoordinateSystem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCoordinateSystem*>))
	}
	
	cv::viz::Widget* cv_WCube_to_Widget(cv::viz::WCube* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCube_to_Widget3D(cv::viz::WCube* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCube_delete(cv::viz::WCube* instance) {
		delete instance;
	}
	// WCube(const cv::Point3d &, const cv::Point3d &, bool, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:384
	Result<cv::viz::WCube*> cv_viz_WCube_WCube_const_Point3dR_const_Point3dR_bool_const_ColorR(const cv::Point3d* min_point, const cv::Point3d* max_point, bool wire_frame, const cv::viz::Color* color) {
		try {
			cv::viz::WCube* ret = new cv::viz::WCube(*min_point, *max_point, wire_frame, *color);
			return Ok<cv::viz::WCube*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCube*>))
	}
	
	cv::viz::Widget* cv_WCylinder_to_Widget(cv::viz::WCylinder* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WCylinder_to_Widget3D(cv::viz::WCylinder* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WCylinder_delete(cv::viz::WCylinder* instance) {
		delete instance;
	}
	// WCylinder(const cv::Point3d &, const cv::Point3d &, double, int, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:367
	Result<cv::viz::WCylinder*> cv_viz_WCylinder_WCylinder_const_Point3dR_const_Point3dR_double_int_const_ColorR(const cv::Point3d* axis_point1, const cv::Point3d* axis_point2, double radius, int numsides, const cv::viz::Color* color) {
		try {
			cv::viz::WCylinder* ret = new cv::viz::WCylinder(*axis_point1, *axis_point2, radius, numsides, *color);
			return Ok<cv::viz::WCylinder*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WCylinder*>))
	}
	
	cv::viz::Widget* cv_WGrid_to_Widget(cv::viz::WGrid* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WGrid_to_Widget3D(cv::viz::WGrid* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WGrid_delete(cv::viz::WGrid* instance) {
		delete instance;
	}
	// WGrid(const cv::Vec2i &, const cv::Vec2d &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:534
	Result<cv::viz::WGrid*> cv_viz_WGrid_WGrid_const_Vec2iR_const_Vec2dR_const_ColorR(const cv::Vec2i* cells, const cv::Vec2d* cells_spacing, const cv::viz::Color* color) {
		try {
			cv::viz::WGrid* ret = new cv::viz::WGrid(*cells, *cells_spacing, *color);
			return Ok<cv::viz::WGrid*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WGrid*>))
	}
	
	// WGrid(const cv::Point3d &, const cv::Vec3d &, const cv::Vec3d &, const cv::Vec2i &, const cv::Vec2d &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:537
	Result<cv::viz::WGrid*> cv_viz_WGrid_WGrid_const_Point3dR_const_Vec3dR_const_Vec3dR_const_Vec2iR_const_Vec2dR_const_ColorR(const cv::Point3d* center, const cv::Vec3d* normal, const cv::Vec3d* new_yaxis, const cv::Vec2i* cells, const cv::Vec2d* cells_spacing, const cv::viz::Color* color) {
		try {
			cv::viz::WGrid* ret = new cv::viz::WGrid(*center, *normal, *new_yaxis, *cells, *cells_spacing, *color);
			return Ok<cv::viz::WGrid*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WGrid*>))
	}
	
	cv::viz::Widget* cv_WImage3D_to_Widget(cv::viz::WImage3D* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WImage3D_to_Widget3D(cv::viz::WImage3D* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WImage3D_delete(cv::viz::WImage3D* instance) {
		delete instance;
	}
	// WImage3D(cv::InputArray, const cv::Size2d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:483
	Result<cv::viz::WImage3D*> cv_viz_WImage3D_WImage3D_const__InputArrayR_const_Size2dR(const cv::_InputArray* image, const cv::Size2d* size) {
		try {
			cv::viz::WImage3D* ret = new cv::viz::WImage3D(*image, *size);
			return Ok<cv::viz::WImage3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WImage3D*>))
	}
	
	// WImage3D(cv::InputArray, const cv::Size2d &, const cv::Vec3d &, const cv::Vec3d &, const cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:493
	Result<cv::viz::WImage3D*> cv_viz_WImage3D_WImage3D_const__InputArrayR_const_Size2dR_const_Vec3dR_const_Vec3dR_const_Vec3dR(const cv::_InputArray* image, const cv::Size2d* size, const cv::Vec3d* center, const cv::Vec3d* normal, const cv::Vec3d* up_vector) {
		try {
			cv::viz::WImage3D* ret = new cv::viz::WImage3D(*image, *size, *center, *normal, *up_vector);
			return Ok<cv::viz::WImage3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WImage3D*>))
	}
	
	// setImage(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:499
	Result_void cv_viz_WImage3D_setImage_const__InputArrayR(cv::viz::WImage3D* instance, const cv::_InputArray* image) {
		try {
			instance->setImage(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:505
	Result_void cv_viz_WImage3D_setSize_const_SizeR(cv::viz::WImage3D* instance, const cv::Size* size) {
		try {
			instance->setSize(*size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::viz::Widget* cv_WImageOverlay_to_Widget(cv::viz::WImageOverlay* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget2D* cv_WImageOverlay_to_Widget2D(cv::viz::WImageOverlay* instance) {
		return dynamic_cast<cv::viz::Widget2D*>(instance);
	}
	
	void cv_WImageOverlay_delete(cv::viz::WImageOverlay* instance) {
		delete instance;
	}
	// WImageOverlay(cv::InputArray, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:465
	Result<cv::viz::WImageOverlay*> cv_viz_WImageOverlay_WImageOverlay_const__InputArrayR_const_RectR(const cv::_InputArray* image, const cv::Rect* rect) {
		try {
			cv::viz::WImageOverlay* ret = new cv::viz::WImageOverlay(*image, *rect);
			return Ok<cv::viz::WImageOverlay*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WImageOverlay*>))
	}
	
	// setImage(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:470
	Result_void cv_viz_WImageOverlay_setImage_const__InputArrayR(cv::viz::WImageOverlay* instance, const cv::_InputArray* image) {
		try {
			instance->setImage(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::viz::Widget* cv_WLine_to_Widget(cv::viz::WLine* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WLine_to_Widget3D(cv::viz::WLine* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WLine_delete(cv::viz::WLine* instance) {
		delete instance;
	}
	// WLine(const cv::Point3d &, const cv::Point3d &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:244
	Result<cv::viz::WLine*> cv_viz_WLine_WLine_const_Point3dR_const_Point3dR_const_ColorR(const cv::Point3d* pt1, const cv::Point3d* pt2, const cv::viz::Color* color) {
		try {
			cv::viz::WLine* ret = new cv::viz::WLine(*pt1, *pt2, *color);
			return Ok<cv::viz::WLine*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WLine*>))
	}
	
	cv::viz::Widget* cv_WMesh_to_Widget(cv::viz::WMesh* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WMesh_to_Widget3D(cv::viz::WMesh* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WMesh_delete(cv::viz::WMesh* instance) {
		delete instance;
	}
	// WMesh(const cv::viz::Mesh &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:794
	Result<cv::viz::WMesh*> cv_viz_WMesh_WMesh_const_MeshR(const cv::viz::Mesh* mesh) {
		try {
			cv::viz::WMesh* ret = new cv::viz::WMesh(*mesh);
			return Ok<cv::viz::WMesh*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WMesh*>))
	}
	
	// WMesh(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:795
	Result<cv::viz::WMesh*> cv_viz_WMesh_WMesh_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* cloud, const cv::_InputArray* polygons, const cv::_InputArray* colors, const cv::_InputArray* normals) {
		try {
			cv::viz::WMesh* ret = new cv::viz::WMesh(*cloud, *polygons, *colors, *normals);
			return Ok<cv::viz::WMesh*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WMesh*>))
	}
	
	cv::viz::Widget* cv_WPaintedCloud_to_Widget(cv::viz::WPaintedCloud* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WPaintedCloud_to_Widget3D(cv::viz::WPaintedCloud* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WPaintedCloud_delete(cv::viz::WPaintedCloud* instance) {
		delete instance;
	}
	// WPaintedCloud(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:724
	Result<cv::viz::WPaintedCloud*> cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR(const cv::_InputArray* cloud) {
		try {
			cv::viz::WPaintedCloud* ret = new cv::viz::WPaintedCloud(*cloud);
			return Ok<cv::viz::WPaintedCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPaintedCloud*>))
	}
	
	// WPaintedCloud(cv::InputArray, const cv::Point3d &, const cv::Point3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:727
	Result<cv::viz::WPaintedCloud*> cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR_const_Point3dR_const_Point3dR(const cv::_InputArray* cloud, const cv::Point3d* p1, const cv::Point3d* p2) {
		try {
			cv::viz::WPaintedCloud* ret = new cv::viz::WPaintedCloud(*cloud, *p1, *p2);
			return Ok<cv::viz::WPaintedCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPaintedCloud*>))
	}
	
	// WPaintedCloud(cv::InputArray, const cv::Point3d &, const cv::Point3d &, const cv::viz::Color &, const cv::viz::Color) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:730
	Result<cv::viz::WPaintedCloud*> cv_viz_WPaintedCloud_WPaintedCloud_const__InputArrayR_const_Point3dR_const_Point3dR_const_ColorR_const_Color(const cv::_InputArray* cloud, const cv::Point3d* p1, const cv::Point3d* p2, const cv::viz::Color* c1, const cv::viz::Color* c2) {
		try {
			cv::viz::WPaintedCloud* ret = new cv::viz::WPaintedCloud(*cloud, *p1, *p2, *c1, *c2);
			return Ok<cv::viz::WPaintedCloud*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPaintedCloud*>))
	}
	
	cv::viz::Widget* cv_WPlane_to_Widget(cv::viz::WPlane* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WPlane_to_Widget3D(cv::viz::WPlane* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WPlane_delete(cv::viz::WPlane* instance) {
		delete instance;
	}
	// WPlane(const cv::Size2d &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:257
	Result<cv::viz::WPlane*> cv_viz_WPlane_WPlane_const_Size2dR_const_ColorR(const cv::Size2d* size, const cv::viz::Color* color) {
		try {
			cv::viz::WPlane* ret = new cv::viz::WPlane(*size, *color);
			return Ok<cv::viz::WPlane*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPlane*>))
	}
	
	// WPlane(const cv::Point3d &, const cv::Vec3d &, const cv::Vec3d &, const cv::Size2d &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:267
	Result<cv::viz::WPlane*> cv_viz_WPlane_WPlane_const_Point3dR_const_Vec3dR_const_Vec3dR_const_Size2dR_const_ColorR(const cv::Point3d* center, const cv::Vec3d* normal, const cv::Vec3d* new_yaxis, const cv::Size2d* size, const cv::viz::Color* color) {
		try {
			cv::viz::WPlane* ret = new cv::viz::WPlane(*center, *normal, *new_yaxis, *size, *color);
			return Ok<cv::viz::WPlane*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPlane*>))
	}
	
	cv::viz::Widget* cv_WPolyLine_to_Widget(cv::viz::WPolyLine* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WPolyLine_to_Widget3D(cv::viz::WPolyLine* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WPolyLine_delete(cv::viz::WPolyLine* instance) {
		delete instance;
	}
	// WPolyLine(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:393
	Result<cv::viz::WPolyLine*> cv_viz_WPolyLine_WPolyLine_const__InputArrayR_const__InputArrayR(const cv::_InputArray* points, const cv::_InputArray* colors) {
		try {
			cv::viz::WPolyLine* ret = new cv::viz::WPolyLine(*points, *colors);
			return Ok<cv::viz::WPolyLine*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPolyLine*>))
	}
	
	// WPolyLine(cv::InputArray, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:399
	Result<cv::viz::WPolyLine*> cv_viz_WPolyLine_WPolyLine_const__InputArrayR_const_ColorR(const cv::_InputArray* points, const cv::viz::Color* color) {
		try {
			cv::viz::WPolyLine* ret = new cv::viz::WPolyLine(*points, *color);
			return Ok<cv::viz::WPolyLine*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WPolyLine*>))
	}
	
	cv::viz::Widget* cv_WSphere_to_Widget(cv::viz::WSphere* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WSphere_to_Widget3D(cv::viz::WSphere* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WSphere_delete(cv::viz::WSphere* instance) {
		delete instance;
	}
	// WSphere(const cv::Point3d &, double, int, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:283
	Result<cv::viz::WSphere*> cv_viz_WSphere_WSphere_const_Point3dR_double_int_const_ColorR(const cv::Point3d* center, double radius, int sphere_resolution, const cv::viz::Color* color) {
		try {
			cv::viz::WSphere* ret = new cv::viz::WSphere(*center, radius, sphere_resolution, *color);
			return Ok<cv::viz::WSphere*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WSphere*>))
	}
	
	cv::viz::Widget* cv_WText_to_Widget(cv::viz::WText* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget2D* cv_WText_to_Widget2D(cv::viz::WText* instance) {
		return dynamic_cast<cv::viz::Widget2D*>(instance);
	}
	
	void cv_WText_delete(cv::viz::WText* instance) {
		delete instance;
	}
	// WText(const cv::String &, const cv::Point &, int, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:417
	Result<cv::viz::WText*> cv_viz_WText_WText_const_StringR_const_PointR_int_const_ColorR(const char* text, const cv::Point* pos, int font_size, const cv::viz::Color* color) {
		try {
			cv::viz::WText* ret = new cv::viz::WText(std::string(text), *pos, font_size, *color);
			return Ok<cv::viz::WText*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WText*>))
	}
	
	// setText(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:423
	Result_void cv_viz_WText_setText_const_StringR(cv::viz::WText* instance, const char* text) {
		try {
			instance->setText(std::string(text));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getText() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:426
	Result<void*> cv_viz_WText_getText_const(const cv::viz::WText* instance) {
		try {
			cv::String ret = instance->getText();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::viz::Widget* cv_WText3D_to_Widget(cv::viz::WText3D* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WText3D_to_Widget3D(cv::viz::WText3D* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WText3D_delete(cv::viz::WText3D* instance) {
		delete instance;
	}
	// WText3D(const cv::String &, const cv::Point3d &, double, bool, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:442
	Result<cv::viz::WText3D*> cv_viz_WText3D_WText3D_const_StringR_const_Point3dR_double_bool_const_ColorR(const char* text, const cv::Point3d* position, double text_scale, bool face_camera, const cv::viz::Color* color) {
		try {
			cv::viz::WText3D* ret = new cv::viz::WText3D(std::string(text), *position, text_scale, face_camera, *color);
			return Ok<cv::viz::WText3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WText3D*>))
	}
	
	// setText(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:449
	Result_void cv_viz_WText3D_setText_const_StringR(cv::viz::WText3D* instance, const char* text) {
		try {
			instance->setText(std::string(text));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getText() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:452
	Result<void*> cv_viz_WText3D_getText_const(const cv::viz::WText3D* instance) {
		try {
			cv::String ret = instance->getText();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::viz::Widget* cv_WTrajectory_to_Widget(cv::viz::WTrajectory* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WTrajectory_to_Widget3D(cv::viz::WTrajectory* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WTrajectory_delete(cv::viz::WTrajectory* instance) {
		delete instance;
	}
	// WTrajectory(cv::InputArray, int, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:622
	Result<cv::viz::WTrajectory*> cv_viz_WTrajectory_WTrajectory_const__InputArrayR_int_double_const_ColorR(const cv::_InputArray* path, int display_mode, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WTrajectory* ret = new cv::viz::WTrajectory(*path, display_mode, scale, *color);
			return Ok<cv::viz::WTrajectory*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WTrajectory*>))
	}
	
	cv::viz::Widget* cv_WTrajectoryFrustums_to_Widget(cv::viz::WTrajectoryFrustums* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WTrajectoryFrustums_to_Widget3D(cv::viz::WTrajectoryFrustums* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WTrajectoryFrustums_delete(cv::viz::WTrajectoryFrustums* instance) {
		delete instance;
	}
	// WTrajectoryFrustums(cv::InputArray, const cv::Matx33d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:639
	Result<cv::viz::WTrajectoryFrustums*> cv_viz_WTrajectoryFrustums_WTrajectoryFrustums_const__InputArrayR_const_Matx33dR_double_const_ColorR(const cv::_InputArray* path, const cv::Matx33d* K, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WTrajectoryFrustums* ret = new cv::viz::WTrajectoryFrustums(*path, *K, scale, *color);
			return Ok<cv::viz::WTrajectoryFrustums*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WTrajectoryFrustums*>))
	}
	
	// WTrajectoryFrustums(cv::InputArray, const cv::Vec2d &, double, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:650
	Result<cv::viz::WTrajectoryFrustums*> cv_viz_WTrajectoryFrustums_WTrajectoryFrustums_const__InputArrayR_const_Vec2dR_double_const_ColorR(const cv::_InputArray* path, const cv::Vec2d* fov, double scale, const cv::viz::Color* color) {
		try {
			cv::viz::WTrajectoryFrustums* ret = new cv::viz::WTrajectoryFrustums(*path, *fov, scale, *color);
			return Ok<cv::viz::WTrajectoryFrustums*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WTrajectoryFrustums*>))
	}
	
	cv::viz::Widget* cv_WTrajectorySpheres_to_Widget(cv::viz::WTrajectorySpheres* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WTrajectorySpheres_to_Widget3D(cv::viz::WTrajectorySpheres* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WTrajectorySpheres_delete(cv::viz::WTrajectorySpheres* instance) {
		delete instance;
	}
	// WTrajectorySpheres(cv::InputArray, double, double, const cv::viz::Color &, const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:669
	Result<cv::viz::WTrajectorySpheres*> cv_viz_WTrajectorySpheres_WTrajectorySpheres_const__InputArrayR_double_double_const_ColorR_const_ColorR(const cv::_InputArray* path, double line_length, double radius, const cv::viz::Color* from, const cv::viz::Color* to) {
		try {
			cv::viz::WTrajectorySpheres* ret = new cv::viz::WTrajectorySpheres(*path, line_length, radius, *from, *to);
			return Ok<cv::viz::WTrajectorySpheres*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WTrajectorySpheres*>))
	}
	
	cv::viz::Widget* cv_WWidgetMerger_to_Widget(cv::viz::WWidgetMerger* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	cv::viz::Widget3D* cv_WWidgetMerger_to_Widget3D(cv::viz::WWidgetMerger* instance) {
		return dynamic_cast<cv::viz::Widget3D*>(instance);
	}
	
	void cv_WWidgetMerger_delete(cv::viz::WWidgetMerger* instance) {
		delete instance;
	}
	// WWidgetMerger() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:808
	Result<cv::viz::WWidgetMerger*> cv_viz_WWidgetMerger_WWidgetMerger() {
		try {
			cv::viz::WWidgetMerger* ret = new cv::viz::WWidgetMerger();
			return Ok<cv::viz::WWidgetMerger*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::WWidgetMerger*>))
	}
	
	// addWidget(const cv::viz::Widget3D &, const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:811
	Result_void cv_viz_WWidgetMerger_addWidget_const_Widget3DR_const_Affine3dR(cv::viz::WWidgetMerger* instance, const cv::viz::Widget3D* widget, const cv::Affine3d* pose) {
		try {
			instance->addWidget(*widget, *pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// finalize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:814
	Result_void cv_viz_WWidgetMerger_finalize(cv::viz::WWidgetMerger* instance) {
		try {
			instance->finalize();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Widget_delete(cv::viz::Widget* instance) {
		delete instance;
	}
	// Widget() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:95
	Result<cv::viz::Widget*> cv_viz_Widget_Widget() {
		try {
			cv::viz::Widget* ret = new cv::viz::Widget();
			return Ok<cv::viz::Widget*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget*>))
	}
	
	// Widget(const cv::viz::Widget &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:96
	Result<cv::viz::Widget*> cv_viz_Widget_Widget_const_WidgetR(const cv::viz::Widget* other) {
		try {
			cv::viz::Widget* ret = new cv::viz::Widget(*other);
			return Ok<cv::viz::Widget*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget*>))
	}
	
	// fromPlyFile(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:104
	Result<cv::viz::Widget*> cv_viz_Widget_fromPlyFile_const_StringR(const char* file_name) {
		try {
			cv::viz::Widget ret = cv::viz::Widget::fromPlyFile(std::string(file_name));
			return Ok(new cv::viz::Widget(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget*>))
	}
	
	// setRenderingProperty(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:131
	Result_void cv_viz_Widget_setRenderingProperty_int_double(cv::viz::Widget* instance, int property, double value) {
		try {
			instance->setRenderingProperty(property, value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRenderingProperty(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:157
	Result<double> cv_viz_Widget_getRenderingProperty_const_int(const cv::viz::Widget* instance, int property) {
		try {
			double ret = instance->getRenderingProperty(property);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	cv::viz::Widget* cv_Widget2D_to_Widget(cv::viz::Widget2D* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	void cv_Widget2D_delete(cv::viz::Widget2D* instance) {
		delete instance;
	}
	// Widget2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:221
	Result<cv::viz::Widget2D*> cv_viz_Widget2D_Widget2D() {
		try {
			cv::viz::Widget2D* ret = new cv::viz::Widget2D();
			return Ok<cv::viz::Widget2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget2D*>))
	}
	
	// setColor(const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:227
	Result_void cv_viz_Widget2D_setColor_const_ColorR(cv::viz::Widget2D* instance, const cv::viz::Color* color) {
		try {
			instance->setColor(*color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::viz::Widget* cv_Widget3D_to_Widget(cv::viz::Widget3D* instance) {
		return dynamic_cast<cv::viz::Widget*>(instance);
	}
	
	void cv_Widget3D_delete(cv::viz::Widget3D* instance) {
		delete instance;
	}
	// Widget3D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:184
	Result<cv::viz::Widget3D*> cv_viz_Widget3D_Widget3D() {
		try {
			cv::viz::Widget3D* ret = new cv::viz::Widget3D();
			return Ok<cv::viz::Widget3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::viz::Widget3D*>))
	}
	
	// setPose(const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:190
	Result_void cv_viz_Widget3D_setPose_const_Affine3dR(cv::viz::Widget3D* instance, const cv::Affine3d* pose) {
		try {
			instance->setPose(*pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updatePose(const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:195
	Result_void cv_viz_Widget3D_updatePose_const_Affine3dR(cv::viz::Widget3D* instance, const cv::Affine3d* pose) {
		try {
			instance->updatePose(*pose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:198
	Result<cv::Affine3d> cv_viz_Widget3D_getPose_const(const cv::viz::Widget3D* instance) {
		try {
			cv::Affine3d ret = instance->getPose();
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// applyTransform(const cv::Affine3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:204
	Result_void cv_viz_Widget3D_applyTransform_const_Affine3dR(cv::viz::Widget3D* instance, const cv::Affine3d* transform) {
		try {
			instance->applyTransform(*transform);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setColor(const cv::viz::Color &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/viz/widgets.hpp:210
	Result_void cv_viz_Widget3D_setColor_const_ColorR(cv::viz::Widget3D* instance, const cv::viz::Color* color) {
		try {
			instance->setColor(*color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
