#include "ocvrs_common.hpp"
#include <opencv2/videostab.hpp>
#include "videostab_types.hpp"

extern "C" {
	// calcBlurriness(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:57
	Result<float> cv_videostab_calcBlurriness_const_MatR(const cv::Mat* frame) {
		try {
			float ret = cv::videostab::calcBlurriness(*frame);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// calcFlowMask(const cv::Mat &, const cv::Mat &, const cv::Mat &, float, const cv::Mat &, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:199
	Result_void cv_videostab_calcFlowMask_const_MatR_const_MatR_const_MatR_float_const_MatR_const_MatR_MatR(const cv::Mat* flowX, const cv::Mat* flowY, const cv::Mat* errors, float maxError, const cv::Mat* mask0, const cv::Mat* mask1, cv::Mat* flowMask) {
		try {
			cv::videostab::calcFlowMask(*flowX, *flowY, *errors, maxError, *mask0, *mask1, *flowMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// completeFrameAccordingToFlow(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, float, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:203
	Result_void cv_videostab_completeFrameAccordingToFlow_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_float_MatR_MatR(const cv::Mat* flowMask, const cv::Mat* flowX, const cv::Mat* flowY, const cv::Mat* frame1, const cv::Mat* mask1, float distThresh, cv::Mat* frame0, cv::Mat* mask0) {
		try {
			cv::videostab::completeFrameAccordingToFlow(*flowMask, *flowX, *flowY, *frame1, *mask1, distThresh, *frame0, *mask0);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ensureInclusionConstraint(const cv::Mat &, cv::Size, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:165
	Result<cv::Mat*> cv_videostab_ensureInclusionConstraint_const_MatR_Size_float(const cv::Mat* M, cv::Size* size, float trimRatio) {
		try {
			cv::Mat ret = cv::videostab::ensureInclusionConstraint(*M, *size, trimRatio);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// estimateGlobalMotionLeastSquares(cv::InputOutputArray, cv::InputOutputArray, int, float *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:77
	Result<cv::Mat*> cv_videostab_estimateGlobalMotionLeastSquares_const__InputOutputArrayR_const__InputOutputArrayR_int_floatX(const cv::_InputOutputArray* points0, const cv::_InputOutputArray* points1, int model, float* rmse) {
		try {
			cv::Mat ret = cv::videostab::estimateGlobalMotionLeastSquares(*points0, *points1, model, rmse);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// estimateGlobalMotionRansac(cv::InputArray, cv::InputArray, int, const cv::videostab::RansacParams &, float *, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:90
	Result<cv::Mat*> cv_videostab_estimateGlobalMotionRansac_const__InputArrayR_const__InputArrayR_int_const_RansacParamsR_floatX_intX(const cv::_InputArray* points0, const cv::_InputArray* points1, int model, const cv::videostab::RansacParams* params, float* rmse, int* ninliers) {
		try {
			cv::Mat ret = cv::videostab::estimateGlobalMotionRansac(*points0, *points1, model, *params, rmse, ninliers);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// estimateOptimalTrimRatio(const cv::Mat &, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:167
	Result<float> cv_videostab_estimateOptimalTrimRatio_const_MatR_Size(const cv::Mat* M, cv::Size* size) {
		try {
			float ret = cv::videostab::estimateOptimalTrimRatio(*M, *size);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getMotion(int, int, const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:304
	Result<cv::Mat*> cv_videostab_getMotion_int_int_const_vector_Mat_R(int from, int to, const std::vector<cv::Mat>* motions) {
		try {
			cv::Mat ret = cv::videostab::getMotion(from, to, *motions);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_ColorAverageInpainter_delete(cv::videostab::ColorAverageInpainter* instance) {
		delete instance;
	}
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:177
	Result_void cv_videostab_ColorAverageInpainter_inpaint_int_MatR_MatR(cv::videostab::ColorAverageInpainter* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_ColorInpainter_delete(cv::videostab::ColorInpainter* instance) {
		delete instance;
	}
	// ColorInpainter(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:186
	Result<cv::videostab::ColorInpainter*> cv_videostab_ColorInpainter_ColorInpainter_int_double(int method, double radius) {
		try {
			cv::videostab::ColorInpainter* ret = new cv::videostab::ColorInpainter(method, radius);
			return Ok<cv::videostab::ColorInpainter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::ColorInpainter*>))
	}
	
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:188
	Result_void cv_videostab_ColorInpainter_inpaint_int_MatR_MatR(cv::videostab::ColorInpainter* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_ConsistentMosaicInpainter_delete(cv::videostab::ConsistentMosaicInpainter* instance) {
		delete instance;
	}
	// ConsistentMosaicInpainter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:130
	Result<cv::videostab::ConsistentMosaicInpainter*> cv_videostab_ConsistentMosaicInpainter_ConsistentMosaicInpainter() {
		try {
			cv::videostab::ConsistentMosaicInpainter* ret = new cv::videostab::ConsistentMosaicInpainter();
			return Ok<cv::videostab::ConsistentMosaicInpainter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::ConsistentMosaicInpainter*>))
	}
	
	// setStdevThresh(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:132
	Result_void cv_videostab_ConsistentMosaicInpainter_setStdevThresh_float(cv::videostab::ConsistentMosaicInpainter* instance, float val) {
		try {
			instance->setStdevThresh(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stdevThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:133
	Result<float> cv_videostab_ConsistentMosaicInpainter_stdevThresh_const(const cv::videostab::ConsistentMosaicInpainter* instance) {
		try {
			float ret = instance->stdevThresh();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:135
	Result_void cv_videostab_ConsistentMosaicInpainter_inpaint_int_MatR_MatR(cv::videostab::ConsistentMosaicInpainter* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:66
	Result_void cv_videostab_DeblurerBase_setRadius_int(cv::videostab::DeblurerBase* instance, int val) {
		try {
			instance->setRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:67
	Result<int> cv_videostab_DeblurerBase_radius_const(const cv::videostab::DeblurerBase* instance) {
		try {
			int ret = instance->radius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// deblur(int, cv::Mat &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:69
	Result_void cv_videostab_DeblurerBase_deblur_int_MatR_const_RangeR(cv::videostab::DeblurerBase* instance, int idx, cv::Mat* frame, const cv::Range* range) {
		try {
			instance->deblur(idx, *frame, *range);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFrames(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:74
	Result_void cv_videostab_DeblurerBase_setFrames_const_vector_Mat_R(cv::videostab::DeblurerBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setFrames(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// frames() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:75
	Result<const std::vector<cv::Mat>*> cv_videostab_DeblurerBase_frames_const(const cv::videostab::DeblurerBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->frames();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:77
	Result_void cv_videostab_DeblurerBase_setMotions_const_vector_Mat_R(cv::videostab::DeblurerBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:78
	Result<const std::vector<cv::Mat>*> cv_videostab_DeblurerBase_motions_const(const cv::videostab::DeblurerBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->motions();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setBlurrinessRates(const std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:80
	Result_void cv_videostab_DeblurerBase_setBlurrinessRates_const_vector_float_R(cv::videostab::DeblurerBase* instance, const std::vector<float>* val) {
		try {
			instance->setBlurrinessRates(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blurrinessRates() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:81
	Result<const std::vector<float>*> cv_videostab_DeblurerBase_blurrinessRates_const(const cv::videostab::DeblurerBase* instance) {
		try {
			const std::vector<float> ret = instance->blurrinessRates();
			return Ok(new const std::vector<float>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<float>*>))
	}
	
	cv::videostab::PyrLkOptFlowEstimatorBase* cv_DensePyrLkOptFlowEstimatorGpu_to_PyrLkOptFlowEstimatorBase(cv::videostab::DensePyrLkOptFlowEstimatorGpu* instance) {
		return dynamic_cast<cv::videostab::PyrLkOptFlowEstimatorBase*>(instance);
	}
	
	void cv_DensePyrLkOptFlowEstimatorGpu_delete(cv::videostab::DensePyrLkOptFlowEstimatorGpu* instance) {
		delete instance;
	}
	// DensePyrLkOptFlowEstimatorGpu() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:132
	Result<cv::videostab::DensePyrLkOptFlowEstimatorGpu*> cv_videostab_DensePyrLkOptFlowEstimatorGpu_DensePyrLkOptFlowEstimatorGpu() {
		try {
			cv::videostab::DensePyrLkOptFlowEstimatorGpu* ret = new cv::videostab::DensePyrLkOptFlowEstimatorGpu();
			return Ok<cv::videostab::DensePyrLkOptFlowEstimatorGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::DensePyrLkOptFlowEstimatorGpu*>))
	}
	
	// run(cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:134
	Result_void cv_videostab_DensePyrLkOptFlowEstimatorGpu_run_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR(cv::videostab::DensePyrLkOptFlowEstimatorGpu* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_InputOutputArray* flowX, const cv::_InputOutputArray* flowY, const cv::_OutputArray* errors) {
		try {
			instance->run(*frame0, *frame1, *flowX, *flowY, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_FastMarchingMethod_delete(cv::videostab::FastMarchingMethod* instance) {
		delete instance;
	}
	// FastMarchingMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/fast_marching.hpp:66
	Result<cv::videostab::FastMarchingMethod*> cv_videostab_FastMarchingMethod_FastMarchingMethod() {
		try {
			cv::videostab::FastMarchingMethod* ret = new cv::videostab::FastMarchingMethod();
			return Ok<cv::videostab::FastMarchingMethod*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::FastMarchingMethod*>))
	}
	
	// distanceMap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/fast_marching.hpp:81
	Result<cv::Mat*> cv_videostab_FastMarchingMethod_distanceMap_const(const cv::videostab::FastMarchingMethod* instance) {
		try {
			cv::Mat ret = instance->distanceMap();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_FromFileMotionReader_delete(cv::videostab::FromFileMotionReader* instance) {
		delete instance;
	}
	// FromFileMotionReader(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:201
	Result<cv::videostab::FromFileMotionReader*> cv_videostab_FromFileMotionReader_FromFileMotionReader_const_StringR(const char* path) {
		try {
			cv::videostab::FromFileMotionReader* ret = new cv::videostab::FromFileMotionReader(std::string(path));
			return Ok<cv::videostab::FromFileMotionReader*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::FromFileMotionReader*>))
	}
	
	// estimate(const cv::Mat &, const cv::Mat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:203
	Result<cv::Mat*> cv_videostab_FromFileMotionReader_estimate_const_MatR_const_MatR_boolX(cv::videostab::FromFileMotionReader* instance, const cv::Mat* frame0, const cv::Mat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_GaussianMotionFilter_delete(cv::videostab::GaussianMotionFilter* instance) {
		delete instance;
	}
	// GaussianMotionFilter(int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:100
	Result<cv::videostab::GaussianMotionFilter*> cv_videostab_GaussianMotionFilter_GaussianMotionFilter_int_float(int radius, float stdev) {
		try {
			cv::videostab::GaussianMotionFilter* ret = new cv::videostab::GaussianMotionFilter(radius, stdev);
			return Ok<cv::videostab::GaussianMotionFilter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::GaussianMotionFilter*>))
	}
	
	// setParams(int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:102
	Result_void cv_videostab_GaussianMotionFilter_setParams_int_float(cv::videostab::GaussianMotionFilter* instance, int radius, float stdev) {
		try {
			instance->setParams(radius, stdev);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:103
	Result<int> cv_videostab_GaussianMotionFilter_radius_const(const cv::videostab::GaussianMotionFilter* instance) {
		try {
			int ret = instance->radius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// stdev() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:104
	Result<float> cv_videostab_GaussianMotionFilter_stdev_const(const cv::videostab::GaussianMotionFilter* instance) {
		try {
			float ret = instance->stdev();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:106
	Result<cv::Mat*> cv_videostab_GaussianMotionFilter_stabilize_int_const_vector_Mat_R_const_RangeR(cv::videostab::GaussianMotionFilter* instance, int idx, const std::vector<cv::Mat>* motions, const cv::Range* range) {
		try {
			cv::Mat ret = instance->stabilize(idx, *motions, *range);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// run(cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:74
	Result_void cv_videostab_IDenseOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR(cv::videostab::IDenseOptFlowEstimator* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_InputOutputArray* flowX, const cv::_InputOutputArray* flowY, const cv::_OutputArray* errors) {
		try {
			instance->run(*frame0, *frame1, *flowX, *flowY, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:61
	Result_void cv_videostab_IFrameSource_reset(cv::videostab::IFrameSource* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:62
	Result<cv::Mat*> cv_videostab_IFrameSource_nextFrame(cv::videostab::IFrameSource* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// print(const char *, ...) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/log.hpp:60
	Result_void cv_videostab_ILog_print_const_charX(cv::videostab::ILog* instance, const char* format) {
		try {
			instance->print(format);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:65
	Result_void cv_videostab_IMotionStabilizer_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(cv::videostab::IMotionStabilizer* instance, int size, const std::vector<cv::Mat>* motions, const cv::Range* range, cv::Mat* stabilizationMotions) {
		try {
			instance->stabilize(size, *motions, *range, stabilizationMotions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// process(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:63
	Result_void cv_videostab_IOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::videostab::IOutlierRejector* instance, cv::Size* frameSize, const cv::_InputArray* points0, const cv::_InputArray* points1, const cv::_OutputArray* mask) {
		try {
			instance->process(*frameSize, *points0, *points1, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:65
	Result_void cv_videostab_ISparseOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::videostab::ISparseOptFlowEstimator* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_InputArray* points0, const cv::_InputOutputArray* points1, const cv::_OutputArray* status, const cv::_OutputArray* errors) {
		try {
			instance->run(*frame0, *frame1, *points0, *points1, *status, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:180
	Result_void cv_videostab_ImageMotionEstimatorBase_setMotionModel_MotionModel(cv::videostab::ImageMotionEstimatorBase* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:181
	Result<cv::videostab::MotionModel> cv_videostab_ImageMotionEstimatorBase_motionModel_const(const cv::videostab::ImageMotionEstimatorBase* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// setFrameMask(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:183
	Result_void cv_videostab_ImageMotionEstimatorBase_setFrameMask_const__InputArrayR(cv::videostab::ImageMotionEstimatorBase* instance, const cv::_InputArray* mask) {
		try {
			instance->setFrameMask(*mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimate(const cv::Mat &, const cv::Mat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:189
	Result<cv::Mat*> cv_videostab_ImageMotionEstimatorBase_estimate_const_MatR_const_MatR_boolX(cv::videostab::ImageMotionEstimatorBase* instance, const cv::Mat* frame0, const cv::Mat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:70
	Result_void cv_videostab_InpainterBase_setRadius_int(cv::videostab::InpainterBase* instance, int val) {
		try {
			instance->setRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:71
	Result<int> cv_videostab_InpainterBase_radius_const(const cv::videostab::InpainterBase* instance) {
		try {
			int ret = instance->radius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:73
	Result_void cv_videostab_InpainterBase_setMotionModel_MotionModel(cv::videostab::InpainterBase* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:74
	Result<cv::videostab::MotionModel> cv_videostab_InpainterBase_motionModel_const(const cv::videostab::InpainterBase* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:76
	Result_void cv_videostab_InpainterBase_inpaint_int_MatR_MatR(cv::videostab::InpainterBase* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFrames(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:81
	Result_void cv_videostab_InpainterBase_setFrames_const_vector_Mat_R(cv::videostab::InpainterBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setFrames(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// frames() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:82
	Result<const std::vector<cv::Mat>*> cv_videostab_InpainterBase_frames_const(const cv::videostab::InpainterBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->frames();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:84
	Result_void cv_videostab_InpainterBase_setMotions_const_vector_Mat_R(cv::videostab::InpainterBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:85
	Result<const std::vector<cv::Mat>*> cv_videostab_InpainterBase_motions_const(const cv::videostab::InpainterBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->motions();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setStabilizedFrames(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:87
	Result_void cv_videostab_InpainterBase_setStabilizedFrames_const_vector_Mat_R(cv::videostab::InpainterBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setStabilizedFrames(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stabilizedFrames() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:88
	Result<const std::vector<cv::Mat>*> cv_videostab_InpainterBase_stabilizedFrames_const(const cv::videostab::InpainterBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->stabilizedFrames();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setStabilizationMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:90
	Result_void cv_videostab_InpainterBase_setStabilizationMotions_const_vector_Mat_R(cv::videostab::InpainterBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setStabilizationMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stabilizationMotions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:91
	Result<const std::vector<cv::Mat>*> cv_videostab_InpainterBase_stabilizationMotions_const(const cv::videostab::InpainterBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->stabilizationMotions();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	void cv_InpaintingPipeline_delete(cv::videostab::InpaintingPipeline* instance) {
		delete instance;
	}
	// pushBack(Ptr<cv::videostab::InpainterBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:111
	Result_void cv_videostab_InpaintingPipeline_pushBack_Ptr_InpainterBase_(cv::videostab::InpaintingPipeline* instance, cv::Ptr<cv::videostab::InpainterBase>* inpainter) {
		try {
			instance->pushBack(*inpainter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:112
	Result<bool> cv_videostab_InpaintingPipeline_empty_const(const cv::videostab::InpaintingPipeline* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:114
	Result_void cv_videostab_InpaintingPipeline_setRadius_int(cv::videostab::InpaintingPipeline* instance, int val) {
		try {
			instance->setRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:115
	Result_void cv_videostab_InpaintingPipeline_setMotionModel_MotionModel(cv::videostab::InpaintingPipeline* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFrames(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:116
	Result_void cv_videostab_InpaintingPipeline_setFrames_const_vector_Mat_R(cv::videostab::InpaintingPipeline* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setFrames(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:117
	Result_void cv_videostab_InpaintingPipeline_setMotions_const_vector_Mat_R(cv::videostab::InpaintingPipeline* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setStabilizedFrames(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:118
	Result_void cv_videostab_InpaintingPipeline_setStabilizedFrames_const_vector_Mat_R(cv::videostab::InpaintingPipeline* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setStabilizedFrames(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setStabilizationMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:119
	Result_void cv_videostab_InpaintingPipeline_setStabilizationMotions_const_vector_Mat_R(cv::videostab::InpaintingPipeline* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setStabilizationMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:121
	Result_void cv_videostab_InpaintingPipeline_inpaint_int_MatR_MatR(cv::videostab::InpaintingPipeline* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_KeypointBasedMotionEstimator_delete(cv::videostab::KeypointBasedMotionEstimator* instance) {
		delete instance;
	}
	// KeypointBasedMotionEstimator(Ptr<cv::videostab::MotionEstimatorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:232
	Result<cv::videostab::KeypointBasedMotionEstimator*> cv_videostab_KeypointBasedMotionEstimator_KeypointBasedMotionEstimator_Ptr_MotionEstimatorBase_(cv::Ptr<cv::videostab::MotionEstimatorBase>* estimator) {
		try {
			cv::videostab::KeypointBasedMotionEstimator* ret = new cv::videostab::KeypointBasedMotionEstimator(*estimator);
			return Ok<cv::videostab::KeypointBasedMotionEstimator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::KeypointBasedMotionEstimator*>))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:234
	Result_void cv_videostab_KeypointBasedMotionEstimator_setMotionModel_MotionModel(cv::videostab::KeypointBasedMotionEstimator* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:235
	Result<cv::videostab::MotionModel> cv_videostab_KeypointBasedMotionEstimator_motionModel_const(const cv::videostab::KeypointBasedMotionEstimator* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// setDetector(Ptr<cv::FeatureDetector>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:237
	Result_void cv_videostab_KeypointBasedMotionEstimator_setDetector_Ptr_Feature2D_(cv::videostab::KeypointBasedMotionEstimator* instance, cv::Ptr<cv::Feature2D>* val) {
		try {
			instance->setDetector(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:238
	Result<cv::Ptr<cv::Feature2D>*> cv_videostab_KeypointBasedMotionEstimator_detector_const(const cv::videostab::KeypointBasedMotionEstimator* instance) {
		try {
			cv::Ptr<cv::Feature2D> ret = instance->detector();
			return Ok(new cv::Ptr<cv::Feature2D>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::Feature2D>*>))
	}
	
	// setOpticalFlowEstimator(Ptr<cv::videostab::ISparseOptFlowEstimator>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:240
	Result_void cv_videostab_KeypointBasedMotionEstimator_setOpticalFlowEstimator_Ptr_ISparseOptFlowEstimator_(cv::videostab::KeypointBasedMotionEstimator* instance, cv::Ptr<cv::videostab::ISparseOptFlowEstimator>* val) {
		try {
			instance->setOpticalFlowEstimator(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// opticalFlowEstimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:241
	Result<cv::Ptr<cv::videostab::ISparseOptFlowEstimator>*> cv_videostab_KeypointBasedMotionEstimator_opticalFlowEstimator_const(const cv::videostab::KeypointBasedMotionEstimator* instance) {
		try {
			cv::Ptr<cv::videostab::ISparseOptFlowEstimator> ret = instance->opticalFlowEstimator();
			return Ok(new cv::Ptr<cv::videostab::ISparseOptFlowEstimator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::ISparseOptFlowEstimator>*>))
	}
	
	// setOutlierRejector(Ptr<cv::videostab::IOutlierRejector>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:243
	Result_void cv_videostab_KeypointBasedMotionEstimator_setOutlierRejector_Ptr_IOutlierRejector_(cv::videostab::KeypointBasedMotionEstimator* instance, cv::Ptr<cv::videostab::IOutlierRejector>* val) {
		try {
			instance->setOutlierRejector(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// outlierRejector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:244
	Result<cv::Ptr<cv::videostab::IOutlierRejector>*> cv_videostab_KeypointBasedMotionEstimator_outlierRejector_const(const cv::videostab::KeypointBasedMotionEstimator* instance) {
		try {
			cv::Ptr<cv::videostab::IOutlierRejector> ret = instance->outlierRejector();
			return Ok(new cv::Ptr<cv::videostab::IOutlierRejector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IOutlierRejector>*>))
	}
	
	// setFrameMask(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:246
	Result_void cv_videostab_KeypointBasedMotionEstimator_setFrameMask_const__InputArrayR(cv::videostab::KeypointBasedMotionEstimator* instance, const cv::_InputArray* mask) {
		try {
			instance->setFrameMask(*mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimate(const cv::Mat &, const cv::Mat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:248
	Result<cv::Mat*> cv_videostab_KeypointBasedMotionEstimator_estimate_const_MatR_const_MatR_boolX(cv::videostab::KeypointBasedMotionEstimator* instance, const cv::Mat* frame0, const cv::Mat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// estimate(cv::InputArray, cv::InputArray, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:249
	Result<cv::Mat*> cv_videostab_KeypointBasedMotionEstimator_estimate_const__InputArrayR_const__InputArrayR_boolX(cv::videostab::KeypointBasedMotionEstimator* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_KeypointBasedMotionEstimatorGpu_delete(cv::videostab::KeypointBasedMotionEstimatorGpu* instance) {
		delete instance;
	}
	// KeypointBasedMotionEstimatorGpu(Ptr<cv::videostab::MotionEstimatorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:269
	Result<cv::videostab::KeypointBasedMotionEstimatorGpu*> cv_videostab_KeypointBasedMotionEstimatorGpu_KeypointBasedMotionEstimatorGpu_Ptr_MotionEstimatorBase_(cv::Ptr<cv::videostab::MotionEstimatorBase>* estimator) {
		try {
			cv::videostab::KeypointBasedMotionEstimatorGpu* ret = new cv::videostab::KeypointBasedMotionEstimatorGpu(*estimator);
			return Ok<cv::videostab::KeypointBasedMotionEstimatorGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::KeypointBasedMotionEstimatorGpu*>))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:271
	Result_void cv_videostab_KeypointBasedMotionEstimatorGpu_setMotionModel_MotionModel(cv::videostab::KeypointBasedMotionEstimatorGpu* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:272
	Result<cv::videostab::MotionModel> cv_videostab_KeypointBasedMotionEstimatorGpu_motionModel_const(const cv::videostab::KeypointBasedMotionEstimatorGpu* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// setOutlierRejector(Ptr<cv::videostab::IOutlierRejector>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:274
	Result_void cv_videostab_KeypointBasedMotionEstimatorGpu_setOutlierRejector_Ptr_IOutlierRejector_(cv::videostab::KeypointBasedMotionEstimatorGpu* instance, cv::Ptr<cv::videostab::IOutlierRejector>* val) {
		try {
			instance->setOutlierRejector(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// outlierRejector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:275
	Result<cv::Ptr<cv::videostab::IOutlierRejector>*> cv_videostab_KeypointBasedMotionEstimatorGpu_outlierRejector_const(const cv::videostab::KeypointBasedMotionEstimatorGpu* instance) {
		try {
			cv::Ptr<cv::videostab::IOutlierRejector> ret = instance->outlierRejector();
			return Ok(new cv::Ptr<cv::videostab::IOutlierRejector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IOutlierRejector>*>))
	}
	
	// estimate(const cv::Mat &, const cv::Mat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:277
	Result<cv::Mat*> cv_videostab_KeypointBasedMotionEstimatorGpu_estimate_const_MatR_const_MatR_boolX(cv::videostab::KeypointBasedMotionEstimatorGpu* instance, const cv::Mat* frame0, const cv::Mat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// estimate(const cuda::GpuMat &, const cuda::GpuMat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:278
	Result<cv::Mat*> cv_videostab_KeypointBasedMotionEstimatorGpu_estimate_const_GpuMatR_const_GpuMatR_boolX(cv::videostab::KeypointBasedMotionEstimatorGpu* instance, const cv::cuda::GpuMat* frame0, const cv::cuda::GpuMat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_LogToStdout_delete(cv::videostab::LogToStdout* instance) {
		delete instance;
	}
	// print(const char *, ...) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/log.hpp:72
	Result_void cv_videostab_LogToStdout_print_const_charX(cv::videostab::LogToStdout* instance, const char* format) {
		try {
			instance->print(format);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_LpMotionStabilizer_delete(cv::videostab::LpMotionStabilizer* instance) {
		delete instance;
	}
	// LpMotionStabilizer(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:120
	Result<cv::videostab::LpMotionStabilizer*> cv_videostab_LpMotionStabilizer_LpMotionStabilizer_MotionModel(cv::videostab::MotionModel model) {
		try {
			cv::videostab::LpMotionStabilizer* ret = new cv::videostab::LpMotionStabilizer(model);
			return Ok<cv::videostab::LpMotionStabilizer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::LpMotionStabilizer*>))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:122
	Result_void cv_videostab_LpMotionStabilizer_setMotionModel_MotionModel(cv::videostab::LpMotionStabilizer* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:123
	Result<cv::videostab::MotionModel> cv_videostab_LpMotionStabilizer_motionModel_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// setFrameSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:125
	Result_void cv_videostab_LpMotionStabilizer_setFrameSize_Size(cv::videostab::LpMotionStabilizer* instance, cv::Size* val) {
		try {
			instance->setFrameSize(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// frameSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:126
	Result<cv::Size> cv_videostab_LpMotionStabilizer_frameSize_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			cv::Size ret = instance->frameSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setTrimRatio(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:128
	Result_void cv_videostab_LpMotionStabilizer_setTrimRatio_float(cv::videostab::LpMotionStabilizer* instance, float val) {
		try {
			instance->setTrimRatio(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// trimRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:129
	Result<float> cv_videostab_LpMotionStabilizer_trimRatio_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			float ret = instance->trimRatio();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setWeight1(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:131
	Result_void cv_videostab_LpMotionStabilizer_setWeight1_float(cv::videostab::LpMotionStabilizer* instance, float val) {
		try {
			instance->setWeight1(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// weight1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:132
	Result<float> cv_videostab_LpMotionStabilizer_weight1_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			float ret = instance->weight1();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setWeight2(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:134
	Result_void cv_videostab_LpMotionStabilizer_setWeight2_float(cv::videostab::LpMotionStabilizer* instance, float val) {
		try {
			instance->setWeight2(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// weight2() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:135
	Result<float> cv_videostab_LpMotionStabilizer_weight2_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			float ret = instance->weight2();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setWeight3(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:137
	Result_void cv_videostab_LpMotionStabilizer_setWeight3_float(cv::videostab::LpMotionStabilizer* instance, float val) {
		try {
			instance->setWeight3(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// weight3() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:138
	Result<float> cv_videostab_LpMotionStabilizer_weight3_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			float ret = instance->weight3();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setWeight4(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:140
	Result_void cv_videostab_LpMotionStabilizer_setWeight4_float(cv::videostab::LpMotionStabilizer* instance, float val) {
		try {
			instance->setWeight4(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// weight4() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:141
	Result<float> cv_videostab_LpMotionStabilizer_weight4_const(const cv::videostab::LpMotionStabilizer* instance) {
		try {
			float ret = instance->weight4();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:143
	Result_void cv_videostab_LpMotionStabilizer_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(cv::videostab::LpMotionStabilizer* instance, int size, const std::vector<cv::Mat>* motions, const cv::Range* range, cv::Mat* stabilizationMotions) {
		try {
			instance->stabilize(size, *motions, *range, stabilizationMotions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_MaskFrameSource_delete(cv::videostab::MaskFrameSource* instance) {
		delete instance;
	}
	// MaskFrameSource(const Ptr<cv::videostab::IFrameSource> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:92
	Result<cv::videostab::MaskFrameSource*> cv_videostab_MaskFrameSource_MaskFrameSource_const_Ptr_IFrameSource_R(const cv::Ptr<cv::videostab::IFrameSource>* source) {
		try {
			cv::videostab::MaskFrameSource* ret = new cv::videostab::MaskFrameSource(*source);
			return Ok<cv::videostab::MaskFrameSource*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MaskFrameSource*>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:94
	Result_void cv_videostab_MaskFrameSource_reset(cv::videostab::MaskFrameSource* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:95
	Result<cv::Mat*> cv_videostab_MaskFrameSource_nextFrame(cv::videostab::MaskFrameSource* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_MoreAccurateMotionWobbleSuppressor_delete(cv::videostab::MoreAccurateMotionWobbleSuppressor* instance) {
		delete instance;
	}
	// suppress(int, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:116
	Result_void cv_videostab_MoreAccurateMotionWobbleSuppressor_suppress_int_const_MatR_MatR(cv::videostab::MoreAccurateMotionWobbleSuppressor* instance, int idx, const cv::Mat* frame, cv::Mat* result) {
		try {
			instance->suppress(idx, *frame, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPeriod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:104
	Result_void cv_videostab_MoreAccurateMotionWobbleSuppressorBase_setPeriod_int(cv::videostab::MoreAccurateMotionWobbleSuppressorBase* instance, int val) {
		try {
			instance->setPeriod(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// period() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:105
	Result<int> cv_videostab_MoreAccurateMotionWobbleSuppressorBase_period_const(const cv::videostab::MoreAccurateMotionWobbleSuppressorBase* instance) {
		try {
			int ret = instance->period();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_MoreAccurateMotionWobbleSuppressorGpu_delete(cv::videostab::MoreAccurateMotionWobbleSuppressorGpu* instance) {
		delete instance;
	}
	// suppress(int, const cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:126
	Result_void cv_videostab_MoreAccurateMotionWobbleSuppressorGpu_suppress_int_const_GpuMatR_GpuMatR(cv::videostab::MoreAccurateMotionWobbleSuppressorGpu* instance, int idx, const cv::cuda::GpuMat* frame, cv::cuda::GpuMat* result) {
		try {
			instance->suppress(idx, *frame, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// suppress(int, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:127
	Result_void cv_videostab_MoreAccurateMotionWobbleSuppressorGpu_suppress_int_const_MatR_MatR(cv::videostab::MoreAccurateMotionWobbleSuppressorGpu* instance, int idx, const cv::Mat* frame, cv::Mat* result) {
		try {
			instance->suppress(idx, *frame, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:106
	Result_void cv_videostab_MotionEstimatorBase_setMotionModel_MotionModel(cv::videostab::MotionEstimatorBase* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:111
	Result<cv::videostab::MotionModel> cv_videostab_MotionEstimatorBase_motionModel_const(const cv::videostab::MotionEstimatorBase* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// estimate(cv::InputArray, cv::InputArray, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:120
	Result<cv::Mat*> cv_videostab_MotionEstimatorBase_estimate_const__InputArrayR_const__InputArrayR_boolX(cv::videostab::MotionEstimatorBase* instance, const cv::_InputArray* points0, const cv::_InputArray* points1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*points0, *points1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_MotionEstimatorL1_delete(cv::videostab::MotionEstimatorL1* instance) {
		delete instance;
	}
	// MotionEstimatorL1(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:156
	Result<cv::videostab::MotionEstimatorL1*> cv_videostab_MotionEstimatorL1_MotionEstimatorL1_MotionModel(cv::videostab::MotionModel model) {
		try {
			cv::videostab::MotionEstimatorL1* ret = new cv::videostab::MotionEstimatorL1(model);
			return Ok<cv::videostab::MotionEstimatorL1*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionEstimatorL1*>))
	}
	
	// estimate(cv::InputArray, cv::InputArray, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:158
	Result<cv::Mat*> cv_videostab_MotionEstimatorL1_estimate_const__InputArrayR_const__InputArrayR_boolX(cv::videostab::MotionEstimatorL1* instance, const cv::_InputArray* points0, const cv::_InputArray* points1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*points0, *points1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_MotionEstimatorRansacL2_delete(cv::videostab::MotionEstimatorRansacL2* instance) {
		delete instance;
	}
	// MotionEstimatorRansacL2(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:134
	Result<cv::videostab::MotionEstimatorRansacL2*> cv_videostab_MotionEstimatorRansacL2_MotionEstimatorRansacL2_MotionModel(cv::videostab::MotionModel model) {
		try {
			cv::videostab::MotionEstimatorRansacL2* ret = new cv::videostab::MotionEstimatorRansacL2(model);
			return Ok<cv::videostab::MotionEstimatorRansacL2*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionEstimatorRansacL2*>))
	}
	
	// setRansacParams(const cv::videostab::RansacParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:136
	Result_void cv_videostab_MotionEstimatorRansacL2_setRansacParams_const_RansacParamsR(cv::videostab::MotionEstimatorRansacL2* instance, const cv::videostab::RansacParams* val) {
		try {
			instance->setRansacParams(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ransacParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:137
	Result<cv::videostab::RansacParams*> cv_videostab_MotionEstimatorRansacL2_ransacParams_const(const cv::videostab::MotionEstimatorRansacL2* instance) {
		try {
			cv::videostab::RansacParams ret = instance->ransacParams();
			return Ok(new cv::videostab::RansacParams(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::RansacParams*>))
	}
	
	// setMinInlierRatio(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:139
	Result_void cv_videostab_MotionEstimatorRansacL2_setMinInlierRatio_float(cv::videostab::MotionEstimatorRansacL2* instance, float val) {
		try {
			instance->setMinInlierRatio(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minInlierRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:140
	Result<float> cv_videostab_MotionEstimatorRansacL2_minInlierRatio_const(const cv::videostab::MotionEstimatorRansacL2* instance) {
		try {
			float ret = instance->minInlierRatio();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// estimate(cv::InputArray, cv::InputArray, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:142
	Result<cv::Mat*> cv_videostab_MotionEstimatorRansacL2_estimate_const__InputArrayR_const__InputArrayR_boolX(cv::videostab::MotionEstimatorRansacL2* instance, const cv::_InputArray* points0, const cv::_InputArray* points1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*points0, *points1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:89
	Result<cv::Mat*> cv_videostab_MotionFilterBase_stabilize_int_const_vector_Mat_R_const_RangeR(cv::videostab::MotionFilterBase* instance, int idx, const std::vector<cv::Mat>* motions, const cv::Range* range) {
		try {
			cv::Mat ret = instance->stabilize(idx, *motions, *range);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:92
	Result_void cv_videostab_MotionFilterBase_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(cv::videostab::MotionFilterBase* instance, int size, const std::vector<cv::Mat>* motions, const cv::Range* range, cv::Mat* stabilizationMotions) {
		try {
			instance->stabilize(size, *motions, *range, stabilizationMotions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_MotionInpainter_delete(cv::videostab::MotionInpainter* instance) {
		delete instance;
	}
	// MotionInpainter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:144
	Result<cv::videostab::MotionInpainter*> cv_videostab_MotionInpainter_MotionInpainter() {
		try {
			cv::videostab::MotionInpainter* ret = new cv::videostab::MotionInpainter();
			return Ok<cv::videostab::MotionInpainter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionInpainter*>))
	}
	
	// setOptFlowEstimator(Ptr<cv::videostab::IDenseOptFlowEstimator>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:146
	Result_void cv_videostab_MotionInpainter_setOptFlowEstimator_Ptr_IDenseOptFlowEstimator_(cv::videostab::MotionInpainter* instance, cv::Ptr<cv::videostab::IDenseOptFlowEstimator>* val) {
		try {
			instance->setOptFlowEstimator(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// optFlowEstimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:147
	Result<cv::Ptr<cv::videostab::IDenseOptFlowEstimator>*> cv_videostab_MotionInpainter_optFlowEstimator_const(const cv::videostab::MotionInpainter* instance) {
		try {
			cv::Ptr<cv::videostab::IDenseOptFlowEstimator> ret = instance->optFlowEstimator();
			return Ok(new cv::Ptr<cv::videostab::IDenseOptFlowEstimator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IDenseOptFlowEstimator>*>))
	}
	
	// setFlowErrorThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:149
	Result_void cv_videostab_MotionInpainter_setFlowErrorThreshold_float(cv::videostab::MotionInpainter* instance, float val) {
		try {
			instance->setFlowErrorThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flowErrorThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:150
	Result<float> cv_videostab_MotionInpainter_flowErrorThreshold_const(const cv::videostab::MotionInpainter* instance) {
		try {
			float ret = instance->flowErrorThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setDistThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:152
	Result_void cv_videostab_MotionInpainter_setDistThreshold_float(cv::videostab::MotionInpainter* instance, float val) {
		try {
			instance->setDistThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// distThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:153
	Result<float> cv_videostab_MotionInpainter_distThresh_const(const cv::videostab::MotionInpainter* instance) {
		try {
			float ret = instance->distThresh();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setBorderMode(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:155
	Result_void cv_videostab_MotionInpainter_setBorderMode_int(cv::videostab::MotionInpainter* instance, int val) {
		try {
			instance->setBorderMode(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// borderMode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:156
	Result<int> cv_videostab_MotionInpainter_borderMode_const(const cv::videostab::MotionInpainter* instance) {
		try {
			int ret = instance->borderMode();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:158
	Result_void cv_videostab_MotionInpainter_inpaint_int_MatR_MatR(cv::videostab::MotionInpainter* instance, int idx, cv::Mat* frame, cv::Mat* mask) {
		try {
			instance->inpaint(idx, *frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_MotionStabilizationPipeline_delete(cv::videostab::MotionStabilizationPipeline* instance) {
		delete instance;
	}
	// pushBack(Ptr<cv::videostab::IMotionStabilizer>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:73
	Result_void cv_videostab_MotionStabilizationPipeline_pushBack_Ptr_IMotionStabilizer_(cv::videostab::MotionStabilizationPipeline* instance, cv::Ptr<cv::videostab::IMotionStabilizer>* stabilizer) {
		try {
			instance->pushBack(*stabilizer);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:74
	Result<bool> cv_videostab_MotionStabilizationPipeline_empty_const(const cv::videostab::MotionStabilizationPipeline* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// stabilize(int, const std::vector<Mat> &, const cv::Range &, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_stabilizing.hpp:76
	Result_void cv_videostab_MotionStabilizationPipeline_stabilize_int_const_vector_Mat_R_const_RangeR_MatX(cv::videostab::MotionStabilizationPipeline* instance, int size, const std::vector<cv::Mat>* motions, const cv::Range* range, cv::Mat* stabilizationMotions) {
		try {
			instance->stabilize(size, *motions, *range, stabilizationMotions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_NullDeblurer_delete(cv::videostab::NullDeblurer* instance) {
		delete instance;
	}
	// deblur(int, cv::Mat &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:93
	Result_void cv_videostab_NullDeblurer_deblur_int_MatR_const_RangeR(cv::videostab::NullDeblurer* instance, int unnamed, cv::Mat* unnamed_1, const cv::Range* unnamed_2) {
		try {
			instance->deblur(unnamed, *unnamed_1, *unnamed_2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_NullFrameSource_delete(cv::videostab::NullFrameSource* instance) {
		delete instance;
	}
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:68
	Result_void cv_videostab_NullFrameSource_reset(cv::videostab::NullFrameSource* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:69
	Result<cv::Mat*> cv_videostab_NullFrameSource_nextFrame(cv::videostab::NullFrameSource* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_NullInpainter_delete(cv::videostab::NullInpainter* instance) {
		delete instance;
	}
	// inpaint(int, cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/inpainting.hpp:105
	Result_void cv_videostab_NullInpainter_inpaint_int_MatR_MatR(cv::videostab::NullInpainter* instance, int unnamed, cv::Mat* unnamed_1, cv::Mat* unnamed_2) {
		try {
			instance->inpaint(unnamed, *unnamed_1, *unnamed_2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_NullLog_delete(cv::videostab::NullLog* instance) {
		delete instance;
	}
	// print(const char *, ...) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/log.hpp:66
	Result_void cv_videostab_NullLog_print_const_charX(cv::videostab::NullLog* instance, const char* unnamed) {
		try {
			instance->print(unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_NullOutlierRejector_delete(cv::videostab::NullOutlierRejector* instance) {
		delete instance;
	}
	// process(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:70
	Result_void cv_videostab_NullOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::videostab::NullOutlierRejector* instance, cv::Size* frameSize, const cv::_InputArray* points0, const cv::_InputArray* points1, const cv::_OutputArray* mask) {
		try {
			instance->process(*frameSize, *points0, *points1, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_NullWobbleSuppressor_delete(cv::videostab::NullWobbleSuppressor* instance) {
		delete instance;
	}
	// suppress(int, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:98
	Result_void cv_videostab_NullWobbleSuppressor_suppress_int_const_MatR_MatR(cv::videostab::NullWobbleSuppressor* instance, int idx, const cv::Mat* frame, cv::Mat* result) {
		try {
			instance->suppress(idx, *frame, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_OnePassStabilizer_delete(cv::videostab::OnePassStabilizer* instance) {
		delete instance;
	}
	// OnePassStabilizer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:146
	Result<cv::videostab::OnePassStabilizer*> cv_videostab_OnePassStabilizer_OnePassStabilizer() {
		try {
			cv::videostab::OnePassStabilizer* ret = new cv::videostab::OnePassStabilizer();
			return Ok<cv::videostab::OnePassStabilizer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::OnePassStabilizer*>))
	}
	
	// setMotionFilter(Ptr<cv::videostab::MotionFilterBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:148
	Result_void cv_videostab_OnePassStabilizer_setMotionFilter_Ptr_MotionFilterBase_(cv::videostab::OnePassStabilizer* instance, cv::Ptr<cv::videostab::MotionFilterBase>* val) {
		try {
			instance->setMotionFilter(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionFilter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:149
	Result<cv::Ptr<cv::videostab::MotionFilterBase>*> cv_videostab_OnePassStabilizer_motionFilter_const(const cv::videostab::OnePassStabilizer* instance) {
		try {
			cv::Ptr<cv::videostab::MotionFilterBase> ret = instance->motionFilter();
			return Ok(new cv::Ptr<cv::videostab::MotionFilterBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::MotionFilterBase>*>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:151
	Result_void cv_videostab_OnePassStabilizer_reset(cv::videostab::OnePassStabilizer* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:152
	Result<cv::Mat*> cv_videostab_OnePassStabilizer_nextFrame(cv::videostab::OnePassStabilizer* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	 Result<cv::videostab::DensePyrLkOptFlowEstimatorGpu*> cv_PyrLkOptFlowEstimatorBase_to_DensePyrLkOptFlowEstimatorGpu(cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		try {
			return Ok(dynamic_cast<cv::videostab::DensePyrLkOptFlowEstimatorGpu*>(instance));
		} OCVRS_CATCH(Result<cv::videostab::DensePyrLkOptFlowEstimatorGpu*>)
	}
	
	 Result<cv::videostab::SparsePyrLkOptFlowEstimator*> cv_PyrLkOptFlowEstimatorBase_to_SparsePyrLkOptFlowEstimator(cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		try {
			return Ok(dynamic_cast<cv::videostab::SparsePyrLkOptFlowEstimator*>(instance));
		} OCVRS_CATCH(Result<cv::videostab::SparsePyrLkOptFlowEstimator*>)
	}
	
	 Result<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*> cv_PyrLkOptFlowEstimatorBase_to_SparsePyrLkOptFlowEstimatorGpu(cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		try {
			return Ok(dynamic_cast<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*>(instance));
		} OCVRS_CATCH(Result<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*>)
	}
	
	void cv_PyrLkOptFlowEstimatorBase_delete(cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		delete instance;
	}
	// PyrLkOptFlowEstimatorBase() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:82
	Result<cv::videostab::PyrLkOptFlowEstimatorBase*> cv_videostab_PyrLkOptFlowEstimatorBase_PyrLkOptFlowEstimatorBase() {
		try {
			cv::videostab::PyrLkOptFlowEstimatorBase* ret = new cv::videostab::PyrLkOptFlowEstimatorBase();
			return Ok<cv::videostab::PyrLkOptFlowEstimatorBase*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::PyrLkOptFlowEstimatorBase*>))
	}
	
	// setWinSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:84
	Result_void cv_videostab_PyrLkOptFlowEstimatorBase_setWinSize_Size(cv::videostab::PyrLkOptFlowEstimatorBase* instance, cv::Size* val) {
		try {
			instance->setWinSize(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// winSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:85
	Result<cv::Size> cv_videostab_PyrLkOptFlowEstimatorBase_winSize_const(const cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		try {
			cv::Size ret = instance->winSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setMaxLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:87
	Result_void cv_videostab_PyrLkOptFlowEstimatorBase_setMaxLevel_int(cv::videostab::PyrLkOptFlowEstimatorBase* instance, int val) {
		try {
			instance->setMaxLevel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// maxLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:88
	Result<int> cv_videostab_PyrLkOptFlowEstimatorBase_maxLevel_const(const cv::videostab::PyrLkOptFlowEstimatorBase* instance) {
		try {
			int ret = instance->maxLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:75
	int cv_videostab_RansacParams_getPropSize_const(const cv::videostab::RansacParams* instance) {
		int ret = instance->size;
		return (int)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:75
	void cv_videostab_RansacParams_setPropSize_int(cv::videostab::RansacParams* instance, int val) {
		instance->size = val;
	}
	
	// thresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:76
	float cv_videostab_RansacParams_getPropThresh_const(const cv::videostab::RansacParams* instance) {
		float ret = instance->thresh;
		return (float)ret;
	}
	
	// thresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:76
	void cv_videostab_RansacParams_setPropThresh_float(cv::videostab::RansacParams* instance, float val) {
		instance->thresh = val;
	}
	
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:77
	float cv_videostab_RansacParams_getPropEps_const(const cv::videostab::RansacParams* instance) {
		float ret = instance->eps;
		return (float)ret;
	}
	
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:77
	void cv_videostab_RansacParams_setPropEps_float(cv::videostab::RansacParams* instance, float val) {
		instance->eps = val;
	}
	
	// prob /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:78
	float cv_videostab_RansacParams_getPropProb_const(const cv::videostab::RansacParams* instance) {
		float ret = instance->prob;
		return (float)ret;
	}
	
	// prob /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:78
	void cv_videostab_RansacParams_setPropProb_float(cv::videostab::RansacParams* instance, float val) {
		instance->prob = val;
	}
	
	void cv_RansacParams_delete(cv::videostab::RansacParams* instance) {
		delete instance;
	}
	// RansacParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:80
	Result<cv::videostab::RansacParams*> cv_videostab_RansacParams_RansacParams() {
		try {
			cv::videostab::RansacParams* ret = new cv::videostab::RansacParams();
			return Ok<cv::videostab::RansacParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::RansacParams*>))
	}
	
	// RansacParams(int, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:87
	Result<cv::videostab::RansacParams*> cv_videostab_RansacParams_RansacParams_int_float_float_float(int size, float thresh, float eps, float prob) {
		try {
			cv::videostab::RansacParams* ret = new cv::videostab::RansacParams(size, thresh, eps, prob);
			return Ok<cv::videostab::RansacParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::RansacParams*>))
	}
	
	// niters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:92
	Result<int> cv_videostab_RansacParams_niters_const(const cv::videostab::RansacParams* instance) {
		try {
			int ret = instance->niters();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// default2dMotion(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/motion_core.hpp:102
	Result<cv::videostab::RansacParams*> cv_videostab_RansacParams_default2dMotion_MotionModel(cv::videostab::MotionModel model) {
		try {
			cv::videostab::RansacParams ret = cv::videostab::RansacParams::default2dMotion(model);
			return Ok(new cv::videostab::RansacParams(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::RansacParams*>))
	}
	
	cv::videostab::PyrLkOptFlowEstimatorBase* cv_SparsePyrLkOptFlowEstimator_to_PyrLkOptFlowEstimatorBase(cv::videostab::SparsePyrLkOptFlowEstimator* instance) {
		return dynamic_cast<cv::videostab::PyrLkOptFlowEstimatorBase*>(instance);
	}
	
	void cv_SparsePyrLkOptFlowEstimator_delete(cv::videostab::SparsePyrLkOptFlowEstimator* instance) {
		delete instance;
	}
	// run(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:100
	Result_void cv_videostab_SparsePyrLkOptFlowEstimator_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::videostab::SparsePyrLkOptFlowEstimator* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_InputArray* points0, const cv::_InputOutputArray* points1, const cv::_OutputArray* status, const cv::_OutputArray* errors) {
		try {
			instance->run(*frame0, *frame1, *points0, *points1, *status, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::videostab::PyrLkOptFlowEstimatorBase* cv_SparsePyrLkOptFlowEstimatorGpu_to_PyrLkOptFlowEstimatorBase(cv::videostab::SparsePyrLkOptFlowEstimatorGpu* instance) {
		return dynamic_cast<cv::videostab::PyrLkOptFlowEstimatorBase*>(instance);
	}
	
	void cv_SparsePyrLkOptFlowEstimatorGpu_delete(cv::videostab::SparsePyrLkOptFlowEstimatorGpu* instance) {
		delete instance;
	}
	// SparsePyrLkOptFlowEstimatorGpu() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:111
	Result<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*> cv_videostab_SparsePyrLkOptFlowEstimatorGpu_SparsePyrLkOptFlowEstimatorGpu() {
		try {
			cv::videostab::SparsePyrLkOptFlowEstimatorGpu* ret = new cv::videostab::SparsePyrLkOptFlowEstimatorGpu();
			return Ok<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::SparsePyrLkOptFlowEstimatorGpu*>))
	}
	
	// run(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:113
	Result_void cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::videostab::SparsePyrLkOptFlowEstimatorGpu* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_InputArray* points0, const cv::_InputOutputArray* points1, const cv::_OutputArray* status, const cv::_OutputArray* errors) {
		try {
			instance->run(*frame0, *frame1, *points0, *points1, *status, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const cuda::GpuMat &, const cuda::GpuMat &, const cuda::GpuMat &, cuda::GpuMat &, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:117
	Result_void cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const_GpuMatR_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR_GpuMatR(cv::videostab::SparsePyrLkOptFlowEstimatorGpu* instance, const cv::cuda::GpuMat* frame0, const cv::cuda::GpuMat* frame1, const cv::cuda::GpuMat* points0, cv::cuda::GpuMat* points1, cv::cuda::GpuMat* status, cv::cuda::GpuMat* errors) {
		try {
			instance->run(*frame0, *frame1, *points0, *points1, *status, *errors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const cuda::GpuMat &, const cuda::GpuMat &, const cuda::GpuMat &, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/optical_flow.hpp:120
	Result_void cv_videostab_SparsePyrLkOptFlowEstimatorGpu_run_const_GpuMatR_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR(cv::videostab::SparsePyrLkOptFlowEstimatorGpu* instance, const cv::cuda::GpuMat* frame0, const cv::cuda::GpuMat* frame1, const cv::cuda::GpuMat* points0, cv::cuda::GpuMat* points1, cv::cuda::GpuMat* status) {
		try {
			instance->run(*frame0, *frame1, *points0, *points1, *status);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLog(Ptr<cv::videostab::ILog>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:71
	Result_void cv_videostab_StabilizerBase_setLog_Ptr_ILog_(cv::videostab::StabilizerBase* instance, cv::Ptr<cv::videostab::ILog>* ilog) {
		try {
			instance->setLog(*ilog);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// log() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:72
	Result<cv::Ptr<cv::videostab::ILog>*> cv_videostab_StabilizerBase_log_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::ILog> ret = instance->log();
			return Ok(new cv::Ptr<cv::videostab::ILog>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::ILog>*>))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:74
	Result_void cv_videostab_StabilizerBase_setRadius_int(cv::videostab::StabilizerBase* instance, int val) {
		try {
			instance->setRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:75
	Result<int> cv_videostab_StabilizerBase_radius_const(const cv::videostab::StabilizerBase* instance) {
		try {
			int ret = instance->radius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFrameSource(Ptr<cv::videostab::IFrameSource>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:77
	Result_void cv_videostab_StabilizerBase_setFrameSource_Ptr_IFrameSource_(cv::videostab::StabilizerBase* instance, cv::Ptr<cv::videostab::IFrameSource>* val) {
		try {
			instance->setFrameSource(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// frameSource() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:78
	Result<cv::Ptr<cv::videostab::IFrameSource>*> cv_videostab_StabilizerBase_frameSource_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::IFrameSource> ret = instance->frameSource();
			return Ok(new cv::Ptr<cv::videostab::IFrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IFrameSource>*>))
	}
	
	// setMaskSource(const Ptr<cv::videostab::IFrameSource> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:80
	Result_void cv_videostab_StabilizerBase_setMaskSource_const_Ptr_IFrameSource_R(cv::videostab::StabilizerBase* instance, const cv::Ptr<cv::videostab::IFrameSource>* val) {
		try {
			instance->setMaskSource(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// maskSource() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:81
	Result<cv::Ptr<cv::videostab::IFrameSource>*> cv_videostab_StabilizerBase_maskSource_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::IFrameSource> ret = instance->maskSource();
			return Ok(new cv::Ptr<cv::videostab::IFrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IFrameSource>*>))
	}
	
	// setMotionEstimator(Ptr<cv::videostab::ImageMotionEstimatorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:83
	Result_void cv_videostab_StabilizerBase_setMotionEstimator_Ptr_ImageMotionEstimatorBase_(cv::videostab::StabilizerBase* instance, cv::Ptr<cv::videostab::ImageMotionEstimatorBase>* val) {
		try {
			instance->setMotionEstimator(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionEstimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:84
	Result<cv::Ptr<cv::videostab::ImageMotionEstimatorBase>*> cv_videostab_StabilizerBase_motionEstimator_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::ImageMotionEstimatorBase> ret = instance->motionEstimator();
			return Ok(new cv::Ptr<cv::videostab::ImageMotionEstimatorBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::ImageMotionEstimatorBase>*>))
	}
	
	// setDeblurer(Ptr<cv::videostab::DeblurerBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:86
	Result_void cv_videostab_StabilizerBase_setDeblurer_Ptr_DeblurerBase_(cv::videostab::StabilizerBase* instance, cv::Ptr<cv::videostab::DeblurerBase>* val) {
		try {
			instance->setDeblurer(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// deblurrer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:87
	Result<cv::Ptr<cv::videostab::DeblurerBase>*> cv_videostab_StabilizerBase_deblurrer_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::DeblurerBase> ret = instance->deblurrer();
			return Ok(new cv::Ptr<cv::videostab::DeblurerBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::DeblurerBase>*>))
	}
	
	// setTrimRatio(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:89
	Result_void cv_videostab_StabilizerBase_setTrimRatio_float(cv::videostab::StabilizerBase* instance, float val) {
		try {
			instance->setTrimRatio(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// trimRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:90
	Result<float> cv_videostab_StabilizerBase_trimRatio_const(const cv::videostab::StabilizerBase* instance) {
		try {
			float ret = instance->trimRatio();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setCorrectionForInclusion(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:92
	Result_void cv_videostab_StabilizerBase_setCorrectionForInclusion_bool(cv::videostab::StabilizerBase* instance, bool val) {
		try {
			instance->setCorrectionForInclusion(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// doCorrectionForInclusion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:93
	Result<bool> cv_videostab_StabilizerBase_doCorrectionForInclusion_const(const cv::videostab::StabilizerBase* instance) {
		try {
			bool ret = instance->doCorrectionForInclusion();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setBorderMode(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:95
	Result_void cv_videostab_StabilizerBase_setBorderMode_int(cv::videostab::StabilizerBase* instance, int val) {
		try {
			instance->setBorderMode(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// borderMode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:96
	Result<int> cv_videostab_StabilizerBase_borderMode_const(const cv::videostab::StabilizerBase* instance) {
		try {
			int ret = instance->borderMode();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setInpainter(Ptr<cv::videostab::InpainterBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:98
	Result_void cv_videostab_StabilizerBase_setInpainter_Ptr_InpainterBase_(cv::videostab::StabilizerBase* instance, cv::Ptr<cv::videostab::InpainterBase>* val) {
		try {
			instance->setInpainter(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inpainter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:99
	Result<cv::Ptr<cv::videostab::InpainterBase>*> cv_videostab_StabilizerBase_inpainter_const(const cv::videostab::StabilizerBase* instance) {
		try {
			cv::Ptr<cv::videostab::InpainterBase> ret = instance->inpainter();
			return Ok(new cv::Ptr<cv::videostab::InpainterBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::InpainterBase>*>))
	}
	
	void cv_ToFileMotionWriter_delete(cv::videostab::ToFileMotionWriter* instance) {
		delete instance;
	}
	// ToFileMotionWriter(const cv::String &, Ptr<cv::videostab::ImageMotionEstimatorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:212
	Result<cv::videostab::ToFileMotionWriter*> cv_videostab_ToFileMotionWriter_ToFileMotionWriter_const_StringR_Ptr_ImageMotionEstimatorBase_(const char* path, cv::Ptr<cv::videostab::ImageMotionEstimatorBase>* estimator) {
		try {
			cv::videostab::ToFileMotionWriter* ret = new cv::videostab::ToFileMotionWriter(std::string(path), *estimator);
			return Ok<cv::videostab::ToFileMotionWriter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::ToFileMotionWriter*>))
	}
	
	// setMotionModel(cv::videostab::MotionModel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:214
	Result_void cv_videostab_ToFileMotionWriter_setMotionModel_MotionModel(cv::videostab::ToFileMotionWriter* instance, cv::videostab::MotionModel val) {
		try {
			instance->setMotionModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:215
	Result<cv::videostab::MotionModel> cv_videostab_ToFileMotionWriter_motionModel_const(const cv::videostab::ToFileMotionWriter* instance) {
		try {
			cv::videostab::MotionModel ret = instance->motionModel();
			return Ok<cv::videostab::MotionModel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::MotionModel>))
	}
	
	// setFrameMask(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:217
	Result_void cv_videostab_ToFileMotionWriter_setFrameMask_const__InputArrayR(cv::videostab::ToFileMotionWriter* instance, const cv::_InputArray* mask) {
		try {
			instance->setFrameMask(*mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimate(const cv::Mat &, const cv::Mat &, bool *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/global_motion.hpp:219
	Result<cv::Mat*> cv_videostab_ToFileMotionWriter_estimate_const_MatR_const_MatR_boolX(cv::videostab::ToFileMotionWriter* instance, const cv::Mat* frame0, const cv::Mat* frame1, bool* ok) {
		try {
			cv::Mat ret = instance->estimate(*frame0, *frame1, ok);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_TranslationBasedLocalOutlierRejector_delete(cv::videostab::TranslationBasedLocalOutlierRejector* instance) {
		delete instance;
	}
	// TranslationBasedLocalOutlierRejector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:77
	Result<cv::videostab::TranslationBasedLocalOutlierRejector*> cv_videostab_TranslationBasedLocalOutlierRejector_TranslationBasedLocalOutlierRejector() {
		try {
			cv::videostab::TranslationBasedLocalOutlierRejector* ret = new cv::videostab::TranslationBasedLocalOutlierRejector();
			return Ok<cv::videostab::TranslationBasedLocalOutlierRejector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::TranslationBasedLocalOutlierRejector*>))
	}
	
	// setCellSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:79
	Result_void cv_videostab_TranslationBasedLocalOutlierRejector_setCellSize_Size(cv::videostab::TranslationBasedLocalOutlierRejector* instance, cv::Size* val) {
		try {
			instance->setCellSize(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cellSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:80
	Result<cv::Size> cv_videostab_TranslationBasedLocalOutlierRejector_cellSize_const(const cv::videostab::TranslationBasedLocalOutlierRejector* instance) {
		try {
			cv::Size ret = instance->cellSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setRansacParams(cv::videostab::RansacParams) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:82
	Result_void cv_videostab_TranslationBasedLocalOutlierRejector_setRansacParams_RansacParams(cv::videostab::TranslationBasedLocalOutlierRejector* instance, cv::videostab::RansacParams* val) {
		try {
			instance->setRansacParams(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ransacParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:83
	Result<cv::videostab::RansacParams*> cv_videostab_TranslationBasedLocalOutlierRejector_ransacParams_const(const cv::videostab::TranslationBasedLocalOutlierRejector* instance) {
		try {
			cv::videostab::RansacParams ret = instance->ransacParams();
			return Ok(new cv::videostab::RansacParams(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::RansacParams*>))
	}
	
	// process(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/outlier_rejection.hpp:85
	Result_void cv_videostab_TranslationBasedLocalOutlierRejector_process_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::videostab::TranslationBasedLocalOutlierRejector* instance, cv::Size* frameSize, const cv::_InputArray* points0, const cv::_InputArray* points1, const cv::_OutputArray* mask) {
		try {
			instance->process(*frameSize, *points0, *points1, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_TwoPassStabilizer_delete(cv::videostab::TwoPassStabilizer* instance) {
		delete instance;
	}
	// TwoPassStabilizer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:166
	Result<cv::videostab::TwoPassStabilizer*> cv_videostab_TwoPassStabilizer_TwoPassStabilizer() {
		try {
			cv::videostab::TwoPassStabilizer* ret = new cv::videostab::TwoPassStabilizer();
			return Ok<cv::videostab::TwoPassStabilizer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::TwoPassStabilizer*>))
	}
	
	// setMotionStabilizer(Ptr<cv::videostab::IMotionStabilizer>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:168
	Result_void cv_videostab_TwoPassStabilizer_setMotionStabilizer_Ptr_IMotionStabilizer_(cv::videostab::TwoPassStabilizer* instance, cv::Ptr<cv::videostab::IMotionStabilizer>* val) {
		try {
			instance->setMotionStabilizer(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionStabilizer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:169
	Result<cv::Ptr<cv::videostab::IMotionStabilizer>*> cv_videostab_TwoPassStabilizer_motionStabilizer_const(const cv::videostab::TwoPassStabilizer* instance) {
		try {
			cv::Ptr<cv::videostab::IMotionStabilizer> ret = instance->motionStabilizer();
			return Ok(new cv::Ptr<cv::videostab::IMotionStabilizer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::IMotionStabilizer>*>))
	}
	
	// setWobbleSuppressor(Ptr<cv::videostab::WobbleSuppressorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:171
	Result_void cv_videostab_TwoPassStabilizer_setWobbleSuppressor_Ptr_WobbleSuppressorBase_(cv::videostab::TwoPassStabilizer* instance, cv::Ptr<cv::videostab::WobbleSuppressorBase>* val) {
		try {
			instance->setWobbleSuppressor(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// wobbleSuppressor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:172
	Result<cv::Ptr<cv::videostab::WobbleSuppressorBase>*> cv_videostab_TwoPassStabilizer_wobbleSuppressor_const(const cv::videostab::TwoPassStabilizer* instance) {
		try {
			cv::Ptr<cv::videostab::WobbleSuppressorBase> ret = instance->wobbleSuppressor();
			return Ok(new cv::Ptr<cv::videostab::WobbleSuppressorBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::WobbleSuppressorBase>*>))
	}
	
	// setEstimateTrimRatio(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:174
	Result_void cv_videostab_TwoPassStabilizer_setEstimateTrimRatio_bool(cv::videostab::TwoPassStabilizer* instance, bool val) {
		try {
			instance->setEstimateTrimRatio(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mustEstimateTrimaRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:175
	Result<bool> cv_videostab_TwoPassStabilizer_mustEstimateTrimaRatio_const(const cv::videostab::TwoPassStabilizer* instance) {
		try {
			bool ret = instance->mustEstimateTrimaRatio();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:177
	Result_void cv_videostab_TwoPassStabilizer_reset(cv::videostab::TwoPassStabilizer* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/stabilizer.hpp:178
	Result<cv::Mat*> cv_videostab_TwoPassStabilizer_nextFrame(cv::videostab::TwoPassStabilizer* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_VideoFileSource_delete(cv::videostab::VideoFileSource* instance) {
		delete instance;
	}
	// VideoFileSource(const cv::String &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:75
	Result<cv::videostab::VideoFileSource*> cv_videostab_VideoFileSource_VideoFileSource_const_StringR_bool(const char* path, bool volatileFrame) {
		try {
			cv::videostab::VideoFileSource* ret = new cv::videostab::VideoFileSource(std::string(path), volatileFrame);
			return Ok<cv::videostab::VideoFileSource*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::VideoFileSource*>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:77
	Result_void cv_videostab_VideoFileSource_reset(cv::videostab::VideoFileSource* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:78
	Result<cv::Mat*> cv_videostab_VideoFileSource_nextFrame(cv::videostab::VideoFileSource* instance) {
		try {
			cv::Mat ret = instance->nextFrame();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// width() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:80
	Result<int> cv_videostab_VideoFileSource_width(cv::videostab::VideoFileSource* instance) {
		try {
			int ret = instance->width();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// height() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:81
	Result<int> cv_videostab_VideoFileSource_height(cv::videostab::VideoFileSource* instance) {
		try {
			int ret = instance->height();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// count() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:82
	Result<int> cv_videostab_VideoFileSource_count(cv::videostab::VideoFileSource* instance) {
		try {
			int ret = instance->count();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// fps() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/frame_source.hpp:83
	Result<double> cv_videostab_VideoFileSource_fps(cv::videostab::VideoFileSource* instance) {
		try {
			double ret = instance->fps();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	void cv_WeightingDeblurer_delete(cv::videostab::WeightingDeblurer* instance) {
		delete instance;
	}
	// WeightingDeblurer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:99
	Result<cv::videostab::WeightingDeblurer*> cv_videostab_WeightingDeblurer_WeightingDeblurer() {
		try {
			cv::videostab::WeightingDeblurer* ret = new cv::videostab::WeightingDeblurer();
			return Ok<cv::videostab::WeightingDeblurer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::videostab::WeightingDeblurer*>))
	}
	
	// setSensitivity(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:101
	Result_void cv_videostab_WeightingDeblurer_setSensitivity_float(cv::videostab::WeightingDeblurer* instance, float val) {
		try {
			instance->setSensitivity(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sensitivity() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:102
	Result<float> cv_videostab_WeightingDeblurer_sensitivity_const(const cv::videostab::WeightingDeblurer* instance) {
		try {
			float ret = instance->sensitivity();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// deblur(int, cv::Mat &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/deblurring.hpp:104
	Result_void cv_videostab_WeightingDeblurer_deblur_int_MatR_const_RangeR(cv::videostab::WeightingDeblurer* instance, int idx, cv::Mat* frame, const cv::Range* range) {
		try {
			instance->deblur(idx, *frame, *range);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMotionEstimator(Ptr<cv::videostab::ImageMotionEstimatorBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:67
	Result_void cv_videostab_WobbleSuppressorBase_setMotionEstimator_Ptr_ImageMotionEstimatorBase_(cv::videostab::WobbleSuppressorBase* instance, cv::Ptr<cv::videostab::ImageMotionEstimatorBase>* val) {
		try {
			instance->setMotionEstimator(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionEstimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:68
	Result<cv::Ptr<cv::videostab::ImageMotionEstimatorBase>*> cv_videostab_WobbleSuppressorBase_motionEstimator_const(const cv::videostab::WobbleSuppressorBase* instance) {
		try {
			cv::Ptr<cv::videostab::ImageMotionEstimatorBase> ret = instance->motionEstimator();
			return Ok(new cv::Ptr<cv::videostab::ImageMotionEstimatorBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::videostab::ImageMotionEstimatorBase>*>))
	}
	
	// suppress(int, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:70
	Result_void cv_videostab_WobbleSuppressorBase_suppress_int_const_MatR_MatR(cv::videostab::WobbleSuppressorBase* instance, int idx, const cv::Mat* frame, cv::Mat* result) {
		try {
			instance->suppress(idx, *frame, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFrameCount(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:75
	Result_void cv_videostab_WobbleSuppressorBase_setFrameCount_int(cv::videostab::WobbleSuppressorBase* instance, int val) {
		try {
			instance->setFrameCount(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// frameCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:76
	Result<int> cv_videostab_WobbleSuppressorBase_frameCount_const(const cv::videostab::WobbleSuppressorBase* instance) {
		try {
			int ret = instance->frameCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:78
	Result_void cv_videostab_WobbleSuppressorBase_setMotions_const_vector_Mat_R(cv::videostab::WobbleSuppressorBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:79
	Result<const std::vector<cv::Mat>*> cv_videostab_WobbleSuppressorBase_motions_const(const cv::videostab::WobbleSuppressorBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->motions();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setMotions2(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:81
	Result_void cv_videostab_WobbleSuppressorBase_setMotions2_const_vector_Mat_R(cv::videostab::WobbleSuppressorBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setMotions2(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motions2() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:82
	Result<const std::vector<cv::Mat>*> cv_videostab_WobbleSuppressorBase_motions2_const(const cv::videostab::WobbleSuppressorBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->motions2();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// setStabilizationMotions(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:84
	Result_void cv_videostab_WobbleSuppressorBase_setStabilizationMotions_const_vector_Mat_R(cv::videostab::WobbleSuppressorBase* instance, const std::vector<cv::Mat>* val) {
		try {
			instance->setStabilizationMotions(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stabilizationMotions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/videostab/wobble_suppression.hpp:85
	Result<const std::vector<cv::Mat>*> cv_videostab_WobbleSuppressorBase_stabilizationMotions_const(const cv::videostab::WobbleSuppressorBase* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->stabilizationMotions();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
}
