#include "ocvrs_common.hpp"
#include <opencv2/video.hpp>
#include "video_types.hpp"

extern "C" {
	// CamShift(cv::InputArray, cv::Rect &, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:79
	Result<cv::RotatedRect*> cv_CamShift_const__InputArrayR_RectR_TermCriteria(const cv::_InputArray* probImage, cv::Rect* window, cv::TermCriteria* criteria) {
		try {
			cv::RotatedRect ret = cv::CamShift(*probImage, *window, *criteria);
			return Ok(new cv::RotatedRect(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// buildOpticalFlowPyramid(cv::InputArray, cv::OutputArrayOfArrays, cv::Size, int, bool, int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:121
	Result<int> cv_buildOpticalFlowPyramid_const__InputArrayR_const__OutputArrayR_Size_int_bool_int_int_bool(const cv::_InputArray* img, const cv::_OutputArray* pyramid, cv::Size* winSize, int maxLevel, bool withDerivatives, int pyrBorder, int derivBorder, bool tryReuseInputImage) {
		try {
			int ret = cv::buildOpticalFlowPyramid(*img, *pyramid, *winSize, maxLevel, withDerivatives, pyrBorder, derivBorder, tryReuseInputImage);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// calcOpticalFlowFarneback(cv::InputArray, cv::InputArray, cv::InputOutputArray, double, int, int, int, int, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:223
	Result_void cv_calcOpticalFlowFarneback_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_double_int_int_int_int_double_int(const cv::_InputArray* prev, const cv::_InputArray* next, const cv::_InputOutputArray* flow, double pyr_scale, int levels, int winsize, int iterations, int poly_n, double poly_sigma, int flags) {
		try {
			cv::calcOpticalFlowFarneback(*prev, *next, *flow, pyr_scale, levels, winsize, iterations, poly_n, poly_sigma, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowPyrLK(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, cv::Size, int, cv::TermCriteria, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:178
	Result_void cv_calcOpticalFlowPyrLK_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_Size_int_TermCriteria_int_double(const cv::_InputArray* prevImg, const cv::_InputArray* nextImg, const cv::_InputArray* prevPts, const cv::_InputOutputArray* nextPts, const cv::_OutputArray* status, const cv::_OutputArray* err, cv::Size* winSize, int maxLevel, cv::TermCriteria* criteria, int flags, double minEigThreshold) {
		try {
			cv::calcOpticalFlowPyrLK(*prevImg, *nextImg, *prevPts, *nextPts, *status, *err, *winSize, maxLevel, *criteria, flags, minEigThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeECC(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:279
	Result<double> cv_computeECC_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* templateImage, const cv::_InputArray* inputImage, const cv::_InputArray* inputMask) {
		try {
			double ret = cv::computeECC(*templateImage, *inputImage, *inputMask);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// createBackgroundSubtractorKNN(int, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:310
	Result<cv::Ptr<cv::BackgroundSubtractorKNN>*> cv_createBackgroundSubtractorKNN_int_double_bool(int history, double dist2Threshold, bool detectShadows) {
		try {
			cv::Ptr<cv::BackgroundSubtractorKNN> ret = cv::createBackgroundSubtractorKNN(history, dist2Threshold, detectShadows);
			return Ok(new cv::Ptr<cv::BackgroundSubtractorKNN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BackgroundSubtractorKNN>*>))
	}
	
	// createBackgroundSubtractorMOG2(int, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:221
	Result<cv::Ptr<cv::BackgroundSubtractorMOG2>*> cv_createBackgroundSubtractorMOG2_int_double_bool(int history, double varThreshold, bool detectShadows) {
		try {
			cv::Ptr<cv::BackgroundSubtractorMOG2> ret = cv::createBackgroundSubtractorMOG2(history, varThreshold, detectShadows);
			return Ok(new cv::Ptr<cv::BackgroundSubtractorMOG2>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BackgroundSubtractorMOG2>*>))
	}
	
	// estimateRigidTransform(cv::InputArray, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:258
	Result<cv::Mat*> cv_estimateRigidTransform_const__InputArrayR_const__InputArrayR_bool(const cv::_InputArray* src, const cv::_InputArray* dst, bool fullAffine) {
		try {
			cv::Mat ret = cv::estimateRigidTransform(*src, *dst, fullAffine);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// findTransformECC(cv::InputArray, cv::InputArray, cv::InputOutputArray, int, cv::TermCriteria, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:343
	Result<double> cv_findTransformECC_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_int_TermCriteria_const__InputArrayR(const cv::_InputArray* templateImage, const cv::_InputArray* inputImage, const cv::_InputOutputArray* warpMatrix, int motionType, cv::TermCriteria* criteria, const cv::_InputArray* inputMask) {
		try {
			double ret = cv::findTransformECC(*templateImage, *inputImage, *warpMatrix, motionType, *criteria, *inputMask);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// findTransformECC(cv::InputArray, cv::InputArray, cv::InputOutputArray, int, cv::TermCriteria, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:336
	Result<double> cv_findTransformECC_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_int_TermCriteria_const__InputArrayR_int(const cv::_InputArray* templateImage, const cv::_InputArray* inputImage, const cv::_InputOutputArray* warpMatrix, int motionType, cv::TermCriteria* criteria, const cv::_InputArray* inputMask, int gaussFiltSize) {
		try {
			double ret = cv::findTransformECC(*templateImage, *inputImage, *warpMatrix, motionType, *criteria, *inputMask, gaussFiltSize);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// meanShift(cv::InputArray, cv::Rect &, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:104
	Result<int> cv_meanShift_const__InputArrayR_RectR_TermCriteria(const cv::_InputArray* probImage, cv::Rect* window, cv::TermCriteria* criteria) {
		try {
			int ret = cv::meanShift(*probImage, *window, *criteria);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// readOpticalFlow(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:421
	Result<cv::Mat*> cv_readOpticalFlow_const_StringR(const char* path) {
		try {
			cv::Mat ret = cv::readOpticalFlow(std::string(path));
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// writeOpticalFlow(const cv::String &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:431
	Result<bool> cv_writeOpticalFlow_const_StringR_const__InputArrayR(const char* path, const cv::_InputArray* flow) {
		try {
			bool ret = cv::writeOpticalFlow(std::string(path), *flow);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// apply(cv::InputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:72
	Result_void cv_BackgroundSubtractor_apply_const__InputArrayR_const__OutputArrayR_double(cv::BackgroundSubtractor* instance, const cv::_InputArray* image, const cv::_OutputArray* fgmask, double learningRate) {
		try {
			instance->apply(*image, *fgmask, learningRate);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundImage(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:81
	Result_void cv_BackgroundSubtractor_getBackgroundImage_const_const__OutputArrayR(const cv::BackgroundSubtractor* instance, const cv::_OutputArray* backgroundImage) {
		try {
			instance->getBackgroundImage(*backgroundImage);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHistory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:234
	Result<int> cv_BackgroundSubtractorKNN_getHistory_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			int ret = instance->getHistory();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setHistory(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:237
	Result_void cv_BackgroundSubtractorKNN_setHistory_int(cv::BackgroundSubtractorKNN* instance, int history) {
		try {
			instance->setHistory(history);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:241
	Result<int> cv_BackgroundSubtractorKNN_getNSamples_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			int ret = instance->getNSamples();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNSamples(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:246
	Result_void cv_BackgroundSubtractorKNN_setNSamples_int(cv::BackgroundSubtractorKNN* instance, int _nN) {
		try {
			instance->setNSamples(_nN);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDist2Threshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:253
	Result<double> cv_BackgroundSubtractorKNN_getDist2Threshold_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			double ret = instance->getDist2Threshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setDist2Threshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:256
	Result_void cv_BackgroundSubtractorKNN_setDist2Threshold_double(cv::BackgroundSubtractorKNN* instance, double _dist2Threshold) {
		try {
			instance->setDist2Threshold(_dist2Threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getkNNSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:263
	Result<int> cv_BackgroundSubtractorKNN_getkNNSamples_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			int ret = instance->getkNNSamples();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setkNNSamples(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:266
	Result_void cv_BackgroundSubtractorKNN_setkNNSamples_int(cv::BackgroundSubtractorKNN* instance, int _nkNN) {
		try {
			instance->setkNNSamples(_nkNN);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDetectShadows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:273
	Result<bool> cv_BackgroundSubtractorKNN_getDetectShadows_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			bool ret = instance->getDetectShadows();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setDetectShadows(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:276
	Result_void cv_BackgroundSubtractorKNN_setDetectShadows_bool(cv::BackgroundSubtractorKNN* instance, bool detectShadows) {
		try {
			instance->setDetectShadows(detectShadows);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getShadowValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:283
	Result<int> cv_BackgroundSubtractorKNN_getShadowValue_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			int ret = instance->getShadowValue();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setShadowValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:286
	Result_void cv_BackgroundSubtractorKNN_setShadowValue_int(cv::BackgroundSubtractorKNN* instance, int value) {
		try {
			instance->setShadowValue(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getShadowThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:295
	Result<double> cv_BackgroundSubtractorKNN_getShadowThreshold_const(const cv::BackgroundSubtractorKNN* instance) {
		try {
			double ret = instance->getShadowThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setShadowThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:298
	Result_void cv_BackgroundSubtractorKNN_setShadowThreshold_double(cv::BackgroundSubtractorKNN* instance, double threshold) {
		try {
			instance->setShadowThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHistory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:95
	Result<int> cv_BackgroundSubtractorMOG2_getHistory_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			int ret = instance->getHistory();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setHistory(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:98
	Result_void cv_BackgroundSubtractorMOG2_setHistory_int(cv::BackgroundSubtractorMOG2* instance, int history) {
		try {
			instance->setHistory(history);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNMixtures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:102
	Result<int> cv_BackgroundSubtractorMOG2_getNMixtures_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			int ret = instance->getNMixtures();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNMixtures(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:107
	Result_void cv_BackgroundSubtractorMOG2_setNMixtures_int(cv::BackgroundSubtractorMOG2* instance, int nmixtures) {
		try {
			instance->setNMixtures(nmixtures);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:115
	Result<double> cv_BackgroundSubtractorMOG2_getBackgroundRatio_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getBackgroundRatio();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBackgroundRatio(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:118
	Result_void cv_BackgroundSubtractorMOG2_setBackgroundRatio_double(cv::BackgroundSubtractorMOG2* instance, double ratio) {
		try {
			instance->setBackgroundRatio(ratio);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:125
	Result<double> cv_BackgroundSubtractorMOG2_getVarThreshold_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getVarThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setVarThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:128
	Result_void cv_BackgroundSubtractorMOG2_setVarThreshold_double(cv::BackgroundSubtractorMOG2* instance, double varThreshold) {
		try {
			instance->setVarThreshold(varThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarThresholdGen() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:138
	Result<double> cv_BackgroundSubtractorMOG2_getVarThresholdGen_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getVarThresholdGen();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setVarThresholdGen(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:141
	Result_void cv_BackgroundSubtractorMOG2_setVarThresholdGen_double(cv::BackgroundSubtractorMOG2* instance, double varThresholdGen) {
		try {
			instance->setVarThresholdGen(varThresholdGen);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarInit() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:145
	Result<double> cv_BackgroundSubtractorMOG2_getVarInit_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getVarInit();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setVarInit(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:148
	Result_void cv_BackgroundSubtractorMOG2_setVarInit_double(cv::BackgroundSubtractorMOG2* instance, double varInit) {
		try {
			instance->setVarInit(varInit);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarMin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:150
	Result<double> cv_BackgroundSubtractorMOG2_getVarMin_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getVarMin();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setVarMin(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:151
	Result_void cv_BackgroundSubtractorMOG2_setVarMin_double(cv::BackgroundSubtractorMOG2* instance, double varMin) {
		try {
			instance->setVarMin(varMin);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarMax() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:153
	Result<double> cv_BackgroundSubtractorMOG2_getVarMax_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getVarMax();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setVarMax(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:154
	Result_void cv_BackgroundSubtractorMOG2_setVarMax_double(cv::BackgroundSubtractorMOG2* instance, double varMax) {
		try {
			instance->setVarMax(varMax);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getComplexityReductionThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:162
	Result<double> cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getComplexityReductionThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setComplexityReductionThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:165
	Result_void cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold_double(cv::BackgroundSubtractorMOG2* instance, double ct) {
		try {
			instance->setComplexityReductionThreshold(ct);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDetectShadows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:172
	Result<bool> cv_BackgroundSubtractorMOG2_getDetectShadows_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			bool ret = instance->getDetectShadows();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setDetectShadows(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:175
	Result_void cv_BackgroundSubtractorMOG2_setDetectShadows_bool(cv::BackgroundSubtractorMOG2* instance, bool detectShadows) {
		try {
			instance->setDetectShadows(detectShadows);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getShadowValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:182
	Result<int> cv_BackgroundSubtractorMOG2_getShadowValue_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			int ret = instance->getShadowValue();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setShadowValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:185
	Result_void cv_BackgroundSubtractorMOG2_setShadowValue_int(cv::BackgroundSubtractorMOG2* instance, int value) {
		try {
			instance->setShadowValue(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getShadowThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:194
	Result<double> cv_BackgroundSubtractorMOG2_getShadowThreshold_const(const cv::BackgroundSubtractorMOG2* instance) {
		try {
			double ret = instance->getShadowThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setShadowThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:197
	Result_void cv_BackgroundSubtractorMOG2_setShadowThreshold_double(cv::BackgroundSubtractorMOG2* instance, double threshold) {
		try {
			instance->setShadowThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// apply(cv::InputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/background_segm.hpp:208
	Result_void cv_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__OutputArrayR_double(cv::BackgroundSubtractorMOG2* instance, const cv::_InputArray* image, const cv::_OutputArray* fgmask, double learningRate) {
		try {
			instance->apply(*image, *fgmask, learningRate);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFinestScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:597
	Result<int> cv_DISOpticalFlow_getFinestScale_const(const cv::DISOpticalFlow* instance) {
		try {
			int ret = instance->getFinestScale();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFinestScale(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:599
	Result_void cv_DISOpticalFlow_setFinestScale_int(cv::DISOpticalFlow* instance, int val) {
		try {
			instance->setFinestScale(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPatchSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:604
	Result<int> cv_DISOpticalFlow_getPatchSize_const(const cv::DISOpticalFlow* instance) {
		try {
			int ret = instance->getPatchSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPatchSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:606
	Result_void cv_DISOpticalFlow_setPatchSize_int(cv::DISOpticalFlow* instance, int val) {
		try {
			instance->setPatchSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPatchStride() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:611
	Result<int> cv_DISOpticalFlow_getPatchStride_const(const cv::DISOpticalFlow* instance) {
		try {
			int ret = instance->getPatchStride();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPatchStride(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:613
	Result_void cv_DISOpticalFlow_setPatchStride_int(cv::DISOpticalFlow* instance, int val) {
		try {
			instance->setPatchStride(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGradientDescentIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:618
	Result<int> cv_DISOpticalFlow_getGradientDescentIterations_const(const cv::DISOpticalFlow* instance) {
		try {
			int ret = instance->getGradientDescentIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setGradientDescentIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:620
	Result_void cv_DISOpticalFlow_setGradientDescentIterations_int(cv::DISOpticalFlow* instance, int val) {
		try {
			instance->setGradientDescentIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVariationalRefinementIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:626
	Result<int> cv_DISOpticalFlow_getVariationalRefinementIterations_const(const cv::DISOpticalFlow* instance) {
		try {
			int ret = instance->getVariationalRefinementIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setVariationalRefinementIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:628
	Result_void cv_DISOpticalFlow_setVariationalRefinementIterations_int(cv::DISOpticalFlow* instance, int val) {
		try {
			instance->setVariationalRefinementIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVariationalRefinementAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:632
	Result<float> cv_DISOpticalFlow_getVariationalRefinementAlpha_const(const cv::DISOpticalFlow* instance) {
		try {
			float ret = instance->getVariationalRefinementAlpha();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setVariationalRefinementAlpha(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:634
	Result_void cv_DISOpticalFlow_setVariationalRefinementAlpha_float(cv::DISOpticalFlow* instance, float val) {
		try {
			instance->setVariationalRefinementAlpha(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVariationalRefinementDelta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:638
	Result<float> cv_DISOpticalFlow_getVariationalRefinementDelta_const(const cv::DISOpticalFlow* instance) {
		try {
			float ret = instance->getVariationalRefinementDelta();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setVariationalRefinementDelta(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:640
	Result_void cv_DISOpticalFlow_setVariationalRefinementDelta_float(cv::DISOpticalFlow* instance, float val) {
		try {
			instance->setVariationalRefinementDelta(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVariationalRefinementGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:644
	Result<float> cv_DISOpticalFlow_getVariationalRefinementGamma_const(const cv::DISOpticalFlow* instance) {
		try {
			float ret = instance->getVariationalRefinementGamma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setVariationalRefinementGamma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:646
	Result_void cv_DISOpticalFlow_setVariationalRefinementGamma_float(cv::DISOpticalFlow* instance, float val) {
		try {
			instance->setVariationalRefinementGamma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseMeanNormalization() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:654
	Result<bool> cv_DISOpticalFlow_getUseMeanNormalization_const(const cv::DISOpticalFlow* instance) {
		try {
			bool ret = instance->getUseMeanNormalization();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseMeanNormalization(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:656
	Result_void cv_DISOpticalFlow_setUseMeanNormalization_bool(cv::DISOpticalFlow* instance, bool val) {
		try {
			instance->setUseMeanNormalization(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseSpatialPropagation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:663
	Result<bool> cv_DISOpticalFlow_getUseSpatialPropagation_const(const cv::DISOpticalFlow* instance) {
		try {
			bool ret = instance->getUseSpatialPropagation();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseSpatialPropagation(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:665
	Result_void cv_DISOpticalFlow_setUseSpatialPropagation_bool(cv::DISOpticalFlow* instance, bool val) {
		try {
			instance->setUseSpatialPropagation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:671
	Result<cv::Ptr<cv::DISOpticalFlow>*> cv_DISOpticalFlow_create_int(int preset) {
		try {
			cv::Ptr<cv::DISOpticalFlow> ret = cv::DISOpticalFlow::create(preset);
			return Ok(new cv::Ptr<cv::DISOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DISOpticalFlow>*>))
	}
	
	// calc(cv::InputArray, cv::InputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:445
	Result_void cv_DenseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(cv::DenseOpticalFlow* instance, const cv::_InputArray* I0, const cv::_InputArray* I1, const cv::_InputOutputArray* flow) {
		try {
			instance->calc(*I0, *I1, *flow);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:448
	Result_void cv_DenseOpticalFlow_collectGarbage(cv::DenseOpticalFlow* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:478
	Result<int> cv_FarnebackOpticalFlow_getNumLevels_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getNumLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:479
	Result_void cv_FarnebackOpticalFlow_setNumLevels_int(cv::FarnebackOpticalFlow* instance, int numLevels) {
		try {
			instance->setNumLevels(numLevels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPyrScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:481
	Result<double> cv_FarnebackOpticalFlow_getPyrScale_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			double ret = instance->getPyrScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setPyrScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:482
	Result_void cv_FarnebackOpticalFlow_setPyrScale_double(cv::FarnebackOpticalFlow* instance, double pyrScale) {
		try {
			instance->setPyrScale(pyrScale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFastPyramids() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:484
	Result<bool> cv_FarnebackOpticalFlow_getFastPyramids_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			bool ret = instance->getFastPyramids();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setFastPyramids(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:485
	Result_void cv_FarnebackOpticalFlow_setFastPyramids_bool(cv::FarnebackOpticalFlow* instance, bool fastPyramids) {
		try {
			instance->setFastPyramids(fastPyramids);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:487
	Result<int> cv_FarnebackOpticalFlow_getWinSize_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getWinSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWinSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:488
	Result_void cv_FarnebackOpticalFlow_setWinSize_int(cv::FarnebackOpticalFlow* instance, int winSize) {
		try {
			instance->setWinSize(winSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumIters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:490
	Result<int> cv_FarnebackOpticalFlow_getNumIters_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getNumIters();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumIters(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:491
	Result_void cv_FarnebackOpticalFlow_setNumIters_int(cv::FarnebackOpticalFlow* instance, int numIters) {
		try {
			instance->setNumIters(numIters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPolyN() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:493
	Result<int> cv_FarnebackOpticalFlow_getPolyN_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getPolyN();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPolyN(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:494
	Result_void cv_FarnebackOpticalFlow_setPolyN_int(cv::FarnebackOpticalFlow* instance, int polyN) {
		try {
			instance->setPolyN(polyN);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPolySigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:496
	Result<double> cv_FarnebackOpticalFlow_getPolySigma_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			double ret = instance->getPolySigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setPolySigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:497
	Result_void cv_FarnebackOpticalFlow_setPolySigma_double(cv::FarnebackOpticalFlow* instance, double polySigma) {
		try {
			instance->setPolySigma(polySigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:499
	Result<int> cv_FarnebackOpticalFlow_getFlags_const(const cv::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getFlags();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFlags(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:500
	Result_void cv_FarnebackOpticalFlow_setFlags_int(cv::FarnebackOpticalFlow* instance, int flags) {
		try {
			instance->setFlags(flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, double, bool, int, int, int, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:502
	Result<cv::Ptr<cv::FarnebackOpticalFlow>*> cv_FarnebackOpticalFlow_create_int_double_bool_int_int_int_double_int(int numLevels, double pyrScale, bool fastPyramids, int winSize, int numIters, int polyN, double polySigma, int flags) {
		try {
			cv::Ptr<cv::FarnebackOpticalFlow> ret = cv::FarnebackOpticalFlow::create(numLevels, pyrScale, fastPyramids, winSize, numIters, polyN, polySigma, flags);
			return Ok(new cv::Ptr<cv::FarnebackOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::FarnebackOpticalFlow>*>))
	}
	
	// statePre /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:393
	cv::Mat* cv_KalmanFilter_getPropStatePre_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->statePre;
		return new cv::Mat(ret);
	}
	
	// statePre /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:393
	void cv_KalmanFilter_setPropStatePre_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->statePre = *val;
	}
	
	// statePost /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:394
	cv::Mat* cv_KalmanFilter_getPropStatePost_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->statePost;
		return new cv::Mat(ret);
	}
	
	// statePost /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:394
	void cv_KalmanFilter_setPropStatePost_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->statePost = *val;
	}
	
	// transitionMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:395
	cv::Mat* cv_KalmanFilter_getPropTransitionMatrix_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->transitionMatrix;
		return new cv::Mat(ret);
	}
	
	// transitionMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:395
	void cv_KalmanFilter_setPropTransitionMatrix_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->transitionMatrix = *val;
	}
	
	// controlMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:396
	cv::Mat* cv_KalmanFilter_getPropControlMatrix_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->controlMatrix;
		return new cv::Mat(ret);
	}
	
	// controlMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:396
	void cv_KalmanFilter_setPropControlMatrix_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->controlMatrix = *val;
	}
	
	// measurementMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:397
	cv::Mat* cv_KalmanFilter_getPropMeasurementMatrix_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->measurementMatrix;
		return new cv::Mat(ret);
	}
	
	// measurementMatrix /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:397
	void cv_KalmanFilter_setPropMeasurementMatrix_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->measurementMatrix = *val;
	}
	
	// processNoiseCov /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:398
	cv::Mat* cv_KalmanFilter_getPropProcessNoiseCov_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->processNoiseCov;
		return new cv::Mat(ret);
	}
	
	// processNoiseCov /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:398
	void cv_KalmanFilter_setPropProcessNoiseCov_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->processNoiseCov = *val;
	}
	
	// measurementNoiseCov /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:399
	cv::Mat* cv_KalmanFilter_getPropMeasurementNoiseCov_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->measurementNoiseCov;
		return new cv::Mat(ret);
	}
	
	// measurementNoiseCov /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:399
	void cv_KalmanFilter_setPropMeasurementNoiseCov_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->measurementNoiseCov = *val;
	}
	
	// errorCovPre /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:400
	cv::Mat* cv_KalmanFilter_getPropErrorCovPre_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->errorCovPre;
		return new cv::Mat(ret);
	}
	
	// errorCovPre /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:400
	void cv_KalmanFilter_setPropErrorCovPre_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->errorCovPre = *val;
	}
	
	// gain /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:401
	cv::Mat* cv_KalmanFilter_getPropGain_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->gain;
		return new cv::Mat(ret);
	}
	
	// gain /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:401
	void cv_KalmanFilter_setPropGain_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->gain = *val;
	}
	
	// errorCovPost /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:402
	cv::Mat* cv_KalmanFilter_getPropErrorCovPost_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->errorCovPost;
		return new cv::Mat(ret);
	}
	
	// errorCovPost /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:402
	void cv_KalmanFilter_setPropErrorCovPost_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->errorCovPost = *val;
	}
	
	// temp1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:405
	cv::Mat* cv_KalmanFilter_getPropTemp1_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->temp1;
		return new cv::Mat(ret);
	}
	
	// temp1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:405
	void cv_KalmanFilter_setPropTemp1_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->temp1 = *val;
	}
	
	// temp2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:406
	cv::Mat* cv_KalmanFilter_getPropTemp2_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->temp2;
		return new cv::Mat(ret);
	}
	
	// temp2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:406
	void cv_KalmanFilter_setPropTemp2_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->temp2 = *val;
	}
	
	// temp3 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:407
	cv::Mat* cv_KalmanFilter_getPropTemp3_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->temp3;
		return new cv::Mat(ret);
	}
	
	// temp3 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:407
	void cv_KalmanFilter_setPropTemp3_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->temp3 = *val;
	}
	
	// temp4 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:408
	cv::Mat* cv_KalmanFilter_getPropTemp4_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->temp4;
		return new cv::Mat(ret);
	}
	
	// temp4 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:408
	void cv_KalmanFilter_setPropTemp4_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->temp4 = *val;
	}
	
	// temp5 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:409
	cv::Mat* cv_KalmanFilter_getPropTemp5_const(const cv::KalmanFilter* instance) {
		cv::Mat ret = instance->temp5;
		return new cv::Mat(ret);
	}
	
	// temp5 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:409
	void cv_KalmanFilter_setPropTemp5_Mat(cv::KalmanFilter* instance, cv::Mat* val) {
		instance->temp5 = *val;
	}
	
	void cv_KalmanFilter_delete(cv::KalmanFilter* instance) {
		delete instance;
	}
	// KalmanFilter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:363
	Result<cv::KalmanFilter*> cv_KalmanFilter_KalmanFilter() {
		try {
			cv::KalmanFilter* ret = new cv::KalmanFilter();
			return Ok<cv::KalmanFilter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KalmanFilter*>))
	}
	
	// KalmanFilter(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:370
	Result<cv::KalmanFilter*> cv_KalmanFilter_KalmanFilter_int_int_int_int(int dynamParams, int measureParams, int controlParams, int type) {
		try {
			cv::KalmanFilter* ret = new cv::KalmanFilter(dynamParams, measureParams, controlParams, type);
			return Ok<cv::KalmanFilter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KalmanFilter*>))
	}
	
	// init(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:379
	Result_void cv_KalmanFilter_init_int_int_int_int(cv::KalmanFilter* instance, int dynamParams, int measureParams, int controlParams, int type) {
		try {
			instance->init(dynamParams, measureParams, controlParams, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:385
	Result<const cv::Mat*> cv_KalmanFilter_predict_const_MatR(cv::KalmanFilter* instance, const cv::Mat* control) {
		try {
			const cv::Mat ret = instance->predict(*control);
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// correct(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:391
	Result<const cv::Mat*> cv_KalmanFilter_correct_const_MatR(cv::KalmanFilter* instance, const cv::Mat* measurement) {
		try {
			const cv::Mat ret = instance->correct(*measurement);
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// calc(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:466
	Result_void cv_SparseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::SparseOpticalFlow* instance, const cv::_InputArray* prevImg, const cv::_InputArray* nextImg, const cv::_InputArray* prevPts, const cv::_InputOutputArray* nextPts, const cv::_OutputArray* status, const cv::_OutputArray* err) {
		try {
			instance->calc(*prevImg, *nextImg, *prevPts, *nextPts, *status, *err);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:685
	Result<cv::Size> cv_SparsePyrLKOpticalFlow_getWinSize_const(const cv::SparsePyrLKOpticalFlow* instance) {
		try {
			cv::Size ret = instance->getWinSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setWinSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:686
	Result_void cv_SparsePyrLKOpticalFlow_setWinSize_Size(cv::SparsePyrLKOpticalFlow* instance, cv::Size* winSize) {
		try {
			instance->setWinSize(*winSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:688
	Result<int> cv_SparsePyrLKOpticalFlow_getMaxLevel_const(const cv::SparsePyrLKOpticalFlow* instance) {
		try {
			int ret = instance->getMaxLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:689
	Result_void cv_SparsePyrLKOpticalFlow_setMaxLevel_int(cv::SparsePyrLKOpticalFlow* instance, int maxLevel) {
		try {
			instance->setMaxLevel(maxLevel);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:691
	Result<cv::TermCriteria> cv_SparsePyrLKOpticalFlow_getTermCriteria_const(const cv::SparsePyrLKOpticalFlow* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:692
	Result_void cv_SparsePyrLKOpticalFlow_setTermCriteria_TermCriteriaR(cv::SparsePyrLKOpticalFlow* instance, cv::TermCriteria* crit) {
		try {
			instance->setTermCriteria(*crit);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:694
	Result<int> cv_SparsePyrLKOpticalFlow_getFlags_const(const cv::SparsePyrLKOpticalFlow* instance) {
		try {
			int ret = instance->getFlags();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFlags(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:695
	Result_void cv_SparsePyrLKOpticalFlow_setFlags_int(cv::SparsePyrLKOpticalFlow* instance, int flags) {
		try {
			instance->setFlags(flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinEigThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:697
	Result<double> cv_SparsePyrLKOpticalFlow_getMinEigThreshold_const(const cv::SparsePyrLKOpticalFlow* instance) {
		try {
			double ret = instance->getMinEigThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinEigThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:698
	Result_void cv_SparsePyrLKOpticalFlow_setMinEigThreshold_double(cv::SparsePyrLKOpticalFlow* instance, double minEigThreshold) {
		try {
			instance->setMinEigThreshold(minEigThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int, cv::TermCriteria, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:700
	Result<cv::Ptr<cv::SparsePyrLKOpticalFlow>*> cv_SparsePyrLKOpticalFlow_create_Size_int_TermCriteria_int_double(cv::Size* winSize, int maxLevel, cv::TermCriteria* crit, int flags, double minEigThreshold) {
		try {
			cv::Ptr<cv::SparsePyrLKOpticalFlow> ret = cv::SparsePyrLKOpticalFlow::create(*winSize, maxLevel, *crit, flags, minEigThreshold);
			return Ok(new cv::Ptr<cv::SparsePyrLKOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::SparsePyrLKOpticalFlow>*>))
	}
	
	// init(cv::InputArray, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:725
	Result_void cv_Tracker_init_const__InputArrayR_const_RectR(cv::Tracker* instance, const cv::_InputArray* image, const cv::Rect* boundingBox) {
		try {
			instance->init(*image, *boundingBox);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// update(cv::InputArray, cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:737
	Result<bool> cv_Tracker_update_const__InputArrayR_RectR(cv::Tracker* instance, const cv::_InputArray* image, cv::Rect* boundingBox) {
		try {
			bool ret = instance->update(*image, *boundingBox);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(const TrackerDaSiamRPN::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:842
	Result<cv::Ptr<cv::TrackerDaSiamRPN>*> cv_TrackerDaSiamRPN_create_const_ParamsR(const cv::TrackerDaSiamRPN::Params* parameters) {
		try {
			cv::Ptr<cv::TrackerDaSiamRPN> ret = cv::TrackerDaSiamRPN::create(*parameters);
			return Ok(new cv::Ptr<cv::TrackerDaSiamRPN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::TrackerDaSiamRPN>*>))
	}
	
	// getTrackingScore() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:846
	Result<float> cv_TrackerDaSiamRPN_getTrackingScore(cv::TrackerDaSiamRPN* instance) {
		try {
			float ret = instance->getTrackingScore();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:831
	void* cv_TrackerDaSiamRPN_Params_getPropModel_const(const cv::TrackerDaSiamRPN::Params* instance) {
		std::string ret = instance->model;
		return ocvrs_create_string(ret.c_str());
	}
	
	// model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:831
	void cv_TrackerDaSiamRPN_Params_setPropModel_string(cv::TrackerDaSiamRPN::Params* instance, char* val) {
		instance->model = std::string(val);
	}
	
	// kernel_cls1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:832
	void* cv_TrackerDaSiamRPN_Params_getPropKernel_cls1_const(const cv::TrackerDaSiamRPN::Params* instance) {
		std::string ret = instance->kernel_cls1;
		return ocvrs_create_string(ret.c_str());
	}
	
	// kernel_cls1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:832
	void cv_TrackerDaSiamRPN_Params_setPropKernel_cls1_string(cv::TrackerDaSiamRPN::Params* instance, char* val) {
		instance->kernel_cls1 = std::string(val);
	}
	
	// kernel_r1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:833
	void* cv_TrackerDaSiamRPN_Params_getPropKernel_r1_const(const cv::TrackerDaSiamRPN::Params* instance) {
		std::string ret = instance->kernel_r1;
		return ocvrs_create_string(ret.c_str());
	}
	
	// kernel_r1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:833
	void cv_TrackerDaSiamRPN_Params_setPropKernel_r1_string(cv::TrackerDaSiamRPN::Params* instance, char* val) {
		instance->kernel_r1 = std::string(val);
	}
	
	// backend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:834
	int cv_TrackerDaSiamRPN_Params_getPropBackend_const(const cv::TrackerDaSiamRPN::Params* instance) {
		int ret = instance->backend;
		return (int)ret;
	}
	
	// backend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:834
	void cv_TrackerDaSiamRPN_Params_setPropBackend_int(cv::TrackerDaSiamRPN::Params* instance, int val) {
		instance->backend = val;
	}
	
	// target /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:835
	int cv_TrackerDaSiamRPN_Params_getPropTarget_const(const cv::TrackerDaSiamRPN::Params* instance) {
		int ret = instance->target;
		return (int)ret;
	}
	
	// target /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:835
	void cv_TrackerDaSiamRPN_Params_setPropTarget_int(cv::TrackerDaSiamRPN::Params* instance, int val) {
		instance->target = val;
	}
	
	void cv_TrackerDaSiamRPN_Params_delete(cv::TrackerDaSiamRPN::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:830
	Result<cv::TrackerDaSiamRPN::Params*> cv_TrackerDaSiamRPN_Params_Params() {
		try {
			cv::TrackerDaSiamRPN::Params* ret = new cv::TrackerDaSiamRPN::Params();
			return Ok<cv::TrackerDaSiamRPN::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TrackerDaSiamRPN::Params*>))
	}
	
	// create(const TrackerGOTURN::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:815
	Result<cv::Ptr<cv::TrackerGOTURN>*> cv_TrackerGOTURN_create_const_ParamsR(const cv::TrackerGOTURN::Params* parameters) {
		try {
			cv::Ptr<cv::TrackerGOTURN> ret = cv::TrackerGOTURN::create(*parameters);
			return Ok(new cv::Ptr<cv::TrackerGOTURN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::TrackerGOTURN>*>))
	}
	
	// modelTxt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:807
	void* cv_TrackerGOTURN_Params_getPropModelTxt_const(const cv::TrackerGOTURN::Params* instance) {
		std::string ret = instance->modelTxt;
		return ocvrs_create_string(ret.c_str());
	}
	
	// modelTxt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:807
	void cv_TrackerGOTURN_Params_setPropModelTxt_string(cv::TrackerGOTURN::Params* instance, char* val) {
		instance->modelTxt = std::string(val);
	}
	
	// modelBin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:808
	void* cv_TrackerGOTURN_Params_getPropModelBin_const(const cv::TrackerGOTURN::Params* instance) {
		std::string ret = instance->modelBin;
		return ocvrs_create_string(ret.c_str());
	}
	
	// modelBin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:808
	void cv_TrackerGOTURN_Params_setPropModelBin_string(cv::TrackerGOTURN::Params* instance, char* val) {
		instance->modelBin = std::string(val);
	}
	
	void cv_TrackerGOTURN_Params_delete(cv::TrackerGOTURN::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:806
	Result<cv::TrackerGOTURN::Params*> cv_TrackerGOTURN_Params_Params() {
		try {
			cv::TrackerGOTURN::Params* ret = new cv::TrackerGOTURN::Params();
			return Ok<cv::TrackerGOTURN::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TrackerGOTURN::Params*>))
	}
	
	// create(const TrackerMIL::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:774
	Result<cv::Ptr<cv::TrackerMIL>*> cv_TrackerMIL_create_const_ParamsR(const cv::TrackerMIL::Params* parameters) {
		try {
			cv::Ptr<cv::TrackerMIL> ret = cv::TrackerMIL::create(*parameters);
			return Ok(new cv::Ptr<cv::TrackerMIL>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::TrackerMIL>*>))
	}
	
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:759
	Result<cv::TrackerMIL::Params> cv_TrackerMIL_Params_Params() {
		try {
			cv::TrackerMIL::Params ret;
			return Ok<cv::TrackerMIL::Params>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TrackerMIL::Params>))
	}
	
	// calcUV(cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:528
	Result_void cv_VariationalRefinement_calcUV_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(cv::VariationalRefinement* instance, const cv::_InputArray* I0, const cv::_InputArray* I1, const cv::_InputOutputArray* flow_u, const cv::_InputOutputArray* flow_v) {
		try {
			instance->calcUV(*I0, *I1, *flow_u, *flow_v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFixedPointIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:532
	Result<int> cv_VariationalRefinement_getFixedPointIterations_const(const cv::VariationalRefinement* instance) {
		try {
			int ret = instance->getFixedPointIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFixedPointIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:534
	Result_void cv_VariationalRefinement_setFixedPointIterations_int(cv::VariationalRefinement* instance, int val) {
		try {
			instance->setFixedPointIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSorIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:539
	Result<int> cv_VariationalRefinement_getSorIterations_const(const cv::VariationalRefinement* instance) {
		try {
			int ret = instance->getSorIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSorIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:541
	Result_void cv_VariationalRefinement_setSorIterations_int(cv::VariationalRefinement* instance, int val) {
		try {
			instance->setSorIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOmega() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:545
	Result<float> cv_VariationalRefinement_getOmega_const(const cv::VariationalRefinement* instance) {
		try {
			float ret = instance->getOmega();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setOmega(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:547
	Result_void cv_VariationalRefinement_setOmega_float(cv::VariationalRefinement* instance, float val) {
		try {
			instance->setOmega(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:551
	Result<float> cv_VariationalRefinement_getAlpha_const(const cv::VariationalRefinement* instance) {
		try {
			float ret = instance->getAlpha();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setAlpha(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:553
	Result_void cv_VariationalRefinement_setAlpha_float(cv::VariationalRefinement* instance, float val) {
		try {
			instance->setAlpha(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDelta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:557
	Result<float> cv_VariationalRefinement_getDelta_const(const cv::VariationalRefinement* instance) {
		try {
			float ret = instance->getDelta();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setDelta(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:559
	Result_void cv_VariationalRefinement_setDelta_float(cv::VariationalRefinement* instance, float val) {
		try {
			instance->setDelta(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:563
	Result<float> cv_VariationalRefinement_getGamma_const(const cv::VariationalRefinement* instance) {
		try {
			float ret = instance->getGamma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setGamma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:565
	Result_void cv_VariationalRefinement_setGamma_float(cv::VariationalRefinement* instance, float val) {
		try {
			instance->setGamma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/video/tracking.hpp:569
	Result<cv::Ptr<cv::VariationalRefinement>*> cv_VariationalRefinement_create() {
		try {
			cv::Ptr<cv::VariationalRefinement> ret = cv::VariationalRefinement::create();
			return Ok(new cv::Ptr<cv::VariationalRefinement>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::VariationalRefinement>*>))
	}
	
}
