#include "ocvrs_common.hpp"
#include <opencv2/text.hpp>
#include "text_types.hpp"

extern "C" {
	// MSERsToERStats(cv::InputArray, std::vector<std::vector<Point>> &, std::vector<std::vector<ERStat>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:347
	Result_void cv_text_MSERsToERStats_const__InputArrayR_vector_vector_Point__R_vector_vector_ERStat__R(const cv::_InputArray* image, std::vector<std::vector<cv::Point>>* contours, std::vector<std::vector<cv::text::ERStat>>* regions) {
		try {
			cv::text::MSERsToERStats(*image, *contours, *regions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeNMChannels(cv::InputArray, cv::OutputArrayOfArrays, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:262
	Result_void cv_text_computeNMChannels_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* _src, const cv::_OutputArray* _channels, int _mode) {
		try {
			cv::text::computeNMChannels(*_src, *_channels, _mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createERFilterNM1(const Ptr<ERFilter::Callback> &, int, float, float, float, bool, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:187
	Result<cv::Ptr<cv::text::ERFilter>*> cv_text_createERFilterNM1_const_Ptr_Callback_R_int_float_float_float_bool_float(const cv::Ptr<cv::text::ERFilter::Callback>* cb, int thresholdDelta, float minArea, float maxArea, float minProbability, bool nonMaxSuppression, float minProbabilityDiff) {
		try {
			cv::Ptr<cv::text::ERFilter> ret = cv::text::createERFilterNM1(*cb, thresholdDelta, minArea, maxArea, minProbability, nonMaxSuppression, minProbabilityDiff);
			return Ok(new cv::Ptr<cv::text::ERFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter>*>))
	}
	
	// createERFilterNM1(const cv::String &, int, float, float, float, bool, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:212
	Result<cv::Ptr<cv::text::ERFilter>*> cv_text_createERFilterNM1_const_StringR_int_float_float_float_bool_float(const char* filename, int thresholdDelta, float minArea, float maxArea, float minProbability, bool nonMaxSuppression, float minProbabilityDiff) {
		try {
			cv::Ptr<cv::text::ERFilter> ret = cv::text::createERFilterNM1(std::string(filename), thresholdDelta, minArea, maxArea, minProbability, nonMaxSuppression, minProbabilityDiff);
			return Ok(new cv::Ptr<cv::text::ERFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter>*>))
	}
	
	// createERFilterNM2(const Ptr<ERFilter::Callback> &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:204
	Result<cv::Ptr<cv::text::ERFilter>*> cv_text_createERFilterNM2_const_Ptr_Callback_R_float(const cv::Ptr<cv::text::ERFilter::Callback>* cb, float minProbability) {
		try {
			cv::Ptr<cv::text::ERFilter> ret = cv::text::createERFilterNM2(*cb, minProbability);
			return Ok(new cv::Ptr<cv::text::ERFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter>*>))
	}
	
	// createERFilterNM2(const cv::String &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:223
	Result<cv::Ptr<cv::text::ERFilter>*> cv_text_createERFilterNM2_const_StringR_float(const char* filename, float minProbability) {
		try {
			cv::Ptr<cv::text::ERFilter> ret = cv::text::createERFilterNM2(std::string(filename), minProbability);
			return Ok(new cv::Ptr<cv::text::ERFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter>*>))
	}
	
	// createOCRHMMTransitionsTable(const cv::String &, std::vector<cv::String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:381
	Result<cv::Mat*> cv_text_createOCRHMMTransitionsTable_const_StringR_vector_String_R(const char* vocabulary, std::vector<cv::String>* lexicon) {
		try {
			cv::Mat ret = cv::text::createOCRHMMTransitionsTable(std::string(vocabulary), *lexicon);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// createOCRHMMTransitionsTable(std::string &, std::vector<std::string> &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:379
	Result_void cv_text_createOCRHMMTransitionsTable_stringR_vector_string_R_const__OutputArrayR(void** vocabulary, std::vector<std::string>* lexicon, const cv::_OutputArray* transition_probabilities_table) {
		try {
			std::string vocabulary_out;
			cv::text::createOCRHMMTransitionsTable(vocabulary_out, *lexicon, *transition_probabilities_table);
			*vocabulary = ocvrs_create_string(vocabulary_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectRegions(cv::InputArray, const Ptr<cv::text::ERFilter> &, const Ptr<cv::text::ERFilter> &, std::vector<Rect> &, int, const cv::String &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:366
	Result_void cv_text_detectRegions_const__InputArrayR_const_Ptr_ERFilter_R_const_Ptr_ERFilter_R_vector_Rect_R_int_const_StringR_float(const cv::_InputArray* image, const cv::Ptr<cv::text::ERFilter>* er_filter1, const cv::Ptr<cv::text::ERFilter>* er_filter2, std::vector<cv::Rect>* groups_rects, int method, const char* filename, float minProbability) {
		try {
			cv::text::detectRegions(*image, *er_filter1, *er_filter2, *groups_rects, method, std::string(filename), minProbability);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectRegions(cv::InputArray, const Ptr<cv::text::ERFilter> &, const Ptr<cv::text::ERFilter> &, std::vector<std::vector<Point>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:351
	Result_void cv_text_detectRegions_const__InputArrayR_const_Ptr_ERFilter_R_const_Ptr_ERFilter_R_vector_vector_Point__R(const cv::_InputArray* image, const cv::Ptr<cv::text::ERFilter>* er_filter1, const cv::Ptr<cv::text::ERFilter>* er_filter2, std::vector<std::vector<cv::Point>>* regions) {
		try {
			cv::text::detectRegions(*image, *er_filter1, *er_filter2, *regions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectTextSWT(cv::InputArray, std::vector<cv::Rect> &, bool, const cv::_OutputArray &, const cv::_OutputArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/swt_text_detection.hpp:20
	Result_void cv_text_detectTextSWT_const__InputArrayR_vector_Rect_R_bool_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* input, std::vector<cv::Rect>* result, bool dark_on_light, const cv::_OutputArray* draw, const cv::_OutputArray* chainBBs) {
		try {
			cv::text::detectTextSWT(*input, *result, dark_on_light, *draw, *chainBBs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erGrouping(cv::InputArray, cv::InputArrayOfArrays, std::vector<std::vector<ERStat>> &, std::vector<std::vector<Vec2i>> &, std::vector<Rect> &, int, const std::string &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:316
	Result_void cv_text_erGrouping_const__InputArrayR_const__InputArrayR_vector_vector_ERStat__R_vector_vector_Vec2i__R_vector_Rect_R_int_const_stringR_float(const cv::_InputArray* img, const cv::_InputArray* channels, std::vector<std::vector<cv::text::ERStat>>* regions, std::vector<std::vector<cv::Vec2i>>* groups, std::vector<cv::Rect>* groups_rects, int method, const char* filename, float minProbablity) {
		try {
			cv::text::erGrouping(*img, *channels, *regions, *groups, *groups_rects, method, std::string(filename), minProbablity);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erGrouping(cv::InputArray, cv::InputArray, std::vector<std::vector<Point>>, std::vector<Rect> &, int, const cv::String &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:324
	Result_void cv_text_erGrouping_const__InputArrayR_const__InputArrayR_vector_vector_Point___vector_Rect_R_int_const_StringR_float(const cv::_InputArray* image, const cv::_InputArray* channel, std::vector<std::vector<cv::Point>>* regions, std::vector<cv::Rect>* groups_rects, int method, const char* filename, float minProbablity) {
		try {
			cv::text::erGrouping(*image, *channel, *regions, *groups_rects, method, std::string(filename), minProbablity);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// loadClassifierNM1(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:232
	Result<cv::Ptr<cv::text::ERFilter::Callback>*> cv_text_loadClassifierNM1_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::text::ERFilter::Callback> ret = cv::text::loadClassifierNM1(std::string(filename));
			return Ok(new cv::Ptr<cv::text::ERFilter::Callback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter::Callback>*>))
	}
	
	// loadClassifierNM2(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:240
	Result<cv::Ptr<cv::text::ERFilter::Callback>*> cv_text_loadClassifierNM2_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::text::ERFilter::Callback> ret = cv::text::loadClassifierNM2(std::string(filename));
			return Ok(new cv::Ptr<cv::text::ERFilter::Callback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::ERFilter::Callback>*>))
	}
	
	// loadOCRBeamSearchClassifierCNN(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:525
	Result<cv::Ptr<cv::text::OCRBeamSearchDecoder::ClassifierCallback>*> cv_text_loadOCRBeamSearchClassifierCNN_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::text::OCRBeamSearchDecoder::ClassifierCallback> ret = cv::text::loadOCRBeamSearchClassifierCNN(std::string(filename));
			return Ok(new cv::Ptr<cv::text::OCRBeamSearchDecoder::ClassifierCallback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRBeamSearchDecoder::ClassifierCallback>*>))
	}
	
	// loadOCRHMMClassifierCNN(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:354
	Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*> cv_text_loadOCRHMMClassifierCNN_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback> ret = cv::text::loadOCRHMMClassifierCNN(std::string(filename));
			return Ok(new cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*>))
	}
	
	// loadOCRHMMClassifierNM(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:341
	Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*> cv_text_loadOCRHMMClassifierNM_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback> ret = cv::text::loadOCRHMMClassifierNM(std::string(filename));
			return Ok(new cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*>))
	}
	
	// loadOCRHMMClassifier(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:363
	Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*> cv_text_loadOCRHMMClassifier_const_StringR_int(const char* filename, int classifier) {
		try {
			cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback> ret = cv::text::loadOCRHMMClassifier(std::string(filename), classifier);
			return Ok(new cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>*>))
	}
	
	// run(cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:96
	Result_void cv_text_BaseOCR_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::BaseOCR* instance, cv::Mat* image, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:99
	Result_void cv_text_BaseOCR_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::BaseOCR* instance, cv::Mat* image, cv::Mat* mask, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, *mask, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, std::vector<ERStat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:151
	Result_void cv_text_ERFilter_run_const__InputArrayR_vector_ERStat_R(cv::text::ERFilter* instance, const cv::_InputArray* image, std::vector<cv::text::ERStat>* regions) {
		try {
			instance->run(*image, *regions);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCallback(const Ptr<ERFilter::Callback> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:155
	Result_void cv_text_ERFilter_setCallback_const_Ptr_Callback_R(cv::text::ERFilter* instance, const cv::Ptr<cv::text::ERFilter::Callback>* cb) {
		try {
			instance->setCallback(*cb);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setThresholdDelta(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:156
	Result_void cv_text_ERFilter_setThresholdDelta_int(cv::text::ERFilter* instance, int thresholdDelta) {
		try {
			instance->setThresholdDelta(thresholdDelta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMinArea(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:157
	Result_void cv_text_ERFilter_setMinArea_float(cv::text::ERFilter* instance, float minArea) {
		try {
			instance->setMinArea(minArea);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxArea(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:158
	Result_void cv_text_ERFilter_setMaxArea_float(cv::text::ERFilter* instance, float maxArea) {
		try {
			instance->setMaxArea(maxArea);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMinProbability(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:159
	Result_void cv_text_ERFilter_setMinProbability_float(cv::text::ERFilter* instance, float minProbability) {
		try {
			instance->setMinProbability(minProbability);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMinProbabilityDiff(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:160
	Result_void cv_text_ERFilter_setMinProbabilityDiff_float(cv::text::ERFilter* instance, float minProbabilityDiff) {
		try {
			instance->setMinProbabilityDiff(minProbabilityDiff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNonMaxSuppression(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:161
	Result_void cv_text_ERFilter_setNonMaxSuppression_bool(cv::text::ERFilter* instance, bool nonMaxSuppression) {
		try {
			instance->setNonMaxSuppression(nonMaxSuppression);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumRejected() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:162
	Result<int> cv_text_ERFilter_getNumRejected_const(const cv::text::ERFilter* instance) {
		try {
			int ret = instance->getNumRejected();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// eval(const cv::text::ERStat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:135
	Result<double> cv_text_ERFilter_Callback_eval_const_ERStatR(cv::text::ERFilter::Callback* instance, const cv::text::ERStat* stat) {
		try {
			double ret = instance->eval(*stat);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// pixel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:75
	int cv_text_ERStat_getPropPixel_const(const cv::text::ERStat* instance) {
		int ret = instance->pixel;
		return (int)ret;
	}
	
	// pixel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:75
	void cv_text_ERStat_setPropPixel_int(cv::text::ERStat* instance, int val) {
		instance->pixel = val;
	}
	
	// level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:76
	int cv_text_ERStat_getPropLevel_const(const cv::text::ERStat* instance) {
		int ret = instance->level;
		return (int)ret;
	}
	
	// level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:76
	void cv_text_ERStat_setPropLevel_int(cv::text::ERStat* instance, int val) {
		instance->level = val;
	}
	
	// area /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:79
	int cv_text_ERStat_getPropArea_const(const cv::text::ERStat* instance) {
		int ret = instance->area;
		return (int)ret;
	}
	
	// area /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:79
	void cv_text_ERStat_setPropArea_int(cv::text::ERStat* instance, int val) {
		instance->area = val;
	}
	
	// perimeter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:80
	int cv_text_ERStat_getPropPerimeter_const(const cv::text::ERStat* instance) {
		int ret = instance->perimeter;
		return (int)ret;
	}
	
	// perimeter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:80
	void cv_text_ERStat_setPropPerimeter_int(cv::text::ERStat* instance, int val) {
		instance->perimeter = val;
	}
	
	// euler /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:81
	int cv_text_ERStat_getPropEuler_const(const cv::text::ERStat* instance) {
		int ret = instance->euler;
		return (int)ret;
	}
	
	// euler /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:81
	void cv_text_ERStat_setPropEuler_int(cv::text::ERStat* instance, int val) {
		instance->euler = val;
	}
	
	// rect /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:82
	cv::Rect cv_text_ERStat_getPropRect_const(const cv::text::ERStat* instance) {
		cv::Rect ret = instance->rect;
		return (cv::Rect)ret;
	}
	
	// rect /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:82
	void cv_text_ERStat_setPropRect_Rect(cv::text::ERStat* instance, cv::Rect* val) {
		instance->rect = *val;
	}
	
	// raw_moments /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:83
	double** cv_text_ERStat_getPropRaw_moments(cv::text::ERStat* instance) {
		double(*ret)[2] = &instance->raw_moments;
		return (double**)ret;
	}
	
	// central_moments /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:84
	double** cv_text_ERStat_getPropCentral_moments(cv::text::ERStat* instance) {
		double(*ret)[3] = &instance->central_moments;
		return (double**)ret;
	}
	
	// med_crossings /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:86
	float cv_text_ERStat_getPropMed_crossings_const(const cv::text::ERStat* instance) {
		float ret = instance->med_crossings;
		return (float)ret;
	}
	
	// med_crossings /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:86
	void cv_text_ERStat_setPropMed_crossings_float(cv::text::ERStat* instance, float val) {
		instance->med_crossings = val;
	}
	
	// hole_area_ratio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:89
	float cv_text_ERStat_getPropHole_area_ratio_const(const cv::text::ERStat* instance) {
		float ret = instance->hole_area_ratio;
		return (float)ret;
	}
	
	// hole_area_ratio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:89
	void cv_text_ERStat_setPropHole_area_ratio_float(cv::text::ERStat* instance, float val) {
		instance->hole_area_ratio = val;
	}
	
	// convex_hull_ratio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:90
	float cv_text_ERStat_getPropConvex_hull_ratio_const(const cv::text::ERStat* instance) {
		float ret = instance->convex_hull_ratio;
		return (float)ret;
	}
	
	// convex_hull_ratio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:90
	void cv_text_ERStat_setPropConvex_hull_ratio_float(cv::text::ERStat* instance, float val) {
		instance->convex_hull_ratio = val;
	}
	
	// num_inflexion_points /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:91
	float cv_text_ERStat_getPropNum_inflexion_points_const(const cv::text::ERStat* instance) {
		float ret = instance->num_inflexion_points;
		return (float)ret;
	}
	
	// num_inflexion_points /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:91
	void cv_text_ERStat_setPropNum_inflexion_points_float(cv::text::ERStat* instance, float val) {
		instance->num_inflexion_points = val;
	}
	
	// probability /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:100
	double cv_text_ERStat_getPropProbability_const(const cv::text::ERStat* instance) {
		double ret = instance->probability;
		return (double)ret;
	}
	
	// probability /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:100
	void cv_text_ERStat_setPropProbability_double(cv::text::ERStat* instance, double val) {
		instance->probability = val;
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:103
	cv::text::ERStat** cv_text_ERStat_getPropParent(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->parent;
		return new cv::text::ERStat*(ret);
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:103
	void cv_text_ERStat_setPropParent_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->parent = val;
	}
	
	// child /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:104
	cv::text::ERStat** cv_text_ERStat_getPropChild(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->child;
		return new cv::text::ERStat*(ret);
	}
	
	// child /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:104
	void cv_text_ERStat_setPropChild_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->child = val;
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:105
	cv::text::ERStat** cv_text_ERStat_getPropNext(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->next;
		return new cv::text::ERStat*(ret);
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:105
	void cv_text_ERStat_setPropNext_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->next = val;
	}
	
	// prev /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:106
	cv::text::ERStat** cv_text_ERStat_getPropPrev(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->prev;
		return new cv::text::ERStat*(ret);
	}
	
	// prev /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:106
	void cv_text_ERStat_setPropPrev_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->prev = val;
	}
	
	// local_maxima /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:109
	bool cv_text_ERStat_getPropLocal_maxima_const(const cv::text::ERStat* instance) {
		bool ret = instance->local_maxima;
		return (bool)ret;
	}
	
	// local_maxima /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:109
	void cv_text_ERStat_setPropLocal_maxima_bool(cv::text::ERStat* instance, bool val) {
		instance->local_maxima = val;
	}
	
	// max_probability_ancestor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:110
	cv::text::ERStat** cv_text_ERStat_getPropMax_probability_ancestor(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->max_probability_ancestor;
		return new cv::text::ERStat*(ret);
	}
	
	// max_probability_ancestor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:110
	void cv_text_ERStat_setPropMax_probability_ancestor_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->max_probability_ancestor = val;
	}
	
	// min_probability_ancestor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:111
	cv::text::ERStat** cv_text_ERStat_getPropMin_probability_ancestor(cv::text::ERStat* instance) {
		cv::text::ERStat* ret = instance->min_probability_ancestor;
		return new cv::text::ERStat*(ret);
	}
	
	// min_probability_ancestor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:111
	void cv_text_ERStat_setPropMin_probability_ancestor_ERStatX(cv::text::ERStat* instance, cv::text::ERStat* val) {
		instance->min_probability_ancestor = val;
	}
	
	void cv_ERStat_delete(cv::text::ERStat* instance) {
		delete instance;
	}
	// ERStat(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/erfilter.hpp:70
	Result<cv::text::ERStat*> cv_text_ERStat_ERStat_int_int_int_int(int level, int pixel, int x, int y) {
		try {
			cv::text::ERStat* ret = new cv::text::ERStat(level, pixel, x, y);
			return Ok<cv::text::ERStat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::text::ERStat*>))
	}
	
	void cv_OCRBeamSearchDecoder_delete(cv::text::OCRBeamSearchDecoder* instance) {
		delete instance;
	}
	// run(cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:446
	Result_void cv_text_OCRBeamSearchDecoder_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRBeamSearchDecoder* instance, cv::Mat* image, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:450
	Result_void cv_text_OCRBeamSearchDecoder_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRBeamSearchDecoder* instance, cv::Mat* image, cv::Mat* mask, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, *mask, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:455
	Result<void*> cv_text_OCRBeamSearchDecoder_run_const__InputArrayR_int_int(cv::text::OCRBeamSearchDecoder* instance, const cv::_InputArray* image, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// run(cv::InputArray, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:457
	Result<void*> cv_text_OCRBeamSearchDecoder_run_const__InputArrayR_const__InputArrayR_int_int(cv::text::OCRBeamSearchDecoder* instance, const cv::_InputArray* image, const cv::_InputArray* mask, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, *mask, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(const Ptr<OCRBeamSearchDecoder::ClassifierCallback>, const std::string &, cv::InputArray, cv::InputArray, text::decoder_mode, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:478
	Result<cv::Ptr<cv::text::OCRBeamSearchDecoder>*> cv_text_OCRBeamSearchDecoder_create_const_Ptr_ClassifierCallback__const_stringR_const__InputArrayR_const__InputArrayR_decoder_mode_int(const cv::Ptr<cv::text::OCRBeamSearchDecoder::ClassifierCallback>* classifier, const char* vocabulary, const cv::_InputArray* transition_probabilities_table, const cv::_InputArray* emission_probabilities_table, cv::text::decoder_mode mode, int beam_size) {
		try {
			cv::Ptr<cv::text::OCRBeamSearchDecoder> ret = cv::text::OCRBeamSearchDecoder::create(*classifier, std::string(vocabulary), *transition_probabilities_table, *emission_probabilities_table, mode, beam_size);
			return Ok(new cv::Ptr<cv::text::OCRBeamSearchDecoder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRBeamSearchDecoder>*>))
	}
	
	// create(const cv::String &, const cv::String &, cv::InputArray, cv::InputArray, text::decoder_mode, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:495
	Result<cv::Ptr<cv::text::OCRBeamSearchDecoder>*> cv_text_OCRBeamSearchDecoder_create_const_StringR_const_StringR_const__InputArrayR_const__InputArrayR_decoder_mode_int(const char* filename, const char* vocabulary, const cv::_InputArray* transition_probabilities_table, const cv::_InputArray* emission_probabilities_table, cv::text::decoder_mode mode, int beam_size) {
		try {
			cv::Ptr<cv::text::OCRBeamSearchDecoder> ret = cv::text::OCRBeamSearchDecoder::create(std::string(filename), std::string(vocabulary), *transition_probabilities_table, *emission_probabilities_table, mode, beam_size);
			return Ok(new cv::Ptr<cv::text::OCRBeamSearchDecoder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRBeamSearchDecoder>*>))
	}
	
	void cv_OCRBeamSearchDecoder_ClassifierCallback_delete(cv::text::OCRBeamSearchDecoder::ClassifierCallback* instance) {
		delete instance;
	}
	// eval(cv::InputArray, std::vector<std::vector<double>> &, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:418
	Result_void cv_text_OCRBeamSearchDecoder_ClassifierCallback_eval_const__InputArrayR_vector_vector_double__R_vector_int_R(cv::text::OCRBeamSearchDecoder::ClassifierCallback* instance, const cv::_InputArray* image, std::vector<std::vector<double>>* recognition_probabilities, std::vector<int>* oversegmentation) {
		try {
			instance->eval(*image, *recognition_probabilities, *oversegmentation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:420
	Result<int> cv_text_OCRBeamSearchDecoder_ClassifierCallback_getWindowSize(cv::text::OCRBeamSearchDecoder::ClassifierCallback* instance) {
		try {
			int ret = instance->getWindowSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getStepSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:421
	Result<int> cv_text_OCRBeamSearchDecoder_ClassifierCallback_getStepSize(cv::text::OCRBeamSearchDecoder::ClassifierCallback* instance) {
		try {
			int ret = instance->getStepSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_OCRHMMDecoder_delete(cv::text::OCRHMMDecoder* instance) {
		delete instance;
	}
	// run(cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:241
	Result_void cv_text_OCRHMMDecoder_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRHMMDecoder* instance, cv::Mat* image, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:268
	Result_void cv_text_OCRHMMDecoder_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRHMMDecoder* instance, cv::Mat* image, cv::Mat* mask, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, *mask, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:273
	Result<void*> cv_text_OCRHMMDecoder_run_const__InputArrayR_int_int(cv::text::OCRHMMDecoder* instance, const cv::_InputArray* image, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// run(cv::InputArray, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:275
	Result<void*> cv_text_OCRHMMDecoder_run_const__InputArrayR_const__InputArrayR_int_int(cv::text::OCRHMMDecoder* instance, const cv::_InputArray* image, const cv::_InputArray* mask, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, *mask, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(const Ptr<OCRHMMDecoder::ClassifierCallback>, const cv::String &, cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:294
	Result<cv::Ptr<cv::text::OCRHMMDecoder>*> cv_text_OCRHMMDecoder_create_const_Ptr_ClassifierCallback__const_StringR_const__InputArrayR_const__InputArrayR_int(const cv::Ptr<cv::text::OCRHMMDecoder::ClassifierCallback>* classifier, const char* vocabulary, const cv::_InputArray* transition_probabilities_table, const cv::_InputArray* emission_probabilities_table, int mode) {
		try {
			cv::Ptr<cv::text::OCRHMMDecoder> ret = cv::text::OCRHMMDecoder::create(*classifier, std::string(vocabulary), *transition_probabilities_table, *emission_probabilities_table, mode);
			return Ok(new cv::Ptr<cv::text::OCRHMMDecoder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHMMDecoder>*>))
	}
	
	// create(const cv::String &, const cv::String &, cv::InputArray, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:307
	Result<cv::Ptr<cv::text::OCRHMMDecoder>*> cv_text_OCRHMMDecoder_create_const_StringR_const_StringR_const__InputArrayR_const__InputArrayR_int_int(const char* filename, const char* vocabulary, const cv::_InputArray* transition_probabilities_table, const cv::_InputArray* emission_probabilities_table, int mode, int classifier) {
		try {
			cv::Ptr<cv::text::OCRHMMDecoder> ret = cv::text::OCRHMMDecoder::create(std::string(filename), std::string(vocabulary), *transition_probabilities_table, *emission_probabilities_table, mode, classifier);
			return Ok(new cv::Ptr<cv::text::OCRHMMDecoder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHMMDecoder>*>))
	}
	
	void cv_OCRHMMDecoder_ClassifierCallback_delete(cv::text::OCRHMMDecoder::ClassifierCallback* instance) {
		delete instance;
	}
	// eval(cv::InputArray, std::vector<int> &, std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:216
	Result_void cv_text_OCRHMMDecoder_ClassifierCallback_eval_const__InputArrayR_vector_int_R_vector_double_R(cv::text::OCRHMMDecoder::ClassifierCallback* instance, const cv::_InputArray* image, std::vector<int>* out_class, std::vector<double>* out_confidence) {
		try {
			instance->eval(*image, *out_class, *out_confidence);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:539
	Result_void cv_text_OCRHolisticWordRecognizer_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRHolisticWordRecognizer* instance, cv::Mat* image, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:569
	Result_void cv_text_OCRHolisticWordRecognizer_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRHolisticWordRecognizer* instance, cv::Mat* image, cv::Mat* mask, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, *mask, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const std::string &, const std::string &, const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:579
	Result<cv::Ptr<cv::text::OCRHolisticWordRecognizer>*> cv_text_OCRHolisticWordRecognizer_create_const_stringR_const_stringR_const_stringR(const char* archFilename, const char* weightsFilename, const char* wordsFilename) {
		try {
			cv::Ptr<cv::text::OCRHolisticWordRecognizer> ret = cv::text::OCRHolisticWordRecognizer::create(std::string(archFilename), std::string(weightsFilename), std::string(wordsFilename));
			return Ok(new cv::Ptr<cv::text::OCRHolisticWordRecognizer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRHolisticWordRecognizer>*>))
	}
	
	// run(cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:135
	Result_void cv_text_OCRTesseract_run_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRTesseract* instance, cv::Mat* image, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::Mat &, cv::Mat &, std::string &, std::vector<Rect> *, std::vector<std::string> *, std::vector<float> *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:139
	Result_void cv_text_OCRTesseract_run_MatR_MatR_stringR_vector_Rect_X_vector_string_X_vector_float_X_int(cv::text::OCRTesseract* instance, cv::Mat* image, cv::Mat* mask, void** output_text, std::vector<cv::Rect>* component_rects, std::vector<std::string>* component_texts, std::vector<float>* component_confidences, int component_level) {
		try {
			std::string output_text_out;
			instance->run(*image, *mask, output_text_out, component_rects, component_texts, component_confidences, component_level);
			*output_text = ocvrs_create_string(output_text_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:144
	Result<void*> cv_text_OCRTesseract_run_const__InputArrayR_int_int(cv::text::OCRTesseract* instance, const cv::_InputArray* image, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// run(cv::InputArray, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:146
	Result<void*> cv_text_OCRTesseract_run_const__InputArrayR_const__InputArrayR_int_int(cv::text::OCRTesseract* instance, const cv::_InputArray* image, const cv::_InputArray* mask, int min_confidence, int component_level) {
		try {
			cv::String ret = instance->run(*image, *mask, min_confidence, component_level);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// setWhiteList(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:148
	Result_void cv_text_OCRTesseract_setWhiteList_const_StringR(cv::text::OCRTesseract* instance, const char* char_whitelist) {
		try {
			instance->setWhiteList(std::string(char_whitelist));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const char *, const char *, const char *, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/ocr.hpp:165
	Result<cv::Ptr<cv::text::OCRTesseract>*> cv_text_OCRTesseract_create_const_charX_const_charX_const_charX_int_int(const char* datapath, const char* language, const char* char_whitelist, int oem, int psmode) {
		try {
			cv::Ptr<cv::text::OCRTesseract> ret = cv::text::OCRTesseract::create(datapath, language, char_whitelist, oem, psmode);
			return Ok(new cv::Ptr<cv::text::OCRTesseract>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::OCRTesseract>*>))
	}
	
	// detect(cv::InputArray, std::vector<Rect> &, std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/textDetector.hpp:30
	Result_void cv_text_TextDetector_detect_const__InputArrayR_vector_Rect_R_vector_float_R(cv::text::TextDetector* instance, const cv::_InputArray* inputImage, std::vector<cv::Rect>* Bbox, std::vector<float>* confidence) {
		try {
			instance->detect(*inputImage, *Bbox, *confidence);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, std::vector<Rect> &, std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/textDetector.hpp:51
	Result_void cv_text_TextDetectorCNN_detect_const__InputArrayR_vector_Rect_R_vector_float_R(cv::text::TextDetectorCNN* instance, const cv::_InputArray* inputImage, std::vector<cv::Rect>* Bbox, std::vector<float>* confidence) {
		try {
			instance->detect(*inputImage, *Bbox, *confidence);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const cv::String &, const cv::String &, std::vector<Size>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/textDetector.hpp:60
	Result<cv::Ptr<cv::text::TextDetectorCNN>*> cv_text_TextDetectorCNN_create_const_StringR_const_StringR_vector_Size_(const char* modelArchFilename, const char* modelWeightsFilename, std::vector<cv::Size>* detectionSizes) {
		try {
			cv::Ptr<cv::text::TextDetectorCNN> ret = cv::text::TextDetectorCNN::create(std::string(modelArchFilename), std::string(modelWeightsFilename), *detectionSizes);
			return Ok(new cv::Ptr<cv::text::TextDetectorCNN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::TextDetectorCNN>*>))
	}
	
	// create(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/text/textDetector.hpp:65
	Result<cv::Ptr<cv::text::TextDetectorCNN>*> cv_text_TextDetectorCNN_create_const_StringR_const_StringR(const char* modelArchFilename, const char* modelWeightsFilename) {
		try {
			cv::Ptr<cv::text::TextDetectorCNN> ret = cv::text::TextDetectorCNN::create(std::string(modelArchFilename), std::string(modelWeightsFilename));
			return Ok(new cv::Ptr<cv::text::TextDetectorCNN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::text::TextDetectorCNN>*>))
	}
	
}
