#include "ocvrs_common.hpp"
#include <opencv2/surface_matching.hpp>
#include "surface_matching_types.hpp"

extern "C" {
	void cv_ICP_delete(cv::ppf_match_3d::ICP* instance) {
		delete instance;
	}
	// ICP() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/icp.hpp:90
	Result<cv::ppf_match_3d::ICP*> cv_ppf_match_3d_ICP_ICP() {
		try {
			cv::ppf_match_3d::ICP* ret = new cv::ppf_match_3d::ICP();
			return Ok<cv::ppf_match_3d::ICP*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::ICP*>))
	}
	
	// ICP(const int, const float, const float, const int, const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/icp.hpp:117
	Result<cv::ppf_match_3d::ICP*> cv_ppf_match_3d_ICP_ICP_const_int_const_float_const_float_const_int_const_int_const_int(const int iterations, const float tolerence, const float rejectionScale, const int numLevels, const int sampleType, const int numMaxCorr) {
		try {
			cv::ppf_match_3d::ICP* ret = new cv::ppf_match_3d::ICP(iterations, tolerence, rejectionScale, numLevels, sampleType, numMaxCorr);
			return Ok<cv::ppf_match_3d::ICP*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::ICP*>))
	}
	
	// registerModelToScene(const cv::Mat &, const cv::Mat &, double &, cv::Matx44d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/icp.hpp:139
	Result<int> cv_ppf_match_3d_ICP_registerModelToScene_const_MatR_const_MatR_doubleR_Matx44dR(cv::ppf_match_3d::ICP* instance, const cv::Mat* srcPC, const cv::Mat* dstPC, double* residual, cv::Matx44d* pose) {
		try {
			int ret = instance->registerModelToScene(*srcPC, *dstPC, *residual, *pose);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// registerModelToScene(const cv::Mat &, const cv::Mat &, std::vector<Pose3DPtr> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/icp.hpp:152
	Result<int> cv_ppf_match_3d_ICP_registerModelToScene_const_MatR_const_MatR_vector_Pose3DPtr_R(cv::ppf_match_3d::ICP* instance, const cv::Mat* srcPC, const cv::Mat* dstPC, std::vector<cv::ppf_match_3d::Pose3DPtr>* poses) {
		try {
			int ret = instance->registerModelToScene(*srcPC, *dstPC, *poses);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_PPF3DDetector_delete(cv::ppf_match_3d::PPF3DDetector* instance) {
		delete instance;
	}
	// PPF3DDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/ppf_match_3d.hpp:104
	Result<cv::ppf_match_3d::PPF3DDetector*> cv_ppf_match_3d_PPF3DDetector_PPF3DDetector() {
		try {
			cv::ppf_match_3d::PPF3DDetector* ret = new cv::ppf_match_3d::PPF3DDetector();
			return Ok<cv::ppf_match_3d::PPF3DDetector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::PPF3DDetector*>))
	}
	
	// PPF3DDetector(const double, const double, const double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/ppf_match_3d.hpp:112
	Result<cv::ppf_match_3d::PPF3DDetector*> cv_ppf_match_3d_PPF3DDetector_PPF3DDetector_const_double_const_double_const_double(const double relativeSamplingStep, const double relativeDistanceStep, const double numAngles) {
		try {
			cv::ppf_match_3d::PPF3DDetector* ret = new cv::ppf_match_3d::PPF3DDetector(relativeSamplingStep, relativeDistanceStep, numAngles);
			return Ok<cv::ppf_match_3d::PPF3DDetector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::PPF3DDetector*>))
	}
	
	// setSearchParams(const double, const double, const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/ppf_match_3d.hpp:122
	Result_void cv_ppf_match_3d_PPF3DDetector_setSearchParams_const_double_const_double_const_bool(cv::ppf_match_3d::PPF3DDetector* instance, const double positionThreshold, const double rotationThreshold, const bool useWeightedClustering) {
		try {
			instance->setSearchParams(positionThreshold, rotationThreshold, useWeightedClustering);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// trainModel(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/ppf_match_3d.hpp:131
	Result_void cv_ppf_match_3d_PPF3DDetector_trainModel_const_MatR(cv::ppf_match_3d::PPF3DDetector* instance, const cv::Mat* Model) {
		try {
			instance->trainModel(*Model);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(const cv::Mat &, std::vector<Pose3DPtr> &, const double, const double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/ppf_match_3d.hpp:141
	Result_void cv_ppf_match_3d_PPF3DDetector_match_const_MatR_vector_Pose3DPtr_R_const_double_const_double(cv::ppf_match_3d::PPF3DDetector* instance, const cv::Mat* scene, std::vector<cv::ppf_match_3d::Pose3DPtr>* results, const double relativeSceneSampleStep, const double relativeSceneDistance) {
		try {
			instance->match(*scene, *results, relativeSceneSampleStep, relativeSceneDistance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:125
	double cv_ppf_match_3d_Pose3D_getPropAlpha_const(const cv::ppf_match_3d::Pose3D* instance) {
		double ret = instance->alpha;
		return (double)ret;
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:125
	void cv_ppf_match_3d_Pose3D_setPropAlpha_double(cv::ppf_match_3d::Pose3D* instance, double val) {
		instance->alpha = val;
	}
	
	// residual /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:125
	double cv_ppf_match_3d_Pose3D_getPropResidual_const(const cv::ppf_match_3d::Pose3D* instance) {
		double ret = instance->residual;
		return (double)ret;
	}
	
	// residual /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:125
	void cv_ppf_match_3d_Pose3D_setPropResidual_double(cv::ppf_match_3d::Pose3D* instance, double val) {
		instance->residual = val;
	}
	
	// modelIndex /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:126
	size_t cv_ppf_match_3d_Pose3D_getPropModelIndex_const(const cv::ppf_match_3d::Pose3D* instance) {
		size_t ret = instance->modelIndex;
		return (size_t)ret;
	}
	
	// modelIndex /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:126
	void cv_ppf_match_3d_Pose3D_setPropModelIndex_size_t(cv::ppf_match_3d::Pose3D* instance, size_t val) {
		instance->modelIndex = val;
	}
	
	// numVotes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:126
	size_t cv_ppf_match_3d_Pose3D_getPropNumVotes_const(const cv::ppf_match_3d::Pose3D* instance) {
		size_t ret = instance->numVotes;
		return (size_t)ret;
	}
	
	// numVotes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:126
	void cv_ppf_match_3d_Pose3D_setPropNumVotes_size_t(cv::ppf_match_3d::Pose3D* instance, size_t val) {
		instance->numVotes = val;
	}
	
	// pose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:127
	cv::Matx44d cv_ppf_match_3d_Pose3D_getPropPose_const(const cv::ppf_match_3d::Pose3D* instance) {
		cv::Matx44d ret = instance->pose;
		return (cv::Matx44d)ret;
	}
	
	// pose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:127
	void cv_ppf_match_3d_Pose3D_setPropPose_Matx44d(cv::ppf_match_3d::Pose3D* instance, cv::Matx44d* val) {
		instance->pose = *val;
	}
	
	// angle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:128
	double cv_ppf_match_3d_Pose3D_getPropAngle_const(const cv::ppf_match_3d::Pose3D* instance) {
		double ret = instance->angle;
		return (double)ret;
	}
	
	// angle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:128
	void cv_ppf_match_3d_Pose3D_setPropAngle_double(cv::ppf_match_3d::Pose3D* instance, double val) {
		instance->angle = val;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:129
	cv::Vec3d cv_ppf_match_3d_Pose3D_getPropT_const(const cv::ppf_match_3d::Pose3D* instance) {
		cv::Vec3d ret = instance->t;
		return (cv::Vec3d)ret;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:129
	void cv_ppf_match_3d_Pose3D_setPropT_Vec3d(cv::ppf_match_3d::Pose3D* instance, cv::Vec3d* val) {
		instance->t = *val;
	}
	
	// q /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:130
	cv::Vec4d cv_ppf_match_3d_Pose3D_getPropQ_const(const cv::ppf_match_3d::Pose3D* instance) {
		cv::Vec4d ret = instance->q;
		return (cv::Vec4d)ret;
	}
	
	// q /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:130
	void cv_ppf_match_3d_Pose3D_setPropQ_Vec4d(cv::ppf_match_3d::Pose3D* instance, cv::Vec4d* val) {
		instance->q = *val;
	}
	
	void cv_Pose3D_delete(cv::ppf_match_3d::Pose3D* instance) {
		delete instance;
	}
	// Pose3D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:73
	Result<cv::ppf_match_3d::Pose3D*> cv_ppf_match_3d_Pose3D_Pose3D() {
		try {
			cv::ppf_match_3d::Pose3D* ret = new cv::ppf_match_3d::Pose3D();
			return Ok<cv::ppf_match_3d::Pose3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::Pose3D*>))
	}
	
	// Pose3D(double, size_t, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:83
	Result<cv::ppf_match_3d::Pose3D*> cv_ppf_match_3d_Pose3D_Pose3D_double_size_t_size_t(double Alpha, size_t ModelIndex, size_t NumVotes) {
		try {
			cv::ppf_match_3d::Pose3D* ret = new cv::ppf_match_3d::Pose3D(Alpha, ModelIndex, NumVotes);
			return Ok<cv::ppf_match_3d::Pose3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::Pose3D*>))
	}
	
	// updatePose(cv::Matx44d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:97
	Result_void cv_ppf_match_3d_Pose3D_updatePose_Matx44dR(cv::ppf_match_3d::Pose3D* instance, cv::Matx44d* NewPose) {
		try {
			instance->updatePose(*NewPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updatePose(cv::Matx33d &, cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:102
	Result_void cv_ppf_match_3d_Pose3D_updatePose_Matx33dR_Vec3dR(cv::ppf_match_3d::Pose3D* instance, cv::Matx33d* NewR, cv::Vec3d* NewT) {
		try {
			instance->updatePose(*NewR, *NewT);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updatePoseQuat(cv::Vec4d &, cv::Vec3d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:107
	Result_void cv_ppf_match_3d_Pose3D_updatePoseQuat_Vec4dR_Vec3dR(cv::ppf_match_3d::Pose3D* instance, cv::Vec4d* Q, cv::Vec3d* NewT) {
		try {
			instance->updatePoseQuat(*Q, *NewT);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// appendPose(cv::Matx44d &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:113
	Result_void cv_ppf_match_3d_Pose3D_appendPose_Matx44dR(cv::ppf_match_3d::Pose3D* instance, cv::Matx44d* IncrementalPose) {
		try {
			instance->appendPose(*IncrementalPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// printPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:114
	Result_void cv_ppf_match_3d_Pose3D_printPose(cv::ppf_match_3d::Pose3D* instance) {
		try {
			instance->printPose();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:116
	Result<cv::ppf_match_3d::Pose3DPtr*> cv_ppf_match_3d_Pose3D_clone(cv::ppf_match_3d::Pose3D* instance) {
		try {
			cv::ppf_match_3d::Pose3DPtr ret = instance->clone();
			return Ok(new cv::ppf_match_3d::Pose3DPtr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::Pose3DPtr*>))
	}
	
	// writePose(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:120
	Result<int> cv_ppf_match_3d_Pose3D_writePose_const_stringR(cv::ppf_match_3d::Pose3D* instance, const char* FileName) {
		try {
			int ret = instance->writePose(std::string(FileName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// readPose(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:121
	Result<int> cv_ppf_match_3d_Pose3D_readPose_const_stringR(cv::ppf_match_3d::Pose3D* instance, const char* FileName) {
		try {
			int ret = instance->readPose(std::string(FileName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// poseList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:177
	std::vector<cv::ppf_match_3d::Pose3DPtr>* cv_ppf_match_3d_PoseCluster3D_getPropPoseList_const(const cv::ppf_match_3d::PoseCluster3D* instance) {
		std::vector<cv::ppf_match_3d::Pose3DPtr> ret = instance->poseList;
		return new std::vector<cv::ppf_match_3d::Pose3DPtr>(ret);
	}
	
	// poseList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:177
	void cv_ppf_match_3d_PoseCluster3D_setPropPoseList_vector_Pose3DPtr_(cv::ppf_match_3d::PoseCluster3D* instance, std::vector<cv::ppf_match_3d::Pose3DPtr>* val) {
		instance->poseList = *val;
	}
	
	// numVotes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:178
	size_t cv_ppf_match_3d_PoseCluster3D_getPropNumVotes_const(const cv::ppf_match_3d::PoseCluster3D* instance) {
		size_t ret = instance->numVotes;
		return (size_t)ret;
	}
	
	// numVotes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:178
	void cv_ppf_match_3d_PoseCluster3D_setPropNumVotes_size_t(cv::ppf_match_3d::PoseCluster3D* instance, size_t val) {
		instance->numVotes = val;
	}
	
	// id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:179
	int cv_ppf_match_3d_PoseCluster3D_getPropId_const(const cv::ppf_match_3d::PoseCluster3D* instance) {
		int ret = instance->id;
		return (int)ret;
	}
	
	// id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:179
	void cv_ppf_match_3d_PoseCluster3D_setPropId_int(cv::ppf_match_3d::PoseCluster3D* instance, int val) {
		instance->id = val;
	}
	
	void cv_PoseCluster3D_delete(cv::ppf_match_3d::PoseCluster3D* instance) {
		delete instance;
	}
	// PoseCluster3D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:141
	Result<cv::ppf_match_3d::PoseCluster3D*> cv_ppf_match_3d_PoseCluster3D_PoseCluster3D() {
		try {
			cv::ppf_match_3d::PoseCluster3D* ret = new cv::ppf_match_3d::PoseCluster3D();
			return Ok<cv::ppf_match_3d::PoseCluster3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::PoseCluster3D*>))
	}
	
	// PoseCluster3D(cv::ppf_match_3d::Pose3DPtr) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:147
	Result<cv::ppf_match_3d::PoseCluster3D*> cv_ppf_match_3d_PoseCluster3D_PoseCluster3D_Pose3DPtr(cv::ppf_match_3d::Pose3DPtr* newPose) {
		try {
			cv::ppf_match_3d::PoseCluster3D* ret = new cv::ppf_match_3d::PoseCluster3D(*newPose);
			return Ok<cv::ppf_match_3d::PoseCluster3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::PoseCluster3D*>))
	}
	
	// PoseCluster3D(cv::ppf_match_3d::Pose3DPtr, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:155
	Result<cv::ppf_match_3d::PoseCluster3D*> cv_ppf_match_3d_PoseCluster3D_PoseCluster3D_Pose3DPtr_int(cv::ppf_match_3d::Pose3DPtr* newPose, int newId) {
		try {
			cv::ppf_match_3d::PoseCluster3D* ret = new cv::ppf_match_3d::PoseCluster3D(*newPose, newId);
			return Ok<cv::ppf_match_3d::PoseCluster3D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ppf_match_3d::PoseCluster3D*>))
	}
	
	// addPose(cv::ppf_match_3d::Pose3DPtr) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:170
	Result_void cv_ppf_match_3d_PoseCluster3D_addPose_Pose3DPtr(cv::ppf_match_3d::PoseCluster3D* instance, cv::ppf_match_3d::Pose3DPtr* newPose) {
		try {
			instance->addPose(*newPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writePoseCluster(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:174
	Result<int> cv_ppf_match_3d_PoseCluster3D_writePoseCluster_const_stringR(cv::ppf_match_3d::PoseCluster3D* instance, const char* FileName) {
		try {
			int ret = instance->writePoseCluster(std::string(FileName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// readPoseCluster(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/surface_matching/pose_3d.hpp:175
	Result<int> cv_ppf_match_3d_PoseCluster3D_readPoseCluster_const_stringR(cv::ppf_match_3d::PoseCluster3D* instance, const char* FileName) {
		try {
			int ret = instance->readPoseCluster(std::string(FileName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
}
