#include "ocvrs_common.hpp"
#include <opencv2/superres.hpp>
#include "superres_types.hpp"

extern "C" {
	// createFrameSource_Camera(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:80
	Result<cv::Ptr<cv::superres::FrameSource>*> cv_superres_createFrameSource_Camera_int(int deviceId) {
		try {
			cv::Ptr<cv::superres::FrameSource> ret = cv::superres::createFrameSource_Camera(deviceId);
			return Ok(new cv::Ptr<cv::superres::FrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FrameSource>*>))
	}
	
	// createFrameSource_Empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:75
	Result<cv::Ptr<cv::superres::FrameSource>*> cv_superres_createFrameSource_Empty() {
		try {
			cv::Ptr<cv::superres::FrameSource> ret = cv::superres::createFrameSource_Empty();
			return Ok(new cv::Ptr<cv::superres::FrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FrameSource>*>))
	}
	
	// createFrameSource_Video_CUDA(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:78
	Result<cv::Ptr<cv::superres::FrameSource>*> cv_superres_createFrameSource_Video_CUDA_const_StringR(const char* fileName) {
		try {
			cv::Ptr<cv::superres::FrameSource> ret = cv::superres::createFrameSource_Video_CUDA(std::string(fileName));
			return Ok(new cv::Ptr<cv::superres::FrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FrameSource>*>))
	}
	
	// createFrameSource_Video(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:77
	Result<cv::Ptr<cv::superres::FrameSource>*> cv_superres_createFrameSource_Video_const_StringR(const char* fileName) {
		try {
			cv::Ptr<cv::superres::FrameSource> ret = cv::superres::createFrameSource_Video(std::string(fileName));
			return Ok(new cv::Ptr<cv::superres::FrameSource>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FrameSource>*>))
	}
	
	// createOptFlow_Brox_CUDA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:177
	Result<cv::Ptr<cv::superres::BroxOpticalFlow>*> cv_superres_createOptFlow_Brox_CUDA() {
		try {
			cv::Ptr<cv::superres::BroxOpticalFlow> ret = cv::superres::createOptFlow_Brox_CUDA();
			return Ok(new cv::Ptr<cv::superres::BroxOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::BroxOpticalFlow>*>))
	}
	
	// createOptFlow_DualTVL1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:139
	Result<cv::Ptr<cv::superres::DualTVL1OpticalFlow>*> cv_superres_createOptFlow_DualTVL1() {
		try {
			cv::Ptr<cv::superres::DualTVL1OpticalFlow> ret = cv::superres::createOptFlow_DualTVL1();
			return Ok(new cv::Ptr<cv::superres::DualTVL1OpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::DualTVL1OpticalFlow>*>))
	}
	
	// createOptFlow_DualTVL1_CUDA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:140
	Result<cv::Ptr<cv::superres::DualTVL1OpticalFlow>*> cv_superres_createOptFlow_DualTVL1_CUDA() {
		try {
			cv::Ptr<cv::superres::DualTVL1OpticalFlow> ret = cv::superres::createOptFlow_DualTVL1_CUDA();
			return Ok(new cv::Ptr<cv::superres::DualTVL1OpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::DualTVL1OpticalFlow>*>))
	}
	
	// createOptFlow_Farneback() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:96
	Result<cv::Ptr<cv::superres::FarnebackOpticalFlow>*> cv_superres_createOptFlow_Farneback() {
		try {
			cv::Ptr<cv::superres::FarnebackOpticalFlow> ret = cv::superres::createOptFlow_Farneback();
			return Ok(new cv::Ptr<cv::superres::FarnebackOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FarnebackOpticalFlow>*>))
	}
	
	// createOptFlow_Farneback_CUDA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:97
	Result<cv::Ptr<cv::superres::FarnebackOpticalFlow>*> cv_superres_createOptFlow_Farneback_CUDA() {
		try {
			cv::Ptr<cv::superres::FarnebackOpticalFlow> ret = cv::superres::createOptFlow_Farneback_CUDA();
			return Ok(new cv::Ptr<cv::superres::FarnebackOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::FarnebackOpticalFlow>*>))
	}
	
	// createOptFlow_PyrLK_CUDA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:196
	Result<cv::Ptr<cv::superres::PyrLKOpticalFlow>*> cv_superres_createOptFlow_PyrLK_CUDA() {
		try {
			cv::Ptr<cv::superres::PyrLKOpticalFlow> ret = cv::superres::createOptFlow_PyrLK_CUDA();
			return Ok(new cv::Ptr<cv::superres::PyrLKOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::PyrLKOpticalFlow>*>))
	}
	
	// createSuperResolution_BTVL1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:199
	Result<cv::Ptr<cv::superres::SuperResolution>*> cv_superres_createSuperResolution_BTVL1() {
		try {
			cv::Ptr<cv::superres::SuperResolution> ret = cv::superres::createSuperResolution_BTVL1();
			return Ok(new cv::Ptr<cv::superres::SuperResolution>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::SuperResolution>*>))
	}
	
	// createSuperResolution_BTVL1_CUDA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:200
	Result<cv::Ptr<cv::superres::SuperResolution>*> cv_superres_createSuperResolution_BTVL1_CUDA() {
		try {
			cv::Ptr<cv::superres::SuperResolution> ret = cv::superres::createSuperResolution_BTVL1_CUDA();
			return Ok(new cv::Ptr<cv::superres::SuperResolution>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::SuperResolution>*>))
	}
	
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:148
	Result<double> cv_superres_BroxOpticalFlow_getAlpha_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			double ret = instance->getAlpha();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAlpha(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:150
	Result_void cv_superres_BroxOpticalFlow_setAlpha_double(cv::superres::BroxOpticalFlow* instance, double val) {
		try {
			instance->setAlpha(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:153
	Result<double> cv_superres_BroxOpticalFlow_getGamma_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			double ret = instance->getGamma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setGamma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:155
	Result_void cv_superres_BroxOpticalFlow_setGamma_double(cv::superres::BroxOpticalFlow* instance, double val) {
		try {
			instance->setGamma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleFactor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:158
	Result<double> cv_superres_BroxOpticalFlow_getScaleFactor_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			double ret = instance->getScaleFactor();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setScaleFactor(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:160
	Result_void cv_superres_BroxOpticalFlow_setScaleFactor_double(cv::superres::BroxOpticalFlow* instance, double val) {
		try {
			instance->setScaleFactor(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getInnerIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:163
	Result<int> cv_superres_BroxOpticalFlow_getInnerIterations_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			int ret = instance->getInnerIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setInnerIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:165
	Result_void cv_superres_BroxOpticalFlow_setInnerIterations_int(cv::superres::BroxOpticalFlow* instance, int val) {
		try {
			instance->setInnerIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOuterIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:168
	Result<int> cv_superres_BroxOpticalFlow_getOuterIterations_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			int ret = instance->getOuterIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setOuterIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:170
	Result_void cv_superres_BroxOpticalFlow_setOuterIterations_int(cv::superres::BroxOpticalFlow* instance, int val) {
		try {
			instance->setOuterIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSolverIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:173
	Result<int> cv_superres_BroxOpticalFlow_getSolverIterations_const(const cv::superres::BroxOpticalFlow* instance) {
		try {
			int ret = instance->getSolverIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSolverIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:175
	Result_void cv_superres_BroxOpticalFlow_setSolverIterations_int(cv::superres::BroxOpticalFlow* instance, int val) {
		try {
			instance->setSolverIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calc(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:59
	Result_void cv_superres_DenseOpticalFlowExt_calc_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::superres::DenseOpticalFlowExt* instance, const cv::_InputArray* frame0, const cv::_InputArray* frame1, const cv::_OutputArray* flow1, const cv::_OutputArray* flow2) {
		try {
			instance->calc(*frame0, *frame1, *flow1, *flow2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:60
	Result_void cv_superres_DenseOpticalFlowExt_collectGarbage(cv::superres::DenseOpticalFlowExt* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTau() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:107
	Result<double> cv_superres_DualTVL1OpticalFlow_getTau_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getTau();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTau(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:109
	Result_void cv_superres_DualTVL1OpticalFlow_setTau_double(cv::superres::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setTau(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:111
	Result<double> cv_superres_DualTVL1OpticalFlow_getLambda_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getLambda();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLambda(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:113
	Result_void cv_superres_DualTVL1OpticalFlow_setLambda_double(cv::superres::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setLambda(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTheta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:115
	Result<double> cv_superres_DualTVL1OpticalFlow_getTheta_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getTheta();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTheta(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:117
	Result_void cv_superres_DualTVL1OpticalFlow_setTheta_double(cv::superres::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setTheta(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScalesNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:119
	Result<int> cv_superres_DualTVL1OpticalFlow_getScalesNumber_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getScalesNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setScalesNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:121
	Result_void cv_superres_DualTVL1OpticalFlow_setScalesNumber_int(cv::superres::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setScalesNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWarpingsNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:123
	Result<int> cv_superres_DualTVL1OpticalFlow_getWarpingsNumber_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getWarpingsNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWarpingsNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:125
	Result_void cv_superres_DualTVL1OpticalFlow_setWarpingsNumber_int(cv::superres::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setWarpingsNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEpsilon() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:127
	Result<double> cv_superres_DualTVL1OpticalFlow_getEpsilon_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getEpsilon();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setEpsilon(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:129
	Result_void cv_superres_DualTVL1OpticalFlow_setEpsilon_double(cv::superres::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setEpsilon(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:131
	Result<int> cv_superres_DualTVL1OpticalFlow_getIterations_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:133
	Result_void cv_superres_DualTVL1OpticalFlow_setIterations_int(cv::superres::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseInitialFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:135
	Result<bool> cv_superres_DualTVL1OpticalFlow_getUseInitialFlow_const(const cv::superres::DualTVL1OpticalFlow* instance) {
		try {
			bool ret = instance->getUseInitialFlow();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseInitialFlow(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:137
	Result_void cv_superres_DualTVL1OpticalFlow_setUseInitialFlow_bool(cv::superres::DualTVL1OpticalFlow* instance, bool val) {
		try {
			instance->setUseInitialFlow(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPyrScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:68
	Result<double> cv_superres_FarnebackOpticalFlow_getPyrScale_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			double ret = instance->getPyrScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setPyrScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:70
	Result_void cv_superres_FarnebackOpticalFlow_setPyrScale_double(cv::superres::FarnebackOpticalFlow* instance, double val) {
		try {
			instance->setPyrScale(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLevelsNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:72
	Result<int> cv_superres_FarnebackOpticalFlow_getLevelsNumber_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getLevelsNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setLevelsNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:74
	Result_void cv_superres_FarnebackOpticalFlow_setLevelsNumber_int(cv::superres::FarnebackOpticalFlow* instance, int val) {
		try {
			instance->setLevelsNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:76
	Result<int> cv_superres_FarnebackOpticalFlow_getWindowSize_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getWindowSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWindowSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:78
	Result_void cv_superres_FarnebackOpticalFlow_setWindowSize_int(cv::superres::FarnebackOpticalFlow* instance, int val) {
		try {
			instance->setWindowSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:80
	Result<int> cv_superres_FarnebackOpticalFlow_getIterations_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:82
	Result_void cv_superres_FarnebackOpticalFlow_setIterations_int(cv::superres::FarnebackOpticalFlow* instance, int val) {
		try {
			instance->setIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPolyN() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:84
	Result<int> cv_superres_FarnebackOpticalFlow_getPolyN_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getPolyN();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPolyN(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:86
	Result_void cv_superres_FarnebackOpticalFlow_setPolyN_int(cv::superres::FarnebackOpticalFlow* instance, int val) {
		try {
			instance->setPolyN(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPolySigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:88
	Result<double> cv_superres_FarnebackOpticalFlow_getPolySigma_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			double ret = instance->getPolySigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setPolySigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:90
	Result_void cv_superres_FarnebackOpticalFlow_setPolySigma_double(cv::superres::FarnebackOpticalFlow* instance, double val) {
		try {
			instance->setPolySigma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:92
	Result<int> cv_superres_FarnebackOpticalFlow_getFlags_const(const cv::superres::FarnebackOpticalFlow* instance) {
		try {
			int ret = instance->getFlags();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFlags(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:94
	Result_void cv_superres_FarnebackOpticalFlow_setFlags_int(cv::superres::FarnebackOpticalFlow* instance, int val) {
		try {
			instance->setFlags(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:71
	Result_void cv_superres_FrameSource_nextFrame_const__OutputArrayR(cv::superres::FrameSource* instance, const cv::_OutputArray* frame) {
		try {
			instance->nextFrame(*frame);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:72
	Result_void cv_superres_FrameSource_reset(cv::superres::FrameSource* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:184
	Result<int> cv_superres_PyrLKOpticalFlow_getWindowSize_const(const cv::superres::PyrLKOpticalFlow* instance) {
		try {
			int ret = instance->getWindowSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWindowSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:186
	Result_void cv_superres_PyrLKOpticalFlow_setWindowSize_int(cv::superres::PyrLKOpticalFlow* instance, int val) {
		try {
			instance->setWindowSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:188
	Result<int> cv_superres_PyrLKOpticalFlow_getMaxLevel_const(const cv::superres::PyrLKOpticalFlow* instance) {
		try {
			int ret = instance->getMaxLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:190
	Result_void cv_superres_PyrLKOpticalFlow_setMaxLevel_int(cv::superres::PyrLKOpticalFlow* instance, int val) {
		try {
			instance->setMaxLevel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:192
	Result<int> cv_superres_PyrLKOpticalFlow_getIterations_const(const cv::superres::PyrLKOpticalFlow* instance) {
		try {
			int ret = instance->getIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres/optical_flow.hpp:194
	Result_void cv_superres_PyrLKOpticalFlow_setIterations_int(cv::superres::PyrLKOpticalFlow* instance, int val) {
		try {
			instance->setIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInput(const Ptr<cv::superres::FrameSource> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:94
	Result_void cv_superres_SuperResolution_setInput_const_Ptr_FrameSource_R(cv::superres::SuperResolution* instance, const cv::Ptr<cv::superres::FrameSource>* frameSource) {
		try {
			instance->setInput(*frameSource);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:100
	Result_void cv_superres_SuperResolution_nextFrame_const__OutputArrayR(cv::superres::SuperResolution* instance, const cv::_OutputArray* frame) {
		try {
			instance->nextFrame(*frame);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:101
	Result_void cv_superres_SuperResolution_reset(cv::superres::SuperResolution* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:105
	Result_void cv_superres_SuperResolution_collectGarbage(cv::superres::SuperResolution* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:109
	Result<int> cv_superres_SuperResolution_getScale_const(const cv::superres::SuperResolution* instance) {
		try {
			int ret = instance->getScale();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setScale(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:111
	Result_void cv_superres_SuperResolution_setScale_int(cv::superres::SuperResolution* instance, int val) {
		try {
			instance->setScale(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:115
	Result<int> cv_superres_SuperResolution_getIterations_const(const cv::superres::SuperResolution* instance) {
		try {
			int ret = instance->getIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:117
	Result_void cv_superres_SuperResolution_setIterations_int(cv::superres::SuperResolution* instance, int val) {
		try {
			instance->setIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTau() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:121
	Result<double> cv_superres_SuperResolution_getTau_const(const cv::superres::SuperResolution* instance) {
		try {
			double ret = instance->getTau();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTau(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:123
	Result_void cv_superres_SuperResolution_setTau_double(cv::superres::SuperResolution* instance, double val) {
		try {
			instance->setTau(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:127
	Result<double> cv_superres_SuperResolution_getLambda_const(const cv::superres::SuperResolution* instance) {
		try {
			double ret = instance->getLambda();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLambda(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:129
	Result_void cv_superres_SuperResolution_setLambda_double(cv::superres::SuperResolution* instance, double val) {
		try {
			instance->setLambda(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:133
	Result<double> cv_superres_SuperResolution_getAlpha_const(const cv::superres::SuperResolution* instance) {
		try {
			double ret = instance->getAlpha();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAlpha(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:135
	Result_void cv_superres_SuperResolution_setAlpha_double(cv::superres::SuperResolution* instance, double val) {
		try {
			instance->setAlpha(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getKernelSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:139
	Result<int> cv_superres_SuperResolution_getKernelSize_const(const cv::superres::SuperResolution* instance) {
		try {
			int ret = instance->getKernelSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setKernelSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:141
	Result_void cv_superres_SuperResolution_setKernelSize_int(cv::superres::SuperResolution* instance, int val) {
		try {
			instance->setKernelSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBlurKernelSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:145
	Result<int> cv_superres_SuperResolution_getBlurKernelSize_const(const cv::superres::SuperResolution* instance) {
		try {
			int ret = instance->getBlurKernelSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setBlurKernelSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:147
	Result_void cv_superres_SuperResolution_setBlurKernelSize_int(cv::superres::SuperResolution* instance, int val) {
		try {
			instance->setBlurKernelSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBlurSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:151
	Result<double> cv_superres_SuperResolution_getBlurSigma_const(const cv::superres::SuperResolution* instance) {
		try {
			double ret = instance->getBlurSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBlurSigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:153
	Result_void cv_superres_SuperResolution_setBlurSigma_double(cv::superres::SuperResolution* instance, double val) {
		try {
			instance->setBlurSigma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTemporalAreaRadius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:157
	Result<int> cv_superres_SuperResolution_getTemporalAreaRadius_const(const cv::superres::SuperResolution* instance) {
		try {
			int ret = instance->getTemporalAreaRadius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTemporalAreaRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:159
	Result_void cv_superres_SuperResolution_setTemporalAreaRadius_int(cv::superres::SuperResolution* instance, int val) {
		try {
			instance->setTemporalAreaRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOpticalFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:163
	Result<cv::Ptr<cv::superres::DenseOpticalFlowExt>*> cv_superres_SuperResolution_getOpticalFlow_const(const cv::superres::SuperResolution* instance) {
		try {
			cv::Ptr<cv::superres::DenseOpticalFlowExt> ret = instance->getOpticalFlow();
			return Ok(new cv::Ptr<cv::superres::DenseOpticalFlowExt>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::superres::DenseOpticalFlowExt>*>))
	}
	
	// setOpticalFlow(const Ptr<cv::superres::DenseOpticalFlowExt> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/superres.hpp:165
	Result_void cv_superres_SuperResolution_setOpticalFlow_const_Ptr_DenseOpticalFlowExt_R(cv::superres::SuperResolution* instance, const cv::Ptr<cv::superres::DenseOpticalFlowExt>* val) {
		try {
			instance->setOpticalFlow(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
