#include "ocvrs_common.hpp"
#include <opencv2/structured_light.hpp>
#include "structured_light_types.hpp"

extern "C" {
	// create(const GrayCodePattern::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:86
	Result<cv::Ptr<cv::structured_light::GrayCodePattern>*> cv_structured_light_GrayCodePattern_create_const_ParamsR(const cv::structured_light::GrayCodePattern::Params* parameters) {
		try {
			cv::Ptr<cv::structured_light::GrayCodePattern> ret = cv::structured_light::GrayCodePattern::create(*parameters);
			return Ok(new cv::Ptr<cv::structured_light::GrayCodePattern>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::structured_light::GrayCodePattern>*>))
	}
	
	// create(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:90
	Result<cv::Ptr<cv::structured_light::GrayCodePattern>*> cv_structured_light_GrayCodePattern_create_int_int(int width, int height) {
		try {
			cv::Ptr<cv::structured_light::GrayCodePattern> ret = cv::structured_light::GrayCodePattern::create(width, height);
			return Ok(new cv::Ptr<cv::structured_light::GrayCodePattern>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::structured_light::GrayCodePattern>*>))
	}
	
	// getNumberOfPatternImages() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:98
	Result<size_t> cv_structured_light_GrayCodePattern_getNumberOfPatternImages_const(const cv::structured_light::GrayCodePattern* instance) {
		try {
			size_t ret = instance->getNumberOfPatternImages();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// setWhiteThreshold(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:108
	Result_void cv_structured_light_GrayCodePattern_setWhiteThreshold_size_t(cv::structured_light::GrayCodePattern* instance, size_t value) {
		try {
			instance->setWhiteThreshold(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBlackThreshold(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:118
	Result_void cv_structured_light_GrayCodePattern_setBlackThreshold_size_t(cv::structured_light::GrayCodePattern* instance, size_t value) {
		try {
			instance->setBlackThreshold(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getImagesForShadowMasks(cv::InputOutputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:130
	Result_void cv_structured_light_GrayCodePattern_getImagesForShadowMasks_const_const__InputOutputArrayR_const__InputOutputArrayR(const cv::structured_light::GrayCodePattern* instance, const cv::_InputOutputArray* blackImage, const cv::_InputOutputArray* whiteImage) {
		try {
			instance->getImagesForShadowMasks(*blackImage, *whiteImage);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getProjPixel(cv::InputArrayOfArrays, int, int, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:143
	Result<bool> cv_structured_light_GrayCodePattern_getProjPixel_const_const__InputArrayR_int_int_PointR(const cv::structured_light::GrayCodePattern* instance, const cv::_InputArray* patternImages, int x, int y, cv::Point* projPix) {
		try {
			bool ret = instance->getProjPixel(*patternImages, x, y, *projPix);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:79
	int cv_structured_light_GrayCodePattern_Params_getPropWidth_const(const cv::structured_light::GrayCodePattern::Params* instance) {
		int ret = instance->width;
		return (int)ret;
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:79
	void cv_structured_light_GrayCodePattern_Params_setPropWidth_int(cv::structured_light::GrayCodePattern::Params* instance, int val) {
		instance->width = val;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:80
	int cv_structured_light_GrayCodePattern_Params_getPropHeight_const(const cv::structured_light::GrayCodePattern::Params* instance) {
		int ret = instance->height;
		return (int)ret;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:80
	void cv_structured_light_GrayCodePattern_Params_setPropHeight_int(cv::structured_light::GrayCodePattern::Params* instance, int val) {
		instance->height = val;
	}
	
	void cv_GrayCodePattern_Params_delete(cv::structured_light::GrayCodePattern::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/graycodepattern.hpp:78
	Result<cv::structured_light::GrayCodePattern::Params*> cv_structured_light_GrayCodePattern_Params_Params() {
		try {
			cv::structured_light::GrayCodePattern::Params* ret = new cv::structured_light::GrayCodePattern::Params();
			return Ok<cv::structured_light::GrayCodePattern::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::structured_light::GrayCodePattern::Params*>))
	}
	
	// create(Ptr<SinusoidalPattern::Params>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:100
	Result<cv::Ptr<cv::structured_light::SinusoidalPattern>*> cv_structured_light_SinusoidalPattern_create_Ptr_Params_(cv::Ptr<cv::structured_light::SinusoidalPattern::Params>* parameters) {
		try {
			cv::Ptr<cv::structured_light::SinusoidalPattern> ret = cv::structured_light::SinusoidalPattern::create(*parameters);
			return Ok(new cv::Ptr<cv::structured_light::SinusoidalPattern>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::structured_light::SinusoidalPattern>*>))
	}
	
	// computePhaseMap(cv::InputArrayOfArrays, cv::OutputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:110
	Result_void cv_structured_light_SinusoidalPattern_computePhaseMap_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(cv::structured_light::SinusoidalPattern* instance, const cv::_InputArray* patternImages, const cv::_OutputArray* wrappedPhaseMap, const cv::_OutputArray* shadowMask, const cv::_InputArray* fundamental) {
		try {
			instance->computePhaseMap(*patternImages, *wrappedPhaseMap, *shadowMask, *fundamental);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unwrapPhaseMap(cv::InputArray, cv::OutputArray, cv::Size, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:122
	Result_void cv_structured_light_SinusoidalPattern_unwrapPhaseMap_const__InputArrayR_const__OutputArrayR_Size_const__InputArrayR(cv::structured_light::SinusoidalPattern* instance, const cv::_InputArray* wrappedPhaseMap, const cv::_OutputArray* unwrappedPhaseMap, cv::Size* camSize, const cv::_InputArray* shadowMask) {
		try {
			instance->unwrapPhaseMap(*wrappedPhaseMap, *unwrappedPhaseMap, *camSize, *shadowMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findProCamMatches(cv::InputArray, cv::InputArray, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:133
	Result_void cv_structured_light_SinusoidalPattern_findProCamMatches_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::structured_light::SinusoidalPattern* instance, const cv::_InputArray* projUnwrappedPhaseMap, const cv::_InputArray* camUnwrappedPhaseMap, const cv::_OutputArray* matches) {
		try {
			instance->findProCamMatches(*projUnwrappedPhaseMap, *camUnwrappedPhaseMap, *matches);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeDataModulationTerm(cv::InputArrayOfArrays, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:143
	Result_void cv_structured_light_SinusoidalPattern_computeDataModulationTerm_const__InputArrayR_const__OutputArrayR_const__InputArrayR(cv::structured_light::SinusoidalPattern* instance, const cv::_InputArray* patternImages, const cv::_OutputArray* dataModulationTerm, const cv::_InputArray* shadowMask) {
		try {
			instance->computeDataModulationTerm(*patternImages, *dataModulationTerm, *shadowMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:85
	int cv_structured_light_SinusoidalPattern_Params_getPropWidth_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		int ret = instance->width;
		return (int)ret;
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:85
	void cv_structured_light_SinusoidalPattern_Params_setPropWidth_int(cv::structured_light::SinusoidalPattern::Params* instance, int val) {
		instance->width = val;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:86
	int cv_structured_light_SinusoidalPattern_Params_getPropHeight_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		int ret = instance->height;
		return (int)ret;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:86
	void cv_structured_light_SinusoidalPattern_Params_setPropHeight_int(cv::structured_light::SinusoidalPattern::Params* instance, int val) {
		instance->height = val;
	}
	
	// nbrOfPeriods /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:87
	int cv_structured_light_SinusoidalPattern_Params_getPropNbrOfPeriods_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		int ret = instance->nbrOfPeriods;
		return (int)ret;
	}
	
	// nbrOfPeriods /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:87
	void cv_structured_light_SinusoidalPattern_Params_setPropNbrOfPeriods_int(cv::structured_light::SinusoidalPattern::Params* instance, int val) {
		instance->nbrOfPeriods = val;
	}
	
	// shiftValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:88
	float cv_structured_light_SinusoidalPattern_Params_getPropShiftValue_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		float ret = instance->shiftValue;
		return (float)ret;
	}
	
	// shiftValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:88
	void cv_structured_light_SinusoidalPattern_Params_setPropShiftValue_float(cv::structured_light::SinusoidalPattern::Params* instance, float val) {
		instance->shiftValue = val;
	}
	
	// methodId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:89
	int cv_structured_light_SinusoidalPattern_Params_getPropMethodId_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		int ret = instance->methodId;
		return (int)ret;
	}
	
	// methodId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:89
	void cv_structured_light_SinusoidalPattern_Params_setPropMethodId_int(cv::structured_light::SinusoidalPattern::Params* instance, int val) {
		instance->methodId = val;
	}
	
	// nbrOfPixelsBetweenMarkers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:90
	int cv_structured_light_SinusoidalPattern_Params_getPropNbrOfPixelsBetweenMarkers_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		int ret = instance->nbrOfPixelsBetweenMarkers;
		return (int)ret;
	}
	
	// nbrOfPixelsBetweenMarkers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:90
	void cv_structured_light_SinusoidalPattern_Params_setPropNbrOfPixelsBetweenMarkers_int(cv::structured_light::SinusoidalPattern::Params* instance, int val) {
		instance->nbrOfPixelsBetweenMarkers = val;
	}
	
	// horizontal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:91
	bool cv_structured_light_SinusoidalPattern_Params_getPropHorizontal_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		bool ret = instance->horizontal;
		return (bool)ret;
	}
	
	// horizontal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:91
	void cv_structured_light_SinusoidalPattern_Params_setPropHorizontal_bool(cv::structured_light::SinusoidalPattern::Params* instance, bool val) {
		instance->horizontal = val;
	}
	
	// setMarkers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:92
	bool cv_structured_light_SinusoidalPattern_Params_getPropSetMarkers_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		bool ret = instance->setMarkers;
		return (bool)ret;
	}
	
	// setMarkers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:92
	void cv_structured_light_SinusoidalPattern_Params_setPropSetMarkers_bool(cv::structured_light::SinusoidalPattern::Params* instance, bool val) {
		instance->setMarkers = val;
	}
	
	// markersLocation /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:93
	std::vector<cv::Point2f>* cv_structured_light_SinusoidalPattern_Params_getPropMarkersLocation_const(const cv::structured_light::SinusoidalPattern::Params* instance) {
		std::vector<cv::Point2f> ret = instance->markersLocation;
		return new std::vector<cv::Point2f>(ret);
	}
	
	// markersLocation /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:93
	void cv_structured_light_SinusoidalPattern_Params_setPropMarkersLocation_vector_Point2f_(cv::structured_light::SinusoidalPattern::Params* instance, std::vector<cv::Point2f>* val) {
		instance->markersLocation = *val;
	}
	
	void cv_SinusoidalPattern_Params_delete(cv::structured_light::SinusoidalPattern::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/sinusoidalpattern.hpp:84
	Result<cv::structured_light::SinusoidalPattern::Params*> cv_structured_light_SinusoidalPattern_Params_Params() {
		try {
			cv::structured_light::SinusoidalPattern::Params* ret = new cv::structured_light::SinusoidalPattern::Params();
			return Ok<cv::structured_light::SinusoidalPattern::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::structured_light::SinusoidalPattern::Params*>))
	}
	
	// generate(cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/structured_light.hpp:69
	Result<bool> cv_structured_light_StructuredLightPattern_generate_const__OutputArrayR(cv::structured_light::StructuredLightPattern* instance, const cv::_OutputArray* patternImages) {
		try {
			bool ret = instance->generate(*patternImages);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// decode(const std::vector<std::vector<Mat>> &, cv::OutputArray, cv::InputArrayOfArrays, cv::InputArrayOfArrays, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/structured_light/structured_light.hpp:81
	Result<bool> cv_structured_light_StructuredLightPattern_decode_const_const_vector_vector_Mat__R_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(const cv::structured_light::StructuredLightPattern* instance, const std::vector<std::vector<cv::Mat>>* patternImages, const cv::_OutputArray* disparityMap, const cv::_InputArray* blackImages, const cv::_InputArray* whiteImages, int flags) {
		try {
			bool ret = instance->decode(*patternImages, *disparityMap, *blackImages, *whiteImages, flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
}
