#include "ocvrs_common.hpp"
#include <opencv2/stitching.hpp>
#include "stitching_types.hpp"

extern "C" {
	// autoDetectWaveCorrectKind(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:342
	Result<cv::detail::WaveCorrectKind> cv_detail_autoDetectWaveCorrectKind_const_vector_Mat_R(const std::vector<cv::Mat>* rmats) {
		try {
			cv::detail::WaveCorrectKind ret = cv::detail::autoDetectWaveCorrectKind(*rmats);
			return Ok<cv::detail::WaveCorrectKind>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::WaveCorrectKind>))
	}
	
	// computeImageFeatures(const Ptr<cv::Feature2D> &, cv::InputArray, cv::detail::ImageFeatures &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:86
	Result_void cv_detail_computeImageFeatures_const_Ptr_Feature2D_R_const__InputArrayR_ImageFeaturesR_const__InputArrayR(const cv::Ptr<cv::Feature2D>* featuresFinder, const cv::_InputArray* image, cv::detail::ImageFeatures* features, const cv::_InputArray* mask) {
		try {
			cv::detail::computeImageFeatures(*featuresFinder, *image, *features, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeImageFeatures(const Ptr<cv::Feature2D> &, cv::InputArrayOfArrays, std::vector<ImageFeatures> &, cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:73
	Result_void cv_detail_computeImageFeatures_const_Ptr_Feature2D_R_const__InputArrayR_vector_ImageFeatures_R_const__InputArrayR(const cv::Ptr<cv::Feature2D>* featuresFinder, const cv::_InputArray* images, std::vector<cv::detail::ImageFeatures>* features, const cv::_InputArray* masks) {
		try {
			cv::detail::computeImageFeatures(*featuresFinder, *images, *features, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createLaplacePyrGpu(cv::InputArray, int, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:173
	Result_void cv_detail_createLaplacePyrGpu_const__InputArrayR_int_vector_UMat_R(const cv::_InputArray* img, int num_levels, std::vector<cv::UMat>* pyr) {
		try {
			cv::detail::createLaplacePyrGpu(*img, num_levels, *pyr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createLaplacePyr(cv::InputArray, int, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:172
	Result_void cv_detail_createLaplacePyr_const__InputArrayR_int_vector_UMat_R(const cv::_InputArray* img, int num_levels, std::vector<cv::UMat>* pyr) {
		try {
			cv::detail::createLaplacePyr(*img, num_levels, *pyr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createWeightMap(cv::InputArray, float, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:170
	Result_void cv_detail_createWeightMap_const__InputArrayR_float_const__InputOutputArrayR(const cv::_InputArray* mask, float sharpness, const cv::_InputOutputArray* weight) {
		try {
			cv::detail::createWeightMap(*mask, sharpness, *weight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findMaxSpanningTree(int, const std::vector<MatchesInfo> &, cv::detail::Graph &, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:364
	Result_void cv_detail_findMaxSpanningTree_int_const_vector_MatchesInfo_R_GraphR_vector_int_R(int num_images, const std::vector<cv::detail::MatchesInfo>* pairwise_matches, cv::detail::Graph* span_tree, std::vector<int>* centers) {
		try {
			cv::detail::findMaxSpanningTree(num_images, *pairwise_matches, *span_tree, *centers);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// leaveBiggestComponent(std::vector<ImageFeatures> &, std::vector<MatchesInfo> &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:359
	Result<std::vector<int>*> cv_detail_leaveBiggestComponent_vector_ImageFeatures_R_vector_MatchesInfo_R_float(std::vector<cv::detail::ImageFeatures>* features, std::vector<cv::detail::MatchesInfo>* pairwise_matches, float conf_threshold) {
		try {
			std::vector<int> ret = cv::detail::leaveBiggestComponent(*features, *pairwise_matches, conf_threshold);
			return Ok(new std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<int>*>))
	}
	
	// matchesGraphAsString(std::vector<String> &, std::vector<MatchesInfo> &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:356
	Result<void*> cv_detail_matchesGraphAsString_vector_String_R_vector_MatchesInfo_R_float(std::vector<cv::String>* pathes, std::vector<cv::detail::MatchesInfo>* pairwise_matches, float conf_threshold) {
		try {
			cv::String ret = cv::detail::matchesGraphAsString(*pathes, *pairwise_matches, conf_threshold);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// normalizeUsingWeightMap(cv::InputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:168
	Result_void cv_detail_normalizeUsingWeightMap_const__InputArrayR_const__InputOutputArrayR(const cv::_InputArray* weight, const cv::_InputOutputArray* src) {
		try {
			cv::detail::normalizeUsingWeightMap(*weight, *src);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// overlapRoi(cv::Point, cv::Point, cv::Size, cv::Size, cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:103
	Result<bool> cv_detail_overlapRoi_Point_Point_Size_Size_RectR(cv::Point* tl1, cv::Point* tl2, cv::Size* sz1, cv::Size* sz2, cv::Rect* roi) {
		try {
			bool ret = cv::detail::overlapRoi(*tl1, *tl2, *sz1, *sz2, *roi);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// restoreImageFromLaplacePyrGpu(std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:177
	Result_void cv_detail_restoreImageFromLaplacePyrGpu_vector_UMat_R(std::vector<cv::UMat>* pyr) {
		try {
			cv::detail::restoreImageFromLaplacePyrGpu(*pyr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// restoreImageFromLaplacePyr(std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:176
	Result_void cv_detail_restoreImageFromLaplacePyr_vector_UMat_R(std::vector<cv::UMat>* pyr) {
		try {
			cv::detail::restoreImageFromLaplacePyr(*pyr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resultRoiIntersection(const std::vector<Point> &, const std::vector<Size> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:106
	Result<cv::Rect> cv_detail_resultRoiIntersection_const_vector_Point_R_const_vector_Size_R(const std::vector<cv::Point>* corners, const std::vector<cv::Size>* sizes) {
		try {
			cv::Rect ret = cv::detail::resultRoiIntersection(*corners, *sizes);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// resultRoi(const std::vector<Point> &, const std::vector<Size> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:105
	Result<cv::Rect> cv_detail_resultRoi_const_vector_Point_R_const_vector_Size_R(const std::vector<cv::Point>* corners, const std::vector<cv::Size>* sizes) {
		try {
			cv::Rect ret = cv::detail::resultRoi(*corners, *sizes);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// resultRoi(const std::vector<Point> &, const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:104
	Result<cv::Rect> cv_detail_resultRoi_const_vector_Point_R_const_vector_UMat_R(const std::vector<cv::Point>* corners, const std::vector<cv::UMat>* images) {
		try {
			cv::Rect ret = cv::detail::resultRoi(*corners, *images);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// resultTl(const std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:107
	Result<cv::Point> cv_detail_resultTl_const_vector_Point_R(const std::vector<cv::Point>* corners) {
		try {
			cv::Point ret = cv::detail::resultTl(*corners);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// selectRandomSubset(int, int, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:110
	Result_void cv_detail_selectRandomSubset_int_int_vector_int_R(int count, int size, std::vector<int>* subset) {
		try {
			cv::detail::selectRandomSubset(count, size, *subset);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stitchingLogLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:112
	Result<int> cv_detail_stitchingLogLevel() {
		try {
			int ret = cv::detail::stitchingLogLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// waveCorrect(std::vector<Mat> &, cv::detail::WaveCorrectKind) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:349
	Result_void cv_detail_waveCorrect_vector_Mat_R_WaveCorrectKind(std::vector<cv::Mat>* rmats, cv::detail::WaveCorrectKind kind) {
		try {
			cv::detail::waveCorrect(*rmats, kind);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_AffineWarper_delete(cv::AffineWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:162
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_AffineWarper_create_const_float(const cv::AffineWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_CompressedRectilinearPortraitWarper_delete(cv::CompressedRectilinearPortraitWarper* instance) {
		delete instance;
	}
	// CompressedRectilinearPortraitWarper(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:208
	Result<cv::CompressedRectilinearPortraitWarper*> cv_CompressedRectilinearPortraitWarper_CompressedRectilinearPortraitWarper_float_float(float A, float B) {
		try {
			cv::CompressedRectilinearPortraitWarper* ret = new cv::CompressedRectilinearPortraitWarper(A, B);
			return Ok<cv::CompressedRectilinearPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CompressedRectilinearPortraitWarper*>))
	}
	
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:212
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_CompressedRectilinearPortraitWarper_create_const_float(const cv::CompressedRectilinearPortraitWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_CompressedRectilinearWarper_delete(cv::CompressedRectilinearWarper* instance) {
		delete instance;
	}
	// CompressedRectilinearWarper(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:197
	Result<cv::CompressedRectilinearWarper*> cv_CompressedRectilinearWarper_CompressedRectilinearWarper_float_float(float A, float B) {
		try {
			cv::CompressedRectilinearWarper* ret = new cv::CompressedRectilinearWarper(A, B);
			return Ok<cv::CompressedRectilinearWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CompressedRectilinearWarper*>))
	}
	
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:201
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_CompressedRectilinearWarper_create_const_float(const cv::CompressedRectilinearWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_CylindricalWarper_delete(cv::CylindricalWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:171
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_CylindricalWarper_create_const_float(const cv::CylindricalWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_CylindricalWarperGpu_delete(cv::CylindricalWarperGpu* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:262
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_CylindricalWarperGpu_create_const_float(const cv::CylindricalWarperGpu* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_FisheyeWarper_delete(cv::FisheyeWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:184
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_FisheyeWarper_create_const_float(const cv::FisheyeWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_MercatorWarper_delete(cv::MercatorWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:240
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_MercatorWarper_create_const_float(const cv::MercatorWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_PaniniPortraitWarper_delete(cv::PaniniPortraitWarper* instance) {
		delete instance;
	}
	// PaniniPortraitWarper(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:230
	Result<cv::PaniniPortraitWarper*> cv_PaniniPortraitWarper_PaniniPortraitWarper_float_float(float A, float B) {
		try {
			cv::PaniniPortraitWarper* ret = new cv::PaniniPortraitWarper(A, B);
			return Ok<cv::PaniniPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PaniniPortraitWarper*>))
	}
	
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:234
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_PaniniPortraitWarper_create_const_float(const cv::PaniniPortraitWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_PaniniWarper_delete(cv::PaniniWarper* instance) {
		delete instance;
	}
	// PaniniWarper(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:219
	Result<cv::PaniniWarper*> cv_PaniniWarper_PaniniWarper_float_float(float A, float B) {
		try {
			cv::PaniniWarper* ret = new cv::PaniniWarper(A, B);
			return Ok<cv::PaniniWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PaniniWarper*>))
	}
	
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:223
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_PaniniWarper_create_const_float(const cv::PaniniWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_PlaneWarper_delete(cv::PlaneWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:153
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_PlaneWarper_create_const_float(const cv::PlaneWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_PlaneWarperGpu_delete(cv::PlaneWarperGpu* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:255
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_PlaneWarperGpu_create_const_float(const cv::PlaneWarperGpu* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_PyRotationWarper_delete(cv::PyRotationWarper* instance) {
		delete instance;
	}
	// PyRotationWarper(cv::String, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:55
	Result<cv::PyRotationWarper*> cv_PyRotationWarper_PyRotationWarper_String_float(char* type, float scale) {
		try {
			cv::PyRotationWarper* ret = new cv::PyRotationWarper(std::string(type), scale);
			return Ok<cv::PyRotationWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PyRotationWarper*>))
	}
	
	// PyRotationWarper() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:56
	Result<cv::PyRotationWarper*> cv_PyRotationWarper_PyRotationWarper() {
		try {
			cv::PyRotationWarper* ret = new cv::PyRotationWarper();
			return Ok<cv::PyRotationWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PyRotationWarper*>))
	}
	
	// warpPoint(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:66
	Result<cv::Point2f> cv_PyRotationWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::PyRotationWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPoint(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPointBackward(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:76
	Result<cv::Point2f> cv_PyRotationWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::PyRotationWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPointBackward(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:93
	Result<cv::Rect> cv_PyRotationWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::PyRotationWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:105
	Result<cv::Point> cv_PyRotationWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::PyRotationWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warpBackward(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::Size, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:118
	Result_void cv_PyRotationWarper_warpBackward_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_Size_const__OutputArrayR(cv::PyRotationWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, cv::Size* dst_size, const cv::_OutputArray* dst) {
		try {
			instance->warpBackward(*src, *K, *R, interp_mode, border_mode, *dst_size, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpRoi(cv::Size, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:127
	Result<cv::Rect> cv_PyRotationWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(cv::PyRotationWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Rect ret = instance->warpRoi(*src_size, *K, *R);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// getScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:129
	Result<float> cv_PyRotationWarper_getScale_const(const cv::PyRotationWarper* instance) {
		try {
			float ret = instance->getScale();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setScale(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:130
	Result_void cv_PyRotationWarper_setScale_float(cv::PyRotationWarper* instance, float unnamed) {
		try {
			instance->setScale(unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_SphericalWarper_delete(cv::SphericalWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:178
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_SphericalWarper_create_const_float(const cv::SphericalWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_SphericalWarperGpu_delete(cv::SphericalWarperGpu* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:269
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_SphericalWarperGpu_create_const_float(const cv::SphericalWarperGpu* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_StereographicWarper_delete(cv::StereographicWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:190
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_StereographicWarper_create_const_float(const cv::StereographicWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_Stitcher_delete(cv::Stitcher* instance) {
		delete instance;
	}
	// create(cv::Stitcher::Mode) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:184
	Result<cv::Ptr<cv::Stitcher>*> cv_Stitcher_create_Mode(cv::Stitcher::Mode mode) {
		try {
			cv::Ptr<cv::Stitcher> ret = cv::Stitcher::create(mode);
			return Ok(new cv::Ptr<cv::Stitcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::Stitcher>*>))
	}
	
	// registrationResol() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:186
	Result<double> cv_Stitcher_registrationResol_const(const cv::Stitcher* instance) {
		try {
			double ret = instance->registrationResol();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRegistrationResol(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:187
	Result_void cv_Stitcher_setRegistrationResol_double(cv::Stitcher* instance, double resol_mpx) {
		try {
			instance->setRegistrationResol(resol_mpx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// seamEstimationResol() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:189
	Result<double> cv_Stitcher_seamEstimationResol_const(const cv::Stitcher* instance) {
		try {
			double ret = instance->seamEstimationResol();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSeamEstimationResol(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:190
	Result_void cv_Stitcher_setSeamEstimationResol_double(cv::Stitcher* instance, double resol_mpx) {
		try {
			instance->setSeamEstimationResol(resol_mpx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compositingResol() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:192
	Result<double> cv_Stitcher_compositingResol_const(const cv::Stitcher* instance) {
		try {
			double ret = instance->compositingResol();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setCompositingResol(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:193
	Result_void cv_Stitcher_setCompositingResol_double(cv::Stitcher* instance, double resol_mpx) {
		try {
			instance->setCompositingResol(resol_mpx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// panoConfidenceThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:195
	Result<double> cv_Stitcher_panoConfidenceThresh_const(const cv::Stitcher* instance) {
		try {
			double ret = instance->panoConfidenceThresh();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setPanoConfidenceThresh(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:196
	Result_void cv_Stitcher_setPanoConfidenceThresh_double(cv::Stitcher* instance, double conf_thresh) {
		try {
			instance->setPanoConfidenceThresh(conf_thresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// waveCorrection() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:198
	Result<bool> cv_Stitcher_waveCorrection_const(const cv::Stitcher* instance) {
		try {
			bool ret = instance->waveCorrection();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setWaveCorrection(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:199
	Result_void cv_Stitcher_setWaveCorrection_bool(cv::Stitcher* instance, bool flag) {
		try {
			instance->setWaveCorrection(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// interpolationFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:201
	Result<cv::InterpolationFlags> cv_Stitcher_interpolationFlags_const(const cv::Stitcher* instance) {
		try {
			cv::InterpolationFlags ret = instance->interpolationFlags();
			return Ok<cv::InterpolationFlags>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::InterpolationFlags>))
	}
	
	// setInterpolationFlags(cv::InterpolationFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:202
	Result_void cv_Stitcher_setInterpolationFlags_InterpolationFlags(cv::Stitcher* instance, cv::InterpolationFlags interp_flags) {
		try {
			instance->setInterpolationFlags(interp_flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// waveCorrectKind() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:204
	Result<cv::detail::WaveCorrectKind> cv_Stitcher_waveCorrectKind_const(const cv::Stitcher* instance) {
		try {
			cv::detail::WaveCorrectKind ret = instance->waveCorrectKind();
			return Ok<cv::detail::WaveCorrectKind>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::WaveCorrectKind>))
	}
	
	// setWaveCorrectKind(detail::WaveCorrectKind) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:205
	Result_void cv_Stitcher_setWaveCorrectKind_WaveCorrectKind(cv::Stitcher* instance, cv::detail::WaveCorrectKind kind) {
		try {
			instance->setWaveCorrectKind(kind);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// featuresFinder() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:207
	Result<cv::Ptr<cv::Feature2D>*> cv_Stitcher_featuresFinder(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::Feature2D> ret = instance->featuresFinder();
			return Ok(new cv::Ptr<cv::Feature2D>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::Feature2D>*>))
	}
	
	// featuresFinder() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:208
	Result<const cv::Ptr<cv::Feature2D>*> cv_Stitcher_featuresFinder_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::Feature2D> ret = instance->featuresFinder();
			return Ok(new const cv::Ptr<cv::Feature2D>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::Feature2D>*>))
	}
	
	// setFeaturesFinder(Ptr<cv::Feature2D>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:209
	Result_void cv_Stitcher_setFeaturesFinder_Ptr_Feature2D_(cv::Stitcher* instance, cv::Ptr<cv::Feature2D>* features_finder) {
		try {
			instance->setFeaturesFinder(*features_finder);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// featuresMatcher() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:212
	Result<cv::Ptr<cv::detail::FeaturesMatcher>*> cv_Stitcher_featuresMatcher(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::FeaturesMatcher> ret = instance->featuresMatcher();
			return Ok(new cv::Ptr<cv::detail::FeaturesMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::FeaturesMatcher>*>))
	}
	
	// featuresMatcher() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:213
	Result<const cv::Ptr<cv::detail::FeaturesMatcher>*> cv_Stitcher_featuresMatcher_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::FeaturesMatcher> ret = instance->featuresMatcher();
			return Ok(new const cv::Ptr<cv::detail::FeaturesMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::FeaturesMatcher>*>))
	}
	
	// setFeaturesMatcher(Ptr<detail::FeaturesMatcher>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:214
	Result_void cv_Stitcher_setFeaturesMatcher_Ptr_FeaturesMatcher_(cv::Stitcher* instance, cv::Ptr<cv::detail::FeaturesMatcher>* features_matcher) {
		try {
			instance->setFeaturesMatcher(*features_matcher);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matchingMask() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:217
	Result<const cv::UMat*> cv_Stitcher_matchingMask_const(const cv::Stitcher* instance) {
		try {
			const cv::UMat ret = instance->matchingMask();
			return Ok(new const cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::UMat*>))
	}
	
	// setMatchingMask(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:218
	Result_void cv_Stitcher_setMatchingMask_const_UMatR(cv::Stitcher* instance, const cv::UMat* mask) {
		try {
			instance->setMatchingMask(*mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bundleAdjuster() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:224
	Result<cv::Ptr<cv::detail::BundleAdjusterBase>*> cv_Stitcher_bundleAdjuster(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::BundleAdjusterBase> ret = instance->bundleAdjuster();
			return Ok(new cv::Ptr<cv::detail::BundleAdjusterBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::BundleAdjusterBase>*>))
	}
	
	// bundleAdjuster() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:225
	Result<const cv::Ptr<cv::detail::BundleAdjusterBase>*> cv_Stitcher_bundleAdjuster_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::BundleAdjusterBase> ret = instance->bundleAdjuster();
			return Ok(new const cv::Ptr<cv::detail::BundleAdjusterBase>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::BundleAdjusterBase>*>))
	}
	
	// setBundleAdjuster(Ptr<detail::BundleAdjusterBase>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:226
	Result_void cv_Stitcher_setBundleAdjuster_Ptr_BundleAdjusterBase_(cv::Stitcher* instance, cv::Ptr<cv::detail::BundleAdjusterBase>* bundle_adjuster) {
		try {
			instance->setBundleAdjuster(*bundle_adjuster);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:229
	Result<cv::Ptr<cv::detail::Estimator>*> cv_Stitcher_estimator(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::Estimator> ret = instance->estimator();
			return Ok(new cv::Ptr<cv::detail::Estimator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::Estimator>*>))
	}
	
	// estimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:230
	Result<const cv::Ptr<cv::detail::Estimator>*> cv_Stitcher_estimator_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::Estimator> ret = instance->estimator();
			return Ok(new const cv::Ptr<cv::detail::Estimator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::Estimator>*>))
	}
	
	// setEstimator(Ptr<detail::Estimator>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:231
	Result_void cv_Stitcher_setEstimator_Ptr_Estimator_(cv::Stitcher* instance, cv::Ptr<cv::detail::Estimator>* estimator) {
		try {
			instance->setEstimator(*estimator);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warper() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:234
	Result<cv::Ptr<cv::WarperCreator>*> cv_Stitcher_warper(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::WarperCreator> ret = instance->warper();
			return Ok(new cv::Ptr<cv::WarperCreator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::WarperCreator>*>))
	}
	
	// warper() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:235
	Result<const cv::Ptr<cv::WarperCreator>*> cv_Stitcher_warper_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::WarperCreator> ret = instance->warper();
			return Ok(new const cv::Ptr<cv::WarperCreator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::WarperCreator>*>))
	}
	
	// setWarper(Ptr<cv::WarperCreator>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:236
	Result_void cv_Stitcher_setWarper_Ptr_WarperCreator_(cv::Stitcher* instance, cv::Ptr<cv::WarperCreator>* creator) {
		try {
			instance->setWarper(*creator);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// exposureCompensator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:238
	Result<cv::Ptr<cv::detail::ExposureCompensator>*> cv_Stitcher_exposureCompensator(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::ExposureCompensator> ret = instance->exposureCompensator();
			return Ok(new cv::Ptr<cv::detail::ExposureCompensator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::ExposureCompensator>*>))
	}
	
	// exposureCompensator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:239
	Result<const cv::Ptr<cv::detail::ExposureCompensator>*> cv_Stitcher_exposureCompensator_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::ExposureCompensator> ret = instance->exposureCompensator();
			return Ok(new const cv::Ptr<cv::detail::ExposureCompensator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::ExposureCompensator>*>))
	}
	
	// setExposureCompensator(Ptr<detail::ExposureCompensator>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:240
	Result_void cv_Stitcher_setExposureCompensator_Ptr_ExposureCompensator_(cv::Stitcher* instance, cv::Ptr<cv::detail::ExposureCompensator>* exposure_comp) {
		try {
			instance->setExposureCompensator(*exposure_comp);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// seamFinder() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:243
	Result<cv::Ptr<cv::detail::SeamFinder>*> cv_Stitcher_seamFinder(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::SeamFinder> ret = instance->seamFinder();
			return Ok(new cv::Ptr<cv::detail::SeamFinder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::SeamFinder>*>))
	}
	
	// seamFinder() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:244
	Result<const cv::Ptr<cv::detail::SeamFinder>*> cv_Stitcher_seamFinder_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::SeamFinder> ret = instance->seamFinder();
			return Ok(new const cv::Ptr<cv::detail::SeamFinder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::SeamFinder>*>))
	}
	
	// setSeamFinder(Ptr<detail::SeamFinder>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:245
	Result_void cv_Stitcher_setSeamFinder_Ptr_SeamFinder_(cv::Stitcher* instance, cv::Ptr<cv::detail::SeamFinder>* seam_finder) {
		try {
			instance->setSeamFinder(*seam_finder);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blender() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:247
	Result<cv::Ptr<cv::detail::Blender>*> cv_Stitcher_blender(cv::Stitcher* instance) {
		try {
			cv::Ptr<cv::detail::Blender> ret = instance->blender();
			return Ok(new cv::Ptr<cv::detail::Blender>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::Blender>*>))
	}
	
	// blender() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:248
	Result<const cv::Ptr<cv::detail::Blender>*> cv_Stitcher_blender_const(const cv::Stitcher* instance) {
		try {
			const cv::Ptr<cv::detail::Blender> ret = instance->blender();
			return Ok(new const cv::Ptr<cv::detail::Blender>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Ptr<cv::detail::Blender>*>))
	}
	
	// setBlender(Ptr<detail::Blender>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:249
	Result_void cv_Stitcher_setBlender_Ptr_Blender_(cv::Stitcher* instance, cv::Ptr<cv::detail::Blender>* b) {
		try {
			instance->setBlender(*b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimateTransform(cv::InputArrayOfArrays, cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:260
	Result<cv::Stitcher::Status> cv_Stitcher_estimateTransform_const__InputArrayR_const__InputArrayR(cv::Stitcher* instance, const cv::_InputArray* images, const cv::_InputArray* masks) {
		try {
			cv::Stitcher::Status ret = instance->estimateTransform(*images, *masks);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// setTransform(cv::InputArrayOfArrays, const std::vector<detail::CameraParams> &, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:270
	Result<cv::Stitcher::Status> cv_Stitcher_setTransform_const__InputArrayR_const_vector_CameraParams_R_const_vector_int_R(cv::Stitcher* instance, const cv::_InputArray* images, const std::vector<cv::detail::CameraParams>* cameras, const std::vector<int>* component) {
		try {
			cv::Stitcher::Status ret = instance->setTransform(*images, *cameras, *component);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// setTransform(cv::InputArrayOfArrays, const std::vector<detail::CameraParams> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:274
	Result<cv::Stitcher::Status> cv_Stitcher_setTransform_const__InputArrayR_const_vector_CameraParams_R(cv::Stitcher* instance, const cv::_InputArray* images, const std::vector<cv::detail::CameraParams>* cameras) {
		try {
			cv::Stitcher::Status ret = instance->setTransform(*images, *cameras);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// composePanorama(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:277
	Result<cv::Stitcher::Status> cv_Stitcher_composePanorama_const__OutputArrayR(cv::Stitcher* instance, const cv::_OutputArray* pano) {
		try {
			cv::Stitcher::Status ret = instance->composePanorama(*pano);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// composePanorama(cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:289
	Result<cv::Stitcher::Status> cv_Stitcher_composePanorama_const__InputArrayR_const__OutputArrayR(cv::Stitcher* instance, const cv::_InputArray* images, const cv::_OutputArray* pano) {
		try {
			cv::Stitcher::Status ret = instance->composePanorama(*images, *pano);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// stitch(cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:292
	Result<cv::Stitcher::Status> cv_Stitcher_stitch_const__InputArrayR_const__OutputArrayR(cv::Stitcher* instance, const cv::_InputArray* images, const cv::_OutputArray* pano) {
		try {
			cv::Stitcher::Status ret = instance->stitch(*images, *pano);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// stitch(cv::InputArrayOfArrays, cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:300
	Result<cv::Stitcher::Status> cv_Stitcher_stitch_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::Stitcher* instance, const cv::_InputArray* images, const cv::_InputArray* masks, const cv::_OutputArray* pano) {
		try {
			cv::Stitcher::Status ret = instance->stitch(*images, *masks, *pano);
			return Ok<cv::Stitcher::Status>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Stitcher::Status>))
	}
	
	// component() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:302
	Result<std::vector<int>*> cv_Stitcher_component_const(const cv::Stitcher* instance) {
		try {
			std::vector<int> ret = instance->component();
			return Ok(new std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<int>*>))
	}
	
	// cameras() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:303
	Result<std::vector<cv::detail::CameraParams>*> cv_Stitcher_cameras_const(const cv::Stitcher* instance) {
		try {
			std::vector<cv::detail::CameraParams> ret = instance->cameras();
			return Ok(new std::vector<cv::detail::CameraParams>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::detail::CameraParams>*>))
	}
	
	// workScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:304
	Result<double> cv_Stitcher_workScale_const(const cv::Stitcher* instance) {
		try {
			double ret = instance->workScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// resultMask() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching.hpp:305
	Result<cv::UMat*> cv_Stitcher_resultMask_const(const cv::Stitcher* instance) {
		try {
			cv::UMat ret = instance->resultMask();
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	void cv_TransverseMercatorWarper_delete(cv::TransverseMercatorWarper* instance) {
		delete instance;
	}
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:246
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_TransverseMercatorWarper_create_const_float(const cv::TransverseMercatorWarper* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	// create(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/warpers.hpp:143
	Result<cv::Ptr<cv::detail::RotationWarper>*> cv_WarperCreator_create_const_float(const cv::WarperCreator* instance, float scale) {
		try {
			cv::Ptr<cv::detail::RotationWarper> ret = instance->create(scale);
			return Ok(new cv::Ptr<cv::detail::RotationWarper>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::RotationWarper>*>))
	}
	
	void cv_Detail_AffineBasedEstimator_delete(cv::detail::AffineBasedEstimator* instance) {
		delete instance;
	}
	// AffineBasedEstimator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:124
	Result<cv::detail::AffineBasedEstimator*> cv_detail_AffineBasedEstimator_AffineBasedEstimator() {
		try {
			cv::detail::AffineBasedEstimator* ret = new cv::detail::AffineBasedEstimator();
			return Ok<cv::detail::AffineBasedEstimator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::AffineBasedEstimator*>))
	}
	
	cv::detail::BestOf2NearestMatcher* cv_Detail_AffineBestOf2NearestMatcher_to_Detail_BestOf2NearestMatcher(cv::detail::AffineBestOf2NearestMatcher* instance) {
		return dynamic_cast<cv::detail::BestOf2NearestMatcher*>(instance);
	}
	
	void cv_Detail_AffineBestOf2NearestMatcher_delete(cv::detail::AffineBestOf2NearestMatcher* instance) {
		delete instance;
	}
	// AffineBestOf2NearestMatcher(bool, bool, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:237
	Result<cv::detail::AffineBestOf2NearestMatcher*> cv_detail_AffineBestOf2NearestMatcher_AffineBestOf2NearestMatcher_bool_bool_float_int(bool full_affine, bool try_use_gpu, float match_conf, int num_matches_thresh1) {
		try {
			cv::detail::AffineBestOf2NearestMatcher* ret = new cv::detail::AffineBestOf2NearestMatcher(full_affine, try_use_gpu, match_conf, num_matches_thresh1);
			return Ok<cv::detail::AffineBestOf2NearestMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::AffineBestOf2NearestMatcher*>))
	}
	
	cv::detail::PlaneWarper* cv_Detail_AffineWarper_to_Detail_PlaneWarper(cv::detail::AffineWarper* instance) {
		return dynamic_cast<cv::detail::PlaneWarper*>(instance);
	}
	
	void cv_Detail_AffineWarper_delete(cv::detail::AffineWarper* instance) {
		delete instance;
	}
	// AffineWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:242
	Result<cv::detail::AffineWarper*> cv_detail_AffineWarper_AffineWarper_float(float scale) {
		try {
			cv::detail::AffineWarper* ret = new cv::detail::AffineWarper(scale);
			return Ok<cv::detail::AffineWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::AffineWarper*>))
	}
	
	// warpPoint(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:251
	Result<cv::Point2f> cv_detail_AffineWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::AffineWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* H) {
		try {
			cv::Point2f ret = instance->warpPoint(*pt, *K, *H);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPointBackward(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:260
	Result<cv::Point2f> cv_detail_AffineWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::AffineWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* H) {
		try {
			cv::Point2f ret = instance->warpPointBackward(*pt, *K, *H);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:271
	Result<cv::Rect> cv_detail_AffineWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::AffineWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* H, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *H, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:283
	Result<cv::Point> cv_detail_AffineWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::AffineWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* H, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *H, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warpRoi(cv::Size, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:292
	Result<cv::Rect> cv_detail_AffineWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(cv::detail::AffineWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* H) {
		try {
			cv::Rect ret = instance->warpRoi(*src_size, *K, *H);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	 Result<cv::detail::AffineBestOf2NearestMatcher*> cv_Detail_BestOf2NearestMatcher_to_Detail_AffineBestOf2NearestMatcher(cv::detail::BestOf2NearestMatcher* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::AffineBestOf2NearestMatcher*>(instance));
		} OCVRS_CATCH(Result<cv::detail::AffineBestOf2NearestMatcher*>)
	}
	
	 Result<cv::detail::BestOf2NearestRangeMatcher*> cv_Detail_BestOf2NearestMatcher_to_Detail_BestOf2NearestRangeMatcher(cv::detail::BestOf2NearestMatcher* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::BestOf2NearestRangeMatcher*>(instance));
		} OCVRS_CATCH(Result<cv::detail::BestOf2NearestRangeMatcher*>)
	}
	
	void cv_Detail_BestOf2NearestMatcher_delete(cv::detail::BestOf2NearestMatcher* instance) {
		delete instance;
	}
	// BestOf2NearestMatcher(bool, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:184
	Result<cv::detail::BestOf2NearestMatcher*> cv_detail_BestOf2NearestMatcher_BestOf2NearestMatcher_bool_float_int_int(bool try_use_gpu, float match_conf, int num_matches_thresh1, int num_matches_thresh2) {
		try {
			cv::detail::BestOf2NearestMatcher* ret = new cv::detail::BestOf2NearestMatcher(try_use_gpu, match_conf, num_matches_thresh1, num_matches_thresh2);
			return Ok<cv::detail::BestOf2NearestMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BestOf2NearestMatcher*>))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:187
	Result_void cv_detail_BestOf2NearestMatcher_collectGarbage(cv::detail::BestOf2NearestMatcher* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(bool, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:188
	Result<cv::Ptr<cv::detail::BestOf2NearestMatcher>*> cv_detail_BestOf2NearestMatcher_create_bool_float_int_int(bool try_use_gpu, float match_conf, int num_matches_thresh1, int num_matches_thresh2) {
		try {
			cv::Ptr<cv::detail::BestOf2NearestMatcher> ret = cv::detail::BestOf2NearestMatcher::create(try_use_gpu, match_conf, num_matches_thresh1, num_matches_thresh2);
			return Ok(new cv::Ptr<cv::detail::BestOf2NearestMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::BestOf2NearestMatcher>*>))
	}
	
	cv::detail::BestOf2NearestMatcher* cv_Detail_BestOf2NearestRangeMatcher_to_Detail_BestOf2NearestMatcher(cv::detail::BestOf2NearestRangeMatcher* instance) {
		return dynamic_cast<cv::detail::BestOf2NearestMatcher*>(instance);
	}
	
	void cv_Detail_BestOf2NearestRangeMatcher_delete(cv::detail::BestOf2NearestRangeMatcher* instance) {
		delete instance;
	}
	// BestOf2NearestRangeMatcher(int, bool, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:202
	Result<cv::detail::BestOf2NearestRangeMatcher*> cv_detail_BestOf2NearestRangeMatcher_BestOf2NearestRangeMatcher_int_bool_float_int_int(int range_width, bool try_use_gpu, float match_conf, int num_matches_thresh1, int num_matches_thresh2) {
		try {
			cv::detail::BestOf2NearestRangeMatcher* ret = new cv::detail::BestOf2NearestRangeMatcher(range_width, try_use_gpu, match_conf, num_matches_thresh1, num_matches_thresh2);
			return Ok<cv::detail::BestOf2NearestRangeMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BestOf2NearestRangeMatcher*>))
	}
	
	 Result<cv::detail::FeatherBlender*> cv_Detail_Blender_to_Detail_FeatherBlender(cv::detail::Blender* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::FeatherBlender*>(instance));
		} OCVRS_CATCH(Result<cv::detail::FeatherBlender*>)
	}
	
	 Result<cv::detail::MultiBandBlender*> cv_Detail_Blender_to_Detail_MultiBandBlender(cv::detail::Blender* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::MultiBandBlender*>(instance));
		} OCVRS_CATCH(Result<cv::detail::MultiBandBlender*>)
	}
	
	void cv_Detail_Blender_delete(cv::detail::Blender* instance) {
		delete instance;
	}
	// createDefault(int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:69
	Result<cv::Ptr<cv::detail::Blender>*> cv_detail_Blender_createDefault_int_bool(int type, bool try_gpu) {
		try {
			cv::Ptr<cv::detail::Blender> ret = cv::detail::Blender::createDefault(type, try_gpu);
			return Ok(new cv::Ptr<cv::detail::Blender>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::Blender>*>))
	}
	
	// prepare(const std::vector<Point> &, const std::vector<Size> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:76
	Result_void cv_detail_Blender_prepare_const_vector_Point_R_const_vector_Size_R(cv::detail::Blender* instance, const std::vector<cv::Point>* corners, const std::vector<cv::Size>* sizes) {
		try {
			instance->prepare(*corners, *sizes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// prepare(cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:78
	Result_void cv_detail_Blender_prepare_Rect(cv::detail::Blender* instance, cv::Rect* dst_roi) {
		try {
			instance->prepare(*dst_roi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// feed(cv::InputArray, cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:85
	Result_void cv_detail_Blender_feed_const__InputArrayR_const__InputArrayR_Point(cv::detail::Blender* instance, const cv::_InputArray* img, const cv::_InputArray* mask, cv::Point* tl) {
		try {
			instance->feed(*img, *mask, *tl);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blend(cv::InputOutputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:91
	Result_void cv_detail_Blender_blend_const__InputOutputArrayR_const__InputOutputArrayR(cv::detail::Blender* instance, const cv::_InputOutputArray* dst, const cv::_InputOutputArray* dst_mask) {
		try {
			instance->blend(*dst, *dst_mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_BlocksChannelsCompensator_delete(cv::detail::BlocksChannelsCompensator* instance) {
		delete instance;
	}
	// BlocksChannelsCompensator(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:234
	Result<cv::detail::BlocksChannelsCompensator*> cv_detail_BlocksChannelsCompensator_BlocksChannelsCompensator_int_int_int(int bl_width, int bl_height, int nr_feeds) {
		try {
			cv::detail::BlocksChannelsCompensator* ret = new cv::detail::BlocksChannelsCompensator(bl_width, bl_height, nr_feeds);
			return Ok<cv::detail::BlocksChannelsCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BlocksChannelsCompensator*>))
	}
	
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:175
	Result_void cv_detail_BlocksCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::BlocksCompensator* instance, int index, cv::Point* corner, const cv::_InputOutputArray* image, const cv::_InputArray* mask) {
		try {
			instance->apply(index, *corner, *image, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:176
	Result_void cv_detail_BlocksCompensator_getMatGains_vector_Mat_R(cv::detail::BlocksCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->getMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:177
	Result_void cv_detail_BlocksCompensator_setMatGains_vector_Mat_R(cv::detail::BlocksCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->setMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNrFeeds(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:178
	Result_void cv_detail_BlocksCompensator_setNrFeeds_int(cv::detail::BlocksCompensator* instance, int nr_feeds) {
		try {
			instance->setNrFeeds(nr_feeds);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNrFeeds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:179
	Result<int> cv_detail_BlocksCompensator_getNrFeeds(cv::detail::BlocksCompensator* instance) {
		try {
			int ret = instance->getNrFeeds();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSimilarityThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:180
	Result_void cv_detail_BlocksCompensator_setSimilarityThreshold_double(cv::detail::BlocksCompensator* instance, double similarity_threshold) {
		try {
			instance->setSimilarityThreshold(similarity_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSimilarityThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:181
	Result<double> cv_detail_BlocksCompensator_getSimilarityThreshold_const(const cv::detail::BlocksCompensator* instance) {
		try {
			double ret = instance->getSimilarityThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBlockSize(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:182
	Result_void cv_detail_BlocksCompensator_setBlockSize_int_int(cv::detail::BlocksCompensator* instance, int width, int height) {
		try {
			instance->setBlockSize(width, height);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBlockSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:183
	Result_void cv_detail_BlocksCompensator_setBlockSize_Size(cv::detail::BlocksCompensator* instance, cv::Size* size) {
		try {
			instance->setBlockSize(*size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBlockSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:184
	Result<cv::Size> cv_detail_BlocksCompensator_getBlockSize_const(const cv::detail::BlocksCompensator* instance) {
		try {
			cv::Size ret = instance->getBlockSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setNrGainsFilteringIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:185
	Result_void cv_detail_BlocksCompensator_setNrGainsFilteringIterations_int(cv::detail::BlocksCompensator* instance, int nr_iterations) {
		try {
			instance->setNrGainsFilteringIterations(nr_iterations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNrGainsFilteringIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:186
	Result<int> cv_detail_BlocksCompensator_getNrGainsFilteringIterations_const(const cv::detail::BlocksCompensator* instance) {
		try {
			int ret = instance->getNrGainsFilteringIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_Detail_BlocksGainCompensator_delete(cv::detail::BlocksGainCompensator* instance) {
		delete instance;
	}
	// BlocksGainCompensator(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:211
	Result<cv::detail::BlocksGainCompensator*> cv_detail_BlocksGainCompensator_BlocksGainCompensator_int_int(int bl_width, int bl_height) {
		try {
			cv::detail::BlocksGainCompensator* ret = new cv::detail::BlocksGainCompensator(bl_width, bl_height);
			return Ok<cv::detail::BlocksGainCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BlocksGainCompensator*>))
	}
	
	// BlocksGainCompensator(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:213
	Result<cv::detail::BlocksGainCompensator*> cv_detail_BlocksGainCompensator_BlocksGainCompensator_int_int_int(int bl_width, int bl_height, int nr_feeds) {
		try {
			cv::detail::BlocksGainCompensator* ret = new cv::detail::BlocksGainCompensator(bl_width, bl_height, nr_feeds);
			return Ok<cv::detail::BlocksGainCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BlocksGainCompensator*>))
	}
	
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:220
	Result_void cv_detail_BlocksGainCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::BlocksGainCompensator* instance, int index, cv::Point* corner, const cv::_InputOutputArray* image, const cv::_InputArray* mask) {
		try {
			instance->apply(index, *corner, *image, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:223
	Result_void cv_detail_BlocksGainCompensator_getMatGains_vector_Mat_R(cv::detail::BlocksGainCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->getMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:225
	Result_void cv_detail_BlocksGainCompensator_setMatGains_vector_Mat_R(cv::detail::BlocksGainCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->setMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_BundleAdjusterAffine_delete(cv::detail::BundleAdjusterAffine* instance) {
		delete instance;
	}
	// BundleAdjusterAffine() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:292
	Result<cv::detail::BundleAdjusterAffine*> cv_detail_BundleAdjusterAffine_BundleAdjusterAffine() {
		try {
			cv::detail::BundleAdjusterAffine* ret = new cv::detail::BundleAdjusterAffine();
			return Ok<cv::detail::BundleAdjusterAffine*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BundleAdjusterAffine*>))
	}
	
	void cv_Detail_BundleAdjusterAffinePartial_delete(cv::detail::BundleAdjusterAffinePartial* instance) {
		delete instance;
	}
	// BundleAdjusterAffinePartial() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:316
	Result<cv::detail::BundleAdjusterAffinePartial*> cv_detail_BundleAdjusterAffinePartial_BundleAdjusterAffinePartial() {
		try {
			cv::detail::BundleAdjusterAffinePartial* ret = new cv::detail::BundleAdjusterAffinePartial();
			return Ok<cv::detail::BundleAdjusterAffinePartial*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BundleAdjusterAffinePartial*>))
	}
	
	// refinementMask() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:136
	Result<const cv::Mat*> cv_detail_BundleAdjusterBase_refinementMask_const(const cv::detail::BundleAdjusterBase* instance) {
		try {
			const cv::Mat ret = instance->refinementMask();
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// setRefinementMask(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:137
	Result_void cv_detail_BundleAdjusterBase_setRefinementMask_const_MatR(cv::detail::BundleAdjusterBase* instance, const cv::Mat* mask) {
		try {
			instance->setRefinementMask(*mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// confThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:143
	Result<double> cv_detail_BundleAdjusterBase_confThresh_const(const cv::detail::BundleAdjusterBase* instance) {
		try {
			double ret = instance->confThresh();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setConfThresh(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:144
	Result_void cv_detail_BundleAdjusterBase_setConfThresh_double(cv::detail::BundleAdjusterBase* instance, double conf_thresh) {
		try {
			instance->setConfThresh(conf_thresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// termCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:146
	Result<cv::TermCriteria> cv_detail_BundleAdjusterBase_termCriteria(cv::detail::BundleAdjusterBase* instance) {
		try {
			cv::TermCriteria ret = instance->termCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:147
	Result_void cv_detail_BundleAdjusterBase_setTermCriteria_const_TermCriteriaR(cv::detail::BundleAdjusterBase* instance, const cv::TermCriteria* term_criteria) {
		try {
			instance->setTermCriteria(*term_criteria);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_BundleAdjusterRay_delete(cv::detail::BundleAdjusterRay* instance) {
		delete instance;
	}
	// BundleAdjusterRay() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:268
	Result<cv::detail::BundleAdjusterRay*> cv_detail_BundleAdjusterRay_BundleAdjusterRay() {
		try {
			cv::detail::BundleAdjusterRay* ret = new cv::detail::BundleAdjusterRay();
			return Ok<cv::detail::BundleAdjusterRay*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BundleAdjusterRay*>))
	}
	
	void cv_Detail_BundleAdjusterReproj_delete(cv::detail::BundleAdjusterReproj* instance) {
		delete instance;
	}
	// BundleAdjusterReproj() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:248
	Result<cv::detail::BundleAdjusterReproj*> cv_detail_BundleAdjusterReproj_BundleAdjusterReproj() {
		try {
			cv::detail::BundleAdjusterReproj* ret = new cv::detail::BundleAdjusterReproj();
			return Ok<cv::detail::BundleAdjusterReproj*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::BundleAdjusterReproj*>))
	}
	
	// focal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:65
	double cv_detail_CameraParams_getPropFocal_const(const cv::detail::CameraParams* instance) {
		double ret = instance->focal;
		return (double)ret;
	}
	
	// focal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:65
	void cv_detail_CameraParams_setPropFocal_double(cv::detail::CameraParams* instance, double val) {
		instance->focal = val;
	}
	
	// aspect /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:66
	double cv_detail_CameraParams_getPropAspect_const(const cv::detail::CameraParams* instance) {
		double ret = instance->aspect;
		return (double)ret;
	}
	
	// aspect /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:66
	void cv_detail_CameraParams_setPropAspect_double(cv::detail::CameraParams* instance, double val) {
		instance->aspect = val;
	}
	
	// ppx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:67
	double cv_detail_CameraParams_getPropPpx_const(const cv::detail::CameraParams* instance) {
		double ret = instance->ppx;
		return (double)ret;
	}
	
	// ppx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:67
	void cv_detail_CameraParams_setPropPpx_double(cv::detail::CameraParams* instance, double val) {
		instance->ppx = val;
	}
	
	// ppy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:68
	double cv_detail_CameraParams_getPropPpy_const(const cv::detail::CameraParams* instance) {
		double ret = instance->ppy;
		return (double)ret;
	}
	
	// ppy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:68
	void cv_detail_CameraParams_setPropPpy_double(cv::detail::CameraParams* instance, double val) {
		instance->ppy = val;
	}
	
	// R /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:69
	cv::Mat* cv_detail_CameraParams_getPropR_const(const cv::detail::CameraParams* instance) {
		cv::Mat ret = instance->R;
		return new cv::Mat(ret);
	}
	
	// R /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:69
	void cv_detail_CameraParams_setPropR_Mat(cv::detail::CameraParams* instance, cv::Mat* val) {
		instance->R = *val;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:70
	cv::Mat* cv_detail_CameraParams_getPropT_const(const cv::detail::CameraParams* instance) {
		cv::Mat ret = instance->t;
		return new cv::Mat(ret);
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:70
	void cv_detail_CameraParams_setPropT_Mat(cv::detail::CameraParams* instance, cv::Mat* val) {
		instance->t = *val;
	}
	
	void cv_Detail_CameraParams_delete(cv::detail::CameraParams* instance) {
		delete instance;
	}
	// CameraParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:60
	Result<cv::detail::CameraParams*> cv_detail_CameraParams_CameraParams() {
		try {
			cv::detail::CameraParams* ret = new cv::detail::CameraParams();
			return Ok<cv::detail::CameraParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CameraParams*>))
	}
	
	// CameraParams(const cv::detail::CameraParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:61
	Result<cv::detail::CameraParams*> cv_detail_CameraParams_CameraParams_const_CameraParamsR(const cv::detail::CameraParams* other) {
		try {
			cv::detail::CameraParams* ret = new cv::detail::CameraParams(*other);
			return Ok<cv::detail::CameraParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CameraParams*>))
	}
	
	// K() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/camera.hpp:63
	Result<cv::Mat*> cv_detail_CameraParams_K_const(const cv::detail::CameraParams* instance) {
		try {
			cv::Mat ret = instance->K();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_Detail_ChannelsCompensator_delete(cv::detail::ChannelsCompensator* instance) {
		delete instance;
	}
	// ChannelsCompensator(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:148
	Result<cv::detail::ChannelsCompensator*> cv_detail_ChannelsCompensator_ChannelsCompensator_int(int nr_feeds) {
		try {
			cv::detail::ChannelsCompensator* ret = new cv::detail::ChannelsCompensator(nr_feeds);
			return Ok<cv::detail::ChannelsCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::ChannelsCompensator*>))
	}
	
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:152
	Result_void cv_detail_ChannelsCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::ChannelsCompensator* instance, int index, cv::Point* corner, const cv::_InputOutputArray* image, const cv::_InputArray* mask) {
		try {
			instance->apply(index, *corner, *image, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:153
	Result_void cv_detail_ChannelsCompensator_getMatGains_vector_Mat_R(cv::detail::ChannelsCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->getMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:154
	Result_void cv_detail_ChannelsCompensator_setMatGains_vector_Mat_R(cv::detail::ChannelsCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->setMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNrFeeds(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:155
	Result_void cv_detail_ChannelsCompensator_setNrFeeds_int(cv::detail::ChannelsCompensator* instance, int nr_feeds) {
		try {
			instance->setNrFeeds(nr_feeds);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNrFeeds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:156
	Result<int> cv_detail_ChannelsCompensator_getNrFeeds(cv::detail::ChannelsCompensator* instance) {
		try {
			int ret = instance->getNrFeeds();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSimilarityThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:157
	Result_void cv_detail_ChannelsCompensator_setSimilarityThreshold_double(cv::detail::ChannelsCompensator* instance, double similarity_threshold) {
		try {
			instance->setSimilarityThreshold(similarity_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSimilarityThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:158
	Result<double> cv_detail_ChannelsCompensator_getSimilarityThreshold_const(const cv::detail::ChannelsCompensator* instance) {
		try {
			double ret = instance->getSimilarityThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// gains() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:159
	Result<std::vector<cv::Scalar>*> cv_detail_ChannelsCompensator_gains_const(const cv::detail::ChannelsCompensator* instance) {
		try {
			std::vector<cv::Scalar> ret = instance->gains();
			return Ok(new std::vector<cv::Scalar>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Scalar>*>))
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:411
	float cv_detail_CompressedRectilinearPortraitProjector_getPropA_const(const cv::detail::CompressedRectilinearPortraitProjector* instance) {
		float ret = instance->a;
		return (float)ret;
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:411
	void cv_detail_CompressedRectilinearPortraitProjector_setPropA_float(cv::detail::CompressedRectilinearPortraitProjector* instance, float val) {
		instance->a = val;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:411
	float cv_detail_CompressedRectilinearPortraitProjector_getPropB_const(const cv::detail::CompressedRectilinearPortraitProjector* instance) {
		float ret = instance->b;
		return (float)ret;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:411
	void cv_detail_CompressedRectilinearPortraitProjector_setPropB_float(cv::detail::CompressedRectilinearPortraitProjector* instance, float val) {
		instance->b = val;
	}
	
	cv::detail::ProjectorBase* cv_Detail_CompressedRectilinearPortraitProjector_to_Detail_ProjectorBase(cv::detail::CompressedRectilinearPortraitProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_CompressedRectilinearPortraitProjector_delete(cv::detail::CompressedRectilinearPortraitProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:413
	Result_void cv_detail_CompressedRectilinearPortraitProjector_mapForward_float_float_floatR_floatR(cv::detail::CompressedRectilinearPortraitProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:414
	Result_void cv_detail_CompressedRectilinearPortraitProjector_mapBackward_float_float_floatR_floatR(cv::detail::CompressedRectilinearPortraitProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_CompressedRectilinearPortraitWarper_delete(cv::detail::CompressedRectilinearPortraitWarper* instance) {
		delete instance;
	}
	// CompressedRectilinearPortraitWarper(float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:421
	Result<cv::detail::CompressedRectilinearPortraitWarper*> cv_detail_CompressedRectilinearPortraitWarper_CompressedRectilinearPortraitWarper_float_float_float(float scale, float A, float B) {
		try {
			cv::detail::CompressedRectilinearPortraitWarper* ret = new cv::detail::CompressedRectilinearPortraitWarper(scale, A, B);
			return Ok<cv::detail::CompressedRectilinearPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CompressedRectilinearPortraitWarper*>))
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:390
	float cv_detail_CompressedRectilinearProjector_getPropA_const(const cv::detail::CompressedRectilinearProjector* instance) {
		float ret = instance->a;
		return (float)ret;
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:390
	void cv_detail_CompressedRectilinearProjector_setPropA_float(cv::detail::CompressedRectilinearProjector* instance, float val) {
		instance->a = val;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:390
	float cv_detail_CompressedRectilinearProjector_getPropB_const(const cv::detail::CompressedRectilinearProjector* instance) {
		float ret = instance->b;
		return (float)ret;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:390
	void cv_detail_CompressedRectilinearProjector_setPropB_float(cv::detail::CompressedRectilinearProjector* instance, float val) {
		instance->b = val;
	}
	
	cv::detail::ProjectorBase* cv_Detail_CompressedRectilinearProjector_to_Detail_ProjectorBase(cv::detail::CompressedRectilinearProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_CompressedRectilinearProjector_delete(cv::detail::CompressedRectilinearProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:392
	Result_void cv_detail_CompressedRectilinearProjector_mapForward_float_float_floatR_floatR(cv::detail::CompressedRectilinearProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:393
	Result_void cv_detail_CompressedRectilinearProjector_mapBackward_float_float_floatR_floatR(cv::detail::CompressedRectilinearProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_CompressedRectilinearWarper_delete(cv::detail::CompressedRectilinearWarper* instance) {
		delete instance;
	}
	// CompressedRectilinearWarper(float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:400
	Result<cv::detail::CompressedRectilinearWarper*> cv_detail_CompressedRectilinearWarper_CompressedRectilinearWarper_float_float_float(float scale, float A, float B) {
		try {
			cv::detail::CompressedRectilinearWarper* ret = new cv::detail::CompressedRectilinearWarper(scale, A, B);
			return Ok<cv::detail::CompressedRectilinearWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CompressedRectilinearWarper*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_CylindricalPortraitProjector_to_Detail_ProjectorBase(cv::detail::CylindricalPortraitProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_CylindricalPortraitProjector_delete(cv::detail::CylindricalPortraitProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:639
	Result_void cv_detail_CylindricalPortraitProjector_mapForward_float_float_floatR_floatR(cv::detail::CylindricalPortraitProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:640
	Result_void cv_detail_CylindricalPortraitProjector_mapBackward_float_float_floatR_floatR(cv::detail::CylindricalPortraitProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_CylindricalPortraitWarper_delete(cv::detail::CylindricalPortraitWarper* instance) {
		delete instance;
	}
	// CylindricalPortraitWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:647
	Result<cv::detail::CylindricalPortraitWarper*> cv_detail_CylindricalPortraitWarper_CylindricalPortraitWarper_float(float scale) {
		try {
			cv::detail::CylindricalPortraitWarper* ret = new cv::detail::CylindricalPortraitWarper(scale);
			return Ok<cv::detail::CylindricalPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CylindricalPortraitWarper*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_CylindricalProjector_to_Detail_ProjectorBase(cv::detail::CylindricalProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_CylindricalProjector_delete(cv::detail::CylindricalProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:334
	Result_void cv_detail_CylindricalProjector_mapForward_float_float_floatR_floatR(cv::detail::CylindricalProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:335
	Result_void cv_detail_CylindricalProjector_mapBackward_float_float_floatR_floatR(cv::detail::CylindricalProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	 Result<cv::detail::CylindricalWarperGpu*> cv_Detail_CylindricalWarper_to_Detail_CylindricalWarperGpu(cv::detail::CylindricalWarper* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::CylindricalWarperGpu*>(instance));
		} OCVRS_CATCH(Result<cv::detail::CylindricalWarperGpu*>)
	}
	
	void cv_Detail_CylindricalWarper_delete(cv::detail::CylindricalWarper* instance) {
		delete instance;
	}
	// CylindricalWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:348
	Result<cv::detail::CylindricalWarper*> cv_detail_CylindricalWarper_CylindricalWarper_float(float scale) {
		try {
			cv::detail::CylindricalWarper* ret = new cv::detail::CylindricalWarper(scale);
			return Ok<cv::detail::CylindricalWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CylindricalWarper*>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:350
	Result<cv::Rect> cv_detail_CylindricalWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::CylindricalWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:351
	Result<cv::Point> cv_detail_CylindricalWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::CylindricalWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	cv::detail::CylindricalWarper* cv_Detail_CylindricalWarperGpu_to_Detail_CylindricalWarper(cv::detail::CylindricalWarperGpu* instance) {
		return dynamic_cast<cv::detail::CylindricalWarper*>(instance);
	}
	
	void cv_Detail_CylindricalWarperGpu_delete(cv::detail::CylindricalWarperGpu* instance) {
		delete instance;
	}
	// CylindricalWarperGpu(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:590
	Result<cv::detail::CylindricalWarperGpu*> cv_detail_CylindricalWarperGpu_CylindricalWarperGpu_float(float scale) {
		try {
			cv::detail::CylindricalWarperGpu* ret = new cv::detail::CylindricalWarperGpu(scale);
			return Ok<cv::detail::CylindricalWarperGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::CylindricalWarperGpu*>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:592
	Result<cv::Rect> cv_detail_CylindricalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::CylindricalWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:600
	Result<cv::Point> cv_detail_CylindricalWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::CylindricalWarperGpu* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:609
	Result<cv::Rect> cv_detail_CylindricalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(cv::detail::CylindricalWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(const cuda::GpuMat &, cv::InputArray, cv::InputArray, int, int, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:611
	Result<cv::Point> cv_detail_CylindricalWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(cv::detail::CylindricalWarperGpu* instance, const cv::cuda::GpuMat* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, cv::cuda::GpuMat* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:64
	std::vector<int>* cv_detail_DisjointSets_getPropParent_const(const cv::detail::DisjointSets* instance) {
		std::vector<int> ret = instance->parent;
		return new std::vector<int>(ret);
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:64
	void cv_detail_DisjointSets_setPropParent_vector_int_(cv::detail::DisjointSets* instance, std::vector<int>* val) {
		instance->parent = *val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:65
	std::vector<int>* cv_detail_DisjointSets_getPropSize_const(const cv::detail::DisjointSets* instance) {
		std::vector<int> ret = instance->size;
		return new std::vector<int>(ret);
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:65
	void cv_detail_DisjointSets_setPropSize_vector_int_(cv::detail::DisjointSets* instance, std::vector<int>* val) {
		instance->size = *val;
	}
	
	void cv_Detail_DisjointSets_delete(cv::detail::DisjointSets* instance) {
		delete instance;
	}
	// DisjointSets(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:58
	Result<cv::detail::DisjointSets*> cv_detail_DisjointSets_DisjointSets_int(int elem_count) {
		try {
			cv::detail::DisjointSets* ret = new cv::detail::DisjointSets(elem_count);
			return Ok<cv::detail::DisjointSets*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::DisjointSets*>))
	}
	
	// createOneElemSets(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:60
	Result_void cv_detail_DisjointSets_createOneElemSets_int(cv::detail::DisjointSets* instance, int elem_count) {
		try {
			instance->createOneElemSets(elem_count);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findSetByElem(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:61
	Result<int> cv_detail_DisjointSets_findSetByElem_int(cv::detail::DisjointSets* instance, int elem) {
		try {
			int ret = instance->findSetByElem(elem);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// mergeSets(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:62
	Result<int> cv_detail_DisjointSets_mergeSets_int_int(cv::detail::DisjointSets* instance, int set1, int set2) {
		try {
			int ret = instance->mergeSets(set1, set2);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_Detail_DpSeamFinder_delete(cv::detail::DpSeamFinder* instance) {
		delete instance;
	}
	// DpSeamFinder(cv::detail::DpSeamFinder::CostFunction) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:125
	Result<cv::detail::DpSeamFinder*> cv_detail_DpSeamFinder_DpSeamFinder_CostFunction(cv::detail::DpSeamFinder::CostFunction costFunc) {
		try {
			cv::detail::DpSeamFinder* ret = new cv::detail::DpSeamFinder(costFunc);
			return Ok<cv::detail::DpSeamFinder*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::DpSeamFinder*>))
	}
	
	// DpSeamFinder(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:126
	Result<cv::detail::DpSeamFinder*> cv_detail_DpSeamFinder_DpSeamFinder_String(char* costFunc) {
		try {
			cv::detail::DpSeamFinder* ret = new cv::detail::DpSeamFinder(std::string(costFunc));
			return Ok<cv::detail::DpSeamFinder*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::DpSeamFinder*>))
	}
	
	// costFunction() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:128
	Result<cv::detail::DpSeamFinder::CostFunction> cv_detail_DpSeamFinder_costFunction_const(const cv::detail::DpSeamFinder* instance) {
		try {
			cv::detail::DpSeamFinder::CostFunction ret = instance->costFunction();
			return Ok<cv::detail::DpSeamFinder::CostFunction>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::DpSeamFinder::CostFunction>))
	}
	
	// setCostFunction(cv::detail::DpSeamFinder::CostFunction) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:129
	Result_void cv_detail_DpSeamFinder_setCostFunction_CostFunction(cv::detail::DpSeamFinder* instance, cv::detail::DpSeamFinder::CostFunction val) {
		try {
			instance->setCostFunction(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCostFunction(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:130
	Result_void cv_detail_DpSeamFinder_setCostFunction_String(cv::detail::DpSeamFinder* instance, char* val) {
		try {
			instance->setCostFunction(std::string(val));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:132
	Result_void cv_detail_DpSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::DpSeamFinder* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createDefault(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:67
	Result<cv::Ptr<cv::detail::ExposureCompensator>*> cv_detail_ExposureCompensator_createDefault_int(int type) {
		try {
			cv::Ptr<cv::detail::ExposureCompensator> ret = cv::detail::ExposureCompensator::createDefault(type);
			return Ok(new cv::Ptr<cv::detail::ExposureCompensator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::ExposureCompensator>*>))
	}
	
	// feed(const std::vector<Point> &, const std::vector<UMat> &, const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:75
	Result_void cv_detail_ExposureCompensator_feed_const_vector_Point_R_const_vector_UMat_R_const_vector_UMat_R(cv::detail::ExposureCompensator* instance, const std::vector<cv::Point>* corners, const std::vector<cv::UMat>* images, const std::vector<cv::UMat>* masks) {
		try {
			instance->feed(*corners, *images, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:87
	Result_void cv_detail_ExposureCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::ExposureCompensator* instance, int index, cv::Point* corner, const cv::_InputOutputArray* image, const cv::_InputArray* mask) {
		try {
			instance->apply(index, *corner, *image, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:88
	Result_void cv_detail_ExposureCompensator_getMatGains_vector_Mat_R(cv::detail::ExposureCompensator* instance, std::vector<cv::Mat>* unnamed) {
		try {
			instance->getMatGains(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:89
	Result_void cv_detail_ExposureCompensator_setMatGains_vector_Mat_R(cv::detail::ExposureCompensator* instance, std::vector<cv::Mat>* unnamed) {
		try {
			instance->setMatGains(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUpdateGain(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:90
	Result_void cv_detail_ExposureCompensator_setUpdateGain_bool(cv::detail::ExposureCompensator* instance, bool b) {
		try {
			instance->setUpdateGain(b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUpdateGain() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:91
	Result<bool> cv_detail_ExposureCompensator_getUpdateGain(cv::detail::ExposureCompensator* instance) {
		try {
			bool ret = instance->getUpdateGain();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::detail::Blender* cv_Detail_FeatherBlender_to_Detail_Blender(cv::detail::FeatherBlender* instance) {
		return dynamic_cast<cv::detail::Blender*>(instance);
	}
	
	void cv_Detail_FeatherBlender_delete(cv::detail::FeatherBlender* instance) {
		delete instance;
	}
	// FeatherBlender(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:103
	Result<cv::detail::FeatherBlender*> cv_detail_FeatherBlender_FeatherBlender_float(float sharpness) {
		try {
			cv::detail::FeatherBlender* ret = new cv::detail::FeatherBlender(sharpness);
			return Ok<cv::detail::FeatherBlender*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::FeatherBlender*>))
	}
	
	// sharpness() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:105
	Result<float> cv_detail_FeatherBlender_sharpness_const(const cv::detail::FeatherBlender* instance) {
		try {
			float ret = instance->sharpness();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSharpness(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:106
	Result_void cv_detail_FeatherBlender_setSharpness_float(cv::detail::FeatherBlender* instance, float val) {
		try {
			instance->setSharpness(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// prepare(cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:108
	Result_void cv_detail_FeatherBlender_prepare_Rect(cv::detail::FeatherBlender* instance, cv::Rect* dst_roi) {
		try {
			instance->prepare(*dst_roi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// feed(cv::InputArray, cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:109
	Result_void cv_detail_FeatherBlender_feed_const__InputArrayR_const__InputArrayR_Point(cv::detail::FeatherBlender* instance, const cv::_InputArray* img, const cv::_InputArray* mask, cv::Point* tl) {
		try {
			instance->feed(*img, *mask, *tl);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blend(cv::InputOutputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:110
	Result_void cv_detail_FeatherBlender_blend_const__InputOutputArrayR_const__InputOutputArrayR(cv::detail::FeatherBlender* instance, const cv::_InputOutputArray* dst, const cv::_InputOutputArray* dst_mask) {
		try {
			instance->blend(*dst, *dst_mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createWeightMaps(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:114
	Result<cv::Rect> cv_detail_FeatherBlender_createWeightMaps_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::FeatherBlender* instance, const std::vector<cv::UMat>* masks, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* weight_maps) {
		try {
			cv::Rect ret = instance->createWeightMaps(*masks, *corners, *weight_maps);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// isThreadSafe() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:145
	Result<bool> cv_detail_FeaturesMatcher_isThreadSafe_const(const cv::detail::FeaturesMatcher* instance) {
		try {
			bool ret = instance->isThreadSafe();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:149
	Result_void cv_detail_FeaturesMatcher_collectGarbage(cv::detail::FeaturesMatcher* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::detail::ProjectorBase* cv_Detail_FisheyeProjector_to_Detail_ProjectorBase(cv::detail::FisheyeProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_FisheyeProjector_delete(cv::detail::FisheyeProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:362
	Result_void cv_detail_FisheyeProjector_mapForward_float_float_floatR_floatR(cv::detail::FisheyeProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:363
	Result_void cv_detail_FisheyeProjector_mapBackward_float_float_floatR_floatR(cv::detail::FisheyeProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_FisheyeWarper_delete(cv::detail::FisheyeWarper* instance) {
		delete instance;
	}
	// FisheyeWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:370
	Result<cv::detail::FisheyeWarper*> cv_detail_FisheyeWarper_FisheyeWarper_float(float scale) {
		try {
			cv::detail::FisheyeWarper* ret = new cv::detail::FisheyeWarper(scale);
			return Ok<cv::detail::FisheyeWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::FisheyeWarper*>))
	}
	
	void cv_Detail_GainCompensator_delete(cv::detail::GainCompensator* instance) {
		delete instance;
	}
	// GainCompensator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:115
	Result<cv::detail::GainCompensator*> cv_detail_GainCompensator_GainCompensator() {
		try {
			cv::detail::GainCompensator* ret = new cv::detail::GainCompensator();
			return Ok<cv::detail::GainCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GainCompensator*>))
	}
	
	// GainCompensator(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:117
	Result<cv::detail::GainCompensator*> cv_detail_GainCompensator_GainCompensator_int(int nr_feeds) {
		try {
			cv::detail::GainCompensator* ret = new cv::detail::GainCompensator(nr_feeds);
			return Ok<cv::detail::GainCompensator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GainCompensator*>))
	}
	
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:123
	Result_void cv_detail_GainCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::GainCompensator* instance, int index, cv::Point* corner, const cv::_InputOutputArray* image, const cv::_InputArray* mask) {
		try {
			instance->apply(index, *corner, *image, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:124
	Result_void cv_detail_GainCompensator_getMatGains_vector_Mat_R(cv::detail::GainCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->getMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:125
	Result_void cv_detail_GainCompensator_setMatGains_vector_Mat_R(cv::detail::GainCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->setMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNrFeeds(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:126
	Result_void cv_detail_GainCompensator_setNrFeeds_int(cv::detail::GainCompensator* instance, int nr_feeds) {
		try {
			instance->setNrFeeds(nr_feeds);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNrFeeds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:127
	Result<int> cv_detail_GainCompensator_getNrFeeds(cv::detail::GainCompensator* instance) {
		try {
			int ret = instance->getNrFeeds();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSimilarityThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:128
	Result_void cv_detail_GainCompensator_setSimilarityThreshold_double(cv::detail::GainCompensator* instance, double similarity_threshold) {
		try {
			instance->setSimilarityThreshold(similarity_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSimilarityThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:129
	Result<double> cv_detail_GainCompensator_getSimilarityThreshold_const(const cv::detail::GainCompensator* instance) {
		try {
			double ret = instance->getSimilarityThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// prepareSimilarityMask(const std::vector<Point> &, const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:130
	Result_void cv_detail_GainCompensator_prepareSimilarityMask_const_vector_Point_R_const_vector_UMat_R(cv::detail::GainCompensator* instance, const std::vector<cv::Point>* corners, const std::vector<cv::UMat>* images) {
		try {
			instance->prepareSimilarityMask(*corners, *images);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// gains() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:131
	Result<std::vector<double>*> cv_detail_GainCompensator_gains_const(const cv::detail::GainCompensator* instance) {
		try {
			std::vector<double> ret = instance->gains();
			return Ok(new std::vector<double>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<double>*>))
	}
	
	void cv_Detail_Graph_delete(cv::detail::Graph* instance) {
		delete instance;
	}
	// Graph(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:88
	Result<cv::detail::Graph*> cv_detail_Graph_Graph_int(int num_vertices) {
		try {
			cv::detail::Graph* ret = new cv::detail::Graph(num_vertices);
			return Ok<cv::detail::Graph*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::Graph*>))
	}
	
	// create(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:89
	Result_void cv_detail_Graph_create_int(cv::detail::Graph* instance, int num_vertices) {
		try {
			instance->create(num_vertices);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// numVertices() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:90
	Result<int> cv_detail_Graph_numVertices_const(const cv::detail::Graph* instance) {
		try {
			int ret = instance->numVertices();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addEdge(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:91
	Result_void cv_detail_Graph_addEdge_int_int_float(cv::detail::Graph* instance, int from, int to, float weight) {
		try {
			instance->addEdge(from, to, weight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::detail::GraphCutSeamFinderBase* cv_Detail_GraphCutSeamFinder_to_Detail_GraphCutSeamFinderBase(cv::detail::GraphCutSeamFinder* instance) {
		return dynamic_cast<cv::detail::GraphCutSeamFinderBase*>(instance);
	}
	
	void cv_Detail_GraphCutSeamFinder_delete(cv::detail::GraphCutSeamFinder* instance) {
		delete instance;
	}
	// GraphCutSeamFinder(int, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:243
	Result<cv::detail::GraphCutSeamFinder*> cv_detail_GraphCutSeamFinder_GraphCutSeamFinder_int_float_float(int cost_type, float terminal_cost, float bad_region_penalty) {
		try {
			cv::detail::GraphCutSeamFinder* ret = new cv::detail::GraphCutSeamFinder(cost_type, terminal_cost, bad_region_penalty);
			return Ok<cv::detail::GraphCutSeamFinder*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GraphCutSeamFinder*>))
	}
	
	// GraphCutSeamFinder(cv::String, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:245
	Result<cv::detail::GraphCutSeamFinder*> cv_detail_GraphCutSeamFinder_GraphCutSeamFinder_String_float_float(char* cost_type, float terminal_cost, float bad_region_penalty) {
		try {
			cv::detail::GraphCutSeamFinder* ret = new cv::detail::GraphCutSeamFinder(std::string(cost_type), terminal_cost, bad_region_penalty);
			return Ok<cv::detail::GraphCutSeamFinder*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GraphCutSeamFinder*>))
	}
	
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:250
	Result_void cv_detail_GraphCutSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::GraphCutSeamFinder* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_GraphCutSeamFinderBase_delete(cv::detail::GraphCutSeamFinderBase* instance) {
		delete instance;
	}
	cv::detail::GraphCutSeamFinderBase* cv_Detail_GraphCutSeamFinderGpu_to_Detail_GraphCutSeamFinderBase(cv::detail::GraphCutSeamFinderGpu* instance) {
		return dynamic_cast<cv::detail::GraphCutSeamFinderBase*>(instance);
	}
	
	void cv_Detail_GraphCutSeamFinderGpu_delete(cv::detail::GraphCutSeamFinderGpu* instance) {
		delete instance;
	}
	// GraphCutSeamFinderGpu(int, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:264
	Result<cv::detail::GraphCutSeamFinderGpu*> cv_detail_GraphCutSeamFinderGpu_GraphCutSeamFinderGpu_int_float_float(int cost_type, float terminal_cost, float bad_region_penalty) {
		try {
			cv::detail::GraphCutSeamFinderGpu* ret = new cv::detail::GraphCutSeamFinderGpu(cost_type, terminal_cost, bad_region_penalty);
			return Ok<cv::detail::GraphCutSeamFinderGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GraphCutSeamFinderGpu*>))
	}
	
	// find(const std::vector<cv::UMat> &, const std::vector<cv::Point> &, std::vector<cv::UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:269
	Result_void cv_detail_GraphCutSeamFinderGpu_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::GraphCutSeamFinderGpu* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findInPair(size_t, size_t, cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:271
	Result_void cv_detail_GraphCutSeamFinderGpu_findInPair_size_t_size_t_Rect(cv::detail::GraphCutSeamFinderGpu* instance, size_t first, size_t second, cv::Rect* roi) {
		try {
			instance->findInPair(first, second, *roi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// from /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:78
	int cv_detail_GraphEdge_getPropFrom_const(const cv::detail::GraphEdge* instance) {
		int ret = instance->from;
		return (int)ret;
	}
	
	// from /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:78
	void cv_detail_GraphEdge_setPropFrom_int(cv::detail::GraphEdge* instance, int val) {
		instance->from = val;
	}
	
	// to /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:78
	int cv_detail_GraphEdge_getPropTo_const(const cv::detail::GraphEdge* instance) {
		int ret = instance->to;
		return (int)ret;
	}
	
	// to /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:78
	void cv_detail_GraphEdge_setPropTo_int(cv::detail::GraphEdge* instance, int val) {
		instance->to = val;
	}
	
	// weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:79
	float cv_detail_GraphEdge_getPropWeight_const(const cv::detail::GraphEdge* instance) {
		float ret = instance->weight;
		return (float)ret;
	}
	
	// weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:79
	void cv_detail_GraphEdge_setPropWeight_float(cv::detail::GraphEdge* instance, float val) {
		instance->weight = val;
	}
	
	void cv_Detail_GraphEdge_delete(cv::detail::GraphEdge* instance) {
		delete instance;
	}
	// GraphEdge(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/util.hpp:74
	Result<cv::detail::GraphEdge*> cv_detail_GraphEdge_GraphEdge_int_int_float(int from, int to, float weight) {
		try {
			cv::detail::GraphEdge* ret = new cv::detail::GraphEdge(from, to, weight);
			return Ok<cv::detail::GraphEdge*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::GraphEdge*>))
	}
	
	void cv_Detail_HomographyBasedEstimator_delete(cv::detail::HomographyBasedEstimator* instance) {
		delete instance;
	}
	// HomographyBasedEstimator(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:103
	Result<cv::detail::HomographyBasedEstimator*> cv_detail_HomographyBasedEstimator_HomographyBasedEstimator_bool(bool is_focals_estimated) {
		try {
			cv::detail::HomographyBasedEstimator* ret = new cv::detail::HomographyBasedEstimator(is_focals_estimated);
			return Ok<cv::detail::HomographyBasedEstimator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::HomographyBasedEstimator*>))
	}
	
	// img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:60
	int cv_detail_ImageFeatures_getPropImg_idx_const(const cv::detail::ImageFeatures* instance) {
		int ret = instance->img_idx;
		return (int)ret;
	}
	
	// img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:60
	void cv_detail_ImageFeatures_setPropImg_idx_int(cv::detail::ImageFeatures* instance, int val) {
		instance->img_idx = val;
	}
	
	// img_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:61
	cv::Size cv_detail_ImageFeatures_getPropImg_size_const(const cv::detail::ImageFeatures* instance) {
		cv::Size ret = instance->img_size;
		return (cv::Size)ret;
	}
	
	// img_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:61
	void cv_detail_ImageFeatures_setPropImg_size_Size(cv::detail::ImageFeatures* instance, cv::Size* val) {
		instance->img_size = *val;
	}
	
	// keypoints /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:62
	std::vector<cv::KeyPoint>* cv_detail_ImageFeatures_getPropKeypoints_const(const cv::detail::ImageFeatures* instance) {
		std::vector<cv::KeyPoint> ret = instance->keypoints;
		return new std::vector<cv::KeyPoint>(ret);
	}
	
	// keypoints /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:62
	void cv_detail_ImageFeatures_setPropKeypoints_vector_KeyPoint_(cv::detail::ImageFeatures* instance, std::vector<cv::KeyPoint>* val) {
		instance->keypoints = *val;
	}
	
	// descriptors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:63
	cv::UMat* cv_detail_ImageFeatures_getPropDescriptors_const(const cv::detail::ImageFeatures* instance) {
		cv::UMat ret = instance->descriptors;
		return new cv::UMat(ret);
	}
	
	// descriptors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:63
	void cv_detail_ImageFeatures_setPropDescriptors_UMat(cv::detail::ImageFeatures* instance, cv::UMat* val) {
		instance->descriptors = *val;
	}
	
	void cv_Detail_ImageFeatures_delete(cv::detail::ImageFeatures* instance) {
		delete instance;
	}
	// getKeypoints() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:64
	Result<std::vector<cv::KeyPoint>*> cv_detail_ImageFeatures_getKeypoints(cv::detail::ImageFeatures* instance) {
		try {
			std::vector<cv::KeyPoint> ret = instance->getKeypoints();
			return Ok(new std::vector<cv::KeyPoint>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::KeyPoint>*>))
	}
	
	// src_img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:105
	int cv_detail_MatchesInfo_getPropSrc_img_idx_const(const cv::detail::MatchesInfo* instance) {
		int ret = instance->src_img_idx;
		return (int)ret;
	}
	
	// src_img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:105
	void cv_detail_MatchesInfo_setPropSrc_img_idx_int(cv::detail::MatchesInfo* instance, int val) {
		instance->src_img_idx = val;
	}
	
	// dst_img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:106
	int cv_detail_MatchesInfo_getPropDst_img_idx_const(const cv::detail::MatchesInfo* instance) {
		int ret = instance->dst_img_idx;
		return (int)ret;
	}
	
	// dst_img_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:106
	void cv_detail_MatchesInfo_setPropDst_img_idx_int(cv::detail::MatchesInfo* instance, int val) {
		instance->dst_img_idx = val;
	}
	
	// matches /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:107
	std::vector<cv::DMatch>* cv_detail_MatchesInfo_getPropMatches_const(const cv::detail::MatchesInfo* instance) {
		std::vector<cv::DMatch> ret = instance->matches;
		return new std::vector<cv::DMatch>(ret);
	}
	
	// matches /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:107
	void cv_detail_MatchesInfo_setPropMatches_vector_DMatch_(cv::detail::MatchesInfo* instance, std::vector<cv::DMatch>* val) {
		instance->matches = *val;
	}
	
	// inliers_mask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:108
	std::vector<unsigned char>* cv_detail_MatchesInfo_getPropInliers_mask_const(const cv::detail::MatchesInfo* instance) {
		std::vector<unsigned char> ret = instance->inliers_mask;
		return new std::vector<unsigned char>(ret);
	}
	
	// inliers_mask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:108
	void cv_detail_MatchesInfo_setPropInliers_mask_vector_unsigned_char_(cv::detail::MatchesInfo* instance, std::vector<unsigned char>* val) {
		instance->inliers_mask = *val;
	}
	
	// num_inliers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:109
	int cv_detail_MatchesInfo_getPropNum_inliers_const(const cv::detail::MatchesInfo* instance) {
		int ret = instance->num_inliers;
		return (int)ret;
	}
	
	// num_inliers /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:109
	void cv_detail_MatchesInfo_setPropNum_inliers_int(cv::detail::MatchesInfo* instance, int val) {
		instance->num_inliers = val;
	}
	
	// H /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:110
	cv::Mat* cv_detail_MatchesInfo_getPropH_const(const cv::detail::MatchesInfo* instance) {
		cv::Mat ret = instance->H;
		return new cv::Mat(ret);
	}
	
	// H /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:110
	void cv_detail_MatchesInfo_setPropH_Mat(cv::detail::MatchesInfo* instance, cv::Mat* val) {
		instance->H = *val;
	}
	
	// confidence /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:111
	double cv_detail_MatchesInfo_getPropConfidence_const(const cv::detail::MatchesInfo* instance) {
		double ret = instance->confidence;
		return (double)ret;
	}
	
	// confidence /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:111
	void cv_detail_MatchesInfo_setPropConfidence_double(cv::detail::MatchesInfo* instance, double val) {
		instance->confidence = val;
	}
	
	void cv_Detail_MatchesInfo_delete(cv::detail::MatchesInfo* instance) {
		delete instance;
	}
	// MatchesInfo() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:101
	Result<cv::detail::MatchesInfo*> cv_detail_MatchesInfo_MatchesInfo() {
		try {
			cv::detail::MatchesInfo* ret = new cv::detail::MatchesInfo();
			return Ok<cv::detail::MatchesInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::MatchesInfo*>))
	}
	
	// MatchesInfo(const cv::detail::MatchesInfo &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:102
	Result<cv::detail::MatchesInfo*> cv_detail_MatchesInfo_MatchesInfo_const_MatchesInfoR(const cv::detail::MatchesInfo* other) {
		try {
			cv::detail::MatchesInfo* ret = new cv::detail::MatchesInfo(*other);
			return Ok<cv::detail::MatchesInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::MatchesInfo*>))
	}
	
	// getMatches() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:112
	Result<std::vector<cv::DMatch>*> cv_detail_MatchesInfo_getMatches(cv::detail::MatchesInfo* instance) {
		try {
			std::vector<cv::DMatch> ret = instance->getMatches();
			return Ok(new std::vector<cv::DMatch>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::DMatch>*>))
	}
	
	// getInliers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/matchers.hpp:113
	Result<std::vector<unsigned char>*> cv_detail_MatchesInfo_getInliers(cv::detail::MatchesInfo* instance) {
		try {
			std::vector<unsigned char> ret = instance->getInliers();
			return Ok(new std::vector<unsigned char>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<unsigned char>*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_MercatorProjector_to_Detail_ProjectorBase(cv::detail::MercatorProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_MercatorProjector_delete(cv::detail::MercatorProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:475
	Result_void cv_detail_MercatorProjector_mapForward_float_float_floatR_floatR(cv::detail::MercatorProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:476
	Result_void cv_detail_MercatorProjector_mapBackward_float_float_floatR_floatR(cv::detail::MercatorProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_MercatorWarper_delete(cv::detail::MercatorWarper* instance) {
		delete instance;
	}
	// MercatorWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:483
	Result<cv::detail::MercatorWarper*> cv_detail_MercatorWarper_MercatorWarper_float(float scale) {
		try {
			cv::detail::MercatorWarper* ret = new cv::detail::MercatorWarper(scale);
			return Ok<cv::detail::MercatorWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::MercatorWarper*>))
	}
	
	cv::detail::Blender* cv_Detail_MultiBandBlender_to_Detail_Blender(cv::detail::MultiBandBlender* instance) {
		return dynamic_cast<cv::detail::Blender*>(instance);
	}
	
	void cv_Detail_MultiBandBlender_delete(cv::detail::MultiBandBlender* instance) {
		delete instance;
	}
	// MultiBandBlender(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:130
	Result<cv::detail::MultiBandBlender*> cv_detail_MultiBandBlender_MultiBandBlender_int_int_int(int try_gpu, int num_bands, int weight_type) {
		try {
			cv::detail::MultiBandBlender* ret = new cv::detail::MultiBandBlender(try_gpu, num_bands, weight_type);
			return Ok<cv::detail::MultiBandBlender*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::MultiBandBlender*>))
	}
	
	// numBands() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:132
	Result<int> cv_detail_MultiBandBlender_numBands_const(const cv::detail::MultiBandBlender* instance) {
		try {
			int ret = instance->numBands();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumBands(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:133
	Result_void cv_detail_MultiBandBlender_setNumBands_int(cv::detail::MultiBandBlender* instance, int val) {
		try {
			instance->setNumBands(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// prepare(cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:135
	Result_void cv_detail_MultiBandBlender_prepare_Rect(cv::detail::MultiBandBlender* instance, cv::Rect* dst_roi) {
		try {
			instance->prepare(*dst_roi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// feed(cv::InputArray, cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:136
	Result_void cv_detail_MultiBandBlender_feed_const__InputArrayR_const__InputArrayR_Point(cv::detail::MultiBandBlender* instance, const cv::_InputArray* img, const cv::_InputArray* mask, cv::Point* tl) {
		try {
			instance->feed(*img, *mask, *tl);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blend(cv::InputOutputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/blenders.hpp:137
	Result_void cv_detail_MultiBandBlender_blend_const__InputOutputArrayR_const__InputOutputArrayR(cv::detail::MultiBandBlender* instance, const cv::_InputOutputArray* dst, const cv::_InputOutputArray* dst_mask) {
		try {
			instance->blend(*dst, *dst_mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_NoBundleAdjuster_delete(cv::detail::NoBundleAdjuster* instance) {
		delete instance;
	}
	// NoBundleAdjuster() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/motion_estimators.hpp:224
	Result<cv::detail::NoBundleAdjuster*> cv_detail_NoBundleAdjuster_NoBundleAdjuster() {
		try {
			cv::detail::NoBundleAdjuster* ret = new cv::detail::NoBundleAdjuster();
			return Ok<cv::detail::NoBundleAdjuster*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::NoBundleAdjuster*>))
	}
	
	void cv_Detail_NoExposureCompensator_delete(cv::detail::NoExposureCompensator* instance) {
		delete instance;
	}
	// apply(int, cv::Point, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:103
	Result_void cv_detail_NoExposureCompensator_apply_int_Point_const__InputOutputArrayR_const__InputArrayR(cv::detail::NoExposureCompensator* instance, int unnamed, cv::Point* unnamed_1, const cv::_InputOutputArray* unnamed_2, const cv::_InputArray* unnamed_3) {
		try {
			instance->apply(unnamed, *unnamed_1, *unnamed_2, *unnamed_3);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:104
	Result_void cv_detail_NoExposureCompensator_getMatGains_vector_Mat_R(cv::detail::NoExposureCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->getMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMatGains(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/exposure_compensate.hpp:105
	Result_void cv_detail_NoExposureCompensator_setMatGains_vector_Mat_R(cv::detail::NoExposureCompensator* instance, std::vector<cv::Mat>* umv) {
		try {
			instance->setMatGains(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_NoSeamFinder_delete(cv::detail::NoSeamFinder* instance) {
		delete instance;
	}
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:79
	Result_void cv_detail_NoSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::NoSeamFinder* instance, const std::vector<cv::UMat>* unnamed, const std::vector<cv::Point>* unnamed_1, std::vector<cv::UMat>* unnamed_2) {
		try {
			instance->find(*unnamed, *unnamed_1, *unnamed_2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:87
	Result_void cv_detail_PairwiseSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::PairwiseSeamFinder* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:453
	float cv_detail_PaniniPortraitProjector_getPropA_const(const cv::detail::PaniniPortraitProjector* instance) {
		float ret = instance->a;
		return (float)ret;
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:453
	void cv_detail_PaniniPortraitProjector_setPropA_float(cv::detail::PaniniPortraitProjector* instance, float val) {
		instance->a = val;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:453
	float cv_detail_PaniniPortraitProjector_getPropB_const(const cv::detail::PaniniPortraitProjector* instance) {
		float ret = instance->b;
		return (float)ret;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:453
	void cv_detail_PaniniPortraitProjector_setPropB_float(cv::detail::PaniniPortraitProjector* instance, float val) {
		instance->b = val;
	}
	
	cv::detail::ProjectorBase* cv_Detail_PaniniPortraitProjector_to_Detail_ProjectorBase(cv::detail::PaniniPortraitProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_PaniniPortraitProjector_delete(cv::detail::PaniniPortraitProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:455
	Result_void cv_detail_PaniniPortraitProjector_mapForward_float_float_floatR_floatR(cv::detail::PaniniPortraitProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:456
	Result_void cv_detail_PaniniPortraitProjector_mapBackward_float_float_floatR_floatR(cv::detail::PaniniPortraitProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_PaniniPortraitWarper_delete(cv::detail::PaniniPortraitWarper* instance) {
		delete instance;
	}
	// PaniniPortraitWarper(float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:463
	Result<cv::detail::PaniniPortraitWarper*> cv_detail_PaniniPortraitWarper_PaniniPortraitWarper_float_float_float(float scale, float A, float B) {
		try {
			cv::detail::PaniniPortraitWarper* ret = new cv::detail::PaniniPortraitWarper(scale, A, B);
			return Ok<cv::detail::PaniniPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::PaniniPortraitWarper*>))
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:432
	float cv_detail_PaniniProjector_getPropA_const(const cv::detail::PaniniProjector* instance) {
		float ret = instance->a;
		return (float)ret;
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:432
	void cv_detail_PaniniProjector_setPropA_float(cv::detail::PaniniProjector* instance, float val) {
		instance->a = val;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:432
	float cv_detail_PaniniProjector_getPropB_const(const cv::detail::PaniniProjector* instance) {
		float ret = instance->b;
		return (float)ret;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:432
	void cv_detail_PaniniProjector_setPropB_float(cv::detail::PaniniProjector* instance, float val) {
		instance->b = val;
	}
	
	cv::detail::ProjectorBase* cv_Detail_PaniniProjector_to_Detail_ProjectorBase(cv::detail::PaniniProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_PaniniProjector_delete(cv::detail::PaniniProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:434
	Result_void cv_detail_PaniniProjector_mapForward_float_float_floatR_floatR(cv::detail::PaniniProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:435
	Result_void cv_detail_PaniniProjector_mapBackward_float_float_floatR_floatR(cv::detail::PaniniProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_PaniniWarper_delete(cv::detail::PaniniWarper* instance) {
		delete instance;
	}
	// PaniniWarper(float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:442
	Result<cv::detail::PaniniWarper*> cv_detail_PaniniWarper_PaniniWarper_float_float_float(float scale, float A, float B) {
		try {
			cv::detail::PaniniWarper* ret = new cv::detail::PaniniWarper(scale, A, B);
			return Ok<cv::detail::PaniniWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::PaniniWarper*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_PlanePortraitProjector_to_Detail_ProjectorBase(cv::detail::PlanePortraitProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_PlanePortraitProjector_delete(cv::detail::PlanePortraitProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:658
	Result_void cv_detail_PlanePortraitProjector_mapForward_float_float_floatR_floatR(cv::detail::PlanePortraitProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:659
	Result_void cv_detail_PlanePortraitProjector_mapBackward_float_float_floatR_floatR(cv::detail::PlanePortraitProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_PlanePortraitWarper_delete(cv::detail::PlanePortraitWarper* instance) {
		delete instance;
	}
	// PlanePortraitWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:666
	Result<cv::detail::PlanePortraitWarper*> cv_detail_PlanePortraitWarper_PlanePortraitWarper_float(float scale) {
		try {
			cv::detail::PlanePortraitWarper* ret = new cv::detail::PlanePortraitWarper(scale);
			return Ok<cv::detail::PlanePortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::PlanePortraitWarper*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_PlaneProjector_to_Detail_ProjectorBase(cv::detail::PlaneProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_PlaneProjector_delete(cv::detail::PlaneProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:193
	Result_void cv_detail_PlaneProjector_mapForward_float_float_floatR_floatR(cv::detail::PlaneProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:194
	Result_void cv_detail_PlaneProjector_mapBackward_float_float_floatR_floatR(cv::detail::PlaneProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	 Result<cv::detail::AffineWarper*> cv_Detail_PlaneWarper_to_Detail_AffineWarper(cv::detail::PlaneWarper* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::AffineWarper*>(instance));
		} OCVRS_CATCH(Result<cv::detail::AffineWarper*>)
	}
	
	 Result<cv::detail::PlaneWarperGpu*> cv_Detail_PlaneWarper_to_Detail_PlaneWarperGpu(cv::detail::PlaneWarper* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::PlaneWarperGpu*>(instance));
		} OCVRS_CATCH(Result<cv::detail::PlaneWarperGpu*>)
	}
	
	void cv_Detail_PlaneWarper_delete(cv::detail::PlaneWarper* instance) {
		delete instance;
	}
	// PlaneWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:206
	Result<cv::detail::PlaneWarper*> cv_detail_PlaneWarper_PlaneWarper_float(float scale) {
		try {
			cv::detail::PlaneWarper* ret = new cv::detail::PlaneWarper(scale);
			return Ok<cv::detail::PlaneWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::PlaneWarper*>))
	}
	
	// warpPoint(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:208
	Result<cv::Point2f> cv_detail_PlaneWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPoint(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPoint(const cv::Point2f &, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:209
	Result<cv::Point2f> cv_detail_PlaneWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T) {
		try {
			cv::Point2f ret = instance->warpPoint(*pt, *K, *R, *T);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPointBackward(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:211
	Result<cv::Point2f> cv_detail_PlaneWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPointBackward(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPointBackward(const cv::Point2f &, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:212
	Result<cv::Point2f> cv_detail_PlaneWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T) {
		try {
			cv::Point2f ret = instance->warpPointBackward(*pt, *K, *R, *T);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:214
	Result<cv::Rect> cv_detail_PlaneWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::PlaneWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *T, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:215
	Result<cv::Rect> cv_detail_PlaneWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::PlaneWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:217
	Result<cv::Point> cv_detail_PlaneWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::PlaneWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:219
	Result<cv::Point> cv_detail_PlaneWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::PlaneWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, *T, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warpRoi(cv::Size, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:222
	Result<cv::Rect> cv_detail_PlaneWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Rect ret = instance->warpRoi(*src_size, *K, *R);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warpRoi(cv::Size, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:223
	Result<cv::Rect> cv_detail_PlaneWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR(cv::detail::PlaneWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T) {
		try {
			cv::Rect ret = instance->warpRoi(*src_size, *K, *R, *T);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	cv::detail::PlaneWarper* cv_Detail_PlaneWarperGpu_to_Detail_PlaneWarper(cv::detail::PlaneWarperGpu* instance) {
		return dynamic_cast<cv::detail::PlaneWarper*>(instance);
	}
	
	void cv_Detail_PlaneWarperGpu_delete(cv::detail::PlaneWarperGpu* instance) {
		delete instance;
	}
	// PlaneWarperGpu(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:504
	Result<cv::detail::PlaneWarperGpu*> cv_detail_PlaneWarperGpu_PlaneWarperGpu_float(float scale) {
		try {
			cv::detail::PlaneWarperGpu* ret = new cv::detail::PlaneWarperGpu(scale);
			return Ok<cv::detail::PlaneWarperGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::PlaneWarperGpu*>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:506
	Result<cv::Rect> cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::PlaneWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:514
	Result<cv::Rect> cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::PlaneWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *T, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:522
	Result<cv::Point> cv_detail_PlaneWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::PlaneWarperGpu* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:531
	Result<cv::Point> cv_detail_PlaneWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::PlaneWarperGpu* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, *T, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:540
	Result<cv::Rect> cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(cv::detail::PlaneWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::InputArray, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:542
	Result<cv::Rect> cv_detail_PlaneWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(cv::detail::PlaneWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *T, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(const cuda::GpuMat &, cv::InputArray, cv::InputArray, int, int, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:544
	Result<cv::Point> cv_detail_PlaneWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(cv::detail::PlaneWarperGpu* instance, const cv::cuda::GpuMat* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, cv::cuda::GpuMat* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warp(const cuda::GpuMat &, cv::InputArray, cv::InputArray, cv::InputArray, int, int, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:547
	Result<cv::Point> cv_detail_PlaneWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(cv::detail::PlaneWarperGpu* instance, const cv::cuda::GpuMat* src, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T, int interp_mode, int border_mode, cv::cuda::GpuMat* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, *T, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:147
	float cv_detail_ProjectorBase_getPropScale_const(const cv::detail::ProjectorBase* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:147
	void cv_detail_ProjectorBase_setPropScale_float(cv::detail::ProjectorBase* instance, float val) {
		instance->scale = val;
	}
	
	// k /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:148
	float** cv_detail_ProjectorBase_getPropK(cv::detail::ProjectorBase* instance) {
		float(*ret)[9] = &instance->k;
		return (float**)ret;
	}
	
	// rinv /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:149
	float** cv_detail_ProjectorBase_getPropRinv(cv::detail::ProjectorBase* instance) {
		float(*ret)[9] = &instance->rinv;
		return (float**)ret;
	}
	
	// r_kinv /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:150
	float** cv_detail_ProjectorBase_getPropR_kinv(cv::detail::ProjectorBase* instance) {
		float(*ret)[9] = &instance->r_kinv;
		return (float**)ret;
	}
	
	// k_rinv /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:151
	float** cv_detail_ProjectorBase_getPropK_rinv(cv::detail::ProjectorBase* instance) {
		float(*ret)[9] = &instance->k_rinv;
		return (float**)ret;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:152
	float** cv_detail_ProjectorBase_getPropT(cv::detail::ProjectorBase* instance) {
		float(*ret)[3] = &instance->t;
		return (float**)ret;
	}
	
	void cv_Detail_ProjectorBase_delete(cv::detail::ProjectorBase* instance) {
		delete instance;
	}
	// setCameraParams(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:143
	Result_void cv_detail_ProjectorBase_setCameraParams_const__InputArrayR_const__InputArrayR_const__InputArrayR(cv::detail::ProjectorBase* instance, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* T) {
		try {
			instance->setCameraParams(*K, *R, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPoint(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:71
	Result<cv::Point2f> cv_detail_RotationWarper_warpPoint_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::RotationWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPoint(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// warpPointBackward(const cv::Point2f &, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:81
	Result<cv::Point2f> cv_detail_RotationWarper_warpPointBackward_const_Point2fR_const__InputArrayR_const__InputArrayR(cv::detail::RotationWarper* instance, const cv::Point2f* pt, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Point2f ret = instance->warpPointBackward(*pt, *K, *R);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:99
	Result<cv::Rect> cv_detail_RotationWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::RotationWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:111
	Result<cv::Point> cv_detail_RotationWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::RotationWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// warpBackward(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::Size, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:124
	Result_void cv_detail_RotationWarper_warpBackward_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_Size_const__OutputArrayR(cv::detail::RotationWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, cv::Size* dst_size, const cv::_OutputArray* dst) {
		try {
			instance->warpBackward(*src, *K, *R, interp_mode, border_mode, *dst_size, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpRoi(cv::Size, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:133
	Result<cv::Rect> cv_detail_RotationWarper_warpRoi_Size_const__InputArrayR_const__InputArrayR(cv::detail::RotationWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R) {
		try {
			cv::Rect ret = instance->warpRoi(*src_size, *K, *R);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// getScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:135
	Result<float> cv_detail_RotationWarper_getScale_const(const cv::detail::RotationWarper* instance) {
		try {
			float ret = instance->getScale();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setScale(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:136
	Result_void cv_detail_RotationWarper_setScale_float(cv::detail::RotationWarper* instance, float unnamed) {
		try {
			instance->setScale(unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:69
	Result_void cv_detail_SeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::SeamFinder* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createDefault(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:71
	Result<cv::Ptr<cv::detail::SeamFinder>*> cv_detail_SeamFinder_createDefault_int(int type) {
		try {
			cv::Ptr<cv::detail::SeamFinder> ret = cv::detail::SeamFinder::createDefault(type);
			return Ok(new cv::Ptr<cv::detail::SeamFinder>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::detail::SeamFinder>*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_SphericalPortraitProjector_to_Detail_ProjectorBase(cv::detail::SphericalPortraitProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_SphericalPortraitProjector_delete(cv::detail::SphericalPortraitProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:621
	Result_void cv_detail_SphericalPortraitProjector_mapForward_float_float_floatR_floatR(cv::detail::SphericalPortraitProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:622
	Result_void cv_detail_SphericalPortraitProjector_mapBackward_float_float_floatR_floatR(cv::detail::SphericalPortraitProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_SphericalPortraitWarper_delete(cv::detail::SphericalPortraitWarper* instance) {
		delete instance;
	}
	// SphericalPortraitWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:631
	Result<cv::detail::SphericalPortraitWarper*> cv_detail_SphericalPortraitWarper_SphericalPortraitWarper_float(float scale) {
		try {
			cv::detail::SphericalPortraitWarper* ret = new cv::detail::SphericalPortraitWarper(scale);
			return Ok<cv::detail::SphericalPortraitWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::SphericalPortraitWarper*>))
	}
	
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:304
	Result_void cv_detail_SphericalProjector_mapForward_float_float_floatR_floatR(cv::detail::SphericalProjector instance, float x, float y, float* u, float* v) {
		try {
			instance.mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:305
	Result_void cv_detail_SphericalProjector_mapBackward_float_float_floatR_floatR(cv::detail::SphericalProjector instance, float u, float v, float* x, float* y) {
		try {
			instance.mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	 Result<cv::detail::SphericalWarperGpu*> cv_Detail_SphericalWarper_to_Detail_SphericalWarperGpu(cv::detail::SphericalWarper* instance) {
		try {
			return Ok(dynamic_cast<cv::detail::SphericalWarperGpu*>(instance));
		} OCVRS_CATCH(Result<cv::detail::SphericalWarperGpu*>)
	}
	
	void cv_Detail_SphericalWarper_delete(cv::detail::SphericalWarper* instance) {
		delete instance;
	}
	// SphericalWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:323
	Result<cv::detail::SphericalWarper*> cv_detail_SphericalWarper_SphericalWarper_float(float scale) {
		try {
			cv::detail::SphericalWarper* ret = new cv::detail::SphericalWarper(scale);
			return Ok<cv::detail::SphericalWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::SphericalWarper*>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:325
	Result<cv::Rect> cv_detail_SphericalWarper_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::SphericalWarper* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:326
	Result<cv::Point> cv_detail_SphericalWarper_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::SphericalWarper* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	cv::detail::SphericalWarper* cv_Detail_SphericalWarperGpu_to_Detail_SphericalWarper(cv::detail::SphericalWarperGpu* instance) {
		return dynamic_cast<cv::detail::SphericalWarper*>(instance);
	}
	
	void cv_Detail_SphericalWarperGpu_delete(cv::detail::SphericalWarperGpu* instance) {
		delete instance;
	}
	// SphericalWarperGpu(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:558
	Result<cv::detail::SphericalWarperGpu*> cv_detail_SphericalWarperGpu_SphericalWarperGpu_float(float scale) {
		try {
			cv::detail::SphericalWarperGpu* ret = new cv::detail::SphericalWarperGpu(scale);
			return Ok<cv::detail::SphericalWarperGpu*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::SphericalWarperGpu*>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:560
	Result<cv::Rect> cv_detail_SphericalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::detail::SphericalWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(cv::InputArray, cv::InputArray, cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:568
	Result<cv::Point> cv_detail_SphericalWarperGpu_warp_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_const__OutputArrayR(cv::detail::SphericalWarperGpu* instance, const cv::_InputArray* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, const cv::_OutputArray* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// buildMaps(cv::Size, cv::InputArray, cv::InputArray, cuda::GpuMat &, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:577
	Result<cv::Rect> cv_detail_SphericalWarperGpu_buildMaps_Size_const__InputArrayR_const__InputArrayR_GpuMatR_GpuMatR(cv::detail::SphericalWarperGpu* instance, cv::Size* src_size, const cv::_InputArray* K, const cv::_InputArray* R, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap) {
		try {
			cv::Rect ret = instance->buildMaps(*src_size, *K, *R, *xmap, *ymap);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// warp(const cuda::GpuMat &, cv::InputArray, cv::InputArray, int, int, cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:579
	Result<cv::Point> cv_detail_SphericalWarperGpu_warp_const_GpuMatR_const__InputArrayR_const__InputArrayR_int_int_GpuMatR(cv::detail::SphericalWarperGpu* instance, const cv::cuda::GpuMat* src, const cv::_InputArray* K, const cv::_InputArray* R, int interp_mode, int border_mode, cv::cuda::GpuMat* dst) {
		try {
			cv::Point ret = instance->warp(*src, *K, *R, interp_mode, border_mode, *dst);
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_StereographicProjector_to_Detail_ProjectorBase(cv::detail::StereographicProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_StereographicProjector_delete(cv::detail::StereographicProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:376
	Result_void cv_detail_StereographicProjector_mapForward_float_float_floatR_floatR(cv::detail::StereographicProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:377
	Result_void cv_detail_StereographicProjector_mapBackward_float_float_floatR_floatR(cv::detail::StereographicProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_StereographicWarper_delete(cv::detail::StereographicWarper* instance) {
		delete instance;
	}
	// StereographicWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:384
	Result<cv::detail::StereographicWarper*> cv_detail_StereographicWarper_StereographicWarper_float(float scale) {
		try {
			cv::detail::StereographicWarper* ret = new cv::detail::StereographicWarper(scale);
			return Ok<cv::detail::StereographicWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::StereographicWarper*>))
	}
	
	cv::detail::ProjectorBase* cv_Detail_TransverseMercatorProjector_to_Detail_ProjectorBase(cv::detail::TransverseMercatorProjector* instance) {
		return dynamic_cast<cv::detail::ProjectorBase*>(instance);
	}
	
	void cv_Detail_TransverseMercatorProjector_delete(cv::detail::TransverseMercatorProjector* instance) {
		delete instance;
	}
	// mapForward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:489
	Result_void cv_detail_TransverseMercatorProjector_mapForward_float_float_floatR_floatR(cv::detail::TransverseMercatorProjector* instance, float x, float y, float* u, float* v) {
		try {
			instance->mapForward(x, y, *u, *v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapBackward(float, float, float &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:490
	Result_void cv_detail_TransverseMercatorProjector_mapBackward_float_float_floatR_floatR(cv::detail::TransverseMercatorProjector* instance, float u, float v, float* x, float* y) {
		try {
			instance->mapBackward(u, v, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Detail_TransverseMercatorWarper_delete(cv::detail::TransverseMercatorWarper* instance) {
		delete instance;
	}
	// TransverseMercatorWarper(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/warpers.hpp:497
	Result<cv::detail::TransverseMercatorWarper*> cv_detail_TransverseMercatorWarper_TransverseMercatorWarper_float(float scale) {
		try {
			cv::detail::TransverseMercatorWarper* ret = new cv::detail::TransverseMercatorWarper(scale);
			return Ok<cv::detail::TransverseMercatorWarper*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::detail::TransverseMercatorWarper*>))
	}
	
	void cv_Detail_VoronoiSeamFinder_delete(cv::detail::VoronoiSeamFinder* instance) {
		delete instance;
	}
	// find(const std::vector<UMat> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:111
	Result_void cv_detail_VoronoiSeamFinder_find_const_vector_UMat_R_const_vector_Point_R_vector_UMat_R(cv::detail::VoronoiSeamFinder* instance, const std::vector<cv::UMat>* src, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*src, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// find(const std::vector<Size> &, const std::vector<Point> &, std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/stitching/detail/seam_finders.hpp:113
	Result_void cv_detail_VoronoiSeamFinder_find_const_vector_Size_R_const_vector_Point_R_vector_UMat_R(cv::detail::VoronoiSeamFinder* instance, const std::vector<cv::Size>* size, const std::vector<cv::Point>* corners, std::vector<cv::UMat>* masks) {
		try {
			instance->find(*size, *corners, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
