#include "sfm.hpp"
#include "sfm_types.hpp"

extern "C" {
	// KRtFromProjection(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/projection.hpp:88
	Result_void cv_sfm_KRtFromProjection_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* P, const cv::_OutputArray* K, const cv::_OutputArray* R, const cv::_OutputArray* t) {
		try {
			cv::sfm::KRtFromProjection(*P, *K, *R, *t);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// applyTransformationToPoints(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/conditioning.hpp:82
	Result_void cv_sfm_applyTransformationToPoints_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_InputArray* T, const cv::_OutputArray* transformed_points) {
		try {
			cv::sfm::applyTransformationToPoints(*points, *T, *transformed_points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeOrientation(cv::InputArrayOfArrays, cv::InputArrayOfArrays, cv::OutputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:212
	Result_void cv_sfm_computeOrientation_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double(const cv::_InputArray* x1, const cv::_InputArray* x2, const cv::_OutputArray* R, const cv::_OutputArray* t, double s) {
		try {
			cv::sfm::computeOrientation(*x1, *x2, *R, *t, s);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// depth(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/projection.hpp:97
	Result<double> cv_sfm_depth_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* R, const cv::_InputArray* t, const cv::_InputArray* X) {
		try {
			double ret = cv::sfm::depth(*R, *t, *X);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// essentialFromFundamental(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:167
	Result_void cv_sfm_essentialFromFundamental_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* F, const cv::_InputArray* K1, const cv::_InputArray* K2, const cv::_OutputArray* E) {
		try {
			cv::sfm::essentialFromFundamental(*F, *K1, *K2, *E);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// essentialFromRt(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:183
	Result_void cv_sfm_essentialFromRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* R1, const cv::_InputArray* t1, const cv::_InputArray* R2, const cv::_InputArray* t2, const cv::_OutputArray* E) {
		try {
			cv::sfm::essentialFromRt(*R1, *t1, *R2, *t2, *E);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// euclideanToHomogeneous(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/projection.hpp:63
	Result_void cv_sfm_euclideanToHomogeneous_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::sfm::euclideanToHomogeneous(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fundamentalFromCorrespondences7PointRobust(cv::InputArray, cv::InputArray, double, cv::OutputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/robust.hpp:90
	Result<double> cv_sfm_fundamentalFromCorrespondences7PointRobust_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR_const__OutputArrayR_double(const cv::_InputArray* x1, const cv::_InputArray* x2, double max_error, const cv::_OutputArray* F, const cv::_OutputArray* inliers, double outliers_probability) {
		try {
			double ret = cv::sfm::fundamentalFromCorrespondences7PointRobust(*x1, *x2, max_error, *F, *inliers, outliers_probability);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// fundamentalFromCorrespondences8PointRobust(cv::InputArray, cv::InputArray, double, cv::OutputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/robust.hpp:67
	Result<double> cv_sfm_fundamentalFromCorrespondences8PointRobust_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR_const__OutputArrayR_double(const cv::_InputArray* x1, const cv::_InputArray* x2, double max_error, const cv::_OutputArray* F, const cv::_OutputArray* inliers, double outliers_probability) {
		try {
			double ret = cv::sfm::fundamentalFromCorrespondences8PointRobust(*x1, *x2, max_error, *F, *inliers, outliers_probability);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// fundamentalFromEssential(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:152
	Result_void cv_sfm_fundamentalFromEssential_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* E, const cv::_InputArray* K1, const cv::_InputArray* K2, const cv::_OutputArray* F) {
		try {
			cv::sfm::fundamentalFromEssential(*E, *K1, *K2, *F);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fundamentalFromProjections(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:69
	Result_void cv_sfm_fundamentalFromProjections_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* P1, const cv::_InputArray* P2, const cv::_OutputArray* F) {
		try {
			cv::sfm::fundamentalFromProjections(*P1, *P2, *F);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// homogeneousToEuclidean(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/projection.hpp:55
	Result_void cv_sfm_homogeneousToEuclidean_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::sfm::homogeneousToEuclidean(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// importReconstruction(const cv::String &, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/io.hpp:77
	Result_void cv_sfm_importReconstruction_const_StringR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(const char* file, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_OutputArray* Ks, const cv::_OutputArray* points3d, int file_format) {
		try {
			cv::sfm::importReconstruction(std::string(file), *Rs, *Ts, *Ks, *points3d, file_format);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isotropicPreconditionerFromPoints(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/conditioning.hpp:72
	Result_void cv_sfm_isotropicPreconditionerFromPoints_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_OutputArray* T) {
		try {
			cv::sfm::isotropicPreconditionerFromPoints(*points, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// meanAndVarianceAlongRows(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/numeric.hpp:58
	Result_void cv_sfm_meanAndVarianceAlongRows_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* A, const cv::_OutputArray* mean, const cv::_OutputArray* variance) {
		try {
			cv::sfm::meanAndVarianceAlongRows(*A, *mean, *variance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// motionFromEssentialChooseSolution(cv::InputArrayOfArrays, cv::InputArrayOfArrays, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:135
	Result<int> cv_sfm_motionFromEssentialChooseSolution_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* Rs, const cv::_InputArray* ts, const cv::_InputArray* K1, const cv::_InputArray* x1, const cv::_InputArray* K2, const cv::_InputArray* x2) {
		try {
			int ret = cv::sfm::motionFromEssentialChooseSolution(*Rs, *ts, *K1, *x1, *K2, *x2);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// motionFromEssential(cv::InputArray, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:117
	Result_void cv_sfm_motionFromEssential_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* E, const cv::_OutputArray* Rs, const cv::_OutputArray* ts) {
		try {
			cv::sfm::motionFromEssential(*E, *Rs, *ts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// normalizeFundamental(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:197
	Result_void cv_sfm_normalizeFundamental_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* F, const cv::_OutputArray* F_normalized) {
		try {
			cv::sfm::normalizeFundamental(*F, *F_normalized);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// normalizeIsotropicPoints(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/conditioning.hpp:112
	Result_void cv_sfm_normalizeIsotropicPoints_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_OutputArray* normalized_points, const cv::_OutputArray* T) {
		try {
			cv::sfm::normalizeIsotropicPoints(*points, *normalized_points, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// normalizePoints(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/conditioning.hpp:97
	Result_void cv_sfm_normalizePoints_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_OutputArray* normalized_points, const cv::_OutputArray* T) {
		try {
			cv::sfm::normalizePoints(*points, *normalized_points, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// normalizedEightPointSolver(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:83
	Result_void cv_sfm_normalizedEightPointSolver_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* x1, const cv::_InputArray* x2, const cv::_OutputArray* F) {
		try {
			cv::sfm::normalizedEightPointSolver(*x1, *x2, *F);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// preconditionerFromPoints(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/conditioning.hpp:59
	Result_void cv_sfm_preconditionerFromPoints_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_OutputArray* T) {
		try {
			cv::sfm::preconditionerFromPoints(*points, *T);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// projectionFromKRt(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/projection.hpp:76
	Result_void cv_sfm_projectionFromKRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* K, const cv::_InputArray* R, const cv::_InputArray* t, const cv::_OutputArray* P) {
		try {
			cv::sfm::projectionFromKRt(*K, *R, *t, *P);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// projectionsFromFundamental(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:58
	Result_void cv_sfm_projectionsFromFundamental_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* F, const cv::_OutputArray* P1, const cv::_OutputArray* P2) {
		try {
			cv::sfm::projectionsFromFundamental(*F, *P1, *P2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reconstruct(cv::InputArrayOfArrays, cv::OutputArray, cv::OutputArray, cv::InputOutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/reconstruct.hpp:74
	Result_void cv_sfm_reconstruct_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_bool(const cv::_InputArray* points2d, const cv::_OutputArray* Ps, const cv::_OutputArray* points3d, const cv::_InputOutputArray* K, bool is_projective) {
		try {
			cv::sfm::reconstruct(*points2d, *Ps, *points3d, *K, is_projective);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reconstruct(cv::InputArrayOfArrays, cv::OutputArray, cv::OutputArray, cv::InputOutputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/reconstruct.hpp:93
	Result_void cv_sfm_reconstruct_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_const__OutputArrayR_bool(const cv::_InputArray* points2d, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_InputOutputArray* K, const cv::_OutputArray* points3d, bool is_projective) {
		try {
			cv::sfm::reconstruct(*points2d, *Rs, *Ts, *K, *points3d, is_projective);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reconstruct(const std::vector<String>, cv::OutputArray, cv::OutputArray, cv::InputOutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/reconstruct.hpp:111
	Result_void cv_sfm_reconstruct_const_vector_String__const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_bool(const std::vector<cv::String>* images, const cv::_OutputArray* Ps, const cv::_OutputArray* points3d, const cv::_InputOutputArray* K, bool is_projective) {
		try {
			cv::sfm::reconstruct(*images, *Ps, *points3d, *K, is_projective);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reconstruct(const std::vector<String>, cv::OutputArray, cv::OutputArray, cv::InputOutputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/reconstruct.hpp:131
	Result_void cv_sfm_reconstruct_const_vector_String__const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR_const__OutputArrayR_bool(const std::vector<cv::String>* images, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_InputOutputArray* K, const cv::_OutputArray* points3d, bool is_projective) {
		try {
			cv::sfm::reconstruct(*images, *Rs, *Ts, *K, *points3d, is_projective);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// relativeCameraMotion(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/fundamental.hpp:101
	Result_void cv_sfm_relativeCameraMotion_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* R1, const cv::_InputArray* t1, const cv::_InputArray* R2, const cv::_InputArray* t2, const cv::_OutputArray* R, const cv::_OutputArray* t) {
		try {
			cv::sfm::relativeCameraMotion(*R1, *t1, *R2, *t2, *R, *t);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// skew(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/numeric.hpp:69
	Result<cv::Mat*> cv_sfm_skew_const__InputArrayR(const cv::_InputArray* x) {
		try {
			cv::Mat ret = cv::sfm::skew(*x);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// triangulatePoints(cv::InputArrayOfArrays, cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/triangulation.hpp:59
	Result_void cv_sfm_triangulatePoints_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* points2d, const cv::_InputArray* projection_matrices, const cv::_OutputArray* points3d) {
		try {
			cv::sfm::triangulatePoints(*points2d, *projection_matrices, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:167
	Result_void cv_sfm_BaseSFM_run_const__InputArrayR(cv::sfm::BaseSFM* instance, const cv::_InputArray* points2d) {
		try {
			instance->run(*points2d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArrayOfArrays, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:170
	Result_void cv_sfm_BaseSFM_run_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::sfm::BaseSFM* instance, const cv::_InputArray* points2d, const cv::_InputOutputArray* K, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_OutputArray* points3d) {
		try {
			instance->run(*points2d, *K, *Rs, *Ts, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:173
	Result_void cv_sfm_BaseSFM_run_const_vector_String_R(cv::sfm::BaseSFM* instance, const std::vector<cv::String>* images) {
		try {
			instance->run(*images);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const std::vector<String> &, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:174
	Result_void cv_sfm_BaseSFM_run_const_vector_String_R_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::sfm::BaseSFM* instance, const std::vector<cv::String>* images, const cv::_InputOutputArray* K, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_OutputArray* points3d) {
		try {
			instance->run(*images, *K, *Rs, *Ts, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getError() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:177
	Result<double> cv_sfm_BaseSFM_getError_const(const cv::sfm::BaseSFM* instance) {
		try {
			double ret = instance->getError();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:178
	Result_void cv_sfm_BaseSFM_getPoints_const__OutputArrayR(cv::sfm::BaseSFM* instance, const cv::_OutputArray* points3d) {
		try {
			instance->getPoints(*points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIntrinsics() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:179
	Result<cv::Mat*> cv_sfm_BaseSFM_getIntrinsics_const(const cv::sfm::BaseSFM* instance) {
		try {
			cv::Mat ret = instance->getIntrinsics();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCameras(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:180
	Result_void cv_sfm_BaseSFM_getCameras_const__OutputArrayR_const__OutputArrayR(cv::sfm::BaseSFM* instance, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts) {
		try {
			instance->getCameras(*Rs, *Ts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setReconstructionOptions(const cv::sfm::libmv_ReconstructionOptions &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:184
	Result_void cv_sfm_BaseSFM_setReconstructionOptions_const_libmv_ReconstructionOptionsR(cv::sfm::BaseSFM* instance, const cv::sfm::libmv_ReconstructionOptions* libmv_reconstruction_options) {
		try {
			instance->setReconstructionOptions(*libmv_reconstruction_options);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCameraIntrinsicOptions(const cv::sfm::libmv_CameraIntrinsicsOptions &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:188
	Result_void cv_sfm_BaseSFM_setCameraIntrinsicOptions_const_libmv_CameraIntrinsicsOptionsR(cv::sfm::BaseSFM* instance, const cv::sfm::libmv_CameraIntrinsicsOptions* libmv_camera_intrinsics_options) {
		try {
			instance->setCameraIntrinsicOptions(*libmv_camera_intrinsics_options);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:203
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_run_const__InputArrayR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::_InputArray* points2d) {
		try {
			instance->run(*points2d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArrayOfArrays, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:216
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_run_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::_InputArray* points2d, const cv::_InputOutputArray* K, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_OutputArray* points3d) {
		try {
			instance->run(*points2d, *K, *Rs, *Ts, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:226
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_run_const_vector_String_R(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const std::vector<cv::String>* images) {
		try {
			instance->run(*images);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(const std::vector<String> &, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:239
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_run_const_vector_String_R_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const std::vector<cv::String>* images, const cv::_InputOutputArray* K, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts, const cv::_OutputArray* points3d) {
		try {
			instance->run(*images, *K, *Rs, *Ts, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getError() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:245
	Result<double> cv_sfm_SFMLibmvEuclideanReconstruction_getError_const(const cv::sfm::SFMLibmvEuclideanReconstruction* instance) {
		try {
			double ret = instance->getError();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:251
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_getPoints_const__OutputArrayR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::_OutputArray* points3d) {
		try {
			instance->getPoints(*points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIntrinsics() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:256
	Result<cv::Mat*> cv_sfm_SFMLibmvEuclideanReconstruction_getIntrinsics_const(const cv::sfm::SFMLibmvEuclideanReconstruction* instance) {
		try {
			cv::Mat ret = instance->getIntrinsics();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCameras(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:263
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_getCameras_const__OutputArrayR_const__OutputArrayR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::_OutputArray* Rs, const cv::_OutputArray* Ts) {
		try {
			instance->getCameras(*Rs, *Ts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setReconstructionOptions(const cv::sfm::libmv_ReconstructionOptions &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:271
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_setReconstructionOptions_const_libmv_ReconstructionOptionsR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::sfm::libmv_ReconstructionOptions* libmv_reconstruction_options) {
		try {
			instance->setReconstructionOptions(*libmv_reconstruction_options);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCameraIntrinsicOptions(const cv::sfm::libmv_CameraIntrinsicsOptions &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:279
	Result_void cv_sfm_SFMLibmvEuclideanReconstruction_setCameraIntrinsicOptions_const_libmv_CameraIntrinsicsOptionsR(cv::sfm::SFMLibmvEuclideanReconstruction* instance, const cv::sfm::libmv_CameraIntrinsicsOptions* libmv_camera_intrinsics_options) {
		try {
			instance->setCameraIntrinsicOptions(*libmv_camera_intrinsics_options);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const cv::sfm::libmv_CameraIntrinsicsOptions &, const cv::sfm::libmv_ReconstructionOptions &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:283
	Result<cv::Ptr<cv::sfm::SFMLibmvEuclideanReconstruction>*> cv_sfm_SFMLibmvEuclideanReconstruction_create_const_libmv_CameraIntrinsicsOptionsR_const_libmv_ReconstructionOptionsR(const cv::sfm::libmv_CameraIntrinsicsOptions* camera_instrinsic_options, const cv::sfm::libmv_ReconstructionOptions* reconstruction_options) {
		try {
			cv::Ptr<cv::sfm::SFMLibmvEuclideanReconstruction> ret = cv::sfm::SFMLibmvEuclideanReconstruction::create(*camera_instrinsic_options, *reconstruction_options);
			return Ok(new cv::Ptr<cv::sfm::SFMLibmvEuclideanReconstruction>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::sfm::SFMLibmvEuclideanReconstruction>*>))
	}
	
	// libmv_CameraIntrinsicsOptions(const int, const double, const double, const double, const double, const double, const double, const double, const double, const double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:76
	Result<cv::sfm::libmv_CameraIntrinsicsOptions> cv_sfm_libmv_CameraIntrinsicsOptions_libmv_CameraIntrinsicsOptions_const_int_const_double_const_double_const_double_const_double_const_double_const_double_const_double_const_double_const_double(const int _distortion_model, const double _focal_length_x, const double _focal_length_y, const double _principal_point_x, const double _principal_point_y, const double _polynomial_k1, const double _polynomial_k2, const double _polynomial_k3, const double _polynomial_p1, const double _polynomial_p2) {
		try {
			cv::sfm::libmv_CameraIntrinsicsOptions ret(_distortion_model, _focal_length_x, _focal_length_y, _principal_point_x, _principal_point_y, _polynomial_k1, _polynomial_k2, _polynomial_k3, _polynomial_p1, _polynomial_p2);
			return Ok<cv::sfm::libmv_CameraIntrinsicsOptions>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::sfm::libmv_CameraIntrinsicsOptions>))
	}
	
	// libmv_ReconstructionOptions(const int, const int, const int, const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/sfm/simple_pipeline.hpp:142
	Result<cv::sfm::libmv_ReconstructionOptions> cv_sfm_libmv_ReconstructionOptions_libmv_ReconstructionOptions_const_int_const_int_const_int_const_int_const_int(const int _keyframe1, const int _keyframe2, const int _refine_intrinsics, const int _select_keyframes, const int _verbosity_level) {
		try {
			cv::sfm::libmv_ReconstructionOptions ret(_keyframe1, _keyframe2, _refine_intrinsics, _select_keyframes, _verbosity_level);
			return Ok<cv::sfm::libmv_ReconstructionOptions>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::sfm::libmv_ReconstructionOptions>))
	}
	
}
