#include "ocvrs_common.hpp"
#include <opencv2/saliency.hpp>
#include "saliency_types.hpp"

extern "C" {
	cv::Algorithm* cv_MotionSaliencyBinWangApr2014_to_Algorithm(cv::saliency::MotionSaliencyBinWangApr2014* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_MotionSaliencyBinWangApr2014_delete(cv::saliency::MotionSaliencyBinWangApr2014* instance) {
		delete instance;
	}
	// MotionSaliencyBinWangApr2014() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:172
	Result<cv::saliency::MotionSaliencyBinWangApr2014*> cv_saliency_MotionSaliencyBinWangApr2014_MotionSaliencyBinWangApr2014() {
		try {
			cv::saliency::MotionSaliencyBinWangApr2014* ret = new cv::saliency::MotionSaliencyBinWangApr2014();
			return Ok<cv::saliency::MotionSaliencyBinWangApr2014*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::saliency::MotionSaliencyBinWangApr2014*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:175
	Result<cv::Ptr<cv::saliency::MotionSaliencyBinWangApr2014>*> cv_saliency_MotionSaliencyBinWangApr2014_create() {
		try {
			cv::Ptr<cv::saliency::MotionSaliencyBinWangApr2014> ret = cv::saliency::MotionSaliencyBinWangApr2014::create();
			return Ok(new cv::Ptr<cv::saliency::MotionSaliencyBinWangApr2014>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::saliency::MotionSaliencyBinWangApr2014>*>))
	}
	
	// computeSaliency(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:180
	Result<bool> cv_saliency_MotionSaliencyBinWangApr2014_computeSaliency_const__InputArrayR_const__OutputArrayR(cv::saliency::MotionSaliencyBinWangApr2014* instance, const cv::_InputArray* image, const cv::_OutputArray* saliencyMap) {
		try {
			bool ret = instance->computeSaliency(*image, *saliencyMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setImagesize(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:193
	Result_void cv_saliency_MotionSaliencyBinWangApr2014_setImagesize_int_int(cv::saliency::MotionSaliencyBinWangApr2014* instance, int W, int H) {
		try {
			instance->setImagesize(W, H);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// init() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:197
	Result<bool> cv_saliency_MotionSaliencyBinWangApr2014_init(cv::saliency::MotionSaliencyBinWangApr2014* instance) {
		try {
			bool ret = instance->init();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getImageWidth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:199
	Result<int> cv_saliency_MotionSaliencyBinWangApr2014_getImageWidth_const(const cv::saliency::MotionSaliencyBinWangApr2014* instance) {
		try {
			int ret = instance->getImageWidth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setImageWidth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:203
	Result_void cv_saliency_MotionSaliencyBinWangApr2014_setImageWidth_int(cv::saliency::MotionSaliencyBinWangApr2014* instance, int val) {
		try {
			instance->setImageWidth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getImageHeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:207
	Result<int> cv_saliency_MotionSaliencyBinWangApr2014_getImageHeight_const(const cv::saliency::MotionSaliencyBinWangApr2014* instance) {
		try {
			int ret = instance->getImageHeight();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setImageHeight(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:211
	Result_void cv_saliency_MotionSaliencyBinWangApr2014_setImageHeight_int(cv::saliency::MotionSaliencyBinWangApr2014* instance, int val) {
		try {
			instance->setImageHeight(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_ObjectnessBING_to_Algorithm(cv::saliency::ObjectnessBING* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_ObjectnessBING_delete(cv::saliency::ObjectnessBING* instance) {
		delete instance;
	}
	// ObjectnessBING() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:295
	Result<cv::saliency::ObjectnessBING*> cv_saliency_ObjectnessBING_ObjectnessBING() {
		try {
			cv::saliency::ObjectnessBING* ret = new cv::saliency::ObjectnessBING();
			return Ok<cv::saliency::ObjectnessBING*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::saliency::ObjectnessBING*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:298
	Result<cv::Ptr<cv::saliency::ObjectnessBING>*> cv_saliency_ObjectnessBING_create() {
		try {
			cv::Ptr<cv::saliency::ObjectnessBING> ret = cv::saliency::ObjectnessBING::create();
			return Ok(new cv::Ptr<cv::saliency::ObjectnessBING>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::saliency::ObjectnessBING>*>))
	}
	
	// computeSaliency(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:303
	Result<bool> cv_saliency_ObjectnessBING_computeSaliency_const__InputArrayR_const__OutputArrayR(cv::saliency::ObjectnessBING* instance, const cv::_InputArray* image, const cv::_OutputArray* saliencyMap) {
		try {
			bool ret = instance->computeSaliency(*image, *saliencyMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// read() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:311
	Result_void cv_saliency_ObjectnessBING_read(cv::saliency::ObjectnessBING* instance) {
		try {
			instance->read();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:312
	Result_void cv_saliency_ObjectnessBING_write_const(const cv::saliency::ObjectnessBING* instance) {
		try {
			instance->write();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getobjectnessValues() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:320
	Result<std::vector<float>*> cv_saliency_ObjectnessBING_getobjectnessValues(cv::saliency::ObjectnessBING* instance) {
		try {
			std::vector<float> ret = instance->getobjectnessValues();
			return Ok(new std::vector<float>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<float>*>))
	}
	
	// setTrainingPath(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:326
	Result_void cv_saliency_ObjectnessBING_setTrainingPath_const_StringR(cv::saliency::ObjectnessBING* instance, const char* trainingPath) {
		try {
			instance->setTrainingPath(std::string(trainingPath));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBBResDir(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:335
	Result_void cv_saliency_ObjectnessBING_setBBResDir_const_StringR(cv::saliency::ObjectnessBING* instance, const char* resultsDir) {
		try {
			instance->setBBResDir(std::string(resultsDir));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBase() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:337
	Result<double> cv_saliency_ObjectnessBING_getBase_const(const cv::saliency::ObjectnessBING* instance) {
		try {
			double ret = instance->getBase();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBase(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:341
	Result_void cv_saliency_ObjectnessBING_setBase_double(cv::saliency::ObjectnessBING* instance, double val) {
		try {
			instance->setBase(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNSS() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:345
	Result<int> cv_saliency_ObjectnessBING_getNSS_const(const cv::saliency::ObjectnessBING* instance) {
		try {
			int ret = instance->getNSS();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNSS(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:349
	Result_void cv_saliency_ObjectnessBING_setNSS_int(cv::saliency::ObjectnessBING* instance, int val) {
		try {
			instance->setNSS(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getW() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:353
	Result<int> cv_saliency_ObjectnessBING_getW_const(const cv::saliency::ObjectnessBING* instance) {
		try {
			int ret = instance->getW();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setW(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:357
	Result_void cv_saliency_ObjectnessBING_setW_int(cv::saliency::ObjectnessBING* instance, int val) {
		try {
			instance->setW(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeSaliency(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencyBaseClasses.hpp:76
	Result<bool> cv_saliency_Saliency_computeSaliency_const__InputArrayR_const__OutputArrayR(cv::saliency::Saliency* instance, const cv::_InputArray* image, const cv::_OutputArray* saliencyMap) {
		try {
			bool ret = instance->computeSaliency(*image, *saliencyMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// computeBinaryMap(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencyBaseClasses.hpp:104
	Result<bool> cv_saliency_StaticSaliency_computeBinaryMap_const__InputArrayR_const__OutputArrayR(cv::saliency::StaticSaliency* instance, const cv::_InputArray* _saliencyMap, const cv::_OutputArray* _binaryMap) {
		try {
			bool ret = instance->computeBinaryMap(*_saliencyMap, *_binaryMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::Algorithm* cv_StaticSaliencyFineGrained_to_Algorithm(cv::saliency::StaticSaliencyFineGrained* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_StaticSaliencyFineGrained_delete(cv::saliency::StaticSaliencyFineGrained* instance) {
		delete instance;
	}
	// StaticSaliencyFineGrained() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:126
	Result<cv::saliency::StaticSaliencyFineGrained*> cv_saliency_StaticSaliencyFineGrained_StaticSaliencyFineGrained() {
		try {
			cv::saliency::StaticSaliencyFineGrained* ret = new cv::saliency::StaticSaliencyFineGrained();
			return Ok<cv::saliency::StaticSaliencyFineGrained*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::saliency::StaticSaliencyFineGrained*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:128
	Result<cv::Ptr<cv::saliency::StaticSaliencyFineGrained>*> cv_saliency_StaticSaliencyFineGrained_create() {
		try {
			cv::Ptr<cv::saliency::StaticSaliencyFineGrained> ret = cv::saliency::StaticSaliencyFineGrained::create();
			return Ok(new cv::Ptr<cv::saliency::StaticSaliencyFineGrained>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::saliency::StaticSaliencyFineGrained>*>))
	}
	
	// computeSaliency(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:133
	Result<bool> cv_saliency_StaticSaliencyFineGrained_computeSaliency_const__InputArrayR_const__OutputArrayR(cv::saliency::StaticSaliencyFineGrained* instance, const cv::_InputArray* image, const cv::_OutputArray* saliencyMap) {
		try {
			bool ret = instance->computeSaliency(*image, *saliencyMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::Algorithm* cv_StaticSaliencySpectralResidual_to_Algorithm(cv::saliency::StaticSaliencySpectralResidual* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_StaticSaliencySpectralResidual_delete(cv::saliency::StaticSaliencySpectralResidual* instance) {
		delete instance;
	}
	// StaticSaliencySpectralResidual() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:73
	Result<cv::saliency::StaticSaliencySpectralResidual*> cv_saliency_StaticSaliencySpectralResidual_StaticSaliencySpectralResidual() {
		try {
			cv::saliency::StaticSaliencySpectralResidual* ret = new cv::saliency::StaticSaliencySpectralResidual();
			return Ok<cv::saliency::StaticSaliencySpectralResidual*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::saliency::StaticSaliencySpectralResidual*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:76
	Result<cv::Ptr<cv::saliency::StaticSaliencySpectralResidual>*> cv_saliency_StaticSaliencySpectralResidual_create() {
		try {
			cv::Ptr<cv::saliency::StaticSaliencySpectralResidual> ret = cv::saliency::StaticSaliencySpectralResidual::create();
			return Ok(new cv::Ptr<cv::saliency::StaticSaliencySpectralResidual>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::saliency::StaticSaliencySpectralResidual>*>))
	}
	
	// computeSaliency(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:81
	Result<bool> cv_saliency_StaticSaliencySpectralResidual_computeSaliency_const__InputArrayR_const__OutputArrayR(cv::saliency::StaticSaliencySpectralResidual* instance, const cv::_InputArray* image, const cv::_OutputArray* saliencyMap) {
		try {
			bool ret = instance->computeSaliency(*image, *saliencyMap);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:89
	Result_void cv_saliency_StaticSaliencySpectralResidual_read_const_FileNodeR(cv::saliency::StaticSaliencySpectralResidual* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:90
	Result_void cv_saliency_StaticSaliencySpectralResidual_write_const_FileStorageR(const cv::saliency::StaticSaliencySpectralResidual* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getImageWidth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:92
	Result<int> cv_saliency_StaticSaliencySpectralResidual_getImageWidth_const(const cv::saliency::StaticSaliencySpectralResidual* instance) {
		try {
			int ret = instance->getImageWidth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setImageWidth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:96
	Result_void cv_saliency_StaticSaliencySpectralResidual_setImageWidth_int(cv::saliency::StaticSaliencySpectralResidual* instance, int val) {
		try {
			instance->setImageWidth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getImageHeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:100
	Result<int> cv_saliency_StaticSaliencySpectralResidual_getImageHeight_const(const cv::saliency::StaticSaliencySpectralResidual* instance) {
		try {
			int ret = instance->getImageHeight();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setImageHeight(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/saliency/saliencySpecializedClasses.hpp:104
	Result_void cv_saliency_StaticSaliencySpectralResidual_setImageHeight_int(cv::saliency::StaticSaliencySpectralResidual* instance, int val) {
		try {
			instance->setImageHeight(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
