#include "ocvrs_common.hpp"
#include <opencv2/rgbd.hpp>
#include "rgbd_types.hpp"

extern "C" {
	// makeVolume(cv::kinfu::VolumeType, float, cv::Matx44f, float, float, int, float, cv::Vec3i) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:118
	Result<cv::Ptr<cv::kinfu::Volume>*> cv_kinfu_makeVolume_VolumeType_float_Matx44f_float_float_int_float_Vec3i(cv::kinfu::VolumeType _volumeType, float _voxelSize, cv::Matx44f* _pose, float _raycastStepFactor, float _truncDist, int _maxWeight, float _truncateThreshold, cv::Vec3i* _resolution) {
		try {
			cv::Ptr<cv::kinfu::Volume> ret = cv::kinfu::makeVolume(_volumeType, _voxelSize, *_pose, _raycastStepFactor, _truncDist, _maxWeight, _truncateThreshold, *_resolution);
			return Ok(new cv::Ptr<cv::kinfu::Volume>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::Volume>*>))
	}
	
	// colormap(const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:245
	Result_void cv_linemod_colormap_const_MatR_MatR(const cv::Mat* quantized, cv::Mat* dst) {
		try {
			cv::linemod::colormap(*quantized, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawFeatures(cv::InputOutputArray, const std::vector<Template> &, const cv::Point2i &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:254
	Result_void cv_linemod_drawFeatures_const__InputOutputArrayR_const_vector_Template_R_const_Point2iR_int(const cv::_InputOutputArray* img, const std::vector<cv::linemod::Template>* templates, const cv::Point2i* tl, int size) {
		try {
			cv::linemod::drawFeatures(*img, *templates, *tl, size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultLINE() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:420
	Result<cv::Ptr<cv::linemod::Detector>*> cv_linemod_getDefaultLINE() {
		try {
			cv::Ptr<cv::linemod::Detector> ret = cv::linemod::getDefaultLINE();
			return Ok(new cv::Ptr<cv::linemod::Detector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::Detector>*>))
	}
	
	// getDefaultLINEMOD() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:428
	Result<cv::Ptr<cv::linemod::Detector>*> cv_linemod_getDefaultLINEMOD() {
		try {
			cv::Ptr<cv::linemod::Detector> ret = cv::linemod::getDefaultLINEMOD();
			return Ok(new cv::Ptr<cv::linemod::Detector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::Detector>*>))
	}
	
	// depthTo3dSparse(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:299
	Result_void cv_rgbd_depthTo3dSparse_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* depth, const cv::_InputArray* in_K, const cv::_InputArray* in_points, const cv::_OutputArray* points3d) {
		try {
			cv::rgbd::depthTo3dSparse(*depth, *in_K, *in_points, *points3d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// depthTo3d(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:312
	Result_void cv_rgbd_depthTo3d_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* depth, const cv::_InputArray* K, const cv::_OutputArray* points3d, const cv::_InputArray* mask) {
		try {
			cv::rgbd::depthTo3d(*depth, *K, *points3d, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isValidDepth(const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:33
	Result<bool> cv_rgbd_isValidDepth_const_doubleR(const double* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isValidDepth(const float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:27
	Result<bool> cv_rgbd_isValidDepth_const_floatR(const float* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isValidDepth(const int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:52
	Result<bool> cv_rgbd_isValidDepth_const_intR(const int* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isValidDepth(const short &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:39
	Result<bool> cv_rgbd_isValidDepth_const_shortR(const short* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isValidDepth(const unsigned int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:58
	Result<bool> cv_rgbd_isValidDepth_const_unsigned_intR(const unsigned int* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isValidDepth(const unsigned short &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:45
	Result<bool> cv_rgbd_isValidDepth_const_unsigned_shortR(const unsigned short* depth) {
		try {
			bool ret = cv::rgbd::isValidDepth(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// registerDepth(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, const cv::Size &, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:287
	Result_void cv_rgbd_registerDepth_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__OutputArrayR_bool(const cv::_InputArray* unregisteredCameraMatrix, const cv::_InputArray* registeredCameraMatrix, const cv::_InputArray* registeredDistCoeffs, const cv::_InputArray* Rt, const cv::_InputArray* unregisteredDepth, const cv::Size* outputImagePlaneSize, const cv::_OutputArray* registeredDepth, bool depthDilation) {
		try {
			cv::rgbd::registerDepth(*unregisteredCameraMatrix, *registeredCameraMatrix, *registeredDistCoeffs, *Rt, *unregisteredDepth, *outputImagePlaneSize, *registeredDepth, depthDilation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rescaleDepth(cv::InputArray, int, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:325
	Result_void cv_rgbd_rescaleDepth_const__InputArrayR_int_const__OutputArrayR_double(const cv::_InputArray* in, int depth, const cv::_OutputArray* out, double depth_factor) {
		try {
			cv::rgbd::rescaleDepth(*in, depth, *out, depth_factor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpFrame(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1179
	Result_void cv_rgbd_warpFrame_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::Mat* image, const cv::Mat* depth, const cv::Mat* mask, const cv::Mat* Rt, const cv::Mat* cameraMatrix, const cv::Mat* distCoeff, const cv::_OutputArray* warpedImage, const cv::_OutputArray* warpedDepth, const cv::_OutputArray* warpedMask) {
		try {
			cv::rgbd::warpFrame(*image, *depth, *mask, *Rt, *cameraMatrix, *distCoeff, *warpedImage, *warpedDepth, *warpedMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const Ptr<cv::colored_kinfu::Params> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:198
	Result<cv::Ptr<cv::colored_kinfu::ColoredKinFu>*> cv_colored_kinfu_ColoredKinFu_create_const_Ptr_Params_R(const cv::Ptr<cv::colored_kinfu::Params>* _params) {
		try {
			cv::Ptr<cv::colored_kinfu::ColoredKinFu> ret = cv::colored_kinfu::ColoredKinFu::create(*_params);
			return Ok(new cv::Ptr<cv::colored_kinfu::ColoredKinFu>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::colored_kinfu::ColoredKinFu>*>))
	}
	
	// getParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:202
	Result<const cv::colored_kinfu::Params*> cv_colored_kinfu_ColoredKinFu_getParams_const(const cv::colored_kinfu::ColoredKinFu* instance) {
		try {
			const cv::colored_kinfu::Params ret = instance->getParams();
			return Ok(new const cv::colored_kinfu::Params(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::colored_kinfu::Params*>))
	}
	
	// render(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:212
	Result_void cv_colored_kinfu_ColoredKinFu_render_const_const__OutputArrayR(const cv::colored_kinfu::ColoredKinFu* instance, const cv::_OutputArray* image) {
		try {
			instance->render(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(cv::OutputArray, const cv::Matx44f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:224
	Result_void cv_colored_kinfu_ColoredKinFu_render_const_const__OutputArrayR_const_Matx44fR(const cv::colored_kinfu::ColoredKinFu* instance, const cv::_OutputArray* image, const cv::Matx44f* cameraPose) {
		try {
			instance->render(*image, *cameraPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCloud(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:234
	Result_void cv_colored_kinfu_ColoredKinFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(const cv::colored_kinfu::ColoredKinFu* instance, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getCloud(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:242
	Result_void cv_colored_kinfu_ColoredKinFu_getPoints_const_const__OutputArrayR(const cv::colored_kinfu::ColoredKinFu* instance, const cv::_OutputArray* points) {
		try {
			instance->getPoints(*points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormals(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:248
	Result_void cv_colored_kinfu_ColoredKinFu_getNormals_const_const__InputArrayR_const__OutputArrayR(const cv::colored_kinfu::ColoredKinFu* instance, const cv::_InputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getNormals(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:254
	Result_void cv_colored_kinfu_ColoredKinFu_reset(cv::colored_kinfu::ColoredKinFu* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:257
	Result<const cv::Affine3f> cv_colored_kinfu_ColoredKinFu_getPose_const(const cv::colored_kinfu::ColoredKinFu* instance) {
		try {
			const cv::Affine3f ret = instance->getPose();
			return Ok<const cv::Affine3f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Affine3f>))
	}
	
	// update(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:265
	Result<bool> cv_colored_kinfu_ColoredKinFu_update_const__InputArrayR_const__InputArrayR(cv::colored_kinfu::ColoredKinFu* instance, const cv::_InputArray* depth, const cv::_InputArray* rgb) {
		try {
			bool ret = instance->update(*depth, *rgb);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:83
	cv::Size cv_colored_kinfu_Params_getPropFrameSize_const(const cv::colored_kinfu::Params* instance) {
		cv::Size ret = instance->frameSize;
		return (cv::Size)ret;
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:83
	void cv_colored_kinfu_Params_setPropFrameSize_Size(cv::colored_kinfu::Params* instance, cv::Size* val) {
		instance->frameSize = *val;
	}
	
	// rgb_frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:86
	cv::Size cv_colored_kinfu_Params_getPropRgb_frameSize_const(const cv::colored_kinfu::Params* instance) {
		cv::Size ret = instance->rgb_frameSize;
		return (cv::Size)ret;
	}
	
	// rgb_frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:86
	void cv_colored_kinfu_Params_setPropRgb_frameSize_Size(cv::colored_kinfu::Params* instance, cv::Size* val) {
		instance->rgb_frameSize = *val;
	}
	
	// volumeType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:88
	cv::kinfu::VolumeType cv_colored_kinfu_Params_getPropVolumeType_const(const cv::colored_kinfu::Params* instance) {
		cv::kinfu::VolumeType ret = instance->volumeType;
		return (cv::kinfu::VolumeType)ret;
	}
	
	// volumeType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:88
	void cv_colored_kinfu_Params_setPropVolumeType_VolumeType(cv::colored_kinfu::Params* instance, cv::kinfu::VolumeType val) {
		instance->volumeType = val;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:91
	cv::Matx33f cv_colored_kinfu_Params_getPropIntr_const(const cv::colored_kinfu::Params* instance) {
		cv::Matx33f ret = instance->intr;
		return (cv::Matx33f)ret;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:91
	void cv_colored_kinfu_Params_setPropIntr_Matx33f(cv::colored_kinfu::Params* instance, cv::Matx33f* val) {
		instance->intr = *val;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:94
	cv::Matx33f cv_colored_kinfu_Params_getPropRgb_intr_const(const cv::colored_kinfu::Params* instance) {
		cv::Matx33f ret = instance->rgb_intr;
		return (cv::Matx33f)ret;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:94
	void cv_colored_kinfu_Params_setPropRgb_intr_Matx33f(cv::colored_kinfu::Params* instance, cv::Matx33f* val) {
		instance->rgb_intr = *val;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:103
	float cv_colored_kinfu_Params_getPropDepthFactor_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->depthFactor;
		return (float)ret;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:103
	void cv_colored_kinfu_Params_setPropDepthFactor_float(cv::colored_kinfu::Params* instance, float val) {
		instance->depthFactor = val;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:106
	float cv_colored_kinfu_Params_getPropBilateral_sigma_depth_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_depth;
		return (float)ret;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:106
	void cv_colored_kinfu_Params_setPropBilateral_sigma_depth_float(cv::colored_kinfu::Params* instance, float val) {
		instance->bilateral_sigma_depth = val;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:108
	float cv_colored_kinfu_Params_getPropBilateral_sigma_spatial_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_spatial;
		return (float)ret;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:108
	void cv_colored_kinfu_Params_setPropBilateral_sigma_spatial_float(cv::colored_kinfu::Params* instance, float val) {
		instance->bilateral_sigma_spatial = val;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:110
	int cv_colored_kinfu_Params_getPropBilateral_kernel_size_const(const cv::colored_kinfu::Params* instance) {
		int ret = instance->bilateral_kernel_size;
		return (int)ret;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:110
	void cv_colored_kinfu_Params_setPropBilateral_kernel_size_int(cv::colored_kinfu::Params* instance, int val) {
		instance->bilateral_kernel_size = val;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:113
	int cv_colored_kinfu_Params_getPropPyramidLevels_const(const cv::colored_kinfu::Params* instance) {
		int ret = instance->pyramidLevels;
		return (int)ret;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:113
	void cv_colored_kinfu_Params_setPropPyramidLevels_int(cv::colored_kinfu::Params* instance, int val) {
		instance->pyramidLevels = val;
	}
	
	// volumeDims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:119
	cv::Vec3i cv_colored_kinfu_Params_getPropVolumeDims_const(const cv::colored_kinfu::Params* instance) {
		cv::Vec3i ret = instance->volumeDims;
		return (cv::Vec3i)ret;
	}
	
	// volumeDims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:119
	void cv_colored_kinfu_Params_setPropVolumeDims_Vec3i(cv::colored_kinfu::Params* instance, cv::Vec3i* val) {
		instance->volumeDims = *val;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:121
	float cv_colored_kinfu_Params_getPropVoxelSize_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->voxelSize;
		return (float)ret;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:121
	void cv_colored_kinfu_Params_setPropVoxelSize_float(cv::colored_kinfu::Params* instance, float val) {
		instance->voxelSize = val;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:127
	float cv_colored_kinfu_Params_getPropTsdf_min_camera_movement_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->tsdf_min_camera_movement;
		return (float)ret;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:127
	void cv_colored_kinfu_Params_setPropTsdf_min_camera_movement_float(cv::colored_kinfu::Params* instance, float val) {
		instance->tsdf_min_camera_movement = val;
	}
	
	// volumePose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:130
	cv::Affine3f cv_colored_kinfu_Params_getPropVolumePose_const(const cv::colored_kinfu::Params* instance) {
		cv::Affine3f ret = instance->volumePose;
		return (cv::Affine3f)ret;
	}
	
	// volumePose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:130
	void cv_colored_kinfu_Params_setPropVolumePose_Affine3f(cv::colored_kinfu::Params* instance, cv::Affine3f* val) {
		instance->volumePose = *val;
	}
	
	// tsdf_trunc_dist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:136
	float cv_colored_kinfu_Params_getPropTsdf_trunc_dist_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->tsdf_trunc_dist;
		return (float)ret;
	}
	
	// tsdf_trunc_dist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:136
	void cv_colored_kinfu_Params_setPropTsdf_trunc_dist_float(cv::colored_kinfu::Params* instance, float val) {
		instance->tsdf_trunc_dist = val;
	}
	
	// tsdf_max_weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:142
	int cv_colored_kinfu_Params_getPropTsdf_max_weight_const(const cv::colored_kinfu::Params* instance) {
		int ret = instance->tsdf_max_weight;
		return (int)ret;
	}
	
	// tsdf_max_weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:142
	void cv_colored_kinfu_Params_setPropTsdf_max_weight_int(cv::colored_kinfu::Params* instance, int val) {
		instance->tsdf_max_weight = val;
	}
	
	// raycast_step_factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:148
	float cv_colored_kinfu_Params_getPropRaycast_step_factor_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->raycast_step_factor;
		return (float)ret;
	}
	
	// raycast_step_factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:148
	void cv_colored_kinfu_Params_setPropRaycast_step_factor_float(cv::colored_kinfu::Params* instance, float val) {
		instance->raycast_step_factor = val;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:155
	cv::Vec3f cv_colored_kinfu_Params_getPropLightPose_const(const cv::colored_kinfu::Params* instance) {
		cv::Vec3f ret = instance->lightPose;
		return (cv::Vec3f)ret;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:155
	void cv_colored_kinfu_Params_setPropLightPose_Vec3f(cv::colored_kinfu::Params* instance, cv::Vec3f* val) {
		instance->lightPose = *val;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:158
	float cv_colored_kinfu_Params_getPropIcpDistThresh_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->icpDistThresh;
		return (float)ret;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:158
	void cv_colored_kinfu_Params_setPropIcpDistThresh_float(cv::colored_kinfu::Params* instance, float val) {
		instance->icpDistThresh = val;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:160
	float cv_colored_kinfu_Params_getPropIcpAngleThresh_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->icpAngleThresh;
		return (float)ret;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:160
	void cv_colored_kinfu_Params_setPropIcpAngleThresh_float(cv::colored_kinfu::Params* instance, float val) {
		instance->icpAngleThresh = val;
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:162
	std::vector<int>* cv_colored_kinfu_Params_getPropIcpIterations_const(const cv::colored_kinfu::Params* instance) {
		std::vector<int> ret = instance->icpIterations;
		return new std::vector<int>(ret);
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:162
	void cv_colored_kinfu_Params_setPropIcpIterations_vector_int_(cv::colored_kinfu::Params* instance, std::vector<int>* val) {
		instance->icpIterations = *val;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:168
	float cv_colored_kinfu_Params_getPropTruncateThreshold_const(const cv::colored_kinfu::Params* instance) {
		float ret = instance->truncateThreshold;
		return (float)ret;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:168
	void cv_colored_kinfu_Params_setPropTruncateThreshold_float(cv::colored_kinfu::Params* instance, float val) {
		instance->truncateThreshold = val;
	}
	
	void cv_ColoredKinfu_Params_delete(cv::colored_kinfu::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:22
	Result<cv::colored_kinfu::Params*> cv_colored_kinfu_Params_Params() {
		try {
			cv::colored_kinfu::Params* ret = new cv::colored_kinfu::Params();
			return Ok<cv::colored_kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::colored_kinfu::Params*>))
	}
	
	// Params(cv::Matx33f, cv::Vec3f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:30
	Result<cv::colored_kinfu::Params*> cv_colored_kinfu_Params_Params_Matx33f_Vec3f(cv::Matx33f* volumeInitialPoseRot, cv::Vec3f* volumeInitialPoseTransl) {
		try {
			cv::colored_kinfu::Params* ret = new cv::colored_kinfu::Params(*volumeInitialPoseRot, *volumeInitialPoseTransl);
			return Ok<cv::colored_kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::colored_kinfu::Params*>))
	}
	
	// Params(cv::Matx44f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:40
	Result<cv::colored_kinfu::Params*> cv_colored_kinfu_Params_Params_Matx44f(cv::Matx44f* volumeInitialPose) {
		try {
			cv::colored_kinfu::Params* ret = new cv::colored_kinfu::Params(*volumeInitialPose);
			return Ok<cv::colored_kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::colored_kinfu::Params*>))
	}
	
	// setInitialVolumePose(cv::Matx33f, cv::Vec3f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:51
	Result_void cv_colored_kinfu_Params_setInitialVolumePose_Matx33f_Vec3f(cv::colored_kinfu::Params* instance, cv::Matx33f* R, cv::Vec3f* t) {
		try {
			instance->setInitialVolumePose(*R, *t);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInitialVolumePose(cv::Matx44f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:58
	Result_void cv_colored_kinfu_Params_setInitialVolumePose_Matx44f(cv::colored_kinfu::Params* instance, cv::Matx44f* homogen_tf) {
		try {
			instance->setInitialVolumePose(*homogen_tf);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// defaultParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:64
	Result<cv::Ptr<cv::colored_kinfu::Params>*> cv_colored_kinfu_Params_defaultParams() {
		try {
			cv::Ptr<cv::colored_kinfu::Params> ret = cv::colored_kinfu::Params::defaultParams();
			return Ok(new cv::Ptr<cv::colored_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::colored_kinfu::Params>*>))
	}
	
	// coarseParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:70
	Result<cv::Ptr<cv::colored_kinfu::Params>*> cv_colored_kinfu_Params_coarseParams() {
		try {
			cv::Ptr<cv::colored_kinfu::Params> ret = cv::colored_kinfu::Params::coarseParams();
			return Ok(new cv::Ptr<cv::colored_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::colored_kinfu::Params>*>))
	}
	
	// hashTSDFParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:75
	Result<cv::Ptr<cv::colored_kinfu::Params>*> cv_colored_kinfu_Params_hashTSDFParams_bool(bool isCoarse) {
		try {
			cv::Ptr<cv::colored_kinfu::Params> ret = cv::colored_kinfu::Params::hashTSDFParams(isCoarse);
			return Ok(new cv::Ptr<cv::colored_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::colored_kinfu::Params>*>))
	}
	
	// coloredTSDFParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/colored_kinfu.hpp:80
	Result<cv::Ptr<cv::colored_kinfu::Params>*> cv_colored_kinfu_Params_coloredTSDFParams_bool(bool isCoarse) {
		try {
			cv::Ptr<cv::colored_kinfu::Params> ret = cv::colored_kinfu::Params::coloredTSDFParams(isCoarse);
			return Ok(new cv::Ptr<cv::colored_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::colored_kinfu::Params>*>))
	}
	
	// create(const Ptr<kinfu::Params> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:49
	Result<cv::Ptr<cv::dynafu::DynaFu>*> cv_dynafu_DynaFu_create_const_Ptr_Params_R(const cv::Ptr<cv::kinfu::Params>* _params) {
		try {
			cv::Ptr<cv::dynafu::DynaFu> ret = cv::dynafu::DynaFu::create(*_params);
			return Ok(new cv::Ptr<cv::dynafu::DynaFu>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dynafu::DynaFu>*>))
	}
	
	// getParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:53
	Result<const cv::kinfu::Params*> cv_dynafu_DynaFu_getParams_const(const cv::dynafu::DynaFu* instance) {
		try {
			const cv::kinfu::Params ret = instance->getParams();
			return Ok(new const cv::kinfu::Params(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::kinfu::Params*>))
	}
	
	// render(cv::OutputArray, const cv::Matx44f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:65
	Result_void cv_dynafu_DynaFu_render_const_const__OutputArrayR_const_Matx44fR(const cv::dynafu::DynaFu* instance, const cv::_OutputArray* image, const cv::Matx44f* cameraPose) {
		try {
			instance->render(*image, *cameraPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCloud(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:75
	Result_void cv_dynafu_DynaFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(const cv::dynafu::DynaFu* instance, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getCloud(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:83
	Result_void cv_dynafu_DynaFu_getPoints_const_const__OutputArrayR(const cv::dynafu::DynaFu* instance, const cv::_OutputArray* points) {
		try {
			instance->getPoints(*points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormals(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:89
	Result_void cv_dynafu_DynaFu_getNormals_const_const__InputArrayR_const__OutputArrayR(const cv::dynafu::DynaFu* instance, const cv::_InputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getNormals(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:95
	Result_void cv_dynafu_DynaFu_reset(cv::dynafu::DynaFu* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:98
	Result<const cv::Affine3f> cv_dynafu_DynaFu_getPose_const(const cv::dynafu::DynaFu* instance) {
		try {
			const cv::Affine3f ret = instance->getPose();
			return Ok<const cv::Affine3f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Affine3f>))
	}
	
	// update(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:108
	Result<bool> cv_dynafu_DynaFu_update_const__InputArrayR(cv::dynafu::DynaFu* instance, const cv::_InputArray* depth) {
		try {
			bool ret = instance->update(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getNodesPos() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:110
	Result<std::vector<cv::Point3f>*> cv_dynafu_DynaFu_getNodesPos_const(const cv::dynafu::DynaFu* instance) {
		try {
			std::vector<cv::Point3f> ret = instance->getNodesPos();
			return Ok(new std::vector<cv::Point3f>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Point3f>*>))
	}
	
	// marchCubes(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:112
	Result_void cv_dynafu_DynaFu_marchCubes_const_const__OutputArrayR_const__OutputArrayR(const cv::dynafu::DynaFu* instance, const cv::_OutputArray* vertices, const cv::_OutputArray* edges) {
		try {
			instance->marchCubes(*vertices, *edges);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// renderSurface(cv::OutputArray, cv::OutputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/dynafu.hpp:114
	Result_void cv_dynafu_DynaFu_renderSurface_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_bool(cv::dynafu::DynaFu* instance, const cv::_OutputArray* depthImage, const cv::_OutputArray* vertImage, const cv::_OutputArray* normImage, bool warp) {
		try {
			instance->renderSurface(*depthImage, *vertImage, *normImage, warp);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Intr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:61
	Result<cv::kinfu::Intr> cv_kinfu_Intr_Intr() {
		try {
			cv::kinfu::Intr ret;
			return Ok<cv::kinfu::Intr>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr>))
	}
	
	// Intr(float, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:62
	Result<cv::kinfu::Intr> cv_kinfu_Intr_Intr_float_float_float_float(float _fx, float _fy, float _cx, float _cy) {
		try {
			cv::kinfu::Intr ret(_fx, _fy, _cx, _cy);
			return Ok<cv::kinfu::Intr>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr>))
	}
	
	// Intr(cv::Matx33f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:63
	Result<cv::kinfu::Intr> cv_kinfu_Intr_Intr_Matx33f(cv::Matx33f* m) {
		try {
			cv::kinfu::Intr ret(*m);
			return Ok<cv::kinfu::Intr>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr>))
	}
	
	// scale(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:65
	Result<cv::kinfu::Intr> cv_kinfu_Intr_scale_const_int(const cv::kinfu::Intr instance, int pyr) {
		try {
			cv::kinfu::Intr ret = instance.scale(pyr);
			return Ok<cv::kinfu::Intr>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr>))
	}
	
	// makeReprojector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:70
	Result<cv::kinfu::Intr::Reprojector> cv_kinfu_Intr_makeReprojector_const(const cv::kinfu::Intr instance) {
		try {
			cv::kinfu::Intr::Reprojector ret = instance.makeReprojector();
			return Ok<cv::kinfu::Intr::Reprojector>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr::Reprojector>))
	}
	
	// makeProjector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:71
	Result<cv::kinfu::Intr::Projector> cv_kinfu_Intr_makeProjector_const(const cv::kinfu::Intr instance) {
		try {
			cv::kinfu::Intr::Projector ret = instance.makeProjector();
			return Ok<cv::kinfu::Intr::Projector>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr::Projector>))
	}
	
	// getMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:73
	Result<cv::Matx33f> cv_kinfu_Intr_getMat_const(const cv::kinfu::Intr instance) {
		try {
			cv::Matx33f ret = instance.getMat();
			return Ok<cv::Matx33f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx33f>))
	}
	
	// Projector(cv::kinfu::Intr) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:41
	Result<cv::kinfu::Intr::Projector> cv_kinfu_Intr_Projector_Projector_Intr(cv::kinfu::Intr* intr) {
		try {
			cv::kinfu::Intr::Projector ret(*intr);
			return Ok<cv::kinfu::Intr::Projector>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr::Projector>))
	}
	
	// Reprojector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:21
	Result<cv::kinfu::Intr::Reprojector> cv_kinfu_Intr_Reprojector_Reprojector() {
		try {
			cv::kinfu::Intr::Reprojector ret;
			return Ok<cv::kinfu::Intr::Reprojector>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr::Reprojector>))
	}
	
	// Reprojector(cv::kinfu::Intr) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/intrinsics.hpp:22
	Result<cv::kinfu::Intr::Reprojector> cv_kinfu_Intr_Reprojector_Reprojector_Intr(cv::kinfu::Intr* intr) {
		try {
			cv::kinfu::Intr::Reprojector ret(*intr);
			return Ok<cv::kinfu::Intr::Reprojector>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Intr::Reprojector>))
	}
	
	// create(const Ptr<cv::kinfu::Params> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:195
	Result<cv::Ptr<cv::kinfu::KinFu>*> cv_kinfu_KinFu_create_const_Ptr_Params_R(const cv::Ptr<cv::kinfu::Params>* _params) {
		try {
			cv::Ptr<cv::kinfu::KinFu> ret = cv::kinfu::KinFu::create(*_params);
			return Ok(new cv::Ptr<cv::kinfu::KinFu>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::KinFu>*>))
	}
	
	// getParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:199
	Result<const cv::kinfu::Params*> cv_kinfu_KinFu_getParams_const(const cv::kinfu::KinFu* instance) {
		try {
			const cv::kinfu::Params ret = instance->getParams();
			return Ok(new const cv::kinfu::Params(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::kinfu::Params*>))
	}
	
	// render(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:209
	Result_void cv_kinfu_KinFu_render_const_const__OutputArrayR(const cv::kinfu::KinFu* instance, const cv::_OutputArray* image) {
		try {
			instance->render(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(cv::OutputArray, const cv::Matx44f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:221
	Result_void cv_kinfu_KinFu_render_const_const__OutputArrayR_const_Matx44fR(const cv::kinfu::KinFu* instance, const cv::_OutputArray* image, const cv::Matx44f* cameraPose) {
		try {
			instance->render(*image, *cameraPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCloud(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:231
	Result_void cv_kinfu_KinFu_getCloud_const_const__OutputArrayR_const__OutputArrayR(const cv::kinfu::KinFu* instance, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getCloud(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:239
	Result_void cv_kinfu_KinFu_getPoints_const_const__OutputArrayR(const cv::kinfu::KinFu* instance, const cv::_OutputArray* points) {
		try {
			instance->getPoints(*points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormals(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:245
	Result_void cv_kinfu_KinFu_getNormals_const_const__InputArrayR_const__OutputArrayR(const cv::kinfu::KinFu* instance, const cv::_InputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getNormals(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:251
	Result_void cv_kinfu_KinFu_reset(cv::kinfu::KinFu* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:254
	Result<const cv::Affine3f> cv_kinfu_KinFu_getPose_const(const cv::kinfu::KinFu* instance) {
		try {
			const cv::Affine3f ret = instance->getPose();
			return Ok<const cv::Affine3f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Affine3f>))
	}
	
	// update(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:264
	Result<bool> cv_kinfu_KinFu_update_const__InputArrayR(cv::kinfu::KinFu* instance, const cv::_InputArray* depth) {
		try {
			bool ret = instance->update(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:83
	cv::Size cv_kinfu_Params_getPropFrameSize_const(const cv::kinfu::Params* instance) {
		cv::Size ret = instance->frameSize;
		return (cv::Size)ret;
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:83
	void cv_kinfu_Params_setPropFrameSize_Size(cv::kinfu::Params* instance, cv::Size* val) {
		instance->frameSize = *val;
	}
	
	// volumeType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:86
	cv::kinfu::VolumeType cv_kinfu_Params_getPropVolumeType_const(const cv::kinfu::Params* instance) {
		cv::kinfu::VolumeType ret = instance->volumeType;
		return (cv::kinfu::VolumeType)ret;
	}
	
	// volumeType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:86
	void cv_kinfu_Params_setPropVolumeType_VolumeType(cv::kinfu::Params* instance, cv::kinfu::VolumeType val) {
		instance->volumeType = val;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:89
	cv::Matx33f cv_kinfu_Params_getPropIntr_const(const cv::kinfu::Params* instance) {
		cv::Matx33f ret = instance->intr;
		return (cv::Matx33f)ret;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:89
	void cv_kinfu_Params_setPropIntr_Matx33f(cv::kinfu::Params* instance, cv::Matx33f* val) {
		instance->intr = *val;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:92
	cv::Matx33f cv_kinfu_Params_getPropRgb_intr_const(const cv::kinfu::Params* instance) {
		cv::Matx33f ret = instance->rgb_intr;
		return (cv::Matx33f)ret;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:92
	void cv_kinfu_Params_setPropRgb_intr_Matx33f(cv::kinfu::Params* instance, cv::Matx33f* val) {
		instance->rgb_intr = *val;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:100
	float cv_kinfu_Params_getPropDepthFactor_const(const cv::kinfu::Params* instance) {
		float ret = instance->depthFactor;
		return (float)ret;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:100
	void cv_kinfu_Params_setPropDepthFactor_float(cv::kinfu::Params* instance, float val) {
		instance->depthFactor = val;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:103
	float cv_kinfu_Params_getPropBilateral_sigma_depth_const(const cv::kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_depth;
		return (float)ret;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:103
	void cv_kinfu_Params_setPropBilateral_sigma_depth_float(cv::kinfu::Params* instance, float val) {
		instance->bilateral_sigma_depth = val;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:105
	float cv_kinfu_Params_getPropBilateral_sigma_spatial_const(const cv::kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_spatial;
		return (float)ret;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:105
	void cv_kinfu_Params_setPropBilateral_sigma_spatial_float(cv::kinfu::Params* instance, float val) {
		instance->bilateral_sigma_spatial = val;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:107
	int cv_kinfu_Params_getPropBilateral_kernel_size_const(const cv::kinfu::Params* instance) {
		int ret = instance->bilateral_kernel_size;
		return (int)ret;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:107
	void cv_kinfu_Params_setPropBilateral_kernel_size_int(cv::kinfu::Params* instance, int val) {
		instance->bilateral_kernel_size = val;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:110
	int cv_kinfu_Params_getPropPyramidLevels_const(const cv::kinfu::Params* instance) {
		int ret = instance->pyramidLevels;
		return (int)ret;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:110
	void cv_kinfu_Params_setPropPyramidLevels_int(cv::kinfu::Params* instance, int val) {
		instance->pyramidLevels = val;
	}
	
	// volumeDims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:116
	cv::Vec3i cv_kinfu_Params_getPropVolumeDims_const(const cv::kinfu::Params* instance) {
		cv::Vec3i ret = instance->volumeDims;
		return (cv::Vec3i)ret;
	}
	
	// volumeDims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:116
	void cv_kinfu_Params_setPropVolumeDims_Vec3i(cv::kinfu::Params* instance, cv::Vec3i* val) {
		instance->volumeDims = *val;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:118
	float cv_kinfu_Params_getPropVoxelSize_const(const cv::kinfu::Params* instance) {
		float ret = instance->voxelSize;
		return (float)ret;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:118
	void cv_kinfu_Params_setPropVoxelSize_float(cv::kinfu::Params* instance, float val) {
		instance->voxelSize = val;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:124
	float cv_kinfu_Params_getPropTsdf_min_camera_movement_const(const cv::kinfu::Params* instance) {
		float ret = instance->tsdf_min_camera_movement;
		return (float)ret;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:124
	void cv_kinfu_Params_setPropTsdf_min_camera_movement_float(cv::kinfu::Params* instance, float val) {
		instance->tsdf_min_camera_movement = val;
	}
	
	// volumePose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:127
	cv::Affine3f cv_kinfu_Params_getPropVolumePose_const(const cv::kinfu::Params* instance) {
		cv::Affine3f ret = instance->volumePose;
		return (cv::Affine3f)ret;
	}
	
	// volumePose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:127
	void cv_kinfu_Params_setPropVolumePose_Affine3f(cv::kinfu::Params* instance, cv::Affine3f* val) {
		instance->volumePose = *val;
	}
	
	// tsdf_trunc_dist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:133
	float cv_kinfu_Params_getPropTsdf_trunc_dist_const(const cv::kinfu::Params* instance) {
		float ret = instance->tsdf_trunc_dist;
		return (float)ret;
	}
	
	// tsdf_trunc_dist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:133
	void cv_kinfu_Params_setPropTsdf_trunc_dist_float(cv::kinfu::Params* instance, float val) {
		instance->tsdf_trunc_dist = val;
	}
	
	// tsdf_max_weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:139
	int cv_kinfu_Params_getPropTsdf_max_weight_const(const cv::kinfu::Params* instance) {
		int ret = instance->tsdf_max_weight;
		return (int)ret;
	}
	
	// tsdf_max_weight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:139
	void cv_kinfu_Params_setPropTsdf_max_weight_int(cv::kinfu::Params* instance, int val) {
		instance->tsdf_max_weight = val;
	}
	
	// raycast_step_factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:145
	float cv_kinfu_Params_getPropRaycast_step_factor_const(const cv::kinfu::Params* instance) {
		float ret = instance->raycast_step_factor;
		return (float)ret;
	}
	
	// raycast_step_factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:145
	void cv_kinfu_Params_setPropRaycast_step_factor_float(cv::kinfu::Params* instance, float val) {
		instance->raycast_step_factor = val;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:152
	cv::Vec3f cv_kinfu_Params_getPropLightPose_const(const cv::kinfu::Params* instance) {
		cv::Vec3f ret = instance->lightPose;
		return (cv::Vec3f)ret;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:152
	void cv_kinfu_Params_setPropLightPose_Vec3f(cv::kinfu::Params* instance, cv::Vec3f* val) {
		instance->lightPose = *val;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:155
	float cv_kinfu_Params_getPropIcpDistThresh_const(const cv::kinfu::Params* instance) {
		float ret = instance->icpDistThresh;
		return (float)ret;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:155
	void cv_kinfu_Params_setPropIcpDistThresh_float(cv::kinfu::Params* instance, float val) {
		instance->icpDistThresh = val;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:157
	float cv_kinfu_Params_getPropIcpAngleThresh_const(const cv::kinfu::Params* instance) {
		float ret = instance->icpAngleThresh;
		return (float)ret;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:157
	void cv_kinfu_Params_setPropIcpAngleThresh_float(cv::kinfu::Params* instance, float val) {
		instance->icpAngleThresh = val;
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:159
	std::vector<int>* cv_kinfu_Params_getPropIcpIterations_const(const cv::kinfu::Params* instance) {
		std::vector<int> ret = instance->icpIterations;
		return new std::vector<int>(ret);
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:159
	void cv_kinfu_Params_setPropIcpIterations_vector_int_(cv::kinfu::Params* instance, std::vector<int>* val) {
		instance->icpIterations = *val;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:165
	float cv_kinfu_Params_getPropTruncateThreshold_const(const cv::kinfu::Params* instance) {
		float ret = instance->truncateThreshold;
		return (float)ret;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:165
	void cv_kinfu_Params_setPropTruncateThreshold_float(cv::kinfu::Params* instance, float val) {
		instance->truncateThreshold = val;
	}
	
	void cv_Kinfu_Params_delete(cv::kinfu::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:22
	Result<cv::kinfu::Params*> cv_kinfu_Params_Params() {
		try {
			cv::kinfu::Params* ret = new cv::kinfu::Params();
			return Ok<cv::kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Params*>))
	}
	
	// Params(cv::Matx33f, cv::Vec3f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:30
	Result<cv::kinfu::Params*> cv_kinfu_Params_Params_Matx33f_Vec3f(cv::Matx33f* volumeInitialPoseRot, cv::Vec3f* volumeInitialPoseTransl) {
		try {
			cv::kinfu::Params* ret = new cv::kinfu::Params(*volumeInitialPoseRot, *volumeInitialPoseTransl);
			return Ok<cv::kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Params*>))
	}
	
	// Params(cv::Matx44f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:40
	Result<cv::kinfu::Params*> cv_kinfu_Params_Params_Matx44f(cv::Matx44f* volumeInitialPose) {
		try {
			cv::kinfu::Params* ret = new cv::kinfu::Params(*volumeInitialPose);
			return Ok<cv::kinfu::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::kinfu::Params*>))
	}
	
	// setInitialVolumePose(cv::Matx33f, cv::Vec3f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:51
	Result_void cv_kinfu_Params_setInitialVolumePose_Matx33f_Vec3f(cv::kinfu::Params* instance, cv::Matx33f* R, cv::Vec3f* t) {
		try {
			instance->setInitialVolumePose(*R, *t);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInitialVolumePose(cv::Matx44f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:58
	Result_void cv_kinfu_Params_setInitialVolumePose_Matx44f(cv::kinfu::Params* instance, cv::Matx44f* homogen_tf) {
		try {
			instance->setInitialVolumePose(*homogen_tf);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// defaultParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:64
	Result<cv::Ptr<cv::kinfu::Params>*> cv_kinfu_Params_defaultParams() {
		try {
			cv::Ptr<cv::kinfu::Params> ret = cv::kinfu::Params::defaultParams();
			return Ok(new cv::Ptr<cv::kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::Params>*>))
	}
	
	// coarseParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:70
	Result<cv::Ptr<cv::kinfu::Params>*> cv_kinfu_Params_coarseParams() {
		try {
			cv::Ptr<cv::kinfu::Params> ret = cv::kinfu::Params::coarseParams();
			return Ok(new cv::Ptr<cv::kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::Params>*>))
	}
	
	// hashTSDFParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:75
	Result<cv::Ptr<cv::kinfu::Params>*> cv_kinfu_Params_hashTSDFParams_bool(bool isCoarse) {
		try {
			cv::Ptr<cv::kinfu::Params> ret = cv::kinfu::Params::hashTSDFParams(isCoarse);
			return Ok(new cv::Ptr<cv::kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::Params>*>))
	}
	
	// coloredTSDFParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/kinfu.hpp:80
	Result<cv::Ptr<cv::kinfu::Params>*> cv_kinfu_Params_coloredTSDFParams_bool(bool isCoarse) {
		try {
			cv::Ptr<cv::kinfu::Params> ret = cv::kinfu::Params::coloredTSDFParams(isCoarse);
			return Ok(new cv::Ptr<cv::kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::Params>*>))
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:45
	const float cv_kinfu_Volume_getPropVoxelSize_const(const cv::kinfu::Volume* instance) {
		const float ret = instance->voxelSize;
		return (const float)ret;
	}
	
	// voxelSizeInv /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:46
	const float cv_kinfu_Volume_getPropVoxelSizeInv_const(const cv::kinfu::Volume* instance) {
		const float ret = instance->voxelSizeInv;
		return (const float)ret;
	}
	
	// pose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:47
	const cv::Affine3f cv_kinfu_Volume_getPropPose_const(const cv::kinfu::Volume* instance) {
		const cv::Affine3f ret = instance->pose;
		return (const cv::Affine3f)ret;
	}
	
	// raycastStepFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:48
	const float cv_kinfu_Volume_getPropRaycastStepFactor_const(const cv::kinfu::Volume* instance) {
		const float ret = instance->raycastStepFactor;
		return (const float)ret;
	}
	
	// integrate(cv::InputArray, float, const cv::Matx44f &, const kinfu::Intr &, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:31
	Result_void cv_kinfu_Volume_integrate_const__InputArrayR_float_const_Matx44fR_const_IntrR_const_int(cv::kinfu::Volume* instance, const cv::_InputArray* _depth, float depthFactor, const cv::Matx44f* cameraPose, const cv::kinfu::Intr* intrinsics, const int frameId) {
		try {
			instance->integrate(*_depth, depthFactor, *cameraPose, *intrinsics, frameId);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// integrate(cv::InputArray, cv::InputArray, float, const cv::Matx44f &, const kinfu::Intr &, const cv::kinfu::Intr &, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:33
	Result_void cv_kinfu_Volume_integrate_const__InputArrayR_const__InputArrayR_float_const_Matx44fR_const_IntrR_const_IntrR_const_int(cv::kinfu::Volume* instance, const cv::_InputArray* _depth, const cv::_InputArray* _rgb, float depthFactor, const cv::Matx44f* cameraPose, const cv::kinfu::Intr* intrinsics, const cv::kinfu::Intr* rgb_intrinsics, const int frameId) {
		try {
			instance->integrate(*_depth, *_rgb, depthFactor, *cameraPose, *intrinsics, *rgb_intrinsics, frameId);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// raycast(const cv::Matx44f &, const kinfu::Intr &, const cv::Size &, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:36
	Result_void cv_kinfu_Volume_raycast_const_const_Matx44fR_const_IntrR_const_SizeR_const__OutputArrayR_const__OutputArrayR(const cv::kinfu::Volume* instance, const cv::Matx44f* cameraPose, const cv::kinfu::Intr* intrinsics, const cv::Size* frameSize, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->raycast(*cameraPose, *intrinsics, *frameSize, *points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// raycast(const cv::Matx44f &, const kinfu::Intr &, const cv::Size &, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:38
	Result_void cv_kinfu_Volume_raycast_const_const_Matx44fR_const_IntrR_const_SizeR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::kinfu::Volume* instance, const cv::Matx44f* cameraPose, const cv::kinfu::Intr* intrinsics, const cv::Size* frameSize, const cv::_OutputArray* points, const cv::_OutputArray* normals, const cv::_OutputArray* colors) {
		try {
			instance->raycast(*cameraPose, *intrinsics, *frameSize, *points, *normals, *colors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fetchNormals(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:40
	Result_void cv_kinfu_Volume_fetchNormals_const_const__InputArrayR_const__OutputArrayR(const cv::kinfu::Volume* instance, const cv::_InputArray* points, const cv::_OutputArray* _normals) {
		try {
			instance->fetchNormals(*points, *_normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fetchPointsNormals(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:41
	Result_void cv_kinfu_Volume_fetchPointsNormals_const_const__OutputArrayR_const__OutputArrayR(const cv::kinfu::Volume* instance, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->fetchPointsNormals(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:42
	Result_void cv_kinfu_Volume_reset(cv::kinfu::Volume* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:63
	cv::kinfu::VolumeType cv_kinfu_VolumeParams_getPropType_const(const cv::kinfu::VolumeParams* instance) {
		cv::kinfu::VolumeType ret = instance->type;
		return (cv::kinfu::VolumeType)ret;
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:63
	void cv_kinfu_VolumeParams_setPropType_VolumeType(cv::kinfu::VolumeParams* instance, cv::kinfu::VolumeType val) {
		instance->type = val;
	}
	
	// resolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:70
	cv::Vec3i cv_kinfu_VolumeParams_getPropResolution_const(const cv::kinfu::VolumeParams* instance) {
		cv::Vec3i ret = instance->resolution;
		return (cv::Vec3i)ret;
	}
	
	// resolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:70
	void cv_kinfu_VolumeParams_setPropResolution_Vec3i(cv::kinfu::VolumeParams* instance, cv::Vec3i* val) {
		instance->resolution = *val;
	}
	
	// unitResolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:76
	int cv_kinfu_VolumeParams_getPropUnitResolution_const(const cv::kinfu::VolumeParams* instance) {
		int ret = instance->unitResolution;
		return (int)ret;
	}
	
	// unitResolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:76
	void cv_kinfu_VolumeParams_setPropUnitResolution_int(cv::kinfu::VolumeParams* instance, int val) {
		instance->unitResolution = val;
	}
	
	// pose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:79
	cv::Affine3f cv_kinfu_VolumeParams_getPropPose_const(const cv::kinfu::VolumeParams* instance) {
		cv::Affine3f ret = instance->pose;
		return (cv::Affine3f)ret;
	}
	
	// pose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:79
	void cv_kinfu_VolumeParams_setPropPose_Affine3f(cv::kinfu::VolumeParams* instance, cv::Affine3f* val) {
		instance->pose = *val;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:82
	float cv_kinfu_VolumeParams_getPropVoxelSize_const(const cv::kinfu::VolumeParams* instance) {
		float ret = instance->voxelSize;
		return (float)ret;
	}
	
	// voxelSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:82
	void cv_kinfu_VolumeParams_setPropVoxelSize_float(cv::kinfu::VolumeParams* instance, float val) {
		instance->voxelSize = val;
	}
	
	// tsdfTruncDist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:87
	float cv_kinfu_VolumeParams_getPropTsdfTruncDist_const(const cv::kinfu::VolumeParams* instance) {
		float ret = instance->tsdfTruncDist;
		return (float)ret;
	}
	
	// tsdfTruncDist /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:87
	void cv_kinfu_VolumeParams_setPropTsdfTruncDist_float(cv::kinfu::VolumeParams* instance, float val) {
		instance->tsdfTruncDist = val;
	}
	
	// maxWeight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:93
	int cv_kinfu_VolumeParams_getPropMaxWeight_const(const cv::kinfu::VolumeParams* instance) {
		int ret = instance->maxWeight;
		return (int)ret;
	}
	
	// maxWeight /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:93
	void cv_kinfu_VolumeParams_setPropMaxWeight_int(cv::kinfu::VolumeParams* instance, int val) {
		instance->maxWeight = val;
	}
	
	// depthTruncThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:98
	float cv_kinfu_VolumeParams_getPropDepthTruncThreshold_const(const cv::kinfu::VolumeParams* instance) {
		float ret = instance->depthTruncThreshold;
		return (float)ret;
	}
	
	// depthTruncThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:98
	void cv_kinfu_VolumeParams_setPropDepthTruncThreshold_float(cv::kinfu::VolumeParams* instance, float val) {
		instance->depthTruncThreshold = val;
	}
	
	// raycastStepFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:103
	float cv_kinfu_VolumeParams_getPropRaycastStepFactor_const(const cv::kinfu::VolumeParams* instance) {
		float ret = instance->raycastStepFactor;
		return (float)ret;
	}
	
	// raycastStepFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:103
	void cv_kinfu_VolumeParams_setPropRaycastStepFactor_float(cv::kinfu::VolumeParams* instance, float val) {
		instance->raycastStepFactor = val;
	}
	
	void cv_Kinfu_VolumeParams_delete(cv::kinfu::VolumeParams* instance) {
		delete instance;
	}
	// defaultParams(cv::kinfu::VolumeType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:108
	Result<cv::Ptr<cv::kinfu::VolumeParams>*> cv_kinfu_VolumeParams_defaultParams_VolumeType(cv::kinfu::VolumeType _volumeType) {
		try {
			cv::Ptr<cv::kinfu::VolumeParams> ret = cv::kinfu::VolumeParams::defaultParams(_volumeType);
			return Ok(new cv::Ptr<cv::kinfu::VolumeParams>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::VolumeParams>*>))
	}
	
	// coarseParams(cv::kinfu::VolumeType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/volume.hpp:113
	Result<cv::Ptr<cv::kinfu::VolumeParams>*> cv_kinfu_VolumeParams_coarseParams_VolumeType(cv::kinfu::VolumeType _volumeType) {
		try {
			cv::Ptr<cv::kinfu::VolumeParams> ret = cv::kinfu::VolumeParams::coarseParams(_volumeType);
			return Ok(new cv::Ptr<cv::kinfu::VolumeParams>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::VolumeParams>*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:29
	Result<cv::Ptr<cv::kinfu::detail::PoseGraph>*> cv_kinfu_detail_PoseGraph_create() {
		try {
			cv::Ptr<cv::kinfu::detail::PoseGraph> ret = cv::kinfu::detail::PoseGraph::create();
			return Ok(new cv::Ptr<cv::kinfu::detail::PoseGraph>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::kinfu::detail::PoseGraph>*>))
	}
	
	// addNode(size_t, const cv::Affine3d &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:33
	Result_void cv_kinfu_detail_PoseGraph_addNode_size_t_const_Affine3dR_bool(cv::kinfu::detail::PoseGraph* instance, size_t _nodeId, const cv::Affine3d* _pose, bool fixed) {
		try {
			instance->addNode(_nodeId, *_pose, fixed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isNodeExist(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:34
	Result<bool> cv_kinfu_detail_PoseGraph_isNodeExist_const_size_t(const cv::kinfu::detail::PoseGraph* instance, size_t nodeId) {
		try {
			bool ret = instance->isNodeExist(nodeId);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setNodeFixed(size_t, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:35
	Result<bool> cv_kinfu_detail_PoseGraph_setNodeFixed_size_t_bool(cv::kinfu::detail::PoseGraph* instance, size_t nodeId, bool fixed) {
		try {
			bool ret = instance->setNodeFixed(nodeId, fixed);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isNodeFixed(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:36
	Result<bool> cv_kinfu_detail_PoseGraph_isNodeFixed_const_size_t(const cv::kinfu::detail::PoseGraph* instance, size_t nodeId) {
		try {
			bool ret = instance->isNodeFixed(nodeId);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getNodePose(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:37
	Result<cv::Affine3d> cv_kinfu_detail_PoseGraph_getNodePose_const_size_t(const cv::kinfu::detail::PoseGraph* instance, size_t nodeId) {
		try {
			cv::Affine3d ret = instance->getNodePose(nodeId);
			return Ok<cv::Affine3d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Affine3d>))
	}
	
	// getNodesIds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:38
	Result<std::vector<size_t>*> cv_kinfu_detail_PoseGraph_getNodesIds_const(const cv::kinfu::detail::PoseGraph* instance) {
		try {
			std::vector<size_t> ret = instance->getNodesIds();
			return Ok(new std::vector<size_t>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<size_t>*>))
	}
	
	// getNumNodes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:39
	Result<size_t> cv_kinfu_detail_PoseGraph_getNumNodes_const(const cv::kinfu::detail::PoseGraph* instance) {
		try {
			size_t ret = instance->getNumNodes();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// addEdge(size_t, size_t, const cv::Affine3f &, const cv::Matx66f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:42
	Result_void cv_kinfu_detail_PoseGraph_addEdge_size_t_size_t_const_Affine3fR_const_Matx66fR(cv::kinfu::detail::PoseGraph* instance, size_t _sourceNodeId, size_t _targetNodeId, const cv::Affine3f* _transformation, const cv::Matx66f* _information) {
		try {
			instance->addEdge(_sourceNodeId, _targetNodeId, *_transformation, *_information);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeStart(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:44
	Result<size_t> cv_kinfu_detail_PoseGraph_getEdgeStart_const_size_t(const cv::kinfu::detail::PoseGraph* instance, size_t i) {
		try {
			size_t ret = instance->getEdgeStart(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// getEdgeEnd(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:45
	Result<size_t> cv_kinfu_detail_PoseGraph_getEdgeEnd_const_size_t(const cv::kinfu::detail::PoseGraph* instance, size_t i) {
		try {
			size_t ret = instance->getEdgeEnd(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// getNumEdges() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:46
	Result<size_t> cv_kinfu_detail_PoseGraph_getNumEdges_const(const cv::kinfu::detail::PoseGraph* instance) {
		try {
			size_t ret = instance->getNumEdges();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// isValid() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:49
	Result<bool> cv_kinfu_detail_PoseGraph_isValid_const(const cv::kinfu::detail::PoseGraph* instance) {
		try {
			bool ret = instance->isValid();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// optimize(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:53
	Result<int> cv_kinfu_detail_PoseGraph_optimize_const_TermCriteriaR(cv::kinfu::detail::PoseGraph* instance, const cv::TermCriteria* tc) {
		try {
			int ret = instance->optimize(*tc);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// calcEnergy() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/detail/pose_graph.hpp:56
	Result<double> cv_kinfu_detail_PoseGraph_calcEnergy_const(const cv::kinfu::detail::PoseGraph* instance) {
		try {
			double ret = instance->calcEnergy();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// create(const Ptr<cv::large_kinfu::Params> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:123
	Result<cv::Ptr<cv::large_kinfu::LargeKinfu>*> cv_large_kinfu_LargeKinfu_create_const_Ptr_Params_R(const cv::Ptr<cv::large_kinfu::Params>* _params) {
		try {
			cv::Ptr<cv::large_kinfu::LargeKinfu> ret = cv::large_kinfu::LargeKinfu::create(*_params);
			return Ok(new cv::Ptr<cv::large_kinfu::LargeKinfu>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::large_kinfu::LargeKinfu>*>))
	}
	
	// getParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:126
	Result<const cv::large_kinfu::Params*> cv_large_kinfu_LargeKinfu_getParams_const(const cv::large_kinfu::LargeKinfu* instance) {
		try {
			const cv::large_kinfu::Params ret = instance->getParams();
			return Ok(new const cv::large_kinfu::Params(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::large_kinfu::Params*>))
	}
	
	// render(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:128
	Result_void cv_large_kinfu_LargeKinfu_render_const_const__OutputArrayR(const cv::large_kinfu::LargeKinfu* instance, const cv::_OutputArray* image) {
		try {
			instance->render(*image);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(cv::OutputArray, const cv::Matx44f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:129
	Result_void cv_large_kinfu_LargeKinfu_render_const_const__OutputArrayR_const_Matx44fR(const cv::large_kinfu::LargeKinfu* instance, const cv::_OutputArray* image, const cv::Matx44f* cameraPose) {
		try {
			instance->render(*image, *cameraPose);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCloud(cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:131
	Result_void cv_large_kinfu_LargeKinfu_getCloud_const_const__OutputArrayR_const__OutputArrayR(const cv::large_kinfu::LargeKinfu* instance, const cv::_OutputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getCloud(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPoints(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:133
	Result_void cv_large_kinfu_LargeKinfu_getPoints_const_const__OutputArrayR(const cv::large_kinfu::LargeKinfu* instance, const cv::_OutputArray* points) {
		try {
			instance->getPoints(*points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormals(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:135
	Result_void cv_large_kinfu_LargeKinfu_getNormals_const_const__InputArrayR_const__OutputArrayR(const cv::large_kinfu::LargeKinfu* instance, const cv::_InputArray* points, const cv::_OutputArray* normals) {
		try {
			instance->getNormals(*points, *normals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:137
	Result_void cv_large_kinfu_LargeKinfu_reset(cv::large_kinfu::LargeKinfu* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPose() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:139
	Result<const cv::Affine3f> cv_large_kinfu_LargeKinfu_getPose_const(const cv::large_kinfu::LargeKinfu* instance) {
		try {
			const cv::Affine3f ret = instance->getPose();
			return Ok<const cv::Affine3f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Affine3f>))
	}
	
	// update(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:141
	Result<bool> cv_large_kinfu_LargeKinfu_update_const__InputArrayR(cv::large_kinfu::LargeKinfu* instance, const cv::_InputArray* depth) {
		try {
			bool ret = instance->update(*depth);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:39
	cv::Size cv_large_kinfu_Params_getPropFrameSize_const(const cv::large_kinfu::Params* instance) {
		cv::Size ret = instance->frameSize;
		return (cv::Size)ret;
	}
	
	// frameSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:39
	void cv_large_kinfu_Params_setPropFrameSize_Size(cv::large_kinfu::Params* instance, cv::Size* val) {
		instance->frameSize = *val;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:42
	cv::Matx33f cv_large_kinfu_Params_getPropIntr_const(const cv::large_kinfu::Params* instance) {
		cv::Matx33f ret = instance->intr;
		return (cv::Matx33f)ret;
	}
	
	// intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:42
	void cv_large_kinfu_Params_setPropIntr_Matx33f(cv::large_kinfu::Params* instance, cv::Matx33f* val) {
		instance->intr = *val;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:45
	cv::Matx33f cv_large_kinfu_Params_getPropRgb_intr_const(const cv::large_kinfu::Params* instance) {
		cv::Matx33f ret = instance->rgb_intr;
		return (cv::Matx33f)ret;
	}
	
	// rgb_intr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:45
	void cv_large_kinfu_Params_setPropRgb_intr_Matx33f(cv::large_kinfu::Params* instance, cv::Matx33f* val) {
		instance->rgb_intr = *val;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:53
	float cv_large_kinfu_Params_getPropDepthFactor_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->depthFactor;
		return (float)ret;
	}
	
	// depthFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:53
	void cv_large_kinfu_Params_setPropDepthFactor_float(cv::large_kinfu::Params* instance, float val) {
		instance->depthFactor = val;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:56
	float cv_large_kinfu_Params_getPropBilateral_sigma_depth_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_depth;
		return (float)ret;
	}
	
	// bilateral_sigma_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:56
	void cv_large_kinfu_Params_setPropBilateral_sigma_depth_float(cv::large_kinfu::Params* instance, float val) {
		instance->bilateral_sigma_depth = val;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:58
	float cv_large_kinfu_Params_getPropBilateral_sigma_spatial_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->bilateral_sigma_spatial;
		return (float)ret;
	}
	
	// bilateral_sigma_spatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:58
	void cv_large_kinfu_Params_setPropBilateral_sigma_spatial_float(cv::large_kinfu::Params* instance, float val) {
		instance->bilateral_sigma_spatial = val;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:60
	int cv_large_kinfu_Params_getPropBilateral_kernel_size_const(const cv::large_kinfu::Params* instance) {
		int ret = instance->bilateral_kernel_size;
		return (int)ret;
	}
	
	// bilateral_kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:60
	void cv_large_kinfu_Params_setPropBilateral_kernel_size_int(cv::large_kinfu::Params* instance, int val) {
		instance->bilateral_kernel_size = val;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:63
	int cv_large_kinfu_Params_getPropPyramidLevels_const(const cv::large_kinfu::Params* instance) {
		int ret = instance->pyramidLevels;
		return (int)ret;
	}
	
	// pyramidLevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:63
	void cv_large_kinfu_Params_setPropPyramidLevels_int(cv::large_kinfu::Params* instance, int val) {
		instance->pyramidLevels = val;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:68
	float cv_large_kinfu_Params_getPropTsdf_min_camera_movement_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->tsdf_min_camera_movement;
		return (float)ret;
	}
	
	// tsdf_min_camera_movement /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:68
	void cv_large_kinfu_Params_setPropTsdf_min_camera_movement_float(cv::large_kinfu::Params* instance, float val) {
		instance->tsdf_min_camera_movement = val;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:71
	cv::Vec3f cv_large_kinfu_Params_getPropLightPose_const(const cv::large_kinfu::Params* instance) {
		cv::Vec3f ret = instance->lightPose;
		return (cv::Vec3f)ret;
	}
	
	// lightPose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:71
	void cv_large_kinfu_Params_setPropLightPose_Vec3f(cv::large_kinfu::Params* instance, cv::Vec3f* val) {
		instance->lightPose = *val;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:74
	float cv_large_kinfu_Params_getPropIcpDistThresh_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->icpDistThresh;
		return (float)ret;
	}
	
	// icpDistThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:74
	void cv_large_kinfu_Params_setPropIcpDistThresh_float(cv::large_kinfu::Params* instance, float val) {
		instance->icpDistThresh = val;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:76
	float cv_large_kinfu_Params_getPropIcpAngleThresh_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->icpAngleThresh;
		return (float)ret;
	}
	
	// icpAngleThresh /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:76
	void cv_large_kinfu_Params_setPropIcpAngleThresh_float(cv::large_kinfu::Params* instance, float val) {
		instance->icpAngleThresh = val;
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:78
	std::vector<int>* cv_large_kinfu_Params_getPropIcpIterations_const(const cv::large_kinfu::Params* instance) {
		std::vector<int> ret = instance->icpIterations;
		return new std::vector<int>(ret);
	}
	
	// icpIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:78
	void cv_large_kinfu_Params_setPropIcpIterations_vector_int_(cv::large_kinfu::Params* instance, std::vector<int>* val) {
		instance->icpIterations = *val;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:83
	float cv_large_kinfu_Params_getPropTruncateThreshold_const(const cv::large_kinfu::Params* instance) {
		float ret = instance->truncateThreshold;
		return (float)ret;
	}
	
	// truncateThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:83
	void cv_large_kinfu_Params_setPropTruncateThreshold_float(cv::large_kinfu::Params* instance, float val) {
		instance->truncateThreshold = val;
	}
	
	// volumeParams /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:87
	cv::kinfu::VolumeParams* cv_large_kinfu_Params_getPropVolumeParams_const(const cv::large_kinfu::Params* instance) {
		cv::kinfu::VolumeParams ret = instance->volumeParams;
		return new cv::kinfu::VolumeParams(ret);
	}
	
	// volumeParams /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:87
	void cv_large_kinfu_Params_setPropVolumeParams_VolumeParams(cv::large_kinfu::Params* instance, cv::kinfu::VolumeParams* val) {
		instance->volumeParams = *val;
	}
	
	void cv_Params_delete(cv::large_kinfu::Params* instance) {
		delete instance;
	}
	// defaultParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:25
	Result<cv::Ptr<cv::large_kinfu::Params>*> cv_large_kinfu_Params_defaultParams() {
		try {
			cv::Ptr<cv::large_kinfu::Params> ret = cv::large_kinfu::Params::defaultParams();
			return Ok(new cv::Ptr<cv::large_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::large_kinfu::Params>*>))
	}
	
	// coarseParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:31
	Result<cv::Ptr<cv::large_kinfu::Params>*> cv_large_kinfu_Params_coarseParams() {
		try {
			cv::Ptr<cv::large_kinfu::Params> ret = cv::large_kinfu::Params::coarseParams();
			return Ok(new cv::Ptr<cv::large_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::large_kinfu::Params>*>))
	}
	
	// hashTSDFParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/large_kinfu.hpp:36
	Result<cv::Ptr<cv::large_kinfu::Params>*> cv_large_kinfu_Params_hashTSDFParams_bool(bool isCoarse) {
		try {
			cv::Ptr<cv::large_kinfu::Params> ret = cv::large_kinfu::Params::hashTSDFParams(isCoarse);
			return Ok(new cv::Ptr<cv::large_kinfu::Params>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::large_kinfu::Params>*>))
	}
	
	// weak_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:191
	float cv_linemod_ColorGradient_getPropWeak_threshold_const(const cv::linemod::ColorGradient* instance) {
		float ret = instance->weak_threshold;
		return (float)ret;
	}
	
	// weak_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:191
	void cv_linemod_ColorGradient_setPropWeak_threshold_float(cv::linemod::ColorGradient* instance, float val) {
		instance->weak_threshold = val;
	}
	
	// num_features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:192
	size_t cv_linemod_ColorGradient_getPropNum_features_const(const cv::linemod::ColorGradient* instance) {
		size_t ret = instance->num_features;
		return (size_t)ret;
	}
	
	// num_features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:192
	void cv_linemod_ColorGradient_setPropNum_features_size_t(cv::linemod::ColorGradient* instance, size_t val) {
		instance->num_features = val;
	}
	
	// strong_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:193
	float cv_linemod_ColorGradient_getPropStrong_threshold_const(const cv::linemod::ColorGradient* instance) {
		float ret = instance->strong_threshold;
		return (float)ret;
	}
	
	// strong_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:193
	void cv_linemod_ColorGradient_setPropStrong_threshold_float(cv::linemod::ColorGradient* instance, float val) {
		instance->strong_threshold = val;
	}
	
	void cv_Linemod_ColorGradient_delete(cv::linemod::ColorGradient* instance) {
		delete instance;
	}
	// ColorGradient() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:172
	Result<cv::linemod::ColorGradient*> cv_linemod_ColorGradient_ColorGradient() {
		try {
			cv::linemod::ColorGradient* ret = new cv::linemod::ColorGradient();
			return Ok<cv::linemod::ColorGradient*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::ColorGradient*>))
	}
	
	// ColorGradient(float, size_t, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:182
	Result<cv::linemod::ColorGradient*> cv_linemod_ColorGradient_ColorGradient_float_size_t_float(float weak_threshold, size_t num_features, float strong_threshold) {
		try {
			cv::linemod::ColorGradient* ret = new cv::linemod::ColorGradient(weak_threshold, num_features, strong_threshold);
			return Ok<cv::linemod::ColorGradient*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::ColorGradient*>))
	}
	
	// create(float, size_t, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:184
	Result<cv::Ptr<cv::linemod::ColorGradient>*> cv_linemod_ColorGradient_create_float_size_t_float(float weak_threshold, size_t num_features, float strong_threshold) {
		try {
			cv::Ptr<cv::linemod::ColorGradient> ret = cv::linemod::ColorGradient::create(weak_threshold, num_features, strong_threshold);
			return Ok(new cv::Ptr<cv::linemod::ColorGradient>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::ColorGradient>*>))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:186
	Result<void*> cv_linemod_ColorGradient_name_const(const cv::linemod::ColorGradient* instance) {
		try {
			cv::String ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:188
	Result_void cv_linemod_ColorGradient_read_const_FileNodeR(cv::linemod::ColorGradient* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:189
	Result_void cv_linemod_ColorGradient_write_const_FileStorageR(const cv::linemod::ColorGradient* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// distance_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:232
	int cv_linemod_DepthNormal_getPropDistance_threshold_const(const cv::linemod::DepthNormal* instance) {
		int ret = instance->distance_threshold;
		return (int)ret;
	}
	
	// distance_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:232
	void cv_linemod_DepthNormal_setPropDistance_threshold_int(cv::linemod::DepthNormal* instance, int val) {
		instance->distance_threshold = val;
	}
	
	// difference_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:233
	int cv_linemod_DepthNormal_getPropDifference_threshold_const(const cv::linemod::DepthNormal* instance) {
		int ret = instance->difference_threshold;
		return (int)ret;
	}
	
	// difference_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:233
	void cv_linemod_DepthNormal_setPropDifference_threshold_int(cv::linemod::DepthNormal* instance, int val) {
		instance->difference_threshold = val;
	}
	
	// num_features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:234
	size_t cv_linemod_DepthNormal_getPropNum_features_const(const cv::linemod::DepthNormal* instance) {
		size_t ret = instance->num_features;
		return (size_t)ret;
	}
	
	// num_features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:234
	void cv_linemod_DepthNormal_setPropNum_features_size_t(cv::linemod::DepthNormal* instance, size_t val) {
		instance->num_features = val;
	}
	
	// extract_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:235
	int cv_linemod_DepthNormal_getPropExtract_threshold_const(const cv::linemod::DepthNormal* instance) {
		int ret = instance->extract_threshold;
		return (int)ret;
	}
	
	// extract_threshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:235
	void cv_linemod_DepthNormal_setPropExtract_threshold_int(cv::linemod::DepthNormal* instance, int val) {
		instance->extract_threshold = val;
	}
	
	void cv_Linemod_DepthNormal_delete(cv::linemod::DepthNormal* instance) {
		delete instance;
	}
	// DepthNormal() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:209
	Result<cv::linemod::DepthNormal*> cv_linemod_DepthNormal_DepthNormal() {
		try {
			cv::linemod::DepthNormal* ret = new cv::linemod::DepthNormal();
			return Ok<cv::linemod::DepthNormal*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::DepthNormal*>))
	}
	
	// DepthNormal(int, int, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:221
	Result<cv::linemod::DepthNormal*> cv_linemod_DepthNormal_DepthNormal_int_int_size_t_int(int distance_threshold, int difference_threshold, size_t num_features, int extract_threshold) {
		try {
			cv::linemod::DepthNormal* ret = new cv::linemod::DepthNormal(distance_threshold, difference_threshold, num_features, extract_threshold);
			return Ok<cv::linemod::DepthNormal*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::DepthNormal*>))
	}
	
	// create(int, int, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:224
	Result<cv::Ptr<cv::linemod::DepthNormal>*> cv_linemod_DepthNormal_create_int_int_size_t_int(int distance_threshold, int difference_threshold, size_t num_features, int extract_threshold) {
		try {
			cv::Ptr<cv::linemod::DepthNormal> ret = cv::linemod::DepthNormal::create(distance_threshold, difference_threshold, num_features, extract_threshold);
			return Ok(new cv::Ptr<cv::linemod::DepthNormal>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::DepthNormal>*>))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:227
	Result<void*> cv_linemod_DepthNormal_name_const(const cv::linemod::DepthNormal* instance) {
		try {
			cv::String ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:229
	Result_void cv_linemod_DepthNormal_read_const_FileNodeR(cv::linemod::DepthNormal* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:230
	Result_void cv_linemod_DepthNormal_write_const_FileStorageR(const cv::linemod::DepthNormal* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Linemod_Detector_delete(cv::linemod::Detector* instance) {
		delete instance;
	}
	// Detector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:304
	Result<cv::linemod::Detector*> cv_linemod_Detector_Detector() {
		try {
			cv::linemod::Detector* ret = new cv::linemod::Detector();
			return Ok<cv::linemod::Detector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Detector*>))
	}
	
	// Detector(const std::vector<Ptr<Modality>> &, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:313
	Result<cv::linemod::Detector*> cv_linemod_Detector_Detector_const_vector_Ptr_Modality__R_const_vector_int_R(const std::vector<cv::Ptr<cv::linemod::Modality>>* modalities, const std::vector<int>* T_pyramid) {
		try {
			cv::linemod::Detector* ret = new cv::linemod::Detector(*modalities, *T_pyramid);
			return Ok<cv::linemod::Detector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Detector*>))
	}
	
	// match(const std::vector<Mat> &, float, std::vector<Match> &, const std::vector<String> &, cv::OutputArrayOfArrays, const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:330
	Result_void cv_linemod_Detector_match_const_const_vector_Mat_R_float_vector_Match_R_const_vector_String_R_const__OutputArrayR_const_vector_Mat_R(const cv::linemod::Detector* instance, const std::vector<cv::Mat>* sources, float threshold, std::vector<cv::linemod::Match>* matches, const std::vector<cv::String>* class_ids, const cv::_OutputArray* quantized_images, const std::vector<cv::Mat>* masks) {
		try {
			instance->match(*sources, threshold, *matches, *class_ids, *quantized_images, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addTemplate(const std::vector<Mat> &, const cv::String &, const cv::Mat &, cv::Rect *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:345
	Result<int> cv_linemod_Detector_addTemplate_const_vector_Mat_R_const_StringR_const_MatR_RectX(cv::linemod::Detector* instance, const std::vector<cv::Mat>* sources, const char* class_id, const cv::Mat* object_mask, cv::Rect* bounding_box) {
		try {
			int ret = instance->addTemplate(*sources, std::string(class_id), *object_mask, bounding_box);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addSyntheticTemplate(const std::vector<Template> &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:351
	Result<int> cv_linemod_Detector_addSyntheticTemplate_const_vector_Template_R_const_StringR(cv::linemod::Detector* instance, const std::vector<cv::linemod::Template>* templates, const char* class_id) {
		try {
			int ret = instance->addSyntheticTemplate(*templates, std::string(class_id));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getModalities() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:359
	Result<const std::vector<cv::Ptr<cv::linemod::Modality>>*> cv_linemod_Detector_getModalities_const(const cv::linemod::Detector* instance) {
		try {
			const std::vector<cv::Ptr<cv::linemod::Modality>> ret = instance->getModalities();
			return Ok(new const std::vector<cv::Ptr<cv::linemod::Modality>>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Ptr<cv::linemod::Modality>>*>))
	}
	
	// getT(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:364
	Result<int> cv_linemod_Detector_getT_const_int(const cv::linemod::Detector* instance, int pyramid_level) {
		try {
			int ret = instance->getT(pyramid_level);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// pyramidLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:369
	Result<int> cv_linemod_Detector_pyramidLevels_const(const cv::linemod::Detector* instance) {
		try {
			int ret = instance->pyramidLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getTemplates(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:377
	Result<const std::vector<cv::linemod::Template>*> cv_linemod_Detector_getTemplates_const_const_StringR_int(const cv::linemod::Detector* instance, const char* class_id, int template_id) {
		try {
			const std::vector<cv::linemod::Template> ret = instance->getTemplates(std::string(class_id), template_id);
			return Ok(new const std::vector<cv::linemod::Template>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::linemod::Template>*>))
	}
	
	// numTemplates() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:379
	Result<int> cv_linemod_Detector_numTemplates_const(const cv::linemod::Detector* instance) {
		try {
			int ret = instance->numTemplates();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// numTemplates(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:380
	Result<int> cv_linemod_Detector_numTemplates_const_const_StringR(const cv::linemod::Detector* instance, const char* class_id) {
		try {
			int ret = instance->numTemplates(std::string(class_id));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// numClasses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:381
	Result<int> cv_linemod_Detector_numClasses_const(const cv::linemod::Detector* instance) {
		try {
			int ret = instance->numClasses();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// classIds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:383
	Result<std::vector<cv::String>*> cv_linemod_Detector_classIds_const(const cv::linemod::Detector* instance) {
		try {
			std::vector<cv::String> ret = instance->classIds();
			return Ok(new std::vector<cv::String>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::String>*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:385
	Result_void cv_linemod_Detector_read_const_FileNodeR(cv::linemod::Detector* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:386
	Result_void cv_linemod_Detector_write_const_FileStorageR(const cv::linemod::Detector* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// readClass(const cv::FileNode &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:388
	Result<void*> cv_linemod_Detector_readClass_const_FileNodeR_const_StringR(cv::linemod::Detector* instance, const cv::FileNode* fn, const char* class_id_override) {
		try {
			cv::String ret = instance->readClass(*fn, std::string(class_id_override));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// writeClass(const cv::String &, cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:389
	Result_void cv_linemod_Detector_writeClass_const_const_StringR_FileStorageR(const cv::linemod::Detector* instance, const char* class_id, cv::FileStorage* fs) {
		try {
			instance->writeClass(std::string(class_id), *fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// readClasses(const std::vector<String> &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:391
	Result_void cv_linemod_Detector_readClasses_const_vector_String_R_const_StringR(cv::linemod::Detector* instance, const std::vector<cv::String>* class_ids, const char* format) {
		try {
			instance->readClasses(*class_ids, std::string(format));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeClasses(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:393
	Result_void cv_linemod_Detector_writeClasses_const_const_StringR(const cv::linemod::Detector* instance, const char* format) {
		try {
			instance->writeClasses(std::string(format));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Feature() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:32
	Result<cv::linemod::Feature> cv_linemod_Feature_Feature() {
		try {
			cv::linemod::Feature ret;
			return Ok<cv::linemod::Feature>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Feature>))
	}
	
	// Feature(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:33
	Result<cv::linemod::Feature> cv_linemod_Feature_Feature_int_int_int(int x, int y, int label) {
		try {
			cv::linemod::Feature ret(x, y, label);
			return Ok<cv::linemod::Feature>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Feature>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:35
	Result_void cv_linemod_Feature_read_const_FileNodeR(cv::linemod::Feature instance, const cv::FileNode* fn) {
		try {
			instance.read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:36
	Result_void cv_linemod_Feature_write_const_FileStorageR(const cv::linemod::Feature instance, cv::FileStorage* fs) {
		try {
			instance.write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// x /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:282
	int cv_linemod_Match_getPropX_const(const cv::linemod::Match* instance) {
		int ret = instance->x;
		return (int)ret;
	}
	
	// x /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:282
	void cv_linemod_Match_setPropX_int(cv::linemod::Match* instance, int val) {
		instance->x = val;
	}
	
	// y /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:283
	int cv_linemod_Match_getPropY_const(const cv::linemod::Match* instance) {
		int ret = instance->y;
		return (int)ret;
	}
	
	// y /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:283
	void cv_linemod_Match_setPropY_int(cv::linemod::Match* instance, int val) {
		instance->y = val;
	}
	
	// similarity /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:284
	float cv_linemod_Match_getPropSimilarity_const(const cv::linemod::Match* instance) {
		float ret = instance->similarity;
		return (float)ret;
	}
	
	// similarity /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:284
	void cv_linemod_Match_setPropSimilarity_float(cv::linemod::Match* instance, float val) {
		instance->similarity = val;
	}
	
	// class_id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:285
	void* cv_linemod_Match_getPropClass_id_const(const cv::linemod::Match* instance) {
		cv::String ret = instance->class_id;
		return ocvrs_create_string(ret.c_str());
	}
	
	// class_id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:285
	void cv_linemod_Match_setPropClass_id_String(cv::linemod::Match* instance, char* val) {
		instance->class_id = std::string(val);
	}
	
	// template_id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:286
	int cv_linemod_Match_getPropTemplate_id_const(const cv::linemod::Match* instance) {
		int ret = instance->template_id;
		return (int)ret;
	}
	
	// template_id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:286
	void cv_linemod_Match_setPropTemplate_id_int(cv::linemod::Match* instance, int val) {
		instance->template_id = val;
	}
	
	void cv_Linemod_Match_delete(cv::linemod::Match* instance) {
		delete instance;
	}
	// Match() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:261
	Result<cv::linemod::Match*> cv_linemod_Match_Match() {
		try {
			cv::linemod::Match* ret = new cv::linemod::Match();
			return Ok<cv::linemod::Match*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Match*>))
	}
	
	// Match(int, int, float, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:265
	Result<cv::linemod::Match*> cv_linemod_Match_Match_int_int_float_const_StringR_int(int x, int y, float similarity, const char* class_id, int template_id) {
		try {
			cv::linemod::Match* ret = new cv::linemod::Match(x, y, similarity, std::string(class_id), template_id);
			return Ok<cv::linemod::Match*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::linemod::Match*>))
	}
	
	// operator==(const cv::linemod::Match &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:277
	Result<bool> cv_linemod_Match_operatorEQ_const_const_MatchR(const cv::linemod::Match* instance, const cv::linemod::Match* rhs) {
		try {
			bool ret = instance->operator==(*rhs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// process(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:132
	Result<cv::Ptr<cv::linemod::QuantizedPyramid>*> cv_linemod_Modality_process_const_const_MatR_const_MatR(const cv::linemod::Modality* instance, const cv::Mat* src, const cv::Mat* mask) {
		try {
			cv::Ptr<cv::linemod::QuantizedPyramid> ret = instance->process(*src, *mask);
			return Ok(new cv::Ptr<cv::linemod::QuantizedPyramid>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::QuantizedPyramid>*>))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:138
	Result<void*> cv_linemod_Modality_name_const(const cv::linemod::Modality* instance) {
		try {
			cv::String ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:140
	Result_void cv_linemod_Modality_read_const_FileNodeR(cv::linemod::Modality* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:141
	Result_void cv_linemod_Modality_write_const_FileStorageR(const cv::linemod::Modality* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:150
	Result<cv::Ptr<cv::linemod::Modality>*> cv_linemod_Modality_create_const_StringR(const char* modality_type) {
		try {
			cv::Ptr<cv::linemod::Modality> ret = cv::linemod::Modality::create(std::string(modality_type));
			return Ok(new cv::Ptr<cv::linemod::Modality>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::Modality>*>))
	}
	
	// create(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:155
	Result<cv::Ptr<cv::linemod::Modality>*> cv_linemod_Modality_create_const_FileNodeR(const cv::FileNode* fn) {
		try {
			cv::Ptr<cv::linemod::Modality> ret = cv::linemod::Modality::create(*fn);
			return Ok(new cv::Ptr<cv::linemod::Modality>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::linemod::Modality>*>))
	}
	
	// quantize(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:67
	Result_void cv_linemod_QuantizedPyramid_quantize_const_MatR(const cv::linemod::QuantizedPyramid* instance, cv::Mat* dst) {
		try {
			instance->quantize(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// extractTemplate(cv::linemod::Template &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:74
	Result<bool> cv_linemod_QuantizedPyramid_extractTemplate_const_TemplateR(const cv::linemod::QuantizedPyramid* instance, cv::linemod::Template* templ) {
		try {
			bool ret = instance->extractTemplate(*templ);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// pyrDown() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:81
	Result_void cv_linemod_QuantizedPyramid_pyrDown(cv::linemod::QuantizedPyramid* instance) {
		try {
			instance->pyrDown();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:43
	int cv_linemod_Template_getPropWidth_const(const cv::linemod::Template* instance) {
		int ret = instance->width;
		return (int)ret;
	}
	
	// width /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:43
	void cv_linemod_Template_setPropWidth_int(cv::linemod::Template* instance, int val) {
		instance->width = val;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:44
	int cv_linemod_Template_getPropHeight_const(const cv::linemod::Template* instance) {
		int ret = instance->height;
		return (int)ret;
	}
	
	// height /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:44
	void cv_linemod_Template_setPropHeight_int(cv::linemod::Template* instance, int val) {
		instance->height = val;
	}
	
	// pyramid_level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:45
	int cv_linemod_Template_getPropPyramid_level_const(const cv::linemod::Template* instance) {
		int ret = instance->pyramid_level;
		return (int)ret;
	}
	
	// pyramid_level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:45
	void cv_linemod_Template_setPropPyramid_level_int(cv::linemod::Template* instance, int val) {
		instance->pyramid_level = val;
	}
	
	// features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:46
	std::vector<cv::linemod::Feature>* cv_linemod_Template_getPropFeatures_const(const cv::linemod::Template* instance) {
		std::vector<cv::linemod::Feature> ret = instance->features;
		return new std::vector<cv::linemod::Feature>(ret);
	}
	
	// features /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:46
	void cv_linemod_Template_setPropFeatures_vector_Feature_(cv::linemod::Template* instance, std::vector<cv::linemod::Feature>* val) {
		instance->features = *val;
	}
	
	void cv_Linemod_Template_delete(cv::linemod::Template* instance) {
		delete instance;
	}
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:48
	Result_void cv_linemod_Template_read_const_FileNodeR(cv::linemod::Template* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/linemod.hpp:49
	Result_void cv_linemod_Template_write_const_FileStorageR(const cv::linemod::Template* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_DepthCleaner_to_Algorithm(cv::rgbd::DepthCleaner* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_DepthCleaner_delete(cv::rgbd::DepthCleaner* instance) {
		delete instance;
	}
	// DepthCleaner() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:198
	Result<cv::rgbd::DepthCleaner*> cv_rgbd_DepthCleaner_DepthCleaner() {
		try {
			cv::rgbd::DepthCleaner* ret = new cv::rgbd::DepthCleaner();
			return Ok<cv::rgbd::DepthCleaner*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::DepthCleaner*>))
	}
	
	// DepthCleaner(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:212
	Result<cv::rgbd::DepthCleaner*> cv_rgbd_DepthCleaner_DepthCleaner_int_int_int(int depth, int window_size, int method) {
		try {
			cv::rgbd::DepthCleaner* ret = new cv::rgbd::DepthCleaner(depth, window_size, method);
			return Ok<cv::rgbd::DepthCleaner*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::DepthCleaner*>))
	}
	
	// create(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:216
	Result<cv::Ptr<cv::rgbd::DepthCleaner>*> cv_rgbd_DepthCleaner_create_int_int_int(int depth, int window_size, int method) {
		try {
			cv::Ptr<cv::rgbd::DepthCleaner> ret = cv::rgbd::DepthCleaner::create(depth, window_size, method);
			return Ok(new cv::Ptr<cv::rgbd::DepthCleaner>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::DepthCleaner>*>))
	}
	
	// initialize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:229
	Result_void cv_rgbd_DepthCleaner_initialize_const(const cv::rgbd::DepthCleaner* instance) {
		try {
			instance->initialize();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:231
	Result<int> cv_rgbd_DepthCleaner_getWindowSize_const(const cv::rgbd::DepthCleaner* instance) {
		try {
			int ret = instance->getWindowSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWindowSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:235
	Result_void cv_rgbd_DepthCleaner_setWindowSize_int(cv::rgbd::DepthCleaner* instance, int val) {
		try {
			instance->setWindowSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:239
	Result<int> cv_rgbd_DepthCleaner_getDepth_const(const cv::rgbd::DepthCleaner* instance) {
		try {
			int ret = instance->getDepth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDepth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:243
	Result_void cv_rgbd_DepthCleaner_setDepth_int(cv::rgbd::DepthCleaner* instance, int val) {
		try {
			instance->setDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:247
	Result<int> cv_rgbd_DepthCleaner_getMethod_const(const cv::rgbd::DepthCleaner* instance) {
		try {
			int ret = instance->getMethod();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMethod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:251
	Result_void cv_rgbd_DepthCleaner_setMethod_int(cv::rgbd::DepthCleaner* instance, int val) {
		try {
			instance->setMethod(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_FastICPOdometry_to_Algorithm(cv::rgbd::FastICPOdometry* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_FastICPOdometry_delete(cv::rgbd::FastICPOdometry* instance) {
		delete instance;
	}
	// FastICPOdometry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1042
	Result<cv::rgbd::FastICPOdometry*> cv_rgbd_FastICPOdometry_FastICPOdometry() {
		try {
			cv::rgbd::FastICPOdometry* ret = new cv::rgbd::FastICPOdometry();
			return Ok<cv::rgbd::FastICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::FastICPOdometry*>))
	}
	
	// FastICPOdometry(const cv::Mat &, float, float, float, float, int, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1054
	Result<cv::rgbd::FastICPOdometry*> cv_rgbd_FastICPOdometry_FastICPOdometry_const_MatR_float_float_float_float_int_const_vector_int_R(const cv::Mat* cameraMatrix, float maxDistDiff, float angleThreshold, float sigmaDepth, float sigmaSpatial, int kernelSize, const std::vector<int>* iterCounts) {
		try {
			cv::rgbd::FastICPOdometry* ret = new cv::rgbd::FastICPOdometry(*cameraMatrix, maxDistDiff, angleThreshold, sigmaDepth, sigmaSpatial, kernelSize, *iterCounts);
			return Ok<cv::rgbd::FastICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::FastICPOdometry*>))
	}
	
	// create(const cv::Mat &, float, float, float, float, int, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1062
	Result<cv::Ptr<cv::rgbd::FastICPOdometry>*> cv_rgbd_FastICPOdometry_create_const_MatR_float_float_float_float_int_const_vector_int_R(const cv::Mat* cameraMatrix, float maxDistDiff, float angleThreshold, float sigmaDepth, float sigmaSpatial, int kernelSize, const std::vector<int>* iterCounts) {
		try {
			cv::Ptr<cv::rgbd::FastICPOdometry> ret = cv::rgbd::FastICPOdometry::create(*cameraMatrix, maxDistDiff, angleThreshold, sigmaDepth, sigmaSpatial, kernelSize, *iterCounts);
			return Ok(new cv::Ptr<cv::rgbd::FastICPOdometry>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::FastICPOdometry>*>))
	}
	
	// prepareFrameCache(Ptr<cv::rgbd::OdometryFrame> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1070
	Result<cv::Size> cv_rgbd_FastICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(const cv::rgbd::FastICPOdometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* frame, int cacheType) {
		try {
			cv::Size ret = instance->prepareFrameCache(*frame, cacheType);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getCameraMatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1072
	Result<cv::Mat*> cv_rgbd_FastICPOdometry_getCameraMatrix_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getCameraMatrix();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setCameraMatrix(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1076
	Result_void cv_rgbd_FastICPOdometry_setCameraMatrix_const_MatR(cv::rgbd::FastICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setCameraMatrix(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDistDiff() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1080
	Result<double> cv_rgbd_FastICPOdometry_getMaxDistDiff_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			double ret = instance->getMaxDistDiff();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDistDiff(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1084
	Result_void cv_rgbd_FastICPOdometry_setMaxDistDiff_float(cv::rgbd::FastICPOdometry* instance, float val) {
		try {
			instance->setMaxDistDiff(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAngleThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1088
	Result<float> cv_rgbd_FastICPOdometry_getAngleThreshold_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			float ret = instance->getAngleThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setAngleThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1092
	Result_void cv_rgbd_FastICPOdometry_setAngleThreshold_float(cv::rgbd::FastICPOdometry* instance, float f) {
		try {
			instance->setAngleThreshold(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigmaDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1096
	Result<float> cv_rgbd_FastICPOdometry_getSigmaDepth_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			float ret = instance->getSigmaDepth();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSigmaDepth(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1100
	Result_void cv_rgbd_FastICPOdometry_setSigmaDepth_float(cv::rgbd::FastICPOdometry* instance, float f) {
		try {
			instance->setSigmaDepth(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigmaSpatial() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1104
	Result<float> cv_rgbd_FastICPOdometry_getSigmaSpatial_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			float ret = instance->getSigmaSpatial();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSigmaSpatial(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1108
	Result_void cv_rgbd_FastICPOdometry_setSigmaSpatial_float(cv::rgbd::FastICPOdometry* instance, float f) {
		try {
			instance->setSigmaSpatial(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getKernelSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1112
	Result<int> cv_rgbd_FastICPOdometry_getKernelSize_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			int ret = instance->getKernelSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setKernelSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1116
	Result_void cv_rgbd_FastICPOdometry_setKernelSize_int(cv::rgbd::FastICPOdometry* instance, int f) {
		try {
			instance->setKernelSize(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterationCounts() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1120
	Result<cv::Mat*> cv_rgbd_FastICPOdometry_getIterationCounts_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getIterationCounts();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setIterationCounts(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1124
	Result_void cv_rgbd_FastICPOdometry_setIterationCounts_const_MatR(cv::rgbd::FastICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setIterationCounts(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTransformType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1128
	Result<int> cv_rgbd_FastICPOdometry_getTransformType_const(const cv::rgbd::FastICPOdometry* instance) {
		try {
			int ret = instance->getTransformType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTransformType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:1132
	Result_void cv_rgbd_FastICPOdometry_setTransformType_int(cv::rgbd::FastICPOdometry* instance, int val) {
		try {
			instance->setTransformType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_ICPOdometry_to_Algorithm(cv::rgbd::ICPOdometry* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_ICPOdometry_delete(cv::rgbd::ICPOdometry* instance) {
		delete instance;
	}
	// ICPOdometry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:762
	Result<cv::rgbd::ICPOdometry*> cv_rgbd_ICPOdometry_ICPOdometry() {
		try {
			cv::rgbd::ICPOdometry* ret = new cv::rgbd::ICPOdometry();
			return Ok<cv::rgbd::ICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::ICPOdometry*>))
	}
	
	// ICPOdometry(const cv::Mat &, float, float, float, float, const std::vector<int> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:773
	Result<cv::rgbd::ICPOdometry*> cv_rgbd_ICPOdometry_ICPOdometry_const_MatR_float_float_float_float_const_vector_int_R_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, float maxPointsPart, const std::vector<int>* iterCounts, int transformType) {
		try {
			cv::rgbd::ICPOdometry* ret = new cv::rgbd::ICPOdometry(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, maxPointsPart, *iterCounts, transformType);
			return Ok<cv::rgbd::ICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::ICPOdometry*>))
	}
	
	// create(const cv::Mat &, float, float, float, float, const std::vector<int> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:777
	Result<cv::Ptr<cv::rgbd::ICPOdometry>*> cv_rgbd_ICPOdometry_create_const_MatR_float_float_float_float_const_vector_int_R_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, float maxPointsPart, const std::vector<int>* iterCounts, int transformType) {
		try {
			cv::Ptr<cv::rgbd::ICPOdometry> ret = cv::rgbd::ICPOdometry::create(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, maxPointsPart, *iterCounts, transformType);
			return Ok(new cv::Ptr<cv::rgbd::ICPOdometry>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::ICPOdometry>*>))
	}
	
	// prepareFrameCache(Ptr<cv::rgbd::OdometryFrame> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:781
	Result<cv::Size> cv_rgbd_ICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(const cv::rgbd::ICPOdometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* frame, int cacheType) {
		try {
			cv::Size ret = instance->prepareFrameCache(*frame, cacheType);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getCameraMatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:783
	Result<cv::Mat*> cv_rgbd_ICPOdometry_getCameraMatrix_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getCameraMatrix();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setCameraMatrix(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:787
	Result_void cv_rgbd_ICPOdometry_setCameraMatrix_const_MatR(cv::rgbd::ICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setCameraMatrix(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:791
	Result<double> cv_rgbd_ICPOdometry_getMinDepth_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMinDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:795
	Result_void cv_rgbd_ICPOdometry_setMinDepth_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMinDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:799
	Result<double> cv_rgbd_ICPOdometry_getMaxDepth_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMaxDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:803
	Result_void cv_rgbd_ICPOdometry_setMaxDepth_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMaxDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepthDiff() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:807
	Result<double> cv_rgbd_ICPOdometry_getMaxDepthDiff_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMaxDepthDiff();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepthDiff(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:811
	Result_void cv_rgbd_ICPOdometry_setMaxDepthDiff_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMaxDepthDiff(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterationCounts() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:815
	Result<cv::Mat*> cv_rgbd_ICPOdometry_getIterationCounts_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getIterationCounts();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setIterationCounts(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:819
	Result_void cv_rgbd_ICPOdometry_setIterationCounts_const_MatR(cv::rgbd::ICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setIterationCounts(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxPointsPart() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:823
	Result<double> cv_rgbd_ICPOdometry_getMaxPointsPart_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMaxPointsPart();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxPointsPart(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:827
	Result_void cv_rgbd_ICPOdometry_setMaxPointsPart_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMaxPointsPart(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTransformType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:831
	Result<int> cv_rgbd_ICPOdometry_getTransformType_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			int ret = instance->getTransformType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTransformType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:835
	Result_void cv_rgbd_ICPOdometry_setTransformType_int(cv::rgbd::ICPOdometry* instance, int val) {
		try {
			instance->setTransformType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxTranslation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:839
	Result<double> cv_rgbd_ICPOdometry_getMaxTranslation_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMaxTranslation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxTranslation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:843
	Result_void cv_rgbd_ICPOdometry_setMaxTranslation_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMaxTranslation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxRotation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:847
	Result<double> cv_rgbd_ICPOdometry_getMaxRotation_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			double ret = instance->getMaxRotation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxRotation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:851
	Result_void cv_rgbd_ICPOdometry_setMaxRotation_double(cv::rgbd::ICPOdometry* instance, double val) {
		try {
			instance->setMaxRotation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormalsComputer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:855
	Result<cv::Ptr<cv::rgbd::RgbdNormals>*> cv_rgbd_ICPOdometry_getNormalsComputer_const(const cv::rgbd::ICPOdometry* instance) {
		try {
			cv::Ptr<cv::rgbd::RgbdNormals> ret = instance->getNormalsComputer();
			return Ok(new cv::Ptr<cv::rgbd::RgbdNormals>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdNormals>*>))
	}
	
	// DEFAULT_MIN_DEPTH() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:535
	Result<float> cv_rgbd_Odometry_DEFAULT_MIN_DEPTH() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MIN_DEPTH();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// DEFAULT_MAX_DEPTH() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:540
	Result<float> cv_rgbd_Odometry_DEFAULT_MAX_DEPTH() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MAX_DEPTH();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// DEFAULT_MAX_DEPTH_DIFF() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:545
	Result<float> cv_rgbd_Odometry_DEFAULT_MAX_DEPTH_DIFF() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MAX_DEPTH_DIFF();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// DEFAULT_MAX_POINTS_PART() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:550
	Result<float> cv_rgbd_Odometry_DEFAULT_MAX_POINTS_PART() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MAX_POINTS_PART();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// DEFAULT_MAX_TRANSLATION() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:555
	Result<float> cv_rgbd_Odometry_DEFAULT_MAX_TRANSLATION() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MAX_TRANSLATION();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// DEFAULT_MAX_ROTATION() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:560
	Result<float> cv_rgbd_Odometry_DEFAULT_MAX_ROTATION() {
		try {
			float ret = cv::rgbd::Odometry::DEFAULT_MAX_ROTATION();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// compute(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, cv::OutputArray, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:584
	Result<bool> cv_rgbd_Odometry_compute_const_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR_const__OutputArrayR_const_MatR(const cv::rgbd::Odometry* instance, const cv::Mat* srcImage, const cv::Mat* srcDepth, const cv::Mat* srcMask, const cv::Mat* dstImage, const cv::Mat* dstDepth, const cv::Mat* dstMask, const cv::_OutputArray* Rt, const cv::Mat* initRt) {
		try {
			bool ret = instance->compute(*srcImage, *srcDepth, *srcMask, *dstImage, *dstDepth, *dstMask, *Rt, *initRt);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// compute(Ptr<cv::rgbd::OdometryFrame> &, Ptr<cv::rgbd::OdometryFrame> &, cv::OutputArray, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:591
	Result<bool> cv_rgbd_Odometry_compute_const_Ptr_OdometryFrame_R_Ptr_OdometryFrame_R_const__OutputArrayR_const_MatR(const cv::rgbd::Odometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* srcFrame, cv::Ptr<cv::rgbd::OdometryFrame>* dstFrame, const cv::_OutputArray* Rt, const cv::Mat* initRt) {
		try {
			bool ret = instance->compute(*srcFrame, *dstFrame, *Rt, *initRt);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// prepareFrameCache(Ptr<cv::rgbd::OdometryFrame> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:599
	Result<cv::Size> cv_rgbd_Odometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(const cv::rgbd::Odometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* frame, int cacheType) {
		try {
			cv::Size ret = instance->prepareFrameCache(*frame, cacheType);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// create(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:601
	Result<cv::Ptr<cv::rgbd::Odometry>*> cv_rgbd_Odometry_create_const_StringR(const char* odometryType) {
		try {
			cv::Ptr<cv::rgbd::Odometry> ret = cv::rgbd::Odometry::create(std::string(odometryType));
			return Ok(new cv::Ptr<cv::rgbd::Odometry>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::Odometry>*>))
	}
	
	// getCameraMatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:604
	Result<cv::Mat*> cv_rgbd_Odometry_getCameraMatrix_const(const cv::rgbd::Odometry* instance) {
		try {
			cv::Mat ret = instance->getCameraMatrix();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setCameraMatrix(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:606
	Result_void cv_rgbd_Odometry_setCameraMatrix_const_MatR(cv::rgbd::Odometry* instance, const cv::Mat* val) {
		try {
			instance->setCameraMatrix(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTransformType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:608
	Result<int> cv_rgbd_Odometry_getTransformType_const(const cv::rgbd::Odometry* instance) {
		try {
			int ret = instance->getTransformType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTransformType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:610
	Result_void cv_rgbd_Odometry_setTransformType_int(cv::rgbd::Odometry* instance, int val) {
		try {
			instance->setTransformType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyramidImage /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:508
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidImage_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidImage;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidImage /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:508
	void cv_rgbd_OdometryFrame_setPropPyramidImage_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidImage = *val;
	}
	
	// pyramidDepth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:509
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidDepth_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidDepth;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidDepth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:509
	void cv_rgbd_OdometryFrame_setPropPyramidDepth_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidDepth = *val;
	}
	
	// pyramidMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:510
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidMask_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidMask;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:510
	void cv_rgbd_OdometryFrame_setPropPyramidMask_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidMask = *val;
	}
	
	// pyramidCloud /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:512
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidCloud_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidCloud;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidCloud /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:512
	void cv_rgbd_OdometryFrame_setPropPyramidCloud_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidCloud = *val;
	}
	
	// pyramid_dI_dx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:514
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramid_dI_dx_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramid_dI_dx;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramid_dI_dx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:514
	void cv_rgbd_OdometryFrame_setPropPyramid_dI_dx_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramid_dI_dx = *val;
	}
	
	// pyramid_dI_dy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:515
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramid_dI_dy_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramid_dI_dy;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramid_dI_dy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:515
	void cv_rgbd_OdometryFrame_setPropPyramid_dI_dy_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramid_dI_dy = *val;
	}
	
	// pyramidTexturedMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:516
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidTexturedMask_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidTexturedMask;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidTexturedMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:516
	void cv_rgbd_OdometryFrame_setPropPyramidTexturedMask_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidTexturedMask = *val;
	}
	
	// pyramidNormals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:518
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidNormals_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidNormals;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidNormals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:518
	void cv_rgbd_OdometryFrame_setPropPyramidNormals_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidNormals = *val;
	}
	
	// pyramidNormalsMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:519
	std::vector<cv::Mat>* cv_rgbd_OdometryFrame_getPropPyramidNormalsMask_const(const cv::rgbd::OdometryFrame* instance) {
		std::vector<cv::Mat> ret = instance->pyramidNormalsMask;
		return new std::vector<cv::Mat>(ret);
	}
	
	// pyramidNormalsMask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:519
	void cv_rgbd_OdometryFrame_setPropPyramidNormalsMask_vector_Mat_(cv::rgbd::OdometryFrame* instance, std::vector<cv::Mat>* val) {
		instance->pyramidNormalsMask = *val;
	}
	
	cv::rgbd::RgbdFrame* cv_OdometryFrame_to_RgbdFrame(cv::rgbd::OdometryFrame* instance) {
		return dynamic_cast<cv::rgbd::RgbdFrame*>(instance);
	}
	
	void cv_OdometryFrame_delete(cv::rgbd::OdometryFrame* instance) {
		delete instance;
	}
	// OdometryFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:497
	Result<cv::rgbd::OdometryFrame*> cv_rgbd_OdometryFrame_OdometryFrame() {
		try {
			cv::rgbd::OdometryFrame* ret = new cv::rgbd::OdometryFrame();
			return Ok<cv::rgbd::OdometryFrame*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::OdometryFrame*>))
	}
	
	// OdometryFrame(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:498
	Result<cv::rgbd::OdometryFrame*> cv_rgbd_OdometryFrame_OdometryFrame_const_MatR_const_MatR_const_MatR_const_MatR_int(const cv::Mat* image, const cv::Mat* depth, const cv::Mat* mask, const cv::Mat* normals, int ID) {
		try {
			cv::rgbd::OdometryFrame* ret = new cv::rgbd::OdometryFrame(*image, *depth, *mask, *normals, ID);
			return Ok<cv::rgbd::OdometryFrame*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::OdometryFrame*>))
	}
	
	// create(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:500
	Result<cv::Ptr<cv::rgbd::OdometryFrame>*> cv_rgbd_OdometryFrame_create_const_MatR_const_MatR_const_MatR_const_MatR_int(const cv::Mat* image, const cv::Mat* depth, const cv::Mat* mask, const cv::Mat* normals, int ID) {
		try {
			cv::Ptr<cv::rgbd::OdometryFrame> ret = cv::rgbd::OdometryFrame::create(*image, *depth, *mask, *normals, ID);
			return Ok(new cv::Ptr<cv::rgbd::OdometryFrame>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::OdometryFrame>*>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:503
	Result_void cv_rgbd_OdometryFrame_release(cv::rgbd::OdometryFrame* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// releasePyramids() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:506
	Result_void cv_rgbd_OdometryFrame_releasePyramids(cv::rgbd::OdometryFrame* instance) {
		try {
			instance->releasePyramids();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ID /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:472
	int cv_rgbd_RgbdFrame_getPropID_const(const cv::rgbd::RgbdFrame* instance) {
		int ret = instance->ID;
		return (int)ret;
	}
	
	// ID /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:472
	void cv_rgbd_RgbdFrame_setPropID_int(cv::rgbd::RgbdFrame* instance, int val) {
		instance->ID = val;
	}
	
	// image /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:473
	cv::Mat* cv_rgbd_RgbdFrame_getPropImage_const(const cv::rgbd::RgbdFrame* instance) {
		cv::Mat ret = instance->image;
		return new cv::Mat(ret);
	}
	
	// image /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:473
	void cv_rgbd_RgbdFrame_setPropImage_Mat(cv::rgbd::RgbdFrame* instance, cv::Mat* val) {
		instance->image = *val;
	}
	
	// depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:474
	cv::Mat* cv_rgbd_RgbdFrame_getPropDepth_const(const cv::rgbd::RgbdFrame* instance) {
		cv::Mat ret = instance->depth;
		return new cv::Mat(ret);
	}
	
	// depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:474
	void cv_rgbd_RgbdFrame_setPropDepth_Mat(cv::rgbd::RgbdFrame* instance, cv::Mat* val) {
		instance->depth = *val;
	}
	
	// mask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:475
	cv::Mat* cv_rgbd_RgbdFrame_getPropMask_const(const cv::rgbd::RgbdFrame* instance) {
		cv::Mat ret = instance->mask;
		return new cv::Mat(ret);
	}
	
	// mask /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:475
	void cv_rgbd_RgbdFrame_setPropMask_Mat(cv::rgbd::RgbdFrame* instance, cv::Mat* val) {
		instance->mask = *val;
	}
	
	// normals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:476
	cv::Mat* cv_rgbd_RgbdFrame_getPropNormals_const(const cv::rgbd::RgbdFrame* instance) {
		cv::Mat ret = instance->normals;
		return new cv::Mat(ret);
	}
	
	// normals /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:476
	void cv_rgbd_RgbdFrame_setPropNormals_Mat(cv::rgbd::RgbdFrame* instance, cv::Mat* val) {
		instance->normals = *val;
	}
	
	 Result<cv::rgbd::OdometryFrame*> cv_RgbdFrame_to_OdometryFrame(cv::rgbd::RgbdFrame* instance) {
		try {
			return Ok(dynamic_cast<cv::rgbd::OdometryFrame*>(instance));
		} OCVRS_CATCH(Result<cv::rgbd::OdometryFrame*>)
	}
	
	void cv_RgbdFrame_delete(cv::rgbd::RgbdFrame* instance) {
		delete instance;
	}
	// RgbdFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:463
	Result<cv::rgbd::RgbdFrame*> cv_rgbd_RgbdFrame_RgbdFrame() {
		try {
			cv::rgbd::RgbdFrame* ret = new cv::rgbd::RgbdFrame();
			return Ok<cv::rgbd::RgbdFrame*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdFrame*>))
	}
	
	// RgbdFrame(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:464
	Result<cv::rgbd::RgbdFrame*> cv_rgbd_RgbdFrame_RgbdFrame_const_MatR_const_MatR_const_MatR_const_MatR_int(const cv::Mat* image, const cv::Mat* depth, const cv::Mat* mask, const cv::Mat* normals, int ID) {
		try {
			cv::rgbd::RgbdFrame* ret = new cv::rgbd::RgbdFrame(*image, *depth, *mask, *normals, ID);
			return Ok<cv::rgbd::RgbdFrame*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdFrame*>))
	}
	
	// create(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:467
	Result<cv::Ptr<cv::rgbd::RgbdFrame>*> cv_rgbd_RgbdFrame_create_const_MatR_const_MatR_const_MatR_const_MatR_int(const cv::Mat* image, const cv::Mat* depth, const cv::Mat* mask, const cv::Mat* normals, int ID) {
		try {
			cv::Ptr<cv::rgbd::RgbdFrame> ret = cv::rgbd::RgbdFrame::create(*image, *depth, *mask, *normals, ID);
			return Ok(new cv::Ptr<cv::rgbd::RgbdFrame>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdFrame>*>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:470
	Result_void cv_rgbd_RgbdFrame_release(cv::rgbd::RgbdFrame* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_RgbdICPOdometry_to_Algorithm(cv::rgbd::RgbdICPOdometry* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_RgbdICPOdometry_delete(cv::rgbd::RgbdICPOdometry* instance) {
		delete instance;
	}
	// RgbdICPOdometry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:890
	Result<cv::rgbd::RgbdICPOdometry*> cv_rgbd_RgbdICPOdometry_RgbdICPOdometry() {
		try {
			cv::rgbd::RgbdICPOdometry* ret = new cv::rgbd::RgbdICPOdometry();
			return Ok<cv::rgbd::RgbdICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdICPOdometry*>))
	}
	
	// RgbdICPOdometry(const cv::Mat &, float, float, float, float, const std::vector<int> &, const std::vector<float> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:903
	Result<cv::rgbd::RgbdICPOdometry*> cv_rgbd_RgbdICPOdometry_RgbdICPOdometry_const_MatR_float_float_float_float_const_vector_int_R_const_vector_float_R_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, float maxPointsPart, const std::vector<int>* iterCounts, const std::vector<float>* minGradientMagnitudes, int transformType) {
		try {
			cv::rgbd::RgbdICPOdometry* ret = new cv::rgbd::RgbdICPOdometry(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, maxPointsPart, *iterCounts, *minGradientMagnitudes, transformType);
			return Ok<cv::rgbd::RgbdICPOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdICPOdometry*>))
	}
	
	// create(const cv::Mat &, float, float, float, float, const std::vector<int> &, const std::vector<float> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:909
	Result<cv::Ptr<cv::rgbd::RgbdICPOdometry>*> cv_rgbd_RgbdICPOdometry_create_const_MatR_float_float_float_float_const_vector_int_R_const_vector_float_R_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, float maxPointsPart, const std::vector<int>* iterCounts, const std::vector<float>* minGradientMagnitudes, int transformType) {
		try {
			cv::Ptr<cv::rgbd::RgbdICPOdometry> ret = cv::rgbd::RgbdICPOdometry::create(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, maxPointsPart, *iterCounts, *minGradientMagnitudes, transformType);
			return Ok(new cv::Ptr<cv::rgbd::RgbdICPOdometry>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdICPOdometry>*>))
	}
	
	// prepareFrameCache(Ptr<cv::rgbd::OdometryFrame> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:915
	Result<cv::Size> cv_rgbd_RgbdICPOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(const cv::rgbd::RgbdICPOdometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* frame, int cacheType) {
		try {
			cv::Size ret = instance->prepareFrameCache(*frame, cacheType);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getCameraMatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:917
	Result<cv::Mat*> cv_rgbd_RgbdICPOdometry_getCameraMatrix_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getCameraMatrix();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setCameraMatrix(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:921
	Result_void cv_rgbd_RgbdICPOdometry_setCameraMatrix_const_MatR(cv::rgbd::RgbdICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setCameraMatrix(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:925
	Result<double> cv_rgbd_RgbdICPOdometry_getMinDepth_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMinDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:929
	Result_void cv_rgbd_RgbdICPOdometry_setMinDepth_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMinDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:933
	Result<double> cv_rgbd_RgbdICPOdometry_getMaxDepth_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMaxDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:937
	Result_void cv_rgbd_RgbdICPOdometry_setMaxDepth_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMaxDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepthDiff() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:941
	Result<double> cv_rgbd_RgbdICPOdometry_getMaxDepthDiff_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMaxDepthDiff();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepthDiff(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:945
	Result_void cv_rgbd_RgbdICPOdometry_setMaxDepthDiff_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMaxDepthDiff(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxPointsPart() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:949
	Result<double> cv_rgbd_RgbdICPOdometry_getMaxPointsPart_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMaxPointsPart();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxPointsPart(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:953
	Result_void cv_rgbd_RgbdICPOdometry_setMaxPointsPart_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMaxPointsPart(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterationCounts() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:957
	Result<cv::Mat*> cv_rgbd_RgbdICPOdometry_getIterationCounts_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getIterationCounts();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setIterationCounts(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:961
	Result_void cv_rgbd_RgbdICPOdometry_setIterationCounts_const_MatR(cv::rgbd::RgbdICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setIterationCounts(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinGradientMagnitudes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:965
	Result<cv::Mat*> cv_rgbd_RgbdICPOdometry_getMinGradientMagnitudes_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			cv::Mat ret = instance->getMinGradientMagnitudes();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setMinGradientMagnitudes(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:969
	Result_void cv_rgbd_RgbdICPOdometry_setMinGradientMagnitudes_const_MatR(cv::rgbd::RgbdICPOdometry* instance, const cv::Mat* val) {
		try {
			instance->setMinGradientMagnitudes(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTransformType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:973
	Result<int> cv_rgbd_RgbdICPOdometry_getTransformType_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			int ret = instance->getTransformType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTransformType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:977
	Result_void cv_rgbd_RgbdICPOdometry_setTransformType_int(cv::rgbd::RgbdICPOdometry* instance, int val) {
		try {
			instance->setTransformType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxTranslation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:981
	Result<double> cv_rgbd_RgbdICPOdometry_getMaxTranslation_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMaxTranslation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxTranslation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:985
	Result_void cv_rgbd_RgbdICPOdometry_setMaxTranslation_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMaxTranslation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxRotation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:989
	Result<double> cv_rgbd_RgbdICPOdometry_getMaxRotation_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			double ret = instance->getMaxRotation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxRotation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:993
	Result_void cv_rgbd_RgbdICPOdometry_setMaxRotation_double(cv::rgbd::RgbdICPOdometry* instance, double val) {
		try {
			instance->setMaxRotation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormalsComputer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:997
	Result<cv::Ptr<cv::rgbd::RgbdNormals>*> cv_rgbd_RgbdICPOdometry_getNormalsComputer_const(const cv::rgbd::RgbdICPOdometry* instance) {
		try {
			cv::Ptr<cv::rgbd::RgbdNormals> ret = instance->getNormalsComputer();
			return Ok(new cv::Ptr<cv::rgbd::RgbdNormals>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdNormals>*>))
	}
	
	cv::Algorithm* cv_RgbdNormals_to_Algorithm(cv::rgbd::RgbdNormals* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_RgbdNormals_delete(cv::rgbd::RgbdNormals* instance) {
		delete instance;
	}
	// RgbdNormals() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:83
	Result<cv::rgbd::RgbdNormals*> cv_rgbd_RgbdNormals_RgbdNormals() {
		try {
			cv::rgbd::RgbdNormals* ret = new cv::rgbd::RgbdNormals();
			return Ok<cv::rgbd::RgbdNormals*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdNormals*>))
	}
	
	// RgbdNormals(int, int, int, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:103
	Result<cv::rgbd::RgbdNormals*> cv_rgbd_RgbdNormals_RgbdNormals_int_int_int_const__InputArrayR_int_int(int rows, int cols, int depth, const cv::_InputArray* K, int window_size, int method) {
		try {
			cv::rgbd::RgbdNormals* ret = new cv::rgbd::RgbdNormals(rows, cols, depth, *K, window_size, method);
			return Ok<cv::rgbd::RgbdNormals*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdNormals*>))
	}
	
	// create(int, int, int, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:108
	Result<cv::Ptr<cv::rgbd::RgbdNormals>*> cv_rgbd_RgbdNormals_create_int_int_int_const__InputArrayR_int_int(int rows, int cols, int depth, const cv::_InputArray* K, int window_size, int method) {
		try {
			cv::Ptr<cv::rgbd::RgbdNormals> ret = cv::rgbd::RgbdNormals::create(rows, cols, depth, *K, window_size, method);
			return Ok(new cv::Ptr<cv::rgbd::RgbdNormals>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdNormals>*>))
	}
	
	// initialize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:122
	Result_void cv_rgbd_RgbdNormals_initialize_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			instance->initialize();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:124
	Result<int> cv_rgbd_RgbdNormals_getRows_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			int ret = instance->getRows();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRows(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:128
	Result_void cv_rgbd_RgbdNormals_setRows_int(cv::rgbd::RgbdNormals* instance, int val) {
		try {
			instance->setRows(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCols() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:132
	Result<int> cv_rgbd_RgbdNormals_getCols_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			int ret = instance->getCols();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCols(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:136
	Result_void cv_rgbd_RgbdNormals_setCols_int(cv::rgbd::RgbdNormals* instance, int val) {
		try {
			instance->setCols(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:140
	Result<int> cv_rgbd_RgbdNormals_getWindowSize_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			int ret = instance->getWindowSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWindowSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:144
	Result_void cv_rgbd_RgbdNormals_setWindowSize_int(cv::rgbd::RgbdNormals* instance, int val) {
		try {
			instance->setWindowSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:148
	Result<int> cv_rgbd_RgbdNormals_getDepth_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			int ret = instance->getDepth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDepth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:152
	Result_void cv_rgbd_RgbdNormals_setDepth_int(cv::rgbd::RgbdNormals* instance, int val) {
		try {
			instance->setDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:156
	Result<cv::Mat*> cv_rgbd_RgbdNormals_getK_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			cv::Mat ret = instance->getK();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setK(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:160
	Result_void cv_rgbd_RgbdNormals_setK_const_MatR(cv::rgbd::RgbdNormals* instance, const cv::Mat* val) {
		try {
			instance->setK(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:164
	Result<int> cv_rgbd_RgbdNormals_getMethod_const(const cv::rgbd::RgbdNormals* instance) {
		try {
			int ret = instance->getMethod();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMethod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:168
	Result_void cv_rgbd_RgbdNormals_setMethod_int(cv::rgbd::RgbdNormals* instance, int val) {
		try {
			instance->setMethod(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_RgbdOdometry_to_Algorithm(cv::rgbd::RgbdOdometry* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_RgbdOdometry_delete(cv::rgbd::RgbdOdometry* instance) {
		delete instance;
	}
	// RgbdOdometry() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:627
	Result<cv::rgbd::RgbdOdometry*> cv_rgbd_RgbdOdometry_RgbdOdometry() {
		try {
			cv::rgbd::RgbdOdometry* ret = new cv::rgbd::RgbdOdometry();
			return Ok<cv::rgbd::RgbdOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdOdometry*>))
	}
	
	// RgbdOdometry(const cv::Mat &, float, float, float, const std::vector<int> &, const std::vector<float> &, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:640
	Result<cv::rgbd::RgbdOdometry*> cv_rgbd_RgbdOdometry_RgbdOdometry_const_MatR_float_float_float_const_vector_int_R_const_vector_float_R_float_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, const std::vector<int>* iterCounts, const std::vector<float>* minGradientMagnitudes, float maxPointsPart, int transformType) {
		try {
			cv::rgbd::RgbdOdometry* ret = new cv::rgbd::RgbdOdometry(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, *iterCounts, *minGradientMagnitudes, maxPointsPart, transformType);
			return Ok<cv::rgbd::RgbdOdometry*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdOdometry*>))
	}
	
	// create(const cv::Mat &, float, float, float, const std::vector<int> &, const std::vector<float> &, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:645
	Result<cv::Ptr<cv::rgbd::RgbdOdometry>*> cv_rgbd_RgbdOdometry_create_const_MatR_float_float_float_const_vector_int_R_const_vector_float_R_float_int(const cv::Mat* cameraMatrix, float minDepth, float maxDepth, float maxDepthDiff, const std::vector<int>* iterCounts, const std::vector<float>* minGradientMagnitudes, float maxPointsPart, int transformType) {
		try {
			cv::Ptr<cv::rgbd::RgbdOdometry> ret = cv::rgbd::RgbdOdometry::create(*cameraMatrix, minDepth, maxDepth, maxDepthDiff, *iterCounts, *minGradientMagnitudes, maxPointsPart, transformType);
			return Ok(new cv::Ptr<cv::rgbd::RgbdOdometry>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdOdometry>*>))
	}
	
	// prepareFrameCache(Ptr<cv::rgbd::OdometryFrame> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:650
	Result<cv::Size> cv_rgbd_RgbdOdometry_prepareFrameCache_const_Ptr_OdometryFrame_R_int(const cv::rgbd::RgbdOdometry* instance, cv::Ptr<cv::rgbd::OdometryFrame>* frame, int cacheType) {
		try {
			cv::Size ret = instance->prepareFrameCache(*frame, cacheType);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getCameraMatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:652
	Result<cv::Mat*> cv_rgbd_RgbdOdometry_getCameraMatrix_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			cv::Mat ret = instance->getCameraMatrix();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setCameraMatrix(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:656
	Result_void cv_rgbd_RgbdOdometry_setCameraMatrix_const_MatR(cv::rgbd::RgbdOdometry* instance, const cv::Mat* val) {
		try {
			instance->setCameraMatrix(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:660
	Result<double> cv_rgbd_RgbdOdometry_getMinDepth_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMinDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:664
	Result_void cv_rgbd_RgbdOdometry_setMinDepth_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMinDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:668
	Result<double> cv_rgbd_RgbdOdometry_getMaxDepth_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMaxDepth();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepth(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:672
	Result_void cv_rgbd_RgbdOdometry_setMaxDepth_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMaxDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepthDiff() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:676
	Result<double> cv_rgbd_RgbdOdometry_getMaxDepthDiff_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMaxDepthDiff();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDepthDiff(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:680
	Result_void cv_rgbd_RgbdOdometry_setMaxDepthDiff_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMaxDepthDiff(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterationCounts() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:684
	Result<cv::Mat*> cv_rgbd_RgbdOdometry_getIterationCounts_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			cv::Mat ret = instance->getIterationCounts();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setIterationCounts(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:688
	Result_void cv_rgbd_RgbdOdometry_setIterationCounts_const_MatR(cv::rgbd::RgbdOdometry* instance, const cv::Mat* val) {
		try {
			instance->setIterationCounts(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinGradientMagnitudes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:692
	Result<cv::Mat*> cv_rgbd_RgbdOdometry_getMinGradientMagnitudes_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			cv::Mat ret = instance->getMinGradientMagnitudes();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setMinGradientMagnitudes(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:696
	Result_void cv_rgbd_RgbdOdometry_setMinGradientMagnitudes_const_MatR(cv::rgbd::RgbdOdometry* instance, const cv::Mat* val) {
		try {
			instance->setMinGradientMagnitudes(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxPointsPart() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:700
	Result<double> cv_rgbd_RgbdOdometry_getMaxPointsPart_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMaxPointsPart();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxPointsPart(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:704
	Result_void cv_rgbd_RgbdOdometry_setMaxPointsPart_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMaxPointsPart(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTransformType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:708
	Result<int> cv_rgbd_RgbdOdometry_getTransformType_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			int ret = instance->getTransformType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTransformType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:712
	Result_void cv_rgbd_RgbdOdometry_setTransformType_int(cv::rgbd::RgbdOdometry* instance, int val) {
		try {
			instance->setTransformType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxTranslation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:716
	Result<double> cv_rgbd_RgbdOdometry_getMaxTranslation_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMaxTranslation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxTranslation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:720
	Result_void cv_rgbd_RgbdOdometry_setMaxTranslation_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMaxTranslation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxRotation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:724
	Result<double> cv_rgbd_RgbdOdometry_getMaxRotation_const(const cv::rgbd::RgbdOdometry* instance) {
		try {
			double ret = instance->getMaxRotation();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxRotation(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:728
	Result_void cv_rgbd_RgbdOdometry_setMaxRotation_double(cv::rgbd::RgbdOdometry* instance, double val) {
		try {
			instance->setMaxRotation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_RgbdPlane_to_Algorithm(cv::rgbd::RgbdPlane* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_RgbdPlane_delete(cv::rgbd::RgbdPlane* instance) {
		delete instance;
	}
	// RgbdPlane(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:337
	Result<cv::rgbd::RgbdPlane*> cv_rgbd_RgbdPlane_RgbdPlane_int(int method) {
		try {
			cv::rgbd::RgbdPlane* ret = new cv::rgbd::RgbdPlane(method);
			return Ok<cv::rgbd::RgbdPlane*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdPlane*>))
	}
	
	// RgbdPlane(int, int, int, double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:358
	Result<cv::rgbd::RgbdPlane*> cv_rgbd_RgbdPlane_RgbdPlane_int_int_int_double_double_double_double(int method, int block_size, int min_size, double threshold, double sensor_error_a, double sensor_error_b, double sensor_error_c) {
		try {
			cv::rgbd::RgbdPlane* ret = new cv::rgbd::RgbdPlane(method, block_size, min_size, threshold, sensor_error_a, sensor_error_b, sensor_error_c);
			return Ok<cv::rgbd::RgbdPlane*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::rgbd::RgbdPlane*>))
	}
	
	// create(int, int, int, double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:364
	Result<cv::Ptr<cv::rgbd::RgbdPlane>*> cv_rgbd_RgbdPlane_create_int_int_int_double_double_double_double(int method, int block_size, int min_size, double threshold, double sensor_error_a, double sensor_error_b, double sensor_error_c) {
		try {
			cv::Ptr<cv::rgbd::RgbdPlane> ret = cv::rgbd::RgbdPlane::create(method, block_size, min_size, threshold, sensor_error_a, sensor_error_b, sensor_error_c);
			return Ok(new cv::Ptr<cv::rgbd::RgbdPlane>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::rgbd::RgbdPlane>*>))
	}
	
	// getBlockSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:389
	Result<int> cv_rgbd_RgbdPlane_getBlockSize_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			int ret = instance->getBlockSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setBlockSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:393
	Result_void cv_rgbd_RgbdPlane_setBlockSize_int(cv::rgbd::RgbdPlane* instance, int val) {
		try {
			instance->setBlockSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:397
	Result<int> cv_rgbd_RgbdPlane_getMinSize_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			int ret = instance->getMinSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:401
	Result_void cv_rgbd_RgbdPlane_setMinSize_int(cv::rgbd::RgbdPlane* instance, int val) {
		try {
			instance->setMinSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:405
	Result<int> cv_rgbd_RgbdPlane_getMethod_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			int ret = instance->getMethod();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMethod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:409
	Result_void cv_rgbd_RgbdPlane_setMethod_int(cv::rgbd::RgbdPlane* instance, int val) {
		try {
			instance->setMethod(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:413
	Result<double> cv_rgbd_RgbdPlane_getThreshold_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:417
	Result_void cv_rgbd_RgbdPlane_setThreshold_double(cv::rgbd::RgbdPlane* instance, double val) {
		try {
			instance->setThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSensorErrorA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:421
	Result<double> cv_rgbd_RgbdPlane_getSensorErrorA_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			double ret = instance->getSensorErrorA();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSensorErrorA(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:425
	Result_void cv_rgbd_RgbdPlane_setSensorErrorA_double(cv::rgbd::RgbdPlane* instance, double val) {
		try {
			instance->setSensorErrorA(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSensorErrorB() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:429
	Result<double> cv_rgbd_RgbdPlane_getSensorErrorB_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			double ret = instance->getSensorErrorB();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSensorErrorB(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:433
	Result_void cv_rgbd_RgbdPlane_setSensorErrorB_double(cv::rgbd::RgbdPlane* instance, double val) {
		try {
			instance->setSensorErrorB(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSensorErrorC() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:437
	Result<double> cv_rgbd_RgbdPlane_getSensorErrorC_const(const cv::rgbd::RgbdPlane* instance) {
		try {
			double ret = instance->getSensorErrorC();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSensorErrorC(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/rgbd/depth.hpp:441
	Result_void cv_rgbd_RgbdPlane_setSensorErrorC_double(cv::rgbd::RgbdPlane* instance, double val) {
		try {
			instance->setSensorErrorC(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
