#include "ocvrs_common.hpp"
#include <opencv2/quality.hpp>
#include "quality_types.hpp"

extern "C" {
	cv::Algorithm* cv_QualityBRISQUE_to_Algorithm(cv::quality::QualityBRISQUE* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_QualityBRISQUE_delete(cv::quality::QualityBRISQUE* instance) {
		delete instance;
	}
	// compute(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybrisque.hpp:33
	Result<cv::Scalar> cv_quality_QualityBRISQUE_compute_const__InputArrayR(cv::quality::QualityBRISQUE* instance, const cv::_InputArray* img) {
		try {
			cv::Scalar ret = instance->compute(*img);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// create(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybrisque.hpp:40
	Result<cv::Ptr<cv::quality::QualityBRISQUE>*> cv_quality_QualityBRISQUE_create_const_StringR_const_StringR(const char* model_file_path, const char* range_file_path) {
		try {
			cv::Ptr<cv::quality::QualityBRISQUE> ret = cv::quality::QualityBRISQUE::create(std::string(model_file_path), std::string(range_file_path));
			return Ok(new cv::Ptr<cv::quality::QualityBRISQUE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualityBRISQUE>*>))
	}
	
	// create(const cv::Ptr<cv::ml::SVM> &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybrisque.hpp:47
	Result<cv::Ptr<cv::quality::QualityBRISQUE>*> cv_quality_QualityBRISQUE_create_const_Ptr_SVM_R_const_MatR(const cv::Ptr<cv::ml::SVM>* model, const cv::Mat* range) {
		try {
			cv::Ptr<cv::quality::QualityBRISQUE> ret = cv::quality::QualityBRISQUE::create(*model, *range);
			return Ok(new cv::Ptr<cv::quality::QualityBRISQUE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualityBRISQUE>*>))
	}
	
	// compute(cv::InputArray, const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybrisque.hpp:56
	Result<cv::Scalar> cv_quality_QualityBRISQUE_compute_const__InputArrayR_const_StringR_const_StringR(const cv::_InputArray* img, const char* model_file_path, const char* range_file_path) {
		try {
			cv::Scalar ret = cv::quality::QualityBRISQUE::compute(*img, std::string(model_file_path), std::string(range_file_path));
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// computeFeatures(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybrisque.hpp:63
	Result_void cv_quality_QualityBRISQUE_computeFeatures_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* img, const cv::_OutputArray* features) {
		try {
			cv::quality::QualityBRISQUE::computeFeatures(*img, *features);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybase.hpp:35
	Result<cv::Scalar> cv_quality_QualityBase_compute_const__InputArrayR(cv::quality::QualityBase* instance, const cv::_InputArray* img) {
		try {
			cv::Scalar ret = instance->compute(*img);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// getQualityMap(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybase.hpp:38
	Result_void cv_quality_QualityBase_getQualityMap_const_const__OutputArrayR(const cv::quality::QualityBase* instance, const cv::_OutputArray* dst) {
		try {
			instance->getQualityMap(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybase.hpp:46
	Result_void cv_quality_QualityBase_clear(cv::quality::QualityBase* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitybase.hpp:49
	Result<bool> cv_quality_QualityBase_empty_const(const cv::quality::QualityBase* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::Algorithm* cv_QualityGMSD_to_Algorithm(cv::quality::QualityGMSD* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_QualityGMSD_delete(cv::quality::QualityGMSD* instance) {
		delete instance;
	}
	// compute(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitygmsd.hpp:28
	Result<cv::Scalar> cv_quality_QualityGMSD_compute_const__InputArrayR(cv::quality::QualityGMSD* instance, const cv::_InputArray* cmp) {
		try {
			cv::Scalar ret = instance->compute(*cmp);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitygmsd.hpp:31
	Result<bool> cv_quality_QualityGMSD_empty_const(const cv::quality::QualityGMSD* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitygmsd.hpp:34
	Result_void cv_quality_QualityGMSD_clear(cv::quality::QualityGMSD* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitygmsd.hpp:40
	Result<cv::Ptr<cv::quality::QualityGMSD>*> cv_quality_QualityGMSD_create_const__InputArrayR(const cv::_InputArray* ref) {
		try {
			cv::Ptr<cv::quality::QualityGMSD> ret = cv::quality::QualityGMSD::create(*ref);
			return Ok(new cv::Ptr<cv::quality::QualityGMSD>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualityGMSD>*>))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitygmsd.hpp:49
	Result<cv::Scalar> cv_quality_QualityGMSD_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* ref, const cv::_InputArray* cmp, const cv::_OutputArray* qualityMap) {
		try {
			cv::Scalar ret = cv::quality::QualityGMSD::compute(*ref, *cmp, *qualityMap);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	cv::Algorithm* cv_QualityMSE_to_Algorithm(cv::quality::QualityMSE* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_QualityMSE_delete(cv::quality::QualityMSE* instance) {
		delete instance;
	}
	// compute(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitymse.hpp:25
	Result<cv::Scalar> cv_quality_QualityMSE_compute_const__InputArrayR(cv::quality::QualityMSE* instance, const cv::_InputArray* cmpImgs) {
		try {
			cv::Scalar ret = instance->compute(*cmpImgs);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitymse.hpp:28
	Result<bool> cv_quality_QualityMSE_empty_const(const cv::quality::QualityMSE* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitymse.hpp:31
	Result_void cv_quality_QualityMSE_clear(cv::quality::QualityMSE* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitymse.hpp:37
	Result<cv::Ptr<cv::quality::QualityMSE>*> cv_quality_QualityMSE_create_const__InputArrayR(const cv::_InputArray* ref) {
		try {
			cv::Ptr<cv::quality::QualityMSE> ret = cv::quality::QualityMSE::create(*ref);
			return Ok(new cv::Ptr<cv::quality::QualityMSE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualityMSE>*>))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitymse.hpp:46
	Result<cv::Scalar> cv_quality_QualityMSE_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* ref, const cv::_InputArray* cmp, const cv::_OutputArray* qualityMap) {
		try {
			cv::Scalar ret = cv::quality::QualityMSE::compute(*ref, *cmp, *qualityMap);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	cv::Algorithm* cv_QualityPSNR_to_Algorithm(cv::quality::QualityPSNR* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_QualityPSNR_delete(cv::quality::QualityPSNR* instance) {
		delete instance;
	}
	// create(cv::InputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:38
	Result<cv::Ptr<cv::quality::QualityPSNR>*> cv_quality_QualityPSNR_create_const__InputArrayR_double(const cv::_InputArray* ref, double maxPixelValue) {
		try {
			cv::Ptr<cv::quality::QualityPSNR> ret = cv::quality::QualityPSNR::create(*ref, maxPixelValue);
			return Ok(new cv::Ptr<cv::quality::QualityPSNR>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualityPSNR>*>))
	}
	
	// compute(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:48
	Result<cv::Scalar> cv_quality_QualityPSNR_compute_const__InputArrayR(cv::quality::QualityPSNR* instance, const cv::_InputArray* cmp) {
		try {
			cv::Scalar ret = instance->compute(*cmp);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:59
	Result<bool> cv_quality_QualityPSNR_empty_const(const cv::quality::QualityPSNR* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:62
	Result_void cv_quality_QualityPSNR_clear(cv::quality::QualityPSNR* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:72
	Result<cv::Scalar> cv_quality_QualityPSNR_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(const cv::_InputArray* ref, const cv::_InputArray* cmp, const cv::_OutputArray* qualityMap, double maxPixelValue) {
		try {
			cv::Scalar ret = cv::quality::QualityPSNR::compute(*ref, *cmp, *qualityMap, maxPixelValue);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// getMaxPixelValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:81
	Result<double> cv_quality_QualityPSNR_getMaxPixelValue_const(const cv::quality::QualityPSNR* instance) {
		try {
			double ret = instance->getMaxPixelValue();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxPixelValue(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualitypsnr.hpp:87
	Result_void cv_quality_QualityPSNR_setMaxPixelValue_double(cv::quality::QualityPSNR* instance, double val) {
		try {
			instance->setMaxPixelValue(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_QualitySSIM_to_Algorithm(cv::quality::QualitySSIM* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_QualitySSIM_delete(cv::quality::QualitySSIM* instance) {
		delete instance;
	}
	// compute(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualityssim.hpp:27
	Result<cv::Scalar> cv_quality_QualitySSIM_compute_const__InputArrayR(cv::quality::QualitySSIM* instance, const cv::_InputArray* cmp) {
		try {
			cv::Scalar ret = instance->compute(*cmp);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualityssim.hpp:30
	Result<bool> cv_quality_QualitySSIM_empty_const(const cv::quality::QualitySSIM* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualityssim.hpp:33
	Result_void cv_quality_QualitySSIM_clear(cv::quality::QualitySSIM* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualityssim.hpp:39
	Result<cv::Ptr<cv::quality::QualitySSIM>*> cv_quality_QualitySSIM_create_const__InputArrayR(const cv::_InputArray* ref) {
		try {
			cv::Ptr<cv::quality::QualitySSIM> ret = cv::quality::QualitySSIM::create(*ref);
			return Ok(new cv::Ptr<cv::quality::QualitySSIM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::quality::QualitySSIM>*>))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/quality/qualityssim.hpp:48
	Result<cv::Scalar> cv_quality_QualitySSIM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* ref, const cv::_InputArray* cmp, const cv::_OutputArray* qualityMap) {
		try {
			cv::Scalar ret = cv::quality::QualitySSIM::compute(*ref, *cmp, *qualityMap);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
}
