#include "ocvrs_common.hpp"
#include <opencv2/plot.hpp>
#include "plot_types.hpp"

extern "C" {
	// setMinX(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:69
	Result_void cv_plot_Plot2d_setMinX_double(cv::plot::Plot2d* instance, double _plotMinX) {
		try {
			instance->setMinX(_plotMinX);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMinY(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:70
	Result_void cv_plot_Plot2d_setMinY_double(cv::plot::Plot2d* instance, double _plotMinY) {
		try {
			instance->setMinY(_plotMinY);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxX(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:71
	Result_void cv_plot_Plot2d_setMaxX_double(cv::plot::Plot2d* instance, double _plotMaxX) {
		try {
			instance->setMaxX(_plotMaxX);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxY(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:72
	Result_void cv_plot_Plot2d_setMaxY_double(cv::plot::Plot2d* instance, double _plotMaxY) {
		try {
			instance->setMaxY(_plotMaxY);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotLineWidth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:73
	Result_void cv_plot_Plot2d_setPlotLineWidth_int(cv::plot::Plot2d* instance, int _plotLineWidth) {
		try {
			instance->setPlotLineWidth(_plotLineWidth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNeedPlotLine(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:80
	Result_void cv_plot_Plot2d_setNeedPlotLine_bool(cv::plot::Plot2d* instance, bool _needPlotLine) {
		try {
			instance->setNeedPlotLine(_needPlotLine);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotLineColor(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:81
	Result_void cv_plot_Plot2d_setPlotLineColor_Scalar(cv::plot::Plot2d* instance, cv::Scalar* _plotLineColor) {
		try {
			instance->setPlotLineColor(*_plotLineColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotBackgroundColor(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:82
	Result_void cv_plot_Plot2d_setPlotBackgroundColor_Scalar(cv::plot::Plot2d* instance, cv::Scalar* _plotBackgroundColor) {
		try {
			instance->setPlotBackgroundColor(*_plotBackgroundColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotAxisColor(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:83
	Result_void cv_plot_Plot2d_setPlotAxisColor_Scalar(cv::plot::Plot2d* instance, cv::Scalar* _plotAxisColor) {
		try {
			instance->setPlotAxisColor(*_plotAxisColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotGridColor(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:84
	Result_void cv_plot_Plot2d_setPlotGridColor_Scalar(cv::plot::Plot2d* instance, cv::Scalar* _plotGridColor) {
		try {
			instance->setPlotGridColor(*_plotGridColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotTextColor(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:85
	Result_void cv_plot_Plot2d_setPlotTextColor_Scalar(cv::plot::Plot2d* instance, cv::Scalar* _plotTextColor) {
		try {
			instance->setPlotTextColor(*_plotTextColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPlotSize(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:86
	Result_void cv_plot_Plot2d_setPlotSize_int_int(cv::plot::Plot2d* instance, int _plotSizeWidth, int _plotSizeHeight) {
		try {
			instance->setPlotSize(_plotSizeWidth, _plotSizeHeight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setShowGrid(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:87
	Result_void cv_plot_Plot2d_setShowGrid_bool(cv::plot::Plot2d* instance, bool needShowGrid) {
		try {
			instance->setShowGrid(needShowGrid);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setShowText(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:88
	Result_void cv_plot_Plot2d_setShowText_bool(cv::plot::Plot2d* instance, bool needShowText) {
		try {
			instance->setShowText(needShowText);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setGridLinesNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:89
	Result_void cv_plot_Plot2d_setGridLinesNumber_int(cv::plot::Plot2d* instance, int gridLinesNumber) {
		try {
			instance->setGridLinesNumber(gridLinesNumber);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInvertOrientation(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:90
	Result_void cv_plot_Plot2d_setInvertOrientation_bool(cv::plot::Plot2d* instance, bool _invertOrientation) {
		try {
			instance->setInvertOrientation(_invertOrientation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPointIdxToPrint(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:96
	Result_void cv_plot_Plot2d_setPointIdxToPrint_int(cv::plot::Plot2d* instance, int pointIdx) {
		try {
			instance->setPointIdxToPrint(pointIdx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:97
	Result_void cv_plot_Plot2d_render_const__OutputArrayR(cv::plot::Plot2d* instance, const cv::_OutputArray* _plotResult) {
		try {
			instance->render(*_plotResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:105
	Result<cv::Ptr<cv::plot::Plot2d>*> cv_plot_Plot2d_create_const__InputArrayR(const cv::_InputArray* data) {
		try {
			cv::Ptr<cv::plot::Plot2d> ret = cv::plot::Plot2d::create(*data);
			return Ok(new cv::Ptr<cv::plot::Plot2d>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::plot::Plot2d>*>))
	}
	
	// create(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/plot.hpp:113
	Result<cv::Ptr<cv::plot::Plot2d>*> cv_plot_Plot2d_create_const__InputArrayR_const__InputArrayR(const cv::_InputArray* dataX, const cv::_InputArray* dataY) {
		try {
			cv::Ptr<cv::plot::Plot2d> ret = cv::plot::Plot2d::create(*dataX, *dataY);
			return Ok(new cv::Ptr<cv::plot::Plot2d>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::plot::Plot2d>*>))
	}
	
}
