#include "ocvrs_common.hpp"
#include <opencv2/optflow.hpp>
#include "optflow_types.hpp"

extern "C" {
	// calcGlobalOrientation(cv::InputArray, cv::InputArray, cv::InputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/motempl.hpp:119
	Result<double> cv_motempl_calcGlobalOrientation_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_double(const cv::_InputArray* orientation, const cv::_InputArray* mask, const cv::_InputArray* mhi, double timestamp, double duration) {
		try {
			double ret = cv::motempl::calcGlobalOrientation(*orientation, *mask, *mhi, timestamp, duration);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// calcMotionGradient(cv::InputArray, cv::OutputArray, cv::OutputArray, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/motempl.hpp:102
	Result_void cv_motempl_calcMotionGradient_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double_int(const cv::_InputArray* mhi, const cv::_OutputArray* mask, const cv::_OutputArray* orientation, double delta1, double delta2, int apertureSize) {
		try {
			cv::motempl::calcMotionGradient(*mhi, *mask, *orientation, delta1, delta2, apertureSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// segmentMotion(cv::InputArray, cv::OutputArray, std::vector<Rect> &, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/motempl.hpp:137
	Result_void cv_motempl_segmentMotion_const__InputArrayR_const__OutputArrayR_vector_Rect_R_double_double(const cv::_InputArray* mhi, const cv::_OutputArray* segmask, std::vector<cv::Rect>* boundingRects, double timestamp, double segThresh) {
		try {
			cv::motempl::segmentMotion(*mhi, *segmask, *boundingRects, timestamp, segThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updateMotionHistory(cv::InputArray, cv::InputOutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/motempl.hpp:71
	Result_void cv_motempl_updateMotionHistory_const__InputArrayR_const__InputOutputArrayR_double_double(const cv::_InputArray* silhouette, const cv::_InputOutputArray* mhi, double timestamp, double duration) {
		try {
			cv::motempl::updateMotionHistory(*silhouette, *mhi, timestamp, duration);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowDenseRLOF(cv::InputArray, cv::InputArray, cv::InputOutputArray, Ptr<cv::optflow::RLOFOpticalFlowParameter>, float, cv::Size, cv::optflow::InterpolationType, int, float, float, int, int, bool, float, float, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:501
	Result_void cv_optflow_calcOpticalFlowDenseRLOF_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_Ptr_RLOFOpticalFlowParameter__float_Size_InterpolationType_int_float_float_int_int_bool_float_float_bool(const cv::_InputArray* I0, const cv::_InputArray* I1, const cv::_InputOutputArray* flow, cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* rlofParam, float forwardBackwardThreshold, cv::Size* gridStep, cv::optflow::InterpolationType interp_type, int epicK, float epicSigma, float epicLambda, int ricSPSize, int ricSLICType, bool use_post_proc, float fgsLambda, float fgsSigma, bool use_variational_refinement) {
		try {
			cv::optflow::calcOpticalFlowDenseRLOF(*I0, *I1, *flow, *rlofParam, forwardBackwardThreshold, *gridStep, interp_type, epicK, epicSigma, epicLambda, ricSPSize, ricSLICType, use_post_proc, fgsLambda, fgsSigma, use_variational_refinement);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowSF(cv::InputArray, cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:81
	Result_void cv_optflow_calcOpticalFlowSF_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* from, const cv::_InputArray* to, const cv::_OutputArray* flow, int layers, int averaging_block_size, int max_flow) {
		try {
			cv::optflow::calcOpticalFlowSF(*from, *to, *flow, layers, averaging_block_size, max_flow);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowSF(cv::InputArray, cv::InputArray, cv::OutputArray, int, int, int, double, double, int, double, double, double, int, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:110
	Result_void cv_optflow_calcOpticalFlowSF_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_int_double_double_int_double_double_double_int_double_double_double(const cv::_InputArray* from, const cv::_InputArray* to, const cv::_OutputArray* flow, int layers, int averaging_block_size, int max_flow, double sigma_dist, double sigma_color, int postprocess_window, double sigma_dist_fix, double sigma_color_fix, double occ_thr, int upscale_averaging_radius, double upscale_sigma_dist, double upscale_sigma_color, double speed_up_thr) {
		try {
			cv::optflow::calcOpticalFlowSF(*from, *to, *flow, layers, averaging_block_size, max_flow, sigma_dist, sigma_color, postprocess_window, sigma_dist_fix, sigma_color_fix, occ_thr, upscale_averaging_radius, upscale_sigma_dist, upscale_sigma_color, speed_up_thr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowSparseRLOF(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, Ptr<cv::optflow::RLOFOpticalFlowParameter>, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:538
	Result_void cv_optflow_calcOpticalFlowSparseRLOF_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_Ptr_RLOFOpticalFlowParameter__float(const cv::_InputArray* prevImg, const cv::_InputArray* nextImg, const cv::_InputArray* prevPts, const cv::_InputOutputArray* nextPts, const cv::_OutputArray* status, const cv::_OutputArray* err, cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* rlofParam, float forwardBackwardThreshold) {
		try {
			cv::optflow::calcOpticalFlowSparseRLOF(*prevImg, *nextImg, *prevPts, *nextPts, *status, *err, *rlofParam, forwardBackwardThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcOpticalFlowSparseToDense(cv::InputArray, cv::InputArray, cv::OutputArray, int, int, float, bool, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:135
	Result_void cv_optflow_calcOpticalFlowSparseToDense_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_int_float_bool_float_float(const cv::_InputArray* from, const cv::_InputArray* to, const cv::_OutputArray* flow, int grid_step, int k, float sigma, bool use_post_proc, float fgs_lambda, float fgs_sigma) {
		try {
			cv::optflow::calcOpticalFlowSparseToDense(*from, *to, *flow, grid_step, k, sigma, use_post_proc, fgs_lambda, fgs_sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createOptFlow_DeepFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:165
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_DeepFlow() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_DeepFlow();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// createOptFlow_DenseRLOF() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:545
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_DenseRLOF() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_DenseRLOF();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// createOptFlow_DualTVL1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:300
	Result<cv::Ptr<cv::optflow::DualTVL1OpticalFlow>*> cv_optflow_createOptFlow_DualTVL1() {
		try {
			cv::Ptr<cv::optflow::DualTVL1OpticalFlow> ret = cv::optflow::createOptFlow_DualTVL1();
			return Ok(new cv::Ptr<cv::optflow::DualTVL1OpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::DualTVL1OpticalFlow>*>))
	}
	
	// createOptFlow_Farneback() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:171
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_Farneback() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_Farneback();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// createOptFlow_PCAFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:142
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_PCAFlow() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_PCAFlow();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// createOptFlow_SimpleFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:168
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_SimpleFlow() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_SimpleFlow();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// createOptFlow_SparseRLOF() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:548
	Result<cv::Ptr<cv::SparseOpticalFlow>*> cv_optflow_createOptFlow_SparseRLOF() {
		try {
			cv::Ptr<cv::SparseOpticalFlow> ret = cv::optflow::createOptFlow_SparseRLOF();
			return Ok(new cv::Ptr<cv::SparseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::SparseOpticalFlow>*>))
	}
	
	// createOptFlow_SparseToDense() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:174
	Result<cv::Ptr<cv::DenseOpticalFlow>*> cv_optflow_createOptFlow_SparseToDense() {
		try {
			cv::Ptr<cv::DenseOpticalFlow> ret = cv::optflow::createOptFlow_SparseToDense();
			return Ok(new cv::Ptr<cv::DenseOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DenseOpticalFlow>*>))
	}
	
	// read(const cv::FileNode &, optflow::GPCTree::Node &, optflow::GPCTree::Node) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:369
	Result_void cv_read_const_FileNodeR_NodeR_Node(const cv::FileNode* fn, cv::optflow::GPCTree::Node* node, cv::optflow::GPCTree::Node* unnamed) {
		try {
			cv::read(*fn, *node, *unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const optflow::GPCTree::Node &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:367
	Result_void cv_write_FileStorageR_const_StringR_const_NodeR(cv::FileStorage* fs, const char* name, const cv::optflow::GPCTree::Node* node) {
		try {
			cv::write(*fs, std::string(name), *node);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setRLOFOpticalFlowParameter(Ptr<cv::optflow::RLOFOpticalFlowParameter>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:240
	Result_void cv_optflow_DenseRLOFOpticalFlow_setRLOFOpticalFlowParameter_Ptr_RLOFOpticalFlowParameter_(cv::optflow::DenseRLOFOpticalFlow* instance, cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* val) {
		try {
			instance->setRLOFOpticalFlowParameter(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRLOFOpticalFlowParameter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:244
	Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*> cv_optflow_DenseRLOFOpticalFlow_getRLOFOpticalFlowParameter_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			cv::Ptr<cv::optflow::RLOFOpticalFlowParameter> ret = instance->getRLOFOpticalFlowParameter();
			return Ok(new cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*>))
	}
	
	// setForwardBackward(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:253
	Result_void cv_optflow_DenseRLOFOpticalFlow_setForwardBackward_float(cv::optflow::DenseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setForwardBackward(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getForwardBackward() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:257
	Result<float> cv_optflow_DenseRLOFOpticalFlow_getForwardBackward_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getForwardBackward();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getGridStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:263
	Result<cv::Size> cv_optflow_DenseRLOFOpticalFlow_getGridStep_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			cv::Size ret = instance->getGridStep();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setGridStep(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:267
	Result_void cv_optflow_DenseRLOFOpticalFlow_setGridStep_Size(cv::optflow::DenseRLOFOpticalFlow* instance, cv::Size* val) {
		try {
			instance->setGridStep(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInterpolation(cv::optflow::InterpolationType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:275
	Result_void cv_optflow_DenseRLOFOpticalFlow_setInterpolation_InterpolationType(cv::optflow::DenseRLOFOpticalFlow* instance, cv::optflow::InterpolationType val) {
		try {
			instance->setInterpolation(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getInterpolation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:279
	Result<cv::optflow::InterpolationType> cv_optflow_DenseRLOFOpticalFlow_getInterpolation_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			cv::optflow::InterpolationType ret = instance->getInterpolation();
			return Ok<cv::optflow::InterpolationType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::InterpolationType>))
	}
	
	// getEPICK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:285
	Result<int> cv_optflow_DenseRLOFOpticalFlow_getEPICK_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			int ret = instance->getEPICK();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setEPICK(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:289
	Result_void cv_optflow_DenseRLOFOpticalFlow_setEPICK_int(cv::optflow::DenseRLOFOpticalFlow* instance, int val) {
		try {
			instance->setEPICK(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEPICSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:296
	Result<float> cv_optflow_DenseRLOFOpticalFlow_getEPICSigma_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getEPICSigma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setEPICSigma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:300
	Result_void cv_optflow_DenseRLOFOpticalFlow_setEPICSigma_float(cv::optflow::DenseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setEPICSigma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEPICLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:306
	Result<float> cv_optflow_DenseRLOFOpticalFlow_getEPICLambda_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getEPICLambda();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setEPICLambda(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:310
	Result_void cv_optflow_DenseRLOFOpticalFlow_setEPICLambda_float(cv::optflow::DenseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setEPICLambda(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFgsLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:315
	Result<float> cv_optflow_DenseRLOFOpticalFlow_getFgsLambda_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getFgsLambda();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setFgsLambda(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:319
	Result_void cv_optflow_DenseRLOFOpticalFlow_setFgsLambda_float(cv::optflow::DenseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setFgsLambda(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFgsSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:324
	Result<float> cv_optflow_DenseRLOFOpticalFlow_getFgsSigma_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getFgsSigma();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setFgsSigma(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:328
	Result_void cv_optflow_DenseRLOFOpticalFlow_setFgsSigma_float(cv::optflow::DenseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setFgsSigma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUsePostProc(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:333
	Result_void cv_optflow_DenseRLOFOpticalFlow_setUsePostProc_bool(cv::optflow::DenseRLOFOpticalFlow* instance, bool val) {
		try {
			instance->setUsePostProc(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUsePostProc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:337
	Result<bool> cv_optflow_DenseRLOFOpticalFlow_getUsePostProc_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			bool ret = instance->getUsePostProc();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseVariationalRefinement(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:342
	Result_void cv_optflow_DenseRLOFOpticalFlow_setUseVariationalRefinement_bool(cv::optflow::DenseRLOFOpticalFlow* instance, bool val) {
		try {
			instance->setUseVariationalRefinement(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseVariationalRefinement() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:346
	Result<bool> cv_optflow_DenseRLOFOpticalFlow_getUseVariationalRefinement_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			bool ret = instance->getUseVariationalRefinement();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setRICSPSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:351
	Result_void cv_optflow_DenseRLOFOpticalFlow_setRICSPSize_int(cv::optflow::DenseRLOFOpticalFlow* instance, int val) {
		try {
			instance->setRICSPSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRICSPSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:355
	Result<int> cv_optflow_DenseRLOFOpticalFlow_getRICSPSize_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			int ret = instance->getRICSPSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRICSLICType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:362
	Result_void cv_optflow_DenseRLOFOpticalFlow_setRICSLICType_int(cv::optflow::DenseRLOFOpticalFlow* instance, int val) {
		try {
			instance->setRICSLICType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRICSLICType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:366
	Result<int> cv_optflow_DenseRLOFOpticalFlow_getRICSLICType_const(const cv::optflow::DenseRLOFOpticalFlow* instance) {
		try {
			int ret = instance->getRICSLICType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// create(Ptr<cv::optflow::RLOFOpticalFlowParameter>, float, cv::Size, cv::optflow::InterpolationType, int, float, float, int, int, bool, float, float, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:383
	Result<cv::Ptr<cv::optflow::DenseRLOFOpticalFlow>*> cv_optflow_DenseRLOFOpticalFlow_create_Ptr_RLOFOpticalFlowParameter__float_Size_InterpolationType_int_float_float_int_int_bool_float_float_bool(cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* rlofParam, float forwardBackwardThreshold, cv::Size* gridStep, cv::optflow::InterpolationType interp_type, int epicK, float epicSigma, float epicLambda, int ricSPSize, int ricSLICType, bool use_post_proc, float fgsLambda, float fgsSigma, bool use_variational_refinement) {
		try {
			cv::Ptr<cv::optflow::DenseRLOFOpticalFlow> ret = cv::optflow::DenseRLOFOpticalFlow::create(*rlofParam, forwardBackwardThreshold, *gridStep, interp_type, epicK, epicSigma, epicLambda, ricSPSize, ricSLICType, use_post_proc, fgsLambda, fgsSigma, use_variational_refinement);
			return Ok(new cv::Ptr<cv::optflow::DenseRLOFOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::DenseRLOFOpticalFlow>*>))
	}
	
	// getTau() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:223
	Result<double> cv_optflow_DualTVL1OpticalFlow_getTau_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getTau();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTau(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:225
	Result_void cv_optflow_DualTVL1OpticalFlow_setTau_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setTau(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLambda() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:228
	Result<double> cv_optflow_DualTVL1OpticalFlow_getLambda_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getLambda();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLambda(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:230
	Result_void cv_optflow_DualTVL1OpticalFlow_setLambda_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setLambda(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTheta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:233
	Result<double> cv_optflow_DualTVL1OpticalFlow_getTheta_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getTheta();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTheta(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:235
	Result_void cv_optflow_DualTVL1OpticalFlow_setTheta_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setTheta(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:238
	Result<double> cv_optflow_DualTVL1OpticalFlow_getGamma_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getGamma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setGamma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:240
	Result_void cv_optflow_DualTVL1OpticalFlow_setGamma_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setGamma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScalesNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:243
	Result<int> cv_optflow_DualTVL1OpticalFlow_getScalesNumber_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getScalesNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setScalesNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:245
	Result_void cv_optflow_DualTVL1OpticalFlow_setScalesNumber_int(cv::optflow::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setScalesNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWarpingsNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:248
	Result<int> cv_optflow_DualTVL1OpticalFlow_getWarpingsNumber_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getWarpingsNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWarpingsNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:250
	Result_void cv_optflow_DualTVL1OpticalFlow_setWarpingsNumber_int(cv::optflow::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setWarpingsNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEpsilon() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:253
	Result<double> cv_optflow_DualTVL1OpticalFlow_getEpsilon_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getEpsilon();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setEpsilon(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:255
	Result_void cv_optflow_DualTVL1OpticalFlow_setEpsilon_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setEpsilon(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getInnerIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:258
	Result<int> cv_optflow_DualTVL1OpticalFlow_getInnerIterations_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getInnerIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setInnerIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:260
	Result_void cv_optflow_DualTVL1OpticalFlow_setInnerIterations_int(cv::optflow::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setInnerIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOuterIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:263
	Result<int> cv_optflow_DualTVL1OpticalFlow_getOuterIterations_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getOuterIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setOuterIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:265
	Result_void cv_optflow_DualTVL1OpticalFlow_setOuterIterations_int(cv::optflow::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setOuterIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseInitialFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:268
	Result<bool> cv_optflow_DualTVL1OpticalFlow_getUseInitialFlow_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			bool ret = instance->getUseInitialFlow();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseInitialFlow(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:270
	Result_void cv_optflow_DualTVL1OpticalFlow_setUseInitialFlow_bool(cv::optflow::DualTVL1OpticalFlow* instance, bool val) {
		try {
			instance->setUseInitialFlow(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:273
	Result<double> cv_optflow_DualTVL1OpticalFlow_getScaleStep_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			double ret = instance->getScaleStep();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setScaleStep(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:275
	Result_void cv_optflow_DualTVL1OpticalFlow_setScaleStep_double(cv::optflow::DualTVL1OpticalFlow* instance, double val) {
		try {
			instance->setScaleStep(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMedianFiltering() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:278
	Result<int> cv_optflow_DualTVL1OpticalFlow_getMedianFiltering_const(const cv::optflow::DualTVL1OpticalFlow* instance) {
		try {
			int ret = instance->getMedianFiltering();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMedianFiltering(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:280
	Result_void cv_optflow_DualTVL1OpticalFlow_setMedianFiltering_int(cv::optflow::DualTVL1OpticalFlow* instance, int val) {
		try {
			instance->setMedianFiltering(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(double, double, double, int, int, double, int, int, double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow.hpp:283
	Result<cv::Ptr<cv::optflow::DualTVL1OpticalFlow>*> cv_optflow_DualTVL1OpticalFlow_create_double_double_double_int_int_double_int_int_double_double_int_bool(double tau, double lambda, double theta, int nscales, int warps, double epsilon, int innnerIterations, int outerIterations, double scaleStep, double gamma, int medianFiltering, bool useInitialFlow) {
		try {
			cv::Ptr<cv::optflow::DualTVL1OpticalFlow> ret = cv::optflow::DualTVL1OpticalFlow::create(tau, lambda, theta, nscales, warps, epsilon, innnerIterations, outerIterations, scaleStep, gamma, medianFiltering, useInitialFlow);
			return Ok(new cv::Ptr<cv::optflow::DualTVL1OpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::DualTVL1OpticalFlow>*>))
	}
	
	void cv_GPCDetails_delete(cv::optflow::GPCDetails* instance) {
		delete instance;
	}
	// getAllDescriptorsForImage(const cv::Mat *, std::vector<GPCPatchDescriptor> &, const cv::optflow::GPCMatchingParams &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:306
	Result_void cv_optflow_GPCDetails_getAllDescriptorsForImage_const_MatX_vector_GPCPatchDescriptor_R_const_GPCMatchingParamsR_int(const cv::Mat* imgCh, std::vector<cv::optflow::GPCPatchDescriptor>* descr, const cv::optflow::GPCMatchingParams* mp, int type) {
		try {
			cv::optflow::GPCDetails::getAllDescriptorsForImage(imgCh, *descr, *mp, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCoordinatesFromIndex(size_t, cv::Size, int &, int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:309
	Result_void cv_optflow_GPCDetails_getCoordinatesFromIndex_size_t_Size_intR_intR(size_t index, cv::Size* sz, int* x, int* y) {
		try {
			cv::optflow::GPCDetails::getCoordinatesFromIndex(index, *sz, *x, *y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GPCMatchingParams(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:147
	Result<cv::optflow::GPCMatchingParams> cv_optflow_GPCMatchingParams_GPCMatchingParams_bool(bool _useOpenCL) {
		try {
			cv::optflow::GPCMatchingParams ret(_useOpenCL);
			return Ok<cv::optflow::GPCMatchingParams>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::GPCMatchingParams>))
	}
	
	// GPCMatchingParams(const cv::optflow::GPCMatchingParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:149
	Result<cv::optflow::GPCMatchingParams> cv_optflow_GPCMatchingParams_GPCMatchingParams_const_GPCMatchingParamsR(const cv::optflow::GPCMatchingParams* params) {
		try {
			cv::optflow::GPCMatchingParams ret(*params);
			return Ok<cv::optflow::GPCMatchingParams>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::GPCMatchingParams>))
	}
	
	// feature /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:68
	cv::Vec<double, 18> cv_optflow_GPCPatchDescriptor_getPropFeature_const(const cv::optflow::GPCPatchDescriptor* instance) {
		cv::Vec<double, 18> ret = instance->feature;
		return (cv::Vec<double, 18>)ret;
	}
	
	// feature /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:68
	void cv_optflow_GPCPatchDescriptor_setPropFeature_Vec_double__18_(cv::optflow::GPCPatchDescriptor* instance, cv::Vec<double, 18>* val) {
		instance->feature = *val;
	}
	
	void cv_GPCPatchDescriptor_delete(cv::optflow::GPCPatchDescriptor* instance) {
		delete instance;
	}
	// dot(const Vec<double, nFeatures> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:70
	Result<double> cv_optflow_GPCPatchDescriptor_dot_const_const_Vec_double__18_R(const cv::optflow::GPCPatchDescriptor* instance, const cv::Vec<double, 18>* coef) {
		try {
			double ret = instance->dot(*coef);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// markAsSeparated() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:72
	Result_void cv_optflow_GPCPatchDescriptor_markAsSeparated(cv::optflow::GPCPatchDescriptor* instance) {
		try {
			instance->markAsSeparated();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isSeparated() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:74
	Result<bool> cv_optflow_GPCPatchDescriptor_isSeparated_const(const cv::optflow::GPCPatchDescriptor* instance) {
		try {
			bool ret = instance->isSeparated();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ref /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:79
	cv::optflow::GPCPatchDescriptor* cv_optflow_GPCPatchSample_getPropRef_const(const cv::optflow::GPCPatchSample* instance) {
		cv::optflow::GPCPatchDescriptor ret = instance->ref;
		return new cv::optflow::GPCPatchDescriptor(ret);
	}
	
	// ref /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:79
	void cv_optflow_GPCPatchSample_setPropRef_GPCPatchDescriptor(cv::optflow::GPCPatchSample* instance, cv::optflow::GPCPatchDescriptor* val) {
		instance->ref = *val;
	}
	
	// pos /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:80
	cv::optflow::GPCPatchDescriptor* cv_optflow_GPCPatchSample_getPropPos_const(const cv::optflow::GPCPatchSample* instance) {
		cv::optflow::GPCPatchDescriptor ret = instance->pos;
		return new cv::optflow::GPCPatchDescriptor(ret);
	}
	
	// pos /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:80
	void cv_optflow_GPCPatchSample_setPropPos_GPCPatchDescriptor(cv::optflow::GPCPatchSample* instance, cv::optflow::GPCPatchDescriptor* val) {
		instance->pos = *val;
	}
	
	// neg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:81
	cv::optflow::GPCPatchDescriptor* cv_optflow_GPCPatchSample_getPropNeg_const(const cv::optflow::GPCPatchSample* instance) {
		cv::optflow::GPCPatchDescriptor ret = instance->neg;
		return new cv::optflow::GPCPatchDescriptor(ret);
	}
	
	// neg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:81
	void cv_optflow_GPCPatchSample_setPropNeg_GPCPatchDescriptor(cv::optflow::GPCPatchSample* instance, cv::optflow::GPCPatchDescriptor* val) {
		instance->neg = *val;
	}
	
	void cv_GPCPatchSample_delete(cv::optflow::GPCPatchSample* instance) {
		delete instance;
	}
	// getDirections(bool &, bool &, bool &, const Vec<double, GPCPatchDescriptor::nFeatures> &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:83
	Result_void cv_optflow_GPCPatchSample_getDirections_const_boolR_boolR_boolR_const_Vec_double__18_R_double(const cv::optflow::GPCPatchSample* instance, bool* refdir, bool* posdir, bool* negdir, const cv::Vec<double, 18>* coef, double rhs) {
		try {
			instance->getDirections(*refdir, *posdir, *negdir, *coef, rhs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GPCTrainingParams(unsigned int, int, cv::optflow::GPCDescType, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:130
	Result<cv::optflow::GPCTrainingParams> cv_optflow_GPCTrainingParams_GPCTrainingParams_unsigned_int_int_GPCDescType_bool(unsigned int _maxTreeDepth, int _minNumberOfSamples, cv::optflow::GPCDescType _descriptorType, bool _printProgress) {
		try {
			cv::optflow::GPCTrainingParams ret(_maxTreeDepth, _minNumberOfSamples, _descriptorType, _printProgress);
			return Ok<cv::optflow::GPCTrainingParams>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::GPCTrainingParams>))
	}
	
	// check() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:138
	Result<bool> cv_optflow_GPCTrainingParams_check_const(const cv::optflow::GPCTrainingParams instance) {
		try {
			bool ret = instance.check();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_GPCTrainingSamples_delete(cv::optflow::GPCTrainingSamples* instance) {
		delete instance;
	}
	// create(const std::vector<String> &, const std::vector<String> &, const std::vector<String> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:108
	Result<cv::Ptr<cv::optflow::GPCTrainingSamples>*> cv_optflow_GPCTrainingSamples_create_const_vector_String_R_const_vector_String_R_const_vector_String_R_int(const std::vector<cv::String>* imagesFrom, const std::vector<cv::String>* imagesTo, const std::vector<cv::String>* gt, int descriptorType) {
		try {
			cv::Ptr<cv::optflow::GPCTrainingSamples> ret = cv::optflow::GPCTrainingSamples::create(*imagesFrom, *imagesTo, *gt, descriptorType);
			return Ok(new cv::Ptr<cv::optflow::GPCTrainingSamples>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::GPCTrainingSamples>*>))
	}
	
	// create(cv::InputArrayOfArrays, cv::InputArrayOfArrays, cv::InputArrayOfArrays, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:111
	Result<cv::Ptr<cv::optflow::GPCTrainingSamples>*> cv_optflow_GPCTrainingSamples_create_const__InputArrayR_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* imagesFrom, const cv::_InputArray* imagesTo, const cv::_InputArray* gt, int descriptorType) {
		try {
			cv::Ptr<cv::optflow::GPCTrainingSamples> ret = cv::optflow::GPCTrainingSamples::create(*imagesFrom, *imagesTo, *gt, descriptorType);
			return Ok(new cv::Ptr<cv::optflow::GPCTrainingSamples>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::GPCTrainingSamples>*>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:114
	Result<size_t> cv_optflow_GPCTrainingSamples_size_const(const cv::optflow::GPCTrainingSamples* instance) {
		try {
			size_t ret = instance->size();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:116
	Result<int> cv_optflow_GPCTrainingSamples_type_const(const cv::optflow::GPCTrainingSamples* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	cv::Algorithm* cv_GPCTree_to_Algorithm(cv::optflow::GPCTree* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_GPCTree_delete(cv::optflow::GPCTree* instance) {
		delete instance;
	}
	// train(cv::optflow::GPCTrainingSamples &, const cv::optflow::GPCTrainingParams) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:176
	Result_void cv_optflow_GPCTree_train_GPCTrainingSamplesR_const_GPCTrainingParams(cv::optflow::GPCTree* instance, cv::optflow::GPCTrainingSamples* samples, const cv::optflow::GPCTrainingParams* params) {
		try {
			instance->train(*samples, *params);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:178
	Result_void cv_optflow_GPCTree_write_const_FileStorageR(const cv::optflow::GPCTree* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:180
	Result_void cv_optflow_GPCTree_read_const_FileNodeR(cv::optflow::GPCTree* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findLeafForPatch(const cv::optflow::GPCPatchDescriptor &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:182
	Result<unsigned int> cv_optflow_GPCTree_findLeafForPatch_const_const_GPCPatchDescriptorR(const cv::optflow::GPCTree* instance, const cv::optflow::GPCPatchDescriptor* descr) {
		try {
			unsigned int ret = instance->findLeafForPatch(*descr);
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:184
	Result<cv::Ptr<cv::optflow::GPCTree>*> cv_optflow_GPCTree_create() {
		try {
			cv::Ptr<cv::optflow::GPCTree> ret = cv::optflow::GPCTree::create();
			return Ok(new cv::Ptr<cv::optflow::GPCTree>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::GPCTree>*>))
	}
	
	// operator==(const cv::optflow::GPCTree &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:186
	Result<bool> cv_optflow_GPCTree_operatorEQ_const_const_GPCTreeR(const cv::optflow::GPCTree* instance, const cv::optflow::GPCTree* t) {
		try {
			bool ret = instance->operator==(*t);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getDescriptorType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:188
	Result<int> cv_optflow_GPCTree_getDescriptorType_const(const cv::optflow::GPCTree* instance) {
		try {
			int ret = instance->getDescriptorType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// operator==(const cv::optflow::GPCTree::Node &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/sparse_matching_gpc.hpp:164
	Result<bool> cv_optflow_GPCTree_Node_operatorEQ_const_const_NodeR(const cv::optflow::GPCTree::Node instance, const cv::optflow::GPCTree::Node* n) {
		try {
			bool ret = instance.operator==(*n);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::Algorithm* cv_OpticalFlowPCAFlow_to_Algorithm(cv::optflow::OpticalFlowPCAFlow* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_OpticalFlowPCAFlow_delete(cv::optflow::OpticalFlowPCAFlow* instance) {
		delete instance;
	}
	// OpticalFlowPCAFlow(Ptr<const cv::optflow::PCAPrior>, const cv::Size, float, float, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:116
	Result<cv::optflow::OpticalFlowPCAFlow*> cv_optflow_OpticalFlowPCAFlow_OpticalFlowPCAFlow_Ptr_const_PCAPrior__const_Size_float_float_float_float_float(cv::Ptr<const cv::optflow::PCAPrior>* _prior, const cv::Size* _basisSize, float _sparseRate, float _retainedCornersFraction, float _occlusionsThreshold, float _dampingFactor, float _claheClip) {
		try {
			cv::optflow::OpticalFlowPCAFlow* ret = new cv::optflow::OpticalFlowPCAFlow(*_prior, *_basisSize, _sparseRate, _retainedCornersFraction, _occlusionsThreshold, _dampingFactor, _claheClip);
			return Ok<cv::optflow::OpticalFlowPCAFlow*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::OpticalFlowPCAFlow*>))
	}
	
	// calc(cv::InputArray, cv::InputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:120
	Result_void cv_optflow_OpticalFlowPCAFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(cv::optflow::OpticalFlowPCAFlow* instance, const cv::_InputArray* I0, const cv::_InputArray* I1, const cv::_InputOutputArray* flow) {
		try {
			instance->calc(*I0, *I1, *flow);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:121
	Result_void cv_optflow_OpticalFlowPCAFlow_collectGarbage(cv::optflow::OpticalFlowPCAFlow* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_PCAPrior_delete(cv::optflow::PCAPrior* instance) {
		delete instance;
	}
	// PCAPrior(const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:83
	Result<cv::optflow::PCAPrior*> cv_optflow_PCAPrior_PCAPrior_const_charX(const char* pathToPrior) {
		try {
			cv::optflow::PCAPrior* ret = new cv::optflow::PCAPrior(pathToPrior);
			return Ok<cv::optflow::PCAPrior*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::PCAPrior*>))
	}
	
	// getPadding() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:85
	Result<int> cv_optflow_PCAPrior_getPadding_const(const cv::optflow::PCAPrior* instance) {
		try {
			int ret = instance->getPadding();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getBasisSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:87
	Result<int> cv_optflow_PCAPrior_getBasisSize_const(const cv::optflow::PCAPrior* instance) {
		try {
			int ret = instance->getBasisSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// fillConstraints(float *, float *, float *, float *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/pcaflow.hpp:89
	Result_void cv_optflow_PCAPrior_fillConstraints_const_floatX_floatX_floatX_floatX(const cv::optflow::PCAPrior* instance, float* A1, float* A2, float* b1, float* b2) {
		try {
			instance->fillConstraints(A1, A2, b1, b2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// solverType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:83
	cv::optflow::SolverType cv_optflow_RLOFOpticalFlowParameter_getPropSolverType_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		cv::optflow::SolverType ret = instance->solverType;
		return (cv::optflow::SolverType)ret;
	}
	
	// solverType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:83
	void cv_optflow_RLOFOpticalFlowParameter_setPropSolverType_SolverType(cv::optflow::RLOFOpticalFlowParameter* instance, cv::optflow::SolverType val) {
		instance->solverType = val;
	}
	
	// supportRegionType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:88
	cv::optflow::SupportRegionType cv_optflow_RLOFOpticalFlowParameter_getPropSupportRegionType_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		cv::optflow::SupportRegionType ret = instance->supportRegionType;
		return (cv::optflow::SupportRegionType)ret;
	}
	
	// supportRegionType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:88
	void cv_optflow_RLOFOpticalFlowParameter_setPropSupportRegionType_SupportRegionType(cv::optflow::RLOFOpticalFlowParameter* instance, cv::optflow::SupportRegionType val) {
		instance->supportRegionType = val;
	}
	
	// normSigma0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:92
	float cv_optflow_RLOFOpticalFlowParameter_getPropNormSigma0_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		float ret = instance->normSigma0;
		return (float)ret;
	}
	
	// normSigma0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:92
	void cv_optflow_RLOFOpticalFlowParameter_setPropNormSigma0_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		instance->normSigma0 = val;
	}
	
	// normSigma1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:98
	float cv_optflow_RLOFOpticalFlowParameter_getPropNormSigma1_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		float ret = instance->normSigma1;
		return (float)ret;
	}
	
	// normSigma1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:98
	void cv_optflow_RLOFOpticalFlowParameter_setPropNormSigma1_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		instance->normSigma1 = val;
	}
	
	// smallWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:104
	int cv_optflow_RLOFOpticalFlowParameter_getPropSmallWinSize_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		int ret = instance->smallWinSize;
		return (int)ret;
	}
	
	// smallWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:104
	void cv_optflow_RLOFOpticalFlowParameter_setPropSmallWinSize_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		instance->smallWinSize = val;
	}
	
	// largeWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:107
	int cv_optflow_RLOFOpticalFlowParameter_getPropLargeWinSize_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		int ret = instance->largeWinSize;
		return (int)ret;
	}
	
	// largeWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:107
	void cv_optflow_RLOFOpticalFlowParameter_setPropLargeWinSize_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		instance->largeWinSize = val;
	}
	
	// crossSegmentationThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:112
	int cv_optflow_RLOFOpticalFlowParameter_getPropCrossSegmentationThreshold_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		int ret = instance->crossSegmentationThreshold;
		return (int)ret;
	}
	
	// crossSegmentationThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:112
	void cv_optflow_RLOFOpticalFlowParameter_setPropCrossSegmentationThreshold_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		instance->crossSegmentationThreshold = val;
	}
	
	// maxLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:117
	int cv_optflow_RLOFOpticalFlowParameter_getPropMaxLevel_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		int ret = instance->maxLevel;
		return (int)ret;
	}
	
	// maxLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:117
	void cv_optflow_RLOFOpticalFlowParameter_setPropMaxLevel_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		instance->maxLevel = val;
	}
	
	// useInitialFlow /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:122
	bool cv_optflow_RLOFOpticalFlowParameter_getPropUseInitialFlow_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		bool ret = instance->useInitialFlow;
		return (bool)ret;
	}
	
	// useInitialFlow /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:122
	void cv_optflow_RLOFOpticalFlowParameter_setPropUseInitialFlow_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		instance->useInitialFlow = val;
	}
	
	// useIlluminationModel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:126
	bool cv_optflow_RLOFOpticalFlowParameter_getPropUseIlluminationModel_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		bool ret = instance->useIlluminationModel;
		return (bool)ret;
	}
	
	// useIlluminationModel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:126
	void cv_optflow_RLOFOpticalFlowParameter_setPropUseIlluminationModel_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		instance->useIlluminationModel = val;
	}
	
	// useGlobalMotionPrior /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:134
	bool cv_optflow_RLOFOpticalFlowParameter_getPropUseGlobalMotionPrior_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		bool ret = instance->useGlobalMotionPrior;
		return (bool)ret;
	}
	
	// useGlobalMotionPrior /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:134
	void cv_optflow_RLOFOpticalFlowParameter_setPropUseGlobalMotionPrior_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		instance->useGlobalMotionPrior = val;
	}
	
	// maxIteration /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:139
	int cv_optflow_RLOFOpticalFlowParameter_getPropMaxIteration_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		int ret = instance->maxIteration;
		return (int)ret;
	}
	
	// maxIteration /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:139
	void cv_optflow_RLOFOpticalFlowParameter_setPropMaxIteration_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		instance->maxIteration = val;
	}
	
	// minEigenValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:143
	float cv_optflow_RLOFOpticalFlowParameter_getPropMinEigenValue_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		float ret = instance->minEigenValue;
		return (float)ret;
	}
	
	// minEigenValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:143
	void cv_optflow_RLOFOpticalFlowParameter_setPropMinEigenValue_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		instance->minEigenValue = val;
	}
	
	// globalMotionRansacThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:147
	float cv_optflow_RLOFOpticalFlowParameter_getPropGlobalMotionRansacThreshold_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		float ret = instance->globalMotionRansacThreshold;
		return (float)ret;
	}
	
	// globalMotionRansacThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:147
	void cv_optflow_RLOFOpticalFlowParameter_setPropGlobalMotionRansacThreshold_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		instance->globalMotionRansacThreshold = val;
	}
	
	void cv_RLOFOpticalFlowParameter_delete(cv::optflow::RLOFOpticalFlowParameter* instance) {
		delete instance;
	}
	// RLOFOpticalFlowParameter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:66
	Result<cv::optflow::RLOFOpticalFlowParameter*> cv_optflow_RLOFOpticalFlowParameter_RLOFOpticalFlowParameter() {
		try {
			cv::optflow::RLOFOpticalFlowParameter* ret = new cv::optflow::RLOFOpticalFlowParameter();
			return Ok<cv::optflow::RLOFOpticalFlowParameter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::RLOFOpticalFlowParameter*>))
	}
	
	// setUseMEstimator(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:160
	Result_void cv_optflow_RLOFOpticalFlowParameter_setUseMEstimator_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		try {
			instance->setUseMEstimator(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSolverType(cv::optflow::SolverType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:162
	Result_void cv_optflow_RLOFOpticalFlowParameter_setSolverType_SolverType(cv::optflow::RLOFOpticalFlowParameter* instance, cv::optflow::SolverType val) {
		try {
			instance->setSolverType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSolverType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:163
	Result<cv::optflow::SolverType> cv_optflow_RLOFOpticalFlowParameter_getSolverType_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			cv::optflow::SolverType ret = instance->getSolverType();
			return Ok<cv::optflow::SolverType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::SolverType>))
	}
	
	// setSupportRegionType(cv::optflow::SupportRegionType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:165
	Result_void cv_optflow_RLOFOpticalFlowParameter_setSupportRegionType_SupportRegionType(cv::optflow::RLOFOpticalFlowParameter* instance, cv::optflow::SupportRegionType val) {
		try {
			instance->setSupportRegionType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSupportRegionType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:166
	Result<cv::optflow::SupportRegionType> cv_optflow_RLOFOpticalFlowParameter_getSupportRegionType_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			cv::optflow::SupportRegionType ret = instance->getSupportRegionType();
			return Ok<cv::optflow::SupportRegionType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::optflow::SupportRegionType>))
	}
	
	// setNormSigma0(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:168
	Result_void cv_optflow_RLOFOpticalFlowParameter_setNormSigma0_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		try {
			instance->setNormSigma0(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormSigma0() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:169
	Result<float> cv_optflow_RLOFOpticalFlowParameter_getNormSigma0_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			float ret = instance->getNormSigma0();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setNormSigma1(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:171
	Result_void cv_optflow_RLOFOpticalFlowParameter_setNormSigma1_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		try {
			instance->setNormSigma1(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormSigma1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:172
	Result<float> cv_optflow_RLOFOpticalFlowParameter_getNormSigma1_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			float ret = instance->getNormSigma1();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSmallWinSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:174
	Result_void cv_optflow_RLOFOpticalFlowParameter_setSmallWinSize_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		try {
			instance->setSmallWinSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSmallWinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:175
	Result<int> cv_optflow_RLOFOpticalFlowParameter_getSmallWinSize_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			int ret = instance->getSmallWinSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setLargeWinSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:177
	Result_void cv_optflow_RLOFOpticalFlowParameter_setLargeWinSize_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		try {
			instance->setLargeWinSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLargeWinSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:178
	Result<int> cv_optflow_RLOFOpticalFlowParameter_getLargeWinSize_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			int ret = instance->getLargeWinSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCrossSegmentationThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:180
	Result_void cv_optflow_RLOFOpticalFlowParameter_setCrossSegmentationThreshold_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		try {
			instance->setCrossSegmentationThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCrossSegmentationThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:181
	Result<int> cv_optflow_RLOFOpticalFlowParameter_getCrossSegmentationThreshold_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			int ret = instance->getCrossSegmentationThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:183
	Result_void cv_optflow_RLOFOpticalFlowParameter_setMaxLevel_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		try {
			instance->setMaxLevel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:184
	Result<int> cv_optflow_RLOFOpticalFlowParameter_getMaxLevel_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			int ret = instance->getMaxLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setUseInitialFlow(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:186
	Result_void cv_optflow_RLOFOpticalFlowParameter_setUseInitialFlow_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		try {
			instance->setUseInitialFlow(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseInitialFlow() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:187
	Result<bool> cv_optflow_RLOFOpticalFlowParameter_getUseInitialFlow_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			bool ret = instance->getUseInitialFlow();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseIlluminationModel(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:189
	Result_void cv_optflow_RLOFOpticalFlowParameter_setUseIlluminationModel_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		try {
			instance->setUseIlluminationModel(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseIlluminationModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:190
	Result<bool> cv_optflow_RLOFOpticalFlowParameter_getUseIlluminationModel_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			bool ret = instance->getUseIlluminationModel();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseGlobalMotionPrior(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:192
	Result_void cv_optflow_RLOFOpticalFlowParameter_setUseGlobalMotionPrior_bool(cv::optflow::RLOFOpticalFlowParameter* instance, bool val) {
		try {
			instance->setUseGlobalMotionPrior(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseGlobalMotionPrior() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:193
	Result<bool> cv_optflow_RLOFOpticalFlowParameter_getUseGlobalMotionPrior_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			bool ret = instance->getUseGlobalMotionPrior();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setMaxIteration(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:195
	Result_void cv_optflow_RLOFOpticalFlowParameter_setMaxIteration_int(cv::optflow::RLOFOpticalFlowParameter* instance, int val) {
		try {
			instance->setMaxIteration(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxIteration() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:196
	Result<int> cv_optflow_RLOFOpticalFlowParameter_getMaxIteration_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			int ret = instance->getMaxIteration();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinEigenValue(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:198
	Result_void cv_optflow_RLOFOpticalFlowParameter_setMinEigenValue_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		try {
			instance->setMinEigenValue(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinEigenValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:199
	Result<float> cv_optflow_RLOFOpticalFlowParameter_getMinEigenValue_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			float ret = instance->getMinEigenValue();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setGlobalMotionRansacThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:201
	Result_void cv_optflow_RLOFOpticalFlowParameter_setGlobalMotionRansacThreshold_float(cv::optflow::RLOFOpticalFlowParameter* instance, float val) {
		try {
			instance->setGlobalMotionRansacThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGlobalMotionRansacThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:202
	Result<float> cv_optflow_RLOFOpticalFlowParameter_getGlobalMotionRansacThreshold_const(const cv::optflow::RLOFOpticalFlowParameter* instance) {
		try {
			float ret = instance->getGlobalMotionRansacThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:205
	Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*> cv_optflow_RLOFOpticalFlowParameter_create() {
		try {
			cv::Ptr<cv::optflow::RLOFOpticalFlowParameter> ret = cv::optflow::RLOFOpticalFlowParameter::create();
			return Ok(new cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*>))
	}
	
	// setRLOFOpticalFlowParameter(Ptr<cv::optflow::RLOFOpticalFlowParameter>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:417
	Result_void cv_optflow_SparseRLOFOpticalFlow_setRLOFOpticalFlowParameter_Ptr_RLOFOpticalFlowParameter_(cv::optflow::SparseRLOFOpticalFlow* instance, cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* val) {
		try {
			instance->setRLOFOpticalFlowParameter(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRLOFOpticalFlowParameter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:421
	Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*> cv_optflow_SparseRLOFOpticalFlow_getRLOFOpticalFlowParameter_const(const cv::optflow::SparseRLOFOpticalFlow* instance) {
		try {
			cv::Ptr<cv::optflow::RLOFOpticalFlowParameter> ret = instance->getRLOFOpticalFlowParameter();
			return Ok(new cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>*>))
	}
	
	// setForwardBackward(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:430
	Result_void cv_optflow_SparseRLOFOpticalFlow_setForwardBackward_float(cv::optflow::SparseRLOFOpticalFlow* instance, float val) {
		try {
			instance->setForwardBackward(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getForwardBackward() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:434
	Result<float> cv_optflow_SparseRLOFOpticalFlow_getForwardBackward_const(const cv::optflow::SparseRLOFOpticalFlow* instance) {
		try {
			float ret = instance->getForwardBackward();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create(Ptr<cv::optflow::RLOFOpticalFlowParameter>, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/optflow/rlofflow.hpp:441
	Result<cv::Ptr<cv::optflow::SparseRLOFOpticalFlow>*> cv_optflow_SparseRLOFOpticalFlow_create_Ptr_RLOFOpticalFlowParameter__float(cv::Ptr<cv::optflow::RLOFOpticalFlowParameter>* rlofParam, float forwardBackwardThreshold) {
		try {
			cv::Ptr<cv::optflow::SparseRLOFOpticalFlow> ret = cv::optflow::SparseRLOFOpticalFlow::create(*rlofParam, forwardBackwardThreshold);
			return Ok(new cv::Ptr<cv::optflow::SparseRLOFOpticalFlow>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::optflow::SparseRLOFOpticalFlow>*>))
	}
	
}
