#include "ocvrs_common.hpp"
#include <opencv2/objdetect.hpp>
#include "objdetect_types.hpp"

extern "C" {
	// createFaceDetectionMaskGenerator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:340
	Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*> cv_createFaceDetectionMaskGenerator() {
		try {
			cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator> ret = cv::createFaceDetectionMaskGenerator();
			return Ok(new cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*>))
	}
	
	// groupRectangles_meanshift(std::vector<Rect> &, std::vector<double> &, std::vector<double> &, double, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:162
	Result_void cv_groupRectangles_meanshift_vector_Rect_R_vector_double_R_vector_double_R_double_Size(std::vector<cv::Rect>* rectList, std::vector<double>* foundWeights, std::vector<double>* foundScales, double detectThreshold, cv::Size* winDetSize) {
		try {
			cv::groupRectangles_meanshift(*rectList, *foundWeights, *foundScales, detectThreshold, *winDetSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// groupRectangles(std::vector<Rect> &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:151
	Result_void cv_groupRectangles_vector_Rect_R_int_double(std::vector<cv::Rect>* rectList, int groupThreshold, double eps) {
		try {
			cv::groupRectangles(*rectList, groupThreshold, eps);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// groupRectangles(std::vector<Rect> &, int, double, std::vector<int> *, std::vector<double> *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:156
	Result_void cv_groupRectangles_vector_Rect_R_int_double_vector_int_X_vector_double_X(std::vector<cv::Rect>* rectList, int groupThreshold, double eps, std::vector<int>* weights, std::vector<double>* levelWeights) {
		try {
			cv::groupRectangles(*rectList, groupThreshold, eps, weights, levelWeights);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// groupRectangles(std::vector<Rect> &, std::vector<int> &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:153
	Result_void cv_groupRectangles_vector_Rect_R_vector_int_R_int_double(std::vector<cv::Rect>* rectList, std::vector<int>* weights, int groupThreshold, double eps) {
		try {
			cv::groupRectangles(*rectList, *weights, groupThreshold, eps);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// groupRectangles(std::vector<Rect> &, std::vector<int> &, std::vector<double> &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:159
	Result_void cv_groupRectangles_vector_Rect_R_vector_int_R_vector_double_R_int_double(std::vector<cv::Rect>* rectList, std::vector<int>* rejectLevels, std::vector<double>* levelWeights, int groupThreshold, double eps) {
		try {
			cv::groupRectangles(*rectList, *rejectLevels, *levelWeights, groupThreshold, eps);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:178
	Result<bool> cv_BaseCascadeClassifier_empty_const(const cv::BaseCascadeClassifier* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:179
	Result<bool> cv_BaseCascadeClassifier_load_const_StringR(cv::BaseCascadeClassifier* instance, const char* filename) {
		try {
			bool ret = instance->load(std::string(filename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, double, int, int, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:180
	Result_void cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_double_int_int_Size_Size(cv::BaseCascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize) {
		try {
			instance->detectMultiScale(*image, *objects, scaleFactor, minNeighbors, flags, *minSize, *maxSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<int> &, double, int, int, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:186
	Result_void cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_double_int_int_Size_Size(cv::BaseCascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, std::vector<int>* numDetections, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize) {
		try {
			instance->detectMultiScale(*image, *objects, *numDetections, scaleFactor, minNeighbors, flags, *minSize, *maxSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<int> &, std::vector<double> &, double, int, int, cv::Size, cv::Size, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:193
	Result_void cv_BaseCascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_vector_double_R_double_int_int_Size_Size_bool(cv::BaseCascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, std::vector<int>* rejectLevels, std::vector<double>* levelWeights, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize, bool outputRejectLevels) {
		try {
			instance->detectMultiScale(*image, *objects, *rejectLevels, *levelWeights, scaleFactor, minNeighbors, flags, *minSize, *maxSize, outputRejectLevels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isOldFormatCascade() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:202
	Result<bool> cv_BaseCascadeClassifier_isOldFormatCascade_const(const cv::BaseCascadeClassifier* instance) {
		try {
			bool ret = instance->isOldFormatCascade();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getOriginalWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:203
	Result<cv::Size> cv_BaseCascadeClassifier_getOriginalWindowSize_const(const cv::BaseCascadeClassifier* instance) {
		try {
			cv::Size ret = instance->getOriginalWindowSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getFeatureType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:204
	Result<int> cv_BaseCascadeClassifier_getFeatureType_const(const cv::BaseCascadeClassifier* instance) {
		try {
			int ret = instance->getFeatureType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getOldCascade() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:205
	Result<void*> cv_BaseCascadeClassifier_getOldCascade(cv::BaseCascadeClassifier* instance) {
		try {
			void* ret = instance->getOldCascade();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// setMaskGenerator(const Ptr<cv::BaseCascadeClassifier::MaskGenerator> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:214
	Result_void cv_BaseCascadeClassifier_setMaskGenerator_const_Ptr_MaskGenerator_R(cv::BaseCascadeClassifier* instance, const cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>* maskGenerator) {
		try {
			instance->setMaskGenerator(*maskGenerator);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaskGenerator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:215
	Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*> cv_BaseCascadeClassifier_getMaskGenerator(cv::BaseCascadeClassifier* instance) {
		try {
			cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator> ret = instance->getMaskGenerator();
			return Ok(new cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*>))
	}
	
	// generateMask(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:211
	Result<cv::Mat*> cv_BaseCascadeClassifier_MaskGenerator_generateMask_const_MatR(cv::BaseCascadeClassifier::MaskGenerator* instance, const cv::Mat* src) {
		try {
			cv::Mat ret = instance->generateMask(*src);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// initializeMask(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:212
	Result_void cv_BaseCascadeClassifier_MaskGenerator_initializeMask_const_MatR(cv::BaseCascadeClassifier::MaskGenerator* instance, const cv::Mat* unnamed) {
		try {
			instance->initializeMask(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:337
	cv::Ptr<cv::BaseCascadeClassifier>* cv_CascadeClassifier_getPropCc(cv::CascadeClassifier* instance) {
		cv::Ptr<cv::BaseCascadeClassifier> ret = instance->cc;
		return new cv::Ptr<cv::BaseCascadeClassifier>(ret);
	}
	
	// cc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:337
	void cv_CascadeClassifier_setPropCc_Ptr_BaseCascadeClassifier_(cv::CascadeClassifier* instance, cv::Ptr<cv::BaseCascadeClassifier>* val) {
		instance->cc = *val;
	}
	
	void cv_CascadeClassifier_delete(cv::CascadeClassifier* instance) {
		delete instance;
	}
	// CascadeClassifier() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:227
	Result<cv::CascadeClassifier*> cv_CascadeClassifier_CascadeClassifier() {
		try {
			cv::CascadeClassifier* ret = new cv::CascadeClassifier();
			return Ok<cv::CascadeClassifier*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CascadeClassifier*>))
	}
	
	// CascadeClassifier(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:232
	Result<cv::CascadeClassifier*> cv_CascadeClassifier_CascadeClassifier_const_StringR(const char* filename) {
		try {
			cv::CascadeClassifier* ret = new cv::CascadeClassifier(std::string(filename));
			return Ok<cv::CascadeClassifier*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CascadeClassifier*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:236
	Result<bool> cv_CascadeClassifier_empty_const(const cv::CascadeClassifier* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:243
	Result<bool> cv_CascadeClassifier_load_const_StringR(cv::CascadeClassifier* instance, const char* filename) {
		try {
			bool ret = instance->load(std::string(filename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:248
	Result<bool> cv_CascadeClassifier_read_const_FileNodeR(cv::CascadeClassifier* instance, const cv::FileNode* node) {
		try {
			bool ret = instance->read(*node);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, double, int, int, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:270
	Result_void cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_double_int_int_Size_Size(cv::CascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize) {
		try {
			instance->detectMultiScale(*image, *objects, scaleFactor, minNeighbors, flags, *minSize, *maxSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<int> &, double, int, int, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:292
	Result_void cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_double_int_int_Size_Size(cv::CascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, std::vector<int>* numDetections, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize) {
		try {
			instance->detectMultiScale(*image, *objects, *numDetections, scaleFactor, minNeighbors, flags, *minSize, *maxSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<int> &, std::vector<double> &, double, int, int, cv::Size, cv::Size, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:317
	Result_void cv_CascadeClassifier_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_int_R_vector_double_R_double_int_int_Size_Size_bool(cv::CascadeClassifier* instance, const cv::_InputArray* image, std::vector<cv::Rect>* objects, std::vector<int>* rejectLevels, std::vector<double>* levelWeights, double scaleFactor, int minNeighbors, int flags, cv::Size* minSize, cv::Size* maxSize, bool outputRejectLevels) {
		try {
			instance->detectMultiScale(*image, *objects, *rejectLevels, *levelWeights, scaleFactor, minNeighbors, flags, *minSize, *maxSize, outputRejectLevels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isOldFormatCascade() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:327
	Result<bool> cv_CascadeClassifier_isOldFormatCascade_const(const cv::CascadeClassifier* instance) {
		try {
			bool ret = instance->isOldFormatCascade();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getOriginalWindowSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:328
	Result<cv::Size> cv_CascadeClassifier_getOriginalWindowSize_const(const cv::CascadeClassifier* instance) {
		try {
			cv::Size ret = instance->getOriginalWindowSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getFeatureType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:329
	Result<int> cv_CascadeClassifier_getFeatureType_const(const cv::CascadeClassifier* instance) {
		try {
			int ret = instance->getFeatureType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getOldCascade() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:330
	Result<void*> cv_CascadeClassifier_getOldCascade(cv::CascadeClassifier* instance) {
		try {
			void* ret = instance->getOldCascade();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// convert(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:332
	Result<bool> cv_CascadeClassifier_convert_const_StringR_const_StringR(const char* oldcascade, const char* newcascade) {
		try {
			bool ret = cv::CascadeClassifier::convert(std::string(oldcascade), std::string(newcascade));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setMaskGenerator(const Ptr<BaseCascadeClassifier::MaskGenerator> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:334
	Result_void cv_CascadeClassifier_setMaskGenerator_const_Ptr_MaskGenerator_R(cv::CascadeClassifier* instance, const cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>* maskGenerator) {
		try {
			instance->setMaskGenerator(*maskGenerator);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaskGenerator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:335
	Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*> cv_CascadeClassifier_getMaskGenerator(cv::CascadeClassifier* instance) {
		try {
			cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator> ret = instance->getMaskGenerator();
			return Ok(new cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BaseCascadeClassifier::MaskGenerator>*>))
	}
	
	void cv_DetectionBasedTracker_delete(cv::DetectionBasedTracker* instance) {
		delete instance;
	}
	// DetectionBasedTracker(cv::Ptr<IDetector>, cv::Ptr<IDetector>, const cv::DetectionBasedTracker::Parameters &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:121
	Result<cv::DetectionBasedTracker*> cv_DetectionBasedTracker_DetectionBasedTracker_Ptr_IDetector__Ptr_IDetector__const_ParametersR(cv::Ptr<cv::DetectionBasedTracker::IDetector>* mainDetector, cv::Ptr<cv::DetectionBasedTracker::IDetector>* trackingDetector, const cv::DetectionBasedTracker::Parameters* params) {
		try {
			cv::DetectionBasedTracker* ret = new cv::DetectionBasedTracker(*mainDetector, *trackingDetector, *params);
			return Ok<cv::DetectionBasedTracker*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DetectionBasedTracker*>))
	}
	
	// run() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:124
	Result<bool> cv_DetectionBasedTracker_run(cv::DetectionBasedTracker* instance) {
		try {
			bool ret = instance->run();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// stop() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:125
	Result_void cv_DetectionBasedTracker_stop(cv::DetectionBasedTracker* instance) {
		try {
			instance->stop();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetTracking() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:126
	Result_void cv_DetectionBasedTracker_resetTracking(cv::DetectionBasedTracker* instance) {
		try {
			instance->resetTracking();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// process(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:128
	Result_void cv_DetectionBasedTracker_process_const_MatR(cv::DetectionBasedTracker* instance, const cv::Mat* imageGray) {
		try {
			instance->process(*imageGray);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setParameters(const cv::DetectionBasedTracker::Parameters &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:130
	Result<bool> cv_DetectionBasedTracker_setParameters_const_ParametersR(cv::DetectionBasedTracker* instance, const cv::DetectionBasedTracker::Parameters* params) {
		try {
			bool ret = instance->setParameters(*params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:131
	Result<const cv::DetectionBasedTracker::Parameters*> cv_DetectionBasedTracker_getParameters_const(const cv::DetectionBasedTracker* instance) {
		try {
			const cv::DetectionBasedTracker::Parameters ret = instance->getParameters();
			return Ok(new const cv::DetectionBasedTracker::Parameters(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::DetectionBasedTracker::Parameters*>))
	}
	
	// getObjects(std::vector<cv::Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:135
	Result_void cv_DetectionBasedTracker_getObjects_const_vector_Rect_R(const cv::DetectionBasedTracker* instance, std::vector<cv::Rect>* result) {
		try {
			instance->getObjects(*result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getObjects(std::vector<ExtObject> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:155
	Result_void cv_DetectionBasedTracker_getObjects_const_vector_ExtObject_R(const cv::DetectionBasedTracker* instance, std::vector<cv::DetectionBasedTracker::ExtObject>* result) {
		try {
			instance->getObjects(*result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addObject(const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:158
	Result<int> cv_DetectionBasedTracker_addObject_const_RectR(cv::DetectionBasedTracker* instance, const cv::Rect* location) {
		try {
			int ret = instance->addObject(*location);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:147
	int cv_DetectionBasedTracker_ExtObject_getPropId_const(const cv::DetectionBasedTracker::ExtObject* instance) {
		int ret = instance->id;
		return (int)ret;
	}
	
	// id /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:147
	void cv_DetectionBasedTracker_ExtObject_setPropId_int(cv::DetectionBasedTracker::ExtObject* instance, int val) {
		instance->id = val;
	}
	
	// location /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:148
	cv::Rect cv_DetectionBasedTracker_ExtObject_getPropLocation_const(const cv::DetectionBasedTracker::ExtObject* instance) {
		cv::Rect ret = instance->location;
		return (cv::Rect)ret;
	}
	
	// location /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:148
	void cv_DetectionBasedTracker_ExtObject_setPropLocation_Rect(cv::DetectionBasedTracker::ExtObject* instance, cv::Rect* val) {
		instance->location = *val;
	}
	
	// status /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:149
	cv::DetectionBasedTracker::ObjectStatus cv_DetectionBasedTracker_ExtObject_getPropStatus_const(const cv::DetectionBasedTracker::ExtObject* instance) {
		cv::DetectionBasedTracker::ObjectStatus ret = instance->status;
		return (cv::DetectionBasedTracker::ObjectStatus)ret;
	}
	
	// status /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:149
	void cv_DetectionBasedTracker_ExtObject_setPropStatus_ObjectStatus(cv::DetectionBasedTracker::ExtObject* instance, cv::DetectionBasedTracker::ObjectStatus val) {
		instance->status = val;
	}
	
	void cv_DetectionBasedTracker_ExtObject_delete(cv::DetectionBasedTracker::ExtObject* instance) {
		delete instance;
	}
	// ExtObject(int, cv::Rect, cv::DetectionBasedTracker::ObjectStatus) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:150
	Result<cv::DetectionBasedTracker::ExtObject*> cv_DetectionBasedTracker_ExtObject_ExtObject_int_Rect_ObjectStatus(int _id, cv::Rect* _location, cv::DetectionBasedTracker::ObjectStatus _status) {
		try {
			cv::DetectionBasedTracker::ExtObject* ret = new cv::DetectionBasedTracker::ExtObject(_id, *_location, _status);
			return Ok<cv::DetectionBasedTracker::ExtObject*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DetectionBasedTracker::ExtObject*>))
	}
	
	// detect(const cv::Mat &, std::vector<cv::Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:78
	Result_void cv_DetectionBasedTracker_IDetector_detect_const_MatR_vector_Rect_R(cv::DetectionBasedTracker::IDetector* instance, const cv::Mat* image, std::vector<cv::Rect>* objects) {
		try {
			instance->detect(*image, *objects);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMinObjectSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:80
	Result_void cv_DetectionBasedTracker_IDetector_setMinObjectSize_const_SizeR(cv::DetectionBasedTracker::IDetector* instance, const cv::Size* min) {
		try {
			instance->setMinObjectSize(*min);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxObjectSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:84
	Result_void cv_DetectionBasedTracker_IDetector_setMaxObjectSize_const_SizeR(cv::DetectionBasedTracker::IDetector* instance, const cv::Size* max) {
		try {
			instance->setMaxObjectSize(*max);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinObjectSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:88
	Result<cv::Size> cv_DetectionBasedTracker_IDetector_getMinObjectSize_const(const cv::DetectionBasedTracker::IDetector* instance) {
		try {
			cv::Size ret = instance->getMinObjectSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getMaxObjectSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:92
	Result<cv::Size> cv_DetectionBasedTracker_IDetector_getMaxObjectSize_const(const cv::DetectionBasedTracker::IDetector* instance) {
		try {
			cv::Size ret = instance->getMaxObjectSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getScaleFactor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:96
	Result<float> cv_DetectionBasedTracker_IDetector_getScaleFactor(cv::DetectionBasedTracker::IDetector* instance) {
		try {
			float ret = instance->getScaleFactor();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setScaleFactor(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:100
	Result_void cv_DetectionBasedTracker_IDetector_setScaleFactor_float(cv::DetectionBasedTracker::IDetector* instance, float value) {
		try {
			instance->setScaleFactor(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinNeighbours() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:104
	Result<int> cv_DetectionBasedTracker_IDetector_getMinNeighbours(cv::DetectionBasedTracker::IDetector* instance) {
		try {
			int ret = instance->getMinNeighbours();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinNeighbours(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:108
	Result_void cv_DetectionBasedTracker_IDetector_setMinNeighbours_int(cv::DetectionBasedTracker::IDetector* instance, int value) {
		try {
			instance->setMinNeighbours(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// maxTrackLifetime /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:62
	int cv_DetectionBasedTracker_Parameters_getPropMaxTrackLifetime_const(const cv::DetectionBasedTracker::Parameters* instance) {
		int ret = instance->maxTrackLifetime;
		return (int)ret;
	}
	
	// maxTrackLifetime /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:62
	void cv_DetectionBasedTracker_Parameters_setPropMaxTrackLifetime_int(cv::DetectionBasedTracker::Parameters* instance, int val) {
		instance->maxTrackLifetime = val;
	}
	
	// minDetectionPeriod /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:63
	int cv_DetectionBasedTracker_Parameters_getPropMinDetectionPeriod_const(const cv::DetectionBasedTracker::Parameters* instance) {
		int ret = instance->minDetectionPeriod;
		return (int)ret;
	}
	
	// minDetectionPeriod /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:63
	void cv_DetectionBasedTracker_Parameters_setPropMinDetectionPeriod_int(cv::DetectionBasedTracker::Parameters* instance, int val) {
		instance->minDetectionPeriod = val;
	}
	
	void cv_DetectionBasedTracker_Parameters_delete(cv::DetectionBasedTracker::Parameters* instance) {
		delete instance;
	}
	// Parameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/detection_based_tracker.hpp:65
	Result<cv::DetectionBasedTracker::Parameters*> cv_DetectionBasedTracker_Parameters_Parameters() {
		try {
			cv::DetectionBasedTracker::Parameters* ret = new cv::DetectionBasedTracker::Parameters();
			return Ok<cv::DetectionBasedTracker::Parameters*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DetectionBasedTracker::Parameters*>))
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:348
	double cv_DetectionROI_getPropScale_const(const cv::DetectionROI* instance) {
		double ret = instance->scale;
		return (double)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:348
	void cv_DetectionROI_setPropScale_double(cv::DetectionROI* instance, double val) {
		instance->scale = val;
	}
	
	// locations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:350
	std::vector<cv::Point>* cv_DetectionROI_getPropLocations_const(const cv::DetectionROI* instance) {
		std::vector<cv::Point> ret = instance->locations;
		return new std::vector<cv::Point>(ret);
	}
	
	// locations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:350
	void cv_DetectionROI_setPropLocations_vector_Point_(cv::DetectionROI* instance, std::vector<cv::Point>* val) {
		instance->locations = *val;
	}
	
	// confidences /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:352
	std::vector<double>* cv_DetectionROI_getPropConfidences_const(const cv::DetectionROI* instance) {
		std::vector<double> ret = instance->confidences;
		return new std::vector<double>(ret);
	}
	
	// confidences /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:352
	void cv_DetectionROI_setPropConfidences_vector_double_(cv::DetectionROI* instance, std::vector<double>* val) {
		instance->confidences = *val;
	}
	
	void cv_DetectionROI_delete(cv::DetectionROI* instance) {
		delete instance;
	}
	// setInputSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:27
	Result_void cv_FaceDetectorYN_setInputSize_const_SizeR(cv::FaceDetectorYN* instance, const cv::Size* input_size) {
		try {
			instance->setInputSize(*input_size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getInputSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:29
	Result<cv::Size> cv_FaceDetectorYN_getInputSize(cv::FaceDetectorYN* instance) {
		try {
			cv::Size ret = instance->getInputSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setScoreThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:35
	Result_void cv_FaceDetectorYN_setScoreThreshold_float(cv::FaceDetectorYN* instance, float score_threshold) {
		try {
			instance->setScoreThreshold(score_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScoreThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:37
	Result<float> cv_FaceDetectorYN_getScoreThreshold(cv::FaceDetectorYN* instance) {
		try {
			float ret = instance->getScoreThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setNMSThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:43
	Result_void cv_FaceDetectorYN_setNMSThreshold_float(cv::FaceDetectorYN* instance, float nms_threshold) {
		try {
			instance->setNMSThreshold(nms_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNMSThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:45
	Result<float> cv_FaceDetectorYN_getNMSThreshold(cv::FaceDetectorYN* instance) {
		try {
			float ret = instance->getNMSThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setTopK(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:51
	Result_void cv_FaceDetectorYN_setTopK_int(cv::FaceDetectorYN* instance, int top_k) {
		try {
			instance->setTopK(top_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTopK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:53
	Result<int> cv_FaceDetectorYN_getTopK(cv::FaceDetectorYN* instance) {
		try {
			int ret = instance->getTopK();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// detect(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:60
	Result<int> cv_FaceDetectorYN_detect_const__InputArrayR_const__OutputArrayR(cv::FaceDetectorYN* instance, const cv::_InputArray* image, const cv::_OutputArray* faces) {
		try {
			int ret = instance->detect(*image, *faces);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// create(const cv::String &, const cv::String &, const cv::Size &, float, float, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:73
	Result<cv::Ptr<cv::FaceDetectorYN>*> cv_FaceDetectorYN_create_const_StringR_const_StringR_const_SizeR_float_float_int_int_int(const char* model, const char* config, const cv::Size* input_size, float score_threshold, float nms_threshold, int top_k, int backend_id, int target_id) {
		try {
			cv::Ptr<cv::FaceDetectorYN> ret = cv::FaceDetectorYN::create(std::string(model), std::string(config), *input_size, score_threshold, nms_threshold, top_k, backend_id, target_id);
			return Ok(new cv::Ptr<cv::FaceDetectorYN>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::FaceDetectorYN>*>))
	}
	
	// alignCrop(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:99
	Result_void cv_FaceRecognizerSF_alignCrop_const_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::FaceRecognizerSF* instance, const cv::_InputArray* src_img, const cv::_InputArray* face_box, const cv::_OutputArray* aligned_img) {
		try {
			instance->alignCrop(*src_img, *face_box, *aligned_img);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// feature(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:105
	Result_void cv_FaceRecognizerSF_feature_const__InputArrayR_const__OutputArrayR(cv::FaceRecognizerSF* instance, const cv::_InputArray* aligned_img, const cv::_OutputArray* face_feature) {
		try {
			instance->feature(*aligned_img, *face_feature);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:112
	Result<double> cv_FaceRecognizerSF_match_const_const__InputArrayR_const__InputArrayR_int(const cv::FaceRecognizerSF* instance, const cv::_InputArray* _face_feature1, const cv::_InputArray* _face_feature2, int dis_type) {
		try {
			double ret = instance->match(*_face_feature1, *_face_feature2, dis_type);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// create(const cv::String &, const cv::String &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect/face.hpp:120
	Result<cv::Ptr<cv::FaceRecognizerSF>*> cv_FaceRecognizerSF_create_const_StringR_const_StringR_int_int(const char* model, const char* config, int backend_id, int target_id) {
		try {
			cv::Ptr<cv::FaceRecognizerSF> ret = cv::FaceRecognizerSF::create(std::string(model), std::string(config), backend_id, target_id);
			return Ok(new cv::Ptr<cv::FaceRecognizerSF>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::FaceRecognizerSF>*>))
	}
	
	// winSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:587
	cv::Size cv_HOGDescriptor_getPropWinSize_const(const cv::HOGDescriptor* instance) {
		cv::Size ret = instance->winSize;
		return (cv::Size)ret;
	}
	
	// winSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:587
	void cv_HOGDescriptor_setPropWinSize_Size(cv::HOGDescriptor* instance, cv::Size* val) {
		instance->winSize = *val;
	}
	
	// blockSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:590
	cv::Size cv_HOGDescriptor_getPropBlockSize_const(const cv::HOGDescriptor* instance) {
		cv::Size ret = instance->blockSize;
		return (cv::Size)ret;
	}
	
	// blockSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:590
	void cv_HOGDescriptor_setPropBlockSize_Size(cv::HOGDescriptor* instance, cv::Size* val) {
		instance->blockSize = *val;
	}
	
	// blockStride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:593
	cv::Size cv_HOGDescriptor_getPropBlockStride_const(const cv::HOGDescriptor* instance) {
		cv::Size ret = instance->blockStride;
		return (cv::Size)ret;
	}
	
	// blockStride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:593
	void cv_HOGDescriptor_setPropBlockStride_Size(cv::HOGDescriptor* instance, cv::Size* val) {
		instance->blockStride = *val;
	}
	
	// cellSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:596
	cv::Size cv_HOGDescriptor_getPropCellSize_const(const cv::HOGDescriptor* instance) {
		cv::Size ret = instance->cellSize;
		return (cv::Size)ret;
	}
	
	// cellSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:596
	void cv_HOGDescriptor_setPropCellSize_Size(cv::HOGDescriptor* instance, cv::Size* val) {
		instance->cellSize = *val;
	}
	
	// nbins /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:599
	int cv_HOGDescriptor_getPropNbins_const(const cv::HOGDescriptor* instance) {
		int ret = instance->nbins;
		return (int)ret;
	}
	
	// nbins /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:599
	void cv_HOGDescriptor_setPropNbins_int(cv::HOGDescriptor* instance, int val) {
		instance->nbins = val;
	}
	
	// derivAperture /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:602
	int cv_HOGDescriptor_getPropDerivAperture_const(const cv::HOGDescriptor* instance) {
		int ret = instance->derivAperture;
		return (int)ret;
	}
	
	// derivAperture /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:602
	void cv_HOGDescriptor_setPropDerivAperture_int(cv::HOGDescriptor* instance, int val) {
		instance->derivAperture = val;
	}
	
	// winSigma /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:605
	double cv_HOGDescriptor_getPropWinSigma_const(const cv::HOGDescriptor* instance) {
		double ret = instance->winSigma;
		return (double)ret;
	}
	
	// winSigma /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:605
	void cv_HOGDescriptor_setPropWinSigma_double(cv::HOGDescriptor* instance, double val) {
		instance->winSigma = val;
	}
	
	// histogramNormType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:608
	cv::HOGDescriptor::HistogramNormType cv_HOGDescriptor_getPropHistogramNormType_const(const cv::HOGDescriptor* instance) {
		cv::HOGDescriptor::HistogramNormType ret = instance->histogramNormType;
		return (cv::HOGDescriptor::HistogramNormType)ret;
	}
	
	// histogramNormType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:608
	void cv_HOGDescriptor_setPropHistogramNormType_HistogramNormType(cv::HOGDescriptor* instance, cv::HOGDescriptor::HistogramNormType val) {
		instance->histogramNormType = val;
	}
	
	// L2HysThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:611
	double cv_HOGDescriptor_getPropL2HysThreshold_const(const cv::HOGDescriptor* instance) {
		double ret = instance->L2HysThreshold;
		return (double)ret;
	}
	
	// L2HysThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:611
	void cv_HOGDescriptor_setPropL2HysThreshold_double(cv::HOGDescriptor* instance, double val) {
		instance->L2HysThreshold = val;
	}
	
	// gammaCorrection /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:614
	bool cv_HOGDescriptor_getPropGammaCorrection_const(const cv::HOGDescriptor* instance) {
		bool ret = instance->gammaCorrection;
		return (bool)ret;
	}
	
	// gammaCorrection /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:614
	void cv_HOGDescriptor_setPropGammaCorrection_bool(cv::HOGDescriptor* instance, bool val) {
		instance->gammaCorrection = val;
	}
	
	// svmDetector /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:617
	std::vector<float>* cv_HOGDescriptor_getPropSvmDetector_const(const cv::HOGDescriptor* instance) {
		std::vector<float> ret = instance->svmDetector;
		return new std::vector<float>(ret);
	}
	
	// svmDetector /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:617
	void cv_HOGDescriptor_setPropSvmDetector_vector_float_(cv::HOGDescriptor* instance, std::vector<float>* val) {
		instance->svmDetector = *val;
	}
	
	// oclSvmDetector /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:620
	cv::UMat* cv_HOGDescriptor_getPropOclSvmDetector_const(const cv::HOGDescriptor* instance) {
		cv::UMat ret = instance->oclSvmDetector;
		return new cv::UMat(ret);
	}
	
	// oclSvmDetector /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:620
	void cv_HOGDescriptor_setPropOclSvmDetector_UMat(cv::HOGDescriptor* instance, cv::UMat* val) {
		instance->oclSvmDetector = *val;
	}
	
	// free_coef /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:623
	float cv_HOGDescriptor_getPropFree_coef_const(const cv::HOGDescriptor* instance) {
		float ret = instance->free_coef;
		return (float)ret;
	}
	
	// free_coef /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:623
	void cv_HOGDescriptor_setPropFree_coef_float(cv::HOGDescriptor* instance, float val) {
		instance->free_coef = val;
	}
	
	// nlevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:626
	int cv_HOGDescriptor_getPropNlevels_const(const cv::HOGDescriptor* instance) {
		int ret = instance->nlevels;
		return (int)ret;
	}
	
	// nlevels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:626
	void cv_HOGDescriptor_setPropNlevels_int(cv::HOGDescriptor* instance, int val) {
		instance->nlevels = val;
	}
	
	// signedGradient /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:629
	bool cv_HOGDescriptor_getPropSignedGradient_const(const cv::HOGDescriptor* instance) {
		bool ret = instance->signedGradient;
		return (bool)ret;
	}
	
	// signedGradient /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:629
	void cv_HOGDescriptor_setPropSignedGradient_bool(cv::HOGDescriptor* instance, bool val) {
		instance->signedGradient = val;
	}
	
	void cv_HOGDescriptor_delete(cv::HOGDescriptor* instance) {
		delete instance;
	}
	// HOGDescriptor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:385
	Result<cv::HOGDescriptor*> cv_HOGDescriptor_HOGDescriptor() {
		try {
			cv::HOGDescriptor* ret = new cv::HOGDescriptor();
			return Ok<cv::HOGDescriptor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::HOGDescriptor*>))
	}
	
	// HOGDescriptor(cv::Size, cv::Size, cv::Size, cv::Size, int, int, double, HOGDescriptor::HistogramNormType, double, bool, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:405
	Result<cv::HOGDescriptor*> cv_HOGDescriptor_HOGDescriptor_Size_Size_Size_Size_int_int_double_HistogramNormType_double_bool_int_bool(cv::Size* _winSize, cv::Size* _blockSize, cv::Size* _blockStride, cv::Size* _cellSize, int _nbins, int _derivAperture, double _winSigma, cv::HOGDescriptor::HistogramNormType _histogramNormType, double _L2HysThreshold, bool _gammaCorrection, int _nlevels, bool _signedGradient) {
		try {
			cv::HOGDescriptor* ret = new cv::HOGDescriptor(*_winSize, *_blockSize, *_blockStride, *_cellSize, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection, _nlevels, _signedGradient);
			return Ok<cv::HOGDescriptor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::HOGDescriptor*>))
	}
	
	// HOGDescriptor(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:419
	Result<cv::HOGDescriptor*> cv_HOGDescriptor_HOGDescriptor_const_StringR(const char* filename) {
		try {
			cv::HOGDescriptor* ret = new cv::HOGDescriptor(std::string(filename));
			return Ok<cv::HOGDescriptor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::HOGDescriptor*>))
	}
	
	// HOGDescriptor(const cv::HOGDescriptor &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:427
	Result<cv::HOGDescriptor*> cv_HOGDescriptor_HOGDescriptor_const_HOGDescriptorR(const cv::HOGDescriptor* d) {
		try {
			cv::HOGDescriptor* ret = new cv::HOGDescriptor(*d);
			return Ok<cv::HOGDescriptor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::HOGDescriptor*>))
	}
	
	// getDescriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:438
	Result<size_t> cv_HOGDescriptor_getDescriptorSize_const(const cv::HOGDescriptor* instance) {
		try {
			size_t ret = instance->getDescriptorSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// checkDetectorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:442
	Result<bool> cv_HOGDescriptor_checkDetectorSize_const(const cv::HOGDescriptor* instance) {
		try {
			bool ret = instance->checkDetectorSize();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getWinSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:446
	Result<double> cv_HOGDescriptor_getWinSigma_const(const cv::HOGDescriptor* instance) {
		try {
			double ret = instance->getWinSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSVMDetector(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:453
	Result_void cv_HOGDescriptor_setSVMDetector_const__InputArrayR(cv::HOGDescriptor* instance, const cv::_InputArray* svmdetector) {
		try {
			instance->setSVMDetector(*svmdetector);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:458
	Result<bool> cv_HOGDescriptor_read_FileNodeR(cv::HOGDescriptor* instance, cv::FileNode* fn) {
		try {
			bool ret = instance->read(*fn);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// write(cv::FileStorage &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:464
	Result_void cv_HOGDescriptor_write_const_FileStorageR_const_StringR(const cv::HOGDescriptor* instance, cv::FileStorage* fs, const char* objname) {
		try {
			instance->write(*fs, std::string(objname));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:470
	Result<bool> cv_HOGDescriptor_load_const_StringR_const_StringR(cv::HOGDescriptor* instance, const char* filename, const char* objname) {
		try {
			bool ret = instance->load(std::string(filename), std::string(objname));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// save(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:476
	Result_void cv_HOGDescriptor_save_const_const_StringR_const_StringR(const cv::HOGDescriptor* instance, const char* filename, const char* objname) {
		try {
			instance->save(std::string(filename), std::string(objname));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::HOGDescriptor &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:481
	Result_void cv_HOGDescriptor_copyTo_const_HOGDescriptorR(const cv::HOGDescriptor* instance, cv::HOGDescriptor* c) {
		try {
			instance->copyTo(*c);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, std::vector<float> &, cv::Size, cv::Size, const std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:492
	Result_void cv_HOGDescriptor_compute_const_const__InputArrayR_vector_float_R_Size_Size_const_vector_Point_R(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<float>* descriptors, cv::Size* winStride, cv::Size* padding, const std::vector<cv::Point>* locations) {
		try {
			instance->compute(*img, *descriptors, *winStride, *padding, *locations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, std::vector<Point> &, std::vector<double> &, double, cv::Size, cv::Size, const std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:508
	Result_void cv_HOGDescriptor_detect_const_const__InputArrayR_vector_Point_R_vector_double_R_double_Size_Size_const_vector_Point_R(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<cv::Point>* foundLocations, std::vector<double>* weights, double hitThreshold, cv::Size* winStride, cv::Size* padding, const std::vector<cv::Point>* searchLocations) {
		try {
			instance->detect(*img, *foundLocations, *weights, hitThreshold, *winStride, *padding, *searchLocations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, std::vector<Point> &, double, cv::Size, cv::Size, const std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:524
	Result_void cv_HOGDescriptor_detect_const_const__InputArrayR_vector_Point_R_double_Size_Size_const_vector_Point_R(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<cv::Point>* foundLocations, double hitThreshold, cv::Size* winStride, cv::Size* padding, const std::vector<cv::Point>* searchLocations) {
		try {
			instance->detect(*img, *foundLocations, hitThreshold, *winStride, *padding, *searchLocations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<double> &, double, cv::Size, cv::Size, double, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:543
	Result_void cv_HOGDescriptor_detectMultiScale_const_const__InputArrayR_vector_Rect_R_vector_double_R_double_Size_Size_double_double_bool(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<cv::Rect>* foundLocations, std::vector<double>* foundWeights, double hitThreshold, cv::Size* winStride, cv::Size* padding, double scale, double finalThreshold, bool useMeanshiftGrouping) {
		try {
			instance->detectMultiScale(*img, *foundLocations, *foundWeights, hitThreshold, *winStride, *padding, scale, finalThreshold, useMeanshiftGrouping);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, double, cv::Size, cv::Size, double, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:561
	Result_void cv_HOGDescriptor_detectMultiScale_const_const__InputArrayR_vector_Rect_R_double_Size_Size_double_double_bool(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<cv::Rect>* foundLocations, double hitThreshold, cv::Size* winStride, cv::Size* padding, double scale, double finalThreshold, bool useMeanshiftGrouping) {
		try {
			instance->detectMultiScale(*img, *foundLocations, hitThreshold, *winStride, *padding, scale, finalThreshold, useMeanshiftGrouping);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeGradient(cv::InputArray, cv::InputOutputArray, cv::InputOutputArray, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:573
	Result_void cv_HOGDescriptor_computeGradient_const_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_Size(const cv::HOGDescriptor* instance, const cv::_InputArray* img, const cv::_InputOutputArray* grad, const cv::_InputOutputArray* angleOfs, cv::Size* paddingTL, cv::Size* paddingBR) {
		try {
			instance->computeGradient(*img, *grad, *angleOfs, *paddingTL, *paddingBR);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultPeopleDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:578
	Result<std::vector<float>*> cv_HOGDescriptor_getDefaultPeopleDetector() {
		try {
			std::vector<float> ret = cv::HOGDescriptor::getDefaultPeopleDetector();
			return Ok(new std::vector<float>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<float>*>))
	}
	
	// getDaimlerPeopleDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:584
	Result<std::vector<float>*> cv_HOGDescriptor_getDaimlerPeopleDetector() {
		try {
			std::vector<float> ret = cv::HOGDescriptor::getDaimlerPeopleDetector();
			return Ok(new std::vector<float>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<float>*>))
	}
	
	// detectROI(cv::InputArray, const std::vector<cv::Point> &, std::vector<cv::Point> &, std::vector<double> &, double, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:642
	Result_void cv_HOGDescriptor_detectROI_const_const__InputArrayR_const_vector_Point_R_vector_Point_R_vector_double_R_double_Size_Size(const cv::HOGDescriptor* instance, const cv::_InputArray* img, const std::vector<cv::Point>* locations, std::vector<cv::Point>* foundLocations, std::vector<double>* confidences, double hitThreshold, cv::Size* winStride, cv::Size* padding) {
		try {
			instance->detectROI(*img, *locations, *foundLocations, *confidences, hitThreshold, *winStride, *padding);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScaleROI(cv::InputArray, std::vector<cv::Rect> &, std::vector<DetectionROI> &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:655
	Result_void cv_HOGDescriptor_detectMultiScaleROI_const_const__InputArrayR_vector_Rect_R_vector_DetectionROI_R_double_int(const cv::HOGDescriptor* instance, const cv::_InputArray* img, std::vector<cv::Rect>* foundLocations, std::vector<cv::DetectionROI>* locations, double hitThreshold, int groupThreshold) {
		try {
			instance->detectMultiScaleROI(*img, *foundLocations, *locations, hitThreshold, groupThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// groupRectangles(std::vector<cv::Rect> &, std::vector<double> &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:667
	Result_void cv_HOGDescriptor_groupRectangles_const_vector_Rect_R_vector_double_R_int_double(const cv::HOGDescriptor* instance, std::vector<cv::Rect>* rectList, std::vector<double>* weights, int groupThreshold, double eps) {
		try {
			instance->groupRectangles(*rectList, *weights, groupThreshold, eps);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_QRCodeDetector_delete(cv::QRCodeDetector* instance) {
		delete instance;
	}
	// QRCodeDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:673
	Result<cv::QRCodeDetector*> cv_QRCodeDetector_QRCodeDetector() {
		try {
			cv::QRCodeDetector* ret = new cv::QRCodeDetector();
			return Ok<cv::QRCodeDetector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::QRCodeDetector*>))
	}
	
	// setEpsX(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:680
	Result_void cv_QRCodeDetector_setEpsX_double(cv::QRCodeDetector* instance, double epsX) {
		try {
			instance->setEpsX(epsX);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setEpsY(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:685
	Result_void cv_QRCodeDetector_setEpsY_double(cv::QRCodeDetector* instance, double epsY) {
		try {
			instance->setEpsY(epsY);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:691
	Result<bool> cv_QRCodeDetector_detect_const_const__InputArrayR_const__OutputArrayR(const cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_OutputArray* points) {
		try {
			bool ret = instance->detect(*img, *points);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// decode(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:700
	Result<void*> cv_QRCodeDetector_decode_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_InputArray* points, const cv::_OutputArray* straight_qrcode) {
		try {
			std::string ret = instance->decode(*img, *points, *straight_qrcode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// decodeCurved(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:709
	Result<void*> cv_QRCodeDetector_decodeCurved_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_InputArray* points, const cv::_OutputArray* straight_qrcode) {
		try {
			cv::String ret = instance->decodeCurved(*img, *points, *straight_qrcode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// detectAndDecode(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:717
	Result<void*> cv_QRCodeDetector_detectAndDecode_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_OutputArray* points, const cv::_OutputArray* straight_qrcode) {
		try {
			std::string ret = instance->detectAndDecode(*img, *points, *straight_qrcode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// detectAndDecodeCurved(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:726
	Result<void*> cv_QRCodeDetector_detectAndDecodeCurved_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_OutputArray* points, const cv::_OutputArray* straight_qrcode) {
		try {
			std::string ret = instance->detectAndDecodeCurved(*img, *points, *straight_qrcode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// detectMulti(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:734
	Result<bool> cv_QRCodeDetector_detectMulti_const_const__InputArrayR_const__OutputArrayR(const cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_OutputArray* points) {
		try {
			bool ret = instance->detectMulti(*img, *points);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// decodeMulti(cv::InputArray, cv::InputArray, std::vector<std::string> &, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:743
	Result<bool> cv_QRCodeDetector_decodeMulti_const_const__InputArrayR_const__InputArrayR_vector_string_R_const__OutputArrayR(const cv::QRCodeDetector* instance, const cv::_InputArray* img, const cv::_InputArray* points, std::vector<std::string>* decoded_info, const cv::_OutputArray* straight_qrcode) {
		try {
			bool ret = instance->decodeMulti(*img, *points, *decoded_info, *straight_qrcode);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// detectAndDecodeMulti(cv::InputArray, std::vector<std::string> &, cv::OutputArray, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:756
	Result<bool> cv_QRCodeDetector_detectAndDecodeMulti_const_const__InputArrayR_vector_string_R_const__OutputArrayR_const__OutputArrayR(const cv::QRCodeDetector* instance, const cv::_InputArray* img, std::vector<std::string>* decoded_info, const cv::_OutputArray* points, const cv::_OutputArray* straight_qrcode) {
		try {
			bool ret = instance->detectAndDecodeMulti(*img, *decoded_info, *points, *straight_qrcode);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:133
	double cv_SimilarRects_getPropEps_const(const cv::SimilarRects* instance) {
		double ret = instance->eps;
		return (double)ret;
	}
	
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:133
	void cv_SimilarRects_setPropEps_double(cv::SimilarRects* instance, double val) {
		instance->eps = val;
	}
	
	void cv_SimilarRects_delete(cv::SimilarRects* instance) {
		delete instance;
	}
	// SimilarRects(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/objdetect.hpp:124
	Result<cv::SimilarRects*> cv_SimilarRects_SimilarRects_double(double _eps) {
		try {
			cv::SimilarRects* ret = new cv::SimilarRects(_eps);
			return Ok<cv::SimilarRects*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SimilarRects*>))
	}
	
}
