#include "ocvrs_common.hpp"
#include <opencv2/ml.hpp>
#include "ml_types.hpp"

extern "C" {
	// createConcentricSpheresTestSet(int, int, int, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1902
	Result_void cv_ml_createConcentricSpheresTestSet_int_int_int_const__OutputArrayR_const__OutputArrayR(int nsamples, int nfeatures, int nclasses, const cv::_OutputArray* samples, const cv::_OutputArray* responses) {
		try {
			cv::ml::createConcentricSpheresTestSet(nsamples, nfeatures, nclasses, *samples, *responses);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// randMVNormal(cv::InputArray, cv::InputArray, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1899
	Result_void cv_ml_randMVNormal_const__InputArrayR_const__InputArrayR_int_const__OutputArrayR(const cv::_InputArray* mean, const cv::_InputArray* cov, int nsamples, const cv::_OutputArray* samples) {
		try {
			cv::ml::randMVNormal(*mean, *cov, nsamples, *samples);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTrainMethod(int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1446
	Result_void cv_ml_ANN_MLP_setTrainMethod_int_double_double(cv::ml::ANN_MLP* instance, int method, double param1, double param2) {
		try {
			instance->setTrainMethod(method, param1, param2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTrainMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1449
	Result<int> cv_ml_ANN_MLP_getTrainMethod_const(const cv::ml::ANN_MLP* instance) {
		try {
			int ret = instance->getTrainMethod();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setActivationFunction(int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1457
	Result_void cv_ml_ANN_MLP_setActivationFunction_int_double_double(cv::ml::ANN_MLP* instance, int type, double param1, double param2) {
		try {
			instance->setActivationFunction(type, param1, param2);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLayerSizes(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1463
	Result_void cv_ml_ANN_MLP_setLayerSizes_const__InputArrayR(cv::ml::ANN_MLP* instance, const cv::_InputArray* _layer_sizes) {
		try {
			instance->setLayerSizes(*_layer_sizes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLayerSizes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1469
	Result<cv::Mat*> cv_ml_ANN_MLP_getLayerSizes_const(const cv::ml::ANN_MLP* instance) {
		try {
			cv::Mat ret = instance->getLayerSizes();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1476
	Result<cv::TermCriteria> cv_ml_ANN_MLP_getTermCriteria_const(const cv::ml::ANN_MLP* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1478
	Result_void cv_ml_ANN_MLP_setTermCriteria_TermCriteria(cv::ml::ANN_MLP* instance, cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackpropWeightScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1483
	Result<double> cv_ml_ANN_MLP_getBackpropWeightScale_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getBackpropWeightScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBackpropWeightScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1485
	Result_void cv_ml_ANN_MLP_setBackpropWeightScale_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setBackpropWeightScale(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackpropMomentumScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1492
	Result<double> cv_ml_ANN_MLP_getBackpropMomentumScale_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getBackpropMomentumScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBackpropMomentumScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1494
	Result_void cv_ml_ANN_MLP_setBackpropMomentumScale_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setBackpropMomentumScale(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRpropDW0() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1499
	Result<double> cv_ml_ANN_MLP_getRpropDW0_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getRpropDW0();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRpropDW0(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1501
	Result_void cv_ml_ANN_MLP_setRpropDW0_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setRpropDW0(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRpropDWPlus() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1506
	Result<double> cv_ml_ANN_MLP_getRpropDWPlus_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getRpropDWPlus();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRpropDWPlus(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1508
	Result_void cv_ml_ANN_MLP_setRpropDWPlus_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setRpropDWPlus(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRpropDWMinus() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1513
	Result<double> cv_ml_ANN_MLP_getRpropDWMinus_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getRpropDWMinus();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRpropDWMinus(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1515
	Result_void cv_ml_ANN_MLP_setRpropDWMinus_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setRpropDWMinus(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRpropDWMin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1520
	Result<double> cv_ml_ANN_MLP_getRpropDWMin_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getRpropDWMin();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRpropDWMin(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1522
	Result_void cv_ml_ANN_MLP_setRpropDWMin_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setRpropDWMin(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRpropDWMax() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1527
	Result<double> cv_ml_ANN_MLP_getRpropDWMax_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getRpropDWMax();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setRpropDWMax(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1529
	Result_void cv_ml_ANN_MLP_setRpropDWMax_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setRpropDWMax(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAnnealInitialT() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1534
	Result<double> cv_ml_ANN_MLP_getAnnealInitialT_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getAnnealInitialT();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAnnealInitialT(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1536
	Result_void cv_ml_ANN_MLP_setAnnealInitialT_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setAnnealInitialT(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAnnealFinalT() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1541
	Result<double> cv_ml_ANN_MLP_getAnnealFinalT_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getAnnealFinalT();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAnnealFinalT(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1543
	Result_void cv_ml_ANN_MLP_setAnnealFinalT_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setAnnealFinalT(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAnnealCoolingRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1548
	Result<double> cv_ml_ANN_MLP_getAnnealCoolingRatio_const(const cv::ml::ANN_MLP* instance) {
		try {
			double ret = instance->getAnnealCoolingRatio();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAnnealCoolingRatio(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1550
	Result_void cv_ml_ANN_MLP_setAnnealCoolingRatio_double(cv::ml::ANN_MLP* instance, double val) {
		try {
			instance->setAnnealCoolingRatio(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAnnealItePerStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1555
	Result<int> cv_ml_ANN_MLP_getAnnealItePerStep_const(const cv::ml::ANN_MLP* instance) {
		try {
			int ret = instance->getAnnealItePerStep();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setAnnealItePerStep(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1557
	Result_void cv_ml_ANN_MLP_setAnnealItePerStep_int(cv::ml::ANN_MLP* instance, int val) {
		try {
			instance->setAnnealItePerStep(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setAnnealEnergyRNG(const cv::RNG &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1560
	Result_void cv_ml_ANN_MLP_setAnnealEnergyRNG_const_RNGR(cv::ml::ANN_MLP* instance, const cv::RNG* rng) {
		try {
			instance->setAnnealEnergyRNG(*rng);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWeights(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1597
	Result<cv::Mat*> cv_ml_ANN_MLP_getWeights_const_int(const cv::ml::ANN_MLP* instance, int layerIdx) {
		try {
			cv::Mat ret = instance->getWeights(layerIdx);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1604
	Result<cv::Ptr<cv::ml::ANN_MLP>*> cv_ml_ANN_MLP_create() {
		try {
			cv::Ptr<cv::ml::ANN_MLP> ret = cv::ml::ANN_MLP::create();
			return Ok(new cv::Ptr<cv::ml::ANN_MLP>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::ANN_MLP>*>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1613
	Result<cv::Ptr<cv::ml::ANN_MLP>*> cv_ml_ANN_MLP_load_const_StringR(const char* filepath) {
		try {
			cv::Ptr<cv::ml::ANN_MLP> ret = cv::ml::ANN_MLP::load(std::string(filepath));
			return Ok(new cv::Ptr<cv::ml::ANN_MLP>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::ANN_MLP>*>))
	}
	
	// getBoostType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1338
	Result<int> cv_ml_Boost_getBoostType_const(const cv::ml::Boost* instance) {
		try {
			int ret = instance->getBoostType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setBoostType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1340
	Result_void cv_ml_Boost_setBoostType_int(cv::ml::Boost* instance, int val) {
		try {
			instance->setBoostType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWeakCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1345
	Result<int> cv_ml_Boost_getWeakCount_const(const cv::ml::Boost* instance) {
		try {
			int ret = instance->getWeakCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWeakCount(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1347
	Result_void cv_ml_Boost_setWeakCount_int(cv::ml::Boost* instance, int val) {
		try {
			instance->setWeakCount(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWeightTrimRate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1353
	Result<double> cv_ml_Boost_getWeightTrimRate_const(const cv::ml::Boost* instance) {
		try {
			double ret = instance->getWeightTrimRate();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setWeightTrimRate(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1355
	Result_void cv_ml_Boost_setWeightTrimRate_double(cv::ml::Boost* instance, double val) {
		try {
			instance->setWeightTrimRate(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1370
	Result<cv::Ptr<cv::ml::Boost>*> cv_ml_Boost_create() {
		try {
			cv::Ptr<cv::ml::Boost> ret = cv::ml::Boost::create();
			return Ok(new cv::Ptr<cv::ml::Boost>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::Boost>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1381
	Result<cv::Ptr<cv::ml::Boost>*> cv_ml_Boost_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::Boost> ret = cv::ml::Boost::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::Boost>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::Boost>*>))
	}
	
	// getMaxCategories() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1071
	Result<int> cv_ml_DTrees_getMaxCategories_const(const cv::ml::DTrees* instance) {
		try {
			int ret = instance->getMaxCategories();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxCategories(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1073
	Result_void cv_ml_DTrees_setMaxCategories_int(cv::ml::DTrees* instance, int val) {
		try {
			instance->setMaxCategories(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1081
	Result<int> cv_ml_DTrees_getMaxDepth_const(const cv::ml::DTrees* instance) {
		try {
			int ret = instance->getMaxDepth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxDepth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1083
	Result_void cv_ml_DTrees_setMaxDepth_int(cv::ml::DTrees* instance, int val) {
		try {
			instance->setMaxDepth(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinSampleCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1089
	Result<int> cv_ml_DTrees_getMinSampleCount_const(const cv::ml::DTrees* instance) {
		try {
			int ret = instance->getMinSampleCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinSampleCount(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1091
	Result_void cv_ml_DTrees_setMinSampleCount_int(cv::ml::DTrees* instance, int val) {
		try {
			instance->setMinSampleCount(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCVFolds() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1097
	Result<int> cv_ml_DTrees_getCVFolds_const(const cv::ml::DTrees* instance) {
		try {
			int ret = instance->getCVFolds();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCVFolds(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1099
	Result_void cv_ml_DTrees_setCVFolds_int(cv::ml::DTrees* instance, int val) {
		try {
			instance->setCVFolds(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseSurrogates() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1106
	Result<bool> cv_ml_DTrees_getUseSurrogates_const(const cv::ml::DTrees* instance) {
		try {
			bool ret = instance->getUseSurrogates();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseSurrogates(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1108
	Result_void cv_ml_DTrees_setUseSurrogates_bool(cv::ml::DTrees* instance, bool val) {
		try {
			instance->setUseSurrogates(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUse1SERule() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1114
	Result<bool> cv_ml_DTrees_getUse1SERule_const(const cv::ml::DTrees* instance) {
		try {
			bool ret = instance->getUse1SERule();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUse1SERule(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1116
	Result_void cv_ml_DTrees_setUse1SERule_bool(cv::ml::DTrees* instance, bool val) {
		try {
			instance->setUse1SERule(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTruncatePrunedTree() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1122
	Result<bool> cv_ml_DTrees_getTruncatePrunedTree_const(const cv::ml::DTrees* instance) {
		try {
			bool ret = instance->getTruncatePrunedTree();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setTruncatePrunedTree(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1124
	Result_void cv_ml_DTrees_setTruncatePrunedTree_bool(cv::ml::DTrees* instance, bool val) {
		try {
			instance->setTruncatePrunedTree(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRegressionAccuracy() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1131
	Result<float> cv_ml_DTrees_getRegressionAccuracy_const(const cv::ml::DTrees* instance) {
		try {
			float ret = instance->getRegressionAccuracy();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setRegressionAccuracy(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1133
	Result_void cv_ml_DTrees_setRegressionAccuracy_float(cv::ml::DTrees* instance, float val) {
		try {
			instance->setRegressionAccuracy(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPriors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1151
	Result<cv::Mat*> cv_ml_DTrees_getPriors_const(const cv::ml::DTrees* instance) {
		try {
			cv::Mat ret = instance->getPriors();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setPriors(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1153
	Result_void cv_ml_DTrees_setPriors_const_MatR(cv::ml::DTrees* instance, const cv::Mat* val) {
		try {
			instance->setPriors(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRoots() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1202
	Result<const std::vector<int>*> cv_ml_DTrees_getRoots_const(const cv::ml::DTrees* instance) {
		try {
			const std::vector<int> ret = instance->getRoots();
			return Ok(new const std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<int>*>))
	}
	
	// getNodes() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1207
	Result<const std::vector<cv::ml::DTrees::Node>*> cv_ml_DTrees_getNodes_const(const cv::ml::DTrees* instance) {
		try {
			const std::vector<cv::ml::DTrees::Node> ret = instance->getNodes();
			return Ok(new const std::vector<cv::ml::DTrees::Node>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::ml::DTrees::Node>*>))
	}
	
	// getSplits() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1212
	Result<const std::vector<cv::ml::DTrees::Split>*> cv_ml_DTrees_getSplits_const(const cv::ml::DTrees* instance) {
		try {
			const std::vector<cv::ml::DTrees::Split> ret = instance->getSplits();
			return Ok(new const std::vector<cv::ml::DTrees::Split>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::ml::DTrees::Split>*>))
	}
	
	// getSubsets() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1217
	Result<const std::vector<int>*> cv_ml_DTrees_getSubsets_const(const cv::ml::DTrees* instance) {
		try {
			const std::vector<int> ret = instance->getSubsets();
			return Ok(new const std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<int>*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1225
	Result<cv::Ptr<cv::ml::DTrees>*> cv_ml_DTrees_create() {
		try {
			cv::Ptr<cv::ml::DTrees> ret = cv::ml::DTrees::create();
			return Ok(new cv::Ptr<cv::ml::DTrees>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::DTrees>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1236
	Result<cv::Ptr<cv::ml::DTrees>*> cv_ml_DTrees_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::DTrees> ret = cv::ml::DTrees::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::DTrees>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::DTrees>*>))
	}
	
	// value /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1161
	double cv_ml_DTrees_Node_getPropValue_const(const cv::ml::DTrees::Node* instance) {
		double ret = instance->value;
		return (double)ret;
	}
	
	// value /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1161
	void cv_ml_DTrees_Node_setPropValue_double(cv::ml::DTrees::Node* instance, double val) {
		instance->value = val;
	}
	
	// classIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1163
	int cv_ml_DTrees_Node_getPropClassIdx_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->classIdx;
		return (int)ret;
	}
	
	// classIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1163
	void cv_ml_DTrees_Node_setPropClassIdx_int(cv::ml::DTrees::Node* instance, int val) {
		instance->classIdx = val;
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1165
	int cv_ml_DTrees_Node_getPropParent_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->parent;
		return (int)ret;
	}
	
	// parent /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1165
	void cv_ml_DTrees_Node_setPropParent_int(cv::ml::DTrees::Node* instance, int val) {
		instance->parent = val;
	}
	
	// left /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1166
	int cv_ml_DTrees_Node_getPropLeft_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->left;
		return (int)ret;
	}
	
	// left /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1166
	void cv_ml_DTrees_Node_setPropLeft_int(cv::ml::DTrees::Node* instance, int val) {
		instance->left = val;
	}
	
	// right /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1167
	int cv_ml_DTrees_Node_getPropRight_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->right;
		return (int)ret;
	}
	
	// right /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1167
	void cv_ml_DTrees_Node_setPropRight_int(cv::ml::DTrees::Node* instance, int val) {
		instance->right = val;
	}
	
	// defaultDir /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1168
	int cv_ml_DTrees_Node_getPropDefaultDir_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->defaultDir;
		return (int)ret;
	}
	
	// defaultDir /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1168
	void cv_ml_DTrees_Node_setPropDefaultDir_int(cv::ml::DTrees::Node* instance, int val) {
		instance->defaultDir = val;
	}
	
	// split /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1170
	int cv_ml_DTrees_Node_getPropSplit_const(const cv::ml::DTrees::Node* instance) {
		int ret = instance->split;
		return (int)ret;
	}
	
	// split /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1170
	void cv_ml_DTrees_Node_setPropSplit_int(cv::ml::DTrees::Node* instance, int val) {
		instance->split = val;
	}
	
	void cv_DTrees_Node_delete(cv::ml::DTrees::Node* instance) {
		delete instance;
	}
	// Node() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1160
	Result<cv::ml::DTrees::Node*> cv_ml_DTrees_Node_Node() {
		try {
			cv::ml::DTrees::Node* ret = new cv::ml::DTrees::Node();
			return Ok<cv::ml::DTrees::Node*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ml::DTrees::Node*>))
	}
	
	// varIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1179
	int cv_ml_DTrees_Split_getPropVarIdx_const(const cv::ml::DTrees::Split* instance) {
		int ret = instance->varIdx;
		return (int)ret;
	}
	
	// varIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1179
	void cv_ml_DTrees_Split_setPropVarIdx_int(cv::ml::DTrees::Split* instance, int val) {
		instance->varIdx = val;
	}
	
	// inversed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1180
	bool cv_ml_DTrees_Split_getPropInversed_const(const cv::ml::DTrees::Split* instance) {
		bool ret = instance->inversed;
		return (bool)ret;
	}
	
	// inversed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1180
	void cv_ml_DTrees_Split_setPropInversed_bool(cv::ml::DTrees::Split* instance, bool val) {
		instance->inversed = val;
	}
	
	// quality /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1182
	float cv_ml_DTrees_Split_getPropQuality_const(const cv::ml::DTrees::Split* instance) {
		float ret = instance->quality;
		return (float)ret;
	}
	
	// quality /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1182
	void cv_ml_DTrees_Split_setPropQuality_float(cv::ml::DTrees::Split* instance, float val) {
		instance->quality = val;
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1183
	int cv_ml_DTrees_Split_getPropNext_const(const cv::ml::DTrees::Split* instance) {
		int ret = instance->next;
		return (int)ret;
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1183
	void cv_ml_DTrees_Split_setPropNext_int(cv::ml::DTrees::Split* instance, int val) {
		instance->next = val;
	}
	
	// c /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1184
	float cv_ml_DTrees_Split_getPropC_const(const cv::ml::DTrees::Split* instance) {
		float ret = instance->c;
		return (float)ret;
	}
	
	// c /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1184
	void cv_ml_DTrees_Split_setPropC_float(cv::ml::DTrees::Split* instance, float val) {
		instance->c = val;
	}
	
	// subsetOfs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1191
	int cv_ml_DTrees_Split_getPropSubsetOfs_const(const cv::ml::DTrees::Split* instance) {
		int ret = instance->subsetOfs;
		return (int)ret;
	}
	
	// subsetOfs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1191
	void cv_ml_DTrees_Split_setPropSubsetOfs_int(cv::ml::DTrees::Split* instance, int val) {
		instance->subsetOfs = val;
	}
	
	void cv_DTrees_Split_delete(cv::ml::DTrees::Split* instance) {
		delete instance;
	}
	// Split() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1178
	Result<cv::ml::DTrees::Split*> cv_ml_DTrees_Split_Split() {
		try {
			cv::ml::DTrees::Split* ret = new cv::ml::DTrees::Split();
			return Ok<cv::ml::DTrees::Split*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ml::DTrees::Split*>))
	}
	
	// getClustersNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:871
	Result<int> cv_ml_EM_getClustersNumber_const(const cv::ml::EM* instance) {
		try {
			int ret = instance->getClustersNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setClustersNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:873
	Result_void cv_ml_EM_setClustersNumber_int(cv::ml::EM* instance, int val) {
		try {
			instance->setClustersNumber(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCovarianceMatrixType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:878
	Result<int> cv_ml_EM_getCovarianceMatrixType_const(const cv::ml::EM* instance) {
		try {
			int ret = instance->getCovarianceMatrixType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCovarianceMatrixType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:880
	Result_void cv_ml_EM_setCovarianceMatrixType_int(cv::ml::EM* instance, int val) {
		try {
			instance->setCovarianceMatrixType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:887
	Result<cv::TermCriteria> cv_ml_EM_getTermCriteria_const(const cv::ml::EM* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:889
	Result_void cv_ml_EM_setTermCriteria_const_TermCriteriaR(cv::ml::EM* instance, const cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:895
	Result<cv::Mat*> cv_ml_EM_getWeights_const(const cv::ml::EM* instance) {
		try {
			cv::Mat ret = instance->getWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getMeans() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:901
	Result<cv::Mat*> cv_ml_EM_getMeans_const(const cv::ml::EM* instance) {
		try {
			cv::Mat ret = instance->getMeans();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCovs(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:907
	Result_void cv_ml_EM_getCovs_const_vector_Mat_R(const cv::ml::EM* instance, std::vector<cv::Mat>* covs) {
		try {
			instance->getCovs(*covs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:916
	Result<float> cv_ml_EM_predict_const_const__InputArrayR_const__OutputArrayR_int(const cv::ml::EM* instance, const cv::_InputArray* samples, const cv::_OutputArray* results, int flags) {
		try {
			float ret = instance->predict(*samples, *results, flags);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// predict2(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:930
	Result<cv::Vec2d> cv_ml_EM_predict2_const_const__InputArrayR_const__OutputArrayR(const cv::ml::EM* instance, const cv::_InputArray* sample, const cv::_OutputArray* probs) {
		try {
			cv::Vec2d ret = instance->predict2(*sample, *probs);
			return Ok<cv::Vec2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2d>))
	}
	
	// trainEM(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:960
	Result<bool> cv_ml_EM_trainEM_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::ml::EM* instance, const cv::_InputArray* samples, const cv::_OutputArray* logLikelihoods, const cv::_OutputArray* labels, const cv::_OutputArray* probs) {
		try {
			bool ret = instance->trainEM(*samples, *logLikelihoods, *labels, *probs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// trainE(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:992
	Result<bool> cv_ml_EM_trainE_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::ml::EM* instance, const cv::_InputArray* samples, const cv::_InputArray* means0, const cv::_InputArray* covs0, const cv::_InputArray* weights0, const cv::_OutputArray* logLikelihoods, const cv::_OutputArray* labels, const cv::_OutputArray* probs) {
		try {
			bool ret = instance->trainE(*samples, *means0, *covs0, *weights0, *logLikelihoods, *labels, *probs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// trainM(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1017
	Result<bool> cv_ml_EM_trainM_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::ml::EM* instance, const cv::_InputArray* samples, const cv::_InputArray* probs0, const cv::_OutputArray* logLikelihoods, const cv::_OutputArray* labels, const cv::_OutputArray* probs) {
		try {
			bool ret = instance->trainM(*samples, *probs0, *logLikelihoods, *labels, *probs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1026
	Result<cv::Ptr<cv::ml::EM>*> cv_ml_EM_create() {
		try {
			cv::Ptr<cv::ml::EM> ret = cv::ml::EM::create();
			return Ok(new cv::Ptr<cv::ml::EM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::EM>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1037
	Result<cv::Ptr<cv::ml::EM>*> cv_ml_EM_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::EM> ret = cv::ml::EM::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::EM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::EM>*>))
	}
	
	// getDefaultK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:442
	Result<int> cv_ml_KNearest_getDefaultK_const(const cv::ml::KNearest* instance) {
		try {
			int ret = instance->getDefaultK();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDefaultK(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:444
	Result_void cv_ml_KNearest_setDefaultK_int(cv::ml::KNearest* instance, int val) {
		try {
			instance->setDefaultK(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIsClassifier() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:448
	Result<bool> cv_ml_KNearest_getIsClassifier_const(const cv::ml::KNearest* instance) {
		try {
			bool ret = instance->getIsClassifier();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setIsClassifier(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:450
	Result_void cv_ml_KNearest_setIsClassifier_bool(cv::ml::KNearest* instance, bool val) {
		try {
			instance->setIsClassifier(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEmax() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:454
	Result<int> cv_ml_KNearest_getEmax_const(const cv::ml::KNearest* instance) {
		try {
			int ret = instance->getEmax();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setEmax(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:456
	Result_void cv_ml_KNearest_setEmax_int(cv::ml::KNearest* instance, int val) {
		try {
			instance->setEmax(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAlgorithmType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:460
	Result<int> cv_ml_KNearest_getAlgorithmType_const(const cv::ml::KNearest* instance) {
		try {
			int ret = instance->getAlgorithmType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setAlgorithmType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:462
	Result_void cv_ml_KNearest_setAlgorithmType_int(cv::ml::KNearest* instance, int val) {
		try {
			instance->setAlgorithmType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findNearest(cv::InputArray, int, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:490
	Result<float> cv_ml_KNearest_findNearest_const_const__InputArrayR_int_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::ml::KNearest* instance, const cv::_InputArray* samples, int k, const cv::_OutputArray* results, const cv::_OutputArray* neighborResponses, const cv::_OutputArray* dist) {
		try {
			float ret = instance->findNearest(*samples, k, *results, *neighborResponses, *dist);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:507
	Result<cv::Ptr<cv::ml::KNearest>*> cv_ml_KNearest_create() {
		try {
			cv::Ptr<cv::ml::KNearest> ret = cv::ml::KNearest::create();
			return Ok(new cv::Ptr<cv::ml::KNearest>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::KNearest>*>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:515
	Result<cv::Ptr<cv::ml::KNearest>*> cv_ml_KNearest_load_const_StringR(const char* filepath) {
		try {
			cv::Ptr<cv::ml::KNearest> ret = cv::ml::KNearest::load(std::string(filepath));
			return Ok(new cv::Ptr<cv::ml::KNearest>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::KNearest>*>))
	}
	
	// getLearningRate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1635
	Result<double> cv_ml_LogisticRegression_getLearningRate_const(const cv::ml::LogisticRegression* instance) {
		try {
			double ret = instance->getLearningRate();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLearningRate(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1637
	Result_void cv_ml_LogisticRegression_setLearningRate_double(cv::ml::LogisticRegression* instance, double val) {
		try {
			instance->setLearningRate(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getIterations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1641
	Result<int> cv_ml_LogisticRegression_getIterations_const(const cv::ml::LogisticRegression* instance) {
		try {
			int ret = instance->getIterations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setIterations(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1643
	Result_void cv_ml_LogisticRegression_setIterations_int(cv::ml::LogisticRegression* instance, int val) {
		try {
			instance->setIterations(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRegularization() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1647
	Result<int> cv_ml_LogisticRegression_getRegularization_const(const cv::ml::LogisticRegression* instance) {
		try {
			int ret = instance->getRegularization();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRegularization(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1649
	Result_void cv_ml_LogisticRegression_setRegularization_int(cv::ml::LogisticRegression* instance, int val) {
		try {
			instance->setRegularization(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTrainMethod() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1653
	Result<int> cv_ml_LogisticRegression_getTrainMethod_const(const cv::ml::LogisticRegression* instance) {
		try {
			int ret = instance->getTrainMethod();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setTrainMethod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1655
	Result_void cv_ml_LogisticRegression_setTrainMethod_int(cv::ml::LogisticRegression* instance, int val) {
		try {
			instance->setTrainMethod(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMiniBatchSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1661
	Result<int> cv_ml_LogisticRegression_getMiniBatchSize_const(const cv::ml::LogisticRegression* instance) {
		try {
			int ret = instance->getMiniBatchSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMiniBatchSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1663
	Result_void cv_ml_LogisticRegression_setMiniBatchSize_int(cv::ml::LogisticRegression* instance, int val) {
		try {
			instance->setMiniBatchSize(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1667
	Result<cv::TermCriteria> cv_ml_LogisticRegression_getTermCriteria_const(const cv::ml::LogisticRegression* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1669
	Result_void cv_ml_LogisticRegression_setTermCriteria_TermCriteria(cv::ml::LogisticRegression* instance, cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1691
	Result<float> cv_ml_LogisticRegression_predict_const_const__InputArrayR_const__OutputArrayR_int(const cv::ml::LogisticRegression* instance, const cv::_InputArray* samples, const cv::_OutputArray* results, int flags) {
		try {
			float ret = instance->predict(*samples, *results, flags);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// get_learnt_thetas() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1698
	Result<cv::Mat*> cv_ml_LogisticRegression_get_learnt_thetas_const(const cv::ml::LogisticRegression* instance) {
		try {
			cv::Mat ret = instance->get_learnt_thetas();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1704
	Result<cv::Ptr<cv::ml::LogisticRegression>*> cv_ml_LogisticRegression_create() {
		try {
			cv::Ptr<cv::ml::LogisticRegression> ret = cv::ml::LogisticRegression::create();
			return Ok(new cv::Ptr<cv::ml::LogisticRegression>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::LogisticRegression>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1715
	Result<cv::Ptr<cv::ml::LogisticRegression>*> cv_ml_LogisticRegression_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::LogisticRegression> ret = cv::ml::LogisticRegression::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::LogisticRegression>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::LogisticRegression>*>))
	}
	
	// predictProb(cv::InputArray, cv::OutputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:409
	Result<float> cv_ml_NormalBayesClassifier_predictProb_const_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int(const cv::ml::NormalBayesClassifier* instance, const cv::_InputArray* inputs, const cv::_OutputArray* outputs, const cv::_OutputArray* outputProbs, int flags) {
		try {
			float ret = instance->predictProb(*inputs, *outputs, *outputProbs, flags);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:414
	Result<cv::Ptr<cv::ml::NormalBayesClassifier>*> cv_ml_NormalBayesClassifier_create() {
		try {
			cv::Ptr<cv::ml::NormalBayesClassifier> ret = cv::ml::NormalBayesClassifier::create();
			return Ok(new cv::Ptr<cv::ml::NormalBayesClassifier>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::NormalBayesClassifier>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:425
	Result<cv::Ptr<cv::ml::NormalBayesClassifier>*> cv_ml_NormalBayesClassifier_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::NormalBayesClassifier> ret = cv::ml::NormalBayesClassifier::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::NormalBayesClassifier>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::NormalBayesClassifier>*>))
	}
	
	// minVal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:115
	double cv_ml_ParamGrid_getPropMinVal_const(const cv::ml::ParamGrid* instance) {
		double ret = instance->minVal;
		return (double)ret;
	}
	
	// minVal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:115
	void cv_ml_ParamGrid_setPropMinVal_double(cv::ml::ParamGrid* instance, double val) {
		instance->minVal = val;
	}
	
	// maxVal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:116
	double cv_ml_ParamGrid_getPropMaxVal_const(const cv::ml::ParamGrid* instance) {
		double ret = instance->maxVal;
		return (double)ret;
	}
	
	// maxVal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:116
	void cv_ml_ParamGrid_setPropMaxVal_double(cv::ml::ParamGrid* instance, double val) {
		instance->maxVal = val;
	}
	
	// logStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:125
	double cv_ml_ParamGrid_getPropLogStep_const(const cv::ml::ParamGrid* instance) {
		double ret = instance->logStep;
		return (double)ret;
	}
	
	// logStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:125
	void cv_ml_ParamGrid_setPropLogStep_double(cv::ml::ParamGrid* instance, double val) {
		instance->logStep = val;
	}
	
	void cv_ParamGrid_delete(cv::ml::ParamGrid* instance) {
		delete instance;
	}
	// ParamGrid() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:111
	Result<cv::ml::ParamGrid*> cv_ml_ParamGrid_ParamGrid() {
		try {
			cv::ml::ParamGrid* ret = new cv::ml::ParamGrid();
			return Ok<cv::ml::ParamGrid*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ml::ParamGrid*>))
	}
	
	// ParamGrid(double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:113
	Result<cv::ml::ParamGrid*> cv_ml_ParamGrid_ParamGrid_double_double_double(double _minVal, double _maxVal, double _logStep) {
		try {
			cv::ml::ParamGrid* ret = new cv::ml::ParamGrid(_minVal, _maxVal, _logStep);
			return Ok<cv::ml::ParamGrid*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ml::ParamGrid*>))
	}
	
	// create(double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:133
	Result<cv::Ptr<cv::ml::ParamGrid>*> cv_ml_ParamGrid_create_double_double_double(double minVal, double maxVal, double logstep) {
		try {
			cv::Ptr<cv::ml::ParamGrid> ret = cv::ml::ParamGrid::create(minVal, maxVal, logstep);
			return Ok(new cv::Ptr<cv::ml::ParamGrid>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::ParamGrid>*>))
	}
	
	// getCalculateVarImportance() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1254
	Result<bool> cv_ml_RTrees_getCalculateVarImportance_const(const cv::ml::RTrees* instance) {
		try {
			bool ret = instance->getCalculateVarImportance();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setCalculateVarImportance(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1256
	Result_void cv_ml_RTrees_setCalculateVarImportance_bool(cv::ml::RTrees* instance, bool val) {
		try {
			instance->setCalculateVarImportance(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getActiveVarCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1263
	Result<int> cv_ml_RTrees_getActiveVarCount_const(const cv::ml::RTrees* instance) {
		try {
			int ret = instance->getActiveVarCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setActiveVarCount(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1265
	Result_void cv_ml_RTrees_setActiveVarCount_int(cv::ml::RTrees* instance, int val) {
		try {
			instance->setActiveVarCount(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1275
	Result<cv::TermCriteria> cv_ml_RTrees_getTermCriteria_const(const cv::ml::RTrees* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1277
	Result_void cv_ml_RTrees_setTermCriteria_const_TermCriteriaR(cv::ml::RTrees* instance, const cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarImportance() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1284
	Result<cv::Mat*> cv_ml_RTrees_getVarImportance_const(const cv::ml::RTrees* instance) {
		try {
			cv::Mat ret = instance->getVarImportance();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getVotes(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1295
	Result_void cv_ml_RTrees_getVotes_const_const__InputArrayR_const__OutputArrayR_int(const cv::ml::RTrees* instance, const cv::_InputArray* samples, const cv::_OutputArray* results, int flags) {
		try {
			instance->getVotes(*samples, *results, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOOBError() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1301
	Result<double> cv_ml_RTrees_getOOBError_const(const cv::ml::RTrees* instance) {
		try {
			double ret = instance->getOOBError();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1310
	Result<cv::Ptr<cv::ml::RTrees>*> cv_ml_RTrees_create() {
		try {
			cv::Ptr<cv::ml::RTrees> ret = cv::ml::RTrees::create();
			return Ok(new cv::Ptr<cv::ml::RTrees>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::RTrees>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1321
	Result<cv::Ptr<cv::ml::RTrees>*> cv_ml_RTrees_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::RTrees> ret = cv::ml::RTrees::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::RTrees>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::RTrees>*>))
	}
	
	// getType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:540
	Result<int> cv_ml_SVM_getType_const(const cv::ml::SVM* instance) {
		try {
			int ret = instance->getType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:542
	Result_void cv_ml_SVM_setType_int(cv::ml::SVM* instance, int val) {
		try {
			instance->setType(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGamma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:547
	Result<double> cv_ml_SVM_getGamma_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getGamma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setGamma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:549
	Result_void cv_ml_SVM_setGamma_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setGamma(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCoef0() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:554
	Result<double> cv_ml_SVM_getCoef0_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getCoef0();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setCoef0(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:556
	Result_void cv_ml_SVM_setCoef0_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setCoef0(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDegree() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:561
	Result<double> cv_ml_SVM_getDegree_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getDegree();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setDegree(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:563
	Result_void cv_ml_SVM_setDegree_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setDegree(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getC() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:568
	Result<double> cv_ml_SVM_getC_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getC();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setC(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:570
	Result_void cv_ml_SVM_setC_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setC(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNu() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:575
	Result<double> cv_ml_SVM_getNu_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getNu();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNu(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:577
	Result_void cv_ml_SVM_setNu_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setNu(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getP() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:582
	Result<double> cv_ml_SVM_getP_const(const cv::ml::SVM* instance) {
		try {
			double ret = instance->getP();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setP(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:584
	Result_void cv_ml_SVM_setP_double(cv::ml::SVM* instance, double val) {
		try {
			instance->setP(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getClassWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:592
	Result<cv::Mat*> cv_ml_SVM_getClassWeights_const(const cv::ml::SVM* instance) {
		try {
			cv::Mat ret = instance->getClassWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setClassWeights(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:594
	Result_void cv_ml_SVM_setClassWeights_const_MatR(cv::ml::SVM* instance, const cv::Mat* val) {
		try {
			instance->setClassWeights(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:601
	Result<cv::TermCriteria> cv_ml_SVM_getTermCriteria_const(const cv::ml::SVM* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:603
	Result_void cv_ml_SVM_setTermCriteria_const_TermCriteriaR(cv::ml::SVM* instance, const cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getKernelType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:607
	Result<int> cv_ml_SVM_getKernelType_const(const cv::ml::SVM* instance) {
		try {
			int ret = instance->getKernelType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setKernel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:611
	Result_void cv_ml_SVM_setKernel_int(cv::ml::SVM* instance, int kernelType) {
		try {
			instance->setKernel(kernelType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCustomKernel(const Ptr<cv::ml::SVM::Kernel> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:615
	Result_void cv_ml_SVM_setCustomKernel_const_Ptr_Kernel_R(cv::ml::SVM* instance, const cv::Ptr<cv::ml::SVM::Kernel>* _kernel) {
		try {
			instance->setCustomKernel(*_kernel);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// trainAuto(const Ptr<cv::ml::TrainData> &, int, cv::ml::ParamGrid, cv::ml::ParamGrid, cv::ml::ParamGrid, cv::ml::ParamGrid, cv::ml::ParamGrid, cv::ml::ParamGrid, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:712
	Result<bool> cv_ml_SVM_trainAuto_const_Ptr_TrainData_R_int_ParamGrid_ParamGrid_ParamGrid_ParamGrid_ParamGrid_ParamGrid_bool(cv::ml::SVM* instance, const cv::Ptr<cv::ml::TrainData>* data, int kFold, cv::ml::ParamGrid* Cgrid, cv::ml::ParamGrid* gammaGrid, cv::ml::ParamGrid* pGrid, cv::ml::ParamGrid* nuGrid, cv::ml::ParamGrid* coeffGrid, cv::ml::ParamGrid* degreeGrid, bool balanced) {
		try {
			bool ret = instance->trainAuto(*data, kFold, *Cgrid, *gammaGrid, *pGrid, *nuGrid, *coeffGrid, *degreeGrid, balanced);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// trainAuto(cv::InputArray, int, cv::InputArray, int, Ptr<cv::ml::ParamGrid>, Ptr<cv::ml::ParamGrid>, Ptr<cv::ml::ParamGrid>, Ptr<cv::ml::ParamGrid>, Ptr<cv::ml::ParamGrid>, Ptr<cv::ml::ParamGrid>, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:749
	Result<bool> cv_ml_SVM_trainAuto_const__InputArrayR_int_const__InputArrayR_int_Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__Ptr_ParamGrid__bool(cv::ml::SVM* instance, const cv::_InputArray* samples, int layout, const cv::_InputArray* responses, int kFold, cv::Ptr<cv::ml::ParamGrid>* Cgrid, cv::Ptr<cv::ml::ParamGrid>* gammaGrid, cv::Ptr<cv::ml::ParamGrid>* pGrid, cv::Ptr<cv::ml::ParamGrid>* nuGrid, cv::Ptr<cv::ml::ParamGrid>* coeffGrid, cv::Ptr<cv::ml::ParamGrid>* degreeGrid, bool balanced) {
		try {
			bool ret = instance->trainAuto(*samples, layout, *responses, kFold, *Cgrid, *gammaGrid, *pGrid, *nuGrid, *coeffGrid, *degreeGrid, balanced);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getSupportVectors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:766
	Result<cv::Mat*> cv_ml_SVM_getSupportVectors_const(const cv::ml::SVM* instance) {
		try {
			cv::Mat ret = instance->getSupportVectors();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getUncompressedSupportVectors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:774
	Result<cv::Mat*> cv_ml_SVM_getUncompressedSupportVectors_const(const cv::ml::SVM* instance) {
		try {
			cv::Mat ret = instance->getUncompressedSupportVectors();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getDecisionFunction(int, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:791
	Result<double> cv_ml_SVM_getDecisionFunction_const_int_const__OutputArrayR_const__OutputArrayR(const cv::ml::SVM* instance, int i, const cv::_OutputArray* alpha, const cv::_OutputArray* svidx) {
		try {
			double ret = instance->getDecisionFunction(i, *alpha, *svidx);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getDefaultGrid(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:801
	Result<cv::ml::ParamGrid*> cv_ml_SVM_getDefaultGrid_int(int param_id) {
		try {
			cv::ml::ParamGrid ret = cv::ml::SVM::getDefaultGrid(param_id);
			return Ok(new cv::ml::ParamGrid(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ml::ParamGrid*>))
	}
	
	// getDefaultGridPtr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:811
	Result<cv::Ptr<cv::ml::ParamGrid>*> cv_ml_SVM_getDefaultGridPtr_int(int param_id) {
		try {
			cv::Ptr<cv::ml::ParamGrid> ret = cv::ml::SVM::getDefaultGridPtr(param_id);
			return Ok(new cv::Ptr<cv::ml::ParamGrid>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::ParamGrid>*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:816
	Result<cv::Ptr<cv::ml::SVM>*> cv_ml_SVM_create() {
		try {
			cv::Ptr<cv::ml::SVM> ret = cv::ml::SVM::create();
			return Ok(new cv::Ptr<cv::ml::SVM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::SVM>*>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:825
	Result<cv::Ptr<cv::ml::SVM>*> cv_ml_SVM_load_const_StringR(const char* filepath) {
		try {
			cv::Ptr<cv::ml::SVM> ret = cv::ml::SVM::load(std::string(filepath));
			return Ok(new cv::Ptr<cv::ml::SVM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::SVM>*>))
	}
	
	// getType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:533
	Result<int> cv_ml_SVM_Kernel_getType_const(const cv::ml::SVM::Kernel* instance) {
		try {
			int ret = instance->getType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// calc(int, int, const float *, const float *, float *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:534
	Result_void cv_ml_SVM_Kernel_calc_int_int_const_floatX_const_floatX_floatX(cv::ml::SVM::Kernel* instance, int vcount, int n, const float* vecs, const float* another, float* results) {
		try {
			instance->calc(vcount, n, vecs, another, results);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1818
	Result<cv::Mat*> cv_ml_SVMSGD_getWeights(cv::ml::SVMSGD* instance) {
		try {
			cv::Mat ret = instance->getWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getShift() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1823
	Result<float> cv_ml_SVMSGD_getShift(cv::ml::SVMSGD* instance) {
		try {
			float ret = instance->getShift();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1829
	Result<cv::Ptr<cv::ml::SVMSGD>*> cv_ml_SVMSGD_create() {
		try {
			cv::Ptr<cv::ml::SVMSGD> ret = cv::ml::SVMSGD::create();
			return Ok(new cv::Ptr<cv::ml::SVMSGD>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::SVMSGD>*>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1840
	Result<cv::Ptr<cv::ml::SVMSGD>*> cv_ml_SVMSGD_load_const_StringR_const_StringR(const char* filepath, const char* nodeName) {
		try {
			cv::Ptr<cv::ml::SVMSGD> ret = cv::ml::SVMSGD::load(std::string(filepath), std::string(nodeName));
			return Ok(new cv::Ptr<cv::ml::SVMSGD>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::SVMSGD>*>))
	}
	
	// setOptimalParameters(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1846
	Result_void cv_ml_SVMSGD_setOptimalParameters_int_int(cv::ml::SVMSGD* instance, int svmsgdType, int marginType) {
		try {
			instance->setOptimalParameters(svmsgdType, marginType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSvmsgdType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1850
	Result<int> cv_ml_SVMSGD_getSvmsgdType_const(const cv::ml::SVMSGD* instance) {
		try {
			int ret = instance->getSvmsgdType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSvmsgdType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1852
	Result_void cv_ml_SVMSGD_setSvmsgdType_int(cv::ml::SVMSGD* instance, int svmsgdType) {
		try {
			instance->setSvmsgdType(svmsgdType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMarginType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1856
	Result<int> cv_ml_SVMSGD_getMarginType_const(const cv::ml::SVMSGD* instance) {
		try {
			int ret = instance->getMarginType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMarginType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1858
	Result_void cv_ml_SVMSGD_setMarginType_int(cv::ml::SVMSGD* instance, int marginType) {
		try {
			instance->setMarginType(marginType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMarginRegularization() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1862
	Result<float> cv_ml_SVMSGD_getMarginRegularization_const(const cv::ml::SVMSGD* instance) {
		try {
			float ret = instance->getMarginRegularization();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMarginRegularization(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1864
	Result_void cv_ml_SVMSGD_setMarginRegularization_float(cv::ml::SVMSGD* instance, float marginRegularization) {
		try {
			instance->setMarginRegularization(marginRegularization);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getInitialStepSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1868
	Result<float> cv_ml_SVMSGD_getInitialStepSize_const(const cv::ml::SVMSGD* instance) {
		try {
			float ret = instance->getInitialStepSize();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setInitialStepSize(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1870
	Result_void cv_ml_SVMSGD_setInitialStepSize_float(cv::ml::SVMSGD* instance, float InitialStepSize) {
		try {
			instance->setInitialStepSize(InitialStepSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getStepDecreasingPower() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1874
	Result<float> cv_ml_SVMSGD_getStepDecreasingPower_const(const cv::ml::SVMSGD* instance) {
		try {
			float ret = instance->getStepDecreasingPower();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setStepDecreasingPower(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1876
	Result_void cv_ml_SVMSGD_setStepDecreasingPower_float(cv::ml::SVMSGD* instance, float stepDecreasingPower) {
		try {
			instance->setStepDecreasingPower(stepDecreasingPower);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1882
	Result<cv::TermCriteria> cv_ml_SVMSGD_getTermCriteria_const(const cv::ml::SVMSGD* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:1884
	Result_void cv_ml_SVMSGD_setTermCriteria_const_TermCriteriaR(cv::ml::SVMSGD* instance, const cv::TermCriteria* val) {
		try {
			instance->setTermCriteria(*val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVarCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:330
	Result<int> cv_ml_StatModel_getVarCount_const(const cv::ml::StatModel* instance) {
		try {
			int ret = instance->getVarCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:332
	Result<bool> cv_ml_StatModel_empty_const(const cv::ml::StatModel* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isTrained() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:335
	Result<bool> cv_ml_StatModel_isTrained_const(const cv::ml::StatModel* instance) {
		try {
			bool ret = instance->isTrained();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isClassifier() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:337
	Result<bool> cv_ml_StatModel_isClassifier_const(const cv::ml::StatModel* instance) {
		try {
			bool ret = instance->isClassifier();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// train(const Ptr<cv::ml::TrainData> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:346
	Result<bool> cv_ml_StatModel_train_const_Ptr_TrainData_R_int(cv::ml::StatModel* instance, const cv::Ptr<cv::ml::TrainData>* trainData, int flags) {
		try {
			bool ret = instance->train(*trainData, flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// train(cv::InputArray, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:354
	Result<bool> cv_ml_StatModel_train_const__InputArrayR_int_const__InputArrayR(cv::ml::StatModel* instance, const cv::_InputArray* samples, int layout, const cv::_InputArray* responses) {
		try {
			bool ret = instance->train(*samples, layout, *responses);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// calcError(const Ptr<cv::ml::TrainData> &, bool, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:369
	Result<float> cv_ml_StatModel_calcError_const_const_Ptr_TrainData_R_bool_const__OutputArrayR(const cv::ml::StatModel* instance, const cv::Ptr<cv::ml::TrainData>* data, bool test, const cv::_OutputArray* resp) {
		try {
			float ret = instance->calcError(*data, test, *resp);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// predict(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:377
	Result<float> cv_ml_StatModel_predict_const_const__InputArrayR_const__OutputArrayR_int(const cv::ml::StatModel* instance, const cv::_InputArray* samples, const cv::_OutputArray* results, int flags) {
		try {
			float ret = instance->predict(*samples, *results, flags);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// missingValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:148
	Result<float> cv_ml_TrainData_missingValue() {
		try {
			float ret = cv::ml::TrainData::missingValue();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getLayout() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:151
	Result<int> cv_ml_TrainData_getLayout_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getLayout();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNTrainSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:152
	Result<int> cv_ml_TrainData_getNTrainSamples_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getNTrainSamples();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNTestSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:153
	Result<int> cv_ml_TrainData_getNTestSamples_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getNTestSamples();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:154
	Result<int> cv_ml_TrainData_getNSamples_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getNSamples();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNVars() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:155
	Result<int> cv_ml_TrainData_getNVars_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getNVars();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNAllVars() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:156
	Result<int> cv_ml_TrainData_getNAllVars_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getNAllVars();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getSample(cv::InputArray, int, float *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:158
	Result_void cv_ml_TrainData_getSample_const_const__InputArrayR_int_floatX(const cv::ml::TrainData* instance, const cv::_InputArray* varIdx, int sidx, float* buf) {
		try {
			instance->getSample(*varIdx, sidx, buf);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:159
	Result<cv::Mat*> cv_ml_TrainData_getSamples_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getSamples();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getMissing() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:160
	Result<cv::Mat*> cv_ml_TrainData_getMissing_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getMissing();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTrainSamples(int, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:174
	Result<cv::Mat*> cv_ml_TrainData_getTrainSamples_const_int_bool_bool(const cv::ml::TrainData* instance, int layout, bool compressSamples, bool compressVars) {
		try {
			cv::Mat ret = instance->getTrainSamples(layout, compressSamples, compressVars);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTrainResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:183
	Result<cv::Mat*> cv_ml_TrainData_getTrainResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTrainResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTrainNormCatResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:191
	Result<cv::Mat*> cv_ml_TrainData_getTrainNormCatResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTrainNormCatResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTestResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:192
	Result<cv::Mat*> cv_ml_TrainData_getTestResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTestResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTestNormCatResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:193
	Result<cv::Mat*> cv_ml_TrainData_getTestNormCatResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTestNormCatResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:194
	Result<cv::Mat*> cv_ml_TrainData_getResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getNormCatResponses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:195
	Result<cv::Mat*> cv_ml_TrainData_getNormCatResponses_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getNormCatResponses();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getSampleWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:196
	Result<cv::Mat*> cv_ml_TrainData_getSampleWeights_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getSampleWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTrainSampleWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:197
	Result<cv::Mat*> cv_ml_TrainData_getTrainSampleWeights_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTrainSampleWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTestSampleWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:198
	Result<cv::Mat*> cv_ml_TrainData_getTestSampleWeights_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTestSampleWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getVarIdx() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:199
	Result<cv::Mat*> cv_ml_TrainData_getVarIdx_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getVarIdx();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getVarType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:200
	Result<cv::Mat*> cv_ml_TrainData_getVarType_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getVarType();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getVarSymbolFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:201
	Result<cv::Mat*> cv_ml_TrainData_getVarSymbolFlags_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getVarSymbolFlags();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getResponseType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:202
	Result<int> cv_ml_TrainData_getResponseType_const(const cv::ml::TrainData* instance) {
		try {
			int ret = instance->getResponseType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getTrainSampleIdx() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:203
	Result<cv::Mat*> cv_ml_TrainData_getTrainSampleIdx_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTrainSampleIdx();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTestSampleIdx() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:204
	Result<cv::Mat*> cv_ml_TrainData_getTestSampleIdx_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTestSampleIdx();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getValues(int, cv::InputArray, float *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:205
	Result_void cv_ml_TrainData_getValues_const_int_const__InputArrayR_floatX(const cv::ml::TrainData* instance, int vi, const cv::_InputArray* sidx, float* values) {
		try {
			instance->getValues(vi, *sidx, values);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNormCatValues(int, cv::InputArray, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:206
	Result_void cv_ml_TrainData_getNormCatValues_const_int_const__InputArrayR_intX(const cv::ml::TrainData* instance, int vi, const cv::_InputArray* sidx, int* values) {
		try {
			instance->getNormCatValues(vi, *sidx, values);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultSubstValues() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:207
	Result<cv::Mat*> cv_ml_TrainData_getDefaultSubstValues_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getDefaultSubstValues();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCatCount(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:209
	Result<int> cv_ml_TrainData_getCatCount_const_int(const cv::ml::TrainData* instance, int vi) {
		try {
			int ret = instance->getCatCount(vi);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getClassLabels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:215
	Result<cv::Mat*> cv_ml_TrainData_getClassLabels_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getClassLabels();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCatOfs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:217
	Result<cv::Mat*> cv_ml_TrainData_getCatOfs_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getCatOfs();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCatMap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:218
	Result<cv::Mat*> cv_ml_TrainData_getCatMap_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getCatMap();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// setTrainTestSplit(int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:223
	Result_void cv_ml_TrainData_setTrainTestSplit_int_bool(cv::ml::TrainData* instance, int count, bool shuffle) {
		try {
			instance->setTrainTestSplit(count, shuffle);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTrainTestSplitRatio(double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:233
	Result_void cv_ml_TrainData_setTrainTestSplitRatio_double_bool(cv::ml::TrainData* instance, double ratio, bool shuffle) {
		try {
			instance->setTrainTestSplitRatio(ratio, shuffle);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// shuffleTrainTest() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:234
	Result_void cv_ml_TrainData_shuffleTrainTest(cv::ml::TrainData* instance) {
		try {
			instance->shuffleTrainTest();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTestSamples() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:237
	Result<cv::Mat*> cv_ml_TrainData_getTestSamples_const(const cv::ml::TrainData* instance) {
		try {
			cv::Mat ret = instance->getTestSamples();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getNames(std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:240
	Result_void cv_ml_TrainData_getNames_const_vector_String_R(const cv::ml::TrainData* instance, std::vector<cv::String>* names) {
		try {
			instance->getNames(*names);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSubVector(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:246
	Result<cv::Mat*> cv_ml_TrainData_getSubVector_const_MatR_const_MatR(const cv::Mat* vec, const cv::Mat* idx) {
		try {
			cv::Mat ret = cv::ml::TrainData::getSubVector(*vec, *idx);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getSubMatrix(const cv::Mat &, const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:253
	Result<cv::Mat*> cv_ml_TrainData_getSubMatrix_const_MatR_const_MatR_int(const cv::Mat* matrix, const cv::Mat* idx, int layout) {
		try {
			cv::Mat ret = cv::ml::TrainData::getSubMatrix(*matrix, *idx, layout);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// loadFromCSV(const cv::String &, int, int, int, const cv::String &, char, char) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:284
	Result<cv::Ptr<cv::ml::TrainData>*> cv_ml_TrainData_loadFromCSV_const_StringR_int_int_int_const_StringR_char_char(const char* filename, int headerLineCount, int responseStartIdx, int responseEndIdx, const char* varTypeSpec, char delimiter, char missch) {
		try {
			cv::Ptr<cv::ml::TrainData> ret = cv::ml::TrainData::loadFromCSV(std::string(filename), headerLineCount, responseStartIdx, responseEndIdx, std::string(varTypeSpec), delimiter, missch);
			return Ok(new cv::Ptr<cv::ml::TrainData>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::TrainData>*>))
	}
	
	// create(cv::InputArray, int, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/ml.hpp:311
	Result<cv::Ptr<cv::ml::TrainData>*> cv_ml_TrainData_create_const__InputArrayR_int_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* samples, int layout, const cv::_InputArray* responses, const cv::_InputArray* varIdx, const cv::_InputArray* sampleIdx, const cv::_InputArray* sampleWeights, const cv::_InputArray* varType) {
		try {
			cv::Ptr<cv::ml::TrainData> ret = cv::ml::TrainData::create(*samples, layout, *responses, *varIdx, *sampleIdx, *sampleWeights, *varType);
			return Ok(new cv::Ptr<cv::ml::TrainData>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ml::TrainData>*>))
	}
	
}
