#include "ocvrs_common.hpp"
#include <opencv2/mcc.hpp>
#include "mcc_types.hpp"

extern "C" {
	void cv_ColorCorrectionModel_delete(cv::ccm::ColorCorrectionModel* instance) {
		delete instance;
	}
	// ColorCorrectionModel(const cv::Mat &, cv::ccm::CONST_COLOR) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:374
	Result<cv::ccm::ColorCorrectionModel*> cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_CONST_COLOR(const cv::Mat* src, cv::ccm::CONST_COLOR constcolor) {
		try {
			cv::ccm::ColorCorrectionModel* ret = new cv::ccm::ColorCorrectionModel(*src, constcolor);
			return Ok<cv::ccm::ColorCorrectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ccm::ColorCorrectionModel*>))
	}
	
	// ColorCorrectionModel(const cv::Mat &, cv::Mat, cv::ccm::COLOR_SPACE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:383
	Result<cv::ccm::ColorCorrectionModel*> cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_Mat_COLOR_SPACE(const cv::Mat* src, cv::Mat* colors, cv::ccm::COLOR_SPACE ref_cs) {
		try {
			cv::ccm::ColorCorrectionModel* ret = new cv::ccm::ColorCorrectionModel(*src, *colors, ref_cs);
			return Ok<cv::ccm::ColorCorrectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ccm::ColorCorrectionModel*>))
	}
	
	// ColorCorrectionModel(const cv::Mat &, cv::Mat, cv::ccm::COLOR_SPACE, cv::Mat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:393
	Result<cv::ccm::ColorCorrectionModel*> cv_ccm_ColorCorrectionModel_ColorCorrectionModel_const_MatR_Mat_COLOR_SPACE_Mat(const cv::Mat* src, cv::Mat* colors, cv::ccm::COLOR_SPACE ref_cs, cv::Mat* colored) {
		try {
			cv::ccm::ColorCorrectionModel* ret = new cv::ccm::ColorCorrectionModel(*src, *colors, ref_cs, *colored);
			return Ok<cv::ccm::ColorCorrectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ccm::ColorCorrectionModel*>))
	}
	
	// setColorSpace(cv::ccm::COLOR_SPACE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:409
	Result_void cv_ccm_ColorCorrectionModel_setColorSpace_COLOR_SPACE(cv::ccm::ColorCorrectionModel* instance, cv::ccm::COLOR_SPACE cs) {
		try {
			instance->setColorSpace(cs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCCM_TYPE(cv::ccm::CCM_TYPE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:415
	Result_void cv_ccm_ColorCorrectionModel_setCCM_TYPE_CCM_TYPE(cv::ccm::ColorCorrectionModel* instance, cv::ccm::CCM_TYPE ccm_type) {
		try {
			instance->setCCM_TYPE(ccm_type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setDistance(cv::ccm::DISTANCE_TYPE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:421
	Result_void cv_ccm_ColorCorrectionModel_setDistance_DISTANCE_TYPE(cv::ccm::ColorCorrectionModel* instance, cv::ccm::DISTANCE_TYPE distance) {
		try {
			instance->setDistance(distance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLinear(cv::ccm::LINEAR_TYPE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:427
	Result_void cv_ccm_ColorCorrectionModel_setLinear_LINEAR_TYPE(cv::ccm::ColorCorrectionModel* instance, cv::ccm::LINEAR_TYPE linear_type) {
		try {
			instance->setLinear(linear_type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLinearGamma(const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:436
	Result_void cv_ccm_ColorCorrectionModel_setLinearGamma_const_doubleR(cv::ccm::ColorCorrectionModel* instance, const double* gamma) {
		try {
			instance->setLinearGamma(*gamma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLinearDegree(const int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:449
	Result_void cv_ccm_ColorCorrectionModel_setLinearDegree_const_intR(cv::ccm::ColorCorrectionModel* instance, const int* deg) {
		try {
			instance->setLinearDegree(*deg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSaturatedThreshold(const double &, const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:459
	Result_void cv_ccm_ColorCorrectionModel_setSaturatedThreshold_const_doubleR_const_doubleR(cv::ccm::ColorCorrectionModel* instance, const double* lower, const double* upper) {
		try {
			instance->setSaturatedThreshold(*lower, *upper);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWeightsList(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:465
	Result_void cv_ccm_ColorCorrectionModel_setWeightsList_const_MatR(cv::ccm::ColorCorrectionModel* instance, const cv::Mat* weights_list) {
		try {
			instance->setWeightsList(*weights_list);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWeightCoeff(const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:471
	Result_void cv_ccm_ColorCorrectionModel_setWeightCoeff_const_doubleR(cv::ccm::ColorCorrectionModel* instance, const double* weights_coeff) {
		try {
			instance->setWeightCoeff(*weights_coeff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInitialMethod(cv::ccm::INITIAL_METHOD_TYPE) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:477
	Result_void cv_ccm_ColorCorrectionModel_setInitialMethod_INITIAL_METHOD_TYPE(cv::ccm::ColorCorrectionModel* instance, cv::ccm::INITIAL_METHOD_TYPE initial_method_type) {
		try {
			instance->setInitialMethod(initial_method_type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxCount(const int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:484
	Result_void cv_ccm_ColorCorrectionModel_setMaxCount_const_intR(cv::ccm::ColorCorrectionModel* instance, const int* max_count) {
		try {
			instance->setMaxCount(*max_count);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setEpsilon(const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:491
	Result_void cv_ccm_ColorCorrectionModel_setEpsilon_const_doubleR(cv::ccm::ColorCorrectionModel* instance, const double* epsilon) {
		try {
			instance->setEpsilon(*epsilon);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:494
	Result_void cv_ccm_ColorCorrectionModel_run(cv::ccm::ColorCorrectionModel* instance) {
		try {
			instance->run();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCCM() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:496
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_getCCM_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			cv::Mat ret = instance->getCCM();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getLoss() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:497
	Result<double> cv_ccm_ColorCorrectionModel_getLoss_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			double ret = instance->getLoss();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// get_src_rgbl() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:498
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_get_src_rgbl_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			cv::Mat ret = instance->get_src_rgbl();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// get_dst_rgbl() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:499
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_get_dst_rgbl_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			cv::Mat ret = instance->get_dst_rgbl();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getMask() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:500
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_getMask_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			cv::Mat ret = instance->getMask();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getWeights() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:501
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_getWeights_const(const cv::ccm::ColorCorrectionModel* instance) {
		try {
			cv::Mat ret = instance->getWeights();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// infer(const cv::Mat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/ccm.hpp:508
	Result<cv::Mat*> cv_ccm_ColorCorrectionModel_infer_const_MatR_bool(cv::ccm::ColorCorrectionModel* instance, const cv::Mat* img, bool islinear) {
		try {
			cv::Mat ret = instance->infer(*img, islinear);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:73
	Result<cv::Ptr<cv::mcc::CChecker>*> cv_mcc_CChecker_create() {
		try {
			cv::Ptr<cv::mcc::CChecker> ret = cv::mcc::CChecker::create();
			return Ok(new cv::Ptr<cv::mcc::CChecker>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::mcc::CChecker>*>))
	}
	
	// setTarget(cv::mcc::TYPECHART) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:83
	Result_void cv_mcc_CChecker_setTarget_TYPECHART(cv::mcc::CChecker* instance, cv::mcc::TYPECHART _target) {
		try {
			instance->setTarget(_target);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBox(std::vector<Point2f>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:84
	Result_void cv_mcc_CChecker_setBox_vector_Point2f_(cv::mcc::CChecker* instance, std::vector<cv::Point2f>* _box) {
		try {
			instance->setBox(*_box);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setChartsRGB(cv::Mat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:85
	Result_void cv_mcc_CChecker_setChartsRGB_Mat(cv::mcc::CChecker* instance, cv::Mat* _chartsRGB) {
		try {
			instance->setChartsRGB(*_chartsRGB);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setChartsYCbCr(cv::Mat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:86
	Result_void cv_mcc_CChecker_setChartsYCbCr_Mat(cv::mcc::CChecker* instance, cv::Mat* _chartsYCbCr) {
		try {
			instance->setChartsYCbCr(*_chartsYCbCr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCost(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:87
	Result_void cv_mcc_CChecker_setCost_float(cv::mcc::CChecker* instance, float _cost) {
		try {
			instance->setCost(_cost);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCenter(cv::Point2f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:88
	Result_void cv_mcc_CChecker_setCenter_Point2f(cv::mcc::CChecker* instance, cv::Point2f* _center) {
		try {
			instance->setCenter(*_center);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTarget() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:90
	Result<cv::mcc::TYPECHART> cv_mcc_CChecker_getTarget(cv::mcc::CChecker* instance) {
		try {
			cv::mcc::TYPECHART ret = instance->getTarget();
			return Ok<cv::mcc::TYPECHART>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::mcc::TYPECHART>))
	}
	
	// getBox() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:91
	Result<std::vector<cv::Point2f>*> cv_mcc_CChecker_getBox(cv::mcc::CChecker* instance) {
		try {
			std::vector<cv::Point2f> ret = instance->getBox();
			return Ok(new std::vector<cv::Point2f>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Point2f>*>))
	}
	
	// getChartsRGB() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:92
	Result<cv::Mat*> cv_mcc_CChecker_getChartsRGB(cv::mcc::CChecker* instance) {
		try {
			cv::Mat ret = instance->getChartsRGB();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getChartsYCbCr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:93
	Result<cv::Mat*> cv_mcc_CChecker_getChartsYCbCr(cv::mcc::CChecker* instance) {
		try {
			cv::Mat ret = instance->getChartsYCbCr();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getCost() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:94
	Result<float> cv_mcc_CChecker_getCost(cv::mcc::CChecker* instance) {
		try {
			float ret = instance->getCost();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getCenter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:95
	Result<cv::Point2f> cv_mcc_CChecker_getCenter(cv::mcc::CChecker* instance) {
		try {
			cv::Point2f ret = instance->getCenter();
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// setNet(dnn::Net) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:144
	Result<bool> cv_mcc_CCheckerDetector_setNet_Net(cv::mcc::CCheckerDetector* instance, cv::dnn::Net* net) {
		try {
			bool ret = instance->setNet(*net);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// process(cv::InputArray, const cv::mcc::TYPECHART, const std::vector<Rect> &, const int, bool, const Ptr<cv::mcc::DetectorParameters> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:167
	Result<bool> cv_mcc_CCheckerDetector_process_const__InputArrayR_const_TYPECHART_const_vector_Rect_R_const_int_bool_const_Ptr_DetectorParameters_R(cv::mcc::CCheckerDetector* instance, const cv::_InputArray* image, const cv::mcc::TYPECHART chartType, const std::vector<cv::Rect>* regionsOfInterest, const int nc, bool useNet, const cv::Ptr<cv::mcc::DetectorParameters>* params) {
		try {
			bool ret = instance->process(*image, chartType, *regionsOfInterest, nc, useNet, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// process(cv::InputArray, const cv::mcc::TYPECHART, const int, bool, const Ptr<cv::mcc::DetectorParameters> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:195
	Result<bool> cv_mcc_CCheckerDetector_process_const__InputArrayR_const_TYPECHART_const_int_bool_const_Ptr_DetectorParameters_R(cv::mcc::CCheckerDetector* instance, const cv::_InputArray* image, const cv::mcc::TYPECHART chartType, const int nc, bool useNet, const cv::Ptr<cv::mcc::DetectorParameters>* params) {
		try {
			bool ret = instance->process(*image, chartType, nc, useNet, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getBestColorChecker() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:204
	Result<cv::Ptr<cv::mcc::CChecker>*> cv_mcc_CCheckerDetector_getBestColorChecker(cv::mcc::CCheckerDetector* instance) {
		try {
			cv::Ptr<cv::mcc::CChecker> ret = instance->getBestColorChecker();
			return Ok(new cv::Ptr<cv::mcc::CChecker>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::mcc::CChecker>*>))
	}
	
	// getListColorChecker() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:209
	Result<std::vector<cv::Ptr<cv::mcc::CChecker>>*> cv_mcc_CCheckerDetector_getListColorChecker(cv::mcc::CCheckerDetector* instance) {
		try {
			std::vector<cv::Ptr<cv::mcc::CChecker>> ret = instance->getListColorChecker();
			return Ok(new std::vector<cv::Ptr<cv::mcc::CChecker>>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Ptr<cv::mcc::CChecker>>*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:214
	Result<cv::Ptr<cv::mcc::CCheckerDetector>*> cv_mcc_CCheckerDetector_create() {
		try {
			cv::Ptr<cv::mcc::CCheckerDetector> ret = cv::mcc::CCheckerDetector::create();
			return Ok(new cv::Ptr<cv::mcc::CCheckerDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::mcc::CCheckerDetector>*>))
	}
	
	// draw(cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:121
	Result_void cv_mcc_CCheckerDraw_draw_const__InputOutputArrayR(cv::mcc::CCheckerDraw* instance, const cv::_InputOutputArray* img) {
		try {
			instance->draw(*img);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(Ptr<cv::mcc::CChecker>, cv::Scalar, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_model.hpp:130
	Result<cv::Ptr<cv::mcc::CCheckerDraw>*> cv_mcc_CCheckerDraw_create_Ptr_CChecker__Scalar_int(cv::Ptr<cv::mcc::CChecker>* pChecker, cv::Scalar* color, int thickness) {
		try {
			cv::Ptr<cv::mcc::CCheckerDraw> ret = cv::mcc::CCheckerDraw::create(*pChecker, *color, thickness);
			return Ok(new cv::Ptr<cv::mcc::CCheckerDraw>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::mcc::CCheckerDraw>*>))
	}
	
	// adaptiveThreshWinSizeMin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:106
	int cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeMin_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeMin;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeMin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:106
	void cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeMin_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeMin = val;
	}
	
	// adaptiveThreshWinSizeMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:107
	int cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeMax_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeMax;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:107
	void cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeMax_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeMax = val;
	}
	
	// adaptiveThreshWinSizeStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:108
	int cv_mcc_DetectorParameters_getPropAdaptiveThreshWinSizeStep_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeStep;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:108
	void cv_mcc_DetectorParameters_setPropAdaptiveThreshWinSizeStep_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeStep = val;
	}
	
	// adaptiveThreshConstant /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:109
	double cv_mcc_DetectorParameters_getPropAdaptiveThreshConstant_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->adaptiveThreshConstant;
		return (double)ret;
	}
	
	// adaptiveThreshConstant /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:109
	void cv_mcc_DetectorParameters_setPropAdaptiveThreshConstant_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->adaptiveThreshConstant = val;
	}
	
	// minContoursAreaRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:110
	double cv_mcc_DetectorParameters_getPropMinContoursAreaRate_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->minContoursAreaRate;
		return (double)ret;
	}
	
	// minContoursAreaRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:110
	void cv_mcc_DetectorParameters_setPropMinContoursAreaRate_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->minContoursAreaRate = val;
	}
	
	// minContoursArea /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:111
	double cv_mcc_DetectorParameters_getPropMinContoursArea_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->minContoursArea;
		return (double)ret;
	}
	
	// minContoursArea /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:111
	void cv_mcc_DetectorParameters_setPropMinContoursArea_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->minContoursArea = val;
	}
	
	// confidenceThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:112
	double cv_mcc_DetectorParameters_getPropConfidenceThreshold_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->confidenceThreshold;
		return (double)ret;
	}
	
	// confidenceThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:112
	void cv_mcc_DetectorParameters_setPropConfidenceThreshold_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->confidenceThreshold = val;
	}
	
	// minContourSolidity /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:113
	double cv_mcc_DetectorParameters_getPropMinContourSolidity_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->minContourSolidity;
		return (double)ret;
	}
	
	// minContourSolidity /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:113
	void cv_mcc_DetectorParameters_setPropMinContourSolidity_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->minContourSolidity = val;
	}
	
	// findCandidatesApproxPolyDPEpsMultiplier /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:114
	double cv_mcc_DetectorParameters_getPropFindCandidatesApproxPolyDPEpsMultiplier_const(const cv::mcc::DetectorParameters* instance) {
		double ret = instance->findCandidatesApproxPolyDPEpsMultiplier;
		return (double)ret;
	}
	
	// findCandidatesApproxPolyDPEpsMultiplier /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:114
	void cv_mcc_DetectorParameters_setPropFindCandidatesApproxPolyDPEpsMultiplier_double(cv::mcc::DetectorParameters* instance, double val) {
		instance->findCandidatesApproxPolyDPEpsMultiplier = val;
	}
	
	// borderWidth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:115
	int cv_mcc_DetectorParameters_getPropBorderWidth_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->borderWidth;
		return (int)ret;
	}
	
	// borderWidth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:115
	void cv_mcc_DetectorParameters_setPropBorderWidth_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->borderWidth = val;
	}
	
	// B0factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:116
	float cv_mcc_DetectorParameters_getPropB0factor_const(const cv::mcc::DetectorParameters* instance) {
		float ret = instance->B0factor;
		return (float)ret;
	}
	
	// B0factor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:116
	void cv_mcc_DetectorParameters_setPropB0factor_float(cv::mcc::DetectorParameters* instance, float val) {
		instance->B0factor = val;
	}
	
	// maxError /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:117
	float cv_mcc_DetectorParameters_getPropMaxError_const(const cv::mcc::DetectorParameters* instance) {
		float ret = instance->maxError;
		return (float)ret;
	}
	
	// maxError /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:117
	void cv_mcc_DetectorParameters_setPropMaxError_float(cv::mcc::DetectorParameters* instance, float val) {
		instance->maxError = val;
	}
	
	// minContourPointsAllowed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:118
	int cv_mcc_DetectorParameters_getPropMinContourPointsAllowed_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->minContourPointsAllowed;
		return (int)ret;
	}
	
	// minContourPointsAllowed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:118
	void cv_mcc_DetectorParameters_setPropMinContourPointsAllowed_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->minContourPointsAllowed = val;
	}
	
	// minContourLengthAllowed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:119
	int cv_mcc_DetectorParameters_getPropMinContourLengthAllowed_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->minContourLengthAllowed;
		return (int)ret;
	}
	
	// minContourLengthAllowed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:119
	void cv_mcc_DetectorParameters_setPropMinContourLengthAllowed_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->minContourLengthAllowed = val;
	}
	
	// minInterContourDistance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:120
	int cv_mcc_DetectorParameters_getPropMinInterContourDistance_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->minInterContourDistance;
		return (int)ret;
	}
	
	// minInterContourDistance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:120
	void cv_mcc_DetectorParameters_setPropMinInterContourDistance_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->minInterContourDistance = val;
	}
	
	// minInterCheckerDistance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:121
	int cv_mcc_DetectorParameters_getPropMinInterCheckerDistance_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->minInterCheckerDistance;
		return (int)ret;
	}
	
	// minInterCheckerDistance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:121
	void cv_mcc_DetectorParameters_setPropMinInterCheckerDistance_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->minInterCheckerDistance = val;
	}
	
	// minImageSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:122
	int cv_mcc_DetectorParameters_getPropMinImageSize_const(const cv::mcc::DetectorParameters* instance) {
		int ret = instance->minImageSize;
		return (int)ret;
	}
	
	// minImageSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:122
	void cv_mcc_DetectorParameters_setPropMinImageSize_int(cv::mcc::DetectorParameters* instance, int val) {
		instance->minImageSize = val;
	}
	
	// minGroupSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:123
	unsigned int cv_mcc_DetectorParameters_getPropMinGroupSize_const(const cv::mcc::DetectorParameters* instance) {
		unsigned int ret = instance->minGroupSize;
		return (unsigned int)ret;
	}
	
	// minGroupSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:123
	void cv_mcc_DetectorParameters_setPropMinGroupSize_unsigned_int(cv::mcc::DetectorParameters* instance, unsigned int val) {
		instance->minGroupSize = val;
	}
	
	void cv_MCC_DetectorParameters_delete(cv::mcc::DetectorParameters* instance) {
		delete instance;
	}
	// DetectorParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:102
	Result<cv::mcc::DetectorParameters*> cv_mcc_DetectorParameters_DetectorParameters() {
		try {
			cv::mcc::DetectorParameters* ret = new cv::mcc::DetectorParameters();
			return Ok<cv::mcc::DetectorParameters*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::mcc::DetectorParameters*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/mcc/checker_detector.hpp:104
	Result<cv::Ptr<cv::mcc::DetectorParameters>*> cv_mcc_DetectorParameters_create() {
		try {
			cv::Ptr<cv::mcc::DetectorParameters> ret = cv::mcc::DetectorParameters::create();
			return Ok(new cv::Ptr<cv::mcc::DetectorParameters>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::mcc::DetectorParameters>*>))
	}
	
}
