#include "ocvrs_common.hpp"
#include <opencv2/line_descriptor.hpp>
#include "line_descriptor_types.hpp"

extern "C" {
	// drawKeylines(const cv::Mat &, const std::vector<KeyLine> &, cv::Mat &, const cv::Scalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1401
	Result_void cv_line_descriptor_drawKeylines_const_MatR_const_vector_KeyLine_R_MatR_const_ScalarR_int(const cv::Mat* image, const std::vector<cv::line_descriptor::KeyLine>* keylines, cv::Mat* outImage, const cv::Scalar* color, int flags) {
		try {
			cv::line_descriptor::drawKeylines(*image, *keylines, *outImage, *color, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawLineMatches(const cv::Mat &, const std::vector<KeyLine> &, const cv::Mat &, const std::vector<KeyLine> &, const std::vector<DMatch> &, cv::Mat &, const cv::Scalar &, const cv::Scalar &, const std::vector<char> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1388
	Result_void cv_line_descriptor_drawLineMatches_const_MatR_const_vector_KeyLine_R_const_MatR_const_vector_KeyLine_R_const_vector_DMatch_R_MatR_const_ScalarR_const_ScalarR_const_vector_char_R_int(const cv::Mat* img1, const std::vector<cv::line_descriptor::KeyLine>* keylines1, const cv::Mat* img2, const std::vector<cv::line_descriptor::KeyLine>* keylines2, const std::vector<cv::DMatch>* matches1to2, cv::Mat* outImg, const cv::Scalar* matchColor, const cv::Scalar* singleLineColor, const std::vector<char>* matchesMask, int flags) {
		try {
			cv::line_descriptor::drawLineMatches(*img1, *keylines1, *img2, *keylines2, *matches1to2, *outImg, *matchColor, *singleLineColor, *matchesMask, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_BinaryDescriptor_to_Algorithm(cv::line_descriptor::BinaryDescriptor* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_BinaryDescriptor_delete(cv::line_descriptor::BinaryDescriptor* instance) {
		delete instance;
	}
	// BinaryDescriptor(const BinaryDescriptor::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:221
	Result<cv::line_descriptor::BinaryDescriptor*> cv_line_descriptor_BinaryDescriptor_BinaryDescriptor_const_ParamsR(const cv::line_descriptor::BinaryDescriptor::Params* parameters) {
		try {
			cv::line_descriptor::BinaryDescriptor* ret = new cv::line_descriptor::BinaryDescriptor(*parameters);
			return Ok<cv::line_descriptor::BinaryDescriptor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::BinaryDescriptor*>))
	}
	
	// createBinaryDescriptor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:226
	Result<cv::Ptr<cv::line_descriptor::BinaryDescriptor>*> cv_line_descriptor_BinaryDescriptor_createBinaryDescriptor() {
		try {
			cv::Ptr<cv::line_descriptor::BinaryDescriptor> ret = cv::line_descriptor::BinaryDescriptor::createBinaryDescriptor();
			return Ok(new cv::Ptr<cv::line_descriptor::BinaryDescriptor>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::line_descriptor::BinaryDescriptor>*>))
	}
	
	// createBinaryDescriptor(cv::line_descriptor::BinaryDescriptor::Params) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:227
	Result<cv::Ptr<cv::line_descriptor::BinaryDescriptor>*> cv_line_descriptor_BinaryDescriptor_createBinaryDescriptor_Params(cv::line_descriptor::BinaryDescriptor::Params* parameters) {
		try {
			cv::Ptr<cv::line_descriptor::BinaryDescriptor> ret = cv::line_descriptor::BinaryDescriptor::createBinaryDescriptor(*parameters);
			return Ok(new cv::Ptr<cv::line_descriptor::BinaryDescriptor>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::line_descriptor::BinaryDescriptor>*>))
	}
	
	// getNumOfOctaves() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:234
	Result<int> cv_line_descriptor_BinaryDescriptor_getNumOfOctaves(cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->getNumOfOctaves();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumOfOctaves(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:238
	Result_void cv_line_descriptor_BinaryDescriptor_setNumOfOctaves_int(cv::line_descriptor::BinaryDescriptor* instance, int octaves) {
		try {
			instance->setNumOfOctaves(octaves);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWidthOfBand() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:241
	Result<int> cv_line_descriptor_BinaryDescriptor_getWidthOfBand(cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->getWidthOfBand();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWidthOfBand(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:245
	Result_void cv_line_descriptor_BinaryDescriptor_setWidthOfBand_int(cv::line_descriptor::BinaryDescriptor* instance, int width) {
		try {
			instance->setWidthOfBand(width);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getReductionRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:248
	Result<int> cv_line_descriptor_BinaryDescriptor_getReductionRatio(cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->getReductionRatio();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setReductionRatio(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:252
	Result_void cv_line_descriptor_BinaryDescriptor_setReductionRatio_int(cv::line_descriptor::BinaryDescriptor* instance, int rRatio) {
		try {
			instance->setReductionRatio(rRatio);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:258
	Result_void cv_line_descriptor_BinaryDescriptor_read_const_FileNodeR(cv::line_descriptor::BinaryDescriptor* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:264
	Result_void cv_line_descriptor_BinaryDescriptor_write_const_FileStorageR(const cv::line_descriptor::BinaryDescriptor* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(const cv::Mat &, std::vector<KeyLine> &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:272
	Result_void cv_line_descriptor_BinaryDescriptor_detect_const_MatR_vector_KeyLine_R_const_MatR(cv::line_descriptor::BinaryDescriptor* instance, const cv::Mat* image, std::vector<cv::line_descriptor::KeyLine>* keypoints, const cv::Mat* mask) {
		try {
			instance->detect(*image, *keypoints, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(const std::vector<Mat> &, std::vector<std::vector<KeyLine>> &, const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:280
	Result_void cv_line_descriptor_BinaryDescriptor_detect_const_const_vector_Mat_R_vector_vector_KeyLine__R_const_vector_Mat_R(const cv::line_descriptor::BinaryDescriptor* instance, const std::vector<cv::Mat>* images, std::vector<std::vector<cv::line_descriptor::KeyLine>>* keylines, const std::vector<cv::Mat>* masks) {
		try {
			instance->detect(*images, *keylines, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(const cv::Mat &, std::vector<KeyLine> &, cv::Mat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:290
	Result_void cv_line_descriptor_BinaryDescriptor_compute_const_const_MatR_vector_KeyLine_R_MatR_bool(const cv::line_descriptor::BinaryDescriptor* instance, const cv::Mat* image, std::vector<cv::line_descriptor::KeyLine>* keylines, cv::Mat* descriptors, bool returnFloatDescr) {
		try {
			instance->compute(*image, *keylines, *descriptors, returnFloatDescr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(const std::vector<Mat> &, std::vector<std::vector<KeyLine>> &, std::vector<Mat> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:299
	Result_void cv_line_descriptor_BinaryDescriptor_compute_const_const_vector_Mat_R_vector_vector_KeyLine__R_vector_Mat_R_bool(const cv::line_descriptor::BinaryDescriptor* instance, const std::vector<cv::Mat>* images, std::vector<std::vector<cv::line_descriptor::KeyLine>>* keylines, std::vector<cv::Mat>* descriptors, bool returnFloatDescr) {
		try {
			instance->compute(*images, *keylines, *descriptors, returnFloatDescr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// descriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:304
	Result<int> cv_line_descriptor_BinaryDescriptor_descriptorSize_const(const cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->descriptorSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// descriptorType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:308
	Result<int> cv_line_descriptor_BinaryDescriptor_descriptorType_const(const cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->descriptorType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// defaultNorm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:312
	Result<int> cv_line_descriptor_BinaryDescriptor_defaultNorm_const(const cv::line_descriptor::BinaryDescriptor* instance) {
		try {
			int ret = instance->defaultNorm();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// numOfOctave_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:195
	int cv_line_descriptor_BinaryDescriptor_Params_getPropNumOfOctave__const(const cv::line_descriptor::BinaryDescriptor::Params* instance) {
		int ret = instance->numOfOctave_;
		return (int)ret;
	}
	
	// numOfOctave_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:195
	void cv_line_descriptor_BinaryDescriptor_Params_setPropNumOfOctave__int(cv::line_descriptor::BinaryDescriptor::Params* instance, int val) {
		instance->numOfOctave_ = val;
	}
	
	// widthOfBand_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:199
	int cv_line_descriptor_BinaryDescriptor_Params_getPropWidthOfBand__const(const cv::line_descriptor::BinaryDescriptor::Params* instance) {
		int ret = instance->widthOfBand_;
		return (int)ret;
	}
	
	// widthOfBand_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:199
	void cv_line_descriptor_BinaryDescriptor_Params_setPropWidthOfBand__int(cv::line_descriptor::BinaryDescriptor::Params* instance, int val) {
		instance->widthOfBand_ = val;
	}
	
	// reductionRatio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:202
	int cv_line_descriptor_BinaryDescriptor_Params_getPropReductionRatio_const(const cv::line_descriptor::BinaryDescriptor::Params* instance) {
		int ret = instance->reductionRatio;
		return (int)ret;
	}
	
	// reductionRatio /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:202
	void cv_line_descriptor_BinaryDescriptor_Params_setPropReductionRatio_int(cv::line_descriptor::BinaryDescriptor::Params* instance, int val) {
		instance->reductionRatio = val;
	}
	
	// ksize_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:204
	int cv_line_descriptor_BinaryDescriptor_Params_getPropKsize__const(const cv::line_descriptor::BinaryDescriptor::Params* instance) {
		int ret = instance->ksize_;
		return (int)ret;
	}
	
	// ksize_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:204
	void cv_line_descriptor_BinaryDescriptor_Params_setPropKsize__int(cv::line_descriptor::BinaryDescriptor::Params* instance, int val) {
		instance->ksize_ = val;
	}
	
	void cv_BinaryDescriptor_Params_delete(cv::line_descriptor::BinaryDescriptor::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:191
	Result<cv::line_descriptor::BinaryDescriptor::Params*> cv_line_descriptor_BinaryDescriptor_Params_Params() {
		try {
			cv::line_descriptor::BinaryDescriptor::Params* ret = new cv::line_descriptor::BinaryDescriptor::Params();
			return Ok<cv::line_descriptor::BinaryDescriptor::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::BinaryDescriptor::Params*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:207
	Result_void cv_line_descriptor_BinaryDescriptor_Params_read_const_FileNodeR(cv::line_descriptor::BinaryDescriptor::Params* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:210
	Result_void cv_line_descriptor_BinaryDescriptor_Params_write_const_FileStorageR(const cv::line_descriptor::BinaryDescriptor::Params* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_BinaryDescriptorMatcher_to_Algorithm(cv::line_descriptor::BinaryDescriptorMatcher* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_BinaryDescriptorMatcher_delete(cv::line_descriptor::BinaryDescriptorMatcher* instance) {
		delete instance;
	}
	// match(const cv::Mat &, const cv::Mat &, std::vector<DMatch> &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1031
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_match_const_const_MatR_const_MatR_vector_DMatch_R_const_MatR(const cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, const cv::Mat* trainDescriptors, std::vector<cv::DMatch>* matches, const cv::Mat* mask) {
		try {
			instance->match(*queryDescriptors, *trainDescriptors, *matches, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(const cv::Mat &, std::vector<DMatch> &, const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1040
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_match_const_MatR_vector_DMatch_R_const_vector_Mat_R(cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, std::vector<cv::DMatch>* matches, const std::vector<cv::Mat>* masks) {
		try {
			instance->match(*queryDescriptors, *matches, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(const cv::Mat &, const cv::Mat &, std::vector<std::vector<DMatch>> &, int, const cv::Mat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1053
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_knnMatch_const_const_MatR_const_MatR_vector_vector_DMatch__R_int_const_MatR_bool(const cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, const cv::Mat* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const cv::Mat* mask, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *trainDescriptors, *matches, k, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(const cv::Mat &, std::vector<std::vector<DMatch>> &, int, const std::vector<Mat> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1066
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_knnMatch_const_MatR_vector_vector_DMatch__R_int_const_vector_Mat_R_bool(cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const std::vector<cv::Mat>* masks, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *matches, k, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(const cv::Mat &, const cv::Mat &, std::vector<std::vector<DMatch>> &, float, const cv::Mat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1080
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_radiusMatch_const_const_MatR_const_MatR_vector_vector_DMatch__R_float_const_MatR_bool(const cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, const cv::Mat* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const cv::Mat* mask, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *trainDescriptors, *matches, maxDistance, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(const cv::Mat &, std::vector<std::vector<DMatch>> &, float, const std::vector<Mat> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1093
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_radiusMatch_const_MatR_vector_vector_DMatch__R_float_const_vector_Mat_R_bool(cv::line_descriptor::BinaryDescriptorMatcher* instance, const cv::Mat* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const std::vector<cv::Mat>* masks, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *matches, maxDistance, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// add(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1104
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_add_const_vector_Mat_R(cv::line_descriptor::BinaryDescriptorMatcher* instance, const std::vector<cv::Mat>* descriptors) {
		try {
			instance->add(*descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// train() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1111
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_train(cv::line_descriptor::BinaryDescriptorMatcher* instance) {
		try {
			instance->train();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createBinaryDescriptorMatcher() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1115
	Result<cv::Ptr<cv::line_descriptor::BinaryDescriptorMatcher>*> cv_line_descriptor_BinaryDescriptorMatcher_createBinaryDescriptorMatcher() {
		try {
			cv::Ptr<cv::line_descriptor::BinaryDescriptorMatcher> ret = cv::line_descriptor::BinaryDescriptorMatcher::createBinaryDescriptorMatcher();
			return Ok(new cv::Ptr<cv::line_descriptor::BinaryDescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::line_descriptor::BinaryDescriptorMatcher>*>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1119
	Result_void cv_line_descriptor_BinaryDescriptorMatcher_clear(cv::line_descriptor::BinaryDescriptorMatcher* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// BinaryDescriptorMatcher() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:1125
	Result<cv::line_descriptor::BinaryDescriptorMatcher*> cv_line_descriptor_BinaryDescriptorMatcher_BinaryDescriptorMatcher() {
		try {
			cv::line_descriptor::BinaryDescriptorMatcher* ret = new cv::line_descriptor::BinaryDescriptorMatcher();
			return Ok<cv::line_descriptor::BinaryDescriptorMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::BinaryDescriptorMatcher*>))
	}
	
	// getStartPoint() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:146
	Result<cv::Point2f> cv_line_descriptor_KeyLine_getStartPoint_const(const cv::line_descriptor::KeyLine instance) {
		try {
			cv::Point2f ret = instance.getStartPoint();
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// getEndPoint() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:152
	Result<cv::Point2f> cv_line_descriptor_KeyLine_getEndPoint_const(const cv::line_descriptor::KeyLine instance) {
		try {
			cv::Point2f ret = instance.getEndPoint();
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// getStartPointInOctave() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:158
	Result<cv::Point2f> cv_line_descriptor_KeyLine_getStartPointInOctave_const(const cv::line_descriptor::KeyLine instance) {
		try {
			cv::Point2f ret = instance.getStartPointInOctave();
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// getEndPointInOctave() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:164
	Result<cv::Point2f> cv_line_descriptor_KeyLine_getEndPointInOctave_const(const cv::line_descriptor::KeyLine instance) {
		try {
			cv::Point2f ret = instance.getEndPointInOctave();
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// KeyLine() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:170
	Result<cv::line_descriptor::KeyLine> cv_line_descriptor_KeyLine_KeyLine() {
		try {
			cv::line_descriptor::KeyLine ret;
			return Ok<cv::line_descriptor::KeyLine>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::KeyLine>))
	}
	
	cv::Algorithm* cv_LSDDetector_to_Algorithm(cv::line_descriptor::LSDDetector* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_LSDDetector_delete(cv::line_descriptor::LSDDetector* instance) {
		delete instance;
	}
	// LSDDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:929
	Result<cv::line_descriptor::LSDDetector*> cv_line_descriptor_LSDDetector_LSDDetector() {
		try {
			cv::line_descriptor::LSDDetector* ret = new cv::line_descriptor::LSDDetector();
			return Ok<cv::line_descriptor::LSDDetector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::LSDDetector*>))
	}
	
	// LSDDetector(cv::line_descriptor::LSDParam) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:934
	Result<cv::line_descriptor::LSDDetector*> cv_line_descriptor_LSDDetector_LSDDetector_LSDParam(cv::line_descriptor::LSDParam* _params) {
		try {
			cv::line_descriptor::LSDDetector* ret = new cv::line_descriptor::LSDDetector(*_params);
			return Ok<cv::line_descriptor::LSDDetector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::LSDDetector*>))
	}
	
	// createLSDDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:941
	Result<cv::Ptr<cv::line_descriptor::LSDDetector>*> cv_line_descriptor_LSDDetector_createLSDDetector() {
		try {
			cv::Ptr<cv::line_descriptor::LSDDetector> ret = cv::line_descriptor::LSDDetector::createLSDDetector();
			return Ok(new cv::Ptr<cv::line_descriptor::LSDDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::line_descriptor::LSDDetector>*>))
	}
	
	// createLSDDetector(cv::line_descriptor::LSDParam) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:944
	Result<cv::Ptr<cv::line_descriptor::LSDDetector>*> cv_line_descriptor_LSDDetector_createLSDDetector_LSDParam(cv::line_descriptor::LSDParam* params) {
		try {
			cv::Ptr<cv::line_descriptor::LSDDetector> ret = cv::line_descriptor::LSDDetector::createLSDDetector(*params);
			return Ok(new cv::Ptr<cv::line_descriptor::LSDDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::line_descriptor::LSDDetector>*>))
	}
	
	// detect(const cv::Mat &, std::vector<KeyLine> &, int, int, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:955
	Result_void cv_line_descriptor_LSDDetector_detect_const_MatR_vector_KeyLine_R_int_int_const_MatR(cv::line_descriptor::LSDDetector* instance, const cv::Mat* image, std::vector<cv::line_descriptor::KeyLine>* keypoints, int scale, int numOctaves, const cv::Mat* mask) {
		try {
			instance->detect(*image, *keypoints, scale, numOctaves, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(const std::vector<Mat> &, std::vector<std::vector<KeyLine>> &, int, int, const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:964
	Result_void cv_line_descriptor_LSDDetector_detect_const_const_vector_Mat_R_vector_vector_KeyLine__R_int_int_const_vector_Mat_R(const cv::line_descriptor::LSDDetector* instance, const std::vector<cv::Mat>* images, std::vector<std::vector<cv::line_descriptor::KeyLine>>* keylines, int scale, int numOctaves, const std::vector<cv::Mat>* masks) {
		try {
			instance->detect(*images, *keylines, scale, numOctaves, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// LSDParam() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/line_descriptor/descriptor.hpp:914
	Result<cv::line_descriptor::LSDParam> cv_line_descriptor_LSDParam_LSDParam() {
		try {
			cv::line_descriptor::LSDParam ret;
			return Ok<cv::line_descriptor::LSDParam>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::line_descriptor::LSDParam>))
	}
	
}
