#include "ocvrs_common.hpp"
#include <opencv2/imgproc.hpp>
#include "imgproc_types.hpp"

extern "C" {
	// Canny(cv::InputArray, cv::InputArray, cv::OutputArray, double, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1809
	Result_void cv_Canny_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_double_bool(const cv::_InputArray* dx, const cv::_InputArray* dy, const cv::_OutputArray* edges, double threshold1, double threshold2, bool L2gradient) {
		try {
			cv::Canny(*dx, *dy, *edges, threshold1, threshold2, L2gradient);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Canny(cv::InputArray, cv::OutputArray, double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1791
	Result_void cv_Canny_const__InputArrayR_const__OutputArrayR_double_double_int_bool(const cv::_InputArray* image, const cv::_OutputArray* edges, double threshold1, double threshold2, int apertureSize, bool L2gradient) {
		try {
			cv::Canny(*image, *edges, threshold1, threshold2, apertureSize, L2gradient);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// EMD(cv::InputArray, cv::InputArray, int, cv::InputArray, float *, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3275
	Result<float> cv_EMD_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_floatX_const__OutputArrayR(const cv::_InputArray* signature1, const cv::_InputArray* signature2, int distType, const cv::_InputArray* cost, float* lowerBound, const cv::_OutputArray* flow) {
		try {
			float ret = cv::EMD(*signature1, *signature2, distType, *cost, lowerBound, *flow);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// GaussianBlur(cv::InputArray, cv::OutputArray, cv::Size, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1464
	Result_void cv_GaussianBlur_const__InputArrayR_const__OutputArrayR_Size_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* ksize, double sigmaX, double sigmaY, int borderType) {
		try {
			cv::GaussianBlur(*src, *dst, *ksize, sigmaX, sigmaY, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HoughCircles(cv::InputArray, cv::OutputArray, int, double, double, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2176
	Result_void cv_HoughCircles_const__InputArrayR_const__OutputArrayR_int_double_double_double_double_int_int(const cv::_InputArray* image, const cv::_OutputArray* circles, int method, double dp, double minDist, double param1, double param2, int minRadius, int maxRadius) {
		try {
			cv::HoughCircles(*image, *circles, method, dp, minDist, param1, param2, minRadius, maxRadius);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HoughLinesP(cv::InputArray, cv::OutputArray, double, double, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2104
	Result_void cv_HoughLinesP_const__InputArrayR_const__OutputArrayR_double_double_int_double_double(const cv::_InputArray* image, const cv::_OutputArray* lines, double rho, double theta, int threshold, double minLineLength, double maxLineGap) {
		try {
			cv::HoughLinesP(*image, *lines, rho, theta, threshold, minLineLength, maxLineGap);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HoughLinesPointSet(cv::InputArray, cv::OutputArray, int, int, double, double, double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2125
	Result_void cv_HoughLinesPointSet_const__InputArrayR_const__OutputArrayR_int_int_double_double_double_double_double_double(const cv::_InputArray* point, const cv::_OutputArray* lines, int lines_max, int threshold, double min_rho, double max_rho, double rho_step, double min_theta, double max_theta, double theta_step) {
		try {
			cv::HoughLinesPointSet(*point, *lines, lines_max, threshold, min_rho, max_rho, rho_step, min_theta, max_theta, theta_step);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HoughLines(cv::InputArray, cv::OutputArray, double, double, int, double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2071
	Result_void cv_HoughLines_const__InputArrayR_const__OutputArrayR_double_double_int_double_double_double_double(const cv::_InputArray* image, const cv::_OutputArray* lines, double rho, double theta, int threshold, double srn, double stn, double min_theta, double max_theta) {
		try {
			cv::HoughLines(*image, *lines, rho, theta, threshold, srn, stn, min_theta, max_theta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HuMoments(const cv::Moments &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3718
	Result_void cv_HuMoments_const_MomentsR_const__OutputArrayR(const cv::Moments* m, const cv::_OutputArray* hu) {
		try {
			cv::HuMoments(*m, *hu);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// HuMoments(const cv::Moments &, double *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3715
	Result_void cv_HuMoments_const_MomentsR_doubleXX(const cv::Moments* moments, double(*hu)[7]) {
		try {
			cv::HuMoments(*moments, *hu);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Laplacian(cv::InputArray, cv::OutputArray, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1759
	Result_void cv_Laplacian_const__InputArrayR_const__OutputArrayR_int_int_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, int ksize, double scale, double delta, int borderType) {
		try {
			cv::Laplacian(*src, *dst, ddepth, ksize, scale, delta, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Scharr(cv::InputArray, cv::OutputArray, int, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1728
	Result_void cv_Scharr_const__InputArrayR_const__OutputArrayR_int_int_int_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, int dx, int dy, double scale, double delta, int borderType) {
		try {
			cv::Scharr(*src, *dst, ddepth, dx, dy, scale, delta, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Sobel(cv::InputArray, cv::OutputArray, int, int, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1678
	Result_void cv_Sobel_const__InputArrayR_const__OutputArrayR_int_int_int_int_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, int dx, int dy, int ksize, double scale, double delta, int borderType) {
		try {
			cv::Sobel(*src, *dst, ddepth, dx, dy, ksize, scale, delta, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// accumulateProduct(cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2853
	Result_void cv_accumulateProduct_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputOutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::accumulateProduct(*src1, *src2, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// accumulateSquare(cv::InputArray, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2834
	Result_void cv_accumulateSquare_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputOutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::accumulateSquare(*src, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// accumulateWeighted(cv::InputArray, cv::InputOutputArray, double, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2874
	Result_void cv_accumulateWeighted_const__InputArrayR_const__InputOutputArrayR_double_const__InputArrayR(const cv::_InputArray* src, const cv::_InputOutputArray* dst, double alpha, const cv::_InputArray* mask) {
		try {
			cv::accumulateWeighted(*src, *dst, alpha, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// accumulate(cv::InputArray, cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2815
	Result_void cv_accumulate_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputOutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::accumulate(*src, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// adaptiveThreshold(cv::InputArray, cv::OutputArray, double, int, int, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3006
	Result_void cv_adaptiveThreshold_const__InputArrayR_const__OutputArrayR_double_int_int_int_double(const cv::_InputArray* src, const cv::_OutputArray* dst, double maxValue, int adaptiveMethod, int thresholdType, int blockSize, double C) {
		try {
			cv::adaptiveThreshold(*src, *dst, maxValue, adaptiveMethod, thresholdType, blockSize, C);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// applyColorMap(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4373
	Result_void cv_applyColorMap_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* userColor) {
		try {
			cv::applyColorMap(*src, *dst, *userColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// applyColorMap(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4365
	Result_void cv_applyColorMap_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int colormap) {
		try {
			cv::applyColorMap(*src, *dst, colormap);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// approxPolyDP(cv::InputArray, cv::OutputArray, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3941
	Result_void cv_approxPolyDP_const__InputArrayR_const__OutputArrayR_double_bool(const cv::_InputArray* curve, const cv::_OutputArray* approxCurve, double epsilon, bool closed) {
		try {
			cv::approxPolyDP(*curve, *approxCurve, epsilon, closed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// arcLength(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3952
	Result<double> cv_arcLength_const__InputArrayR_bool(const cv::_InputArray* curve, bool closed) {
		try {
			double ret = cv::arcLength(*curve, closed);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// arrowedLine(cv::InputOutputArray, cv::Point, cv::Point, const cv::Scalar &, int, int, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4415
	Result_void cv_arrowedLine_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int_double(const cv::_InputOutputArray* img, cv::Point* pt1, cv::Point* pt2, const cv::Scalar* color, int thickness, int line_type, int shift, double tipLength) {
		try {
			cv::arrowedLine(*img, *pt1, *pt2, *color, thickness, line_type, shift, tipLength);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bilateralFilter(cv::InputArray, cv::OutputArray, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1496
	Result_void cv_bilateralFilter_const__InputArrayR_const__OutputArrayR_int_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int d, double sigmaColor, double sigmaSpace, int borderType) {
		try {
			cv::bilateralFilter(*src, *dst, d, sigmaColor, sigmaSpace, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blendLinear(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3571
	Result_void cv_blendLinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputArray* weights1, const cv::_InputArray* weights2, const cv::_OutputArray* dst) {
		try {
			cv::blendLinear(*src1, *src2, *weights1, *weights2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blur(cv::InputArray, cv::OutputArray, cv::Size, cv::Point, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1570
	Result_void cv_blur_const__InputArrayR_const__OutputArrayR_Size_Point_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* ksize, cv::Point* anchor, int borderType) {
		try {
			cv::blur(*src, *dst, *ksize, *anchor, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// boundingRect(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3961
	Result<cv::Rect> cv_boundingRect_const__InputArrayR(const cv::_InputArray* array) {
		try {
			cv::Rect ret = cv::boundingRect(*array);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// boxFilter(cv::InputArray, cv::OutputArray, int, cv::Size, cv::Point, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1524
	Result_void cv_boxFilter_const__InputArrayR_const__OutputArrayR_int_Size_Point_bool_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, cv::Size* ksize, cv::Point* anchor, bool normalize, int borderType) {
		try {
			cv::boxFilter(*src, *dst, ddepth, *ksize, *anchor, normalize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// boxPoints(cv::RotatedRect, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4014
	Result_void cv_boxPoints_RotatedRect_const__OutputArrayR(cv::RotatedRect* box, const cv::_OutputArray* points) {
		try {
			cv::boxPoints(*box, *points);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildPyramid(cv::InputArray, cv::OutputArrayOfArrays, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3072
	Result_void cv_buildPyramid_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int maxlevel, int borderType) {
		try {
			cv::buildPyramid(*src, *dst, maxlevel, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcBackProject(cv::InputArrayOfArrays, const std::vector<int> &, cv::InputArray, cv::OutputArray, const std::vector<float> &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3191
	Result_void cv_calcBackProject_const__InputArrayR_const_vector_int_R_const__InputArrayR_const__OutputArrayR_const_vector_float_R_double(const cv::_InputArray* images, const std::vector<int>* channels, const cv::_InputArray* hist, const cv::_OutputArray* dst, const std::vector<float>* ranges, double scale) {
		try {
			cv::calcBackProject(*images, *channels, *hist, *dst, *ranges, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcHist(cv::InputArrayOfArrays, const std::vector<int> &, cv::InputArray, cv::OutputArray, const std::vector<int> &, const std::vector<float> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3133
	Result_void cv_calcHist_const__InputArrayR_const_vector_int_R_const__InputArrayR_const__OutputArrayR_const_vector_int_R_const_vector_float_R_bool(const cv::_InputArray* images, const std::vector<int>* channels, const cv::_InputArray* mask, const cv::_OutputArray* hist, const std::vector<int>* histSize, const std::vector<float>* ranges, bool accumulate) {
		try {
			cv::calcHist(*images, *channels, *mask, *hist, *histSize, *ranges, accumulate);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// circle(cv::InputOutputArray, cv::Point, int, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4461
	Result_void cv_circle_const__InputOutputArrayR_Point_int_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, cv::Point* center, int radius, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::circle(*img, *center, radius, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clipLine(cv::Rect, cv::Point &, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4670
	Result<bool> cv_clipLine_Rect_PointR_PointR(cv::Rect* imgRect, cv::Point* pt1, cv::Point* pt2) {
		try {
			bool ret = cv::clipLine(*imgRect, *pt1, *pt2);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clipLine(cv::Size2l, cv::Point2l &, cv::Point2l &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4663
	Result<bool> cv_clipLine_Size2l_Point2lR_Point2lR(cv::Size2l* imgSize, cv::Point2l* pt1, cv::Point2l* pt2) {
		try {
			bool ret = cv::clipLine(*imgSize, *pt1, *pt2);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// clipLine(cv::Size, cv::Point &, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4656
	Result<bool> cv_clipLine_Size_PointR_PointR(cv::Size* imgSize, cv::Point* pt1, cv::Point* pt2) {
		try {
			bool ret = cv::clipLine(*imgSize, *pt1, *pt2);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// compareHist(const cv::SparseMat &, const cv::SparseMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3214
	Result<double> cv_compareHist_const_SparseMatR_const_SparseMatR_int(const cv::SparseMat* H1, const cv::SparseMat* H2, int method) {
		try {
			double ret = cv::compareHist(*H1, *H2, method);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// compareHist(cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3211
	Result<double> cv_compareHist_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* H1, const cv::_InputArray* H2, int method) {
		try {
			double ret = cv::compareHist(*H1, *H2, method);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// connectedComponentsWithStats(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3879
	Result<int> cv_connectedComponentsWithStats_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* image, const cv::_OutputArray* labels, const cv::_OutputArray* stats, const cv::_OutputArray* centroids, int connectivity, int ltype) {
		try {
			int ret = cv::connectedComponentsWithStats(*image, *labels, *stats, *centroids, connectivity, ltype);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// connectedComponentsWithStats(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3864
	Result<int> cv_connectedComponentsWithStats_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* image, const cv::_OutputArray* labels, const cv::_OutputArray* stats, const cv::_OutputArray* centroids, int connectivity, int ltype, int ccltype) {
		try {
			int ret = cv::connectedComponentsWithStats(*image, *labels, *stats, *centroids, connectivity, ltype, ccltype);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// connectedComponents(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3838
	Result<int> cv_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* image, const cv::_OutputArray* labels, int connectivity, int ltype) {
		try {
			int ret = cv::connectedComponents(*image, *labels, connectivity, ltype);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// connectedComponents(cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3827
	Result<int> cv_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* image, const cv::_OutputArray* labels, int connectivity, int ltype, int ccltype) {
		try {
			int ret = cv::connectedComponents(*image, *labels, connectivity, ltype, ccltype);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// contourArea(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3993
	Result<double> cv_contourArea_const__InputArrayR_bool(const cv::_InputArray* contour, bool oriented) {
		try {
			double ret = cv::contourArea(*contour, oriented);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// convertMaps(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2453
	Result_void cv_convertMaps_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_bool(const cv::_InputArray* map1, const cv::_InputArray* map2, const cv::_OutputArray* dstmap1, const cv::_OutputArray* dstmap2, int dstmap1type, bool nninterpolation) {
		try {
			cv::convertMaps(*map1, *map2, *dstmap1, *dstmap2, dstmap1type, nninterpolation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convexHull(cv::InputArray, cv::OutputArray, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4094
	Result_void cv_convexHull_const__InputArrayR_const__OutputArrayR_bool_bool(const cv::_InputArray* points, const cv::_OutputArray* hull, bool clockwise, bool returnPoints) {
		try {
			cv::convexHull(*points, *hull, clockwise, returnPoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convexityDefects(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4114
	Result_void cv_convexityDefects_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* contour, const cv::_InputArray* convexhull, const cv::_OutputArray* convexityDefects) {
		try {
			cv::convexityDefects(*contour, *convexhull, *convexityDefects);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cornerEigenValsAndVecs(cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1880
	Result_void cv_cornerEigenValsAndVecs_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int blockSize, int ksize, int borderType) {
		try {
			cv::cornerEigenValsAndVecs(*src, *dst, blockSize, ksize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cornerHarris(cv::InputArray, cv::OutputArray, int, int, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1850
	Result_void cv_cornerHarris_const__InputArrayR_const__OutputArrayR_int_int_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int blockSize, int ksize, double k, int borderType) {
		try {
			cv::cornerHarris(*src, *dst, blockSize, ksize, k, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cornerMinEigenVal(cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1827
	Result_void cv_cornerMinEigenVal_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int blockSize, int ksize, int borderType) {
		try {
			cv::cornerMinEigenVal(*src, *dst, blockSize, ksize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cornerSubPix(cv::InputArray, cv::InputOutputArray, cv::Size, cv::Size, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1950
	Result_void cv_cornerSubPix_const__InputArrayR_const__InputOutputArrayR_Size_Size_TermCriteria(const cv::_InputArray* image, const cv::_InputOutputArray* corners, cv::Size* winSize, cv::Size* zeroZone, cv::TermCriteria* criteria) {
		try {
			cv::cornerSubPix(*image, *corners, *winSize, *zeroZone, *criteria);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createCLAHE(double, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3239
	Result<cv::Ptr<cv::CLAHE>*> cv_createCLAHE_double_Size(double clipLimit, cv::Size* tileGridSize) {
		try {
			cv::Ptr<cv::CLAHE> ret = cv::createCLAHE(clipLimit, *tileGridSize);
			return Ok(new cv::Ptr<cv::CLAHE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::CLAHE>*>))
	}
	
	// createGeneralizedHoughBallard() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4317
	Result<cv::Ptr<cv::GeneralizedHoughBallard>*> cv_createGeneralizedHoughBallard() {
		try {
			cv::Ptr<cv::GeneralizedHoughBallard> ret = cv::createGeneralizedHoughBallard();
			return Ok(new cv::Ptr<cv::GeneralizedHoughBallard>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::GeneralizedHoughBallard>*>))
	}
	
	// createGeneralizedHoughGuil() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4321
	Result<cv::Ptr<cv::GeneralizedHoughGuil>*> cv_createGeneralizedHoughGuil() {
		try {
			cv::Ptr<cv::GeneralizedHoughGuil> ret = cv::createGeneralizedHoughGuil();
			return Ok(new cv::Ptr<cv::GeneralizedHoughGuil>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::GeneralizedHoughGuil>*>))
	}
	
	// createHanningWindow(cv::OutputArray, cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2930
	Result_void cv_createHanningWindow_const__OutputArrayR_Size_int(const cv::_OutputArray* dst, cv::Size* winSize, int type) {
		try {
			cv::createHanningWindow(*dst, *winSize, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createLineSegmentDetector(int, double, double, double, double, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1336
	Result<cv::Ptr<cv::LineSegmentDetector>*> cv_createLineSegmentDetector_int_double_double_double_double_double_double_int(int refine, double scale, double sigma_scale, double quant, double ang_th, double log_eps, double density_th, int n_bins) {
		try {
			cv::Ptr<cv::LineSegmentDetector> ret = cv::createLineSegmentDetector(refine, scale, sigma_scale, quant, ang_th, log_eps, density_th, n_bins);
			return Ok(new cv::Ptr<cv::LineSegmentDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::LineSegmentDetector>*>))
	}
	
	// cvtColorTwoPlane(cv::InputArray, cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3639
	Result_void cv_cvtColorTwoPlane_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int code) {
		try {
			cv::cvtColorTwoPlane(*src1, *src2, *dst, code);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cvtColor(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3619
	Result_void cv_cvtColor_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int code, int dstCn) {
		try {
			cv::cvtColor(*src, *dst, code, dstCn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// demosaicing(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3671
	Result_void cv_demosaicing_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int code, int dstCn) {
		try {
			cv::demosaicing(*src, *dst, code, dstCn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// dilate(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Point, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2246
	Result_void cv_dilate_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* kernel, cv::Point* anchor, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::dilate(*src, *dst, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// distanceTransform(cv::InputArray, cv::OutputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3457
	Result_void cv_distanceTransform_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_OutputArray* labels, int distanceType, int maskSize, int labelType) {
		try {
			cv::distanceTransform(*src, *dst, *labels, distanceType, maskSize, labelType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// distanceTransform(cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3472
	Result_void cv_distanceTransform_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int distanceType, int maskSize, int dstType) {
		try {
			cv::distanceTransform(*src, *dst, distanceType, maskSize, dstType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// divSpectrums(cv::InputArray, cv::InputArray, cv::OutputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2945
	Result_void cv_divSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool(const cv::_InputArray* a, const cv::_InputArray* b, const cv::_OutputArray* c, int flags, bool conjB) {
		try {
			cv::divSpectrums(*a, *b, *c, flags, conjB);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawContours(cv::InputOutputArray, cv::InputArrayOfArrays, int, const cv::Scalar &, int, int, cv::InputArray, int, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4641
	Result_void cv_drawContours_const__InputOutputArrayR_const__InputArrayR_int_const_ScalarR_int_int_const__InputArrayR_int_Point(const cv::_InputOutputArray* image, const cv::_InputArray* contours, int contourIdx, const cv::Scalar* color, int thickness, int lineType, const cv::_InputArray* hierarchy, int maxLevel, cv::Point* offset) {
		try {
			cv::drawContours(*image, *contours, contourIdx, *color, thickness, lineType, *hierarchy, maxLevel, *offset);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawMarker(cv::InputOutputArray, cv::Point, const cv::Scalar &, int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4524
	Result_void cv_drawMarker_const__InputOutputArrayR_Point_const_ScalarR_int_int_int_int(const cv::_InputOutputArray* img, cv::Point* position, const cv::Scalar* color, int markerType, int markerSize, int thickness, int line_type) {
		try {
			cv::drawMarker(*img, *position, *color, markerType, markerSize, thickness, line_type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ellipse2Poly(cv::Point2d, cv::Size2d, int, int, int, int, std::vector<Point2d> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4699
	Result_void cv_ellipse2Poly_Point2d_Size2d_int_int_int_int_vector_Point2d_R(cv::Point2d* center, cv::Size2d* axes, int angle, int arcStart, int arcEnd, int delta, std::vector<cv::Point2d>* pts) {
		try {
			cv::ellipse2Poly(*center, *axes, angle, arcStart, arcEnd, delta, *pts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ellipse2Poly(cv::Point, cv::Size, int, int, int, int, std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4686
	Result_void cv_ellipse2Poly_Point_Size_int_int_int_int_vector_Point_R(cv::Point* center, cv::Size* axes, int angle, int arcStart, int arcEnd, int delta, std::vector<cv::Point>* pts) {
		try {
			cv::ellipse2Poly(*center, *axes, angle, arcStart, arcEnd, delta, *pts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ellipse(cv::InputOutputArray, cv::Point, cv::Size, double, double, double, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4490
	Result_void cv_ellipse_const__InputOutputArrayR_Point_Size_double_double_double_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, cv::Point* center, cv::Size* axes, double angle, double startAngle, double endAngle, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::ellipse(*img, *center, *axes, angle, startAngle, endAngle, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ellipse(cv::InputOutputArray, const cv::RotatedRect &, const cv::Scalar &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4504
	Result_void cv_ellipse_const__InputOutputArrayR_const_RotatedRectR_const_ScalarR_int_int(const cv::_InputOutputArray* img, const cv::RotatedRect* box, const cv::Scalar* color, int thickness, int lineType) {
		try {
			cv::ellipse(*img, *box, *color, thickness, lineType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// equalizeHist(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3231
	Result_void cv_equalizeHist_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::equalizeHist(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erode(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Point, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2214
	Result_void cv_erode_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Point_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* kernel, cv::Point* anchor, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::erode(*src, *dst, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fillConvexPoly(cv::InputOutputArray, cv::InputArray, const cv::Scalar &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4545
	Result_void cv_fillConvexPoly_const__InputOutputArrayR_const__InputArrayR_const_ScalarR_int_int(const cv::_InputOutputArray* img, const cv::_InputArray* points, const cv::Scalar* color, int lineType, int shift) {
		try {
			cv::fillConvexPoly(*img, *points, *color, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fillPoly(cv::InputOutputArray, cv::InputArrayOfArrays, const cv::Scalar &, int, int, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4572
	Result_void cv_fillPoly_const__InputOutputArrayR_const__InputArrayR_const_ScalarR_int_int_Point(const cv::_InputOutputArray* img, const cv::_InputArray* pts, const cv::Scalar* color, int lineType, int shift, cv::Point* offset) {
		try {
			cv::fillPoly(*img, *pts, *color, lineType, shift, *offset);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// filter2D(cv::InputArray, cv::OutputArray, int, cv::InputArray, cv::Point, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1604
	Result_void cv_filter2D_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_Point_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, const cv::_InputArray* kernel, cv::Point* anchor, double delta, int borderType) {
		try {
			cv::filter2D(*src, *dst, ddepth, *kernel, *anchor, delta, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findContours(cv::InputArray, cv::OutputArrayOfArrays, cv::OutputArray, int, int, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3910
	Result_void cv_findContours_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_Point(const cv::_InputArray* image, const cv::_OutputArray* contours, const cv::_OutputArray* hierarchy, int mode, int method, cv::Point* offset) {
		try {
			cv::findContours(*image, *contours, *hierarchy, mode, method, *offset);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findContours(cv::InputArray, cv::OutputArrayOfArrays, int, int, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3915
	Result_void cv_findContours_const__InputArrayR_const__OutputArrayR_int_int_Point(const cv::_InputArray* image, const cv::_OutputArray* contours, int mode, int method, cv::Point* offset) {
		try {
			cv::findContours(*image, *contours, mode, method, *offset);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fitEllipseAMS(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4196
	Result<cv::RotatedRect*> cv_fitEllipseAMS_const__InputArrayR(const cv::_InputArray* points) {
		try {
			cv::RotatedRect ret = cv::fitEllipseAMS(*points);
			return Ok(new cv::RotatedRect(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// fitEllipseDirect(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4241
	Result<cv::RotatedRect*> cv_fitEllipseDirect_const__InputArrayR(const cv::_InputArray* points) {
		try {
			cv::RotatedRect ret = cv::fitEllipseDirect(*points);
			return Ok(new cv::RotatedRect(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// fitEllipse(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4159
	Result<cv::RotatedRect*> cv_fitEllipse_const__InputArrayR(const cv::_InputArray* points) {
		try {
			cv::RotatedRect ret = cv::fitEllipse(*points);
			return Ok(new cv::RotatedRect(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// fitLine(cv::InputArray, cv::OutputArray, int, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4277
	Result_void cv_fitLine_const__InputArrayR_const__OutputArrayR_int_double_double_double(const cv::_InputArray* points, const cv::_OutputArray* line, int distType, double param, double reps, double aeps) {
		try {
			cv::fitLine(*points, *line, distType, param, reps, aeps);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// floodFill(cv::InputOutputArray, cv::Point, cv::Scalar, cv::Rect *, cv::Scalar, cv::Scalar, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3559
	Result<int> cv_floodFill_const__InputOutputArrayR_Point_Scalar_RectX_Scalar_Scalar_int(const cv::_InputOutputArray* image, cv::Point* seedPoint, cv::Scalar* newVal, cv::Rect* rect, cv::Scalar* loDiff, cv::Scalar* upDiff, int flags) {
		try {
			int ret = cv::floodFill(*image, *seedPoint, *newVal, rect, *loDiff, *upDiff, flags);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// floodFill(cv::InputOutputArray, cv::InputOutputArray, cv::Point, cv::Scalar, cv::Rect *, cv::Scalar, cv::Scalar, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3546
	Result<int> cv_floodFill_const__InputOutputArrayR_const__InputOutputArrayR_Point_Scalar_RectX_Scalar_Scalar_int(const cv::_InputOutputArray* image, const cv::_InputOutputArray* mask, cv::Point* seedPoint, cv::Scalar* newVal, cv::Rect* rect, cv::Scalar* loDiff, cv::Scalar* upDiff, int flags) {
		try {
			int ret = cv::floodFill(*image, *mask, *seedPoint, *newVal, rect, *loDiff, *upDiff, flags);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getAffineTransform(const cv::Point2f *, const cv::Point2f *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2502
	Result<cv::Mat*> cv_getAffineTransform_const_Point2fX_const_Point2fX(const cv::Point2f* src, const cv::Point2f* dst) {
		try {
			cv::Mat ret = cv::getAffineTransform(src, dst);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getAffineTransform(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2539
	Result<cv::Mat*> cv_getAffineTransform_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputArray* dst) {
		try {
			cv::Mat ret = cv::getAffineTransform(*src, *dst);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getDerivKernels(cv::OutputArray, cv::OutputArray, int, int, int, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1384
	Result_void cv_getDerivKernels_const__OutputArrayR_const__OutputArrayR_int_int_int_bool_int(const cv::_OutputArray* kx, const cv::_OutputArray* ky, int dx, int dy, int ksize, bool normalize, int ktype) {
		try {
			cv::getDerivKernels(*kx, *ky, dx, dy, ksize, normalize, ktype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFontScaleFromHeight(const int, const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4784
	Result<double> cv_getFontScaleFromHeight_const_int_const_int_const_int(const int fontFace, const int pixelHeight, const int thickness) {
		try {
			double ret = cv::getFontScaleFromHeight(fontFace, pixelHeight, thickness);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getGaborKernel(cv::Size, double, double, double, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1401
	Result<cv::Mat*> cv_getGaborKernel_Size_double_double_double_double_double_int(cv::Size* ksize, double sigma, double theta, double lambd, double gamma, double psi, int ktype) {
		try {
			cv::Mat ret = cv::getGaborKernel(*ksize, sigma, theta, lambd, gamma, psi, ktype);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getGaussianKernel(int, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1364
	Result<cv::Mat*> cv_getGaussianKernel_int_double_int(int ksize, double sigma, int ktype) {
		try {
			cv::Mat ret = cv::getGaussianKernel(ksize, sigma, ktype);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getPerspectiveTransform(const cv::Point2f *, const cv::Point2f *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2536
	Result<cv::Mat*> cv_getPerspectiveTransform_const_Point2fX_const_Point2fX_int(const cv::Point2f* src, const cv::Point2f* dst, int solveMethod) {
		try {
			cv::Mat ret = cv::getPerspectiveTransform(src, dst, solveMethod);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getPerspectiveTransform(cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2533
	Result<cv::Mat*> cv_getPerspectiveTransform_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* src, const cv::_InputArray* dst, int solveMethod) {
		try {
			cv::Mat ret = cv::getPerspectiveTransform(*src, *dst, solveMethod);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getRectSubPix(cv::InputArray, cv::Size, cv::Point2f, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2561
	Result_void cv_getRectSubPix_const__InputArrayR_Size_Point2f_const__OutputArrayR_int(const cv::_InputArray* image, cv::Size* patchSize, cv::Point2f* center, const cv::_OutputArray* patch, int patchType) {
		try {
			cv::getRectSubPix(*image, *patchSize, *center, *patch, patchType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRotationMatrix2D(cv::Point2f, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2476
	Result<cv::Mat*> cv_getRotationMatrix2D_Point2f_double_double(cv::Point2f* center, double angle, double scale) {
		try {
			cv::Mat ret = cv::getRotationMatrix2D(*center, angle, scale);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	#if !defined(OCVRS_TARGET_OS_WINDOWS)
	// getRotationMatrix2D_(cv::Point2f, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2479
	Result<cv::Matx23d> cv_getRotationMatrix2D__Point2f_double_double(cv::Point2f* center, double angle, double scale) {
		try {
			cv::Matx23d ret = cv::getRotationMatrix2D_(*center, angle, scale);
			return Ok<cv::Matx23d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx23d>))
	}
	#endif
	
	// getStructuringElement(int, cv::Size, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1420
	Result<cv::Mat*> cv_getStructuringElement_int_Size_Point(int shape, cv::Size* ksize, cv::Point* anchor) {
		try {
			cv::Mat ret = cv::getStructuringElement(shape, *ksize, *anchor);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getTextSize(const cv::String &, int, double, int, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4770
	Result<cv::Size> cv_getTextSize_const_StringR_int_double_int_intX(const char* text, int fontFace, double fontScale, int thickness, int* baseLine) {
		try {
			cv::Size ret = cv::getTextSize(std::string(text), fontFace, fontScale, thickness, baseLine);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// goodFeaturesToTrack(cv::InputArray, cv::OutputArray, int, double, double, cv::InputArray, cv::OutputArray, int, int, bool, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2034
	Result_void cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_const__OutputArrayR_int_int_bool_double(const cv::_InputArray* image, const cv::_OutputArray* corners, int maxCorners, double qualityLevel, double minDistance, const cv::_InputArray* mask, const cv::_OutputArray* cornersQuality, int blockSize, int gradientSize, bool useHarrisDetector, double k) {
		try {
			cv::goodFeaturesToTrack(*image, *corners, maxCorners, qualityLevel, minDistance, *mask, *cornersQuality, blockSize, gradientSize, useHarrisDetector, k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// goodFeaturesToTrack(cv::InputArray, cv::OutputArray, int, double, double, cv::InputArray, int, bool, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1998
	Result_void cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_int_bool_double(const cv::_InputArray* image, const cv::_OutputArray* corners, int maxCorners, double qualityLevel, double minDistance, const cv::_InputArray* mask, int blockSize, bool useHarrisDetector, double k) {
		try {
			cv::goodFeaturesToTrack(*image, *corners, maxCorners, qualityLevel, minDistance, *mask, blockSize, useHarrisDetector, k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// goodFeaturesToTrack(cv::InputArray, cv::OutputArray, int, double, double, cv::InputArray, int, int, bool, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2003
	Result_void cv_goodFeaturesToTrack_const__InputArrayR_const__OutputArrayR_int_double_double_const__InputArrayR_int_int_bool_double(const cv::_InputArray* image, const cv::_OutputArray* corners, int maxCorners, double qualityLevel, double minDistance, const cv::_InputArray* mask, int blockSize, int gradientSize, bool useHarrisDetector, double k) {
		try {
			cv::goodFeaturesToTrack(*image, *corners, maxCorners, qualityLevel, minDistance, *mask, blockSize, gradientSize, useHarrisDetector, k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// grabCut(cv::InputArray, cv::InputOutputArray, cv::Rect, cv::InputOutputArray, cv::InputOutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3391
	Result_void cv_grabCut_const__InputArrayR_const__InputOutputArrayR_Rect_const__InputOutputArrayR_const__InputOutputArrayR_int_int(const cv::_InputArray* img, const cv::_InputOutputArray* mask, cv::Rect* rect, const cv::_InputOutputArray* bgdModel, const cv::_InputOutputArray* fgdModel, int iterCount, int mode) {
		try {
			cv::grabCut(*img, *mask, *rect, *bgdModel, *fgdModel, iterCount, mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// integral(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2782
	Result_void cv_integral_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* sum, const cv::_OutputArray* sqsum, const cv::_OutputArray* tilted, int sdepth, int sqdepth) {
		try {
			cv::integral(*src, *sum, *sqsum, *tilted, sdepth, sqdepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// integral(cv::InputArray, cv::OutputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2790
	Result_void cv_integral_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* sum, const cv::_OutputArray* sqsum, int sdepth, int sqdepth) {
		try {
			cv::integral(*src, *sum, *sqsum, sdepth, sqdepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// integral(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2787
	Result_void cv_integral_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* sum, int sdepth) {
		try {
			cv::integral(*src, *sum, sdepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// intersectConvexConvex(cv::InputArray, cv::InputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4142
	Result<float> cv_intersectConvexConvex_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(const cv::_InputArray* p1, const cv::_InputArray* p2, const cv::_OutputArray* p12, bool handleNested) {
		try {
			float ret = cv::intersectConvexConvex(*p1, *p2, *p12, handleNested);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// invertAffineTransform(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2515
	Result_void cv_invertAffineTransform_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* M, const cv::_OutputArray* iM) {
		try {
			cv::invertAffineTransform(*M, *iM);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isContourConvex(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4123
	Result<bool> cv_isContourConvex_const__InputArrayR(const cv::_InputArray* contour) {
		try {
			bool ret = cv::isContourConvex(*contour);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// line(cv::InputOutputArray, cv::Point, cv::Point, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4399
	Result_void cv_line_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, cv::Point* pt1, cv::Point* pt2, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::line(*img, *pt1, *pt2, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// linearPolar(cv::InputArray, cv::OutputArray, cv::Point2f, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2648
	Result_void cv_linearPolar_const__InputArrayR_const__OutputArrayR_Point2f_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Point2f* center, double maxRadius, int flags) {
		try {
			cv::linearPolar(*src, *dst, *center, maxRadius, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// logPolar(cv::InputArray, cv::OutputArray, cv::Point2f, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2607
	Result_void cv_logPolar_const__InputArrayR_const__OutputArrayR_Point2f_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Point2f* center, double M, int flags) {
		try {
			cv::logPolar(*src, *dst, *center, M, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matchShapes(cv::InputArray, cv::InputArray, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4060
	Result<double> cv_matchShapes_const__InputArrayR_const__InputArrayR_int_double(const cv::_InputArray* contour1, const cv::_InputArray* contour2, int method, double parameter) {
		try {
			double ret = cv::matchShapes(*contour1, *contour2, method, parameter);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// matchTemplate(cv::InputArray, cv::InputArray, cv::OutputArray, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3798
	Result_void cv_matchTemplate_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR(const cv::_InputArray* image, const cv::_InputArray* templ, const cv::_OutputArray* result, int method, const cv::_InputArray* mask) {
		try {
			cv::matchTemplate(*image, *templ, *result, method, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// medianBlur(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1442
	Result_void cv_medianBlur_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ksize) {
		try {
			cv::medianBlur(*src, *dst, ksize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minAreaRect(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4003
	Result<cv::RotatedRect*> cv_minAreaRect_const__InputArrayR(const cv::_InputArray* points) {
		try {
			cv::RotatedRect ret = cv::minAreaRect(*points);
			return Ok(new cv::RotatedRect(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// minEnclosingCircle(cv::InputArray, cv::Point2f &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4024
	Result_void cv_minEnclosingCircle_const__InputArrayR_Point2fR_floatR(const cv::_InputArray* points, cv::Point2f* center, float* radius) {
		try {
			cv::minEnclosingCircle(*points, *center, *radius);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minEnclosingTriangle(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4049
	Result<double> cv_minEnclosingTriangle_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* points, const cv::_OutputArray* triangle) {
		try {
			double ret = cv::minEnclosingTriangle(*points, *triangle);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// moments(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3694
	Result<cv::Moments> cv_moments_const__InputArrayR_bool(const cv::_InputArray* array, bool binaryImage) {
		try {
			cv::Moments ret = cv::moments(*array, binaryImage);
			return Ok<cv::Moments>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Moments>))
	}
	
	// morphologyDefaultBorderValue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1405
	Result<cv::Scalar> cv_morphologyDefaultBorderValue() {
		try {
			cv::Scalar ret = cv::morphologyDefaultBorderValue();
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// morphologyEx(cv::InputArray, cv::OutputArray, int, cv::InputArray, cv::Point, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2275
	Result_void cv_morphologyEx_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_Point_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, int op, const cv::_InputArray* kernel, cv::Point* anchor, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::morphologyEx(*src, *dst, op, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// phaseCorrelate(cv::InputArray, cv::InputArray, cv::InputArray, double *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2912
	Result<cv::Point2d> cv_phaseCorrelate_const__InputArrayR_const__InputArrayR_const__InputArrayR_doubleX(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputArray* window, double* response) {
		try {
			cv::Point2d ret = cv::phaseCorrelate(*src1, *src2, *window, response);
			return Ok<cv::Point2d>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2d>))
	}
	
	// pointPolygonTest(cv::InputArray, cv::Point2f, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4296
	Result<double> cv_pointPolygonTest_const__InputArrayR_Point2f_bool(const cv::_InputArray* contour, cv::Point2f* pt, bool measureDist) {
		try {
			double ret = cv::pointPolygonTest(*contour, *pt, measureDist);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// polylines(cv::InputOutputArray, cv::InputArrayOfArrays, bool, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4595
	Result_void cv_polylines_const__InputOutputArrayR_const__InputArrayR_bool_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, const cv::_InputArray* pts, bool isClosed, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::polylines(*img, *pts, isClosed, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// preCornerDetect(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1907
	Result_void cv_preCornerDetect_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ksize, int borderType) {
		try {
			cv::preCornerDetect(*src, *dst, ksize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// putText(cv::InputOutputArray, const cv::String &, cv::Point, int, double, cv::Scalar, int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4720
	Result_void cv_putText_const__InputOutputArrayR_const_StringR_Point_int_double_Scalar_int_int_bool(const cv::_InputOutputArray* img, const char* text, cv::Point* org, int fontFace, double fontScale, cv::Scalar* color, int thickness, int lineType, bool bottomLeftOrigin) {
		try {
			cv::putText(*img, std::string(text), *org, fontFace, fontScale, *color, thickness, lineType, bottomLeftOrigin);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyrDown(cv::InputArray, cv::OutputArray, const cv::Size &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3038
	Result_void cv_pyrDown_const__InputArrayR_const__OutputArrayR_const_SizeR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::Size* dstsize, int borderType) {
		try {
			cv::pyrDown(*src, *dst, *dstsize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyrMeanShiftFiltering(cv::InputArray, cv::OutputArray, double, double, int, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3359
	Result_void cv_pyrMeanShiftFiltering_const__InputArrayR_const__OutputArrayR_double_double_int_TermCriteria(const cv::_InputArray* src, const cv::_OutputArray* dst, double sp, double sr, int maxLevel, cv::TermCriteria* termcrit) {
		try {
			cv::pyrMeanShiftFiltering(*src, *dst, sp, sr, maxLevel, *termcrit);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyrUp(cv::InputArray, cv::OutputArray, const cv::Size &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3058
	Result_void cv_pyrUp_const__InputArrayR_const__OutputArrayR_const_SizeR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::Size* dstsize, int borderType) {
		try {
			cv::pyrUp(*src, *dst, *dstsize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rectangle(cv::InputOutputArray, cv::Point, cv::Point, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4432
	Result_void cv_rectangle_const__InputOutputArrayR_Point_Point_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, cv::Point* pt1, cv::Point* pt2, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::rectangle(*img, *pt1, *pt2, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rectangle(cv::InputOutputArray, cv::Rect, const cv::Scalar &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4441
	Result_void cv_rectangle_const__InputOutputArrayR_Rect_const_ScalarR_int_int_int(const cv::_InputOutputArray* img, cv::Rect* rec, const cv::Scalar* color, int thickness, int lineType, int shift) {
		try {
			cv::rectangle(*img, *rec, *color, thickness, lineType, shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// remap(cv::InputArray, cv::OutputArray, cv::InputArray, cv::InputArray, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2418
	Result_void cv_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* map1, const cv::_InputArray* map2, int interpolation, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::remap(*src, *dst, *map1, *map2, interpolation, borderMode, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resize(cv::InputArray, cv::OutputArray, cv::Size, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2320
	Result_void cv_resize_const__InputArrayR_const__OutputArrayR_Size_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* dsize, double fx, double fy, int interpolation) {
		try {
			cv::resize(*src, *dst, *dsize, fx, fy, interpolation);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rotatedRectangleIntersection(const cv::RotatedRect &, const cv::RotatedRect &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4313
	Result<int> cv_rotatedRectangleIntersection_const_RotatedRectR_const_RotatedRectR_const__OutputArrayR(const cv::RotatedRect* rect1, const cv::RotatedRect* rect2, const cv::_OutputArray* intersectingRegion) {
		try {
			int ret = cv::rotatedRectangleIntersection(*rect1, *rect2, *intersectingRegion);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// sepFilter2D(cv::InputArray, cv::OutputArray, int, cv::InputArray, cv::InputArray, cv::Point, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1625
	Result_void cv_sepFilter2D_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_const__InputArrayR_Point_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, const cv::_InputArray* kernelX, const cv::_InputArray* kernelY, cv::Point* anchor, double delta, int borderType) {
		try {
			cv::sepFilter2D(*src, *dst, ddepth, *kernelX, *kernelY, *anchor, delta, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// spatialGradient(cv::InputArray, cv::OutputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1702
	Result_void cv_spatialGradient_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dx, const cv::_OutputArray* dy, int ksize, int borderType) {
		try {
			cv::spatialGradient(*src, *dx, *dy, ksize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sqrBoxFilter(cv::InputArray, cv::OutputArray, int, cv::Size, cv::Point, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1547
	Result_void cv_sqrBoxFilter_const__InputArrayR_const__OutputArrayR_int_Size_Point_bool_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int ddepth, cv::Size* ksize, cv::Point* anchor, bool normalize, int borderType) {
		try {
			cv::sqrBoxFilter(*src, *dst, ddepth, *ksize, *anchor, normalize, borderType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// threshold(cv::InputArray, cv::OutputArray, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2977
	Result<double> cv_threshold_const__InputArrayR_const__OutputArrayR_double_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, double thresh, double maxval, int type) {
		try {
			double ret = cv::threshold(*src, *dst, thresh, maxval, type);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// warpAffine(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Size, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2348
	Result_void cv_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* M, cv::Size* dsize, int flags, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::warpAffine(*src, *dst, *M, *dsize, flags, borderMode, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPerspective(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Size, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2380
	Result_void cv_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* M, cv::Size* dsize, int flags, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::warpPerspective(*src, *dst, *M, *dsize, flags, borderMode, *borderValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPolar(cv::InputArray, cv::OutputArray, cv::Size, cv::Point2f, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:2739
	Result_void cv_warpPolar_const__InputArrayR_const__OutputArrayR_Size_Point2f_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* dsize, cv::Point2f* center, double maxRadius, int flags) {
		try {
			cv::warpPolar(*src, *dst, *dsize, *center, maxRadius, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// watershed(cv::InputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3316
	Result_void cv_watershed_const__InputArrayR_const__InputOutputArrayR(const cv::_InputArray* image, const cv::_InputOutputArray* markers) {
		try {
			cv::watershed(*image, *markers);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// wrapperEMD(cv::InputArray, cv::InputArray, int, cv::InputArray, Ptr<float>, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:3279
	Result<float> cv_wrapperEMD_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_Ptr_float__const__OutputArrayR(const cv::_InputArray* signature1, const cv::_InputArray* signature2, int distType, const cv::_InputArray* cost, cv::Ptr<float>* lowerBound, const cv::_OutputArray* flow) {
		try {
			float ret = cv::wrapperEMD(*signature1, *signature2, distType, *cost, *lowerBound, *flow);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// apply(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:969
	Result_void cv_CLAHE_apply_const__InputArrayR_const__OutputArrayR(cv::CLAHE* instance, const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			instance->apply(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setClipLimit(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:975
	Result_void cv_CLAHE_setClipLimit_double(cv::CLAHE* instance, double clipLimit) {
		try {
			instance->setClipLimit(clipLimit);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getClipLimit() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:978
	Result<double> cv_CLAHE_getClipLimit_const(const cv::CLAHE* instance) {
		try {
			double ret = instance->getClipLimit();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setTilesGridSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:985
	Result_void cv_CLAHE_setTilesGridSize_Size(cv::CLAHE* instance, cv::Size* tileGridSize) {
		try {
			instance->setTilesGridSize(*tileGridSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTilesGridSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:988
	Result<cv::Size> cv_CLAHE_getTilesGridSize_const(const cv::CLAHE* instance) {
		try {
			cv::Size ret = instance->getTilesGridSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// collectGarbage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:990
	Result_void cv_CLAHE_collectGarbage(cv::CLAHE* instance) {
		try {
			instance->collectGarbage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTemplate(cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:854
	Result_void cv_GeneralizedHough_setTemplate_const__InputArrayR_Point(cv::GeneralizedHough* instance, const cv::_InputArray* templ, cv::Point* templCenter) {
		try {
			instance->setTemplate(*templ, *templCenter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTemplate(cv::InputArray, cv::InputArray, cv::InputArray, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:855
	Result_void cv_GeneralizedHough_setTemplate_const__InputArrayR_const__InputArrayR_const__InputArrayR_Point(cv::GeneralizedHough* instance, const cv::_InputArray* edges, const cv::_InputArray* dx, const cv::_InputArray* dy, cv::Point* templCenter) {
		try {
			instance->setTemplate(*edges, *dx, *dy, *templCenter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:858
	Result_void cv_GeneralizedHough_detect_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::GeneralizedHough* instance, const cv::_InputArray* image, const cv::_OutputArray* positions, const cv::_OutputArray* votes) {
		try {
			instance->detect(*image, *positions, *votes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:859
	Result_void cv_GeneralizedHough_detect_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::GeneralizedHough* instance, const cv::_InputArray* edges, const cv::_InputArray* dx, const cv::_InputArray* dy, const cv::_OutputArray* positions, const cv::_OutputArray* votes) {
		try {
			instance->detect(*edges, *dx, *dy, *positions, *votes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setCannyLowThresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:862
	Result_void cv_GeneralizedHough_setCannyLowThresh_int(cv::GeneralizedHough* instance, int cannyLowThresh) {
		try {
			instance->setCannyLowThresh(cannyLowThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCannyLowThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:863
	Result<int> cv_GeneralizedHough_getCannyLowThresh_const(const cv::GeneralizedHough* instance) {
		try {
			int ret = instance->getCannyLowThresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setCannyHighThresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:866
	Result_void cv_GeneralizedHough_setCannyHighThresh_int(cv::GeneralizedHough* instance, int cannyHighThresh) {
		try {
			instance->setCannyHighThresh(cannyHighThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCannyHighThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:867
	Result<int> cv_GeneralizedHough_getCannyHighThresh_const(const cv::GeneralizedHough* instance) {
		try {
			int ret = instance->getCannyHighThresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinDist(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:870
	Result_void cv_GeneralizedHough_setMinDist_double(cv::GeneralizedHough* instance, double minDist) {
		try {
			instance->setMinDist(minDist);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinDist() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:871
	Result<double> cv_GeneralizedHough_getMinDist_const(const cv::GeneralizedHough* instance) {
		try {
			double ret = instance->getMinDist();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setDp(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:874
	Result_void cv_GeneralizedHough_setDp_double(cv::GeneralizedHough* instance, double dp) {
		try {
			instance->setDp(dp);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:875
	Result<double> cv_GeneralizedHough_getDp_const(const cv::GeneralizedHough* instance) {
		try {
			double ret = instance->getDp();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxBufferSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:878
	Result_void cv_GeneralizedHough_setMaxBufferSize_int(cv::GeneralizedHough* instance, int maxBufferSize) {
		try {
			instance->setMaxBufferSize(maxBufferSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxBufferSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:879
	Result<int> cv_GeneralizedHough_getMaxBufferSize_const(const cv::GeneralizedHough* instance) {
		try {
			int ret = instance->getMaxBufferSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:890
	Result_void cv_GeneralizedHoughBallard_setLevels_int(cv::GeneralizedHoughBallard* instance, int levels) {
		try {
			instance->setLevels(levels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:891
	Result<int> cv_GeneralizedHoughBallard_getLevels_const(const cv::GeneralizedHoughBallard* instance) {
		try {
			int ret = instance->getLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setVotesThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:894
	Result_void cv_GeneralizedHoughBallard_setVotesThreshold_int(cv::GeneralizedHoughBallard* instance, int votesThreshold) {
		try {
			instance->setVotesThreshold(votesThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVotesThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:895
	Result<int> cv_GeneralizedHoughBallard_getVotesThreshold_const(const cv::GeneralizedHoughBallard* instance) {
		try {
			int ret = instance->getVotesThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setXi(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:906
	Result_void cv_GeneralizedHoughGuil_setXi_double(cv::GeneralizedHoughGuil* instance, double xi) {
		try {
			instance->setXi(xi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getXi() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:907
	Result<double> cv_GeneralizedHoughGuil_getXi_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getXi();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:910
	Result_void cv_GeneralizedHoughGuil_setLevels_int(cv::GeneralizedHoughGuil* instance, int levels) {
		try {
			instance->setLevels(levels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:911
	Result<int> cv_GeneralizedHoughGuil_getLevels_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			int ret = instance->getLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setAngleEpsilon(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:914
	Result_void cv_GeneralizedHoughGuil_setAngleEpsilon_double(cv::GeneralizedHoughGuil* instance, double angleEpsilon) {
		try {
			instance->setAngleEpsilon(angleEpsilon);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAngleEpsilon() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:915
	Result<double> cv_GeneralizedHoughGuil_getAngleEpsilon_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getAngleEpsilon();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinAngle(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:918
	Result_void cv_GeneralizedHoughGuil_setMinAngle_double(cv::GeneralizedHoughGuil* instance, double minAngle) {
		try {
			instance->setMinAngle(minAngle);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinAngle() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:919
	Result<double> cv_GeneralizedHoughGuil_getMinAngle_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getMinAngle();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxAngle(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:922
	Result_void cv_GeneralizedHoughGuil_setMaxAngle_double(cv::GeneralizedHoughGuil* instance, double maxAngle) {
		try {
			instance->setMaxAngle(maxAngle);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxAngle() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:923
	Result<double> cv_GeneralizedHoughGuil_getMaxAngle_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getMaxAngle();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAngleStep(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:926
	Result_void cv_GeneralizedHoughGuil_setAngleStep_double(cv::GeneralizedHoughGuil* instance, double angleStep) {
		try {
			instance->setAngleStep(angleStep);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAngleStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:927
	Result<double> cv_GeneralizedHoughGuil_getAngleStep_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getAngleStep();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setAngleThresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:930
	Result_void cv_GeneralizedHoughGuil_setAngleThresh_int(cv::GeneralizedHoughGuil* instance, int angleThresh) {
		try {
			instance->setAngleThresh(angleThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAngleThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:931
	Result<int> cv_GeneralizedHoughGuil_getAngleThresh_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			int ret = instance->getAngleThresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:934
	Result_void cv_GeneralizedHoughGuil_setMinScale_double(cv::GeneralizedHoughGuil* instance, double minScale) {
		try {
			instance->setMinScale(minScale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:935
	Result<double> cv_GeneralizedHoughGuil_getMinScale_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getMinScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:938
	Result_void cv_GeneralizedHoughGuil_setMaxScale_double(cv::GeneralizedHoughGuil* instance, double maxScale) {
		try {
			instance->setMaxScale(maxScale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:939
	Result<double> cv_GeneralizedHoughGuil_getMaxScale_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getMaxScale();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setScaleStep(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:942
	Result_void cv_GeneralizedHoughGuil_setScaleStep_double(cv::GeneralizedHoughGuil* instance, double scaleStep) {
		try {
			instance->setScaleStep(scaleStep);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:943
	Result<double> cv_GeneralizedHoughGuil_getScaleStep_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			double ret = instance->getScaleStep();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setScaleThresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:946
	Result_void cv_GeneralizedHoughGuil_setScaleThresh_int(cv::GeneralizedHoughGuil* instance, int scaleThresh) {
		try {
			instance->setScaleThresh(scaleThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:947
	Result<int> cv_GeneralizedHoughGuil_getScaleThresh_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			int ret = instance->getScaleThresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPosThresh(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:950
	Result_void cv_GeneralizedHoughGuil_setPosThresh_int(cv::GeneralizedHoughGuil* instance, int posThresh) {
		try {
			instance->setPosThresh(posThresh);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPosThresh() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:951
	Result<int> cv_GeneralizedHoughGuil_getPosThresh_const(const cv::GeneralizedHoughGuil* instance) {
		try {
			int ret = instance->getPosThresh();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// ptr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4876
	unsigned char* cv_LineIterator_getPropPtr(cv::LineIterator* instance) {
		unsigned char* ret = instance->ptr;
		return (unsigned char*)ret;
	}
	
	// ptr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4876
	void cv_LineIterator_setPropPtr_unsigned_charX(cv::LineIterator* instance, unsigned char* val) {
		instance->ptr = val;
	}
	
	// ptr0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4877
	const unsigned char* cv_LineIterator_getPropPtr0_const(const cv::LineIterator* instance) {
		const unsigned char* ret = instance->ptr0;
		return (const unsigned char*)ret;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4878
	int cv_LineIterator_getPropStep_const(const cv::LineIterator* instance) {
		int ret = instance->step;
		return (int)ret;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4878
	void cv_LineIterator_setPropStep_int(cv::LineIterator* instance, int val) {
		instance->step = val;
	}
	
	// elemSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4878
	int cv_LineIterator_getPropElemSize_const(const cv::LineIterator* instance) {
		int ret = instance->elemSize;
		return (int)ret;
	}
	
	// elemSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4878
	void cv_LineIterator_setPropElemSize_int(cv::LineIterator* instance, int val) {
		instance->elemSize = val;
	}
	
	// err /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4879
	int cv_LineIterator_getPropErr_const(const cv::LineIterator* instance) {
		int ret = instance->err;
		return (int)ret;
	}
	
	// err /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4879
	void cv_LineIterator_setPropErr_int(cv::LineIterator* instance, int val) {
		instance->err = val;
	}
	
	// count /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4879
	int cv_LineIterator_getPropCount_const(const cv::LineIterator* instance) {
		int ret = instance->count;
		return (int)ret;
	}
	
	// count /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4879
	void cv_LineIterator_setPropCount_int(cv::LineIterator* instance, int val) {
		instance->count = val;
	}
	
	// minusDelta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4880
	int cv_LineIterator_getPropMinusDelta_const(const cv::LineIterator* instance) {
		int ret = instance->minusDelta;
		return (int)ret;
	}
	
	// minusDelta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4880
	void cv_LineIterator_setPropMinusDelta_int(cv::LineIterator* instance, int val) {
		instance->minusDelta = val;
	}
	
	// plusDelta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4880
	int cv_LineIterator_getPropPlusDelta_const(const cv::LineIterator* instance) {
		int ret = instance->plusDelta;
		return (int)ret;
	}
	
	// plusDelta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4880
	void cv_LineIterator_setPropPlusDelta_int(cv::LineIterator* instance, int val) {
		instance->plusDelta = val;
	}
	
	// minusStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4881
	int cv_LineIterator_getPropMinusStep_const(const cv::LineIterator* instance) {
		int ret = instance->minusStep;
		return (int)ret;
	}
	
	// minusStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4881
	void cv_LineIterator_setPropMinusStep_int(cv::LineIterator* instance, int val) {
		instance->minusStep = val;
	}
	
	// plusStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4881
	int cv_LineIterator_getPropPlusStep_const(const cv::LineIterator* instance) {
		int ret = instance->plusStep;
		return (int)ret;
	}
	
	// plusStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4881
	void cv_LineIterator_setPropPlusStep_int(cv::LineIterator* instance, int val) {
		instance->plusStep = val;
	}
	
	// minusShift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4882
	int cv_LineIterator_getPropMinusShift_const(const cv::LineIterator* instance) {
		int ret = instance->minusShift;
		return (int)ret;
	}
	
	// minusShift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4882
	void cv_LineIterator_setPropMinusShift_int(cv::LineIterator* instance, int val) {
		instance->minusShift = val;
	}
	
	// plusShift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4882
	int cv_LineIterator_getPropPlusShift_const(const cv::LineIterator* instance) {
		int ret = instance->plusShift;
		return (int)ret;
	}
	
	// plusShift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4882
	void cv_LineIterator_setPropPlusShift_int(cv::LineIterator* instance, int val) {
		instance->plusShift = val;
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4883
	cv::Point cv_LineIterator_getPropP_const(const cv::LineIterator* instance) {
		cv::Point ret = instance->p;
		return (cv::Point)ret;
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4883
	void cv_LineIterator_setPropP_Point(cv::LineIterator* instance, cv::Point* val) {
		instance->p = *val;
	}
	
	// ptmode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4884
	bool cv_LineIterator_getPropPtmode_const(const cv::LineIterator* instance) {
		bool ret = instance->ptmode;
		return (bool)ret;
	}
	
	// ptmode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4884
	void cv_LineIterator_setPropPtmode_bool(cv::LineIterator* instance, bool val) {
		instance->ptmode = val;
	}
	
	void cv_LineIterator_delete(cv::LineIterator* instance) {
		delete instance;
	}
	// LineIterator(const cv::Mat &, cv::Point, cv::Point, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4832
	Result<cv::LineIterator*> cv_LineIterator_LineIterator_const_MatR_Point_Point_int_bool(const cv::Mat* img, cv::Point* pt1, cv::Point* pt2, int connectivity, bool leftToRight) {
		try {
			cv::LineIterator* ret = new cv::LineIterator(*img, *pt1, *pt2, connectivity, leftToRight);
			return Ok<cv::LineIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LineIterator*>))
	}
	
	// LineIterator(cv::Point, cv::Point, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4838
	Result<cv::LineIterator*> cv_LineIterator_LineIterator_Point_Point_int_bool(cv::Point* pt1, cv::Point* pt2, int connectivity, bool leftToRight) {
		try {
			cv::LineIterator* ret = new cv::LineIterator(*pt1, *pt2, connectivity, leftToRight);
			return Ok<cv::LineIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LineIterator*>))
	}
	
	// LineIterator(cv::Size, cv::Point, cv::Point, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4848
	Result<cv::LineIterator*> cv_LineIterator_LineIterator_Size_Point_Point_int_bool(cv::Size* boundingAreaSize, cv::Point* pt1, cv::Point* pt2, int connectivity, bool leftToRight) {
		try {
			cv::LineIterator* ret = new cv::LineIterator(*boundingAreaSize, *pt1, *pt2, connectivity, leftToRight);
			return Ok<cv::LineIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LineIterator*>))
	}
	
	// LineIterator(cv::Rect, cv::Point, cv::Point, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4855
	Result<cv::LineIterator*> cv_LineIterator_LineIterator_Rect_Point_Point_int_bool(cv::Rect* boundingAreaRect, cv::Point* pt1, cv::Point* pt2, int connectivity, bool leftToRight) {
		try {
			cv::LineIterator* ret = new cv::LineIterator(*boundingAreaRect, *pt1, *pt2, connectivity, leftToRight);
			return Ok<cv::LineIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LineIterator*>))
	}
	
	// init(const cv::Mat *, cv::Rect, cv::Point, cv::Point, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4861
	Result_void cv_LineIterator_init_const_MatX_Rect_Point_Point_int_bool(cv::LineIterator* instance, const cv::Mat* img, cv::Rect* boundingAreaRect, cv::Point* pt1, cv::Point* pt2, int connectivity, bool leftToRight) {
		try {
			instance->init(img, *boundingAreaRect, *pt1, *pt2, connectivity, leftToRight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// operator*() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4865
	Result<unsigned char*> cv_LineIterator_operatorX(cv::LineIterator* instance) {
		try {
			unsigned char* ret = instance->operator*();
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// pos() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:4874
	Result<cv::Point> cv_LineIterator_pos_const(const cv::LineIterator* instance) {
		try {
			cv::Point ret = instance->pos();
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// detect(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1298
	Result_void cv_LineSegmentDetector_detect_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(cv::LineSegmentDetector* instance, const cv::_InputArray* image, const cv::_OutputArray* lines, const cv::_OutputArray* width, const cv::_OutputArray* prec, const cv::_OutputArray* nfa) {
		try {
			instance->detect(*image, *lines, *width, *prec, *nfa);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawSegments(cv::InputOutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1307
	Result_void cv_LineSegmentDetector_drawSegments_const__InputOutputArrayR_const__InputArrayR(cv::LineSegmentDetector* instance, const cv::_InputOutputArray* image, const cv::_InputArray* lines) {
		try {
			instance->drawSegments(*image, *lines);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compareSegments(const cv::Size &, cv::InputArray, cv::InputArray, cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1317
	Result<int> cv_LineSegmentDetector_compareSegments_const_SizeR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(cv::LineSegmentDetector* instance, const cv::Size* size, const cv::_InputArray* lines1, const cv::_InputArray* lines2, const cv::_InputOutputArray* image) {
		try {
			int ret = instance->compareSegments(*size, *lines1, *lines2, *image);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_Subdiv2D_delete(cv::Subdiv2D* instance) {
		delete instance;
	}
	// Subdiv2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1023
	Result<cv::Subdiv2D*> cv_Subdiv2D_Subdiv2D() {
		try {
			cv::Subdiv2D* ret = new cv::Subdiv2D();
			return Ok<cv::Subdiv2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Subdiv2D*>))
	}
	
	// Subdiv2D(cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1033
	Result<cv::Subdiv2D*> cv_Subdiv2D_Subdiv2D_Rect(cv::Rect* rect) {
		try {
			cv::Subdiv2D* ret = new cv::Subdiv2D(*rect);
			return Ok<cv::Subdiv2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Subdiv2D*>))
	}
	
	// initDelaunay(cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1040
	Result_void cv_Subdiv2D_initDelaunay_Rect(cv::Subdiv2D* instance, cv::Rect* rect) {
		try {
			instance->initDelaunay(*rect);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// insert(cv::Point2f) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1052
	Result<int> cv_Subdiv2D_insert_Point2f(cv::Subdiv2D* instance, cv::Point2f* pt) {
		try {
			int ret = instance->insert(*pt);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// insert(const std::vector<Point2f> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1061
	Result_void cv_Subdiv2D_insert_const_vector_Point2f_R(cv::Subdiv2D* instance, const std::vector<cv::Point2f>* ptvec) {
		try {
			instance->insert(*ptvec);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// locate(cv::Point2f, int &, int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1083
	Result<int> cv_Subdiv2D_locate_Point2f_intR_intR(cv::Subdiv2D* instance, cv::Point2f* pt, int* edge, int* vertex) {
		try {
			int ret = instance->locate(*pt, *edge, *vertex);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// findNearest(cv::Point2f, cv::Point2f *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1097
	Result<int> cv_Subdiv2D_findNearest_Point2f_Point2fX(cv::Subdiv2D* instance, cv::Point2f* pt, cv::Point2f* nearestPt) {
		try {
			int ret = instance->findNearest(*pt, nearestPt);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getEdgeList(std::vector<Vec4f> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1106
	Result_void cv_Subdiv2D_getEdgeList_const_vector_Vec4f_R(const cv::Subdiv2D* instance, std::vector<cv::Vec4f>* edgeList) {
		try {
			instance->getEdgeList(*edgeList);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLeadingEdgeList(std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1114
	Result_void cv_Subdiv2D_getLeadingEdgeList_const_vector_int_R(const cv::Subdiv2D* instance, std::vector<int>* leadingEdgeList) {
		try {
			instance->getLeadingEdgeList(*leadingEdgeList);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTriangleList(std::vector<Vec6f> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1123
	Result_void cv_Subdiv2D_getTriangleList_const_vector_Vec6f_R(const cv::Subdiv2D* instance, std::vector<cv::Vec6f>* triangleList) {
		try {
			instance->getTriangleList(*triangleList);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVoronoiFacetList(const std::vector<int> &, std::vector<std::vector<Point2f>> &, std::vector<Point2f> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1132
	Result_void cv_Subdiv2D_getVoronoiFacetList_const_vector_int_R_vector_vector_Point2f__R_vector_Point2f_R(cv::Subdiv2D* instance, const std::vector<int>* idx, std::vector<std::vector<cv::Point2f>>* facetList, std::vector<cv::Point2f>* facetCenters) {
		try {
			instance->getVoronoiFacetList(*idx, *facetList, *facetCenters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVertex(int, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1142
	Result<cv::Point2f> cv_Subdiv2D_getVertex_const_int_intX(const cv::Subdiv2D* instance, int vertex, int* firstEdge) {
		try {
			cv::Point2f ret = instance->getVertex(vertex, firstEdge);
			return Ok<cv::Point2f>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point2f>))
	}
	
	// getEdge(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1162
	Result<int> cv_Subdiv2D_getEdge_const_int_int(const cv::Subdiv2D* instance, int edge, int nextEdgeType) {
		try {
			int ret = instance->getEdge(edge, nextEdgeType);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nextEdge(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1171
	Result<int> cv_Subdiv2D_nextEdge_const_int(const cv::Subdiv2D* instance, int edge) {
		try {
			int ret = instance->nextEdge(edge);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// rotateEdge(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1185
	Result<int> cv_Subdiv2D_rotateEdge_const_int_int(const cv::Subdiv2D* instance, int edge, int rotate) {
		try {
			int ret = instance->rotateEdge(edge, rotate);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// symEdge(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1186
	Result<int> cv_Subdiv2D_symEdge_const_int(const cv::Subdiv2D* instance, int edge) {
		try {
			int ret = instance->symEdge(edge);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// edgeOrg(int, cv::Point2f *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1195
	Result<int> cv_Subdiv2D_edgeOrg_const_int_Point2fX(const cv::Subdiv2D* instance, int edge, cv::Point2f* orgpt) {
		try {
			int ret = instance->edgeOrg(edge, orgpt);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// edgeDst(int, cv::Point2f *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc.hpp:1204
	Result<int> cv_Subdiv2D_edgeDst_const_int_Point2fX(const cv::Subdiv2D* instance, int edge, cv::Point2f* dstpt) {
		try {
			int ret = instance->edgeDst(edge, dstpt);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_IntelligentScissorsMB_delete(cv::segmentation::IntelligentScissorsMB* instance) {
		delete instance;
	}
	// IntelligentScissorsMB() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:34
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_IntelligentScissorsMB() {
		try {
			cv::segmentation::IntelligentScissorsMB* ret = new cv::segmentation::IntelligentScissorsMB();
			return Ok<cv::segmentation::IntelligentScissorsMB*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// setWeights(float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:46
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_setWeights_float_float_float(cv::segmentation::IntelligentScissorsMB* instance, float weight_non_edge, float weight_gradient_direction, float weight_gradient_magnitude) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->setWeights(weight_non_edge, weight_gradient_direction, weight_gradient_magnitude);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// setGradientMagnitudeMaxLimit(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:58
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_setGradientMagnitudeMaxLimit_float(cv::segmentation::IntelligentScissorsMB* instance, float gradient_magnitude_threshold_max) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->setGradientMagnitudeMaxLimit(gradient_magnitude_threshold_max);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// setEdgeFeatureZeroCrossingParameters(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:74
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_setEdgeFeatureZeroCrossingParameters_float(cv::segmentation::IntelligentScissorsMB* instance, float gradient_magnitude_min_value) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->setEdgeFeatureZeroCrossingParameters(gradient_magnitude_min_value);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// setEdgeFeatureCannyParameters(double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:83
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_setEdgeFeatureCannyParameters_double_double_int_bool(cv::segmentation::IntelligentScissorsMB* instance, double threshold1, double threshold2, int apertureSize, bool L2gradient) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->setEdgeFeatureCannyParameters(threshold1, threshold2, apertureSize, L2gradient);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// applyImage(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:93
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_applyImage_const__InputArrayR(cv::segmentation::IntelligentScissorsMB* instance, const cv::_InputArray* image) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->applyImage(*image);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// applyImageFeatures(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:105
	Result<cv::segmentation::IntelligentScissorsMB*> cv_segmentation_IntelligentScissorsMB_applyImageFeatures_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(cv::segmentation::IntelligentScissorsMB* instance, const cv::_InputArray* non_edge, const cv::_InputArray* gradient_direction, const cv::_InputArray* gradient_magnitude, const cv::_InputArray* image) {
		try {
			cv::segmentation::IntelligentScissorsMB ret = instance->applyImageFeatures(*non_edge, *gradient_direction, *gradient_magnitude, *image);
			return Ok(new cv::segmentation::IntelligentScissorsMB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::segmentation::IntelligentScissorsMB*>))
	}
	
	// buildMap(const cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:116
	Result_void cv_segmentation_IntelligentScissorsMB_buildMap_const_PointR(cv::segmentation::IntelligentScissorsMB* instance, const cv::Point* sourcePt) {
		try {
			instance->buildMap(*sourcePt);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getContour(const cv::Point &, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgproc/segmentation.hpp:126
	Result_void cv_segmentation_IntelligentScissorsMB_getContour_const_const_PointR_const__OutputArrayR_bool(const cv::segmentation::IntelligentScissorsMB* instance, const cv::Point* targetPt, const cv::_OutputArray* contour, bool backward) {
		try {
			instance->getContour(*targetPt, *contour, backward);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
