#include "ocvrs_common.hpp"
#include <opencv2/imgcodecs.hpp>
#include "imgcodecs_types.hpp"

extern "C" {
	// haveImageReader(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:317
	Result<bool> cv_haveImageReader_const_StringR(const char* filename) {
		try {
			bool ret = cv::haveImageReader(std::string(filename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// haveImageWriter(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:323
	Result<bool> cv_haveImageWriter_const_StringR(const char* filename) {
		try {
			bool ret = cv::haveImageWriter(std::string(filename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imcount(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:236
	Result<size_t> cv_imcount_const_StringR_int(const char* filename, int flags) {
		try {
			size_t ret = cv::imcount(std::string(filename), flags);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// imdecode(cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:289
	Result<cv::Mat*> cv_imdecode_const__InputArrayR_int(const cv::_InputArray* buf, int flags) {
		try {
			cv::Mat ret = cv::imdecode(*buf, flags);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// imdecode(cv::InputArray, int, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:297
	Result<cv::Mat*> cv_imdecode_const__InputArrayR_int_MatX(const cv::_InputArray* buf, int flags, cv::Mat* dst) {
		try {
			cv::Mat ret = cv::imdecode(*buf, flags, dst);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// imencode(const cv::String &, cv::InputArray, std::vector<uchar> &, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:309
	Result<bool> cv_imencode_const_StringR_const__InputArrayR_vector_unsigned_char_R_const_vector_int_R(const char* ext, const cv::_InputArray* img, std::vector<unsigned char>* buf, const std::vector<int>* params) {
		try {
			bool ret = cv::imencode(std::string(ext), *img, *buf, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imread(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:206
	Result<cv::Mat*> cv_imread_const_StringR_int(const char* filename, int flags) {
		try {
			cv::Mat ret = cv::imread(std::string(filename), flags);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// imreadmulti(const cv::String &, std::vector<Mat> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:216
	Result<bool> cv_imreadmulti_const_StringR_vector_Mat_R_int(const char* filename, std::vector<cv::Mat>* mats, int flags) {
		try {
			bool ret = cv::imreadmulti(std::string(filename), *mats, flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imreadmulti(const cv::String &, std::vector<Mat> &, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:228
	Result<bool> cv_imreadmulti_const_StringR_vector_Mat_R_int_int_int(const char* filename, std::vector<cv::Mat>* mats, int start, int count, int flags) {
		try {
			bool ret = cv::imreadmulti(std::string(filename), *mats, start, count, flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imwrite(const cv::String &, cv::InputArray, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:267
	Result<bool> cv_imwrite_const_StringR_const__InputArrayR_const_vector_int_R(const char* filename, const cv::_InputArray* img, const std::vector<int>* params) {
		try {
			bool ret = cv::imwrite(std::string(filename), *img, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imwritemulti(const cv::String &, cv::InputArrayOfArrays, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/imgcodecs.hpp:272
	Result<bool> cv_imwritemulti_const_StringR_const__InputArrayR_const_vector_int_R(const char* filename, const cv::_InputArray* img, const std::vector<int>* params) {
		try {
			bool ret = cv::imwritemulti(std::string(filename), *img, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
}
