#include "ocvrs_common.hpp"
#include <opencv2/img_hash.hpp>
#include "img_hash_types.hpp"

extern "C" {
	// averageHash(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/average_hash.hpp:33
	Result_void cv_img_hash_averageHash_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr) {
		try {
			cv::img_hash::averageHash(*inputArr, *outputArr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blockMeanHash(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/block_mean_hash.hpp:44
	Result_void cv_img_hash_blockMeanHash_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr, int mode) {
		try {
			cv::img_hash::blockMeanHash(*inputArr, *outputArr, mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// colorMomentHash(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/color_moment_hash.hpp:35
	Result_void cv_img_hash_colorMomentHash_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr) {
		try {
			cv::img_hash::colorMomentHash(*inputArr, *outputArr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// marrHildrethHash(cv::InputArray, cv::OutputArray, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/marr_hildreth_hash.hpp:56
	Result_void cv_img_hash_marrHildrethHash_const__InputArrayR_const__OutputArrayR_float_float(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr, float alpha, float scale) {
		try {
			cv::img_hash::marrHildrethHash(*inputArr, *outputArr, alpha, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pHash(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/phash.hpp:35
	Result_void cv_img_hash_pHash_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr) {
		try {
			cv::img_hash::pHash(*inputArr, *outputArr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radialVarianceHash(cv::InputArray, cv::OutputArray, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:48
	Result_void cv_img_hash_radialVarianceHash_const__InputArrayR_const__OutputArrayR_double_int(const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr, double sigma, int numOfAngleLine) {
		try {
			cv::img_hash::radialVarianceHash(*inputArr, *outputArr, sigma, numOfAngleLine);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_AverageHash_to_Algorithm(cv::img_hash::AverageHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_AverageHash_to_ImgHashBase(cv::img_hash::AverageHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_AverageHash_delete(cv::img_hash::AverageHash* instance) {
		delete instance;
	}
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/average_hash.hpp:24
	Result<cv::Ptr<cv::img_hash::AverageHash>*> cv_img_hash_AverageHash_create() {
		try {
			cv::Ptr<cv::img_hash::AverageHash> ret = cv::img_hash::AverageHash::create();
			return Ok(new cv::Ptr<cv::img_hash::AverageHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::AverageHash>*>))
	}
	
	cv::Algorithm* cv_BlockMeanHash_to_Algorithm(cv::img_hash::BlockMeanHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_BlockMeanHash_to_ImgHashBase(cv::img_hash::BlockMeanHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_BlockMeanHash_delete(cv::img_hash::BlockMeanHash* instance) {
		delete instance;
	}
	// setMode(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/block_mean_hash.hpp:32
	Result_void cv_img_hash_BlockMeanHash_setMode_int(cv::img_hash::BlockMeanHash* instance, int mode) {
		try {
			instance->setMode(mode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMean() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/block_mean_hash.hpp:33
	Result<std::vector<double>*> cv_img_hash_BlockMeanHash_getMean_const(const cv::img_hash::BlockMeanHash* instance) {
		try {
			std::vector<double> ret = instance->getMean();
			return Ok(new std::vector<double>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<double>*>))
	}
	
	// create(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/block_mean_hash.hpp:34
	Result<cv::Ptr<cv::img_hash::BlockMeanHash>*> cv_img_hash_BlockMeanHash_create_int(int mode) {
		try {
			cv::Ptr<cv::img_hash::BlockMeanHash> ret = cv::img_hash::BlockMeanHash::create(mode);
			return Ok(new cv::Ptr<cv::img_hash::BlockMeanHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::BlockMeanHash>*>))
	}
	
	cv::Algorithm* cv_ColorMomentHash_to_Algorithm(cv::img_hash::ColorMomentHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_ColorMomentHash_to_ImgHashBase(cv::img_hash::ColorMomentHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_ColorMomentHash_delete(cv::img_hash::ColorMomentHash* instance) {
		delete instance;
	}
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/color_moment_hash.hpp:23
	Result<cv::Ptr<cv::img_hash::ColorMomentHash>*> cv_img_hash_ColorMomentHash_create() {
		try {
			cv::Ptr<cv::img_hash::ColorMomentHash> ret = cv::img_hash::ColorMomentHash::create();
			return Ok(new cv::Ptr<cv::img_hash::ColorMomentHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::ColorMomentHash>*>))
	}
	
	cv::Algorithm* cv_ImgHashBase_to_Algorithm(cv::img_hash::ImgHashBase* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_ImgHashBase_delete(cv::img_hash::ImgHashBase* instance) {
		delete instance;
	}
	// compute(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/img_hash_base.hpp:28
	Result_void cv_img_hash_ImgHashBase_compute_const__InputArrayR_const__OutputArrayR(cv::img_hash::ImgHashBase* instance, const cv::_InputArray* inputArr, const cv::_OutputArray* outputArr) {
		try {
			instance->compute(*inputArr, *outputArr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compare(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/img_hash_base.hpp:35
	Result<double> cv_img_hash_ImgHashBase_compare_const_const__InputArrayR_const__InputArrayR(const cv::img_hash::ImgHashBase* instance, const cv::_InputArray* hashOne, const cv::_InputArray* hashTwo) {
		try {
			double ret = instance->compare(*hashOne, *hashTwo);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	cv::Algorithm* cv_MarrHildrethHash_to_Algorithm(cv::img_hash::MarrHildrethHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_MarrHildrethHash_to_ImgHashBase(cv::img_hash::MarrHildrethHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_MarrHildrethHash_delete(cv::img_hash::MarrHildrethHash* instance) {
		delete instance;
	}
	// getAlpha() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/marr_hildreth_hash.hpp:26
	Result<float> cv_img_hash_MarrHildrethHash_getAlpha_const(const cv::img_hash::MarrHildrethHash* instance) {
		try {
			float ret = instance->getAlpha();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getScale() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/marr_hildreth_hash.hpp:31
	Result<float> cv_img_hash_MarrHildrethHash_getScale_const(const cv::img_hash::MarrHildrethHash* instance) {
		try {
			float ret = instance->getScale();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setKernelParam(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/marr_hildreth_hash.hpp:37
	Result_void cv_img_hash_MarrHildrethHash_setKernelParam_float_float(cv::img_hash::MarrHildrethHash* instance, float alpha, float scale) {
		try {
			instance->setKernelParam(alpha, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/marr_hildreth_hash.hpp:43
	Result<cv::Ptr<cv::img_hash::MarrHildrethHash>*> cv_img_hash_MarrHildrethHash_create_float_float(float alpha, float scale) {
		try {
			cv::Ptr<cv::img_hash::MarrHildrethHash> ret = cv::img_hash::MarrHildrethHash::create(alpha, scale);
			return Ok(new cv::Ptr<cv::img_hash::MarrHildrethHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::MarrHildrethHash>*>))
	}
	
	cv::Algorithm* cv_PHash_to_Algorithm(cv::img_hash::PHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_PHash_to_ImgHashBase(cv::img_hash::PHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_PHash_delete(cv::img_hash::PHash* instance) {
		delete instance;
	}
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/phash.hpp:25
	Result<cv::Ptr<cv::img_hash::PHash>*> cv_img_hash_PHash_create() {
		try {
			cv::Ptr<cv::img_hash::PHash> ret = cv::img_hash::PHash::create();
			return Ok(new cv::Ptr<cv::img_hash::PHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::PHash>*>))
	}
	
	cv::Algorithm* cv_RadialVarianceHash_to_Algorithm(cv::img_hash::RadialVarianceHash* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::img_hash::ImgHashBase* cv_RadialVarianceHash_to_ImgHashBase(cv::img_hash::RadialVarianceHash* instance) {
		return dynamic_cast<cv::img_hash::ImgHashBase*>(instance);
	}
	
	void cv_RadialVarianceHash_delete(cv::img_hash::RadialVarianceHash* instance) {
		delete instance;
	}
	// create(double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:24
	Result<cv::Ptr<cv::img_hash::RadialVarianceHash>*> cv_img_hash_RadialVarianceHash_create_double_int(double sigma, int numOfAngleLine) {
		try {
			cv::Ptr<cv::img_hash::RadialVarianceHash> ret = cv::img_hash::RadialVarianceHash::create(sigma, numOfAngleLine);
			return Ok(new cv::Ptr<cv::img_hash::RadialVarianceHash>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::img_hash::RadialVarianceHash>*>))
	}
	
	// getNumOfAngleLine() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:26
	Result<int> cv_img_hash_RadialVarianceHash_getNumOfAngleLine_const(const cv::img_hash::RadialVarianceHash* instance) {
		try {
			int ret = instance->getNumOfAngleLine();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:27
	Result<double> cv_img_hash_RadialVarianceHash_getSigma_const(const cv::img_hash::RadialVarianceHash* instance) {
		try {
			double ret = instance->getSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNumOfAngleLine(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:29
	Result_void cv_img_hash_RadialVarianceHash_setNumOfAngleLine_int(cv::img_hash::RadialVarianceHash* instance, int value) {
		try {
			instance->setNumOfAngleLine(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:30
	Result_void cv_img_hash_RadialVarianceHash_setSigma_double(cv::img_hash::RadialVarianceHash* instance, double value) {
		try {
			instance->setSigma(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFeatures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:33
	Result<std::vector<double>*> cv_img_hash_RadialVarianceHash_getFeatures(cv::img_hash::RadialVarianceHash* instance) {
		try {
			std::vector<double> ret = instance->getFeatures();
			return Ok(new std::vector<double>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<double>*>))
	}
	
	// getHash() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:34
	Result<cv::Mat*> cv_img_hash_RadialVarianceHash_getHash(cv::img_hash::RadialVarianceHash* instance) {
		try {
			cv::Mat ret = instance->getHash();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getPixPerLine(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:35
	Result<cv::Mat*> cv_img_hash_RadialVarianceHash_getPixPerLine_const_MatR(cv::img_hash::RadialVarianceHash* instance, const cv::Mat* input) {
		try {
			cv::Mat ret = instance->getPixPerLine(*input);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getProjection() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/img_hash/radial_variance_hash.hpp:36
	Result<cv::Mat*> cv_img_hash_RadialVarianceHash_getProjection(cv::img_hash::RadialVarianceHash* instance) {
		try {
			cv::Mat ret = instance->getProjection();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
}
